package timeseriesinsights

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"github.com/gofrs/uuid"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/timeseriesinsights/mgmt/2017-02-28-preview/timeseriesinsights"

// AccessPolicyCreateOrUpdateParameters ...
type AccessPolicyCreateOrUpdateParameters struct {
	*AccessPolicyResourceProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for AccessPolicyCreateOrUpdateParameters.
func (apcoup AccessPolicyCreateOrUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if apcoup.AccessPolicyResourceProperties != nil {
		objectMap["properties"] = apcoup.AccessPolicyResourceProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AccessPolicyCreateOrUpdateParameters struct.
func (apcoup *AccessPolicyCreateOrUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var accessPolicyResourceProperties AccessPolicyResourceProperties
				err = json.Unmarshal(*v, &accessPolicyResourceProperties)
				if err != nil {
					return err
				}
				apcoup.AccessPolicyResourceProperties = &accessPolicyResourceProperties
			}
		}
	}

	return nil
}

// AccessPolicyListResponse the response of the List access policies operation.
type AccessPolicyListResponse struct {
	autorest.Response `json:"-"`
	// Value - Result of the List access policies operation.
	Value *[]AccessPolicyResource `json:"value,omitempty"`
}

// AccessPolicyMutableProperties an object that represents a set of mutable access policy resource
// properties.
type AccessPolicyMutableProperties struct {
	// Description - An description of the access policy.
	Description *string `json:"description,omitempty"`
	// Roles - The list of roles the principal is assigned on the environment.
	Roles *[]AccessPolicyRole `json:"roles,omitempty"`
}

// AccessPolicyResource an access policy is used to grant users and applications access to the environment.
// Roles are assigned to service principals in Azure Active Directory. These roles define the actions the
// principal can perform through the Time Series Insights data plane APIs.
type AccessPolicyResource struct {
	autorest.Response               `json:"-"`
	*AccessPolicyResourceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AccessPolicyResource.
func (apr AccessPolicyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if apr.AccessPolicyResourceProperties != nil {
		objectMap["properties"] = apr.AccessPolicyResourceProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AccessPolicyResource struct.
func (apr *AccessPolicyResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var accessPolicyResourceProperties AccessPolicyResourceProperties
				err = json.Unmarshal(*v, &accessPolicyResourceProperties)
				if err != nil {
					return err
				}
				apr.AccessPolicyResourceProperties = &accessPolicyResourceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				apr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				apr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				apr.Type = &typeVar
			}
		}
	}

	return nil
}

// AccessPolicyResourceProperties ...
type AccessPolicyResourceProperties struct {
	// PrincipalObjectID - The objectId of the principal in Azure Active Directory.
	PrincipalObjectID *string `json:"principalObjectId,omitempty"`
	// Description - An description of the access policy.
	Description *string `json:"description,omitempty"`
	// Roles - The list of roles the principal is assigned on the environment.
	Roles *[]AccessPolicyRole `json:"roles,omitempty"`
}

// AccessPolicyUpdateParameters ...
type AccessPolicyUpdateParameters struct {
	*AccessPolicyMutableProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for AccessPolicyUpdateParameters.
func (apup AccessPolicyUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if apup.AccessPolicyMutableProperties != nil {
		objectMap["properties"] = apup.AccessPolicyMutableProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AccessPolicyUpdateParameters struct.
func (apup *AccessPolicyUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var accessPolicyMutableProperties AccessPolicyMutableProperties
				err = json.Unmarshal(*v, &accessPolicyMutableProperties)
				if err != nil {
					return err
				}
				apup.AccessPolicyMutableProperties = &accessPolicyMutableProperties
			}
		}
	}

	return nil
}

// AzureEventSourceProperties properties of an event source that reads events from an event broker in
// Azure.
type AzureEventSourceProperties struct {
	// EventSourceResourceID - The resource id of the event source in Azure Resource Manager.
	EventSourceResourceID *string `json:"eventSourceResourceId,omitempty"`
	// TimestampPropertyName - The event property that will be used as the event source's timestamp. If a value isn't specified for timestampPropertyName, or if null or empty-string is specified, the event creation time will be used.
	TimestampPropertyName *string `json:"timestampPropertyName,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning state of the resource. Possible values include: 'Accepted', 'Creating', 'Updating', 'Succeeded', 'Failed', 'Deleting'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// CreationTime - READ-ONLY; The time the resource was created.
	CreationTime *date.Time `json:"creationTime,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureEventSourceProperties.
func (aesp AzureEventSourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if aesp.EventSourceResourceID != nil {
		objectMap["eventSourceResourceId"] = aesp.EventSourceResourceID
	}
	if aesp.TimestampPropertyName != nil {
		objectMap["timestampPropertyName"] = aesp.TimestampPropertyName
	}
	return json.Marshal(objectMap)
}

// CloudError contains information about an API error.
type CloudError struct {
	Error *CloudErrorBody `json:"error,omitempty"`
}

// CloudErrorBody describes a particular API error with an error code and a message.
type CloudErrorBody struct {
	// Code - An error code that describes the error condition more precisely than an HTTP status code. Can be used to programmatically handle specific error cases.
	Code *string `json:"code,omitempty"`
	// Message - A message that describes the error in detail and provides debugging information.
	Message *string `json:"message,omitempty"`
	// Target - The target of the particular error (for example, the name of the property in error).
	Target *string `json:"target,omitempty"`
	// Details - Contains nested errors that are related to this error.
	Details *[]CloudErrorBody `json:"details,omitempty"`
}

// CreateOrUpdateTrackedResourceProperties properties required to create any resource tracked by Azure
// Resource Manager.
type CreateOrUpdateTrackedResourceProperties struct {
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - Key-value pairs of additional properties for the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for CreateOrUpdateTrackedResourceProperties.
func (coutrp CreateOrUpdateTrackedResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if coutrp.Location != nil {
		objectMap["location"] = coutrp.Location
	}
	if coutrp.Tags != nil {
		objectMap["tags"] = coutrp.Tags
	}
	return json.Marshal(objectMap)
}

// EnvironmentCreateOrUpdateParameters parameters supplied to the CreateOrUpdate Environment operation.
type EnvironmentCreateOrUpdateParameters struct {
	Sku                            *Sku `json:"sku,omitempty"`
	*EnvironmentCreationProperties `json:"properties,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - Key-value pairs of additional properties for the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for EnvironmentCreateOrUpdateParameters.
func (ecoup EnvironmentCreateOrUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ecoup.Sku != nil {
		objectMap["sku"] = ecoup.Sku
	}
	if ecoup.EnvironmentCreationProperties != nil {
		objectMap["properties"] = ecoup.EnvironmentCreationProperties
	}
	if ecoup.Location != nil {
		objectMap["location"] = ecoup.Location
	}
	if ecoup.Tags != nil {
		objectMap["tags"] = ecoup.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for EnvironmentCreateOrUpdateParameters struct.
func (ecoup *EnvironmentCreateOrUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				ecoup.Sku = &sku
			}
		case "properties":
			if v != nil {
				var environmentCreationProperties EnvironmentCreationProperties
				err = json.Unmarshal(*v, &environmentCreationProperties)
				if err != nil {
					return err
				}
				ecoup.EnvironmentCreationProperties = &environmentCreationProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ecoup.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ecoup.Tags = tags
			}
		}
	}

	return nil
}

// EnvironmentCreationProperties properties used to create an environment.
type EnvironmentCreationProperties struct {
	// DataRetentionTime - ISO8601 timespan specifying the minimum number of days the environment's events will be available for query.
	DataRetentionTime *string `json:"dataRetentionTime,omitempty"`
	// StorageLimitExceededBehavior - The behavior the Time Series Insights service should take when the environment's capacity has been exceeded. If "PauseIngress" is specified, new events will not be read from the event source. If "PurgeOldData" is specified, new events will continue to be read and old events will be deleted from the environment. The default behavior is PurgeOldData. Possible values include: 'PurgeOldData', 'PauseIngress'
	StorageLimitExceededBehavior StorageLimitExceededBehavior `json:"storageLimitExceededBehavior,omitempty"`
}

// EnvironmentListResponse the response of the List Environments operation.
type EnvironmentListResponse struct {
	autorest.Response `json:"-"`
	// Value - Result of the List Environments operation.
	Value *[]EnvironmentResource `json:"value,omitempty"`
}

// EnvironmentMutableProperties an object that represents a set of mutable environment resource properties.
type EnvironmentMutableProperties struct {
	// DataRetentionTime - ISO8601 timespan specifying the minimum number of days the environment's events will be available for query.
	DataRetentionTime *string `json:"dataRetentionTime,omitempty"`
}

// EnvironmentResource an environment is a set of time-series data available for query, and is the top
// level Azure Time Series Insights resource.
type EnvironmentResource struct {
	autorest.Response              `json:"-"`
	Sku                            *Sku `json:"sku,omitempty"`
	*EnvironmentResourceProperties `json:"properties,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for EnvironmentResource.
func (er EnvironmentResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if er.Sku != nil {
		objectMap["sku"] = er.Sku
	}
	if er.EnvironmentResourceProperties != nil {
		objectMap["properties"] = er.EnvironmentResourceProperties
	}
	if er.Location != nil {
		objectMap["location"] = er.Location
	}
	if er.Tags != nil {
		objectMap["tags"] = er.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for EnvironmentResource struct.
func (er *EnvironmentResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				er.Sku = &sku
			}
		case "properties":
			if v != nil {
				var environmentResourceProperties EnvironmentResourceProperties
				err = json.Unmarshal(*v, &environmentResourceProperties)
				if err != nil {
					return err
				}
				er.EnvironmentResourceProperties = &environmentResourceProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				er.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				er.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				er.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				er.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				er.Type = &typeVar
			}
		}
	}

	return nil
}

// EnvironmentResourceProperties properties of the environment.
type EnvironmentResourceProperties struct {
	// DataRetentionTime - ISO8601 timespan specifying the minimum number of days the environment's events will be available for query.
	DataRetentionTime *string `json:"dataRetentionTime,omitempty"`
	// StorageLimitExceededBehavior - The behavior the Time Series Insights service should take when the environment's capacity has been exceeded. If "PauseIngress" is specified, new events will not be read from the event source. If "PurgeOldData" is specified, new events will continue to be read and old events will be deleted from the environment. The default behavior is PurgeOldData. Possible values include: 'PurgeOldData', 'PauseIngress'
	StorageLimitExceededBehavior StorageLimitExceededBehavior `json:"storageLimitExceededBehavior,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning state of the resource. Possible values include: 'Accepted', 'Creating', 'Updating', 'Succeeded', 'Failed', 'Deleting'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// CreationTime - READ-ONLY; The time the resource was created.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// DataAccessID - READ-ONLY; An id used to access the environment data, e.g. to query the environment's events or upload reference data for the environment.
	DataAccessID *uuid.UUID `json:"dataAccessId,omitempty"`
	// DataAccessFqdn - READ-ONLY; The fully qualified domain name used to access the environment data, e.g. to query the environment's events or upload reference data for the environment.
	DataAccessFqdn *string `json:"dataAccessFqdn,omitempty"`
}

// MarshalJSON is the custom marshaler for EnvironmentResourceProperties.
func (erp EnvironmentResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if erp.DataRetentionTime != nil {
		objectMap["dataRetentionTime"] = erp.DataRetentionTime
	}
	if erp.StorageLimitExceededBehavior != "" {
		objectMap["storageLimitExceededBehavior"] = erp.StorageLimitExceededBehavior
	}
	return json.Marshal(objectMap)
}

// EnvironmentsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type EnvironmentsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(EnvironmentsClient) (EnvironmentResource, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *EnvironmentsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for EnvironmentsCreateOrUpdateFuture.Result.
func (future *EnvironmentsCreateOrUpdateFuture) result(client EnvironmentsClient) (er EnvironmentResource, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "timeseriesinsights.EnvironmentsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("timeseriesinsights.EnvironmentsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if er.Response.Response, err = future.GetResult(sender); err == nil && er.Response.Response.StatusCode != http.StatusNoContent {
		er, err = client.CreateOrUpdateResponder(er.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "timeseriesinsights.EnvironmentsCreateOrUpdateFuture", "Result", er.Response.Response, "Failure responding to request")
		}
	}
	return
}

// EnvironmentsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type EnvironmentsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(EnvironmentsClient) (EnvironmentResource, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *EnvironmentsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for EnvironmentsUpdateFuture.Result.
func (future *EnvironmentsUpdateFuture) result(client EnvironmentsClient) (er EnvironmentResource, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "timeseriesinsights.EnvironmentsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("timeseriesinsights.EnvironmentsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if er.Response.Response, err = future.GetResult(sender); err == nil && er.Response.Response.StatusCode != http.StatusNoContent {
		er, err = client.UpdateResponder(er.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "timeseriesinsights.EnvironmentsUpdateFuture", "Result", er.Response.Response, "Failure responding to request")
		}
	}
	return
}

// EnvironmentUpdateParameters parameters supplied to the Update Environment operation.
type EnvironmentUpdateParameters struct {
	// Sku - The sku of the environment.
	Sku *Sku `json:"sku,omitempty"`
	// Tags - Key-value pairs of additional properties for the environment.
	Tags map[string]*string `json:"tags"`
	// EnvironmentMutableProperties - Properties of the environment.
	*EnvironmentMutableProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for EnvironmentUpdateParameters.
func (eup EnvironmentUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if eup.Sku != nil {
		objectMap["sku"] = eup.Sku
	}
	if eup.Tags != nil {
		objectMap["tags"] = eup.Tags
	}
	if eup.EnvironmentMutableProperties != nil {
		objectMap["properties"] = eup.EnvironmentMutableProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for EnvironmentUpdateParameters struct.
func (eup *EnvironmentUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				eup.Sku = &sku
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				eup.Tags = tags
			}
		case "properties":
			if v != nil {
				var environmentMutableProperties EnvironmentMutableProperties
				err = json.Unmarshal(*v, &environmentMutableProperties)
				if err != nil {
					return err
				}
				eup.EnvironmentMutableProperties = &environmentMutableProperties
			}
		}
	}

	return nil
}

// EventHubEventSourceCommonProperties properties of the EventHub event source.
type EventHubEventSourceCommonProperties struct {
	// ServiceBusNamespace - The name of the service bus that contains the event hub.
	ServiceBusNamespace *string `json:"serviceBusNamespace,omitempty"`
	// EventHubName - The name of the event hub.
	EventHubName *string `json:"eventHubName,omitempty"`
	// ConsumerGroupName - The name of the event hub's consumer group that holds the partitions from which events will be read.
	ConsumerGroupName *string `json:"consumerGroupName,omitempty"`
	// KeyName - The name of the SAS key that grants the Time Series Insights service access to the event hub. The shared access policies for this key must grant 'Listen' permissions to the event hub.
	KeyName *string `json:"keyName,omitempty"`
	// EventSourceResourceID - The resource id of the event source in Azure Resource Manager.
	EventSourceResourceID *string `json:"eventSourceResourceId,omitempty"`
	// TimestampPropertyName - The event property that will be used as the event source's timestamp. If a value isn't specified for timestampPropertyName, or if null or empty-string is specified, the event creation time will be used.
	TimestampPropertyName *string `json:"timestampPropertyName,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning state of the resource. Possible values include: 'Accepted', 'Creating', 'Updating', 'Succeeded', 'Failed', 'Deleting'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// CreationTime - READ-ONLY; The time the resource was created.
	CreationTime *date.Time `json:"creationTime,omitempty"`
}

// MarshalJSON is the custom marshaler for EventHubEventSourceCommonProperties.
func (ehescp EventHubEventSourceCommonProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ehescp.ServiceBusNamespace != nil {
		objectMap["serviceBusNamespace"] = ehescp.ServiceBusNamespace
	}
	if ehescp.EventHubName != nil {
		objectMap["eventHubName"] = ehescp.EventHubName
	}
	if ehescp.ConsumerGroupName != nil {
		objectMap["consumerGroupName"] = ehescp.ConsumerGroupName
	}
	if ehescp.KeyName != nil {
		objectMap["keyName"] = ehescp.KeyName
	}
	if ehescp.EventSourceResourceID != nil {
		objectMap["eventSourceResourceId"] = ehescp.EventSourceResourceID
	}
	if ehescp.TimestampPropertyName != nil {
		objectMap["timestampPropertyName"] = ehescp.TimestampPropertyName
	}
	return json.Marshal(objectMap)
}

// EventHubEventSourceCreateOrUpdateParameters parameters supplied to the Create or Update Event Source
// operation for an EventHub event source.
type EventHubEventSourceCreateOrUpdateParameters struct {
	*EventHubEventSourceCreationProperties `json:"properties,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - Key-value pairs of additional properties for the resource.
	Tags map[string]*string `json:"tags"`
	// Kind - Possible values include: 'KindEventSourceCreateOrUpdateParameters', 'KindMicrosoftEventHub', 'KindMicrosoftIoTHub'
	Kind Kind `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for EventHubEventSourceCreateOrUpdateParameters.
func (ehescoup EventHubEventSourceCreateOrUpdateParameters) MarshalJSON() ([]byte, error) {
	ehescoup.Kind = KindMicrosoftEventHub
	objectMap := make(map[string]interface{})
	if ehescoup.EventHubEventSourceCreationProperties != nil {
		objectMap["properties"] = ehescoup.EventHubEventSourceCreationProperties
	}
	if ehescoup.Kind != "" {
		objectMap["kind"] = ehescoup.Kind
	}
	if ehescoup.Location != nil {
		objectMap["location"] = ehescoup.Location
	}
	if ehescoup.Tags != nil {
		objectMap["tags"] = ehescoup.Tags
	}
	return json.Marshal(objectMap)
}

// AsEventHubEventSourceCreateOrUpdateParameters is the BasicEventSourceCreateOrUpdateParameters implementation for EventHubEventSourceCreateOrUpdateParameters.
func (ehescoup EventHubEventSourceCreateOrUpdateParameters) AsEventHubEventSourceCreateOrUpdateParameters() (*EventHubEventSourceCreateOrUpdateParameters, bool) {
	return &ehescoup, true
}

// AsIoTHubEventSourceCreateOrUpdateParameters is the BasicEventSourceCreateOrUpdateParameters implementation for EventHubEventSourceCreateOrUpdateParameters.
func (ehescoup EventHubEventSourceCreateOrUpdateParameters) AsIoTHubEventSourceCreateOrUpdateParameters() (*IoTHubEventSourceCreateOrUpdateParameters, bool) {
	return nil, false
}

// AsEventSourceCreateOrUpdateParameters is the BasicEventSourceCreateOrUpdateParameters implementation for EventHubEventSourceCreateOrUpdateParameters.
func (ehescoup EventHubEventSourceCreateOrUpdateParameters) AsEventSourceCreateOrUpdateParameters() (*EventSourceCreateOrUpdateParameters, bool) {
	return nil, false
}

// AsBasicEventSourceCreateOrUpdateParameters is the BasicEventSourceCreateOrUpdateParameters implementation for EventHubEventSourceCreateOrUpdateParameters.
func (ehescoup EventHubEventSourceCreateOrUpdateParameters) AsBasicEventSourceCreateOrUpdateParameters() (BasicEventSourceCreateOrUpdateParameters, bool) {
	return &ehescoup, true
}

// UnmarshalJSON is the custom unmarshaler for EventHubEventSourceCreateOrUpdateParameters struct.
func (ehescoup *EventHubEventSourceCreateOrUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var eventHubEventSourceCreationProperties EventHubEventSourceCreationProperties
				err = json.Unmarshal(*v, &eventHubEventSourceCreationProperties)
				if err != nil {
					return err
				}
				ehescoup.EventHubEventSourceCreationProperties = &eventHubEventSourceCreationProperties
			}
		case "kind":
			if v != nil {
				var kind Kind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ehescoup.Kind = kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ehescoup.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ehescoup.Tags = tags
			}
		}
	}

	return nil
}

// EventHubEventSourceCreationProperties properties of the EventHub event source that are required on
// create or update requests.
type EventHubEventSourceCreationProperties struct {
	// SharedAccessKey - The value of the shared access key that grants the Time Series Insights service read access to the event hub. This property is not shown in event source responses.
	SharedAccessKey *string `json:"sharedAccessKey,omitempty"`
	// ServiceBusNamespace - The name of the service bus that contains the event hub.
	ServiceBusNamespace *string `json:"serviceBusNamespace,omitempty"`
	// EventHubName - The name of the event hub.
	EventHubName *string `json:"eventHubName,omitempty"`
	// ConsumerGroupName - The name of the event hub's consumer group that holds the partitions from which events will be read.
	ConsumerGroupName *string `json:"consumerGroupName,omitempty"`
	// KeyName - The name of the SAS key that grants the Time Series Insights service access to the event hub. The shared access policies for this key must grant 'Listen' permissions to the event hub.
	KeyName *string `json:"keyName,omitempty"`
	// EventSourceResourceID - The resource id of the event source in Azure Resource Manager.
	EventSourceResourceID *string `json:"eventSourceResourceId,omitempty"`
	// TimestampPropertyName - The event property that will be used as the event source's timestamp. If a value isn't specified for timestampPropertyName, or if null or empty-string is specified, the event creation time will be used.
	TimestampPropertyName *string `json:"timestampPropertyName,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning state of the resource. Possible values include: 'Accepted', 'Creating', 'Updating', 'Succeeded', 'Failed', 'Deleting'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// CreationTime - READ-ONLY; The time the resource was created.
	CreationTime *date.Time `json:"creationTime,omitempty"`
}

// MarshalJSON is the custom marshaler for EventHubEventSourceCreationProperties.
func (ehescp EventHubEventSourceCreationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ehescp.SharedAccessKey != nil {
		objectMap["sharedAccessKey"] = ehescp.SharedAccessKey
	}
	if ehescp.ServiceBusNamespace != nil {
		objectMap["serviceBusNamespace"] = ehescp.ServiceBusNamespace
	}
	if ehescp.EventHubName != nil {
		objectMap["eventHubName"] = ehescp.EventHubName
	}
	if ehescp.ConsumerGroupName != nil {
		objectMap["consumerGroupName"] = ehescp.ConsumerGroupName
	}
	if ehescp.KeyName != nil {
		objectMap["keyName"] = ehescp.KeyName
	}
	if ehescp.EventSourceResourceID != nil {
		objectMap["eventSourceResourceId"] = ehescp.EventSourceResourceID
	}
	if ehescp.TimestampPropertyName != nil {
		objectMap["timestampPropertyName"] = ehescp.TimestampPropertyName
	}
	return json.Marshal(objectMap)
}

// EventHubEventSourceMutableProperties an object that represents a set of mutable EventHub event source
// resource properties.
type EventHubEventSourceMutableProperties struct {
	// SharedAccessKey - The value of the shared access key that grants the Time Series Insights service read access to the event hub. This property is not shown in event source responses.
	SharedAccessKey *string `json:"sharedAccessKey,omitempty"`
	// TimestampPropertyName - The event property that will be used as the event source's timestamp. If a value isn't specified for timestampPropertyName, or if null or empty-string is specified, the event creation time will be used.
	TimestampPropertyName *string         `json:"timestampPropertyName,omitempty"`
	LocalTimestamp        *LocalTimestamp `json:"localTimestamp,omitempty"`
}

// EventHubEventSourceResource an event source that receives its data from an Azure EventHub.
type EventHubEventSourceResource struct {
	*EventHubEventSourceResourceProperties `json:"properties,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Kind - Possible values include: 'KindBasicEventSourceResourceKindEventSourceResource', 'KindBasicEventSourceResourceKindMicrosoftEventHub', 'KindBasicEventSourceResourceKindMicrosoftIotHub'
	Kind KindBasicEventSourceResource `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for EventHubEventSourceResource.
func (ehesr EventHubEventSourceResource) MarshalJSON() ([]byte, error) {
	ehesr.Kind = KindBasicEventSourceResourceKindMicrosoftEventHub
	objectMap := make(map[string]interface{})
	if ehesr.EventHubEventSourceResourceProperties != nil {
		objectMap["properties"] = ehesr.EventHubEventSourceResourceProperties
	}
	if ehesr.Kind != "" {
		objectMap["kind"] = ehesr.Kind
	}
	if ehesr.Location != nil {
		objectMap["location"] = ehesr.Location
	}
	if ehesr.Tags != nil {
		objectMap["tags"] = ehesr.Tags
	}
	return json.Marshal(objectMap)
}

// AsEventHubEventSourceResource is the BasicEventSourceResource implementation for EventHubEventSourceResource.
func (ehesr EventHubEventSourceResource) AsEventHubEventSourceResource() (*EventHubEventSourceResource, bool) {
	return &ehesr, true
}

// AsIoTHubEventSourceResource is the BasicEventSourceResource implementation for EventHubEventSourceResource.
func (ehesr EventHubEventSourceResource) AsIoTHubEventSourceResource() (*IoTHubEventSourceResource, bool) {
	return nil, false
}

// AsEventSourceResource is the BasicEventSourceResource implementation for EventHubEventSourceResource.
func (ehesr EventHubEventSourceResource) AsEventSourceResource() (*EventSourceResource, bool) {
	return nil, false
}

// AsBasicEventSourceResource is the BasicEventSourceResource implementation for EventHubEventSourceResource.
func (ehesr EventHubEventSourceResource) AsBasicEventSourceResource() (BasicEventSourceResource, bool) {
	return &ehesr, true
}

// UnmarshalJSON is the custom unmarshaler for EventHubEventSourceResource struct.
func (ehesr *EventHubEventSourceResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var eventHubEventSourceResourceProperties EventHubEventSourceResourceProperties
				err = json.Unmarshal(*v, &eventHubEventSourceResourceProperties)
				if err != nil {
					return err
				}
				ehesr.EventHubEventSourceResourceProperties = &eventHubEventSourceResourceProperties
			}
		case "kind":
			if v != nil {
				var kind KindBasicEventSourceResource
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ehesr.Kind = kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ehesr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ehesr.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ehesr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ehesr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ehesr.Type = &typeVar
			}
		}
	}

	return nil
}

// EventHubEventSourceResourceProperties properties of the EventHub event source resource.
type EventHubEventSourceResourceProperties struct {
	// ServiceBusNamespace - The name of the service bus that contains the event hub.
	ServiceBusNamespace *string `json:"serviceBusNamespace,omitempty"`
	// EventHubName - The name of the event hub.
	EventHubName *string `json:"eventHubName,omitempty"`
	// ConsumerGroupName - The name of the event hub's consumer group that holds the partitions from which events will be read.
	ConsumerGroupName *string `json:"consumerGroupName,omitempty"`
	// KeyName - The name of the SAS key that grants the Time Series Insights service access to the event hub. The shared access policies for this key must grant 'Listen' permissions to the event hub.
	KeyName *string `json:"keyName,omitempty"`
	// EventSourceResourceID - The resource id of the event source in Azure Resource Manager.
	EventSourceResourceID *string `json:"eventSourceResourceId,omitempty"`
	// TimestampPropertyName - The event property that will be used as the event source's timestamp. If a value isn't specified for timestampPropertyName, or if null or empty-string is specified, the event creation time will be used.
	TimestampPropertyName *string `json:"timestampPropertyName,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning state of the resource. Possible values include: 'Accepted', 'Creating', 'Updating', 'Succeeded', 'Failed', 'Deleting'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// CreationTime - READ-ONLY; The time the resource was created.
	CreationTime *date.Time `json:"creationTime,omitempty"`
}

// MarshalJSON is the custom marshaler for EventHubEventSourceResourceProperties.
func (ehesrp EventHubEventSourceResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ehesrp.ServiceBusNamespace != nil {
		objectMap["serviceBusNamespace"] = ehesrp.ServiceBusNamespace
	}
	if ehesrp.EventHubName != nil {
		objectMap["eventHubName"] = ehesrp.EventHubName
	}
	if ehesrp.ConsumerGroupName != nil {
		objectMap["consumerGroupName"] = ehesrp.ConsumerGroupName
	}
	if ehesrp.KeyName != nil {
		objectMap["keyName"] = ehesrp.KeyName
	}
	if ehesrp.EventSourceResourceID != nil {
		objectMap["eventSourceResourceId"] = ehesrp.EventSourceResourceID
	}
	if ehesrp.TimestampPropertyName != nil {
		objectMap["timestampPropertyName"] = ehesrp.TimestampPropertyName
	}
	return json.Marshal(objectMap)
}

// EventHubEventSourceUpdateParameters parameters supplied to the Update Event Source operation to update
// an EventHub event source.
type EventHubEventSourceUpdateParameters struct {
	// EventHubEventSourceMutableProperties - Properties of the EventHub event source.
	*EventHubEventSourceMutableProperties `json:"properties,omitempty"`
	// Tags - Key-value pairs of additional properties for the event source.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for EventHubEventSourceUpdateParameters.
func (ehesup EventHubEventSourceUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ehesup.EventHubEventSourceMutableProperties != nil {
		objectMap["properties"] = ehesup.EventHubEventSourceMutableProperties
	}
	if ehesup.Tags != nil {
		objectMap["tags"] = ehesup.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for EventHubEventSourceUpdateParameters struct.
func (ehesup *EventHubEventSourceUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var eventHubEventSourceMutableProperties EventHubEventSourceMutableProperties
				err = json.Unmarshal(*v, &eventHubEventSourceMutableProperties)
				if err != nil {
					return err
				}
				ehesup.EventHubEventSourceMutableProperties = &eventHubEventSourceMutableProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ehesup.Tags = tags
			}
		}
	}

	return nil
}

// EventSourceCommonProperties properties of the event source.
type EventSourceCommonProperties struct {
	// TimestampPropertyName - The event property that will be used as the event source's timestamp. If a value isn't specified for timestampPropertyName, or if null or empty-string is specified, the event creation time will be used.
	TimestampPropertyName *string `json:"timestampPropertyName,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning state of the resource. Possible values include: 'Accepted', 'Creating', 'Updating', 'Succeeded', 'Failed', 'Deleting'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// CreationTime - READ-ONLY; The time the resource was created.
	CreationTime *date.Time `json:"creationTime,omitempty"`
}

// MarshalJSON is the custom marshaler for EventSourceCommonProperties.
func (escp EventSourceCommonProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if escp.TimestampPropertyName != nil {
		objectMap["timestampPropertyName"] = escp.TimestampPropertyName
	}
	return json.Marshal(objectMap)
}

// BasicEventSourceCreateOrUpdateParameters parameters supplied to the Create or Update Event Source operation.
type BasicEventSourceCreateOrUpdateParameters interface {
	AsEventHubEventSourceCreateOrUpdateParameters() (*EventHubEventSourceCreateOrUpdateParameters, bool)
	AsIoTHubEventSourceCreateOrUpdateParameters() (*IoTHubEventSourceCreateOrUpdateParameters, bool)
	AsEventSourceCreateOrUpdateParameters() (*EventSourceCreateOrUpdateParameters, bool)
}

// EventSourceCreateOrUpdateParameters parameters supplied to the Create or Update Event Source operation.
type EventSourceCreateOrUpdateParameters struct {
	// Kind - Possible values include: 'KindEventSourceCreateOrUpdateParameters', 'KindMicrosoftEventHub', 'KindMicrosoftIoTHub'
	Kind Kind `json:"kind,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - Key-value pairs of additional properties for the resource.
	Tags map[string]*string `json:"tags"`
}

func unmarshalBasicEventSourceCreateOrUpdateParameters(body []byte) (BasicEventSourceCreateOrUpdateParameters, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["kind"] {
	case string(KindMicrosoftEventHub):
		var ehescoup EventHubEventSourceCreateOrUpdateParameters
		err := json.Unmarshal(body, &ehescoup)
		return ehescoup, err
	case string(KindMicrosoftIoTHub):
		var ithescoup IoTHubEventSourceCreateOrUpdateParameters
		err := json.Unmarshal(body, &ithescoup)
		return ithescoup, err
	default:
		var escoup EventSourceCreateOrUpdateParameters
		err := json.Unmarshal(body, &escoup)
		return escoup, err
	}
}
func unmarshalBasicEventSourceCreateOrUpdateParametersArray(body []byte) ([]BasicEventSourceCreateOrUpdateParameters, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	escoupArray := make([]BasicEventSourceCreateOrUpdateParameters, len(rawMessages))

	for index, rawMessage := range rawMessages {
		escoup, err := unmarshalBasicEventSourceCreateOrUpdateParameters(*rawMessage)
		if err != nil {
			return nil, err
		}
		escoupArray[index] = escoup
	}
	return escoupArray, nil
}

// MarshalJSON is the custom marshaler for EventSourceCreateOrUpdateParameters.
func (escoup EventSourceCreateOrUpdateParameters) MarshalJSON() ([]byte, error) {
	escoup.Kind = KindEventSourceCreateOrUpdateParameters
	objectMap := make(map[string]interface{})
	if escoup.Kind != "" {
		objectMap["kind"] = escoup.Kind
	}
	if escoup.Location != nil {
		objectMap["location"] = escoup.Location
	}
	if escoup.Tags != nil {
		objectMap["tags"] = escoup.Tags
	}
	return json.Marshal(objectMap)
}

// AsEventHubEventSourceCreateOrUpdateParameters is the BasicEventSourceCreateOrUpdateParameters implementation for EventSourceCreateOrUpdateParameters.
func (escoup EventSourceCreateOrUpdateParameters) AsEventHubEventSourceCreateOrUpdateParameters() (*EventHubEventSourceCreateOrUpdateParameters, bool) {
	return nil, false
}

// AsIoTHubEventSourceCreateOrUpdateParameters is the BasicEventSourceCreateOrUpdateParameters implementation for EventSourceCreateOrUpdateParameters.
func (escoup EventSourceCreateOrUpdateParameters) AsIoTHubEventSourceCreateOrUpdateParameters() (*IoTHubEventSourceCreateOrUpdateParameters, bool) {
	return nil, false
}

// AsEventSourceCreateOrUpdateParameters is the BasicEventSourceCreateOrUpdateParameters implementation for EventSourceCreateOrUpdateParameters.
func (escoup EventSourceCreateOrUpdateParameters) AsEventSourceCreateOrUpdateParameters() (*EventSourceCreateOrUpdateParameters, bool) {
	return &escoup, true
}

// AsBasicEventSourceCreateOrUpdateParameters is the BasicEventSourceCreateOrUpdateParameters implementation for EventSourceCreateOrUpdateParameters.
func (escoup EventSourceCreateOrUpdateParameters) AsBasicEventSourceCreateOrUpdateParameters() (BasicEventSourceCreateOrUpdateParameters, bool) {
	return &escoup, true
}

// EventSourceListResponse the response of the List EventSources operation.
type EventSourceListResponse struct {
	autorest.Response `json:"-"`
	// Value - Result of the List EventSources operation.
	Value *[]BasicEventSourceResource `json:"value,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for EventSourceListResponse struct.
func (eslr *EventSourceListResponse) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "value":
			if v != nil {
				value, err := unmarshalBasicEventSourceResourceArray(*v)
				if err != nil {
					return err
				}
				eslr.Value = &value
			}
		}
	}

	return nil
}

// EventSourceMutableProperties an object that represents a set of mutable event source resource
// properties.
type EventSourceMutableProperties struct {
	// TimestampPropertyName - The event property that will be used as the event source's timestamp. If a value isn't specified for timestampPropertyName, or if null or empty-string is specified, the event creation time will be used.
	TimestampPropertyName *string         `json:"timestampPropertyName,omitempty"`
	LocalTimestamp        *LocalTimestamp `json:"localTimestamp,omitempty"`
}

// BasicEventSourceResource an environment receives data from one or more event sources. Each event source has
// associated connection info that allows the Time Series Insights ingress pipeline to connect to and pull data from
// the event source
type BasicEventSourceResource interface {
	AsEventHubEventSourceResource() (*EventHubEventSourceResource, bool)
	AsIoTHubEventSourceResource() (*IoTHubEventSourceResource, bool)
	AsEventSourceResource() (*EventSourceResource, bool)
}

// EventSourceResource an environment receives data from one or more event sources. Each event source has
// associated connection info that allows the Time Series Insights ingress pipeline to connect to and pull data
// from the event source
type EventSourceResource struct {
	autorest.Response `json:"-"`
	// Kind - Possible values include: 'KindBasicEventSourceResourceKindEventSourceResource', 'KindBasicEventSourceResourceKindMicrosoftEventHub', 'KindBasicEventSourceResourceKindMicrosoftIotHub'
	Kind KindBasicEventSourceResource `json:"kind,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

func unmarshalBasicEventSourceResource(body []byte) (BasicEventSourceResource, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["kind"] {
	case string(KindBasicEventSourceResourceKindMicrosoftEventHub):
		var ehesr EventHubEventSourceResource
		err := json.Unmarshal(body, &ehesr)
		return ehesr, err
	case string(KindBasicEventSourceResourceKindMicrosoftIotHub):
		var ithesr IoTHubEventSourceResource
		err := json.Unmarshal(body, &ithesr)
		return ithesr, err
	default:
		var esr EventSourceResource
		err := json.Unmarshal(body, &esr)
		return esr, err
	}
}
func unmarshalBasicEventSourceResourceArray(body []byte) ([]BasicEventSourceResource, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	esrArray := make([]BasicEventSourceResource, len(rawMessages))

	for index, rawMessage := range rawMessages {
		esr, err := unmarshalBasicEventSourceResource(*rawMessage)
		if err != nil {
			return nil, err
		}
		esrArray[index] = esr
	}
	return esrArray, nil
}

// MarshalJSON is the custom marshaler for EventSourceResource.
func (esr EventSourceResource) MarshalJSON() ([]byte, error) {
	esr.Kind = KindBasicEventSourceResourceKindEventSourceResource
	objectMap := make(map[string]interface{})
	if esr.Kind != "" {
		objectMap["kind"] = esr.Kind
	}
	if esr.Location != nil {
		objectMap["location"] = esr.Location
	}
	if esr.Tags != nil {
		objectMap["tags"] = esr.Tags
	}
	return json.Marshal(objectMap)
}

// AsEventHubEventSourceResource is the BasicEventSourceResource implementation for EventSourceResource.
func (esr EventSourceResource) AsEventHubEventSourceResource() (*EventHubEventSourceResource, bool) {
	return nil, false
}

// AsIoTHubEventSourceResource is the BasicEventSourceResource implementation for EventSourceResource.
func (esr EventSourceResource) AsIoTHubEventSourceResource() (*IoTHubEventSourceResource, bool) {
	return nil, false
}

// AsEventSourceResource is the BasicEventSourceResource implementation for EventSourceResource.
func (esr EventSourceResource) AsEventSourceResource() (*EventSourceResource, bool) {
	return &esr, true
}

// AsBasicEventSourceResource is the BasicEventSourceResource implementation for EventSourceResource.
func (esr EventSourceResource) AsBasicEventSourceResource() (BasicEventSourceResource, bool) {
	return &esr, true
}

// EventSourceResourceModel ...
type EventSourceResourceModel struct {
	autorest.Response `json:"-"`
	Value             BasicEventSourceResource `json:"value,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for EventSourceResourceModel struct.
func (esrm *EventSourceResourceModel) UnmarshalJSON(body []byte) error {
	esr, err := unmarshalBasicEventSourceResource(body)
	if err != nil {
		return err
	}
	esrm.Value = esr

	return nil
}

// EventSourceUpdateParameters parameters supplied to the Update Event Source operation.
type EventSourceUpdateParameters struct {
	// Tags - Key-value pairs of additional properties for the event source.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for EventSourceUpdateParameters.
func (esup EventSourceUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if esup.Tags != nil {
		objectMap["tags"] = esup.Tags
	}
	return json.Marshal(objectMap)
}

// IoTHubEventSourceCommonProperties properties of the IoTHub event source.
type IoTHubEventSourceCommonProperties struct {
	// IotHubName - The name of the iot hub.
	IotHubName *string `json:"iotHubName,omitempty"`
	// ConsumerGroupName - The name of the iot hub's consumer group that holds the partitions from which events will be read.
	ConsumerGroupName *string `json:"consumerGroupName,omitempty"`
	// KeyName - The name of the Shared Access Policy key that grants the Time Series Insights service access to the iot hub. This shared access policy key must grant 'service connect' permissions to the iot hub.
	KeyName *string `json:"keyName,omitempty"`
	// EventSourceResourceID - The resource id of the event source in Azure Resource Manager.
	EventSourceResourceID *string `json:"eventSourceResourceId,omitempty"`
	// TimestampPropertyName - The event property that will be used as the event source's timestamp. If a value isn't specified for timestampPropertyName, or if null or empty-string is specified, the event creation time will be used.
	TimestampPropertyName *string `json:"timestampPropertyName,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning state of the resource. Possible values include: 'Accepted', 'Creating', 'Updating', 'Succeeded', 'Failed', 'Deleting'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// CreationTime - READ-ONLY; The time the resource was created.
	CreationTime *date.Time `json:"creationTime,omitempty"`
}

// MarshalJSON is the custom marshaler for IoTHubEventSourceCommonProperties.
func (ithescp IoTHubEventSourceCommonProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ithescp.IotHubName != nil {
		objectMap["iotHubName"] = ithescp.IotHubName
	}
	if ithescp.ConsumerGroupName != nil {
		objectMap["consumerGroupName"] = ithescp.ConsumerGroupName
	}
	if ithescp.KeyName != nil {
		objectMap["keyName"] = ithescp.KeyName
	}
	if ithescp.EventSourceResourceID != nil {
		objectMap["eventSourceResourceId"] = ithescp.EventSourceResourceID
	}
	if ithescp.TimestampPropertyName != nil {
		objectMap["timestampPropertyName"] = ithescp.TimestampPropertyName
	}
	return json.Marshal(objectMap)
}

// IoTHubEventSourceCreateOrUpdateParameters parameters supplied to the Create or Update Event Source
// operation for an IoTHub event source.
type IoTHubEventSourceCreateOrUpdateParameters struct {
	*IoTHubEventSourceCreationProperties `json:"properties,omitempty"`
	// Kind - Possible values include: 'KindEventSourceCreateOrUpdateParameters', 'KindMicrosoftEventHub', 'KindMicrosoftIoTHub'
	Kind Kind `json:"kind,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - Key-value pairs of additional properties for the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for IoTHubEventSourceCreateOrUpdateParameters.
func (ithescoup IoTHubEventSourceCreateOrUpdateParameters) MarshalJSON() ([]byte, error) {
	ithescoup.Kind = KindMicrosoftIoTHub
	objectMap := make(map[string]interface{})
	if ithescoup.IoTHubEventSourceCreationProperties != nil {
		objectMap["properties"] = ithescoup.IoTHubEventSourceCreationProperties
	}
	if ithescoup.Kind != "" {
		objectMap["kind"] = ithescoup.Kind
	}
	if ithescoup.Location != nil {
		objectMap["location"] = ithescoup.Location
	}
	if ithescoup.Tags != nil {
		objectMap["tags"] = ithescoup.Tags
	}
	return json.Marshal(objectMap)
}

// AsEventHubEventSourceCreateOrUpdateParameters is the BasicEventSourceCreateOrUpdateParameters implementation for IoTHubEventSourceCreateOrUpdateParameters.
func (ithescoup IoTHubEventSourceCreateOrUpdateParameters) AsEventHubEventSourceCreateOrUpdateParameters() (*EventHubEventSourceCreateOrUpdateParameters, bool) {
	return nil, false
}

// AsIoTHubEventSourceCreateOrUpdateParameters is the BasicEventSourceCreateOrUpdateParameters implementation for IoTHubEventSourceCreateOrUpdateParameters.
func (ithescoup IoTHubEventSourceCreateOrUpdateParameters) AsIoTHubEventSourceCreateOrUpdateParameters() (*IoTHubEventSourceCreateOrUpdateParameters, bool) {
	return &ithescoup, true
}

// AsEventSourceCreateOrUpdateParameters is the BasicEventSourceCreateOrUpdateParameters implementation for IoTHubEventSourceCreateOrUpdateParameters.
func (ithescoup IoTHubEventSourceCreateOrUpdateParameters) AsEventSourceCreateOrUpdateParameters() (*EventSourceCreateOrUpdateParameters, bool) {
	return nil, false
}

// AsBasicEventSourceCreateOrUpdateParameters is the BasicEventSourceCreateOrUpdateParameters implementation for IoTHubEventSourceCreateOrUpdateParameters.
func (ithescoup IoTHubEventSourceCreateOrUpdateParameters) AsBasicEventSourceCreateOrUpdateParameters() (BasicEventSourceCreateOrUpdateParameters, bool) {
	return &ithescoup, true
}

// UnmarshalJSON is the custom unmarshaler for IoTHubEventSourceCreateOrUpdateParameters struct.
func (ithescoup *IoTHubEventSourceCreateOrUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var ioTHubEventSourceCreationProperties IoTHubEventSourceCreationProperties
				err = json.Unmarshal(*v, &ioTHubEventSourceCreationProperties)
				if err != nil {
					return err
				}
				ithescoup.IoTHubEventSourceCreationProperties = &ioTHubEventSourceCreationProperties
			}
		case "kind":
			if v != nil {
				var kind Kind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ithescoup.Kind = kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ithescoup.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ithescoup.Tags = tags
			}
		}
	}

	return nil
}

// IoTHubEventSourceCreationProperties properties of the IoTHub event source that are required on create or
// update requests.
type IoTHubEventSourceCreationProperties struct {
	// SharedAccessKey - The value of the Shared Access Policy key that grants the Time Series Insights service read access to the iot hub. This property is not shown in event source responses.
	SharedAccessKey *string `json:"sharedAccessKey,omitempty"`
	// IotHubName - The name of the iot hub.
	IotHubName *string `json:"iotHubName,omitempty"`
	// ConsumerGroupName - The name of the iot hub's consumer group that holds the partitions from which events will be read.
	ConsumerGroupName *string `json:"consumerGroupName,omitempty"`
	// KeyName - The name of the Shared Access Policy key that grants the Time Series Insights service access to the iot hub. This shared access policy key must grant 'service connect' permissions to the iot hub.
	KeyName *string `json:"keyName,omitempty"`
	// EventSourceResourceID - The resource id of the event source in Azure Resource Manager.
	EventSourceResourceID *string `json:"eventSourceResourceId,omitempty"`
	// TimestampPropertyName - The event property that will be used as the event source's timestamp. If a value isn't specified for timestampPropertyName, or if null or empty-string is specified, the event creation time will be used.
	TimestampPropertyName *string `json:"timestampPropertyName,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning state of the resource. Possible values include: 'Accepted', 'Creating', 'Updating', 'Succeeded', 'Failed', 'Deleting'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// CreationTime - READ-ONLY; The time the resource was created.
	CreationTime *date.Time `json:"creationTime,omitempty"`
}

// MarshalJSON is the custom marshaler for IoTHubEventSourceCreationProperties.
func (ithescp IoTHubEventSourceCreationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ithescp.SharedAccessKey != nil {
		objectMap["sharedAccessKey"] = ithescp.SharedAccessKey
	}
	if ithescp.IotHubName != nil {
		objectMap["iotHubName"] = ithescp.IotHubName
	}
	if ithescp.ConsumerGroupName != nil {
		objectMap["consumerGroupName"] = ithescp.ConsumerGroupName
	}
	if ithescp.KeyName != nil {
		objectMap["keyName"] = ithescp.KeyName
	}
	if ithescp.EventSourceResourceID != nil {
		objectMap["eventSourceResourceId"] = ithescp.EventSourceResourceID
	}
	if ithescp.TimestampPropertyName != nil {
		objectMap["timestampPropertyName"] = ithescp.TimestampPropertyName
	}
	return json.Marshal(objectMap)
}

// IoTHubEventSourceMutableProperties an object that represents a set of mutable IoTHub event source
// resource properties.
type IoTHubEventSourceMutableProperties struct {
	// SharedAccessKey - The value of the shared access key that grants the Time Series Insights service read access to the iot hub. This property is not shown in event source responses.
	SharedAccessKey *string `json:"sharedAccessKey,omitempty"`
	// TimestampPropertyName - The event property that will be used as the event source's timestamp. If a value isn't specified for timestampPropertyName, or if null or empty-string is specified, the event creation time will be used.
	TimestampPropertyName *string         `json:"timestampPropertyName,omitempty"`
	LocalTimestamp        *LocalTimestamp `json:"localTimestamp,omitempty"`
}

// IoTHubEventSourceResource an event source that receives its data from an Azure IoTHub.
type IoTHubEventSourceResource struct {
	*IoTHubEventSourceResourceProperties `json:"properties,omitempty"`
	// Kind - Possible values include: 'KindBasicEventSourceResourceKindEventSourceResource', 'KindBasicEventSourceResourceKindMicrosoftEventHub', 'KindBasicEventSourceResourceKindMicrosoftIotHub'
	Kind KindBasicEventSourceResource `json:"kind,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for IoTHubEventSourceResource.
func (ithesr IoTHubEventSourceResource) MarshalJSON() ([]byte, error) {
	ithesr.Kind = KindBasicEventSourceResourceKindMicrosoftIotHub
	objectMap := make(map[string]interface{})
	if ithesr.IoTHubEventSourceResourceProperties != nil {
		objectMap["properties"] = ithesr.IoTHubEventSourceResourceProperties
	}
	if ithesr.Kind != "" {
		objectMap["kind"] = ithesr.Kind
	}
	if ithesr.Location != nil {
		objectMap["location"] = ithesr.Location
	}
	if ithesr.Tags != nil {
		objectMap["tags"] = ithesr.Tags
	}
	return json.Marshal(objectMap)
}

// AsEventHubEventSourceResource is the BasicEventSourceResource implementation for IoTHubEventSourceResource.
func (ithesr IoTHubEventSourceResource) AsEventHubEventSourceResource() (*EventHubEventSourceResource, bool) {
	return nil, false
}

// AsIoTHubEventSourceResource is the BasicEventSourceResource implementation for IoTHubEventSourceResource.
func (ithesr IoTHubEventSourceResource) AsIoTHubEventSourceResource() (*IoTHubEventSourceResource, bool) {
	return &ithesr, true
}

// AsEventSourceResource is the BasicEventSourceResource implementation for IoTHubEventSourceResource.
func (ithesr IoTHubEventSourceResource) AsEventSourceResource() (*EventSourceResource, bool) {
	return nil, false
}

// AsBasicEventSourceResource is the BasicEventSourceResource implementation for IoTHubEventSourceResource.
func (ithesr IoTHubEventSourceResource) AsBasicEventSourceResource() (BasicEventSourceResource, bool) {
	return &ithesr, true
}

// UnmarshalJSON is the custom unmarshaler for IoTHubEventSourceResource struct.
func (ithesr *IoTHubEventSourceResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var ioTHubEventSourceResourceProperties IoTHubEventSourceResourceProperties
				err = json.Unmarshal(*v, &ioTHubEventSourceResourceProperties)
				if err != nil {
					return err
				}
				ithesr.IoTHubEventSourceResourceProperties = &ioTHubEventSourceResourceProperties
			}
		case "kind":
			if v != nil {
				var kind KindBasicEventSourceResource
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ithesr.Kind = kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ithesr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ithesr.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ithesr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ithesr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ithesr.Type = &typeVar
			}
		}
	}

	return nil
}

// IoTHubEventSourceResourceProperties properties of the IoTHub event source resource.
type IoTHubEventSourceResourceProperties struct {
	// IotHubName - The name of the iot hub.
	IotHubName *string `json:"iotHubName,omitempty"`
	// ConsumerGroupName - The name of the iot hub's consumer group that holds the partitions from which events will be read.
	ConsumerGroupName *string `json:"consumerGroupName,omitempty"`
	// KeyName - The name of the Shared Access Policy key that grants the Time Series Insights service access to the iot hub. This shared access policy key must grant 'service connect' permissions to the iot hub.
	KeyName *string `json:"keyName,omitempty"`
	// EventSourceResourceID - The resource id of the event source in Azure Resource Manager.
	EventSourceResourceID *string `json:"eventSourceResourceId,omitempty"`
	// TimestampPropertyName - The event property that will be used as the event source's timestamp. If a value isn't specified for timestampPropertyName, or if null or empty-string is specified, the event creation time will be used.
	TimestampPropertyName *string `json:"timestampPropertyName,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning state of the resource. Possible values include: 'Accepted', 'Creating', 'Updating', 'Succeeded', 'Failed', 'Deleting'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// CreationTime - READ-ONLY; The time the resource was created.
	CreationTime *date.Time `json:"creationTime,omitempty"`
}

// MarshalJSON is the custom marshaler for IoTHubEventSourceResourceProperties.
func (ithesrp IoTHubEventSourceResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ithesrp.IotHubName != nil {
		objectMap["iotHubName"] = ithesrp.IotHubName
	}
	if ithesrp.ConsumerGroupName != nil {
		objectMap["consumerGroupName"] = ithesrp.ConsumerGroupName
	}
	if ithesrp.KeyName != nil {
		objectMap["keyName"] = ithesrp.KeyName
	}
	if ithesrp.EventSourceResourceID != nil {
		objectMap["eventSourceResourceId"] = ithesrp.EventSourceResourceID
	}
	if ithesrp.TimestampPropertyName != nil {
		objectMap["timestampPropertyName"] = ithesrp.TimestampPropertyName
	}
	return json.Marshal(objectMap)
}

// IoTHubEventSourceUpdateParameters parameters supplied to the Update Event Source operation to update an
// IoTHub event source.
type IoTHubEventSourceUpdateParameters struct {
	// IoTHubEventSourceMutableProperties - Properties of the IoTHub event source.
	*IoTHubEventSourceMutableProperties `json:"properties,omitempty"`
	// Tags - Key-value pairs of additional properties for the event source.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for IoTHubEventSourceUpdateParameters.
func (ithesup IoTHubEventSourceUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ithesup.IoTHubEventSourceMutableProperties != nil {
		objectMap["properties"] = ithesup.IoTHubEventSourceMutableProperties
	}
	if ithesup.Tags != nil {
		objectMap["tags"] = ithesup.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for IoTHubEventSourceUpdateParameters struct.
func (ithesup *IoTHubEventSourceUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var ioTHubEventSourceMutableProperties IoTHubEventSourceMutableProperties
				err = json.Unmarshal(*v, &ioTHubEventSourceMutableProperties)
				if err != nil {
					return err
				}
				ithesup.IoTHubEventSourceMutableProperties = &ioTHubEventSourceMutableProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ithesup.Tags = tags
			}
		}
	}

	return nil
}

// LocalTimestamp an object that represents the local timestamp property. It contains the format of local
// timestamp that needs to be used and the corresponding timezone offset information. If a value isn't
// specified for localTimestamp, or if null, then the local timestamp will not be ingressed with the
// events.
type LocalTimestamp struct {
	// Format - An enum that represents the format of the local timestamp property that needs to be set. Possible values include: 'Embedded', 'Iana', 'TimeSpan'
	Format LocalTimestampFormat `json:"format,omitempty"`
	// TimeZoneOffset - An object that represents the offset information for the local timestamp format specified. Should not be specified for LocalTimestampFormat - Embedded.
	TimeZoneOffset *LocalTimestampTimeZoneOffset `json:"timeZoneOffset,omitempty"`
}

// LocalTimestampTimeZoneOffset an object that represents the offset information for the local timestamp
// format specified. Should not be specified for LocalTimestampFormat - Embedded.
type LocalTimestampTimeZoneOffset struct {
	// PropertyName - The event property that will be contain the offset information to calculate the local timestamp. When the LocalTimestampFormat is Iana, the property name will contain the name of the column which contains IANA Timezone Name (eg: Americas/Los Angeles). When LocalTimestampFormat is Timespan, it contains the name of property which contains values representing the offset (eg: P1D or 1.00:00:00)
	PropertyName *string `json:"propertyName,omitempty"`
}

// Operation a Time Series Insights REST API operation
type Operation struct {
	// Name - READ-ONLY; The name of the operation being performed on this particular object.
	Name *string `json:"name,omitempty"`
	// Display - READ-ONLY; Contains the localized display information for this particular operation / action.
	Display *OperationDisplay `json:"display,omitempty"`
}

// OperationDisplay contains the localized display information for this particular operation / action.
type OperationDisplay struct {
	// Provider - READ-ONLY; The localized friendly form of the resource provider name.
	Provider *string `json:"provider,omitempty"`
	// Resource - READ-ONLY; The localized friendly form of the resource type related to this action/operation.
	Resource *string `json:"resource,omitempty"`
	// Operation - READ-ONLY; The localized friendly name for the operation.
	Operation *string `json:"operation,omitempty"`
	// Description - READ-ONLY; The localized friendly description for the operation.
	Description *string `json:"description,omitempty"`
}

// OperationListResult result of the request to list Time Series Insights operations. It contains a list of
// operations and a URL link to get the next set of results.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of Time Series Insights operations supported by the Microsoft.TimeSeriesInsights resource provider.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationListResultIterator provides access to a complete listing of Operation values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListResultIterator type.
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return OperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (olr OperationListResult) hasNextLink() bool {
	return olr.NextLink != nil && len(*olr.NextLink) != 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !olr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of Operation values.
type OperationListResultPage struct {
	fn  func(context.Context, OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.olr)
		if err != nil {
			return err
		}
		page.olr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []Operation {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OperationListResultPage type.
func NewOperationListResultPage(cur OperationListResult, getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return OperationListResultPage{
		fn:  getNextPage,
		olr: cur,
	}
}

// ReferenceDataSetCreateOrUpdateParameters ...
type ReferenceDataSetCreateOrUpdateParameters struct {
	*ReferenceDataSetCreationProperties `json:"properties,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - Key-value pairs of additional properties for the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ReferenceDataSetCreateOrUpdateParameters.
func (rdscoup ReferenceDataSetCreateOrUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rdscoup.ReferenceDataSetCreationProperties != nil {
		objectMap["properties"] = rdscoup.ReferenceDataSetCreationProperties
	}
	if rdscoup.Location != nil {
		objectMap["location"] = rdscoup.Location
	}
	if rdscoup.Tags != nil {
		objectMap["tags"] = rdscoup.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ReferenceDataSetCreateOrUpdateParameters struct.
func (rdscoup *ReferenceDataSetCreateOrUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var referenceDataSetCreationProperties ReferenceDataSetCreationProperties
				err = json.Unmarshal(*v, &referenceDataSetCreationProperties)
				if err != nil {
					return err
				}
				rdscoup.ReferenceDataSetCreationProperties = &referenceDataSetCreationProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				rdscoup.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				rdscoup.Tags = tags
			}
		}
	}

	return nil
}

// ReferenceDataSetCreationProperties properties used to create a reference data set.
type ReferenceDataSetCreationProperties struct {
	// KeyProperties - The list of key properties for the reference data set.
	KeyProperties *[]ReferenceDataSetKeyProperty `json:"keyProperties,omitempty"`
}

// ReferenceDataSetKeyProperty a key property for the reference data set. A reference data set can have
// multiple key properties.
type ReferenceDataSetKeyProperty struct {
	// Name - The name of the key property.
	Name *string `json:"name,omitempty"`
	// Type - The type of the key property. Possible values include: 'String', 'Double', 'Bool', 'DateTime'
	Type ReferenceDataKeyPropertyType `json:"type,omitempty"`
}

// ReferenceDataSetListResponse the response of the List Reference Data Sets operation.
type ReferenceDataSetListResponse struct {
	autorest.Response `json:"-"`
	// Value - Result of the List Reference Data Sets operation.
	Value *[]ReferenceDataSetResource `json:"value,omitempty"`
}

// ReferenceDataSetResource a reference data set provides metadata about the events in an environment.
// Metadata in the reference data set will be joined with events as they are read from event sources. The
// metadata that makes up the reference data set is uploaded or modified through the Time Series Insights
// data plane APIs.
type ReferenceDataSetResource struct {
	autorest.Response                   `json:"-"`
	*ReferenceDataSetResourceProperties `json:"properties,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ReferenceDataSetResource.
func (rdsr ReferenceDataSetResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rdsr.ReferenceDataSetResourceProperties != nil {
		objectMap["properties"] = rdsr.ReferenceDataSetResourceProperties
	}
	if rdsr.Location != nil {
		objectMap["location"] = rdsr.Location
	}
	if rdsr.Tags != nil {
		objectMap["tags"] = rdsr.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ReferenceDataSetResource struct.
func (rdsr *ReferenceDataSetResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var referenceDataSetResourceProperties ReferenceDataSetResourceProperties
				err = json.Unmarshal(*v, &referenceDataSetResourceProperties)
				if err != nil {
					return err
				}
				rdsr.ReferenceDataSetResourceProperties = &referenceDataSetResourceProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				rdsr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				rdsr.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rdsr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rdsr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rdsr.Type = &typeVar
			}
		}
	}

	return nil
}

// ReferenceDataSetResourceProperties properties of the reference data set.
type ReferenceDataSetResourceProperties struct {
	// KeyProperties - The list of key properties for the reference data set.
	KeyProperties *[]ReferenceDataSetKeyProperty `json:"keyProperties,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning state of the resource. Possible values include: 'Accepted', 'Creating', 'Updating', 'Succeeded', 'Failed', 'Deleting'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// CreationTime - READ-ONLY; The time the resource was created.
	CreationTime *date.Time `json:"creationTime,omitempty"`
}

// MarshalJSON is the custom marshaler for ReferenceDataSetResourceProperties.
func (rdsrp ReferenceDataSetResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rdsrp.KeyProperties != nil {
		objectMap["keyProperties"] = rdsrp.KeyProperties
	}
	return json.Marshal(objectMap)
}

// ReferenceDataSetUpdateParameters parameters supplied to the Update Reference Data Set operation.
type ReferenceDataSetUpdateParameters struct {
	// Tags - Key-value pairs of additional properties for the reference data set.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ReferenceDataSetUpdateParameters.
func (rdsup ReferenceDataSetUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rdsup.Tags != nil {
		objectMap["tags"] = rdsup.Tags
	}
	return json.Marshal(objectMap)
}

// Resource time Series Insights resource
type Resource struct {
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// ResourceProperties properties that are common to all tracked resources.
type ResourceProperties struct {
	// ProvisioningState - READ-ONLY; Provisioning state of the resource. Possible values include: 'Accepted', 'Creating', 'Updating', 'Succeeded', 'Failed', 'Deleting'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// CreationTime - READ-ONLY; The time the resource was created.
	CreationTime *date.Time `json:"creationTime,omitempty"`
}

// Sku the sku determines the capacity of the environment, the SLA (in queries-per-minute and total
// capacity), and the billing rate.
type Sku struct {
	// Name - The name of this SKU. Possible values include: 'S1', 'S2'
	Name SkuName `json:"name,omitempty"`
	// Capacity - The capacity of the sku. This value can be changed to support scale out of environments after they have been created.
	Capacity *int32 `json:"capacity,omitempty"`
}

// TrackedResource time Series Insights resource that is tracked by Azure Resource Manager.
type TrackedResource struct {
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	return json.Marshal(objectMap)
}
