package account

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"github.com/gofrs/uuid"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/datalake/store/mgmt/2016-11-01/account"

// AccountsCreateFutureType an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AccountsCreateFutureType struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AccountsClient) (DataLakeStoreAccount, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *AccountsCreateFutureType) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for AccountsCreateFutureType.Result.
func (future *AccountsCreateFutureType) result(client AccountsClient) (dlsa DataLakeStoreAccount, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "account.AccountsCreateFutureType", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("account.AccountsCreateFutureType")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if dlsa.Response.Response, err = future.GetResult(sender); err == nil && dlsa.Response.Response.StatusCode != http.StatusNoContent {
		dlsa, err = client.CreateResponder(dlsa.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "account.AccountsCreateFutureType", "Result", dlsa.Response.Response, "Failure responding to request")
		}
	}
	return
}

// AccountsDeleteFutureType an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AccountsDeleteFutureType struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AccountsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *AccountsDeleteFutureType) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for AccountsDeleteFutureType.Result.
func (future *AccountsDeleteFutureType) result(client AccountsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "account.AccountsDeleteFutureType", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("account.AccountsDeleteFutureType")
		return
	}
	ar.Response = future.Response()
	return
}

// AccountsUpdateFutureType an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AccountsUpdateFutureType struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AccountsClient) (DataLakeStoreAccount, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *AccountsUpdateFutureType) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for AccountsUpdateFutureType.Result.
func (future *AccountsUpdateFutureType) result(client AccountsClient) (dlsa DataLakeStoreAccount, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "account.AccountsUpdateFutureType", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("account.AccountsUpdateFutureType")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if dlsa.Response.Response, err = future.GetResult(sender); err == nil && dlsa.Response.Response.StatusCode != http.StatusNoContent {
		dlsa, err = client.UpdateResponder(dlsa.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "account.AccountsUpdateFutureType", "Result", dlsa.Response.Response, "Failure responding to request")
		}
	}
	return
}

// CapabilityInformation subscription-level properties and limits for Data Lake Store.
type CapabilityInformation struct {
	autorest.Response `json:"-"`
	// SubscriptionID - READ-ONLY; The subscription credentials that uniquely identifies the subscription.
	SubscriptionID *uuid.UUID `json:"subscriptionId,omitempty"`
	// State - READ-ONLY; The subscription state. Possible values include: 'SubscriptionStateRegistered', 'SubscriptionStateSuspended', 'SubscriptionStateDeleted', 'SubscriptionStateUnregistered', 'SubscriptionStateWarned'
	State SubscriptionState `json:"state,omitempty"`
	// MaxAccountCount - READ-ONLY; The maximum supported number of accounts under this subscription.
	MaxAccountCount *int32 `json:"maxAccountCount,omitempty"`
	// AccountCount - READ-ONLY; The current number of accounts under this subscription.
	AccountCount *int32 `json:"accountCount,omitempty"`
	// MigrationState - READ-ONLY; The Boolean value of true or false to indicate the maintenance state.
	MigrationState *bool `json:"migrationState,omitempty"`
}

// CheckNameAvailabilityParameters data Lake Store account name availability check parameters.
type CheckNameAvailabilityParameters struct {
	// Name - The Data Lake Store name to check availability for.
	Name *string `json:"name,omitempty"`
	// Type - The resource type. Note: This should not be set by the user, as the constant value is Microsoft.DataLakeStore/accounts
	Type *string `json:"type,omitempty"`
}

// CreateDataLakeStoreAccountParameters ...
type CreateDataLakeStoreAccountParameters struct {
	// Location - The resource location.
	Location *string `json:"location,omitempty"`
	// Tags - The resource tags.
	Tags map[string]*string `json:"tags"`
	// Identity - The Key Vault encryption identity, if any.
	Identity *EncryptionIdentity `json:"identity,omitempty"`
	// CreateDataLakeStoreAccountProperties - The Data Lake Store account properties to use for creating.
	*CreateDataLakeStoreAccountProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for CreateDataLakeStoreAccountParameters.
func (cdlsap CreateDataLakeStoreAccountParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cdlsap.Location != nil {
		objectMap["location"] = cdlsap.Location
	}
	if cdlsap.Tags != nil {
		objectMap["tags"] = cdlsap.Tags
	}
	if cdlsap.Identity != nil {
		objectMap["identity"] = cdlsap.Identity
	}
	if cdlsap.CreateDataLakeStoreAccountProperties != nil {
		objectMap["properties"] = cdlsap.CreateDataLakeStoreAccountProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CreateDataLakeStoreAccountParameters struct.
func (cdlsap *CreateDataLakeStoreAccountParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				cdlsap.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				cdlsap.Tags = tags
			}
		case "identity":
			if v != nil {
				var identity EncryptionIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				cdlsap.Identity = &identity
			}
		case "properties":
			if v != nil {
				var createDataLakeStoreAccountProperties CreateDataLakeStoreAccountProperties
				err = json.Unmarshal(*v, &createDataLakeStoreAccountProperties)
				if err != nil {
					return err
				}
				cdlsap.CreateDataLakeStoreAccountProperties = &createDataLakeStoreAccountProperties
			}
		}
	}

	return nil
}

// CreateDataLakeStoreAccountProperties ...
type CreateDataLakeStoreAccountProperties struct {
	// DefaultGroup - The default owner group for all new folders and files created in the Data Lake Store account.
	DefaultGroup *string `json:"defaultGroup,omitempty"`
	// EncryptionConfig - The Key Vault encryption configuration.
	EncryptionConfig *EncryptionConfig `json:"encryptionConfig,omitempty"`
	// EncryptionState - The current state of encryption for this Data Lake Store account. Possible values include: 'Enabled', 'Disabled'
	EncryptionState EncryptionState `json:"encryptionState,omitempty"`
	// FirewallRules - The list of firewall rules associated with this Data Lake Store account.
	FirewallRules *[]CreateFirewallRuleWithAccountParameters `json:"firewallRules,omitempty"`
	// VirtualNetworkRules - The list of virtual network rules associated with this Data Lake Store account.
	VirtualNetworkRules *[]CreateVirtualNetworkRuleWithAccountParameters `json:"virtualNetworkRules,omitempty"`
	// FirewallState - The current state of the IP address firewall for this Data Lake Store account. Possible values include: 'FirewallStateEnabled', 'FirewallStateDisabled'
	FirewallState FirewallState `json:"firewallState,omitempty"`
	// FirewallAllowAzureIps - The current state of allowing or disallowing IPs originating within Azure through the firewall. If the firewall is disabled, this is not enforced. Possible values include: 'FirewallAllowAzureIpsStateEnabled', 'FirewallAllowAzureIpsStateDisabled'
	FirewallAllowAzureIps FirewallAllowAzureIpsState `json:"firewallAllowAzureIps,omitempty"`
	// TrustedIDProviders - The list of trusted identity providers associated with this Data Lake Store account.
	TrustedIDProviders *[]CreateTrustedIDProviderWithAccountParameters `json:"trustedIdProviders,omitempty"`
	// TrustedIDProviderState - The current state of the trusted identity provider feature for this Data Lake Store account. Possible values include: 'TrustedIDProviderStateEnabled', 'TrustedIDProviderStateDisabled'
	TrustedIDProviderState TrustedIDProviderState `json:"trustedIdProviderState,omitempty"`
	// NewTier - The commitment tier to use for next month. Possible values include: 'Consumption', 'Commitment1TB', 'Commitment10TB', 'Commitment100TB', 'Commitment500TB', 'Commitment1PB', 'Commitment5PB'
	NewTier TierType `json:"newTier,omitempty"`
}

// CreateFirewallRuleWithAccountParameters the parameters used to create a new firewall rule while creating
// a new Data Lake Store account.
type CreateFirewallRuleWithAccountParameters struct {
	// Name - The unique name of the firewall rule to create.
	Name *string `json:"name,omitempty"`
	// CreateOrUpdateFirewallRuleProperties - The firewall rule properties to use when creating a new firewall rule.
	*CreateOrUpdateFirewallRuleProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for CreateFirewallRuleWithAccountParameters.
func (cfrwap CreateFirewallRuleWithAccountParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cfrwap.Name != nil {
		objectMap["name"] = cfrwap.Name
	}
	if cfrwap.CreateOrUpdateFirewallRuleProperties != nil {
		objectMap["properties"] = cfrwap.CreateOrUpdateFirewallRuleProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CreateFirewallRuleWithAccountParameters struct.
func (cfrwap *CreateFirewallRuleWithAccountParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cfrwap.Name = &name
			}
		case "properties":
			if v != nil {
				var createOrUpdateFirewallRuleProperties CreateOrUpdateFirewallRuleProperties
				err = json.Unmarshal(*v, &createOrUpdateFirewallRuleProperties)
				if err != nil {
					return err
				}
				cfrwap.CreateOrUpdateFirewallRuleProperties = &createOrUpdateFirewallRuleProperties
			}
		}
	}

	return nil
}

// CreateOrUpdateFirewallRuleParameters the parameters used to create a new firewall rule.
type CreateOrUpdateFirewallRuleParameters struct {
	// CreateOrUpdateFirewallRuleProperties - The firewall rule properties to use when creating a new firewall rule.
	*CreateOrUpdateFirewallRuleProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for CreateOrUpdateFirewallRuleParameters.
func (coufrp CreateOrUpdateFirewallRuleParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if coufrp.CreateOrUpdateFirewallRuleProperties != nil {
		objectMap["properties"] = coufrp.CreateOrUpdateFirewallRuleProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CreateOrUpdateFirewallRuleParameters struct.
func (coufrp *CreateOrUpdateFirewallRuleParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var createOrUpdateFirewallRuleProperties CreateOrUpdateFirewallRuleProperties
				err = json.Unmarshal(*v, &createOrUpdateFirewallRuleProperties)
				if err != nil {
					return err
				}
				coufrp.CreateOrUpdateFirewallRuleProperties = &createOrUpdateFirewallRuleProperties
			}
		}
	}

	return nil
}

// CreateOrUpdateFirewallRuleProperties the firewall rule properties to use when creating a new firewall
// rule.
type CreateOrUpdateFirewallRuleProperties struct {
	// StartIPAddress - The start IP address for the firewall rule. This can be either ipv4 or ipv6. Start and End should be in the same protocol.
	StartIPAddress *string `json:"startIpAddress,omitempty"`
	// EndIPAddress - The end IP address for the firewall rule. This can be either ipv4 or ipv6. Start and End should be in the same protocol.
	EndIPAddress *string `json:"endIpAddress,omitempty"`
}

// CreateOrUpdateTrustedIDProviderParameters the parameters used to create a new trusted identity provider.
type CreateOrUpdateTrustedIDProviderParameters struct {
	// CreateOrUpdateTrustedIDProviderProperties - The trusted identity provider properties to use when creating a new trusted identity provider.
	*CreateOrUpdateTrustedIDProviderProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for CreateOrUpdateTrustedIDProviderParameters.
func (coutipp CreateOrUpdateTrustedIDProviderParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if coutipp.CreateOrUpdateTrustedIDProviderProperties != nil {
		objectMap["properties"] = coutipp.CreateOrUpdateTrustedIDProviderProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CreateOrUpdateTrustedIDProviderParameters struct.
func (coutipp *CreateOrUpdateTrustedIDProviderParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var createOrUpdateTrustedIDProviderProperties CreateOrUpdateTrustedIDProviderProperties
				err = json.Unmarshal(*v, &createOrUpdateTrustedIDProviderProperties)
				if err != nil {
					return err
				}
				coutipp.CreateOrUpdateTrustedIDProviderProperties = &createOrUpdateTrustedIDProviderProperties
			}
		}
	}

	return nil
}

// CreateOrUpdateTrustedIDProviderProperties the trusted identity provider properties to use when creating
// a new trusted identity provider.
type CreateOrUpdateTrustedIDProviderProperties struct {
	// IDProvider - The URL of this trusted identity provider.
	IDProvider *string `json:"idProvider,omitempty"`
}

// CreateOrUpdateVirtualNetworkRuleParameters the parameters used to create a new virtual network rule.
type CreateOrUpdateVirtualNetworkRuleParameters struct {
	// CreateOrUpdateVirtualNetworkRuleProperties - The virtual network rule properties to use when creating a new virtual network rule.
	*CreateOrUpdateVirtualNetworkRuleProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for CreateOrUpdateVirtualNetworkRuleParameters.
func (couvnrp CreateOrUpdateVirtualNetworkRuleParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if couvnrp.CreateOrUpdateVirtualNetworkRuleProperties != nil {
		objectMap["properties"] = couvnrp.CreateOrUpdateVirtualNetworkRuleProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CreateOrUpdateVirtualNetworkRuleParameters struct.
func (couvnrp *CreateOrUpdateVirtualNetworkRuleParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var createOrUpdateVirtualNetworkRuleProperties CreateOrUpdateVirtualNetworkRuleProperties
				err = json.Unmarshal(*v, &createOrUpdateVirtualNetworkRuleProperties)
				if err != nil {
					return err
				}
				couvnrp.CreateOrUpdateVirtualNetworkRuleProperties = &createOrUpdateVirtualNetworkRuleProperties
			}
		}
	}

	return nil
}

// CreateOrUpdateVirtualNetworkRuleProperties the virtual network rule properties to use when creating a
// new virtual network rule.
type CreateOrUpdateVirtualNetworkRuleProperties struct {
	// SubnetID - The resource identifier for the subnet.
	SubnetID *string `json:"subnetId,omitempty"`
}

// CreateTrustedIDProviderWithAccountParameters the parameters used to create a new trusted identity
// provider while creating a new Data Lake Store account.
type CreateTrustedIDProviderWithAccountParameters struct {
	// Name - The unique name of the trusted identity provider to create.
	Name *string `json:"name,omitempty"`
	// CreateOrUpdateTrustedIDProviderProperties - The trusted identity provider properties to use when creating a new trusted identity provider.
	*CreateOrUpdateTrustedIDProviderProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for CreateTrustedIDProviderWithAccountParameters.
func (ctipwap CreateTrustedIDProviderWithAccountParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ctipwap.Name != nil {
		objectMap["name"] = ctipwap.Name
	}
	if ctipwap.CreateOrUpdateTrustedIDProviderProperties != nil {
		objectMap["properties"] = ctipwap.CreateOrUpdateTrustedIDProviderProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CreateTrustedIDProviderWithAccountParameters struct.
func (ctipwap *CreateTrustedIDProviderWithAccountParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ctipwap.Name = &name
			}
		case "properties":
			if v != nil {
				var createOrUpdateTrustedIDProviderProperties CreateOrUpdateTrustedIDProviderProperties
				err = json.Unmarshal(*v, &createOrUpdateTrustedIDProviderProperties)
				if err != nil {
					return err
				}
				ctipwap.CreateOrUpdateTrustedIDProviderProperties = &createOrUpdateTrustedIDProviderProperties
			}
		}
	}

	return nil
}

// CreateVirtualNetworkRuleWithAccountParameters the parameters used to create a new virtual network rule
// while creating a new Data Lake Store account.
type CreateVirtualNetworkRuleWithAccountParameters struct {
	// Name - The unique name of the virtual network rule to create.
	Name *string `json:"name,omitempty"`
	// CreateOrUpdateVirtualNetworkRuleProperties - The virtual network rule properties to use when creating a new virtual network rule.
	*CreateOrUpdateVirtualNetworkRuleProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for CreateVirtualNetworkRuleWithAccountParameters.
func (cvnrwap CreateVirtualNetworkRuleWithAccountParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cvnrwap.Name != nil {
		objectMap["name"] = cvnrwap.Name
	}
	if cvnrwap.CreateOrUpdateVirtualNetworkRuleProperties != nil {
		objectMap["properties"] = cvnrwap.CreateOrUpdateVirtualNetworkRuleProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CreateVirtualNetworkRuleWithAccountParameters struct.
func (cvnrwap *CreateVirtualNetworkRuleWithAccountParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cvnrwap.Name = &name
			}
		case "properties":
			if v != nil {
				var createOrUpdateVirtualNetworkRuleProperties CreateOrUpdateVirtualNetworkRuleProperties
				err = json.Unmarshal(*v, &createOrUpdateVirtualNetworkRuleProperties)
				if err != nil {
					return err
				}
				cvnrwap.CreateOrUpdateVirtualNetworkRuleProperties = &createOrUpdateVirtualNetworkRuleProperties
			}
		}
	}

	return nil
}

// DataLakeStoreAccount data Lake Store account information.
type DataLakeStoreAccount struct {
	autorest.Response `json:"-"`
	// Identity - READ-ONLY; The Key Vault encryption identity, if any.
	Identity *EncryptionIdentity `json:"identity,omitempty"`
	// DataLakeStoreAccountProperties - READ-ONLY; The Data Lake Store account properties.
	*DataLakeStoreAccountProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The resource type.
	Type *string `json:"type,omitempty"`
	// Location - READ-ONLY; The resource location.
	Location *string `json:"location,omitempty"`
	// Tags - READ-ONLY; The resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for DataLakeStoreAccount.
func (dlsa DataLakeStoreAccount) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DataLakeStoreAccount struct.
func (dlsa *DataLakeStoreAccount) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "identity":
			if v != nil {
				var identity EncryptionIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				dlsa.Identity = &identity
			}
		case "properties":
			if v != nil {
				var dataLakeStoreAccountProperties DataLakeStoreAccountProperties
				err = json.Unmarshal(*v, &dataLakeStoreAccountProperties)
				if err != nil {
					return err
				}
				dlsa.DataLakeStoreAccountProperties = &dataLakeStoreAccountProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dlsa.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dlsa.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dlsa.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				dlsa.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				dlsa.Tags = tags
			}
		}
	}

	return nil
}

// DataLakeStoreAccountBasic basic Data Lake Store account information, returned on list calls.
type DataLakeStoreAccountBasic struct {
	// DataLakeStoreAccountPropertiesBasic - READ-ONLY; The basic Data Lake Store account properties.
	*DataLakeStoreAccountPropertiesBasic `json:"properties,omitempty"`
	// ID - READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The resource type.
	Type *string `json:"type,omitempty"`
	// Location - READ-ONLY; The resource location.
	Location *string `json:"location,omitempty"`
	// Tags - READ-ONLY; The resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for DataLakeStoreAccountBasic.
func (dlsab DataLakeStoreAccountBasic) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DataLakeStoreAccountBasic struct.
func (dlsab *DataLakeStoreAccountBasic) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var dataLakeStoreAccountPropertiesBasic DataLakeStoreAccountPropertiesBasic
				err = json.Unmarshal(*v, &dataLakeStoreAccountPropertiesBasic)
				if err != nil {
					return err
				}
				dlsab.DataLakeStoreAccountPropertiesBasic = &dataLakeStoreAccountPropertiesBasic
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dlsab.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dlsab.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dlsab.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				dlsab.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				dlsab.Tags = tags
			}
		}
	}

	return nil
}

// DataLakeStoreAccountListResult data Lake Store account list information response.
type DataLakeStoreAccountListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The results of the list operation.
	Value *[]DataLakeStoreAccountBasic `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// DataLakeStoreAccountListResultIterator provides access to a complete listing of
// DataLakeStoreAccountBasic values.
type DataLakeStoreAccountListResultIterator struct {
	i    int
	page DataLakeStoreAccountListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DataLakeStoreAccountListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DataLakeStoreAccountListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DataLakeStoreAccountListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DataLakeStoreAccountListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DataLakeStoreAccountListResultIterator) Response() DataLakeStoreAccountListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DataLakeStoreAccountListResultIterator) Value() DataLakeStoreAccountBasic {
	if !iter.page.NotDone() {
		return DataLakeStoreAccountBasic{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DataLakeStoreAccountListResultIterator type.
func NewDataLakeStoreAccountListResultIterator(page DataLakeStoreAccountListResultPage) DataLakeStoreAccountListResultIterator {
	return DataLakeStoreAccountListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dlsalr DataLakeStoreAccountListResult) IsEmpty() bool {
	return dlsalr.Value == nil || len(*dlsalr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dlsalr DataLakeStoreAccountListResult) hasNextLink() bool {
	return dlsalr.NextLink != nil && len(*dlsalr.NextLink) != 0
}

// dataLakeStoreAccountListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dlsalr DataLakeStoreAccountListResult) dataLakeStoreAccountListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !dlsalr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dlsalr.NextLink)))
}

// DataLakeStoreAccountListResultPage contains a page of DataLakeStoreAccountBasic values.
type DataLakeStoreAccountListResultPage struct {
	fn     func(context.Context, DataLakeStoreAccountListResult) (DataLakeStoreAccountListResult, error)
	dlsalr DataLakeStoreAccountListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DataLakeStoreAccountListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DataLakeStoreAccountListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dlsalr)
		if err != nil {
			return err
		}
		page.dlsalr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DataLakeStoreAccountListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DataLakeStoreAccountListResultPage) NotDone() bool {
	return !page.dlsalr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DataLakeStoreAccountListResultPage) Response() DataLakeStoreAccountListResult {
	return page.dlsalr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DataLakeStoreAccountListResultPage) Values() []DataLakeStoreAccountBasic {
	if page.dlsalr.IsEmpty() {
		return nil
	}
	return *page.dlsalr.Value
}

// Creates a new instance of the DataLakeStoreAccountListResultPage type.
func NewDataLakeStoreAccountListResultPage(cur DataLakeStoreAccountListResult, getNextPage func(context.Context, DataLakeStoreAccountListResult) (DataLakeStoreAccountListResult, error)) DataLakeStoreAccountListResultPage {
	return DataLakeStoreAccountListResultPage{
		fn:     getNextPage,
		dlsalr: cur,
	}
}

// DataLakeStoreAccountProperties data Lake Store account properties information.
type DataLakeStoreAccountProperties struct {
	// DefaultGroup - READ-ONLY; The default owner group for all new folders and files created in the Data Lake Store account.
	DefaultGroup *string `json:"defaultGroup,omitempty"`
	// EncryptionConfig - READ-ONLY; The Key Vault encryption configuration.
	EncryptionConfig *EncryptionConfig `json:"encryptionConfig,omitempty"`
	// EncryptionState - READ-ONLY; The current state of encryption for this Data Lake Store account. Possible values include: 'Enabled', 'Disabled'
	EncryptionState EncryptionState `json:"encryptionState,omitempty"`
	// EncryptionProvisioningState - READ-ONLY; The current state of encryption provisioning for this Data Lake Store account. Possible values include: 'EncryptionProvisioningStateCreating', 'EncryptionProvisioningStateSucceeded'
	EncryptionProvisioningState EncryptionProvisioningState `json:"encryptionProvisioningState,omitempty"`
	// FirewallRules - READ-ONLY; The list of firewall rules associated with this Data Lake Store account.
	FirewallRules *[]FirewallRule `json:"firewallRules,omitempty"`
	// VirtualNetworkRules - READ-ONLY; The list of virtual network rules associated with this Data Lake Store account.
	VirtualNetworkRules *[]VirtualNetworkRule `json:"virtualNetworkRules,omitempty"`
	// FirewallState - READ-ONLY; The current state of the IP address firewall for this Data Lake Store account. Possible values include: 'FirewallStateEnabled', 'FirewallStateDisabled'
	FirewallState FirewallState `json:"firewallState,omitempty"`
	// FirewallAllowAzureIps - READ-ONLY; The current state of allowing or disallowing IPs originating within Azure through the firewall. If the firewall is disabled, this is not enforced. Possible values include: 'FirewallAllowAzureIpsStateEnabled', 'FirewallAllowAzureIpsStateDisabled'
	FirewallAllowAzureIps FirewallAllowAzureIpsState `json:"firewallAllowAzureIps,omitempty"`
	// TrustedIDProviders - READ-ONLY; The list of trusted identity providers associated with this Data Lake Store account.
	TrustedIDProviders *[]TrustedIDProvider `json:"trustedIdProviders,omitempty"`
	// TrustedIDProviderState - READ-ONLY; The current state of the trusted identity provider feature for this Data Lake Store account. Possible values include: 'TrustedIDProviderStateEnabled', 'TrustedIDProviderStateDisabled'
	TrustedIDProviderState TrustedIDProviderState `json:"trustedIdProviderState,omitempty"`
	// NewTier - READ-ONLY; The commitment tier to use for next month. Possible values include: 'Consumption', 'Commitment1TB', 'Commitment10TB', 'Commitment100TB', 'Commitment500TB', 'Commitment1PB', 'Commitment5PB'
	NewTier TierType `json:"newTier,omitempty"`
	// CurrentTier - READ-ONLY; The commitment tier in use for the current month. Possible values include: 'Consumption', 'Commitment1TB', 'Commitment10TB', 'Commitment100TB', 'Commitment500TB', 'Commitment1PB', 'Commitment5PB'
	CurrentTier TierType `json:"currentTier,omitempty"`
	// AccountID - READ-ONLY; The unique identifier associated with this Data Lake Store account.
	AccountID *uuid.UUID `json:"accountId,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning status of the Data Lake Store account. Possible values include: 'Failed', 'Creating', 'Running', 'Succeeded', 'Patching', 'Suspending', 'Resuming', 'Deleting', 'Deleted', 'Undeleting', 'Canceled'
	ProvisioningState DataLakeStoreAccountStatus `json:"provisioningState,omitempty"`
	// State - READ-ONLY; The state of the Data Lake Store account. Possible values include: 'Active', 'Suspended'
	State DataLakeStoreAccountState `json:"state,omitempty"`
	// CreationTime - READ-ONLY; The account creation time.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// LastModifiedTime - READ-ONLY; The account last modified time.
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
	// Endpoint - READ-ONLY; The full CName endpoint for this account.
	Endpoint *string `json:"endpoint,omitempty"`
}

// DataLakeStoreAccountPropertiesBasic the basic account specific properties that are associated with an
// underlying Data Lake Store account.
type DataLakeStoreAccountPropertiesBasic struct {
	// AccountID - READ-ONLY; The unique identifier associated with this Data Lake Store account.
	AccountID *uuid.UUID `json:"accountId,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning status of the Data Lake Store account. Possible values include: 'Failed', 'Creating', 'Running', 'Succeeded', 'Patching', 'Suspending', 'Resuming', 'Deleting', 'Deleted', 'Undeleting', 'Canceled'
	ProvisioningState DataLakeStoreAccountStatus `json:"provisioningState,omitempty"`
	// State - READ-ONLY; The state of the Data Lake Store account. Possible values include: 'Active', 'Suspended'
	State DataLakeStoreAccountState `json:"state,omitempty"`
	// CreationTime - READ-ONLY; The account creation time.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// LastModifiedTime - READ-ONLY; The account last modified time.
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
	// Endpoint - READ-ONLY; The full CName endpoint for this account.
	Endpoint *string `json:"endpoint,omitempty"`
}

// EncryptionConfig the encryption configuration for the account.
type EncryptionConfig struct {
	// Type - The type of encryption configuration being used. Currently the only supported types are 'UserManaged' and 'ServiceManaged'. Possible values include: 'UserManaged', 'ServiceManaged'
	Type EncryptionConfigType `json:"type,omitempty"`
	// KeyVaultMetaInfo - The Key Vault information for connecting to user managed encryption keys.
	KeyVaultMetaInfo *KeyVaultMetaInfo `json:"keyVaultMetaInfo,omitempty"`
}

// EncryptionIdentity the encryption identity properties.
type EncryptionIdentity struct {
	// Type - The type of encryption being used. Currently the only supported type is 'SystemAssigned'.
	Type *string `json:"type,omitempty"`
	// PrincipalID - READ-ONLY; The principal identifier associated with the encryption.
	PrincipalID *uuid.UUID `json:"principalId,omitempty"`
	// TenantID - READ-ONLY; The tenant identifier associated with the encryption.
	TenantID *uuid.UUID `json:"tenantId,omitempty"`
}

// MarshalJSON is the custom marshaler for EncryptionIdentity.
func (ei EncryptionIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ei.Type != nil {
		objectMap["type"] = ei.Type
	}
	return json.Marshal(objectMap)
}

// FirewallRule data Lake Store firewall rule information.
type FirewallRule struct {
	autorest.Response `json:"-"`
	// FirewallRuleProperties - READ-ONLY; The firewall rule properties.
	*FirewallRuleProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for FirewallRule.
func (fr FirewallRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for FirewallRule struct.
func (fr *FirewallRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var firewallRuleProperties FirewallRuleProperties
				err = json.Unmarshal(*v, &firewallRuleProperties)
				if err != nil {
					return err
				}
				fr.FirewallRuleProperties = &firewallRuleProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				fr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				fr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				fr.Type = &typeVar
			}
		}
	}

	return nil
}

// FirewallRuleListResult data Lake Store firewall rule list information.
type FirewallRuleListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The results of the list operation.
	Value *[]FirewallRule `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// FirewallRuleListResultIterator provides access to a complete listing of FirewallRule values.
type FirewallRuleListResultIterator struct {
	i    int
	page FirewallRuleListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *FirewallRuleListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/FirewallRuleListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *FirewallRuleListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter FirewallRuleListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter FirewallRuleListResultIterator) Response() FirewallRuleListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter FirewallRuleListResultIterator) Value() FirewallRule {
	if !iter.page.NotDone() {
		return FirewallRule{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the FirewallRuleListResultIterator type.
func NewFirewallRuleListResultIterator(page FirewallRuleListResultPage) FirewallRuleListResultIterator {
	return FirewallRuleListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (frlr FirewallRuleListResult) IsEmpty() bool {
	return frlr.Value == nil || len(*frlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (frlr FirewallRuleListResult) hasNextLink() bool {
	return frlr.NextLink != nil && len(*frlr.NextLink) != 0
}

// firewallRuleListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (frlr FirewallRuleListResult) firewallRuleListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !frlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(frlr.NextLink)))
}

// FirewallRuleListResultPage contains a page of FirewallRule values.
type FirewallRuleListResultPage struct {
	fn   func(context.Context, FirewallRuleListResult) (FirewallRuleListResult, error)
	frlr FirewallRuleListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *FirewallRuleListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/FirewallRuleListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.frlr)
		if err != nil {
			return err
		}
		page.frlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *FirewallRuleListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page FirewallRuleListResultPage) NotDone() bool {
	return !page.frlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page FirewallRuleListResultPage) Response() FirewallRuleListResult {
	return page.frlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page FirewallRuleListResultPage) Values() []FirewallRule {
	if page.frlr.IsEmpty() {
		return nil
	}
	return *page.frlr.Value
}

// Creates a new instance of the FirewallRuleListResultPage type.
func NewFirewallRuleListResultPage(cur FirewallRuleListResult, getNextPage func(context.Context, FirewallRuleListResult) (FirewallRuleListResult, error)) FirewallRuleListResultPage {
	return FirewallRuleListResultPage{
		fn:   getNextPage,
		frlr: cur,
	}
}

// FirewallRuleProperties the firewall rule properties.
type FirewallRuleProperties struct {
	// StartIPAddress - READ-ONLY; The start IP address for the firewall rule. This can be either ipv4 or ipv6. Start and End should be in the same protocol.
	StartIPAddress *string `json:"startIpAddress,omitempty"`
	// EndIPAddress - READ-ONLY; The end IP address for the firewall rule. This can be either ipv4 or ipv6. Start and End should be in the same protocol.
	EndIPAddress *string `json:"endIpAddress,omitempty"`
}

// KeyVaultMetaInfo metadata information used by account encryption.
type KeyVaultMetaInfo struct {
	// KeyVaultResourceID - The resource identifier for the user managed Key Vault being used to encrypt.
	KeyVaultResourceID *string `json:"keyVaultResourceId,omitempty"`
	// EncryptionKeyName - The name of the user managed encryption key.
	EncryptionKeyName *string `json:"encryptionKeyName,omitempty"`
	// EncryptionKeyVersion - The version of the user managed encryption key.
	EncryptionKeyVersion *string `json:"encryptionKeyVersion,omitempty"`
}

// NameAvailabilityInformation data Lake Store account name availability result information.
type NameAvailabilityInformation struct {
	autorest.Response `json:"-"`
	// NameAvailable - READ-ONLY; The Boolean value of true or false to indicate whether the Data Lake Store account name is available or not.
	NameAvailable *bool `json:"nameAvailable,omitempty"`
	// Reason - READ-ONLY; The reason why the Data Lake Store account name is not available, if nameAvailable is false.
	Reason *string `json:"reason,omitempty"`
	// Message - READ-ONLY; The message describing why the Data Lake Store account name is not available, if nameAvailable is false.
	Message *string `json:"message,omitempty"`
}

// Operation an available operation for Data Lake Store.
type Operation struct {
	// Name - READ-ONLY; The name of the operation.
	Name *string `json:"name,omitempty"`
	// Display - The display information for the operation.
	Display *OperationDisplay `json:"display,omitempty"`
	// Origin - READ-ONLY; The intended executor of the operation. Possible values include: 'User', 'System', 'Usersystem'
	Origin OperationOrigin `json:"origin,omitempty"`
}

// MarshalJSON is the custom marshaler for Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if o.Display != nil {
		objectMap["display"] = o.Display
	}
	return json.Marshal(objectMap)
}

// OperationDisplay the display information for a particular operation.
type OperationDisplay struct {
	// Provider - READ-ONLY; The resource provider of the operation.
	Provider *string `json:"provider,omitempty"`
	// Resource - READ-ONLY; The resource type of the operation.
	Resource *string `json:"resource,omitempty"`
	// Operation - READ-ONLY; A friendly name of the operation.
	Operation *string `json:"operation,omitempty"`
	// Description - READ-ONLY; A friendly description of the operation.
	Description *string `json:"description,omitempty"`
}

// OperationListResult the list of available operations for Data Lake Store.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The results of the list operation.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// Resource the resource model definition.
type Resource struct {
	// ID - READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The resource type.
	Type *string `json:"type,omitempty"`
	// Location - READ-ONLY; The resource location.
	Location *string `json:"location,omitempty"`
	// Tags - READ-ONLY; The resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// SubResource the resource model definition for a nested resource.
type SubResource struct {
	// ID - READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The resource type.
	Type *string `json:"type,omitempty"`
}

// TrustedIDProvider data Lake Store trusted identity provider information.
type TrustedIDProvider struct {
	autorest.Response `json:"-"`
	// TrustedIDProviderProperties - READ-ONLY; The trusted identity provider properties.
	*TrustedIDProviderProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TrustedIDProvider.
func (tip TrustedIDProvider) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for TrustedIDProvider struct.
func (tip *TrustedIDProvider) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var trustedIDProviderProperties TrustedIDProviderProperties
				err = json.Unmarshal(*v, &trustedIDProviderProperties)
				if err != nil {
					return err
				}
				tip.TrustedIDProviderProperties = &trustedIDProviderProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				tip.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				tip.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				tip.Type = &typeVar
			}
		}
	}

	return nil
}

// TrustedIDProviderListResult data Lake Store trusted identity provider list information.
type TrustedIDProviderListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The results of the list operation.
	Value *[]TrustedIDProvider `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// TrustedIDProviderListResultIterator provides access to a complete listing of TrustedIDProvider values.
type TrustedIDProviderListResultIterator struct {
	i    int
	page TrustedIDProviderListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *TrustedIDProviderListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TrustedIDProviderListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *TrustedIDProviderListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter TrustedIDProviderListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter TrustedIDProviderListResultIterator) Response() TrustedIDProviderListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter TrustedIDProviderListResultIterator) Value() TrustedIDProvider {
	if !iter.page.NotDone() {
		return TrustedIDProvider{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the TrustedIDProviderListResultIterator type.
func NewTrustedIDProviderListResultIterator(page TrustedIDProviderListResultPage) TrustedIDProviderListResultIterator {
	return TrustedIDProviderListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (tiplr TrustedIDProviderListResult) IsEmpty() bool {
	return tiplr.Value == nil || len(*tiplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (tiplr TrustedIDProviderListResult) hasNextLink() bool {
	return tiplr.NextLink != nil && len(*tiplr.NextLink) != 0
}

// trustedIDProviderListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (tiplr TrustedIDProviderListResult) trustedIDProviderListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !tiplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(tiplr.NextLink)))
}

// TrustedIDProviderListResultPage contains a page of TrustedIDProvider values.
type TrustedIDProviderListResultPage struct {
	fn    func(context.Context, TrustedIDProviderListResult) (TrustedIDProviderListResult, error)
	tiplr TrustedIDProviderListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *TrustedIDProviderListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TrustedIDProviderListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.tiplr)
		if err != nil {
			return err
		}
		page.tiplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *TrustedIDProviderListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page TrustedIDProviderListResultPage) NotDone() bool {
	return !page.tiplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page TrustedIDProviderListResultPage) Response() TrustedIDProviderListResult {
	return page.tiplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page TrustedIDProviderListResultPage) Values() []TrustedIDProvider {
	if page.tiplr.IsEmpty() {
		return nil
	}
	return *page.tiplr.Value
}

// Creates a new instance of the TrustedIDProviderListResultPage type.
func NewTrustedIDProviderListResultPage(cur TrustedIDProviderListResult, getNextPage func(context.Context, TrustedIDProviderListResult) (TrustedIDProviderListResult, error)) TrustedIDProviderListResultPage {
	return TrustedIDProviderListResultPage{
		fn:    getNextPage,
		tiplr: cur,
	}
}

// TrustedIDProviderProperties the trusted identity provider properties.
type TrustedIDProviderProperties struct {
	// IDProvider - READ-ONLY; The URL of this trusted identity provider.
	IDProvider *string `json:"idProvider,omitempty"`
}

// UpdateDataLakeStoreAccountParameters data Lake Store account information to update.
type UpdateDataLakeStoreAccountParameters struct {
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// UpdateDataLakeStoreAccountProperties - The Data Lake Store account properties to update.
	*UpdateDataLakeStoreAccountProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for UpdateDataLakeStoreAccountParameters.
func (udlsap UpdateDataLakeStoreAccountParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if udlsap.Tags != nil {
		objectMap["tags"] = udlsap.Tags
	}
	if udlsap.UpdateDataLakeStoreAccountProperties != nil {
		objectMap["properties"] = udlsap.UpdateDataLakeStoreAccountProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for UpdateDataLakeStoreAccountParameters struct.
func (udlsap *UpdateDataLakeStoreAccountParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				udlsap.Tags = tags
			}
		case "properties":
			if v != nil {
				var updateDataLakeStoreAccountProperties UpdateDataLakeStoreAccountProperties
				err = json.Unmarshal(*v, &updateDataLakeStoreAccountProperties)
				if err != nil {
					return err
				}
				udlsap.UpdateDataLakeStoreAccountProperties = &updateDataLakeStoreAccountProperties
			}
		}
	}

	return nil
}

// UpdateDataLakeStoreAccountProperties data Lake Store account properties information to be updated.
type UpdateDataLakeStoreAccountProperties struct {
	// DefaultGroup - The default owner group for all new folders and files created in the Data Lake Store account.
	DefaultGroup *string `json:"defaultGroup,omitempty"`
	// EncryptionConfig - Used for rotation of user managed Key Vault keys. Can only be used to rotate a user managed encryption Key Vault key.
	EncryptionConfig *UpdateEncryptionConfig `json:"encryptionConfig,omitempty"`
	// FirewallRules - The list of firewall rules associated with this Data Lake Store account.
	FirewallRules *[]UpdateFirewallRuleWithAccountParameters `json:"firewallRules,omitempty"`
	// VirtualNetworkRules - The list of virtual network rules associated with this Data Lake Store account.
	VirtualNetworkRules *[]UpdateVirtualNetworkRuleWithAccountParameters `json:"virtualNetworkRules,omitempty"`
	// FirewallState - The current state of the IP address firewall for this Data Lake Store account. Disabling the firewall does not remove existing rules, they will just be ignored until the firewall is re-enabled. Possible values include: 'FirewallStateEnabled', 'FirewallStateDisabled'
	FirewallState FirewallState `json:"firewallState,omitempty"`
	// FirewallAllowAzureIps - The current state of allowing or disallowing IPs originating within Azure through the firewall. If the firewall is disabled, this is not enforced. Possible values include: 'FirewallAllowAzureIpsStateEnabled', 'FirewallAllowAzureIpsStateDisabled'
	FirewallAllowAzureIps FirewallAllowAzureIpsState `json:"firewallAllowAzureIps,omitempty"`
	// TrustedIDProviders - The list of trusted identity providers associated with this Data Lake Store account.
	TrustedIDProviders *[]UpdateTrustedIDProviderWithAccountParameters `json:"trustedIdProviders,omitempty"`
	// TrustedIDProviderState - The current state of the trusted identity provider feature for this Data Lake Store account. Disabling trusted identity provider functionality does not remove the providers, they will just be ignored until this feature is re-enabled. Possible values include: 'TrustedIDProviderStateEnabled', 'TrustedIDProviderStateDisabled'
	TrustedIDProviderState TrustedIDProviderState `json:"trustedIdProviderState,omitempty"`
	// NewTier - The commitment tier to use for next month. Possible values include: 'Consumption', 'Commitment1TB', 'Commitment10TB', 'Commitment100TB', 'Commitment500TB', 'Commitment1PB', 'Commitment5PB'
	NewTier TierType `json:"newTier,omitempty"`
}

// UpdateEncryptionConfig the encryption configuration used to update a user managed Key Vault key.
type UpdateEncryptionConfig struct {
	// KeyVaultMetaInfo - The updated Key Vault key to use in user managed key rotation.
	KeyVaultMetaInfo *UpdateKeyVaultMetaInfo `json:"keyVaultMetaInfo,omitempty"`
}

// UpdateFirewallRuleParameters the parameters used to update a firewall rule.
type UpdateFirewallRuleParameters struct {
	// UpdateFirewallRuleProperties - The firewall rule properties to use when updating a firewall rule.
	*UpdateFirewallRuleProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for UpdateFirewallRuleParameters.
func (ufrp UpdateFirewallRuleParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ufrp.UpdateFirewallRuleProperties != nil {
		objectMap["properties"] = ufrp.UpdateFirewallRuleProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for UpdateFirewallRuleParameters struct.
func (ufrp *UpdateFirewallRuleParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var updateFirewallRuleProperties UpdateFirewallRuleProperties
				err = json.Unmarshal(*v, &updateFirewallRuleProperties)
				if err != nil {
					return err
				}
				ufrp.UpdateFirewallRuleProperties = &updateFirewallRuleProperties
			}
		}
	}

	return nil
}

// UpdateFirewallRuleProperties the firewall rule properties to use when updating a firewall rule.
type UpdateFirewallRuleProperties struct {
	// StartIPAddress - The start IP address for the firewall rule. This can be either ipv4 or ipv6. Start and End should be in the same protocol.
	StartIPAddress *string `json:"startIpAddress,omitempty"`
	// EndIPAddress - The end IP address for the firewall rule. This can be either ipv4 or ipv6. Start and End should be in the same protocol.
	EndIPAddress *string `json:"endIpAddress,omitempty"`
}

// UpdateFirewallRuleWithAccountParameters the parameters used to update a firewall rule while updating a
// Data Lake Store account.
type UpdateFirewallRuleWithAccountParameters struct {
	// Name - The unique name of the firewall rule to update.
	Name *string `json:"name,omitempty"`
	// UpdateFirewallRuleProperties - The firewall rule properties to use when updating a firewall rule.
	*UpdateFirewallRuleProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for UpdateFirewallRuleWithAccountParameters.
func (ufrwap UpdateFirewallRuleWithAccountParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ufrwap.Name != nil {
		objectMap["name"] = ufrwap.Name
	}
	if ufrwap.UpdateFirewallRuleProperties != nil {
		objectMap["properties"] = ufrwap.UpdateFirewallRuleProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for UpdateFirewallRuleWithAccountParameters struct.
func (ufrwap *UpdateFirewallRuleWithAccountParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ufrwap.Name = &name
			}
		case "properties":
			if v != nil {
				var updateFirewallRuleProperties UpdateFirewallRuleProperties
				err = json.Unmarshal(*v, &updateFirewallRuleProperties)
				if err != nil {
					return err
				}
				ufrwap.UpdateFirewallRuleProperties = &updateFirewallRuleProperties
			}
		}
	}

	return nil
}

// UpdateKeyVaultMetaInfo the Key Vault update information used for user managed key rotation.
type UpdateKeyVaultMetaInfo struct {
	// EncryptionKeyVersion - The version of the user managed encryption key to update through a key rotation.
	EncryptionKeyVersion *string `json:"encryptionKeyVersion,omitempty"`
}

// UpdateTrustedIDProviderParameters the parameters used to update a trusted identity provider.
type UpdateTrustedIDProviderParameters struct {
	// UpdateTrustedIDProviderProperties - The trusted identity provider properties to use when updating a trusted identity provider.
	*UpdateTrustedIDProviderProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for UpdateTrustedIDProviderParameters.
func (utipp UpdateTrustedIDProviderParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if utipp.UpdateTrustedIDProviderProperties != nil {
		objectMap["properties"] = utipp.UpdateTrustedIDProviderProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for UpdateTrustedIDProviderParameters struct.
func (utipp *UpdateTrustedIDProviderParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var updateTrustedIDProviderProperties UpdateTrustedIDProviderProperties
				err = json.Unmarshal(*v, &updateTrustedIDProviderProperties)
				if err != nil {
					return err
				}
				utipp.UpdateTrustedIDProviderProperties = &updateTrustedIDProviderProperties
			}
		}
	}

	return nil
}

// UpdateTrustedIDProviderProperties the trusted identity provider properties to use when updating a
// trusted identity provider.
type UpdateTrustedIDProviderProperties struct {
	// IDProvider - The URL of this trusted identity provider.
	IDProvider *string `json:"idProvider,omitempty"`
}

// UpdateTrustedIDProviderWithAccountParameters the parameters used to update a trusted identity provider
// while updating a Data Lake Store account.
type UpdateTrustedIDProviderWithAccountParameters struct {
	// Name - The unique name of the trusted identity provider to update.
	Name *string `json:"name,omitempty"`
	// UpdateTrustedIDProviderProperties - The trusted identity provider properties to use when updating a trusted identity provider.
	*UpdateTrustedIDProviderProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for UpdateTrustedIDProviderWithAccountParameters.
func (utipwap UpdateTrustedIDProviderWithAccountParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if utipwap.Name != nil {
		objectMap["name"] = utipwap.Name
	}
	if utipwap.UpdateTrustedIDProviderProperties != nil {
		objectMap["properties"] = utipwap.UpdateTrustedIDProviderProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for UpdateTrustedIDProviderWithAccountParameters struct.
func (utipwap *UpdateTrustedIDProviderWithAccountParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				utipwap.Name = &name
			}
		case "properties":
			if v != nil {
				var updateTrustedIDProviderProperties UpdateTrustedIDProviderProperties
				err = json.Unmarshal(*v, &updateTrustedIDProviderProperties)
				if err != nil {
					return err
				}
				utipwap.UpdateTrustedIDProviderProperties = &updateTrustedIDProviderProperties
			}
		}
	}

	return nil
}

// UpdateVirtualNetworkRuleParameters the parameters used to update a virtual network rule.
type UpdateVirtualNetworkRuleParameters struct {
	// UpdateVirtualNetworkRuleProperties - The virtual network rule properties to use when updating a virtual network rule.
	*UpdateVirtualNetworkRuleProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for UpdateVirtualNetworkRuleParameters.
func (uvnrp UpdateVirtualNetworkRuleParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if uvnrp.UpdateVirtualNetworkRuleProperties != nil {
		objectMap["properties"] = uvnrp.UpdateVirtualNetworkRuleProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for UpdateVirtualNetworkRuleParameters struct.
func (uvnrp *UpdateVirtualNetworkRuleParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var updateVirtualNetworkRuleProperties UpdateVirtualNetworkRuleProperties
				err = json.Unmarshal(*v, &updateVirtualNetworkRuleProperties)
				if err != nil {
					return err
				}
				uvnrp.UpdateVirtualNetworkRuleProperties = &updateVirtualNetworkRuleProperties
			}
		}
	}

	return nil
}

// UpdateVirtualNetworkRuleProperties the virtual network rule properties to use when updating a virtual
// network rule.
type UpdateVirtualNetworkRuleProperties struct {
	// SubnetID - The resource identifier for the subnet.
	SubnetID *string `json:"subnetId,omitempty"`
}

// UpdateVirtualNetworkRuleWithAccountParameters the parameters used to update a virtual network rule while
// updating a Data Lake Store account.
type UpdateVirtualNetworkRuleWithAccountParameters struct {
	// Name - The unique name of the virtual network rule to update.
	Name *string `json:"name,omitempty"`
	// UpdateVirtualNetworkRuleProperties - The virtual network rule properties to use when updating a virtual network rule.
	*UpdateVirtualNetworkRuleProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for UpdateVirtualNetworkRuleWithAccountParameters.
func (uvnrwap UpdateVirtualNetworkRuleWithAccountParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if uvnrwap.Name != nil {
		objectMap["name"] = uvnrwap.Name
	}
	if uvnrwap.UpdateVirtualNetworkRuleProperties != nil {
		objectMap["properties"] = uvnrwap.UpdateVirtualNetworkRuleProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for UpdateVirtualNetworkRuleWithAccountParameters struct.
func (uvnrwap *UpdateVirtualNetworkRuleWithAccountParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				uvnrwap.Name = &name
			}
		case "properties":
			if v != nil {
				var updateVirtualNetworkRuleProperties UpdateVirtualNetworkRuleProperties
				err = json.Unmarshal(*v, &updateVirtualNetworkRuleProperties)
				if err != nil {
					return err
				}
				uvnrwap.UpdateVirtualNetworkRuleProperties = &updateVirtualNetworkRuleProperties
			}
		}
	}

	return nil
}

// Usage describes the Resource Usage.
type Usage struct {
	// Unit - READ-ONLY; Gets the unit of measurement. Possible values include: 'Count', 'Bytes', 'Seconds', 'Percent', 'CountsPerSecond', 'BytesPerSecond'
	Unit UsageUnit `json:"unit,omitempty"`
	// ID - READ-ONLY; Resource identifier.
	ID *string `json:"id,omitempty"`
	// CurrentValue - READ-ONLY; Gets the current count of the allocated resources in the subscription.
	CurrentValue *int32 `json:"currentValue,omitempty"`
	// Limit - READ-ONLY; Gets the maximum count of the resources that can be allocated in the subscription.
	Limit *int32 `json:"limit,omitempty"`
	// Name - READ-ONLY; Gets the name of the type of usage.
	Name *UsageName `json:"name,omitempty"`
}

// UsageListResult the response from the List Usages operation.
type UsageListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets the list of Storage Resource Usages.
	Value *[]Usage `json:"value,omitempty"`
}

// UsageName the usage names that can be used.
type UsageName struct {
	// Value - READ-ONLY; Gets a string describing the resource name.
	Value *string `json:"value,omitempty"`
	// LocalizedValue - READ-ONLY; Gets a localized string describing the resource name.
	LocalizedValue *string `json:"localizedValue,omitempty"`
}

// VirtualNetworkRule data Lake Store virtual network rule information.
type VirtualNetworkRule struct {
	autorest.Response `json:"-"`
	// VirtualNetworkRuleProperties - READ-ONLY; The virtual network rule properties.
	*VirtualNetworkRuleProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualNetworkRule.
func (vnr VirtualNetworkRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VirtualNetworkRule struct.
func (vnr *VirtualNetworkRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var virtualNetworkRuleProperties VirtualNetworkRuleProperties
				err = json.Unmarshal(*v, &virtualNetworkRuleProperties)
				if err != nil {
					return err
				}
				vnr.VirtualNetworkRuleProperties = &virtualNetworkRuleProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vnr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vnr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vnr.Type = &typeVar
			}
		}
	}

	return nil
}

// VirtualNetworkRuleListResult data Lake Store virtual network rule list information.
type VirtualNetworkRuleListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The results of the list operation.
	Value *[]VirtualNetworkRule `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// VirtualNetworkRuleListResultIterator provides access to a complete listing of VirtualNetworkRule values.
type VirtualNetworkRuleListResultIterator struct {
	i    int
	page VirtualNetworkRuleListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *VirtualNetworkRuleListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualNetworkRuleListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *VirtualNetworkRuleListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter VirtualNetworkRuleListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter VirtualNetworkRuleListResultIterator) Response() VirtualNetworkRuleListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter VirtualNetworkRuleListResultIterator) Value() VirtualNetworkRule {
	if !iter.page.NotDone() {
		return VirtualNetworkRule{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the VirtualNetworkRuleListResultIterator type.
func NewVirtualNetworkRuleListResultIterator(page VirtualNetworkRuleListResultPage) VirtualNetworkRuleListResultIterator {
	return VirtualNetworkRuleListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (vnrlr VirtualNetworkRuleListResult) IsEmpty() bool {
	return vnrlr.Value == nil || len(*vnrlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (vnrlr VirtualNetworkRuleListResult) hasNextLink() bool {
	return vnrlr.NextLink != nil && len(*vnrlr.NextLink) != 0
}

// virtualNetworkRuleListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (vnrlr VirtualNetworkRuleListResult) virtualNetworkRuleListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !vnrlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(vnrlr.NextLink)))
}

// VirtualNetworkRuleListResultPage contains a page of VirtualNetworkRule values.
type VirtualNetworkRuleListResultPage struct {
	fn    func(context.Context, VirtualNetworkRuleListResult) (VirtualNetworkRuleListResult, error)
	vnrlr VirtualNetworkRuleListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *VirtualNetworkRuleListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualNetworkRuleListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.vnrlr)
		if err != nil {
			return err
		}
		page.vnrlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *VirtualNetworkRuleListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page VirtualNetworkRuleListResultPage) NotDone() bool {
	return !page.vnrlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page VirtualNetworkRuleListResultPage) Response() VirtualNetworkRuleListResult {
	return page.vnrlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page VirtualNetworkRuleListResultPage) Values() []VirtualNetworkRule {
	if page.vnrlr.IsEmpty() {
		return nil
	}
	return *page.vnrlr.Value
}

// Creates a new instance of the VirtualNetworkRuleListResultPage type.
func NewVirtualNetworkRuleListResultPage(cur VirtualNetworkRuleListResult, getNextPage func(context.Context, VirtualNetworkRuleListResult) (VirtualNetworkRuleListResult, error)) VirtualNetworkRuleListResultPage {
	return VirtualNetworkRuleListResultPage{
		fn:    getNextPage,
		vnrlr: cur,
	}
}

// VirtualNetworkRuleProperties the virtual network rule properties.
type VirtualNetworkRuleProperties struct {
	// SubnetID - READ-ONLY; The resource identifier for the subnet.
	SubnetID *string `json:"subnetId,omitempty"`
}
