package kusto

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/kusto/mgmt/2019-05-15/kusto"

// AzureCapacity azure capacity definition.
type AzureCapacity struct {
	// ScaleType - Scale type. Possible values include: 'Automatic', 'Manual', 'None'
	ScaleType AzureScaleType `json:"scaleType,omitempty"`
	// Minimum - Minimum allowed capacity.
	Minimum *int32 `json:"minimum,omitempty"`
	// Maximum - Maximum allowed capacity.
	Maximum *int32 `json:"maximum,omitempty"`
	// Default - The default capacity that would be used.
	Default *int32 `json:"default,omitempty"`
}

// AzureEntityResource the resource model definition for an Azure Resource Manager resource with an etag.
type AzureEntityResource struct {
	// Etag - READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// AzureResourceSku azure resource SKU definition.
type AzureResourceSku struct {
	// ResourceType - Resource Namespace and Type.
	ResourceType *string `json:"resourceType,omitempty"`
	// Sku - The SKU details.
	Sku *AzureSku `json:"sku,omitempty"`
	// Capacity - The number of instances of the cluster.
	Capacity *AzureCapacity `json:"capacity,omitempty"`
}

// AzureSku azure SKU definition.
type AzureSku struct {
	// Name - SKU name. Possible values include: 'StandardDS13V21TBPS', 'StandardDS13V22TBPS', 'StandardDS14V23TBPS', 'StandardDS14V24TBPS', 'StandardD13V2', 'StandardD14V2', 'StandardL8s', 'StandardL16s', 'StandardD11V2', 'StandardD12V2', 'StandardL4s', 'DevNoSLAStandardD11V2'
	Name AzureSkuName `json:"name,omitempty"`
	// Capacity - The number of instances of the cluster.
	Capacity *int32 `json:"capacity,omitempty"`
	// Tier - SKU tier. Possible values include: 'Basic', 'Standard'
	Tier AzureSkuTier `json:"tier,omitempty"`
}

// CheckNameResult the result returned from a check name availability request.
type CheckNameResult struct {
	autorest.Response `json:"-"`
	// NameAvailable - Specifies a Boolean value that indicates if the name is available.
	NameAvailable *bool `json:"nameAvailable,omitempty"`
	// Name - The name that was checked.
	Name *string `json:"name,omitempty"`
	// Message - Message indicating an unavailable name due to a conflict, or a description of the naming rules that are violated.
	Message *string `json:"message,omitempty"`
	// Reason - Message providing the reason why the given name is invalid. Possible values include: 'Invalid', 'AlreadyExists'
	Reason Reason `json:"reason,omitempty"`
}

// CloudError an error response from Kusto.
type CloudError struct {
	// Error - An error response from Kusto.
	Error *CloudErrorBody `json:"error,omitempty"`
}

// CloudErrorBody an error response from Kusto.
type CloudErrorBody struct {
	// Code - An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
	Code *string `json:"code,omitempty"`
	// Message - A message describing the error, intended to be suitable for displaying in a user interface.
	Message *string `json:"message,omitempty"`
	// Target - The target of the particular error. For example, the name of the property in error.
	Target *string `json:"target,omitempty"`
	// Details - A list of additional details about the error.
	Details *[]CloudErrorBody `json:"details,omitempty"`
}

// Cluster class representing a Kusto cluster.
type Cluster struct {
	autorest.Response `json:"-"`
	// Sku - The SKU of the cluster.
	Sku *AzureSku `json:"sku,omitempty"`
	// Zones - The availability zones of the cluster.
	Zones *[]string `json:"zones,omitempty"`
	// ClusterProperties - The cluster properties.
	*ClusterProperties `json:"properties,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Cluster.
func (c Cluster) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if c.Sku != nil {
		objectMap["sku"] = c.Sku
	}
	if c.Zones != nil {
		objectMap["zones"] = c.Zones
	}
	if c.ClusterProperties != nil {
		objectMap["properties"] = c.ClusterProperties
	}
	if c.Tags != nil {
		objectMap["tags"] = c.Tags
	}
	if c.Location != nil {
		objectMap["location"] = c.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Cluster struct.
func (c *Cluster) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku AzureSku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				c.Sku = &sku
			}
		case "zones":
			if v != nil {
				var zones []string
				err = json.Unmarshal(*v, &zones)
				if err != nil {
					return err
				}
				c.Zones = &zones
			}
		case "properties":
			if v != nil {
				var clusterProperties ClusterProperties
				err = json.Unmarshal(*v, &clusterProperties)
				if err != nil {
					return err
				}
				c.ClusterProperties = &clusterProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				c.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				c.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				c.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				c.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				c.Type = &typeVar
			}
		}
	}

	return nil
}

// ClusterCheckNameRequest the result returned from a cluster check name availability request.
type ClusterCheckNameRequest struct {
	// Name - Cluster name.
	Name *string `json:"name,omitempty"`
	// Type - The type of resource, Microsoft.Kusto/clusters.
	Type *string `json:"type,omitempty"`
}

// ClusterListResult the list Kusto clusters operation response.
type ClusterListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of Kusto clusters.
	Value *[]Cluster `json:"value,omitempty"`
}

// ClusterProperties class representing the Kusto cluster properties.
type ClusterProperties struct {
	// State - READ-ONLY; The state of the resource. Possible values include: 'StateCreating', 'StateUnavailable', 'StateRunning', 'StateDeleting', 'StateDeleted', 'StateStopping', 'StateStopped', 'StateStarting', 'StateUpdating'
	State State `json:"state,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioned state of the resource. Possible values include: 'Running', 'Creating', 'Deleting', 'Succeeded', 'Failed', 'Moving'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// URI - READ-ONLY; The cluster URI.
	URI *string `json:"uri,omitempty"`
	// DataIngestionURI - READ-ONLY; The cluster data ingestion URI.
	DataIngestionURI *string `json:"dataIngestionUri,omitempty"`
	// TrustedExternalTenants - The cluster's external tenants.
	TrustedExternalTenants *[]TrustedExternalTenant `json:"trustedExternalTenants,omitempty"`
	// OptimizedAutoscale - Optimized auto scale definition.
	OptimizedAutoscale *OptimizedAutoscale `json:"optimizedAutoscale,omitempty"`
	// EnableDiskEncryption - A boolean value that indicates if the cluster's disks are encrypted.
	EnableDiskEncryption *bool `json:"enableDiskEncryption,omitempty"`
	// EnableStreamingIngest - A boolean value that indicates if the streaming ingest is enabled.
	EnableStreamingIngest *bool `json:"enableStreamingIngest,omitempty"`
	// VirtualNetworkConfiguration - Virtual network definition.
	VirtualNetworkConfiguration *VirtualNetworkConfiguration `json:"virtualNetworkConfiguration,omitempty"`
}

// MarshalJSON is the custom marshaler for ClusterProperties.
func (cp ClusterProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cp.TrustedExternalTenants != nil {
		objectMap["trustedExternalTenants"] = cp.TrustedExternalTenants
	}
	if cp.OptimizedAutoscale != nil {
		objectMap["optimizedAutoscale"] = cp.OptimizedAutoscale
	}
	if cp.EnableDiskEncryption != nil {
		objectMap["enableDiskEncryption"] = cp.EnableDiskEncryption
	}
	if cp.EnableStreamingIngest != nil {
		objectMap["enableStreamingIngest"] = cp.EnableStreamingIngest
	}
	if cp.VirtualNetworkConfiguration != nil {
		objectMap["virtualNetworkConfiguration"] = cp.VirtualNetworkConfiguration
	}
	return json.Marshal(objectMap)
}

// ClustersCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ClustersCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ClustersClient) (Cluster, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ClustersCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ClustersCreateOrUpdateFuture.Result.
func (future *ClustersCreateOrUpdateFuture) result(client ClustersClient) (c Cluster, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "kusto.ClustersCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("kusto.ClustersCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if c.Response.Response, err = future.GetResult(sender); err == nil && c.Response.Response.StatusCode != http.StatusNoContent {
		c, err = client.CreateOrUpdateResponder(c.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "kusto.ClustersCreateOrUpdateFuture", "Result", c.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ClustersDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ClustersDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ClustersClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ClustersDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ClustersDeleteFuture.Result.
func (future *ClustersDeleteFuture) result(client ClustersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "kusto.ClustersDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("kusto.ClustersDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ClustersStartFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ClustersStartFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ClustersClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ClustersStartFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ClustersStartFuture.Result.
func (future *ClustersStartFuture) result(client ClustersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "kusto.ClustersStartFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("kusto.ClustersStartFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ClustersStopFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type ClustersStopFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ClustersClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ClustersStopFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ClustersStopFuture.Result.
func (future *ClustersStopFuture) result(client ClustersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "kusto.ClustersStopFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("kusto.ClustersStopFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ClustersUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ClustersUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ClustersClient) (Cluster, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ClustersUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ClustersUpdateFuture.Result.
func (future *ClustersUpdateFuture) result(client ClustersClient) (c Cluster, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "kusto.ClustersUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("kusto.ClustersUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if c.Response.Response, err = future.GetResult(sender); err == nil && c.Response.Response.StatusCode != http.StatusNoContent {
		c, err = client.UpdateResponder(c.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "kusto.ClustersUpdateFuture", "Result", c.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ClusterUpdate class representing an update to a Kusto cluster.
type ClusterUpdate struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Sku - The SKU of the cluster.
	Sku *AzureSku `json:"sku,omitempty"`
	// ClusterProperties - The cluster properties.
	*ClusterProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ClusterUpdate.
func (cu ClusterUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cu.Tags != nil {
		objectMap["tags"] = cu.Tags
	}
	if cu.Location != nil {
		objectMap["location"] = cu.Location
	}
	if cu.Sku != nil {
		objectMap["sku"] = cu.Sku
	}
	if cu.ClusterProperties != nil {
		objectMap["properties"] = cu.ClusterProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ClusterUpdate struct.
func (cu *ClusterUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				cu.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				cu.Location = &location
			}
		case "sku":
			if v != nil {
				var sku AzureSku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				cu.Sku = &sku
			}
		case "properties":
			if v != nil {
				var clusterProperties ClusterProperties
				err = json.Unmarshal(*v, &clusterProperties)
				if err != nil {
					return err
				}
				cu.ClusterProperties = &clusterProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cu.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cu.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cu.Type = &typeVar
			}
		}
	}

	return nil
}

// Database class representing a Kusto database.
type Database struct {
	autorest.Response `json:"-"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// DatabaseProperties - The database properties.
	*DatabaseProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Database.
func (d Database) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if d.Location != nil {
		objectMap["location"] = d.Location
	}
	if d.DatabaseProperties != nil {
		objectMap["properties"] = d.DatabaseProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Database struct.
func (d *Database) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				d.Location = &location
			}
		case "properties":
			if v != nil {
				var databaseProperties DatabaseProperties
				err = json.Unmarshal(*v, &databaseProperties)
				if err != nil {
					return err
				}
				d.DatabaseProperties = &databaseProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				d.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				d.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				d.Type = &typeVar
			}
		}
	}

	return nil
}

// DatabaseCheckNameRequest the result returned from a database check name availability request.
type DatabaseCheckNameRequest struct {
	// Name - Database name.
	Name *string `json:"name,omitempty"`
	// Type - The type of resource, Microsoft.Kusto/clusters/databases.
	Type *string `json:"type,omitempty"`
}

// DatabaseListResult the list Kusto databases operation response.
type DatabaseListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of Kusto databases.
	Value *[]Database `json:"value,omitempty"`
}

// DatabasePrincipal a class representing database principal entity.
type DatabasePrincipal struct {
	// Role - Database principal role. Possible values include: 'Admin', 'Ingestor', 'Monitor', 'User', 'UnrestrictedViewers', 'Viewer'
	Role DatabasePrincipalRole `json:"role,omitempty"`
	// Name - Database principal name.
	Name *string `json:"name,omitempty"`
	// Type - Database principal type. Possible values include: 'DatabasePrincipalTypeApp', 'DatabasePrincipalTypeGroup', 'DatabasePrincipalTypeUser'
	Type DatabasePrincipalType `json:"type,omitempty"`
	// Fqn - Database principal fully qualified name.
	Fqn *string `json:"fqn,omitempty"`
	// Email - Database principal email if exists.
	Email *string `json:"email,omitempty"`
	// AppID - Application id - relevant only for application principal type.
	AppID *string `json:"appId,omitempty"`
	// TenantName - READ-ONLY; The tenant name of the principal
	TenantName *string `json:"tenantName,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabasePrincipal.
func (dp DatabasePrincipal) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dp.Role != "" {
		objectMap["role"] = dp.Role
	}
	if dp.Name != nil {
		objectMap["name"] = dp.Name
	}
	if dp.Type != "" {
		objectMap["type"] = dp.Type
	}
	if dp.Fqn != nil {
		objectMap["fqn"] = dp.Fqn
	}
	if dp.Email != nil {
		objectMap["email"] = dp.Email
	}
	if dp.AppID != nil {
		objectMap["appId"] = dp.AppID
	}
	return json.Marshal(objectMap)
}

// DatabasePrincipalListRequest the list Kusto database principals operation request.
type DatabasePrincipalListRequest struct {
	// Value - The list of Kusto database principals.
	Value *[]DatabasePrincipal `json:"value,omitempty"`
}

// DatabasePrincipalListResult the list Kusto database principals operation response.
type DatabasePrincipalListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of Kusto database principals.
	Value *[]DatabasePrincipal `json:"value,omitempty"`
}

// DatabaseProperties class representing the Kusto database properties.
type DatabaseProperties struct {
	// ProvisioningState - READ-ONLY; The provisioned state of the resource. Possible values include: 'Running', 'Creating', 'Deleting', 'Succeeded', 'Failed', 'Moving'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// SoftDeletePeriod - The time the data should be kept before it stops being accessible to queries in TimeSpan.
	SoftDeletePeriod *string `json:"softDeletePeriod,omitempty"`
	// HotCachePeriod - The time the data should be kept in cache for fast queries in TimeSpan.
	HotCachePeriod *string `json:"hotCachePeriod,omitempty"`
	// Statistics - The statistics of the database.
	Statistics *DatabaseStatistics `json:"statistics,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseProperties.
func (dp DatabaseProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dp.SoftDeletePeriod != nil {
		objectMap["softDeletePeriod"] = dp.SoftDeletePeriod
	}
	if dp.HotCachePeriod != nil {
		objectMap["hotCachePeriod"] = dp.HotCachePeriod
	}
	if dp.Statistics != nil {
		objectMap["statistics"] = dp.Statistics
	}
	return json.Marshal(objectMap)
}

// DatabasesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DatabasesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DatabasesClient) (Database, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DatabasesCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DatabasesCreateOrUpdateFuture.Result.
func (future *DatabasesCreateOrUpdateFuture) result(client DatabasesClient) (d Database, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "kusto.DatabasesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("kusto.DatabasesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if d.Response.Response, err = future.GetResult(sender); err == nil && d.Response.Response.StatusCode != http.StatusNoContent {
		d, err = client.CreateOrUpdateResponder(d.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "kusto.DatabasesCreateOrUpdateFuture", "Result", d.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DatabasesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DatabasesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DatabasesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DatabasesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DatabasesDeleteFuture.Result.
func (future *DatabasesDeleteFuture) result(client DatabasesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "kusto.DatabasesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("kusto.DatabasesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DatabaseStatistics a class that contains database statistics information.
type DatabaseStatistics struct {
	// Size - The database size - the total size of compressed data and index in bytes.
	Size *float64 `json:"size,omitempty"`
}

// DatabasesUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DatabasesUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DatabasesClient) (Database, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DatabasesUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DatabasesUpdateFuture.Result.
func (future *DatabasesUpdateFuture) result(client DatabasesClient) (d Database, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "kusto.DatabasesUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("kusto.DatabasesUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if d.Response.Response, err = future.GetResult(sender); err == nil && d.Response.Response.StatusCode != http.StatusNoContent {
		d, err = client.UpdateResponder(d.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "kusto.DatabasesUpdateFuture", "Result", d.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DatabaseUpdate class representing an update to a Kusto database.
type DatabaseUpdate struct {
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// DatabaseProperties - The properties of the updated database.
	*DatabaseProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseUpdate.
func (du DatabaseUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if du.Location != nil {
		objectMap["location"] = du.Location
	}
	if du.DatabaseProperties != nil {
		objectMap["properties"] = du.DatabaseProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DatabaseUpdate struct.
func (du *DatabaseUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				du.Location = &location
			}
		case "properties":
			if v != nil {
				var databaseProperties DatabaseProperties
				err = json.Unmarshal(*v, &databaseProperties)
				if err != nil {
					return err
				}
				du.DatabaseProperties = &databaseProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				du.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				du.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				du.Type = &typeVar
			}
		}
	}

	return nil
}

// BasicDataConnection class representing an data connection.
type BasicDataConnection interface {
	AsEventHubDataConnection() (*EventHubDataConnection, bool)
	AsIotHubDataConnection() (*IotHubDataConnection, bool)
	AsEventGridDataConnection() (*EventGridDataConnection, bool)
	AsDataConnection() (*DataConnection, bool)
}

// DataConnection class representing an data connection.
type DataConnection struct {
	autorest.Response `json:"-"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Kind - Possible values include: 'KindDataConnection', 'KindEventHub', 'KindIotHub', 'KindEventGrid'
	Kind Kind `json:"kind,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

func unmarshalBasicDataConnection(body []byte) (BasicDataConnection, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["kind"] {
	case string(KindEventHub):
		var ehdc EventHubDataConnection
		err := json.Unmarshal(body, &ehdc)
		return ehdc, err
	case string(KindIotHub):
		var ihdc IotHubDataConnection
		err := json.Unmarshal(body, &ihdc)
		return ihdc, err
	case string(KindEventGrid):
		var egdc EventGridDataConnection
		err := json.Unmarshal(body, &egdc)
		return egdc, err
	default:
		var dc DataConnection
		err := json.Unmarshal(body, &dc)
		return dc, err
	}
}
func unmarshalBasicDataConnectionArray(body []byte) ([]BasicDataConnection, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	dcArray := make([]BasicDataConnection, len(rawMessages))

	for index, rawMessage := range rawMessages {
		dc, err := unmarshalBasicDataConnection(*rawMessage)
		if err != nil {
			return nil, err
		}
		dcArray[index] = dc
	}
	return dcArray, nil
}

// MarshalJSON is the custom marshaler for DataConnection.
func (dc DataConnection) MarshalJSON() ([]byte, error) {
	dc.Kind = KindDataConnection
	objectMap := make(map[string]interface{})
	if dc.Location != nil {
		objectMap["location"] = dc.Location
	}
	if dc.Kind != "" {
		objectMap["kind"] = dc.Kind
	}
	return json.Marshal(objectMap)
}

// AsEventHubDataConnection is the BasicDataConnection implementation for DataConnection.
func (dc DataConnection) AsEventHubDataConnection() (*EventHubDataConnection, bool) {
	return nil, false
}

// AsIotHubDataConnection is the BasicDataConnection implementation for DataConnection.
func (dc DataConnection) AsIotHubDataConnection() (*IotHubDataConnection, bool) {
	return nil, false
}

// AsEventGridDataConnection is the BasicDataConnection implementation for DataConnection.
func (dc DataConnection) AsEventGridDataConnection() (*EventGridDataConnection, bool) {
	return nil, false
}

// AsDataConnection is the BasicDataConnection implementation for DataConnection.
func (dc DataConnection) AsDataConnection() (*DataConnection, bool) {
	return &dc, true
}

// AsBasicDataConnection is the BasicDataConnection implementation for DataConnection.
func (dc DataConnection) AsBasicDataConnection() (BasicDataConnection, bool) {
	return &dc, true
}

// DataConnectionCheckNameRequest the result returned from a data connections check name availability
// request.
type DataConnectionCheckNameRequest struct {
	// Name - Data Connection name.
	Name *string `json:"name,omitempty"`
	// Type - The type of resource, Microsoft.Kusto/clusters/databases/dataConnections.
	Type *string `json:"type,omitempty"`
}

// DataConnectionListResult the list Kusto data connections operation response.
type DataConnectionListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of Kusto data connections.
	Value *[]BasicDataConnection `json:"value,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for DataConnectionListResult struct.
func (dclr *DataConnectionListResult) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "value":
			if v != nil {
				value, err := unmarshalBasicDataConnectionArray(*v)
				if err != nil {
					return err
				}
				dclr.Value = &value
			}
		}
	}

	return nil
}

// DataConnectionModel ...
type DataConnectionModel struct {
	autorest.Response `json:"-"`
	Value             BasicDataConnection `json:"value,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for DataConnectionModel struct.
func (dcm *DataConnectionModel) UnmarshalJSON(body []byte) error {
	dc, err := unmarshalBasicDataConnection(body)
	if err != nil {
		return err
	}
	dcm.Value = dc

	return nil
}

// DataConnectionsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DataConnectionsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DataConnectionsClient) (DataConnectionModel, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DataConnectionsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DataConnectionsCreateOrUpdateFuture.Result.
func (future *DataConnectionsCreateOrUpdateFuture) result(client DataConnectionsClient) (dcm DataConnectionModel, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "kusto.DataConnectionsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("kusto.DataConnectionsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if dcm.Response.Response, err = future.GetResult(sender); err == nil && dcm.Response.Response.StatusCode != http.StatusNoContent {
		dcm, err = client.CreateOrUpdateResponder(dcm.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "kusto.DataConnectionsCreateOrUpdateFuture", "Result", dcm.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DataConnectionsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DataConnectionsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DataConnectionsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DataConnectionsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DataConnectionsDeleteFuture.Result.
func (future *DataConnectionsDeleteFuture) result(client DataConnectionsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "kusto.DataConnectionsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("kusto.DataConnectionsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DataConnectionsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DataConnectionsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DataConnectionsClient) (DataConnectionModel, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DataConnectionsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DataConnectionsUpdateFuture.Result.
func (future *DataConnectionsUpdateFuture) result(client DataConnectionsClient) (dcm DataConnectionModel, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "kusto.DataConnectionsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("kusto.DataConnectionsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if dcm.Response.Response, err = future.GetResult(sender); err == nil && dcm.Response.Response.StatusCode != http.StatusNoContent {
		dcm, err = client.UpdateResponder(dcm.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "kusto.DataConnectionsUpdateFuture", "Result", dcm.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DataConnectionValidation class representing an data connection validation.
type DataConnectionValidation struct {
	// DataConnectionName - The name of the data connection.
	DataConnectionName *string `json:"dataConnectionName,omitempty"`
	// Properties - The data connection properties to validate.
	Properties BasicDataConnection `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for DataConnectionValidation struct.
func (dcv *DataConnectionValidation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "dataConnectionName":
			if v != nil {
				var dataConnectionName string
				err = json.Unmarshal(*v, &dataConnectionName)
				if err != nil {
					return err
				}
				dcv.DataConnectionName = &dataConnectionName
			}
		case "properties":
			if v != nil {
				properties, err := unmarshalBasicDataConnection(*v)
				if err != nil {
					return err
				}
				dcv.Properties = properties
			}
		}
	}

	return nil
}

// DataConnectionValidationListResult the list Kusto data connection validation result.
type DataConnectionValidationListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of Kusto data connection validation errors.
	Value *[]DataConnectionValidationResult `json:"value,omitempty"`
}

// DataConnectionValidationResult the result returned from a data connection validation request.
type DataConnectionValidationResult struct {
	// ErrorMessage - A message which indicates a problem in data connection validation.
	ErrorMessage *string `json:"errorMessage,omitempty"`
}

// EventGridConnectionProperties class representing the Kusto event grid connection properties.
type EventGridConnectionProperties struct {
	// StorageAccountResourceID - The resource ID of the storage account where the data resides.
	StorageAccountResourceID *string `json:"storageAccountResourceId,omitempty"`
	// EventHubResourceID - The resource ID where the event grid is configured to send events.
	EventHubResourceID *string `json:"eventHubResourceId,omitempty"`
	// ConsumerGroup - The event hub consumer group.
	ConsumerGroup *string `json:"consumerGroup,omitempty"`
	// TableName - The table where the data should be ingested. Optionally the table information can be added to each message.
	TableName *string `json:"tableName,omitempty"`
	// MappingRuleName - The mapping rule to be used to ingest the data. Optionally the mapping information can be added to each message.
	MappingRuleName *string `json:"mappingRuleName,omitempty"`
	// DataFormat - The data format of the message. Optionally the data format can be added to each message. Possible values include: 'MULTIJSON', 'JSON', 'CSV', 'TSV', 'SCSV', 'SOHSV', 'PSV', 'TXT', 'RAW', 'SINGLEJSON', 'AVRO', 'TSVE'
	DataFormat DataFormat `json:"dataFormat,omitempty"`
}

// EventGridDataConnection class representing an Event Grid data connection.
type EventGridDataConnection struct {
	// EventGridConnectionProperties - The properties of the Event Grid data connection.
	*EventGridConnectionProperties `json:"properties,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Kind - Possible values include: 'KindDataConnection', 'KindEventHub', 'KindIotHub', 'KindEventGrid'
	Kind Kind `json:"kind,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for EventGridDataConnection.
func (egdc EventGridDataConnection) MarshalJSON() ([]byte, error) {
	egdc.Kind = KindEventGrid
	objectMap := make(map[string]interface{})
	if egdc.EventGridConnectionProperties != nil {
		objectMap["properties"] = egdc.EventGridConnectionProperties
	}
	if egdc.Location != nil {
		objectMap["location"] = egdc.Location
	}
	if egdc.Kind != "" {
		objectMap["kind"] = egdc.Kind
	}
	return json.Marshal(objectMap)
}

// AsEventHubDataConnection is the BasicDataConnection implementation for EventGridDataConnection.
func (egdc EventGridDataConnection) AsEventHubDataConnection() (*EventHubDataConnection, bool) {
	return nil, false
}

// AsIotHubDataConnection is the BasicDataConnection implementation for EventGridDataConnection.
func (egdc EventGridDataConnection) AsIotHubDataConnection() (*IotHubDataConnection, bool) {
	return nil, false
}

// AsEventGridDataConnection is the BasicDataConnection implementation for EventGridDataConnection.
func (egdc EventGridDataConnection) AsEventGridDataConnection() (*EventGridDataConnection, bool) {
	return &egdc, true
}

// AsDataConnection is the BasicDataConnection implementation for EventGridDataConnection.
func (egdc EventGridDataConnection) AsDataConnection() (*DataConnection, bool) {
	return nil, false
}

// AsBasicDataConnection is the BasicDataConnection implementation for EventGridDataConnection.
func (egdc EventGridDataConnection) AsBasicDataConnection() (BasicDataConnection, bool) {
	return &egdc, true
}

// UnmarshalJSON is the custom unmarshaler for EventGridDataConnection struct.
func (egdc *EventGridDataConnection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var eventGridConnectionProperties EventGridConnectionProperties
				err = json.Unmarshal(*v, &eventGridConnectionProperties)
				if err != nil {
					return err
				}
				egdc.EventGridConnectionProperties = &eventGridConnectionProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				egdc.Location = &location
			}
		case "kind":
			if v != nil {
				var kind Kind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				egdc.Kind = kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				egdc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				egdc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				egdc.Type = &typeVar
			}
		}
	}

	return nil
}

// EventHubConnectionProperties class representing the Kusto event hub connection properties.
type EventHubConnectionProperties struct {
	// EventHubResourceID - The resource ID of the event hub to be used to create a data connection.
	EventHubResourceID *string `json:"eventHubResourceId,omitempty"`
	// ConsumerGroup - The event hub consumer group.
	ConsumerGroup *string `json:"consumerGroup,omitempty"`
	// TableName - The table where the data should be ingested. Optionally the table information can be added to each message.
	TableName *string `json:"tableName,omitempty"`
	// MappingRuleName - The mapping rule to be used to ingest the data. Optionally the mapping information can be added to each message.
	MappingRuleName *string `json:"mappingRuleName,omitempty"`
	// DataFormat - The data format of the message. Optionally the data format can be added to each message. Possible values include: 'MULTIJSON', 'JSON', 'CSV', 'TSV', 'SCSV', 'SOHSV', 'PSV', 'TXT', 'RAW', 'SINGLEJSON', 'AVRO', 'TSVE'
	DataFormat DataFormat `json:"dataFormat,omitempty"`
	// EventSystemProperties - System properties of the event hub
	EventSystemProperties *[]string `json:"eventSystemProperties,omitempty"`
}

// EventHubDataConnection class representing an event hub data connection.
type EventHubDataConnection struct {
	// EventHubConnectionProperties - The Event Hub data connection properties to validate.
	*EventHubConnectionProperties `json:"properties,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Kind - Possible values include: 'KindDataConnection', 'KindEventHub', 'KindIotHub', 'KindEventGrid'
	Kind Kind `json:"kind,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for EventHubDataConnection.
func (ehdc EventHubDataConnection) MarshalJSON() ([]byte, error) {
	ehdc.Kind = KindEventHub
	objectMap := make(map[string]interface{})
	if ehdc.EventHubConnectionProperties != nil {
		objectMap["properties"] = ehdc.EventHubConnectionProperties
	}
	if ehdc.Location != nil {
		objectMap["location"] = ehdc.Location
	}
	if ehdc.Kind != "" {
		objectMap["kind"] = ehdc.Kind
	}
	return json.Marshal(objectMap)
}

// AsEventHubDataConnection is the BasicDataConnection implementation for EventHubDataConnection.
func (ehdc EventHubDataConnection) AsEventHubDataConnection() (*EventHubDataConnection, bool) {
	return &ehdc, true
}

// AsIotHubDataConnection is the BasicDataConnection implementation for EventHubDataConnection.
func (ehdc EventHubDataConnection) AsIotHubDataConnection() (*IotHubDataConnection, bool) {
	return nil, false
}

// AsEventGridDataConnection is the BasicDataConnection implementation for EventHubDataConnection.
func (ehdc EventHubDataConnection) AsEventGridDataConnection() (*EventGridDataConnection, bool) {
	return nil, false
}

// AsDataConnection is the BasicDataConnection implementation for EventHubDataConnection.
func (ehdc EventHubDataConnection) AsDataConnection() (*DataConnection, bool) {
	return nil, false
}

// AsBasicDataConnection is the BasicDataConnection implementation for EventHubDataConnection.
func (ehdc EventHubDataConnection) AsBasicDataConnection() (BasicDataConnection, bool) {
	return &ehdc, true
}

// UnmarshalJSON is the custom unmarshaler for EventHubDataConnection struct.
func (ehdc *EventHubDataConnection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var eventHubConnectionProperties EventHubConnectionProperties
				err = json.Unmarshal(*v, &eventHubConnectionProperties)
				if err != nil {
					return err
				}
				ehdc.EventHubConnectionProperties = &eventHubConnectionProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ehdc.Location = &location
			}
		case "kind":
			if v != nil {
				var kind Kind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ehdc.Kind = kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ehdc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ehdc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ehdc.Type = &typeVar
			}
		}
	}

	return nil
}

// IotHubConnectionProperties class representing the Kusto iot hub connection properties.
type IotHubConnectionProperties struct {
	// IotHubResourceID - The resource ID of the Iot hub to be used to create a data connection.
	IotHubResourceID *string `json:"iotHubResourceId,omitempty"`
	// ConsumerGroup - The iot hub consumer group.
	ConsumerGroup *string `json:"consumerGroup,omitempty"`
	// TableName - The table where the data should be ingested. Optionally the table information can be added to each message.
	TableName *string `json:"tableName,omitempty"`
	// MappingRuleName - The mapping rule to be used to ingest the data. Optionally the mapping information can be added to each message.
	MappingRuleName *string `json:"mappingRuleName,omitempty"`
	// DataFormat - The data format of the message. Optionally the data format can be added to each message. Possible values include: 'MULTIJSON', 'JSON', 'CSV', 'TSV', 'SCSV', 'SOHSV', 'PSV', 'TXT', 'RAW', 'SINGLEJSON', 'AVRO', 'TSVE'
	DataFormat DataFormat `json:"dataFormat,omitempty"`
	// EventSystemProperties - System properties of the iot hub
	EventSystemProperties *[]string `json:"eventSystemProperties,omitempty"`
	// SharedAccessPolicyName - The name of the share access policy name
	SharedAccessPolicyName *string `json:"sharedAccessPolicyName,omitempty"`
}

// IotHubDataConnection class representing an iot hub data connection.
type IotHubDataConnection struct {
	// IotHubConnectionProperties - The Iot Hub data connection properties.
	*IotHubConnectionProperties `json:"properties,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Kind - Possible values include: 'KindDataConnection', 'KindEventHub', 'KindIotHub', 'KindEventGrid'
	Kind Kind `json:"kind,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for IotHubDataConnection.
func (ihdc IotHubDataConnection) MarshalJSON() ([]byte, error) {
	ihdc.Kind = KindIotHub
	objectMap := make(map[string]interface{})
	if ihdc.IotHubConnectionProperties != nil {
		objectMap["properties"] = ihdc.IotHubConnectionProperties
	}
	if ihdc.Location != nil {
		objectMap["location"] = ihdc.Location
	}
	if ihdc.Kind != "" {
		objectMap["kind"] = ihdc.Kind
	}
	return json.Marshal(objectMap)
}

// AsEventHubDataConnection is the BasicDataConnection implementation for IotHubDataConnection.
func (ihdc IotHubDataConnection) AsEventHubDataConnection() (*EventHubDataConnection, bool) {
	return nil, false
}

// AsIotHubDataConnection is the BasicDataConnection implementation for IotHubDataConnection.
func (ihdc IotHubDataConnection) AsIotHubDataConnection() (*IotHubDataConnection, bool) {
	return &ihdc, true
}

// AsEventGridDataConnection is the BasicDataConnection implementation for IotHubDataConnection.
func (ihdc IotHubDataConnection) AsEventGridDataConnection() (*EventGridDataConnection, bool) {
	return nil, false
}

// AsDataConnection is the BasicDataConnection implementation for IotHubDataConnection.
func (ihdc IotHubDataConnection) AsDataConnection() (*DataConnection, bool) {
	return nil, false
}

// AsBasicDataConnection is the BasicDataConnection implementation for IotHubDataConnection.
func (ihdc IotHubDataConnection) AsBasicDataConnection() (BasicDataConnection, bool) {
	return &ihdc, true
}

// UnmarshalJSON is the custom unmarshaler for IotHubDataConnection struct.
func (ihdc *IotHubDataConnection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var iotHubConnectionProperties IotHubConnectionProperties
				err = json.Unmarshal(*v, &iotHubConnectionProperties)
				if err != nil {
					return err
				}
				ihdc.IotHubConnectionProperties = &iotHubConnectionProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ihdc.Location = &location
			}
		case "kind":
			if v != nil {
				var kind Kind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ihdc.Kind = kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ihdc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ihdc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ihdc.Type = &typeVar
			}
		}
	}

	return nil
}

// ListResourceSkusResult list of available SKUs for a Kusto Cluster.
type ListResourceSkusResult struct {
	autorest.Response `json:"-"`
	// Value - The collection of available SKUs for an existing resource.
	Value *[]AzureResourceSku `json:"value,omitempty"`
}

// Operation ...
type Operation struct {
	// Name - This is of the format {provider}/{resource}/{operation}.
	Name       *string           `json:"name,omitempty"`
	Display    *OperationDisplay `json:"display,omitempty"`
	Origin     *string           `json:"origin,omitempty"`
	Properties interface{}       `json:"properties,omitempty"`
}

// OperationDisplay ...
type OperationDisplay struct {
	Provider *string `json:"provider,omitempty"`
	// Operation - For example: read, write, delete.
	Operation   *string `json:"operation,omitempty"`
	Resource    *string `json:"resource,omitempty"`
	Description *string `json:"description,omitempty"`
}

// OperationListResult ...
type OperationListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Operation `json:"value,omitempty"`
	NextLink          *string      `json:"nextLink,omitempty"`
}

// OperationListResultIterator provides access to a complete listing of Operation values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListResultIterator type.
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return OperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (olr OperationListResult) hasNextLink() bool {
	return olr.NextLink != nil && len(*olr.NextLink) != 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !olr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of Operation values.
type OperationListResultPage struct {
	fn  func(context.Context, OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.olr)
		if err != nil {
			return err
		}
		page.olr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []Operation {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OperationListResultPage type.
func NewOperationListResultPage(cur OperationListResult, getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return OperationListResultPage{
		fn:  getNextPage,
		olr: cur,
	}
}

// OptimizedAutoscale a class that contains the optimized auto scale definition.
type OptimizedAutoscale struct {
	// Version - The version of the template defined, for instance 1.
	Version *int32 `json:"version,omitempty"`
	// IsEnabled - A boolean value that indicate if the optimized autoscale feature is enabled or not.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// Minimum - Minimum allowed instances count.
	Minimum *int32 `json:"minimum,omitempty"`
	// Maximum - Maximum allowed instances count.
	Maximum *int32 `json:"maximum,omitempty"`
}

// ProxyResource the resource model definition for a Azure Resource Manager proxy resource. It will not
// have tags and a location
type ProxyResource struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// Resource common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// SkuDescription the Kusto SKU description of given resource type
type SkuDescription struct {
	// ResourceType - READ-ONLY; The resource type
	ResourceType *string `json:"resourceType,omitempty"`
	// Name - READ-ONLY; The name of the SKU
	Name *string `json:"name,omitempty"`
	// Tier - READ-ONLY; The tier of the SKU
	Tier *string `json:"tier,omitempty"`
	// Locations - READ-ONLY; The set of locations that the SKU is available
	Locations *[]string `json:"locations,omitempty"`
	// LocationInfo - READ-ONLY; Locations and zones
	LocationInfo *[]SkuLocationInfoItem `json:"locationInfo,omitempty"`
	// Restrictions - READ-ONLY; The restrictions because of which SKU cannot be used
	Restrictions *[]interface{} `json:"restrictions,omitempty"`
}

// SkuDescriptionList the list of the EngagementFabric SKU descriptions
type SkuDescriptionList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; SKU descriptions
	Value *[]SkuDescription `json:"value,omitempty"`
}

// SkuLocationInfoItem the locations and zones info for SKU.
type SkuLocationInfoItem struct {
	// Location - The available location of the SKU.
	Location *string `json:"location,omitempty"`
	// Zones - The available zone of the SKU.
	Zones *[]string `json:"zones,omitempty"`
}

// TrackedResource the resource model definition for an Azure Resource Manager tracked top level resource
// which has 'tags' and a 'location'
type TrackedResource struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	return json.Marshal(objectMap)
}

// TrustedExternalTenant represents a tenant ID that is trusted by the cluster.
type TrustedExternalTenant struct {
	// Value - GUID representing an external tenant.
	Value *string `json:"value,omitempty"`
}

// VirtualNetworkConfiguration a class that contains virtual network definition.
type VirtualNetworkConfiguration struct {
	// SubnetID - The subnet resource id.
	SubnetID *string `json:"subnetId,omitempty"`
	// EnginePublicIPID - Engine service's public IP address resource id.
	EnginePublicIPID *string `json:"enginePublicIpId,omitempty"`
	// DataManagementPublicIPID - Data management's service public IP address resource id.
	DataManagementPublicIPID *string `json:"dataManagementPublicIpId,omitempty"`
}
