package servicefabricmesh

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// ApplicationScopedVolumeKind enumerates the values for application scoped volume kind.
type ApplicationScopedVolumeKind string

const (
	// ServiceFabricVolumeDisk Provides Service Fabric High Availability Volume Disk
	ServiceFabricVolumeDisk ApplicationScopedVolumeKind = "ServiceFabricVolumeDisk"
)

// PossibleApplicationScopedVolumeKindValues returns an array of possible values for the ApplicationScopedVolumeKind const type.
func PossibleApplicationScopedVolumeKindValues() []ApplicationScopedVolumeKind {
	return []ApplicationScopedVolumeKind{ServiceFabricVolumeDisk}
}

// AutoScalingMechanismKind enumerates the values for auto scaling mechanism kind.
type AutoScalingMechanismKind string

const (
	// AddRemoveReplica Indicates that scaling should be performed by adding or removing replicas.
	AddRemoveReplica AutoScalingMechanismKind = "AddRemoveReplica"
)

// PossibleAutoScalingMechanismKindValues returns an array of possible values for the AutoScalingMechanismKind const type.
func PossibleAutoScalingMechanismKindValues() []AutoScalingMechanismKind {
	return []AutoScalingMechanismKind{AddRemoveReplica}
}

// AutoScalingMetricKind enumerates the values for auto scaling metric kind.
type AutoScalingMetricKind string

const (
	// AutoScalingMetricKindResource Indicates that the metric is one of resources, like cpu or memory.
	AutoScalingMetricKindResource AutoScalingMetricKind = "Resource"
)

// PossibleAutoScalingMetricKindValues returns an array of possible values for the AutoScalingMetricKind const type.
func PossibleAutoScalingMetricKindValues() []AutoScalingMetricKind {
	return []AutoScalingMetricKind{AutoScalingMetricKindResource}
}

// AutoScalingResourceMetricName enumerates the values for auto scaling resource metric name.
type AutoScalingResourceMetricName string

const (
	// CPU Indicates that the resource is CPU cores.
	CPU AutoScalingResourceMetricName = "cpu"
	// MemoryInGB Indicates that the resource is memory in GB.
	MemoryInGB AutoScalingResourceMetricName = "memoryInGB"
)

// PossibleAutoScalingResourceMetricNameValues returns an array of possible values for the AutoScalingResourceMetricName const type.
func PossibleAutoScalingResourceMetricNameValues() []AutoScalingResourceMetricName {
	return []AutoScalingResourceMetricName{CPU, MemoryInGB}
}

// AutoScalingTriggerKind enumerates the values for auto scaling trigger kind.
type AutoScalingTriggerKind string

const (
	// AverageLoad Indicates that scaling should be performed based on average load of all replicas in the
	// service.
	AverageLoad AutoScalingTriggerKind = "AverageLoad"
)

// PossibleAutoScalingTriggerKindValues returns an array of possible values for the AutoScalingTriggerKind const type.
func PossibleAutoScalingTriggerKindValues() []AutoScalingTriggerKind {
	return []AutoScalingTriggerKind{AverageLoad}
}

// DiagnosticsSinkKind enumerates the values for diagnostics sink kind.
type DiagnosticsSinkKind string

const (
	// AzureInternalMonitoringPipeline Diagnostics settings for Geneva.
	AzureInternalMonitoringPipeline DiagnosticsSinkKind = "AzureInternalMonitoringPipeline"
	// Invalid Indicates an invalid sink kind. All Service Fabric enumerations have the invalid type.
	Invalid DiagnosticsSinkKind = "Invalid"
)

// PossibleDiagnosticsSinkKindValues returns an array of possible values for the DiagnosticsSinkKind const type.
func PossibleDiagnosticsSinkKindValues() []DiagnosticsSinkKind {
	return []DiagnosticsSinkKind{AzureInternalMonitoringPipeline, Invalid}
}

// HeaderMatchType enumerates the values for header match type.
type HeaderMatchType string

const (
	// Exact ...
	Exact HeaderMatchType = "exact"
)

// PossibleHeaderMatchTypeValues returns an array of possible values for the HeaderMatchType const type.
func PossibleHeaderMatchTypeValues() []HeaderMatchType {
	return []HeaderMatchType{Exact}
}

// HealthState enumerates the values for health state.
type HealthState string

const (
	// HealthStateError Indicates the health state is at an error level. Error health state should be
	// investigated, as they can impact the correct functionality of the cluster. The value is 3.
	HealthStateError HealthState = "Error"
	// HealthStateInvalid Indicates an invalid health state. All Service Fabric enumerations have the invalid
	// type. The value is zero.
	HealthStateInvalid HealthState = "Invalid"
	// HealthStateOk Indicates the health state is okay. The value is 1.
	HealthStateOk HealthState = "Ok"
	// HealthStateUnknown Indicates an unknown health status. The value is 65535.
	HealthStateUnknown HealthState = "Unknown"
	// HealthStateWarning Indicates the health state is at a warning level. The value is 2.
	HealthStateWarning HealthState = "Warning"
)

// PossibleHealthStateValues returns an array of possible values for the HealthState const type.
func PossibleHealthStateValues() []HealthState {
	return []HealthState{HealthStateError, HealthStateInvalid, HealthStateOk, HealthStateUnknown, HealthStateWarning}
}

// Kind enumerates the values for kind.
type Kind string

const (
	// KindInlinedValue ...
	KindInlinedValue Kind = "inlinedValue"
	// KindSecretResourceProperties ...
	KindSecretResourceProperties Kind = "SecretResourceProperties"
	// KindSecretResourcePropertiesBase ...
	KindSecretResourcePropertiesBase Kind = "SecretResourcePropertiesBase"
)

// PossibleKindValues returns an array of possible values for the Kind const type.
func PossibleKindValues() []Kind {
	return []Kind{KindInlinedValue, KindSecretResourceProperties, KindSecretResourcePropertiesBase}
}

// KindBasicApplicationScopedVolumeCreationParameters enumerates the values for kind basic application scoped
// volume creation parameters.
type KindBasicApplicationScopedVolumeCreationParameters string

const (
	// KindApplicationScopedVolumeCreationParameters ...
	KindApplicationScopedVolumeCreationParameters KindBasicApplicationScopedVolumeCreationParameters = "ApplicationScopedVolumeCreationParameters"
	// KindServiceFabricVolumeDisk ...
	KindServiceFabricVolumeDisk KindBasicApplicationScopedVolumeCreationParameters = "ServiceFabricVolumeDisk"
)

// PossibleKindBasicApplicationScopedVolumeCreationParametersValues returns an array of possible values for the KindBasicApplicationScopedVolumeCreationParameters const type.
func PossibleKindBasicApplicationScopedVolumeCreationParametersValues() []KindBasicApplicationScopedVolumeCreationParameters {
	return []KindBasicApplicationScopedVolumeCreationParameters{KindApplicationScopedVolumeCreationParameters, KindServiceFabricVolumeDisk}
}

// KindBasicAutoScalingMechanism enumerates the values for kind basic auto scaling mechanism.
type KindBasicAutoScalingMechanism string

const (
	// KindAddRemoveReplica ...
	KindAddRemoveReplica KindBasicAutoScalingMechanism = "AddRemoveReplica"
	// KindAutoScalingMechanism ...
	KindAutoScalingMechanism KindBasicAutoScalingMechanism = "AutoScalingMechanism"
)

// PossibleKindBasicAutoScalingMechanismValues returns an array of possible values for the KindBasicAutoScalingMechanism const type.
func PossibleKindBasicAutoScalingMechanismValues() []KindBasicAutoScalingMechanism {
	return []KindBasicAutoScalingMechanism{KindAddRemoveReplica, KindAutoScalingMechanism}
}

// KindBasicAutoScalingMetric enumerates the values for kind basic auto scaling metric.
type KindBasicAutoScalingMetric string

const (
	// KindAutoScalingMetric ...
	KindAutoScalingMetric KindBasicAutoScalingMetric = "AutoScalingMetric"
	// KindResource ...
	KindResource KindBasicAutoScalingMetric = "Resource"
)

// PossibleKindBasicAutoScalingMetricValues returns an array of possible values for the KindBasicAutoScalingMetric const type.
func PossibleKindBasicAutoScalingMetricValues() []KindBasicAutoScalingMetric {
	return []KindBasicAutoScalingMetric{KindAutoScalingMetric, KindResource}
}

// KindBasicAutoScalingTrigger enumerates the values for kind basic auto scaling trigger.
type KindBasicAutoScalingTrigger string

const (
	// KindAutoScalingTrigger ...
	KindAutoScalingTrigger KindBasicAutoScalingTrigger = "AutoScalingTrigger"
	// KindAverageLoad ...
	KindAverageLoad KindBasicAutoScalingTrigger = "AverageLoad"
)

// PossibleKindBasicAutoScalingTriggerValues returns an array of possible values for the KindBasicAutoScalingTrigger const type.
func PossibleKindBasicAutoScalingTriggerValues() []KindBasicAutoScalingTrigger {
	return []KindBasicAutoScalingTrigger{KindAutoScalingTrigger, KindAverageLoad}
}

// KindBasicDiagnosticsSinkProperties enumerates the values for kind basic diagnostics sink properties.
type KindBasicDiagnosticsSinkProperties string

const (
	// KindAzureInternalMonitoringPipeline ...
	KindAzureInternalMonitoringPipeline KindBasicDiagnosticsSinkProperties = "AzureInternalMonitoringPipeline"
	// KindDiagnosticsSinkProperties ...
	KindDiagnosticsSinkProperties KindBasicDiagnosticsSinkProperties = "DiagnosticsSinkProperties"
)

// PossibleKindBasicDiagnosticsSinkPropertiesValues returns an array of possible values for the KindBasicDiagnosticsSinkProperties const type.
func PossibleKindBasicDiagnosticsSinkPropertiesValues() []KindBasicDiagnosticsSinkProperties {
	return []KindBasicDiagnosticsSinkProperties{KindAzureInternalMonitoringPipeline, KindDiagnosticsSinkProperties}
}

// KindBasicNetworkResourcePropertiesBase enumerates the values for kind basic network resource properties
// base.
type KindBasicNetworkResourcePropertiesBase string

const (
	// KindLocal ...
	KindLocal KindBasicNetworkResourcePropertiesBase = "Local"
	// KindNetworkResourceProperties ...
	KindNetworkResourceProperties KindBasicNetworkResourcePropertiesBase = "NetworkResourceProperties"
	// KindNetworkResourcePropertiesBase ...
	KindNetworkResourcePropertiesBase KindBasicNetworkResourcePropertiesBase = "NetworkResourcePropertiesBase"
)

// PossibleKindBasicNetworkResourcePropertiesBaseValues returns an array of possible values for the KindBasicNetworkResourcePropertiesBase const type.
func PossibleKindBasicNetworkResourcePropertiesBaseValues() []KindBasicNetworkResourcePropertiesBase {
	return []KindBasicNetworkResourcePropertiesBase{KindLocal, KindNetworkResourceProperties, KindNetworkResourcePropertiesBase}
}

// NetworkKind enumerates the values for network kind.
type NetworkKind string

const (
	// Local Indicates a container network local to a single Service Fabric cluster. The value is 1.
	Local NetworkKind = "Local"
)

// PossibleNetworkKindValues returns an array of possible values for the NetworkKind const type.
func PossibleNetworkKindValues() []NetworkKind {
	return []NetworkKind{Local}
}

// OperatingSystemType enumerates the values for operating system type.
type OperatingSystemType string

const (
	// Linux The required operating system is Linux.
	Linux OperatingSystemType = "Linux"
	// Windows The required operating system is Windows.
	Windows OperatingSystemType = "Windows"
)

// PossibleOperatingSystemTypeValues returns an array of possible values for the OperatingSystemType const type.
func PossibleOperatingSystemTypeValues() []OperatingSystemType {
	return []OperatingSystemType{Linux, Windows}
}

// ResourceStatus enumerates the values for resource status.
type ResourceStatus string

const (
	// Creating Indicates the resource is being created. The value is 3.
	Creating ResourceStatus = "Creating"
	// Deleting Indicates the resource is being deleted. The value is 4.
	Deleting ResourceStatus = "Deleting"
	// Failed Indicates the resource is not functional due to persistent failures. See statusDetails property
	// for more details. The value is 5.
	Failed ResourceStatus = "Failed"
	// Ready Indicates the resource is ready. The value is 1.
	Ready ResourceStatus = "Ready"
	// Unknown Indicates the resource status is unknown. The value is zero.
	Unknown ResourceStatus = "Unknown"
	// Upgrading Indicates the resource is upgrading. The value is 2.
	Upgrading ResourceStatus = "Upgrading"
)

// PossibleResourceStatusValues returns an array of possible values for the ResourceStatus const type.
func PossibleResourceStatusValues() []ResourceStatus {
	return []ResourceStatus{Creating, Deleting, Failed, Ready, Unknown, Upgrading}
}

// SecretKind enumerates the values for secret kind.
type SecretKind string

const (
	// InlinedValue A simple secret resource whose plaintext value is provided by the user.
	InlinedValue SecretKind = "inlinedValue"
)

// PossibleSecretKindValues returns an array of possible values for the SecretKind const type.
func PossibleSecretKindValues() []SecretKind {
	return []SecretKind{InlinedValue}
}

// SizeTypes enumerates the values for size types.
type SizeTypes string

const (
	// Large ...
	Large SizeTypes = "Large"
	// Medium ...
	Medium SizeTypes = "Medium"
	// Small ...
	Small SizeTypes = "Small"
)

// PossibleSizeTypesValues returns an array of possible values for the SizeTypes const type.
func PossibleSizeTypesValues() []SizeTypes {
	return []SizeTypes{Large, Medium, Small}
}

// VolumeProvider enumerates the values for volume provider.
type VolumeProvider string

const (
	// SFAzureFile Provides volumes that are backed by Azure Files.
	SFAzureFile VolumeProvider = "SFAzureFile"
)

// PossibleVolumeProviderValues returns an array of possible values for the VolumeProvider const type.
func PossibleVolumeProviderValues() []VolumeProvider {
	return []VolumeProvider{SFAzureFile}
}
