// +build !ignore_autogenerated_kubeadm_controlplane

/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by conversion-gen. DO NOT EDIT.

package v1alpha3

import (
	unsafe "unsafe"

	conversion "k8s.io/apimachinery/pkg/conversion"
	runtime "k8s.io/apimachinery/pkg/runtime"
	intstr "k8s.io/apimachinery/pkg/util/intstr"
	clusterapiapiv1alpha3 "sigs.k8s.io/cluster-api/api/v1alpha3"
	apiv1beta1 "sigs.k8s.io/cluster-api/api/v1beta1"
	apiv1alpha3 "sigs.k8s.io/cluster-api/bootstrap/kubeadm/api/v1alpha3"
	v1beta1 "sigs.k8s.io/cluster-api/controlplane/kubeadm/api/v1beta1"
	errors "sigs.k8s.io/cluster-api/errors"
)

func init() {
	localSchemeBuilder.Register(RegisterConversions)
}

// RegisterConversions adds conversion functions to the given scheme.
// Public to allow building arbitrary schemes.
func RegisterConversions(s *runtime.Scheme) error {
	if err := s.AddGeneratedConversionFunc((*KubeadmControlPlane)(nil), (*v1beta1.KubeadmControlPlane)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_KubeadmControlPlane_To_v1beta1_KubeadmControlPlane(a.(*KubeadmControlPlane), b.(*v1beta1.KubeadmControlPlane), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.KubeadmControlPlane)(nil), (*KubeadmControlPlane)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_KubeadmControlPlane_To_v1alpha3_KubeadmControlPlane(a.(*v1beta1.KubeadmControlPlane), b.(*KubeadmControlPlane), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*KubeadmControlPlaneList)(nil), (*v1beta1.KubeadmControlPlaneList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_KubeadmControlPlaneList_To_v1beta1_KubeadmControlPlaneList(a.(*KubeadmControlPlaneList), b.(*v1beta1.KubeadmControlPlaneList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.KubeadmControlPlaneList)(nil), (*KubeadmControlPlaneList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_KubeadmControlPlaneList_To_v1alpha3_KubeadmControlPlaneList(a.(*v1beta1.KubeadmControlPlaneList), b.(*KubeadmControlPlaneList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*KubeadmControlPlaneStatus)(nil), (*v1beta1.KubeadmControlPlaneStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_KubeadmControlPlaneStatus_To_v1beta1_KubeadmControlPlaneStatus(a.(*KubeadmControlPlaneStatus), b.(*v1beta1.KubeadmControlPlaneStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*RollingUpdate)(nil), (*v1beta1.RollingUpdate)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_RollingUpdate_To_v1beta1_RollingUpdate(a.(*RollingUpdate), b.(*v1beta1.RollingUpdate), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.RollingUpdate)(nil), (*RollingUpdate)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_RollingUpdate_To_v1alpha3_RollingUpdate(a.(*v1beta1.RollingUpdate), b.(*RollingUpdate), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*RolloutStrategy)(nil), (*v1beta1.RolloutStrategy)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_RolloutStrategy_To_v1beta1_RolloutStrategy(a.(*RolloutStrategy), b.(*v1beta1.RolloutStrategy), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.RolloutStrategy)(nil), (*RolloutStrategy)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_RolloutStrategy_To_v1alpha3_RolloutStrategy(a.(*v1beta1.RolloutStrategy), b.(*RolloutStrategy), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*KubeadmControlPlaneSpec)(nil), (*v1beta1.KubeadmControlPlaneSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_KubeadmControlPlaneSpec_To_v1beta1_KubeadmControlPlaneSpec(a.(*KubeadmControlPlaneSpec), b.(*v1beta1.KubeadmControlPlaneSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*v1beta1.KubeadmControlPlaneSpec)(nil), (*KubeadmControlPlaneSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_KubeadmControlPlaneSpec_To_v1alpha3_KubeadmControlPlaneSpec(a.(*v1beta1.KubeadmControlPlaneSpec), b.(*KubeadmControlPlaneSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*v1beta1.KubeadmControlPlaneStatus)(nil), (*KubeadmControlPlaneStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_KubeadmControlPlaneStatus_To_v1alpha3_KubeadmControlPlaneStatus(a.(*v1beta1.KubeadmControlPlaneStatus), b.(*KubeadmControlPlaneStatus), scope)
	}); err != nil {
		return err
	}
	return nil
}

func autoConvert_v1alpha3_KubeadmControlPlane_To_v1beta1_KubeadmControlPlane(in *KubeadmControlPlane, out *v1beta1.KubeadmControlPlane, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha3_KubeadmControlPlaneSpec_To_v1beta1_KubeadmControlPlaneSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1alpha3_KubeadmControlPlaneStatus_To_v1beta1_KubeadmControlPlaneStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha3_KubeadmControlPlane_To_v1beta1_KubeadmControlPlane is an autogenerated conversion function.
func Convert_v1alpha3_KubeadmControlPlane_To_v1beta1_KubeadmControlPlane(in *KubeadmControlPlane, out *v1beta1.KubeadmControlPlane, s conversion.Scope) error {
	return autoConvert_v1alpha3_KubeadmControlPlane_To_v1beta1_KubeadmControlPlane(in, out, s)
}

func autoConvert_v1beta1_KubeadmControlPlane_To_v1alpha3_KubeadmControlPlane(in *v1beta1.KubeadmControlPlane, out *KubeadmControlPlane, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1beta1_KubeadmControlPlaneSpec_To_v1alpha3_KubeadmControlPlaneSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1beta1_KubeadmControlPlaneStatus_To_v1alpha3_KubeadmControlPlaneStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1beta1_KubeadmControlPlane_To_v1alpha3_KubeadmControlPlane is an autogenerated conversion function.
func Convert_v1beta1_KubeadmControlPlane_To_v1alpha3_KubeadmControlPlane(in *v1beta1.KubeadmControlPlane, out *KubeadmControlPlane, s conversion.Scope) error {
	return autoConvert_v1beta1_KubeadmControlPlane_To_v1alpha3_KubeadmControlPlane(in, out, s)
}

func autoConvert_v1alpha3_KubeadmControlPlaneList_To_v1beta1_KubeadmControlPlaneList(in *KubeadmControlPlaneList, out *v1beta1.KubeadmControlPlaneList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]v1beta1.KubeadmControlPlane, len(*in))
		for i := range *in {
			if err := Convert_v1alpha3_KubeadmControlPlane_To_v1beta1_KubeadmControlPlane(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1alpha3_KubeadmControlPlaneList_To_v1beta1_KubeadmControlPlaneList is an autogenerated conversion function.
func Convert_v1alpha3_KubeadmControlPlaneList_To_v1beta1_KubeadmControlPlaneList(in *KubeadmControlPlaneList, out *v1beta1.KubeadmControlPlaneList, s conversion.Scope) error {
	return autoConvert_v1alpha3_KubeadmControlPlaneList_To_v1beta1_KubeadmControlPlaneList(in, out, s)
}

func autoConvert_v1beta1_KubeadmControlPlaneList_To_v1alpha3_KubeadmControlPlaneList(in *v1beta1.KubeadmControlPlaneList, out *KubeadmControlPlaneList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]KubeadmControlPlane, len(*in))
		for i := range *in {
			if err := Convert_v1beta1_KubeadmControlPlane_To_v1alpha3_KubeadmControlPlane(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1beta1_KubeadmControlPlaneList_To_v1alpha3_KubeadmControlPlaneList is an autogenerated conversion function.
func Convert_v1beta1_KubeadmControlPlaneList_To_v1alpha3_KubeadmControlPlaneList(in *v1beta1.KubeadmControlPlaneList, out *KubeadmControlPlaneList, s conversion.Scope) error {
	return autoConvert_v1beta1_KubeadmControlPlaneList_To_v1alpha3_KubeadmControlPlaneList(in, out, s)
}

func autoConvert_v1alpha3_KubeadmControlPlaneSpec_To_v1beta1_KubeadmControlPlaneSpec(in *KubeadmControlPlaneSpec, out *v1beta1.KubeadmControlPlaneSpec, s conversion.Scope) error {
	out.Replicas = (*int32)(unsafe.Pointer(in.Replicas))
	out.Version = in.Version
	// WARNING: in.InfrastructureTemplate requires manual conversion: does not exist in peer-type
	if err := apiv1alpha3.Convert_v1alpha3_KubeadmConfigSpec_To_v1beta1_KubeadmConfigSpec(&in.KubeadmConfigSpec, &out.KubeadmConfigSpec, s); err != nil {
		return err
	}
	// WARNING: in.UpgradeAfter requires manual conversion: does not exist in peer-type
	// WARNING: in.NodeDrainTimeout requires manual conversion: does not exist in peer-type
	out.RolloutStrategy = (*v1beta1.RolloutStrategy)(unsafe.Pointer(in.RolloutStrategy))
	return nil
}

func autoConvert_v1beta1_KubeadmControlPlaneSpec_To_v1alpha3_KubeadmControlPlaneSpec(in *v1beta1.KubeadmControlPlaneSpec, out *KubeadmControlPlaneSpec, s conversion.Scope) error {
	out.Replicas = (*int32)(unsafe.Pointer(in.Replicas))
	out.Version = in.Version
	// WARNING: in.MachineTemplate requires manual conversion: does not exist in peer-type
	if err := apiv1alpha3.Convert_v1beta1_KubeadmConfigSpec_To_v1alpha3_KubeadmConfigSpec(&in.KubeadmConfigSpec, &out.KubeadmConfigSpec, s); err != nil {
		return err
	}
	// WARNING: in.RolloutAfter requires manual conversion: does not exist in peer-type
	out.RolloutStrategy = (*RolloutStrategy)(unsafe.Pointer(in.RolloutStrategy))
	return nil
}

func autoConvert_v1alpha3_KubeadmControlPlaneStatus_To_v1beta1_KubeadmControlPlaneStatus(in *KubeadmControlPlaneStatus, out *v1beta1.KubeadmControlPlaneStatus, s conversion.Scope) error {
	out.Selector = in.Selector
	out.Replicas = in.Replicas
	out.UpdatedReplicas = in.UpdatedReplicas
	out.ReadyReplicas = in.ReadyReplicas
	out.UnavailableReplicas = in.UnavailableReplicas
	out.Initialized = in.Initialized
	out.Ready = in.Ready
	out.FailureReason = errors.KubeadmControlPlaneStatusError(in.FailureReason)
	out.FailureMessage = (*string)(unsafe.Pointer(in.FailureMessage))
	out.ObservedGeneration = in.ObservedGeneration
	if in.Conditions != nil {
		in, out := &in.Conditions, &out.Conditions
		*out = make(apiv1beta1.Conditions, len(*in))
		for i := range *in {
			if err := clusterapiapiv1alpha3.Convert_v1alpha3_Condition_To_v1beta1_Condition(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Conditions = nil
	}
	return nil
}

// Convert_v1alpha3_KubeadmControlPlaneStatus_To_v1beta1_KubeadmControlPlaneStatus is an autogenerated conversion function.
func Convert_v1alpha3_KubeadmControlPlaneStatus_To_v1beta1_KubeadmControlPlaneStatus(in *KubeadmControlPlaneStatus, out *v1beta1.KubeadmControlPlaneStatus, s conversion.Scope) error {
	return autoConvert_v1alpha3_KubeadmControlPlaneStatus_To_v1beta1_KubeadmControlPlaneStatus(in, out, s)
}

func autoConvert_v1beta1_KubeadmControlPlaneStatus_To_v1alpha3_KubeadmControlPlaneStatus(in *v1beta1.KubeadmControlPlaneStatus, out *KubeadmControlPlaneStatus, s conversion.Scope) error {
	out.Selector = in.Selector
	out.Replicas = in.Replicas
	// WARNING: in.Version requires manual conversion: does not exist in peer-type
	out.UpdatedReplicas = in.UpdatedReplicas
	out.ReadyReplicas = in.ReadyReplicas
	out.UnavailableReplicas = in.UnavailableReplicas
	out.Initialized = in.Initialized
	out.Ready = in.Ready
	out.FailureReason = errors.KubeadmControlPlaneStatusError(in.FailureReason)
	out.FailureMessage = (*string)(unsafe.Pointer(in.FailureMessage))
	out.ObservedGeneration = in.ObservedGeneration
	if in.Conditions != nil {
		in, out := &in.Conditions, &out.Conditions
		*out = make(clusterapiapiv1alpha3.Conditions, len(*in))
		for i := range *in {
			if err := clusterapiapiv1alpha3.Convert_v1beta1_Condition_To_v1alpha3_Condition(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Conditions = nil
	}
	return nil
}

func autoConvert_v1alpha3_RollingUpdate_To_v1beta1_RollingUpdate(in *RollingUpdate, out *v1beta1.RollingUpdate, s conversion.Scope) error {
	out.MaxSurge = (*intstr.IntOrString)(unsafe.Pointer(in.MaxSurge))
	return nil
}

// Convert_v1alpha3_RollingUpdate_To_v1beta1_RollingUpdate is an autogenerated conversion function.
func Convert_v1alpha3_RollingUpdate_To_v1beta1_RollingUpdate(in *RollingUpdate, out *v1beta1.RollingUpdate, s conversion.Scope) error {
	return autoConvert_v1alpha3_RollingUpdate_To_v1beta1_RollingUpdate(in, out, s)
}

func autoConvert_v1beta1_RollingUpdate_To_v1alpha3_RollingUpdate(in *v1beta1.RollingUpdate, out *RollingUpdate, s conversion.Scope) error {
	out.MaxSurge = (*intstr.IntOrString)(unsafe.Pointer(in.MaxSurge))
	return nil
}

// Convert_v1beta1_RollingUpdate_To_v1alpha3_RollingUpdate is an autogenerated conversion function.
func Convert_v1beta1_RollingUpdate_To_v1alpha3_RollingUpdate(in *v1beta1.RollingUpdate, out *RollingUpdate, s conversion.Scope) error {
	return autoConvert_v1beta1_RollingUpdate_To_v1alpha3_RollingUpdate(in, out, s)
}

func autoConvert_v1alpha3_RolloutStrategy_To_v1beta1_RolloutStrategy(in *RolloutStrategy, out *v1beta1.RolloutStrategy, s conversion.Scope) error {
	out.Type = v1beta1.RolloutStrategyType(in.Type)
	out.RollingUpdate = (*v1beta1.RollingUpdate)(unsafe.Pointer(in.RollingUpdate))
	return nil
}

// Convert_v1alpha3_RolloutStrategy_To_v1beta1_RolloutStrategy is an autogenerated conversion function.
func Convert_v1alpha3_RolloutStrategy_To_v1beta1_RolloutStrategy(in *RolloutStrategy, out *v1beta1.RolloutStrategy, s conversion.Scope) error {
	return autoConvert_v1alpha3_RolloutStrategy_To_v1beta1_RolloutStrategy(in, out, s)
}

func autoConvert_v1beta1_RolloutStrategy_To_v1alpha3_RolloutStrategy(in *v1beta1.RolloutStrategy, out *RolloutStrategy, s conversion.Scope) error {
	out.Type = RolloutStrategyType(in.Type)
	out.RollingUpdate = (*RollingUpdate)(unsafe.Pointer(in.RollingUpdate))
	return nil
}

// Convert_v1beta1_RolloutStrategy_To_v1alpha3_RolloutStrategy is an autogenerated conversion function.
func Convert_v1beta1_RolloutStrategy_To_v1alpha3_RolloutStrategy(in *v1beta1.RolloutStrategy, out *RolloutStrategy, s conversion.Scope) error {
	return autoConvert_v1beta1_RolloutStrategy_To_v1alpha3_RolloutStrategy(in, out, s)
}
