// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: vector_tile.proto

/*
	Package vectortile is a generated protocol buffer package.

	It is generated from these files:
		vector_tile.proto

	It has these top-level messages:
		Tile
*/
package vectortile

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"

import binary "encoding/binary"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

type Tile_GeomType int32

const (
	Tile_UNKNOWN    Tile_GeomType = 0
	Tile_POINT      Tile_GeomType = 1
	Tile_LINESTRING Tile_GeomType = 2
	Tile_POLYGON    Tile_GeomType = 3
)

var Tile_GeomType_name = map[int32]string{
	0: "UNKNOWN",
	1: "POINT",
	2: "LINESTRING",
	3: "POLYGON",
}
var Tile_GeomType_value = map[string]int32{
	"UNKNOWN":    0,
	"POINT":      1,
	"LINESTRING": 2,
	"POLYGON":    3,
}

func (x Tile_GeomType) Enum() *Tile_GeomType {
	p := new(Tile_GeomType)
	*p = x
	return p
}
func (x Tile_GeomType) String() string {
	return proto.EnumName(Tile_GeomType_name, int32(x))
}
func (x *Tile_GeomType) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(Tile_GeomType_value, data, "Tile_GeomType")
	if err != nil {
		return err
	}
	*x = Tile_GeomType(value)
	return nil
}
func (Tile_GeomType) EnumDescriptor() ([]byte, []int) { return fileDescriptorVectorTile, []int{0, 0} }

type Tile struct {
	Layers                       []*Tile_Layer `protobuf:"bytes,3,rep,name=layers" json:"layers,omitempty"`
	proto.XXX_InternalExtensions `json:"-"`
	XXX_unrecognized             []byte `json:"-"`
}

func (m *Tile) Reset()                    { *m = Tile{} }
func (m *Tile) String() string            { return proto.CompactTextString(m) }
func (*Tile) ProtoMessage()               {}
func (*Tile) Descriptor() ([]byte, []int) { return fileDescriptorVectorTile, []int{0} }

var extRange_Tile = []proto.ExtensionRange{
	{Start: 16, End: 8191},
}

func (*Tile) ExtensionRangeArray() []proto.ExtensionRange {
	return extRange_Tile
}

func (m *Tile) GetLayers() []*Tile_Layer {
	if m != nil {
		return m.Layers
	}
	return nil
}

// Variant type encoding
type Tile_Value struct {
	// Exactly one of these values may be present in a valid message
	StringValue                  *string  `protobuf:"bytes,1,opt,name=string_value,json=stringValue" json:"string_value,omitempty"`
	FloatValue                   *float32 `protobuf:"fixed32,2,opt,name=float_value,json=floatValue" json:"float_value,omitempty"`
	DoubleValue                  *float64 `protobuf:"fixed64,3,opt,name=double_value,json=doubleValue" json:"double_value,omitempty"`
	IntValue                     *int64   `protobuf:"varint,4,opt,name=int_value,json=intValue" json:"int_value,omitempty"`
	UintValue                    *uint64  `protobuf:"varint,5,opt,name=uint_value,json=uintValue" json:"uint_value,omitempty"`
	SintValue                    *int64   `protobuf:"zigzag64,6,opt,name=sint_value,json=sintValue" json:"sint_value,omitempty"`
	BoolValue                    *bool    `protobuf:"varint,7,opt,name=bool_value,json=boolValue" json:"bool_value,omitempty"`
	proto.XXX_InternalExtensions `json:"-"`
	XXX_unrecognized             []byte `json:"-"`
}

func (m *Tile_Value) Reset()                    { *m = Tile_Value{} }
func (m *Tile_Value) String() string            { return proto.CompactTextString(m) }
func (*Tile_Value) ProtoMessage()               {}
func (*Tile_Value) Descriptor() ([]byte, []int) { return fileDescriptorVectorTile, []int{0, 0} }

var extRange_Tile_Value = []proto.ExtensionRange{
	{Start: 8, End: 536870911},
}

func (*Tile_Value) ExtensionRangeArray() []proto.ExtensionRange {
	return extRange_Tile_Value
}

func (m *Tile_Value) GetStringValue() string {
	if m != nil && m.StringValue != nil {
		return *m.StringValue
	}
	return ""
}

func (m *Tile_Value) GetFloatValue() float32 {
	if m != nil && m.FloatValue != nil {
		return *m.FloatValue
	}
	return 0
}

func (m *Tile_Value) GetDoubleValue() float64 {
	if m != nil && m.DoubleValue != nil {
		return *m.DoubleValue
	}
	return 0
}

func (m *Tile_Value) GetIntValue() int64 {
	if m != nil && m.IntValue != nil {
		return *m.IntValue
	}
	return 0
}

func (m *Tile_Value) GetUintValue() uint64 {
	if m != nil && m.UintValue != nil {
		return *m.UintValue
	}
	return 0
}

func (m *Tile_Value) GetSintValue() int64 {
	if m != nil && m.SintValue != nil {
		return *m.SintValue
	}
	return 0
}

func (m *Tile_Value) GetBoolValue() bool {
	if m != nil && m.BoolValue != nil {
		return *m.BoolValue
	}
	return false
}

type Tile_Feature struct {
	Id *uint64 `protobuf:"varint,1,opt,name=id,def=0" json:"id,omitempty"`
	// Tags of this feature are encoded as repeated pairs of
	// integers. Even indexed values (n, beginning with 0) are
	// themselves indexes into the layer's keys list. Odd indexed
	// values (n+1) are indexes into the layer's values list.
	// The first (n=0) tag of a feature, therefore, has a key of
	// layer.keys[feature.tags[0]] and a value of
	// layer.values[feature.tags[1]].
	Tags []uint32 `protobuf:"varint,2,rep,packed,name=tags" json:"tags,omitempty"`
	// The type of geometry stored in this feature.
	Type *Tile_GeomType `protobuf:"varint,3,opt,name=type,enum=vector_tile.Tile_GeomType,def=0" json:"type,omitempty"`
	// Contains a stream of commands and parameters (vertices). The
	// repeat count is shifted to the left by 3 bits. This means
	// that the command has 3 bits (0-7). The repeat count
	// indicates how often this command is to be repeated. Defined
	// commands are:
	// - MoveTo:    1   (2 parameters follow)
	// - LineTo:    2   (2 parameters follow)
	// - ClosePath: 7   (no parameters follow)
	//
	// Commands are encoded as uint32 varints. Vertex parameters
	// are encoded as deltas to the previous position and, as they
	// may be negative, are further "zigzag" encoded as unsigned
	// 32-bit ints:
	//
	//   n = (n << 1) ^ (n >> 31)
	//
	// Ex.: MoveTo(3, 6), LineTo(8, 12), LineTo(20, 34), ClosePath
	// Encoded as: [ 9 6 12 18 10 12 24 44 15 ]
	//               |       |              `> [00001 111] command type 7 (ClosePath), length 1
	//               |       |       ===== relative LineTo(+12, +22) == LineTo(20, 34)
	//               |       | ===== relative LineTo(+5, +6) == LineTo(8, 12)
	//               |       `> [00010 010] = command type 2 (LineTo), length 2
	//               | ==== relative MoveTo(+3, +6)
	//               `> [00001 001] = command type 1 (MoveTo), length 1
	//
	// The original position is (0,0).
	Geometry         []uint32 `protobuf:"varint,4,rep,packed,name=geometry" json:"geometry,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *Tile_Feature) Reset()                    { *m = Tile_Feature{} }
func (m *Tile_Feature) String() string            { return proto.CompactTextString(m) }
func (*Tile_Feature) ProtoMessage()               {}
func (*Tile_Feature) Descriptor() ([]byte, []int) { return fileDescriptorVectorTile, []int{0, 1} }

const Default_Tile_Feature_Id uint64 = 0
const Default_Tile_Feature_Type Tile_GeomType = Tile_UNKNOWN

func (m *Tile_Feature) GetId() uint64 {
	if m != nil && m.Id != nil {
		return *m.Id
	}
	return Default_Tile_Feature_Id
}

func (m *Tile_Feature) GetTags() []uint32 {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *Tile_Feature) GetType() Tile_GeomType {
	if m != nil && m.Type != nil {
		return *m.Type
	}
	return Default_Tile_Feature_Type
}

func (m *Tile_Feature) GetGeometry() []uint32 {
	if m != nil {
		return m.Geometry
	}
	return nil
}

type Tile_Layer struct {
	// Any compliant implementation must first read the version
	// number encoded in this message and choose the correct
	// implementation for this version number before proceeding to
	// decode other parts of this message.
	Version *uint32 `protobuf:"varint,15,req,name=version,def=1" json:"version,omitempty"`
	Name    *string `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	// The actual features in this tile.
	Features []*Tile_Feature `protobuf:"bytes,2,rep,name=features" json:"features,omitempty"`
	// Dictionary encoding for keys
	Keys []string `protobuf:"bytes,3,rep,name=keys" json:"keys,omitempty"`
	// Dictionary encoding for values
	Values []*Tile_Value `protobuf:"bytes,4,rep,name=values" json:"values,omitempty"`
	// The bounding box in this tile spans from 0..4095 units
	Extent                       *uint32 `protobuf:"varint,5,opt,name=extent,def=4096" json:"extent,omitempty"`
	proto.XXX_InternalExtensions `json:"-"`
	XXX_unrecognized             []byte `json:"-"`
}

func (m *Tile_Layer) Reset()                    { *m = Tile_Layer{} }
func (m *Tile_Layer) String() string            { return proto.CompactTextString(m) }
func (*Tile_Layer) ProtoMessage()               {}
func (*Tile_Layer) Descriptor() ([]byte, []int) { return fileDescriptorVectorTile, []int{0, 2} }

var extRange_Tile_Layer = []proto.ExtensionRange{
	{Start: 16, End: 536870911},
}

func (*Tile_Layer) ExtensionRangeArray() []proto.ExtensionRange {
	return extRange_Tile_Layer
}

const Default_Tile_Layer_Version uint32 = 1
const Default_Tile_Layer_Extent uint32 = 4096

func (m *Tile_Layer) GetVersion() uint32 {
	if m != nil && m.Version != nil {
		return *m.Version
	}
	return Default_Tile_Layer_Version
}

func (m *Tile_Layer) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *Tile_Layer) GetFeatures() []*Tile_Feature {
	if m != nil {
		return m.Features
	}
	return nil
}

func (m *Tile_Layer) GetKeys() []string {
	if m != nil {
		return m.Keys
	}
	return nil
}

func (m *Tile_Layer) GetValues() []*Tile_Value {
	if m != nil {
		return m.Values
	}
	return nil
}

func (m *Tile_Layer) GetExtent() uint32 {
	if m != nil && m.Extent != nil {
		return *m.Extent
	}
	return Default_Tile_Layer_Extent
}

func init() {
	proto.RegisterType((*Tile)(nil), "vector_tile.Tile")
	proto.RegisterType((*Tile_Value)(nil), "vector_tile.Tile.Value")
	proto.RegisterType((*Tile_Feature)(nil), "vector_tile.Tile.Feature")
	proto.RegisterType((*Tile_Layer)(nil), "vector_tile.Tile.Layer")
	proto.RegisterEnum("vector_tile.Tile_GeomType", Tile_GeomType_name, Tile_GeomType_value)
}
func (m *Tile) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Tile) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Layers) > 0 {
		for _, msg := range m.Layers {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintVectorTile(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	n, err := proto.EncodeInternalExtension(m, dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Tile_Value) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Tile_Value) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.StringValue != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintVectorTile(dAtA, i, uint64(len(*m.StringValue)))
		i += copy(dAtA[i:], *m.StringValue)
	}
	if m.FloatValue != nil {
		dAtA[i] = 0x15
		i++
		binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(*m.FloatValue))))
		i += 4
	}
	if m.DoubleValue != nil {
		dAtA[i] = 0x19
		i++
		binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(*m.DoubleValue))))
		i += 8
	}
	if m.IntValue != nil {
		dAtA[i] = 0x20
		i++
		i = encodeVarintVectorTile(dAtA, i, uint64(*m.IntValue))
	}
	if m.UintValue != nil {
		dAtA[i] = 0x28
		i++
		i = encodeVarintVectorTile(dAtA, i, uint64(*m.UintValue))
	}
	if m.SintValue != nil {
		dAtA[i] = 0x30
		i++
		i = encodeVarintVectorTile(dAtA, i, uint64((uint64(*m.SintValue)<<1)^uint64((*m.SintValue>>63))))
	}
	if m.BoolValue != nil {
		dAtA[i] = 0x38
		i++
		if *m.BoolValue {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	n, err := proto.EncodeInternalExtension(m, dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Tile_Feature) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Tile_Feature) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Id != nil {
		dAtA[i] = 0x8
		i++
		i = encodeVarintVectorTile(dAtA, i, uint64(*m.Id))
	}
	if len(m.Tags) > 0 {
		dAtA2 := make([]byte, len(m.Tags)*10)
		var j1 int
		for _, num := range m.Tags {
			for num >= 1<<7 {
				dAtA2[j1] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j1++
			}
			dAtA2[j1] = uint8(num)
			j1++
		}
		dAtA[i] = 0x12
		i++
		i = encodeVarintVectorTile(dAtA, i, uint64(j1))
		i += copy(dAtA[i:], dAtA2[:j1])
	}
	if m.Type != nil {
		dAtA[i] = 0x18
		i++
		i = encodeVarintVectorTile(dAtA, i, uint64(*m.Type))
	}
	if len(m.Geometry) > 0 {
		dAtA4 := make([]byte, len(m.Geometry)*10)
		var j3 int
		for _, num := range m.Geometry {
			for num >= 1<<7 {
				dAtA4[j3] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j3++
			}
			dAtA4[j3] = uint8(num)
			j3++
		}
		dAtA[i] = 0x22
		i++
		i = encodeVarintVectorTile(dAtA, i, uint64(j3))
		i += copy(dAtA[i:], dAtA4[:j3])
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Tile_Layer) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Tile_Layer) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Name == nil {
		return 0, proto.NewRequiredNotSetError("name")
	} else {
		dAtA[i] = 0xa
		i++
		i = encodeVarintVectorTile(dAtA, i, uint64(len(*m.Name)))
		i += copy(dAtA[i:], *m.Name)
	}
	if len(m.Features) > 0 {
		for _, msg := range m.Features {
			dAtA[i] = 0x12
			i++
			i = encodeVarintVectorTile(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Keys) > 0 {
		for _, s := range m.Keys {
			dAtA[i] = 0x1a
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.Values) > 0 {
		for _, msg := range m.Values {
			dAtA[i] = 0x22
			i++
			i = encodeVarintVectorTile(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.Extent != nil {
		dAtA[i] = 0x28
		i++
		i = encodeVarintVectorTile(dAtA, i, uint64(*m.Extent))
	}
	if m.Version == nil {
		return 0, proto.NewRequiredNotSetError("version")
	} else {
		dAtA[i] = 0x78
		i++
		i = encodeVarintVectorTile(dAtA, i, uint64(*m.Version))
	}
	n, err := proto.EncodeInternalExtension(m, dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func encodeVarintVectorTile(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *Tile) Size() (n int) {
	var l int
	_ = l
	if len(m.Layers) > 0 {
		for _, e := range m.Layers {
			l = e.Size()
			n += 1 + l + sovVectorTile(uint64(l))
		}
	}
	n += proto.SizeOfInternalExtension(m)
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Tile_Value) Size() (n int) {
	var l int
	_ = l
	if m.StringValue != nil {
		l = len(*m.StringValue)
		n += 1 + l + sovVectorTile(uint64(l))
	}
	if m.FloatValue != nil {
		n += 5
	}
	if m.DoubleValue != nil {
		n += 9
	}
	if m.IntValue != nil {
		n += 1 + sovVectorTile(uint64(*m.IntValue))
	}
	if m.UintValue != nil {
		n += 1 + sovVectorTile(uint64(*m.UintValue))
	}
	if m.SintValue != nil {
		n += 1 + sozVectorTile(uint64(*m.SintValue))
	}
	if m.BoolValue != nil {
		n += 2
	}
	n += proto.SizeOfInternalExtension(m)
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Tile_Feature) Size() (n int) {
	var l int
	_ = l
	if m.Id != nil {
		n += 1 + sovVectorTile(uint64(*m.Id))
	}
	if len(m.Tags) > 0 {
		l = 0
		for _, e := range m.Tags {
			l += sovVectorTile(uint64(e))
		}
		n += 1 + sovVectorTile(uint64(l)) + l
	}
	if m.Type != nil {
		n += 1 + sovVectorTile(uint64(*m.Type))
	}
	if len(m.Geometry) > 0 {
		l = 0
		for _, e := range m.Geometry {
			l += sovVectorTile(uint64(e))
		}
		n += 1 + sovVectorTile(uint64(l)) + l
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Tile_Layer) Size() (n int) {
	var l int
	_ = l
	if m.Name != nil {
		l = len(*m.Name)
		n += 1 + l + sovVectorTile(uint64(l))
	}
	if len(m.Features) > 0 {
		for _, e := range m.Features {
			l = e.Size()
			n += 1 + l + sovVectorTile(uint64(l))
		}
	}
	if len(m.Keys) > 0 {
		for _, s := range m.Keys {
			l = len(s)
			n += 1 + l + sovVectorTile(uint64(l))
		}
	}
	if len(m.Values) > 0 {
		for _, e := range m.Values {
			l = e.Size()
			n += 1 + l + sovVectorTile(uint64(l))
		}
	}
	if m.Extent != nil {
		n += 1 + sovVectorTile(uint64(*m.Extent))
	}
	if m.Version != nil {
		n += 1 + sovVectorTile(uint64(*m.Version))
	}
	n += proto.SizeOfInternalExtension(m)
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovVectorTile(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozVectorTile(x uint64) (n int) {
	return sovVectorTile(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Tile) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowVectorTile
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Tile: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Tile: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Layers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVectorTile
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVectorTile
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Layers = append(m.Layers, &Tile_Layer{})
			if err := m.Layers[len(m.Layers)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			if (fieldNum >= 16) && (fieldNum < 8192) {
				var sizeOfWire int
				for {
					sizeOfWire++
					wire >>= 7
					if wire == 0 {
						break
					}
				}
				iNdEx -= sizeOfWire
				skippy, err := skipVectorTile(dAtA[iNdEx:])
				if err != nil {
					return err
				}
				if skippy < 0 {
					return ErrInvalidLengthVectorTile
				}
				if (iNdEx + skippy) > l {
					return io.ErrUnexpectedEOF
				}
				proto.AppendExtension(m, int32(fieldNum), dAtA[iNdEx:iNdEx+skippy])
				iNdEx += skippy
			} else {
				iNdEx = preIndex
				skippy, err := skipVectorTile(dAtA[iNdEx:])
				if err != nil {
					return err
				}
				if skippy < 0 {
					return ErrInvalidLengthVectorTile
				}
				if (iNdEx + skippy) > l {
					return io.ErrUnexpectedEOF
				}
				m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
				iNdEx += skippy
			}
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Tile_Value) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowVectorTile
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Value: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Value: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StringValue", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVectorTile
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthVectorTile
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.StringValue = &s
			iNdEx = postIndex
		case 2:
			if wireType != 5 {
				return fmt.Errorf("proto: wrong wireType = %d for field FloatValue", wireType)
			}
			var v uint32
			if (iNdEx + 4) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint32(binary.LittleEndian.Uint32(dAtA[iNdEx:]))
			iNdEx += 4
			v2 := float32(math.Float32frombits(v))
			m.FloatValue = &v2
		case 3:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field DoubleValue", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			v2 := float64(math.Float64frombits(v))
			m.DoubleValue = &v2
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IntValue", wireType)
			}
			var v int64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVectorTile
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IntValue = &v
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field UintValue", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVectorTile
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.UintValue = &v
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SintValue", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVectorTile
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			v = (v >> 1) ^ uint64((int64(v&1)<<63)>>63)
			v2 := int64(v)
			m.SintValue = &v2
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field BoolValue", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVectorTile
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.BoolValue = &b
		default:
			if (fieldNum >= 8) && (fieldNum < 536870912) {
				var sizeOfWire int
				for {
					sizeOfWire++
					wire >>= 7
					if wire == 0 {
						break
					}
				}
				iNdEx -= sizeOfWire
				skippy, err := skipVectorTile(dAtA[iNdEx:])
				if err != nil {
					return err
				}
				if skippy < 0 {
					return ErrInvalidLengthVectorTile
				}
				if (iNdEx + skippy) > l {
					return io.ErrUnexpectedEOF
				}
				proto.AppendExtension(m, int32(fieldNum), dAtA[iNdEx:iNdEx+skippy])
				iNdEx += skippy
			} else {
				iNdEx = preIndex
				skippy, err := skipVectorTile(dAtA[iNdEx:])
				if err != nil {
					return err
				}
				if skippy < 0 {
					return ErrInvalidLengthVectorTile
				}
				if (iNdEx + skippy) > l {
					return io.ErrUnexpectedEOF
				}
				m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
				iNdEx += skippy
			}
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Tile_Feature) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowVectorTile
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Feature: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Feature: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVectorTile
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Id = &v
		case 2:
			if wireType == 0 {
				var v uint32
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowVectorTile
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (uint32(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.Tags = append(m.Tags, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowVectorTile
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthVectorTile
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v uint32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowVectorTile
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (uint32(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.Tags = append(m.Tags, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Tags", wireType)
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var v Tile_GeomType
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVectorTile
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (Tile_GeomType(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Type = &v
		case 4:
			if wireType == 0 {
				var v uint32
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowVectorTile
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (uint32(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.Geometry = append(m.Geometry, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowVectorTile
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthVectorTile
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v uint32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowVectorTile
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (uint32(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.Geometry = append(m.Geometry, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Geometry", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipVectorTile(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthVectorTile
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Tile_Layer) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowVectorTile
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Layer: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Layer: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVectorTile
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthVectorTile
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Name = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Features", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVectorTile
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVectorTile
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Features = append(m.Features, &Tile_Feature{})
			if err := m.Features[len(m.Features)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Keys", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVectorTile
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthVectorTile
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Keys = append(m.Keys, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Values", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVectorTile
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVectorTile
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Values = append(m.Values, &Tile_Value{})
			if err := m.Values[len(m.Values)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Extent", wireType)
			}
			var v uint32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVectorTile
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Extent = &v
		case 15:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var v uint32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVectorTile
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Version = &v
			hasFields[0] |= uint64(0x00000002)
		default:
			if (fieldNum >= 16) && (fieldNum < 536870912) {
				var sizeOfWire int
				for {
					sizeOfWire++
					wire >>= 7
					if wire == 0 {
						break
					}
				}
				iNdEx -= sizeOfWire
				skippy, err := skipVectorTile(dAtA[iNdEx:])
				if err != nil {
					return err
				}
				if skippy < 0 {
					return ErrInvalidLengthVectorTile
				}
				if (iNdEx + skippy) > l {
					return io.ErrUnexpectedEOF
				}
				proto.AppendExtension(m, int32(fieldNum), dAtA[iNdEx:iNdEx+skippy])
				iNdEx += skippy
			} else {
				iNdEx = preIndex
				skippy, err := skipVectorTile(dAtA[iNdEx:])
				if err != nil {
					return err
				}
				if skippy < 0 {
					return ErrInvalidLengthVectorTile
				}
				if (iNdEx + skippy) > l {
					return io.ErrUnexpectedEOF
				}
				m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
				iNdEx += skippy
			}
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return proto.NewRequiredNotSetError("name")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return proto.NewRequiredNotSetError("version")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipVectorTile(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowVectorTile
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowVectorTile
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowVectorTile
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthVectorTile
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowVectorTile
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipVectorTile(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthVectorTile = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowVectorTile   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("vector_tile.proto", fileDescriptorVectorTile) }

var fileDescriptorVectorTile = []byte{
	// 498 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x6c, 0x52, 0xcb, 0x8e, 0xd3, 0x30,
	0x14, 0xc5, 0x4e, 0x32, 0x75, 0x6e, 0x68, 0xc9, 0x78, 0x01, 0xa5, 0x03, 0xc5, 0xcc, 0xca, 0xea,
	0xa2, 0x0c, 0x15, 0x0f, 0xd1, 0x0d, 0x68, 0x24, 0x28, 0x15, 0x55, 0x3a, 0x32, 0x05, 0xc4, 0x6a,
	0x94, 0xa1, 0x9e, 0x2a, 0x22, 0x8d, 0xab, 0xc4, 0xad, 0xc8, 0xae, 0x3f, 0xc0, 0x7f, 0xb1, 0xe4,
	0x03, 0x58, 0xa0, 0xf2, 0x07, 0x7c, 0x01, 0x8a, 0x93, 0x76, 0x2a, 0x0d, 0x3b, 0xfb, 0x9c, 0x73,
	0x8f, 0xef, 0x3d, 0xbe, 0x70, 0xb8, 0x92, 0x5f, 0xb4, 0x4a, 0xcf, 0x75, 0x14, 0xcb, 0xee, 0x22,
	0x55, 0x5a, 0x51, 0x6f, 0x0f, 0x3a, 0xfe, 0xe3, 0x80, 0x3d, 0x89, 0x62, 0x49, 0x1f, 0xc1, 0x41,
	0x1c, 0xe6, 0x32, 0xcd, 0x9a, 0x16, 0xb3, 0xb8, 0xd7, 0xbb, 0xd3, 0xdd, 0xaf, 0x2c, 0x24, 0xdd,
	0x51, 0xc1, 0x8b, 0x4a, 0xd6, 0xfa, 0x8b, 0xc0, 0xf9, 0x18, 0xc6, 0x4b, 0x49, 0x1f, 0xc2, 0xcd,
	0x4c, 0xa7, 0x51, 0x32, 0x3b, 0x5f, 0x15, 0xf7, 0x26, 0x62, 0x88, 0xbb, 0xc2, 0x2b, 0xb1, 0x52,
	0xf2, 0x00, 0xbc, 0xcb, 0x58, 0x85, 0xba, 0x52, 0x60, 0x86, 0x38, 0x16, 0x60, 0xa0, 0x9d, 0xc7,
	0x54, 0x2d, 0x2f, 0x62, 0x59, 0x29, 0x2c, 0x86, 0x38, 0x12, 0x5e, 0x89, 0x95, 0x92, 0x23, 0x70,
	0xa3, 0x64, 0xeb, 0x60, 0x33, 0xc4, 0x2d, 0x41, 0xa2, 0xa4, 0xaa, 0xbf, 0x0f, 0xb0, 0xbc, 0x62,
	0x1d, 0x86, 0xb8, 0x2d, 0xdc, 0xe5, 0x3e, 0x9d, 0x5d, 0xd1, 0x07, 0x0c, 0x71, 0x2a, 0xdc, 0x6c,
	0x9f, 0xbe, 0x50, 0x2a, 0xae, 0xe8, 0x1a, 0x43, 0x9c, 0x08, 0xb7, 0x40, 0x0c, 0xdd, 0x21, 0x84,
	0xf8, 0xeb, 0xf5, 0x7a, 0x8d, 0x5b, 0xdf, 0x11, 0xd4, 0xde, 0xc8, 0x50, 0x2f, 0x53, 0x49, 0x0f,
	0x01, 0x47, 0x53, 0x33, 0xac, 0xdd, 0x47, 0x27, 0x02, 0x47, 0x53, 0x7a, 0x1b, 0x6c, 0x1d, 0xce,
	0xb2, 0x26, 0x66, 0x16, 0xaf, 0x9f, 0x62, 0x1f, 0x09, 0x73, 0xa7, 0xcf, 0xc1, 0xd6, 0xf9, 0xa2,
	0x9c, 0xaa, 0xd1, 0x6b, 0x5d, 0x8f, 0x76, 0x20, 0xd5, 0x7c, 0x92, 0x2f, 0x64, 0xbf, 0xf6, 0x21,
	0x78, 0x17, 0x8c, 0x3f, 0x05, 0xc2, 0x14, 0xd0, 0x36, 0x90, 0x99, 0x54, 0x73, 0xa9, 0xd3, 0xbc,
	0x69, 0xef, 0x4c, 0x77, 0x58, 0xeb, 0x17, 0x02, 0xc7, 0x7c, 0x0b, 0xa5, 0x60, 0x27, 0xe1, 0xbc,
	0x08, 0x1f, 0x73, 0x57, 0x98, 0x33, 0x7d, 0x0a, 0xe4, 0xb2, 0x6c, 0xb6, 0x6c, 0xc9, 0xeb, 0xdd,
	0xbd, 0xfe, 0x74, 0x35, 0x8e, 0xd8, 0x49, 0x0b, 0xab, 0xaf, 0x32, 0x2f, 0x17, 0xc1, 0x15, 0xe6,
	0x5c, 0xac, 0x87, 0x09, 0x27, 0x33, 0x6d, 0xfc, 0x77, 0x3d, 0x4c, 0x56, 0xa2, 0x92, 0xd1, 0x7b,
	0x70, 0x20, 0xbf, 0x69, 0x99, 0x68, 0xf3, 0x19, 0xf5, 0xbe, 0xfd, 0xe4, 0xe4, 0xc5, 0x33, 0x51,
	0x61, 0xf4, 0x08, 0x6a, 0x2b, 0x99, 0x66, 0x91, 0x4a, 0x9a, 0xb7, 0x18, 0xe6, 0xf5, 0x3e, 0x7a,
	0x2c, 0xb6, 0x48, 0x87, 0x10, 0xbf, 0x8c, 0xfb, 0xf8, 0x25, 0x90, 0x6d, 0x32, 0xd4, 0x83, 0x6d,
	0x36, 0xfe, 0x0d, 0xea, 0x82, 0x73, 0x36, 0x1e, 0x06, 0x13, 0x1f, 0xd1, 0x06, 0xc0, 0x68, 0x18,
	0xbc, 0x7e, 0x3f, 0x11, 0xc3, 0x60, 0xe0, 0xe3, 0x42, 0x77, 0x36, 0x1e, 0x7d, 0x1e, 0x8c, 0x03,
	0xdf, 0xea, 0x38, 0x85, 0xd5, 0xab, 0xd3, 0xc6, 0x8f, 0x4d, 0x1b, 0xfd, 0xdc, 0xb4, 0xd1, 0xef,
	0x4d, 0x1b, 0xbd, 0xb5, 0xfe, 0x05, 0x00, 0x00, 0xff, 0xff, 0xd5, 0xe5, 0x19, 0x8e, 0x16, 0x03,
	0x00, 0x00,
}
