// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0-devel
// 	protoc        v3.13.0
// source: google/cloud/recommender/v1/recommendation.proto

package recommender

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	money "google.golang.org/genproto/googleapis/type/money"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	structpb "google.golang.org/protobuf/types/known/structpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// The category of the impact.
type Impact_Category int32

const (
	// Default unspecified category. Don't use directly.
	Impact_CATEGORY_UNSPECIFIED Impact_Category = 0
	// Indicates a potential increase or decrease in cost.
	Impact_COST Impact_Category = 1
	// Indicates a potential increase or decrease in security.
	Impact_SECURITY Impact_Category = 2
	// Indicates a potential increase or decrease in performance.
	Impact_PERFORMANCE Impact_Category = 3
	// Indicates a potential increase or decrease in manageability.
	Impact_MANAGEABILITY Impact_Category = 4
)

// Enum value maps for Impact_Category.
var (
	Impact_Category_name = map[int32]string{
		0: "CATEGORY_UNSPECIFIED",
		1: "COST",
		2: "SECURITY",
		3: "PERFORMANCE",
		4: "MANAGEABILITY",
	}
	Impact_Category_value = map[string]int32{
		"CATEGORY_UNSPECIFIED": 0,
		"COST":                 1,
		"SECURITY":             2,
		"PERFORMANCE":          3,
		"MANAGEABILITY":        4,
	}
)

func (x Impact_Category) Enum() *Impact_Category {
	p := new(Impact_Category)
	*p = x
	return p
}

func (x Impact_Category) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Impact_Category) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_recommender_v1_recommendation_proto_enumTypes[0].Descriptor()
}

func (Impact_Category) Type() protoreflect.EnumType {
	return &file_google_cloud_recommender_v1_recommendation_proto_enumTypes[0]
}

func (x Impact_Category) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Impact_Category.Descriptor instead.
func (Impact_Category) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_recommender_v1_recommendation_proto_rawDescGZIP(), []int{6, 0}
}

// Represents Recommendation State.
type RecommendationStateInfo_State int32

const (
	// Default state. Don't use directly.
	RecommendationStateInfo_STATE_UNSPECIFIED RecommendationStateInfo_State = 0
	// Recommendation is active and can be applied. Recommendations content can
	// be updated by Google.
	//
	// ACTIVE recommendations can be marked as CLAIMED, SUCCEEDED, or FAILED.
	RecommendationStateInfo_ACTIVE RecommendationStateInfo_State = 1
	// Recommendation is in claimed state. Recommendations content is
	// immutable and cannot be updated by Google.
	//
	// CLAIMED recommendations can be marked as CLAIMED, SUCCEEDED, or FAILED.
	RecommendationStateInfo_CLAIMED RecommendationStateInfo_State = 6
	// Recommendation is in succeeded state. Recommendations content is
	// immutable and cannot be updated by Google.
	//
	// SUCCEEDED recommendations can be marked as SUCCEEDED, or FAILED.
	RecommendationStateInfo_SUCCEEDED RecommendationStateInfo_State = 3
	// Recommendation is in failed state. Recommendations content is immutable
	// and cannot be updated by Google.
	//
	// FAILED recommendations can be marked as SUCCEEDED, or FAILED.
	RecommendationStateInfo_FAILED RecommendationStateInfo_State = 4
	// Recommendation is in dismissed state. Recommendation content can be
	// updated by Google.
	//
	// DISMISSED recommendations can be marked as ACTIVE.
	RecommendationStateInfo_DISMISSED RecommendationStateInfo_State = 5
)

// Enum value maps for RecommendationStateInfo_State.
var (
	RecommendationStateInfo_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "ACTIVE",
		6: "CLAIMED",
		3: "SUCCEEDED",
		4: "FAILED",
		5: "DISMISSED",
	}
	RecommendationStateInfo_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"ACTIVE":            1,
		"CLAIMED":           6,
		"SUCCEEDED":         3,
		"FAILED":            4,
		"DISMISSED":         5,
	}
)

func (x RecommendationStateInfo_State) Enum() *RecommendationStateInfo_State {
	p := new(RecommendationStateInfo_State)
	*p = x
	return p
}

func (x RecommendationStateInfo_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RecommendationStateInfo_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_recommender_v1_recommendation_proto_enumTypes[1].Descriptor()
}

func (RecommendationStateInfo_State) Type() protoreflect.EnumType {
	return &file_google_cloud_recommender_v1_recommendation_proto_enumTypes[1]
}

func (x RecommendationStateInfo_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RecommendationStateInfo_State.Descriptor instead.
func (RecommendationStateInfo_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_recommender_v1_recommendation_proto_rawDescGZIP(), []int{7, 0}
}

// A recommendation along with a suggested action. E.g., a rightsizing
// recommendation for an underutilized VM, IAM role recommendations, etc
type Recommendation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of recommendation.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Free-form human readable summary in English. The maximum length is 500
	// characters.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Contains an identifier for a subtype of recommendations produced for the
	// same recommender. Subtype is a function of content and impact, meaning a
	// new subtype might be added when significant changes to `content` or
	// `primary_impact.category` are introduced. See the Recommenders section
	// to see a list of subtypes for a given Recommender.
	//
	// Examples:
	//   For recommender = "google.iam.policy.Recommender",
	//   recommender_subtype can be one of "REMOVE_ROLE"/"REPLACE_ROLE"
	RecommenderSubtype string `protobuf:"bytes,12,opt,name=recommender_subtype,json=recommenderSubtype,proto3" json:"recommender_subtype,omitempty"`
	// Last time this recommendation was refreshed by the system that created it
	// in the first place.
	LastRefreshTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=last_refresh_time,json=lastRefreshTime,proto3" json:"last_refresh_time,omitempty"`
	// The primary impact that this recommendation can have while trying to
	// optimize for one category.
	PrimaryImpact *Impact `protobuf:"bytes,5,opt,name=primary_impact,json=primaryImpact,proto3" json:"primary_impact,omitempty"`
	// Optional set of additional impact that this recommendation may have when
	// trying to optimize for the primary category. These may be positive
	// or negative.
	AdditionalImpact []*Impact `protobuf:"bytes,6,rep,name=additional_impact,json=additionalImpact,proto3" json:"additional_impact,omitempty"`
	// Content of the recommendation describing recommended changes to resources.
	Content *RecommendationContent `protobuf:"bytes,7,opt,name=content,proto3" json:"content,omitempty"`
	// Information for state. Contains state and metadata.
	StateInfo *RecommendationStateInfo `protobuf:"bytes,10,opt,name=state_info,json=stateInfo,proto3" json:"state_info,omitempty"`
	// Fingerprint of the Recommendation. Provides optimistic locking when
	// updating states.
	Etag string `protobuf:"bytes,11,opt,name=etag,proto3" json:"etag,omitempty"`
	// Insights that led to this recommendation.
	AssociatedInsights []*Recommendation_InsightReference `protobuf:"bytes,14,rep,name=associated_insights,json=associatedInsights,proto3" json:"associated_insights,omitempty"`
}

func (x *Recommendation) Reset() {
	*x = Recommendation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_recommender_v1_recommendation_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Recommendation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Recommendation) ProtoMessage() {}

func (x *Recommendation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_recommender_v1_recommendation_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Recommendation.ProtoReflect.Descriptor instead.
func (*Recommendation) Descriptor() ([]byte, []int) {
	return file_google_cloud_recommender_v1_recommendation_proto_rawDescGZIP(), []int{0}
}

func (x *Recommendation) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Recommendation) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Recommendation) GetRecommenderSubtype() string {
	if x != nil {
		return x.RecommenderSubtype
	}
	return ""
}

func (x *Recommendation) GetLastRefreshTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LastRefreshTime
	}
	return nil
}

func (x *Recommendation) GetPrimaryImpact() *Impact {
	if x != nil {
		return x.PrimaryImpact
	}
	return nil
}

func (x *Recommendation) GetAdditionalImpact() []*Impact {
	if x != nil {
		return x.AdditionalImpact
	}
	return nil
}

func (x *Recommendation) GetContent() *RecommendationContent {
	if x != nil {
		return x.Content
	}
	return nil
}

func (x *Recommendation) GetStateInfo() *RecommendationStateInfo {
	if x != nil {
		return x.StateInfo
	}
	return nil
}

func (x *Recommendation) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *Recommendation) GetAssociatedInsights() []*Recommendation_InsightReference {
	if x != nil {
		return x.AssociatedInsights
	}
	return nil
}

// Contains what resources are changing and how they are changing.
type RecommendationContent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Operations to one or more Google Cloud resources grouped in such a way
	// that, all operations within one group are expected to be performed
	// atomically and in an order.
	OperationGroups []*OperationGroup `protobuf:"bytes,2,rep,name=operation_groups,json=operationGroups,proto3" json:"operation_groups,omitempty"`
}

func (x *RecommendationContent) Reset() {
	*x = RecommendationContent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_recommender_v1_recommendation_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RecommendationContent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RecommendationContent) ProtoMessage() {}

func (x *RecommendationContent) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_recommender_v1_recommendation_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RecommendationContent.ProtoReflect.Descriptor instead.
func (*RecommendationContent) Descriptor() ([]byte, []int) {
	return file_google_cloud_recommender_v1_recommendation_proto_rawDescGZIP(), []int{1}
}

func (x *RecommendationContent) GetOperationGroups() []*OperationGroup {
	if x != nil {
		return x.OperationGroups
	}
	return nil
}

// Group of operations that need to be performed atomically.
type OperationGroup struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of operations across one or more resources that belong to this group.
	// Loosely based on RFC6902 and should be performed in the order they appear.
	Operations []*Operation `protobuf:"bytes,1,rep,name=operations,proto3" json:"operations,omitempty"`
}

func (x *OperationGroup) Reset() {
	*x = OperationGroup{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_recommender_v1_recommendation_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OperationGroup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OperationGroup) ProtoMessage() {}

func (x *OperationGroup) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_recommender_v1_recommendation_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OperationGroup.ProtoReflect.Descriptor instead.
func (*OperationGroup) Descriptor() ([]byte, []int) {
	return file_google_cloud_recommender_v1_recommendation_proto_rawDescGZIP(), []int{2}
}

func (x *OperationGroup) GetOperations() []*Operation {
	if x != nil {
		return x.Operations
	}
	return nil
}

// Contains an operation for a resource loosely based on the JSON-PATCH format
// with support for:
//
// * Custom filters for describing partial array patch.
// * Extended path values for describing nested arrays.
// * Custom fields for describing the resource for which the operation is being
//   described.
// * Allows extension to custom operations not natively supported by RFC6902.
// See https://tools.ietf.org/html/rfc6902 for details on the original RFC.
type Operation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Type of this operation. Contains one of 'and', 'remove', 'replace', 'move',
	// 'copy', 'test' and custom operations. This field is case-insensitive and
	// always populated.
	Action string `protobuf:"bytes,1,opt,name=action,proto3" json:"action,omitempty"`
	// Type of GCP resource being modified/tested. This field is always populated.
	// Example: cloudresourcemanager.googleapis.com/Project,
	// compute.googleapis.com/Instance
	ResourceType string `protobuf:"bytes,2,opt,name=resource_type,json=resourceType,proto3" json:"resource_type,omitempty"`
	// Contains the fully qualified resource name. This field is always populated.
	// ex: //cloudresourcemanager.googleapis.com/projects/foo.
	Resource string `protobuf:"bytes,3,opt,name=resource,proto3" json:"resource,omitempty"`
	// Path to the target field being operated on. If the operation is at the
	// resource level, then path should be "/". This field is always populated.
	Path string `protobuf:"bytes,4,opt,name=path,proto3" json:"path,omitempty"`
	// Can be set with action 'copy' to copy resource configuration across
	// different resources of the same type. Example: A resource clone can be
	// done via action = 'copy', path = "/", from = "/",
	// source_resource = <source> and resource_name = <target>.
	// This field is empty for all other values of `action`.
	SourceResource string `protobuf:"bytes,5,opt,name=source_resource,json=sourceResource,proto3" json:"source_resource,omitempty"`
	// Can be set with action 'copy' or 'move' to indicate the source field within
	// resource or source_resource, ignored if provided for other operation types.
	SourcePath string `protobuf:"bytes,6,opt,name=source_path,json=sourcePath,proto3" json:"source_path,omitempty"`
	// One of the fields in the following block will be set and intend to
	// describe a value for 'path' field.
	//
	// Types that are assignable to PathValue:
	//	*Operation_Value
	//	*Operation_ValueMatcher
	PathValue isOperation_PathValue `protobuf_oneof:"path_value"`
	// Set of filters to apply if `path` refers to array elements or nested array
	// elements in order to narrow down to a single unique element that is being
	// tested/modified.
	// This is intended to be an exact match per filter. To perform advanced
	// matching, use path_value_matchers.
	//
	// * Example: {
	//   "/versions/*/name" : "it-123"
	//   "/versions/*/targetSize/percent": 20
	//  }
	// * Example: {
	//   "/bindings/*/role": "roles/owner"
	//   "/bindings/*/condition" : null
	//  }
	// * Example: {
	//   "/bindings/*/role": "roles/owner"
	//   "/bindings/*/members/*" : ["x@example.com", "y@example.com"]
	//  }
	// When both path_filters and path_value_matchers are set, an implicit AND
	// must be performed.
	PathFilters map[string]*structpb.Value `protobuf:"bytes,8,rep,name=path_filters,json=pathFilters,proto3" json:"path_filters,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Similar to path_filters, this contains set of filters to apply if `path`
	// field referes to array elements. This is meant to support value matching
	// beyond exact match. To perform exact match, use path_filters.
	// When both path_filters and path_value_matchers are set, an implicit AND
	// must be performed.
	PathValueMatchers map[string]*ValueMatcher `protobuf:"bytes,11,rep,name=path_value_matchers,json=pathValueMatchers,proto3" json:"path_value_matchers,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *Operation) Reset() {
	*x = Operation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_recommender_v1_recommendation_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Operation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Operation) ProtoMessage() {}

func (x *Operation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_recommender_v1_recommendation_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Operation.ProtoReflect.Descriptor instead.
func (*Operation) Descriptor() ([]byte, []int) {
	return file_google_cloud_recommender_v1_recommendation_proto_rawDescGZIP(), []int{3}
}

func (x *Operation) GetAction() string {
	if x != nil {
		return x.Action
	}
	return ""
}

func (x *Operation) GetResourceType() string {
	if x != nil {
		return x.ResourceType
	}
	return ""
}

func (x *Operation) GetResource() string {
	if x != nil {
		return x.Resource
	}
	return ""
}

func (x *Operation) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *Operation) GetSourceResource() string {
	if x != nil {
		return x.SourceResource
	}
	return ""
}

func (x *Operation) GetSourcePath() string {
	if x != nil {
		return x.SourcePath
	}
	return ""
}

func (m *Operation) GetPathValue() isOperation_PathValue {
	if m != nil {
		return m.PathValue
	}
	return nil
}

func (x *Operation) GetValue() *structpb.Value {
	if x, ok := x.GetPathValue().(*Operation_Value); ok {
		return x.Value
	}
	return nil
}

func (x *Operation) GetValueMatcher() *ValueMatcher {
	if x, ok := x.GetPathValue().(*Operation_ValueMatcher); ok {
		return x.ValueMatcher
	}
	return nil
}

func (x *Operation) GetPathFilters() map[string]*structpb.Value {
	if x != nil {
		return x.PathFilters
	}
	return nil
}

func (x *Operation) GetPathValueMatchers() map[string]*ValueMatcher {
	if x != nil {
		return x.PathValueMatchers
	}
	return nil
}

type isOperation_PathValue interface {
	isOperation_PathValue()
}

type Operation_Value struct {
	// Value for the `path` field. Will be set for actions:'add'/'replace'.
	// Maybe set for action: 'test'. Either this or `value_matcher` will be set
	// for 'test' operation. An exact match must be performed.
	Value *structpb.Value `protobuf:"bytes,7,opt,name=value,proto3,oneof"`
}

type Operation_ValueMatcher struct {
	// Can be set for action 'test' for advanced matching for the value of
	// 'path' field. Either this or `value` will be set for 'test' operation.
	ValueMatcher *ValueMatcher `protobuf:"bytes,10,opt,name=value_matcher,json=valueMatcher,proto3,oneof"`
}

func (*Operation_Value) isOperation_PathValue() {}

func (*Operation_ValueMatcher) isOperation_PathValue() {}

// Contains various matching options for values for a GCP resource field.
type ValueMatcher struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to MatchVariant:
	//	*ValueMatcher_MatchesPattern
	MatchVariant isValueMatcher_MatchVariant `protobuf_oneof:"match_variant"`
}

func (x *ValueMatcher) Reset() {
	*x = ValueMatcher{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_recommender_v1_recommendation_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ValueMatcher) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValueMatcher) ProtoMessage() {}

func (x *ValueMatcher) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_recommender_v1_recommendation_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValueMatcher.ProtoReflect.Descriptor instead.
func (*ValueMatcher) Descriptor() ([]byte, []int) {
	return file_google_cloud_recommender_v1_recommendation_proto_rawDescGZIP(), []int{4}
}

func (m *ValueMatcher) GetMatchVariant() isValueMatcher_MatchVariant {
	if m != nil {
		return m.MatchVariant
	}
	return nil
}

func (x *ValueMatcher) GetMatchesPattern() string {
	if x, ok := x.GetMatchVariant().(*ValueMatcher_MatchesPattern); ok {
		return x.MatchesPattern
	}
	return ""
}

type isValueMatcher_MatchVariant interface {
	isValueMatcher_MatchVariant()
}

type ValueMatcher_MatchesPattern struct {
	// To be used for full regex matching. The regular expression is using the
	// Google RE2 syntax (https://github.com/google/re2/wiki/Syntax), so to be
	// used with RE2::FullMatch
	MatchesPattern string `protobuf:"bytes,1,opt,name=matches_pattern,json=matchesPattern,proto3,oneof"`
}

func (*ValueMatcher_MatchesPattern) isValueMatcher_MatchVariant() {}

// Contains metadata about how much money a recommendation can save or incur.
type CostProjection struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// An approximate projection on amount saved or amount incurred. Negative cost
	// units indicate cost savings and positive cost units indicate increase.
	// See google.type.Money documentation for positive/negative units.
	Cost *money.Money `protobuf:"bytes,1,opt,name=cost,proto3" json:"cost,omitempty"`
	// Duration for which this cost applies.
	Duration *durationpb.Duration `protobuf:"bytes,2,opt,name=duration,proto3" json:"duration,omitempty"`
}

func (x *CostProjection) Reset() {
	*x = CostProjection{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_recommender_v1_recommendation_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CostProjection) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CostProjection) ProtoMessage() {}

func (x *CostProjection) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_recommender_v1_recommendation_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CostProjection.ProtoReflect.Descriptor instead.
func (*CostProjection) Descriptor() ([]byte, []int) {
	return file_google_cloud_recommender_v1_recommendation_proto_rawDescGZIP(), []int{5}
}

func (x *CostProjection) GetCost() *money.Money {
	if x != nil {
		return x.Cost
	}
	return nil
}

func (x *CostProjection) GetDuration() *durationpb.Duration {
	if x != nil {
		return x.Duration
	}
	return nil
}

// Contains the impact a recommendation can have for a given category.
type Impact struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Category that is being targeted.
	Category Impact_Category `protobuf:"varint,1,opt,name=category,proto3,enum=google.cloud.recommender.v1.Impact_Category" json:"category,omitempty"`
	// Contains projections (if any) for this category.
	//
	// Types that are assignable to Projection:
	//	*Impact_CostProjection
	Projection isImpact_Projection `protobuf_oneof:"projection"`
}

func (x *Impact) Reset() {
	*x = Impact{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_recommender_v1_recommendation_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Impact) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Impact) ProtoMessage() {}

func (x *Impact) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_recommender_v1_recommendation_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Impact.ProtoReflect.Descriptor instead.
func (*Impact) Descriptor() ([]byte, []int) {
	return file_google_cloud_recommender_v1_recommendation_proto_rawDescGZIP(), []int{6}
}

func (x *Impact) GetCategory() Impact_Category {
	if x != nil {
		return x.Category
	}
	return Impact_CATEGORY_UNSPECIFIED
}

func (m *Impact) GetProjection() isImpact_Projection {
	if m != nil {
		return m.Projection
	}
	return nil
}

func (x *Impact) GetCostProjection() *CostProjection {
	if x, ok := x.GetProjection().(*Impact_CostProjection); ok {
		return x.CostProjection
	}
	return nil
}

type isImpact_Projection interface {
	isImpact_Projection()
}

type Impact_CostProjection struct {
	// Use with CategoryType.COST
	CostProjection *CostProjection `protobuf:"bytes,100,opt,name=cost_projection,json=costProjection,proto3,oneof"`
}

func (*Impact_CostProjection) isImpact_Projection() {}

// Information for state. Contains state and metadata.
type RecommendationStateInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The state of the recommendation, Eg ACTIVE, SUCCEEDED, FAILED.
	State RecommendationStateInfo_State `protobuf:"varint,1,opt,name=state,proto3,enum=google.cloud.recommender.v1.RecommendationStateInfo_State" json:"state,omitempty"`
	// A map of metadata for the state, provided by user or automations systems.
	StateMetadata map[string]string `protobuf:"bytes,2,rep,name=state_metadata,json=stateMetadata,proto3" json:"state_metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *RecommendationStateInfo) Reset() {
	*x = RecommendationStateInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_recommender_v1_recommendation_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RecommendationStateInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RecommendationStateInfo) ProtoMessage() {}

func (x *RecommendationStateInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_recommender_v1_recommendation_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RecommendationStateInfo.ProtoReflect.Descriptor instead.
func (*RecommendationStateInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_recommender_v1_recommendation_proto_rawDescGZIP(), []int{7}
}

func (x *RecommendationStateInfo) GetState() RecommendationStateInfo_State {
	if x != nil {
		return x.State
	}
	return RecommendationStateInfo_STATE_UNSPECIFIED
}

func (x *RecommendationStateInfo) GetStateMetadata() map[string]string {
	if x != nil {
		return x.StateMetadata
	}
	return nil
}

// Reference to an associated insight.
type Recommendation_InsightReference struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Insight resource name, e.g.
	// projects/[PROJECT_NUMBER]/locations/[LOCATION]/insightTypes/[INSIGHT_TYPE_ID]/insights/[INSIGHT_ID]
	Insight string `protobuf:"bytes,1,opt,name=insight,proto3" json:"insight,omitempty"`
}

func (x *Recommendation_InsightReference) Reset() {
	*x = Recommendation_InsightReference{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_recommender_v1_recommendation_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Recommendation_InsightReference) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Recommendation_InsightReference) ProtoMessage() {}

func (x *Recommendation_InsightReference) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_recommender_v1_recommendation_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Recommendation_InsightReference.ProtoReflect.Descriptor instead.
func (*Recommendation_InsightReference) Descriptor() ([]byte, []int) {
	return file_google_cloud_recommender_v1_recommendation_proto_rawDescGZIP(), []int{0, 0}
}

func (x *Recommendation_InsightReference) GetInsight() string {
	if x != nil {
		return x.Insight
	}
	return ""
}

var File_google_cloud_recommender_v1_recommendation_proto protoreflect.FileDescriptor

var file_google_cloud_recommender_v1_recommendation_proto_rawDesc = []byte{
	0x0a, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x72,
	0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x72, 0x65,
	0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x1a,
	0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75,
	0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x6d, 0x6f, 0x6e, 0x65, 0x79, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0x8e, 0x09, 0x0a, 0x0e, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2f, 0x0a, 0x13, 0x72,
	0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x5f, 0x73, 0x75, 0x62, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d,
	0x65, 0x6e, 0x64, 0x65, 0x72, 0x53, 0x75, 0x62, 0x74, 0x79, 0x70, 0x65, 0x12, 0x46, 0x0a, 0x11,
	0x6c, 0x61, 0x73, 0x74, 0x5f, 0x72, 0x65, 0x66, 0x72, 0x65, 0x73, 0x68, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x0f, 0x6c, 0x61, 0x73, 0x74, 0x52, 0x65, 0x66, 0x72, 0x65, 0x73, 0x68,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x4a, 0x0a, 0x0e, 0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x5f,
	0x69, 0x6d, 0x70, 0x61, 0x63, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x6f,
	0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6d, 0x70, 0x61, 0x63,
	0x74, 0x52, 0x0d, 0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x49, 0x6d, 0x70, 0x61, 0x63, 0x74,
	0x12, 0x50, 0x0a, 0x11, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f, 0x69,
	0x6d, 0x70, 0x61, 0x63, 0x74, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x6f, 0x6d,
	0x6d, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6d, 0x70, 0x61, 0x63, 0x74,
	0x52, 0x10, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x49, 0x6d, 0x70, 0x61,
	0x63, 0x74, 0x12, 0x4c, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x12, 0x53, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x0a,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x09, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x12, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x0b, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x12, 0x6d, 0x0a, 0x13, 0x61, 0x73, 0x73,
	0x6f, 0x63, 0x69, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73,
	0x18, 0x0e, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x49, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x52, 0x65, 0x66, 0x65, 0x72,
	0x65, 0x6e, 0x63, 0x65, 0x52, 0x12, 0x61, 0x73, 0x73, 0x6f, 0x63, 0x69, 0x61, 0x74, 0x65, 0x64,
	0x49, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x1a, 0x2c, 0x0a, 0x10, 0x49, 0x6e, 0x73, 0x69,
	0x67, 0x68, 0x74, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07,
	0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x69,
	0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x3a, 0xda, 0x03, 0xea, 0x41, 0xd6, 0x03, 0x0a, 0x29, 0x72,
	0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d,
	0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x63, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x7d, 0x2f, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x7b,
	0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x7d, 0x2f, 0x72, 0x65, 0x63,
	0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x72, 0x65,
	0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x12, 0x72, 0x62,
	0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x7b,
	0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x7d,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x65,
	0x72, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x7d,
	0x2f, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x7b, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x7d, 0x12, 0x61, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x66, 0x6f, 0x6c, 0x64,
	0x65, 0x72, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65,
	0x6e, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64,
	0x65, 0x72, 0x7d, 0x2f, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x7d, 0x12, 0x6d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e,
	0x64, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x65,
	0x72, 0x7d, 0x2f, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x7d, 0x22, 0x6f, 0x0a, 0x15, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x56, 0x0a, 0x10,
	0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x52, 0x0f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x73, 0x22, 0x58, 0x0a, 0x0e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x46, 0x0a, 0x0a, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d,
	0x65, 0x6e, 0x64, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x0a, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0xe6,
	0x05, 0x0a, 0x09, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x16, 0x0a, 0x06,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x23, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x12, 0x27, 0x0a, 0x0f, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0e, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x70, 0x61, 0x74,
	0x68, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x50,
	0x61, 0x74, 0x68, 0x12, 0x2e, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x48, 0x00, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x12, 0x50, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x6d, 0x61, 0x74,
	0x63, 0x68, 0x65, 0x72, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d,
	0x65, 0x6e, 0x64, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x4d, 0x61,
	0x74, 0x63, 0x68, 0x65, 0x72, 0x48, 0x00, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x4d, 0x61,
	0x74, 0x63, 0x68, 0x65, 0x72, 0x12, 0x5a, 0x0a, 0x0c, 0x70, 0x61, 0x74, 0x68, 0x5f, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x6f, 0x6d,
	0x6d, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x50, 0x61, 0x74, 0x68, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x52, 0x0b, 0x70, 0x61, 0x74, 0x68, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x73, 0x12, 0x6d, 0x0a, 0x13, 0x70, 0x61, 0x74, 0x68, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f,
	0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65,
	0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x50, 0x61, 0x74, 0x68, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x11, 0x70,
	0x61, 0x74, 0x68, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x73,
	0x1a, 0x56, 0x0a, 0x10, 0x50, 0x61, 0x74, 0x68, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x2c, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x6f, 0x0a, 0x16, 0x50, 0x61, 0x74, 0x68,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x3f, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x42, 0x0c, 0x0a, 0x0a, 0x70, 0x61, 0x74,
	0x68, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x4a, 0x0a, 0x0c, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x12, 0x29, 0x0a, 0x0f, 0x6d, 0x61, 0x74, 0x63, 0x68,
	0x65, 0x73, 0x5f, 0x70, 0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x48, 0x00, 0x52, 0x0e, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x50, 0x61, 0x74, 0x74, 0x65,
	0x72, 0x6e, 0x42, 0x0f, 0x0a, 0x0d, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x76, 0x61, 0x72, 0x69,
	0x61, 0x6e, 0x74, 0x22, 0x6f, 0x0a, 0x0e, 0x43, 0x6f, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x26, 0x0a, 0x04, 0x63, 0x6f, 0x73, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70,
	0x65, 0x2e, 0x4d, 0x6f, 0x6e, 0x65, 0x79, 0x52, 0x04, 0x63, 0x6f, 0x73, 0x74, 0x12, 0x35, 0x0a,
	0x08, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x64, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x9a, 0x02, 0x0a, 0x06, 0x49, 0x6d, 0x70, 0x61, 0x63, 0x74, 0x12,
	0x48, 0x0a, 0x08, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x49, 0x6d, 0x70, 0x61, 0x63, 0x74, 0x2e, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x52,
	0x08, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x12, 0x56, 0x0a, 0x0f, 0x63, 0x6f, 0x73,
	0x74, 0x5f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x64, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x6f, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x48,
	0x00, 0x52, 0x0e, 0x63, 0x6f, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x60, 0x0a, 0x08, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x12, 0x18, 0x0a,
	0x14, 0x43, 0x41, 0x54, 0x45, 0x47, 0x4f, 0x52, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x43, 0x4f, 0x53, 0x54, 0x10,
	0x01, 0x12, 0x0c, 0x0a, 0x08, 0x53, 0x45, 0x43, 0x55, 0x52, 0x49, 0x54, 0x59, 0x10, 0x02, 0x12,
	0x0f, 0x0a, 0x0b, 0x50, 0x45, 0x52, 0x46, 0x4f, 0x52, 0x4d, 0x41, 0x4e, 0x43, 0x45, 0x10, 0x03,
	0x12, 0x11, 0x0a, 0x0d, 0x4d, 0x41, 0x4e, 0x41, 0x47, 0x45, 0x41, 0x42, 0x49, 0x4c, 0x49, 0x54,
	0x59, 0x10, 0x04, 0x42, 0x0c, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x80, 0x03, 0x0a, 0x17, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x50, 0x0a,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x6f,
	0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x6d,
	0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x49, 0x6e,
	0x66, 0x6f, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x6e, 0x0a, 0x0e, 0x73, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x52, 0x0d, 0x73, 0x74, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x1a,
	0x40, 0x0a, 0x12, 0x53, 0x74, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38,
	0x01, 0x22, 0x61, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54,
	0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12, 0x0b, 0x0a,
	0x07, 0x43, 0x4c, 0x41, 0x49, 0x4d, 0x45, 0x44, 0x10, 0x06, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55,
	0x43, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49,
	0x4c, 0x45, 0x44, 0x10, 0x04, 0x12, 0x0d, 0x0a, 0x09, 0x44, 0x49, 0x53, 0x4d, 0x49, 0x53, 0x53,
	0x45, 0x44, 0x10, 0x05, 0x42, 0xe3, 0x03, 0x0a, 0x1f, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d,
	0x65, 0x6e, 0x64, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x50, 0x01, 0x5a, 0x46, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65,
	0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e,
	0x64, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x3b, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64,
	0x65, 0x72, 0xa2, 0x02, 0x04, 0x43, 0x52, 0x45, 0x43, 0xaa, 0x02, 0x1b, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65,
	0x6e, 0x64, 0x65, 0x72, 0x2e, 0x56, 0x31, 0xea, 0x41, 0xcf, 0x02, 0x0a, 0x26, 0x72, 0x65, 0x63,
	0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e,
	0x64, 0x65, 0x72, 0x12, 0x42, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x72, 0x65, 0x63,
	0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x63, 0x6f, 0x6d,
	0x6d, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x7d, 0x12, 0x51, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67,
	0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e,
	0x67, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f,
	0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x72, 0x65,
	0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x7d, 0x12, 0x40, 0x66, 0x6f, 0x6c, 0x64,
	0x65, 0x72, 0x73, 0x2f, 0x7b, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x7d, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x7d, 0x2f, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x7b,
	0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x7d, 0x12, 0x4c, 0x6f, 0x72,
	0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6f, 0x72, 0x67,
	0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f,
	0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x72, 0x65,
	0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x7d, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x33,
}

var (
	file_google_cloud_recommender_v1_recommendation_proto_rawDescOnce sync.Once
	file_google_cloud_recommender_v1_recommendation_proto_rawDescData = file_google_cloud_recommender_v1_recommendation_proto_rawDesc
)

func file_google_cloud_recommender_v1_recommendation_proto_rawDescGZIP() []byte {
	file_google_cloud_recommender_v1_recommendation_proto_rawDescOnce.Do(func() {
		file_google_cloud_recommender_v1_recommendation_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_recommender_v1_recommendation_proto_rawDescData)
	})
	return file_google_cloud_recommender_v1_recommendation_proto_rawDescData
}

var file_google_cloud_recommender_v1_recommendation_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_recommender_v1_recommendation_proto_msgTypes = make([]protoimpl.MessageInfo, 12)
var file_google_cloud_recommender_v1_recommendation_proto_goTypes = []interface{}{
	(Impact_Category)(0),                    // 0: google.cloud.recommender.v1.Impact.Category
	(RecommendationStateInfo_State)(0),      // 1: google.cloud.recommender.v1.RecommendationStateInfo.State
	(*Recommendation)(nil),                  // 2: google.cloud.recommender.v1.Recommendation
	(*RecommendationContent)(nil),           // 3: google.cloud.recommender.v1.RecommendationContent
	(*OperationGroup)(nil),                  // 4: google.cloud.recommender.v1.OperationGroup
	(*Operation)(nil),                       // 5: google.cloud.recommender.v1.Operation
	(*ValueMatcher)(nil),                    // 6: google.cloud.recommender.v1.ValueMatcher
	(*CostProjection)(nil),                  // 7: google.cloud.recommender.v1.CostProjection
	(*Impact)(nil),                          // 8: google.cloud.recommender.v1.Impact
	(*RecommendationStateInfo)(nil),         // 9: google.cloud.recommender.v1.RecommendationStateInfo
	(*Recommendation_InsightReference)(nil), // 10: google.cloud.recommender.v1.Recommendation.InsightReference
	nil,                                     // 11: google.cloud.recommender.v1.Operation.PathFiltersEntry
	nil,                                     // 12: google.cloud.recommender.v1.Operation.PathValueMatchersEntry
	nil,                                     // 13: google.cloud.recommender.v1.RecommendationStateInfo.StateMetadataEntry
	(*timestamppb.Timestamp)(nil),           // 14: google.protobuf.Timestamp
	(*structpb.Value)(nil),                  // 15: google.protobuf.Value
	(*money.Money)(nil),                     // 16: google.type.Money
	(*durationpb.Duration)(nil),             // 17: google.protobuf.Duration
}
var file_google_cloud_recommender_v1_recommendation_proto_depIdxs = []int32{
	14, // 0: google.cloud.recommender.v1.Recommendation.last_refresh_time:type_name -> google.protobuf.Timestamp
	8,  // 1: google.cloud.recommender.v1.Recommendation.primary_impact:type_name -> google.cloud.recommender.v1.Impact
	8,  // 2: google.cloud.recommender.v1.Recommendation.additional_impact:type_name -> google.cloud.recommender.v1.Impact
	3,  // 3: google.cloud.recommender.v1.Recommendation.content:type_name -> google.cloud.recommender.v1.RecommendationContent
	9,  // 4: google.cloud.recommender.v1.Recommendation.state_info:type_name -> google.cloud.recommender.v1.RecommendationStateInfo
	10, // 5: google.cloud.recommender.v1.Recommendation.associated_insights:type_name -> google.cloud.recommender.v1.Recommendation.InsightReference
	4,  // 6: google.cloud.recommender.v1.RecommendationContent.operation_groups:type_name -> google.cloud.recommender.v1.OperationGroup
	5,  // 7: google.cloud.recommender.v1.OperationGroup.operations:type_name -> google.cloud.recommender.v1.Operation
	15, // 8: google.cloud.recommender.v1.Operation.value:type_name -> google.protobuf.Value
	6,  // 9: google.cloud.recommender.v1.Operation.value_matcher:type_name -> google.cloud.recommender.v1.ValueMatcher
	11, // 10: google.cloud.recommender.v1.Operation.path_filters:type_name -> google.cloud.recommender.v1.Operation.PathFiltersEntry
	12, // 11: google.cloud.recommender.v1.Operation.path_value_matchers:type_name -> google.cloud.recommender.v1.Operation.PathValueMatchersEntry
	16, // 12: google.cloud.recommender.v1.CostProjection.cost:type_name -> google.type.Money
	17, // 13: google.cloud.recommender.v1.CostProjection.duration:type_name -> google.protobuf.Duration
	0,  // 14: google.cloud.recommender.v1.Impact.category:type_name -> google.cloud.recommender.v1.Impact.Category
	7,  // 15: google.cloud.recommender.v1.Impact.cost_projection:type_name -> google.cloud.recommender.v1.CostProjection
	1,  // 16: google.cloud.recommender.v1.RecommendationStateInfo.state:type_name -> google.cloud.recommender.v1.RecommendationStateInfo.State
	13, // 17: google.cloud.recommender.v1.RecommendationStateInfo.state_metadata:type_name -> google.cloud.recommender.v1.RecommendationStateInfo.StateMetadataEntry
	15, // 18: google.cloud.recommender.v1.Operation.PathFiltersEntry.value:type_name -> google.protobuf.Value
	6,  // 19: google.cloud.recommender.v1.Operation.PathValueMatchersEntry.value:type_name -> google.cloud.recommender.v1.ValueMatcher
	20, // [20:20] is the sub-list for method output_type
	20, // [20:20] is the sub-list for method input_type
	20, // [20:20] is the sub-list for extension type_name
	20, // [20:20] is the sub-list for extension extendee
	0,  // [0:20] is the sub-list for field type_name
}

func init() { file_google_cloud_recommender_v1_recommendation_proto_init() }
func file_google_cloud_recommender_v1_recommendation_proto_init() {
	if File_google_cloud_recommender_v1_recommendation_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_recommender_v1_recommendation_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Recommendation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_recommender_v1_recommendation_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RecommendationContent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_recommender_v1_recommendation_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OperationGroup); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_recommender_v1_recommendation_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Operation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_recommender_v1_recommendation_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ValueMatcher); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_recommender_v1_recommendation_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CostProjection); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_recommender_v1_recommendation_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Impact); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_recommender_v1_recommendation_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RecommendationStateInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_recommender_v1_recommendation_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Recommendation_InsightReference); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_recommender_v1_recommendation_proto_msgTypes[3].OneofWrappers = []interface{}{
		(*Operation_Value)(nil),
		(*Operation_ValueMatcher)(nil),
	}
	file_google_cloud_recommender_v1_recommendation_proto_msgTypes[4].OneofWrappers = []interface{}{
		(*ValueMatcher_MatchesPattern)(nil),
	}
	file_google_cloud_recommender_v1_recommendation_proto_msgTypes[6].OneofWrappers = []interface{}{
		(*Impact_CostProjection)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_recommender_v1_recommendation_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   12,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_recommender_v1_recommendation_proto_goTypes,
		DependencyIndexes: file_google_cloud_recommender_v1_recommendation_proto_depIdxs,
		EnumInfos:         file_google_cloud_recommender_v1_recommendation_proto_enumTypes,
		MessageInfos:      file_google_cloud_recommender_v1_recommendation_proto_msgTypes,
	}.Build()
	File_google_cloud_recommender_v1_recommendation_proto = out.File
	file_google_cloud_recommender_v1_recommendation_proto_rawDesc = nil
	file_google_cloud_recommender_v1_recommendation_proto_goTypes = nil
	file_google_cloud_recommender_v1_recommendation_proto_depIdxs = nil
}
