// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package servicediscovery_test

import (
	"fmt"
	"strings"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awserr"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/servicediscovery"
)

var _ time.Duration
var _ strings.Reader
var _ aws.Config

func parseTime(layout, value string) *time.Time {
	t, err := time.Parse(layout, value)
	if err != nil {
		panic(err)
	}
	return &t
}

// Example: Create private DNS namespace
//
// Example: Create private DNS namespace
func ExampleServiceDiscovery_CreatePrivateDnsNamespace_shared00() {
	svc := servicediscovery.New(session.New())
	input := &servicediscovery.CreatePrivateDnsNamespaceInput{
		CreatorRequestId: aws.String("eedd6892-50f3-41b2-8af9-611d6e1d1a8c"),
		Name:             aws.String("example.com"),
		Vpc:              aws.String("vpc-1c56417b"),
	}

	result, err := svc.CreatePrivateDnsNamespace(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case servicediscovery.ErrCodeInvalidInput:
				fmt.Println(servicediscovery.ErrCodeInvalidInput, aerr.Error())
			case servicediscovery.ErrCodeNamespaceAlreadyExists:
				fmt.Println(servicediscovery.ErrCodeNamespaceAlreadyExists, aerr.Error())
			case servicediscovery.ErrCodeResourceLimitExceeded:
				fmt.Println(servicediscovery.ErrCodeResourceLimitExceeded, aerr.Error())
			case servicediscovery.ErrCodeDuplicateRequest:
				fmt.Println(servicediscovery.ErrCodeDuplicateRequest, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Example: Create service
//
// Example: Create service
func ExampleServiceDiscovery_CreateService_shared00() {
	svc := servicediscovery.New(session.New())
	input := &servicediscovery.CreateServiceInput{
		CreatorRequestId: aws.String("567c1193-6b00-4308-bd57-ad38a8822d25"),
		DnsConfig: &servicediscovery.DnsConfig{
			DnsRecords: []*servicediscovery.DnsRecord{
				{
					TTL:  aws.Int64(60),
					Type: aws.String("A"),
				},
			},
			NamespaceId:   aws.String("ns-ylexjili4cdxy3xm"),
			RoutingPolicy: aws.String("MULTIVALUE"),
		},
		Name:        aws.String("myservice"),
		NamespaceId: aws.String("ns-ylexjili4cdxy3xm"),
	}

	result, err := svc.CreateService(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case servicediscovery.ErrCodeInvalidInput:
				fmt.Println(servicediscovery.ErrCodeInvalidInput, aerr.Error())
			case servicediscovery.ErrCodeResourceLimitExceeded:
				fmt.Println(servicediscovery.ErrCodeResourceLimitExceeded, aerr.Error())
			case servicediscovery.ErrCodeNamespaceNotFound:
				fmt.Println(servicediscovery.ErrCodeNamespaceNotFound, aerr.Error())
			case servicediscovery.ErrCodeServiceAlreadyExists:
				fmt.Println(servicediscovery.ErrCodeServiceAlreadyExists, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Example: Delete namespace
//
// Example: Delete namespace
func ExampleServiceDiscovery_DeleteNamespace_shared00() {
	svc := servicediscovery.New(session.New())
	input := &servicediscovery.DeleteNamespaceInput{
		Id: aws.String("ns-ylexjili4cdxy3xm"),
	}

	result, err := svc.DeleteNamespace(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case servicediscovery.ErrCodeInvalidInput:
				fmt.Println(servicediscovery.ErrCodeInvalidInput, aerr.Error())
			case servicediscovery.ErrCodeNamespaceNotFound:
				fmt.Println(servicediscovery.ErrCodeNamespaceNotFound, aerr.Error())
			case servicediscovery.ErrCodeResourceInUse:
				fmt.Println(servicediscovery.ErrCodeResourceInUse, aerr.Error())
			case servicediscovery.ErrCodeDuplicateRequest:
				fmt.Println(servicediscovery.ErrCodeDuplicateRequest, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Example: Delete service
//
// Example: Delete service
func ExampleServiceDiscovery_DeleteService_shared00() {
	svc := servicediscovery.New(session.New())
	input := &servicediscovery.DeleteServiceInput{
		Id: aws.String("srv-p5zdwlg5uvvzjita"),
	}

	result, err := svc.DeleteService(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case servicediscovery.ErrCodeInvalidInput:
				fmt.Println(servicediscovery.ErrCodeInvalidInput, aerr.Error())
			case servicediscovery.ErrCodeServiceNotFound:
				fmt.Println(servicediscovery.ErrCodeServiceNotFound, aerr.Error())
			case servicediscovery.ErrCodeResourceInUse:
				fmt.Println(servicediscovery.ErrCodeResourceInUse, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Example: Deregister a service instance
//
// Example: Deregister a service instance
func ExampleServiceDiscovery_DeregisterInstance_shared00() {
	svc := servicediscovery.New(session.New())
	input := &servicediscovery.DeregisterInstanceInput{
		InstanceId: aws.String("myservice-53"),
		ServiceId:  aws.String("srv-p5zdwlg5uvvzjita"),
	}

	result, err := svc.DeregisterInstance(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case servicediscovery.ErrCodeDuplicateRequest:
				fmt.Println(servicediscovery.ErrCodeDuplicateRequest, aerr.Error())
			case servicediscovery.ErrCodeInvalidInput:
				fmt.Println(servicediscovery.ErrCodeInvalidInput, aerr.Error())
			case servicediscovery.ErrCodeInstanceNotFound:
				fmt.Println(servicediscovery.ErrCodeInstanceNotFound, aerr.Error())
			case servicediscovery.ErrCodeResourceInUse:
				fmt.Println(servicediscovery.ErrCodeResourceInUse, aerr.Error())
			case servicediscovery.ErrCodeServiceNotFound:
				fmt.Println(servicediscovery.ErrCodeServiceNotFound, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Example: Discover registered instances
//
// Example: Discover registered instances
func ExampleServiceDiscovery_DiscoverInstances_shared00() {
	svc := servicediscovery.New(session.New())
	input := &servicediscovery.DiscoverInstancesInput{
		HealthStatus:  aws.String("ALL"),
		MaxResults:    aws.Int64(10),
		NamespaceName: aws.String("example.com"),
		ServiceName:   aws.String("myservice"),
	}

	result, err := svc.DiscoverInstances(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case servicediscovery.ErrCodeServiceNotFound:
				fmt.Println(servicediscovery.ErrCodeServiceNotFound, aerr.Error())
			case servicediscovery.ErrCodeNamespaceNotFound:
				fmt.Println(servicediscovery.ErrCodeNamespaceNotFound, aerr.Error())
			case servicediscovery.ErrCodeInvalidInput:
				fmt.Println(servicediscovery.ErrCodeInvalidInput, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Example: Get operation result
//
// Example: Get operation result
func ExampleServiceDiscovery_GetOperation_shared00() {
	svc := servicediscovery.New(session.New())
	input := &servicediscovery.GetOperationInput{
		OperationId: aws.String("gv4g5meo7ndmeh4fqskygvk23d2fijwa-k9302yzd"),
	}

	result, err := svc.GetOperation(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case servicediscovery.ErrCodeInvalidInput:
				fmt.Println(servicediscovery.ErrCodeInvalidInput, aerr.Error())
			case servicediscovery.ErrCodeOperationNotFound:
				fmt.Println(servicediscovery.ErrCodeOperationNotFound, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Example: List service instances
//
// Example: List service instances
func ExampleServiceDiscovery_ListInstances_shared00() {
	svc := servicediscovery.New(session.New())
	input := &servicediscovery.ListInstancesInput{
		ServiceId: aws.String("srv-qzpwvt2tfqcegapy"),
	}

	result, err := svc.ListInstances(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case servicediscovery.ErrCodeServiceNotFound:
				fmt.Println(servicediscovery.ErrCodeServiceNotFound, aerr.Error())
			case servicediscovery.ErrCodeInvalidInput:
				fmt.Println(servicediscovery.ErrCodeInvalidInput, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Example: List namespaces
//
// Example: List namespaces
func ExampleServiceDiscovery_ListNamespaces_shared00() {
	svc := servicediscovery.New(session.New())
	input := &servicediscovery.ListNamespacesInput{}

	result, err := svc.ListNamespaces(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case servicediscovery.ErrCodeInvalidInput:
				fmt.Println(servicediscovery.ErrCodeInvalidInput, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Example: List services
//
// Example: List services
func ExampleServiceDiscovery_ListServices_shared00() {
	svc := servicediscovery.New(session.New())
	input := &servicediscovery.ListServicesInput{}

	result, err := svc.ListServices(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case servicediscovery.ErrCodeInvalidInput:
				fmt.Println(servicediscovery.ErrCodeInvalidInput, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Example: Register Instance
//
// Example: Register Instance
func ExampleServiceDiscovery_RegisterInstance_shared00() {
	svc := servicediscovery.New(session.New())
	input := &servicediscovery.RegisterInstanceInput{
		Attributes: map[string]*string{
			"AWS_INSTANCE_IPV4": aws.String("172.2.1.3"),
			"AWS_INSTANCE_PORT": aws.String("808"),
		},
		CreatorRequestId: aws.String("7a48a98a-72e6-4849-bfa7-1a458e030d7b"),
		InstanceId:       aws.String("myservice-53"),
		ServiceId:        aws.String("srv-p5zdwlg5uvvzjita"),
	}

	result, err := svc.RegisterInstance(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case servicediscovery.ErrCodeDuplicateRequest:
				fmt.Println(servicediscovery.ErrCodeDuplicateRequest, aerr.Error())
			case servicediscovery.ErrCodeInvalidInput:
				fmt.Println(servicediscovery.ErrCodeInvalidInput, aerr.Error())
			case servicediscovery.ErrCodeResourceInUse:
				fmt.Println(servicediscovery.ErrCodeResourceInUse, aerr.Error())
			case servicediscovery.ErrCodeResourceLimitExceeded:
				fmt.Println(servicediscovery.ErrCodeResourceLimitExceeded, aerr.Error())
			case servicediscovery.ErrCodeServiceNotFound:
				fmt.Println(servicediscovery.ErrCodeServiceNotFound, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}
