// Code generated by go-bindata. DO NOT EDIT.
// sources:
// assets/dns/cluster-role-binding.yaml (223B)
// assets/dns/cluster-role.yaml (397B)
// assets/dns/daemonset.yaml (6.125kB)
// assets/dns/metrics/cluster-role-binding.yaml (279B)
// assets/dns/metrics/cluster-role.yaml (246B)
// assets/dns/metrics/role-binding.yaml (293B)
// assets/dns/metrics/role.yaml (284B)
// assets/dns/namespace.yaml (369B)
// assets/dns/service-account.yaml (85B)
// assets/dns/service.yaml (520B)

package manifests

import (
	"bytes"
	"compress/gzip"
	"crypto/sha256"
	"fmt"
	"io"
	"io/ioutil"
	"os"
	"path/filepath"
	"strings"
	"time"
)

func bindataRead(data []byte, name string) ([]byte, error) {
	gz, err := gzip.NewReader(bytes.NewBuffer(data))
	if err != nil {
		return nil, fmt.Errorf("Read %q: %v", name, err)
	}

	var buf bytes.Buffer
	_, err = io.Copy(&buf, gz)
	clErr := gz.Close()

	if err != nil {
		return nil, fmt.Errorf("Read %q: %v", name, err)
	}
	if clErr != nil {
		return nil, err
	}

	return buf.Bytes(), nil
}

type asset struct {
	bytes  []byte
	info   os.FileInfo
	digest [sha256.Size]byte
}

type bindataFileInfo struct {
	name    string
	size    int64
	mode    os.FileMode
	modTime time.Time
}

func (fi bindataFileInfo) Name() string {
	return fi.name
}
func (fi bindataFileInfo) Size() int64 {
	return fi.size
}
func (fi bindataFileInfo) Mode() os.FileMode {
	return fi.mode
}
func (fi bindataFileInfo) ModTime() time.Time {
	return fi.modTime
}
func (fi bindataFileInfo) IsDir() bool {
	return false
}
func (fi bindataFileInfo) Sys() interface{} {
	return nil
}

var _assetsDnsClusterRoleBindingYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x6c\xce\x31\x8e\x83\x40\x0c\x05\xd0\x7e\x4e\xe1\x0b\xc0\x6a\xbb\xd5\x74\x9b\xdc\x80\x48\xe9\xcd\x8c\x09\x0e\x60\xa3\xb1\x87\x22\xa7\x8f\x10\x4a\x45\x3a\x17\xfe\xff\xfd\x89\x25\x47\xb8\xce\xd5\x9c\x4a\xa7\x33\x5d\x58\x32\xcb\x23\xe0\xca\x77\x2a\xc6\x2a\x11\x4a\x8f\xa9\xc5\xea\xa3\x16\x7e\xa1\xb3\x4a\x3b\xfd\x59\xcb\xfa\xb3\xfd\x86\x85\x1c\x33\x3a\xc6\x00\x00\x20\xb8\x50\x04\x5d\x49\x6c\xe4\xc1\x9b\x2c\x16\xac\xf6\x4f\x4a\x6e\x31\x34\x70\x78\x37\x2a\x1b\x27\xfa\x4f\x49\xab\x78\xf8\xc4\xf6\xe7\xe3\xb6\x15\xd3\xa9\xa7\xe8\x4c\x1d\x0d\x3b\x74\x9a\x1d\xbe\xd3\xef\x00\x00\x00\xff\xff\xfa\x62\xe7\x50\xdf\x00\x00\x00")

func assetsDnsClusterRoleBindingYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsClusterRoleBindingYaml,
		"assets/dns/cluster-role-binding.yaml",
	)
}

func assetsDnsClusterRoleBindingYaml() (*asset, error) {
	bytes, err := assetsDnsClusterRoleBindingYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/cluster-role-binding.yaml", size: 223, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0xd9, 0xf6, 0x2a, 0x3b, 0x84, 0xd7, 0x3e, 0xc4, 0xe1, 0x70, 0x66, 0x31, 0xda, 0xc4, 0x2f, 0x53, 0x27, 0x29, 0x13, 0xfe, 0x80, 0x36, 0xc5, 0xa1, 0x70, 0xdc, 0x2d, 0xef, 0xcf, 0xe0, 0xc4, 0xeb}}
	return a, nil
}

var _assetsDnsClusterRoleYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x7c\x90\xb1\x4e\xc4\x30\x10\x44\x7b\x7f\x85\x75\xfd\x05\xd1\xa1\xb4\x14\xf4\x14\xf4\x1b\x67\x50\x96\xe4\x76\xad\xdd\x75\x4e\xe2\xeb\x51\x2e\x57\xa0\x8b\xa0\x9b\x19\xd9\xf3\x3c\x9e\x59\xc6\x3e\xbf\x2e\xcd\x03\xf6\xae\x0b\x12\x55\xfe\x80\x39\xab\xf4\xd9\x06\x2a\x1d\xb5\x98\xd4\xf8\x9b\x82\x55\xba\xf9\xc5\x3b\xd6\xa7\xf5\x39\x5d\x10\x34\x52\x50\x9f\x72\x16\xba\xa0\xcf\x5a\x21\x3e\xf1\x67\x9c\x47\xf1\x64\x6d\x81\xf7\xe9\x9c\xa9\xf2\x9b\x69\xab\xbe\x9d\x3c\xe7\xd3\x29\xe5\x6c\x70\x6d\x56\x70\xcf\x20\x63\x55\x96\xf0\x9b\x73\xd8\xca\x05\xbb\xa9\x3a\xee\x62\x63\x78\xa5\x3d\x5f\x61\xc3\xfd\xee\xc2\x1e\x37\x71\xa5\x28\x53\x3a\x02\xb7\x01\x90\xe0\xf2\x7b\xc1\xf1\x0d\xa1\x33\xc4\xb0\x32\xae\x0f\x84\x62\xa0\xc0\x1f\xcd\x8f\x5f\x73\x2c\xf6\x36\x7c\xa1\x04\x95\x02\xf7\xff\x00\x3f\x01\x00\x00\xff\xff\x76\x1b\x55\x2e\x8d\x01\x00\x00")

func assetsDnsClusterRoleYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsClusterRoleYaml,
		"assets/dns/cluster-role.yaml",
	)
}

func assetsDnsClusterRoleYaml() (*asset, error) {
	bytes, err := assetsDnsClusterRoleYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/cluster-role.yaml", size: 397, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x84, 0xae, 0xd1, 0xba, 0xfa, 0x6b, 0xf8, 0x6e, 0x8d, 0x28, 0xc2, 0xa7, 0xaf, 0xc9, 0x3b, 0xc7, 0xcd, 0x80, 0xbe, 0xec, 0x98, 0xb4, 0x61, 0xa0, 0x9, 0xae, 0xa, 0xd8, 0xb2, 0x2e, 0x16, 0xf2}}
	return a, nil
}

var _assetsDnsDaemonsetYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xcc\x58\xdd\x73\xdb\x36\x12\x7f\xf7\x5f\xb1\xa1\x3d\x71\xd2\x9a\x92\x9c\xc4\x69\x8e\x89\x7b\x55\x65\xb9\xf6\x34\xb2\x35\x96\xd2\x3c\x78\x3c\x1a\x08\x5c\x89\x38\x81\x00\x0a\x80\xb4\x35\xb6\xfe\xf7\x1b\x90\xfa\xe0\x87\xac\x36\x77\xd3\x99\xe4\x41\x91\xb1\xbb\x3f\xec\x2e\xf6\x53\x33\x26\xc2\x00\xce\x08\xc6\x52\x0c\xd0\xee\x11\xc5\xfe\x40\x6d\x98\x14\x01\x10\xa5\x4c\x33\x3d\xde\xdb\x07\x41\x62\x3c\xca\x3e\x8d\x22\x14\x81\x88\x10\x38\x19\x23\x37\x40\x34\x82\x41\x0b\xc4\x82\x4e\x84\x65\x31\xee\x19\x85\x34\xd8\x03\xb0\x18\x2b\x4e\x2c\xba\xef\x00\xab\xd3\xec\x3b\xea\x94\x51\x6c\x53\x2a\x13\x61\xaf\x48\x8c\x01\x84\xc2\x2c\xa9\x4a\x33\xa9\x99\x9d\x77\x38\x31\x26\x27\x9a\xb9\xb1\x18\xfb\x42\x86\xe8\x53\xcd\x2c\xa3\x84\x2f\xb9\xa9\x14\x96\x30\x81\xda\xac\xd0\xfd\x4c\xd3\x22\x22\xc0\x3e\xb0\x98\x4c\x11\x98\xa9\x6a\xbb\xe2\xc8\xe8\xfd\x84\xf3\xbe\xe4\x8c\xce\x03\xb8\x9c\x5c\x49\xdb\xd7\x68\x50\xd8\x35\x97\x45\x1d\x33\x41\x2c\x93\xa2\x87\xc6\x38\x91\x25\xfb\x39\xe1\x7c\x4c\xe8\x6c\x28\x3f\xcb\xa9\xb9\x16\x5d\xad\xa5\x5e\xcb\x51\x19\xc7\xc4\xb9\xfa\x16\x3c\x2a\x35\x86\xc2\x78\x70\xb7\x26\x13\x3d\x35\x19\xcd\xa7\x52\x4c\xbc\x23\xf0\x9a\x68\x69\x73\xc9\xd9\xec\x48\x8d\x13\xc6\xb1\x28\x92\x4a\x9e\xc4\xd8\x73\x0e\x5c\x5b\xbe\xb1\xdd\xc1\xb0\xa9\x9f\x33\xad\xa9\x00\xb1\xe3\xef\x13\x1b\x05\x50\xbc\xa1\xc0\xa1\x91\x84\xd7\x82\xcf\x03\xb0\x3a\xd9\x88\x2a\xa9\xcb\xf7\xac\xfd\xde\x97\xda\x06\x70\xf2\xf6\xe4\x6d\x01\xa5\xfe\x02\xee\x5d\xa5\x95\x54\xf2\x00\xbe\x9c\xf5\xbf\x1d\xc9\xb7\x54\x6d\x45\x1b\x76\x36\x68\x4e\x7b\x26\xd0\x98\xbe\x96\x63\x0c\x0a\xfc\x91\xb5\xea\x37\xb4\xc5\x23\x00\x95\x7b\x22\x42\xc2\x6d\x54\xa6\x64\xba\x7c\x68\x7d\x68\x95\x8e\x0d\x8d\xd0\xe9\x73\x31\x1c\xf6\x0b\x04\x26\x98\x65\x84\x9f\x21\x27\xf3\x01\x52\x29\x42\x13\xc0\x71\x51\x54\xa1\x66\x32\xdc\x4e\x33\x09\xa5\x68\xcc\x30\xd2\x68\x22\xc9\xc3\x00\x8e\x0b\xd4\x09\x61\x3c\xd1\x58\xa0\x16\xdd\xe3\x62\x58\x26\x76\x1b\x30\x67\x29\x7e\x27\xae\x78\xdf\xda\xa1\xf2\xc9\xff\xe1\x8a\x93\xc2\xcb\x1b\x99\x68\x8a\xa6\x68\x16\x67\x31\xb3\xa6\x6c\x68\x8c\xb1\xd4\xf3\x00\x4e\x8e\xdf\xf4\x58\x29\xf0\xff\x4c\xd0\x54\xb9\xa9\x4a\x02\x38\x69\xc5\x5b\x21\x7e\x6a\xad\x11\x56\x89\x37\x4b\xc6\xe8\xeb\x31\xa1\xbe\xd2\xf2\x61\xfe\x0d\x05\x28\xab\x01\x85\xb4\xf0\x7d\x2e\xa7\x56\x1a\x1b\xa2\xd6\xa5\x73\x83\x34\xd1\xe8\x73\x66\x2c\x0a\x9f\x84\xa1\x46\x63\x4e\x83\x7f\x1d\x9f\xbc\x2b\xf1\x59\x6e\x7c\xca\x54\x84\xda\x37\x09\xb3\x68\x4e\x87\x9f\x07\xa3\x6e\xe7\xec\xa2\x3b\xba\x19\xb4\x47\x5f\x2f\x87\x17\xa3\x76\x77\x30\x3a\x7e\xf3\x61\xf4\x5b\xa7\x37\x1a\x5c\xb4\xdf\x9c\xbc\x3f\xda\x70\x75\x3b\x67\x7f\xc1\x57\xc3\xe9\xfc\xda\xf9\x5b\x38\x5b\xf9\x76\xa0\x95\x2c\x4b\x94\xb1\x1a\x49\x7c\xea\x42\x39\x68\x36\x8f\xdf\xfc\xd4\x68\x35\x5a\x8d\x63\xe7\x84\xb7\xcd\xba\x17\x50\x5b\xdf\x55\xd0\xd3\xac\xea\x59\x6e\x9a\x4a\xb3\x94\x58\x74\xdf\x1b\x54\xdb\x9a\xc8\x92\xee\xcf\x70\xbe\x43\x72\x86\xf3\xbf\x5d\x22\x4b\xef\xb3\x2a\x6c\x31\x5a\xcd\xa8\xd9\x1d\xc6\x3b\x42\xf3\xf8\x99\xd0\x7c\xd7\x2a\x04\xf7\x73\xbd\xa2\xda\x0d\x0a\xd6\x3d\xa7\xa8\xf3\xcd\x5f\x75\x8b\x42\x03\xce\x5b\xb6\x33\x8a\xa7\xa8\xbf\x9b\x76\x9c\x65\x90\x1b\x31\xa4\xb0\xf8\x50\xaa\x84\xce\x7e\xc6\x71\x8a\x61\xa5\x03\xee\x6e\xb8\x91\x34\xd6\x64\x81\xb2\xa3\xdb\x66\x4c\x05\x27\xa0\x48\xe1\xaa\xdd\xeb\x0e\xba\x37\x7f\x74\x6f\xb2\xb1\xaa\xf3\xf9\xcb\x60\xd8\xbd\x19\x9d\x5d\xf7\xda\x97\x57\xdb\xc6\xab\x95\x38\x8a\xb4\xae\x86\x43\xba\xec\x74\x07\x05\x25\xf6\xa1\xe3\x86\x0f\x90\x1a\xf2\xe9\xcd\xa0\x22\x9a\x58\x0c\xc1\x55\x10\x90\x93\xd5\x3c\x66\x4a\x52\x57\xd7\xc3\x6e\x00\xe7\x52\x83\x90\xf7\x47\x80\xc2\x24\x1a\xc1\x46\x68\x30\x53\x4b\x23\x27\x96\xa5\x98\xcf\x85\x1f\x61\x22\x35\x20\xa1\x51\x99\x70\x54\xc2\x24\x02\x08\x67\xc4\xc0\x3d\xb3\x91\xc3\xaa\xda\x6b\x92\xc9\x84\x3d\xc0\x3d\xe3\x1c\x08\x37\x12\xc6\x08\x24\x0c\x31\x6c\x14\x70\x52\xc2\x13\x0c\xc0\xcb\x62\xc4\xd7\x38\x65\xc6\xea\x79\x43\x2a\x14\x26\x62\x13\xeb\x57\x08\x26\xa5\x5e\x6d\x12\x2b\xb8\xae\x39\x66\xa2\x39\x26\x26\x2a\x16\x01\x5a\xf8\xe3\xa9\x68\xc4\x8b\x3a\x3b\x64\x6f\xe4\x27\x12\x14\x53\xe8\xba\xd4\x5e\xb1\xdf\x69\xa2\xe0\xf0\x3f\x72\x6c\xc0\x57\xf0\x04\x0f\xae\xd2\xc3\xcc\x99\xf8\xf4\x94\xc5\xd8\x47\xb8\x27\xcc\x7e\x04\x7c\x60\x16\x5a\x87\x30\xec\xde\xf4\x8a\x08\xd7\xfd\xee\xd5\xe0\xe2\xf2\x7c\x38\xea\xb5\x6f\x7e\xef\xde\x9c\x7a\x1b\x5b\xa7\x28\x30\x7b\xcd\x72\xaa\x79\x05\xf1\x8b\xeb\xc1\x70\x30\x3a\xbf\xfc\xdc\x3d\xf5\x36\x71\x58\xe4\x18\x76\x7b\xfd\x1a\x43\xc3\xc6\xca\x2b\xaa\x71\x79\x3e\x38\x3d\x3c\x82\xc3\x2c\xeb\xc1\xd7\xe0\x93\x75\xe8\xc0\xa7\x4f\x9f\xc0\x3b\x78\x5c\x05\xe0\xa2\x24\xb9\x0f\x3d\x32\x43\x20\xd9\x4e\x20\x35\xd1\x73\x70\xa9\xb2\x09\x03\xc9\xc3\x3c\x85\xb2\xf3\x43\x03\xc4\x5a\xcd\xc6\x89\x45\x53\x7c\x79\xaa\xc0\x9f\x80\xef\x6f\xa8\xbe\x14\x7c\xee\x2e\xde\x18\xb9\xf0\xdc\xdf\x6b\x93\xca\x9a\xdc\x47\xee\xde\xdc\xe9\xa1\x2c\x95\xce\x10\x29\x77\x81\xed\xb7\xc1\xa4\x74\xc4\x94\x29\x91\x5d\x7c\x9b\x94\x02\x13\x0e\x7e\x65\xf7\xed\x2f\x77\x0b\xaf\x06\xe5\x2c\x3e\x47\x4b\xa3\x95\x7f\xe0\xb2\x0f\x13\x2d\x63\xa0\x3c\x31\x16\xb5\xab\x8d\xc0\x26\xa0\xf2\x82\xd6\x80\xaf\x08\xb1\x73\x91\xc1\x14\x35\xe1\x60\x35\x43\x53\xc3\xb4\x12\x42\x09\xcc\x06\x70\xd9\x4f\xdf\x1d\xb9\xcf\xf7\xd9\xe7\x3b\x90\x29\x6a\x37\x0a\x67\x55\xc4\x9d\xaf\x4f\x1a\x30\x8c\x10\xec\xbd\x04\x4e\x5c\xbe\x8b\x2d\xc0\xce\x6e\x67\x60\x88\x8a\xcb\x79\x8c\xc2\x2e\x73\xf4\xf7\x44\xcf\x35\x48\xe1\x5e\x08\x35\x5c\x2b\x14\x03\x4b\xe8\x0c\x5e\x5d\x0f\xfa\xc7\x6f\x5f\x83\x0f\x36\x92\x06\x9d\x5e\x42\xda\x1a\xb0\x49\x94\xeb\x8b\x6e\xe4\x07\x2e\x49\x38\x26\x9c\x08\x8a\xda\x64\x7a\xba\xc6\xc6\xb2\x5a\x42\x68\xc4\xc4\x14\xce\xae\x06\x60\x23\x2d\x93\x69\x94\xa9\x5e\xc1\xa3\x71\x68\x4e\x5f\x1d\x86\x6c\x0a\xbe\x85\x36\xfc\xe2\x1d\x3c\x6e\x0a\xe8\xc2\x83\x1f\x4d\xe4\x6e\x73\x0f\x94\xd2\x45\xe3\xe0\xb1\x5c\x5f\x16\xde\x61\x05\x31\xff\xb7\x46\x6c\xb7\xff\x01\x50\xf8\xd1\x52\xf5\xcf\xe8\xfa\xbf\x22\xbf\xae\x40\xbb\xb7\x67\x2e\xb4\x0f\x1e\x5f\x38\x27\xdf\xfe\x70\xb7\xa8\xb0\xd4\x42\x1c\x80\x29\x73\xfa\xea\xe0\x15\xa6\x84\xbb\xcb\x32\x41\x76\xb7\xf0\x5e\x57\xe1\xc1\xc5\xfa\xed\x2d\x78\x07\xff\xf6\xc0\xc7\x3f\xa1\x05\x2f\x5f\x3a\x91\x7d\xa6\xf2\x14\x02\x5f\x20\xb4\xe0\xee\xee\xa3\xab\x07\x62\x8b\xe5\xcb\x9c\xbc\x5d\x5a\xe5\xdd\x9d\x7a\x07\x8f\x2b\xf1\x2d\xfc\x63\x8d\x64\x56\x3b\x9f\xb0\x9a\x59\x02\xf7\x6a\x07\xa5\x93\x7d\xf8\xa2\x42\x62\xb1\xd0\xc4\x21\x2b\x3b\x6c\x02\xf7\x08\x53\xb4\xae\x25\xb1\xb0\x90\xec\xa6\x02\xf0\x15\xf3\x9e\x26\xa4\x85\xa4\x06\x76\x1f\xa1\x70\x66\xeb\x6c\x22\x5a\xee\xe4\x6b\x34\x99\x58\x37\x2b\x49\x0d\x44\x31\x48\x04\x49\x09\xe3\x64\xcc\x38\xb3\xf3\xca\x35\x03\x4b\x38\x02\x8a\xac\x7a\x00\x95\x09\x0f\x5d\x53\x31\xd6\x3d\x6d\xe1\x42\x36\xc9\xaa\xee\xea\x06\x66\x20\x44\x8e\x16\xc3\xbd\xfa\x9b\xf9\x62\x19\x48\x99\xf7\x7f\xb8\xf3\x17\xde\x73\xcf\xb4\x0f\xbf\x26\x8c\x87\x40\x40\xe0\x7d\xa1\x9e\xe7\xa5\xaf\x68\xb0\x2b\x2d\x32\xd1\x40\x13\x63\x65\xbc\xd6\x78\xc2\xb8\x45\x8d\xa1\xb3\xb9\x82\x3d\xd5\xa8\xc0\x4f\xc1\xdb\x87\x83\xc7\x6a\x43\xcc\x4b\x7e\xa9\x05\xfc\xbc\xa3\x09\xe4\xba\xb6\x95\xc2\xac\x06\xe5\x1d\x73\xa3\x84\x2b\xf4\xf5\x89\x08\x6a\x3d\xe0\xc5\xca\x29\xcf\xf4\x80\x65\x5a\xa9\x3c\xaf\x56\xcc\x79\xf8\xde\x2d\xb6\x0a\x00\x20\x8d\x24\x64\x91\xbd\xc8\x85\x56\xff\xd5\xd3\x18\x9e\x71\xc5\xcf\x35\xdb\xab\x97\xd4\x82\x7e\x5b\xd8\x3b\x1f\x0d\xaf\xcf\xae\x83\x2d\xe1\x4f\xac\x8c\x19\x25\x9c\xcf\x5d\x4f\x22\xa9\x64\x21\x10\x31\x07\x26\xa8\x14\x26\x5b\x4c\x2d\x8c\x31\x22\x29\x2b\x8c\xdd\x2b\xd4\x1b\x54\xdc\x4d\xa2\xdb\x22\x22\x96\x21\x9b\x30\x0c\x21\xcd\x7f\x87\x74\x51\x28\x10\xc3\x4a\x6c\xba\x5e\xa0\x2a\x66\xd6\x62\xe0\xe9\x69\x39\x31\xec\xe6\xab\x5b\xbd\xe2\x75\x99\xe1\x52\x56\x63\x2c\x53\x0c\x37\xb6\x66\x51\x4d\x35\xba\x3d\x30\x4f\x9d\xac\x9f\x6d\xe6\x12\xa0\x52\xcd\x81\x46\x89\x2e\x27\x49\xa5\xfe\x18\x8e\xa8\xe0\x7d\x0b\x5e\x66\x23\x60\x89\x96\x08\x37\x55\xd6\x47\x91\xd2\xe3\x7d\xeb\xbe\x78\xb2\x5a\x17\x43\x61\x56\xbb\xd2\x19\x4e\x48\xc2\x57\x97\xbb\x31\x72\x80\x1c\xa9\x95\x7a\x03\x30\x4b\xc6\xa8\x05\xba\x79\x8c\xc9\xa6\x34\x01\x70\x26\x92\x87\x9c\xb8\xe4\xca\x37\xa4\xda\xef\xb0\xdb\x7f\x8b\xcc\x4f\x7b\x44\x05\x85\x85\xe8\x8a\xc4\xbb\x96\x42\x00\x66\x31\x2e\x99\xe5\xc3\x0c\xe7\x01\xac\x7e\x21\xdd\xf2\x93\x56\x85\xb4\x63\x61\x73\x47\xd9\xb6\xb6\x57\xc5\xd8\xb2\xbd\x01\xd8\xb9\xc2\x00\xce\xeb\xd0\xdb\x56\xe5\x7d\xb7\x73\x6a\xb4\x3b\x2d\xb4\x92\xbb\x59\x9e\x49\xb1\xb6\x71\x3f\x1b\x89\x5c\x02\x18\x17\x7d\x3a\x11\xe0\x26\xc4\xf9\xbd\xeb\x16\x0d\x18\xe6\x12\x08\x84\x73\xb0\x84\x89\xb5\x86\x3e\x48\xe5\x48\x52\x07\xd0\x75\x2d\xc0\xec\xfd\x37\x00\x00\xff\xff\x37\x6b\x53\x9e\xed\x17\x00\x00")

func assetsDnsDaemonsetYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsDaemonsetYaml,
		"assets/dns/daemonset.yaml",
	)
}

func assetsDnsDaemonsetYaml() (*asset, error) {
	bytes, err := assetsDnsDaemonsetYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/daemonset.yaml", size: 6125, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0xab, 0x41, 0xc9, 0x44, 0xa6, 0x16, 0x1f, 0xc4, 0x8f, 0x67, 0x41, 0x76, 0x65, 0xcd, 0x4c, 0x74, 0x3c, 0xc7, 0x76, 0xf9, 0x47, 0xda, 0x5b, 0xf0, 0x24, 0xcc, 0x1d, 0x2, 0xe9, 0xc4, 0x2d, 0x36}}
	return a, nil
}

var _assetsDnsMetricsClusterRoleBindingYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x7c\x8f\xb1\x4a\x04\x41\x0c\x86\xfb\x79\x8a\xbc\xc0\xae\xd8\x1d\xd3\xa9\x85\xfd\x09\xf6\xb9\x99\x9c\x1b\x77\x27\x19\x92\xcc\x16\x3e\xbd\x2c\x8a\x08\xe2\xb5\x81\x7c\xdf\xff\xad\x2c\x35\xc3\xd3\x36\x3c\xc8\xce\xba\xd1\x23\x4b\x65\x79\x4b\xd8\xf9\x95\xcc\x59\x25\x83\x5d\xb0\xcc\x38\x62\x51\xe3\x0f\x0c\x56\x99\xd7\x93\xcf\xac\x77\xfb\x7d\x6a\x14\x58\x31\x30\x27\x00\xc1\x46\x19\xaa\xf8\xd4\x54\x38\xd4\x0e\x92\x8f\xcb\x3b\x95\xf0\x9c\x26\xf8\xd2\xbd\x90\xed\x5c\xe8\xa1\x14\x1d\x12\x3f\x7f\xdd\xb4\x51\x2c\x34\x7c\x5a\x4f\xfe\x7d\xf6\x8e\x85\x32\x68\x27\xf1\x85\xaf\xf1\x9b\x6c\xba\xd1\x99\xae\x87\xf9\x4f\xc7\x7f\x6b\x00\xb0\xf3\xb3\xe9\xe8\x37\xba\xd2\x67\x00\x00\x00\xff\xff\x5b\x52\x00\xaa\x17\x01\x00\x00")

func assetsDnsMetricsClusterRoleBindingYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsMetricsClusterRoleBindingYaml,
		"assets/dns/metrics/cluster-role-binding.yaml",
	)
}

func assetsDnsMetricsClusterRoleBindingYaml() (*asset, error) {
	bytes, err := assetsDnsMetricsClusterRoleBindingYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/metrics/cluster-role-binding.yaml", size: 279, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x79, 0x95, 0x6f, 0xa4, 0xd5, 0xed, 0x48, 0x27, 0x41, 0x56, 0x5c, 0xea, 0x5c, 0x89, 0xdc, 0xc1, 0x44, 0x91, 0xd4, 0xb, 0x18, 0x85, 0x79, 0x75, 0xaa, 0x6e, 0xb5, 0x98, 0xbe, 0xc6, 0x33, 0x43}}
	return a, nil
}

var _assetsDnsMetricsClusterRoleYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x34\xcd\x31\x4b\x34\x41\x0c\x87\xf1\x7e\x3e\x45\xe0\xad\x77\x5f\xec\x64\x5a\x05\x3b\x0b\x05\xfb\xec\xce\xdf\xdb\x70\x3b\xc9\x90\x64\x0e\xf4\xd3\x8b\x70\xb6\x0f\x3f\x78\xfe\xd1\xd3\x39\x23\xe1\xe4\x76\x22\x48\x81\x86\x46\xdb\x17\x0d\xb7\x8e\x3c\x30\x83\xd2\x28\x76\xe7\x01\x7a\x7e\x7d\xa7\x8e\x74\xd9\x83\xa0\x6d\x98\x68\x16\x1e\xf2\x01\x0f\x31\xad\xe4\x1b\xef\x2b\xcf\x3c\xcc\xe5\x9b\x53\x4c\xd7\xeb\x63\xac\x62\xff\x6f\x0f\xe5\x2a\xda\xea\xdf\xf0\xcd\x4e\x94\x8e\xe4\xc6\xc9\xb5\x10\x29\x77\x54\x6a\x1a\x4b\x37\x95\x34\x17\xbd\x14\x9f\x27\xa2\x96\x85\x78\xc8\x8b\xdb\x1c\xf1\x4b\x17\xb2\x01\xe7\x34\x5f\x6d\x40\xe3\x90\xcf\x5c\xc5\x0a\x91\x23\x6c\xfa\x8e\x3b\x6b\x1a\x88\x42\x74\x83\x6f\xf7\x74\x41\x96\x9f\x00\x00\x00\xff\xff\x9f\xa8\x4d\x6c\xf6\x00\x00\x00")

func assetsDnsMetricsClusterRoleYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsMetricsClusterRoleYaml,
		"assets/dns/metrics/cluster-role.yaml",
	)
}

func assetsDnsMetricsClusterRoleYaml() (*asset, error) {
	bytes, err := assetsDnsMetricsClusterRoleYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/metrics/cluster-role.yaml", size: 246, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x64, 0xdb, 0xe0, 0x95, 0x65, 0xae, 0x53, 0x96, 0x3a, 0x5f, 0x5e, 0x8b, 0x69, 0xe2, 0x7d, 0x5, 0xbf, 0x1f, 0x3a, 0xf, 0xff, 0xd0, 0x6b, 0x23, 0x4f, 0xfd, 0x11, 0x7f, 0x57, 0xd4, 0x4a, 0x8b}}
	return a, nil
}

var _assetsDnsMetricsRoleBindingYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x94\xce\xb1\x4e\xc4\x40\x0c\x04\xd0\x7e\xbf\xc2\x3f\x90\x20\xba\xd3\x76\xd0\xd0\x1f\x12\xbd\x6f\xd7\x97\x98\x64\xed\x95\xed\x4d\xc1\xd7\x23\xa4\x48\x54\x20\x5d\x3b\x9a\xd1\x1b\xec\xfc\x41\xe6\xac\x92\xc1\x6e\x58\x66\x1c\xb1\xaa\xf1\x17\x06\xab\xcc\xdb\xc5\x67\xd6\xa7\xe3\x39\x6d\x2c\x35\xc3\x55\x77\x7a\x65\xa9\x2c\x4b\x6a\x14\x58\x31\x30\x27\x00\xc1\x46\x19\xba\x69\xa3\x58\x69\xf8\xb4\x5d\xfc\x8c\xbd\x63\xa1\x0c\xda\x49\x7c\xe5\x7b\x4c\x55\x3c\x99\xee\x74\xa5\xfb\xcf\x14\x3b\xbf\x99\x8e\xfe\x8f\x9f\x00\x7e\xf9\xbf\x34\x1f\xb7\x4f\x2a\xe1\x39\x4d\x67\xfb\x9d\xec\xe0\x42\x2f\xa5\xe8\x90\x78\xf0\x65\x53\xe1\x50\x63\x59\x20\x7d\x07\x00\x00\xff\xff\xb9\xd9\xab\x8d\x25\x01\x00\x00")

func assetsDnsMetricsRoleBindingYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsMetricsRoleBindingYaml,
		"assets/dns/metrics/role-binding.yaml",
	)
}

func assetsDnsMetricsRoleBindingYaml() (*asset, error) {
	bytes, err := assetsDnsMetricsRoleBindingYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/metrics/role-binding.yaml", size: 293, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0xc, 0x7d, 0xc7, 0x45, 0x33, 0xc4, 0xd8, 0xf, 0x8d, 0x89, 0x8d, 0x6, 0x47, 0xa7, 0xa, 0x6b, 0x17, 0xf5, 0x5f, 0x5a, 0x2f, 0xd8, 0xf9, 0x6, 0x71, 0xaa, 0x78, 0x8d, 0xb5, 0x7a, 0xf6, 0x99}}
	return a, nil
}

var _assetsDnsMetricsRoleYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x4c\x8e\xb1\x4e\xec\x40\x0c\x45\xfb\xf9\x0a\x6b\x5f\x9d\x7d\xa2\x5b\x4d\x8d\x44\x47\x01\x12\xbd\x77\xe6\x42\xac\x24\xe3\x91\xed\x04\xc1\xd7\xa3\xcd\x06\x89\xca\xf7\x1e\x59\x3e\xfe\x47\x2f\x3a\xc3\xa9\x01\x15\x95\xae\x5f\xd4\x4d\x17\xc4\x88\xd5\x29\x94\xbc\x18\x77\xd0\xe3\xf3\x2b\x2d\x08\x93\xe2\x84\x56\xbb\x4a\x8b\xc4\x5d\xde\x60\x2e\xda\x32\xd9\x95\xcb\x99\xd7\x18\xd5\xe4\x9b\x43\xb4\x9d\xa7\x8b\x9f\x45\xff\x6f\x0f\x69\x92\x56\xf3\x2e\x4a\x0b\x82\x2b\x07\xe7\x44\xd4\x78\x41\xfe\xe3\x1b\xa6\x8b\x1f\xd8\x3b\x17\x64\xd2\x8e\xe6\xa3\xbc\xc7\x50\x9b\x27\x5b\x67\x78\x4e\x03\x71\x97\x27\xd3\xb5\xfb\xed\xca\x40\xa7\x53\x22\x32\xb8\xae\x56\x70\x30\x87\x6d\x52\xe0\x7b\xf9\xfd\xf8\xde\xba\xd6\x5b\xd8\x60\xd7\x63\xf9\x03\xb1\xcf\x59\xfc\x1e\x3e\x39\xca\x98\x7e\x02\x00\x00\xff\xff\x29\x39\xda\x05\x1c\x01\x00\x00")

func assetsDnsMetricsRoleYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsMetricsRoleYaml,
		"assets/dns/metrics/role.yaml",
	)
}

func assetsDnsMetricsRoleYaml() (*asset, error) {
	bytes, err := assetsDnsMetricsRoleYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/metrics/role.yaml", size: 284, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x8c, 0xf2, 0x4e, 0x40, 0x91, 0xd8, 0x5e, 0x1c, 0x98, 0xb6, 0x2f, 0x11, 0x2a, 0x15, 0x8f, 0xe4, 0x7c, 0xfe, 0xc6, 0x31, 0xf3, 0xb2, 0xa0, 0x38, 0xb2, 0x3f, 0x15, 0x5a, 0x33, 0x12, 0xd2, 0x88}}
	return a, nil
}

var _assetsDnsNamespaceYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x64\x90\xcd\x4e\xc4\x30\x0c\x84\xef\x79\x8a\x51\x38\x2f\x3f\xd7\xbc\x03\x5c\x90\xb8\xbb\x8d\x97\x35\x4d\xed\x2a\x76\xcb\xeb\xa3\xb2\x15\xac\xb4\xc7\x68\x46\xf3\x7d\xf1\x24\x5a\x0b\xde\x68\x66\x5f\x68\xe4\x44\x8b\x7c\x70\x77\x31\x2d\xd8\x5e\xd2\xcc\x41\x95\x82\x4a\x02\x48\xd5\x82\x42\x4c\x7d\x7f\x02\xb6\xb0\xfa\x45\xce\xf1\x28\xf6\xa4\x56\xf9\xe4\xdc\x78\x0c\xeb\x05\x39\x27\x40\x69\xe6\xf2\x5f\x3b\x55\xf5\x04\x34\x1a\xb8\x1d\x13\x0f\x70\x0e\x6c\xd4\x56\x46\x18\x68\x33\xa9\xa8\xbc\xb0\x56\xd1\x4f\x98\x62\x5a\x07\x06\xd5\x59\x7c\x97\x42\x5c\x28\x8e\x82\xef\xf1\xdf\x38\x68\x11\xbf\xd7\xea\xab\x9e\x1a\x6f\xdc\x0a\xf2\x73\x3e\x98\xd4\x9a\x7d\xdf\x78\xcd\xa6\x12\xd6\x77\x62\x18\x9a\xd9\x84\xb3\x75\xbc\x73\xdf\x64\xe4\xd7\x6b\x0a\x1b\xbe\x78\x0c\x87\xec\x16\xe2\xbf\xbf\xbb\x1e\xed\x8e\x3a\xb6\xd5\x83\xfb\xcd\x70\x41\x8e\xbe\x72\x4e\x3f\x01\x00\x00\xff\xff\x82\x6d\x29\x03\x71\x01\x00\x00")

func assetsDnsNamespaceYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsNamespaceYaml,
		"assets/dns/namespace.yaml",
	)
}

func assetsDnsNamespaceYaml() (*asset, error) {
	bytes, err := assetsDnsNamespaceYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/namespace.yaml", size: 369, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0xe, 0xab, 0x50, 0x84, 0x61, 0x5f, 0x41, 0xf4, 0x17, 0x3b, 0x6, 0x84, 0xc0, 0x5f, 0x4f, 0xbb, 0xd8, 0x1d, 0xae, 0x26, 0x3e, 0x1f, 0x29, 0x2c, 0x84, 0x6d, 0x5e, 0xc1, 0x87, 0x97, 0x5f, 0xc9}}
	return a, nil
}

var _assetsDnsServiceAccountYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x2c\xc9\xb1\x09\xc4\x30\x0c\x05\xd0\xde\x53\x68\x81\x2b\xae\x55\x77\x33\x1c\xa4\x17\xf2\x0f\x11\xc1\xb2\xb1\x14\xcf\x1f\x02\xe9\x1e\xbc\xd3\xbc\x32\xfd\x31\x97\x29\x7e\xaa\xfd\xf2\x2c\x32\x6c\xc3\x0c\xeb\xce\xb4\xbe\xa5\x21\xa5\x4a\x0a\x17\x22\x97\x06\xa6\xea\xf1\x3a\x86\x28\x98\xfa\x80\xc7\x61\x7b\x7e\x9e\xba\x03\x00\x00\xff\xff\x8e\x2c\xf1\x2e\x55\x00\x00\x00")

func assetsDnsServiceAccountYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsServiceAccountYaml,
		"assets/dns/service-account.yaml",
	)
}

func assetsDnsServiceAccountYaml() (*asset, error) {
	bytes, err := assetsDnsServiceAccountYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/service-account.yaml", size: 85, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x57, 0x12, 0x50, 0x4d, 0x67, 0x2f, 0x1b, 0x74, 0xa0, 0xa4, 0xbb, 0xa7, 0x59, 0xe9, 0x5a, 0xc6, 0xc1, 0x1a, 0xf8, 0x5f, 0xff, 0x5, 0xdb, 0xc, 0x10, 0x8b, 0xc1, 0x0, 0xcc, 0xf, 0x9f, 0x3a}}
	return a, nil
}

var _assetsDnsServiceYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x84\x91\x31\x6f\xe2\x40\x10\x85\x7b\xff\x8a\x27\xe8\x4e\xc0\x09\xdd\x51\x9c\xdb\xa3\x89\x52\x80\x14\x48\x3f\x5e\x4f\xcc\x8a\xf5\x8c\xb5\x33\x06\xf1\xef\x23\x4c\x42\x80\x14\x69\x56\xda\x7d\x9f\x3e\x3d\xbd\xdd\x47\xa9\x4b\xbc\x70\x3e\xc4\xc0\x05\x75\xf1\x95\xb3\x45\x95\x12\x87\x79\x31\x86\x50\xcb\x93\xe1\xb4\x8e\x02\x4f\x12\x55\x9c\x0c\x24\x35\x48\x44\x9d\x3c\xaa\x18\x28\x33\x8c\x1d\xe4\xc8\xbd\x78\x6c\xb9\xb0\x8e\x43\x59\x00\x63\x84\xd4\x9b\x73\x7e\x5a\xe3\x18\x53\x42\xc5\xa0\xde\xb5\x25\x8f\x81\x52\x3a\xa1\x25\xa1\x86\xeb\xd9\x00\x1b\x27\x0e\xae\x19\xd1\x1e\x8d\x40\xa7\xd9\xed\x2c\x9d\x0e\x95\x4a\xd4\x62\x05\x70\x09\x4a\x2c\xfe\x0c\x17\xa7\xdc\xb0\xaf\x87\xa7\x2b\x90\xd5\x35\x68\x2a\xb1\x5d\xae\xef\x05\x53\x0f\xdd\x8f\x92\x2f\xe8\x2a\xda\xfc\xbf\x15\xb5\xec\x39\x86\xdb\x36\xff\xe6\x8b\xbf\xdf\x54\x77\xd8\x83\x6a\x8c\xcd\x6a\xb9\x2a\xb1\x95\xa0\x6d\xcb\xe2\x38\xee\x58\x60\x97\xbf\x81\x6b\xa7\x49\x9b\x13\xde\x98\xbc\xcf\x8c\x86\x9c\xcf\x33\xb1\x50\x95\x3e\xf6\xfb\x84\x9e\xf9\x64\x97\xf5\x31\xc5\x68\xdf\x57\x9c\x85\x9d\x6d\x16\xf5\xf7\x4e\xcd\xcf\xa5\x47\xd7\xfc\xd7\xa8\x78\x0f\x00\x00\xff\xff\x82\x42\x75\xa4\x08\x02\x00\x00")

func assetsDnsServiceYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsServiceYaml,
		"assets/dns/service.yaml",
	)
}

func assetsDnsServiceYaml() (*asset, error) {
	bytes, err := assetsDnsServiceYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/service.yaml", size: 520, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x18, 0x69, 0xc5, 0xf1, 0xe, 0xc, 0x77, 0xe5, 0x78, 0xce, 0xfc, 0xc2, 0x41, 0xf8, 0x21, 0x87, 0x8a, 0xb7, 0x67, 0xdd, 0x48, 0x94, 0x63, 0x79, 0x69, 0x4e, 0x38, 0x53, 0x3c, 0xdb, 0xc7, 0x13}}
	return a, nil
}

// Asset loads and returns the asset for the given name.
// It returns an error if the asset could not be found or
// could not be loaded.
func Asset(name string) ([]byte, error) {
	canonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[canonicalName]; ok {
		a, err := f()
		if err != nil {
			return nil, fmt.Errorf("Asset %s can't read by error: %v", name, err)
		}
		return a.bytes, nil
	}
	return nil, fmt.Errorf("Asset %s not found", name)
}

// AssetString returns the asset contents as a string (instead of a []byte).
func AssetString(name string) (string, error) {
	data, err := Asset(name)
	return string(data), err
}

// MustAsset is like Asset but panics when Asset would return an error.
// It simplifies safe initialization of global variables.
func MustAsset(name string) []byte {
	a, err := Asset(name)
	if err != nil {
		panic("asset: Asset(" + name + "): " + err.Error())
	}

	return a
}

// MustAssetString is like AssetString but panics when Asset would return an
// error. It simplifies safe initialization of global variables.
func MustAssetString(name string) string {
	return string(MustAsset(name))
}

// AssetInfo loads and returns the asset info for the given name.
// It returns an error if the asset could not be found or
// could not be loaded.
func AssetInfo(name string) (os.FileInfo, error) {
	canonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[canonicalName]; ok {
		a, err := f()
		if err != nil {
			return nil, fmt.Errorf("AssetInfo %s can't read by error: %v", name, err)
		}
		return a.info, nil
	}
	return nil, fmt.Errorf("AssetInfo %s not found", name)
}

// AssetDigest returns the digest of the file with the given name. It returns an
// error if the asset could not be found or the digest could not be loaded.
func AssetDigest(name string) ([sha256.Size]byte, error) {
	canonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[canonicalName]; ok {
		a, err := f()
		if err != nil {
			return [sha256.Size]byte{}, fmt.Errorf("AssetDigest %s can't read by error: %v", name, err)
		}
		return a.digest, nil
	}
	return [sha256.Size]byte{}, fmt.Errorf("AssetDigest %s not found", name)
}

// Digests returns a map of all known files and their checksums.
func Digests() (map[string][sha256.Size]byte, error) {
	mp := make(map[string][sha256.Size]byte, len(_bindata))
	for name := range _bindata {
		a, err := _bindata[name]()
		if err != nil {
			return nil, err
		}
		mp[name] = a.digest
	}
	return mp, nil
}

// AssetNames returns the names of the assets.
func AssetNames() []string {
	names := make([]string, 0, len(_bindata))
	for name := range _bindata {
		names = append(names, name)
	}
	return names
}

// _bindata is a table, holding each asset generator, mapped to its name.
var _bindata = map[string]func() (*asset, error){
	"assets/dns/cluster-role-binding.yaml": assetsDnsClusterRoleBindingYaml,

	"assets/dns/cluster-role.yaml": assetsDnsClusterRoleYaml,

	"assets/dns/daemonset.yaml": assetsDnsDaemonsetYaml,

	"assets/dns/metrics/cluster-role-binding.yaml": assetsDnsMetricsClusterRoleBindingYaml,

	"assets/dns/metrics/cluster-role.yaml": assetsDnsMetricsClusterRoleYaml,

	"assets/dns/metrics/role-binding.yaml": assetsDnsMetricsRoleBindingYaml,

	"assets/dns/metrics/role.yaml": assetsDnsMetricsRoleYaml,

	"assets/dns/namespace.yaml": assetsDnsNamespaceYaml,

	"assets/dns/service-account.yaml": assetsDnsServiceAccountYaml,

	"assets/dns/service.yaml": assetsDnsServiceYaml,
}

// AssetDir returns the file names below a certain
// directory embedded in the file by go-bindata.
// For example if you run go-bindata on data/... and data contains the
// following hierarchy:
//     data/
//       foo.txt
//       img/
//         a.png
//         b.png
// then AssetDir("data") would return []string{"foo.txt", "img"},
// AssetDir("data/img") would return []string{"a.png", "b.png"},
// AssetDir("foo.txt") and AssetDir("notexist") would return an error, and
// AssetDir("") will return []string{"data"}.
func AssetDir(name string) ([]string, error) {
	node := _bintree
	if len(name) != 0 {
		canonicalName := strings.Replace(name, "\\", "/", -1)
		pathList := strings.Split(canonicalName, "/")
		for _, p := range pathList {
			node = node.Children[p]
			if node == nil {
				return nil, fmt.Errorf("Asset %s not found", name)
			}
		}
	}
	if node.Func != nil {
		return nil, fmt.Errorf("Asset %s not found", name)
	}
	rv := make([]string, 0, len(node.Children))
	for childName := range node.Children {
		rv = append(rv, childName)
	}
	return rv, nil
}

type bintree struct {
	Func     func() (*asset, error)
	Children map[string]*bintree
}

var _bintree = &bintree{nil, map[string]*bintree{
	"assets": {nil, map[string]*bintree{
		"dns": {nil, map[string]*bintree{
			"cluster-role-binding.yaml": {assetsDnsClusterRoleBindingYaml, map[string]*bintree{}},
			"cluster-role.yaml":         {assetsDnsClusterRoleYaml, map[string]*bintree{}},
			"daemonset.yaml":            {assetsDnsDaemonsetYaml, map[string]*bintree{}},
			"metrics": {nil, map[string]*bintree{
				"cluster-role-binding.yaml": {assetsDnsMetricsClusterRoleBindingYaml, map[string]*bintree{}},
				"cluster-role.yaml":         {assetsDnsMetricsClusterRoleYaml, map[string]*bintree{}},
				"role-binding.yaml":         {assetsDnsMetricsRoleBindingYaml, map[string]*bintree{}},
				"role.yaml":                 {assetsDnsMetricsRoleYaml, map[string]*bintree{}},
			}},
			"namespace.yaml":       {assetsDnsNamespaceYaml, map[string]*bintree{}},
			"service-account.yaml": {assetsDnsServiceAccountYaml, map[string]*bintree{}},
			"service.yaml":         {assetsDnsServiceYaml, map[string]*bintree{}},
		}},
	}},
}}

// RestoreAsset restores an asset under the given directory.
func RestoreAsset(dir, name string) error {
	data, err := Asset(name)
	if err != nil {
		return err
	}
	info, err := AssetInfo(name)
	if err != nil {
		return err
	}
	err = os.MkdirAll(_filePath(dir, filepath.Dir(name)), os.FileMode(0755))
	if err != nil {
		return err
	}
	err = ioutil.WriteFile(_filePath(dir, name), data, info.Mode())
	if err != nil {
		return err
	}
	return os.Chtimes(_filePath(dir, name), info.ModTime(), info.ModTime())
}

// RestoreAssets restores an asset under the given directory recursively.
func RestoreAssets(dir, name string) error {
	children, err := AssetDir(name)
	// File
	if err != nil {
		return RestoreAsset(dir, name)
	}
	// Dir
	for _, child := range children {
		err = RestoreAssets(dir, filepath.Join(name, child))
		if err != nil {
			return err
		}
	}
	return nil
}

func _filePath(dir, name string) string {
	canonicalName := strings.Replace(name, "\\", "/", -1)
	return filepath.Join(append([]string{dir}, strings.Split(canonicalName, "/")...)...)
}
