// Code generated by go-bindata. DO NOT EDIT.
// sources:
// assets/dns/cluster-role-binding.yaml (223B)
// assets/dns/cluster-role.yaml (397B)
// assets/dns/daemonset.yaml (6.406kB)
// assets/dns/metrics/cluster-role-binding.yaml (279B)
// assets/dns/metrics/cluster-role.yaml (246B)
// assets/dns/metrics/role-binding.yaml (293B)
// assets/dns/metrics/role.yaml (284B)
// assets/dns/namespace.yaml (369B)
// assets/dns/service-account.yaml (85B)
// assets/dns/service.yaml (520B)

package manifests

import (
	"bytes"
	"compress/gzip"
	"crypto/sha256"
	"fmt"
	"io"
	"io/ioutil"
	"os"
	"path/filepath"
	"strings"
	"time"
)

func bindataRead(data []byte, name string) ([]byte, error) {
	gz, err := gzip.NewReader(bytes.NewBuffer(data))
	if err != nil {
		return nil, fmt.Errorf("Read %q: %v", name, err)
	}

	var buf bytes.Buffer
	_, err = io.Copy(&buf, gz)
	clErr := gz.Close()

	if err != nil {
		return nil, fmt.Errorf("Read %q: %v", name, err)
	}
	if clErr != nil {
		return nil, err
	}

	return buf.Bytes(), nil
}

type asset struct {
	bytes  []byte
	info   os.FileInfo
	digest [sha256.Size]byte
}

type bindataFileInfo struct {
	name    string
	size    int64
	mode    os.FileMode
	modTime time.Time
}

func (fi bindataFileInfo) Name() string {
	return fi.name
}
func (fi bindataFileInfo) Size() int64 {
	return fi.size
}
func (fi bindataFileInfo) Mode() os.FileMode {
	return fi.mode
}
func (fi bindataFileInfo) ModTime() time.Time {
	return fi.modTime
}
func (fi bindataFileInfo) IsDir() bool {
	return false
}
func (fi bindataFileInfo) Sys() interface{} {
	return nil
}

var _assetsDnsClusterRoleBindingYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x6c\xce\x31\x8e\x83\x40\x0c\x05\xd0\x7e\x4e\xe1\x0b\xc0\x6a\xbb\xd5\x74\x9b\xdc\x80\x48\xe9\xcd\x8c\x09\x0e\x60\xa3\xb1\x87\x22\xa7\x8f\x10\x4a\x45\x3a\x17\xfe\xff\xfd\x89\x25\x47\xb8\xce\xd5\x9c\x4a\xa7\x33\x5d\x58\x32\xcb\x23\xe0\xca\x77\x2a\xc6\x2a\x11\x4a\x8f\xa9\xc5\xea\xa3\x16\x7e\xa1\xb3\x4a\x3b\xfd\x59\xcb\xfa\xb3\xfd\x86\x85\x1c\x33\x3a\xc6\x00\x00\x20\xb8\x50\x04\x5d\x49\x6c\xe4\xc1\x9b\x2c\x16\xac\xf6\x4f\x4a\x6e\x31\x34\x70\x78\x37\x2a\x1b\x27\xfa\x4f\x49\xab\x78\xf8\xc4\xf6\xe7\xe3\xb6\x15\xd3\xa9\xa7\xe8\x4c\x1d\x0d\x3b\x74\x9a\x1d\xbe\xd3\xef\x00\x00\x00\xff\xff\xfa\x62\xe7\x50\xdf\x00\x00\x00")

func assetsDnsClusterRoleBindingYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsClusterRoleBindingYaml,
		"assets/dns/cluster-role-binding.yaml",
	)
}

func assetsDnsClusterRoleBindingYaml() (*asset, error) {
	bytes, err := assetsDnsClusterRoleBindingYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/cluster-role-binding.yaml", size: 223, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0xd9, 0xf6, 0x2a, 0x3b, 0x84, 0xd7, 0x3e, 0xc4, 0xe1, 0x70, 0x66, 0x31, 0xda, 0xc4, 0x2f, 0x53, 0x27, 0x29, 0x13, 0xfe, 0x80, 0x36, 0xc5, 0xa1, 0x70, 0xdc, 0x2d, 0xef, 0xcf, 0xe0, 0xc4, 0xeb}}
	return a, nil
}

var _assetsDnsClusterRoleYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x7c\x90\xb1\x4e\xc4\x30\x10\x44\x7b\x7f\x85\x75\xfd\x05\xd1\xa1\xb4\x14\xf4\x14\xf4\x1b\x67\x50\x96\xe4\x76\xad\xdd\x75\x4e\xe2\xeb\x51\x2e\x57\xa0\x8b\xa0\x9b\x19\xd9\xf3\x3c\x9e\x59\xc6\x3e\xbf\x2e\xcd\x03\xf6\xae\x0b\x12\x55\xfe\x80\x39\xab\xf4\xd9\x06\x2a\x1d\xb5\x98\xd4\xf8\x9b\x82\x55\xba\xf9\xc5\x3b\xd6\xa7\xf5\x39\x5d\x10\x34\x52\x50\x9f\x72\x16\xba\xa0\xcf\x5a\x21\x3e\xf1\x67\x9c\x47\xf1\x64\x6d\x81\xf7\xe9\x9c\xa9\xf2\x9b\x69\xab\xbe\x9d\x3c\xe7\xd3\x29\xe5\x6c\x70\x6d\x56\x70\xcf\x20\x63\x55\x96\xf0\x9b\x73\xd8\xca\x05\xbb\xa9\x3a\xee\x62\x63\x78\xa5\x3d\x5f\x61\xc3\xfd\xee\xc2\x1e\x37\x71\xa5\x28\x53\x3a\x02\xb7\x01\x90\xe0\xf2\x7b\xc1\xf1\x0d\xa1\x33\xc4\xb0\x32\xae\x0f\x84\x62\xa0\xc0\x1f\xcd\x8f\x5f\x73\x2c\xf6\x36\x7c\xa1\x04\x95\x02\xf7\xff\x00\x3f\x01\x00\x00\xff\xff\x76\x1b\x55\x2e\x8d\x01\x00\x00")

func assetsDnsClusterRoleYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsClusterRoleYaml,
		"assets/dns/cluster-role.yaml",
	)
}

func assetsDnsClusterRoleYaml() (*asset, error) {
	bytes, err := assetsDnsClusterRoleYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/cluster-role.yaml", size: 397, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x84, 0xae, 0xd1, 0xba, 0xfa, 0x6b, 0xf8, 0x6e, 0x8d, 0x28, 0xc2, 0xa7, 0xaf, 0xc9, 0x3b, 0xc7, 0xcd, 0x80, 0xbe, 0xec, 0x98, 0xb4, 0x61, 0xa0, 0x9, 0xae, 0xa, 0xd8, 0xb2, 0x2e, 0x16, 0xf2}}
	return a, nil
}

var _assetsDnsDaemonsetYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xcc\x59\xff\x53\xdb\xc6\x12\xff\x9d\xbf\x62\x2b\x78\x21\x69\x10\x98\x24\xa4\x79\x4a\xe8\xab\x0b\xa6\x30\x0d\xe0\xc1\x4e\xf3\x03\xc3\x63\xce\xa7\xb5\x75\xcf\xa7\xbb\xeb\xdd\x49\xa0\x01\xfe\xf7\x37\x77\xb2\x6c\xc9\x32\x6e\x33\xef\xcb\xb4\x3f\x50\xb8\xdd\xfd\xdc\xee\xde\x7e\x55\xa6\x4c\xc4\x11\x1c\x13\x4c\xa5\x18\xa0\xdd\x20\x8a\xfd\x86\xda\x30\x29\x22\x20\x4a\x99\xbd\x7c\x7f\x63\x13\x04\x49\x71\xc7\xff\x34\x8a\x50\x04\x22\x62\xe0\x64\x84\xdc\x00\xd1\x08\x06\x2d\x10\x0b\x3a\x13\x96\xa5\xb8\x61\x14\xd2\x68\x03\xc0\x62\xaa\x38\xb1\xe8\x7e\x07\xa8\x4e\xfd\xef\xa8\x73\x46\xb1\x4b\xa9\xcc\x84\xbd\x20\x29\x46\x10\x0b\x33\xa3\x2a\xcd\xa4\x66\xb6\x38\xe2\xc4\x98\x92\x68\x0a\x63\x31\x0d\x85\x8c\x31\xa4\x9a\x59\x46\x09\x9f\x71\x53\x29\x2c\x61\x02\xb5\xa9\xd0\x43\xaf\x69\x1d\x11\x60\x13\x58\x4a\x26\x08\xcc\x2c\x6b\x5b\x71\x78\x7a\x3f\xe3\xbc\x2f\x39\xa3\x45\x04\x67\xe3\x0b\x69\xfb\x1a\x0d\x0a\x3b\xe7\xb2\xa8\x53\x26\x88\x65\x52\x9c\xa3\x31\x4e\x64\xc6\x7e\x42\x38\x1f\x11\x3a\x1d\xca\xcf\x72\x62\x2e\x45\x4f\x6b\xa9\xe7\x72\x54\xa6\x29\x71\xae\xbe\x86\x80\x4a\x8d\xb1\x30\x01\xdc\xcc\xc9\x44\x4f\x8c\xa7\x85\x54\x8a\x71\xb0\x03\xc1\x1e\x5a\xba\x37\xe3\xdc\x3b\x92\x1a\xc7\x8c\x63\x5d\x24\x97\x3c\x4b\xf1\xdc\x39\x70\x6e\xf9\xc2\x76\x07\xc3\x26\x61\xc9\x34\xa7\x02\xa4\x8e\xbf\x4f\x6c\x12\x41\xfd\x86\x1a\x87\x46\x12\x5f\x0a\x5e\x44\x60\x75\xb6\x10\x55\x52\x37\xef\x99\xfb\xbd\x2f\xb5\x8d\xe0\xe0\xed\xc1\xdb\x1a\x4a\xfb\x05\xdc\xbb\x4a\x2b\xa9\xe4\x11\x7c\x39\xee\x7f\x3b\x52\x68\xa9\x5a\x89\x36\x3c\x5a\xa0\x39\xed\x99\x40\x63\xfa\x5a\x8e\x30\xaa\xf1\x27\xd6\xaa\x5f\xd0\xd6\x8f\x00\x54\xe9\x89\x04\x09\xb7\x49\x93\xe2\x75\xf9\xd0\xf9\xd0\x69\x1c\x1b\x9a\xa0\xd3\xe7\x74\x38\xec\xd7\x08\x4c\x30\xcb\x08\x3f\x46\x4e\x8a\x01\x52\x29\x62\x13\xc1\x7e\x5d\x54\xa1\x66\x32\x5e\x4d\x33\x19\xa5\x68\xcc\x30\xd1\x68\x12\xc9\xe3\x08\xf6\x6b\xd4\x31\x61\x3c\xd3\x58\xa3\xd6\xdd\xe3\x62\x58\x66\x76\x15\x30\x67\x39\xfe\x45\x5c\xf1\xbe\xb3\x46\xe5\x83\xff\xc0\x15\x07\xb5\x97\x37\x32\xd3\x14\x4d\xdd\x2c\xce\x52\x66\x4d\xd3\xd0\x14\x53\xa9\x8b\x08\x0e\xf6\xdf\x9c\xb3\x46\xe0\xff\x9e\xa1\x59\xe6\xa6\x2a\x8b\xe0\xa0\x93\xae\x84\xf8\xa1\x33\x47\xa8\x12\x6f\x9a\x8d\x30\xd4\x23\x42\x43\xa5\xe5\x7d\xf1\x0d\x05\xc8\xd7\x80\x5a\x5a\x84\x21\x97\x13\x2b\x8d\x8d\x51\xeb\xc6\xb9\x41\x9a\x69\x0c\x39\x33\x16\x45\x48\xe2\x58\xa3\x31\x87\xd1\xdf\xf7\x0f\xde\x35\xf8\x2c\x37\x21\x65\x2a\x41\x1d\x9a\x8c\x59\x34\x87\xc3\xcf\x83\xdb\xde\xd1\xf1\x69\xef\xf6\x6a\xd0\xbd\xfd\x7a\x36\x3c\xbd\xed\xf6\x06\xb7\xfb\x6f\x3e\xdc\xfe\x72\x74\x7e\x3b\x38\xed\xbe\x39\x78\xbf\xb3\xe0\xea\x1d\x1d\xff\x01\x5f\x0b\xe7\xe8\xe7\xa3\x3f\x85\xb3\x92\x6f\x0d\x5a\xc3\xb2\x4c\x19\xab\x91\xa4\x87\x2e\x94\xa3\xbd\xbd\xfd\x37\x3f\xec\x76\x76\x3b\xbb\xfb\xce\x09\x6f\xf7\xda\x5e\x40\x6d\x43\x57\x41\x0f\x7d\xd5\xb3\xdc\xec\x29\xcd\x72\x62\xd1\xfd\xbe\x4b\xb5\x6d\x89\xcc\xe8\xe1\x14\x8b\x35\x92\x53\x2c\xfe\x74\x89\x6c\xbc\x4f\x55\xd8\x52\xb4\x9a\x51\xb3\x3e\x8c\xd7\x84\xe6\xfe\x33\xa1\xf9\xae\x53\x0b\xee\xe7\x7a\xc5\x72\x37\xa8\x59\xf7\x9c\xa2\xce\x37\x7f\xd4\x2d\x6a\x0d\xb8\x6c\xd9\xce\x28\x9e\xa3\xfe\xcb\xb4\x63\x9f\x41\x6e\xc4\x90\xc2\xe2\x7d\xa3\x12\x3a\xfb\x19\xc7\x09\xc6\x4b\x1d\x70\x7d\xc3\x4d\xa4\xb1\xc6\x07\xca\x9a\x6e\xeb\x99\x6a\x4e\x40\x91\xc3\x45\xf7\xbc\x37\xe8\x5d\xfd\xd6\xbb\xf2\x63\xd5\xd1\xe7\x2f\x83\x61\xef\xea\xf6\xf8\xf2\xbc\x7b\x76\xb1\x6a\xbc\xaa\xc4\x51\xe4\x6d\x35\x1c\xd2\xd9\x51\x6f\x50\x53\x62\x13\x8e\xdc\xf0\x01\x52\x43\x39\xbd\x19\x54\x44\x13\x8b\x31\xb8\x0a\x02\x72\x5c\xcd\x63\xa6\x21\x75\x71\x39\xec\x45\x70\x22\x35\x08\x79\xb7\x03\x28\x4c\xa6\x11\x6c\x82\x06\xbd\x5a\x1a\x39\xb1\x2c\xc7\x72\x2e\xfc\x08\x63\xa9\x01\x09\x4d\x9a\x84\x9d\x06\x26\x11\x40\x38\x23\x06\xee\x98\x4d\x1c\xd6\xb2\xbd\x26\x1b\x8f\xd9\x3d\xdc\x31\xce\x81\x70\x23\x61\x84\x40\xe2\x18\xe3\xdd\x1a\x4e\x4e\x78\x86\x11\x04\x3e\x46\x42\x8d\x13\x66\xac\x2e\x76\xa5\x42\x61\x12\x36\xb6\xe1\x12\xc1\xe4\x34\x68\x4d\x62\x35\xd7\xed\x8d\x98\xd8\x1b\x11\x93\xd4\x8b\x00\xad\xfd\xf1\x58\x37\xe2\xbb\x36\x3b\xf8\x37\x0a\x33\x09\x8a\x29\x74\x5d\x6a\xa3\xde\xef\x34\x51\xb0\xfd\x2f\x39\x32\x10\x2a\x78\x84\x7b\x57\xe9\x61\xea\x4c\x7c\x7c\xf4\x31\xf6\x11\xee\x08\xb3\x1f\x01\xef\x99\x85\xce\x36\x0c\x7b\x57\xe7\x75\x84\xcb\x7e\xef\x62\x70\x7a\x76\x32\xbc\x3d\xef\x5e\xfd\xda\xbb\x3a\x0c\x16\xb6\x4e\x50\xa0\x7f\xcd\x66\xaa\x05\x35\xf1\xd3\xcb\xc1\x70\x70\x7b\x72\xf6\xb9\x77\x18\x2c\xe2\xb0\xce\x31\xec\x9d\xf7\x5b\x0c\xbb\x36\x55\x41\x5d\x8d\xb3\x93\xc1\xe1\xf6\x0e\x6c\xfb\xac\x87\x50\x43\x48\xe6\xa1\x03\x9f\x3e\x7d\x82\x60\xeb\xa1\x0a\xc0\xa7\x86\xe4\x26\x9c\x93\x29\x02\xf1\x3b\x81\xd4\x44\x17\xe0\x52\x65\x11\x06\x92\xc7\x65\x0a\xf9\xf3\x6d\x03\xc4\x5a\xcd\x46\x99\x45\x53\x7f\x79\xaa\x20\x1c\x43\x18\x2e\xa8\xa1\x14\xbc\x70\x17\x2f\x8c\x7c\x0a\xdc\xdf\x73\x93\x9a\x9a\xdc\x25\xee\xde\xd2\xe9\xb1\x6c\x94\xce\x18\x29\x77\x81\x1d\x76\xc1\xe4\xf4\x96\x29\xd3\x20\xbb\xf8\x36\x39\x05\x26\x1c\x7c\x65\xf7\xf5\x4f\x37\x4f\x41\x0b\xca\x59\x7c\x82\x96\x26\x95\x7f\xe0\xac\x0f\x63\x2d\x53\xa0\x3c\x33\x16\xb5\xab\x8d\xc0\xc6\xa0\xca\x82\xb6\x0b\x5f\x11\x52\xe7\x22\x83\x39\x6a\xc2\xc1\x6a\x86\xa6\x85\x69\x25\xc4\x12\x98\x8d\xe0\xac\x9f\xbf\xdb\x71\x3f\xdf\xfb\x9f\xef\x40\xe6\xa8\xdd\x28\xec\xab\x88\x3b\x9f\x9f\xec\xc2\x30\x41\xb0\x77\x12\x38\x71\xf9\x2e\x56\x00\x3b\xbb\x9d\x81\x31\x2a\x2e\x8b\x14\x85\x9d\xe5\xe8\xaf\x99\x2e\x34\x48\xe1\x5e\x08\x35\x5c\x2a\x14\x03\x4b\xe8\x14\x5e\x5e\x0e\xfa\xfb\x6f\x5f\x41\x08\x36\x91\x06\x9d\x5e\x42\xda\x16\xb0\xc9\x94\xeb\x8b\x6e\xe4\x07\x2e\x49\x3c\x22\x9c\x08\x8a\xda\x78\x3d\x5d\x63\x63\xbe\x96\x10\x9a\x30\x31\x81\xe3\x8b\x01\xd8\x44\xcb\x6c\x92\x78\xd5\x97\xf0\x68\x1a\x9b\xc3\x97\xdb\x31\x9b\x40\x68\xa1\x0b\x3f\x05\x5b\x0f\x8b\x02\xfa\x14\xc0\x6b\x93\xb8\xdb\xdc\x03\xe5\xf4\x69\x77\xeb\xa1\x59\x5f\x9e\x82\xc7\x89\x46\x05\x61\x0e\xc1\x3f\x3f\x06\xdb\x4b\xf0\xe5\x7f\x73\xf8\x6e\xf7\x7f\x7d\x03\xbc\xb6\x54\xc1\x6b\x8d\x56\x17\x87\x9d\xff\x83\x39\xff\xdd\xfb\x5e\x2d\x5d\xe8\x22\x88\xb9\x04\xd9\x7a\xf8\xce\x3d\xd5\xf5\xf7\x37\x4f\x4b\x2c\xad\x44\x01\x60\xca\x1c\xbe\xdc\x7a\x89\x39\xe1\xee\x66\x2f\xc8\x6e\x9e\x82\x57\xcb\xf0\xe0\x32\xe6\xfa\x1a\x82\xad\x7f\x04\x10\xe2\xef\xd0\x81\x17\x2f\x9c\xc8\x26\x53\x65\x22\x42\x28\x10\x3a\x70\x73\xf3\xd1\x55\x15\xb1\xc2\x1f\xb3\xcc\xbe\x9e\x99\x18\xdc\x1c\x06\x5b\x0f\x95\xf8\x0a\xfe\x91\x46\x32\x6d\x9d\x8f\x59\xcb\x2c\x81\x1b\xad\x83\xc6\xc9\x26\x7c\x51\x31\xb1\x58\x1b\x05\xc0\x17\x2f\x36\x86\x3b\x84\x09\x5a\xd7\xd8\x58\x5c\x2b\x19\x66\x09\xe0\x2b\x96\x9d\x51\x48\x0b\x59\x0b\xec\x2e\x41\xe1\xcc\xd6\x7e\xae\x9a\x6d\xf6\x73\x34\x99\x59\x37\x71\x49\x0d\x44\x31\xc8\x04\xc9\x09\xe3\x64\xc4\x38\xb3\xc5\xd2\x35\x03\x4b\x38\x02\x0a\x5f\x83\x80\xca\x8c\xc7\xae\x35\x19\xeb\x9e\xb6\x76\x21\x1b\xfb\xda\x5d\xdd\xc0\x0c\xc4\xc8\xd1\x62\xbc\xd1\x7e\xb3\x50\xcc\xa2\xca\x7b\xff\xfb\x9b\xf0\x29\x78\xee\x99\x36\xe1\xe7\x8c\xf1\x18\x08\x08\xbc\xab\x75\x85\xb2\x80\xd6\x0d\x76\x05\x4a\x66\x1a\x68\x66\xac\x4c\xe7\x1a\x8f\x19\xb7\xa8\x31\x76\x36\x2f\x61\xcf\xc3\x77\x13\xb6\x1e\x96\xdb\x6a\xd9\x38\x1a\x8d\xe4\xc7\x35\xad\xa4\xd4\xb5\xab\x14\xfa\x4a\x56\xf6\xdd\x85\x12\xae\x5d\xb4\xe7\x2a\x68\x75\x92\xef\x2a\xa7\x3c\xd3\x49\x66\x69\xa5\xca\xbc\xaa\x98\xcb\xf0\xbd\x79\x5a\x29\x00\x80\x34\x91\xe0\x23\xfb\xa9\x14\xaa\xfe\xd7\xce\x69\x78\xc6\x15\x3f\xb6\x6c\x5f\xbe\xa4\x15\xf4\xab\xc2\xde\xf9\x68\x78\x79\x7c\x19\xad\x08\x7f\x62\x65\xca\x28\xe1\xbc\x70\x9d\x8d\xe4\x92\xc5\x40\x44\x01\x4c\x50\x29\x8c\x5f\x6f\x2d\x8c\x30\x21\x39\xab\x0d\xef\x15\xea\x15\x2a\xee\xe6\xd9\x55\x11\x91\xca\x98\x8d\x19\xc6\x90\x97\x5f\x33\x5d\x14\x0a\xc4\x78\x29\x36\x5d\x47\x51\x4b\x66\xb6\x62\xe0\xf1\x71\x36\x77\xac\xe7\x6b\x5b\x5d\xf1\xba\xcc\x70\x29\xab\x31\x95\x39\xc6\x0b\x5b\x7d\x54\x53\x8d\x6e\x9b\x2c\x53\xc7\x77\xc5\xc5\x74\x03\x54\xaa\x02\x68\x92\xe9\x66\x92\x2c\xd5\x1f\xc3\x11\x15\xbc\xef\xc0\x0b\x3f\x48\x36\x68\x99\x70\xb3\x69\x7b\xa0\x69\x3c\xde\xb7\x6e\x9d\x07\xd5\xd2\x19\x0b\x53\x6d\x5c\xc7\x38\x26\x19\xaf\x2e\x77\xc3\xe8\x00\x39\x52\x2b\xf5\x02\x60\x9a\x8d\x50\x0b\x74\x53\x1d\x93\x7b\xd2\x44\xc0\x99\xc8\xee\x4b\xe2\x8c\xab\xdc\xb3\x5a\x5f\x73\x57\x7f\xd1\x2c\x4f\xcf\x89\x8a\x6a\x6b\xd5\x05\x49\xd7\xad\x96\x00\xcc\x62\xda\x30\x2b\x84\x29\x16\x11\x54\xdf\x59\x57\x7c\x18\x5b\x22\xad\x59\xfb\xdc\x91\xdf\xf9\x36\x96\x31\x56\xec\x80\x00\xb6\x50\x18\xc1\x49\x1b\x7a\xd5\xc2\xbd\xe9\x36\x57\x8d\x76\xad\x85\x56\x72\xb7\x11\x30\x29\xe6\x36\x6e\xfa\xc1\xca\x25\x80\x71\xd1\xa7\x33\x01\x6e\xce\x2c\xee\x5c\xb7\xd8\x85\x61\x29\x81\x40\x38\x07\x4b\x98\x98\x6b\x18\x82\x54\x8e\x24\x75\x04\x3d\xd7\x02\x1c\xa1\x6c\x3d\x03\xeb\x44\x26\x45\x79\x47\x69\xc6\x95\xe4\x9c\x89\x49\x99\xe9\xfe\x5c\xd7\x4f\x16\xea\x5c\x48\x8b\x91\x9f\x4b\x63\xff\x6f\x0f\xfe\x5b\x89\xe3\x45\x0d\x5a\x66\xc2\xe9\x99\x20\x28\xd4\x14\x85\x6f\x5c\x99\x9a\x0b\xbf\xcc\x04\x67\x53\xbf\x8b\xd6\x06\xd6\x1a\xc4\x8e\x1b\xf3\xdd\x26\x5a\x22\xc5\xf2\x4e\xbc\xaa\x46\xc9\x94\xdc\x7f\xa9\x9a\x1f\xc7\x08\xf6\x3b\x7f\xdb\xf8\x77\x00\x00\x00\xff\xff\x95\xd8\x9d\x17\x06\x19\x00\x00")

func assetsDnsDaemonsetYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsDaemonsetYaml,
		"assets/dns/daemonset.yaml",
	)
}

func assetsDnsDaemonsetYaml() (*asset, error) {
	bytes, err := assetsDnsDaemonsetYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/daemonset.yaml", size: 6406, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x33, 0xc0, 0x8c, 0xc1, 0x6a, 0x4f, 0xd3, 0xe9, 0xf5, 0x19, 0xba, 0x65, 0x8, 0x7d, 0x97, 0x28, 0x53, 0x51, 0xb3, 0xe9, 0x5e, 0x4c, 0xf, 0xfc, 0x23, 0x10, 0xb, 0x8, 0x88, 0x65, 0xb3, 0x46}}
	return a, nil
}

var _assetsDnsMetricsClusterRoleBindingYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x7c\x8f\xb1\x4a\x04\x41\x0c\x86\xfb\x79\x8a\xbc\xc0\xae\xd8\x1d\xd3\xa9\x85\xfd\x09\xf6\xb9\x99\x9c\x1b\x77\x27\x19\x92\xcc\x16\x3e\xbd\x2c\x8a\x08\xe2\xb5\x81\x7c\xdf\xff\xad\x2c\x35\xc3\xd3\x36\x3c\xc8\xce\xba\xd1\x23\x4b\x65\x79\x4b\xd8\xf9\x95\xcc\x59\x25\x83\x5d\xb0\xcc\x38\x62\x51\xe3\x0f\x0c\x56\x99\xd7\x93\xcf\xac\x77\xfb\x7d\x6a\x14\x58\x31\x30\x27\x00\xc1\x46\x19\xaa\xf8\xd4\x54\x38\xd4\x0e\x92\x8f\xcb\x3b\x95\xf0\x9c\x26\xf8\xd2\xbd\x90\xed\x5c\xe8\xa1\x14\x1d\x12\x3f\x7f\xdd\xb4\x51\x2c\x34\x7c\x5a\x4f\xfe\x7d\xf6\x8e\x85\x32\x68\x27\xf1\x85\xaf\xf1\x9b\x6c\xba\xd1\x99\xae\x87\xf9\x4f\xc7\x7f\x6b\x00\xb0\xf3\xb3\xe9\xe8\x37\xba\xd2\x67\x00\x00\x00\xff\xff\x5b\x52\x00\xaa\x17\x01\x00\x00")

func assetsDnsMetricsClusterRoleBindingYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsMetricsClusterRoleBindingYaml,
		"assets/dns/metrics/cluster-role-binding.yaml",
	)
}

func assetsDnsMetricsClusterRoleBindingYaml() (*asset, error) {
	bytes, err := assetsDnsMetricsClusterRoleBindingYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/metrics/cluster-role-binding.yaml", size: 279, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x79, 0x95, 0x6f, 0xa4, 0xd5, 0xed, 0x48, 0x27, 0x41, 0x56, 0x5c, 0xea, 0x5c, 0x89, 0xdc, 0xc1, 0x44, 0x91, 0xd4, 0xb, 0x18, 0x85, 0x79, 0x75, 0xaa, 0x6e, 0xb5, 0x98, 0xbe, 0xc6, 0x33, 0x43}}
	return a, nil
}

var _assetsDnsMetricsClusterRoleYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x34\xcd\x31\x4b\x34\x41\x0c\x87\xf1\x7e\x3e\x45\xe0\xad\x77\x5f\xec\x64\x5a\x05\x3b\x0b\x05\xfb\xec\xce\xdf\xdb\x70\x3b\xc9\x90\x64\x0e\xf4\xd3\x8b\x70\xb6\x0f\x3f\x78\xfe\xd1\xd3\x39\x23\xe1\xe4\x76\x22\x48\x81\x86\x46\xdb\x17\x0d\xb7\x8e\x3c\x30\x83\xd2\x28\x76\xe7\x01\x7a\x7e\x7d\xa7\x8e\x74\xd9\x83\xa0\x6d\x98\x68\x16\x1e\xf2\x01\x0f\x31\xad\xe4\x1b\xef\x2b\xcf\x3c\xcc\xe5\x9b\x53\x4c\xd7\xeb\x63\xac\x62\xff\x6f\x0f\xe5\x2a\xda\xea\xdf\xf0\xcd\x4e\x94\x8e\xe4\xc6\xc9\xb5\x10\x29\x77\x54\x6a\x1a\x4b\x37\x95\x34\x17\xbd\x14\x9f\x27\xa2\x96\x85\x78\xc8\x8b\xdb\x1c\xf1\x4b\x17\xb2\x01\xe7\x34\x5f\x6d\x40\xe3\x90\xcf\x5c\xc5\x0a\x91\x23\x6c\xfa\x8e\x3b\x6b\x1a\x88\x42\x74\x83\x6f\xf7\x74\x41\x96\x9f\x00\x00\x00\xff\xff\x9f\xa8\x4d\x6c\xf6\x00\x00\x00")

func assetsDnsMetricsClusterRoleYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsMetricsClusterRoleYaml,
		"assets/dns/metrics/cluster-role.yaml",
	)
}

func assetsDnsMetricsClusterRoleYaml() (*asset, error) {
	bytes, err := assetsDnsMetricsClusterRoleYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/metrics/cluster-role.yaml", size: 246, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x64, 0xdb, 0xe0, 0x95, 0x65, 0xae, 0x53, 0x96, 0x3a, 0x5f, 0x5e, 0x8b, 0x69, 0xe2, 0x7d, 0x5, 0xbf, 0x1f, 0x3a, 0xf, 0xff, 0xd0, 0x6b, 0x23, 0x4f, 0xfd, 0x11, 0x7f, 0x57, 0xd4, 0x4a, 0x8b}}
	return a, nil
}

var _assetsDnsMetricsRoleBindingYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x94\xce\xb1\x4e\xc4\x40\x0c\x04\xd0\x7e\xbf\xc2\x3f\x90\x20\xba\xd3\x76\xd0\xd0\x1f\x12\xbd\x6f\xd7\x97\x98\x64\xed\x95\xed\x4d\xc1\xd7\x23\xa4\x48\x54\x20\x5d\x3b\x9a\xd1\x1b\xec\xfc\x41\xe6\xac\x92\xc1\x6e\x58\x66\x1c\xb1\xaa\xf1\x17\x06\xab\xcc\xdb\xc5\x67\xd6\xa7\xe3\x39\x6d\x2c\x35\xc3\x55\x77\x7a\x65\xa9\x2c\x4b\x6a\x14\x58\x31\x30\x27\x00\xc1\x46\x19\xba\x69\xa3\x58\x69\xf8\xb4\x5d\xfc\x8c\xbd\x63\xa1\x0c\xda\x49\x7c\xe5\x7b\x4c\x55\x3c\x99\xee\x74\xa5\xfb\xcf\x14\x3b\xbf\x99\x8e\xfe\x8f\x9f\x00\x7e\xf9\xbf\x34\x1f\xb7\x4f\x2a\xe1\x39\x4d\x67\xfb\x9d\xec\xe0\x42\x2f\xa5\xe8\x90\x78\xf0\x65\x53\xe1\x50\x63\x59\x20\x7d\x07\x00\x00\xff\xff\xb9\xd9\xab\x8d\x25\x01\x00\x00")

func assetsDnsMetricsRoleBindingYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsMetricsRoleBindingYaml,
		"assets/dns/metrics/role-binding.yaml",
	)
}

func assetsDnsMetricsRoleBindingYaml() (*asset, error) {
	bytes, err := assetsDnsMetricsRoleBindingYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/metrics/role-binding.yaml", size: 293, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0xc, 0x7d, 0xc7, 0x45, 0x33, 0xc4, 0xd8, 0xf, 0x8d, 0x89, 0x8d, 0x6, 0x47, 0xa7, 0xa, 0x6b, 0x17, 0xf5, 0x5f, 0x5a, 0x2f, 0xd8, 0xf9, 0x6, 0x71, 0xaa, 0x78, 0x8d, 0xb5, 0x7a, 0xf6, 0x99}}
	return a, nil
}

var _assetsDnsMetricsRoleYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x4c\x8e\xb1\x4e\xec\x40\x0c\x45\xfb\xf9\x0a\x6b\x5f\x9d\x7d\xa2\x5b\x4d\x8d\x44\x47\x01\x12\xbd\x77\xe6\x42\xac\x24\xe3\x91\xed\x04\xc1\xd7\xa3\xcd\x06\x89\xca\xf7\x1e\x59\x3e\xfe\x47\x2f\x3a\xc3\xa9\x01\x15\x95\xae\x5f\xd4\x4d\x17\xc4\x88\xd5\x29\x94\xbc\x18\x77\xd0\xe3\xf3\x2b\x2d\x08\x93\xe2\x84\x56\xbb\x4a\x8b\xc4\x5d\xde\x60\x2e\xda\x32\xd9\x95\xcb\x99\xd7\x18\xd5\xe4\x9b\x43\xb4\x9d\xa7\x8b\x9f\x45\xff\x6f\x0f\x69\x92\x56\xf3\x2e\x4a\x0b\x82\x2b\x07\xe7\x44\xd4\x78\x41\xfe\xe3\x1b\xa6\x8b\x1f\xd8\x3b\x17\x64\xd2\x8e\xe6\xa3\xbc\xc7\x50\x9b\x27\x5b\x67\x78\x4e\x03\x71\x97\x27\xd3\xb5\xfb\xed\xca\x40\xa7\x53\x22\x32\xb8\xae\x56\x70\x30\x87\x6d\x52\xe0\x7b\xf9\xfd\xf8\xde\xba\xd6\x5b\xd8\x60\xd7\x63\xf9\x03\xb1\xcf\x59\xfc\x1e\x3e\x39\xca\x98\x7e\x02\x00\x00\xff\xff\x29\x39\xda\x05\x1c\x01\x00\x00")

func assetsDnsMetricsRoleYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsMetricsRoleYaml,
		"assets/dns/metrics/role.yaml",
	)
}

func assetsDnsMetricsRoleYaml() (*asset, error) {
	bytes, err := assetsDnsMetricsRoleYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/metrics/role.yaml", size: 284, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x8c, 0xf2, 0x4e, 0x40, 0x91, 0xd8, 0x5e, 0x1c, 0x98, 0xb6, 0x2f, 0x11, 0x2a, 0x15, 0x8f, 0xe4, 0x7c, 0xfe, 0xc6, 0x31, 0xf3, 0xb2, 0xa0, 0x38, 0xb2, 0x3f, 0x15, 0x5a, 0x33, 0x12, 0xd2, 0x88}}
	return a, nil
}

var _assetsDnsNamespaceYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x64\x90\xcd\x4e\xc4\x30\x0c\x84\xef\x79\x8a\x51\x38\x2f\x3f\xd7\xbc\x03\x5c\x90\xb8\xbb\x8d\x97\x35\x4d\xed\x2a\x76\xcb\xeb\xa3\xb2\x15\xac\xb4\xc7\x68\x46\xf3\x7d\xf1\x24\x5a\x0b\xde\x68\x66\x5f\x68\xe4\x44\x8b\x7c\x70\x77\x31\x2d\xd8\x5e\xd2\xcc\x41\x95\x82\x4a\x02\x48\xd5\x82\x42\x4c\x7d\x7f\x02\xb6\xb0\xfa\x45\xce\xf1\x28\xf6\xa4\x56\xf9\xe4\xdc\x78\x0c\xeb\x05\x39\x27\x40\x69\xe6\xf2\x5f\x3b\x55\xf5\x04\x34\x1a\xb8\x1d\x13\x0f\x70\x0e\x6c\xd4\x56\x46\x18\x68\x33\xa9\xa8\xbc\xb0\x56\xd1\x4f\x98\x62\x5a\x07\x06\xd5\x59\x7c\x97\x42\x5c\x28\x8e\x82\xef\xf1\xdf\x38\x68\x11\xbf\xd7\xea\xab\x9e\x1a\x6f\xdc\x0a\xf2\x73\x3e\x98\xd4\x9a\x7d\xdf\x78\xcd\xa6\x12\xd6\x77\x62\x18\x9a\xd9\x84\xb3\x75\xbc\x73\xdf\x64\xe4\xd7\x6b\x0a\x1b\xbe\x78\x0c\x87\xec\x16\xe2\xbf\xbf\xbb\x1e\xed\x8e\x3a\xb6\xd5\x83\xfb\xcd\x70\x41\x8e\xbe\x72\x4e\x3f\x01\x00\x00\xff\xff\x82\x6d\x29\x03\x71\x01\x00\x00")

func assetsDnsNamespaceYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsNamespaceYaml,
		"assets/dns/namespace.yaml",
	)
}

func assetsDnsNamespaceYaml() (*asset, error) {
	bytes, err := assetsDnsNamespaceYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/namespace.yaml", size: 369, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0xe, 0xab, 0x50, 0x84, 0x61, 0x5f, 0x41, 0xf4, 0x17, 0x3b, 0x6, 0x84, 0xc0, 0x5f, 0x4f, 0xbb, 0xd8, 0x1d, 0xae, 0x26, 0x3e, 0x1f, 0x29, 0x2c, 0x84, 0x6d, 0x5e, 0xc1, 0x87, 0x97, 0x5f, 0xc9}}
	return a, nil
}

var _assetsDnsServiceAccountYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x2c\xc9\xb1\x09\xc4\x30\x0c\x05\xd0\xde\x53\x68\x81\x2b\xae\x55\x77\x33\x1c\xa4\x17\xf2\x0f\x11\xc1\xb2\xb1\x14\xcf\x1f\x02\xe9\x1e\xbc\xd3\xbc\x32\xfd\x31\x97\x29\x7e\xaa\xfd\xf2\x2c\x32\x6c\xc3\x0c\xeb\xce\xb4\xbe\xa5\x21\xa5\x4a\x0a\x17\x22\x97\x06\xa6\xea\xf1\x3a\x86\x28\x98\xfa\x80\xc7\x61\x7b\x7e\x9e\xba\x03\x00\x00\xff\xff\x8e\x2c\xf1\x2e\x55\x00\x00\x00")

func assetsDnsServiceAccountYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsServiceAccountYaml,
		"assets/dns/service-account.yaml",
	)
}

func assetsDnsServiceAccountYaml() (*asset, error) {
	bytes, err := assetsDnsServiceAccountYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/service-account.yaml", size: 85, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x57, 0x12, 0x50, 0x4d, 0x67, 0x2f, 0x1b, 0x74, 0xa0, 0xa4, 0xbb, 0xa7, 0x59, 0xe9, 0x5a, 0xc6, 0xc1, 0x1a, 0xf8, 0x5f, 0xff, 0x5, 0xdb, 0xc, 0x10, 0x8b, 0xc1, 0x0, 0xcc, 0xf, 0x9f, 0x3a}}
	return a, nil
}

var _assetsDnsServiceYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x84\x91\x31\x6f\xe2\x40\x10\x85\x7b\xff\x8a\x27\xe8\x4e\xc0\x09\xdd\x51\x9c\xdb\xa3\x89\x52\x80\x14\x48\x3f\x5e\x4f\xcc\x8a\xf5\x8c\xb5\x33\x06\xf1\xef\x23\x4c\x42\x80\x14\x69\x56\xda\x7d\x9f\x3e\x3d\xbd\xdd\x47\xa9\x4b\xbc\x70\x3e\xc4\xc0\x05\x75\xf1\x95\xb3\x45\x95\x12\x87\x79\x31\x86\x50\xcb\x93\xe1\xb4\x8e\x02\x4f\x12\x55\x9c\x0c\x24\x35\x48\x44\x9d\x3c\xaa\x18\x28\x33\x8c\x1d\xe4\xc8\xbd\x78\x6c\xb9\xb0\x8e\x43\x59\x00\x63\x84\xd4\x9b\x73\x7e\x5a\xe3\x18\x53\x42\xc5\xa0\xde\xb5\x25\x8f\x81\x52\x3a\xa1\x25\xa1\x86\xeb\xd9\x00\x1b\x27\x0e\xae\x19\xd1\x1e\x8d\x40\xa7\xd9\xed\x2c\x9d\x0e\x95\x4a\xd4\x62\x05\x70\x09\x4a\x2c\xfe\x0c\x17\xa7\xdc\xb0\xaf\x87\xa7\x2b\x90\xd5\x35\x68\x2a\xb1\x5d\xae\xef\x05\x53\x0f\xdd\x8f\x92\x2f\xe8\x2a\xda\xfc\xbf\x15\xb5\xec\x39\x86\xdb\x36\xff\xe6\x8b\xbf\xdf\x54\x77\xd8\x83\x6a\x8c\xcd\x6a\xb9\x2a\xb1\x95\xa0\x6d\xcb\xe2\x38\xee\x58\x60\x97\xbf\x81\x6b\xa7\x49\x9b\x13\xde\x98\xbc\xcf\x8c\x86\x9c\xcf\x33\xb1\x50\x95\x3e\xf6\xfb\x84\x9e\xf9\x64\x97\xf5\x31\xc5\x68\xdf\x57\x9c\x85\x9d\x6d\x16\xf5\xf7\x4e\xcd\xcf\xa5\x47\xd7\xfc\xd7\xa8\x78\x0f\x00\x00\xff\xff\x82\x42\x75\xa4\x08\x02\x00\x00")

func assetsDnsServiceYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsServiceYaml,
		"assets/dns/service.yaml",
	)
}

func assetsDnsServiceYaml() (*asset, error) {
	bytes, err := assetsDnsServiceYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/service.yaml", size: 520, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x18, 0x69, 0xc5, 0xf1, 0xe, 0xc, 0x77, 0xe5, 0x78, 0xce, 0xfc, 0xc2, 0x41, 0xf8, 0x21, 0x87, 0x8a, 0xb7, 0x67, 0xdd, 0x48, 0x94, 0x63, 0x79, 0x69, 0x4e, 0x38, 0x53, 0x3c, 0xdb, 0xc7, 0x13}}
	return a, nil
}

// Asset loads and returns the asset for the given name.
// It returns an error if the asset could not be found or
// could not be loaded.
func Asset(name string) ([]byte, error) {
	canonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[canonicalName]; ok {
		a, err := f()
		if err != nil {
			return nil, fmt.Errorf("Asset %s can't read by error: %v", name, err)
		}
		return a.bytes, nil
	}
	return nil, fmt.Errorf("Asset %s not found", name)
}

// AssetString returns the asset contents as a string (instead of a []byte).
func AssetString(name string) (string, error) {
	data, err := Asset(name)
	return string(data), err
}

// MustAsset is like Asset but panics when Asset would return an error.
// It simplifies safe initialization of global variables.
func MustAsset(name string) []byte {
	a, err := Asset(name)
	if err != nil {
		panic("asset: Asset(" + name + "): " + err.Error())
	}

	return a
}

// MustAssetString is like AssetString but panics when Asset would return an
// error. It simplifies safe initialization of global variables.
func MustAssetString(name string) string {
	return string(MustAsset(name))
}

// AssetInfo loads and returns the asset info for the given name.
// It returns an error if the asset could not be found or
// could not be loaded.
func AssetInfo(name string) (os.FileInfo, error) {
	canonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[canonicalName]; ok {
		a, err := f()
		if err != nil {
			return nil, fmt.Errorf("AssetInfo %s can't read by error: %v", name, err)
		}
		return a.info, nil
	}
	return nil, fmt.Errorf("AssetInfo %s not found", name)
}

// AssetDigest returns the digest of the file with the given name. It returns an
// error if the asset could not be found or the digest could not be loaded.
func AssetDigest(name string) ([sha256.Size]byte, error) {
	canonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[canonicalName]; ok {
		a, err := f()
		if err != nil {
			return [sha256.Size]byte{}, fmt.Errorf("AssetDigest %s can't read by error: %v", name, err)
		}
		return a.digest, nil
	}
	return [sha256.Size]byte{}, fmt.Errorf("AssetDigest %s not found", name)
}

// Digests returns a map of all known files and their checksums.
func Digests() (map[string][sha256.Size]byte, error) {
	mp := make(map[string][sha256.Size]byte, len(_bindata))
	for name := range _bindata {
		a, err := _bindata[name]()
		if err != nil {
			return nil, err
		}
		mp[name] = a.digest
	}
	return mp, nil
}

// AssetNames returns the names of the assets.
func AssetNames() []string {
	names := make([]string, 0, len(_bindata))
	for name := range _bindata {
		names = append(names, name)
	}
	return names
}

// _bindata is a table, holding each asset generator, mapped to its name.
var _bindata = map[string]func() (*asset, error){
	"assets/dns/cluster-role-binding.yaml": assetsDnsClusterRoleBindingYaml,

	"assets/dns/cluster-role.yaml": assetsDnsClusterRoleYaml,

	"assets/dns/daemonset.yaml": assetsDnsDaemonsetYaml,

	"assets/dns/metrics/cluster-role-binding.yaml": assetsDnsMetricsClusterRoleBindingYaml,

	"assets/dns/metrics/cluster-role.yaml": assetsDnsMetricsClusterRoleYaml,

	"assets/dns/metrics/role-binding.yaml": assetsDnsMetricsRoleBindingYaml,

	"assets/dns/metrics/role.yaml": assetsDnsMetricsRoleYaml,

	"assets/dns/namespace.yaml": assetsDnsNamespaceYaml,

	"assets/dns/service-account.yaml": assetsDnsServiceAccountYaml,

	"assets/dns/service.yaml": assetsDnsServiceYaml,
}

// AssetDir returns the file names below a certain
// directory embedded in the file by go-bindata.
// For example if you run go-bindata on data/... and data contains the
// following hierarchy:
//     data/
//       foo.txt
//       img/
//         a.png
//         b.png
// then AssetDir("data") would return []string{"foo.txt", "img"},
// AssetDir("data/img") would return []string{"a.png", "b.png"},
// AssetDir("foo.txt") and AssetDir("notexist") would return an error, and
// AssetDir("") will return []string{"data"}.
func AssetDir(name string) ([]string, error) {
	node := _bintree
	if len(name) != 0 {
		canonicalName := strings.Replace(name, "\\", "/", -1)
		pathList := strings.Split(canonicalName, "/")
		for _, p := range pathList {
			node = node.Children[p]
			if node == nil {
				return nil, fmt.Errorf("Asset %s not found", name)
			}
		}
	}
	if node.Func != nil {
		return nil, fmt.Errorf("Asset %s not found", name)
	}
	rv := make([]string, 0, len(node.Children))
	for childName := range node.Children {
		rv = append(rv, childName)
	}
	return rv, nil
}

type bintree struct {
	Func     func() (*asset, error)
	Children map[string]*bintree
}

var _bintree = &bintree{nil, map[string]*bintree{
	"assets": {nil, map[string]*bintree{
		"dns": {nil, map[string]*bintree{
			"cluster-role-binding.yaml": {assetsDnsClusterRoleBindingYaml, map[string]*bintree{}},
			"cluster-role.yaml":         {assetsDnsClusterRoleYaml, map[string]*bintree{}},
			"daemonset.yaml":            {assetsDnsDaemonsetYaml, map[string]*bintree{}},
			"metrics": {nil, map[string]*bintree{
				"cluster-role-binding.yaml": {assetsDnsMetricsClusterRoleBindingYaml, map[string]*bintree{}},
				"cluster-role.yaml":         {assetsDnsMetricsClusterRoleYaml, map[string]*bintree{}},
				"role-binding.yaml":         {assetsDnsMetricsRoleBindingYaml, map[string]*bintree{}},
				"role.yaml":                 {assetsDnsMetricsRoleYaml, map[string]*bintree{}},
			}},
			"namespace.yaml":       {assetsDnsNamespaceYaml, map[string]*bintree{}},
			"service-account.yaml": {assetsDnsServiceAccountYaml, map[string]*bintree{}},
			"service.yaml":         {assetsDnsServiceYaml, map[string]*bintree{}},
		}},
	}},
}}

// RestoreAsset restores an asset under the given directory.
func RestoreAsset(dir, name string) error {
	data, err := Asset(name)
	if err != nil {
		return err
	}
	info, err := AssetInfo(name)
	if err != nil {
		return err
	}
	err = os.MkdirAll(_filePath(dir, filepath.Dir(name)), os.FileMode(0755))
	if err != nil {
		return err
	}
	err = ioutil.WriteFile(_filePath(dir, name), data, info.Mode())
	if err != nil {
		return err
	}
	return os.Chtimes(_filePath(dir, name), info.ModTime(), info.ModTime())
}

// RestoreAssets restores an asset under the given directory recursively.
func RestoreAssets(dir, name string) error {
	children, err := AssetDir(name)
	// File
	if err != nil {
		return RestoreAsset(dir, name)
	}
	// Dir
	for _, child := range children {
		err = RestoreAssets(dir, filepath.Join(name, child))
		if err != nil {
			return err
		}
	}
	return nil
}

func _filePath(dir, name string) string {
	canonicalName := strings.Replace(name, "\\", "/", -1)
	return filepath.Join(append([]string{dir}, strings.Split(canonicalName, "/")...)...)
}
