// Code generated by go-bindata. DO NOT EDIT.
// sources:
// assets/dns/cluster-role-binding.yaml (223B)
// assets/dns/cluster-role.yaml (397B)
// assets/dns/daemonset.yaml (6.404kB)
// assets/dns/metrics/cluster-role-binding.yaml (279B)
// assets/dns/metrics/cluster-role.yaml (246B)
// assets/dns/metrics/role-binding.yaml (293B)
// assets/dns/metrics/role.yaml (284B)
// assets/dns/namespace.yaml (369B)
// assets/dns/service-account.yaml (85B)
// assets/dns/service.yaml (520B)

package manifests

import (
	"bytes"
	"compress/gzip"
	"crypto/sha256"
	"fmt"
	"io"
	"io/ioutil"
	"os"
	"path/filepath"
	"strings"
	"time"
)

func bindataRead(data []byte, name string) ([]byte, error) {
	gz, err := gzip.NewReader(bytes.NewBuffer(data))
	if err != nil {
		return nil, fmt.Errorf("Read %q: %v", name, err)
	}

	var buf bytes.Buffer
	_, err = io.Copy(&buf, gz)
	clErr := gz.Close()

	if err != nil {
		return nil, fmt.Errorf("Read %q: %v", name, err)
	}
	if clErr != nil {
		return nil, err
	}

	return buf.Bytes(), nil
}

type asset struct {
	bytes  []byte
	info   os.FileInfo
	digest [sha256.Size]byte
}

type bindataFileInfo struct {
	name    string
	size    int64
	mode    os.FileMode
	modTime time.Time
}

func (fi bindataFileInfo) Name() string {
	return fi.name
}
func (fi bindataFileInfo) Size() int64 {
	return fi.size
}
func (fi bindataFileInfo) Mode() os.FileMode {
	return fi.mode
}
func (fi bindataFileInfo) ModTime() time.Time {
	return fi.modTime
}
func (fi bindataFileInfo) IsDir() bool {
	return false
}
func (fi bindataFileInfo) Sys() interface{} {
	return nil
}

var _assetsDnsClusterRoleBindingYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x6c\xce\x31\x8e\x83\x40\x0c\x05\xd0\x7e\x4e\xe1\x0b\xc0\x6a\xbb\xd5\x74\x9b\xdc\x80\x48\xe9\xcd\x8c\x09\x0e\x60\xa3\xb1\x87\x22\xa7\x8f\x10\x4a\x45\x3a\x17\xfe\xff\xfd\x89\x25\x47\xb8\xce\xd5\x9c\x4a\xa7\x33\x5d\x58\x32\xcb\x23\xe0\xca\x77\x2a\xc6\x2a\x11\x4a\x8f\xa9\xc5\xea\xa3\x16\x7e\xa1\xb3\x4a\x3b\xfd\x59\xcb\xfa\xb3\xfd\x86\x85\x1c\x33\x3a\xc6\x00\x00\x20\xb8\x50\x04\x5d\x49\x6c\xe4\xc1\x9b\x2c\x16\xac\xf6\x4f\x4a\x6e\x31\x34\x70\x78\x37\x2a\x1b\x27\xfa\x4f\x49\xab\x78\xf8\xc4\xf6\xe7\xe3\xb6\x15\xd3\xa9\xa7\xe8\x4c\x1d\x0d\x3b\x74\x9a\x1d\xbe\xd3\xef\x00\x00\x00\xff\xff\xfa\x62\xe7\x50\xdf\x00\x00\x00")

func assetsDnsClusterRoleBindingYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsClusterRoleBindingYaml,
		"assets/dns/cluster-role-binding.yaml",
	)
}

func assetsDnsClusterRoleBindingYaml() (*asset, error) {
	bytes, err := assetsDnsClusterRoleBindingYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/cluster-role-binding.yaml", size: 223, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0xd9, 0xf6, 0x2a, 0x3b, 0x84, 0xd7, 0x3e, 0xc4, 0xe1, 0x70, 0x66, 0x31, 0xda, 0xc4, 0x2f, 0x53, 0x27, 0x29, 0x13, 0xfe, 0x80, 0x36, 0xc5, 0xa1, 0x70, 0xdc, 0x2d, 0xef, 0xcf, 0xe0, 0xc4, 0xeb}}
	return a, nil
}

var _assetsDnsClusterRoleYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x7c\x90\xb1\x4e\xc4\x30\x10\x44\x7b\x7f\x85\x75\xfd\x05\xd1\xa1\xb4\x14\xf4\x14\xf4\x1b\x67\x50\x96\xe4\x76\xad\xdd\x75\x4e\xe2\xeb\x51\x2e\x57\xa0\x8b\xa0\x9b\x19\xd9\xf3\x3c\x9e\x59\xc6\x3e\xbf\x2e\xcd\x03\xf6\xae\x0b\x12\x55\xfe\x80\x39\xab\xf4\xd9\x06\x2a\x1d\xb5\x98\xd4\xf8\x9b\x82\x55\xba\xf9\xc5\x3b\xd6\xa7\xf5\x39\x5d\x10\x34\x52\x50\x9f\x72\x16\xba\xa0\xcf\x5a\x21\x3e\xf1\x67\x9c\x47\xf1\x64\x6d\x81\xf7\xe9\x9c\xa9\xf2\x9b\x69\xab\xbe\x9d\x3c\xe7\xd3\x29\xe5\x6c\x70\x6d\x56\x70\xcf\x20\x63\x55\x96\xf0\x9b\x73\xd8\xca\x05\xbb\xa9\x3a\xee\x62\x63\x78\xa5\x3d\x5f\x61\xc3\xfd\xee\xc2\x1e\x37\x71\xa5\x28\x53\x3a\x02\xb7\x01\x90\xe0\xf2\x7b\xc1\xf1\x0d\xa1\x33\xc4\xb0\x32\xae\x0f\x84\x62\xa0\xc0\x1f\xcd\x8f\x5f\x73\x2c\xf6\x36\x7c\xa1\x04\x95\x02\xf7\xff\x00\x3f\x01\x00\x00\xff\xff\x76\x1b\x55\x2e\x8d\x01\x00\x00")

func assetsDnsClusterRoleYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsClusterRoleYaml,
		"assets/dns/cluster-role.yaml",
	)
}

func assetsDnsClusterRoleYaml() (*asset, error) {
	bytes, err := assetsDnsClusterRoleYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/cluster-role.yaml", size: 397, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x84, 0xae, 0xd1, 0xba, 0xfa, 0x6b, 0xf8, 0x6e, 0x8d, 0x28, 0xc2, 0xa7, 0xaf, 0xc9, 0x3b, 0xc7, 0xcd, 0x80, 0xbe, 0xec, 0x98, 0xb4, 0x61, 0xa0, 0x9, 0xae, 0xa, 0xd8, 0xb2, 0x2e, 0x16, 0xf2}}
	return a, nil
}

var _assetsDnsDaemonsetYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xcc\x59\xff\x53\xdb\xc6\x12\xff\x9d\xbf\x62\x2b\x78\x21\x69\x10\x98\x24\xa4\x79\x4a\xe8\xab\x0b\xa6\x30\x0d\xe0\xc1\x4e\xf3\x03\xc3\x63\xce\xa7\xb5\x75\xcf\xa7\xbb\xeb\xdd\x49\xa0\x01\xfe\xf7\x37\x77\xb2\x6c\xc9\x32\x6e\x33\xef\xcb\xb4\x3f\x50\xb8\xdd\xfd\xdc\xee\xde\x7e\x55\xa6\x4c\xc4\x11\x1c\x13\x4c\xa5\x18\xa0\xdd\x20\x8a\xfd\x86\xda\x30\x29\x22\x20\x4a\x99\xbd\x7c\x7f\x63\x13\x04\x49\x71\xc7\xff\x34\x8a\x50\x04\x22\x62\xe0\x64\x84\xdc\x00\xd1\x08\x06\x2d\x10\x0b\x3a\x13\x96\xa5\xb8\x61\x14\xd2\x68\x03\xc0\x62\xaa\x38\xb1\xe8\x7e\x07\xa8\x4e\xfd\xef\xa8\x73\x46\xb1\x4b\xa9\xcc\x84\xbd\x20\x29\x46\x10\x0b\x33\xa3\x2a\xcd\xa4\x66\xb6\x38\xe2\xc4\x98\x92\x68\x0a\x63\x31\x0d\x85\x8c\x31\xa4\x9a\x59\x46\x09\x9f\x71\x53\x29\x2c\x61\x02\xb5\xa9\xd0\x43\xaf\x69\x1d\x11\x60\x13\x58\x4a\x26\x08\xcc\x2c\x6b\x5b\x71\x78\x7a\x3f\xe3\xbc\x2f\x39\xa3\x45\x04\x67\xe3\x0b\x69\xfb\x1a\x0d\x0a\x3b\xe7\xb2\xa8\x53\x26\x88\x65\x52\x9c\xa3\x31\x4e\x64\xc6\x7e\x42\x38\x1f\x11\x3a\x1d\xca\xcf\x72\x62\x2e\x45\x4f\x6b\xa9\xe7\x72\x54\xa6\x29\x71\xae\xbe\x86\x80\x4a\x8d\xb1\x30\x01\xdc\xcc\xc9\x44\x4f\x8c\xa7\x85\x54\x8a\x71\xb0\x03\xc1\x1e\x5a\xba\x37\xe3\xdc\x3b\x92\x1a\xc7\x8c\x63\x5d\x24\x97\x3c\x4b\xf1\xdc\x39\x70\x6e\xf9\xc2\x76\x07\xc3\x26\x61\xc9\x34\xa7\x02\xa4\x8e\xbf\x4f\x6c\x12\x41\xfd\x86\x1a\x87\x46\x12\x5f\x0a\x5e\x44\x60\x75\xb6\x10\x55\x52\x37\xef\x99\xfb\xbd\x2f\xb5\x8d\xe0\xe0\xed\xc1\xdb\x1a\x4a\xfb\x05\xdc\xbb\x4a\x2b\xa9\xe4\x11\x7c\x39\xee\x7f\x3b\x52\x68\xa9\x5a\x89\x36\x3c\x5a\xa0\x39\xed\x99\x40\x63\xfa\x5a\x8e\x30\xaa\xf1\x27\xd6\xaa\x5f\xd0\xd6\x8f\x00\x54\xe9\x89\x04\x09\xb7\x49\x93\xe2\x75\xf9\xd0\xf9\xd0\x69\x1c\x1b\x9a\xa0\xd3\xe7\x74\x38\xec\xd7\x08\x4c\x30\xcb\x08\x3f\x46\x4e\x8a\x01\x52\x29\x62\x13\xc1\x7e\x5d\x54\xa1\x66\x32\x9e\xd3\xea\x16\x9a\x8c\x52\x34\x66\x98\x68\x34\x89\xe4\x71\x04\xfb\x35\xea\x98\x30\x9e\x69\xac\x51\xeb\xb2\x2e\x84\x65\x66\x57\xe0\x72\x96\xe3\x5f\xc4\x11\xef\x3b\x6b\x34\x3e\xf8\x0f\x3c\x71\x50\x7b\x77\x23\x33\x4d\xd1\xd4\xcd\xe2\x2c\x65\xd6\x34\x0d\x4d\x31\x95\xba\x88\xe0\x60\xff\xcd\x39\x6b\x84\xfd\xef\x19\x9a\x65\x6e\xaa\xb2\x08\x0e\x3a\xe9\x4a\x88\x1f\x3a\x73\x84\x2a\xed\xa6\xd9\x08\x43\x3d\x22\x34\x54\x5a\xde\x17\xdf\x50\x7e\x7c\x05\xa8\x25\x45\x18\x72\x39\xb1\xd2\xd8\x18\xb5\x6e\x9c\x1b\xa4\x99\xc6\x90\x33\x63\x51\x84\x24\x8e\x35\x1a\x73\x18\xfd\x7d\xff\xe0\x5d\x83\xcf\x72\x13\x52\xa6\x12\xd4\xa1\xc9\x98\x45\x73\x38\xfc\x3c\xb8\xed\x1d\x1d\x9f\xf6\x6e\xaf\x06\xdd\xdb\xaf\x67\xc3\xd3\xdb\x6e\x6f\x70\xbb\xff\xe6\xc3\xed\x2f\x47\xe7\xb7\x83\xd3\xee\x9b\x83\xf7\x3b\x0b\xae\xde\xd1\xf1\x1f\xf0\xb5\x70\x8e\x7e\x3e\xfa\x53\x38\x2b\xf9\xd6\xa0\x35\x2c\xcb\x94\xb1\x1a\x49\x7a\xe8\x42\x39\xda\xdb\xdb\x7f\xf3\xc3\x6e\x67\xb7\xb3\xbb\xef\x9c\xf0\x76\xaf\xed\x05\xd4\x36\x74\xf5\xf3\xd0\xd7\x3c\xcb\xcd\x9e\xd2\x2c\x27\x16\xdd\xef\xbb\x54\xdb\x96\xc8\x8c\x1e\x4e\xb1\x58\x23\x39\xc5\xe2\x4f\x17\xc8\xc6\xfb\x54\x65\x2d\x45\xab\x19\x35\xeb\xc3\x78\x4d\x68\xee\x3f\x13\x9a\xef\x3a\xb5\xe0\x7e\xae\x53\x2c\xf7\x82\x9a\x75\xcf\x29\xea\x7c\xf3\x47\xbd\xa2\xd6\x7e\xcb\x86\xed\x8c\xe2\x39\xea\xbf\x4c\x33\xf6\x19\xe4\x06\x0c\x29\x2c\xde\x37\x2a\xa1\xb3\x9f\x71\x9c\x60\xbc\xd4\xff\xd6\xb7\xdb\x44\x1a\x6b\x7c\xa0\xac\xe9\xb5\x9e\xa9\xe6\x04\x14\x39\x5c\x74\xcf\x7b\x83\xde\xd5\x6f\xbd\x2b\x3f\x54\x1d\x7d\xfe\x32\x18\xf6\xae\x6e\x8f\x2f\xcf\xbb\x67\x17\xab\x86\xab\x4a\x1c\x45\xde\x56\xc3\x21\x9d\x1d\xf5\x06\x35\x25\x36\xe1\xc8\x8d\x1e\x20\x35\x94\xb3\x9b\x41\x45\x34\xb1\x18\x83\xab\x20\x20\xc7\xd5\x34\x66\x1a\x52\x17\x97\xc3\x5e\x04\x27\x52\x83\x90\x77\x3b\x80\xc2\x64\x1a\xc1\x26\x68\xd0\xab\xa5\x91\x13\xcb\x72\x2c\xa7\xc2\x8f\x30\x96\x1a\x90\xd0\xa4\x49\xd8\x69\x60\x12\x01\x84\x33\x62\xe0\x8e\xd9\xc4\x61\x2d\xdb\x6b\xb2\xf1\x98\xdd\xc3\x1d\xe3\x1c\x08\x37\x12\x46\x08\x24\x8e\x31\xde\xad\xe1\xe4\x84\x67\x18\x41\xe0\x63\x24\xd4\x38\x61\xc6\xea\x62\x57\x2a\x14\x26\x61\x63\x1b\x2e\x11\x4c\x4e\x83\xd6\x1c\x56\x73\xdd\xde\x88\x89\xbd\x11\x31\x49\xbd\x08\xd0\xda\x1f\x8f\x75\x23\xbe\x6b\xb3\x83\x7f\xa3\x30\x93\xa0\x98\x42\xd7\xa5\x36\xea\xfd\x4e\x13\x05\xdb\xff\x92\x23\x03\xa1\x82\x47\xb8\x77\x95\x1e\xa6\xce\xc4\xc7\x47\x1f\x63\x1f\xe1\x8e\x30\xfb\x11\xf0\x9e\x59\xe8\x6c\xc3\xb0\x77\x75\x5e\x47\xb8\xec\xf7\x2e\x06\xa7\x67\x27\xc3\xdb\xf3\xee\xd5\xaf\xbd\xab\xc3\x60\x61\xeb\x04\x05\xfa\xd7\x6c\xa6\x5a\x50\x13\x3f\xbd\x1c\x0c\x07\xb7\x27\x67\x9f\x7b\x87\xc1\x22\x0e\xeb\x1c\xc3\xde\x79\xbf\xc5\xb0\x6b\x53\x15\xd4\xd5\x38\x3b\x19\x1c\x6e\xef\xc0\xb6\xcf\x7a\x08\x35\x84\x64\x1e\x3a\xf0\xe9\xd3\x27\x08\xb6\x1e\xaa\x00\x7c\x6a\x48\x6e\xc2\x39\x99\x22\x10\xbf\x11\x48\x4d\x74\x01\x2e\x55\x16\x61\x20\x79\x5c\xa6\x90\x3f\xdf\x36\x40\xac\xd5\x6c\x94\x59\x34\xf5\x97\xa7\x0a\xc2\x31\x84\xe1\x82\x1a\x4a\xc1\x0b\x77\xf1\xc2\xc8\xa7\xc0\xfd\x3d\x37\xa9\xa9\xc9\x5d\xe2\xee\x2d\x9d\x1e\xcb\x46\xe9\x8c\x91\x72\x17\xd8\x61\x17\x4c\x4e\x6f\x99\x32\x0d\xb2\x8b\x6f\x93\x53\x60\xc2\xc1\x57\x76\x5f\xff\x74\xf3\x14\xb4\xa0\x9c\xc5\x27\x68\x69\x52\xf9\x07\xce\xfa\x30\xd6\x32\x05\xca\x33\x63\x51\xbb\xda\x08\x6c\x0c\xaa\x2c\x68\xbb\xf0\x15\x21\x75\x2e\x32\x98\xa3\x26\x1c\xac\x66\x68\x5a\x98\x56\x42\x2c\x81\xd9\x08\xce\xfa\xf9\xbb\x1d\xf7\xf3\xbd\xff\xf9\x0e\x64\x8e\xda\x0d\xc2\xbe\x8a\xb8\xf3\xf9\xc9\x2e\x0c\x13\x04\x7b\x27\x81\x13\x97\xef\x62\x05\xb0\xb3\xdb\x19\x18\xa3\xe2\xb2\x48\x51\xd8\x59\x8e\xfe\x9a\xe9\x42\x83\x14\xee\x85\x50\xc3\xa5\x42\x31\xb0\x84\x4e\xe1\xe5\xe5\xa0\xbf\xff\xf6\x15\x84\x60\x13\x69\xd0\xe9\x25\xa4\x6d\x01\x9b\x4c\xb9\xbe\xe8\x06\x7e\xe0\x92\xc4\x23\xc2\x89\xa0\xa8\x8d\xd7\xd3\x35\x36\xe6\x6b\x09\xa1\x09\x13\x13\x38\xbe\x18\x80\x4d\xb4\xcc\x26\x89\x57\x7d\x09\x8f\xa6\xb1\x39\x7c\xb9\x1d\xb3\x09\x84\x16\xba\xf0\x53\xb0\xf5\xb0\x28\xa0\x4f\x01\xbc\x36\x89\xbb\xcd\x3d\x50\x4e\x9f\x76\xb7\x1e\x9a\xf5\xe5\x29\x78\x9c\x68\x54\x10\xe6\x10\xfc\xf3\x63\xb0\xbd\x04\x5f\xfe\x37\x87\xef\x76\xff\xd7\x37\xc0\x6b\x4b\x15\xbc\xd6\x68\x75\x71\xd8\xf9\x3f\x98\xf3\xdf\xbd\xef\xd5\xd2\x85\x2e\x82\x98\x4b\x90\xad\x87\xef\xdc\x53\x5d\x7f\x7f\xf3\xb4\xc4\xd2\x4a\x14\x00\xa6\xcc\xe1\xcb\xad\x97\x98\x13\xee\x6e\xf6\x82\xec\xe6\x29\x78\xb5\x0c\x0f\x2e\x63\xae\xaf\x21\xd8\xfa\x47\x00\x21\xfe\x0e\x1d\x78\xf1\xc2\x89\x6c\x32\x55\x26\x22\x84\x02\xa1\x03\x37\x37\x1f\x5d\x55\x11\x2b\xfc\x31\xcb\xec\xeb\x99\x89\xc1\xcd\x61\xb0\xf5\x50\x89\xaf\xe0\x1f\x69\x24\xd3\xd6\xf9\x98\xb5\xcc\x12\xb8\xd1\x3a\x68\x9c\x6c\xc2\x17\x15\x13\x8b\xb5\x51\x00\x7c\xf1\x62\x63\xb8\x43\x98\xa0\x75\x8d\x8d\xc5\xb5\x92\x61\x96\x00\xbe\x62\xd9\x19\x85\xb4\x90\xb5\xc0\xee\x12\x14\xce\x6c\xed\xe7\xaa\xd9\x5e\x3f\x47\x93\x99\x75\x13\x97\xd4\x40\x14\x83\x4c\x90\x9c\x30\x4e\x46\x8c\x33\x5b\x2c\x5d\x33\xb0\x84\x23\xa0\xf0\x35\x08\xa8\xcc\x78\xec\x5a\x93\xb1\xee\x69\x6b\x17\xb2\xb1\xaf\xdd\xd5\x0d\xcc\x40\x8c\x1c\x2d\xc6\x1b\xed\x37\x0b\xc5\x2c\xaa\xbc\xf7\xbf\xbf\x09\x9f\x82\xe7\x9e\x69\x13\x7e\xce\x18\x8f\x81\x80\xc0\xbb\x5a\x57\x28\x0b\x68\xdd\x60\x57\xa0\x64\xa6\x81\x66\xc6\xca\x74\xae\xf1\x98\x71\x8b\x1a\x63\x67\xf3\x12\xf6\x3c\x7c\x37\x61\xeb\x61\xb9\xad\x96\x8d\xa3\xd1\x48\x7e\x5c\xd3\x4a\x4a\x5d\xbb\x4a\xa1\xaf\x64\x65\xdf\x5d\x28\xe1\xda\x45\x7b\xae\x82\x56\x27\xf9\xae\x72\xca\x33\x9d\x64\x96\x56\xaa\xcc\xab\x8a\xb9\x0c\xdf\x9b\xa7\x95\x02\x00\x48\x13\x09\x3e\xb2\x9f\x4a\xa1\xea\x7f\xed\x9c\x86\x67\x5c\xf1\x63\xcb\xf6\xe5\x4b\x5a\x41\xbf\x2a\xec\x9d\x8f\x86\x97\xc7\x97\xd1\x8a\xf0\x27\x56\xa6\x8c\x12\xce\x0b\xd7\xd9\x48\x2e\x59\x0c\x44\x14\xc0\x04\x95\xc2\xf8\xf5\xd6\xc2\x08\x13\x92\xb3\xda\xf0\x5e\xa1\x5e\xa1\xe2\x6e\x9e\x5d\x15\x11\xa9\x8c\xd9\x98\x61\x0c\x79\xf9\x2d\xd3\x45\xa1\x40\x8c\x97\x62\xd3\x75\x14\xb5\x64\x66\x2b\x06\x1e\x1f\x67\x73\xc7\x7a\xbe\xb6\xd5\x15\xaf\xcb\x0c\x97\xb2\x1a\x53\x99\x63\xbc\xb0\xd5\x47\x35\xd5\xe8\xb6\xc9\x32\x75\x7c\x57\x5c\x4c\x37\x40\xa5\x2a\x80\x26\x99\x6e\x26\xc9\x52\xfd\x31\x1c\x51\xc1\xfb\x0e\xbc\xf0\x83\x64\x83\x96\x09\x37\x9b\xb6\x07\x9a\xc6\xe3\x7d\xeb\xd6\x79\x50\x2d\x9d\xb1\x30\xd5\xc6\x75\x8c\x63\x92\xf1\xea\x72\x37\x8c\x0e\x90\x23\xb5\x52\x2f\x00\xa6\xd9\x08\xb5\x40\x37\xd5\x31\xb9\x27\x4d\x04\x9c\x89\xec\xbe\x24\xce\xb8\xca\x3d\xab\xf5\x2d\x77\xf5\xf7\xcc\xf2\xf4\x9c\xa8\xa8\xb6\x56\x5d\x90\x74\xdd\x6a\x09\xc0\x2c\xa6\x0d\xb3\x42\x98\x62\x11\x41\xf5\x95\x75\xc5\x87\xb1\x25\xd2\x9a\xb5\xcf\x1d\xf9\x9d\x6f\x63\x19\x63\xc5\x0e\x08\x60\x0b\x85\x11\x9c\xb4\xa1\x57\x2d\xdc\x9b\x6e\x73\xd5\x68\xd7\x5a\x68\x25\x77\x1b\x01\x93\x62\x6e\xe3\xa6\x1f\xac\x5c\x02\x18\x17\x7d\x3a\x13\xe0\xe6\xcc\xe2\xce\x75\x8b\x5d\x18\x96\x12\x08\x84\x73\xb0\x84\x89\xb9\x86\x21\x48\xe5\x48\x52\x47\xd0\x73\x2d\xc0\x11\xca\xd6\x33\xb0\x4e\x64\x52\x94\x77\x94\x66\x5c\x49\xce\x99\x98\x94\x99\xee\xcf\x75\xfd\x64\xa1\xce\x85\xb4\x18\xf9\xb9\x34\xf6\xff\xf2\xe0\xbf\x95\x38\x5e\xd4\xa0\x65\x26\x9c\x9e\x09\x82\x42\x4d\x51\xf8\xc6\x95\xa9\xb9\xf0\xcb\x4c\x70\x36\xf5\xbb\x68\x6d\x60\xad\x41\xec\xb8\x31\xdf\x6d\xa2\x25\x52\x2c\xef\xc4\xab\x6a\x94\x4c\xc9\xfd\x97\xaa\xf9\x71\x8c\x60\xbf\xf3\xb7\x8d\x7f\x07\x00\x00\xff\xff\x8b\x8a\xab\xbb\x04\x19\x00\x00")

func assetsDnsDaemonsetYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsDaemonsetYaml,
		"assets/dns/daemonset.yaml",
	)
}

func assetsDnsDaemonsetYaml() (*asset, error) {
	bytes, err := assetsDnsDaemonsetYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/daemonset.yaml", size: 6404, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x26, 0xe1, 0x42, 0x1f, 0xc7, 0x72, 0x1c, 0x60, 0x58, 0x12, 0x27, 0xfe, 0x9d, 0xe, 0xe9, 0xff, 0xb5, 0xf6, 0x4b, 0x9d, 0x9d, 0x9f, 0x80, 0xf0, 0x21, 0xb8, 0x63, 0xb5, 0xfc, 0x6e, 0x77, 0xb9}}
	return a, nil
}

var _assetsDnsMetricsClusterRoleBindingYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x7c\x8f\xb1\x4a\x04\x41\x0c\x86\xfb\x79\x8a\xbc\xc0\xae\xd8\x1d\xd3\xa9\x85\xfd\x09\xf6\xb9\x99\x9c\x1b\x77\x27\x19\x92\xcc\x16\x3e\xbd\x2c\x8a\x08\xe2\xb5\x81\x7c\xdf\xff\xad\x2c\x35\xc3\xd3\x36\x3c\xc8\xce\xba\xd1\x23\x4b\x65\x79\x4b\xd8\xf9\x95\xcc\x59\x25\x83\x5d\xb0\xcc\x38\x62\x51\xe3\x0f\x0c\x56\x99\xd7\x93\xcf\xac\x77\xfb\x7d\x6a\x14\x58\x31\x30\x27\x00\xc1\x46\x19\xaa\xf8\xd4\x54\x38\xd4\x0e\x92\x8f\xcb\x3b\x95\xf0\x9c\x26\xf8\xd2\xbd\x90\xed\x5c\xe8\xa1\x14\x1d\x12\x3f\x7f\xdd\xb4\x51\x2c\x34\x7c\x5a\x4f\xfe\x7d\xf6\x8e\x85\x32\x68\x27\xf1\x85\xaf\xf1\x9b\x6c\xba\xd1\x99\xae\x87\xf9\x4f\xc7\x7f\x6b\x00\xb0\xf3\xb3\xe9\xe8\x37\xba\xd2\x67\x00\x00\x00\xff\xff\x5b\x52\x00\xaa\x17\x01\x00\x00")

func assetsDnsMetricsClusterRoleBindingYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsMetricsClusterRoleBindingYaml,
		"assets/dns/metrics/cluster-role-binding.yaml",
	)
}

func assetsDnsMetricsClusterRoleBindingYaml() (*asset, error) {
	bytes, err := assetsDnsMetricsClusterRoleBindingYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/metrics/cluster-role-binding.yaml", size: 279, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x79, 0x95, 0x6f, 0xa4, 0xd5, 0xed, 0x48, 0x27, 0x41, 0x56, 0x5c, 0xea, 0x5c, 0x89, 0xdc, 0xc1, 0x44, 0x91, 0xd4, 0xb, 0x18, 0x85, 0x79, 0x75, 0xaa, 0x6e, 0xb5, 0x98, 0xbe, 0xc6, 0x33, 0x43}}
	return a, nil
}

var _assetsDnsMetricsClusterRoleYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x34\xcd\x31\x4b\x34\x41\x0c\x87\xf1\x7e\x3e\x45\xe0\xad\x77\x5f\xec\x64\x5a\x05\x3b\x0b\x05\xfb\xec\xce\xdf\xdb\x70\x3b\xc9\x90\x64\x0e\xf4\xd3\x8b\x70\xb6\x0f\x3f\x78\xfe\xd1\xd3\x39\x23\xe1\xe4\x76\x22\x48\x81\x86\x46\xdb\x17\x0d\xb7\x8e\x3c\x30\x83\xd2\x28\x76\xe7\x01\x7a\x7e\x7d\xa7\x8e\x74\xd9\x83\xa0\x6d\x98\x68\x16\x1e\xf2\x01\x0f\x31\xad\xe4\x1b\xef\x2b\xcf\x3c\xcc\xe5\x9b\x53\x4c\xd7\xeb\x63\xac\x62\xff\x6f\x0f\xe5\x2a\xda\xea\xdf\xf0\xcd\x4e\x94\x8e\xe4\xc6\xc9\xb5\x10\x29\x77\x54\x6a\x1a\x4b\x37\x95\x34\x17\xbd\x14\x9f\x27\xa2\x96\x85\x78\xc8\x8b\xdb\x1c\xf1\x4b\x17\xb2\x01\xe7\x34\x5f\x6d\x40\xe3\x90\xcf\x5c\xc5\x0a\x91\x23\x6c\xfa\x8e\x3b\x6b\x1a\x88\x42\x74\x83\x6f\xf7\x74\x41\x96\x9f\x00\x00\x00\xff\xff\x9f\xa8\x4d\x6c\xf6\x00\x00\x00")

func assetsDnsMetricsClusterRoleYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsMetricsClusterRoleYaml,
		"assets/dns/metrics/cluster-role.yaml",
	)
}

func assetsDnsMetricsClusterRoleYaml() (*asset, error) {
	bytes, err := assetsDnsMetricsClusterRoleYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/metrics/cluster-role.yaml", size: 246, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x64, 0xdb, 0xe0, 0x95, 0x65, 0xae, 0x53, 0x96, 0x3a, 0x5f, 0x5e, 0x8b, 0x69, 0xe2, 0x7d, 0x5, 0xbf, 0x1f, 0x3a, 0xf, 0xff, 0xd0, 0x6b, 0x23, 0x4f, 0xfd, 0x11, 0x7f, 0x57, 0xd4, 0x4a, 0x8b}}
	return a, nil
}

var _assetsDnsMetricsRoleBindingYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x94\xce\xb1\x4e\xc4\x40\x0c\x04\xd0\x7e\xbf\xc2\x3f\x90\x20\xba\xd3\x76\xd0\xd0\x1f\x12\xbd\x6f\xd7\x97\x98\x64\xed\x95\xed\x4d\xc1\xd7\x23\xa4\x48\x54\x20\x5d\x3b\x9a\xd1\x1b\xec\xfc\x41\xe6\xac\x92\xc1\x6e\x58\x66\x1c\xb1\xaa\xf1\x17\x06\xab\xcc\xdb\xc5\x67\xd6\xa7\xe3\x39\x6d\x2c\x35\xc3\x55\x77\x7a\x65\xa9\x2c\x4b\x6a\x14\x58\x31\x30\x27\x00\xc1\x46\x19\xba\x69\xa3\x58\x69\xf8\xb4\x5d\xfc\x8c\xbd\x63\xa1\x0c\xda\x49\x7c\xe5\x7b\x4c\x55\x3c\x99\xee\x74\xa5\xfb\xcf\x14\x3b\xbf\x99\x8e\xfe\x8f\x9f\x00\x7e\xf9\xbf\x34\x1f\xb7\x4f\x2a\xe1\x39\x4d\x67\xfb\x9d\xec\xe0\x42\x2f\xa5\xe8\x90\x78\xf0\x65\x53\xe1\x50\x63\x59\x20\x7d\x07\x00\x00\xff\xff\xb9\xd9\xab\x8d\x25\x01\x00\x00")

func assetsDnsMetricsRoleBindingYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsMetricsRoleBindingYaml,
		"assets/dns/metrics/role-binding.yaml",
	)
}

func assetsDnsMetricsRoleBindingYaml() (*asset, error) {
	bytes, err := assetsDnsMetricsRoleBindingYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/metrics/role-binding.yaml", size: 293, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0xc, 0x7d, 0xc7, 0x45, 0x33, 0xc4, 0xd8, 0xf, 0x8d, 0x89, 0x8d, 0x6, 0x47, 0xa7, 0xa, 0x6b, 0x17, 0xf5, 0x5f, 0x5a, 0x2f, 0xd8, 0xf9, 0x6, 0x71, 0xaa, 0x78, 0x8d, 0xb5, 0x7a, 0xf6, 0x99}}
	return a, nil
}

var _assetsDnsMetricsRoleYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x4c\x8e\xb1\x4e\xec\x40\x0c\x45\xfb\xf9\x0a\x6b\x5f\x9d\x7d\xa2\x5b\x4d\x8d\x44\x47\x01\x12\xbd\x77\xe6\x42\xac\x24\xe3\x91\xed\x04\xc1\xd7\xa3\xcd\x06\x89\xca\xf7\x1e\x59\x3e\xfe\x47\x2f\x3a\xc3\xa9\x01\x15\x95\xae\x5f\xd4\x4d\x17\xc4\x88\xd5\x29\x94\xbc\x18\x77\xd0\xe3\xf3\x2b\x2d\x08\x93\xe2\x84\x56\xbb\x4a\x8b\xc4\x5d\xde\x60\x2e\xda\x32\xd9\x95\xcb\x99\xd7\x18\xd5\xe4\x9b\x43\xb4\x9d\xa7\x8b\x9f\x45\xff\x6f\x0f\x69\x92\x56\xf3\x2e\x4a\x0b\x82\x2b\x07\xe7\x44\xd4\x78\x41\xfe\xe3\x1b\xa6\x8b\x1f\xd8\x3b\x17\x64\xd2\x8e\xe6\xa3\xbc\xc7\x50\x9b\x27\x5b\x67\x78\x4e\x03\x71\x97\x27\xd3\xb5\xfb\xed\xca\x40\xa7\x53\x22\x32\xb8\xae\x56\x70\x30\x87\x6d\x52\xe0\x7b\xf9\xfd\xf8\xde\xba\xd6\x5b\xd8\x60\xd7\x63\xf9\x03\xb1\xcf\x59\xfc\x1e\x3e\x39\xca\x98\x7e\x02\x00\x00\xff\xff\x29\x39\xda\x05\x1c\x01\x00\x00")

func assetsDnsMetricsRoleYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsMetricsRoleYaml,
		"assets/dns/metrics/role.yaml",
	)
}

func assetsDnsMetricsRoleYaml() (*asset, error) {
	bytes, err := assetsDnsMetricsRoleYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/metrics/role.yaml", size: 284, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x8c, 0xf2, 0x4e, 0x40, 0x91, 0xd8, 0x5e, 0x1c, 0x98, 0xb6, 0x2f, 0x11, 0x2a, 0x15, 0x8f, 0xe4, 0x7c, 0xfe, 0xc6, 0x31, 0xf3, 0xb2, 0xa0, 0x38, 0xb2, 0x3f, 0x15, 0x5a, 0x33, 0x12, 0xd2, 0x88}}
	return a, nil
}

var _assetsDnsNamespaceYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x64\x90\xcd\x4e\xc4\x30\x0c\x84\xef\x79\x8a\x51\x38\x2f\x3f\xd7\xbc\x03\x5c\x90\xb8\xbb\x8d\x97\x35\x4d\xed\x2a\x76\xcb\xeb\xa3\xb2\x15\xac\xb4\xc7\x68\x46\xf3\x7d\xf1\x24\x5a\x0b\xde\x68\x66\x5f\x68\xe4\x44\x8b\x7c\x70\x77\x31\x2d\xd8\x5e\xd2\xcc\x41\x95\x82\x4a\x02\x48\xd5\x82\x42\x4c\x7d\x7f\x02\xb6\xb0\xfa\x45\xce\xf1\x28\xf6\xa4\x56\xf9\xe4\xdc\x78\x0c\xeb\x05\x39\x27\x40\x69\xe6\xf2\x5f\x3b\x55\xf5\x04\x34\x1a\xb8\x1d\x13\x0f\x70\x0e\x6c\xd4\x56\x46\x18\x68\x33\xa9\xa8\xbc\xb0\x56\xd1\x4f\x98\x62\x5a\x07\x06\xd5\x59\x7c\x97\x42\x5c\x28\x8e\x82\xef\xf1\xdf\x38\x68\x11\xbf\xd7\xea\xab\x9e\x1a\x6f\xdc\x0a\xf2\x73\x3e\x98\xd4\x9a\x7d\xdf\x78\xcd\xa6\x12\xd6\x77\x62\x18\x9a\xd9\x84\xb3\x75\xbc\x73\xdf\x64\xe4\xd7\x6b\x0a\x1b\xbe\x78\x0c\x87\xec\x16\xe2\xbf\xbf\xbb\x1e\xed\x8e\x3a\xb6\xd5\x83\xfb\xcd\x70\x41\x8e\xbe\x72\x4e\x3f\x01\x00\x00\xff\xff\x82\x6d\x29\x03\x71\x01\x00\x00")

func assetsDnsNamespaceYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsNamespaceYaml,
		"assets/dns/namespace.yaml",
	)
}

func assetsDnsNamespaceYaml() (*asset, error) {
	bytes, err := assetsDnsNamespaceYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/namespace.yaml", size: 369, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0xe, 0xab, 0x50, 0x84, 0x61, 0x5f, 0x41, 0xf4, 0x17, 0x3b, 0x6, 0x84, 0xc0, 0x5f, 0x4f, 0xbb, 0xd8, 0x1d, 0xae, 0x26, 0x3e, 0x1f, 0x29, 0x2c, 0x84, 0x6d, 0x5e, 0xc1, 0x87, 0x97, 0x5f, 0xc9}}
	return a, nil
}

var _assetsDnsServiceAccountYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x2c\xc9\xb1\x09\xc4\x30\x0c\x05\xd0\xde\x53\x68\x81\x2b\xae\x55\x77\x33\x1c\xa4\x17\xf2\x0f\x11\xc1\xb2\xb1\x14\xcf\x1f\x02\xe9\x1e\xbc\xd3\xbc\x32\xfd\x31\x97\x29\x7e\xaa\xfd\xf2\x2c\x32\x6c\xc3\x0c\xeb\xce\xb4\xbe\xa5\x21\xa5\x4a\x0a\x17\x22\x97\x06\xa6\xea\xf1\x3a\x86\x28\x98\xfa\x80\xc7\x61\x7b\x7e\x9e\xba\x03\x00\x00\xff\xff\x8e\x2c\xf1\x2e\x55\x00\x00\x00")

func assetsDnsServiceAccountYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsServiceAccountYaml,
		"assets/dns/service-account.yaml",
	)
}

func assetsDnsServiceAccountYaml() (*asset, error) {
	bytes, err := assetsDnsServiceAccountYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/service-account.yaml", size: 85, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x57, 0x12, 0x50, 0x4d, 0x67, 0x2f, 0x1b, 0x74, 0xa0, 0xa4, 0xbb, 0xa7, 0x59, 0xe9, 0x5a, 0xc6, 0xc1, 0x1a, 0xf8, 0x5f, 0xff, 0x5, 0xdb, 0xc, 0x10, 0x8b, 0xc1, 0x0, 0xcc, 0xf, 0x9f, 0x3a}}
	return a, nil
}

var _assetsDnsServiceYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x84\x91\x31\x6f\xe2\x40\x10\x85\x7b\xff\x8a\x27\xe8\x4e\xc0\x09\xdd\x51\x9c\xdb\xa3\x89\x52\x80\x14\x48\x3f\x5e\x4f\xcc\x8a\xf5\x8c\xb5\x33\x06\xf1\xef\x23\x4c\x42\x80\x14\x69\x56\xda\x7d\x9f\x3e\x3d\xbd\xdd\x47\xa9\x4b\xbc\x70\x3e\xc4\xc0\x05\x75\xf1\x95\xb3\x45\x95\x12\x87\x79\x31\x86\x50\xcb\x93\xe1\xb4\x8e\x02\x4f\x12\x55\x9c\x0c\x24\x35\x48\x44\x9d\x3c\xaa\x18\x28\x33\x8c\x1d\xe4\xc8\xbd\x78\x6c\xb9\xb0\x8e\x43\x59\x00\x63\x84\xd4\x9b\x73\x7e\x5a\xe3\x18\x53\x42\xc5\xa0\xde\xb5\x25\x8f\x81\x52\x3a\xa1\x25\xa1\x86\xeb\xd9\x00\x1b\x27\x0e\xae\x19\xd1\x1e\x8d\x40\xa7\xd9\xed\x2c\x9d\x0e\x95\x4a\xd4\x62\x05\x70\x09\x4a\x2c\xfe\x0c\x17\xa7\xdc\xb0\xaf\x87\xa7\x2b\x90\xd5\x35\x68\x2a\xb1\x5d\xae\xef\x05\x53\x0f\xdd\x8f\x92\x2f\xe8\x2a\xda\xfc\xbf\x15\xb5\xec\x39\x86\xdb\x36\xff\xe6\x8b\xbf\xdf\x54\x77\xd8\x83\x6a\x8c\xcd\x6a\xb9\x2a\xb1\x95\xa0\x6d\xcb\xe2\x38\xee\x58\x60\x97\xbf\x81\x6b\xa7\x49\x9b\x13\xde\x98\xbc\xcf\x8c\x86\x9c\xcf\x33\xb1\x50\x95\x3e\xf6\xfb\x84\x9e\xf9\x64\x97\xf5\x31\xc5\x68\xdf\x57\x9c\x85\x9d\x6d\x16\xf5\xf7\x4e\xcd\xcf\xa5\x47\xd7\xfc\xd7\xa8\x78\x0f\x00\x00\xff\xff\x82\x42\x75\xa4\x08\x02\x00\x00")

func assetsDnsServiceYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsServiceYaml,
		"assets/dns/service.yaml",
	)
}

func assetsDnsServiceYaml() (*asset, error) {
	bytes, err := assetsDnsServiceYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/service.yaml", size: 520, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x18, 0x69, 0xc5, 0xf1, 0xe, 0xc, 0x77, 0xe5, 0x78, 0xce, 0xfc, 0xc2, 0x41, 0xf8, 0x21, 0x87, 0x8a, 0xb7, 0x67, 0xdd, 0x48, 0x94, 0x63, 0x79, 0x69, 0x4e, 0x38, 0x53, 0x3c, 0xdb, 0xc7, 0x13}}
	return a, nil
}

// Asset loads and returns the asset for the given name.
// It returns an error if the asset could not be found or
// could not be loaded.
func Asset(name string) ([]byte, error) {
	canonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[canonicalName]; ok {
		a, err := f()
		if err != nil {
			return nil, fmt.Errorf("Asset %s can't read by error: %v", name, err)
		}
		return a.bytes, nil
	}
	return nil, fmt.Errorf("Asset %s not found", name)
}

// AssetString returns the asset contents as a string (instead of a []byte).
func AssetString(name string) (string, error) {
	data, err := Asset(name)
	return string(data), err
}

// MustAsset is like Asset but panics when Asset would return an error.
// It simplifies safe initialization of global variables.
func MustAsset(name string) []byte {
	a, err := Asset(name)
	if err != nil {
		panic("asset: Asset(" + name + "): " + err.Error())
	}

	return a
}

// MustAssetString is like AssetString but panics when Asset would return an
// error. It simplifies safe initialization of global variables.
func MustAssetString(name string) string {
	return string(MustAsset(name))
}

// AssetInfo loads and returns the asset info for the given name.
// It returns an error if the asset could not be found or
// could not be loaded.
func AssetInfo(name string) (os.FileInfo, error) {
	canonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[canonicalName]; ok {
		a, err := f()
		if err != nil {
			return nil, fmt.Errorf("AssetInfo %s can't read by error: %v", name, err)
		}
		return a.info, nil
	}
	return nil, fmt.Errorf("AssetInfo %s not found", name)
}

// AssetDigest returns the digest of the file with the given name. It returns an
// error if the asset could not be found or the digest could not be loaded.
func AssetDigest(name string) ([sha256.Size]byte, error) {
	canonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[canonicalName]; ok {
		a, err := f()
		if err != nil {
			return [sha256.Size]byte{}, fmt.Errorf("AssetDigest %s can't read by error: %v", name, err)
		}
		return a.digest, nil
	}
	return [sha256.Size]byte{}, fmt.Errorf("AssetDigest %s not found", name)
}

// Digests returns a map of all known files and their checksums.
func Digests() (map[string][sha256.Size]byte, error) {
	mp := make(map[string][sha256.Size]byte, len(_bindata))
	for name := range _bindata {
		a, err := _bindata[name]()
		if err != nil {
			return nil, err
		}
		mp[name] = a.digest
	}
	return mp, nil
}

// AssetNames returns the names of the assets.
func AssetNames() []string {
	names := make([]string, 0, len(_bindata))
	for name := range _bindata {
		names = append(names, name)
	}
	return names
}

// _bindata is a table, holding each asset generator, mapped to its name.
var _bindata = map[string]func() (*asset, error){
	"assets/dns/cluster-role-binding.yaml": assetsDnsClusterRoleBindingYaml,

	"assets/dns/cluster-role.yaml": assetsDnsClusterRoleYaml,

	"assets/dns/daemonset.yaml": assetsDnsDaemonsetYaml,

	"assets/dns/metrics/cluster-role-binding.yaml": assetsDnsMetricsClusterRoleBindingYaml,

	"assets/dns/metrics/cluster-role.yaml": assetsDnsMetricsClusterRoleYaml,

	"assets/dns/metrics/role-binding.yaml": assetsDnsMetricsRoleBindingYaml,

	"assets/dns/metrics/role.yaml": assetsDnsMetricsRoleYaml,

	"assets/dns/namespace.yaml": assetsDnsNamespaceYaml,

	"assets/dns/service-account.yaml": assetsDnsServiceAccountYaml,

	"assets/dns/service.yaml": assetsDnsServiceYaml,
}

// AssetDir returns the file names below a certain
// directory embedded in the file by go-bindata.
// For example if you run go-bindata on data/... and data contains the
// following hierarchy:
//     data/
//       foo.txt
//       img/
//         a.png
//         b.png
// then AssetDir("data") would return []string{"foo.txt", "img"},
// AssetDir("data/img") would return []string{"a.png", "b.png"},
// AssetDir("foo.txt") and AssetDir("notexist") would return an error, and
// AssetDir("") will return []string{"data"}.
func AssetDir(name string) ([]string, error) {
	node := _bintree
	if len(name) != 0 {
		canonicalName := strings.Replace(name, "\\", "/", -1)
		pathList := strings.Split(canonicalName, "/")
		for _, p := range pathList {
			node = node.Children[p]
			if node == nil {
				return nil, fmt.Errorf("Asset %s not found", name)
			}
		}
	}
	if node.Func != nil {
		return nil, fmt.Errorf("Asset %s not found", name)
	}
	rv := make([]string, 0, len(node.Children))
	for childName := range node.Children {
		rv = append(rv, childName)
	}
	return rv, nil
}

type bintree struct {
	Func     func() (*asset, error)
	Children map[string]*bintree
}

var _bintree = &bintree{nil, map[string]*bintree{
	"assets": {nil, map[string]*bintree{
		"dns": {nil, map[string]*bintree{
			"cluster-role-binding.yaml": {assetsDnsClusterRoleBindingYaml, map[string]*bintree{}},
			"cluster-role.yaml":         {assetsDnsClusterRoleYaml, map[string]*bintree{}},
			"daemonset.yaml":            {assetsDnsDaemonsetYaml, map[string]*bintree{}},
			"metrics": {nil, map[string]*bintree{
				"cluster-role-binding.yaml": {assetsDnsMetricsClusterRoleBindingYaml, map[string]*bintree{}},
				"cluster-role.yaml":         {assetsDnsMetricsClusterRoleYaml, map[string]*bintree{}},
				"role-binding.yaml":         {assetsDnsMetricsRoleBindingYaml, map[string]*bintree{}},
				"role.yaml":                 {assetsDnsMetricsRoleYaml, map[string]*bintree{}},
			}},
			"namespace.yaml":       {assetsDnsNamespaceYaml, map[string]*bintree{}},
			"service-account.yaml": {assetsDnsServiceAccountYaml, map[string]*bintree{}},
			"service.yaml":         {assetsDnsServiceYaml, map[string]*bintree{}},
		}},
	}},
}}

// RestoreAsset restores an asset under the given directory.
func RestoreAsset(dir, name string) error {
	data, err := Asset(name)
	if err != nil {
		return err
	}
	info, err := AssetInfo(name)
	if err != nil {
		return err
	}
	err = os.MkdirAll(_filePath(dir, filepath.Dir(name)), os.FileMode(0755))
	if err != nil {
		return err
	}
	err = ioutil.WriteFile(_filePath(dir, name), data, info.Mode())
	if err != nil {
		return err
	}
	return os.Chtimes(_filePath(dir, name), info.ModTime(), info.ModTime())
}

// RestoreAssets restores an asset under the given directory recursively.
func RestoreAssets(dir, name string) error {
	children, err := AssetDir(name)
	// File
	if err != nil {
		return RestoreAsset(dir, name)
	}
	// Dir
	for _, child := range children {
		err = RestoreAssets(dir, filepath.Join(name, child))
		if err != nil {
			return err
		}
	}
	return nil
}

func _filePath(dir, name string) string {
	canonicalName := strings.Replace(name, "\\", "/", -1)
	return filepath.Join(append([]string{dir}, strings.Split(canonicalName, "/")...)...)
}
