package alimt

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetImageTranslateTask invokes the alimt.GetImageTranslateTask API synchronously
func (client *Client) GetImageTranslateTask(request *GetImageTranslateTaskRequest) (response *GetImageTranslateTaskResponse, err error) {
	response = CreateGetImageTranslateTaskResponse()
	err = client.DoAction(request, response)
	return
}

// GetImageTranslateTaskWithChan invokes the alimt.GetImageTranslateTask API asynchronously
func (client *Client) GetImageTranslateTaskWithChan(request *GetImageTranslateTaskRequest) (<-chan *GetImageTranslateTaskResponse, <-chan error) {
	responseChan := make(chan *GetImageTranslateTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetImageTranslateTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetImageTranslateTaskWithCallback invokes the alimt.GetImageTranslateTask API asynchronously
func (client *Client) GetImageTranslateTaskWithCallback(request *GetImageTranslateTaskRequest, callback func(response *GetImageTranslateTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetImageTranslateTaskResponse
		var err error
		defer close(result)
		response, err = client.GetImageTranslateTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetImageTranslateTaskRequest is the request struct for api GetImageTranslateTask
type GetImageTranslateTaskRequest struct {
	*requests.RpcRequest
	TaskId string `position:"Body" name:"TaskId"`
}

// GetImageTranslateTaskResponse is the response struct for api GetImageTranslateTask
type GetImageTranslateTaskResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetImageTranslateTaskRequest creates a request to invoke GetImageTranslateTask API
func CreateGetImageTranslateTaskRequest() (request *GetImageTranslateTaskRequest) {
	request = &GetImageTranslateTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("alimt", "2018-10-12", "GetImageTranslateTask", "alimt", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetImageTranslateTaskResponse creates a response to parse from GetImageTranslateTask response
func CreateGetImageTranslateTaskResponse() (response *GetImageTranslateTaskResponse) {
	response = &GetImageTranslateTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
