package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SearchTracesByPage invokes the arms.SearchTracesByPage API synchronously
func (client *Client) SearchTracesByPage(request *SearchTracesByPageRequest) (response *SearchTracesByPageResponse, err error) {
	response = CreateSearchTracesByPageResponse()
	err = client.DoAction(request, response)
	return
}

// SearchTracesByPageWithChan invokes the arms.SearchTracesByPage API asynchronously
func (client *Client) SearchTracesByPageWithChan(request *SearchTracesByPageRequest) (<-chan *SearchTracesByPageResponse, <-chan error) {
	responseChan := make(chan *SearchTracesByPageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SearchTracesByPage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SearchTracesByPageWithCallback invokes the arms.SearchTracesByPage API asynchronously
func (client *Client) SearchTracesByPageWithCallback(request *SearchTracesByPageRequest, callback func(response *SearchTracesByPageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SearchTracesByPageResponse
		var err error
		defer close(result)
		response, err = client.SearchTracesByPage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SearchTracesByPageRequest is the request struct for api SearchTracesByPage
type SearchTracesByPageRequest struct {
	*requests.RpcRequest
	EndTime          requests.Integer                      `position:"Query" name:"EndTime"`
	StartTime        requests.Integer                      `position:"Query" name:"StartTime"`
	Reverse          requests.Boolean                      `position:"Query" name:"Reverse"`
	MinDuration      requests.Integer                      `position:"Query" name:"MinDuration"`
	PageNumber       requests.Integer                      `position:"Query" name:"PageNumber"`
	ServiceIp        string                                `position:"Query" name:"ServiceIp"`
	ExclusionFilters *[]SearchTracesByPageExclusionFilters `position:"Query" name:"ExclusionFilters"  type:"Repeated"`
	OperationName    string                                `position:"Query" name:"OperationName"`
	PageSize         requests.Integer                      `position:"Query" name:"PageSize"`
	ServiceName      string                                `position:"Query" name:"ServiceName"`
}

// SearchTracesByPageExclusionFilters is a repeated param struct in SearchTracesByPageRequest
type SearchTracesByPageExclusionFilters struct {
	Value string `name:"Value"`
	Key   string `name:"Key"`
}

// SearchTracesByPageResponse is the response struct for api SearchTracesByPage
type SearchTracesByPageResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	PageBean  PageBean `json:"PageBean" xml:"PageBean"`
}

// CreateSearchTracesByPageRequest creates a request to invoke SearchTracesByPage API
func CreateSearchTracesByPageRequest() (request *SearchTracesByPageRequest) {
	request = &SearchTracesByPageRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "SearchTracesByPage", "arms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSearchTracesByPageResponse creates a response to parse from SearchTracesByPage response
func CreateSearchTracesByPageResponse() (response *SearchTracesByPageResponse) {
	response = &SearchTracesByPageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
