package cloudauth

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateWhitelistSetting invokes the cloudauth.CreateWhitelistSetting API synchronously
func (client *Client) CreateWhitelistSetting(request *CreateWhitelistSettingRequest) (response *CreateWhitelistSettingResponse, err error) {
	response = CreateCreateWhitelistSettingResponse()
	err = client.DoAction(request, response)
	return
}

// CreateWhitelistSettingWithChan invokes the cloudauth.CreateWhitelistSetting API asynchronously
func (client *Client) CreateWhitelistSettingWithChan(request *CreateWhitelistSettingRequest) (<-chan *CreateWhitelistSettingResponse, <-chan error) {
	responseChan := make(chan *CreateWhitelistSettingResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateWhitelistSetting(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateWhitelistSettingWithCallback invokes the cloudauth.CreateWhitelistSetting API asynchronously
func (client *Client) CreateWhitelistSettingWithCallback(request *CreateWhitelistSettingRequest, callback func(response *CreateWhitelistSettingResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateWhitelistSettingResponse
		var err error
		defer close(result)
		response, err = client.CreateWhitelistSetting(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateWhitelistSettingRequest is the request struct for api CreateWhitelistSetting
type CreateWhitelistSettingRequest struct {
	*requests.RpcRequest
	CertifyId   string           `position:"Query" name:"CertifyId"`
	CertNo      string           `position:"Query" name:"CertNo"`
	SourceIp    string           `position:"Query" name:"SourceIp"`
	Lang        string           `position:"Query" name:"Lang"`
	ValidDay    requests.Integer `position:"Query" name:"ValidDay"`
	ServiceCode string           `position:"Query" name:"ServiceCode"`
	SceneId     requests.Integer `position:"Query" name:"SceneId"`
}

// CreateWhitelistSettingResponse is the response struct for api CreateWhitelistSetting
type CreateWhitelistSettingResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ResultObject bool   `json:"ResultObject" xml:"ResultObject"`
}

// CreateCreateWhitelistSettingRequest creates a request to invoke CreateWhitelistSetting API
func CreateCreateWhitelistSettingRequest() (request *CreateWhitelistSettingRequest) {
	request = &CreateWhitelistSettingRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudauth", "2019-03-07", "CreateWhitelistSetting", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateWhitelistSettingResponse creates a response to parse from CreateWhitelistSetting response
func CreateCreateWhitelistSettingResponse() (response *CreateWhitelistSettingResponse) {
	response = &CreateWhitelistSettingResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
