package codeup

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetRepositoryTagV2 invokes the codeup.GetRepositoryTagV2 API synchronously
func (client *Client) GetRepositoryTagV2(request *GetRepositoryTagV2Request) (response *GetRepositoryTagV2Response, err error) {
	response = CreateGetRepositoryTagV2Response()
	err = client.DoAction(request, response)
	return
}

// GetRepositoryTagV2WithChan invokes the codeup.GetRepositoryTagV2 API asynchronously
func (client *Client) GetRepositoryTagV2WithChan(request *GetRepositoryTagV2Request) (<-chan *GetRepositoryTagV2Response, <-chan error) {
	responseChan := make(chan *GetRepositoryTagV2Response, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetRepositoryTagV2(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetRepositoryTagV2WithCallback invokes the codeup.GetRepositoryTagV2 API asynchronously
func (client *Client) GetRepositoryTagV2WithCallback(request *GetRepositoryTagV2Request, callback func(response *GetRepositoryTagV2Response, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetRepositoryTagV2Response
		var err error
		defer close(result)
		response, err = client.GetRepositoryTagV2(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetRepositoryTagV2Request is the request struct for api GetRepositoryTagV2
type GetRepositoryTagV2Request struct {
	*requests.RoaRequest
	OrganizationId string           `position:"Query" name:"OrganizationId"`
	TagName        string           `position:"Query" name:"TagName"`
	AccessToken    string           `position:"Query" name:"AccessToken"`
	ProjectId      requests.Integer `position:"Path" name:"ProjectId"`
}

// GetRepositoryTagV2Response is the response struct for api GetRepositoryTagV2
type GetRepositoryTagV2Response struct {
	*responses.BaseResponse
	ErrorCode    string                     `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string                     `json:"ErrorMessage" xml:"ErrorMessage"`
	RequestId    string                     `json:"RequestId" xml:"RequestId"`
	Success      bool                       `json:"Success" xml:"Success"`
	Result       ResultInGetRepositoryTagV2 `json:"Result" xml:"Result"`
}

// CreateGetRepositoryTagV2Request creates a request to invoke GetRepositoryTagV2 API
func CreateGetRepositoryTagV2Request() (request *GetRepositoryTagV2Request) {
	request = &GetRepositoryTagV2Request{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("codeup", "2020-04-14", "GetRepositoryTagV2", "/api/v3/projects/[ProjectId]/repository/tag/info", "", "")
	request.Method = requests.GET
	return
}

// CreateGetRepositoryTagV2Response creates a response to parse from GetRepositoryTagV2 response
func CreateGetRepositoryTagV2Response() (response *GetRepositoryTagV2Response) {
	response = &GetRepositoryTagV2Response{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
