package companyreg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetBalanceSheetInfo invokes the companyreg.GetBalanceSheetInfo API synchronously
func (client *Client) GetBalanceSheetInfo(request *GetBalanceSheetInfoRequest) (response *GetBalanceSheetInfoResponse, err error) {
	response = CreateGetBalanceSheetInfoResponse()
	err = client.DoAction(request, response)
	return
}

// GetBalanceSheetInfoWithChan invokes the companyreg.GetBalanceSheetInfo API asynchronously
func (client *Client) GetBalanceSheetInfoWithChan(request *GetBalanceSheetInfoRequest) (<-chan *GetBalanceSheetInfoResponse, <-chan error) {
	responseChan := make(chan *GetBalanceSheetInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetBalanceSheetInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetBalanceSheetInfoWithCallback invokes the companyreg.GetBalanceSheetInfo API asynchronously
func (client *Client) GetBalanceSheetInfoWithCallback(request *GetBalanceSheetInfoRequest, callback func(response *GetBalanceSheetInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetBalanceSheetInfoResponse
		var err error
		defer close(result)
		response, err = client.GetBalanceSheetInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetBalanceSheetInfoRequest is the request struct for api GetBalanceSheetInfo
type GetBalanceSheetInfoRequest struct {
	*requests.RpcRequest
	Period             string           `position:"Query" name:"Period"`
	IsReclassification requests.Boolean `position:"Query" name:"IsReclassification"`
	BizId              string           `position:"Query" name:"BizId"`
}

// GetBalanceSheetInfoResponse is the response struct for api GetBalanceSheetInfo
type GetBalanceSheetInfoResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Url       string `json:"Url" xml:"Url"`
}

// CreateGetBalanceSheetInfoRequest creates a request to invoke GetBalanceSheetInfo API
func CreateGetBalanceSheetInfoRequest() (request *GetBalanceSheetInfoRequest) {
	request = &GetBalanceSheetInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("companyreg", "2020-10-22", "GetBalanceSheetInfo", "companyreg", "openAPI")
	request.Method = requests.GET
	return
}

// CreateGetBalanceSheetInfoResponse creates a response to parse from GetBalanceSheetInfo response
func CreateGetBalanceSheetInfoResponse() (response *GetBalanceSheetInfoResponse) {
	response = &GetBalanceSheetInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
