package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// JoinVSwitchesToEpnInstance invokes the ens.JoinVSwitchesToEpnInstance API synchronously
func (client *Client) JoinVSwitchesToEpnInstance(request *JoinVSwitchesToEpnInstanceRequest) (response *JoinVSwitchesToEpnInstanceResponse, err error) {
	response = CreateJoinVSwitchesToEpnInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// JoinVSwitchesToEpnInstanceWithChan invokes the ens.JoinVSwitchesToEpnInstance API asynchronously
func (client *Client) JoinVSwitchesToEpnInstanceWithChan(request *JoinVSwitchesToEpnInstanceRequest) (<-chan *JoinVSwitchesToEpnInstanceResponse, <-chan error) {
	responseChan := make(chan *JoinVSwitchesToEpnInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.JoinVSwitchesToEpnInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// JoinVSwitchesToEpnInstanceWithCallback invokes the ens.JoinVSwitchesToEpnInstance API asynchronously
func (client *Client) JoinVSwitchesToEpnInstanceWithCallback(request *JoinVSwitchesToEpnInstanceRequest, callback func(response *JoinVSwitchesToEpnInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *JoinVSwitchesToEpnInstanceResponse
		var err error
		defer close(result)
		response, err = client.JoinVSwitchesToEpnInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// JoinVSwitchesToEpnInstanceRequest is the request struct for api JoinVSwitchesToEpnInstance
type JoinVSwitchesToEpnInstanceRequest struct {
	*requests.RpcRequest
	VSwitchesInfo string `position:"Query" name:"VSwitchesInfo"`
	EPNInstanceId string `position:"Query" name:"EPNInstanceId"`
}

// JoinVSwitchesToEpnInstanceResponse is the response struct for api JoinVSwitchesToEpnInstance
type JoinVSwitchesToEpnInstanceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateJoinVSwitchesToEpnInstanceRequest creates a request to invoke JoinVSwitchesToEpnInstance API
func CreateJoinVSwitchesToEpnInstanceRequest() (request *JoinVSwitchesToEpnInstanceRequest) {
	request = &JoinVSwitchesToEpnInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "JoinVSwitchesToEpnInstance", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateJoinVSwitchesToEpnInstanceResponse creates a response to parse from JoinVSwitchesToEpnInstance response
func CreateJoinVSwitchesToEpnInstanceResponse() (response *JoinVSwitchesToEpnInstanceResponse) {
	response = &JoinVSwitchesToEpnInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
