package green

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeUsageBill invokes the green.DescribeUsageBill API synchronously
func (client *Client) DescribeUsageBill(request *DescribeUsageBillRequest) (response *DescribeUsageBillResponse, err error) {
	response = CreateDescribeUsageBillResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeUsageBillWithChan invokes the green.DescribeUsageBill API asynchronously
func (client *Client) DescribeUsageBillWithChan(request *DescribeUsageBillRequest) (<-chan *DescribeUsageBillResponse, <-chan error) {
	responseChan := make(chan *DescribeUsageBillResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeUsageBill(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeUsageBillWithCallback invokes the green.DescribeUsageBill API asynchronously
func (client *Client) DescribeUsageBillWithCallback(request *DescribeUsageBillRequest, callback func(response *DescribeUsageBillResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeUsageBillResponse
		var err error
		defer close(result)
		response, err = client.DescribeUsageBill(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeUsageBillRequest is the request struct for api DescribeUsageBill
type DescribeUsageBillRequest struct {
	*requests.RpcRequest
	TotalCount  requests.Integer `position:"Query" name:"TotalCount"`
	CurrentPage requests.Integer `position:"Query" name:"CurrentPage"`
	Type        string           `position:"Query" name:"Type"`
	SourceIp    string           `position:"Query" name:"SourceIp"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
	Day         string           `position:"Query" name:"Day"`
}

// DescribeUsageBillResponse is the response struct for api DescribeUsageBill
type DescribeUsageBillResponse struct {
	*responses.BaseResponse
	RequestId   string `json:"RequestId" xml:"RequestId"`
	TotalCount  int    `json:"TotalCount" xml:"TotalCount"`
	PageSize    int    `json:"PageSize" xml:"PageSize"`
	CurrentPage int    `json:"CurrentPage" xml:"CurrentPage"`
	BillList    []Bill `json:"BillList" xml:"BillList"`
}

// CreateDescribeUsageBillRequest creates a request to invoke DescribeUsageBill API
func CreateDescribeUsageBillRequest() (request *DescribeUsageBillRequest) {
	request = &DescribeUsageBillRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Green", "2017-08-23", "DescribeUsageBill", "green", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeUsageBillResponse creates a response to parse from DescribeUsageBill response
func CreateDescribeUsageBillResponse() (response *DescribeUsageBillResponse) {
	response = &DescribeUsageBillResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
