package green

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// LiveStreamCancelScan invokes the green.LiveStreamCancelScan API synchronously
func (client *Client) LiveStreamCancelScan(request *LiveStreamCancelScanRequest) (response *LiveStreamCancelScanResponse, err error) {
	response = CreateLiveStreamCancelScanResponse()
	err = client.DoAction(request, response)
	return
}

// LiveStreamCancelScanWithChan invokes the green.LiveStreamCancelScan API asynchronously
func (client *Client) LiveStreamCancelScanWithChan(request *LiveStreamCancelScanRequest) (<-chan *LiveStreamCancelScanResponse, <-chan error) {
	responseChan := make(chan *LiveStreamCancelScanResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.LiveStreamCancelScan(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// LiveStreamCancelScanWithCallback invokes the green.LiveStreamCancelScan API asynchronously
func (client *Client) LiveStreamCancelScanWithCallback(request *LiveStreamCancelScanRequest, callback func(response *LiveStreamCancelScanResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *LiveStreamCancelScanResponse
		var err error
		defer close(result)
		response, err = client.LiveStreamCancelScan(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// LiveStreamCancelScanRequest is the request struct for api LiveStreamCancelScan
type LiveStreamCancelScanRequest struct {
	*requests.RoaRequest
	ClientInfo string `position:"Query" name:"ClientInfo"`
}

// LiveStreamCancelScanResponse is the response struct for api LiveStreamCancelScan
type LiveStreamCancelScanResponse struct {
	*responses.BaseResponse
}

// CreateLiveStreamCancelScanRequest creates a request to invoke LiveStreamCancelScan API
func CreateLiveStreamCancelScanRequest() (request *LiveStreamCancelScanRequest) {
	request = &LiveStreamCancelScanRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Green", "2018-05-09", "LiveStreamCancelScan", "/green/livestream/cancelscan", "green", "openAPI")
	request.Method = requests.POST
	return
}

// CreateLiveStreamCancelScanResponse creates a response to parse from LiveStreamCancelScan response
func CreateLiveStreamCancelScanResponse() (response *LiveStreamCancelScanResponse) {
	response = &LiveStreamCancelScanResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
