package green

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// VerifyCustomOcrTemplate invokes the green.VerifyCustomOcrTemplate API synchronously
func (client *Client) VerifyCustomOcrTemplate(request *VerifyCustomOcrTemplateRequest) (response *VerifyCustomOcrTemplateResponse, err error) {
	response = CreateVerifyCustomOcrTemplateResponse()
	err = client.DoAction(request, response)
	return
}

// VerifyCustomOcrTemplateWithChan invokes the green.VerifyCustomOcrTemplate API asynchronously
func (client *Client) VerifyCustomOcrTemplateWithChan(request *VerifyCustomOcrTemplateRequest) (<-chan *VerifyCustomOcrTemplateResponse, <-chan error) {
	responseChan := make(chan *VerifyCustomOcrTemplateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.VerifyCustomOcrTemplate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// VerifyCustomOcrTemplateWithCallback invokes the green.VerifyCustomOcrTemplate API asynchronously
func (client *Client) VerifyCustomOcrTemplateWithCallback(request *VerifyCustomOcrTemplateRequest, callback func(response *VerifyCustomOcrTemplateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *VerifyCustomOcrTemplateResponse
		var err error
		defer close(result)
		response, err = client.VerifyCustomOcrTemplate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// VerifyCustomOcrTemplateRequest is the request struct for api VerifyCustomOcrTemplate
type VerifyCustomOcrTemplateRequest struct {
	*requests.RpcRequest
	TestImgUrl string           `position:"Query" name:"TestImgUrl"`
	SourceIp   string           `position:"Query" name:"SourceIp"`
	Id         requests.Integer `position:"Query" name:"Id"`
}

// VerifyCustomOcrTemplateResponse is the response struct for api VerifyCustomOcrTemplate
type VerifyCustomOcrTemplateResponse struct {
	*responses.BaseResponse
	RequestId     string `json:"RequestId" xml:"RequestId"`
	RecognizeInfo string `json:"RecognizeInfo" xml:"RecognizeInfo"`
	ImageUrl      string `json:"ImageUrl" xml:"ImageUrl"`
}

// CreateVerifyCustomOcrTemplateRequest creates a request to invoke VerifyCustomOcrTemplate API
func CreateVerifyCustomOcrTemplateRequest() (request *VerifyCustomOcrTemplateRequest) {
	request = &VerifyCustomOcrTemplateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Green", "2017-08-23", "VerifyCustomOcrTemplate", "green", "openAPI")
	request.Method = requests.POST
	return
}

// CreateVerifyCustomOcrTemplateResponse creates a response to parse from VerifyCustomOcrTemplate response
func CreateVerifyCustomOcrTemplateResponse() (response *VerifyCustomOcrTemplateResponse) {
	response = &VerifyCustomOcrTemplateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
