package r_kvstore

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyUserClusterHost invokes the r_kvstore.ModifyUserClusterHost API synchronously
func (client *Client) ModifyUserClusterHost(request *ModifyUserClusterHostRequest) (response *ModifyUserClusterHostResponse, err error) {
	response = CreateModifyUserClusterHostResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyUserClusterHostWithChan invokes the r_kvstore.ModifyUserClusterHost API asynchronously
func (client *Client) ModifyUserClusterHostWithChan(request *ModifyUserClusterHostRequest) (<-chan *ModifyUserClusterHostResponse, <-chan error) {
	responseChan := make(chan *ModifyUserClusterHostResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyUserClusterHost(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyUserClusterHostWithCallback invokes the r_kvstore.ModifyUserClusterHost API asynchronously
func (client *Client) ModifyUserClusterHostWithCallback(request *ModifyUserClusterHostRequest, callback func(response *ModifyUserClusterHostResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyUserClusterHostResponse
		var err error
		defer close(result)
		response, err = client.ModifyUserClusterHost(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyUserClusterHostRequest is the request struct for api ModifyUserClusterHost
type ModifyUserClusterHostRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	HostId               string           `position:"Query" name:"HostId"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
	AllocationStatus     requests.Integer `position:"Query" name:"AllocationStatus"`
	Engine               string           `position:"Query" name:"Engine"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	ClusterId            string           `position:"Query" name:"ClusterId"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	ZoneId               string           `position:"Query" name:"ZoneId"`
}

// ModifyUserClusterHostResponse is the response struct for api ModifyUserClusterHost
type ModifyUserClusterHostResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyUserClusterHostRequest creates a request to invoke ModifyUserClusterHost API
func CreateModifyUserClusterHostRequest() (request *ModifyUserClusterHostRequest) {
	request = &ModifyUserClusterHostRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("R-kvstore", "2015-01-01", "ModifyUserClusterHost", "redisa", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyUserClusterHostResponse creates a response to parse from ModifyUserClusterHost response
func CreateModifyUserClusterHostResponse() (response *ModifyUserClusterHostResponse) {
	response = &ModifyUserClusterHostResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
