package rtc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateServiceLinkedRoleForRtc invokes the rtc.CreateServiceLinkedRoleForRtc API synchronously
func (client *Client) CreateServiceLinkedRoleForRtc(request *CreateServiceLinkedRoleForRtcRequest) (response *CreateServiceLinkedRoleForRtcResponse, err error) {
	response = CreateCreateServiceLinkedRoleForRtcResponse()
	err = client.DoAction(request, response)
	return
}

// CreateServiceLinkedRoleForRtcWithChan invokes the rtc.CreateServiceLinkedRoleForRtc API asynchronously
func (client *Client) CreateServiceLinkedRoleForRtcWithChan(request *CreateServiceLinkedRoleForRtcRequest) (<-chan *CreateServiceLinkedRoleForRtcResponse, <-chan error) {
	responseChan := make(chan *CreateServiceLinkedRoleForRtcResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateServiceLinkedRoleForRtc(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateServiceLinkedRoleForRtcWithCallback invokes the rtc.CreateServiceLinkedRoleForRtc API asynchronously
func (client *Client) CreateServiceLinkedRoleForRtcWithCallback(request *CreateServiceLinkedRoleForRtcRequest, callback func(response *CreateServiceLinkedRoleForRtcResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateServiceLinkedRoleForRtcResponse
		var err error
		defer close(result)
		response, err = client.CreateServiceLinkedRoleForRtc(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateServiceLinkedRoleForRtcRequest is the request struct for api CreateServiceLinkedRoleForRtc
type CreateServiceLinkedRoleForRtcRequest struct {
	*requests.RpcRequest
	ShowLog string           `position:"Query" name:"ShowLog"`
	OwnerId requests.Integer `position:"Query" name:"OwnerId"`
}

// CreateServiceLinkedRoleForRtcResponse is the response struct for api CreateServiceLinkedRoleForRtc
type CreateServiceLinkedRoleForRtcResponse struct {
	*responses.BaseResponse
}

// CreateCreateServiceLinkedRoleForRtcRequest creates a request to invoke CreateServiceLinkedRoleForRtc API
func CreateCreateServiceLinkedRoleForRtcRequest() (request *CreateServiceLinkedRoleForRtcRequest) {
	request = &CreateServiceLinkedRoleForRtcRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("rtc", "2018-01-11", "CreateServiceLinkedRoleForRtc", "rtc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateServiceLinkedRoleForRtcResponse creates a response to parse from CreateServiceLinkedRoleForRtc response
func CreateCreateServiceLinkedRoleForRtcResponse() (response *CreateServiceLinkedRoleForRtcResponse) {
	response = &CreateServiceLinkedRoleForRtcResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
