package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListDNADB invokes the vod.ListDNADB API synchronously
func (client *Client) ListDNADB(request *ListDNADBRequest) (response *ListDNADBResponse, err error) {
	response = CreateListDNADBResponse()
	err = client.DoAction(request, response)
	return
}

// ListDNADBWithChan invokes the vod.ListDNADB API asynchronously
func (client *Client) ListDNADBWithChan(request *ListDNADBRequest) (<-chan *ListDNADBResponse, <-chan error) {
	responseChan := make(chan *ListDNADBResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListDNADB(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListDNADBWithCallback invokes the vod.ListDNADB API asynchronously
func (client *Client) ListDNADBWithCallback(request *ListDNADBRequest, callback func(response *ListDNADBResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListDNADBResponse
		var err error
		defer close(result)
		response, err = client.ListDNADB(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListDNADBRequest is the request struct for api ListDNADB
type ListDNADBRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      string `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string `position:"Query" name:"OwnerAccount"`
	OwnerId              string `position:"Query" name:"OwnerId"`
}

// ListDNADBResponse is the response struct for api ListDNADB
type ListDNADBResponse struct {
	*responses.BaseResponse
	RequestId string  `json:"RequestId" xml:"RequestId"`
	DNADBList []DNADB `json:"DNADBList" xml:"DNADBList"`
}

// CreateListDNADBRequest creates a request to invoke ListDNADB API
func CreateListDNADBRequest() (request *ListDNADBRequest) {
	request = &ListDNADBRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "ListDNADB", "vod", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListDNADBResponse creates a response to parse from ListDNADB response
func CreateListDNADBResponse() (response *ListDNADBResponse) {
	response = &ListDNADBResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
