package vs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeGroups invokes the vs.DescribeGroups API synchronously
func (client *Client) DescribeGroups(request *DescribeGroupsRequest) (response *DescribeGroupsResponse, err error) {
	response = CreateDescribeGroupsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeGroupsWithChan invokes the vs.DescribeGroups API asynchronously
func (client *Client) DescribeGroupsWithChan(request *DescribeGroupsRequest) (<-chan *DescribeGroupsResponse, <-chan error) {
	responseChan := make(chan *DescribeGroupsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeGroups(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeGroupsWithCallback invokes the vs.DescribeGroups API asynchronously
func (client *Client) DescribeGroupsWithCallback(request *DescribeGroupsRequest, callback func(response *DescribeGroupsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeGroupsResponse
		var err error
		defer close(result)
		response, err = client.DescribeGroups(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeGroupsRequest is the request struct for api DescribeGroups
type DescribeGroupsRequest struct {
	*requests.RpcRequest
	SortDirection string           `position:"Query" name:"SortDirection"`
	PageNum       requests.Integer `position:"Query" name:"PageNum"`
	IncludeStats  requests.Boolean `position:"Query" name:"IncludeStats"`
	PageSize      requests.Integer `position:"Query" name:"PageSize"`
	Id            string           `position:"Query" name:"Id"`
	ShowLog       string           `position:"Query" name:"ShowLog"`
	OwnerId       requests.Integer `position:"Query" name:"OwnerId"`
	InProtocol    string           `position:"Query" name:"InProtocol"`
	Name          string           `position:"Query" name:"Name"`
	SortBy        string           `position:"Query" name:"SortBy"`
	Region        string           `position:"Query" name:"Region"`
	Status        string           `position:"Query" name:"Status"`
}

// DescribeGroupsResponse is the response struct for api DescribeGroups
type DescribeGroupsResponse struct {
	*responses.BaseResponse
	RequestId  string  `json:"RequestId" xml:"RequestId"`
	PageSize   int64   `json:"PageSize" xml:"PageSize"`
	PageNum    int64   `json:"PageNum" xml:"PageNum"`
	PageCount  int64   `json:"PageCount" xml:"PageCount"`
	TotalCount int64   `json:"TotalCount" xml:"TotalCount"`
	Groups     []Group `json:"Groups" xml:"Groups"`
}

// CreateDescribeGroupsRequest creates a request to invoke DescribeGroups API
func CreateDescribeGroupsRequest() (request *DescribeGroupsRequest) {
	request = &DescribeGroupsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vs", "2018-12-12", "DescribeGroups", "vs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeGroupsResponse creates a response to parse from DescribeGroups response
func CreateDescribeGroupsResponse() (response *DescribeGroupsResponse) {
	response = &DescribeGroupsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
