package vs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeVsStreamsOnlineList invokes the vs.DescribeVsStreamsOnlineList API synchronously
func (client *Client) DescribeVsStreamsOnlineList(request *DescribeVsStreamsOnlineListRequest) (response *DescribeVsStreamsOnlineListResponse, err error) {
	response = CreateDescribeVsStreamsOnlineListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeVsStreamsOnlineListWithChan invokes the vs.DescribeVsStreamsOnlineList API asynchronously
func (client *Client) DescribeVsStreamsOnlineListWithChan(request *DescribeVsStreamsOnlineListRequest) (<-chan *DescribeVsStreamsOnlineListResponse, <-chan error) {
	responseChan := make(chan *DescribeVsStreamsOnlineListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeVsStreamsOnlineList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeVsStreamsOnlineListWithCallback invokes the vs.DescribeVsStreamsOnlineList API asynchronously
func (client *Client) DescribeVsStreamsOnlineListWithCallback(request *DescribeVsStreamsOnlineListRequest, callback func(response *DescribeVsStreamsOnlineListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeVsStreamsOnlineListResponse
		var err error
		defer close(result)
		response, err = client.DescribeVsStreamsOnlineList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeVsStreamsOnlineListRequest is the request struct for api DescribeVsStreamsOnlineList
type DescribeVsStreamsOnlineListRequest struct {
	*requests.RpcRequest
	StartTime  string           `position:"Query" name:"StartTime"`
	PageNum    requests.Integer `position:"Query" name:"PageNum"`
	AppName    string           `position:"Query" name:"AppName"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	StreamName string           `position:"Query" name:"StreamName"`
	QueryType  string           `position:"Query" name:"QueryType"`
	ShowLog    string           `position:"Query" name:"ShowLog"`
	StreamType string           `position:"Query" name:"StreamType"`
	DomainName string           `position:"Query" name:"DomainName"`
	EndTime    string           `position:"Query" name:"EndTime"`
	OrderBy    string           `position:"Query" name:"OrderBy"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeVsStreamsOnlineListResponse is the response struct for api DescribeVsStreamsOnlineList
type DescribeVsStreamsOnlineListResponse struct {
	*responses.BaseResponse
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	PageNum    int        `json:"PageNum" xml:"PageNum"`
	PageSize   int        `json:"PageSize" xml:"PageSize"`
	TotalNum   int        `json:"TotalNum" xml:"TotalNum"`
	TotalPage  int        `json:"TotalPage" xml:"TotalPage"`
	OnlineInfo OnlineInfo `json:"OnlineInfo" xml:"OnlineInfo"`
}

// CreateDescribeVsStreamsOnlineListRequest creates a request to invoke DescribeVsStreamsOnlineList API
func CreateDescribeVsStreamsOnlineListRequest() (request *DescribeVsStreamsOnlineListRequest) {
	request = &DescribeVsStreamsOnlineListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vs", "2018-12-12", "DescribeVsStreamsOnlineList", "vs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeVsStreamsOnlineListResponse creates a response to parse from DescribeVsStreamsOnlineList response
func CreateDescribeVsStreamsOnlineListResponse() (response *DescribeVsStreamsOnlineListResponse) {
	response = &DescribeVsStreamsOnlineListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
