package datafactory

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"github.com/satori/go.uuid"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/datafactory/mgmt/2018-06-01/datafactory"

// AuthenticationType enumerates the values for authentication type.
type AuthenticationType string

const (
	// AuthenticationTypeAnonymous ...
	AuthenticationTypeAnonymous AuthenticationType = "Anonymous"
	// AuthenticationTypeBasic ...
	AuthenticationTypeBasic AuthenticationType = "Basic"
	// AuthenticationTypeClientCertificate ...
	AuthenticationTypeClientCertificate AuthenticationType = "ClientCertificate"
	// AuthenticationTypeWebLinkedServiceTypeProperties ...
	AuthenticationTypeWebLinkedServiceTypeProperties AuthenticationType = "WebLinkedServiceTypeProperties"
)

// PossibleAuthenticationTypeValues returns an array of possible values for the AuthenticationType const type.
func PossibleAuthenticationTypeValues() []AuthenticationType {
	return []AuthenticationType{AuthenticationTypeAnonymous, AuthenticationTypeBasic, AuthenticationTypeClientCertificate, AuthenticationTypeWebLinkedServiceTypeProperties}
}

// AuthorizationType enumerates the values for authorization type.
type AuthorizationType string

const (
	// AuthorizationTypeKey ...
	AuthorizationTypeKey AuthorizationType = "Key"
	// AuthorizationTypeLinkedIntegrationRuntimeType ...
	AuthorizationTypeLinkedIntegrationRuntimeType AuthorizationType = "LinkedIntegrationRuntimeType"
	// AuthorizationTypeRBAC ...
	AuthorizationTypeRBAC AuthorizationType = "RBAC"
)

// PossibleAuthorizationTypeValues returns an array of possible values for the AuthorizationType const type.
func PossibleAuthorizationTypeValues() []AuthorizationType {
	return []AuthorizationType{AuthorizationTypeKey, AuthorizationTypeLinkedIntegrationRuntimeType, AuthorizationTypeRBAC}
}

// AzureFunctionActivityMethod enumerates the values for azure function activity method.
type AzureFunctionActivityMethod string

const (
	// DELETE ...
	DELETE AzureFunctionActivityMethod = "DELETE"
	// GET ...
	GET AzureFunctionActivityMethod = "GET"
	// HEAD ...
	HEAD AzureFunctionActivityMethod = "HEAD"
	// OPTIONS ...
	OPTIONS AzureFunctionActivityMethod = "OPTIONS"
	// POST ...
	POST AzureFunctionActivityMethod = "POST"
	// PUT ...
	PUT AzureFunctionActivityMethod = "PUT"
	// TRACE ...
	TRACE AzureFunctionActivityMethod = "TRACE"
)

// PossibleAzureFunctionActivityMethodValues returns an array of possible values for the AzureFunctionActivityMethod const type.
func PossibleAzureFunctionActivityMethodValues() []AzureFunctionActivityMethod {
	return []AzureFunctionActivityMethod{DELETE, GET, HEAD, OPTIONS, POST, PUT, TRACE}
}

// AzureSearchIndexWriteBehaviorType enumerates the values for azure search index write behavior type.
type AzureSearchIndexWriteBehaviorType string

const (
	// Merge ...
	Merge AzureSearchIndexWriteBehaviorType = "Merge"
	// Upload ...
	Upload AzureSearchIndexWriteBehaviorType = "Upload"
)

// PossibleAzureSearchIndexWriteBehaviorTypeValues returns an array of possible values for the AzureSearchIndexWriteBehaviorType const type.
func PossibleAzureSearchIndexWriteBehaviorTypeValues() []AzureSearchIndexWriteBehaviorType {
	return []AzureSearchIndexWriteBehaviorType{Merge, Upload}
}

// BlobEventTypes enumerates the values for blob event types.
type BlobEventTypes string

const (
	// MicrosoftStorageBlobCreated ...
	MicrosoftStorageBlobCreated BlobEventTypes = "Microsoft.Storage.BlobCreated"
	// MicrosoftStorageBlobDeleted ...
	MicrosoftStorageBlobDeleted BlobEventTypes = "Microsoft.Storage.BlobDeleted"
)

// PossibleBlobEventTypesValues returns an array of possible values for the BlobEventTypes const type.
func PossibleBlobEventTypesValues() []BlobEventTypes {
	return []BlobEventTypes{MicrosoftStorageBlobCreated, MicrosoftStorageBlobDeleted}
}

// CassandraSourceReadConsistencyLevels enumerates the values for cassandra source read consistency levels.
type CassandraSourceReadConsistencyLevels string

const (
	// ALL ...
	ALL CassandraSourceReadConsistencyLevels = "ALL"
	// EACHQUORUM ...
	EACHQUORUM CassandraSourceReadConsistencyLevels = "EACH_QUORUM"
	// LOCALONE ...
	LOCALONE CassandraSourceReadConsistencyLevels = "LOCAL_ONE"
	// LOCALQUORUM ...
	LOCALQUORUM CassandraSourceReadConsistencyLevels = "LOCAL_QUORUM"
	// LOCALSERIAL ...
	LOCALSERIAL CassandraSourceReadConsistencyLevels = "LOCAL_SERIAL"
	// ONE ...
	ONE CassandraSourceReadConsistencyLevels = "ONE"
	// QUORUM ...
	QUORUM CassandraSourceReadConsistencyLevels = "QUORUM"
	// SERIAL ...
	SERIAL CassandraSourceReadConsistencyLevels = "SERIAL"
	// THREE ...
	THREE CassandraSourceReadConsistencyLevels = "THREE"
	// TWO ...
	TWO CassandraSourceReadConsistencyLevels = "TWO"
)

// PossibleCassandraSourceReadConsistencyLevelsValues returns an array of possible values for the CassandraSourceReadConsistencyLevels const type.
func PossibleCassandraSourceReadConsistencyLevelsValues() []CassandraSourceReadConsistencyLevels {
	return []CassandraSourceReadConsistencyLevels{ALL, EACHQUORUM, LOCALONE, LOCALQUORUM, LOCALSERIAL, ONE, QUORUM, SERIAL, THREE, TWO}
}

// CopyBehaviorType enumerates the values for copy behavior type.
type CopyBehaviorType string

const (
	// FlattenHierarchy ...
	FlattenHierarchy CopyBehaviorType = "FlattenHierarchy"
	// MergeFiles ...
	MergeFiles CopyBehaviorType = "MergeFiles"
	// PreserveHierarchy ...
	PreserveHierarchy CopyBehaviorType = "PreserveHierarchy"
)

// PossibleCopyBehaviorTypeValues returns an array of possible values for the CopyBehaviorType const type.
func PossibleCopyBehaviorTypeValues() []CopyBehaviorType {
	return []CopyBehaviorType{FlattenHierarchy, MergeFiles, PreserveHierarchy}
}

// DatasetCompressionLevel enumerates the values for dataset compression level.
type DatasetCompressionLevel string

const (
	// Fastest ...
	Fastest DatasetCompressionLevel = "Fastest"
	// Optimal ...
	Optimal DatasetCompressionLevel = "Optimal"
)

// PossibleDatasetCompressionLevelValues returns an array of possible values for the DatasetCompressionLevel const type.
func PossibleDatasetCompressionLevelValues() []DatasetCompressionLevel {
	return []DatasetCompressionLevel{Fastest, Optimal}
}

// DayOfWeek enumerates the values for day of week.
type DayOfWeek string

const (
	// Friday ...
	Friday DayOfWeek = "Friday"
	// Monday ...
	Monday DayOfWeek = "Monday"
	// Saturday ...
	Saturday DayOfWeek = "Saturday"
	// Sunday ...
	Sunday DayOfWeek = "Sunday"
	// Thursday ...
	Thursday DayOfWeek = "Thursday"
	// Tuesday ...
	Tuesday DayOfWeek = "Tuesday"
	// Wednesday ...
	Wednesday DayOfWeek = "Wednesday"
)

// PossibleDayOfWeekValues returns an array of possible values for the DayOfWeek const type.
func PossibleDayOfWeekValues() []DayOfWeek {
	return []DayOfWeek{Friday, Monday, Saturday, Sunday, Thursday, Tuesday, Wednesday}
}

// DaysOfWeek enumerates the values for days of week.
type DaysOfWeek string

const (
	// DaysOfWeekFriday ...
	DaysOfWeekFriday DaysOfWeek = "Friday"
	// DaysOfWeekMonday ...
	DaysOfWeekMonday DaysOfWeek = "Monday"
	// DaysOfWeekSaturday ...
	DaysOfWeekSaturday DaysOfWeek = "Saturday"
	// DaysOfWeekSunday ...
	DaysOfWeekSunday DaysOfWeek = "Sunday"
	// DaysOfWeekThursday ...
	DaysOfWeekThursday DaysOfWeek = "Thursday"
	// DaysOfWeekTuesday ...
	DaysOfWeekTuesday DaysOfWeek = "Tuesday"
	// DaysOfWeekWednesday ...
	DaysOfWeekWednesday DaysOfWeek = "Wednesday"
)

// PossibleDaysOfWeekValues returns an array of possible values for the DaysOfWeek const type.
func PossibleDaysOfWeekValues() []DaysOfWeek {
	return []DaysOfWeek{DaysOfWeekFriday, DaysOfWeekMonday, DaysOfWeekSaturday, DaysOfWeekSunday, DaysOfWeekThursday, DaysOfWeekTuesday, DaysOfWeekWednesday}
}

// Db2AuthenticationType enumerates the values for db 2 authentication type.
type Db2AuthenticationType string

const (
	// Basic ...
	Basic Db2AuthenticationType = "Basic"
)

// PossibleDb2AuthenticationTypeValues returns an array of possible values for the Db2AuthenticationType const type.
func PossibleDb2AuthenticationTypeValues() []Db2AuthenticationType {
	return []Db2AuthenticationType{Basic}
}

// DependencyCondition enumerates the values for dependency condition.
type DependencyCondition string

const (
	// Completed ...
	Completed DependencyCondition = "Completed"
	// Failed ...
	Failed DependencyCondition = "Failed"
	// Skipped ...
	Skipped DependencyCondition = "Skipped"
	// Succeeded ...
	Succeeded DependencyCondition = "Succeeded"
)

// PossibleDependencyConditionValues returns an array of possible values for the DependencyCondition const type.
func PossibleDependencyConditionValues() []DependencyCondition {
	return []DependencyCondition{Completed, Failed, Skipped, Succeeded}
}

// FtpAuthenticationType enumerates the values for ftp authentication type.
type FtpAuthenticationType string

const (
	// FtpAuthenticationTypeAnonymous ...
	FtpAuthenticationTypeAnonymous FtpAuthenticationType = "Anonymous"
	// FtpAuthenticationTypeBasic ...
	FtpAuthenticationTypeBasic FtpAuthenticationType = "Basic"
)

// PossibleFtpAuthenticationTypeValues returns an array of possible values for the FtpAuthenticationType const type.
func PossibleFtpAuthenticationTypeValues() []FtpAuthenticationType {
	return []FtpAuthenticationType{FtpAuthenticationTypeAnonymous, FtpAuthenticationTypeBasic}
}

// GoogleAdWordsAuthenticationType enumerates the values for google ad words authentication type.
type GoogleAdWordsAuthenticationType string

const (
	// ServiceAuthentication ...
	ServiceAuthentication GoogleAdWordsAuthenticationType = "ServiceAuthentication"
	// UserAuthentication ...
	UserAuthentication GoogleAdWordsAuthenticationType = "UserAuthentication"
)

// PossibleGoogleAdWordsAuthenticationTypeValues returns an array of possible values for the GoogleAdWordsAuthenticationType const type.
func PossibleGoogleAdWordsAuthenticationTypeValues() []GoogleAdWordsAuthenticationType {
	return []GoogleAdWordsAuthenticationType{ServiceAuthentication, UserAuthentication}
}

// GoogleBigQueryAuthenticationType enumerates the values for google big query authentication type.
type GoogleBigQueryAuthenticationType string

const (
	// GoogleBigQueryAuthenticationTypeServiceAuthentication ...
	GoogleBigQueryAuthenticationTypeServiceAuthentication GoogleBigQueryAuthenticationType = "ServiceAuthentication"
	// GoogleBigQueryAuthenticationTypeUserAuthentication ...
	GoogleBigQueryAuthenticationTypeUserAuthentication GoogleBigQueryAuthenticationType = "UserAuthentication"
)

// PossibleGoogleBigQueryAuthenticationTypeValues returns an array of possible values for the GoogleBigQueryAuthenticationType const type.
func PossibleGoogleBigQueryAuthenticationTypeValues() []GoogleBigQueryAuthenticationType {
	return []GoogleBigQueryAuthenticationType{GoogleBigQueryAuthenticationTypeServiceAuthentication, GoogleBigQueryAuthenticationTypeUserAuthentication}
}

// HBaseAuthenticationType enumerates the values for h base authentication type.
type HBaseAuthenticationType string

const (
	// HBaseAuthenticationTypeAnonymous ...
	HBaseAuthenticationTypeAnonymous HBaseAuthenticationType = "Anonymous"
	// HBaseAuthenticationTypeBasic ...
	HBaseAuthenticationTypeBasic HBaseAuthenticationType = "Basic"
)

// PossibleHBaseAuthenticationTypeValues returns an array of possible values for the HBaseAuthenticationType const type.
func PossibleHBaseAuthenticationTypeValues() []HBaseAuthenticationType {
	return []HBaseAuthenticationType{HBaseAuthenticationTypeAnonymous, HBaseAuthenticationTypeBasic}
}

// HDInsightActivityDebugInfoOption enumerates the values for hd insight activity debug info option.
type HDInsightActivityDebugInfoOption string

const (
	// Always ...
	Always HDInsightActivityDebugInfoOption = "Always"
	// Failure ...
	Failure HDInsightActivityDebugInfoOption = "Failure"
	// None ...
	None HDInsightActivityDebugInfoOption = "None"
)

// PossibleHDInsightActivityDebugInfoOptionValues returns an array of possible values for the HDInsightActivityDebugInfoOption const type.
func PossibleHDInsightActivityDebugInfoOptionValues() []HDInsightActivityDebugInfoOption {
	return []HDInsightActivityDebugInfoOption{Always, Failure, None}
}

// HiveAuthenticationType enumerates the values for hive authentication type.
type HiveAuthenticationType string

const (
	// Anonymous ...
	Anonymous HiveAuthenticationType = "Anonymous"
	// Username ...
	Username HiveAuthenticationType = "Username"
	// UsernameAndPassword ...
	UsernameAndPassword HiveAuthenticationType = "UsernameAndPassword"
	// WindowsAzureHDInsightService ...
	WindowsAzureHDInsightService HiveAuthenticationType = "WindowsAzureHDInsightService"
)

// PossibleHiveAuthenticationTypeValues returns an array of possible values for the HiveAuthenticationType const type.
func PossibleHiveAuthenticationTypeValues() []HiveAuthenticationType {
	return []HiveAuthenticationType{Anonymous, Username, UsernameAndPassword, WindowsAzureHDInsightService}
}

// HiveServerType enumerates the values for hive server type.
type HiveServerType string

const (
	// HiveServer1 ...
	HiveServer1 HiveServerType = "HiveServer1"
	// HiveServer2 ...
	HiveServer2 HiveServerType = "HiveServer2"
	// HiveThriftServer ...
	HiveThriftServer HiveServerType = "HiveThriftServer"
)

// PossibleHiveServerTypeValues returns an array of possible values for the HiveServerType const type.
func PossibleHiveServerTypeValues() []HiveServerType {
	return []HiveServerType{HiveServer1, HiveServer2, HiveThriftServer}
}

// HiveThriftTransportProtocol enumerates the values for hive thrift transport protocol.
type HiveThriftTransportProtocol string

const (
	// Binary ...
	Binary HiveThriftTransportProtocol = "Binary"
	// HTTP ...
	HTTP HiveThriftTransportProtocol = "HTTP "
	// SASL ...
	SASL HiveThriftTransportProtocol = "SASL"
)

// PossibleHiveThriftTransportProtocolValues returns an array of possible values for the HiveThriftTransportProtocol const type.
func PossibleHiveThriftTransportProtocolValues() []HiveThriftTransportProtocol {
	return []HiveThriftTransportProtocol{Binary, HTTP, SASL}
}

// HTTPAuthenticationType enumerates the values for http authentication type.
type HTTPAuthenticationType string

const (
	// HTTPAuthenticationTypeAnonymous ...
	HTTPAuthenticationTypeAnonymous HTTPAuthenticationType = "Anonymous"
	// HTTPAuthenticationTypeBasic ...
	HTTPAuthenticationTypeBasic HTTPAuthenticationType = "Basic"
	// HTTPAuthenticationTypeClientCertificate ...
	HTTPAuthenticationTypeClientCertificate HTTPAuthenticationType = "ClientCertificate"
	// HTTPAuthenticationTypeDigest ...
	HTTPAuthenticationTypeDigest HTTPAuthenticationType = "Digest"
	// HTTPAuthenticationTypeWindows ...
	HTTPAuthenticationTypeWindows HTTPAuthenticationType = "Windows"
)

// PossibleHTTPAuthenticationTypeValues returns an array of possible values for the HTTPAuthenticationType const type.
func PossibleHTTPAuthenticationTypeValues() []HTTPAuthenticationType {
	return []HTTPAuthenticationType{HTTPAuthenticationTypeAnonymous, HTTPAuthenticationTypeBasic, HTTPAuthenticationTypeClientCertificate, HTTPAuthenticationTypeDigest, HTTPAuthenticationTypeWindows}
}

// ImpalaAuthenticationType enumerates the values for impala authentication type.
type ImpalaAuthenticationType string

const (
	// ImpalaAuthenticationTypeAnonymous ...
	ImpalaAuthenticationTypeAnonymous ImpalaAuthenticationType = "Anonymous"
	// ImpalaAuthenticationTypeSASLUsername ...
	ImpalaAuthenticationTypeSASLUsername ImpalaAuthenticationType = "SASLUsername"
	// ImpalaAuthenticationTypeUsernameAndPassword ...
	ImpalaAuthenticationTypeUsernameAndPassword ImpalaAuthenticationType = "UsernameAndPassword"
)

// PossibleImpalaAuthenticationTypeValues returns an array of possible values for the ImpalaAuthenticationType const type.
func PossibleImpalaAuthenticationTypeValues() []ImpalaAuthenticationType {
	return []ImpalaAuthenticationType{ImpalaAuthenticationTypeAnonymous, ImpalaAuthenticationTypeSASLUsername, ImpalaAuthenticationTypeUsernameAndPassword}
}

// IntegrationRuntimeAuthKeyName enumerates the values for integration runtime auth key name.
type IntegrationRuntimeAuthKeyName string

const (
	// AuthKey1 ...
	AuthKey1 IntegrationRuntimeAuthKeyName = "authKey1"
	// AuthKey2 ...
	AuthKey2 IntegrationRuntimeAuthKeyName = "authKey2"
)

// PossibleIntegrationRuntimeAuthKeyNameValues returns an array of possible values for the IntegrationRuntimeAuthKeyName const type.
func PossibleIntegrationRuntimeAuthKeyNameValues() []IntegrationRuntimeAuthKeyName {
	return []IntegrationRuntimeAuthKeyName{AuthKey1, AuthKey2}
}

// IntegrationRuntimeAutoUpdate enumerates the values for integration runtime auto update.
type IntegrationRuntimeAutoUpdate string

const (
	// Off ...
	Off IntegrationRuntimeAutoUpdate = "Off"
	// On ...
	On IntegrationRuntimeAutoUpdate = "On"
)

// PossibleIntegrationRuntimeAutoUpdateValues returns an array of possible values for the IntegrationRuntimeAutoUpdate const type.
func PossibleIntegrationRuntimeAutoUpdateValues() []IntegrationRuntimeAutoUpdate {
	return []IntegrationRuntimeAutoUpdate{Off, On}
}

// IntegrationRuntimeEdition enumerates the values for integration runtime edition.
type IntegrationRuntimeEdition string

const (
	// Enterprise ...
	Enterprise IntegrationRuntimeEdition = "Enterprise"
	// Standard ...
	Standard IntegrationRuntimeEdition = "Standard"
)

// PossibleIntegrationRuntimeEditionValues returns an array of possible values for the IntegrationRuntimeEdition const type.
func PossibleIntegrationRuntimeEditionValues() []IntegrationRuntimeEdition {
	return []IntegrationRuntimeEdition{Enterprise, Standard}
}

// IntegrationRuntimeInternalChannelEncryptionMode enumerates the values for integration runtime internal
// channel encryption mode.
type IntegrationRuntimeInternalChannelEncryptionMode string

const (
	// NotEncrypted ...
	NotEncrypted IntegrationRuntimeInternalChannelEncryptionMode = "NotEncrypted"
	// NotSet ...
	NotSet IntegrationRuntimeInternalChannelEncryptionMode = "NotSet"
	// SslEncrypted ...
	SslEncrypted IntegrationRuntimeInternalChannelEncryptionMode = "SslEncrypted"
)

// PossibleIntegrationRuntimeInternalChannelEncryptionModeValues returns an array of possible values for the IntegrationRuntimeInternalChannelEncryptionMode const type.
func PossibleIntegrationRuntimeInternalChannelEncryptionModeValues() []IntegrationRuntimeInternalChannelEncryptionMode {
	return []IntegrationRuntimeInternalChannelEncryptionMode{NotEncrypted, NotSet, SslEncrypted}
}

// IntegrationRuntimeLicenseType enumerates the values for integration runtime license type.
type IntegrationRuntimeLicenseType string

const (
	// BasePrice ...
	BasePrice IntegrationRuntimeLicenseType = "BasePrice"
	// LicenseIncluded ...
	LicenseIncluded IntegrationRuntimeLicenseType = "LicenseIncluded"
)

// PossibleIntegrationRuntimeLicenseTypeValues returns an array of possible values for the IntegrationRuntimeLicenseType const type.
func PossibleIntegrationRuntimeLicenseTypeValues() []IntegrationRuntimeLicenseType {
	return []IntegrationRuntimeLicenseType{BasePrice, LicenseIncluded}
}

// IntegrationRuntimeSsisCatalogPricingTier enumerates the values for integration runtime ssis catalog pricing
// tier.
type IntegrationRuntimeSsisCatalogPricingTier string

const (
	// IntegrationRuntimeSsisCatalogPricingTierBasic ...
	IntegrationRuntimeSsisCatalogPricingTierBasic IntegrationRuntimeSsisCatalogPricingTier = "Basic"
	// IntegrationRuntimeSsisCatalogPricingTierPremium ...
	IntegrationRuntimeSsisCatalogPricingTierPremium IntegrationRuntimeSsisCatalogPricingTier = "Premium"
	// IntegrationRuntimeSsisCatalogPricingTierPremiumRS ...
	IntegrationRuntimeSsisCatalogPricingTierPremiumRS IntegrationRuntimeSsisCatalogPricingTier = "PremiumRS"
	// IntegrationRuntimeSsisCatalogPricingTierStandard ...
	IntegrationRuntimeSsisCatalogPricingTierStandard IntegrationRuntimeSsisCatalogPricingTier = "Standard"
)

// PossibleIntegrationRuntimeSsisCatalogPricingTierValues returns an array of possible values for the IntegrationRuntimeSsisCatalogPricingTier const type.
func PossibleIntegrationRuntimeSsisCatalogPricingTierValues() []IntegrationRuntimeSsisCatalogPricingTier {
	return []IntegrationRuntimeSsisCatalogPricingTier{IntegrationRuntimeSsisCatalogPricingTierBasic, IntegrationRuntimeSsisCatalogPricingTierPremium, IntegrationRuntimeSsisCatalogPricingTierPremiumRS, IntegrationRuntimeSsisCatalogPricingTierStandard}
}

// IntegrationRuntimeState enumerates the values for integration runtime state.
type IntegrationRuntimeState string

const (
	// AccessDenied ...
	AccessDenied IntegrationRuntimeState = "AccessDenied"
	// Initial ...
	Initial IntegrationRuntimeState = "Initial"
	// Limited ...
	Limited IntegrationRuntimeState = "Limited"
	// NeedRegistration ...
	NeedRegistration IntegrationRuntimeState = "NeedRegistration"
	// Offline ...
	Offline IntegrationRuntimeState = "Offline"
	// Online ...
	Online IntegrationRuntimeState = "Online"
	// Started ...
	Started IntegrationRuntimeState = "Started"
	// Starting ...
	Starting IntegrationRuntimeState = "Starting"
	// Stopped ...
	Stopped IntegrationRuntimeState = "Stopped"
	// Stopping ...
	Stopping IntegrationRuntimeState = "Stopping"
)

// PossibleIntegrationRuntimeStateValues returns an array of possible values for the IntegrationRuntimeState const type.
func PossibleIntegrationRuntimeStateValues() []IntegrationRuntimeState {
	return []IntegrationRuntimeState{AccessDenied, Initial, Limited, NeedRegistration, Offline, Online, Started, Starting, Stopped, Stopping}
}

// IntegrationRuntimeType enumerates the values for integration runtime type.
type IntegrationRuntimeType string

const (
	// Managed ...
	Managed IntegrationRuntimeType = "Managed"
	// SelfHosted ...
	SelfHosted IntegrationRuntimeType = "SelfHosted"
)

// PossibleIntegrationRuntimeTypeValues returns an array of possible values for the IntegrationRuntimeType const type.
func PossibleIntegrationRuntimeTypeValues() []IntegrationRuntimeType {
	return []IntegrationRuntimeType{Managed, SelfHosted}
}

// IntegrationRuntimeUpdateResult enumerates the values for integration runtime update result.
type IntegrationRuntimeUpdateResult string

const (
	// IntegrationRuntimeUpdateResultFail ...
	IntegrationRuntimeUpdateResultFail IntegrationRuntimeUpdateResult = "Fail"
	// IntegrationRuntimeUpdateResultNone ...
	IntegrationRuntimeUpdateResultNone IntegrationRuntimeUpdateResult = "None"
	// IntegrationRuntimeUpdateResultSucceed ...
	IntegrationRuntimeUpdateResultSucceed IntegrationRuntimeUpdateResult = "Succeed"
)

// PossibleIntegrationRuntimeUpdateResultValues returns an array of possible values for the IntegrationRuntimeUpdateResult const type.
func PossibleIntegrationRuntimeUpdateResultValues() []IntegrationRuntimeUpdateResult {
	return []IntegrationRuntimeUpdateResult{IntegrationRuntimeUpdateResultFail, IntegrationRuntimeUpdateResultNone, IntegrationRuntimeUpdateResultSucceed}
}

// JSONFormatFilePattern enumerates the values for json format file pattern.
type JSONFormatFilePattern string

const (
	// ArrayOfObjects ...
	ArrayOfObjects JSONFormatFilePattern = "arrayOfObjects"
	// SetOfObjects ...
	SetOfObjects JSONFormatFilePattern = "setOfObjects"
)

// PossibleJSONFormatFilePatternValues returns an array of possible values for the JSONFormatFilePattern const type.
func PossibleJSONFormatFilePatternValues() []JSONFormatFilePattern {
	return []JSONFormatFilePattern{ArrayOfObjects, SetOfObjects}
}

// ManagedIntegrationRuntimeNodeStatus enumerates the values for managed integration runtime node status.
type ManagedIntegrationRuntimeNodeStatus string

const (
	// ManagedIntegrationRuntimeNodeStatusAvailable ...
	ManagedIntegrationRuntimeNodeStatusAvailable ManagedIntegrationRuntimeNodeStatus = "Available"
	// ManagedIntegrationRuntimeNodeStatusRecycling ...
	ManagedIntegrationRuntimeNodeStatusRecycling ManagedIntegrationRuntimeNodeStatus = "Recycling"
	// ManagedIntegrationRuntimeNodeStatusStarting ...
	ManagedIntegrationRuntimeNodeStatusStarting ManagedIntegrationRuntimeNodeStatus = "Starting"
	// ManagedIntegrationRuntimeNodeStatusUnavailable ...
	ManagedIntegrationRuntimeNodeStatusUnavailable ManagedIntegrationRuntimeNodeStatus = "Unavailable"
)

// PossibleManagedIntegrationRuntimeNodeStatusValues returns an array of possible values for the ManagedIntegrationRuntimeNodeStatus const type.
func PossibleManagedIntegrationRuntimeNodeStatusValues() []ManagedIntegrationRuntimeNodeStatus {
	return []ManagedIntegrationRuntimeNodeStatus{ManagedIntegrationRuntimeNodeStatusAvailable, ManagedIntegrationRuntimeNodeStatusRecycling, ManagedIntegrationRuntimeNodeStatusStarting, ManagedIntegrationRuntimeNodeStatusUnavailable}
}

// MongoDbAuthenticationType enumerates the values for mongo db authentication type.
type MongoDbAuthenticationType string

const (
	// MongoDbAuthenticationTypeAnonymous ...
	MongoDbAuthenticationTypeAnonymous MongoDbAuthenticationType = "Anonymous"
	// MongoDbAuthenticationTypeBasic ...
	MongoDbAuthenticationTypeBasic MongoDbAuthenticationType = "Basic"
)

// PossibleMongoDbAuthenticationTypeValues returns an array of possible values for the MongoDbAuthenticationType const type.
func PossibleMongoDbAuthenticationTypeValues() []MongoDbAuthenticationType {
	return []MongoDbAuthenticationType{MongoDbAuthenticationTypeAnonymous, MongoDbAuthenticationTypeBasic}
}

// ODataAadServicePrincipalCredentialType enumerates the values for o data aad service principal credential
// type.
type ODataAadServicePrincipalCredentialType string

const (
	// ServicePrincipalCert ...
	ServicePrincipalCert ODataAadServicePrincipalCredentialType = "ServicePrincipalCert"
	// ServicePrincipalKey ...
	ServicePrincipalKey ODataAadServicePrincipalCredentialType = "ServicePrincipalKey"
)

// PossibleODataAadServicePrincipalCredentialTypeValues returns an array of possible values for the ODataAadServicePrincipalCredentialType const type.
func PossibleODataAadServicePrincipalCredentialTypeValues() []ODataAadServicePrincipalCredentialType {
	return []ODataAadServicePrincipalCredentialType{ServicePrincipalCert, ServicePrincipalKey}
}

// ODataAuthenticationType enumerates the values for o data authentication type.
type ODataAuthenticationType string

const (
	// ODataAuthenticationTypeAadServicePrincipal ...
	ODataAuthenticationTypeAadServicePrincipal ODataAuthenticationType = "AadServicePrincipal"
	// ODataAuthenticationTypeAnonymous ...
	ODataAuthenticationTypeAnonymous ODataAuthenticationType = "Anonymous"
	// ODataAuthenticationTypeBasic ...
	ODataAuthenticationTypeBasic ODataAuthenticationType = "Basic"
	// ODataAuthenticationTypeManagedServiceIdentity ...
	ODataAuthenticationTypeManagedServiceIdentity ODataAuthenticationType = "ManagedServiceIdentity"
	// ODataAuthenticationTypeWindows ...
	ODataAuthenticationTypeWindows ODataAuthenticationType = "Windows"
)

// PossibleODataAuthenticationTypeValues returns an array of possible values for the ODataAuthenticationType const type.
func PossibleODataAuthenticationTypeValues() []ODataAuthenticationType {
	return []ODataAuthenticationType{ODataAuthenticationTypeAadServicePrincipal, ODataAuthenticationTypeAnonymous, ODataAuthenticationTypeBasic, ODataAuthenticationTypeManagedServiceIdentity, ODataAuthenticationTypeWindows}
}

// ParameterType enumerates the values for parameter type.
type ParameterType string

const (
	// ParameterTypeArray ...
	ParameterTypeArray ParameterType = "Array"
	// ParameterTypeBool ...
	ParameterTypeBool ParameterType = "Bool"
	// ParameterTypeFloat ...
	ParameterTypeFloat ParameterType = "Float"
	// ParameterTypeInt ...
	ParameterTypeInt ParameterType = "Int"
	// ParameterTypeObject ...
	ParameterTypeObject ParameterType = "Object"
	// ParameterTypeSecureString ...
	ParameterTypeSecureString ParameterType = "SecureString"
	// ParameterTypeString ...
	ParameterTypeString ParameterType = "String"
)

// PossibleParameterTypeValues returns an array of possible values for the ParameterType const type.
func PossibleParameterTypeValues() []ParameterType {
	return []ParameterType{ParameterTypeArray, ParameterTypeBool, ParameterTypeFloat, ParameterTypeInt, ParameterTypeObject, ParameterTypeSecureString, ParameterTypeString}
}

// PhoenixAuthenticationType enumerates the values for phoenix authentication type.
type PhoenixAuthenticationType string

const (
	// PhoenixAuthenticationTypeAnonymous ...
	PhoenixAuthenticationTypeAnonymous PhoenixAuthenticationType = "Anonymous"
	// PhoenixAuthenticationTypeUsernameAndPassword ...
	PhoenixAuthenticationTypeUsernameAndPassword PhoenixAuthenticationType = "UsernameAndPassword"
	// PhoenixAuthenticationTypeWindowsAzureHDInsightService ...
	PhoenixAuthenticationTypeWindowsAzureHDInsightService PhoenixAuthenticationType = "WindowsAzureHDInsightService"
)

// PossiblePhoenixAuthenticationTypeValues returns an array of possible values for the PhoenixAuthenticationType const type.
func PossiblePhoenixAuthenticationTypeValues() []PhoenixAuthenticationType {
	return []PhoenixAuthenticationType{PhoenixAuthenticationTypeAnonymous, PhoenixAuthenticationTypeUsernameAndPassword, PhoenixAuthenticationTypeWindowsAzureHDInsightService}
}

// PolybaseSettingsRejectType enumerates the values for polybase settings reject type.
type PolybaseSettingsRejectType string

const (
	// Percentage ...
	Percentage PolybaseSettingsRejectType = "percentage"
	// Value ...
	Value PolybaseSettingsRejectType = "value"
)

// PossiblePolybaseSettingsRejectTypeValues returns an array of possible values for the PolybaseSettingsRejectType const type.
func PossiblePolybaseSettingsRejectTypeValues() []PolybaseSettingsRejectType {
	return []PolybaseSettingsRejectType{Percentage, Value}
}

// PrestoAuthenticationType enumerates the values for presto authentication type.
type PrestoAuthenticationType string

const (
	// PrestoAuthenticationTypeAnonymous ...
	PrestoAuthenticationTypeAnonymous PrestoAuthenticationType = "Anonymous"
	// PrestoAuthenticationTypeLDAP ...
	PrestoAuthenticationTypeLDAP PrestoAuthenticationType = "LDAP"
)

// PossiblePrestoAuthenticationTypeValues returns an array of possible values for the PrestoAuthenticationType const type.
func PossiblePrestoAuthenticationTypeValues() []PrestoAuthenticationType {
	return []PrestoAuthenticationType{PrestoAuthenticationTypeAnonymous, PrestoAuthenticationTypeLDAP}
}

// RecurrenceFrequency enumerates the values for recurrence frequency.
type RecurrenceFrequency string

const (
	// Day ...
	Day RecurrenceFrequency = "Day"
	// Hour ...
	Hour RecurrenceFrequency = "Hour"
	// Minute ...
	Minute RecurrenceFrequency = "Minute"
	// Month ...
	Month RecurrenceFrequency = "Month"
	// NotSpecified ...
	NotSpecified RecurrenceFrequency = "NotSpecified"
	// Week ...
	Week RecurrenceFrequency = "Week"
	// Year ...
	Year RecurrenceFrequency = "Year"
)

// PossibleRecurrenceFrequencyValues returns an array of possible values for the RecurrenceFrequency const type.
func PossibleRecurrenceFrequencyValues() []RecurrenceFrequency {
	return []RecurrenceFrequency{Day, Hour, Minute, Month, NotSpecified, Week, Year}
}

// RestServiceAuthenticationType enumerates the values for rest service authentication type.
type RestServiceAuthenticationType string

const (
	// RestServiceAuthenticationTypeAadServicePrincipal ...
	RestServiceAuthenticationTypeAadServicePrincipal RestServiceAuthenticationType = "AadServicePrincipal"
	// RestServiceAuthenticationTypeAnonymous ...
	RestServiceAuthenticationTypeAnonymous RestServiceAuthenticationType = "Anonymous"
	// RestServiceAuthenticationTypeBasic ...
	RestServiceAuthenticationTypeBasic RestServiceAuthenticationType = "Basic"
	// RestServiceAuthenticationTypeManagedServiceIdentity ...
	RestServiceAuthenticationTypeManagedServiceIdentity RestServiceAuthenticationType = "ManagedServiceIdentity"
)

// PossibleRestServiceAuthenticationTypeValues returns an array of possible values for the RestServiceAuthenticationType const type.
func PossibleRestServiceAuthenticationTypeValues() []RestServiceAuthenticationType {
	return []RestServiceAuthenticationType{RestServiceAuthenticationTypeAadServicePrincipal, RestServiceAuthenticationTypeAnonymous, RestServiceAuthenticationTypeBasic, RestServiceAuthenticationTypeManagedServiceIdentity}
}

// RunQueryFilterOperand enumerates the values for run query filter operand.
type RunQueryFilterOperand string

const (
	// ActivityName ...
	ActivityName RunQueryFilterOperand = "ActivityName"
	// ActivityRunEnd ...
	ActivityRunEnd RunQueryFilterOperand = "ActivityRunEnd"
	// ActivityRunStart ...
	ActivityRunStart RunQueryFilterOperand = "ActivityRunStart"
	// ActivityType ...
	ActivityType RunQueryFilterOperand = "ActivityType"
	// LatestOnly ...
	LatestOnly RunQueryFilterOperand = "LatestOnly"
	// PipelineName ...
	PipelineName RunQueryFilterOperand = "PipelineName"
	// RunEnd ...
	RunEnd RunQueryFilterOperand = "RunEnd"
	// RunGroupID ...
	RunGroupID RunQueryFilterOperand = "RunGroupId"
	// RunStart ...
	RunStart RunQueryFilterOperand = "RunStart"
	// Status ...
	Status RunQueryFilterOperand = "Status"
	// TriggerName ...
	TriggerName RunQueryFilterOperand = "TriggerName"
	// TriggerRunTimestamp ...
	TriggerRunTimestamp RunQueryFilterOperand = "TriggerRunTimestamp"
)

// PossibleRunQueryFilterOperandValues returns an array of possible values for the RunQueryFilterOperand const type.
func PossibleRunQueryFilterOperandValues() []RunQueryFilterOperand {
	return []RunQueryFilterOperand{ActivityName, ActivityRunEnd, ActivityRunStart, ActivityType, LatestOnly, PipelineName, RunEnd, RunGroupID, RunStart, Status, TriggerName, TriggerRunTimestamp}
}

// RunQueryFilterOperator enumerates the values for run query filter operator.
type RunQueryFilterOperator string

const (
	// Equals ...
	Equals RunQueryFilterOperator = "Equals"
	// In ...
	In RunQueryFilterOperator = "In"
	// NotEquals ...
	NotEquals RunQueryFilterOperator = "NotEquals"
	// NotIn ...
	NotIn RunQueryFilterOperator = "NotIn"
)

// PossibleRunQueryFilterOperatorValues returns an array of possible values for the RunQueryFilterOperator const type.
func PossibleRunQueryFilterOperatorValues() []RunQueryFilterOperator {
	return []RunQueryFilterOperator{Equals, In, NotEquals, NotIn}
}

// RunQueryOrder enumerates the values for run query order.
type RunQueryOrder string

const (
	// ASC ...
	ASC RunQueryOrder = "ASC"
	// DESC ...
	DESC RunQueryOrder = "DESC"
)

// PossibleRunQueryOrderValues returns an array of possible values for the RunQueryOrder const type.
func PossibleRunQueryOrderValues() []RunQueryOrder {
	return []RunQueryOrder{ASC, DESC}
}

// RunQueryOrderByField enumerates the values for run query order by field.
type RunQueryOrderByField string

const (
	// RunQueryOrderByFieldActivityName ...
	RunQueryOrderByFieldActivityName RunQueryOrderByField = "ActivityName"
	// RunQueryOrderByFieldActivityRunEnd ...
	RunQueryOrderByFieldActivityRunEnd RunQueryOrderByField = "ActivityRunEnd"
	// RunQueryOrderByFieldActivityRunStart ...
	RunQueryOrderByFieldActivityRunStart RunQueryOrderByField = "ActivityRunStart"
	// RunQueryOrderByFieldPipelineName ...
	RunQueryOrderByFieldPipelineName RunQueryOrderByField = "PipelineName"
	// RunQueryOrderByFieldRunEnd ...
	RunQueryOrderByFieldRunEnd RunQueryOrderByField = "RunEnd"
	// RunQueryOrderByFieldRunStart ...
	RunQueryOrderByFieldRunStart RunQueryOrderByField = "RunStart"
	// RunQueryOrderByFieldStatus ...
	RunQueryOrderByFieldStatus RunQueryOrderByField = "Status"
	// RunQueryOrderByFieldTriggerName ...
	RunQueryOrderByFieldTriggerName RunQueryOrderByField = "TriggerName"
	// RunQueryOrderByFieldTriggerRunTimestamp ...
	RunQueryOrderByFieldTriggerRunTimestamp RunQueryOrderByField = "TriggerRunTimestamp"
)

// PossibleRunQueryOrderByFieldValues returns an array of possible values for the RunQueryOrderByField const type.
func PossibleRunQueryOrderByFieldValues() []RunQueryOrderByField {
	return []RunQueryOrderByField{RunQueryOrderByFieldActivityName, RunQueryOrderByFieldActivityRunEnd, RunQueryOrderByFieldActivityRunStart, RunQueryOrderByFieldPipelineName, RunQueryOrderByFieldRunEnd, RunQueryOrderByFieldRunStart, RunQueryOrderByFieldStatus, RunQueryOrderByFieldTriggerName, RunQueryOrderByFieldTriggerRunTimestamp}
}

// SalesforceSinkWriteBehavior enumerates the values for salesforce sink write behavior.
type SalesforceSinkWriteBehavior string

const (
	// Insert ...
	Insert SalesforceSinkWriteBehavior = "Insert"
	// Upsert ...
	Upsert SalesforceSinkWriteBehavior = "Upsert"
)

// PossibleSalesforceSinkWriteBehaviorValues returns an array of possible values for the SalesforceSinkWriteBehavior const type.
func PossibleSalesforceSinkWriteBehaviorValues() []SalesforceSinkWriteBehavior {
	return []SalesforceSinkWriteBehavior{Insert, Upsert}
}

// SalesforceSourceReadBehavior enumerates the values for salesforce source read behavior.
type SalesforceSourceReadBehavior string

const (
	// Query ...
	Query SalesforceSourceReadBehavior = "Query"
	// QueryAll ...
	QueryAll SalesforceSourceReadBehavior = "QueryAll"
)

// PossibleSalesforceSourceReadBehaviorValues returns an array of possible values for the SalesforceSourceReadBehavior const type.
func PossibleSalesforceSourceReadBehaviorValues() []SalesforceSourceReadBehavior {
	return []SalesforceSourceReadBehavior{Query, QueryAll}
}

// SapCloudForCustomerSinkWriteBehavior enumerates the values for sap cloud for customer sink write behavior.
type SapCloudForCustomerSinkWriteBehavior string

const (
	// SapCloudForCustomerSinkWriteBehaviorInsert ...
	SapCloudForCustomerSinkWriteBehaviorInsert SapCloudForCustomerSinkWriteBehavior = "Insert"
	// SapCloudForCustomerSinkWriteBehaviorUpdate ...
	SapCloudForCustomerSinkWriteBehaviorUpdate SapCloudForCustomerSinkWriteBehavior = "Update"
)

// PossibleSapCloudForCustomerSinkWriteBehaviorValues returns an array of possible values for the SapCloudForCustomerSinkWriteBehavior const type.
func PossibleSapCloudForCustomerSinkWriteBehaviorValues() []SapCloudForCustomerSinkWriteBehavior {
	return []SapCloudForCustomerSinkWriteBehavior{SapCloudForCustomerSinkWriteBehaviorInsert, SapCloudForCustomerSinkWriteBehaviorUpdate}
}

// SapHanaAuthenticationType enumerates the values for sap hana authentication type.
type SapHanaAuthenticationType string

const (
	// SapHanaAuthenticationTypeBasic ...
	SapHanaAuthenticationTypeBasic SapHanaAuthenticationType = "Basic"
	// SapHanaAuthenticationTypeWindows ...
	SapHanaAuthenticationTypeWindows SapHanaAuthenticationType = "Windows"
)

// PossibleSapHanaAuthenticationTypeValues returns an array of possible values for the SapHanaAuthenticationType const type.
func PossibleSapHanaAuthenticationTypeValues() []SapHanaAuthenticationType {
	return []SapHanaAuthenticationType{SapHanaAuthenticationTypeBasic, SapHanaAuthenticationTypeWindows}
}

// SelfHostedIntegrationRuntimeNodeStatus enumerates the values for self hosted integration runtime node
// status.
type SelfHostedIntegrationRuntimeNodeStatus string

const (
	// SelfHostedIntegrationRuntimeNodeStatusInitializeFailed ...
	SelfHostedIntegrationRuntimeNodeStatusInitializeFailed SelfHostedIntegrationRuntimeNodeStatus = "InitializeFailed"
	// SelfHostedIntegrationRuntimeNodeStatusInitializing ...
	SelfHostedIntegrationRuntimeNodeStatusInitializing SelfHostedIntegrationRuntimeNodeStatus = "Initializing"
	// SelfHostedIntegrationRuntimeNodeStatusLimited ...
	SelfHostedIntegrationRuntimeNodeStatusLimited SelfHostedIntegrationRuntimeNodeStatus = "Limited"
	// SelfHostedIntegrationRuntimeNodeStatusNeedRegistration ...
	SelfHostedIntegrationRuntimeNodeStatusNeedRegistration SelfHostedIntegrationRuntimeNodeStatus = "NeedRegistration"
	// SelfHostedIntegrationRuntimeNodeStatusOffline ...
	SelfHostedIntegrationRuntimeNodeStatusOffline SelfHostedIntegrationRuntimeNodeStatus = "Offline"
	// SelfHostedIntegrationRuntimeNodeStatusOnline ...
	SelfHostedIntegrationRuntimeNodeStatusOnline SelfHostedIntegrationRuntimeNodeStatus = "Online"
	// SelfHostedIntegrationRuntimeNodeStatusUpgrading ...
	SelfHostedIntegrationRuntimeNodeStatusUpgrading SelfHostedIntegrationRuntimeNodeStatus = "Upgrading"
)

// PossibleSelfHostedIntegrationRuntimeNodeStatusValues returns an array of possible values for the SelfHostedIntegrationRuntimeNodeStatus const type.
func PossibleSelfHostedIntegrationRuntimeNodeStatusValues() []SelfHostedIntegrationRuntimeNodeStatus {
	return []SelfHostedIntegrationRuntimeNodeStatus{SelfHostedIntegrationRuntimeNodeStatusInitializeFailed, SelfHostedIntegrationRuntimeNodeStatusInitializing, SelfHostedIntegrationRuntimeNodeStatusLimited, SelfHostedIntegrationRuntimeNodeStatusNeedRegistration, SelfHostedIntegrationRuntimeNodeStatusOffline, SelfHostedIntegrationRuntimeNodeStatusOnline, SelfHostedIntegrationRuntimeNodeStatusUpgrading}
}

// ServiceNowAuthenticationType enumerates the values for service now authentication type.
type ServiceNowAuthenticationType string

const (
	// ServiceNowAuthenticationTypeBasic ...
	ServiceNowAuthenticationTypeBasic ServiceNowAuthenticationType = "Basic"
	// ServiceNowAuthenticationTypeOAuth2 ...
	ServiceNowAuthenticationTypeOAuth2 ServiceNowAuthenticationType = "OAuth2"
)

// PossibleServiceNowAuthenticationTypeValues returns an array of possible values for the ServiceNowAuthenticationType const type.
func PossibleServiceNowAuthenticationTypeValues() []ServiceNowAuthenticationType {
	return []ServiceNowAuthenticationType{ServiceNowAuthenticationTypeBasic, ServiceNowAuthenticationTypeOAuth2}
}

// SftpAuthenticationType enumerates the values for sftp authentication type.
type SftpAuthenticationType string

const (
	// SftpAuthenticationTypeBasic ...
	SftpAuthenticationTypeBasic SftpAuthenticationType = "Basic"
	// SftpAuthenticationTypeSSHPublicKey ...
	SftpAuthenticationTypeSSHPublicKey SftpAuthenticationType = "SshPublicKey"
)

// PossibleSftpAuthenticationTypeValues returns an array of possible values for the SftpAuthenticationType const type.
func PossibleSftpAuthenticationTypeValues() []SftpAuthenticationType {
	return []SftpAuthenticationType{SftpAuthenticationTypeBasic, SftpAuthenticationTypeSSHPublicKey}
}

// SparkAuthenticationType enumerates the values for spark authentication type.
type SparkAuthenticationType string

const (
	// SparkAuthenticationTypeAnonymous ...
	SparkAuthenticationTypeAnonymous SparkAuthenticationType = "Anonymous"
	// SparkAuthenticationTypeUsername ...
	SparkAuthenticationTypeUsername SparkAuthenticationType = "Username"
	// SparkAuthenticationTypeUsernameAndPassword ...
	SparkAuthenticationTypeUsernameAndPassword SparkAuthenticationType = "UsernameAndPassword"
	// SparkAuthenticationTypeWindowsAzureHDInsightService ...
	SparkAuthenticationTypeWindowsAzureHDInsightService SparkAuthenticationType = "WindowsAzureHDInsightService"
)

// PossibleSparkAuthenticationTypeValues returns an array of possible values for the SparkAuthenticationType const type.
func PossibleSparkAuthenticationTypeValues() []SparkAuthenticationType {
	return []SparkAuthenticationType{SparkAuthenticationTypeAnonymous, SparkAuthenticationTypeUsername, SparkAuthenticationTypeUsernameAndPassword, SparkAuthenticationTypeWindowsAzureHDInsightService}
}

// SparkServerType enumerates the values for spark server type.
type SparkServerType string

const (
	// SharkServer ...
	SharkServer SparkServerType = "SharkServer"
	// SharkServer2 ...
	SharkServer2 SparkServerType = "SharkServer2"
	// SparkThriftServer ...
	SparkThriftServer SparkServerType = "SparkThriftServer"
)

// PossibleSparkServerTypeValues returns an array of possible values for the SparkServerType const type.
func PossibleSparkServerTypeValues() []SparkServerType {
	return []SparkServerType{SharkServer, SharkServer2, SparkThriftServer}
}

// SparkThriftTransportProtocol enumerates the values for spark thrift transport protocol.
type SparkThriftTransportProtocol string

const (
	// SparkThriftTransportProtocolBinary ...
	SparkThriftTransportProtocolBinary SparkThriftTransportProtocol = "Binary"
	// SparkThriftTransportProtocolHTTP ...
	SparkThriftTransportProtocolHTTP SparkThriftTransportProtocol = "HTTP "
	// SparkThriftTransportProtocolSASL ...
	SparkThriftTransportProtocolSASL SparkThriftTransportProtocol = "SASL"
)

// PossibleSparkThriftTransportProtocolValues returns an array of possible values for the SparkThriftTransportProtocol const type.
func PossibleSparkThriftTransportProtocolValues() []SparkThriftTransportProtocol {
	return []SparkThriftTransportProtocol{SparkThriftTransportProtocolBinary, SparkThriftTransportProtocolHTTP, SparkThriftTransportProtocolSASL}
}

// SsisObjectMetadataType enumerates the values for ssis object metadata type.
type SsisObjectMetadataType string

const (
	// Environment ...
	Environment SsisObjectMetadataType = "Environment"
	// Folder ...
	Folder SsisObjectMetadataType = "Folder"
	// Package ...
	Package SsisObjectMetadataType = "Package"
	// Project ...
	Project SsisObjectMetadataType = "Project"
)

// PossibleSsisObjectMetadataTypeValues returns an array of possible values for the SsisObjectMetadataType const type.
func PossibleSsisObjectMetadataTypeValues() []SsisObjectMetadataType {
	return []SsisObjectMetadataType{Environment, Folder, Package, Project}
}

// StoredProcedureParameterType enumerates the values for stored procedure parameter type.
type StoredProcedureParameterType string

const (
	// Boolean ...
	Boolean StoredProcedureParameterType = "Boolean"
	// Date ...
	Date StoredProcedureParameterType = "Date"
	// Decimal ...
	Decimal StoredProcedureParameterType = "Decimal"
	// GUID ...
	GUID StoredProcedureParameterType = "Guid"
	// Int ...
	Int StoredProcedureParameterType = "Int"
	// String ...
	String StoredProcedureParameterType = "String"
)

// PossibleStoredProcedureParameterTypeValues returns an array of possible values for the StoredProcedureParameterType const type.
func PossibleStoredProcedureParameterTypeValues() []StoredProcedureParameterType {
	return []StoredProcedureParameterType{Boolean, Date, Decimal, GUID, Int, String}
}

// SybaseAuthenticationType enumerates the values for sybase authentication type.
type SybaseAuthenticationType string

const (
	// SybaseAuthenticationTypeBasic ...
	SybaseAuthenticationTypeBasic SybaseAuthenticationType = "Basic"
	// SybaseAuthenticationTypeWindows ...
	SybaseAuthenticationTypeWindows SybaseAuthenticationType = "Windows"
)

// PossibleSybaseAuthenticationTypeValues returns an array of possible values for the SybaseAuthenticationType const type.
func PossibleSybaseAuthenticationTypeValues() []SybaseAuthenticationType {
	return []SybaseAuthenticationType{SybaseAuthenticationTypeBasic, SybaseAuthenticationTypeWindows}
}

// TeradataAuthenticationType enumerates the values for teradata authentication type.
type TeradataAuthenticationType string

const (
	// TeradataAuthenticationTypeBasic ...
	TeradataAuthenticationTypeBasic TeradataAuthenticationType = "Basic"
	// TeradataAuthenticationTypeWindows ...
	TeradataAuthenticationTypeWindows TeradataAuthenticationType = "Windows"
)

// PossibleTeradataAuthenticationTypeValues returns an array of possible values for the TeradataAuthenticationType const type.
func PossibleTeradataAuthenticationTypeValues() []TeradataAuthenticationType {
	return []TeradataAuthenticationType{TeradataAuthenticationTypeBasic, TeradataAuthenticationTypeWindows}
}

// TriggerRunStatus enumerates the values for trigger run status.
type TriggerRunStatus string

const (
	// TriggerRunStatusFailed ...
	TriggerRunStatusFailed TriggerRunStatus = "Failed"
	// TriggerRunStatusInprogress ...
	TriggerRunStatusInprogress TriggerRunStatus = "Inprogress"
	// TriggerRunStatusSucceeded ...
	TriggerRunStatusSucceeded TriggerRunStatus = "Succeeded"
)

// PossibleTriggerRunStatusValues returns an array of possible values for the TriggerRunStatus const type.
func PossibleTriggerRunStatusValues() []TriggerRunStatus {
	return []TriggerRunStatus{TriggerRunStatusFailed, TriggerRunStatusInprogress, TriggerRunStatusSucceeded}
}

// TriggerRuntimeState enumerates the values for trigger runtime state.
type TriggerRuntimeState string

const (
	// TriggerRuntimeStateDisabled ...
	TriggerRuntimeStateDisabled TriggerRuntimeState = "Disabled"
	// TriggerRuntimeStateStarted ...
	TriggerRuntimeStateStarted TriggerRuntimeState = "Started"
	// TriggerRuntimeStateStopped ...
	TriggerRuntimeStateStopped TriggerRuntimeState = "Stopped"
)

// PossibleTriggerRuntimeStateValues returns an array of possible values for the TriggerRuntimeState const type.
func PossibleTriggerRuntimeStateValues() []TriggerRuntimeState {
	return []TriggerRuntimeState{TriggerRuntimeStateDisabled, TriggerRuntimeStateStarted, TriggerRuntimeStateStopped}
}

// TumblingWindowFrequency enumerates the values for tumbling window frequency.
type TumblingWindowFrequency string

const (
	// TumblingWindowFrequencyHour ...
	TumblingWindowFrequencyHour TumblingWindowFrequency = "Hour"
	// TumblingWindowFrequencyMinute ...
	TumblingWindowFrequencyMinute TumblingWindowFrequency = "Minute"
)

// PossibleTumblingWindowFrequencyValues returns an array of possible values for the TumblingWindowFrequency const type.
func PossibleTumblingWindowFrequencyValues() []TumblingWindowFrequency {
	return []TumblingWindowFrequency{TumblingWindowFrequencyHour, TumblingWindowFrequencyMinute}
}

// Type enumerates the values for type.
type Type string

const (
	// TypeAzureKeyVaultSecret ...
	TypeAzureKeyVaultSecret Type = "AzureKeyVaultSecret"
	// TypeSecretBase ...
	TypeSecretBase Type = "SecretBase"
	// TypeSecureString ...
	TypeSecureString Type = "SecureString"
)

// PossibleTypeValues returns an array of possible values for the Type const type.
func PossibleTypeValues() []Type {
	return []Type{TypeAzureKeyVaultSecret, TypeSecretBase, TypeSecureString}
}

// TypeBasicActivity enumerates the values for type basic activity.
type TypeBasicActivity string

const (
	// TypeActivity ...
	TypeActivity TypeBasicActivity = "Activity"
	// TypeAppendVariable ...
	TypeAppendVariable TypeBasicActivity = "AppendVariable"
	// TypeAzureFunctionActivity ...
	TypeAzureFunctionActivity TypeBasicActivity = "AzureFunctionActivity"
	// TypeAzureMLBatchExecution ...
	TypeAzureMLBatchExecution TypeBasicActivity = "AzureMLBatchExecution"
	// TypeAzureMLUpdateResource ...
	TypeAzureMLUpdateResource TypeBasicActivity = "AzureMLUpdateResource"
	// TypeContainer ...
	TypeContainer TypeBasicActivity = "Container"
	// TypeCopy ...
	TypeCopy TypeBasicActivity = "Copy"
	// TypeCustom ...
	TypeCustom TypeBasicActivity = "Custom"
	// TypeDatabricksNotebook ...
	TypeDatabricksNotebook TypeBasicActivity = "DatabricksNotebook"
	// TypeDatabricksSparkJar ...
	TypeDatabricksSparkJar TypeBasicActivity = "DatabricksSparkJar"
	// TypeDatabricksSparkPython ...
	TypeDatabricksSparkPython TypeBasicActivity = "DatabricksSparkPython"
	// TypeDataLakeAnalyticsUSQL ...
	TypeDataLakeAnalyticsUSQL TypeBasicActivity = "DataLakeAnalyticsU-SQL"
	// TypeDelete ...
	TypeDelete TypeBasicActivity = "Delete"
	// TypeExecutePipeline ...
	TypeExecutePipeline TypeBasicActivity = "ExecutePipeline"
	// TypeExecuteSSISPackage ...
	TypeExecuteSSISPackage TypeBasicActivity = "ExecuteSSISPackage"
	// TypeExecution ...
	TypeExecution TypeBasicActivity = "Execution"
	// TypeFilter ...
	TypeFilter TypeBasicActivity = "Filter"
	// TypeForEach ...
	TypeForEach TypeBasicActivity = "ForEach"
	// TypeGetMetadata ...
	TypeGetMetadata TypeBasicActivity = "GetMetadata"
	// TypeHDInsightHive ...
	TypeHDInsightHive TypeBasicActivity = "HDInsightHive"
	// TypeHDInsightMapReduce ...
	TypeHDInsightMapReduce TypeBasicActivity = "HDInsightMapReduce"
	// TypeHDInsightPig ...
	TypeHDInsightPig TypeBasicActivity = "HDInsightPig"
	// TypeHDInsightSpark ...
	TypeHDInsightSpark TypeBasicActivity = "HDInsightSpark"
	// TypeHDInsightStreaming ...
	TypeHDInsightStreaming TypeBasicActivity = "HDInsightStreaming"
	// TypeIfCondition ...
	TypeIfCondition TypeBasicActivity = "IfCondition"
	// TypeLookup ...
	TypeLookup TypeBasicActivity = "Lookup"
	// TypeSetVariable ...
	TypeSetVariable TypeBasicActivity = "SetVariable"
	// TypeSQLServerStoredProcedure ...
	TypeSQLServerStoredProcedure TypeBasicActivity = "SqlServerStoredProcedure"
	// TypeUntil ...
	TypeUntil TypeBasicActivity = "Until"
	// TypeValidation ...
	TypeValidation TypeBasicActivity = "Validation"
	// TypeWait ...
	TypeWait TypeBasicActivity = "Wait"
	// TypeWebActivity ...
	TypeWebActivity TypeBasicActivity = "WebActivity"
	// TypeWebHook ...
	TypeWebHook TypeBasicActivity = "WebHook"
)

// PossibleTypeBasicActivityValues returns an array of possible values for the TypeBasicActivity const type.
func PossibleTypeBasicActivityValues() []TypeBasicActivity {
	return []TypeBasicActivity{TypeActivity, TypeAppendVariable, TypeAzureFunctionActivity, TypeAzureMLBatchExecution, TypeAzureMLUpdateResource, TypeContainer, TypeCopy, TypeCustom, TypeDatabricksNotebook, TypeDatabricksSparkJar, TypeDatabricksSparkPython, TypeDataLakeAnalyticsUSQL, TypeDelete, TypeExecutePipeline, TypeExecuteSSISPackage, TypeExecution, TypeFilter, TypeForEach, TypeGetMetadata, TypeHDInsightHive, TypeHDInsightMapReduce, TypeHDInsightPig, TypeHDInsightSpark, TypeHDInsightStreaming, TypeIfCondition, TypeLookup, TypeSetVariable, TypeSQLServerStoredProcedure, TypeUntil, TypeValidation, TypeWait, TypeWebActivity, TypeWebHook}
}

// TypeBasicCopySink enumerates the values for type basic copy sink.
type TypeBasicCopySink string

const (
	// TypeAzureBlobFSSink ...
	TypeAzureBlobFSSink TypeBasicCopySink = "AzureBlobFSSink"
	// TypeAzureDataExplorerSink ...
	TypeAzureDataExplorerSink TypeBasicCopySink = "AzureDataExplorerSink"
	// TypeAzureDataLakeStoreSink ...
	TypeAzureDataLakeStoreSink TypeBasicCopySink = "AzureDataLakeStoreSink"
	// TypeAzureQueueSink ...
	TypeAzureQueueSink TypeBasicCopySink = "AzureQueueSink"
	// TypeAzureSearchIndexSink ...
	TypeAzureSearchIndexSink TypeBasicCopySink = "AzureSearchIndexSink"
	// TypeAzureTableSink ...
	TypeAzureTableSink TypeBasicCopySink = "AzureTableSink"
	// TypeBlobSink ...
	TypeBlobSink TypeBasicCopySink = "BlobSink"
	// TypeCopySink ...
	TypeCopySink TypeBasicCopySink = "CopySink"
	// TypeCosmosDbMongoDbAPISink ...
	TypeCosmosDbMongoDbAPISink TypeBasicCopySink = "CosmosDbMongoDbApiSink"
	// TypeDocumentDbCollectionSink ...
	TypeDocumentDbCollectionSink TypeBasicCopySink = "DocumentDbCollectionSink"
	// TypeDynamicsSink ...
	TypeDynamicsSink TypeBasicCopySink = "DynamicsSink"
	// TypeFileSystemSink ...
	TypeFileSystemSink TypeBasicCopySink = "FileSystemSink"
	// TypeOdbcSink ...
	TypeOdbcSink TypeBasicCopySink = "OdbcSink"
	// TypeOracleSink ...
	TypeOracleSink TypeBasicCopySink = "OracleSink"
	// TypeSalesforceSink ...
	TypeSalesforceSink TypeBasicCopySink = "SalesforceSink"
	// TypeSapCloudForCustomerSink ...
	TypeSapCloudForCustomerSink TypeBasicCopySink = "SapCloudForCustomerSink"
	// TypeSQLDWSink ...
	TypeSQLDWSink TypeBasicCopySink = "SqlDWSink"
	// TypeSQLSink ...
	TypeSQLSink TypeBasicCopySink = "SqlSink"
)

// PossibleTypeBasicCopySinkValues returns an array of possible values for the TypeBasicCopySink const type.
func PossibleTypeBasicCopySinkValues() []TypeBasicCopySink {
	return []TypeBasicCopySink{TypeAzureBlobFSSink, TypeAzureDataExplorerSink, TypeAzureDataLakeStoreSink, TypeAzureQueueSink, TypeAzureSearchIndexSink, TypeAzureTableSink, TypeBlobSink, TypeCopySink, TypeCosmosDbMongoDbAPISink, TypeDocumentDbCollectionSink, TypeDynamicsSink, TypeFileSystemSink, TypeOdbcSink, TypeOracleSink, TypeSalesforceSink, TypeSapCloudForCustomerSink, TypeSQLDWSink, TypeSQLSink}
}

// TypeBasicCopySource enumerates the values for type basic copy source.
type TypeBasicCopySource string

const (
	// TypeAmazonMWSSource ...
	TypeAmazonMWSSource TypeBasicCopySource = "AmazonMWSSource"
	// TypeAmazonRedshiftSource ...
	TypeAmazonRedshiftSource TypeBasicCopySource = "AmazonRedshiftSource"
	// TypeAzureBlobFSSource ...
	TypeAzureBlobFSSource TypeBasicCopySource = "AzureBlobFSSource"
	// TypeAzureDataExplorerSource ...
	TypeAzureDataExplorerSource TypeBasicCopySource = "AzureDataExplorerSource"
	// TypeAzureDataLakeStoreSource ...
	TypeAzureDataLakeStoreSource TypeBasicCopySource = "AzureDataLakeStoreSource"
	// TypeAzureMySQLSource ...
	TypeAzureMySQLSource TypeBasicCopySource = "AzureMySqlSource"
	// TypeAzurePostgreSQLSource ...
	TypeAzurePostgreSQLSource TypeBasicCopySource = "AzurePostgreSqlSource"
	// TypeAzureTableSource ...
	TypeAzureTableSource TypeBasicCopySource = "AzureTableSource"
	// TypeBlobSource ...
	TypeBlobSource TypeBasicCopySource = "BlobSource"
	// TypeCassandraSource ...
	TypeCassandraSource TypeBasicCopySource = "CassandraSource"
	// TypeConcurSource ...
	TypeConcurSource TypeBasicCopySource = "ConcurSource"
	// TypeCopySource ...
	TypeCopySource TypeBasicCopySource = "CopySource"
	// TypeCosmosDbMongoDbAPISource ...
	TypeCosmosDbMongoDbAPISource TypeBasicCopySource = "CosmosDbMongoDbApiSource"
	// TypeCouchbaseSource ...
	TypeCouchbaseSource TypeBasicCopySource = "CouchbaseSource"
	// TypeDocumentDbCollectionSource ...
	TypeDocumentDbCollectionSource TypeBasicCopySource = "DocumentDbCollectionSource"
	// TypeDrillSource ...
	TypeDrillSource TypeBasicCopySource = "DrillSource"
	// TypeDynamicsAXSource ...
	TypeDynamicsAXSource TypeBasicCopySource = "DynamicsAXSource"
	// TypeDynamicsSource ...
	TypeDynamicsSource TypeBasicCopySource = "DynamicsSource"
	// TypeEloquaSource ...
	TypeEloquaSource TypeBasicCopySource = "EloquaSource"
	// TypeFileSystemSource ...
	TypeFileSystemSource TypeBasicCopySource = "FileSystemSource"
	// TypeGoogleAdWordsSource ...
	TypeGoogleAdWordsSource TypeBasicCopySource = "GoogleAdWordsSource"
	// TypeGoogleBigQuerySource ...
	TypeGoogleBigQuerySource TypeBasicCopySource = "GoogleBigQuerySource"
	// TypeGreenplumSource ...
	TypeGreenplumSource TypeBasicCopySource = "GreenplumSource"
	// TypeHBaseSource ...
	TypeHBaseSource TypeBasicCopySource = "HBaseSource"
	// TypeHdfsSource ...
	TypeHdfsSource TypeBasicCopySource = "HdfsSource"
	// TypeHiveSource ...
	TypeHiveSource TypeBasicCopySource = "HiveSource"
	// TypeHTTPSource ...
	TypeHTTPSource TypeBasicCopySource = "HttpSource"
	// TypeHubspotSource ...
	TypeHubspotSource TypeBasicCopySource = "HubspotSource"
	// TypeImpalaSource ...
	TypeImpalaSource TypeBasicCopySource = "ImpalaSource"
	// TypeJiraSource ...
	TypeJiraSource TypeBasicCopySource = "JiraSource"
	// TypeMagentoSource ...
	TypeMagentoSource TypeBasicCopySource = "MagentoSource"
	// TypeMariaDBSource ...
	TypeMariaDBSource TypeBasicCopySource = "MariaDBSource"
	// TypeMarketoSource ...
	TypeMarketoSource TypeBasicCopySource = "MarketoSource"
	// TypeMongoDbSource ...
	TypeMongoDbSource TypeBasicCopySource = "MongoDbSource"
	// TypeMongoDbV2Source ...
	TypeMongoDbV2Source TypeBasicCopySource = "MongoDbV2Source"
	// TypeNetezzaSource ...
	TypeNetezzaSource TypeBasicCopySource = "NetezzaSource"
	// TypeOffice365Source ...
	TypeOffice365Source TypeBasicCopySource = "Office365Source"
	// TypeOracleServiceCloudSource ...
	TypeOracleServiceCloudSource TypeBasicCopySource = "OracleServiceCloudSource"
	// TypeOracleSource ...
	TypeOracleSource TypeBasicCopySource = "OracleSource"
	// TypePaypalSource ...
	TypePaypalSource TypeBasicCopySource = "PaypalSource"
	// TypePhoenixSource ...
	TypePhoenixSource TypeBasicCopySource = "PhoenixSource"
	// TypePrestoSource ...
	TypePrestoSource TypeBasicCopySource = "PrestoSource"
	// TypeQuickBooksSource ...
	TypeQuickBooksSource TypeBasicCopySource = "QuickBooksSource"
	// TypeRelationalSource ...
	TypeRelationalSource TypeBasicCopySource = "RelationalSource"
	// TypeResponsysSource ...
	TypeResponsysSource TypeBasicCopySource = "ResponsysSource"
	// TypeRestSource ...
	TypeRestSource TypeBasicCopySource = "RestSource"
	// TypeSalesforceMarketingCloudSource ...
	TypeSalesforceMarketingCloudSource TypeBasicCopySource = "SalesforceMarketingCloudSource"
	// TypeSalesforceSource ...
	TypeSalesforceSource TypeBasicCopySource = "SalesforceSource"
	// TypeSapCloudForCustomerSource ...
	TypeSapCloudForCustomerSource TypeBasicCopySource = "SapCloudForCustomerSource"
	// TypeSapEccSource ...
	TypeSapEccSource TypeBasicCopySource = "SapEccSource"
	// TypeSapOpenHubSource ...
	TypeSapOpenHubSource TypeBasicCopySource = "SapOpenHubSource"
	// TypeServiceNowSource ...
	TypeServiceNowSource TypeBasicCopySource = "ServiceNowSource"
	// TypeShopifySource ...
	TypeShopifySource TypeBasicCopySource = "ShopifySource"
	// TypeSparkSource ...
	TypeSparkSource TypeBasicCopySource = "SparkSource"
	// TypeSQLDWSource ...
	TypeSQLDWSource TypeBasicCopySource = "SqlDWSource"
	// TypeSQLSource ...
	TypeSQLSource TypeBasicCopySource = "SqlSource"
	// TypeSquareSource ...
	TypeSquareSource TypeBasicCopySource = "SquareSource"
	// TypeVerticaSource ...
	TypeVerticaSource TypeBasicCopySource = "VerticaSource"
	// TypeWebSource ...
	TypeWebSource TypeBasicCopySource = "WebSource"
	// TypeXeroSource ...
	TypeXeroSource TypeBasicCopySource = "XeroSource"
	// TypeZohoSource ...
	TypeZohoSource TypeBasicCopySource = "ZohoSource"
)

// PossibleTypeBasicCopySourceValues returns an array of possible values for the TypeBasicCopySource const type.
func PossibleTypeBasicCopySourceValues() []TypeBasicCopySource {
	return []TypeBasicCopySource{TypeAmazonMWSSource, TypeAmazonRedshiftSource, TypeAzureBlobFSSource, TypeAzureDataExplorerSource, TypeAzureDataLakeStoreSource, TypeAzureMySQLSource, TypeAzurePostgreSQLSource, TypeAzureTableSource, TypeBlobSource, TypeCassandraSource, TypeConcurSource, TypeCopySource, TypeCosmosDbMongoDbAPISource, TypeCouchbaseSource, TypeDocumentDbCollectionSource, TypeDrillSource, TypeDynamicsAXSource, TypeDynamicsSource, TypeEloquaSource, TypeFileSystemSource, TypeGoogleAdWordsSource, TypeGoogleBigQuerySource, TypeGreenplumSource, TypeHBaseSource, TypeHdfsSource, TypeHiveSource, TypeHTTPSource, TypeHubspotSource, TypeImpalaSource, TypeJiraSource, TypeMagentoSource, TypeMariaDBSource, TypeMarketoSource, TypeMongoDbSource, TypeMongoDbV2Source, TypeNetezzaSource, TypeOffice365Source, TypeOracleServiceCloudSource, TypeOracleSource, TypePaypalSource, TypePhoenixSource, TypePrestoSource, TypeQuickBooksSource, TypeRelationalSource, TypeResponsysSource, TypeRestSource, TypeSalesforceMarketingCloudSource, TypeSalesforceSource, TypeSapCloudForCustomerSource, TypeSapEccSource, TypeSapOpenHubSource, TypeServiceNowSource, TypeShopifySource, TypeSparkSource, TypeSQLDWSource, TypeSQLSource, TypeSquareSource, TypeVerticaSource, TypeWebSource, TypeXeroSource, TypeZohoSource}
}

// TypeBasicCopyTranslator enumerates the values for type basic copy translator.
type TypeBasicCopyTranslator string

const (
	// TypeCopyTranslator ...
	TypeCopyTranslator TypeBasicCopyTranslator = "CopyTranslator"
	// TypeTabularTranslator ...
	TypeTabularTranslator TypeBasicCopyTranslator = "TabularTranslator"
)

// PossibleTypeBasicCopyTranslatorValues returns an array of possible values for the TypeBasicCopyTranslator const type.
func PossibleTypeBasicCopyTranslatorValues() []TypeBasicCopyTranslator {
	return []TypeBasicCopyTranslator{TypeCopyTranslator, TypeTabularTranslator}
}

// TypeBasicDataset enumerates the values for type basic dataset.
type TypeBasicDataset string

const (
	// TypeAmazonMWSObject ...
	TypeAmazonMWSObject TypeBasicDataset = "AmazonMWSObject"
	// TypeAmazonS3Object ...
	TypeAmazonS3Object TypeBasicDataset = "AmazonS3Object"
	// TypeAzureBlob ...
	TypeAzureBlob TypeBasicDataset = "AzureBlob"
	// TypeAzureBlobFSFile ...
	TypeAzureBlobFSFile TypeBasicDataset = "AzureBlobFSFile"
	// TypeAzureDataExplorerTable ...
	TypeAzureDataExplorerTable TypeBasicDataset = "AzureDataExplorerTable"
	// TypeAzureDataLakeStoreFile ...
	TypeAzureDataLakeStoreFile TypeBasicDataset = "AzureDataLakeStoreFile"
	// TypeAzureMySQLTable ...
	TypeAzureMySQLTable TypeBasicDataset = "AzureMySqlTable"
	// TypeAzurePostgreSQLTable ...
	TypeAzurePostgreSQLTable TypeBasicDataset = "AzurePostgreSqlTable"
	// TypeAzureSearchIndex ...
	TypeAzureSearchIndex TypeBasicDataset = "AzureSearchIndex"
	// TypeAzureSQLDWTable ...
	TypeAzureSQLDWTable TypeBasicDataset = "AzureSqlDWTable"
	// TypeAzureSQLTable ...
	TypeAzureSQLTable TypeBasicDataset = "AzureSqlTable"
	// TypeAzureTable ...
	TypeAzureTable TypeBasicDataset = "AzureTable"
	// TypeCassandraTable ...
	TypeCassandraTable TypeBasicDataset = "CassandraTable"
	// TypeConcurObject ...
	TypeConcurObject TypeBasicDataset = "ConcurObject"
	// TypeCosmosDbMongoDbAPICollection ...
	TypeCosmosDbMongoDbAPICollection TypeBasicDataset = "CosmosDbMongoDbApiCollection"
	// TypeCouchbaseTable ...
	TypeCouchbaseTable TypeBasicDataset = "CouchbaseTable"
	// TypeCustomDataset ...
	TypeCustomDataset TypeBasicDataset = "CustomDataset"
	// TypeDataset ...
	TypeDataset TypeBasicDataset = "Dataset"
	// TypeDocumentDbCollection ...
	TypeDocumentDbCollection TypeBasicDataset = "DocumentDbCollection"
	// TypeDrillTable ...
	TypeDrillTable TypeBasicDataset = "DrillTable"
	// TypeDynamicsAXResource ...
	TypeDynamicsAXResource TypeBasicDataset = "DynamicsAXResource"
	// TypeDynamicsEntity ...
	TypeDynamicsEntity TypeBasicDataset = "DynamicsEntity"
	// TypeEloquaObject ...
	TypeEloquaObject TypeBasicDataset = "EloquaObject"
	// TypeFileShare ...
	TypeFileShare TypeBasicDataset = "FileShare"
	// TypeGoogleAdWordsObject ...
	TypeGoogleAdWordsObject TypeBasicDataset = "GoogleAdWordsObject"
	// TypeGoogleBigQueryObject ...
	TypeGoogleBigQueryObject TypeBasicDataset = "GoogleBigQueryObject"
	// TypeGreenplumTable ...
	TypeGreenplumTable TypeBasicDataset = "GreenplumTable"
	// TypeHBaseObject ...
	TypeHBaseObject TypeBasicDataset = "HBaseObject"
	// TypeHiveObject ...
	TypeHiveObject TypeBasicDataset = "HiveObject"
	// TypeHTTPFile ...
	TypeHTTPFile TypeBasicDataset = "HttpFile"
	// TypeHubspotObject ...
	TypeHubspotObject TypeBasicDataset = "HubspotObject"
	// TypeImpalaObject ...
	TypeImpalaObject TypeBasicDataset = "ImpalaObject"
	// TypeJiraObject ...
	TypeJiraObject TypeBasicDataset = "JiraObject"
	// TypeMagentoObject ...
	TypeMagentoObject TypeBasicDataset = "MagentoObject"
	// TypeMariaDBTable ...
	TypeMariaDBTable TypeBasicDataset = "MariaDBTable"
	// TypeMarketoObject ...
	TypeMarketoObject TypeBasicDataset = "MarketoObject"
	// TypeMongoDbCollection ...
	TypeMongoDbCollection TypeBasicDataset = "MongoDbCollection"
	// TypeMongoDbV2Collection ...
	TypeMongoDbV2Collection TypeBasicDataset = "MongoDbV2Collection"
	// TypeNetezzaTable ...
	TypeNetezzaTable TypeBasicDataset = "NetezzaTable"
	// TypeODataResource ...
	TypeODataResource TypeBasicDataset = "ODataResource"
	// TypeOffice365Table ...
	TypeOffice365Table TypeBasicDataset = "Office365Table"
	// TypeOracleServiceCloudObject ...
	TypeOracleServiceCloudObject TypeBasicDataset = "OracleServiceCloudObject"
	// TypeOracleTable ...
	TypeOracleTable TypeBasicDataset = "OracleTable"
	// TypePaypalObject ...
	TypePaypalObject TypeBasicDataset = "PaypalObject"
	// TypePhoenixObject ...
	TypePhoenixObject TypeBasicDataset = "PhoenixObject"
	// TypePrestoObject ...
	TypePrestoObject TypeBasicDataset = "PrestoObject"
	// TypeQuickBooksObject ...
	TypeQuickBooksObject TypeBasicDataset = "QuickBooksObject"
	// TypeRelationalTable ...
	TypeRelationalTable TypeBasicDataset = "RelationalTable"
	// TypeResponsysObject ...
	TypeResponsysObject TypeBasicDataset = "ResponsysObject"
	// TypeRestResource ...
	TypeRestResource TypeBasicDataset = "RestResource"
	// TypeSalesforceMarketingCloudObject ...
	TypeSalesforceMarketingCloudObject TypeBasicDataset = "SalesforceMarketingCloudObject"
	// TypeSalesforceObject ...
	TypeSalesforceObject TypeBasicDataset = "SalesforceObject"
	// TypeSapCloudForCustomerResource ...
	TypeSapCloudForCustomerResource TypeBasicDataset = "SapCloudForCustomerResource"
	// TypeSapEccResource ...
	TypeSapEccResource TypeBasicDataset = "SapEccResource"
	// TypeSapOpenHubTable ...
	TypeSapOpenHubTable TypeBasicDataset = "SapOpenHubTable"
	// TypeServiceNowObject ...
	TypeServiceNowObject TypeBasicDataset = "ServiceNowObject"
	// TypeShopifyObject ...
	TypeShopifyObject TypeBasicDataset = "ShopifyObject"
	// TypeSparkObject ...
	TypeSparkObject TypeBasicDataset = "SparkObject"
	// TypeSQLServerTable ...
	TypeSQLServerTable TypeBasicDataset = "SqlServerTable"
	// TypeSquareObject ...
	TypeSquareObject TypeBasicDataset = "SquareObject"
	// TypeVerticaTable ...
	TypeVerticaTable TypeBasicDataset = "VerticaTable"
	// TypeWebTable ...
	TypeWebTable TypeBasicDataset = "WebTable"
	// TypeXeroObject ...
	TypeXeroObject TypeBasicDataset = "XeroObject"
	// TypeZohoObject ...
	TypeZohoObject TypeBasicDataset = "ZohoObject"
)

// PossibleTypeBasicDatasetValues returns an array of possible values for the TypeBasicDataset const type.
func PossibleTypeBasicDatasetValues() []TypeBasicDataset {
	return []TypeBasicDataset{TypeAmazonMWSObject, TypeAmazonS3Object, TypeAzureBlob, TypeAzureBlobFSFile, TypeAzureDataExplorerTable, TypeAzureDataLakeStoreFile, TypeAzureMySQLTable, TypeAzurePostgreSQLTable, TypeAzureSearchIndex, TypeAzureSQLDWTable, TypeAzureSQLTable, TypeAzureTable, TypeCassandraTable, TypeConcurObject, TypeCosmosDbMongoDbAPICollection, TypeCouchbaseTable, TypeCustomDataset, TypeDataset, TypeDocumentDbCollection, TypeDrillTable, TypeDynamicsAXResource, TypeDynamicsEntity, TypeEloquaObject, TypeFileShare, TypeGoogleAdWordsObject, TypeGoogleBigQueryObject, TypeGreenplumTable, TypeHBaseObject, TypeHiveObject, TypeHTTPFile, TypeHubspotObject, TypeImpalaObject, TypeJiraObject, TypeMagentoObject, TypeMariaDBTable, TypeMarketoObject, TypeMongoDbCollection, TypeMongoDbV2Collection, TypeNetezzaTable, TypeODataResource, TypeOffice365Table, TypeOracleServiceCloudObject, TypeOracleTable, TypePaypalObject, TypePhoenixObject, TypePrestoObject, TypeQuickBooksObject, TypeRelationalTable, TypeResponsysObject, TypeRestResource, TypeSalesforceMarketingCloudObject, TypeSalesforceObject, TypeSapCloudForCustomerResource, TypeSapEccResource, TypeSapOpenHubTable, TypeServiceNowObject, TypeShopifyObject, TypeSparkObject, TypeSQLServerTable, TypeSquareObject, TypeVerticaTable, TypeWebTable, TypeXeroObject, TypeZohoObject}
}

// TypeBasicDatasetCompression enumerates the values for type basic dataset compression.
type TypeBasicDatasetCompression string

const (
	// TypeBZip2 ...
	TypeBZip2 TypeBasicDatasetCompression = "BZip2"
	// TypeDatasetCompression ...
	TypeDatasetCompression TypeBasicDatasetCompression = "DatasetCompression"
	// TypeDeflate ...
	TypeDeflate TypeBasicDatasetCompression = "Deflate"
	// TypeGZip ...
	TypeGZip TypeBasicDatasetCompression = "GZip"
	// TypeZipDeflate ...
	TypeZipDeflate TypeBasicDatasetCompression = "ZipDeflate"
)

// PossibleTypeBasicDatasetCompressionValues returns an array of possible values for the TypeBasicDatasetCompression const type.
func PossibleTypeBasicDatasetCompressionValues() []TypeBasicDatasetCompression {
	return []TypeBasicDatasetCompression{TypeBZip2, TypeDatasetCompression, TypeDeflate, TypeGZip, TypeZipDeflate}
}

// TypeBasicDatasetStorageFormat enumerates the values for type basic dataset storage format.
type TypeBasicDatasetStorageFormat string

const (
	// TypeAvroFormat ...
	TypeAvroFormat TypeBasicDatasetStorageFormat = "AvroFormat"
	// TypeDatasetStorageFormat ...
	TypeDatasetStorageFormat TypeBasicDatasetStorageFormat = "DatasetStorageFormat"
	// TypeJSONFormat ...
	TypeJSONFormat TypeBasicDatasetStorageFormat = "JsonFormat"
	// TypeOrcFormat ...
	TypeOrcFormat TypeBasicDatasetStorageFormat = "OrcFormat"
	// TypeParquetFormat ...
	TypeParquetFormat TypeBasicDatasetStorageFormat = "ParquetFormat"
	// TypeTextFormat ...
	TypeTextFormat TypeBasicDatasetStorageFormat = "TextFormat"
)

// PossibleTypeBasicDatasetStorageFormatValues returns an array of possible values for the TypeBasicDatasetStorageFormat const type.
func PossibleTypeBasicDatasetStorageFormatValues() []TypeBasicDatasetStorageFormat {
	return []TypeBasicDatasetStorageFormat{TypeAvroFormat, TypeDatasetStorageFormat, TypeJSONFormat, TypeOrcFormat, TypeParquetFormat, TypeTextFormat}
}

// TypeBasicDependencyReference enumerates the values for type basic dependency reference.
type TypeBasicDependencyReference string

const (
	// TypeDependencyReference ...
	TypeDependencyReference TypeBasicDependencyReference = "DependencyReference"
	// TypeSelfDependencyTumblingWindowTriggerReference ...
	TypeSelfDependencyTumblingWindowTriggerReference TypeBasicDependencyReference = "SelfDependencyTumblingWindowTriggerReference"
	// TypeTriggerDependencyReference ...
	TypeTriggerDependencyReference TypeBasicDependencyReference = "TriggerDependencyReference"
	// TypeTumblingWindowTriggerDependencyReference ...
	TypeTumblingWindowTriggerDependencyReference TypeBasicDependencyReference = "TumblingWindowTriggerDependencyReference"
)

// PossibleTypeBasicDependencyReferenceValues returns an array of possible values for the TypeBasicDependencyReference const type.
func PossibleTypeBasicDependencyReferenceValues() []TypeBasicDependencyReference {
	return []TypeBasicDependencyReference{TypeDependencyReference, TypeSelfDependencyTumblingWindowTriggerReference, TypeTriggerDependencyReference, TypeTumblingWindowTriggerDependencyReference}
}

// TypeBasicFactoryRepoConfiguration enumerates the values for type basic factory repo configuration.
type TypeBasicFactoryRepoConfiguration string

const (
	// TypeFactoryGitHubConfiguration ...
	TypeFactoryGitHubConfiguration TypeBasicFactoryRepoConfiguration = "FactoryGitHubConfiguration"
	// TypeFactoryRepoConfiguration ...
	TypeFactoryRepoConfiguration TypeBasicFactoryRepoConfiguration = "FactoryRepoConfiguration"
	// TypeFactoryVSTSConfiguration ...
	TypeFactoryVSTSConfiguration TypeBasicFactoryRepoConfiguration = "FactoryVSTSConfiguration"
)

// PossibleTypeBasicFactoryRepoConfigurationValues returns an array of possible values for the TypeBasicFactoryRepoConfiguration const type.
func PossibleTypeBasicFactoryRepoConfigurationValues() []TypeBasicFactoryRepoConfiguration {
	return []TypeBasicFactoryRepoConfiguration{TypeFactoryGitHubConfiguration, TypeFactoryRepoConfiguration, TypeFactoryVSTSConfiguration}
}

// TypeBasicIntegrationRuntime enumerates the values for type basic integration runtime.
type TypeBasicIntegrationRuntime string

const (
	// TypeIntegrationRuntime ...
	TypeIntegrationRuntime TypeBasicIntegrationRuntime = "IntegrationRuntime"
	// TypeManaged ...
	TypeManaged TypeBasicIntegrationRuntime = "Managed"
	// TypeSelfHosted ...
	TypeSelfHosted TypeBasicIntegrationRuntime = "SelfHosted"
)

// PossibleTypeBasicIntegrationRuntimeValues returns an array of possible values for the TypeBasicIntegrationRuntime const type.
func PossibleTypeBasicIntegrationRuntimeValues() []TypeBasicIntegrationRuntime {
	return []TypeBasicIntegrationRuntime{TypeIntegrationRuntime, TypeManaged, TypeSelfHosted}
}

// TypeBasicIntegrationRuntimeStatus enumerates the values for type basic integration runtime status.
type TypeBasicIntegrationRuntimeStatus string

const (
	// TypeBasicIntegrationRuntimeStatusTypeIntegrationRuntimeStatus ...
	TypeBasicIntegrationRuntimeStatusTypeIntegrationRuntimeStatus TypeBasicIntegrationRuntimeStatus = "IntegrationRuntimeStatus"
	// TypeBasicIntegrationRuntimeStatusTypeManaged ...
	TypeBasicIntegrationRuntimeStatusTypeManaged TypeBasicIntegrationRuntimeStatus = "Managed"
	// TypeBasicIntegrationRuntimeStatusTypeSelfHosted ...
	TypeBasicIntegrationRuntimeStatusTypeSelfHosted TypeBasicIntegrationRuntimeStatus = "SelfHosted"
)

// PossibleTypeBasicIntegrationRuntimeStatusValues returns an array of possible values for the TypeBasicIntegrationRuntimeStatus const type.
func PossibleTypeBasicIntegrationRuntimeStatusValues() []TypeBasicIntegrationRuntimeStatus {
	return []TypeBasicIntegrationRuntimeStatus{TypeBasicIntegrationRuntimeStatusTypeIntegrationRuntimeStatus, TypeBasicIntegrationRuntimeStatusTypeManaged, TypeBasicIntegrationRuntimeStatusTypeSelfHosted}
}

// TypeBasicLinkedService enumerates the values for type basic linked service.
type TypeBasicLinkedService string

const (
	// TypeAmazonMWS ...
	TypeAmazonMWS TypeBasicLinkedService = "AmazonMWS"
	// TypeAmazonRedshift ...
	TypeAmazonRedshift TypeBasicLinkedService = "AmazonRedshift"
	// TypeAmazonS3 ...
	TypeAmazonS3 TypeBasicLinkedService = "AmazonS3"
	// TypeAzureBatch ...
	TypeAzureBatch TypeBasicLinkedService = "AzureBatch"
	// TypeAzureBlobFS ...
	TypeAzureBlobFS TypeBasicLinkedService = "AzureBlobFS"
	// TypeAzureBlobStorage ...
	TypeAzureBlobStorage TypeBasicLinkedService = "AzureBlobStorage"
	// TypeAzureDatabricks ...
	TypeAzureDatabricks TypeBasicLinkedService = "AzureDatabricks"
	// TypeAzureDataExplorer ...
	TypeAzureDataExplorer TypeBasicLinkedService = "AzureDataExplorer"
	// TypeAzureDataLakeAnalytics ...
	TypeAzureDataLakeAnalytics TypeBasicLinkedService = "AzureDataLakeAnalytics"
	// TypeAzureDataLakeStore ...
	TypeAzureDataLakeStore TypeBasicLinkedService = "AzureDataLakeStore"
	// TypeAzureFunction ...
	TypeAzureFunction TypeBasicLinkedService = "AzureFunction"
	// TypeAzureKeyVault ...
	TypeAzureKeyVault TypeBasicLinkedService = "AzureKeyVault"
	// TypeAzureML ...
	TypeAzureML TypeBasicLinkedService = "AzureML"
	// TypeAzureMySQL ...
	TypeAzureMySQL TypeBasicLinkedService = "AzureMySql"
	// TypeAzurePostgreSQL ...
	TypeAzurePostgreSQL TypeBasicLinkedService = "AzurePostgreSql"
	// TypeAzureSearch ...
	TypeAzureSearch TypeBasicLinkedService = "AzureSearch"
	// TypeAzureSQLDatabase ...
	TypeAzureSQLDatabase TypeBasicLinkedService = "AzureSqlDatabase"
	// TypeAzureSQLDW ...
	TypeAzureSQLDW TypeBasicLinkedService = "AzureSqlDW"
	// TypeAzureStorage ...
	TypeAzureStorage TypeBasicLinkedService = "AzureStorage"
	// TypeAzureTableStorage ...
	TypeAzureTableStorage TypeBasicLinkedService = "AzureTableStorage"
	// TypeCassandra ...
	TypeCassandra TypeBasicLinkedService = "Cassandra"
	// TypeConcur ...
	TypeConcur TypeBasicLinkedService = "Concur"
	// TypeCosmosDb ...
	TypeCosmosDb TypeBasicLinkedService = "CosmosDb"
	// TypeCosmosDbMongoDbAPI ...
	TypeCosmosDbMongoDbAPI TypeBasicLinkedService = "CosmosDbMongoDbApi"
	// TypeCouchbase ...
	TypeCouchbase TypeBasicLinkedService = "Couchbase"
	// TypeCustomDataSource ...
	TypeCustomDataSource TypeBasicLinkedService = "CustomDataSource"
	// TypeDb2 ...
	TypeDb2 TypeBasicLinkedService = "Db2"
	// TypeDrill ...
	TypeDrill TypeBasicLinkedService = "Drill"
	// TypeDynamics ...
	TypeDynamics TypeBasicLinkedService = "Dynamics"
	// TypeDynamicsAX ...
	TypeDynamicsAX TypeBasicLinkedService = "DynamicsAX"
	// TypeEloqua ...
	TypeEloqua TypeBasicLinkedService = "Eloqua"
	// TypeFileServer ...
	TypeFileServer TypeBasicLinkedService = "FileServer"
	// TypeFtpServer ...
	TypeFtpServer TypeBasicLinkedService = "FtpServer"
	// TypeGoogleAdWords ...
	TypeGoogleAdWords TypeBasicLinkedService = "GoogleAdWords"
	// TypeGoogleBigQuery ...
	TypeGoogleBigQuery TypeBasicLinkedService = "GoogleBigQuery"
	// TypeGreenplum ...
	TypeGreenplum TypeBasicLinkedService = "Greenplum"
	// TypeHBase ...
	TypeHBase TypeBasicLinkedService = "HBase"
	// TypeHdfs ...
	TypeHdfs TypeBasicLinkedService = "Hdfs"
	// TypeHDInsight ...
	TypeHDInsight TypeBasicLinkedService = "HDInsight"
	// TypeHDInsightOnDemand ...
	TypeHDInsightOnDemand TypeBasicLinkedService = "HDInsightOnDemand"
	// TypeHive ...
	TypeHive TypeBasicLinkedService = "Hive"
	// TypeHTTPServer ...
	TypeHTTPServer TypeBasicLinkedService = "HttpServer"
	// TypeHubspot ...
	TypeHubspot TypeBasicLinkedService = "Hubspot"
	// TypeImpala ...
	TypeImpala TypeBasicLinkedService = "Impala"
	// TypeJira ...
	TypeJira TypeBasicLinkedService = "Jira"
	// TypeLinkedService ...
	TypeLinkedService TypeBasicLinkedService = "LinkedService"
	// TypeMagento ...
	TypeMagento TypeBasicLinkedService = "Magento"
	// TypeMariaDB ...
	TypeMariaDB TypeBasicLinkedService = "MariaDB"
	// TypeMarketo ...
	TypeMarketo TypeBasicLinkedService = "Marketo"
	// TypeMongoDb ...
	TypeMongoDb TypeBasicLinkedService = "MongoDb"
	// TypeMongoDbV2 ...
	TypeMongoDbV2 TypeBasicLinkedService = "MongoDbV2"
	// TypeMySQL ...
	TypeMySQL TypeBasicLinkedService = "MySql"
	// TypeNetezza ...
	TypeNetezza TypeBasicLinkedService = "Netezza"
	// TypeOData ...
	TypeOData TypeBasicLinkedService = "OData"
	// TypeOdbc ...
	TypeOdbc TypeBasicLinkedService = "Odbc"
	// TypeOffice365 ...
	TypeOffice365 TypeBasicLinkedService = "Office365"
	// TypeOracle ...
	TypeOracle TypeBasicLinkedService = "Oracle"
	// TypeOracleServiceCloud ...
	TypeOracleServiceCloud TypeBasicLinkedService = "OracleServiceCloud"
	// TypePaypal ...
	TypePaypal TypeBasicLinkedService = "Paypal"
	// TypePhoenix ...
	TypePhoenix TypeBasicLinkedService = "Phoenix"
	// TypePostgreSQL ...
	TypePostgreSQL TypeBasicLinkedService = "PostgreSql"
	// TypePresto ...
	TypePresto TypeBasicLinkedService = "Presto"
	// TypeQuickBooks ...
	TypeQuickBooks TypeBasicLinkedService = "QuickBooks"
	// TypeResponsys ...
	TypeResponsys TypeBasicLinkedService = "Responsys"
	// TypeRestService ...
	TypeRestService TypeBasicLinkedService = "RestService"
	// TypeSalesforce ...
	TypeSalesforce TypeBasicLinkedService = "Salesforce"
	// TypeSalesforceMarketingCloud ...
	TypeSalesforceMarketingCloud TypeBasicLinkedService = "SalesforceMarketingCloud"
	// TypeSapBW ...
	TypeSapBW TypeBasicLinkedService = "SapBW"
	// TypeSapCloudForCustomer ...
	TypeSapCloudForCustomer TypeBasicLinkedService = "SapCloudForCustomer"
	// TypeSapEcc ...
	TypeSapEcc TypeBasicLinkedService = "SapEcc"
	// TypeSapHana ...
	TypeSapHana TypeBasicLinkedService = "SapHana"
	// TypeSapOpenHub ...
	TypeSapOpenHub TypeBasicLinkedService = "SapOpenHub"
	// TypeServiceNow ...
	TypeServiceNow TypeBasicLinkedService = "ServiceNow"
	// TypeSftp ...
	TypeSftp TypeBasicLinkedService = "Sftp"
	// TypeShopify ...
	TypeShopify TypeBasicLinkedService = "Shopify"
	// TypeSpark ...
	TypeSpark TypeBasicLinkedService = "Spark"
	// TypeSQLServer ...
	TypeSQLServer TypeBasicLinkedService = "SqlServer"
	// TypeSquare ...
	TypeSquare TypeBasicLinkedService = "Square"
	// TypeSybase ...
	TypeSybase TypeBasicLinkedService = "Sybase"
	// TypeTeradata ...
	TypeTeradata TypeBasicLinkedService = "Teradata"
	// TypeVertica ...
	TypeVertica TypeBasicLinkedService = "Vertica"
	// TypeWeb ...
	TypeWeb TypeBasicLinkedService = "Web"
	// TypeXero ...
	TypeXero TypeBasicLinkedService = "Xero"
	// TypeZoho ...
	TypeZoho TypeBasicLinkedService = "Zoho"
)

// PossibleTypeBasicLinkedServiceValues returns an array of possible values for the TypeBasicLinkedService const type.
func PossibleTypeBasicLinkedServiceValues() []TypeBasicLinkedService {
	return []TypeBasicLinkedService{TypeAmazonMWS, TypeAmazonRedshift, TypeAmazonS3, TypeAzureBatch, TypeAzureBlobFS, TypeAzureBlobStorage, TypeAzureDatabricks, TypeAzureDataExplorer, TypeAzureDataLakeAnalytics, TypeAzureDataLakeStore, TypeAzureFunction, TypeAzureKeyVault, TypeAzureML, TypeAzureMySQL, TypeAzurePostgreSQL, TypeAzureSearch, TypeAzureSQLDatabase, TypeAzureSQLDW, TypeAzureStorage, TypeAzureTableStorage, TypeCassandra, TypeConcur, TypeCosmosDb, TypeCosmosDbMongoDbAPI, TypeCouchbase, TypeCustomDataSource, TypeDb2, TypeDrill, TypeDynamics, TypeDynamicsAX, TypeEloqua, TypeFileServer, TypeFtpServer, TypeGoogleAdWords, TypeGoogleBigQuery, TypeGreenplum, TypeHBase, TypeHdfs, TypeHDInsight, TypeHDInsightOnDemand, TypeHive, TypeHTTPServer, TypeHubspot, TypeImpala, TypeJira, TypeLinkedService, TypeMagento, TypeMariaDB, TypeMarketo, TypeMongoDb, TypeMongoDbV2, TypeMySQL, TypeNetezza, TypeOData, TypeOdbc, TypeOffice365, TypeOracle, TypeOracleServiceCloud, TypePaypal, TypePhoenix, TypePostgreSQL, TypePresto, TypeQuickBooks, TypeResponsys, TypeRestService, TypeSalesforce, TypeSalesforceMarketingCloud, TypeSapBW, TypeSapCloudForCustomer, TypeSapEcc, TypeSapHana, TypeSapOpenHub, TypeServiceNow, TypeSftp, TypeShopify, TypeSpark, TypeSQLServer, TypeSquare, TypeSybase, TypeTeradata, TypeVertica, TypeWeb, TypeXero, TypeZoho}
}

// TypeBasicSsisObjectMetadata enumerates the values for type basic ssis object metadata.
type TypeBasicSsisObjectMetadata string

const (
	// TypeEnvironment ...
	TypeEnvironment TypeBasicSsisObjectMetadata = "Environment"
	// TypeFolder ...
	TypeFolder TypeBasicSsisObjectMetadata = "Folder"
	// TypePackage ...
	TypePackage TypeBasicSsisObjectMetadata = "Package"
	// TypeProject ...
	TypeProject TypeBasicSsisObjectMetadata = "Project"
	// TypeSsisObjectMetadata ...
	TypeSsisObjectMetadata TypeBasicSsisObjectMetadata = "SsisObjectMetadata"
)

// PossibleTypeBasicSsisObjectMetadataValues returns an array of possible values for the TypeBasicSsisObjectMetadata const type.
func PossibleTypeBasicSsisObjectMetadataValues() []TypeBasicSsisObjectMetadata {
	return []TypeBasicSsisObjectMetadata{TypeEnvironment, TypeFolder, TypePackage, TypeProject, TypeSsisObjectMetadata}
}

// TypeBasicTrigger enumerates the values for type basic trigger.
type TypeBasicTrigger string

const (
	// TypeBlobEventsTrigger ...
	TypeBlobEventsTrigger TypeBasicTrigger = "BlobEventsTrigger"
	// TypeBlobTrigger ...
	TypeBlobTrigger TypeBasicTrigger = "BlobTrigger"
	// TypeMultiplePipelineTrigger ...
	TypeMultiplePipelineTrigger TypeBasicTrigger = "MultiplePipelineTrigger"
	// TypeRerunTumblingWindowTrigger ...
	TypeRerunTumblingWindowTrigger TypeBasicTrigger = "RerunTumblingWindowTrigger"
	// TypeScheduleTrigger ...
	TypeScheduleTrigger TypeBasicTrigger = "ScheduleTrigger"
	// TypeTrigger ...
	TypeTrigger TypeBasicTrigger = "Trigger"
	// TypeTumblingWindowTrigger ...
	TypeTumblingWindowTrigger TypeBasicTrigger = "TumblingWindowTrigger"
)

// PossibleTypeBasicTriggerValues returns an array of possible values for the TypeBasicTrigger const type.
func PossibleTypeBasicTriggerValues() []TypeBasicTrigger {
	return []TypeBasicTrigger{TypeBlobEventsTrigger, TypeBlobTrigger, TypeMultiplePipelineTrigger, TypeRerunTumblingWindowTrigger, TypeScheduleTrigger, TypeTrigger, TypeTumblingWindowTrigger}
}

// VariableType enumerates the values for variable type.
type VariableType string

const (
	// VariableTypeArray ...
	VariableTypeArray VariableType = "Array"
	// VariableTypeBool ...
	VariableTypeBool VariableType = "Bool"
	// VariableTypeString ...
	VariableTypeString VariableType = "String"
)

// PossibleVariableTypeValues returns an array of possible values for the VariableType const type.
func PossibleVariableTypeValues() []VariableType {
	return []VariableType{VariableTypeArray, VariableTypeBool, VariableTypeString}
}

// WebActivityMethod enumerates the values for web activity method.
type WebActivityMethod string

const (
	// WebActivityMethodDELETE ...
	WebActivityMethodDELETE WebActivityMethod = "DELETE"
	// WebActivityMethodGET ...
	WebActivityMethodGET WebActivityMethod = "GET"
	// WebActivityMethodPOST ...
	WebActivityMethodPOST WebActivityMethod = "POST"
	// WebActivityMethodPUT ...
	WebActivityMethodPUT WebActivityMethod = "PUT"
)

// PossibleWebActivityMethodValues returns an array of possible values for the WebActivityMethod const type.
func PossibleWebActivityMethodValues() []WebActivityMethod {
	return []WebActivityMethod{WebActivityMethodDELETE, WebActivityMethodGET, WebActivityMethodPOST, WebActivityMethodPUT}
}

// WebHookActivityMethod enumerates the values for web hook activity method.
type WebHookActivityMethod string

const (
	// WebHookActivityMethodPOST ...
	WebHookActivityMethodPOST WebHookActivityMethod = "POST"
)

// PossibleWebHookActivityMethodValues returns an array of possible values for the WebHookActivityMethod const type.
func PossibleWebHookActivityMethodValues() []WebHookActivityMethod {
	return []WebHookActivityMethod{WebHookActivityMethodPOST}
}

// AccessPolicyResponse get Data Plane read only token response definition.
type AccessPolicyResponse struct {
	autorest.Response `json:"-"`
	// Policy - The user access policy.
	Policy *UserAccessPolicy `json:"policy,omitempty"`
	// AccessToken - Data Plane read only access token.
	AccessToken *string `json:"accessToken,omitempty"`
	// DataPlaneURL - Data Plane service base URL.
	DataPlaneURL *string `json:"dataPlaneUrl,omitempty"`
}

// BasicActivity a pipeline activity.
type BasicActivity interface {
	AsAzureFunctionActivity() (*AzureFunctionActivity, bool)
	AsDatabricksSparkPythonActivity() (*DatabricksSparkPythonActivity, bool)
	AsDatabricksSparkJarActivity() (*DatabricksSparkJarActivity, bool)
	AsDatabricksNotebookActivity() (*DatabricksNotebookActivity, bool)
	AsDataLakeAnalyticsUSQLActivity() (*DataLakeAnalyticsUSQLActivity, bool)
	AsAzureMLUpdateResourceActivity() (*AzureMLUpdateResourceActivity, bool)
	AsAzureMLBatchExecutionActivity() (*AzureMLBatchExecutionActivity, bool)
	AsGetMetadataActivity() (*GetMetadataActivity, bool)
	AsWebActivity() (*WebActivity, bool)
	AsLookupActivity() (*LookupActivity, bool)
	AsDeleteActivity() (*DeleteActivity, bool)
	AsSQLServerStoredProcedureActivity() (*SQLServerStoredProcedureActivity, bool)
	AsCustomActivity() (*CustomActivity, bool)
	AsExecuteSSISPackageActivity() (*ExecuteSSISPackageActivity, bool)
	AsHDInsightSparkActivity() (*HDInsightSparkActivity, bool)
	AsHDInsightStreamingActivity() (*HDInsightStreamingActivity, bool)
	AsHDInsightMapReduceActivity() (*HDInsightMapReduceActivity, bool)
	AsHDInsightPigActivity() (*HDInsightPigActivity, bool)
	AsHDInsightHiveActivity() (*HDInsightHiveActivity, bool)
	AsCopyActivity() (*CopyActivity, bool)
	AsExecutionActivity() (*ExecutionActivity, bool)
	AsBasicExecutionActivity() (BasicExecutionActivity, bool)
	AsWebHookActivity() (*WebHookActivity, bool)
	AsAppendVariableActivity() (*AppendVariableActivity, bool)
	AsSetVariableActivity() (*SetVariableActivity, bool)
	AsFilterActivity() (*FilterActivity, bool)
	AsValidationActivity() (*ValidationActivity, bool)
	AsUntilActivity() (*UntilActivity, bool)
	AsWaitActivity() (*WaitActivity, bool)
	AsForEachActivity() (*ForEachActivity, bool)
	AsIfConditionActivity() (*IfConditionActivity, bool)
	AsExecutePipelineActivity() (*ExecutePipelineActivity, bool)
	AsControlActivity() (*ControlActivity, bool)
	AsBasicControlActivity() (BasicControlActivity, bool)
	AsActivity() (*Activity, bool)
}

// Activity a pipeline activity.
type Activity struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Name - Activity name.
	Name *string `json:"name,omitempty"`
	// Description - Activity description.
	Description *string `json:"description,omitempty"`
	// DependsOn - Activity depends on condition.
	DependsOn *[]ActivityDependency `json:"dependsOn,omitempty"`
	// UserProperties - Activity user properties.
	UserProperties *[]UserProperty `json:"userProperties,omitempty"`
	// Type - Possible values include: 'TypeActivity', 'TypeAzureFunctionActivity', 'TypeDatabricksSparkPython', 'TypeDatabricksSparkJar', 'TypeDatabricksNotebook', 'TypeDataLakeAnalyticsUSQL', 'TypeAzureMLUpdateResource', 'TypeAzureMLBatchExecution', 'TypeGetMetadata', 'TypeWebActivity', 'TypeLookup', 'TypeDelete', 'TypeSQLServerStoredProcedure', 'TypeCustom', 'TypeExecuteSSISPackage', 'TypeHDInsightSpark', 'TypeHDInsightStreaming', 'TypeHDInsightMapReduce', 'TypeHDInsightPig', 'TypeHDInsightHive', 'TypeCopy', 'TypeExecution', 'TypeWebHook', 'TypeAppendVariable', 'TypeSetVariable', 'TypeFilter', 'TypeValidation', 'TypeUntil', 'TypeWait', 'TypeForEach', 'TypeIfCondition', 'TypeExecutePipeline', 'TypeContainer'
	Type TypeBasicActivity `json:"type,omitempty"`
}

func unmarshalBasicActivity(body []byte) (BasicActivity, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["type"] {
	case string(TypeAzureFunctionActivity):
		var afa AzureFunctionActivity
		err := json.Unmarshal(body, &afa)
		return afa, err
	case string(TypeDatabricksSparkPython):
		var dspa DatabricksSparkPythonActivity
		err := json.Unmarshal(body, &dspa)
		return dspa, err
	case string(TypeDatabricksSparkJar):
		var dsja DatabricksSparkJarActivity
		err := json.Unmarshal(body, &dsja)
		return dsja, err
	case string(TypeDatabricksNotebook):
		var dna DatabricksNotebookActivity
		err := json.Unmarshal(body, &dna)
		return dna, err
	case string(TypeDataLakeAnalyticsUSQL):
		var dlaua DataLakeAnalyticsUSQLActivity
		err := json.Unmarshal(body, &dlaua)
		return dlaua, err
	case string(TypeAzureMLUpdateResource):
		var amura AzureMLUpdateResourceActivity
		err := json.Unmarshal(body, &amura)
		return amura, err
	case string(TypeAzureMLBatchExecution):
		var ambea AzureMLBatchExecutionActivity
		err := json.Unmarshal(body, &ambea)
		return ambea, err
	case string(TypeGetMetadata):
		var gma GetMetadataActivity
		err := json.Unmarshal(body, &gma)
		return gma, err
	case string(TypeWebActivity):
		var wa WebActivity
		err := json.Unmarshal(body, &wa)
		return wa, err
	case string(TypeLookup):
		var la LookupActivity
		err := json.Unmarshal(body, &la)
		return la, err
	case string(TypeDelete):
		var da DeleteActivity
		err := json.Unmarshal(body, &da)
		return da, err
	case string(TypeSQLServerStoredProcedure):
		var ssspa SQLServerStoredProcedureActivity
		err := json.Unmarshal(body, &ssspa)
		return ssspa, err
	case string(TypeCustom):
		var ca CustomActivity
		err := json.Unmarshal(body, &ca)
		return ca, err
	case string(TypeExecuteSSISPackage):
		var espa ExecuteSSISPackageActivity
		err := json.Unmarshal(body, &espa)
		return espa, err
	case string(TypeHDInsightSpark):
		var hisa HDInsightSparkActivity
		err := json.Unmarshal(body, &hisa)
		return hisa, err
	case string(TypeHDInsightStreaming):
		var hisa HDInsightStreamingActivity
		err := json.Unmarshal(body, &hisa)
		return hisa, err
	case string(TypeHDInsightMapReduce):
		var himra HDInsightMapReduceActivity
		err := json.Unmarshal(body, &himra)
		return himra, err
	case string(TypeHDInsightPig):
		var hipa HDInsightPigActivity
		err := json.Unmarshal(body, &hipa)
		return hipa, err
	case string(TypeHDInsightHive):
		var hiha HDInsightHiveActivity
		err := json.Unmarshal(body, &hiha)
		return hiha, err
	case string(TypeCopy):
		var ca CopyActivity
		err := json.Unmarshal(body, &ca)
		return ca, err
	case string(TypeExecution):
		var ea ExecutionActivity
		err := json.Unmarshal(body, &ea)
		return ea, err
	case string(TypeWebHook):
		var wha WebHookActivity
		err := json.Unmarshal(body, &wha)
		return wha, err
	case string(TypeAppendVariable):
		var ava AppendVariableActivity
		err := json.Unmarshal(body, &ava)
		return ava, err
	case string(TypeSetVariable):
		var sva SetVariableActivity
		err := json.Unmarshal(body, &sva)
		return sva, err
	case string(TypeFilter):
		var fa FilterActivity
		err := json.Unmarshal(body, &fa)
		return fa, err
	case string(TypeValidation):
		var va ValidationActivity
		err := json.Unmarshal(body, &va)
		return va, err
	case string(TypeUntil):
		var ua UntilActivity
		err := json.Unmarshal(body, &ua)
		return ua, err
	case string(TypeWait):
		var wa WaitActivity
		err := json.Unmarshal(body, &wa)
		return wa, err
	case string(TypeForEach):
		var fea ForEachActivity
		err := json.Unmarshal(body, &fea)
		return fea, err
	case string(TypeIfCondition):
		var ica IfConditionActivity
		err := json.Unmarshal(body, &ica)
		return ica, err
	case string(TypeExecutePipeline):
		var epa ExecutePipelineActivity
		err := json.Unmarshal(body, &epa)
		return epa, err
	case string(TypeContainer):
		var ca ControlActivity
		err := json.Unmarshal(body, &ca)
		return ca, err
	default:
		var a Activity
		err := json.Unmarshal(body, &a)
		return a, err
	}
}
func unmarshalBasicActivityArray(body []byte) ([]BasicActivity, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	aArray := make([]BasicActivity, len(rawMessages))

	for index, rawMessage := range rawMessages {
		a, err := unmarshalBasicActivity(*rawMessage)
		if err != nil {
			return nil, err
		}
		aArray[index] = a
	}
	return aArray, nil
}

// MarshalJSON is the custom marshaler for Activity.
func (a Activity) MarshalJSON() ([]byte, error) {
	a.Type = TypeActivity
	objectMap := make(map[string]interface{})
	if a.Name != nil {
		objectMap["name"] = a.Name
	}
	if a.Description != nil {
		objectMap["description"] = a.Description
	}
	if a.DependsOn != nil {
		objectMap["dependsOn"] = a.DependsOn
	}
	if a.UserProperties != nil {
		objectMap["userProperties"] = a.UserProperties
	}
	if a.Type != "" {
		objectMap["type"] = a.Type
	}
	for k, v := range a.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsAzureFunctionActivity is the BasicActivity implementation for Activity.
func (a Activity) AsAzureFunctionActivity() (*AzureFunctionActivity, bool) {
	return nil, false
}

// AsDatabricksSparkPythonActivity is the BasicActivity implementation for Activity.
func (a Activity) AsDatabricksSparkPythonActivity() (*DatabricksSparkPythonActivity, bool) {
	return nil, false
}

// AsDatabricksSparkJarActivity is the BasicActivity implementation for Activity.
func (a Activity) AsDatabricksSparkJarActivity() (*DatabricksSparkJarActivity, bool) {
	return nil, false
}

// AsDatabricksNotebookActivity is the BasicActivity implementation for Activity.
func (a Activity) AsDatabricksNotebookActivity() (*DatabricksNotebookActivity, bool) {
	return nil, false
}

// AsDataLakeAnalyticsUSQLActivity is the BasicActivity implementation for Activity.
func (a Activity) AsDataLakeAnalyticsUSQLActivity() (*DataLakeAnalyticsUSQLActivity, bool) {
	return nil, false
}

// AsAzureMLUpdateResourceActivity is the BasicActivity implementation for Activity.
func (a Activity) AsAzureMLUpdateResourceActivity() (*AzureMLUpdateResourceActivity, bool) {
	return nil, false
}

// AsAzureMLBatchExecutionActivity is the BasicActivity implementation for Activity.
func (a Activity) AsAzureMLBatchExecutionActivity() (*AzureMLBatchExecutionActivity, bool) {
	return nil, false
}

// AsGetMetadataActivity is the BasicActivity implementation for Activity.
func (a Activity) AsGetMetadataActivity() (*GetMetadataActivity, bool) {
	return nil, false
}

// AsWebActivity is the BasicActivity implementation for Activity.
func (a Activity) AsWebActivity() (*WebActivity, bool) {
	return nil, false
}

// AsLookupActivity is the BasicActivity implementation for Activity.
func (a Activity) AsLookupActivity() (*LookupActivity, bool) {
	return nil, false
}

// AsDeleteActivity is the BasicActivity implementation for Activity.
func (a Activity) AsDeleteActivity() (*DeleteActivity, bool) {
	return nil, false
}

// AsSQLServerStoredProcedureActivity is the BasicActivity implementation for Activity.
func (a Activity) AsSQLServerStoredProcedureActivity() (*SQLServerStoredProcedureActivity, bool) {
	return nil, false
}

// AsCustomActivity is the BasicActivity implementation for Activity.
func (a Activity) AsCustomActivity() (*CustomActivity, bool) {
	return nil, false
}

// AsExecuteSSISPackageActivity is the BasicActivity implementation for Activity.
func (a Activity) AsExecuteSSISPackageActivity() (*ExecuteSSISPackageActivity, bool) {
	return nil, false
}

// AsHDInsightSparkActivity is the BasicActivity implementation for Activity.
func (a Activity) AsHDInsightSparkActivity() (*HDInsightSparkActivity, bool) {
	return nil, false
}

// AsHDInsightStreamingActivity is the BasicActivity implementation for Activity.
func (a Activity) AsHDInsightStreamingActivity() (*HDInsightStreamingActivity, bool) {
	return nil, false
}

// AsHDInsightMapReduceActivity is the BasicActivity implementation for Activity.
func (a Activity) AsHDInsightMapReduceActivity() (*HDInsightMapReduceActivity, bool) {
	return nil, false
}

// AsHDInsightPigActivity is the BasicActivity implementation for Activity.
func (a Activity) AsHDInsightPigActivity() (*HDInsightPigActivity, bool) {
	return nil, false
}

// AsHDInsightHiveActivity is the BasicActivity implementation for Activity.
func (a Activity) AsHDInsightHiveActivity() (*HDInsightHiveActivity, bool) {
	return nil, false
}

// AsCopyActivity is the BasicActivity implementation for Activity.
func (a Activity) AsCopyActivity() (*CopyActivity, bool) {
	return nil, false
}

// AsExecutionActivity is the BasicActivity implementation for Activity.
func (a Activity) AsExecutionActivity() (*ExecutionActivity, bool) {
	return nil, false
}

// AsBasicExecutionActivity is the BasicActivity implementation for Activity.
func (a Activity) AsBasicExecutionActivity() (BasicExecutionActivity, bool) {
	return nil, false
}

// AsWebHookActivity is the BasicActivity implementation for Activity.
func (a Activity) AsWebHookActivity() (*WebHookActivity, bool) {
	return nil, false
}

// AsAppendVariableActivity is the BasicActivity implementation for Activity.
func (a Activity) AsAppendVariableActivity() (*AppendVariableActivity, bool) {
	return nil, false
}

// AsSetVariableActivity is the BasicActivity implementation for Activity.
func (a Activity) AsSetVariableActivity() (*SetVariableActivity, bool) {
	return nil, false
}

// AsFilterActivity is the BasicActivity implementation for Activity.
func (a Activity) AsFilterActivity() (*FilterActivity, bool) {
	return nil, false
}

// AsValidationActivity is the BasicActivity implementation for Activity.
func (a Activity) AsValidationActivity() (*ValidationActivity, bool) {
	return nil, false
}

// AsUntilActivity is the BasicActivity implementation for Activity.
func (a Activity) AsUntilActivity() (*UntilActivity, bool) {
	return nil, false
}

// AsWaitActivity is the BasicActivity implementation for Activity.
func (a Activity) AsWaitActivity() (*WaitActivity, bool) {
	return nil, false
}

// AsForEachActivity is the BasicActivity implementation for Activity.
func (a Activity) AsForEachActivity() (*ForEachActivity, bool) {
	return nil, false
}

// AsIfConditionActivity is the BasicActivity implementation for Activity.
func (a Activity) AsIfConditionActivity() (*IfConditionActivity, bool) {
	return nil, false
}

// AsExecutePipelineActivity is the BasicActivity implementation for Activity.
func (a Activity) AsExecutePipelineActivity() (*ExecutePipelineActivity, bool) {
	return nil, false
}

// AsControlActivity is the BasicActivity implementation for Activity.
func (a Activity) AsControlActivity() (*ControlActivity, bool) {
	return nil, false
}

// AsBasicControlActivity is the BasicActivity implementation for Activity.
func (a Activity) AsBasicControlActivity() (BasicControlActivity, bool) {
	return nil, false
}

// AsActivity is the BasicActivity implementation for Activity.
func (a Activity) AsActivity() (*Activity, bool) {
	return &a, true
}

// AsBasicActivity is the BasicActivity implementation for Activity.
func (a Activity) AsBasicActivity() (BasicActivity, bool) {
	return &a, true
}

// UnmarshalJSON is the custom unmarshaler for Activity struct.
func (a *Activity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if a.AdditionalProperties == nil {
					a.AdditionalProperties = make(map[string]interface{})
				}
				a.AdditionalProperties[k] = additionalProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				a.Name = &name
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				a.Description = &description
			}
		case "dependsOn":
			if v != nil {
				var dependsOn []ActivityDependency
				err = json.Unmarshal(*v, &dependsOn)
				if err != nil {
					return err
				}
				a.DependsOn = &dependsOn
			}
		case "userProperties":
			if v != nil {
				var userProperties []UserProperty
				err = json.Unmarshal(*v, &userProperties)
				if err != nil {
					return err
				}
				a.UserProperties = &userProperties
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicActivity
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				a.Type = typeVar
			}
		}
	}

	return nil
}

// ActivityDependency activity dependency information.
type ActivityDependency struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Activity - Activity name.
	Activity *string `json:"activity,omitempty"`
	// DependencyConditions - Match-Condition for the dependency.
	DependencyConditions *[]DependencyCondition `json:"dependencyConditions,omitempty"`
}

// MarshalJSON is the custom marshaler for ActivityDependency.
func (ad ActivityDependency) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ad.Activity != nil {
		objectMap["activity"] = ad.Activity
	}
	if ad.DependencyConditions != nil {
		objectMap["dependencyConditions"] = ad.DependencyConditions
	}
	for k, v := range ad.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ActivityDependency struct.
func (ad *ActivityDependency) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if ad.AdditionalProperties == nil {
					ad.AdditionalProperties = make(map[string]interface{})
				}
				ad.AdditionalProperties[k] = additionalProperties
			}
		case "activity":
			if v != nil {
				var activity string
				err = json.Unmarshal(*v, &activity)
				if err != nil {
					return err
				}
				ad.Activity = &activity
			}
		case "dependencyConditions":
			if v != nil {
				var dependencyConditions []DependencyCondition
				err = json.Unmarshal(*v, &dependencyConditions)
				if err != nil {
					return err
				}
				ad.DependencyConditions = &dependencyConditions
			}
		}
	}

	return nil
}

// ActivityPolicy execution policy for an activity.
type ActivityPolicy struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Timeout - Specifies the timeout for the activity to run. The default timeout is 7 days. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	Timeout interface{} `json:"timeout,omitempty"`
	// Retry - Maximum ordinary retry attempts. Default is 0. Type: integer (or Expression with resultType integer), minimum: 0.
	Retry interface{} `json:"retry,omitempty"`
	// RetryIntervalInSeconds - Interval between each retry attempt (in seconds). The default is 30 sec.
	RetryIntervalInSeconds *int32 `json:"retryIntervalInSeconds,omitempty"`
	// SecureInput - When set to true, Input from activity is considered as secure and will not be logged to monitoring.
	SecureInput *bool `json:"secureInput,omitempty"`
	// SecureOutput - When set to true, Output from activity is considered as secure and will not be logged to monitoring.
	SecureOutput *bool `json:"secureOutput,omitempty"`
}

// MarshalJSON is the custom marshaler for ActivityPolicy.
func (ap ActivityPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ap.Timeout != nil {
		objectMap["timeout"] = ap.Timeout
	}
	if ap.Retry != nil {
		objectMap["retry"] = ap.Retry
	}
	if ap.RetryIntervalInSeconds != nil {
		objectMap["retryIntervalInSeconds"] = ap.RetryIntervalInSeconds
	}
	if ap.SecureInput != nil {
		objectMap["secureInput"] = ap.SecureInput
	}
	if ap.SecureOutput != nil {
		objectMap["secureOutput"] = ap.SecureOutput
	}
	for k, v := range ap.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ActivityPolicy struct.
func (ap *ActivityPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if ap.AdditionalProperties == nil {
					ap.AdditionalProperties = make(map[string]interface{})
				}
				ap.AdditionalProperties[k] = additionalProperties
			}
		case "timeout":
			if v != nil {
				var timeout interface{}
				err = json.Unmarshal(*v, &timeout)
				if err != nil {
					return err
				}
				ap.Timeout = timeout
			}
		case "retry":
			if v != nil {
				var retry interface{}
				err = json.Unmarshal(*v, &retry)
				if err != nil {
					return err
				}
				ap.Retry = retry
			}
		case "retryIntervalInSeconds":
			if v != nil {
				var retryIntervalInSeconds int32
				err = json.Unmarshal(*v, &retryIntervalInSeconds)
				if err != nil {
					return err
				}
				ap.RetryIntervalInSeconds = &retryIntervalInSeconds
			}
		case "secureInput":
			if v != nil {
				var secureInput bool
				err = json.Unmarshal(*v, &secureInput)
				if err != nil {
					return err
				}
				ap.SecureInput = &secureInput
			}
		case "secureOutput":
			if v != nil {
				var secureOutput bool
				err = json.Unmarshal(*v, &secureOutput)
				if err != nil {
					return err
				}
				ap.SecureOutput = &secureOutput
			}
		}
	}

	return nil
}

// ActivityRun information about an activity run in a pipeline.
type ActivityRun struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// PipelineName - READ-ONLY; The name of the pipeline.
	PipelineName *string `json:"pipelineName,omitempty"`
	// PipelineRunID - READ-ONLY; The id of the pipeline run.
	PipelineRunID *string `json:"pipelineRunId,omitempty"`
	// ActivityName - READ-ONLY; The name of the activity.
	ActivityName *string `json:"activityName,omitempty"`
	// ActivityType - READ-ONLY; The type of the activity.
	ActivityType *string `json:"activityType,omitempty"`
	// ActivityRunID - READ-ONLY; The id of the activity run.
	ActivityRunID *string `json:"activityRunId,omitempty"`
	// LinkedServiceName - READ-ONLY; The name of the compute linked service.
	LinkedServiceName *string `json:"linkedServiceName,omitempty"`
	// Status - READ-ONLY; The status of the activity run.
	Status *string `json:"status,omitempty"`
	// ActivityRunStart - READ-ONLY; The start time of the activity run in 'ISO 8601' format.
	ActivityRunStart *date.Time `json:"activityRunStart,omitempty"`
	// ActivityRunEnd - READ-ONLY; The end time of the activity run in 'ISO 8601' format.
	ActivityRunEnd *date.Time `json:"activityRunEnd,omitempty"`
	// DurationInMs - READ-ONLY; The duration of the activity run.
	DurationInMs *int32 `json:"durationInMs,omitempty"`
	// Input - READ-ONLY; The input for the activity.
	Input interface{} `json:"input,omitempty"`
	// Output - READ-ONLY; The output for the activity.
	Output interface{} `json:"output,omitempty"`
	// Error - READ-ONLY; The error if any from the activity run.
	Error interface{} `json:"error,omitempty"`
}

// MarshalJSON is the custom marshaler for ActivityRun.
func (ar ActivityRun) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	for k, v := range ar.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ActivityRun struct.
func (ar *ActivityRun) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if ar.AdditionalProperties == nil {
					ar.AdditionalProperties = make(map[string]interface{})
				}
				ar.AdditionalProperties[k] = additionalProperties
			}
		case "pipelineName":
			if v != nil {
				var pipelineName string
				err = json.Unmarshal(*v, &pipelineName)
				if err != nil {
					return err
				}
				ar.PipelineName = &pipelineName
			}
		case "pipelineRunId":
			if v != nil {
				var pipelineRunID string
				err = json.Unmarshal(*v, &pipelineRunID)
				if err != nil {
					return err
				}
				ar.PipelineRunID = &pipelineRunID
			}
		case "activityName":
			if v != nil {
				var activityName string
				err = json.Unmarshal(*v, &activityName)
				if err != nil {
					return err
				}
				ar.ActivityName = &activityName
			}
		case "activityType":
			if v != nil {
				var activityType string
				err = json.Unmarshal(*v, &activityType)
				if err != nil {
					return err
				}
				ar.ActivityType = &activityType
			}
		case "activityRunId":
			if v != nil {
				var activityRunID string
				err = json.Unmarshal(*v, &activityRunID)
				if err != nil {
					return err
				}
				ar.ActivityRunID = &activityRunID
			}
		case "linkedServiceName":
			if v != nil {
				var linkedServiceName string
				err = json.Unmarshal(*v, &linkedServiceName)
				if err != nil {
					return err
				}
				ar.LinkedServiceName = &linkedServiceName
			}
		case "status":
			if v != nil {
				var status string
				err = json.Unmarshal(*v, &status)
				if err != nil {
					return err
				}
				ar.Status = &status
			}
		case "activityRunStart":
			if v != nil {
				var activityRunStart date.Time
				err = json.Unmarshal(*v, &activityRunStart)
				if err != nil {
					return err
				}
				ar.ActivityRunStart = &activityRunStart
			}
		case "activityRunEnd":
			if v != nil {
				var activityRunEnd date.Time
				err = json.Unmarshal(*v, &activityRunEnd)
				if err != nil {
					return err
				}
				ar.ActivityRunEnd = &activityRunEnd
			}
		case "durationInMs":
			if v != nil {
				var durationInMs int32
				err = json.Unmarshal(*v, &durationInMs)
				if err != nil {
					return err
				}
				ar.DurationInMs = &durationInMs
			}
		case "input":
			if v != nil {
				var input interface{}
				err = json.Unmarshal(*v, &input)
				if err != nil {
					return err
				}
				ar.Input = input
			}
		case "output":
			if v != nil {
				var output interface{}
				err = json.Unmarshal(*v, &output)
				if err != nil {
					return err
				}
				ar.Output = output
			}
		case "error":
			if v != nil {
				var errorVar interface{}
				err = json.Unmarshal(*v, &errorVar)
				if err != nil {
					return err
				}
				ar.Error = errorVar
			}
		}
	}

	return nil
}

// ActivityRunsQueryResponse a list activity runs.
type ActivityRunsQueryResponse struct {
	autorest.Response `json:"-"`
	// Value - List of activity runs.
	Value *[]ActivityRun `json:"value,omitempty"`
	// ContinuationToken - The continuation token for getting the next page of results, if any remaining results exist, null otherwise.
	ContinuationToken *string `json:"continuationToken,omitempty"`
}

// AmazonMWSLinkedService amazon Marketplace Web Service linked service.
type AmazonMWSLinkedService struct {
	// AmazonMWSLinkedServiceTypeProperties - Amazon Marketplace Web Service linked service properties.
	*AmazonMWSLinkedServiceTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Parameters - Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the linked service.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Type - Possible values include: 'TypeLinkedService', 'TypeAzureFunction', 'TypeAzureDataExplorer', 'TypeGoogleAdWords', 'TypeOracleServiceCloud', 'TypeDynamicsAX', 'TypeResponsys', 'TypeAzureDatabricks', 'TypeAzureDataLakeAnalytics', 'TypeHDInsightOnDemand', 'TypeSalesforceMarketingCloud', 'TypeNetezza', 'TypeVertica', 'TypeZoho', 'TypeXero', 'TypeSquare', 'TypeSpark', 'TypeShopify', 'TypeServiceNow', 'TypeQuickBooks', 'TypePresto', 'TypePhoenix', 'TypePaypal', 'TypeMarketo', 'TypeMariaDB', 'TypeMagento', 'TypeJira', 'TypeImpala', 'TypeHubspot', 'TypeHive', 'TypeHBase', 'TypeGreenplum', 'TypeGoogleBigQuery', 'TypeEloqua', 'TypeDrill', 'TypeCouchbase', 'TypeConcur', 'TypeAzurePostgreSQL', 'TypeAmazonMWS', 'TypeSapHana', 'TypeSapBW', 'TypeSftp', 'TypeFtpServer', 'TypeHTTPServer', 'TypeAzureSearch', 'TypeCustomDataSource', 'TypeAmazonRedshift', 'TypeAmazonS3', 'TypeRestService', 'TypeSapOpenHub', 'TypeSapEcc', 'TypeSapCloudForCustomer', 'TypeSalesforce', 'TypeOffice365', 'TypeAzureBlobFS', 'TypeAzureDataLakeStore', 'TypeCosmosDbMongoDbAPI', 'TypeMongoDbV2', 'TypeMongoDb', 'TypeCassandra', 'TypeWeb', 'TypeOData', 'TypeHdfs', 'TypeOdbc', 'TypeAzureML', 'TypeTeradata', 'TypeDb2', 'TypeSybase', 'TypePostgreSQL', 'TypeMySQL', 'TypeAzureMySQL', 'TypeOracle', 'TypeFileServer', 'TypeHDInsight', 'TypeDynamics', 'TypeCosmosDb', 'TypeAzureKeyVault', 'TypeAzureBatch', 'TypeAzureSQLDatabase', 'TypeSQLServer', 'TypeAzureSQLDW', 'TypeAzureTableStorage', 'TypeAzureBlobStorage', 'TypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) MarshalJSON() ([]byte, error) {
	amls.Type = TypeAmazonMWS
	objectMap := make(map[string]interface{})
	if amls.AmazonMWSLinkedServiceTypeProperties != nil {
		objectMap["typeProperties"] = amls.AmazonMWSLinkedServiceTypeProperties
	}
	if amls.ConnectVia != nil {
		objectMap["connectVia"] = amls.ConnectVia
	}
	if amls.Description != nil {
		objectMap["description"] = amls.Description
	}
	if amls.Parameters != nil {
		objectMap["parameters"] = amls.Parameters
	}
	if amls.Annotations != nil {
		objectMap["annotations"] = amls.Annotations
	}
	if amls.Type != "" {
		objectMap["type"] = amls.Type
	}
	for k, v := range amls.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsAzureFunctionLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzureFunctionLinkedService() (*AzureFunctionLinkedService, bool) {
	return nil, false
}

// AsAzureDataExplorerLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzureDataExplorerLinkedService() (*AzureDataExplorerLinkedService, bool) {
	return nil, false
}

// AsGoogleAdWordsLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsGoogleAdWordsLinkedService() (*GoogleAdWordsLinkedService, bool) {
	return nil, false
}

// AsOracleServiceCloudLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsOracleServiceCloudLinkedService() (*OracleServiceCloudLinkedService, bool) {
	return nil, false
}

// AsDynamicsAXLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsDynamicsAXLinkedService() (*DynamicsAXLinkedService, bool) {
	return nil, false
}

// AsResponsysLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsResponsysLinkedService() (*ResponsysLinkedService, bool) {
	return nil, false
}

// AsAzureDatabricksLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzureDatabricksLinkedService() (*AzureDatabricksLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return nil, false
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsSalesforceMarketingCloudLinkedService() (*SalesforceMarketingCloudLinkedService, bool) {
	return nil, false
}

// AsNetezzaLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsNetezzaLinkedService() (*NetezzaLinkedService, bool) {
	return nil, false
}

// AsVerticaLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsVerticaLinkedService() (*VerticaLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return nil, false
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return nil, false
}

// AsConcurLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return nil, false
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return nil, false
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return &amls, true
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return nil, false
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return nil, false
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return nil, false
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return nil, false
}

// AsRestServiceLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsRestServiceLinkedService() (*RestServiceLinkedService, bool) {
	return nil, false
}

// AsSapOpenHubLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsSapOpenHubLinkedService() (*SapOpenHubLinkedService, bool) {
	return nil, false
}

// AsSapEccLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsSapEccLinkedService() (*SapEccLinkedService, bool) {
	return nil, false
}

// AsSapCloudForCustomerLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsSapCloudForCustomerLinkedService() (*SapCloudForCustomerLinkedService, bool) {
	return nil, false
}

// AsSalesforceLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsSalesforceLinkedService() (*SalesforceLinkedService, bool) {
	return nil, false
}

// AsOffice365LinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsOffice365LinkedService() (*Office365LinkedService, bool) {
	return nil, false
}

// AsAzureBlobFSLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzureBlobFSLinkedService() (*AzureBlobFSLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzureDataLakeStoreLinkedService() (*AzureDataLakeStoreLinkedService, bool) {
	return nil, false
}

// AsCosmosDbMongoDbAPILinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsCosmosDbMongoDbAPILinkedService() (*CosmosDbMongoDbAPILinkedService, bool) {
	return nil, false
}

// AsMongoDbV2LinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsMongoDbV2LinkedService() (*MongoDbV2LinkedService, bool) {
	return nil, false
}

// AsMongoDbLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsMongoDbLinkedService() (*MongoDbLinkedService, bool) {
	return nil, false
}

// AsCassandraLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsCassandraLinkedService() (*CassandraLinkedService, bool) {
	return nil, false
}

// AsWebLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsWebLinkedService() (*WebLinkedService, bool) {
	return nil, false
}

// AsODataLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsODataLinkedService() (*ODataLinkedService, bool) {
	return nil, false
}

// AsHdfsLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsHdfsLinkedService() (*HdfsLinkedService, bool) {
	return nil, false
}

// AsOdbcLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsOdbcLinkedService() (*OdbcLinkedService, bool) {
	return nil, false
}

// AsAzureMLLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzureMLLinkedService() (*AzureMLLinkedService, bool) {
	return nil, false
}

// AsTeradataLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsTeradataLinkedService() (*TeradataLinkedService, bool) {
	return nil, false
}

// AsDb2LinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsDb2LinkedService() (*Db2LinkedService, bool) {
	return nil, false
}

// AsSybaseLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsSybaseLinkedService() (*SybaseLinkedService, bool) {
	return nil, false
}

// AsPostgreSQLLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsPostgreSQLLinkedService() (*PostgreSQLLinkedService, bool) {
	return nil, false
}

// AsMySQLLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsMySQLLinkedService() (*MySQLLinkedService, bool) {
	return nil, false
}

// AsAzureMySQLLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzureMySQLLinkedService() (*AzureMySQLLinkedService, bool) {
	return nil, false
}

// AsOracleLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsOracleLinkedService() (*OracleLinkedService, bool) {
	return nil, false
}

// AsFileServerLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsFileServerLinkedService() (*FileServerLinkedService, bool) {
	return nil, false
}

// AsHDInsightLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsHDInsightLinkedService() (*HDInsightLinkedService, bool) {
	return nil, false
}

// AsDynamicsLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsDynamicsLinkedService() (*DynamicsLinkedService, bool) {
	return nil, false
}

// AsCosmosDbLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsCosmosDbLinkedService() (*CosmosDbLinkedService, bool) {
	return nil, false
}

// AsAzureKeyVaultLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzureKeyVaultLinkedService() (*AzureKeyVaultLinkedService, bool) {
	return nil, false
}

// AsAzureBatchLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzureBatchLinkedService() (*AzureBatchLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDatabaseLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzureSQLDatabaseLinkedService() (*AzureSQLDatabaseLinkedService, bool) {
	return nil, false
}

// AsSQLServerLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsSQLServerLinkedService() (*SQLServerLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDWLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzureSQLDWLinkedService() (*AzureSQLDWLinkedService, bool) {
	return nil, false
}

// AsAzureTableStorageLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzureTableStorageLinkedService() (*AzureTableStorageLinkedService, bool) {
	return nil, false
}

// AsAzureBlobStorageLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzureBlobStorageLinkedService() (*AzureBlobStorageLinkedService, bool) {
	return nil, false
}

// AsAzureStorageLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzureStorageLinkedService() (*AzureStorageLinkedService, bool) {
	return nil, false
}

// AsLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsLinkedService() (*LinkedService, bool) {
	return nil, false
}

// AsBasicLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsBasicLinkedService() (BasicLinkedService, bool) {
	return &amls, true
}

// UnmarshalJSON is the custom unmarshaler for AmazonMWSLinkedService struct.
func (amls *AmazonMWSLinkedService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var amazonMWSLinkedServiceTypeProperties AmazonMWSLinkedServiceTypeProperties
				err = json.Unmarshal(*v, &amazonMWSLinkedServiceTypeProperties)
				if err != nil {
					return err
				}
				amls.AmazonMWSLinkedServiceTypeProperties = &amazonMWSLinkedServiceTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if amls.AdditionalProperties == nil {
					amls.AdditionalProperties = make(map[string]interface{})
				}
				amls.AdditionalProperties[k] = additionalProperties
			}
		case "connectVia":
			if v != nil {
				var connectVia IntegrationRuntimeReference
				err = json.Unmarshal(*v, &connectVia)
				if err != nil {
					return err
				}
				amls.ConnectVia = &connectVia
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				amls.Description = &description
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				amls.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				amls.Annotations = &annotations
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicLinkedService
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				amls.Type = typeVar
			}
		}
	}

	return nil
}

// AmazonMWSLinkedServiceTypeProperties amazon Marketplace Web Service linked service properties.
type AmazonMWSLinkedServiceTypeProperties struct {
	// Endpoint - The endpoint of the Amazon MWS server, (i.e. mws.amazonservices.com)
	Endpoint interface{} `json:"endpoint,omitempty"`
	// MarketplaceID - The Amazon Marketplace ID you want to retrieve data from. To retrieve data from multiple Marketplace IDs, separate them with a comma (,). (i.e. A2EUQ1WTGCTBG2)
	MarketplaceID interface{} `json:"marketplaceID,omitempty"`
	// SellerID - The Amazon seller ID.
	SellerID interface{} `json:"sellerID,omitempty"`
	// MwsAuthToken - The Amazon MWS authentication token.
	MwsAuthToken BasicSecretBase `json:"mwsAuthToken,omitempty"`
	// AccessKeyID - The access key id used to access data.
	AccessKeyID interface{} `json:"accessKeyId,omitempty"`
	// SecretKey - The secret key used to access data.
	SecretKey BasicSecretBase `json:"secretKey,omitempty"`
	// UseEncryptedEndpoints - Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
	UseEncryptedEndpoints interface{} `json:"useEncryptedEndpoints,omitempty"`
	// UseHostVerification - Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true.
	UseHostVerification interface{} `json:"useHostVerification,omitempty"`
	// UsePeerVerification - Specifies whether to verify the identity of the server when connecting over SSL. The default value is true.
	UsePeerVerification interface{} `json:"usePeerVerification,omitempty"`
	// EncryptedCredential - The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AmazonMWSLinkedServiceTypeProperties struct.
func (amlstp *AmazonMWSLinkedServiceTypeProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "endpoint":
			if v != nil {
				var endpoint interface{}
				err = json.Unmarshal(*v, &endpoint)
				if err != nil {
					return err
				}
				amlstp.Endpoint = endpoint
			}
		case "marketplaceID":
			if v != nil {
				var marketplaceID interface{}
				err = json.Unmarshal(*v, &marketplaceID)
				if err != nil {
					return err
				}
				amlstp.MarketplaceID = marketplaceID
			}
		case "sellerID":
			if v != nil {
				var sellerID interface{}
				err = json.Unmarshal(*v, &sellerID)
				if err != nil {
					return err
				}
				amlstp.SellerID = sellerID
			}
		case "mwsAuthToken":
			if v != nil {
				mwsAuthToken, err := unmarshalBasicSecretBase(*v)
				if err != nil {
					return err
				}
				amlstp.MwsAuthToken = mwsAuthToken
			}
		case "accessKeyId":
			if v != nil {
				var accessKeyID interface{}
				err = json.Unmarshal(*v, &accessKeyID)
				if err != nil {
					return err
				}
				amlstp.AccessKeyID = accessKeyID
			}
		case "secretKey":
			if v != nil {
				secretKey, err := unmarshalBasicSecretBase(*v)
				if err != nil {
					return err
				}
				amlstp.SecretKey = secretKey
			}
		case "useEncryptedEndpoints":
			if v != nil {
				var useEncryptedEndpoints interface{}
				err = json.Unmarshal(*v, &useEncryptedEndpoints)
				if err != nil {
					return err
				}
				amlstp.UseEncryptedEndpoints = useEncryptedEndpoints
			}
		case "useHostVerification":
			if v != nil {
				var useHostVerification interface{}
				err = json.Unmarshal(*v, &useHostVerification)
				if err != nil {
					return err
				}
				amlstp.UseHostVerification = useHostVerification
			}
		case "usePeerVerification":
			if v != nil {
				var usePeerVerification interface{}
				err = json.Unmarshal(*v, &usePeerVerification)
				if err != nil {
					return err
				}
				amlstp.UsePeerVerification = usePeerVerification
			}
		case "encryptedCredential":
			if v != nil {
				var encryptedCredential interface{}
				err = json.Unmarshal(*v, &encryptedCredential)
				if err != nil {
					return err
				}
				amlstp.EncryptedCredential = encryptedCredential
			}
		}
	}

	return nil
}

// AmazonMWSObjectDataset amazon Marketplace Web Service dataset.
type AmazonMWSObjectDataset struct {
	// GenericDatasetTypeProperties - Properties specific to this dataset type.
	*GenericDatasetTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Description - Dataset description.
	Description *string `json:"description,omitempty"`
	// Structure - Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`
	// Schema - Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType: DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`
	// LinkedServiceName - Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
	// Parameters - Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the Dataset.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Folder - The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`
	// Type - Possible values include: 'TypeDataset', 'TypeGoogleAdWordsObject', 'TypeAzureDataExplorerTable', 'TypeOracleServiceCloudObject', 'TypeDynamicsAXResource', 'TypeResponsysObject', 'TypeSalesforceMarketingCloudObject', 'TypeVerticaTable', 'TypeNetezzaTable', 'TypeZohoObject', 'TypeXeroObject', 'TypeSquareObject', 'TypeSparkObject', 'TypeShopifyObject', 'TypeServiceNowObject', 'TypeQuickBooksObject', 'TypePrestoObject', 'TypePhoenixObject', 'TypePaypalObject', 'TypeMarketoObject', 'TypeMariaDBTable', 'TypeMagentoObject', 'TypeJiraObject', 'TypeImpalaObject', 'TypeHubspotObject', 'TypeHiveObject', 'TypeHBaseObject', 'TypeGreenplumTable', 'TypeGoogleBigQueryObject', 'TypeEloquaObject', 'TypeDrillTable', 'TypeCouchbaseTable', 'TypeConcurObject', 'TypeAzurePostgreSQLTable', 'TypeAmazonMWSObject', 'TypeHTTPFile', 'TypeAzureSearchIndex', 'TypeWebTable', 'TypeRestResource', 'TypeSQLServerTable', 'TypeSapOpenHubTable', 'TypeSapEccResource', 'TypeSapCloudForCustomerResource', 'TypeSalesforceObject', 'TypeRelationalTable', 'TypeAzureMySQLTable', 'TypeOracleTable', 'TypeODataResource', 'TypeCosmosDbMongoDbAPICollection', 'TypeMongoDbV2Collection', 'TypeMongoDbCollection', 'TypeFileShare', 'TypeOffice365Table', 'TypeAzureBlobFSFile', 'TypeAzureDataLakeStoreFile', 'TypeDynamicsEntity', 'TypeDocumentDbCollection', 'TypeCustomDataset', 'TypeCassandraTable', 'TypeAzureSQLDWTable', 'TypeAzureSQLTable', 'TypeAzureTable', 'TypeAzureBlob', 'TypeAmazonS3Object'
	Type TypeBasicDataset `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) MarshalJSON() ([]byte, error) {
	amod.Type = TypeAmazonMWSObject
	objectMap := make(map[string]interface{})
	if amod.GenericDatasetTypeProperties != nil {
		objectMap["typeProperties"] = amod.GenericDatasetTypeProperties
	}
	if amod.Description != nil {
		objectMap["description"] = amod.Description
	}
	if amod.Structure != nil {
		objectMap["structure"] = amod.Structure
	}
	if amod.Schema != nil {
		objectMap["schema"] = amod.Schema
	}
	if amod.LinkedServiceName != nil {
		objectMap["linkedServiceName"] = amod.LinkedServiceName
	}
	if amod.Parameters != nil {
		objectMap["parameters"] = amod.Parameters
	}
	if amod.Annotations != nil {
		objectMap["annotations"] = amod.Annotations
	}
	if amod.Folder != nil {
		objectMap["folder"] = amod.Folder
	}
	if amod.Type != "" {
		objectMap["type"] = amod.Type
	}
	for k, v := range amod.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsGoogleAdWordsObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsGoogleAdWordsObjectDataset() (*GoogleAdWordsObjectDataset, bool) {
	return nil, false
}

// AsAzureDataExplorerTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsAzureDataExplorerTableDataset() (*AzureDataExplorerTableDataset, bool) {
	return nil, false
}

// AsOracleServiceCloudObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsOracleServiceCloudObjectDataset() (*OracleServiceCloudObjectDataset, bool) {
	return nil, false
}

// AsDynamicsAXResourceDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsDynamicsAXResourceDataset() (*DynamicsAXResourceDataset, bool) {
	return nil, false
}

// AsResponsysObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsResponsysObjectDataset() (*ResponsysObjectDataset, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsSalesforceMarketingCloudObjectDataset() (*SalesforceMarketingCloudObjectDataset, bool) {
	return nil, false
}

// AsVerticaTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsVerticaTableDataset() (*VerticaTableDataset, bool) {
	return nil, false
}

// AsNetezzaTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsNetezzaTableDataset() (*NetezzaTableDataset, bool) {
	return nil, false
}

// AsZohoObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsZohoObjectDataset() (*ZohoObjectDataset, bool) {
	return nil, false
}

// AsXeroObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsXeroObjectDataset() (*XeroObjectDataset, bool) {
	return nil, false
}

// AsSquareObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsSquareObjectDataset() (*SquareObjectDataset, bool) {
	return nil, false
}

// AsSparkObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsSparkObjectDataset() (*SparkObjectDataset, bool) {
	return nil, false
}

// AsShopifyObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsShopifyObjectDataset() (*ShopifyObjectDataset, bool) {
	return nil, false
}

// AsServiceNowObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsServiceNowObjectDataset() (*ServiceNowObjectDataset, bool) {
	return nil, false
}

// AsQuickBooksObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsQuickBooksObjectDataset() (*QuickBooksObjectDataset, bool) {
	return nil, false
}

// AsPrestoObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsPrestoObjectDataset() (*PrestoObjectDataset, bool) {
	return nil, false
}

// AsPhoenixObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsPhoenixObjectDataset() (*PhoenixObjectDataset, bool) {
	return nil, false
}

// AsPaypalObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsPaypalObjectDataset() (*PaypalObjectDataset, bool) {
	return nil, false
}

// AsMarketoObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsMarketoObjectDataset() (*MarketoObjectDataset, bool) {
	return nil, false
}

// AsMariaDBTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsMariaDBTableDataset() (*MariaDBTableDataset, bool) {
	return nil, false
}

// AsMagentoObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsMagentoObjectDataset() (*MagentoObjectDataset, bool) {
	return nil, false
}

// AsJiraObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsJiraObjectDataset() (*JiraObjectDataset, bool) {
	return nil, false
}

// AsImpalaObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsImpalaObjectDataset() (*ImpalaObjectDataset, bool) {
	return nil, false
}

// AsHubspotObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsHubspotObjectDataset() (*HubspotObjectDataset, bool) {
	return nil, false
}

// AsHiveObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsHiveObjectDataset() (*HiveObjectDataset, bool) {
	return nil, false
}

// AsHBaseObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsHBaseObjectDataset() (*HBaseObjectDataset, bool) {
	return nil, false
}

// AsGreenplumTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsGreenplumTableDataset() (*GreenplumTableDataset, bool) {
	return nil, false
}

// AsGoogleBigQueryObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsGoogleBigQueryObjectDataset() (*GoogleBigQueryObjectDataset, bool) {
	return nil, false
}

// AsEloquaObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsEloquaObjectDataset() (*EloquaObjectDataset, bool) {
	return nil, false
}

// AsDrillTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsDrillTableDataset() (*DrillTableDataset, bool) {
	return nil, false
}

// AsCouchbaseTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsCouchbaseTableDataset() (*CouchbaseTableDataset, bool) {
	return nil, false
}

// AsConcurObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsConcurObjectDataset() (*ConcurObjectDataset, bool) {
	return nil, false
}

// AsAzurePostgreSQLTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsAzurePostgreSQLTableDataset() (*AzurePostgreSQLTableDataset, bool) {
	return nil, false
}

// AsAmazonMWSObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsAmazonMWSObjectDataset() (*AmazonMWSObjectDataset, bool) {
	return &amod, true
}

// AsHTTPDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsHTTPDataset() (*HTTPDataset, bool) {
	return nil, false
}

// AsAzureSearchIndexDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsAzureSearchIndexDataset() (*AzureSearchIndexDataset, bool) {
	return nil, false
}

// AsWebTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsWebTableDataset() (*WebTableDataset, bool) {
	return nil, false
}

// AsRestResourceDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsRestResourceDataset() (*RestResourceDataset, bool) {
	return nil, false
}

// AsSQLServerTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsSQLServerTableDataset() (*SQLServerTableDataset, bool) {
	return nil, false
}

// AsSapOpenHubTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsSapOpenHubTableDataset() (*SapOpenHubTableDataset, bool) {
	return nil, false
}

// AsSapEccResourceDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsSapEccResourceDataset() (*SapEccResourceDataset, bool) {
	return nil, false
}

// AsSapCloudForCustomerResourceDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsSapCloudForCustomerResourceDataset() (*SapCloudForCustomerResourceDataset, bool) {
	return nil, false
}

// AsSalesforceObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsSalesforceObjectDataset() (*SalesforceObjectDataset, bool) {
	return nil, false
}

// AsRelationalTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsRelationalTableDataset() (*RelationalTableDataset, bool) {
	return nil, false
}

// AsAzureMySQLTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsAzureMySQLTableDataset() (*AzureMySQLTableDataset, bool) {
	return nil, false
}

// AsOracleTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsOracleTableDataset() (*OracleTableDataset, bool) {
	return nil, false
}

// AsODataResourceDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsODataResourceDataset() (*ODataResourceDataset, bool) {
	return nil, false
}

// AsCosmosDbMongoDbAPICollectionDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsCosmosDbMongoDbAPICollectionDataset() (*CosmosDbMongoDbAPICollectionDataset, bool) {
	return nil, false
}

// AsMongoDbV2CollectionDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsMongoDbV2CollectionDataset() (*MongoDbV2CollectionDataset, bool) {
	return nil, false
}

// AsMongoDbCollectionDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsMongoDbCollectionDataset() (*MongoDbCollectionDataset, bool) {
	return nil, false
}

// AsFileShareDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsFileShareDataset() (*FileShareDataset, bool) {
	return nil, false
}

// AsOffice365Dataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsOffice365Dataset() (*Office365Dataset, bool) {
	return nil, false
}

// AsAzureBlobFSDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsAzureBlobFSDataset() (*AzureBlobFSDataset, bool) {
	return nil, false
}

// AsAzureDataLakeStoreDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsAzureDataLakeStoreDataset() (*AzureDataLakeStoreDataset, bool) {
	return nil, false
}

// AsDynamicsEntityDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsDynamicsEntityDataset() (*DynamicsEntityDataset, bool) {
	return nil, false
}

// AsDocumentDbCollectionDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsDocumentDbCollectionDataset() (*DocumentDbCollectionDataset, bool) {
	return nil, false
}

// AsCustomDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsCustomDataset() (*CustomDataset, bool) {
	return nil, false
}

// AsCassandraTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsCassandraTableDataset() (*CassandraTableDataset, bool) {
	return nil, false
}

// AsAzureSQLDWTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsAzureSQLDWTableDataset() (*AzureSQLDWTableDataset, bool) {
	return nil, false
}

// AsAzureSQLTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsAzureSQLTableDataset() (*AzureSQLTableDataset, bool) {
	return nil, false
}

// AsAzureTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsAzureTableDataset() (*AzureTableDataset, bool) {
	return nil, false
}

// AsAzureBlobDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsAzureBlobDataset() (*AzureBlobDataset, bool) {
	return nil, false
}

// AsAmazonS3Dataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsAmazonS3Dataset() (*AmazonS3Dataset, bool) {
	return nil, false
}

// AsDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsDataset() (*Dataset, bool) {
	return nil, false
}

// AsBasicDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsBasicDataset() (BasicDataset, bool) {
	return &amod, true
}

// UnmarshalJSON is the custom unmarshaler for AmazonMWSObjectDataset struct.
func (amod *AmazonMWSObjectDataset) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var genericDatasetTypeProperties GenericDatasetTypeProperties
				err = json.Unmarshal(*v, &genericDatasetTypeProperties)
				if err != nil {
					return err
				}
				amod.GenericDatasetTypeProperties = &genericDatasetTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if amod.AdditionalProperties == nil {
					amod.AdditionalProperties = make(map[string]interface{})
				}
				amod.AdditionalProperties[k] = additionalProperties
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				amod.Description = &description
			}
		case "structure":
			if v != nil {
				var structure interface{}
				err = json.Unmarshal(*v, &structure)
				if err != nil {
					return err
				}
				amod.Structure = structure
			}
		case "schema":
			if v != nil {
				var schema interface{}
				err = json.Unmarshal(*v, &schema)
				if err != nil {
					return err
				}
				amod.Schema = schema
			}
		case "linkedServiceName":
			if v != nil {
				var linkedServiceName LinkedServiceReference
				err = json.Unmarshal(*v, &linkedServiceName)
				if err != nil {
					return err
				}
				amod.LinkedServiceName = &linkedServiceName
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				amod.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				amod.Annotations = &annotations
			}
		case "folder":
			if v != nil {
				var folder DatasetFolder
				err = json.Unmarshal(*v, &folder)
				if err != nil {
					return err
				}
				amod.Folder = &folder
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicDataset
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				amod.Type = typeVar
			}
		}
	}

	return nil
}

// AmazonMWSSource a copy activity Amazon Marketplace Web Service source.
type AmazonMWSSource struct {
	// Query - A query to retrieve data from source. Type: string (or Expression with resultType string).
	Query interface{} `json:"query,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// SourceRetryCount - Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`
	// SourceRetryWait - Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
	// MaxConcurrentConnections - The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`
	// Type - Possible values include: 'TypeCopySource', 'TypeAmazonRedshiftSource', 'TypeGoogleAdWordsSource', 'TypeOracleServiceCloudSource', 'TypeDynamicsAXSource', 'TypeResponsysSource', 'TypeSalesforceMarketingCloudSource', 'TypeVerticaSource', 'TypeNetezzaSource', 'TypeZohoSource', 'TypeXeroSource', 'TypeSquareSource', 'TypeSparkSource', 'TypeShopifySource', 'TypeServiceNowSource', 'TypeQuickBooksSource', 'TypePrestoSource', 'TypePhoenixSource', 'TypePaypalSource', 'TypeMarketoSource', 'TypeMariaDBSource', 'TypeMagentoSource', 'TypeJiraSource', 'TypeImpalaSource', 'TypeHubspotSource', 'TypeHiveSource', 'TypeHBaseSource', 'TypeGreenplumSource', 'TypeGoogleBigQuerySource', 'TypeEloquaSource', 'TypeDrillSource', 'TypeCouchbaseSource', 'TypeConcurSource', 'TypeAzurePostgreSQLSource', 'TypeAmazonMWSSource', 'TypeHTTPSource', 'TypeAzureBlobFSSource', 'TypeAzureDataLakeStoreSource', 'TypeOffice365Source', 'TypeCosmosDbMongoDbAPISource', 'TypeMongoDbV2Source', 'TypeMongoDbSource', 'TypeCassandraSource', 'TypeWebSource', 'TypeOracleSource', 'TypeAzureDataExplorerSource', 'TypeAzureMySQLSource', 'TypeHdfsSource', 'TypeFileSystemSource', 'TypeSQLDWSource', 'TypeSQLSource', 'TypeRestSource', 'TypeSapOpenHubSource', 'TypeSapEccSource', 'TypeSapCloudForCustomerSource', 'TypeSalesforceSource', 'TypeRelationalSource', 'TypeDynamicsSource', 'TypeDocumentDbCollectionSource', 'TypeBlobSource', 'TypeAzureTableSource'
	Type TypeBasicCopySource `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AmazonMWSSource.
func (ams AmazonMWSSource) MarshalJSON() ([]byte, error) {
	ams.Type = TypeAmazonMWSSource
	objectMap := make(map[string]interface{})
	if ams.Query != nil {
		objectMap["query"] = ams.Query
	}
	if ams.SourceRetryCount != nil {
		objectMap["sourceRetryCount"] = ams.SourceRetryCount
	}
	if ams.SourceRetryWait != nil {
		objectMap["sourceRetryWait"] = ams.SourceRetryWait
	}
	if ams.MaxConcurrentConnections != nil {
		objectMap["maxConcurrentConnections"] = ams.MaxConcurrentConnections
	}
	if ams.Type != "" {
		objectMap["type"] = ams.Type
	}
	for k, v := range ams.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsAmazonRedshiftSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsAmazonRedshiftSource() (*AmazonRedshiftSource, bool) {
	return nil, false
}

// AsGoogleAdWordsSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsGoogleAdWordsSource() (*GoogleAdWordsSource, bool) {
	return nil, false
}

// AsOracleServiceCloudSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsOracleServiceCloudSource() (*OracleServiceCloudSource, bool) {
	return nil, false
}

// AsDynamicsAXSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsDynamicsAXSource() (*DynamicsAXSource, bool) {
	return nil, false
}

// AsResponsysSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsResponsysSource() (*ResponsysSource, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsSalesforceMarketingCloudSource() (*SalesforceMarketingCloudSource, bool) {
	return nil, false
}

// AsVerticaSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsVerticaSource() (*VerticaSource, bool) {
	return nil, false
}

// AsNetezzaSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsNetezzaSource() (*NetezzaSource, bool) {
	return nil, false
}

// AsZohoSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsZohoSource() (*ZohoSource, bool) {
	return nil, false
}

// AsXeroSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsXeroSource() (*XeroSource, bool) {
	return nil, false
}

// AsSquareSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsSquareSource() (*SquareSource, bool) {
	return nil, false
}

// AsSparkSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsSparkSource() (*SparkSource, bool) {
	return nil, false
}

// AsShopifySource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsShopifySource() (*ShopifySource, bool) {
	return nil, false
}

// AsServiceNowSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsServiceNowSource() (*ServiceNowSource, bool) {
	return nil, false
}

// AsQuickBooksSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsQuickBooksSource() (*QuickBooksSource, bool) {
	return nil, false
}

// AsPrestoSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsPrestoSource() (*PrestoSource, bool) {
	return nil, false
}

// AsPhoenixSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsPhoenixSource() (*PhoenixSource, bool) {
	return nil, false
}

// AsPaypalSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsPaypalSource() (*PaypalSource, bool) {
	return nil, false
}

// AsMarketoSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsMarketoSource() (*MarketoSource, bool) {
	return nil, false
}

// AsMariaDBSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsMariaDBSource() (*MariaDBSource, bool) {
	return nil, false
}

// AsMagentoSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsMagentoSource() (*MagentoSource, bool) {
	return nil, false
}

// AsJiraSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsJiraSource() (*JiraSource, bool) {
	return nil, false
}

// AsImpalaSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsImpalaSource() (*ImpalaSource, bool) {
	return nil, false
}

// AsHubspotSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsHubspotSource() (*HubspotSource, bool) {
	return nil, false
}

// AsHiveSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsHiveSource() (*HiveSource, bool) {
	return nil, false
}

// AsHBaseSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsHBaseSource() (*HBaseSource, bool) {
	return nil, false
}

// AsGreenplumSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsGreenplumSource() (*GreenplumSource, bool) {
	return nil, false
}

// AsGoogleBigQuerySource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsGoogleBigQuerySource() (*GoogleBigQuerySource, bool) {
	return nil, false
}

// AsEloquaSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsEloquaSource() (*EloquaSource, bool) {
	return nil, false
}

// AsDrillSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsDrillSource() (*DrillSource, bool) {
	return nil, false
}

// AsCouchbaseSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsCouchbaseSource() (*CouchbaseSource, bool) {
	return nil, false
}

// AsConcurSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsConcurSource() (*ConcurSource, bool) {
	return nil, false
}

// AsAzurePostgreSQLSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsAzurePostgreSQLSource() (*AzurePostgreSQLSource, bool) {
	return nil, false
}

// AsAmazonMWSSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsAmazonMWSSource() (*AmazonMWSSource, bool) {
	return &ams, true
}

// AsHTTPSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsHTTPSource() (*HTTPSource, bool) {
	return nil, false
}

// AsAzureBlobFSSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsAzureBlobFSSource() (*AzureBlobFSSource, bool) {
	return nil, false
}

// AsAzureDataLakeStoreSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsAzureDataLakeStoreSource() (*AzureDataLakeStoreSource, bool) {
	return nil, false
}

// AsOffice365Source is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsOffice365Source() (*Office365Source, bool) {
	return nil, false
}

// AsCosmosDbMongoDbAPISource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsCosmosDbMongoDbAPISource() (*CosmosDbMongoDbAPISource, bool) {
	return nil, false
}

// AsMongoDbV2Source is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsMongoDbV2Source() (*MongoDbV2Source, bool) {
	return nil, false
}

// AsMongoDbSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsMongoDbSource() (*MongoDbSource, bool) {
	return nil, false
}

// AsCassandraSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsCassandraSource() (*CassandraSource, bool) {
	return nil, false
}

// AsWebSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsWebSource() (*WebSource, bool) {
	return nil, false
}

// AsOracleSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsOracleSource() (*OracleSource, bool) {
	return nil, false
}

// AsAzureDataExplorerSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsAzureDataExplorerSource() (*AzureDataExplorerSource, bool) {
	return nil, false
}

// AsAzureMySQLSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsAzureMySQLSource() (*AzureMySQLSource, bool) {
	return nil, false
}

// AsHdfsSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsHdfsSource() (*HdfsSource, bool) {
	return nil, false
}

// AsFileSystemSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsFileSystemSource() (*FileSystemSource, bool) {
	return nil, false
}

// AsSQLDWSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsSQLDWSource() (*SQLDWSource, bool) {
	return nil, false
}

// AsSQLSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsSQLSource() (*SQLSource, bool) {
	return nil, false
}

// AsRestSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsRestSource() (*RestSource, bool) {
	return nil, false
}

// AsSapOpenHubSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsSapOpenHubSource() (*SapOpenHubSource, bool) {
	return nil, false
}

// AsSapEccSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsSapEccSource() (*SapEccSource, bool) {
	return nil, false
}

// AsSapCloudForCustomerSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsSapCloudForCustomerSource() (*SapCloudForCustomerSource, bool) {
	return nil, false
}

// AsSalesforceSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsSalesforceSource() (*SalesforceSource, bool) {
	return nil, false
}

// AsRelationalSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsRelationalSource() (*RelationalSource, bool) {
	return nil, false
}

// AsDynamicsSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsDynamicsSource() (*DynamicsSource, bool) {
	return nil, false
}

// AsDocumentDbCollectionSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsDocumentDbCollectionSource() (*DocumentDbCollectionSource, bool) {
	return nil, false
}

// AsBlobSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsBlobSource() (*BlobSource, bool) {
	return nil, false
}

// AsAzureTableSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsAzureTableSource() (*AzureTableSource, bool) {
	return nil, false
}

// AsCopySource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsCopySource() (*CopySource, bool) {
	return nil, false
}

// AsBasicCopySource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsBasicCopySource() (BasicCopySource, bool) {
	return &ams, true
}

// UnmarshalJSON is the custom unmarshaler for AmazonMWSSource struct.
func (ams *AmazonMWSSource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "query":
			if v != nil {
				var query interface{}
				err = json.Unmarshal(*v, &query)
				if err != nil {
					return err
				}
				ams.Query = query
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if ams.AdditionalProperties == nil {
					ams.AdditionalProperties = make(map[string]interface{})
				}
				ams.AdditionalProperties[k] = additionalProperties
			}
		case "sourceRetryCount":
			if v != nil {
				var sourceRetryCount interface{}
				err = json.Unmarshal(*v, &sourceRetryCount)
				if err != nil {
					return err
				}
				ams.SourceRetryCount = sourceRetryCount
			}
		case "sourceRetryWait":
			if v != nil {
				var sourceRetryWait interface{}
				err = json.Unmarshal(*v, &sourceRetryWait)
				if err != nil {
					return err
				}
				ams.SourceRetryWait = sourceRetryWait
			}
		case "maxConcurrentConnections":
			if v != nil {
				var maxConcurrentConnections interface{}
				err = json.Unmarshal(*v, &maxConcurrentConnections)
				if err != nil {
					return err
				}
				ams.MaxConcurrentConnections = maxConcurrentConnections
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicCopySource
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ams.Type = typeVar
			}
		}
	}

	return nil
}

// AmazonRedshiftLinkedService linked service for Amazon Redshift.
type AmazonRedshiftLinkedService struct {
	// AmazonRedshiftLinkedServiceTypeProperties - Amazon Redshift linked service properties.
	*AmazonRedshiftLinkedServiceTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Parameters - Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the linked service.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Type - Possible values include: 'TypeLinkedService', 'TypeAzureFunction', 'TypeAzureDataExplorer', 'TypeGoogleAdWords', 'TypeOracleServiceCloud', 'TypeDynamicsAX', 'TypeResponsys', 'TypeAzureDatabricks', 'TypeAzureDataLakeAnalytics', 'TypeHDInsightOnDemand', 'TypeSalesforceMarketingCloud', 'TypeNetezza', 'TypeVertica', 'TypeZoho', 'TypeXero', 'TypeSquare', 'TypeSpark', 'TypeShopify', 'TypeServiceNow', 'TypeQuickBooks', 'TypePresto', 'TypePhoenix', 'TypePaypal', 'TypeMarketo', 'TypeMariaDB', 'TypeMagento', 'TypeJira', 'TypeImpala', 'TypeHubspot', 'TypeHive', 'TypeHBase', 'TypeGreenplum', 'TypeGoogleBigQuery', 'TypeEloqua', 'TypeDrill', 'TypeCouchbase', 'TypeConcur', 'TypeAzurePostgreSQL', 'TypeAmazonMWS', 'TypeSapHana', 'TypeSapBW', 'TypeSftp', 'TypeFtpServer', 'TypeHTTPServer', 'TypeAzureSearch', 'TypeCustomDataSource', 'TypeAmazonRedshift', 'TypeAmazonS3', 'TypeRestService', 'TypeSapOpenHub', 'TypeSapEcc', 'TypeSapCloudForCustomer', 'TypeSalesforce', 'TypeOffice365', 'TypeAzureBlobFS', 'TypeAzureDataLakeStore', 'TypeCosmosDbMongoDbAPI', 'TypeMongoDbV2', 'TypeMongoDb', 'TypeCassandra', 'TypeWeb', 'TypeOData', 'TypeHdfs', 'TypeOdbc', 'TypeAzureML', 'TypeTeradata', 'TypeDb2', 'TypeSybase', 'TypePostgreSQL', 'TypeMySQL', 'TypeAzureMySQL', 'TypeOracle', 'TypeFileServer', 'TypeHDInsight', 'TypeDynamics', 'TypeCosmosDb', 'TypeAzureKeyVault', 'TypeAzureBatch', 'TypeAzureSQLDatabase', 'TypeSQLServer', 'TypeAzureSQLDW', 'TypeAzureTableStorage', 'TypeAzureBlobStorage', 'TypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) MarshalJSON() ([]byte, error) {
	arls.Type = TypeAmazonRedshift
	objectMap := make(map[string]interface{})
	if arls.AmazonRedshiftLinkedServiceTypeProperties != nil {
		objectMap["typeProperties"] = arls.AmazonRedshiftLinkedServiceTypeProperties
	}
	if arls.ConnectVia != nil {
		objectMap["connectVia"] = arls.ConnectVia
	}
	if arls.Description != nil {
		objectMap["description"] = arls.Description
	}
	if arls.Parameters != nil {
		objectMap["parameters"] = arls.Parameters
	}
	if arls.Annotations != nil {
		objectMap["annotations"] = arls.Annotations
	}
	if arls.Type != "" {
		objectMap["type"] = arls.Type
	}
	for k, v := range arls.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsAzureFunctionLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzureFunctionLinkedService() (*AzureFunctionLinkedService, bool) {
	return nil, false
}

// AsAzureDataExplorerLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzureDataExplorerLinkedService() (*AzureDataExplorerLinkedService, bool) {
	return nil, false
}

// AsGoogleAdWordsLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsGoogleAdWordsLinkedService() (*GoogleAdWordsLinkedService, bool) {
	return nil, false
}

// AsOracleServiceCloudLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsOracleServiceCloudLinkedService() (*OracleServiceCloudLinkedService, bool) {
	return nil, false
}

// AsDynamicsAXLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsDynamicsAXLinkedService() (*DynamicsAXLinkedService, bool) {
	return nil, false
}

// AsResponsysLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsResponsysLinkedService() (*ResponsysLinkedService, bool) {
	return nil, false
}

// AsAzureDatabricksLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzureDatabricksLinkedService() (*AzureDatabricksLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return nil, false
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsSalesforceMarketingCloudLinkedService() (*SalesforceMarketingCloudLinkedService, bool) {
	return nil, false
}

// AsNetezzaLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsNetezzaLinkedService() (*NetezzaLinkedService, bool) {
	return nil, false
}

// AsVerticaLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsVerticaLinkedService() (*VerticaLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return nil, false
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return nil, false
}

// AsConcurLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return nil, false
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return nil, false
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return nil, false
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return nil, false
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return nil, false
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return &arls, true
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return nil, false
}

// AsRestServiceLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsRestServiceLinkedService() (*RestServiceLinkedService, bool) {
	return nil, false
}

// AsSapOpenHubLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsSapOpenHubLinkedService() (*SapOpenHubLinkedService, bool) {
	return nil, false
}

// AsSapEccLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsSapEccLinkedService() (*SapEccLinkedService, bool) {
	return nil, false
}

// AsSapCloudForCustomerLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsSapCloudForCustomerLinkedService() (*SapCloudForCustomerLinkedService, bool) {
	return nil, false
}

// AsSalesforceLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsSalesforceLinkedService() (*SalesforceLinkedService, bool) {
	return nil, false
}

// AsOffice365LinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsOffice365LinkedService() (*Office365LinkedService, bool) {
	return nil, false
}

// AsAzureBlobFSLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzureBlobFSLinkedService() (*AzureBlobFSLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzureDataLakeStoreLinkedService() (*AzureDataLakeStoreLinkedService, bool) {
	return nil, false
}

// AsCosmosDbMongoDbAPILinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsCosmosDbMongoDbAPILinkedService() (*CosmosDbMongoDbAPILinkedService, bool) {
	return nil, false
}

// AsMongoDbV2LinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsMongoDbV2LinkedService() (*MongoDbV2LinkedService, bool) {
	return nil, false
}

// AsMongoDbLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsMongoDbLinkedService() (*MongoDbLinkedService, bool) {
	return nil, false
}

// AsCassandraLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsCassandraLinkedService() (*CassandraLinkedService, bool) {
	return nil, false
}

// AsWebLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsWebLinkedService() (*WebLinkedService, bool) {
	return nil, false
}

// AsODataLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsODataLinkedService() (*ODataLinkedService, bool) {
	return nil, false
}

// AsHdfsLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsHdfsLinkedService() (*HdfsLinkedService, bool) {
	return nil, false
}

// AsOdbcLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsOdbcLinkedService() (*OdbcLinkedService, bool) {
	return nil, false
}

// AsAzureMLLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzureMLLinkedService() (*AzureMLLinkedService, bool) {
	return nil, false
}

// AsTeradataLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsTeradataLinkedService() (*TeradataLinkedService, bool) {
	return nil, false
}

// AsDb2LinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsDb2LinkedService() (*Db2LinkedService, bool) {
	return nil, false
}

// AsSybaseLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsSybaseLinkedService() (*SybaseLinkedService, bool) {
	return nil, false
}

// AsPostgreSQLLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsPostgreSQLLinkedService() (*PostgreSQLLinkedService, bool) {
	return nil, false
}

// AsMySQLLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsMySQLLinkedService() (*MySQLLinkedService, bool) {
	return nil, false
}

// AsAzureMySQLLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzureMySQLLinkedService() (*AzureMySQLLinkedService, bool) {
	return nil, false
}

// AsOracleLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsOracleLinkedService() (*OracleLinkedService, bool) {
	return nil, false
}

// AsFileServerLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsFileServerLinkedService() (*FileServerLinkedService, bool) {
	return nil, false
}

// AsHDInsightLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsHDInsightLinkedService() (*HDInsightLinkedService, bool) {
	return nil, false
}

// AsDynamicsLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsDynamicsLinkedService() (*DynamicsLinkedService, bool) {
	return nil, false
}

// AsCosmosDbLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsCosmosDbLinkedService() (*CosmosDbLinkedService, bool) {
	return nil, false
}

// AsAzureKeyVaultLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzureKeyVaultLinkedService() (*AzureKeyVaultLinkedService, bool) {
	return nil, false
}

// AsAzureBatchLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzureBatchLinkedService() (*AzureBatchLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDatabaseLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzureSQLDatabaseLinkedService() (*AzureSQLDatabaseLinkedService, bool) {
	return nil, false
}

// AsSQLServerLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsSQLServerLinkedService() (*SQLServerLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDWLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzureSQLDWLinkedService() (*AzureSQLDWLinkedService, bool) {
	return nil, false
}

// AsAzureTableStorageLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzureTableStorageLinkedService() (*AzureTableStorageLinkedService, bool) {
	return nil, false
}

// AsAzureBlobStorageLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzureBlobStorageLinkedService() (*AzureBlobStorageLinkedService, bool) {
	return nil, false
}

// AsAzureStorageLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzureStorageLinkedService() (*AzureStorageLinkedService, bool) {
	return nil, false
}

// AsLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsLinkedService() (*LinkedService, bool) {
	return nil, false
}

// AsBasicLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsBasicLinkedService() (BasicLinkedService, bool) {
	return &arls, true
}

// UnmarshalJSON is the custom unmarshaler for AmazonRedshiftLinkedService struct.
func (arls *AmazonRedshiftLinkedService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var amazonRedshiftLinkedServiceTypeProperties AmazonRedshiftLinkedServiceTypeProperties
				err = json.Unmarshal(*v, &amazonRedshiftLinkedServiceTypeProperties)
				if err != nil {
					return err
				}
				arls.AmazonRedshiftLinkedServiceTypeProperties = &amazonRedshiftLinkedServiceTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if arls.AdditionalProperties == nil {
					arls.AdditionalProperties = make(map[string]interface{})
				}
				arls.AdditionalProperties[k] = additionalProperties
			}
		case "connectVia":
			if v != nil {
				var connectVia IntegrationRuntimeReference
				err = json.Unmarshal(*v, &connectVia)
				if err != nil {
					return err
				}
				arls.ConnectVia = &connectVia
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				arls.Description = &description
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				arls.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				arls.Annotations = &annotations
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicLinkedService
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				arls.Type = typeVar
			}
		}
	}

	return nil
}

// AmazonRedshiftLinkedServiceTypeProperties amazon Redshift linked service properties.
type AmazonRedshiftLinkedServiceTypeProperties struct {
	// Server - The name of the Amazon Redshift server. Type: string (or Expression with resultType string).
	Server interface{} `json:"server,omitempty"`
	// Username - The username of the Amazon Redshift source. Type: string (or Expression with resultType string).
	Username interface{} `json:"username,omitempty"`
	// Password - The password of the Amazon Redshift source.
	Password BasicSecretBase `json:"password,omitempty"`
	// Database - The database name of the Amazon Redshift source. Type: string (or Expression with resultType string).
	Database interface{} `json:"database,omitempty"`
	// Port - The TCP port number that the Amazon Redshift server uses to listen for client connections. The default value is 5439. Type: integer (or Expression with resultType integer).
	Port interface{} `json:"port,omitempty"`
	// EncryptedCredential - The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AmazonRedshiftLinkedServiceTypeProperties struct.
func (arlstp *AmazonRedshiftLinkedServiceTypeProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "server":
			if v != nil {
				var server interface{}
				err = json.Unmarshal(*v, &server)
				if err != nil {
					return err
				}
				arlstp.Server = server
			}
		case "username":
			if v != nil {
				var username interface{}
				err = json.Unmarshal(*v, &username)
				if err != nil {
					return err
				}
				arlstp.Username = username
			}
		case "password":
			if v != nil {
				password, err := unmarshalBasicSecretBase(*v)
				if err != nil {
					return err
				}
				arlstp.Password = password
			}
		case "database":
			if v != nil {
				var databaseVar interface{}
				err = json.Unmarshal(*v, &databaseVar)
				if err != nil {
					return err
				}
				arlstp.Database = databaseVar
			}
		case "port":
			if v != nil {
				var port interface{}
				err = json.Unmarshal(*v, &port)
				if err != nil {
					return err
				}
				arlstp.Port = port
			}
		case "encryptedCredential":
			if v != nil {
				var encryptedCredential interface{}
				err = json.Unmarshal(*v, &encryptedCredential)
				if err != nil {
					return err
				}
				arlstp.EncryptedCredential = encryptedCredential
			}
		}
	}

	return nil
}

// AmazonRedshiftSource a copy activity source for Amazon Redshift Source.
type AmazonRedshiftSource struct {
	// Query - Database query. Type: string (or Expression with resultType string).
	Query interface{} `json:"query,omitempty"`
	// RedshiftUnloadSettings - The Amazon S3 settings needed for the interim Amazon S3 when copying from Amazon Redshift with unload. With this, data from Amazon Redshift source will be unloaded into S3 first and then copied into the targeted sink from the interim S3.
	RedshiftUnloadSettings *RedshiftUnloadSettings `json:"redshiftUnloadSettings,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// SourceRetryCount - Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`
	// SourceRetryWait - Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
	// MaxConcurrentConnections - The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`
	// Type - Possible values include: 'TypeCopySource', 'TypeAmazonRedshiftSource', 'TypeGoogleAdWordsSource', 'TypeOracleServiceCloudSource', 'TypeDynamicsAXSource', 'TypeResponsysSource', 'TypeSalesforceMarketingCloudSource', 'TypeVerticaSource', 'TypeNetezzaSource', 'TypeZohoSource', 'TypeXeroSource', 'TypeSquareSource', 'TypeSparkSource', 'TypeShopifySource', 'TypeServiceNowSource', 'TypeQuickBooksSource', 'TypePrestoSource', 'TypePhoenixSource', 'TypePaypalSource', 'TypeMarketoSource', 'TypeMariaDBSource', 'TypeMagentoSource', 'TypeJiraSource', 'TypeImpalaSource', 'TypeHubspotSource', 'TypeHiveSource', 'TypeHBaseSource', 'TypeGreenplumSource', 'TypeGoogleBigQuerySource', 'TypeEloquaSource', 'TypeDrillSource', 'TypeCouchbaseSource', 'TypeConcurSource', 'TypeAzurePostgreSQLSource', 'TypeAmazonMWSSource', 'TypeHTTPSource', 'TypeAzureBlobFSSource', 'TypeAzureDataLakeStoreSource', 'TypeOffice365Source', 'TypeCosmosDbMongoDbAPISource', 'TypeMongoDbV2Source', 'TypeMongoDbSource', 'TypeCassandraSource', 'TypeWebSource', 'TypeOracleSource', 'TypeAzureDataExplorerSource', 'TypeAzureMySQLSource', 'TypeHdfsSource', 'TypeFileSystemSource', 'TypeSQLDWSource', 'TypeSQLSource', 'TypeRestSource', 'TypeSapOpenHubSource', 'TypeSapEccSource', 'TypeSapCloudForCustomerSource', 'TypeSalesforceSource', 'TypeRelationalSource', 'TypeDynamicsSource', 'TypeDocumentDbCollectionSource', 'TypeBlobSource', 'TypeAzureTableSource'
	Type TypeBasicCopySource `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) MarshalJSON() ([]byte, error) {
	ars.Type = TypeAmazonRedshiftSource
	objectMap := make(map[string]interface{})
	if ars.Query != nil {
		objectMap["query"] = ars.Query
	}
	if ars.RedshiftUnloadSettings != nil {
		objectMap["redshiftUnloadSettings"] = ars.RedshiftUnloadSettings
	}
	if ars.SourceRetryCount != nil {
		objectMap["sourceRetryCount"] = ars.SourceRetryCount
	}
	if ars.SourceRetryWait != nil {
		objectMap["sourceRetryWait"] = ars.SourceRetryWait
	}
	if ars.MaxConcurrentConnections != nil {
		objectMap["maxConcurrentConnections"] = ars.MaxConcurrentConnections
	}
	if ars.Type != "" {
		objectMap["type"] = ars.Type
	}
	for k, v := range ars.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsAmazonRedshiftSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsAmazonRedshiftSource() (*AmazonRedshiftSource, bool) {
	return &ars, true
}

// AsGoogleAdWordsSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsGoogleAdWordsSource() (*GoogleAdWordsSource, bool) {
	return nil, false
}

// AsOracleServiceCloudSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsOracleServiceCloudSource() (*OracleServiceCloudSource, bool) {
	return nil, false
}

// AsDynamicsAXSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsDynamicsAXSource() (*DynamicsAXSource, bool) {
	return nil, false
}

// AsResponsysSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsResponsysSource() (*ResponsysSource, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsSalesforceMarketingCloudSource() (*SalesforceMarketingCloudSource, bool) {
	return nil, false
}

// AsVerticaSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsVerticaSource() (*VerticaSource, bool) {
	return nil, false
}

// AsNetezzaSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsNetezzaSource() (*NetezzaSource, bool) {
	return nil, false
}

// AsZohoSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsZohoSource() (*ZohoSource, bool) {
	return nil, false
}

// AsXeroSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsXeroSource() (*XeroSource, bool) {
	return nil, false
}

// AsSquareSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsSquareSource() (*SquareSource, bool) {
	return nil, false
}

// AsSparkSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsSparkSource() (*SparkSource, bool) {
	return nil, false
}

// AsShopifySource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsShopifySource() (*ShopifySource, bool) {
	return nil, false
}

// AsServiceNowSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsServiceNowSource() (*ServiceNowSource, bool) {
	return nil, false
}

// AsQuickBooksSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsQuickBooksSource() (*QuickBooksSource, bool) {
	return nil, false
}

// AsPrestoSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsPrestoSource() (*PrestoSource, bool) {
	return nil, false
}

// AsPhoenixSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsPhoenixSource() (*PhoenixSource, bool) {
	return nil, false
}

// AsPaypalSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsPaypalSource() (*PaypalSource, bool) {
	return nil, false
}

// AsMarketoSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsMarketoSource() (*MarketoSource, bool) {
	return nil, false
}

// AsMariaDBSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsMariaDBSource() (*MariaDBSource, bool) {
	return nil, false
}

// AsMagentoSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsMagentoSource() (*MagentoSource, bool) {
	return nil, false
}

// AsJiraSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsJiraSource() (*JiraSource, bool) {
	return nil, false
}

// AsImpalaSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsImpalaSource() (*ImpalaSource, bool) {
	return nil, false
}

// AsHubspotSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsHubspotSource() (*HubspotSource, bool) {
	return nil, false
}

// AsHiveSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsHiveSource() (*HiveSource, bool) {
	return nil, false
}

// AsHBaseSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsHBaseSource() (*HBaseSource, bool) {
	return nil, false
}

// AsGreenplumSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsGreenplumSource() (*GreenplumSource, bool) {
	return nil, false
}

// AsGoogleBigQuerySource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsGoogleBigQuerySource() (*GoogleBigQuerySource, bool) {
	return nil, false
}

// AsEloquaSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsEloquaSource() (*EloquaSource, bool) {
	return nil, false
}

// AsDrillSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsDrillSource() (*DrillSource, bool) {
	return nil, false
}

// AsCouchbaseSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsCouchbaseSource() (*CouchbaseSource, bool) {
	return nil, false
}

// AsConcurSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsConcurSource() (*ConcurSource, bool) {
	return nil, false
}

// AsAzurePostgreSQLSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsAzurePostgreSQLSource() (*AzurePostgreSQLSource, bool) {
	return nil, false
}

// AsAmazonMWSSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsAmazonMWSSource() (*AmazonMWSSource, bool) {
	return nil, false
}

// AsHTTPSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsHTTPSource() (*HTTPSource, bool) {
	return nil, false
}

// AsAzureBlobFSSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsAzureBlobFSSource() (*AzureBlobFSSource, bool) {
	return nil, false
}

// AsAzureDataLakeStoreSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsAzureDataLakeStoreSource() (*AzureDataLakeStoreSource, bool) {
	return nil, false
}

// AsOffice365Source is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsOffice365Source() (*Office365Source, bool) {
	return nil, false
}

// AsCosmosDbMongoDbAPISource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsCosmosDbMongoDbAPISource() (*CosmosDbMongoDbAPISource, bool) {
	return nil, false
}

// AsMongoDbV2Source is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsMongoDbV2Source() (*MongoDbV2Source, bool) {
	return nil, false
}

// AsMongoDbSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsMongoDbSource() (*MongoDbSource, bool) {
	return nil, false
}

// AsCassandraSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsCassandraSource() (*CassandraSource, bool) {
	return nil, false
}

// AsWebSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsWebSource() (*WebSource, bool) {
	return nil, false
}

// AsOracleSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsOracleSource() (*OracleSource, bool) {
	return nil, false
}

// AsAzureDataExplorerSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsAzureDataExplorerSource() (*AzureDataExplorerSource, bool) {
	return nil, false
}

// AsAzureMySQLSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsAzureMySQLSource() (*AzureMySQLSource, bool) {
	return nil, false
}

// AsHdfsSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsHdfsSource() (*HdfsSource, bool) {
	return nil, false
}

// AsFileSystemSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsFileSystemSource() (*FileSystemSource, bool) {
	return nil, false
}

// AsSQLDWSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsSQLDWSource() (*SQLDWSource, bool) {
	return nil, false
}

// AsSQLSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsSQLSource() (*SQLSource, bool) {
	return nil, false
}

// AsRestSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsRestSource() (*RestSource, bool) {
	return nil, false
}

// AsSapOpenHubSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsSapOpenHubSource() (*SapOpenHubSource, bool) {
	return nil, false
}

// AsSapEccSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsSapEccSource() (*SapEccSource, bool) {
	return nil, false
}

// AsSapCloudForCustomerSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsSapCloudForCustomerSource() (*SapCloudForCustomerSource, bool) {
	return nil, false
}

// AsSalesforceSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsSalesforceSource() (*SalesforceSource, bool) {
	return nil, false
}

// AsRelationalSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsRelationalSource() (*RelationalSource, bool) {
	return nil, false
}

// AsDynamicsSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsDynamicsSource() (*DynamicsSource, bool) {
	return nil, false
}

// AsDocumentDbCollectionSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsDocumentDbCollectionSource() (*DocumentDbCollectionSource, bool) {
	return nil, false
}

// AsBlobSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsBlobSource() (*BlobSource, bool) {
	return nil, false
}

// AsAzureTableSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsAzureTableSource() (*AzureTableSource, bool) {
	return nil, false
}

// AsCopySource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsCopySource() (*CopySource, bool) {
	return nil, false
}

// AsBasicCopySource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsBasicCopySource() (BasicCopySource, bool) {
	return &ars, true
}

// UnmarshalJSON is the custom unmarshaler for AmazonRedshiftSource struct.
func (ars *AmazonRedshiftSource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "query":
			if v != nil {
				var query interface{}
				err = json.Unmarshal(*v, &query)
				if err != nil {
					return err
				}
				ars.Query = query
			}
		case "redshiftUnloadSettings":
			if v != nil {
				var redshiftUnloadSettings RedshiftUnloadSettings
				err = json.Unmarshal(*v, &redshiftUnloadSettings)
				if err != nil {
					return err
				}
				ars.RedshiftUnloadSettings = &redshiftUnloadSettings
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if ars.AdditionalProperties == nil {
					ars.AdditionalProperties = make(map[string]interface{})
				}
				ars.AdditionalProperties[k] = additionalProperties
			}
		case "sourceRetryCount":
			if v != nil {
				var sourceRetryCount interface{}
				err = json.Unmarshal(*v, &sourceRetryCount)
				if err != nil {
					return err
				}
				ars.SourceRetryCount = sourceRetryCount
			}
		case "sourceRetryWait":
			if v != nil {
				var sourceRetryWait interface{}
				err = json.Unmarshal(*v, &sourceRetryWait)
				if err != nil {
					return err
				}
				ars.SourceRetryWait = sourceRetryWait
			}
		case "maxConcurrentConnections":
			if v != nil {
				var maxConcurrentConnections interface{}
				err = json.Unmarshal(*v, &maxConcurrentConnections)
				if err != nil {
					return err
				}
				ars.MaxConcurrentConnections = maxConcurrentConnections
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicCopySource
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ars.Type = typeVar
			}
		}
	}

	return nil
}

// AmazonS3Dataset a single Amazon Simple Storage Service (S3) object or a set of S3 objects.
type AmazonS3Dataset struct {
	// AmazonS3DatasetTypeProperties - Amazon S3 dataset properties.
	*AmazonS3DatasetTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Description - Dataset description.
	Description *string `json:"description,omitempty"`
	// Structure - Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`
	// Schema - Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType: DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`
	// LinkedServiceName - Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
	// Parameters - Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the Dataset.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Folder - The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`
	// Type - Possible values include: 'TypeDataset', 'TypeGoogleAdWordsObject', 'TypeAzureDataExplorerTable', 'TypeOracleServiceCloudObject', 'TypeDynamicsAXResource', 'TypeResponsysObject', 'TypeSalesforceMarketingCloudObject', 'TypeVerticaTable', 'TypeNetezzaTable', 'TypeZohoObject', 'TypeXeroObject', 'TypeSquareObject', 'TypeSparkObject', 'TypeShopifyObject', 'TypeServiceNowObject', 'TypeQuickBooksObject', 'TypePrestoObject', 'TypePhoenixObject', 'TypePaypalObject', 'TypeMarketoObject', 'TypeMariaDBTable', 'TypeMagentoObject', 'TypeJiraObject', 'TypeImpalaObject', 'TypeHubspotObject', 'TypeHiveObject', 'TypeHBaseObject', 'TypeGreenplumTable', 'TypeGoogleBigQueryObject', 'TypeEloquaObject', 'TypeDrillTable', 'TypeCouchbaseTable', 'TypeConcurObject', 'TypeAzurePostgreSQLTable', 'TypeAmazonMWSObject', 'TypeHTTPFile', 'TypeAzureSearchIndex', 'TypeWebTable', 'TypeRestResource', 'TypeSQLServerTable', 'TypeSapOpenHubTable', 'TypeSapEccResource', 'TypeSapCloudForCustomerResource', 'TypeSalesforceObject', 'TypeRelationalTable', 'TypeAzureMySQLTable', 'TypeOracleTable', 'TypeODataResource', 'TypeCosmosDbMongoDbAPICollection', 'TypeMongoDbV2Collection', 'TypeMongoDbCollection', 'TypeFileShare', 'TypeOffice365Table', 'TypeAzureBlobFSFile', 'TypeAzureDataLakeStoreFile', 'TypeDynamicsEntity', 'TypeDocumentDbCollection', 'TypeCustomDataset', 'TypeCassandraTable', 'TypeAzureSQLDWTable', 'TypeAzureSQLTable', 'TypeAzureTable', 'TypeAzureBlob', 'TypeAmazonS3Object'
	Type TypeBasicDataset `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AmazonS3Dataset.
func (asd AmazonS3Dataset) MarshalJSON() ([]byte, error) {
	asd.Type = TypeAmazonS3Object
	objectMap := make(map[string]interface{})
	if asd.AmazonS3DatasetTypeProperties != nil {
		objectMap["typeProperties"] = asd.AmazonS3DatasetTypeProperties
	}
	if asd.Description != nil {
		objectMap["description"] = asd.Description
	}
	if asd.Structure != nil {
		objectMap["structure"] = asd.Structure
	}
	if asd.Schema != nil {
		objectMap["schema"] = asd.Schema
	}
	if asd.LinkedServiceName != nil {
		objectMap["linkedServiceName"] = asd.LinkedServiceName
	}
	if asd.Parameters != nil {
		objectMap["parameters"] = asd.Parameters
	}
	if asd.Annotations != nil {
		objectMap["annotations"] = asd.Annotations
	}
	if asd.Folder != nil {
		objectMap["folder"] = asd.Folder
	}
	if asd.Type != "" {
		objectMap["type"] = asd.Type
	}
	for k, v := range asd.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsGoogleAdWordsObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsGoogleAdWordsObjectDataset() (*GoogleAdWordsObjectDataset, bool) {
	return nil, false
}

// AsAzureDataExplorerTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsAzureDataExplorerTableDataset() (*AzureDataExplorerTableDataset, bool) {
	return nil, false
}

// AsOracleServiceCloudObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsOracleServiceCloudObjectDataset() (*OracleServiceCloudObjectDataset, bool) {
	return nil, false
}

// AsDynamicsAXResourceDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsDynamicsAXResourceDataset() (*DynamicsAXResourceDataset, bool) {
	return nil, false
}

// AsResponsysObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsResponsysObjectDataset() (*ResponsysObjectDataset, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsSalesforceMarketingCloudObjectDataset() (*SalesforceMarketingCloudObjectDataset, bool) {
	return nil, false
}

// AsVerticaTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsVerticaTableDataset() (*VerticaTableDataset, bool) {
	return nil, false
}

// AsNetezzaTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsNetezzaTableDataset() (*NetezzaTableDataset, bool) {
	return nil, false
}

// AsZohoObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsZohoObjectDataset() (*ZohoObjectDataset, bool) {
	return nil, false
}

// AsXeroObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsXeroObjectDataset() (*XeroObjectDataset, bool) {
	return nil, false
}

// AsSquareObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsSquareObjectDataset() (*SquareObjectDataset, bool) {
	return nil, false
}

// AsSparkObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsSparkObjectDataset() (*SparkObjectDataset, bool) {
	return nil, false
}

// AsShopifyObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsShopifyObjectDataset() (*ShopifyObjectDataset, bool) {
	return nil, false
}

// AsServiceNowObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsServiceNowObjectDataset() (*ServiceNowObjectDataset, bool) {
	return nil, false
}

// AsQuickBooksObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsQuickBooksObjectDataset() (*QuickBooksObjectDataset, bool) {
	return nil, false
}

// AsPrestoObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsPrestoObjectDataset() (*PrestoObjectDataset, bool) {
	return nil, false
}

// AsPhoenixObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsPhoenixObjectDataset() (*PhoenixObjectDataset, bool) {
	return nil, false
}

// AsPaypalObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsPaypalObjectDataset() (*PaypalObjectDataset, bool) {
	return nil, false
}

// AsMarketoObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsMarketoObjectDataset() (*MarketoObjectDataset, bool) {
	return nil, false
}

// AsMariaDBTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsMariaDBTableDataset() (*MariaDBTableDataset, bool) {
	return nil, false
}

// AsMagentoObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsMagentoObjectDataset() (*MagentoObjectDataset, bool) {
	return nil, false
}

// AsJiraObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsJiraObjectDataset() (*JiraObjectDataset, bool) {
	return nil, false
}

// AsImpalaObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsImpalaObjectDataset() (*ImpalaObjectDataset, bool) {
	return nil, false
}

// AsHubspotObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsHubspotObjectDataset() (*HubspotObjectDataset, bool) {
	return nil, false
}

// AsHiveObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsHiveObjectDataset() (*HiveObjectDataset, bool) {
	return nil, false
}

// AsHBaseObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsHBaseObjectDataset() (*HBaseObjectDataset, bool) {
	return nil, false
}

// AsGreenplumTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsGreenplumTableDataset() (*GreenplumTableDataset, bool) {
	return nil, false
}

// AsGoogleBigQueryObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsGoogleBigQueryObjectDataset() (*GoogleBigQueryObjectDataset, bool) {
	return nil, false
}

// AsEloquaObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsEloquaObjectDataset() (*EloquaObjectDataset, bool) {
	return nil, false
}

// AsDrillTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsDrillTableDataset() (*DrillTableDataset, bool) {
	return nil, false
}

// AsCouchbaseTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsCouchbaseTableDataset() (*CouchbaseTableDataset, bool) {
	return nil, false
}

// AsConcurObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsConcurObjectDataset() (*ConcurObjectDataset, bool) {
	return nil, false
}

// AsAzurePostgreSQLTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsAzurePostgreSQLTableDataset() (*AzurePostgreSQLTableDataset, bool) {
	return nil, false
}

// AsAmazonMWSObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsAmazonMWSObjectDataset() (*AmazonMWSObjectDataset, bool) {
	return nil, false
}

// AsHTTPDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsHTTPDataset() (*HTTPDataset, bool) {
	return nil, false
}

// AsAzureSearchIndexDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsAzureSearchIndexDataset() (*AzureSearchIndexDataset, bool) {
	return nil, false
}

// AsWebTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsWebTableDataset() (*WebTableDataset, bool) {
	return nil, false
}

// AsRestResourceDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsRestResourceDataset() (*RestResourceDataset, bool) {
	return nil, false
}

// AsSQLServerTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsSQLServerTableDataset() (*SQLServerTableDataset, bool) {
	return nil, false
}

// AsSapOpenHubTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsSapOpenHubTableDataset() (*SapOpenHubTableDataset, bool) {
	return nil, false
}

// AsSapEccResourceDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsSapEccResourceDataset() (*SapEccResourceDataset, bool) {
	return nil, false
}

// AsSapCloudForCustomerResourceDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsSapCloudForCustomerResourceDataset() (*SapCloudForCustomerResourceDataset, bool) {
	return nil, false
}

// AsSalesforceObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsSalesforceObjectDataset() (*SalesforceObjectDataset, bool) {
	return nil, false
}

// AsRelationalTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsRelationalTableDataset() (*RelationalTableDataset, bool) {
	return nil, false
}

// AsAzureMySQLTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsAzureMySQLTableDataset() (*AzureMySQLTableDataset, bool) {
	return nil, false
}

// AsOracleTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsOracleTableDataset() (*OracleTableDataset, bool) {
	return nil, false
}

// AsODataResourceDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsODataResourceDataset() (*ODataResourceDataset, bool) {
	return nil, false
}

// AsCosmosDbMongoDbAPICollectionDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsCosmosDbMongoDbAPICollectionDataset() (*CosmosDbMongoDbAPICollectionDataset, bool) {
	return nil, false
}

// AsMongoDbV2CollectionDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsMongoDbV2CollectionDataset() (*MongoDbV2CollectionDataset, bool) {
	return nil, false
}

// AsMongoDbCollectionDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsMongoDbCollectionDataset() (*MongoDbCollectionDataset, bool) {
	return nil, false
}

// AsFileShareDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsFileShareDataset() (*FileShareDataset, bool) {
	return nil, false
}

// AsOffice365Dataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsOffice365Dataset() (*Office365Dataset, bool) {
	return nil, false
}

// AsAzureBlobFSDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsAzureBlobFSDataset() (*AzureBlobFSDataset, bool) {
	return nil, false
}

// AsAzureDataLakeStoreDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsAzureDataLakeStoreDataset() (*AzureDataLakeStoreDataset, bool) {
	return nil, false
}

// AsDynamicsEntityDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsDynamicsEntityDataset() (*DynamicsEntityDataset, bool) {
	return nil, false
}

// AsDocumentDbCollectionDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsDocumentDbCollectionDataset() (*DocumentDbCollectionDataset, bool) {
	return nil, false
}

// AsCustomDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsCustomDataset() (*CustomDataset, bool) {
	return nil, false
}

// AsCassandraTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsCassandraTableDataset() (*CassandraTableDataset, bool) {
	return nil, false
}

// AsAzureSQLDWTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsAzureSQLDWTableDataset() (*AzureSQLDWTableDataset, bool) {
	return nil, false
}

// AsAzureSQLTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsAzureSQLTableDataset() (*AzureSQLTableDataset, bool) {
	return nil, false
}

// AsAzureTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsAzureTableDataset() (*AzureTableDataset, bool) {
	return nil, false
}

// AsAzureBlobDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsAzureBlobDataset() (*AzureBlobDataset, bool) {
	return nil, false
}

// AsAmazonS3Dataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsAmazonS3Dataset() (*AmazonS3Dataset, bool) {
	return &asd, true
}

// AsDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsDataset() (*Dataset, bool) {
	return nil, false
}

// AsBasicDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsBasicDataset() (BasicDataset, bool) {
	return &asd, true
}

// UnmarshalJSON is the custom unmarshaler for AmazonS3Dataset struct.
func (asd *AmazonS3Dataset) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var amazonS3DatasetTypeProperties AmazonS3DatasetTypeProperties
				err = json.Unmarshal(*v, &amazonS3DatasetTypeProperties)
				if err != nil {
					return err
				}
				asd.AmazonS3DatasetTypeProperties = &amazonS3DatasetTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if asd.AdditionalProperties == nil {
					asd.AdditionalProperties = make(map[string]interface{})
				}
				asd.AdditionalProperties[k] = additionalProperties
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				asd.Description = &description
			}
		case "structure":
			if v != nil {
				var structure interface{}
				err = json.Unmarshal(*v, &structure)
				if err != nil {
					return err
				}
				asd.Structure = structure
			}
		case "schema":
			if v != nil {
				var schema interface{}
				err = json.Unmarshal(*v, &schema)
				if err != nil {
					return err
				}
				asd.Schema = schema
			}
		case "linkedServiceName":
			if v != nil {
				var linkedServiceName LinkedServiceReference
				err = json.Unmarshal(*v, &linkedServiceName)
				if err != nil {
					return err
				}
				asd.LinkedServiceName = &linkedServiceName
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				asd.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				asd.Annotations = &annotations
			}
		case "folder":
			if v != nil {
				var folder DatasetFolder
				err = json.Unmarshal(*v, &folder)
				if err != nil {
					return err
				}
				asd.Folder = &folder
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicDataset
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				asd.Type = typeVar
			}
		}
	}

	return nil
}

// AmazonS3DatasetTypeProperties amazon S3 dataset properties.
type AmazonS3DatasetTypeProperties struct {
	// BucketName - The name of the Amazon S3 bucket. Type: string (or Expression with resultType string).
	BucketName interface{} `json:"bucketName,omitempty"`
	// Key - The key of the Amazon S3 object. Type: string (or Expression with resultType string).
	Key interface{} `json:"key,omitempty"`
	// Prefix - The prefix filter for the S3 object name. Type: string (or Expression with resultType string).
	Prefix interface{} `json:"prefix,omitempty"`
	// Version - The version for the S3 object. Type: string (or Expression with resultType string).
	Version interface{} `json:"version,omitempty"`
	// ModifiedDatetimeStart - The start of S3 object's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeStart interface{} `json:"modifiedDatetimeStart,omitempty"`
	// ModifiedDatetimeEnd - The end of S3 object's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeEnd interface{} `json:"modifiedDatetimeEnd,omitempty"`
	// Format - The format of files.
	Format BasicDatasetStorageFormat `json:"format,omitempty"`
	// Compression - The data compression method used for the Amazon S3 object.
	Compression BasicDatasetCompression `json:"compression,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AmazonS3DatasetTypeProperties struct.
func (asdtp *AmazonS3DatasetTypeProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "bucketName":
			if v != nil {
				var bucketName interface{}
				err = json.Unmarshal(*v, &bucketName)
				if err != nil {
					return err
				}
				asdtp.BucketName = bucketName
			}
		case "key":
			if v != nil {
				var key interface{}
				err = json.Unmarshal(*v, &key)
				if err != nil {
					return err
				}
				asdtp.Key = key
			}
		case "prefix":
			if v != nil {
				var prefix interface{}
				err = json.Unmarshal(*v, &prefix)
				if err != nil {
					return err
				}
				asdtp.Prefix = prefix
			}
		case "version":
			if v != nil {
				var version interface{}
				err = json.Unmarshal(*v, &version)
				if err != nil {
					return err
				}
				asdtp.Version = version
			}
		case "modifiedDatetimeStart":
			if v != nil {
				var modifiedDatetimeStart interface{}
				err = json.Unmarshal(*v, &modifiedDatetimeStart)
				if err != nil {
					return err
				}
				asdtp.ModifiedDatetimeStart = modifiedDatetimeStart
			}
		case "modifiedDatetimeEnd":
			if v != nil {
				var modifiedDatetimeEnd interface{}
				err = json.Unmarshal(*v, &modifiedDatetimeEnd)
				if err != nil {
					return err
				}
				asdtp.ModifiedDatetimeEnd = modifiedDatetimeEnd
			}
		case "format":
			if v != nil {
				formatVar, err := unmarshalBasicDatasetStorageFormat(*v)
				if err != nil {
					return err
				}
				asdtp.Format = formatVar
			}
		case "compression":
			if v != nil {
				compression, err := unmarshalBasicDatasetCompression(*v)
				if err != nil {
					return err
				}
				asdtp.Compression = compression
			}
		}
	}

	return nil
}

// AmazonS3LinkedService linked service for Amazon S3.
type AmazonS3LinkedService struct {
	// AmazonS3LinkedServiceTypeProperties - Amazon S3 linked service properties.
	*AmazonS3LinkedServiceTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Parameters - Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the linked service.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Type - Possible values include: 'TypeLinkedService', 'TypeAzureFunction', 'TypeAzureDataExplorer', 'TypeGoogleAdWords', 'TypeOracleServiceCloud', 'TypeDynamicsAX', 'TypeResponsys', 'TypeAzureDatabricks', 'TypeAzureDataLakeAnalytics', 'TypeHDInsightOnDemand', 'TypeSalesforceMarketingCloud', 'TypeNetezza', 'TypeVertica', 'TypeZoho', 'TypeXero', 'TypeSquare', 'TypeSpark', 'TypeShopify', 'TypeServiceNow', 'TypeQuickBooks', 'TypePresto', 'TypePhoenix', 'TypePaypal', 'TypeMarketo', 'TypeMariaDB', 'TypeMagento', 'TypeJira', 'TypeImpala', 'TypeHubspot', 'TypeHive', 'TypeHBase', 'TypeGreenplum', 'TypeGoogleBigQuery', 'TypeEloqua', 'TypeDrill', 'TypeCouchbase', 'TypeConcur', 'TypeAzurePostgreSQL', 'TypeAmazonMWS', 'TypeSapHana', 'TypeSapBW', 'TypeSftp', 'TypeFtpServer', 'TypeHTTPServer', 'TypeAzureSearch', 'TypeCustomDataSource', 'TypeAmazonRedshift', 'TypeAmazonS3', 'TypeRestService', 'TypeSapOpenHub', 'TypeSapEcc', 'TypeSapCloudForCustomer', 'TypeSalesforce', 'TypeOffice365', 'TypeAzureBlobFS', 'TypeAzureDataLakeStore', 'TypeCosmosDbMongoDbAPI', 'TypeMongoDbV2', 'TypeMongoDb', 'TypeCassandra', 'TypeWeb', 'TypeOData', 'TypeHdfs', 'TypeOdbc', 'TypeAzureML', 'TypeTeradata', 'TypeDb2', 'TypeSybase', 'TypePostgreSQL', 'TypeMySQL', 'TypeAzureMySQL', 'TypeOracle', 'TypeFileServer', 'TypeHDInsight', 'TypeDynamics', 'TypeCosmosDb', 'TypeAzureKeyVault', 'TypeAzureBatch', 'TypeAzureSQLDatabase', 'TypeSQLServer', 'TypeAzureSQLDW', 'TypeAzureTableStorage', 'TypeAzureBlobStorage', 'TypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) MarshalJSON() ([]byte, error) {
	asls.Type = TypeAmazonS3
	objectMap := make(map[string]interface{})
	if asls.AmazonS3LinkedServiceTypeProperties != nil {
		objectMap["typeProperties"] = asls.AmazonS3LinkedServiceTypeProperties
	}
	if asls.ConnectVia != nil {
		objectMap["connectVia"] = asls.ConnectVia
	}
	if asls.Description != nil {
		objectMap["description"] = asls.Description
	}
	if asls.Parameters != nil {
		objectMap["parameters"] = asls.Parameters
	}
	if asls.Annotations != nil {
		objectMap["annotations"] = asls.Annotations
	}
	if asls.Type != "" {
		objectMap["type"] = asls.Type
	}
	for k, v := range asls.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsAzureFunctionLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzureFunctionLinkedService() (*AzureFunctionLinkedService, bool) {
	return nil, false
}

// AsAzureDataExplorerLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzureDataExplorerLinkedService() (*AzureDataExplorerLinkedService, bool) {
	return nil, false
}

// AsGoogleAdWordsLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsGoogleAdWordsLinkedService() (*GoogleAdWordsLinkedService, bool) {
	return nil, false
}

// AsOracleServiceCloudLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsOracleServiceCloudLinkedService() (*OracleServiceCloudLinkedService, bool) {
	return nil, false
}

// AsDynamicsAXLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsDynamicsAXLinkedService() (*DynamicsAXLinkedService, bool) {
	return nil, false
}

// AsResponsysLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsResponsysLinkedService() (*ResponsysLinkedService, bool) {
	return nil, false
}

// AsAzureDatabricksLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzureDatabricksLinkedService() (*AzureDatabricksLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return nil, false
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsSalesforceMarketingCloudLinkedService() (*SalesforceMarketingCloudLinkedService, bool) {
	return nil, false
}

// AsNetezzaLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsNetezzaLinkedService() (*NetezzaLinkedService, bool) {
	return nil, false
}

// AsVerticaLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsVerticaLinkedService() (*VerticaLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return nil, false
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return nil, false
}

// AsConcurLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return nil, false
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return nil, false
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return nil, false
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return nil, false
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return nil, false
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return nil, false
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return &asls, true
}

// AsRestServiceLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsRestServiceLinkedService() (*RestServiceLinkedService, bool) {
	return nil, false
}

// AsSapOpenHubLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsSapOpenHubLinkedService() (*SapOpenHubLinkedService, bool) {
	return nil, false
}

// AsSapEccLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsSapEccLinkedService() (*SapEccLinkedService, bool) {
	return nil, false
}

// AsSapCloudForCustomerLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsSapCloudForCustomerLinkedService() (*SapCloudForCustomerLinkedService, bool) {
	return nil, false
}

// AsSalesforceLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsSalesforceLinkedService() (*SalesforceLinkedService, bool) {
	return nil, false
}

// AsOffice365LinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsOffice365LinkedService() (*Office365LinkedService, bool) {
	return nil, false
}

// AsAzureBlobFSLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzureBlobFSLinkedService() (*AzureBlobFSLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzureDataLakeStoreLinkedService() (*AzureDataLakeStoreLinkedService, bool) {
	return nil, false
}

// AsCosmosDbMongoDbAPILinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsCosmosDbMongoDbAPILinkedService() (*CosmosDbMongoDbAPILinkedService, bool) {
	return nil, false
}

// AsMongoDbV2LinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsMongoDbV2LinkedService() (*MongoDbV2LinkedService, bool) {
	return nil, false
}

// AsMongoDbLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsMongoDbLinkedService() (*MongoDbLinkedService, bool) {
	return nil, false
}

// AsCassandraLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsCassandraLinkedService() (*CassandraLinkedService, bool) {
	return nil, false
}

// AsWebLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsWebLinkedService() (*WebLinkedService, bool) {
	return nil, false
}

// AsODataLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsODataLinkedService() (*ODataLinkedService, bool) {
	return nil, false
}

// AsHdfsLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsHdfsLinkedService() (*HdfsLinkedService, bool) {
	return nil, false
}

// AsOdbcLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsOdbcLinkedService() (*OdbcLinkedService, bool) {
	return nil, false
}

// AsAzureMLLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzureMLLinkedService() (*AzureMLLinkedService, bool) {
	return nil, false
}

// AsTeradataLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsTeradataLinkedService() (*TeradataLinkedService, bool) {
	return nil, false
}

// AsDb2LinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsDb2LinkedService() (*Db2LinkedService, bool) {
	return nil, false
}

// AsSybaseLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsSybaseLinkedService() (*SybaseLinkedService, bool) {
	return nil, false
}

// AsPostgreSQLLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsPostgreSQLLinkedService() (*PostgreSQLLinkedService, bool) {
	return nil, false
}

// AsMySQLLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsMySQLLinkedService() (*MySQLLinkedService, bool) {
	return nil, false
}

// AsAzureMySQLLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzureMySQLLinkedService() (*AzureMySQLLinkedService, bool) {
	return nil, false
}

// AsOracleLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsOracleLinkedService() (*OracleLinkedService, bool) {
	return nil, false
}

// AsFileServerLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsFileServerLinkedService() (*FileServerLinkedService, bool) {
	return nil, false
}

// AsHDInsightLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsHDInsightLinkedService() (*HDInsightLinkedService, bool) {
	return nil, false
}

// AsDynamicsLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsDynamicsLinkedService() (*DynamicsLinkedService, bool) {
	return nil, false
}

// AsCosmosDbLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsCosmosDbLinkedService() (*CosmosDbLinkedService, bool) {
	return nil, false
}

// AsAzureKeyVaultLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzureKeyVaultLinkedService() (*AzureKeyVaultLinkedService, bool) {
	return nil, false
}

// AsAzureBatchLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzureBatchLinkedService() (*AzureBatchLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDatabaseLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzureSQLDatabaseLinkedService() (*AzureSQLDatabaseLinkedService, bool) {
	return nil, false
}

// AsSQLServerLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsSQLServerLinkedService() (*SQLServerLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDWLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzureSQLDWLinkedService() (*AzureSQLDWLinkedService, bool) {
	return nil, false
}

// AsAzureTableStorageLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzureTableStorageLinkedService() (*AzureTableStorageLinkedService, bool) {
	return nil, false
}

// AsAzureBlobStorageLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzureBlobStorageLinkedService() (*AzureBlobStorageLinkedService, bool) {
	return nil, false
}

// AsAzureStorageLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzureStorageLinkedService() (*AzureStorageLinkedService, bool) {
	return nil, false
}

// AsLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsLinkedService() (*LinkedService, bool) {
	return nil, false
}

// AsBasicLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsBasicLinkedService() (BasicLinkedService, bool) {
	return &asls, true
}

// UnmarshalJSON is the custom unmarshaler for AmazonS3LinkedService struct.
func (asls *AmazonS3LinkedService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var amazonS3LinkedServiceTypeProperties AmazonS3LinkedServiceTypeProperties
				err = json.Unmarshal(*v, &amazonS3LinkedServiceTypeProperties)
				if err != nil {
					return err
				}
				asls.AmazonS3LinkedServiceTypeProperties = &amazonS3LinkedServiceTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if asls.AdditionalProperties == nil {
					asls.AdditionalProperties = make(map[string]interface{})
				}
				asls.AdditionalProperties[k] = additionalProperties
			}
		case "connectVia":
			if v != nil {
				var connectVia IntegrationRuntimeReference
				err = json.Unmarshal(*v, &connectVia)
				if err != nil {
					return err
				}
				asls.ConnectVia = &connectVia
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				asls.Description = &description
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				asls.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				asls.Annotations = &annotations
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicLinkedService
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				asls.Type = typeVar
			}
		}
	}

	return nil
}

// AmazonS3LinkedServiceTypeProperties amazon S3 linked service properties.
type AmazonS3LinkedServiceTypeProperties struct {
	// AccessKeyID - The access key identifier of the Amazon S3 Identity and Access Management (IAM) user. Type: string (or Expression with resultType string).
	AccessKeyID interface{} `json:"accessKeyId,omitempty"`
	// SecretAccessKey - The secret access key of the Amazon S3 Identity and Access Management (IAM) user.
	SecretAccessKey BasicSecretBase `json:"secretAccessKey,omitempty"`
	// ServiceURL - This value specifies the endpoint to access with the S3 Connector. This is an optional property; change it only if you want to try a different service endpoint or want to switch between https and http. Type: string (or Expression with resultType string).
	ServiceURL interface{} `json:"serviceUrl,omitempty"`
	// EncryptedCredential - The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AmazonS3LinkedServiceTypeProperties struct.
func (aslstp *AmazonS3LinkedServiceTypeProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "accessKeyId":
			if v != nil {
				var accessKeyID interface{}
				err = json.Unmarshal(*v, &accessKeyID)
				if err != nil {
					return err
				}
				aslstp.AccessKeyID = accessKeyID
			}
		case "secretAccessKey":
			if v != nil {
				secretAccessKey, err := unmarshalBasicSecretBase(*v)
				if err != nil {
					return err
				}
				aslstp.SecretAccessKey = secretAccessKey
			}
		case "serviceUrl":
			if v != nil {
				var serviceURL interface{}
				err = json.Unmarshal(*v, &serviceURL)
				if err != nil {
					return err
				}
				aslstp.ServiceURL = serviceURL
			}
		case "encryptedCredential":
			if v != nil {
				var encryptedCredential interface{}
				err = json.Unmarshal(*v, &encryptedCredential)
				if err != nil {
					return err
				}
				aslstp.EncryptedCredential = encryptedCredential
			}
		}
	}

	return nil
}

// AppendVariableActivity append value for a Variable of type Array.
type AppendVariableActivity struct {
	// AppendVariableActivityTypeProperties - Append Variable activity properties.
	*AppendVariableActivityTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Name - Activity name.
	Name *string `json:"name,omitempty"`
	// Description - Activity description.
	Description *string `json:"description,omitempty"`
	// DependsOn - Activity depends on condition.
	DependsOn *[]ActivityDependency `json:"dependsOn,omitempty"`
	// UserProperties - Activity user properties.
	UserProperties *[]UserProperty `json:"userProperties,omitempty"`
	// Type - Possible values include: 'TypeActivity', 'TypeAzureFunctionActivity', 'TypeDatabricksSparkPython', 'TypeDatabricksSparkJar', 'TypeDatabricksNotebook', 'TypeDataLakeAnalyticsUSQL', 'TypeAzureMLUpdateResource', 'TypeAzureMLBatchExecution', 'TypeGetMetadata', 'TypeWebActivity', 'TypeLookup', 'TypeDelete', 'TypeSQLServerStoredProcedure', 'TypeCustom', 'TypeExecuteSSISPackage', 'TypeHDInsightSpark', 'TypeHDInsightStreaming', 'TypeHDInsightMapReduce', 'TypeHDInsightPig', 'TypeHDInsightHive', 'TypeCopy', 'TypeExecution', 'TypeWebHook', 'TypeAppendVariable', 'TypeSetVariable', 'TypeFilter', 'TypeValidation', 'TypeUntil', 'TypeWait', 'TypeForEach', 'TypeIfCondition', 'TypeExecutePipeline', 'TypeContainer'
	Type TypeBasicActivity `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AppendVariableActivity.
func (ava AppendVariableActivity) MarshalJSON() ([]byte, error) {
	ava.Type = TypeAppendVariable
	objectMap := make(map[string]interface{})
	if ava.AppendVariableActivityTypeProperties != nil {
		objectMap["typeProperties"] = ava.AppendVariableActivityTypeProperties
	}
	if ava.Name != nil {
		objectMap["name"] = ava.Name
	}
	if ava.Description != nil {
		objectMap["description"] = ava.Description
	}
	if ava.DependsOn != nil {
		objectMap["dependsOn"] = ava.DependsOn
	}
	if ava.UserProperties != nil {
		objectMap["userProperties"] = ava.UserProperties
	}
	if ava.Type != "" {
		objectMap["type"] = ava.Type
	}
	for k, v := range ava.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsAzureFunctionActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsAzureFunctionActivity() (*AzureFunctionActivity, bool) {
	return nil, false
}

// AsDatabricksSparkPythonActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsDatabricksSparkPythonActivity() (*DatabricksSparkPythonActivity, bool) {
	return nil, false
}

// AsDatabricksSparkJarActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsDatabricksSparkJarActivity() (*DatabricksSparkJarActivity, bool) {
	return nil, false
}

// AsDatabricksNotebookActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsDatabricksNotebookActivity() (*DatabricksNotebookActivity, bool) {
	return nil, false
}

// AsDataLakeAnalyticsUSQLActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsDataLakeAnalyticsUSQLActivity() (*DataLakeAnalyticsUSQLActivity, bool) {
	return nil, false
}

// AsAzureMLUpdateResourceActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsAzureMLUpdateResourceActivity() (*AzureMLUpdateResourceActivity, bool) {
	return nil, false
}

// AsAzureMLBatchExecutionActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsAzureMLBatchExecutionActivity() (*AzureMLBatchExecutionActivity, bool) {
	return nil, false
}

// AsGetMetadataActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsGetMetadataActivity() (*GetMetadataActivity, bool) {
	return nil, false
}

// AsWebActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsWebActivity() (*WebActivity, bool) {
	return nil, false
}

// AsLookupActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsLookupActivity() (*LookupActivity, bool) {
	return nil, false
}

// AsDeleteActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsDeleteActivity() (*DeleteActivity, bool) {
	return nil, false
}

// AsSQLServerStoredProcedureActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsSQLServerStoredProcedureActivity() (*SQLServerStoredProcedureActivity, bool) {
	return nil, false
}

// AsCustomActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsCustomActivity() (*CustomActivity, bool) {
	return nil, false
}

// AsExecuteSSISPackageActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsExecuteSSISPackageActivity() (*ExecuteSSISPackageActivity, bool) {
	return nil, false
}

// AsHDInsightSparkActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsHDInsightSparkActivity() (*HDInsightSparkActivity, bool) {
	return nil, false
}

// AsHDInsightStreamingActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsHDInsightStreamingActivity() (*HDInsightStreamingActivity, bool) {
	return nil, false
}

// AsHDInsightMapReduceActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsHDInsightMapReduceActivity() (*HDInsightMapReduceActivity, bool) {
	return nil, false
}

// AsHDInsightPigActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsHDInsightPigActivity() (*HDInsightPigActivity, bool) {
	return nil, false
}

// AsHDInsightHiveActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsHDInsightHiveActivity() (*HDInsightHiveActivity, bool) {
	return nil, false
}

// AsCopyActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsCopyActivity() (*CopyActivity, bool) {
	return nil, false
}

// AsExecutionActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsExecutionActivity() (*ExecutionActivity, bool) {
	return nil, false
}

// AsBasicExecutionActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsBasicExecutionActivity() (BasicExecutionActivity, bool) {
	return nil, false
}

// AsWebHookActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsWebHookActivity() (*WebHookActivity, bool) {
	return nil, false
}

// AsAppendVariableActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsAppendVariableActivity() (*AppendVariableActivity, bool) {
	return &ava, true
}

// AsSetVariableActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsSetVariableActivity() (*SetVariableActivity, bool) {
	return nil, false
}

// AsFilterActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsFilterActivity() (*FilterActivity, bool) {
	return nil, false
}

// AsValidationActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsValidationActivity() (*ValidationActivity, bool) {
	return nil, false
}

// AsUntilActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsUntilActivity() (*UntilActivity, bool) {
	return nil, false
}

// AsWaitActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsWaitActivity() (*WaitActivity, bool) {
	return nil, false
}

// AsForEachActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsForEachActivity() (*ForEachActivity, bool) {
	return nil, false
}

// AsIfConditionActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsIfConditionActivity() (*IfConditionActivity, bool) {
	return nil, false
}

// AsExecutePipelineActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsExecutePipelineActivity() (*ExecutePipelineActivity, bool) {
	return nil, false
}

// AsControlActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsControlActivity() (*ControlActivity, bool) {
	return nil, false
}

// AsBasicControlActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsBasicControlActivity() (BasicControlActivity, bool) {
	return &ava, true
}

// AsActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsActivity() (*Activity, bool) {
	return nil, false
}

// AsBasicActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsBasicActivity() (BasicActivity, bool) {
	return &ava, true
}

// UnmarshalJSON is the custom unmarshaler for AppendVariableActivity struct.
func (ava *AppendVariableActivity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var appendVariableActivityTypeProperties AppendVariableActivityTypeProperties
				err = json.Unmarshal(*v, &appendVariableActivityTypeProperties)
				if err != nil {
					return err
				}
				ava.AppendVariableActivityTypeProperties = &appendVariableActivityTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if ava.AdditionalProperties == nil {
					ava.AdditionalProperties = make(map[string]interface{})
				}
				ava.AdditionalProperties[k] = additionalProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ava.Name = &name
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				ava.Description = &description
			}
		case "dependsOn":
			if v != nil {
				var dependsOn []ActivityDependency
				err = json.Unmarshal(*v, &dependsOn)
				if err != nil {
					return err
				}
				ava.DependsOn = &dependsOn
			}
		case "userProperties":
			if v != nil {
				var userProperties []UserProperty
				err = json.Unmarshal(*v, &userProperties)
				if err != nil {
					return err
				}
				ava.UserProperties = &userProperties
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicActivity
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ava.Type = typeVar
			}
		}
	}

	return nil
}

// AppendVariableActivityTypeProperties appendVariable activity properties.
type AppendVariableActivityTypeProperties struct {
	// VariableName - Name of the variable whose value needs to be appended to.
	VariableName *string `json:"variableName,omitempty"`
	// Value - Value to be appended. Could be a static value or Expression
	Value interface{} `json:"value,omitempty"`
}

// AvroFormat the data stored in Avro format.
type AvroFormat struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Serializer - Serializer. Type: string (or Expression with resultType string).
	Serializer interface{} `json:"serializer,omitempty"`
	// Deserializer - Deserializer. Type: string (or Expression with resultType string).
	Deserializer interface{} `json:"deserializer,omitempty"`
	// Type - Possible values include: 'TypeDatasetStorageFormat', 'TypeParquetFormat', 'TypeOrcFormat', 'TypeAvroFormat', 'TypeJSONFormat', 'TypeTextFormat'
	Type TypeBasicDatasetStorageFormat `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AvroFormat.
func (af AvroFormat) MarshalJSON() ([]byte, error) {
	af.Type = TypeAvroFormat
	objectMap := make(map[string]interface{})
	if af.Serializer != nil {
		objectMap["serializer"] = af.Serializer
	}
	if af.Deserializer != nil {
		objectMap["deserializer"] = af.Deserializer
	}
	if af.Type != "" {
		objectMap["type"] = af.Type
	}
	for k, v := range af.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsParquetFormat is the BasicDatasetStorageFormat implementation for AvroFormat.
func (af AvroFormat) AsParquetFormat() (*ParquetFormat, bool) {
	return nil, false
}

// AsOrcFormat is the BasicDatasetStorageFormat implementation for AvroFormat.
func (af AvroFormat) AsOrcFormat() (*OrcFormat, bool) {
	return nil, false
}

// AsAvroFormat is the BasicDatasetStorageFormat implementation for AvroFormat.
func (af AvroFormat) AsAvroFormat() (*AvroFormat, bool) {
	return &af, true
}

// AsJSONFormat is the BasicDatasetStorageFormat implementation for AvroFormat.
func (af AvroFormat) AsJSONFormat() (*JSONFormat, bool) {
	return nil, false
}

// AsTextFormat is the BasicDatasetStorageFormat implementation for AvroFormat.
func (af AvroFormat) AsTextFormat() (*TextFormat, bool) {
	return nil, false
}

// AsDatasetStorageFormat is the BasicDatasetStorageFormat implementation for AvroFormat.
func (af AvroFormat) AsDatasetStorageFormat() (*DatasetStorageFormat, bool) {
	return nil, false
}

// AsBasicDatasetStorageFormat is the BasicDatasetStorageFormat implementation for AvroFormat.
func (af AvroFormat) AsBasicDatasetStorageFormat() (BasicDatasetStorageFormat, bool) {
	return &af, true
}

// UnmarshalJSON is the custom unmarshaler for AvroFormat struct.
func (af *AvroFormat) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if af.AdditionalProperties == nil {
					af.AdditionalProperties = make(map[string]interface{})
				}
				af.AdditionalProperties[k] = additionalProperties
			}
		case "serializer":
			if v != nil {
				var serializer interface{}
				err = json.Unmarshal(*v, &serializer)
				if err != nil {
					return err
				}
				af.Serializer = serializer
			}
		case "deserializer":
			if v != nil {
				var deserializer interface{}
				err = json.Unmarshal(*v, &deserializer)
				if err != nil {
					return err
				}
				af.Deserializer = deserializer
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicDatasetStorageFormat
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				af.Type = typeVar
			}
		}
	}

	return nil
}

// AzureBatchLinkedService azure Batch linked service.
type AzureBatchLinkedService struct {
	// AzureBatchLinkedServiceTypeProperties - Azure Batch linked service properties.
	*AzureBatchLinkedServiceTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Parameters - Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the linked service.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Type - Possible values include: 'TypeLinkedService', 'TypeAzureFunction', 'TypeAzureDataExplorer', 'TypeGoogleAdWords', 'TypeOracleServiceCloud', 'TypeDynamicsAX', 'TypeResponsys', 'TypeAzureDatabricks', 'TypeAzureDataLakeAnalytics', 'TypeHDInsightOnDemand', 'TypeSalesforceMarketingCloud', 'TypeNetezza', 'TypeVertica', 'TypeZoho', 'TypeXero', 'TypeSquare', 'TypeSpark', 'TypeShopify', 'TypeServiceNow', 'TypeQuickBooks', 'TypePresto', 'TypePhoenix', 'TypePaypal', 'TypeMarketo', 'TypeMariaDB', 'TypeMagento', 'TypeJira', 'TypeImpala', 'TypeHubspot', 'TypeHive', 'TypeHBase', 'TypeGreenplum', 'TypeGoogleBigQuery', 'TypeEloqua', 'TypeDrill', 'TypeCouchbase', 'TypeConcur', 'TypeAzurePostgreSQL', 'TypeAmazonMWS', 'TypeSapHana', 'TypeSapBW', 'TypeSftp', 'TypeFtpServer', 'TypeHTTPServer', 'TypeAzureSearch', 'TypeCustomDataSource', 'TypeAmazonRedshift', 'TypeAmazonS3', 'TypeRestService', 'TypeSapOpenHub', 'TypeSapEcc', 'TypeSapCloudForCustomer', 'TypeSalesforce', 'TypeOffice365', 'TypeAzureBlobFS', 'TypeAzureDataLakeStore', 'TypeCosmosDbMongoDbAPI', 'TypeMongoDbV2', 'TypeMongoDb', 'TypeCassandra', 'TypeWeb', 'TypeOData', 'TypeHdfs', 'TypeOdbc', 'TypeAzureML', 'TypeTeradata', 'TypeDb2', 'TypeSybase', 'TypePostgreSQL', 'TypeMySQL', 'TypeAzureMySQL', 'TypeOracle', 'TypeFileServer', 'TypeHDInsight', 'TypeDynamics', 'TypeCosmosDb', 'TypeAzureKeyVault', 'TypeAzureBatch', 'TypeAzureSQLDatabase', 'TypeSQLServer', 'TypeAzureSQLDW', 'TypeAzureTableStorage', 'TypeAzureBlobStorage', 'TypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) MarshalJSON() ([]byte, error) {
	abls.Type = TypeAzureBatch
	objectMap := make(map[string]interface{})
	if abls.AzureBatchLinkedServiceTypeProperties != nil {
		objectMap["typeProperties"] = abls.AzureBatchLinkedServiceTypeProperties
	}
	if abls.ConnectVia != nil {
		objectMap["connectVia"] = abls.ConnectVia
	}
	if abls.Description != nil {
		objectMap["description"] = abls.Description
	}
	if abls.Parameters != nil {
		objectMap["parameters"] = abls.Parameters
	}
	if abls.Annotations != nil {
		objectMap["annotations"] = abls.Annotations
	}
	if abls.Type != "" {
		objectMap["type"] = abls.Type
	}
	for k, v := range abls.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsAzureFunctionLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzureFunctionLinkedService() (*AzureFunctionLinkedService, bool) {
	return nil, false
}

// AsAzureDataExplorerLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzureDataExplorerLinkedService() (*AzureDataExplorerLinkedService, bool) {
	return nil, false
}

// AsGoogleAdWordsLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsGoogleAdWordsLinkedService() (*GoogleAdWordsLinkedService, bool) {
	return nil, false
}

// AsOracleServiceCloudLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsOracleServiceCloudLinkedService() (*OracleServiceCloudLinkedService, bool) {
	return nil, false
}

// AsDynamicsAXLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsDynamicsAXLinkedService() (*DynamicsAXLinkedService, bool) {
	return nil, false
}

// AsResponsysLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsResponsysLinkedService() (*ResponsysLinkedService, bool) {
	return nil, false
}

// AsAzureDatabricksLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzureDatabricksLinkedService() (*AzureDatabricksLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return nil, false
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsSalesforceMarketingCloudLinkedService() (*SalesforceMarketingCloudLinkedService, bool) {
	return nil, false
}

// AsNetezzaLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsNetezzaLinkedService() (*NetezzaLinkedService, bool) {
	return nil, false
}

// AsVerticaLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsVerticaLinkedService() (*VerticaLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return nil, false
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return nil, false
}

// AsConcurLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return nil, false
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return nil, false
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return nil, false
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return nil, false
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return nil, false
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return nil, false
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return nil, false
}

// AsRestServiceLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsRestServiceLinkedService() (*RestServiceLinkedService, bool) {
	return nil, false
}

// AsSapOpenHubLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsSapOpenHubLinkedService() (*SapOpenHubLinkedService, bool) {
	return nil, false
}

// AsSapEccLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsSapEccLinkedService() (*SapEccLinkedService, bool) {
	return nil, false
}

// AsSapCloudForCustomerLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsSapCloudForCustomerLinkedService() (*SapCloudForCustomerLinkedService, bool) {
	return nil, false
}

// AsSalesforceLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsSalesforceLinkedService() (*SalesforceLinkedService, bool) {
	return nil, false
}

// AsOffice365LinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsOffice365LinkedService() (*Office365LinkedService, bool) {
	return nil, false
}

// AsAzureBlobFSLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzureBlobFSLinkedService() (*AzureBlobFSLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzureDataLakeStoreLinkedService() (*AzureDataLakeStoreLinkedService, bool) {
	return nil, false
}

// AsCosmosDbMongoDbAPILinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsCosmosDbMongoDbAPILinkedService() (*CosmosDbMongoDbAPILinkedService, bool) {
	return nil, false
}

// AsMongoDbV2LinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsMongoDbV2LinkedService() (*MongoDbV2LinkedService, bool) {
	return nil, false
}

// AsMongoDbLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsMongoDbLinkedService() (*MongoDbLinkedService, bool) {
	return nil, false
}

// AsCassandraLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsCassandraLinkedService() (*CassandraLinkedService, bool) {
	return nil, false
}

// AsWebLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsWebLinkedService() (*WebLinkedService, bool) {
	return nil, false
}

// AsODataLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsODataLinkedService() (*ODataLinkedService, bool) {
	return nil, false
}

// AsHdfsLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsHdfsLinkedService() (*HdfsLinkedService, bool) {
	return nil, false
}

// AsOdbcLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsOdbcLinkedService() (*OdbcLinkedService, bool) {
	return nil, false
}

// AsAzureMLLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzureMLLinkedService() (*AzureMLLinkedService, bool) {
	return nil, false
}

// AsTeradataLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsTeradataLinkedService() (*TeradataLinkedService, bool) {
	return nil, false
}

// AsDb2LinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsDb2LinkedService() (*Db2LinkedService, bool) {
	return nil, false
}

// AsSybaseLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsSybaseLinkedService() (*SybaseLinkedService, bool) {
	return nil, false
}

// AsPostgreSQLLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsPostgreSQLLinkedService() (*PostgreSQLLinkedService, bool) {
	return nil, false
}

// AsMySQLLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsMySQLLinkedService() (*MySQLLinkedService, bool) {
	return nil, false
}

// AsAzureMySQLLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzureMySQLLinkedService() (*AzureMySQLLinkedService, bool) {
	return nil, false
}

// AsOracleLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsOracleLinkedService() (*OracleLinkedService, bool) {
	return nil, false
}

// AsFileServerLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsFileServerLinkedService() (*FileServerLinkedService, bool) {
	return nil, false
}

// AsHDInsightLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsHDInsightLinkedService() (*HDInsightLinkedService, bool) {
	return nil, false
}

// AsDynamicsLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsDynamicsLinkedService() (*DynamicsLinkedService, bool) {
	return nil, false
}

// AsCosmosDbLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsCosmosDbLinkedService() (*CosmosDbLinkedService, bool) {
	return nil, false
}

// AsAzureKeyVaultLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzureKeyVaultLinkedService() (*AzureKeyVaultLinkedService, bool) {
	return nil, false
}

// AsAzureBatchLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzureBatchLinkedService() (*AzureBatchLinkedService, bool) {
	return &abls, true
}

// AsAzureSQLDatabaseLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzureSQLDatabaseLinkedService() (*AzureSQLDatabaseLinkedService, bool) {
	return nil, false
}

// AsSQLServerLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsSQLServerLinkedService() (*SQLServerLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDWLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzureSQLDWLinkedService() (*AzureSQLDWLinkedService, bool) {
	return nil, false
}

// AsAzureTableStorageLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzureTableStorageLinkedService() (*AzureTableStorageLinkedService, bool) {
	return nil, false
}

// AsAzureBlobStorageLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzureBlobStorageLinkedService() (*AzureBlobStorageLinkedService, bool) {
	return nil, false
}

// AsAzureStorageLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzureStorageLinkedService() (*AzureStorageLinkedService, bool) {
	return nil, false
}

// AsLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsLinkedService() (*LinkedService, bool) {
	return nil, false
}

// AsBasicLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsBasicLinkedService() (BasicLinkedService, bool) {
	return &abls, true
}

// UnmarshalJSON is the custom unmarshaler for AzureBatchLinkedService struct.
func (abls *AzureBatchLinkedService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var azureBatchLinkedServiceTypeProperties AzureBatchLinkedServiceTypeProperties
				err = json.Unmarshal(*v, &azureBatchLinkedServiceTypeProperties)
				if err != nil {
					return err
				}
				abls.AzureBatchLinkedServiceTypeProperties = &azureBatchLinkedServiceTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if abls.AdditionalProperties == nil {
					abls.AdditionalProperties = make(map[string]interface{})
				}
				abls.AdditionalProperties[k] = additionalProperties
			}
		case "connectVia":
			if v != nil {
				var connectVia IntegrationRuntimeReference
				err = json.Unmarshal(*v, &connectVia)
				if err != nil {
					return err
				}
				abls.ConnectVia = &connectVia
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				abls.Description = &description
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				abls.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				abls.Annotations = &annotations
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicLinkedService
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				abls.Type = typeVar
			}
		}
	}

	return nil
}

// AzureBatchLinkedServiceTypeProperties azure Batch linked service properties.
type AzureBatchLinkedServiceTypeProperties struct {
	// AccountName - The Azure Batch account name. Type: string (or Expression with resultType string).
	AccountName interface{} `json:"accountName,omitempty"`
	// AccessKey - The Azure Batch account access key.
	AccessKey BasicSecretBase `json:"accessKey,omitempty"`
	// BatchURI - The Azure Batch URI. Type: string (or Expression with resultType string).
	BatchURI interface{} `json:"batchUri,omitempty"`
	// PoolName - The Azure Batch pool name. Type: string (or Expression with resultType string).
	PoolName interface{} `json:"poolName,omitempty"`
	// LinkedServiceName - The Azure Storage linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
	// EncryptedCredential - The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AzureBatchLinkedServiceTypeProperties struct.
func (ablstp *AzureBatchLinkedServiceTypeProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "accountName":
			if v != nil {
				var accountName interface{}
				err = json.Unmarshal(*v, &accountName)
				if err != nil {
					return err
				}
				ablstp.AccountName = accountName
			}
		case "accessKey":
			if v != nil {
				accessKey, err := unmarshalBasicSecretBase(*v)
				if err != nil {
					return err
				}
				ablstp.AccessKey = accessKey
			}
		case "batchUri":
			if v != nil {
				var batchURI interface{}
				err = json.Unmarshal(*v, &batchURI)
				if err != nil {
					return err
				}
				ablstp.BatchURI = batchURI
			}
		case "poolName":
			if v != nil {
				var poolName interface{}
				err = json.Unmarshal(*v, &poolName)
				if err != nil {
					return err
				}
				ablstp.PoolName = poolName
			}
		case "linkedServiceName":
			if v != nil {
				var linkedServiceName LinkedServiceReference
				err = json.Unmarshal(*v, &linkedServiceName)
				if err != nil {
					return err
				}
				ablstp.LinkedServiceName = &linkedServiceName
			}
		case "encryptedCredential":
			if v != nil {
				var encryptedCredential interface{}
				err = json.Unmarshal(*v, &encryptedCredential)
				if err != nil {
					return err
				}
				ablstp.EncryptedCredential = encryptedCredential
			}
		}
	}

	return nil
}

// AzureBlobDataset the Azure Blob storage.
type AzureBlobDataset struct {
	// AzureBlobDatasetTypeProperties - Azure Blob dataset properties.
	*AzureBlobDatasetTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Description - Dataset description.
	Description *string `json:"description,omitempty"`
	// Structure - Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`
	// Schema - Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType: DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`
	// LinkedServiceName - Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
	// Parameters - Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the Dataset.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Folder - The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`
	// Type - Possible values include: 'TypeDataset', 'TypeGoogleAdWordsObject', 'TypeAzureDataExplorerTable', 'TypeOracleServiceCloudObject', 'TypeDynamicsAXResource', 'TypeResponsysObject', 'TypeSalesforceMarketingCloudObject', 'TypeVerticaTable', 'TypeNetezzaTable', 'TypeZohoObject', 'TypeXeroObject', 'TypeSquareObject', 'TypeSparkObject', 'TypeShopifyObject', 'TypeServiceNowObject', 'TypeQuickBooksObject', 'TypePrestoObject', 'TypePhoenixObject', 'TypePaypalObject', 'TypeMarketoObject', 'TypeMariaDBTable', 'TypeMagentoObject', 'TypeJiraObject', 'TypeImpalaObject', 'TypeHubspotObject', 'TypeHiveObject', 'TypeHBaseObject', 'TypeGreenplumTable', 'TypeGoogleBigQueryObject', 'TypeEloquaObject', 'TypeDrillTable', 'TypeCouchbaseTable', 'TypeConcurObject', 'TypeAzurePostgreSQLTable', 'TypeAmazonMWSObject', 'TypeHTTPFile', 'TypeAzureSearchIndex', 'TypeWebTable', 'TypeRestResource', 'TypeSQLServerTable', 'TypeSapOpenHubTable', 'TypeSapEccResource', 'TypeSapCloudForCustomerResource', 'TypeSalesforceObject', 'TypeRelationalTable', 'TypeAzureMySQLTable', 'TypeOracleTable', 'TypeODataResource', 'TypeCosmosDbMongoDbAPICollection', 'TypeMongoDbV2Collection', 'TypeMongoDbCollection', 'TypeFileShare', 'TypeOffice365Table', 'TypeAzureBlobFSFile', 'TypeAzureDataLakeStoreFile', 'TypeDynamicsEntity', 'TypeDocumentDbCollection', 'TypeCustomDataset', 'TypeCassandraTable', 'TypeAzureSQLDWTable', 'TypeAzureSQLTable', 'TypeAzureTable', 'TypeAzureBlob', 'TypeAmazonS3Object'
	Type TypeBasicDataset `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureBlobDataset.
func (abd AzureBlobDataset) MarshalJSON() ([]byte, error) {
	abd.Type = TypeAzureBlob
	objectMap := make(map[string]interface{})
	if abd.AzureBlobDatasetTypeProperties != nil {
		objectMap["typeProperties"] = abd.AzureBlobDatasetTypeProperties
	}
	if abd.Description != nil {
		objectMap["description"] = abd.Description
	}
	if abd.Structure != nil {
		objectMap["structure"] = abd.Structure
	}
	if abd.Schema != nil {
		objectMap["schema"] = abd.Schema
	}
	if abd.LinkedServiceName != nil {
		objectMap["linkedServiceName"] = abd.LinkedServiceName
	}
	if abd.Parameters != nil {
		objectMap["parameters"] = abd.Parameters
	}
	if abd.Annotations != nil {
		objectMap["annotations"] = abd.Annotations
	}
	if abd.Folder != nil {
		objectMap["folder"] = abd.Folder
	}
	if abd.Type != "" {
		objectMap["type"] = abd.Type
	}
	for k, v := range abd.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsGoogleAdWordsObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsGoogleAdWordsObjectDataset() (*GoogleAdWordsObjectDataset, bool) {
	return nil, false
}

// AsAzureDataExplorerTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsAzureDataExplorerTableDataset() (*AzureDataExplorerTableDataset, bool) {
	return nil, false
}

// AsOracleServiceCloudObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsOracleServiceCloudObjectDataset() (*OracleServiceCloudObjectDataset, bool) {
	return nil, false
}

// AsDynamicsAXResourceDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsDynamicsAXResourceDataset() (*DynamicsAXResourceDataset, bool) {
	return nil, false
}

// AsResponsysObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsResponsysObjectDataset() (*ResponsysObjectDataset, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsSalesforceMarketingCloudObjectDataset() (*SalesforceMarketingCloudObjectDataset, bool) {
	return nil, false
}

// AsVerticaTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsVerticaTableDataset() (*VerticaTableDataset, bool) {
	return nil, false
}

// AsNetezzaTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsNetezzaTableDataset() (*NetezzaTableDataset, bool) {
	return nil, false
}

// AsZohoObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsZohoObjectDataset() (*ZohoObjectDataset, bool) {
	return nil, false
}

// AsXeroObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsXeroObjectDataset() (*XeroObjectDataset, bool) {
	return nil, false
}

// AsSquareObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsSquareObjectDataset() (*SquareObjectDataset, bool) {
	return nil, false
}

// AsSparkObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsSparkObjectDataset() (*SparkObjectDataset, bool) {
	return nil, false
}

// AsShopifyObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsShopifyObjectDataset() (*ShopifyObjectDataset, bool) {
	return nil, false
}

// AsServiceNowObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsServiceNowObjectDataset() (*ServiceNowObjectDataset, bool) {
	return nil, false
}

// AsQuickBooksObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsQuickBooksObjectDataset() (*QuickBooksObjectDataset, bool) {
	return nil, false
}

// AsPrestoObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsPrestoObjectDataset() (*PrestoObjectDataset, bool) {
	return nil, false
}

// AsPhoenixObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsPhoenixObjectDataset() (*PhoenixObjectDataset, bool) {
	return nil, false
}

// AsPaypalObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsPaypalObjectDataset() (*PaypalObjectDataset, bool) {
	return nil, false
}

// AsMarketoObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsMarketoObjectDataset() (*MarketoObjectDataset, bool) {
	return nil, false
}

// AsMariaDBTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsMariaDBTableDataset() (*MariaDBTableDataset, bool) {
	return nil, false
}

// AsMagentoObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsMagentoObjectDataset() (*MagentoObjectDataset, bool) {
	return nil, false
}

// AsJiraObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsJiraObjectDataset() (*JiraObjectDataset, bool) {
	return nil, false
}

// AsImpalaObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsImpalaObjectDataset() (*ImpalaObjectDataset, bool) {
	return nil, false
}

// AsHubspotObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsHubspotObjectDataset() (*HubspotObjectDataset, bool) {
	return nil, false
}

// AsHiveObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsHiveObjectDataset() (*HiveObjectDataset, bool) {
	return nil, false
}

// AsHBaseObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsHBaseObjectDataset() (*HBaseObjectDataset, bool) {
	return nil, false
}

// AsGreenplumTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsGreenplumTableDataset() (*GreenplumTableDataset, bool) {
	return nil, false
}

// AsGoogleBigQueryObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsGoogleBigQueryObjectDataset() (*GoogleBigQueryObjectDataset, bool) {
	return nil, false
}

// AsEloquaObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsEloquaObjectDataset() (*EloquaObjectDataset, bool) {
	return nil, false
}

// AsDrillTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsDrillTableDataset() (*DrillTableDataset, bool) {
	return nil, false
}

// AsCouchbaseTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsCouchbaseTableDataset() (*CouchbaseTableDataset, bool) {
	return nil, false
}

// AsConcurObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsConcurObjectDataset() (*ConcurObjectDataset, bool) {
	return nil, false
}

// AsAzurePostgreSQLTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsAzurePostgreSQLTableDataset() (*AzurePostgreSQLTableDataset, bool) {
	return nil, false
}

// AsAmazonMWSObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsAmazonMWSObjectDataset() (*AmazonMWSObjectDataset, bool) {
	return nil, false
}

// AsHTTPDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsHTTPDataset() (*HTTPDataset, bool) {
	return nil, false
}

// AsAzureSearchIndexDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsAzureSearchIndexDataset() (*AzureSearchIndexDataset, bool) {
	return nil, false
}

// AsWebTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsWebTableDataset() (*WebTableDataset, bool) {
	return nil, false
}

// AsRestResourceDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsRestResourceDataset() (*RestResourceDataset, bool) {
	return nil, false
}

// AsSQLServerTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsSQLServerTableDataset() (*SQLServerTableDataset, bool) {
	return nil, false
}

// AsSapOpenHubTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsSapOpenHubTableDataset() (*SapOpenHubTableDataset, bool) {
	return nil, false
}

// AsSapEccResourceDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsSapEccResourceDataset() (*SapEccResourceDataset, bool) {
	return nil, false
}

// AsSapCloudForCustomerResourceDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsSapCloudForCustomerResourceDataset() (*SapCloudForCustomerResourceDataset, bool) {
	return nil, false
}

// AsSalesforceObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsSalesforceObjectDataset() (*SalesforceObjectDataset, bool) {
	return nil, false
}

// AsRelationalTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsRelationalTableDataset() (*RelationalTableDataset, bool) {
	return nil, false
}

// AsAzureMySQLTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsAzureMySQLTableDataset() (*AzureMySQLTableDataset, bool) {
	return nil, false
}

// AsOracleTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsOracleTableDataset() (*OracleTableDataset, bool) {
	return nil, false
}

// AsODataResourceDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsODataResourceDataset() (*ODataResourceDataset, bool) {
	return nil, false
}

// AsCosmosDbMongoDbAPICollectionDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsCosmosDbMongoDbAPICollectionDataset() (*CosmosDbMongoDbAPICollectionDataset, bool) {
	return nil, false
}

// AsMongoDbV2CollectionDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsMongoDbV2CollectionDataset() (*MongoDbV2CollectionDataset, bool) {
	return nil, false
}

// AsMongoDbCollectionDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsMongoDbCollectionDataset() (*MongoDbCollectionDataset, bool) {
	return nil, false
}

// AsFileShareDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsFileShareDataset() (*FileShareDataset, bool) {
	return nil, false
}

// AsOffice365Dataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsOffice365Dataset() (*Office365Dataset, bool) {
	return nil, false
}

// AsAzureBlobFSDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsAzureBlobFSDataset() (*AzureBlobFSDataset, bool) {
	return nil, false
}

// AsAzureDataLakeStoreDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsAzureDataLakeStoreDataset() (*AzureDataLakeStoreDataset, bool) {
	return nil, false
}

// AsDynamicsEntityDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsDynamicsEntityDataset() (*DynamicsEntityDataset, bool) {
	return nil, false
}

// AsDocumentDbCollectionDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsDocumentDbCollectionDataset() (*DocumentDbCollectionDataset, bool) {
	return nil, false
}

// AsCustomDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsCustomDataset() (*CustomDataset, bool) {
	return nil, false
}

// AsCassandraTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsCassandraTableDataset() (*CassandraTableDataset, bool) {
	return nil, false
}

// AsAzureSQLDWTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsAzureSQLDWTableDataset() (*AzureSQLDWTableDataset, bool) {
	return nil, false
}

// AsAzureSQLTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsAzureSQLTableDataset() (*AzureSQLTableDataset, bool) {
	return nil, false
}

// AsAzureTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsAzureTableDataset() (*AzureTableDataset, bool) {
	return nil, false
}

// AsAzureBlobDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsAzureBlobDataset() (*AzureBlobDataset, bool) {
	return &abd, true
}

// AsAmazonS3Dataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsAmazonS3Dataset() (*AmazonS3Dataset, bool) {
	return nil, false
}

// AsDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsDataset() (*Dataset, bool) {
	return nil, false
}

// AsBasicDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsBasicDataset() (BasicDataset, bool) {
	return &abd, true
}

// UnmarshalJSON is the custom unmarshaler for AzureBlobDataset struct.
func (abd *AzureBlobDataset) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var azureBlobDatasetTypeProperties AzureBlobDatasetTypeProperties
				err = json.Unmarshal(*v, &azureBlobDatasetTypeProperties)
				if err != nil {
					return err
				}
				abd.AzureBlobDatasetTypeProperties = &azureBlobDatasetTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if abd.AdditionalProperties == nil {
					abd.AdditionalProperties = make(map[string]interface{})
				}
				abd.AdditionalProperties[k] = additionalProperties
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				abd.Description = &description
			}
		case "structure":
			if v != nil {
				var structure interface{}
				err = json.Unmarshal(*v, &structure)
				if err != nil {
					return err
				}
				abd.Structure = structure
			}
		case "schema":
			if v != nil {
				var schema interface{}
				err = json.Unmarshal(*v, &schema)
				if err != nil {
					return err
				}
				abd.Schema = schema
			}
		case "linkedServiceName":
			if v != nil {
				var linkedServiceName LinkedServiceReference
				err = json.Unmarshal(*v, &linkedServiceName)
				if err != nil {
					return err
				}
				abd.LinkedServiceName = &linkedServiceName
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				abd.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				abd.Annotations = &annotations
			}
		case "folder":
			if v != nil {
				var folder DatasetFolder
				err = json.Unmarshal(*v, &folder)
				if err != nil {
					return err
				}
				abd.Folder = &folder
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicDataset
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				abd.Type = typeVar
			}
		}
	}

	return nil
}

// AzureBlobDatasetTypeProperties azure Blob dataset properties.
type AzureBlobDatasetTypeProperties struct {
	// FolderPath - The path of the Azure Blob storage. Type: string (or Expression with resultType string).
	FolderPath interface{} `json:"folderPath,omitempty"`
	// TableRootLocation - The root of blob path. Type: string (or Expression with resultType string).
	TableRootLocation interface{} `json:"tableRootLocation,omitempty"`
	// FileName - The name of the Azure Blob. Type: string (or Expression with resultType string).
	FileName interface{} `json:"fileName,omitempty"`
	// ModifiedDatetimeStart - The start of Azure Blob's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeStart interface{} `json:"modifiedDatetimeStart,omitempty"`
	// ModifiedDatetimeEnd - The end of Azure Blob's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeEnd interface{} `json:"modifiedDatetimeEnd,omitempty"`
	// Format - The format of the Azure Blob storage.
	Format BasicDatasetStorageFormat `json:"format,omitempty"`
	// Compression - The data compression method used for the blob storage.
	Compression BasicDatasetCompression `json:"compression,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AzureBlobDatasetTypeProperties struct.
func (abdtp *AzureBlobDatasetTypeProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "folderPath":
			if v != nil {
				var folderPath interface{}
				err = json.Unmarshal(*v, &folderPath)
				if err != nil {
					return err
				}
				abdtp.FolderPath = folderPath
			}
		case "tableRootLocation":
			if v != nil {
				var tableRootLocation interface{}
				err = json.Unmarshal(*v, &tableRootLocation)
				if err != nil {
					return err
				}
				abdtp.TableRootLocation = tableRootLocation
			}
		case "fileName":
			if v != nil {
				var fileName interface{}
				err = json.Unmarshal(*v, &fileName)
				if err != nil {
					return err
				}
				abdtp.FileName = fileName
			}
		case "modifiedDatetimeStart":
			if v != nil {
				var modifiedDatetimeStart interface{}
				err = json.Unmarshal(*v, &modifiedDatetimeStart)
				if err != nil {
					return err
				}
				abdtp.ModifiedDatetimeStart = modifiedDatetimeStart
			}
		case "modifiedDatetimeEnd":
			if v != nil {
				var modifiedDatetimeEnd interface{}
				err = json.Unmarshal(*v, &modifiedDatetimeEnd)
				if err != nil {
					return err
				}
				abdtp.ModifiedDatetimeEnd = modifiedDatetimeEnd
			}
		case "format":
			if v != nil {
				formatVar, err := unmarshalBasicDatasetStorageFormat(*v)
				if err != nil {
					return err
				}
				abdtp.Format = formatVar
			}
		case "compression":
			if v != nil {
				compression, err := unmarshalBasicDatasetCompression(*v)
				if err != nil {
					return err
				}
				abdtp.Compression = compression
			}
		}
	}

	return nil
}

// AzureBlobFSDataset the Azure Data Lake Storage Gen2 storage.
type AzureBlobFSDataset struct {
	// AzureBlobFSDatasetTypeProperties - Azure Data Lake Storage Gen2 dataset properties.
	*AzureBlobFSDatasetTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Description - Dataset description.
	Description *string `json:"description,omitempty"`
	// Structure - Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`
	// Schema - Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType: DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`
	// LinkedServiceName - Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
	// Parameters - Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the Dataset.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Folder - The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`
	// Type - Possible values include: 'TypeDataset', 'TypeGoogleAdWordsObject', 'TypeAzureDataExplorerTable', 'TypeOracleServiceCloudObject', 'TypeDynamicsAXResource', 'TypeResponsysObject', 'TypeSalesforceMarketingCloudObject', 'TypeVerticaTable', 'TypeNetezzaTable', 'TypeZohoObject', 'TypeXeroObject', 'TypeSquareObject', 'TypeSparkObject', 'TypeShopifyObject', 'TypeServiceNowObject', 'TypeQuickBooksObject', 'TypePrestoObject', 'TypePhoenixObject', 'TypePaypalObject', 'TypeMarketoObject', 'TypeMariaDBTable', 'TypeMagentoObject', 'TypeJiraObject', 'TypeImpalaObject', 'TypeHubspotObject', 'TypeHiveObject', 'TypeHBaseObject', 'TypeGreenplumTable', 'TypeGoogleBigQueryObject', 'TypeEloquaObject', 'TypeDrillTable', 'TypeCouchbaseTable', 'TypeConcurObject', 'TypeAzurePostgreSQLTable', 'TypeAmazonMWSObject', 'TypeHTTPFile', 'TypeAzureSearchIndex', 'TypeWebTable', 'TypeRestResource', 'TypeSQLServerTable', 'TypeSapOpenHubTable', 'TypeSapEccResource', 'TypeSapCloudForCustomerResource', 'TypeSalesforceObject', 'TypeRelationalTable', 'TypeAzureMySQLTable', 'TypeOracleTable', 'TypeODataResource', 'TypeCosmosDbMongoDbAPICollection', 'TypeMongoDbV2Collection', 'TypeMongoDbCollection', 'TypeFileShare', 'TypeOffice365Table', 'TypeAzureBlobFSFile', 'TypeAzureDataLakeStoreFile', 'TypeDynamicsEntity', 'TypeDocumentDbCollection', 'TypeCustomDataset', 'TypeCassandraTable', 'TypeAzureSQLDWTable', 'TypeAzureSQLTable', 'TypeAzureTable', 'TypeAzureBlob', 'TypeAmazonS3Object'
	Type TypeBasicDataset `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) MarshalJSON() ([]byte, error) {
	abfd.Type = TypeAzureBlobFSFile
	objectMap := make(map[string]interface{})
	if abfd.AzureBlobFSDatasetTypeProperties != nil {
		objectMap["typeProperties"] = abfd.AzureBlobFSDatasetTypeProperties
	}
	if abfd.Description != nil {
		objectMap["description"] = abfd.Description
	}
	if abfd.Structure != nil {
		objectMap["structure"] = abfd.Structure
	}
	if abfd.Schema != nil {
		objectMap["schema"] = abfd.Schema
	}
	if abfd.LinkedServiceName != nil {
		objectMap["linkedServiceName"] = abfd.LinkedServiceName
	}
	if abfd.Parameters != nil {
		objectMap["parameters"] = abfd.Parameters
	}
	if abfd.Annotations != nil {
		objectMap["annotations"] = abfd.Annotations
	}
	if abfd.Folder != nil {
		objectMap["folder"] = abfd.Folder
	}
	if abfd.Type != "" {
		objectMap["type"] = abfd.Type
	}
	for k, v := range abfd.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsGoogleAdWordsObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsGoogleAdWordsObjectDataset() (*GoogleAdWordsObjectDataset, bool) {
	return nil, false
}

// AsAzureDataExplorerTableDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsAzureDataExplorerTableDataset() (*AzureDataExplorerTableDataset, bool) {
	return nil, false
}

// AsOracleServiceCloudObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsOracleServiceCloudObjectDataset() (*OracleServiceCloudObjectDataset, bool) {
	return nil, false
}

// AsDynamicsAXResourceDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsDynamicsAXResourceDataset() (*DynamicsAXResourceDataset, bool) {
	return nil, false
}

// AsResponsysObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsResponsysObjectDataset() (*ResponsysObjectDataset, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsSalesforceMarketingCloudObjectDataset() (*SalesforceMarketingCloudObjectDataset, bool) {
	return nil, false
}

// AsVerticaTableDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsVerticaTableDataset() (*VerticaTableDataset, bool) {
	return nil, false
}

// AsNetezzaTableDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsNetezzaTableDataset() (*NetezzaTableDataset, bool) {
	return nil, false
}

// AsZohoObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsZohoObjectDataset() (*ZohoObjectDataset, bool) {
	return nil, false
}

// AsXeroObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsXeroObjectDataset() (*XeroObjectDataset, bool) {
	return nil, false
}

// AsSquareObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsSquareObjectDataset() (*SquareObjectDataset, bool) {
	return nil, false
}

// AsSparkObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsSparkObjectDataset() (*SparkObjectDataset, bool) {
	return nil, false
}

// AsShopifyObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsShopifyObjectDataset() (*ShopifyObjectDataset, bool) {
	return nil, false
}

// AsServiceNowObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsServiceNowObjectDataset() (*ServiceNowObjectDataset, bool) {
	return nil, false
}

// AsQuickBooksObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsQuickBooksObjectDataset() (*QuickBooksObjectDataset, bool) {
	return nil, false
}

// AsPrestoObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsPrestoObjectDataset() (*PrestoObjectDataset, bool) {
	return nil, false
}

// AsPhoenixObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsPhoenixObjectDataset() (*PhoenixObjectDataset, bool) {
	return nil, false
}

// AsPaypalObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsPaypalObjectDataset() (*PaypalObjectDataset, bool) {
	return nil, false
}

// AsMarketoObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsMarketoObjectDataset() (*MarketoObjectDataset, bool) {
	return nil, false
}

// AsMariaDBTableDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsMariaDBTableDataset() (*MariaDBTableDataset, bool) {
	return nil, false
}

// AsMagentoObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsMagentoObjectDataset() (*MagentoObjectDataset, bool) {
	return nil, false
}

// AsJiraObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsJiraObjectDataset() (*JiraObjectDataset, bool) {
	return nil, false
}

// AsImpalaObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsImpalaObjectDataset() (*ImpalaObjectDataset, bool) {
	return nil, false
}

// AsHubspotObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsHubspotObjectDataset() (*HubspotObjectDataset, bool) {
	return nil, false
}

// AsHiveObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsHiveObjectDataset() (*HiveObjectDataset, bool) {
	return nil, false
}

// AsHBaseObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsHBaseObjectDataset() (*HBaseObjectDataset, bool) {
	return nil, false
}

// AsGreenplumTableDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsGreenplumTableDataset() (*GreenplumTableDataset, bool) {
	return nil, false
}

// AsGoogleBigQueryObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsGoogleBigQueryObjectDataset() (*GoogleBigQueryObjectDataset, bool) {
	return nil, false
}

// AsEloquaObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsEloquaObjectDataset() (*EloquaObjectDataset, bool) {
	return nil, false
}

// AsDrillTableDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsDrillTableDataset() (*DrillTableDataset, bool) {
	return nil, false
}

// AsCouchbaseTableDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsCouchbaseTableDataset() (*CouchbaseTableDataset, bool) {
	return nil, false
}

// AsConcurObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsConcurObjectDataset() (*ConcurObjectDataset, bool) {
	return nil, false
}

// AsAzurePostgreSQLTableDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsAzurePostgreSQLTableDataset() (*AzurePostgreSQLTableDataset, bool) {
	return nil, false
}

// AsAmazonMWSObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsAmazonMWSObjectDataset() (*AmazonMWSObjectDataset, bool) {
	return nil, false
}

// AsHTTPDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsHTTPDataset() (*HTTPDataset, bool) {
	return nil, false
}

// AsAzureSearchIndexDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsAzureSearchIndexDataset() (*AzureSearchIndexDataset, bool) {
	return nil, false
}

// AsWebTableDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsWebTableDataset() (*WebTableDataset, bool) {
	return nil, false
}

// AsRestResourceDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsRestResourceDataset() (*RestResourceDataset, bool) {
	return nil, false
}

// AsSQLServerTableDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsSQLServerTableDataset() (*SQLServerTableDataset, bool) {
	return nil, false
}

// AsSapOpenHubTableDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsSapOpenHubTableDataset() (*SapOpenHubTableDataset, bool) {
	return nil, false
}

// AsSapEccResourceDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsSapEccResourceDataset() (*SapEccResourceDataset, bool) {
	return nil, false
}

// AsSapCloudForCustomerResourceDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsSapCloudForCustomerResourceDataset() (*SapCloudForCustomerResourceDataset, bool) {
	return nil, false
}

// AsSalesforceObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsSalesforceObjectDataset() (*SalesforceObjectDataset, bool) {
	return nil, false
}

// AsRelationalTableDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsRelationalTableDataset() (*RelationalTableDataset, bool) {
	return nil, false
}

// AsAzureMySQLTableDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsAzureMySQLTableDataset() (*AzureMySQLTableDataset, bool) {
	return nil, false
}

// AsOracleTableDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsOracleTableDataset() (*OracleTableDataset, bool) {
	return nil, false
}

// AsODataResourceDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsODataResourceDataset() (*ODataResourceDataset, bool) {
	return nil, false
}

// AsCosmosDbMongoDbAPICollectionDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsCosmosDbMongoDbAPICollectionDataset() (*CosmosDbMongoDbAPICollectionDataset, bool) {
	return nil, false
}

// AsMongoDbV2CollectionDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsMongoDbV2CollectionDataset() (*MongoDbV2CollectionDataset, bool) {
	return nil, false
}

// AsMongoDbCollectionDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsMongoDbCollectionDataset() (*MongoDbCollectionDataset, bool) {
	return nil, false
}

// AsFileShareDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsFileShareDataset() (*FileShareDataset, bool) {
	return nil, false
}

// AsOffice365Dataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsOffice365Dataset() (*Office365Dataset, bool) {
	return nil, false
}

// AsAzureBlobFSDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsAzureBlobFSDataset() (*AzureBlobFSDataset, bool) {
	return &abfd, true
}

// AsAzureDataLakeStoreDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsAzureDataLakeStoreDataset() (*AzureDataLakeStoreDataset, bool) {
	return nil, false
}

// AsDynamicsEntityDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsDynamicsEntityDataset() (*DynamicsEntityDataset, bool) {
	return nil, false
}

// AsDocumentDbCollectionDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsDocumentDbCollectionDataset() (*DocumentDbCollectionDataset, bool) {
	return nil, false
}

// AsCustomDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsCustomDataset() (*CustomDataset, bool) {
	return nil, false
}

// AsCassandraTableDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsCassandraTableDataset() (*CassandraTableDataset, bool) {
	return nil, false
}

// AsAzureSQLDWTableDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsAzureSQLDWTableDataset() (*AzureSQLDWTableDataset, bool) {
	return nil, false
}

// AsAzureSQLTableDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsAzureSQLTableDataset() (*AzureSQLTableDataset, bool) {
	return nil, false
}

// AsAzureTableDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsAzureTableDataset() (*AzureTableDataset, bool) {
	return nil, false
}

// AsAzureBlobDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsAzureBlobDataset() (*AzureBlobDataset, bool) {
	return nil, false
}

// AsAmazonS3Dataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsAmazonS3Dataset() (*AmazonS3Dataset, bool) {
	return nil, false
}

// AsDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsDataset() (*Dataset, bool) {
	return nil, false
}

// AsBasicDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsBasicDataset() (BasicDataset, bool) {
	return &abfd, true
}

// UnmarshalJSON is the custom unmarshaler for AzureBlobFSDataset struct.
func (abfd *AzureBlobFSDataset) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var azureBlobFSDatasetTypeProperties AzureBlobFSDatasetTypeProperties
				err = json.Unmarshal(*v, &azureBlobFSDatasetTypeProperties)
				if err != nil {
					return err
				}
				abfd.AzureBlobFSDatasetTypeProperties = &azureBlobFSDatasetTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if abfd.AdditionalProperties == nil {
					abfd.AdditionalProperties = make(map[string]interface{})
				}
				abfd.AdditionalProperties[k] = additionalProperties
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				abfd.Description = &description
			}
		case "structure":
			if v != nil {
				var structure interface{}
				err = json.Unmarshal(*v, &structure)
				if err != nil {
					return err
				}
				abfd.Structure = structure
			}
		case "schema":
			if v != nil {
				var schema interface{}
				err = json.Unmarshal(*v, &schema)
				if err != nil {
					return err
				}
				abfd.Schema = schema
			}
		case "linkedServiceName":
			if v != nil {
				var linkedServiceName LinkedServiceReference
				err = json.Unmarshal(*v, &linkedServiceName)
				if err != nil {
					return err
				}
				abfd.LinkedServiceName = &linkedServiceName
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				abfd.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				abfd.Annotations = &annotations
			}
		case "folder":
			if v != nil {
				var folder DatasetFolder
				err = json.Unmarshal(*v, &folder)
				if err != nil {
					return err
				}
				abfd.Folder = &folder
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicDataset
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				abfd.Type = typeVar
			}
		}
	}

	return nil
}

// AzureBlobFSDatasetTypeProperties azure Data Lake Storage Gen2 dataset properties.
type AzureBlobFSDatasetTypeProperties struct {
	// FolderPath - The path of the Azure Data Lake Storage Gen2 storage. Type: string (or Expression with resultType string).
	FolderPath interface{} `json:"folderPath,omitempty"`
	// FileName - The name of the Azure Data Lake Storage Gen2. Type: string (or Expression with resultType string).
	FileName interface{} `json:"fileName,omitempty"`
	// Format - The format of the Azure Data Lake Storage Gen2 storage.
	Format BasicDatasetStorageFormat `json:"format,omitempty"`
	// Compression - The data compression method used for the blob storage.
	Compression BasicDatasetCompression `json:"compression,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AzureBlobFSDatasetTypeProperties struct.
func (abfdtp *AzureBlobFSDatasetTypeProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "folderPath":
			if v != nil {
				var folderPath interface{}
				err = json.Unmarshal(*v, &folderPath)
				if err != nil {
					return err
				}
				abfdtp.FolderPath = folderPath
			}
		case "fileName":
			if v != nil {
				var fileName interface{}
				err = json.Unmarshal(*v, &fileName)
				if err != nil {
					return err
				}
				abfdtp.FileName = fileName
			}
		case "format":
			if v != nil {
				formatVar, err := unmarshalBasicDatasetStorageFormat(*v)
				if err != nil {
					return err
				}
				abfdtp.Format = formatVar
			}
		case "compression":
			if v != nil {
				compression, err := unmarshalBasicDatasetCompression(*v)
				if err != nil {
					return err
				}
				abfdtp.Compression = compression
			}
		}
	}

	return nil
}

// AzureBlobFSLinkedService azure Data Lake Storage Gen2 linked service.
type AzureBlobFSLinkedService struct {
	// AzureBlobFSLinkedServiceTypeProperties - Azure Data Lake Storage Gen2 linked service properties.
	*AzureBlobFSLinkedServiceTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Parameters - Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the linked service.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Type - Possible values include: 'TypeLinkedService', 'TypeAzureFunction', 'TypeAzureDataExplorer', 'TypeGoogleAdWords', 'TypeOracleServiceCloud', 'TypeDynamicsAX', 'TypeResponsys', 'TypeAzureDatabricks', 'TypeAzureDataLakeAnalytics', 'TypeHDInsightOnDemand', 'TypeSalesforceMarketingCloud', 'TypeNetezza', 'TypeVertica', 'TypeZoho', 'TypeXero', 'TypeSquare', 'TypeSpark', 'TypeShopify', 'TypeServiceNow', 'TypeQuickBooks', 'TypePresto', 'TypePhoenix', 'TypePaypal', 'TypeMarketo', 'TypeMariaDB', 'TypeMagento', 'TypeJira', 'TypeImpala', 'TypeHubspot', 'TypeHive', 'TypeHBase', 'TypeGreenplum', 'TypeGoogleBigQuery', 'TypeEloqua', 'TypeDrill', 'TypeCouchbase', 'TypeConcur', 'TypeAzurePostgreSQL', 'TypeAmazonMWS', 'TypeSapHana', 'TypeSapBW', 'TypeSftp', 'TypeFtpServer', 'TypeHTTPServer', 'TypeAzureSearch', 'TypeCustomDataSource', 'TypeAmazonRedshift', 'TypeAmazonS3', 'TypeRestService', 'TypeSapOpenHub', 'TypeSapEcc', 'TypeSapCloudForCustomer', 'TypeSalesforce', 'TypeOffice365', 'TypeAzureBlobFS', 'TypeAzureDataLakeStore', 'TypeCosmosDbMongoDbAPI', 'TypeMongoDbV2', 'TypeMongoDb', 'TypeCassandra', 'TypeWeb', 'TypeOData', 'TypeHdfs', 'TypeOdbc', 'TypeAzureML', 'TypeTeradata', 'TypeDb2', 'TypeSybase', 'TypePostgreSQL', 'TypeMySQL', 'TypeAzureMySQL', 'TypeOracle', 'TypeFileServer', 'TypeHDInsight', 'TypeDynamics', 'TypeCosmosDb', 'TypeAzureKeyVault', 'TypeAzureBatch', 'TypeAzureSQLDatabase', 'TypeSQLServer', 'TypeAzureSQLDW', 'TypeAzureTableStorage', 'TypeAzureBlobStorage', 'TypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) MarshalJSON() ([]byte, error) {
	abfls.Type = TypeAzureBlobFS
	objectMap := make(map[string]interface{})
	if abfls.AzureBlobFSLinkedServiceTypeProperties != nil {
		objectMap["typeProperties"] = abfls.AzureBlobFSLinkedServiceTypeProperties
	}
	if abfls.ConnectVia != nil {
		objectMap["connectVia"] = abfls.ConnectVia
	}
	if abfls.Description != nil {
		objectMap["description"] = abfls.Description
	}
	if abfls.Parameters != nil {
		objectMap["parameters"] = abfls.Parameters
	}
	if abfls.Annotations != nil {
		objectMap["annotations"] = abfls.Annotations
	}
	if abfls.Type != "" {
		objectMap["type"] = abfls.Type
	}
	for k, v := range abfls.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsAzureFunctionLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsAzureFunctionLinkedService() (*AzureFunctionLinkedService, bool) {
	return nil, false
}

// AsAzureDataExplorerLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsAzureDataExplorerLinkedService() (*AzureDataExplorerLinkedService, bool) {
	return nil, false
}

// AsGoogleAdWordsLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsGoogleAdWordsLinkedService() (*GoogleAdWordsLinkedService, bool) {
	return nil, false
}

// AsOracleServiceCloudLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsOracleServiceCloudLinkedService() (*OracleServiceCloudLinkedService, bool) {
	return nil, false
}

// AsDynamicsAXLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsDynamicsAXLinkedService() (*DynamicsAXLinkedService, bool) {
	return nil, false
}

// AsResponsysLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsResponsysLinkedService() (*ResponsysLinkedService, bool) {
	return nil, false
}

// AsAzureDatabricksLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsAzureDatabricksLinkedService() (*AzureDatabricksLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return nil, false
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsSalesforceMarketingCloudLinkedService() (*SalesforceMarketingCloudLinkedService, bool) {
	return nil, false
}

// AsNetezzaLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsNetezzaLinkedService() (*NetezzaLinkedService, bool) {
	return nil, false
}

// AsVerticaLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsVerticaLinkedService() (*VerticaLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return nil, false
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return nil, false
}

// AsConcurLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return nil, false
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return nil, false
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return nil, false
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return nil, false
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return nil, false
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return nil, false
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return nil, false
}

// AsRestServiceLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsRestServiceLinkedService() (*RestServiceLinkedService, bool) {
	return nil, false
}

// AsSapOpenHubLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsSapOpenHubLinkedService() (*SapOpenHubLinkedService, bool) {
	return nil, false
}

// AsSapEccLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsSapEccLinkedService() (*SapEccLinkedService, bool) {
	return nil, false
}

// AsSapCloudForCustomerLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsSapCloudForCustomerLinkedService() (*SapCloudForCustomerLinkedService, bool) {
	return nil, false
}

// AsSalesforceLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsSalesforceLinkedService() (*SalesforceLinkedService, bool) {
	return nil, false
}

// AsOffice365LinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsOffice365LinkedService() (*Office365LinkedService, bool) {
	return nil, false
}

// AsAzureBlobFSLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsAzureBlobFSLinkedService() (*AzureBlobFSLinkedService, bool) {
	return &abfls, true
}

// AsAzureDataLakeStoreLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsAzureDataLakeStoreLinkedService() (*AzureDataLakeStoreLinkedService, bool) {
	return nil, false
}

// AsCosmosDbMongoDbAPILinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsCosmosDbMongoDbAPILinkedService() (*CosmosDbMongoDbAPILinkedService, bool) {
	return nil, false
}

// AsMongoDbV2LinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsMongoDbV2LinkedService() (*MongoDbV2LinkedService, bool) {
	return nil, false
}

// AsMongoDbLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsMongoDbLinkedService() (*MongoDbLinkedService, bool) {
	return nil, false
}

// AsCassandraLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsCassandraLinkedService() (*CassandraLinkedService, bool) {
	return nil, false
}

// AsWebLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsWebLinkedService() (*WebLinkedService, bool) {
	return nil, false
}

// AsODataLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsODataLinkedService() (*ODataLinkedService, bool) {
	return nil, false
}

// AsHdfsLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsHdfsLinkedService() (*HdfsLinkedService, bool) {
	return nil, false
}

// AsOdbcLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsOdbcLinkedService() (*OdbcLinkedService, bool) {
	return nil, false
}

// AsAzureMLLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsAzureMLLinkedService() (*AzureMLLinkedService, bool) {
	return nil, false
}

// AsTeradataLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsTeradataLinkedService() (*TeradataLinkedService, bool) {
	return nil, false
}

// AsDb2LinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsDb2LinkedService() (*Db2LinkedService, bool) {
	return nil, false
}

// AsSybaseLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsSybaseLinkedService() (*SybaseLinkedService, bool) {
	return nil, false
}

// AsPostgreSQLLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsPostgreSQLLinkedService() (*PostgreSQLLinkedService, bool) {
	return nil, false
}

// AsMySQLLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsMySQLLinkedService() (*MySQLLinkedService, bool) {
	return nil, false
}

// AsAzureMySQLLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsAzureMySQLLinkedService() (*AzureMySQLLinkedService, bool) {
	return nil, false
}

// AsOracleLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsOracleLinkedService() (*OracleLinkedService, bool) {
	return nil, false
}

// AsFileServerLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsFileServerLinkedService() (*FileServerLinkedService, bool) {
	return nil, false
}

// AsHDInsightLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsHDInsightLinkedService() (*HDInsightLinkedService, bool) {
	return nil, false
}

// AsDynamicsLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsDynamicsLinkedService() (*DynamicsLinkedService, bool) {
	return nil, false
}

// AsCosmosDbLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsCosmosDbLinkedService() (*CosmosDbLinkedService, bool) {
	return nil, false
}

// AsAzureKeyVaultLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsAzureKeyVaultLinkedService() (*AzureKeyVaultLinkedService, bool) {
	return nil, false
}

// AsAzureBatchLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsAzureBatchLinkedService() (*AzureBatchLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDatabaseLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsAzureSQLDatabaseLinkedService() (*AzureSQLDatabaseLinkedService, bool) {
	return nil, false
}

// AsSQLServerLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsSQLServerLinkedService() (*SQLServerLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDWLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsAzureSQLDWLinkedService() (*AzureSQLDWLinkedService, bool) {
	return nil, false
}

// AsAzureTableStorageLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsAzureTableStorageLinkedService() (*AzureTableStorageLinkedService, bool) {
	return nil, false
}

// AsAzureBlobStorageLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsAzureBlobStorageLinkedService() (*AzureBlobStorageLinkedService, bool) {
	return nil, false
}

// AsAzureStorageLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsAzureStorageLinkedService() (*AzureStorageLinkedService, bool) {
	return nil, false
}

// AsLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsLinkedService() (*LinkedService, bool) {
	return nil, false
}

// AsBasicLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsBasicLinkedService() (BasicLinkedService, bool) {
	return &abfls, true
}

// UnmarshalJSON is the custom unmarshaler for AzureBlobFSLinkedService struct.
func (abfls *AzureBlobFSLinkedService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var azureBlobFSLinkedServiceTypeProperties AzureBlobFSLinkedServiceTypeProperties
				err = json.Unmarshal(*v, &azureBlobFSLinkedServiceTypeProperties)
				if err != nil {
					return err
				}
				abfls.AzureBlobFSLinkedServiceTypeProperties = &azureBlobFSLinkedServiceTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if abfls.AdditionalProperties == nil {
					abfls.AdditionalProperties = make(map[string]interface{})
				}
				abfls.AdditionalProperties[k] = additionalProperties
			}
		case "connectVia":
			if v != nil {
				var connectVia IntegrationRuntimeReference
				err = json.Unmarshal(*v, &connectVia)
				if err != nil {
					return err
				}
				abfls.ConnectVia = &connectVia
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				abfls.Description = &description
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				abfls.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				abfls.Annotations = &annotations
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicLinkedService
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				abfls.Type = typeVar
			}
		}
	}

	return nil
}

// AzureBlobFSLinkedServiceTypeProperties azure Data Lake Storage Gen2 linked service properties.
type AzureBlobFSLinkedServiceTypeProperties struct {
	// URL - Endpoint for the Azure Data Lake Storage Gen2 service. Type: string (or Expression with resultType string).
	URL interface{} `json:"url,omitempty"`
	// AccountKey - Account key for the Azure Data Lake Storage Gen2 service. Type: string (or Expression with resultType string).
	AccountKey interface{} `json:"accountKey,omitempty"`
	// ServicePrincipalID - The ID of the application used to authenticate against the Azure Data Lake Storage Gen2 account. Type: string (or Expression with resultType string).
	ServicePrincipalID interface{} `json:"servicePrincipalId,omitempty"`
	// ServicePrincipalKey - The Key of the application used to authenticate against the Azure Data Lake Storage Gen2 account.
	ServicePrincipalKey BasicSecretBase `json:"servicePrincipalKey,omitempty"`
	// Tenant - The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
	Tenant interface{} `json:"tenant,omitempty"`
	// EncryptedCredential - The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AzureBlobFSLinkedServiceTypeProperties struct.
func (abflstp *AzureBlobFSLinkedServiceTypeProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "url":
			if v != nil {
				var URL interface{}
				err = json.Unmarshal(*v, &URL)
				if err != nil {
					return err
				}
				abflstp.URL = URL
			}
		case "accountKey":
			if v != nil {
				var accountKey interface{}
				err = json.Unmarshal(*v, &accountKey)
				if err != nil {
					return err
				}
				abflstp.AccountKey = accountKey
			}
		case "servicePrincipalId":
			if v != nil {
				var servicePrincipalID interface{}
				err = json.Unmarshal(*v, &servicePrincipalID)
				if err != nil {
					return err
				}
				abflstp.ServicePrincipalID = servicePrincipalID
			}
		case "servicePrincipalKey":
			if v != nil {
				servicePrincipalKey, err := unmarshalBasicSecretBase(*v)
				if err != nil {
					return err
				}
				abflstp.ServicePrincipalKey = servicePrincipalKey
			}
		case "tenant":
			if v != nil {
				var tenant interface{}
				err = json.Unmarshal(*v, &tenant)
				if err != nil {
					return err
				}
				abflstp.Tenant = tenant
			}
		case "encryptedCredential":
			if v != nil {
				var encryptedCredential interface{}
				err = json.Unmarshal(*v, &encryptedCredential)
				if err != nil {
					return err
				}
				abflstp.EncryptedCredential = encryptedCredential
			}
		}
	}

	return nil
}

// AzureBlobFSSink a copy activity Azure Data Lake Storage Gen2 sink.
type AzureBlobFSSink struct {
	// CopyBehavior - The type of copy behavior for copy sink. Possible values include: 'PreserveHierarchy', 'FlattenHierarchy', 'MergeFiles'
	CopyBehavior CopyBehaviorType `json:"copyBehavior,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// WriteBatchSize - Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize interface{} `json:"writeBatchSize,omitempty"`
	// WriteBatchTimeout - Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout interface{} `json:"writeBatchTimeout,omitempty"`
	// SinkRetryCount - Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount interface{} `json:"sinkRetryCount,omitempty"`
	// SinkRetryWait - Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait interface{} `json:"sinkRetryWait,omitempty"`
	// MaxConcurrentConnections - The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`
	// Type - Possible values include: 'TypeCopySink', 'TypeCosmosDbMongoDbAPISink', 'TypeSalesforceSink', 'TypeAzureDataExplorerSink', 'TypeDynamicsSink', 'TypeOdbcSink', 'TypeAzureSearchIndexSink', 'TypeAzureBlobFSSink', 'TypeAzureDataLakeStoreSink', 'TypeOracleSink', 'TypeSQLDWSink', 'TypeSQLSink', 'TypeDocumentDbCollectionSink', 'TypeFileSystemSink', 'TypeBlobSink', 'TypeAzureTableSink', 'TypeAzureQueueSink', 'TypeSapCloudForCustomerSink'
	Type TypeBasicCopySink `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureBlobFSSink.
func (abfs AzureBlobFSSink) MarshalJSON() ([]byte, error) {
	abfs.Type = TypeAzureBlobFSSink
	objectMap := make(map[string]interface{})
	if abfs.CopyBehavior != "" {
		objectMap["copyBehavior"] = abfs.CopyBehavior
	}
	if abfs.WriteBatchSize != nil {
		objectMap["writeBatchSize"] = abfs.WriteBatchSize
	}
	if abfs.WriteBatchTimeout != nil {
		objectMap["writeBatchTimeout"] = abfs.WriteBatchTimeout
	}
	if abfs.SinkRetryCount != nil {
		objectMap["sinkRetryCount"] = abfs.SinkRetryCount
	}
	if abfs.SinkRetryWait != nil {
		objectMap["sinkRetryWait"] = abfs.SinkRetryWait
	}
	if abfs.MaxConcurrentConnections != nil {
		objectMap["maxConcurrentConnections"] = abfs.MaxConcurrentConnections
	}
	if abfs.Type != "" {
		objectMap["type"] = abfs.Type
	}
	for k, v := range abfs.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsCosmosDbMongoDbAPISink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsCosmosDbMongoDbAPISink() (*CosmosDbMongoDbAPISink, bool) {
	return nil, false
}

// AsSalesforceSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsSalesforceSink() (*SalesforceSink, bool) {
	return nil, false
}

// AsAzureDataExplorerSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsAzureDataExplorerSink() (*AzureDataExplorerSink, bool) {
	return nil, false
}

// AsDynamicsSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsDynamicsSink() (*DynamicsSink, bool) {
	return nil, false
}

// AsOdbcSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsOdbcSink() (*OdbcSink, bool) {
	return nil, false
}

// AsAzureSearchIndexSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsAzureSearchIndexSink() (*AzureSearchIndexSink, bool) {
	return nil, false
}

// AsAzureBlobFSSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsAzureBlobFSSink() (*AzureBlobFSSink, bool) {
	return &abfs, true
}

// AsAzureDataLakeStoreSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsAzureDataLakeStoreSink() (*AzureDataLakeStoreSink, bool) {
	return nil, false
}

// AsOracleSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsOracleSink() (*OracleSink, bool) {
	return nil, false
}

// AsSQLDWSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsSQLDWSink() (*SQLDWSink, bool) {
	return nil, false
}

// AsSQLSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsSQLSink() (*SQLSink, bool) {
	return nil, false
}

// AsDocumentDbCollectionSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsDocumentDbCollectionSink() (*DocumentDbCollectionSink, bool) {
	return nil, false
}

// AsFileSystemSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsFileSystemSink() (*FileSystemSink, bool) {
	return nil, false
}

// AsBlobSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsBlobSink() (*BlobSink, bool) {
	return nil, false
}

// AsAzureTableSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsAzureTableSink() (*AzureTableSink, bool) {
	return nil, false
}

// AsAzureQueueSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsAzureQueueSink() (*AzureQueueSink, bool) {
	return nil, false
}

// AsSapCloudForCustomerSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsSapCloudForCustomerSink() (*SapCloudForCustomerSink, bool) {
	return nil, false
}

// AsCopySink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsCopySink() (*CopySink, bool) {
	return nil, false
}

// AsBasicCopySink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsBasicCopySink() (BasicCopySink, bool) {
	return &abfs, true
}

// UnmarshalJSON is the custom unmarshaler for AzureBlobFSSink struct.
func (abfs *AzureBlobFSSink) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "copyBehavior":
			if v != nil {
				var copyBehavior CopyBehaviorType
				err = json.Unmarshal(*v, &copyBehavior)
				if err != nil {
					return err
				}
				abfs.CopyBehavior = copyBehavior
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if abfs.AdditionalProperties == nil {
					abfs.AdditionalProperties = make(map[string]interface{})
				}
				abfs.AdditionalProperties[k] = additionalProperties
			}
		case "writeBatchSize":
			if v != nil {
				var writeBatchSize interface{}
				err = json.Unmarshal(*v, &writeBatchSize)
				if err != nil {
					return err
				}
				abfs.WriteBatchSize = writeBatchSize
			}
		case "writeBatchTimeout":
			if v != nil {
				var writeBatchTimeout interface{}
				err = json.Unmarshal(*v, &writeBatchTimeout)
				if err != nil {
					return err
				}
				abfs.WriteBatchTimeout = writeBatchTimeout
			}
		case "sinkRetryCount":
			if v != nil {
				var sinkRetryCount interface{}
				err = json.Unmarshal(*v, &sinkRetryCount)
				if err != nil {
					return err
				}
				abfs.SinkRetryCount = sinkRetryCount
			}
		case "sinkRetryWait":
			if v != nil {
				var sinkRetryWait interface{}
				err = json.Unmarshal(*v, &sinkRetryWait)
				if err != nil {
					return err
				}
				abfs.SinkRetryWait = sinkRetryWait
			}
		case "maxConcurrentConnections":
			if v != nil {
				var maxConcurrentConnections interface{}
				err = json.Unmarshal(*v, &maxConcurrentConnections)
				if err != nil {
					return err
				}
				abfs.MaxConcurrentConnections = maxConcurrentConnections
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicCopySink
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				abfs.Type = typeVar
			}
		}
	}

	return nil
}

// AzureBlobFSSource a copy activity Azure BlobFS source.
type AzureBlobFSSource struct {
	// TreatEmptyAsNull - Treat empty as null. Type: boolean (or Expression with resultType boolean).
	TreatEmptyAsNull interface{} `json:"treatEmptyAsNull,omitempty"`
	// SkipHeaderLineCount - Number of header lines to skip from each blob. Type: integer (or Expression with resultType integer).
	SkipHeaderLineCount interface{} `json:"skipHeaderLineCount,omitempty"`
	// Recursive - If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType boolean).
	Recursive interface{} `json:"recursive,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// SourceRetryCount - Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`
	// SourceRetryWait - Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
	// MaxConcurrentConnections - The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`
	// Type - Possible values include: 'TypeCopySource', 'TypeAmazonRedshiftSource', 'TypeGoogleAdWordsSource', 'TypeOracleServiceCloudSource', 'TypeDynamicsAXSource', 'TypeResponsysSource', 'TypeSalesforceMarketingCloudSource', 'TypeVerticaSource', 'TypeNetezzaSource', 'TypeZohoSource', 'TypeXeroSource', 'TypeSquareSource', 'TypeSparkSource', 'TypeShopifySource', 'TypeServiceNowSource', 'TypeQuickBooksSource', 'TypePrestoSource', 'TypePhoenixSource', 'TypePaypalSource', 'TypeMarketoSource', 'TypeMariaDBSource', 'TypeMagentoSource', 'TypeJiraSource', 'TypeImpalaSource', 'TypeHubspotSource', 'TypeHiveSource', 'TypeHBaseSource', 'TypeGreenplumSource', 'TypeGoogleBigQuerySource', 'TypeEloquaSource', 'TypeDrillSource', 'TypeCouchbaseSource', 'TypeConcurSource', 'TypeAzurePostgreSQLSource', 'TypeAmazonMWSSource', 'TypeHTTPSource', 'TypeAzureBlobFSSource', 'TypeAzureDataLakeStoreSource', 'TypeOffice365Source', 'TypeCosmosDbMongoDbAPISource', 'TypeMongoDbV2Source', 'TypeMongoDbSource', 'TypeCassandraSource', 'TypeWebSource', 'TypeOracleSource', 'TypeAzureDataExplorerSource', 'TypeAzureMySQLSource', 'TypeHdfsSource', 'TypeFileSystemSource', 'TypeSQLDWSource', 'TypeSQLSource', 'TypeRestSource', 'TypeSapOpenHubSource', 'TypeSapEccSource', 'TypeSapCloudForCustomerSource', 'TypeSalesforceSource', 'TypeRelationalSource', 'TypeDynamicsSource', 'TypeDocumentDbCollectionSource', 'TypeBlobSource', 'TypeAzureTableSource'
	Type TypeBasicCopySource `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureBlobFSSource.
func (abfs AzureBlobFSSource) MarshalJSON() ([]byte, error) {
	abfs.Type = TypeAzureBlobFSSource
	objectMap := make(map[string]interface{})
	if abfs.TreatEmptyAsNull != nil {
		objectMap["treatEmptyAsNull"] = abfs.TreatEmptyAsNull
	}
	if abfs.SkipHeaderLineCount != nil {
		objectMap["skipHeaderLineCount"] = abfs.SkipHeaderLineCount
	}
	if abfs.Recursive != nil {
		objectMap["recursive"] = abfs.Recursive
	}
	if abfs.SourceRetryCount != nil {
		objectMap["sourceRetryCount"] = abfs.SourceRetryCount
	}
	if abfs.SourceRetryWait != nil {
		objectMap["sourceRetryWait"] = abfs.SourceRetryWait
	}
	if abfs.MaxConcurrentConnections != nil {
		objectMap["maxConcurrentConnections"] = abfs.MaxConcurrentConnections
	}
	if abfs.Type != "" {
		objectMap["type"] = abfs.Type
	}
	for k, v := range abfs.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsAmazonRedshiftSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsAmazonRedshiftSource() (*AmazonRedshiftSource, bool) {
	return nil, false
}

// AsGoogleAdWordsSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsGoogleAdWordsSource() (*GoogleAdWordsSource, bool) {
	return nil, false
}

// AsOracleServiceCloudSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsOracleServiceCloudSource() (*OracleServiceCloudSource, bool) {
	return nil, false
}

// AsDynamicsAXSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsDynamicsAXSource() (*DynamicsAXSource, bool) {
	return nil, false
}

// AsResponsysSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsResponsysSource() (*ResponsysSource, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsSalesforceMarketingCloudSource() (*SalesforceMarketingCloudSource, bool) {
	return nil, false
}

// AsVerticaSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsVerticaSource() (*VerticaSource, bool) {
	return nil, false
}

// AsNetezzaSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsNetezzaSource() (*NetezzaSource, bool) {
	return nil, false
}

// AsZohoSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsZohoSource() (*ZohoSource, bool) {
	return nil, false
}

// AsXeroSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsXeroSource() (*XeroSource, bool) {
	return nil, false
}

// AsSquareSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsSquareSource() (*SquareSource, bool) {
	return nil, false
}

// AsSparkSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsSparkSource() (*SparkSource, bool) {
	return nil, false
}

// AsShopifySource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsShopifySource() (*ShopifySource, bool) {
	return nil, false
}

// AsServiceNowSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsServiceNowSource() (*ServiceNowSource, bool) {
	return nil, false
}

// AsQuickBooksSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsQuickBooksSource() (*QuickBooksSource, bool) {
	return nil, false
}

// AsPrestoSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsPrestoSource() (*PrestoSource, bool) {
	return nil, false
}

// AsPhoenixSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsPhoenixSource() (*PhoenixSource, bool) {
	return nil, false
}

// AsPaypalSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsPaypalSource() (*PaypalSource, bool) {
	return nil, false
}

// AsMarketoSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsMarketoSource() (*MarketoSource, bool) {
	return nil, false
}

// AsMariaDBSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsMariaDBSource() (*MariaDBSource, bool) {
	return nil, false
}

// AsMagentoSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsMagentoSource() (*MagentoSource, bool) {
	return nil, false
}

// AsJiraSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsJiraSource() (*JiraSource, bool) {
	return nil, false
}

// AsImpalaSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsImpalaSource() (*ImpalaSource, bool) {
	return nil, false
}

// AsHubspotSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsHubspotSource() (*HubspotSource, bool) {
	return nil, false
}

// AsHiveSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsHiveSource() (*HiveSource, bool) {
	return nil, false
}

// AsHBaseSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsHBaseSource() (*HBaseSource, bool) {
	return nil, false
}

// AsGreenplumSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsGreenplumSource() (*GreenplumSource, bool) {
	return nil, false
}

// AsGoogleBigQuerySource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsGoogleBigQuerySource() (*GoogleBigQuerySource, bool) {
	return nil, false
}

// AsEloquaSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsEloquaSource() (*EloquaSource, bool) {
	return nil, false
}

// AsDrillSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsDrillSource() (*DrillSource, bool) {
	return nil, false
}

// AsCouchbaseSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsCouchbaseSource() (*CouchbaseSource, bool) {
	return nil, false
}

// AsConcurSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsConcurSource() (*ConcurSource, bool) {
	return nil, false
}

// AsAzurePostgreSQLSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsAzurePostgreSQLSource() (*AzurePostgreSQLSource, bool) {
	return nil, false
}

// AsAmazonMWSSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsAmazonMWSSource() (*AmazonMWSSource, bool) {
	return nil, false
}

// AsHTTPSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsHTTPSource() (*HTTPSource, bool) {
	return nil, false
}

// AsAzureBlobFSSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsAzureBlobFSSource() (*AzureBlobFSSource, bool) {
	return &abfs, true
}

// AsAzureDataLakeStoreSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsAzureDataLakeStoreSource() (*AzureDataLakeStoreSource, bool) {
	return nil, false
}

// AsOffice365Source is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsOffice365Source() (*Office365Source, bool) {
	return nil, false
}

// AsCosmosDbMongoDbAPISource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsCosmosDbMongoDbAPISource() (*CosmosDbMongoDbAPISource, bool) {
	return nil, false
}

// AsMongoDbV2Source is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsMongoDbV2Source() (*MongoDbV2Source, bool) {
	return nil, false
}

// AsMongoDbSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsMongoDbSource() (*MongoDbSource, bool) {
	return nil, false
}

// AsCassandraSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsCassandraSource() (*CassandraSource, bool) {
	return nil, false
}

// AsWebSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsWebSource() (*WebSource, bool) {
	return nil, false
}

// AsOracleSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsOracleSource() (*OracleSource, bool) {
	return nil, false
}

// AsAzureDataExplorerSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsAzureDataExplorerSource() (*AzureDataExplorerSource, bool) {
	return nil, false
}

// AsAzureMySQLSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsAzureMySQLSource() (*AzureMySQLSource, bool) {
	return nil, false
}

// AsHdfsSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsHdfsSource() (*HdfsSource, bool) {
	return nil, false
}

// AsFileSystemSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsFileSystemSource() (*FileSystemSource, bool) {
	return nil, false
}

// AsSQLDWSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsSQLDWSource() (*SQLDWSource, bool) {
	return nil, false
}

// AsSQLSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsSQLSource() (*SQLSource, bool) {
	return nil, false
}

// AsRestSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsRestSource() (*RestSource, bool) {
	return nil, false
}

// AsSapOpenHubSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsSapOpenHubSource() (*SapOpenHubSource, bool) {
	return nil, false
}

// AsSapEccSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsSapEccSource() (*SapEccSource, bool) {
	return nil, false
}

// AsSapCloudForCustomerSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsSapCloudForCustomerSource() (*SapCloudForCustomerSource, bool) {
	return nil, false
}

// AsSalesforceSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsSalesforceSource() (*SalesforceSource, bool) {
	return nil, false
}

// AsRelationalSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsRelationalSource() (*RelationalSource, bool) {
	return nil, false
}

// AsDynamicsSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsDynamicsSource() (*DynamicsSource, bool) {
	return nil, false
}

// AsDocumentDbCollectionSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsDocumentDbCollectionSource() (*DocumentDbCollectionSource, bool) {
	return nil, false
}

// AsBlobSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsBlobSource() (*BlobSource, bool) {
	return nil, false
}

// AsAzureTableSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsAzureTableSource() (*AzureTableSource, bool) {
	return nil, false
}

// AsCopySource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsCopySource() (*CopySource, bool) {
	return nil, false
}

// AsBasicCopySource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsBasicCopySource() (BasicCopySource, bool) {
	return &abfs, true
}

// UnmarshalJSON is the custom unmarshaler for AzureBlobFSSource struct.
func (abfs *AzureBlobFSSource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "treatEmptyAsNull":
			if v != nil {
				var treatEmptyAsNull interface{}
				err = json.Unmarshal(*v, &treatEmptyAsNull)
				if err != nil {
					return err
				}
				abfs.TreatEmptyAsNull = treatEmptyAsNull
			}
		case "skipHeaderLineCount":
			if v != nil {
				var skipHeaderLineCount interface{}
				err = json.Unmarshal(*v, &skipHeaderLineCount)
				if err != nil {
					return err
				}
				abfs.SkipHeaderLineCount = skipHeaderLineCount
			}
		case "recursive":
			if v != nil {
				var recursive interface{}
				err = json.Unmarshal(*v, &recursive)
				if err != nil {
					return err
				}
				abfs.Recursive = recursive
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if abfs.AdditionalProperties == nil {
					abfs.AdditionalProperties = make(map[string]interface{})
				}
				abfs.AdditionalProperties[k] = additionalProperties
			}
		case "sourceRetryCount":
			if v != nil {
				var sourceRetryCount interface{}
				err = json.Unmarshal(*v, &sourceRetryCount)
				if err != nil {
					return err
				}
				abfs.SourceRetryCount = sourceRetryCount
			}
		case "sourceRetryWait":
			if v != nil {
				var sourceRetryWait interface{}
				err = json.Unmarshal(*v, &sourceRetryWait)
				if err != nil {
					return err
				}
				abfs.SourceRetryWait = sourceRetryWait
			}
		case "maxConcurrentConnections":
			if v != nil {
				var maxConcurrentConnections interface{}
				err = json.Unmarshal(*v, &maxConcurrentConnections)
				if err != nil {
					return err
				}
				abfs.MaxConcurrentConnections = maxConcurrentConnections
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicCopySource
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				abfs.Type = typeVar
			}
		}
	}

	return nil
}

// AzureBlobStorageLinkedService the azure blob storage linked service.
type AzureBlobStorageLinkedService struct {
	// AzureBlobStorageLinkedServiceTypeProperties - Azure Blob Storage linked service properties.
	*AzureBlobStorageLinkedServiceTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Parameters - Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the linked service.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Type - Possible values include: 'TypeLinkedService', 'TypeAzureFunction', 'TypeAzureDataExplorer', 'TypeGoogleAdWords', 'TypeOracleServiceCloud', 'TypeDynamicsAX', 'TypeResponsys', 'TypeAzureDatabricks', 'TypeAzureDataLakeAnalytics', 'TypeHDInsightOnDemand', 'TypeSalesforceMarketingCloud', 'TypeNetezza', 'TypeVertica', 'TypeZoho', 'TypeXero', 'TypeSquare', 'TypeSpark', 'TypeShopify', 'TypeServiceNow', 'TypeQuickBooks', 'TypePresto', 'TypePhoenix', 'TypePaypal', 'TypeMarketo', 'TypeMariaDB', 'TypeMagento', 'TypeJira', 'TypeImpala', 'TypeHubspot', 'TypeHive', 'TypeHBase', 'TypeGreenplum', 'TypeGoogleBigQuery', 'TypeEloqua', 'TypeDrill', 'TypeCouchbase', 'TypeConcur', 'TypeAzurePostgreSQL', 'TypeAmazonMWS', 'TypeSapHana', 'TypeSapBW', 'TypeSftp', 'TypeFtpServer', 'TypeHTTPServer', 'TypeAzureSearch', 'TypeCustomDataSource', 'TypeAmazonRedshift', 'TypeAmazonS3', 'TypeRestService', 'TypeSapOpenHub', 'TypeSapEcc', 'TypeSapCloudForCustomer', 'TypeSalesforce', 'TypeOffice365', 'TypeAzureBlobFS', 'TypeAzureDataLakeStore', 'TypeCosmosDbMongoDbAPI', 'TypeMongoDbV2', 'TypeMongoDb', 'TypeCassandra', 'TypeWeb', 'TypeOData', 'TypeHdfs', 'TypeOdbc', 'TypeAzureML', 'TypeTeradata', 'TypeDb2', 'TypeSybase', 'TypePostgreSQL', 'TypeMySQL', 'TypeAzureMySQL', 'TypeOracle', 'TypeFileServer', 'TypeHDInsight', 'TypeDynamics', 'TypeCosmosDb', 'TypeAzureKeyVault', 'TypeAzureBatch', 'TypeAzureSQLDatabase', 'TypeSQLServer', 'TypeAzureSQLDW', 'TypeAzureTableStorage', 'TypeAzureBlobStorage', 'TypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) MarshalJSON() ([]byte, error) {
	absls.Type = TypeAzureBlobStorage
	objectMap := make(map[string]interface{})
	if absls.AzureBlobStorageLinkedServiceTypeProperties != nil {
		objectMap["typeProperties"] = absls.AzureBlobStorageLinkedServiceTypeProperties
	}
	if absls.ConnectVia != nil {
		objectMap["connectVia"] = absls.ConnectVia
	}
	if absls.Description != nil {
		objectMap["description"] = absls.Description
	}
	if absls.Parameters != nil {
		objectMap["parameters"] = absls.Parameters
	}
	if absls.Annotations != nil {
		objectMap["annotations"] = absls.Annotations
	}
	if absls.Type != "" {
		objectMap["type"] = absls.Type
	}
	for k, v := range absls.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsAzureFunctionLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsAzureFunctionLinkedService() (*AzureFunctionLinkedService, bool) {
	return nil, false
}

// AsAzureDataExplorerLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsAzureDataExplorerLinkedService() (*AzureDataExplorerLinkedService, bool) {
	return nil, false
}

// AsGoogleAdWordsLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsGoogleAdWordsLinkedService() (*GoogleAdWordsLinkedService, bool) {
	return nil, false
}

// AsOracleServiceCloudLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsOracleServiceCloudLinkedService() (*OracleServiceCloudLinkedService, bool) {
	return nil, false
}

// AsDynamicsAXLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsDynamicsAXLinkedService() (*DynamicsAXLinkedService, bool) {
	return nil, false
}

// AsResponsysLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsResponsysLinkedService() (*ResponsysLinkedService, bool) {
	return nil, false
}

// AsAzureDatabricksLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsAzureDatabricksLinkedService() (*AzureDatabricksLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return nil, false
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsSalesforceMarketingCloudLinkedService() (*SalesforceMarketingCloudLinkedService, bool) {
	return nil, false
}

// AsNetezzaLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsNetezzaLinkedService() (*NetezzaLinkedService, bool) {
	return nil, false
}

// AsVerticaLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsVerticaLinkedService() (*VerticaLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return nil, false
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return nil, false
}

// AsConcurLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return nil, false
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return nil, false
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return nil, false
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return nil, false
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return nil, false
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return nil, false
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return nil, false
}

// AsRestServiceLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsRestServiceLinkedService() (*RestServiceLinkedService, bool) {
	return nil, false
}

// AsSapOpenHubLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsSapOpenHubLinkedService() (*SapOpenHubLinkedService, bool) {
	return nil, false
}

// AsSapEccLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsSapEccLinkedService() (*SapEccLinkedService, bool) {
	return nil, false
}

// AsSapCloudForCustomerLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsSapCloudForCustomerLinkedService() (*SapCloudForCustomerLinkedService, bool) {
	return nil, false
}

// AsSalesforceLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsSalesforceLinkedService() (*SalesforceLinkedService, bool) {
	return nil, false
}

// AsOffice365LinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsOffice365LinkedService() (*Office365LinkedService, bool) {
	return nil, false
}

// AsAzureBlobFSLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsAzureBlobFSLinkedService() (*AzureBlobFSLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsAzureDataLakeStoreLinkedService() (*AzureDataLakeStoreLinkedService, bool) {
	return nil, false
}

// AsCosmosDbMongoDbAPILinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsCosmosDbMongoDbAPILinkedService() (*CosmosDbMongoDbAPILinkedService, bool) {
	return nil, false
}

// AsMongoDbV2LinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsMongoDbV2LinkedService() (*MongoDbV2LinkedService, bool) {
	return nil, false
}

// AsMongoDbLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsMongoDbLinkedService() (*MongoDbLinkedService, bool) {
	return nil, false
}

// AsCassandraLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsCassandraLinkedService() (*CassandraLinkedService, bool) {
	return nil, false
}

// AsWebLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsWebLinkedService() (*WebLinkedService, bool) {
	return nil, false
}

// AsODataLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsODataLinkedService() (*ODataLinkedService, bool) {
	return nil, false
}

// AsHdfsLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsHdfsLinkedService() (*HdfsLinkedService, bool) {
	return nil, false
}

// AsOdbcLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsOdbcLinkedService() (*OdbcLinkedService, bool) {
	return nil, false
}

// AsAzureMLLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsAzureMLLinkedService() (*AzureMLLinkedService, bool) {
	return nil, false
}

// AsTeradataLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsTeradataLinkedService() (*TeradataLinkedService, bool) {
	return nil, false
}

// AsDb2LinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsDb2LinkedService() (*Db2LinkedService, bool) {
	return nil, false
}

// AsSybaseLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsSybaseLinkedService() (*SybaseLinkedService, bool) {
	return nil, false
}

// AsPostgreSQLLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsPostgreSQLLinkedService() (*PostgreSQLLinkedService, bool) {
	return nil, false
}

// AsMySQLLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsMySQLLinkedService() (*MySQLLinkedService, bool) {
	return nil, false
}

// AsAzureMySQLLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsAzureMySQLLinkedService() (*AzureMySQLLinkedService, bool) {
	return nil, false
}

// AsOracleLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsOracleLinkedService() (*OracleLinkedService, bool) {
	return nil, false
}

// AsFileServerLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsFileServerLinkedService() (*FileServerLinkedService, bool) {
	return nil, false
}

// AsHDInsightLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsHDInsightLinkedService() (*HDInsightLinkedService, bool) {
	return nil, false
}

// AsDynamicsLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsDynamicsLinkedService() (*DynamicsLinkedService, bool) {
	return nil, false
}

// AsCosmosDbLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsCosmosDbLinkedService() (*CosmosDbLinkedService, bool) {
	return nil, false
}

// AsAzureKeyVaultLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsAzureKeyVaultLinkedService() (*AzureKeyVaultLinkedService, bool) {
	return nil, false
}

// AsAzureBatchLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsAzureBatchLinkedService() (*AzureBatchLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDatabaseLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsAzureSQLDatabaseLinkedService() (*AzureSQLDatabaseLinkedService, bool) {
	return nil, false
}

// AsSQLServerLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsSQLServerLinkedService() (*SQLServerLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDWLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsAzureSQLDWLinkedService() (*AzureSQLDWLinkedService, bool) {
	return nil, false
}

// AsAzureTableStorageLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsAzureTableStorageLinkedService() (*AzureTableStorageLinkedService, bool) {
	return nil, false
}

// AsAzureBlobStorageLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsAzureBlobStorageLinkedService() (*AzureBlobStorageLinkedService, bool) {
	return &absls, true
}

// AsAzureStorageLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsAzureStorageLinkedService() (*AzureStorageLinkedService, bool) {
	return nil, false
}

// AsLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsLinkedService() (*LinkedService, bool) {
	return nil, false
}

// AsBasicLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsBasicLinkedService() (BasicLinkedService, bool) {
	return &absls, true
}

// UnmarshalJSON is the custom unmarshaler for AzureBlobStorageLinkedService struct.
func (absls *AzureBlobStorageLinkedService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var azureBlobStorageLinkedServiceTypeProperties AzureBlobStorageLinkedServiceTypeProperties
				err = json.Unmarshal(*v, &azureBlobStorageLinkedServiceTypeProperties)
				if err != nil {
					return err
				}
				absls.AzureBlobStorageLinkedServiceTypeProperties = &azureBlobStorageLinkedServiceTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if absls.AdditionalProperties == nil {
					absls.AdditionalProperties = make(map[string]interface{})
				}
				absls.AdditionalProperties[k] = additionalProperties
			}
		case "connectVia":
			if v != nil {
				var connectVia IntegrationRuntimeReference
				err = json.Unmarshal(*v, &connectVia)
				if err != nil {
					return err
				}
				absls.ConnectVia = &connectVia
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				absls.Description = &description
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				absls.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				absls.Annotations = &annotations
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicLinkedService
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				absls.Type = typeVar
			}
		}
	}

	return nil
}

// AzureBlobStorageLinkedServiceTypeProperties azure Blob Storage linked service properties.
type AzureBlobStorageLinkedServiceTypeProperties struct {
	// ConnectionString - The connection string. It is mutually exclusive with sasUri, serviceEndpoint property. Type: string, SecureString or AzureKeyVaultSecretReference.
	ConnectionString interface{} `json:"connectionString,omitempty"`
	// AccountKey - The Azure key vault secret reference of accountKey in connection string.
	AccountKey *AzureKeyVaultSecretReference `json:"accountKey,omitempty"`
	// SasURI - SAS URI of the Azure Blob Storage resource. It is mutually exclusive with connectionString, serviceEndpoint property. Type: string, SecureString or AzureKeyVaultSecretReference.
	SasURI interface{} `json:"sasUri,omitempty"`
	// SasToken - The Azure key vault secret reference of sasToken in sas uri.
	SasToken *AzureKeyVaultSecretReference `json:"sasToken,omitempty"`
	// ServiceEndpoint - Blob service endpoint of the Azure Blob Storage resource. It is mutually exclusive with connectionString, sasUri property.
	ServiceEndpoint *string `json:"serviceEndpoint,omitempty"`
	// ServicePrincipalID - The ID of the service principal used to authenticate against Azure SQL Data Warehouse. Type: string (or Expression with resultType string).
	ServicePrincipalID interface{} `json:"servicePrincipalId,omitempty"`
	// ServicePrincipalKey - The key of the service principal used to authenticate against Azure SQL Data Warehouse.
	ServicePrincipalKey BasicSecretBase `json:"servicePrincipalKey,omitempty"`
	// Tenant - The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
	Tenant interface{} `json:"tenant,omitempty"`
	// EncryptedCredential - The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
	EncryptedCredential *string `json:"encryptedCredential,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AzureBlobStorageLinkedServiceTypeProperties struct.
func (abslstp *AzureBlobStorageLinkedServiceTypeProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "connectionString":
			if v != nil {
				var connectionString interface{}
				err = json.Unmarshal(*v, &connectionString)
				if err != nil {
					return err
				}
				abslstp.ConnectionString = connectionString
			}
		case "accountKey":
			if v != nil {
				var accountKey AzureKeyVaultSecretReference
				err = json.Unmarshal(*v, &accountKey)
				if err != nil {
					return err
				}
				abslstp.AccountKey = &accountKey
			}
		case "sasUri":
			if v != nil {
				var sasURI interface{}
				err = json.Unmarshal(*v, &sasURI)
				if err != nil {
					return err
				}
				abslstp.SasURI = sasURI
			}
		case "sasToken":
			if v != nil {
				var sasToken AzureKeyVaultSecretReference
				err = json.Unmarshal(*v, &sasToken)
				if err != nil {
					return err
				}
				abslstp.SasToken = &sasToken
			}
		case "serviceEndpoint":
			if v != nil {
				var serviceEndpoint string
				err = json.Unmarshal(*v, &serviceEndpoint)
				if err != nil {
					return err
				}
				abslstp.ServiceEndpoint = &serviceEndpoint
			}
		case "servicePrincipalId":
			if v != nil {
				var servicePrincipalID interface{}
				err = json.Unmarshal(*v, &servicePrincipalID)
				if err != nil {
					return err
				}
				abslstp.ServicePrincipalID = servicePrincipalID
			}
		case "servicePrincipalKey":
			if v != nil {
				servicePrincipalKey, err := unmarshalBasicSecretBase(*v)
				if err != nil {
					return err
				}
				abslstp.ServicePrincipalKey = servicePrincipalKey
			}
		case "tenant":
			if v != nil {
				var tenant interface{}
				err = json.Unmarshal(*v, &tenant)
				if err != nil {
					return err
				}
				abslstp.Tenant = tenant
			}
		case "encryptedCredential":
			if v != nil {
				var encryptedCredential string
				err = json.Unmarshal(*v, &encryptedCredential)
				if err != nil {
					return err
				}
				abslstp.EncryptedCredential = &encryptedCredential
			}
		}
	}

	return nil
}

// AzureDatabricksLinkedService azure Databricks linked service.
type AzureDatabricksLinkedService struct {
	// AzureDatabricksLinkedServiceTypeProperties - Azure Databricks linked service properties.
	*AzureDatabricksLinkedServiceTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Parameters - Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the linked service.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Type - Possible values include: 'TypeLinkedService', 'TypeAzureFunction', 'TypeAzureDataExplorer', 'TypeGoogleAdWords', 'TypeOracleServiceCloud', 'TypeDynamicsAX', 'TypeResponsys', 'TypeAzureDatabricks', 'TypeAzureDataLakeAnalytics', 'TypeHDInsightOnDemand', 'TypeSalesforceMarketingCloud', 'TypeNetezza', 'TypeVertica', 'TypeZoho', 'TypeXero', 'TypeSquare', 'TypeSpark', 'TypeShopify', 'TypeServiceNow', 'TypeQuickBooks', 'TypePresto', 'TypePhoenix', 'TypePaypal', 'TypeMarketo', 'TypeMariaDB', 'TypeMagento', 'TypeJira', 'TypeImpala', 'TypeHubspot', 'TypeHive', 'TypeHBase', 'TypeGreenplum', 'TypeGoogleBigQuery', 'TypeEloqua', 'TypeDrill', 'TypeCouchbase', 'TypeConcur', 'TypeAzurePostgreSQL', 'TypeAmazonMWS', 'TypeSapHana', 'TypeSapBW', 'TypeSftp', 'TypeFtpServer', 'TypeHTTPServer', 'TypeAzureSearch', 'TypeCustomDataSource', 'TypeAmazonRedshift', 'TypeAmazonS3', 'TypeRestService', 'TypeSapOpenHub', 'TypeSapEcc', 'TypeSapCloudForCustomer', 'TypeSalesforce', 'TypeOffice365', 'TypeAzureBlobFS', 'TypeAzureDataLakeStore', 'TypeCosmosDbMongoDbAPI', 'TypeMongoDbV2', 'TypeMongoDb', 'TypeCassandra', 'TypeWeb', 'TypeOData', 'TypeHdfs', 'TypeOdbc', 'TypeAzureML', 'TypeTeradata', 'TypeDb2', 'TypeSybase', 'TypePostgreSQL', 'TypeMySQL', 'TypeAzureMySQL', 'TypeOracle', 'TypeFileServer', 'TypeHDInsight', 'TypeDynamics', 'TypeCosmosDb', 'TypeAzureKeyVault', 'TypeAzureBatch', 'TypeAzureSQLDatabase', 'TypeSQLServer', 'TypeAzureSQLDW', 'TypeAzureTableStorage', 'TypeAzureBlobStorage', 'TypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) MarshalJSON() ([]byte, error) {
	adls.Type = TypeAzureDatabricks
	objectMap := make(map[string]interface{})
	if adls.AzureDatabricksLinkedServiceTypeProperties != nil {
		objectMap["typeProperties"] = adls.AzureDatabricksLinkedServiceTypeProperties
	}
	if adls.ConnectVia != nil {
		objectMap["connectVia"] = adls.ConnectVia
	}
	if adls.Description != nil {
		objectMap["description"] = adls.Description
	}
	if adls.Parameters != nil {
		objectMap["parameters"] = adls.Parameters
	}
	if adls.Annotations != nil {
		objectMap["annotations"] = adls.Annotations
	}
	if adls.Type != "" {
		objectMap["type"] = adls.Type
	}
	for k, v := range adls.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsAzureFunctionLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAzureFunctionLinkedService() (*AzureFunctionLinkedService, bool) {
	return nil, false
}

// AsAzureDataExplorerLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAzureDataExplorerLinkedService() (*AzureDataExplorerLinkedService, bool) {
	return nil, false
}

// AsGoogleAdWordsLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsGoogleAdWordsLinkedService() (*GoogleAdWordsLinkedService, bool) {
	return nil, false
}

// AsOracleServiceCloudLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsOracleServiceCloudLinkedService() (*OracleServiceCloudLinkedService, bool) {
	return nil, false
}

// AsDynamicsAXLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsDynamicsAXLinkedService() (*DynamicsAXLinkedService, bool) {
	return nil, false
}

// AsResponsysLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsResponsysLinkedService() (*ResponsysLinkedService, bool) {
	return nil, false
}

// AsAzureDatabricksLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAzureDatabricksLinkedService() (*AzureDatabricksLinkedService, bool) {
	return &adls, true
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return nil, false
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsSalesforceMarketingCloudLinkedService() (*SalesforceMarketingCloudLinkedService, bool) {
	return nil, false
}

// AsNetezzaLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsNetezzaLinkedService() (*NetezzaLinkedService, bool) {
	return nil, false
}

// AsVerticaLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsVerticaLinkedService() (*VerticaLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return nil, false
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return nil, false
}

// AsConcurLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return nil, false
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return nil, false
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return nil, false
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return nil, false
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return nil, false
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return nil, false
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return nil, false
}

// AsRestServiceLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsRestServiceLinkedService() (*RestServiceLinkedService, bool) {
	return nil, false
}

// AsSapOpenHubLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsSapOpenHubLinkedService() (*SapOpenHubLinkedService, bool) {
	return nil, false
}

// AsSapEccLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsSapEccLinkedService() (*SapEccLinkedService, bool) {
	return nil, false
}

// AsSapCloudForCustomerLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsSapCloudForCustomerLinkedService() (*SapCloudForCustomerLinkedService, bool) {
	return nil, false
}

// AsSalesforceLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsSalesforceLinkedService() (*SalesforceLinkedService, bool) {
	return nil, false
}

// AsOffice365LinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsOffice365LinkedService() (*Office365LinkedService, bool) {
	return nil, false
}

// AsAzureBlobFSLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAzureBlobFSLinkedService() (*AzureBlobFSLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAzureDataLakeStoreLinkedService() (*AzureDataLakeStoreLinkedService, bool) {
	return nil, false
}

// AsCosmosDbMongoDbAPILinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsCosmosDbMongoDbAPILinkedService() (*CosmosDbMongoDbAPILinkedService, bool) {
	return nil, false
}

// AsMongoDbV2LinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsMongoDbV2LinkedService() (*MongoDbV2LinkedService, bool) {
	return nil, false
}

// AsMongoDbLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsMongoDbLinkedService() (*MongoDbLinkedService, bool) {
	return nil, false
}

// AsCassandraLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsCassandraLinkedService() (*CassandraLinkedService, bool) {
	return nil, false
}

// AsWebLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsWebLinkedService() (*WebLinkedService, bool) {
	return nil, false
}

// AsODataLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsODataLinkedService() (*ODataLinkedService, bool) {
	return nil, false
}

// AsHdfsLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsHdfsLinkedService() (*HdfsLinkedService, bool) {
	return nil, false
}

// AsOdbcLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsOdbcLinkedService() (*OdbcLinkedService, bool) {
	return nil, false
}

// AsAzureMLLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAzureMLLinkedService() (*AzureMLLinkedService, bool) {
	return nil, false
}

// AsTeradataLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsTeradataLinkedService() (*TeradataLinkedService, bool) {
	return nil, false
}

// AsDb2LinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsDb2LinkedService() (*Db2LinkedService, bool) {
	return nil, false
}

// AsSybaseLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsSybaseLinkedService() (*SybaseLinkedService, bool) {
	return nil, false
}

// AsPostgreSQLLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsPostgreSQLLinkedService() (*PostgreSQLLinkedService, bool) {
	return nil, false
}

// AsMySQLLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsMySQLLinkedService() (*MySQLLinkedService, bool) {
	return nil, false
}

// AsAzureMySQLLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAzureMySQLLinkedService() (*AzureMySQLLinkedService, bool) {
	return nil, false
}

// AsOracleLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsOracleLinkedService() (*OracleLinkedService, bool) {
	return nil, false
}

// AsFileServerLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsFileServerLinkedService() (*FileServerLinkedService, bool) {
	return nil, false
}

// AsHDInsightLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsHDInsightLinkedService() (*HDInsightLinkedService, bool) {
	return nil, false
}

// AsDynamicsLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsDynamicsLinkedService() (*DynamicsLinkedService, bool) {
	return nil, false
}

// AsCosmosDbLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsCosmosDbLinkedService() (*CosmosDbLinkedService, bool) {
	return nil, false
}

// AsAzureKeyVaultLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAzureKeyVaultLinkedService() (*AzureKeyVaultLinkedService, bool) {
	return nil, false
}

// AsAzureBatchLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAzureBatchLinkedService() (*AzureBatchLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDatabaseLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAzureSQLDatabaseLinkedService() (*AzureSQLDatabaseLinkedService, bool) {
	return nil, false
}

// AsSQLServerLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsSQLServerLinkedService() (*SQLServerLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDWLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAzureSQLDWLinkedService() (*AzureSQLDWLinkedService, bool) {
	return nil, false
}

// AsAzureTableStorageLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAzureTableStorageLinkedService() (*AzureTableStorageLinkedService, bool) {
	return nil, false
}

// AsAzureBlobStorageLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAzureBlobStorageLinkedService() (*AzureBlobStorageLinkedService, bool) {
	return nil, false
}

// AsAzureStorageLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAzureStorageLinkedService() (*AzureStorageLinkedService, bool) {
	return nil, false
}

// AsLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsLinkedService() (*LinkedService, bool) {
	return nil, false
}

// AsBasicLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsBasicLinkedService() (BasicLinkedService, bool) {
	return &adls, true
}

// UnmarshalJSON is the custom unmarshaler for AzureDatabricksLinkedService struct.
func (adls *AzureDatabricksLinkedService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var azureDatabricksLinkedServiceTypeProperties AzureDatabricksLinkedServiceTypeProperties
				err = json.Unmarshal(*v, &azureDatabricksLinkedServiceTypeProperties)
				if err != nil {
					return err
				}
				adls.AzureDatabricksLinkedServiceTypeProperties = &azureDatabricksLinkedServiceTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if adls.AdditionalProperties == nil {
					adls.AdditionalProperties = make(map[string]interface{})
				}
				adls.AdditionalProperties[k] = additionalProperties
			}
		case "connectVia":
			if v != nil {
				var connectVia IntegrationRuntimeReference
				err = json.Unmarshal(*v, &connectVia)
				if err != nil {
					return err
				}
				adls.ConnectVia = &connectVia
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				adls.Description = &description
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				adls.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				adls.Annotations = &annotations
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicLinkedService
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				adls.Type = typeVar
			}
		}
	}

	return nil
}

// AzureDatabricksLinkedServiceTypeProperties azure Databricks linked service properties.
type AzureDatabricksLinkedServiceTypeProperties struct {
	// Domain - <REGION>.azuredatabricks.net, domain name of your Databricks deployment. Type: string (or Expression with resultType string).
	Domain interface{} `json:"domain,omitempty"`
	// AccessToken - Access token for databricks REST API. Refer to https://docs.azuredatabricks.net/api/latest/authentication.html. Type: string (or Expression with resultType string).
	AccessToken BasicSecretBase `json:"accessToken,omitempty"`
	// ExistingClusterID - The id of an existing cluster that will be used for all runs of this job. Type: string (or Expression with resultType string).
	ExistingClusterID interface{} `json:"existingClusterId,omitempty"`
	// NewClusterVersion - The Spark version of new cluster. Type: string (or Expression with resultType string).
	NewClusterVersion interface{} `json:"newClusterVersion,omitempty"`
	// NewClusterNumOfWorker - Number of worker nodes that new cluster should have. A string formatted Int32, like '1' means numOfWorker is 1 or '1:10' means auto-scale from 1 as min and 10 as max. Type: string (or Expression with resultType string).
	NewClusterNumOfWorker interface{} `json:"newClusterNumOfWorker,omitempty"`
	// NewClusterNodeType - The node types of new cluster. Type: string (or Expression with resultType string).
	NewClusterNodeType interface{} `json:"newClusterNodeType,omitempty"`
	// NewClusterSparkConf - A set of optional, user-specified Spark configuration key-value pairs.
	NewClusterSparkConf map[string]interface{} `json:"newClusterSparkConf"`
	// NewClusterSparkEnvVars - A set of optional, user-specified Spark environment variables key-value pairs.
	NewClusterSparkEnvVars map[string]interface{} `json:"newClusterSparkEnvVars"`
	// NewClusterCustomTags - Additional tags for cluster resources.
	NewClusterCustomTags map[string]interface{} `json:"newClusterCustomTags"`
	// NewClusterDriverNodeType - The driver node type for the new cluster. Type: string (or Expression with resultType string).
	NewClusterDriverNodeType interface{} `json:"newClusterDriverNodeType,omitempty"`
	// NewClusterInitScripts - User-defined initialization scripts for the new cluster. Type: array of strings (or Expression with resultType array of strings).
	NewClusterInitScripts interface{} `json:"newClusterInitScripts,omitempty"`
	// NewClusterEnableElasticDisk - Enable the elastic disk on the new cluster. Type: boolean (or Expression with resultType boolean).
	NewClusterEnableElasticDisk interface{} `json:"newClusterEnableElasticDisk,omitempty"`
	// EncryptedCredential - The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureDatabricksLinkedServiceTypeProperties.
func (adlstp AzureDatabricksLinkedServiceTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if adlstp.Domain != nil {
		objectMap["domain"] = adlstp.Domain
	}
	objectMap["accessToken"] = adlstp.AccessToken
	if adlstp.ExistingClusterID != nil {
		objectMap["existingClusterId"] = adlstp.ExistingClusterID
	}
	if adlstp.NewClusterVersion != nil {
		objectMap["newClusterVersion"] = adlstp.NewClusterVersion
	}
	if adlstp.NewClusterNumOfWorker != nil {
		objectMap["newClusterNumOfWorker"] = adlstp.NewClusterNumOfWorker
	}
	if adlstp.NewClusterNodeType != nil {
		objectMap["newClusterNodeType"] = adlstp.NewClusterNodeType
	}
	if adlstp.NewClusterSparkConf != nil {
		objectMap["newClusterSparkConf"] = adlstp.NewClusterSparkConf
	}
	if adlstp.NewClusterSparkEnvVars != nil {
		objectMap["newClusterSparkEnvVars"] = adlstp.NewClusterSparkEnvVars
	}
	if adlstp.NewClusterCustomTags != nil {
		objectMap["newClusterCustomTags"] = adlstp.NewClusterCustomTags
	}
	if adlstp.NewClusterDriverNodeType != nil {
		objectMap["newClusterDriverNodeType"] = adlstp.NewClusterDriverNodeType
	}
	if adlstp.NewClusterInitScripts != nil {
		objectMap["newClusterInitScripts"] = adlstp.NewClusterInitScripts
	}
	if adlstp.NewClusterEnableElasticDisk != nil {
		objectMap["newClusterEnableElasticDisk"] = adlstp.NewClusterEnableElasticDisk
	}
	if adlstp.EncryptedCredential != nil {
		objectMap["encryptedCredential"] = adlstp.EncryptedCredential
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AzureDatabricksLinkedServiceTypeProperties struct.
func (adlstp *AzureDatabricksLinkedServiceTypeProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "domain":
			if v != nil {
				var domain interface{}
				err = json.Unmarshal(*v, &domain)
				if err != nil {
					return err
				}
				adlstp.Domain = domain
			}
		case "accessToken":
			if v != nil {
				accessToken, err := unmarshalBasicSecretBase(*v)
				if err != nil {
					return err
				}
				adlstp.AccessToken = accessToken
			}
		case "existingClusterId":
			if v != nil {
				var existingClusterID interface{}
				err = json.Unmarshal(*v, &existingClusterID)
				if err != nil {
					return err
				}
				adlstp.ExistingClusterID = existingClusterID
			}
		case "newClusterVersion":
			if v != nil {
				var newClusterVersion interface{}
				err = json.Unmarshal(*v, &newClusterVersion)
				if err != nil {
					return err
				}
				adlstp.NewClusterVersion = newClusterVersion
			}
		case "newClusterNumOfWorker":
			if v != nil {
				var newClusterNumOfWorker interface{}
				err = json.Unmarshal(*v, &newClusterNumOfWorker)
				if err != nil {
					return err
				}
				adlstp.NewClusterNumOfWorker = newClusterNumOfWorker
			}
		case "newClusterNodeType":
			if v != nil {
				var newClusterNodeType interface{}
				err = json.Unmarshal(*v, &newClusterNodeType)
				if err != nil {
					return err
				}
				adlstp.NewClusterNodeType = newClusterNodeType
			}
		case "newClusterSparkConf":
			if v != nil {
				var newClusterSparkConf map[string]interface{}
				err = json.Unmarshal(*v, &newClusterSparkConf)
				if err != nil {
					return err
				}
				adlstp.NewClusterSparkConf = newClusterSparkConf
			}
		case "newClusterSparkEnvVars":
			if v != nil {
				var newClusterSparkEnvVars map[string]interface{}
				err = json.Unmarshal(*v, &newClusterSparkEnvVars)
				if err != nil {
					return err
				}
				adlstp.NewClusterSparkEnvVars = newClusterSparkEnvVars
			}
		case "newClusterCustomTags":
			if v != nil {
				var newClusterCustomTags map[string]interface{}
				err = json.Unmarshal(*v, &newClusterCustomTags)
				if err != nil {
					return err
				}
				adlstp.NewClusterCustomTags = newClusterCustomTags
			}
		case "newClusterDriverNodeType":
			if v != nil {
				var newClusterDriverNodeType interface{}
				err = json.Unmarshal(*v, &newClusterDriverNodeType)
				if err != nil {
					return err
				}
				adlstp.NewClusterDriverNodeType = newClusterDriverNodeType
			}
		case "newClusterInitScripts":
			if v != nil {
				var newClusterInitScripts interface{}
				err = json.Unmarshal(*v, &newClusterInitScripts)
				if err != nil {
					return err
				}
				adlstp.NewClusterInitScripts = newClusterInitScripts
			}
		case "newClusterEnableElasticDisk":
			if v != nil {
				var newClusterEnableElasticDisk interface{}
				err = json.Unmarshal(*v, &newClusterEnableElasticDisk)
				if err != nil {
					return err
				}
				adlstp.NewClusterEnableElasticDisk = newClusterEnableElasticDisk
			}
		case "encryptedCredential":
			if v != nil {
				var encryptedCredential interface{}
				err = json.Unmarshal(*v, &encryptedCredential)
				if err != nil {
					return err
				}
				adlstp.EncryptedCredential = encryptedCredential
			}
		}
	}

	return nil
}

// AzureDataExplorerDatasetTypeProperties azure Data Explorer (Kusto) dataset properties.
type AzureDataExplorerDatasetTypeProperties struct {
	// Table - The table name of the Azure Data Explorer database. Type: string (or Expression with resultType string).
	Table interface{} `json:"table,omitempty"`
}

// AzureDataExplorerLinkedService azure Data Explorer (Kusto) linked service.
type AzureDataExplorerLinkedService struct {
	// AzureDataExplorerLinkedServiceTypeProperties - Azure Data Explorer (Kusto) linked service properties.
	*AzureDataExplorerLinkedServiceTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Parameters - Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the linked service.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Type - Possible values include: 'TypeLinkedService', 'TypeAzureFunction', 'TypeAzureDataExplorer', 'TypeGoogleAdWords', 'TypeOracleServiceCloud', 'TypeDynamicsAX', 'TypeResponsys', 'TypeAzureDatabricks', 'TypeAzureDataLakeAnalytics', 'TypeHDInsightOnDemand', 'TypeSalesforceMarketingCloud', 'TypeNetezza', 'TypeVertica', 'TypeZoho', 'TypeXero', 'TypeSquare', 'TypeSpark', 'TypeShopify', 'TypeServiceNow', 'TypeQuickBooks', 'TypePresto', 'TypePhoenix', 'TypePaypal', 'TypeMarketo', 'TypeMariaDB', 'TypeMagento', 'TypeJira', 'TypeImpala', 'TypeHubspot', 'TypeHive', 'TypeHBase', 'TypeGreenplum', 'TypeGoogleBigQuery', 'TypeEloqua', 'TypeDrill', 'TypeCouchbase', 'TypeConcur', 'TypeAzurePostgreSQL', 'TypeAmazonMWS', 'TypeSapHana', 'TypeSapBW', 'TypeSftp', 'TypeFtpServer', 'TypeHTTPServer', 'TypeAzureSearch', 'TypeCustomDataSource', 'TypeAmazonRedshift', 'TypeAmazonS3', 'TypeRestService', 'TypeSapOpenHub', 'TypeSapEcc', 'TypeSapCloudForCustomer', 'TypeSalesforce', 'TypeOffice365', 'TypeAzureBlobFS', 'TypeAzureDataLakeStore', 'TypeCosmosDbMongoDbAPI', 'TypeMongoDbV2', 'TypeMongoDb', 'TypeCassandra', 'TypeWeb', 'TypeOData', 'TypeHdfs', 'TypeOdbc', 'TypeAzureML', 'TypeTeradata', 'TypeDb2', 'TypeSybase', 'TypePostgreSQL', 'TypeMySQL', 'TypeAzureMySQL', 'TypeOracle', 'TypeFileServer', 'TypeHDInsight', 'TypeDynamics', 'TypeCosmosDb', 'TypeAzureKeyVault', 'TypeAzureBatch', 'TypeAzureSQLDatabase', 'TypeSQLServer', 'TypeAzureSQLDW', 'TypeAzureTableStorage', 'TypeAzureBlobStorage', 'TypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) MarshalJSON() ([]byte, error) {
	adels.Type = TypeAzureDataExplorer
	objectMap := make(map[string]interface{})
	if adels.AzureDataExplorerLinkedServiceTypeProperties != nil {
		objectMap["typeProperties"] = adels.AzureDataExplorerLinkedServiceTypeProperties
	}
	if adels.ConnectVia != nil {
		objectMap["connectVia"] = adels.ConnectVia
	}
	if adels.Description != nil {
		objectMap["description"] = adels.Description
	}
	if adels.Parameters != nil {
		objectMap["parameters"] = adels.Parameters
	}
	if adels.Annotations != nil {
		objectMap["annotations"] = adels.Annotations
	}
	if adels.Type != "" {
		objectMap["type"] = adels.Type
	}
	for k, v := range adels.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsAzureFunctionLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsAzureFunctionLinkedService() (*AzureFunctionLinkedService, bool) {
	return nil, false
}

// AsAzureDataExplorerLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsAzureDataExplorerLinkedService() (*AzureDataExplorerLinkedService, bool) {
	return &adels, true
}

// AsGoogleAdWordsLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsGoogleAdWordsLinkedService() (*GoogleAdWordsLinkedService, bool) {
	return nil, false
}

// AsOracleServiceCloudLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsOracleServiceCloudLinkedService() (*OracleServiceCloudLinkedService, bool) {
	return nil, false
}

// AsDynamicsAXLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsDynamicsAXLinkedService() (*DynamicsAXLinkedService, bool) {
	return nil, false
}

// AsResponsysLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsResponsysLinkedService() (*ResponsysLinkedService, bool) {
	return nil, false
}

// AsAzureDatabricksLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsAzureDatabricksLinkedService() (*AzureDatabricksLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return nil, false
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsSalesforceMarketingCloudLinkedService() (*SalesforceMarketingCloudLinkedService, bool) {
	return nil, false
}

// AsNetezzaLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsNetezzaLinkedService() (*NetezzaLinkedService, bool) {
	return nil, false
}

// AsVerticaLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsVerticaLinkedService() (*VerticaLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return nil, false
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return nil, false
}

// AsConcurLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return nil, false
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return nil, false
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return nil, false
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return nil, false
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return nil, false
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return nil, false
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return nil, false
}

// AsRestServiceLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsRestServiceLinkedService() (*RestServiceLinkedService, bool) {
	return nil, false
}

// AsSapOpenHubLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsSapOpenHubLinkedService() (*SapOpenHubLinkedService, bool) {
	return nil, false
}

// AsSapEccLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsSapEccLinkedService() (*SapEccLinkedService, bool) {
	return nil, false
}

// AsSapCloudForCustomerLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsSapCloudForCustomerLinkedService() (*SapCloudForCustomerLinkedService, bool) {
	return nil, false
}

// AsSalesforceLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsSalesforceLinkedService() (*SalesforceLinkedService, bool) {
	return nil, false
}

// AsOffice365LinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsOffice365LinkedService() (*Office365LinkedService, bool) {
	return nil, false
}

// AsAzureBlobFSLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsAzureBlobFSLinkedService() (*AzureBlobFSLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsAzureDataLakeStoreLinkedService() (*AzureDataLakeStoreLinkedService, bool) {
	return nil, false
}

// AsCosmosDbMongoDbAPILinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsCosmosDbMongoDbAPILinkedService() (*CosmosDbMongoDbAPILinkedService, bool) {
	return nil, false
}

// AsMongoDbV2LinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsMongoDbV2LinkedService() (*MongoDbV2LinkedService, bool) {
	return nil, false
}

// AsMongoDbLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsMongoDbLinkedService() (*MongoDbLinkedService, bool) {
	return nil, false
}

// AsCassandraLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsCassandraLinkedService() (*CassandraLinkedService, bool) {
	return nil, false
}

// AsWebLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsWebLinkedService() (*WebLinkedService, bool) {
	return nil, false
}

// AsODataLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsODataLinkedService() (*ODataLinkedService, bool) {
	return nil, false
}

// AsHdfsLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsHdfsLinkedService() (*HdfsLinkedService, bool) {
	return nil, false
}

// AsOdbcLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsOdbcLinkedService() (*OdbcLinkedService, bool) {
	return nil, false
}

// AsAzureMLLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsAzureMLLinkedService() (*AzureMLLinkedService, bool) {
	return nil, false
}

// AsTeradataLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsTeradataLinkedService() (*TeradataLinkedService, bool) {
	return nil, false
}

// AsDb2LinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsDb2LinkedService() (*Db2LinkedService, bool) {
	return nil, false
}

// AsSybaseLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsSybaseLinkedService() (*SybaseLinkedService, bool) {
	return nil, false
}

// AsPostgreSQLLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsPostgreSQLLinkedService() (*PostgreSQLLinkedService, bool) {
	return nil, false
}

// AsMySQLLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsMySQLLinkedService() (*MySQLLinkedService, bool) {
	return nil, false
}

// AsAzureMySQLLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsAzureMySQLLinkedService() (*AzureMySQLLinkedService, bool) {
	return nil, false
}

// AsOracleLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsOracleLinkedService() (*OracleLinkedService, bool) {
	return nil, false
}

// AsFileServerLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsFileServerLinkedService() (*FileServerLinkedService, bool) {
	return nil, false
}

// AsHDInsightLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsHDInsightLinkedService() (*HDInsightLinkedService, bool) {
	return nil, false
}

// AsDynamicsLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsDynamicsLinkedService() (*DynamicsLinkedService, bool) {
	return nil, false
}

// AsCosmosDbLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsCosmosDbLinkedService() (*CosmosDbLinkedService, bool) {
	return nil, false
}

// AsAzureKeyVaultLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsAzureKeyVaultLinkedService() (*AzureKeyVaultLinkedService, bool) {
	return nil, false
}

// AsAzureBatchLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsAzureBatchLinkedService() (*AzureBatchLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDatabaseLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsAzureSQLDatabaseLinkedService() (*AzureSQLDatabaseLinkedService, bool) {
	return nil, false
}

// AsSQLServerLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsSQLServerLinkedService() (*SQLServerLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDWLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsAzureSQLDWLinkedService() (*AzureSQLDWLinkedService, bool) {
	return nil, false
}

// AsAzureTableStorageLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsAzureTableStorageLinkedService() (*AzureTableStorageLinkedService, bool) {
	return nil, false
}

// AsAzureBlobStorageLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsAzureBlobStorageLinkedService() (*AzureBlobStorageLinkedService, bool) {
	return nil, false
}

// AsAzureStorageLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsAzureStorageLinkedService() (*AzureStorageLinkedService, bool) {
	return nil, false
}

// AsLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsLinkedService() (*LinkedService, bool) {
	return nil, false
}

// AsBasicLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsBasicLinkedService() (BasicLinkedService, bool) {
	return &adels, true
}

// UnmarshalJSON is the custom unmarshaler for AzureDataExplorerLinkedService struct.
func (adels *AzureDataExplorerLinkedService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var azureDataExplorerLinkedServiceTypeProperties AzureDataExplorerLinkedServiceTypeProperties
				err = json.Unmarshal(*v, &azureDataExplorerLinkedServiceTypeProperties)
				if err != nil {
					return err
				}
				adels.AzureDataExplorerLinkedServiceTypeProperties = &azureDataExplorerLinkedServiceTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if adels.AdditionalProperties == nil {
					adels.AdditionalProperties = make(map[string]interface{})
				}
				adels.AdditionalProperties[k] = additionalProperties
			}
		case "connectVia":
			if v != nil {
				var connectVia IntegrationRuntimeReference
				err = json.Unmarshal(*v, &connectVia)
				if err != nil {
					return err
				}
				adels.ConnectVia = &connectVia
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				adels.Description = &description
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				adels.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				adels.Annotations = &annotations
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicLinkedService
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				adels.Type = typeVar
			}
		}
	}

	return nil
}

// AzureDataExplorerLinkedServiceTypeProperties azure Data Explorer (Kusto) linked service properties.
type AzureDataExplorerLinkedServiceTypeProperties struct {
	// Endpoint - The endpoint of Azure Data Explorer (the engine's endpoint). URL will be in the format https://<clusterName>.<regionName>.kusto.windows.net. Type: string (or Expression with resultType string)
	Endpoint interface{} `json:"endpoint,omitempty"`
	// ServicePrincipalID - The ID of the service principal used to authenticate against Azure Data Explorer. Type: string (or Expression with resultType string).
	ServicePrincipalID interface{} `json:"servicePrincipalId,omitempty"`
	// ServicePrincipalKey - The key of the service principal used to authenticate against Kusto.
	ServicePrincipalKey BasicSecretBase `json:"servicePrincipalKey,omitempty"`
	// Database - Database name for connection. Type: string (or Expression with resultType string).
	Database interface{} `json:"database,omitempty"`
	// Tenant - The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
	Tenant interface{} `json:"tenant,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AzureDataExplorerLinkedServiceTypeProperties struct.
func (adelstp *AzureDataExplorerLinkedServiceTypeProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "endpoint":
			if v != nil {
				var endpoint interface{}
				err = json.Unmarshal(*v, &endpoint)
				if err != nil {
					return err
				}
				adelstp.Endpoint = endpoint
			}
		case "servicePrincipalId":
			if v != nil {
				var servicePrincipalID interface{}
				err = json.Unmarshal(*v, &servicePrincipalID)
				if err != nil {
					return err
				}
				adelstp.ServicePrincipalID = servicePrincipalID
			}
		case "servicePrincipalKey":
			if v != nil {
				servicePrincipalKey, err := unmarshalBasicSecretBase(*v)
				if err != nil {
					return err
				}
				adelstp.ServicePrincipalKey = servicePrincipalKey
			}
		case "database":
			if v != nil {
				var databaseVar interface{}
				err = json.Unmarshal(*v, &databaseVar)
				if err != nil {
					return err
				}
				adelstp.Database = databaseVar
			}
		case "tenant":
			if v != nil {
				var tenant interface{}
				err = json.Unmarshal(*v, &tenant)
				if err != nil {
					return err
				}
				adelstp.Tenant = tenant
			}
		}
	}

	return nil
}

// AzureDataExplorerSink a copy activity Azure Data Explorer sink.
type AzureDataExplorerSink struct {
	// IngestionMappingName - A name of a pre-created csv mapping that was defined on the target Kusto table. Type: string.
	IngestionMappingName interface{} `json:"ingestionMappingName,omitempty"`
	// IngestionMappingAsJSON - An explicit column mapping description provided in a json format. Type: string.
	IngestionMappingAsJSON interface{} `json:"ingestionMappingAsJson,omitempty"`
	// FlushImmediately - If set to true, any aggregation will be skipped. Default is false. Type: boolean.
	FlushImmediately interface{} `json:"flushImmediately,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// WriteBatchSize - Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize interface{} `json:"writeBatchSize,omitempty"`
	// WriteBatchTimeout - Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout interface{} `json:"writeBatchTimeout,omitempty"`
	// SinkRetryCount - Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount interface{} `json:"sinkRetryCount,omitempty"`
	// SinkRetryWait - Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait interface{} `json:"sinkRetryWait,omitempty"`
	// MaxConcurrentConnections - The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`
	// Type - Possible values include: 'TypeCopySink', 'TypeCosmosDbMongoDbAPISink', 'TypeSalesforceSink', 'TypeAzureDataExplorerSink', 'TypeDynamicsSink', 'TypeOdbcSink', 'TypeAzureSearchIndexSink', 'TypeAzureBlobFSSink', 'TypeAzureDataLakeStoreSink', 'TypeOracleSink', 'TypeSQLDWSink', 'TypeSQLSink', 'TypeDocumentDbCollectionSink', 'TypeFileSystemSink', 'TypeBlobSink', 'TypeAzureTableSink', 'TypeAzureQueueSink', 'TypeSapCloudForCustomerSink'
	Type TypeBasicCopySink `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) MarshalJSON() ([]byte, error) {
	ades.Type = TypeAzureDataExplorerSink
	objectMap := make(map[string]interface{})
	if ades.IngestionMappingName != nil {
		objectMap["ingestionMappingName"] = ades.IngestionMappingName
	}
	if ades.IngestionMappingAsJSON != nil {
		objectMap["ingestionMappingAsJson"] = ades.IngestionMappingAsJSON
	}
	if ades.FlushImmediately != nil {
		objectMap["flushImmediately"] = ades.FlushImmediately
	}
	if ades.WriteBatchSize != nil {
		objectMap["writeBatchSize"] = ades.WriteBatchSize
	}
	if ades.WriteBatchTimeout != nil {
		objectMap["writeBatchTimeout"] = ades.WriteBatchTimeout
	}
	if ades.SinkRetryCount != nil {
		objectMap["sinkRetryCount"] = ades.SinkRetryCount
	}
	if ades.SinkRetryWait != nil {
		objectMap["sinkRetryWait"] = ades.SinkRetryWait
	}
	if ades.MaxConcurrentConnections != nil {
		objectMap["maxConcurrentConnections"] = ades.MaxConcurrentConnections
	}
	if ades.Type != "" {
		objectMap["type"] = ades.Type
	}
	for k, v := range ades.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsCosmosDbMongoDbAPISink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsCosmosDbMongoDbAPISink() (*CosmosDbMongoDbAPISink, bool) {
	return nil, false
}

// AsSalesforceSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsSalesforceSink() (*SalesforceSink, bool) {
	return nil, false
}

// AsAzureDataExplorerSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsAzureDataExplorerSink() (*AzureDataExplorerSink, bool) {
	return &ades, true
}

// AsDynamicsSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsDynamicsSink() (*DynamicsSink, bool) {
	return nil, false
}

// AsOdbcSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsOdbcSink() (*OdbcSink, bool) {
	return nil, false
}

// AsAzureSearchIndexSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsAzureSearchIndexSink() (*AzureSearchIndexSink, bool) {
	return nil, false
}

// AsAzureBlobFSSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsAzureBlobFSSink() (*AzureBlobFSSink, bool) {
	return nil, false
}

// AsAzureDataLakeStoreSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsAzureDataLakeStoreSink() (*AzureDataLakeStoreSink, bool) {
	return nil, false
}

// AsOracleSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsOracleSink() (*OracleSink, bool) {
	return nil, false
}

// AsSQLDWSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsSQLDWSink() (*SQLDWSink, bool) {
	return nil, false
}

// AsSQLSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsSQLSink() (*SQLSink, bool) {
	return nil, false
}

// AsDocumentDbCollectionSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsDocumentDbCollectionSink() (*DocumentDbCollectionSink, bool) {
	return nil, false
}

// AsFileSystemSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsFileSystemSink() (*FileSystemSink, bool) {
	return nil, false
}

// AsBlobSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsBlobSink() (*BlobSink, bool) {
	return nil, false
}

// AsAzureTableSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsAzureTableSink() (*AzureTableSink, bool) {
	return nil, false
}

// AsAzureQueueSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsAzureQueueSink() (*AzureQueueSink, bool) {
	return nil, false
}

// AsSapCloudForCustomerSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsSapCloudForCustomerSink() (*SapCloudForCustomerSink, bool) {
	return nil, false
}

// AsCopySink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsCopySink() (*CopySink, bool) {
	return nil, false
}

// AsBasicCopySink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsBasicCopySink() (BasicCopySink, bool) {
	return &ades, true
}

// UnmarshalJSON is the custom unmarshaler for AzureDataExplorerSink struct.
func (ades *AzureDataExplorerSink) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "ingestionMappingName":
			if v != nil {
				var ingestionMappingName interface{}
				err = json.Unmarshal(*v, &ingestionMappingName)
				if err != nil {
					return err
				}
				ades.IngestionMappingName = ingestionMappingName
			}
		case "ingestionMappingAsJson":
			if v != nil {
				var ingestionMappingAsJSON interface{}
				err = json.Unmarshal(*v, &ingestionMappingAsJSON)
				if err != nil {
					return err
				}
				ades.IngestionMappingAsJSON = ingestionMappingAsJSON
			}
		case "flushImmediately":
			if v != nil {
				var flushImmediately interface{}
				err = json.Unmarshal(*v, &flushImmediately)
				if err != nil {
					return err
				}
				ades.FlushImmediately = flushImmediately
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if ades.AdditionalProperties == nil {
					ades.AdditionalProperties = make(map[string]interface{})
				}
				ades.AdditionalProperties[k] = additionalProperties
			}
		case "writeBatchSize":
			if v != nil {
				var writeBatchSize interface{}
				err = json.Unmarshal(*v, &writeBatchSize)
				if err != nil {
					return err
				}
				ades.WriteBatchSize = writeBatchSize
			}
		case "writeBatchTimeout":
			if v != nil {
				var writeBatchTimeout interface{}
				err = json.Unmarshal(*v, &writeBatchTimeout)
				if err != nil {
					return err
				}
				ades.WriteBatchTimeout = writeBatchTimeout
			}
		case "sinkRetryCount":
			if v != nil {
				var sinkRetryCount interface{}
				err = json.Unmarshal(*v, &sinkRetryCount)
				if err != nil {
					return err
				}
				ades.SinkRetryCount = sinkRetryCount
			}
		case "sinkRetryWait":
			if v != nil {
				var sinkRetryWait interface{}
				err = json.Unmarshal(*v, &sinkRetryWait)
				if err != nil {
					return err
				}
				ades.SinkRetryWait = sinkRetryWait
			}
		case "maxConcurrentConnections":
			if v != nil {
				var maxConcurrentConnections interface{}
				err = json.Unmarshal(*v, &maxConcurrentConnections)
				if err != nil {
					return err
				}
				ades.MaxConcurrentConnections = maxConcurrentConnections
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicCopySink
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ades.Type = typeVar
			}
		}
	}

	return nil
}

// AzureDataExplorerSource a copy activity Azure Data Explorer (Kusto) source.
type AzureDataExplorerSource struct {
	// Query - Database query. Should be a Kusto Query Language (KQL) query. Type: string (or Expression with resultType string).
	Query interface{} `json:"query,omitempty"`
	// NoTruncation - The name of the Boolean option that controls whether truncation is applied to result-sets that go beyond a certain row-count limit.
	NoTruncation interface{} `json:"noTruncation,omitempty"`
	// QueryTimeout - Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9]))..
	QueryTimeout interface{} `json:"queryTimeout,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// SourceRetryCount - Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`
	// SourceRetryWait - Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
	// MaxConcurrentConnections - The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`
	// Type - Possible values include: 'TypeCopySource', 'TypeAmazonRedshiftSource', 'TypeGoogleAdWordsSource', 'TypeOracleServiceCloudSource', 'TypeDynamicsAXSource', 'TypeResponsysSource', 'TypeSalesforceMarketingCloudSource', 'TypeVerticaSource', 'TypeNetezzaSource', 'TypeZohoSource', 'TypeXeroSource', 'TypeSquareSource', 'TypeSparkSource', 'TypeShopifySource', 'TypeServiceNowSource', 'TypeQuickBooksSource', 'TypePrestoSource', 'TypePhoenixSource', 'TypePaypalSource', 'TypeMarketoSource', 'TypeMariaDBSource', 'TypeMagentoSource', 'TypeJiraSource', 'TypeImpalaSource', 'TypeHubspotSource', 'TypeHiveSource', 'TypeHBaseSource', 'TypeGreenplumSource', 'TypeGoogleBigQuerySource', 'TypeEloquaSource', 'TypeDrillSource', 'TypeCouchbaseSource', 'TypeConcurSource', 'TypeAzurePostgreSQLSource', 'TypeAmazonMWSSource', 'TypeHTTPSource', 'TypeAzureBlobFSSource', 'TypeAzureDataLakeStoreSource', 'TypeOffice365Source', 'TypeCosmosDbMongoDbAPISource', 'TypeMongoDbV2Source', 'TypeMongoDbSource', 'TypeCassandraSource', 'TypeWebSource', 'TypeOracleSource', 'TypeAzureDataExplorerSource', 'TypeAzureMySQLSource', 'TypeHdfsSource', 'TypeFileSystemSource', 'TypeSQLDWSource', 'TypeSQLSource', 'TypeRestSource', 'TypeSapOpenHubSource', 'TypeSapEccSource', 'TypeSapCloudForCustomerSource', 'TypeSalesforceSource', 'TypeRelationalSource', 'TypeDynamicsSource', 'TypeDocumentDbCollectionSource', 'TypeBlobSource', 'TypeAzureTableSource'
	Type TypeBasicCopySource `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) MarshalJSON() ([]byte, error) {
	ades.Type = TypeAzureDataExplorerSource
	objectMap := make(map[string]interface{})
	if ades.Query != nil {
		objectMap["query"] = ades.Query
	}
	if ades.NoTruncation != nil {
		objectMap["noTruncation"] = ades.NoTruncation
	}
	if ades.QueryTimeout != nil {
		objectMap["queryTimeout"] = ades.QueryTimeout
	}
	if ades.SourceRetryCount != nil {
		objectMap["sourceRetryCount"] = ades.SourceRetryCount
	}
	if ades.SourceRetryWait != nil {
		objectMap["sourceRetryWait"] = ades.SourceRetryWait
	}
	if ades.MaxConcurrentConnections != nil {
		objectMap["maxConcurrentConnections"] = ades.MaxConcurrentConnections
	}
	if ades.Type != "" {
		objectMap["type"] = ades.Type
	}
	for k, v := range ades.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsAmazonRedshiftSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsAmazonRedshiftSource() (*AmazonRedshiftSource, bool) {
	return nil, false
}

// AsGoogleAdWordsSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsGoogleAdWordsSource() (*GoogleAdWordsSource, bool) {
	return nil, false
}

// AsOracleServiceCloudSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsOracleServiceCloudSource() (*OracleServiceCloudSource, bool) {
	return nil, false
}

// AsDynamicsAXSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsDynamicsAXSource() (*DynamicsAXSource, bool) {
	return nil, false
}

// AsResponsysSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsResponsysSource() (*ResponsysSource, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsSalesforceMarketingCloudSource() (*SalesforceMarketingCloudSource, bool) {
	return nil, false
}

// AsVerticaSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsVerticaSource() (*VerticaSource, bool) {
	return nil, false
}

// AsNetezzaSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsNetezzaSource() (*NetezzaSource, bool) {
	return nil, false
}

// AsZohoSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsZohoSource() (*ZohoSource, bool) {
	return nil, false
}

// AsXeroSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsXeroSource() (*XeroSource, bool) {
	return nil, false
}

// AsSquareSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsSquareSource() (*SquareSource, bool) {
	return nil, false
}

// AsSparkSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsSparkSource() (*SparkSource, bool) {
	return nil, false
}

// AsShopifySource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsShopifySource() (*ShopifySource, bool) {
	return nil, false
}

// AsServiceNowSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsServiceNowSource() (*ServiceNowSource, bool) {
	return nil, false
}

// AsQuickBooksSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsQuickBooksSource() (*QuickBooksSource, bool) {
	return nil, false
}

// AsPrestoSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsPrestoSource() (*PrestoSource, bool) {
	return nil, false
}

// AsPhoenixSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsPhoenixSource() (*PhoenixSource, bool) {
	return nil, false
}

// AsPaypalSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsPaypalSource() (*PaypalSource, bool) {
	return nil, false
}

// AsMarketoSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsMarketoSource() (*MarketoSource, bool) {
	return nil, false
}

// AsMariaDBSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsMariaDBSource() (*MariaDBSource, bool) {
	return nil, false
}

// AsMagentoSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsMagentoSource() (*MagentoSource, bool) {
	return nil, false
}

// AsJiraSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsJiraSource() (*JiraSource, bool) {
	return nil, false
}

// AsImpalaSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsImpalaSource() (*ImpalaSource, bool) {
	return nil, false
}

// AsHubspotSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsHubspotSource() (*HubspotSource, bool) {
	return nil, false
}

// AsHiveSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsHiveSource() (*HiveSource, bool) {
	return nil, false
}

// AsHBaseSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsHBaseSource() (*HBaseSource, bool) {
	return nil, false
}

// AsGreenplumSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsGreenplumSource() (*GreenplumSource, bool) {
	return nil, false
}

// AsGoogleBigQuerySource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsGoogleBigQuerySource() (*GoogleBigQuerySource, bool) {
	return nil, false
}

// AsEloquaSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsEloquaSource() (*EloquaSource, bool) {
	return nil, false
}

// AsDrillSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsDrillSource() (*DrillSource, bool) {
	return nil, false
}

// AsCouchbaseSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsCouchbaseSource() (*CouchbaseSource, bool) {
	return nil, false
}

// AsConcurSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsConcurSource() (*ConcurSource, bool) {
	return nil, false
}

// AsAzurePostgreSQLSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsAzurePostgreSQLSource() (*AzurePostgreSQLSource, bool) {
	return nil, false
}

// AsAmazonMWSSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsAmazonMWSSource() (*AmazonMWSSource, bool) {
	return nil, false
}

// AsHTTPSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsHTTPSource() (*HTTPSource, bool) {
	return nil, false
}

// AsAzureBlobFSSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsAzureBlobFSSource() (*AzureBlobFSSource, bool) {
	return nil, false
}

// AsAzureDataLakeStoreSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsAzureDataLakeStoreSource() (*AzureDataLakeStoreSource, bool) {
	return nil, false
}

// AsOffice365Source is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsOffice365Source() (*Office365Source, bool) {
	return nil, false
}

// AsCosmosDbMongoDbAPISource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsCosmosDbMongoDbAPISource() (*CosmosDbMongoDbAPISource, bool) {
	return nil, false
}

// AsMongoDbV2Source is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsMongoDbV2Source() (*MongoDbV2Source, bool) {
	return nil, false
}

// AsMongoDbSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsMongoDbSource() (*MongoDbSource, bool) {
	return nil, false
}

// AsCassandraSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsCassandraSource() (*CassandraSource, bool) {
	return nil, false
}

// AsWebSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsWebSource() (*WebSource, bool) {
	return nil, false
}

// AsOracleSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsOracleSource() (*OracleSource, bool) {
	return nil, false
}

// AsAzureDataExplorerSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsAzureDataExplorerSource() (*AzureDataExplorerSource, bool) {
	return &ades, true
}

// AsAzureMySQLSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsAzureMySQLSource() (*AzureMySQLSource, bool) {
	return nil, false
}

// AsHdfsSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsHdfsSource() (*HdfsSource, bool) {
	return nil, false
}

// AsFileSystemSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsFileSystemSource() (*FileSystemSource, bool) {
	return nil, false
}

// AsSQLDWSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsSQLDWSource() (*SQLDWSource, bool) {
	return nil, false
}

// AsSQLSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsSQLSource() (*SQLSource, bool) {
	return nil, false
}

// AsRestSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsRestSource() (*RestSource, bool) {
	return nil, false
}

// AsSapOpenHubSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsSapOpenHubSource() (*SapOpenHubSource, bool) {
	return nil, false
}

// AsSapEccSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsSapEccSource() (*SapEccSource, bool) {
	return nil, false
}

// AsSapCloudForCustomerSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsSapCloudForCustomerSource() (*SapCloudForCustomerSource, bool) {
	return nil, false
}

// AsSalesforceSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsSalesforceSource() (*SalesforceSource, bool) {
	return nil, false
}

// AsRelationalSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsRelationalSource() (*RelationalSource, bool) {
	return nil, false
}

// AsDynamicsSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsDynamicsSource() (*DynamicsSource, bool) {
	return nil, false
}

// AsDocumentDbCollectionSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsDocumentDbCollectionSource() (*DocumentDbCollectionSource, bool) {
	return nil, false
}

// AsBlobSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsBlobSource() (*BlobSource, bool) {
	return nil, false
}

// AsAzureTableSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsAzureTableSource() (*AzureTableSource, bool) {
	return nil, false
}

// AsCopySource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsCopySource() (*CopySource, bool) {
	return nil, false
}

// AsBasicCopySource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsBasicCopySource() (BasicCopySource, bool) {
	return &ades, true
}

// UnmarshalJSON is the custom unmarshaler for AzureDataExplorerSource struct.
func (ades *AzureDataExplorerSource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "query":
			if v != nil {
				var query interface{}
				err = json.Unmarshal(*v, &query)
				if err != nil {
					return err
				}
				ades.Query = query
			}
		case "noTruncation":
			if v != nil {
				var noTruncation interface{}
				err = json.Unmarshal(*v, &noTruncation)
				if err != nil {
					return err
				}
				ades.NoTruncation = noTruncation
			}
		case "queryTimeout":
			if v != nil {
				var queryTimeout interface{}
				err = json.Unmarshal(*v, &queryTimeout)
				if err != nil {
					return err
				}
				ades.QueryTimeout = queryTimeout
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if ades.AdditionalProperties == nil {
					ades.AdditionalProperties = make(map[string]interface{})
				}
				ades.AdditionalProperties[k] = additionalProperties
			}
		case "sourceRetryCount":
			if v != nil {
				var sourceRetryCount interface{}
				err = json.Unmarshal(*v, &sourceRetryCount)
				if err != nil {
					return err
				}
				ades.SourceRetryCount = sourceRetryCount
			}
		case "sourceRetryWait":
			if v != nil {
				var sourceRetryWait interface{}
				err = json.Unmarshal(*v, &sourceRetryWait)
				if err != nil {
					return err
				}
				ades.SourceRetryWait = sourceRetryWait
			}
		case "maxConcurrentConnections":
			if v != nil {
				var maxConcurrentConnections interface{}
				err = json.Unmarshal(*v, &maxConcurrentConnections)
				if err != nil {
					return err
				}
				ades.MaxConcurrentConnections = maxConcurrentConnections
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicCopySource
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ades.Type = typeVar
			}
		}
	}

	return nil
}

// AzureDataExplorerTableDataset the Azure Data Explorer (Kusto) dataset.
type AzureDataExplorerTableDataset struct {
	// AzureDataExplorerDatasetTypeProperties - Azure Data Explorer (Kusto) dataset properties.
	*AzureDataExplorerDatasetTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Description - Dataset description.
	Description *string `json:"description,omitempty"`
	// Structure - Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`
	// Schema - Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType: DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`
	// LinkedServiceName - Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
	// Parameters - Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the Dataset.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Folder - The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`
	// Type - Possible values include: 'TypeDataset', 'TypeGoogleAdWordsObject', 'TypeAzureDataExplorerTable', 'TypeOracleServiceCloudObject', 'TypeDynamicsAXResource', 'TypeResponsysObject', 'TypeSalesforceMarketingCloudObject', 'TypeVerticaTable', 'TypeNetezzaTable', 'TypeZohoObject', 'TypeXeroObject', 'TypeSquareObject', 'TypeSparkObject', 'TypeShopifyObject', 'TypeServiceNowObject', 'TypeQuickBooksObject', 'TypePrestoObject', 'TypePhoenixObject', 'TypePaypalObject', 'TypeMarketoObject', 'TypeMariaDBTable', 'TypeMagentoObject', 'TypeJiraObject', 'TypeImpalaObject', 'TypeHubspotObject', 'TypeHiveObject', 'TypeHBaseObject', 'TypeGreenplumTable', 'TypeGoogleBigQueryObject', 'TypeEloquaObject', 'TypeDrillTable', 'TypeCouchbaseTable', 'TypeConcurObject', 'TypeAzurePostgreSQLTable', 'TypeAmazonMWSObject', 'TypeHTTPFile', 'TypeAzureSearchIndex', 'TypeWebTable', 'TypeRestResource', 'TypeSQLServerTable', 'TypeSapOpenHubTable', 'TypeSapEccResource', 'TypeSapCloudForCustomerResource', 'TypeSalesforceObject', 'TypeRelationalTable', 'TypeAzureMySQLTable', 'TypeOracleTable', 'TypeODataResource', 'TypeCosmosDbMongoDbAPICollection', 'TypeMongoDbV2Collection', 'TypeMongoDbCollection', 'TypeFileShare', 'TypeOffice365Table', 'TypeAzureBlobFSFile', 'TypeAzureDataLakeStoreFile', 'TypeDynamicsEntity', 'TypeDocumentDbCollection', 'TypeCustomDataset', 'TypeCassandraTable', 'TypeAzureSQLDWTable', 'TypeAzureSQLTable', 'TypeAzureTable', 'TypeAzureBlob', 'TypeAmazonS3Object'
	Type TypeBasicDataset `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) MarshalJSON() ([]byte, error) {
	adetd.Type = TypeAzureDataExplorerTable
	objectMap := make(map[string]interface{})
	if adetd.AzureDataExplorerDatasetTypeProperties != nil {
		objectMap["typeProperties"] = adetd.AzureDataExplorerDatasetTypeProperties
	}
	if adetd.Description != nil {
		objectMap["description"] = adetd.Description
	}
	if adetd.Structure != nil {
		objectMap["structure"] = adetd.Structure
	}
	if adetd.Schema != nil {
		objectMap["schema"] = adetd.Schema
	}
	if adetd.LinkedServiceName != nil {
		objectMap["linkedServiceName"] = adetd.LinkedServiceName
	}
	if adetd.Parameters != nil {
		objectMap["parameters"] = adetd.Parameters
	}
	if adetd.Annotations != nil {
		objectMap["annotations"] = adetd.Annotations
	}
	if adetd.Folder != nil {
		objectMap["folder"] = adetd.Folder
	}
	if adetd.Type != "" {
		objectMap["type"] = adetd.Type
	}
	for k, v := range adetd.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsGoogleAdWordsObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsGoogleAdWordsObjectDataset() (*GoogleAdWordsObjectDataset, bool) {
	return nil, false
}

// AsAzureDataExplorerTableDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsAzureDataExplorerTableDataset() (*AzureDataExplorerTableDataset, bool) {
	return &adetd, true
}

// AsOracleServiceCloudObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsOracleServiceCloudObjectDataset() (*OracleServiceCloudObjectDataset, bool) {
	return nil, false
}

// AsDynamicsAXResourceDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsDynamicsAXResourceDataset() (*DynamicsAXResourceDataset, bool) {
	return nil, false
}

// AsResponsysObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsResponsysObjectDataset() (*ResponsysObjectDataset, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsSalesforceMarketingCloudObjectDataset() (*SalesforceMarketingCloudObjectDataset, bool) {
	return nil, false
}

// AsVerticaTableDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsVerticaTableDataset() (*VerticaTableDataset, bool) {
	return nil, false
}

// AsNetezzaTableDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsNetezzaTableDataset() (*NetezzaTableDataset, bool) {
	return nil, false
}

// AsZohoObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsZohoObjectDataset() (*ZohoObjectDataset, bool) {
	return nil, false
}

// AsXeroObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsXeroObjectDataset() (*XeroObjectDataset, bool) {
	return nil, false
}

// AsSquareObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsSquareObjectDataset() (*SquareObjectDataset, bool) {
	return nil, false
}

// AsSparkObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsSparkObjectDataset() (*SparkObjectDataset, bool) {
	return nil, false
}

// AsShopifyObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsShopifyObjectDataset() (*ShopifyObjectDataset, bool) {
	return nil, false
}

// AsServiceNowObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsServiceNowObjectDataset() (*ServiceNowObjectDataset, bool) {
	return nil, false
}

// AsQuickBooksObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsQuickBooksObjectDataset() (*QuickBooksObjectDataset, bool) {
	return nil, false
}

// AsPrestoObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsPrestoObjectDataset() (*PrestoObjectDataset, bool) {
	return nil, false
}

// AsPhoenixObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsPhoenixObjectDataset() (*PhoenixObjectDataset, bool) {
	return nil, false
}

// AsPaypalObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsPaypalObjectDataset() (*PaypalObjectDataset, bool) {
	return nil, false
}

// AsMarketoObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsMarketoObjectDataset() (*MarketoObjectDataset, bool) {
	return nil, false
}

// AsMariaDBTableDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsMariaDBTableDataset() (*MariaDBTableDataset, bool) {
	return nil, false
}

// AsMagentoObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsMagentoObjectDataset() (*MagentoObjectDataset, bool) {
	return nil, false
}

// AsJiraObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsJiraObjectDataset() (*JiraObjectDataset, bool) {
	return nil, false
}

// AsImpalaObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsImpalaObjectDataset() (*ImpalaObjectDataset, bool) {
	return nil, false
}

// AsHubspotObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsHubspotObjectDataset() (*HubspotObjectDataset, bool) {
	return nil, false
}

// AsHiveObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsHiveObjectDataset() (*HiveObjectDataset, bool) {
	return nil, false
}

// AsHBaseObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsHBaseObjectDataset() (*HBaseObjectDataset, bool) {
	return nil, false
}

// AsGreenplumTableDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsGreenplumTableDataset() (*GreenplumTableDataset, bool) {
	return nil, false
}

// AsGoogleBigQueryObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsGoogleBigQueryObjectDataset() (*GoogleBigQueryObjectDataset, bool) {
	return nil, false
}

// AsEloquaObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsEloquaObjectDataset() (*EloquaObjectDataset, bool) {
	return nil, false
}

// AsDrillTableDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsDrillTableDataset() (*DrillTableDataset, bool) {
	return nil, false
}

// AsCouchbaseTableDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsCouchbaseTableDataset() (*CouchbaseTableDataset, bool) {
	return nil, false
}

// AsConcurObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsConcurObjectDataset() (*ConcurObjectDataset, bool) {
	return nil, false
}

// AsAzurePostgreSQLTableDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsAzurePostgreSQLTableDataset() (*AzurePostgreSQLTableDataset, bool) {
	return nil, false
}

// AsAmazonMWSObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsAmazonMWSObjectDataset() (*AmazonMWSObjectDataset, bool) {
	return nil, false
}

// AsHTTPDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsHTTPDataset() (*HTTPDataset, bool) {
	return nil, false
}

// AsAzureSearchIndexDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsAzureSearchIndexDataset() (*AzureSearchIndexDataset, bool) {
	return nil, false
}

// AsWebTableDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsWebTableDataset() (*WebTableDataset, bool) {
	return nil, false
}

// AsRestResourceDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsRestResourceDataset() (*RestResourceDataset, bool) {
	return nil, false
}

// AsSQLServerTableDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsSQLServerTableDataset() (*SQLServerTableDataset, bool) {
	return nil, false
}

// AsSapOpenHubTableDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsSapOpenHubTableDataset() (*SapOpenHubTableDataset, bool) {
	return nil, false
}

// AsSapEccResourceDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsSapEccResourceDataset() (*SapEccResourceDataset, bool) {
	return nil, false
}

// AsSapCloudForCustomerResourceDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsSapCloudForCustomerResourceDataset() (*SapCloudForCustomerResourceDataset, bool) {
	return nil, false
}

// AsSalesforceObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsSalesforceObjectDataset() (*SalesforceObjectDataset, bool) {
	return nil, false
}

// AsRelationalTableDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsRelationalTableDataset() (*RelationalTableDataset, bool) {
	return nil, false
}

// AsAzureMySQLTableDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsAzureMySQLTableDataset() (*AzureMySQLTableDataset, bool) {
	return nil, false
}

// AsOracleTableDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsOracleTableDataset() (*OracleTableDataset, bool) {
	return nil, false
}

// AsODataResourceDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsODataResourceDataset() (*ODataResourceDataset, bool) {
	return nil, false
}

// AsCosmosDbMongoDbAPICollectionDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsCosmosDbMongoDbAPICollectionDataset() (*CosmosDbMongoDbAPICollectionDataset, bool) {
	return nil, false
}

// AsMongoDbV2CollectionDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsMongoDbV2CollectionDataset() (*MongoDbV2CollectionDataset, bool) {
	return nil, false
}

// AsMongoDbCollectionDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsMongoDbCollectionDataset() (*MongoDbCollectionDataset, bool) {
	return nil, false
}

// AsFileShareDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsFileShareDataset() (*FileShareDataset, bool) {
	return nil, false
}

// AsOffice365Dataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsOffice365Dataset() (*Office365Dataset, bool) {
	return nil, false
}

// AsAzureBlobFSDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsAzureBlobFSDataset() (*AzureBlobFSDataset, bool) {
	return nil, false
}

// AsAzureDataLakeStoreDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsAzureDataLakeStoreDataset() (*AzureDataLakeStoreDataset, bool) {
	return nil, false
}

// AsDynamicsEntityDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsDynamicsEntityDataset() (*DynamicsEntityDataset, bool) {
	return nil, false
}

// AsDocumentDbCollectionDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsDocumentDbCollectionDataset() (*DocumentDbCollectionDataset, bool) {
	return nil, false
}

// AsCustomDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsCustomDataset() (*CustomDataset, bool) {
	return nil, false
}

// AsCassandraTableDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsCassandraTableDataset() (*CassandraTableDataset, bool) {
	return nil, false
}

// AsAzureSQLDWTableDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsAzureSQLDWTableDataset() (*AzureSQLDWTableDataset, bool) {
	return nil, false
}

// AsAzureSQLTableDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsAzureSQLTableDataset() (*AzureSQLTableDataset, bool) {
	return nil, false
}

// AsAzureTableDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsAzureTableDataset() (*AzureTableDataset, bool) {
	return nil, false
}

// AsAzureBlobDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsAzureBlobDataset() (*AzureBlobDataset, bool) {
	return nil, false
}

// AsAmazonS3Dataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsAmazonS3Dataset() (*AmazonS3Dataset, bool) {
	return nil, false
}

// AsDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsDataset() (*Dataset, bool) {
	return nil, false
}

// AsBasicDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsBasicDataset() (BasicDataset, bool) {
	return &adetd, true
}

// UnmarshalJSON is the custom unmarshaler for AzureDataExplorerTableDataset struct.
func (adetd *AzureDataExplorerTableDataset) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var azureDataExplorerDatasetTypeProperties AzureDataExplorerDatasetTypeProperties
				err = json.Unmarshal(*v, &azureDataExplorerDatasetTypeProperties)
				if err != nil {
					return err
				}
				adetd.AzureDataExplorerDatasetTypeProperties = &azureDataExplorerDatasetTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if adetd.AdditionalProperties == nil {
					adetd.AdditionalProperties = make(map[string]interface{})
				}
				adetd.AdditionalProperties[k] = additionalProperties
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				adetd.Description = &description
			}
		case "structure":
			if v != nil {
				var structure interface{}
				err = json.Unmarshal(*v, &structure)
				if err != nil {
					return err
				}
				adetd.Structure = structure
			}
		case "schema":
			if v != nil {
				var schema interface{}
				err = json.Unmarshal(*v, &schema)
				if err != nil {
					return err
				}
				adetd.Schema = schema
			}
		case "linkedServiceName":
			if v != nil {
				var linkedServiceName LinkedServiceReference
				err = json.Unmarshal(*v, &linkedServiceName)
				if err != nil {
					return err
				}
				adetd.LinkedServiceName = &linkedServiceName
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				adetd.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				adetd.Annotations = &annotations
			}
		case "folder":
			if v != nil {
				var folder DatasetFolder
				err = json.Unmarshal(*v, &folder)
				if err != nil {
					return err
				}
				adetd.Folder = &folder
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicDataset
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				adetd.Type = typeVar
			}
		}
	}

	return nil
}

// AzureDataLakeAnalyticsLinkedService azure Data Lake Analytics linked service.
type AzureDataLakeAnalyticsLinkedService struct {
	// AzureDataLakeAnalyticsLinkedServiceTypeProperties - Azure Data Lake Analytics linked service properties.
	*AzureDataLakeAnalyticsLinkedServiceTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Parameters - Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the linked service.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Type - Possible values include: 'TypeLinkedService', 'TypeAzureFunction', 'TypeAzureDataExplorer', 'TypeGoogleAdWords', 'TypeOracleServiceCloud', 'TypeDynamicsAX', 'TypeResponsys', 'TypeAzureDatabricks', 'TypeAzureDataLakeAnalytics', 'TypeHDInsightOnDemand', 'TypeSalesforceMarketingCloud', 'TypeNetezza', 'TypeVertica', 'TypeZoho', 'TypeXero', 'TypeSquare', 'TypeSpark', 'TypeShopify', 'TypeServiceNow', 'TypeQuickBooks', 'TypePresto', 'TypePhoenix', 'TypePaypal', 'TypeMarketo', 'TypeMariaDB', 'TypeMagento', 'TypeJira', 'TypeImpala', 'TypeHubspot', 'TypeHive', 'TypeHBase', 'TypeGreenplum', 'TypeGoogleBigQuery', 'TypeEloqua', 'TypeDrill', 'TypeCouchbase', 'TypeConcur', 'TypeAzurePostgreSQL', 'TypeAmazonMWS', 'TypeSapHana', 'TypeSapBW', 'TypeSftp', 'TypeFtpServer', 'TypeHTTPServer', 'TypeAzureSearch', 'TypeCustomDataSource', 'TypeAmazonRedshift', 'TypeAmazonS3', 'TypeRestService', 'TypeSapOpenHub', 'TypeSapEcc', 'TypeSapCloudForCustomer', 'TypeSalesforce', 'TypeOffice365', 'TypeAzureBlobFS', 'TypeAzureDataLakeStore', 'TypeCosmosDbMongoDbAPI', 'TypeMongoDbV2', 'TypeMongoDb', 'TypeCassandra', 'TypeWeb', 'TypeOData', 'TypeHdfs', 'TypeOdbc', 'TypeAzureML', 'TypeTeradata', 'TypeDb2', 'TypeSybase', 'TypePostgreSQL', 'TypeMySQL', 'TypeAzureMySQL', 'TypeOracle', 'TypeFileServer', 'TypeHDInsight', 'TypeDynamics', 'TypeCosmosDb', 'TypeAzureKeyVault', 'TypeAzureBatch', 'TypeAzureSQLDatabase', 'TypeSQLServer', 'TypeAzureSQLDW', 'TypeAzureTableStorage', 'TypeAzureBlobStorage', 'TypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) MarshalJSON() ([]byte, error) {
	adlals.Type = TypeAzureDataLakeAnalytics
	objectMap := make(map[string]interface{})
	if adlals.AzureDataLakeAnalyticsLinkedServiceTypeProperties != nil {
		objectMap["typeProperties"] = adlals.AzureDataLakeAnalyticsLinkedServiceTypeProperties
	}
	if adlals.ConnectVia != nil {
		objectMap["connectVia"] = adlals.ConnectVia
	}
	if adlals.Description != nil {
		objectMap["description"] = adlals.Description
	}
	if adlals.Parameters != nil {
		objectMap["parameters"] = adlals.Parameters
	}
	if adlals.Annotations != nil {
		objectMap["annotations"] = adlals.Annotations
	}
	if adlals.Type != "" {
		objectMap["type"] = adlals.Type
	}
	for k, v := range adlals.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsAzureFunctionLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAzureFunctionLinkedService() (*AzureFunctionLinkedService, bool) {
	return nil, false
}

// AsAzureDataExplorerLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAzureDataExplorerLinkedService() (*AzureDataExplorerLinkedService, bool) {
	return nil, false
}

// AsGoogleAdWordsLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsGoogleAdWordsLinkedService() (*GoogleAdWordsLinkedService, bool) {
	return nil, false
}

// AsOracleServiceCloudLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsOracleServiceCloudLinkedService() (*OracleServiceCloudLinkedService, bool) {
	return nil, false
}

// AsDynamicsAXLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsDynamicsAXLinkedService() (*DynamicsAXLinkedService, bool) {
	return nil, false
}

// AsResponsysLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsResponsysLinkedService() (*ResponsysLinkedService, bool) {
	return nil, false
}

// AsAzureDatabricksLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAzureDatabricksLinkedService() (*AzureDatabricksLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return &adlals, true
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsSalesforceMarketingCloudLinkedService() (*SalesforceMarketingCloudLinkedService, bool) {
	return nil, false
}

// AsNetezzaLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsNetezzaLinkedService() (*NetezzaLinkedService, bool) {
	return nil, false
}

// AsVerticaLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsVerticaLinkedService() (*VerticaLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return nil, false
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return nil, false
}

// AsConcurLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return nil, false
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return nil, false
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return nil, false
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return nil, false
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return nil, false
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return nil, false
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return nil, false
}

// AsRestServiceLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsRestServiceLinkedService() (*RestServiceLinkedService, bool) {
	return nil, false
}

// AsSapOpenHubLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsSapOpenHubLinkedService() (*SapOpenHubLinkedService, bool) {
	return nil, false
}

// AsSapEccLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsSapEccLinkedService() (*SapEccLinkedService, bool) {
	return nil, false
}

// AsSapCloudForCustomerLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsSapCloudForCustomerLinkedService() (*SapCloudForCustomerLinkedService, bool) {
	return nil, false
}

// AsSalesforceLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsSalesforceLinkedService() (*SalesforceLinkedService, bool) {
	return nil, false
}

// AsOffice365LinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsOffice365LinkedService() (*Office365LinkedService, bool) {
	return nil, false
}

// AsAzureBlobFSLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAzureBlobFSLinkedService() (*AzureBlobFSLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAzureDataLakeStoreLinkedService() (*AzureDataLakeStoreLinkedService, bool) {
	return nil, false
}

// AsCosmosDbMongoDbAPILinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsCosmosDbMongoDbAPILinkedService() (*CosmosDbMongoDbAPILinkedService, bool) {
	return nil, false
}

// AsMongoDbV2LinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsMongoDbV2LinkedService() (*MongoDbV2LinkedService, bool) {
	return nil, false
}

// AsMongoDbLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsMongoDbLinkedService() (*MongoDbLinkedService, bool) {
	return nil, false
}

// AsCassandraLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsCassandraLinkedService() (*CassandraLinkedService, bool) {
	return nil, false
}

// AsWebLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsWebLinkedService() (*WebLinkedService, bool) {
	return nil, false
}

// AsODataLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsODataLinkedService() (*ODataLinkedService, bool) {
	return nil, false
}

// AsHdfsLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsHdfsLinkedService() (*HdfsLinkedService, bool) {
	return nil, false
}

// AsOdbcLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsOdbcLinkedService() (*OdbcLinkedService, bool) {
	return nil, false
}

// AsAzureMLLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAzureMLLinkedService() (*AzureMLLinkedService, bool) {
	return nil, false
}

// AsTeradataLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsTeradataLinkedService() (*TeradataLinkedService, bool) {
	return nil, false
}

// AsDb2LinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsDb2LinkedService() (*Db2LinkedService, bool) {
	return nil, false
}

// AsSybaseLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsSybaseLinkedService() (*SybaseLinkedService, bool) {
	return nil, false
}

// AsPostgreSQLLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsPostgreSQLLinkedService() (*PostgreSQLLinkedService, bool) {
	return nil, false
}

// AsMySQLLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsMySQLLinkedService() (*MySQLLinkedService, bool) {
	return nil, false
}

// AsAzureMySQLLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAzureMySQLLinkedService() (*AzureMySQLLinkedService, bool) {
	return nil, false
}

// AsOracleLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsOracleLinkedService() (*OracleLinkedService, bool) {
	return nil, false
}

// AsFileServerLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsFileServerLinkedService() (*FileServerLinkedService, bool) {
	return nil, false
}

// AsHDInsightLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsHDInsightLinkedService() (*HDInsightLinkedService, bool) {
	return nil, false
}

// AsDynamicsLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsDynamicsLinkedService() (*DynamicsLinkedService, bool) {
	return nil, false
}

// AsCosmosDbLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsCosmosDbLinkedService() (*CosmosDbLinkedService, bool) {
	return nil, false
}

// AsAzureKeyVaultLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAzureKeyVaultLinkedService() (*AzureKeyVaultLinkedService, bool) {
	return nil, false
}

// AsAzureBatchLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAzureBatchLinkedService() (*AzureBatchLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDatabaseLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAzureSQLDatabaseLinkedService() (*AzureSQLDatabaseLinkedService, bool) {
	return nil, false
}

// AsSQLServerLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsSQLServerLinkedService() (*SQLServerLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDWLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAzureSQLDWLinkedService() (*AzureSQLDWLinkedService, bool) {
	return nil, false
}

// AsAzureTableStorageLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAzureTableStorageLinkedService() (*AzureTableStorageLinkedService, bool) {
	return nil, false
}

// AsAzureBlobStorageLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAzureBlobStorageLinkedService() (*AzureBlobStorageLinkedService, bool) {
	return nil, false
}

// AsAzureStorageLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAzureStorageLinkedService() (*AzureStorageLinkedService, bool) {
	return nil, false
}

// AsLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsLinkedService() (*LinkedService, bool) {
	return nil, false
}

// AsBasicLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsBasicLinkedService() (BasicLinkedService, bool) {
	return &adlals, true
}

// UnmarshalJSON is the custom unmarshaler for AzureDataLakeAnalyticsLinkedService struct.
func (adlals *AzureDataLakeAnalyticsLinkedService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var azureDataLakeAnalyticsLinkedServiceTypeProperties AzureDataLakeAnalyticsLinkedServiceTypeProperties
				err = json.Unmarshal(*v, &azureDataLakeAnalyticsLinkedServiceTypeProperties)
				if err != nil {
					return err
				}
				adlals.AzureDataLakeAnalyticsLinkedServiceTypeProperties = &azureDataLakeAnalyticsLinkedServiceTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if adlals.AdditionalProperties == nil {
					adlals.AdditionalProperties = make(map[string]interface{})
				}
				adlals.AdditionalProperties[k] = additionalProperties
			}
		case "connectVia":
			if v != nil {
				var connectVia IntegrationRuntimeReference
				err = json.Unmarshal(*v, &connectVia)
				if err != nil {
					return err
				}
				adlals.ConnectVia = &connectVia
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				adlals.Description = &description
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				adlals.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				adlals.Annotations = &annotations
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicLinkedService
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				adlals.Type = typeVar
			}
		}
	}

	return nil
}

// AzureDataLakeAnalyticsLinkedServiceTypeProperties azure Data Lake Analytics linked service properties.
type AzureDataLakeAnalyticsLinkedServiceTypeProperties struct {
	// AccountName - The Azure Data Lake Analytics account name. Type: string (or Expression with resultType string).
	AccountName interface{} `json:"accountName,omitempty"`
	// ServicePrincipalID - The ID of the application used to authenticate against the Azure Data Lake Analytics account. Type: string (or Expression with resultType string).
	ServicePrincipalID interface{} `json:"servicePrincipalId,omitempty"`
	// ServicePrincipalKey - The Key of the application used to authenticate against the Azure Data Lake Analytics account.
	ServicePrincipalKey BasicSecretBase `json:"servicePrincipalKey,omitempty"`
	// Tenant - The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
	Tenant interface{} `json:"tenant,omitempty"`
	// SubscriptionID - Data Lake Analytics account subscription ID (if different from Data Factory account). Type: string (or Expression with resultType string).
	SubscriptionID interface{} `json:"subscriptionId,omitempty"`
	// ResourceGroupName - Data Lake Analytics account resource group name (if different from Data Factory account). Type: string (or Expression with resultType string).
	ResourceGroupName interface{} `json:"resourceGroupName,omitempty"`
	// DataLakeAnalyticsURI - Azure Data Lake Analytics URI Type: string (or Expression with resultType string).
	DataLakeAnalyticsURI interface{} `json:"dataLakeAnalyticsUri,omitempty"`
	// EncryptedCredential - The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AzureDataLakeAnalyticsLinkedServiceTypeProperties struct.
func (adlalstp *AzureDataLakeAnalyticsLinkedServiceTypeProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "accountName":
			if v != nil {
				var accountName interface{}
				err = json.Unmarshal(*v, &accountName)
				if err != nil {
					return err
				}
				adlalstp.AccountName = accountName
			}
		case "servicePrincipalId":
			if v != nil {
				var servicePrincipalID interface{}
				err = json.Unmarshal(*v, &servicePrincipalID)
				if err != nil {
					return err
				}
				adlalstp.ServicePrincipalID = servicePrincipalID
			}
		case "servicePrincipalKey":
			if v != nil {
				servicePrincipalKey, err := unmarshalBasicSecretBase(*v)
				if err != nil {
					return err
				}
				adlalstp.ServicePrincipalKey = servicePrincipalKey
			}
		case "tenant":
			if v != nil {
				var tenant interface{}
				err = json.Unmarshal(*v, &tenant)
				if err != nil {
					return err
				}
				adlalstp.Tenant = tenant
			}
		case "subscriptionId":
			if v != nil {
				var subscriptionID interface{}
				err = json.Unmarshal(*v, &subscriptionID)
				if err != nil {
					return err
				}
				adlalstp.SubscriptionID = subscriptionID
			}
		case "resourceGroupName":
			if v != nil {
				var resourceGroupName interface{}
				err = json.Unmarshal(*v, &resourceGroupName)
				if err != nil {
					return err
				}
				adlalstp.ResourceGroupName = resourceGroupName
			}
		case "dataLakeAnalyticsUri":
			if v != nil {
				var dataLakeAnalyticsURI interface{}
				err = json.Unmarshal(*v, &dataLakeAnalyticsURI)
				if err != nil {
					return err
				}
				adlalstp.DataLakeAnalyticsURI = dataLakeAnalyticsURI
			}
		case "encryptedCredential":
			if v != nil {
				var encryptedCredential interface{}
				err = json.Unmarshal(*v, &encryptedCredential)
				if err != nil {
					return err
				}
				adlalstp.EncryptedCredential = encryptedCredential
			}
		}
	}

	return nil
}

// AzureDataLakeStoreDataset azure Data Lake Store dataset.
type AzureDataLakeStoreDataset struct {
	// AzureDataLakeStoreDatasetTypeProperties - Azure Data Lake Store dataset properties.
	*AzureDataLakeStoreDatasetTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Description - Dataset description.
	Description *string `json:"description,omitempty"`
	// Structure - Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`
	// Schema - Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType: DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`
	// LinkedServiceName - Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
	// Parameters - Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the Dataset.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Folder - The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`
	// Type - Possible values include: 'TypeDataset', 'TypeGoogleAdWordsObject', 'TypeAzureDataExplorerTable', 'TypeOracleServiceCloudObject', 'TypeDynamicsAXResource', 'TypeResponsysObject', 'TypeSalesforceMarketingCloudObject', 'TypeVerticaTable', 'TypeNetezzaTable', 'TypeZohoObject', 'TypeXeroObject', 'TypeSquareObject', 'TypeSparkObject', 'TypeShopifyObject', 'TypeServiceNowObject', 'TypeQuickBooksObject', 'TypePrestoObject', 'TypePhoenixObject', 'TypePaypalObject', 'TypeMarketoObject', 'TypeMariaDBTable', 'TypeMagentoObject', 'TypeJiraObject', 'TypeImpalaObject', 'TypeHubspotObject', 'TypeHiveObject', 'TypeHBaseObject', 'TypeGreenplumTable', 'TypeGoogleBigQueryObject', 'TypeEloquaObject', 'TypeDrillTable', 'TypeCouchbaseTable', 'TypeConcurObject', 'TypeAzurePostgreSQLTable', 'TypeAmazonMWSObject', 'TypeHTTPFile', 'TypeAzureSearchIndex', 'TypeWebTable', 'TypeRestResource', 'TypeSQLServerTable', 'TypeSapOpenHubTable', 'TypeSapEccResource', 'TypeSapCloudForCustomerResource', 'TypeSalesforceObject', 'TypeRelationalTable', 'TypeAzureMySQLTable', 'TypeOracleTable', 'TypeODataResource', 'TypeCosmosDbMongoDbAPICollection', 'TypeMongoDbV2Collection', 'TypeMongoDbCollection', 'TypeFileShare', 'TypeOffice365Table', 'TypeAzureBlobFSFile', 'TypeAzureDataLakeStoreFile', 'TypeDynamicsEntity', 'TypeDocumentDbCollection', 'TypeCustomDataset', 'TypeCassandraTable', 'TypeAzureSQLDWTable', 'TypeAzureSQLTable', 'TypeAzureTable', 'TypeAzureBlob', 'TypeAmazonS3Object'
	Type TypeBasicDataset `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) MarshalJSON() ([]byte, error) {
	adlsd.Type = TypeAzureDataLakeStoreFile
	objectMap := make(map[string]interface{})
	if adlsd.AzureDataLakeStoreDatasetTypeProperties != nil {
		objectMap["typeProperties"] = adlsd.AzureDataLakeStoreDatasetTypeProperties
	}
	if adlsd.Description != nil {
		objectMap["description"] = adlsd.Description
	}
	if adlsd.Structure != nil {
		objectMap["structure"] = adlsd.Structure
	}
	if adlsd.Schema != nil {
		objectMap["schema"] = adlsd.Schema
	}
	if adlsd.LinkedServiceName != nil {
		objectMap["linkedServiceName"] = adlsd.LinkedServiceName
	}
	if adlsd.Parameters != nil {
		objectMap["parameters"] = adlsd.Parameters
	}
	if adlsd.Annotations != nil {
		objectMap["annotations"] = adlsd.Annotations
	}
	if adlsd.Folder != nil {
		objectMap["folder"] = adlsd.Folder
	}
	if adlsd.Type != "" {
		objectMap["type"] = adlsd.Type
	}
	for k, v := range adlsd.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsGoogleAdWordsObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsGoogleAdWordsObjectDataset() (*GoogleAdWordsObjectDataset, bool) {
	return nil, false
}

// AsAzureDataExplorerTableDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsAzureDataExplorerTableDataset() (*AzureDataExplorerTableDataset, bool) {
	return nil, false
}

// AsOracleServiceCloudObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsOracleServiceCloudObjectDataset() (*OracleServiceCloudObjectDataset, bool) {
	return nil, false
}

// AsDynamicsAXResourceDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsDynamicsAXResourceDataset() (*DynamicsAXResourceDataset, bool) {
	return nil, false
}

// AsResponsysObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsResponsysObjectDataset() (*ResponsysObjectDataset, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsSalesforceMarketingCloudObjectDataset() (*SalesforceMarketingCloudObjectDataset, bool) {
	return nil, false
}

// AsVerticaTableDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsVerticaTableDataset() (*VerticaTableDataset, bool) {
	return nil, false
}

// AsNetezzaTableDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsNetezzaTableDataset() (*NetezzaTableDataset, bool) {
	return nil, false
}

// AsZohoObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsZohoObjectDataset() (*ZohoObjectDataset, bool) {
	return nil, false
}

// AsXeroObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsXeroObjectDataset() (*XeroObjectDataset, bool) {
	return nil, false
}

// AsSquareObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsSquareObjectDataset() (*SquareObjectDataset, bool) {
	return nil, false
}

// AsSparkObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsSparkObjectDataset() (*SparkObjectDataset, bool) {
	return nil, false
}

// AsShopifyObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsShopifyObjectDataset() (*ShopifyObjectDataset, bool) {
	return nil, false
}

// AsServiceNowObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsServiceNowObjectDataset() (*ServiceNowObjectDataset, bool) {
	return nil, false
}

// AsQuickBooksObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsQuickBooksObjectDataset() (*QuickBooksObjectDataset, bool) {
	return nil, false
}

// AsPrestoObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsPrestoObjectDataset() (*PrestoObjectDataset, bool) {
	return nil, false
}

// AsPhoenixObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsPhoenixObjectDataset() (*PhoenixObjectDataset, bool) {
	return nil, false
}

// AsPaypalObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsPaypalObjectDataset() (*PaypalObjectDataset, bool) {
	return nil, false
}

// AsMarketoObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsMarketoObjectDataset() (*MarketoObjectDataset, bool) {
	return nil, false
}

// AsMariaDBTableDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsMariaDBTableDataset() (*MariaDBTableDataset, bool) {
	return nil, false
}

// AsMagentoObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsMagentoObjectDataset() (*MagentoObjectDataset, bool) {
	return nil, false
}

// AsJiraObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsJiraObjectDataset() (*JiraObjectDataset, bool) {
	return nil, false
}

// AsImpalaObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsImpalaObjectDataset() (*ImpalaObjectDataset, bool) {
	return nil, false
}

// AsHubspotObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsHubspotObjectDataset() (*HubspotObjectDataset, bool) {
	return nil, false
}

// AsHiveObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsHiveObjectDataset() (*HiveObjectDataset, bool) {
	return nil, false
}

// AsHBaseObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsHBaseObjectDataset() (*HBaseObjectDataset, bool) {
	return nil, false
}

// AsGreenplumTableDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsGreenplumTableDataset() (*GreenplumTableDataset, bool) {
	return nil, false
}

// AsGoogleBigQueryObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsGoogleBigQueryObjectDataset() (*GoogleBigQueryObjectDataset, bool) {
	return nil, false
}

// AsEloquaObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsEloquaObjectDataset() (*EloquaObjectDataset, bool) {
	return nil, false
}

// AsDrillTableDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsDrillTableDataset() (*DrillTableDataset, bool) {
	return nil, false
}

// AsCouchbaseTableDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsCouchbaseTableDataset() (*CouchbaseTableDataset, bool) {
	return nil, false
}

// AsConcurObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsConcurObjectDataset() (*ConcurObjectDataset, bool) {
	return nil, false
}

// AsAzurePostgreSQLTableDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsAzurePostgreSQLTableDataset() (*AzurePostgreSQLTableDataset, bool) {
	return nil, false
}

// AsAmazonMWSObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsAmazonMWSObjectDataset() (*AmazonMWSObjectDataset, bool) {
	return nil, false
}

// AsHTTPDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsHTTPDataset() (*HTTPDataset, bool) {
	return nil, false
}

// AsAzureSearchIndexDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsAzureSearchIndexDataset() (*AzureSearchIndexDataset, bool) {
	return nil, false
}

// AsWebTableDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsWebTableDataset() (*WebTableDataset, bool) {
	return nil, false
}

// AsRestResourceDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsRestResourceDataset() (*RestResourceDataset, bool) {
	return nil, false
}

// AsSQLServerTableDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsSQLServerTableDataset() (*SQLServerTableDataset, bool) {
	return nil, false
}

// AsSapOpenHubTableDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsSapOpenHubTableDataset() (*SapOpenHubTableDataset, bool) {
	return nil, false
}

// AsSapEccResourceDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsSapEccResourceDataset() (*SapEccResourceDataset, bool) {
	return nil, false
}

// AsSapCloudForCustomerResourceDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsSapCloudForCustomerResourceDataset() (*SapCloudForCustomerResourceDataset, bool) {
	return nil, false
}

// AsSalesforceObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsSalesforceObjectDataset() (*SalesforceObjectDataset, bool) {
	return nil, false
}

// AsRelationalTableDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsRelationalTableDataset() (*RelationalTableDataset, bool) {
	return nil, false
}

// AsAzureMySQLTableDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsAzureMySQLTableDataset() (*AzureMySQLTableDataset, bool) {
	return nil, false
}

// AsOracleTableDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsOracleTableDataset() (*OracleTableDataset, bool) {
	return nil, false
}

// AsODataResourceDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsODataResourceDataset() (*ODataResourceDataset, bool) {
	return nil, false
}

// AsCosmosDbMongoDbAPICollectionDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsCosmosDbMongoDbAPICollectionDataset() (*CosmosDbMongoDbAPICollectionDataset, bool) {
	return nil, false
}

// AsMongoDbV2CollectionDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsMongoDbV2CollectionDataset() (*MongoDbV2CollectionDataset, bool) {
	return nil, false
}

// AsMongoDbCollectionDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsMongoDbCollectionDataset() (*MongoDbCollectionDataset, bool) {
	return nil, false
}

// AsFileShareDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsFileShareDataset() (*FileShareDataset, bool) {
	return nil, false
}

// AsOffice365Dataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsOffice365Dataset() (*Office365Dataset, bool) {
	return nil, false
}

// AsAzureBlobFSDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsAzureBlobFSDataset() (*AzureBlobFSDataset, bool) {
	return nil, false
}

// AsAzureDataLakeStoreDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsAzureDataLakeStoreDataset() (*AzureDataLakeStoreDataset, bool) {
	return &adlsd, true
}

// AsDynamicsEntityDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsDynamicsEntityDataset() (*DynamicsEntityDataset, bool) {
	return nil, false
}

// AsDocumentDbCollectionDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsDocumentDbCollectionDataset() (*DocumentDbCollectionDataset, bool) {
	return nil, false
}

// AsCustomDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsCustomDataset() (*CustomDataset, bool) {
	return nil, false
}

// AsCassandraTableDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsCassandraTableDataset() (*CassandraTableDataset, bool) {
	return nil, false
}

// AsAzureSQLDWTableDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsAzureSQLDWTableDataset() (*AzureSQLDWTableDataset, bool) {
	return nil, false
}

// AsAzureSQLTableDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsAzureSQLTableDataset() (*AzureSQLTableDataset, bool) {
	return nil, false
}

// AsAzureTableDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsAzureTableDataset() (*AzureTableDataset, bool) {
	return nil, false
}

// AsAzureBlobDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsAzureBlobDataset() (*AzureBlobDataset, bool) {
	return nil, false
}

// AsAmazonS3Dataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsAmazonS3Dataset() (*AmazonS3Dataset, bool) {
	return nil, false
}

// AsDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsDataset() (*Dataset, bool) {
	return nil, false
}

// AsBasicDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsBasicDataset() (BasicDataset, bool) {
	return &adlsd, true
}

// UnmarshalJSON is the custom unmarshaler for AzureDataLakeStoreDataset struct.
func (adlsd *AzureDataLakeStoreDataset) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var azureDataLakeStoreDatasetTypeProperties AzureDataLakeStoreDatasetTypeProperties
				err = json.Unmarshal(*v, &azureDataLakeStoreDatasetTypeProperties)
				if err != nil {
					return err
				}
				adlsd.AzureDataLakeStoreDatasetTypeProperties = &azureDataLakeStoreDatasetTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if adlsd.AdditionalProperties == nil {
					adlsd.AdditionalProperties = make(map[string]interface{})
				}
				adlsd.AdditionalProperties[k] = additionalProperties
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				adlsd.Description = &description
			}
		case "structure":
			if v != nil {
				var structure interface{}
				err = json.Unmarshal(*v, &structure)
				if err != nil {
					return err
				}
				adlsd.Structure = structure
			}
		case "schema":
			if v != nil {
				var schema interface{}
				err = json.Unmarshal(*v, &schema)
				if err != nil {
					return err
				}
				adlsd.Schema = schema
			}
		case "linkedServiceName":
			if v != nil {
				var linkedServiceName LinkedServiceReference
				err = json.Unmarshal(*v, &linkedServiceName)
				if err != nil {
					return err
				}
				adlsd.LinkedServiceName = &linkedServiceName
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				adlsd.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				adlsd.Annotations = &annotations
			}
		case "folder":
			if v != nil {
				var folder DatasetFolder
				err = json.Unmarshal(*v, &folder)
				if err != nil {
					return err
				}
				adlsd.Folder = &folder
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicDataset
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				adlsd.Type = typeVar
			}
		}
	}

	return nil
}

// AzureDataLakeStoreDatasetTypeProperties azure Data Lake Store dataset properties.
type AzureDataLakeStoreDatasetTypeProperties struct {
	// FolderPath - Path to the folder in the Azure Data Lake Store. Type: string (or Expression with resultType string).
	FolderPath interface{} `json:"folderPath,omitempty"`
	// FileName - The name of the file in the Azure Data Lake Store. Type: string (or Expression with resultType string).
	FileName interface{} `json:"fileName,omitempty"`
	// Format - The format of the Data Lake Store.
	Format BasicDatasetStorageFormat `json:"format,omitempty"`
	// Compression - The data compression method used for the item(s) in the Azure Data Lake Store.
	Compression BasicDatasetCompression `json:"compression,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AzureDataLakeStoreDatasetTypeProperties struct.
func (adlsdtp *AzureDataLakeStoreDatasetTypeProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "folderPath":
			if v != nil {
				var folderPath interface{}
				err = json.Unmarshal(*v, &folderPath)
				if err != nil {
					return err
				}
				adlsdtp.FolderPath = folderPath
			}
		case "fileName":
			if v != nil {
				var fileName interface{}
				err = json.Unmarshal(*v, &fileName)
				if err != nil {
					return err
				}
				adlsdtp.FileName = fileName
			}
		case "format":
			if v != nil {
				formatVar, err := unmarshalBasicDatasetStorageFormat(*v)
				if err != nil {
					return err
				}
				adlsdtp.Format = formatVar
			}
		case "compression":
			if v != nil {
				compression, err := unmarshalBasicDatasetCompression(*v)
				if err != nil {
					return err
				}
				adlsdtp.Compression = compression
			}
		}
	}

	return nil
}

// AzureDataLakeStoreLinkedService azure Data Lake Store linked service.
type AzureDataLakeStoreLinkedService struct {
	// AzureDataLakeStoreLinkedServiceTypeProperties - Azure Data Lake Store linked service properties.
	*AzureDataLakeStoreLinkedServiceTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Parameters - Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the linked service.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Type - Possible values include: 'TypeLinkedService', 'TypeAzureFunction', 'TypeAzureDataExplorer', 'TypeGoogleAdWords', 'TypeOracleServiceCloud', 'TypeDynamicsAX', 'TypeResponsys', 'TypeAzureDatabricks', 'TypeAzureDataLakeAnalytics', 'TypeHDInsightOnDemand', 'TypeSalesforceMarketingCloud', 'TypeNetezza', 'TypeVertica', 'TypeZoho', 'TypeXero', 'TypeSquare', 'TypeSpark', 'TypeShopify', 'TypeServiceNow', 'TypeQuickBooks', 'TypePresto', 'TypePhoenix', 'TypePaypal', 'TypeMarketo', 'TypeMariaDB', 'TypeMagento', 'TypeJira', 'TypeImpala', 'TypeHubspot', 'TypeHive', 'TypeHBase', 'TypeGreenplum', 'TypeGoogleBigQuery', 'TypeEloqua', 'TypeDrill', 'TypeCouchbase', 'TypeConcur', 'TypeAzurePostgreSQL', 'TypeAmazonMWS', 'TypeSapHana', 'TypeSapBW', 'TypeSftp', 'TypeFtpServer', 'TypeHTTPServer', 'TypeAzureSearch', 'TypeCustomDataSource', 'TypeAmazonRedshift', 'TypeAmazonS3', 'TypeRestService', 'TypeSapOpenHub', 'TypeSapEcc', 'TypeSapCloudForCustomer', 'TypeSalesforce', 'TypeOffice365', 'TypeAzureBlobFS', 'TypeAzureDataLakeStore', 'TypeCosmosDbMongoDbAPI', 'TypeMongoDbV2', 'TypeMongoDb', 'TypeCassandra', 'TypeWeb', 'TypeOData', 'TypeHdfs', 'TypeOdbc', 'TypeAzureML', 'TypeTeradata', 'TypeDb2', 'TypeSybase', 'TypePostgreSQL', 'TypeMySQL', 'TypeAzureMySQL', 'TypeOracle', 'TypeFileServer', 'TypeHDInsight', 'TypeDynamics', 'TypeCosmosDb', 'TypeAzureKeyVault', 'TypeAzureBatch', 'TypeAzureSQLDatabase', 'TypeSQLServer', 'TypeAzureSQLDW', 'TypeAzureTableStorage', 'TypeAzureBlobStorage', 'TypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) MarshalJSON() ([]byte, error) {
	adlsls.Type = TypeAzureDataLakeStore
	objectMap := make(map[string]interface{})
	if adlsls.AzureDataLakeStoreLinkedServiceTypeProperties != nil {
		objectMap["typeProperties"] = adlsls.AzureDataLakeStoreLinkedServiceTypeProperties
	}
	if adlsls.ConnectVia != nil {
		objectMap["connectVia"] = adlsls.ConnectVia
	}
	if adlsls.Description != nil {
		objectMap["description"] = adlsls.Description
	}
	if adlsls.Parameters != nil {
		objectMap["parameters"] = adlsls.Parameters
	}
	if adlsls.Annotations != nil {
		objectMap["annotations"] = adlsls.Annotations
	}
	if adlsls.Type != "" {
		objectMap["type"] = adlsls.Type
	}
	for k, v := range adlsls.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsAzureFunctionLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsAzureFunctionLinkedService() (*AzureFunctionLinkedService, bool) {
	return nil, false
}

// AsAzureDataExplorerLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsAzureDataExplorerLinkedService() (*AzureDataExplorerLinkedService, bool) {
	return nil, false
}

// AsGoogleAdWordsLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsGoogleAdWordsLinkedService() (*GoogleAdWordsLinkedService, bool) {
	return nil, false
}

// AsOracleServiceCloudLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsOracleServiceCloudLinkedService() (*OracleServiceCloudLinkedService, bool) {
	return nil, false
}

// AsDynamicsAXLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsDynamicsAXLinkedService() (*DynamicsAXLinkedService, bool) {
	return nil, false
}

// AsResponsysLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsResponsysLinkedService() (*ResponsysLinkedService, bool) {
	return nil, false
}

// AsAzureDatabricksLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsAzureDatabricksLinkedService() (*AzureDatabricksLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return nil, false
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsSalesforceMarketingCloudLinkedService() (*SalesforceMarketingCloudLinkedService, bool) {
	return nil, false
}

// AsNetezzaLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsNetezzaLinkedService() (*NetezzaLinkedService, bool) {
	return nil, false
}

// AsVerticaLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsVerticaLinkedService() (*VerticaLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return nil, false
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return nil, false
}

// AsConcurLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return nil, false
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return nil, false
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return nil, false
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return nil, false
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return nil, false
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return nil, false
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return nil, false
}

// AsRestServiceLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsRestServiceLinkedService() (*RestServiceLinkedService, bool) {
	return nil, false
}

// AsSapOpenHubLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsSapOpenHubLinkedService() (*SapOpenHubLinkedService, bool) {
	return nil, false
}

// AsSapEccLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsSapEccLinkedService() (*SapEccLinkedService, bool) {
	return nil, false
}

// AsSapCloudForCustomerLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsSapCloudForCustomerLinkedService() (*SapCloudForCustomerLinkedService, bool) {
	return nil, false
}

// AsSalesforceLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsSalesforceLinkedService() (*SalesforceLinkedService, bool) {
	return nil, false
}

// AsOffice365LinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsOffice365LinkedService() (*Office365LinkedService, bool) {
	return nil, false
}

// AsAzureBlobFSLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsAzureBlobFSLinkedService() (*AzureBlobFSLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsAzureDataLakeStoreLinkedService() (*AzureDataLakeStoreLinkedService, bool) {
	return &adlsls, true
}

// AsCosmosDbMongoDbAPILinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsCosmosDbMongoDbAPILinkedService() (*CosmosDbMongoDbAPILinkedService, bool) {
	return nil, false
}

// AsMongoDbV2LinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsMongoDbV2LinkedService() (*MongoDbV2LinkedService, bool) {
	return nil, false
}

// AsMongoDbLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsMongoDbLinkedService() (*MongoDbLinkedService, bool) {
	return nil, false
}

// AsCassandraLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsCassandraLinkedService() (*CassandraLinkedService, bool) {
	return nil, false
}

// AsWebLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsWebLinkedService() (*WebLinkedService, bool) {
	return nil, false
}

// AsODataLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsODataLinkedService() (*ODataLinkedService, bool) {
	return nil, false
}

// AsHdfsLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsHdfsLinkedService() (*HdfsLinkedService, bool) {
	return nil, false
}

// AsOdbcLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsOdbcLinkedService() (*OdbcLinkedService, bool) {
	return nil, false
}

// AsAzureMLLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsAzureMLLinkedService() (*AzureMLLinkedService, bool) {
	return nil, false
}

// AsTeradataLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsTeradataLinkedService() (*TeradataLinkedService, bool) {
	return nil, false
}

// AsDb2LinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsDb2LinkedService() (*Db2LinkedService, bool) {
	return nil, false
}

// AsSybaseLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsSybaseLinkedService() (*SybaseLinkedService, bool) {
	return nil, false
}

// AsPostgreSQLLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsPostgreSQLLinkedService() (*PostgreSQLLinkedService, bool) {
	return nil, false
}

// AsMySQLLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsMySQLLinkedService() (*MySQLLinkedService, bool) {
	return nil, false
}

// AsAzureMySQLLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsAzureMySQLLinkedService() (*AzureMySQLLinkedService, bool) {
	return nil, false
}

// AsOracleLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsOracleLinkedService() (*OracleLinkedService, bool) {
	return nil, false
}

// AsFileServerLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsFileServerLinkedService() (*FileServerLinkedService, bool) {
	return nil, false
}

// AsHDInsightLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsHDInsightLinkedService() (*HDInsightLinkedService, bool) {
	return nil, false
}

// AsDynamicsLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsDynamicsLinkedService() (*DynamicsLinkedService, bool) {
	return nil, false
}

// AsCosmosDbLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsCosmosDbLinkedService() (*CosmosDbLinkedService, bool) {
	return nil, false
}

// AsAzureKeyVaultLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsAzureKeyVaultLinkedService() (*AzureKeyVaultLinkedService, bool) {
	return nil, false
}

// AsAzureBatchLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsAzureBatchLinkedService() (*AzureBatchLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDatabaseLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsAzureSQLDatabaseLinkedService() (*AzureSQLDatabaseLinkedService, bool) {
	return nil, false
}

// AsSQLServerLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsSQLServerLinkedService() (*SQLServerLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDWLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsAzureSQLDWLinkedService() (*AzureSQLDWLinkedService, bool) {
	return nil, false
}

// AsAzureTableStorageLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsAzureTableStorageLinkedService() (*AzureTableStorageLinkedService, bool) {
	return nil, false
}

// AsAzureBlobStorageLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsAzureBlobStorageLinkedService() (*AzureBlobStorageLinkedService, bool) {
	return nil, false
}

// AsAzureStorageLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsAzureStorageLinkedService() (*AzureStorageLinkedService, bool) {
	return nil, false
}

// AsLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsLinkedService() (*LinkedService, bool) {
	return nil, false
}

// AsBasicLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsBasicLinkedService() (BasicLinkedService, bool) {
	return &adlsls, true
}

// UnmarshalJSON is the custom unmarshaler for AzureDataLakeStoreLinkedService struct.
func (adlsls *AzureDataLakeStoreLinkedService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var azureDataLakeStoreLinkedServiceTypeProperties AzureDataLakeStoreLinkedServiceTypeProperties
				err = json.Unmarshal(*v, &azureDataLakeStoreLinkedServiceTypeProperties)
				if err != nil {
					return err
				}
				adlsls.AzureDataLakeStoreLinkedServiceTypeProperties = &azureDataLakeStoreLinkedServiceTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if adlsls.AdditionalProperties == nil {
					adlsls.AdditionalProperties = make(map[string]interface{})
				}
				adlsls.AdditionalProperties[k] = additionalProperties
			}
		case "connectVia":
			if v != nil {
				var connectVia IntegrationRuntimeReference
				err = json.Unmarshal(*v, &connectVia)
				if err != nil {
					return err
				}
				adlsls.ConnectVia = &connectVia
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				adlsls.Description = &description
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				adlsls.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				adlsls.Annotations = &annotations
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicLinkedService
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				adlsls.Type = typeVar
			}
		}
	}

	return nil
}

// AzureDataLakeStoreLinkedServiceTypeProperties azure Data Lake Store linked service properties.
type AzureDataLakeStoreLinkedServiceTypeProperties struct {
	// DataLakeStoreURI - Data Lake Store service URI. Type: string (or Expression with resultType string).
	DataLakeStoreURI interface{} `json:"dataLakeStoreUri,omitempty"`
	// ServicePrincipalID - The ID of the application used to authenticate against the Azure Data Lake Store account. Type: string (or Expression with resultType string).
	ServicePrincipalID interface{} `json:"servicePrincipalId,omitempty"`
	// ServicePrincipalKey - The Key of the application used to authenticate against the Azure Data Lake Store account.
	ServicePrincipalKey BasicSecretBase `json:"servicePrincipalKey,omitempty"`
	// Tenant - The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
	Tenant interface{} `json:"tenant,omitempty"`
	// AccountName - Data Lake Store account name. Type: string (or Expression with resultType string).
	AccountName interface{} `json:"accountName,omitempty"`
	// SubscriptionID - Data Lake Store account subscription ID (if different from Data Factory account). Type: string (or Expression with resultType string).
	SubscriptionID interface{} `json:"subscriptionId,omitempty"`
	// ResourceGroupName - Data Lake Store account resource group name (if different from Data Factory account). Type: string (or Expression with resultType string).
	ResourceGroupName interface{} `json:"resourceGroupName,omitempty"`
	// EncryptedCredential - The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AzureDataLakeStoreLinkedServiceTypeProperties struct.
func (adlslstp *AzureDataLakeStoreLinkedServiceTypeProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "dataLakeStoreUri":
			if v != nil {
				var dataLakeStoreURI interface{}
				err = json.Unmarshal(*v, &dataLakeStoreURI)
				if err != nil {
					return err
				}
				adlslstp.DataLakeStoreURI = dataLakeStoreURI
			}
		case "servicePrincipalId":
			if v != nil {
				var servicePrincipalID interface{}
				err = json.Unmarshal(*v, &servicePrincipalID)
				if err != nil {
					return err
				}
				adlslstp.ServicePrincipalID = servicePrincipalID
			}
		case "servicePrincipalKey":
			if v != nil {
				servicePrincipalKey, err := unmarshalBasicSecretBase(*v)
				if err != nil {
					return err
				}
				adlslstp.ServicePrincipalKey = servicePrincipalKey
			}
		case "tenant":
			if v != nil {
				var tenant interface{}
				err = json.Unmarshal(*v, &tenant)
				if err != nil {
					return err
				}
				adlslstp.Tenant = tenant
			}
		case "accountName":
			if v != nil {
				var accountName interface{}
				err = json.Unmarshal(*v, &accountName)
				if err != nil {
					return err
				}
				adlslstp.AccountName = accountName
			}
		case "subscriptionId":
			if v != nil {
				var subscriptionID interface{}
				err = json.Unmarshal(*v, &subscriptionID)
				if err != nil {
					return err
				}
				adlslstp.SubscriptionID = subscriptionID
			}
		case "resourceGroupName":
			if v != nil {
				var resourceGroupName interface{}
				err = json.Unmarshal(*v, &resourceGroupName)
				if err != nil {
					return err
				}
				adlslstp.ResourceGroupName = resourceGroupName
			}
		case "encryptedCredential":
			if v != nil {
				var encryptedCredential interface{}
				err = json.Unmarshal(*v, &encryptedCredential)
				if err != nil {
					return err
				}
				adlslstp.EncryptedCredential = encryptedCredential
			}
		}
	}

	return nil
}

// AzureDataLakeStoreSink a copy activity Azure Data Lake Store sink.
type AzureDataLakeStoreSink struct {
	// CopyBehavior - The type of copy behavior for copy sink. Possible values include: 'PreserveHierarchy', 'FlattenHierarchy', 'MergeFiles'
	CopyBehavior CopyBehaviorType `json:"copyBehavior,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// WriteBatchSize - Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize interface{} `json:"writeBatchSize,omitempty"`
	// WriteBatchTimeout - Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout interface{} `json:"writeBatchTimeout,omitempty"`
	// SinkRetryCount - Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount interface{} `json:"sinkRetryCount,omitempty"`
	// SinkRetryWait - Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait interface{} `json:"sinkRetryWait,omitempty"`
	// MaxConcurrentConnections - The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`
	// Type - Possible values include: 'TypeCopySink', 'TypeCosmosDbMongoDbAPISink', 'TypeSalesforceSink', 'TypeAzureDataExplorerSink', 'TypeDynamicsSink', 'TypeOdbcSink', 'TypeAzureSearchIndexSink', 'TypeAzureBlobFSSink', 'TypeAzureDataLakeStoreSink', 'TypeOracleSink', 'TypeSQLDWSink', 'TypeSQLSink', 'TypeDocumentDbCollectionSink', 'TypeFileSystemSink', 'TypeBlobSink', 'TypeAzureTableSink', 'TypeAzureQueueSink', 'TypeSapCloudForCustomerSink'
	Type TypeBasicCopySink `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) MarshalJSON() ([]byte, error) {
	adlss.Type = TypeAzureDataLakeStoreSink
	objectMap := make(map[string]interface{})
	if adlss.CopyBehavior != "" {
		objectMap["copyBehavior"] = adlss.CopyBehavior
	}
	if adlss.WriteBatchSize != nil {
		objectMap["writeBatchSize"] = adlss.WriteBatchSize
	}
	if adlss.WriteBatchTimeout != nil {
		objectMap["writeBatchTimeout"] = adlss.WriteBatchTimeout
	}
	if adlss.SinkRetryCount != nil {
		objectMap["sinkRetryCount"] = adlss.SinkRetryCount
	}
	if adlss.SinkRetryWait != nil {
		objectMap["sinkRetryWait"] = adlss.SinkRetryWait
	}
	if adlss.MaxConcurrentConnections != nil {
		objectMap["maxConcurrentConnections"] = adlss.MaxConcurrentConnections
	}
	if adlss.Type != "" {
		objectMap["type"] = adlss.Type
	}
	for k, v := range adlss.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsCosmosDbMongoDbAPISink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsCosmosDbMongoDbAPISink() (*CosmosDbMongoDbAPISink, bool) {
	return nil, false
}

// AsSalesforceSink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsSalesforceSink() (*SalesforceSink, bool) {
	return nil, false
}

// AsAzureDataExplorerSink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsAzureDataExplorerSink() (*AzureDataExplorerSink, bool) {
	return nil, false
}

// AsDynamicsSink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsDynamicsSink() (*DynamicsSink, bool) {
	return nil, false
}

// AsOdbcSink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsOdbcSink() (*OdbcSink, bool) {
	return nil, false
}

// AsAzureSearchIndexSink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsAzureSearchIndexSink() (*AzureSearchIndexSink, bool) {
	return nil, false
}

// AsAzureBlobFSSink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsAzureBlobFSSink() (*AzureBlobFSSink, bool) {
	return nil, false
}

// AsAzureDataLakeStoreSink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsAzureDataLakeStoreSink() (*AzureDataLakeStoreSink, bool) {
	return &adlss, true
}

// AsOracleSink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsOracleSink() (*OracleSink, bool) {
	return nil, false
}

// AsSQLDWSink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsSQLDWSink() (*SQLDWSink, bool) {
	return nil, false
}

// AsSQLSink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsSQLSink() (*SQLSink, bool) {
	return nil, false
}

// AsDocumentDbCollectionSink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsDocumentDbCollectionSink() (*DocumentDbCollectionSink, bool) {
	return nil, false
}

// AsFileSystemSink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsFileSystemSink() (*FileSystemSink, bool) {
	return nil, false
}

// AsBlobSink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsBlobSink() (*BlobSink, bool) {
	return nil, false
}

// AsAzureTableSink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsAzureTableSink() (*AzureTableSink, bool) {
	return nil, false
}

// AsAzureQueueSink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsAzureQueueSink() (*AzureQueueSink, bool) {
	return nil, false
}

// AsSapCloudForCustomerSink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsSapCloudForCustomerSink() (*SapCloudForCustomerSink, bool) {
	return nil, false
}

// AsCopySink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsCopySink() (*CopySink, bool) {
	return nil, false
}

// AsBasicCopySink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsBasicCopySink() (BasicCopySink, bool) {
	return &adlss, true
}

// UnmarshalJSON is the custom unmarshaler for AzureDataLakeStoreSink struct.
func (adlss *AzureDataLakeStoreSink) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "copyBehavior":
			if v != nil {
				var copyBehavior CopyBehaviorType
				err = json.Unmarshal(*v, &copyBehavior)
				if err != nil {
					return err
				}
				adlss.CopyBehavior = copyBehavior
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if adlss.AdditionalProperties == nil {
					adlss.AdditionalProperties = make(map[string]interface{})
				}
				adlss.AdditionalProperties[k] = additionalProperties
			}
		case "writeBatchSize":
			if v != nil {
				var writeBatchSize interface{}
				err = json.Unmarshal(*v, &writeBatchSize)
				if err != nil {
					return err
				}
				adlss.WriteBatchSize = writeBatchSize
			}
		case "writeBatchTimeout":
			if v != nil {
				var writeBatchTimeout interface{}
				err = json.Unmarshal(*v, &writeBatchTimeout)
				if err != nil {
					return err
				}
				adlss.WriteBatchTimeout = writeBatchTimeout
			}
		case "sinkRetryCount":
			if v != nil {
				var sinkRetryCount interface{}
				err = json.Unmarshal(*v, &sinkRetryCount)
				if err != nil {
					return err
				}
				adlss.SinkRetryCount = sinkRetryCount
			}
		case "sinkRetryWait":
			if v != nil {
				var sinkRetryWait interface{}
				err = json.Unmarshal(*v, &sinkRetryWait)
				if err != nil {
					return err
				}
				adlss.SinkRetryWait = sinkRetryWait
			}
		case "maxConcurrentConnections":
			if v != nil {
				var maxConcurrentConnections interface{}
				err = json.Unmarshal(*v, &maxConcurrentConnections)
				if err != nil {
					return err
				}
				adlss.MaxConcurrentConnections = maxConcurrentConnections
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicCopySink
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				adlss.Type = typeVar
			}
		}
	}

	return nil
}

// AzureDataLakeStoreSource a copy activity Azure Data Lake source.
type AzureDataLakeStoreSource struct {
	// Recursive - If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType boolean).
	Recursive interface{} `json:"recursive,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// SourceRetryCount - Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`
	// SourceRetryWait - Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
	// MaxConcurrentConnections - The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`
	// Type - Possible values include: 'TypeCopySource', 'TypeAmazonRedshiftSource', 'TypeGoogleAdWordsSource', 'TypeOracleServiceCloudSource', 'TypeDynamicsAXSource', 'TypeResponsysSource', 'TypeSalesforceMarketingCloudSource', 'TypeVerticaSource', 'TypeNetezzaSource', 'TypeZohoSource', 'TypeXeroSource', 'TypeSquareSource', 'TypeSparkSource', 'TypeShopifySource', 'TypeServiceNowSource', 'TypeQuickBooksSource', 'TypePrestoSource', 'TypePhoenixSource', 'TypePaypalSource', 'TypeMarketoSource', 'TypeMariaDBSource', 'TypeMagentoSource', 'TypeJiraSource', 'TypeImpalaSource', 'TypeHubspotSource', 'TypeHiveSource', 'TypeHBaseSource', 'TypeGreenplumSource', 'TypeGoogleBigQuerySource', 'TypeEloquaSource', 'TypeDrillSource', 'TypeCouchbaseSource', 'TypeConcurSource', 'TypeAzurePostgreSQLSource', 'TypeAmazonMWSSource', 'TypeHTTPSource', 'TypeAzureBlobFSSource', 'TypeAzureDataLakeStoreSource', 'TypeOffice365Source', 'TypeCosmosDbMongoDbAPISource', 'TypeMongoDbV2Source', 'TypeMongoDbSource', 'TypeCassandraSource', 'TypeWebSource', 'TypeOracleSource', 'TypeAzureDataExplorerSource', 'TypeAzureMySQLSource', 'TypeHdfsSource', 'TypeFileSystemSource', 'TypeSQLDWSource', 'TypeSQLSource', 'TypeRestSource', 'TypeSapOpenHubSource', 'TypeSapEccSource', 'TypeSapCloudForCustomerSource', 'TypeSalesforceSource', 'TypeRelationalSource', 'TypeDynamicsSource', 'TypeDocumentDbCollectionSource', 'TypeBlobSource', 'TypeAzureTableSource'
	Type TypeBasicCopySource `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) MarshalJSON() ([]byte, error) {
	adlss.Type = TypeAzureDataLakeStoreSource
	objectMap := make(map[string]interface{})
	if adlss.Recursive != nil {
		objectMap["recursive"] = adlss.Recursive
	}
	if adlss.SourceRetryCount != nil {
		objectMap["sourceRetryCount"] = adlss.SourceRetryCount
	}
	if adlss.SourceRetryWait != nil {
		objectMap["sourceRetryWait"] = adlss.SourceRetryWait
	}
	if adlss.MaxConcurrentConnections != nil {
		objectMap["maxConcurrentConnections"] = adlss.MaxConcurrentConnections
	}
	if adlss.Type != "" {
		objectMap["type"] = adlss.Type
	}
	for k, v := range adlss.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsAmazonRedshiftSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsAmazonRedshiftSource() (*AmazonRedshiftSource, bool) {
	return nil, false
}

// AsGoogleAdWordsSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsGoogleAdWordsSource() (*GoogleAdWordsSource, bool) {
	return nil, false
}

// AsOracleServiceCloudSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsOracleServiceCloudSource() (*OracleServiceCloudSource, bool) {
	return nil, false
}

// AsDynamicsAXSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsDynamicsAXSource() (*DynamicsAXSource, bool) {
	return nil, false
}

// AsResponsysSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsResponsysSource() (*ResponsysSource, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsSalesforceMarketingCloudSource() (*SalesforceMarketingCloudSource, bool) {
	return nil, false
}

// AsVerticaSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsVerticaSource() (*VerticaSource, bool) {
	return nil, false
}

// AsNetezzaSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsNetezzaSource() (*NetezzaSource, bool) {
	return nil, false
}

// AsZohoSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsZohoSource() (*ZohoSource, bool) {
	return nil, false
}

// AsXeroSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsXeroSource() (*XeroSource, bool) {
	return nil, false
}

// AsSquareSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsSquareSource() (*SquareSource, bool) {
	return nil, false
}

// AsSparkSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsSparkSource() (*SparkSource, bool) {
	return nil, false
}

// AsShopifySource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsShopifySource() (*ShopifySource, bool) {
	return nil, false
}

// AsServiceNowSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsServiceNowSource() (*ServiceNowSource, bool) {
	return nil, false
}

// AsQuickBooksSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsQuickBooksSource() (*QuickBooksSource, bool) {
	return nil, false
}

// AsPrestoSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsPrestoSource() (*PrestoSource, bool) {
	return nil, false
}

// AsPhoenixSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsPhoenixSource() (*PhoenixSource, bool) {
	return nil, false
}

// AsPaypalSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsPaypalSource() (*PaypalSource, bool) {
	return nil, false
}

// AsMarketoSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsMarketoSource() (*MarketoSource, bool) {
	return nil, false
}

// AsMariaDBSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsMariaDBSource() (*MariaDBSource, bool) {
	return nil, false
}

// AsMagentoSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsMagentoSource() (*MagentoSource, bool) {
	return nil, false
}

// AsJiraSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsJiraSource() (*JiraSource, bool) {
	return nil, false
}

// AsImpalaSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsImpalaSource() (*ImpalaSource, bool) {
	return nil, false
}

// AsHubspotSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsHubspotSource() (*HubspotSource, bool) {
	return nil, false
}

// AsHiveSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsHiveSource() (*HiveSource, bool) {
	return nil, false
}

// AsHBaseSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsHBaseSource() (*HBaseSource, bool) {
	return nil, false
}

// AsGreenplumSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsGreenplumSource() (*GreenplumSource, bool) {
	return nil, false
}

// AsGoogleBigQuerySource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsGoogleBigQuerySource() (*GoogleBigQuerySource, bool) {
	return nil, false
}

// AsEloquaSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsEloquaSource() (*EloquaSource, bool) {
	return nil, false
}

// AsDrillSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsDrillSource() (*DrillSource, bool) {
	return nil, false
}

// AsCouchbaseSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsCouchbaseSource() (*CouchbaseSource, bool) {
	return nil, false
}

// AsConcurSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsConcurSource() (*ConcurSource, bool) {
	return nil, false
}

// AsAzurePostgreSQLSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsAzurePostgreSQLSource() (*AzurePostgreSQLSource, bool) {
	return nil, false
}

// AsAmazonMWSSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsAmazonMWSSource() (*AmazonMWSSource, bool) {
	return nil, false
}

// AsHTTPSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsHTTPSource() (*HTTPSource, bool) {
	return nil, false
}

// AsAzureBlobFSSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsAzureBlobFSSource() (*AzureBlobFSSource, bool) {
	return nil, false
}

// AsAzureDataLakeStoreSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsAzureDataLakeStoreSource() (*AzureDataLakeStoreSource, bool) {
	return &adlss, true
}

// AsOffice365Source is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsOffice365Source() (*Office365Source, bool) {
	return nil, false
}

// AsCosmosDbMongoDbAPISource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsCosmosDbMongoDbAPISource() (*CosmosDbMongoDbAPISource, bool) {
	return nil, false
}

// AsMongoDbV2Source is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsMongoDbV2Source() (*MongoDbV2Source, bool) {
	return nil, false
}

// AsMongoDbSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsMongoDbSource() (*MongoDbSource, bool) {
	return nil, false
}

// AsCassandraSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsCassandraSource() (*CassandraSource, bool) {
	return nil, false
}

// AsWebSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsWebSource() (*WebSource, bool) {
	return nil, false
}

// AsOracleSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsOracleSource() (*OracleSource, bool) {
	return nil, false
}

// AsAzureDataExplorerSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsAzureDataExplorerSource() (*AzureDataExplorerSource, bool) {
	return nil, false
}

// AsAzureMySQLSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsAzureMySQLSource() (*AzureMySQLSource, bool) {
	return nil, false
}

// AsHdfsSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsHdfsSource() (*HdfsSource, bool) {
	return nil, false
}

// AsFileSystemSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsFileSystemSource() (*FileSystemSource, bool) {
	return nil, false
}

// AsSQLDWSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsSQLDWSource() (*SQLDWSource, bool) {
	return nil, false
}

// AsSQLSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsSQLSource() (*SQLSource, bool) {
	return nil, false
}

// AsRestSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsRestSource() (*RestSource, bool) {
	return nil, false
}

// AsSapOpenHubSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsSapOpenHubSource() (*SapOpenHubSource, bool) {
	return nil, false
}

// AsSapEccSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsSapEccSource() (*SapEccSource, bool) {
	return nil, false
}

// AsSapCloudForCustomerSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsSapCloudForCustomerSource() (*SapCloudForCustomerSource, bool) {
	return nil, false
}

// AsSalesforceSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsSalesforceSource() (*SalesforceSource, bool) {
	return nil, false
}

// AsRelationalSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsRelationalSource() (*RelationalSource, bool) {
	return nil, false
}

// AsDynamicsSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsDynamicsSource() (*DynamicsSource, bool) {
	return nil, false
}

// AsDocumentDbCollectionSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsDocumentDbCollectionSource() (*DocumentDbCollectionSource, bool) {
	return nil, false
}

// AsBlobSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsBlobSource() (*BlobSource, bool) {
	return nil, false
}

// AsAzureTableSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsAzureTableSource() (*AzureTableSource, bool) {
	return nil, false
}

// AsCopySource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsCopySource() (*CopySource, bool) {
	return nil, false
}

// AsBasicCopySource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsBasicCopySource() (BasicCopySource, bool) {
	return &adlss, true
}

// UnmarshalJSON is the custom unmarshaler for AzureDataLakeStoreSource struct.
func (adlss *AzureDataLakeStoreSource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "recursive":
			if v != nil {
				var recursive interface{}
				err = json.Unmarshal(*v, &recursive)
				if err != nil {
					return err
				}
				adlss.Recursive = recursive
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if adlss.AdditionalProperties == nil {
					adlss.AdditionalProperties = make(map[string]interface{})
				}
				adlss.AdditionalProperties[k] = additionalProperties
			}
		case "sourceRetryCount":
			if v != nil {
				var sourceRetryCount interface{}
				err = json.Unmarshal(*v, &sourceRetryCount)
				if err != nil {
					return err
				}
				adlss.SourceRetryCount = sourceRetryCount
			}
		case "sourceRetryWait":
			if v != nil {
				var sourceRetryWait interface{}
				err = json.Unmarshal(*v, &sourceRetryWait)
				if err != nil {
					return err
				}
				adlss.SourceRetryWait = sourceRetryWait
			}
		case "maxConcurrentConnections":
			if v != nil {
				var maxConcurrentConnections interface{}
				err = json.Unmarshal(*v, &maxConcurrentConnections)
				if err != nil {
					return err
				}
				adlss.MaxConcurrentConnections = maxConcurrentConnections
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicCopySource
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				adlss.Type = typeVar
			}
		}
	}

	return nil
}

// AzureFunctionActivity azure Function activity.
type AzureFunctionActivity struct {
	// AzureFunctionActivityTypeProperties - Azure Function activity properties.
	*AzureFunctionActivityTypeProperties `json:"typeProperties,omitempty"`
	// LinkedServiceName - Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
	// Policy - Activity policy.
	Policy *ActivityPolicy `json:"policy,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Name - Activity name.
	Name *string `json:"name,omitempty"`
	// Description - Activity description.
	Description *string `json:"description,omitempty"`
	// DependsOn - Activity depends on condition.
	DependsOn *[]ActivityDependency `json:"dependsOn,omitempty"`
	// UserProperties - Activity user properties.
	UserProperties *[]UserProperty `json:"userProperties,omitempty"`
	// Type - Possible values include: 'TypeActivity', 'TypeAzureFunctionActivity', 'TypeDatabricksSparkPython', 'TypeDatabricksSparkJar', 'TypeDatabricksNotebook', 'TypeDataLakeAnalyticsUSQL', 'TypeAzureMLUpdateResource', 'TypeAzureMLBatchExecution', 'TypeGetMetadata', 'TypeWebActivity', 'TypeLookup', 'TypeDelete', 'TypeSQLServerStoredProcedure', 'TypeCustom', 'TypeExecuteSSISPackage', 'TypeHDInsightSpark', 'TypeHDInsightStreaming', 'TypeHDInsightMapReduce', 'TypeHDInsightPig', 'TypeHDInsightHive', 'TypeCopy', 'TypeExecution', 'TypeWebHook', 'TypeAppendVariable', 'TypeSetVariable', 'TypeFilter', 'TypeValidation', 'TypeUntil', 'TypeWait', 'TypeForEach', 'TypeIfCondition', 'TypeExecutePipeline', 'TypeContainer'
	Type TypeBasicActivity `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureFunctionActivity.
func (afa AzureFunctionActivity) MarshalJSON() ([]byte, error) {
	afa.Type = TypeAzureFunctionActivity
	objectMap := make(map[string]interface{})
	if afa.AzureFunctionActivityTypeProperties != nil {
		objectMap["typeProperties"] = afa.AzureFunctionActivityTypeProperties
	}
	if afa.LinkedServiceName != nil {
		objectMap["linkedServiceName"] = afa.LinkedServiceName
	}
	if afa.Policy != nil {
		objectMap["policy"] = afa.Policy
	}
	if afa.Name != nil {
		objectMap["name"] = afa.Name
	}
	if afa.Description != nil {
		objectMap["description"] = afa.Description
	}
	if afa.DependsOn != nil {
		objectMap["dependsOn"] = afa.DependsOn
	}
	if afa.UserProperties != nil {
		objectMap["userProperties"] = afa.UserProperties
	}
	if afa.Type != "" {
		objectMap["type"] = afa.Type
	}
	for k, v := range afa.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsAzureFunctionActivity is the BasicActivity implementation for AzureFunctionActivity.
func (afa AzureFunctionActivity) AsAzureFunctionActivity() (*AzureFunctionActivity, bool) {
	return &afa, true
}

// AsDatabricksSparkPythonActivity is the BasicActivity implementation for AzureFunctionActivity.
func (afa AzureFunctionActivity) AsDatabricksSparkPythonActivity() (*DatabricksSparkPythonActivity, bool) {
	return nil, false
}

// AsDatabricksSparkJarActivity is the BasicActivity implementation for AzureFunctionActivity.
func (afa AzureFunctionActivity) AsDatabricksSparkJarActivity() (*DatabricksSparkJarActivity, bool) {
	return nil, false
}

// AsDatabricksNotebookActivity is the BasicActivity implementation for AzureFunctionActivity.
func (afa AzureFunctionActivity) AsDatabricksNotebookActivity() (*DatabricksNotebookActivity, bool) {
	return nil, false
}

// AsDataLakeAnalyticsUSQLActivity is the BasicActivity implementation for AzureFunctionActivity.
func (afa AzureFunctionActivity) AsDataLakeAnalyticsUSQLActivity() (*DataLakeAnalyticsUSQLActivity, bool) {
	return nil, false
}

// AsAzureMLUpdateResourceActivity is the BasicActivity implementation for AzureFunctionActivity.
func (afa AzureFunctionActivity) AsAzureMLUpdateResourceActivity() (*AzureMLUpdateResourceActivity, bool) {
	return nil, false
}

// AsAzureMLBatchExecutionActivity is the BasicActivity implementation for AzureFunctionActivity.
func (afa AzureFunctionActivity) AsAzureMLBatchExecutionActivity() (*AzureMLBatchExecutionActivity, bool) {
	return nil, false
}

// AsGetMetadataActivity is the BasicActivity implementation for AzureFunctionActivity.
func (afa AzureFunctionActivity) AsGetMetadataActivity() (*GetMetadataActivity, bool) {
	return nil, false
}

// AsWebActivity is the BasicActivity implementation for AzureFunctionActivity.
func (afa AzureFunctionActivity) AsWebActivity() (*WebActivity, bool) {
	return nil, false
}

// AsLookupActivity is the BasicActivity implementation for AzureFunctionActivity.
func (afa AzureFunctionActivity) AsLookupActivity() (*LookupActivity, bool) {
	return nil, false
}

// AsDeleteActivity is the BasicActivity implementation for AzureFunctionActivity.
func (afa AzureFunctionActivity) AsDeleteActivity() (*DeleteActivity, bool) {
	return nil, false
}

// AsSQLServerStoredProcedureActivity is the BasicActivity implementation for AzureFunctionActivity.
func (afa AzureFunctionActivity) AsSQLServerStoredProcedureActivity() (*SQLServerStoredProcedureActivity, bool) {
	return nil, false
}

// AsCustomActivity is the BasicActivity implementation for AzureFunctionActivity.
func (afa AzureFunctionActivity) AsCustomActivity() (*CustomActivity, bool) {
	return nil, false
}

// AsExecuteSSISPackageActivity is the BasicActivity implementation for AzureFunctionActivity.
func (afa AzureFunctionActivity) AsExecuteSSISPackageActivity() (*ExecuteSSISPackageActivity, bool) {
	return nil, false
}

// AsHDInsightSparkActivity is the BasicActivity implementation for AzureFunctionActivity.
func (afa AzureFunctionActivity) AsHDInsightSparkActivity() (*HDInsightSparkActivity, bool) {
	return nil, false
}

// AsHDInsightStreamingActivity is the BasicActivity implementation for AzureFunctionActivity.
func (afa AzureFunctionActivity) AsHDInsightStreamingActivity() (*HDInsightStreamingActivity, bool) {
	return nil, false
}

// AsHDInsightMapReduceActivity is the BasicActivity implementation for AzureFunctionActivity.
func (afa AzureFunctionActivity) AsHDInsightMapReduceActivity() (*HDInsightMapReduceActivity, bool) {
	return nil, false
}

// AsHDInsightPigActivity is the BasicActivity implementation for AzureFunctionActivity.
func (afa AzureFunctionActivity) AsHDInsightPigActivity() (*HDInsightPigActivity, bool) {
	return nil, false
}

// AsHDInsightHiveActivity is the BasicActivity implementation for AzureFunctionActivity.
func (afa AzureFunctionActivity) AsHDInsightHiveActivity() (*HDInsightHiveActivity, bool) {
	return nil, false
}

// AsCopyActivity is the BasicActivity implementation for AzureFunctionActivity.
func (afa AzureFunctionActivity) AsCopyActivity() (*CopyActivity, bool) {
	return nil, false
}

// AsExecutionActivity is the BasicActivity implementation for AzureFunctionActivity.
func (afa AzureFunctionActivity) AsExecutionActivity() (*ExecutionActivity, bool) {
	return nil, false
}

// AsBasicExecutionActivity is the BasicActivity implementation for AzureFunctionActivity.
func (afa AzureFunctionActivity) AsBasicExecutionActivity() (BasicExecutionActivity, bool) {
	return &afa, true
}

// AsWebHookActivity is the BasicActivity implementation for AzureFunctionActivity.
func (afa AzureFunctionActivity) AsWebHookActivity() (*WebHookActivity, bool) {
	return nil, false
}

// AsAppendVariableActivity is the BasicActivity implementation for AzureFunctionActivity.
func (afa AzureFunctionActivity) AsAppendVariableActivity() (*AppendVariableActivity, bool) {
	return nil, false
}

// AsSetVariableActivity is the BasicActivity implementation for AzureFunctionActivity.
func (afa AzureFunctionActivity) AsSetVariableActivity() (*SetVariableActivity, bool) {
	return nil, false
}

// AsFilterActivity is the BasicActivity implementation for AzureFunctionActivity.
func (afa AzureFunctionActivity) AsFilterActivity() (*FilterActivity, bool) {
	return nil, false
}

// AsValidationActivity is the BasicActivity implementation for AzureFunctionActivity.
func (afa AzureFunctionActivity) AsValidationActivity() (*ValidationActivity, bool) {
	return nil, false
}

// AsUntilActivity is the BasicActivity implementation for AzureFunctionActivity.
func (afa AzureFunctionActivity) AsUntilActivity() (*UntilActivity, bool) {
	return nil, false
}

// AsWaitActivity is the BasicActivity implementation for AzureFunctionActivity.
func (afa AzureFunctionActivity) AsWaitActivity() (*WaitActivity, bool) {
	return nil, false
}

// AsForEachActivity is the BasicActivity implementation for AzureFunctionActivity.
func (afa AzureFunctionActivity) AsForEachActivity() (*ForEachActivity, bool) {
	return nil, false
}

// AsIfConditionActivity is the BasicActivity implementation for AzureFunctionActivity.
func (afa AzureFunctionActivity) AsIfConditionActivity() (*IfConditionActivity, bool) {
	return nil, false
}

// AsExecutePipelineActivity is the BasicActivity implementation for AzureFunctionActivity.
func (afa AzureFunctionActivity) AsExecutePipelineActivity() (*ExecutePipelineActivity, bool) {
	return nil, false
}

// AsControlActivity is the BasicActivity implementation for AzureFunctionActivity.
func (afa AzureFunctionActivity) AsControlActivity() (*ControlActivity, bool) {
	return nil, false
}

// AsBasicControlActivity is the BasicActivity implementation for AzureFunctionActivity.
func (afa AzureFunctionActivity) AsBasicControlActivity() (BasicControlActivity, bool) {
	return nil, false
}

// AsActivity is the BasicActivity implementation for AzureFunctionActivity.
func (afa AzureFunctionActivity) AsActivity() (*Activity, bool) {
	return nil, false
}

// AsBasicActivity is the BasicActivity implementation for AzureFunctionActivity.
func (afa AzureFunctionActivity) AsBasicActivity() (BasicActivity, bool) {
	return &afa, true
}

// UnmarshalJSON is the custom unmarshaler for AzureFunctionActivity struct.
func (afa *AzureFunctionActivity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var azureFunctionActivityTypeProperties AzureFunctionActivityTypeProperties
				err = json.Unmarshal(*v, &azureFunctionActivityTypeProperties)
				if err != nil {
					return err
				}
				afa.AzureFunctionActivityTypeProperties = &azureFunctionActivityTypeProperties
			}
		case "linkedServiceName":
			if v != nil {
				var linkedServiceName LinkedServiceReference
				err = json.Unmarshal(*v, &linkedServiceName)
				if err != nil {
					return err
				}
				afa.LinkedServiceName = &linkedServiceName
			}
		case "policy":
			if v != nil {
				var policy ActivityPolicy
				err = json.Unmarshal(*v, &policy)
				if err != nil {
					return err
				}
				afa.Policy = &policy
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if afa.AdditionalProperties == nil {
					afa.AdditionalProperties = make(map[string]interface{})
				}
				afa.AdditionalProperties[k] = additionalProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				afa.Name = &name
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				afa.Description = &description
			}
		case "dependsOn":
			if v != nil {
				var dependsOn []ActivityDependency
				err = json.Unmarshal(*v, &dependsOn)
				if err != nil {
					return err
				}
				afa.DependsOn = &dependsOn
			}
		case "userProperties":
			if v != nil {
				var userProperties []UserProperty
				err = json.Unmarshal(*v, &userProperties)
				if err != nil {
					return err
				}
				afa.UserProperties = &userProperties
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicActivity
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				afa.Type = typeVar
			}
		}
	}

	return nil
}

// AzureFunctionActivityTypeProperties azure Function activity type properties.
type AzureFunctionActivityTypeProperties struct {
	// Method - Rest API method for target endpoint. Possible values include: 'GET', 'POST', 'PUT', 'DELETE', 'OPTIONS', 'HEAD', 'TRACE'
	Method AzureFunctionActivityMethod `json:"method,omitempty"`
	// FunctionName - Name of the Function that the Azure Function Activity will call. Type: string (or Expression with resultType string)
	FunctionName interface{} `json:"functionName,omitempty"`
	// Headers - Represents the headers that will be sent to the request. For example, to set the language and type on a request: "headers" : { "Accept-Language": "en-us", "Content-Type": "application/json" }. Type: string (or Expression with resultType string).
	Headers interface{} `json:"headers,omitempty"`
	// Body - Represents the payload that will be sent to the endpoint. Required for POST/PUT method, not allowed for GET method Type: string (or Expression with resultType string).
	Body interface{} `json:"body,omitempty"`
}

// AzureFunctionLinkedService azure Function linked service.
type AzureFunctionLinkedService struct {
	// AzureFunctionLinkedServiceTypeProperties - Azure Function linked service properties.
	*AzureFunctionLinkedServiceTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Parameters - Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the linked service.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Type - Possible values include: 'TypeLinkedService', 'TypeAzureFunction', 'TypeAzureDataExplorer', 'TypeGoogleAdWords', 'TypeOracleServiceCloud', 'TypeDynamicsAX', 'TypeResponsys', 'TypeAzureDatabricks', 'TypeAzureDataLakeAnalytics', 'TypeHDInsightOnDemand', 'TypeSalesforceMarketingCloud', 'TypeNetezza', 'TypeVertica', 'TypeZoho', 'TypeXero', 'TypeSquare', 'TypeSpark', 'TypeShopify', 'TypeServiceNow', 'TypeQuickBooks', 'TypePresto', 'TypePhoenix', 'TypePaypal', 'TypeMarketo', 'TypeMariaDB', 'TypeMagento', 'TypeJira', 'TypeImpala', 'TypeHubspot', 'TypeHive', 'TypeHBase', 'TypeGreenplum', 'TypeGoogleBigQuery', 'TypeEloqua', 'TypeDrill', 'TypeCouchbase', 'TypeConcur', 'TypeAzurePostgreSQL', 'TypeAmazonMWS', 'TypeSapHana', 'TypeSapBW', 'TypeSftp', 'TypeFtpServer', 'TypeHTTPServer', 'TypeAzureSearch', 'TypeCustomDataSource', 'TypeAmazonRedshift', 'TypeAmazonS3', 'TypeRestService', 'TypeSapOpenHub', 'TypeSapEcc', 'TypeSapCloudForCustomer', 'TypeSalesforce', 'TypeOffice365', 'TypeAzureBlobFS', 'TypeAzureDataLakeStore', 'TypeCosmosDbMongoDbAPI', 'TypeMongoDbV2', 'TypeMongoDb', 'TypeCassandra', 'TypeWeb', 'TypeOData', 'TypeHdfs', 'TypeOdbc', 'TypeAzureML', 'TypeTeradata', 'TypeDb2', 'TypeSybase', 'TypePostgreSQL', 'TypeMySQL', 'TypeAzureMySQL', 'TypeOracle', 'TypeFileServer', 'TypeHDInsight', 'TypeDynamics', 'TypeCosmosDb', 'TypeAzureKeyVault', 'TypeAzureBatch', 'TypeAzureSQLDatabase', 'TypeSQLServer', 'TypeAzureSQLDW', 'TypeAzureTableStorage', 'TypeAzureBlobStorage', 'TypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) MarshalJSON() ([]byte, error) {
	afls.Type = TypeAzureFunction
	objectMap := make(map[string]interface{})
	if afls.AzureFunctionLinkedServiceTypeProperties != nil {
		objectMap["typeProperties"] = afls.AzureFunctionLinkedServiceTypeProperties
	}
	if afls.ConnectVia != nil {
		objectMap["connectVia"] = afls.ConnectVia
	}
	if afls.Description != nil {
		objectMap["description"] = afls.Description
	}
	if afls.Parameters != nil {
		objectMap["parameters"] = afls.Parameters
	}
	if afls.Annotations != nil {
		objectMap["annotations"] = afls.Annotations
	}
	if afls.Type != "" {
		objectMap["type"] = afls.Type
	}
	for k, v := range afls.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsAzureFunctionLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsAzureFunctionLinkedService() (*AzureFunctionLinkedService, bool) {
	return &afls, true
}

// AsAzureDataExplorerLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsAzureDataExplorerLinkedService() (*AzureDataExplorerLinkedService, bool) {
	return nil, false
}

// AsGoogleAdWordsLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsGoogleAdWordsLinkedService() (*GoogleAdWordsLinkedService, bool) {
	return nil, false
}

// AsOracleServiceCloudLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsOracleServiceCloudLinkedService() (*OracleServiceCloudLinkedService, bool) {
	return nil, false
}

// AsDynamicsAXLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsDynamicsAXLinkedService() (*DynamicsAXLinkedService, bool) {
	return nil, false
}

// AsResponsysLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsResponsysLinkedService() (*ResponsysLinkedService, bool) {
	return nil, false
}

// AsAzureDatabricksLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsAzureDatabricksLinkedService() (*AzureDatabricksLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return nil, false
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsSalesforceMarketingCloudLinkedService() (*SalesforceMarketingCloudLinkedService, bool) {
	return nil, false
}

// AsNetezzaLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsNetezzaLinkedService() (*NetezzaLinkedService, bool) {
	return nil, false
}

// AsVerticaLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsVerticaLinkedService() (*VerticaLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return nil, false
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return nil, false
}

// AsConcurLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return nil, false
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return nil, false
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return nil, false
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return nil, false
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return nil, false
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return nil, false
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return nil, false
}

// AsRestServiceLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsRestServiceLinkedService() (*RestServiceLinkedService, bool) {
	return nil, false
}

// AsSapOpenHubLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsSapOpenHubLinkedService() (*SapOpenHubLinkedService, bool) {
	return nil, false
}

// AsSapEccLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsSapEccLinkedService() (*SapEccLinkedService, bool) {
	return nil, false
}

// AsSapCloudForCustomerLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsSapCloudForCustomerLinkedService() (*SapCloudForCustomerLinkedService, bool) {
	return nil, false
}

// AsSalesforceLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsSalesforceLinkedService() (*SalesforceLinkedService, bool) {
	return nil, false
}

// AsOffice365LinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsOffice365LinkedService() (*Office365LinkedService, bool) {
	return nil, false
}

// AsAzureBlobFSLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsAzureBlobFSLinkedService() (*AzureBlobFSLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsAzureDataLakeStoreLinkedService() (*AzureDataLakeStoreLinkedService, bool) {
	return nil, false
}

// AsCosmosDbMongoDbAPILinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsCosmosDbMongoDbAPILinkedService() (*CosmosDbMongoDbAPILinkedService, bool) {
	return nil, false
}

// AsMongoDbV2LinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsMongoDbV2LinkedService() (*MongoDbV2LinkedService, bool) {
	return nil, false
}

// AsMongoDbLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsMongoDbLinkedService() (*MongoDbLinkedService, bool) {
	return nil, false
}

// AsCassandraLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsCassandraLinkedService() (*CassandraLinkedService, bool) {
	return nil, false
}

// AsWebLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsWebLinkedService() (*WebLinkedService, bool) {
	return nil, false
}

// AsODataLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsODataLinkedService() (*ODataLinkedService, bool) {
	return nil, false
}

// AsHdfsLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsHdfsLinkedService() (*HdfsLinkedService, bool) {
	return nil, false
}

// AsOdbcLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsOdbcLinkedService() (*OdbcLinkedService, bool) {
	return nil, false
}

// AsAzureMLLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsAzureMLLinkedService() (*AzureMLLinkedService, bool) {
	return nil, false
}

// AsTeradataLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsTeradataLinkedService() (*TeradataLinkedService, bool) {
	return nil, false
}

// AsDb2LinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsDb2LinkedService() (*Db2LinkedService, bool) {
	return nil, false
}

// AsSybaseLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsSybaseLinkedService() (*SybaseLinkedService, bool) {
	return nil, false
}

// AsPostgreSQLLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsPostgreSQLLinkedService() (*PostgreSQLLinkedService, bool) {
	return nil, false
}

// AsMySQLLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsMySQLLinkedService() (*MySQLLinkedService, bool) {
	return nil, false
}

// AsAzureMySQLLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsAzureMySQLLinkedService() (*AzureMySQLLinkedService, bool) {
	return nil, false
}

// AsOracleLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsOracleLinkedService() (*OracleLinkedService, bool) {
	return nil, false
}

// AsFileServerLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsFileServerLinkedService() (*FileServerLinkedService, bool) {
	return nil, false
}

// AsHDInsightLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsHDInsightLinkedService() (*HDInsightLinkedService, bool) {
	return nil, false
}

// AsDynamicsLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsDynamicsLinkedService() (*DynamicsLinkedService, bool) {
	return nil, false
}

// AsCosmosDbLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsCosmosDbLinkedService() (*CosmosDbLinkedService, bool) {
	return nil, false
}

// AsAzureKeyVaultLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsAzureKeyVaultLinkedService() (*AzureKeyVaultLinkedService, bool) {
	return nil, false
}

// AsAzureBatchLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsAzureBatchLinkedService() (*AzureBatchLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDatabaseLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsAzureSQLDatabaseLinkedService() (*AzureSQLDatabaseLinkedService, bool) {
	return nil, false
}

// AsSQLServerLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsSQLServerLinkedService() (*SQLServerLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDWLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsAzureSQLDWLinkedService() (*AzureSQLDWLinkedService, bool) {
	return nil, false
}

// AsAzureTableStorageLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsAzureTableStorageLinkedService() (*AzureTableStorageLinkedService, bool) {
	return nil, false
}

// AsAzureBlobStorageLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsAzureBlobStorageLinkedService() (*AzureBlobStorageLinkedService, bool) {
	return nil, false
}

// AsAzureStorageLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsAzureStorageLinkedService() (*AzureStorageLinkedService, bool) {
	return nil, false
}

// AsLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsLinkedService() (*LinkedService, bool) {
	return nil, false
}

// AsBasicLinkedService is the BasicLinkedService implementation for AzureFunctionLinkedService.
func (afls AzureFunctionLinkedService) AsBasicLinkedService() (BasicLinkedService, bool) {
	return &afls, true
}

// UnmarshalJSON is the custom unmarshaler for AzureFunctionLinkedService struct.
func (afls *AzureFunctionLinkedService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var azureFunctionLinkedServiceTypeProperties AzureFunctionLinkedServiceTypeProperties
				err = json.Unmarshal(*v, &azureFunctionLinkedServiceTypeProperties)
				if err != nil {
					return err
				}
				afls.AzureFunctionLinkedServiceTypeProperties = &azureFunctionLinkedServiceTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if afls.AdditionalProperties == nil {
					afls.AdditionalProperties = make(map[string]interface{})
				}
				afls.AdditionalProperties[k] = additionalProperties
			}
		case "connectVia":
			if v != nil {
				var connectVia IntegrationRuntimeReference
				err = json.Unmarshal(*v, &connectVia)
				if err != nil {
					return err
				}
				afls.ConnectVia = &connectVia
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				afls.Description = &description
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				afls.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				afls.Annotations = &annotations
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicLinkedService
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				afls.Type = typeVar
			}
		}
	}

	return nil
}

// AzureFunctionLinkedServiceTypeProperties azure Function linked service properties.
type AzureFunctionLinkedServiceTypeProperties struct {
	// FunctionAppURL - The endpoint of the Azure Function App. URL will be in the format https://<accountName>.azurewebsites.net.
	FunctionAppURL interface{} `json:"functionAppUrl,omitempty"`
	// FunctionKey - Function or Host key for Azure Function App.
	FunctionKey BasicSecretBase `json:"functionKey,omitempty"`
	// EncryptedCredential - The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AzureFunctionLinkedServiceTypeProperties struct.
func (aflstp *AzureFunctionLinkedServiceTypeProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "functionAppUrl":
			if v != nil {
				var functionAppURL interface{}
				err = json.Unmarshal(*v, &functionAppURL)
				if err != nil {
					return err
				}
				aflstp.FunctionAppURL = functionAppURL
			}
		case "functionKey":
			if v != nil {
				functionKey, err := unmarshalBasicSecretBase(*v)
				if err != nil {
					return err
				}
				aflstp.FunctionKey = functionKey
			}
		case "encryptedCredential":
			if v != nil {
				var encryptedCredential interface{}
				err = json.Unmarshal(*v, &encryptedCredential)
				if err != nil {
					return err
				}
				aflstp.EncryptedCredential = encryptedCredential
			}
		}
	}

	return nil
}

// AzureKeyVaultLinkedService azure Key Vault linked service.
type AzureKeyVaultLinkedService struct {
	// AzureKeyVaultLinkedServiceTypeProperties - Azure Key Vault linked service properties.
	*AzureKeyVaultLinkedServiceTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Parameters - Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the linked service.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Type - Possible values include: 'TypeLinkedService', 'TypeAzureFunction', 'TypeAzureDataExplorer', 'TypeGoogleAdWords', 'TypeOracleServiceCloud', 'TypeDynamicsAX', 'TypeResponsys', 'TypeAzureDatabricks', 'TypeAzureDataLakeAnalytics', 'TypeHDInsightOnDemand', 'TypeSalesforceMarketingCloud', 'TypeNetezza', 'TypeVertica', 'TypeZoho', 'TypeXero', 'TypeSquare', 'TypeSpark', 'TypeShopify', 'TypeServiceNow', 'TypeQuickBooks', 'TypePresto', 'TypePhoenix', 'TypePaypal', 'TypeMarketo', 'TypeMariaDB', 'TypeMagento', 'TypeJira', 'TypeImpala', 'TypeHubspot', 'TypeHive', 'TypeHBase', 'TypeGreenplum', 'TypeGoogleBigQuery', 'TypeEloqua', 'TypeDrill', 'TypeCouchbase', 'TypeConcur', 'TypeAzurePostgreSQL', 'TypeAmazonMWS', 'TypeSapHana', 'TypeSapBW', 'TypeSftp', 'TypeFtpServer', 'TypeHTTPServer', 'TypeAzureSearch', 'TypeCustomDataSource', 'TypeAmazonRedshift', 'TypeAmazonS3', 'TypeRestService', 'TypeSapOpenHub', 'TypeSapEcc', 'TypeSapCloudForCustomer', 'TypeSalesforce', 'TypeOffice365', 'TypeAzureBlobFS', 'TypeAzureDataLakeStore', 'TypeCosmosDbMongoDbAPI', 'TypeMongoDbV2', 'TypeMongoDb', 'TypeCassandra', 'TypeWeb', 'TypeOData', 'TypeHdfs', 'TypeOdbc', 'TypeAzureML', 'TypeTeradata', 'TypeDb2', 'TypeSybase', 'TypePostgreSQL', 'TypeMySQL', 'TypeAzureMySQL', 'TypeOracle', 'TypeFileServer', 'TypeHDInsight', 'TypeDynamics', 'TypeCosmosDb', 'TypeAzureKeyVault', 'TypeAzureBatch', 'TypeAzureSQLDatabase', 'TypeSQLServer', 'TypeAzureSQLDW', 'TypeAzureTableStorage', 'TypeAzureBlobStorage', 'TypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) MarshalJSON() ([]byte, error) {
	akvls.Type = TypeAzureKeyVault
	objectMap := make(map[string]interface{})
	if akvls.AzureKeyVaultLinkedServiceTypeProperties != nil {
		objectMap["typeProperties"] = akvls.AzureKeyVaultLinkedServiceTypeProperties
	}
	if akvls.ConnectVia != nil {
		objectMap["connectVia"] = akvls.ConnectVia
	}
	if akvls.Description != nil {
		objectMap["description"] = akvls.Description
	}
	if akvls.Parameters != nil {
		objectMap["parameters"] = akvls.Parameters
	}
	if akvls.Annotations != nil {
		objectMap["annotations"] = akvls.Annotations
	}
	if akvls.Type != "" {
		objectMap["type"] = akvls.Type
	}
	for k, v := range akvls.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsAzureFunctionLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsAzureFunctionLinkedService() (*AzureFunctionLinkedService, bool) {
	return nil, false
}

// AsAzureDataExplorerLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsAzureDataExplorerLinkedService() (*AzureDataExplorerLinkedService, bool) {
	return nil, false
}

// AsGoogleAdWordsLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsGoogleAdWordsLinkedService() (*GoogleAdWordsLinkedService, bool) {
	return nil, false
}

// AsOracleServiceCloudLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsOracleServiceCloudLinkedService() (*OracleServiceCloudLinkedService, bool) {
	return nil, false
}

// AsDynamicsAXLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsDynamicsAXLinkedService() (*DynamicsAXLinkedService, bool) {
	return nil, false
}

// AsResponsysLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsResponsysLinkedService() (*ResponsysLinkedService, bool) {
	return nil, false
}

// AsAzureDatabricksLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsAzureDatabricksLinkedService() (*AzureDatabricksLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return nil, false
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsSalesforceMarketingCloudLinkedService() (*SalesforceMarketingCloudLinkedService, bool) {
	return nil, false
}

// AsNetezzaLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsNetezzaLinkedService() (*NetezzaLinkedService, bool) {
	return nil, false
}

// AsVerticaLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsVerticaLinkedService() (*VerticaLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return nil, false
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return nil, false
}

// AsConcurLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return nil, false
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return nil, false
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return nil, false
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return nil, false
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return nil, false
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return nil, false
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return nil, false
}

// AsRestServiceLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsRestServiceLinkedService() (*RestServiceLinkedService, bool) {
	return nil, false
}

// AsSapOpenHubLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsSapOpenHubLinkedService() (*SapOpenHubLinkedService, bool) {
	return nil, false
}

// AsSapEccLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsSapEccLinkedService() (*SapEccLinkedService, bool) {
	return nil, false
}

// AsSapCloudForCustomerLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsSapCloudForCustomerLinkedService() (*SapCloudForCustomerLinkedService, bool) {
	return nil, false
}

// AsSalesforceLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsSalesforceLinkedService() (*SalesforceLinkedService, bool) {
	return nil, false
}

// AsOffice365LinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsOffice365LinkedService() (*Office365LinkedService, bool) {
	return nil, false
}

// AsAzureBlobFSLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsAzureBlobFSLinkedService() (*AzureBlobFSLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsAzureDataLakeStoreLinkedService() (*AzureDataLakeStoreLinkedService, bool) {
	return nil, false
}

// AsCosmosDbMongoDbAPILinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsCosmosDbMongoDbAPILinkedService() (*CosmosDbMongoDbAPILinkedService, bool) {
	return nil, false
}

// AsMongoDbV2LinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsMongoDbV2LinkedService() (*MongoDbV2LinkedService, bool) {
	return nil, false
}

// AsMongoDbLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsMongoDbLinkedService() (*MongoDbLinkedService, bool) {
	return nil, false
}

// AsCassandraLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsCassandraLinkedService() (*CassandraLinkedService, bool) {
	return nil, false
}

// AsWebLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsWebLinkedService() (*WebLinkedService, bool) {
	return nil, false
}

// AsODataLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsODataLinkedService() (*ODataLinkedService, bool) {
	return nil, false
}

// AsHdfsLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsHdfsLinkedService() (*HdfsLinkedService, bool) {
	return nil, false
}

// AsOdbcLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsOdbcLinkedService() (*OdbcLinkedService, bool) {
	return nil, false
}

// AsAzureMLLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsAzureMLLinkedService() (*AzureMLLinkedService, bool) {
	return nil, false
}

// AsTeradataLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsTeradataLinkedService() (*TeradataLinkedService, bool) {
	return nil, false
}

// AsDb2LinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsDb2LinkedService() (*Db2LinkedService, bool) {
	return nil, false
}

// AsSybaseLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsSybaseLinkedService() (*SybaseLinkedService, bool) {
	return nil, false
}

// AsPostgreSQLLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsPostgreSQLLinkedService() (*PostgreSQLLinkedService, bool) {
	return nil, false
}

// AsMySQLLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsMySQLLinkedService() (*MySQLLinkedService, bool) {
	return nil, false
}

// AsAzureMySQLLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsAzureMySQLLinkedService() (*AzureMySQLLinkedService, bool) {
	return nil, false
}

// AsOracleLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsOracleLinkedService() (*OracleLinkedService, bool) {
	return nil, false
}

// AsFileServerLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsFileServerLinkedService() (*FileServerLinkedService, bool) {
	return nil, false
}

// AsHDInsightLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsHDInsightLinkedService() (*HDInsightLinkedService, bool) {
	return nil, false
}

// AsDynamicsLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsDynamicsLinkedService() (*DynamicsLinkedService, bool) {
	return nil, false
}

// AsCosmosDbLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsCosmosDbLinkedService() (*CosmosDbLinkedService, bool) {
	return nil, false
}

// AsAzureKeyVaultLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsAzureKeyVaultLinkedService() (*AzureKeyVaultLinkedService, bool) {
	return &akvls, true
}

// AsAzureBatchLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsAzureBatchLinkedService() (*AzureBatchLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDatabaseLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsAzureSQLDatabaseLinkedService() (*AzureSQLDatabaseLinkedService, bool) {
	return nil, false
}

// AsSQLServerLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsSQLServerLinkedService() (*SQLServerLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDWLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsAzureSQLDWLinkedService() (*AzureSQLDWLinkedService, bool) {
	return nil, false
}

// AsAzureTableStorageLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsAzureTableStorageLinkedService() (*AzureTableStorageLinkedService, bool) {
	return nil, false
}

// AsAzureBlobStorageLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsAzureBlobStorageLinkedService() (*AzureBlobStorageLinkedService, bool) {
	return nil, false
}

// AsAzureStorageLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsAzureStorageLinkedService() (*AzureStorageLinkedService, bool) {
	return nil, false
}

// AsLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsLinkedService() (*LinkedService, bool) {
	return nil, false
}

// AsBasicLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsBasicLinkedService() (BasicLinkedService, bool) {
	return &akvls, true
}

// UnmarshalJSON is the custom unmarshaler for AzureKeyVaultLinkedService struct.
func (akvls *AzureKeyVaultLinkedService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var azureKeyVaultLinkedServiceTypeProperties AzureKeyVaultLinkedServiceTypeProperties
				err = json.Unmarshal(*v, &azureKeyVaultLinkedServiceTypeProperties)
				if err != nil {
					return err
				}
				akvls.AzureKeyVaultLinkedServiceTypeProperties = &azureKeyVaultLinkedServiceTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if akvls.AdditionalProperties == nil {
					akvls.AdditionalProperties = make(map[string]interface{})
				}
				akvls.AdditionalProperties[k] = additionalProperties
			}
		case "connectVia":
			if v != nil {
				var connectVia IntegrationRuntimeReference
				err = json.Unmarshal(*v, &connectVia)
				if err != nil {
					return err
				}
				akvls.ConnectVia = &connectVia
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				akvls.Description = &description
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				akvls.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				akvls.Annotations = &annotations
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicLinkedService
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				akvls.Type = typeVar
			}
		}
	}

	return nil
}

// AzureKeyVaultLinkedServiceTypeProperties azure Key Vault linked service properties.
type AzureKeyVaultLinkedServiceTypeProperties struct {
	// BaseURL - The base URL of the Azure Key Vault. e.g. https://myakv.vault.azure.net Type: string (or Expression with resultType string).
	BaseURL interface{} `json:"baseUrl,omitempty"`
}

// AzureKeyVaultSecretReference azure Key Vault secret reference.
type AzureKeyVaultSecretReference struct {
	// Store - The Azure Key Vault linked service reference.
	Store *LinkedServiceReference `json:"store,omitempty"`
	// SecretName - The name of the secret in Azure Key Vault. Type: string (or Expression with resultType string).
	SecretName interface{} `json:"secretName,omitempty"`
	// SecretVersion - The version of the secret in Azure Key Vault. The default value is the latest version of the secret. Type: string (or Expression with resultType string).
	SecretVersion interface{} `json:"secretVersion,omitempty"`
	// Type - Possible values include: 'TypeSecretBase', 'TypeSecureString', 'TypeAzureKeyVaultSecret'
	Type Type `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureKeyVaultSecretReference.
func (akvsr AzureKeyVaultSecretReference) MarshalJSON() ([]byte, error) {
	akvsr.Type = TypeAzureKeyVaultSecret
	objectMap := make(map[string]interface{})
	if akvsr.Store != nil {
		objectMap["store"] = akvsr.Store
	}
	if akvsr.SecretName != nil {
		objectMap["secretName"] = akvsr.SecretName
	}
	if akvsr.SecretVersion != nil {
		objectMap["secretVersion"] = akvsr.SecretVersion
	}
	if akvsr.Type != "" {
		objectMap["type"] = akvsr.Type
	}
	return json.Marshal(objectMap)
}

// AsSecureString is the BasicSecretBase implementation for AzureKeyVaultSecretReference.
func (akvsr AzureKeyVaultSecretReference) AsSecureString() (*SecureString, bool) {
	return nil, false
}

// AsAzureKeyVaultSecretReference is the BasicSecretBase implementation for AzureKeyVaultSecretReference.
func (akvsr AzureKeyVaultSecretReference) AsAzureKeyVaultSecretReference() (*AzureKeyVaultSecretReference, bool) {
	return &akvsr, true
}

// AsSecretBase is the BasicSecretBase implementation for AzureKeyVaultSecretReference.
func (akvsr AzureKeyVaultSecretReference) AsSecretBase() (*SecretBase, bool) {
	return nil, false
}

// AsBasicSecretBase is the BasicSecretBase implementation for AzureKeyVaultSecretReference.
func (akvsr AzureKeyVaultSecretReference) AsBasicSecretBase() (BasicSecretBase, bool) {
	return &akvsr, true
}

// AzureMLBatchExecutionActivity azure ML Batch Execution activity.
type AzureMLBatchExecutionActivity struct {
	// AzureMLBatchExecutionActivityTypeProperties - Azure ML Batch Execution activity properties.
	*AzureMLBatchExecutionActivityTypeProperties `json:"typeProperties,omitempty"`
	// LinkedServiceName - Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
	// Policy - Activity policy.
	Policy *ActivityPolicy `json:"policy,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Name - Activity name.
	Name *string `json:"name,omitempty"`
	// Description - Activity description.
	Description *string `json:"description,omitempty"`
	// DependsOn - Activity depends on condition.
	DependsOn *[]ActivityDependency `json:"dependsOn,omitempty"`
	// UserProperties - Activity user properties.
	UserProperties *[]UserProperty `json:"userProperties,omitempty"`
	// Type - Possible values include: 'TypeActivity', 'TypeAzureFunctionActivity', 'TypeDatabricksSparkPython', 'TypeDatabricksSparkJar', 'TypeDatabricksNotebook', 'TypeDataLakeAnalyticsUSQL', 'TypeAzureMLUpdateResource', 'TypeAzureMLBatchExecution', 'TypeGetMetadata', 'TypeWebActivity', 'TypeLookup', 'TypeDelete', 'TypeSQLServerStoredProcedure', 'TypeCustom', 'TypeExecuteSSISPackage', 'TypeHDInsightSpark', 'TypeHDInsightStreaming', 'TypeHDInsightMapReduce', 'TypeHDInsightPig', 'TypeHDInsightHive', 'TypeCopy', 'TypeExecution', 'TypeWebHook', 'TypeAppendVariable', 'TypeSetVariable', 'TypeFilter', 'TypeValidation', 'TypeUntil', 'TypeWait', 'TypeForEach', 'TypeIfCondition', 'TypeExecutePipeline', 'TypeContainer'
	Type TypeBasicActivity `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) MarshalJSON() ([]byte, error) {
	ambea.Type = TypeAzureMLBatchExecution
	objectMap := make(map[string]interface{})
	if ambea.AzureMLBatchExecutionActivityTypeProperties != nil {
		objectMap["typeProperties"] = ambea.AzureMLBatchExecutionActivityTypeProperties
	}
	if ambea.LinkedServiceName != nil {
		objectMap["linkedServiceName"] = ambea.LinkedServiceName
	}
	if ambea.Policy != nil {
		objectMap["policy"] = ambea.Policy
	}
	if ambea.Name != nil {
		objectMap["name"] = ambea.Name
	}
	if ambea.Description != nil {
		objectMap["description"] = ambea.Description
	}
	if ambea.DependsOn != nil {
		objectMap["dependsOn"] = ambea.DependsOn
	}
	if ambea.UserProperties != nil {
		objectMap["userProperties"] = ambea.UserProperties
	}
	if ambea.Type != "" {
		objectMap["type"] = ambea.Type
	}
	for k, v := range ambea.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsAzureFunctionActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsAzureFunctionActivity() (*AzureFunctionActivity, bool) {
	return nil, false
}

// AsDatabricksSparkPythonActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsDatabricksSparkPythonActivity() (*DatabricksSparkPythonActivity, bool) {
	return nil, false
}

// AsDatabricksSparkJarActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsDatabricksSparkJarActivity() (*DatabricksSparkJarActivity, bool) {
	return nil, false
}

// AsDatabricksNotebookActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsDatabricksNotebookActivity() (*DatabricksNotebookActivity, bool) {
	return nil, false
}

// AsDataLakeAnalyticsUSQLActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsDataLakeAnalyticsUSQLActivity() (*DataLakeAnalyticsUSQLActivity, bool) {
	return nil, false
}

// AsAzureMLUpdateResourceActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsAzureMLUpdateResourceActivity() (*AzureMLUpdateResourceActivity, bool) {
	return nil, false
}

// AsAzureMLBatchExecutionActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsAzureMLBatchExecutionActivity() (*AzureMLBatchExecutionActivity, bool) {
	return &ambea, true
}

// AsGetMetadataActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsGetMetadataActivity() (*GetMetadataActivity, bool) {
	return nil, false
}

// AsWebActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsWebActivity() (*WebActivity, bool) {
	return nil, false
}

// AsLookupActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsLookupActivity() (*LookupActivity, bool) {
	return nil, false
}

// AsDeleteActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsDeleteActivity() (*DeleteActivity, bool) {
	return nil, false
}

// AsSQLServerStoredProcedureActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsSQLServerStoredProcedureActivity() (*SQLServerStoredProcedureActivity, bool) {
	return nil, false
}

// AsCustomActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsCustomActivity() (*CustomActivity, bool) {
	return nil, false
}

// AsExecuteSSISPackageActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsExecuteSSISPackageActivity() (*ExecuteSSISPackageActivity, bool) {
	return nil, false
}

// AsHDInsightSparkActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsHDInsightSparkActivity() (*HDInsightSparkActivity, bool) {
	return nil, false
}

// AsHDInsightStreamingActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsHDInsightStreamingActivity() (*HDInsightStreamingActivity, bool) {
	return nil, false
}

// AsHDInsightMapReduceActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsHDInsightMapReduceActivity() (*HDInsightMapReduceActivity, bool) {
	return nil, false
}

// AsHDInsightPigActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsHDInsightPigActivity() (*HDInsightPigActivity, bool) {
	return nil, false
}

// AsHDInsightHiveActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsHDInsightHiveActivity() (*HDInsightHiveActivity, bool) {
	return nil, false
}

// AsCopyActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsCopyActivity() (*CopyActivity, bool) {
	return nil, false
}

// AsExecutionActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsExecutionActivity() (*ExecutionActivity, bool) {
	return nil, false
}

// AsBasicExecutionActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsBasicExecutionActivity() (BasicExecutionActivity, bool) {
	return &ambea, true
}

// AsWebHookActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsWebHookActivity() (*WebHookActivity, bool) {
	return nil, false
}

// AsAppendVariableActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsAppendVariableActivity() (*AppendVariableActivity, bool) {
	return nil, false
}

// AsSetVariableActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsSetVariableActivity() (*SetVariableActivity, bool) {
	return nil, false
}

// AsFilterActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsFilterActivity() (*FilterActivity, bool) {
	return nil, false
}

// AsValidationActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsValidationActivity() (*ValidationActivity, bool) {
	return nil, false
}

// AsUntilActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsUntilActivity() (*UntilActivity, bool) {
	return nil, false
}

// AsWaitActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsWaitActivity() (*WaitActivity, bool) {
	return nil, false
}

// AsForEachActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsForEachActivity() (*ForEachActivity, bool) {
	return nil, false
}

// AsIfConditionActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsIfConditionActivity() (*IfConditionActivity, bool) {
	return nil, false
}

// AsExecutePipelineActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsExecutePipelineActivity() (*ExecutePipelineActivity, bool) {
	return nil, false
}

// AsControlActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsControlActivity() (*ControlActivity, bool) {
	return nil, false
}

// AsBasicControlActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsBasicControlActivity() (BasicControlActivity, bool) {
	return nil, false
}

// AsActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsActivity() (*Activity, bool) {
	return nil, false
}

// AsBasicActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsBasicActivity() (BasicActivity, bool) {
	return &ambea, true
}

// UnmarshalJSON is the custom unmarshaler for AzureMLBatchExecutionActivity struct.
func (ambea *AzureMLBatchExecutionActivity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var azureMLBatchExecutionActivityTypeProperties AzureMLBatchExecutionActivityTypeProperties
				err = json.Unmarshal(*v, &azureMLBatchExecutionActivityTypeProperties)
				if err != nil {
					return err
				}
				ambea.AzureMLBatchExecutionActivityTypeProperties = &azureMLBatchExecutionActivityTypeProperties
			}
		case "linkedServiceName":
			if v != nil {
				var linkedServiceName LinkedServiceReference
				err = json.Unmarshal(*v, &linkedServiceName)
				if err != nil {
					return err
				}
				ambea.LinkedServiceName = &linkedServiceName
			}
		case "policy":
			if v != nil {
				var policy ActivityPolicy
				err = json.Unmarshal(*v, &policy)
				if err != nil {
					return err
				}
				ambea.Policy = &policy
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if ambea.AdditionalProperties == nil {
					ambea.AdditionalProperties = make(map[string]interface{})
				}
				ambea.AdditionalProperties[k] = additionalProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ambea.Name = &name
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				ambea.Description = &description
			}
		case "dependsOn":
			if v != nil {
				var dependsOn []ActivityDependency
				err = json.Unmarshal(*v, &dependsOn)
				if err != nil {
					return err
				}
				ambea.DependsOn = &dependsOn
			}
		case "userProperties":
			if v != nil {
				var userProperties []UserProperty
				err = json.Unmarshal(*v, &userProperties)
				if err != nil {
					return err
				}
				ambea.UserProperties = &userProperties
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicActivity
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ambea.Type = typeVar
			}
		}
	}

	return nil
}

// AzureMLBatchExecutionActivityTypeProperties azure ML Batch Execution activity properties.
type AzureMLBatchExecutionActivityTypeProperties struct {
	// GlobalParameters - Key,Value pairs to be passed to the Azure ML Batch Execution Service endpoint. Keys must match the names of web service parameters defined in the published Azure ML web service. Values will be passed in the GlobalParameters property of the Azure ML batch execution request.
	GlobalParameters map[string]interface{} `json:"globalParameters"`
	// WebServiceOutputs - Key,Value pairs, mapping the names of Azure ML endpoint's Web Service Outputs to AzureMLWebServiceFile objects specifying the output Blob locations. This information will be passed in the WebServiceOutputs property of the Azure ML batch execution request.
	WebServiceOutputs map[string]*AzureMLWebServiceFile `json:"webServiceOutputs"`
	// WebServiceInputs - Key,Value pairs, mapping the names of Azure ML endpoint's Web Service Inputs to AzureMLWebServiceFile objects specifying the input Blob locations.. This information will be passed in the WebServiceInputs property of the Azure ML batch execution request.
	WebServiceInputs map[string]*AzureMLWebServiceFile `json:"webServiceInputs"`
}

// MarshalJSON is the custom marshaler for AzureMLBatchExecutionActivityTypeProperties.
func (ambeatp AzureMLBatchExecutionActivityTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ambeatp.GlobalParameters != nil {
		objectMap["globalParameters"] = ambeatp.GlobalParameters
	}
	if ambeatp.WebServiceOutputs != nil {
		objectMap["webServiceOutputs"] = ambeatp.WebServiceOutputs
	}
	if ambeatp.WebServiceInputs != nil {
		objectMap["webServiceInputs"] = ambeatp.WebServiceInputs
	}
	return json.Marshal(objectMap)
}

// AzureMLLinkedService azure ML Web Service linked service.
type AzureMLLinkedService struct {
	// AzureMLLinkedServiceTypeProperties - Azure ML Web Service linked service properties.
	*AzureMLLinkedServiceTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Parameters - Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the linked service.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Type - Possible values include: 'TypeLinkedService', 'TypeAzureFunction', 'TypeAzureDataExplorer', 'TypeGoogleAdWords', 'TypeOracleServiceCloud', 'TypeDynamicsAX', 'TypeResponsys', 'TypeAzureDatabricks', 'TypeAzureDataLakeAnalytics', 'TypeHDInsightOnDemand', 'TypeSalesforceMarketingCloud', 'TypeNetezza', 'TypeVertica', 'TypeZoho', 'TypeXero', 'TypeSquare', 'TypeSpark', 'TypeShopify', 'TypeServiceNow', 'TypeQuickBooks', 'TypePresto', 'TypePhoenix', 'TypePaypal', 'TypeMarketo', 'TypeMariaDB', 'TypeMagento', 'TypeJira', 'TypeImpala', 'TypeHubspot', 'TypeHive', 'TypeHBase', 'TypeGreenplum', 'TypeGoogleBigQuery', 'TypeEloqua', 'TypeDrill', 'TypeCouchbase', 'TypeConcur', 'TypeAzurePostgreSQL', 'TypeAmazonMWS', 'TypeSapHana', 'TypeSapBW', 'TypeSftp', 'TypeFtpServer', 'TypeHTTPServer', 'TypeAzureSearch', 'TypeCustomDataSource', 'TypeAmazonRedshift', 'TypeAmazonS3', 'TypeRestService', 'TypeSapOpenHub', 'TypeSapEcc', 'TypeSapCloudForCustomer', 'TypeSalesforce', 'TypeOffice365', 'TypeAzureBlobFS', 'TypeAzureDataLakeStore', 'TypeCosmosDbMongoDbAPI', 'TypeMongoDbV2', 'TypeMongoDb', 'TypeCassandra', 'TypeWeb', 'TypeOData', 'TypeHdfs', 'TypeOdbc', 'TypeAzureML', 'TypeTeradata', 'TypeDb2', 'TypeSybase', 'TypePostgreSQL', 'TypeMySQL', 'TypeAzureMySQL', 'TypeOracle', 'TypeFileServer', 'TypeHDInsight', 'TypeDynamics', 'TypeCosmosDb', 'TypeAzureKeyVault', 'TypeAzureBatch', 'TypeAzureSQLDatabase', 'TypeSQLServer', 'TypeAzureSQLDW', 'TypeAzureTableStorage', 'TypeAzureBlobStorage', 'TypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureMLLinkedService.
func (amls AzureMLLinkedService) MarshalJSON() ([]byte, error) {
	amls.Type = TypeAzureML
	objectMap := make(map[string]interface{})
	if amls.AzureMLLinkedServiceTypeProperties != nil {
		objectMap["typeProperties"] = amls.AzureMLLinkedServiceTypeProperties
	}
	if amls.ConnectVia != nil {
		objectMap["connectVia"] = amls.ConnectVia
	}
	if amls.Description != nil {
		objectMap["description"] = amls.Description
	}
	if amls.Parameters != nil {
		objectMap["parameters"] = amls.Parameters
	}
	if amls.Annotations != nil {
		objectMap["annotations"] = amls.Annotations
	}
	if amls.Type != "" {
		objectMap["type"] = amls.Type
	}
	for k, v := range amls.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsAzureFunctionLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsAzureFunctionLinkedService() (*AzureFunctionLinkedService, bool) {
	return nil, false
}

// AsAzureDataExplorerLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsAzureDataExplorerLinkedService() (*AzureDataExplorerLinkedService, bool) {
	return nil, false
}

// AsGoogleAdWordsLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsGoogleAdWordsLinkedService() (*GoogleAdWordsLinkedService, bool) {
	return nil, false
}

// AsOracleServiceCloudLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsOracleServiceCloudLinkedService() (*OracleServiceCloudLinkedService, bool) {
	return nil, false
}

// AsDynamicsAXLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsDynamicsAXLinkedService() (*DynamicsAXLinkedService, bool) {
	return nil, false
}

// AsResponsysLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsResponsysLinkedService() (*ResponsysLinkedService, bool) {
	return nil, false
}

// AsAzureDatabricksLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsAzureDatabricksLinkedService() (*AzureDatabricksLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return nil, false
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsSalesforceMarketingCloudLinkedService() (*SalesforceMarketingCloudLinkedService, bool) {
	return nil, false
}

// AsNetezzaLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsNetezzaLinkedService() (*NetezzaLinkedService, bool) {
	return nil, false
}

// AsVerticaLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsVerticaLinkedService() (*VerticaLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return nil, false
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return nil, false
}

// AsConcurLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return nil, false
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return nil, false
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return nil, false
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return nil, false
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return nil, false
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return nil, false
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return nil, false
}

// AsRestServiceLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsRestServiceLinkedService() (*RestServiceLinkedService, bool) {
	return nil, false
}

// AsSapOpenHubLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsSapOpenHubLinkedService() (*SapOpenHubLinkedService, bool) {
	return nil, false
}

// AsSapEccLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsSapEccLinkedService() (*SapEccLinkedService, bool) {
	return nil, false
}

// AsSapCloudForCustomerLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsSapCloudForCustomerLinkedService() (*SapCloudForCustomerLinkedService, bool) {
	return nil, false
}

// AsSalesforceLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsSalesforceLinkedService() (*SalesforceLinkedService, bool) {
	return nil, false
}

// AsOffice365LinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsOffice365LinkedService() (*Office365LinkedService, bool) {
	return nil, false
}

// AsAzureBlobFSLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsAzureBlobFSLinkedService() (*AzureBlobFSLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsAzureDataLakeStoreLinkedService() (*AzureDataLakeStoreLinkedService, bool) {
	return nil, false
}

// AsCosmosDbMongoDbAPILinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsCosmosDbMongoDbAPILinkedService() (*CosmosDbMongoDbAPILinkedService, bool) {
	return nil, false
}

// AsMongoDbV2LinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsMongoDbV2LinkedService() (*MongoDbV2LinkedService, bool) {
	return nil, false
}

// AsMongoDbLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsMongoDbLinkedService() (*MongoDbLinkedService, bool) {
	return nil, false
}

// AsCassandraLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsCassandraLinkedService() (*CassandraLinkedService, bool) {
	return nil, false
}

// AsWebLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsWebLinkedService() (*WebLinkedService, bool) {
	return nil, false
}

// AsODataLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsODataLinkedService() (*ODataLinkedService, bool) {
	return nil, false
}

// AsHdfsLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsHdfsLinkedService() (*HdfsLinkedService, bool) {
	return nil, false
}

// AsOdbcLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsOdbcLinkedService() (*OdbcLinkedService, bool) {
	return nil, false
}

// AsAzureMLLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsAzureMLLinkedService() (*AzureMLLinkedService, bool) {
	return &amls, true
}

// AsTeradataLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsTeradataLinkedService() (*TeradataLinkedService, bool) {
	return nil, false
}

// AsDb2LinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsDb2LinkedService() (*Db2LinkedService, bool) {
	return nil, false
}

// AsSybaseLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsSybaseLinkedService() (*SybaseLinkedService, bool) {
	return nil, false
}

// AsPostgreSQLLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsPostgreSQLLinkedService() (*PostgreSQLLinkedService, bool) {
	return nil, false
}

// AsMySQLLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsMySQLLinkedService() (*MySQLLinkedService, bool) {
	return nil, false
}

// AsAzureMySQLLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsAzureMySQLLinkedService() (*AzureMySQLLinkedService, bool) {
	return nil, false
}

// AsOracleLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsOracleLinkedService() (*OracleLinkedService, bool) {
	return nil, false
}

// AsFileServerLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsFileServerLinkedService() (*FileServerLinkedService, bool) {
	return nil, false
}

// AsHDInsightLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsHDInsightLinkedService() (*HDInsightLinkedService, bool) {
	return nil, false
}

// AsDynamicsLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsDynamicsLinkedService() (*DynamicsLinkedService, bool) {
	return nil, false
}

// AsCosmosDbLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsCosmosDbLinkedService() (*CosmosDbLinkedService, bool) {
	return nil, false
}

// AsAzureKeyVaultLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsAzureKeyVaultLinkedService() (*AzureKeyVaultLinkedService, bool) {
	return nil, false
}

// AsAzureBatchLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsAzureBatchLinkedService() (*AzureBatchLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDatabaseLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsAzureSQLDatabaseLinkedService() (*AzureSQLDatabaseLinkedService, bool) {
	return nil, false
}

// AsSQLServerLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsSQLServerLinkedService() (*SQLServerLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDWLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsAzureSQLDWLinkedService() (*AzureSQLDWLinkedService, bool) {
	return nil, false
}

// AsAzureTableStorageLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsAzureTableStorageLinkedService() (*AzureTableStorageLinkedService, bool) {
	return nil, false
}

// AsAzureBlobStorageLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsAzureBlobStorageLinkedService() (*AzureBlobStorageLinkedService, bool) {
	return nil, false
}

// AsAzureStorageLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsAzureStorageLinkedService() (*AzureStorageLinkedService, bool) {
	return nil, false
}

// AsLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsLinkedService() (*LinkedService, bool) {
	return nil, false
}

// AsBasicLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsBasicLinkedService() (BasicLinkedService, bool) {
	return &amls, true
}

// UnmarshalJSON is the custom unmarshaler for AzureMLLinkedService struct.
func (amls *AzureMLLinkedService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var azureMLLinkedServiceTypeProperties AzureMLLinkedServiceTypeProperties
				err = json.Unmarshal(*v, &azureMLLinkedServiceTypeProperties)
				if err != nil {
					return err
				}
				amls.AzureMLLinkedServiceTypeProperties = &azureMLLinkedServiceTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if amls.AdditionalProperties == nil {
					amls.AdditionalProperties = make(map[string]interface{})
				}
				amls.AdditionalProperties[k] = additionalProperties
			}
		case "connectVia":
			if v != nil {
				var connectVia IntegrationRuntimeReference
				err = json.Unmarshal(*v, &connectVia)
				if err != nil {
					return err
				}
				amls.ConnectVia = &connectVia
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				amls.Description = &description
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				amls.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				amls.Annotations = &annotations
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicLinkedService
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				amls.Type = typeVar
			}
		}
	}

	return nil
}

// AzureMLLinkedServiceTypeProperties azure ML Web Service linked service properties.
type AzureMLLinkedServiceTypeProperties struct {
	// MlEndpoint - The Batch Execution REST URL for an Azure ML Web Service endpoint. Type: string (or Expression with resultType string).
	MlEndpoint interface{} `json:"mlEndpoint,omitempty"`
	// APIKey - The API key for accessing the Azure ML model endpoint.
	APIKey BasicSecretBase `json:"apiKey,omitempty"`
	// UpdateResourceEndpoint - The Update Resource REST URL for an Azure ML Web Service endpoint. Type: string (or Expression with resultType string).
	UpdateResourceEndpoint interface{} `json:"updateResourceEndpoint,omitempty"`
	// ServicePrincipalID - The ID of the service principal used to authenticate against the ARM-based updateResourceEndpoint of an Azure ML web service. Type: string (or Expression with resultType string).
	ServicePrincipalID interface{} `json:"servicePrincipalId,omitempty"`
	// ServicePrincipalKey - The key of the service principal used to authenticate against the ARM-based updateResourceEndpoint of an Azure ML web service.
	ServicePrincipalKey BasicSecretBase `json:"servicePrincipalKey,omitempty"`
	// Tenant - The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
	Tenant interface{} `json:"tenant,omitempty"`
	// EncryptedCredential - The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AzureMLLinkedServiceTypeProperties struct.
func (amlstp *AzureMLLinkedServiceTypeProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "mlEndpoint":
			if v != nil {
				var mlEndpoint interface{}
				err = json.Unmarshal(*v, &mlEndpoint)
				if err != nil {
					return err
				}
				amlstp.MlEndpoint = mlEndpoint
			}
		case "apiKey":
			if v != nil {
				APIKey, err := unmarshalBasicSecretBase(*v)
				if err != nil {
					return err
				}
				amlstp.APIKey = APIKey
			}
		case "updateResourceEndpoint":
			if v != nil {
				var updateResourceEndpoint interface{}
				err = json.Unmarshal(*v, &updateResourceEndpoint)
				if err != nil {
					return err
				}
				amlstp.UpdateResourceEndpoint = updateResourceEndpoint
			}
		case "servicePrincipalId":
			if v != nil {
				var servicePrincipalID interface{}
				err = json.Unmarshal(*v, &servicePrincipalID)
				if err != nil {
					return err
				}
				amlstp.ServicePrincipalID = servicePrincipalID
			}
		case "servicePrincipalKey":
			if v != nil {
				servicePrincipalKey, err := unmarshalBasicSecretBase(*v)
				if err != nil {
					return err
				}
				amlstp.ServicePrincipalKey = servicePrincipalKey
			}
		case "tenant":
			if v != nil {
				var tenant interface{}
				err = json.Unmarshal(*v, &tenant)
				if err != nil {
					return err
				}
				amlstp.Tenant = tenant
			}
		case "encryptedCredential":
			if v != nil {
				var encryptedCredential interface{}
				err = json.Unmarshal(*v, &encryptedCredential)
				if err != nil {
					return err
				}
				amlstp.EncryptedCredential = encryptedCredential
			}
		}
	}

	return nil
}

// AzureMLUpdateResourceActivity azure ML Update Resource management activity.
type AzureMLUpdateResourceActivity struct {
	// AzureMLUpdateResourceActivityTypeProperties - Azure ML Update Resource management activity properties.
	*AzureMLUpdateResourceActivityTypeProperties `json:"typeProperties,omitempty"`
	// LinkedServiceName - Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
	// Policy - Activity policy.
	Policy *ActivityPolicy `json:"policy,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Name - Activity name.
	Name *string `json:"name,omitempty"`
	// Description - Activity description.
	Description *string `json:"description,omitempty"`
	// DependsOn - Activity depends on condition.
	DependsOn *[]ActivityDependency `json:"dependsOn,omitempty"`
	// UserProperties - Activity user properties.
	UserProperties *[]UserProperty `json:"userProperties,omitempty"`
	// Type - Possible values include: 'TypeActivity', 'TypeAzureFunctionActivity', 'TypeDatabricksSparkPython', 'TypeDatabricksSparkJar', 'TypeDatabricksNotebook', 'TypeDataLakeAnalyticsUSQL', 'TypeAzureMLUpdateResource', 'TypeAzureMLBatchExecution', 'TypeGetMetadata', 'TypeWebActivity', 'TypeLookup', 'TypeDelete', 'TypeSQLServerStoredProcedure', 'TypeCustom', 'TypeExecuteSSISPackage', 'TypeHDInsightSpark', 'TypeHDInsightStreaming', 'TypeHDInsightMapReduce', 'TypeHDInsightPig', 'TypeHDInsightHive', 'TypeCopy', 'TypeExecution', 'TypeWebHook', 'TypeAppendVariable', 'TypeSetVariable', 'TypeFilter', 'TypeValidation', 'TypeUntil', 'TypeWait', 'TypeForEach', 'TypeIfCondition', 'TypeExecutePipeline', 'TypeContainer'
	Type TypeBasicActivity `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) MarshalJSON() ([]byte, error) {
	amura.Type = TypeAzureMLUpdateResource
	objectMap := make(map[string]interface{})
	if amura.AzureMLUpdateResourceActivityTypeProperties != nil {
		objectMap["typeProperties"] = amura.AzureMLUpdateResourceActivityTypeProperties
	}
	if amura.LinkedServiceName != nil {
		objectMap["linkedServiceName"] = amura.LinkedServiceName
	}
	if amura.Policy != nil {
		objectMap["policy"] = amura.Policy
	}
	if amura.Name != nil {
		objectMap["name"] = amura.Name
	}
	if amura.Description != nil {
		objectMap["description"] = amura.Description
	}
	if amura.DependsOn != nil {
		objectMap["dependsOn"] = amura.DependsOn
	}
	if amura.UserProperties != nil {
		objectMap["userProperties"] = amura.UserProperties
	}
	if amura.Type != "" {
		objectMap["type"] = amura.Type
	}
	for k, v := range amura.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsAzureFunctionActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsAzureFunctionActivity() (*AzureFunctionActivity, bool) {
	return nil, false
}

// AsDatabricksSparkPythonActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsDatabricksSparkPythonActivity() (*DatabricksSparkPythonActivity, bool) {
	return nil, false
}

// AsDatabricksSparkJarActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsDatabricksSparkJarActivity() (*DatabricksSparkJarActivity, bool) {
	return nil, false
}

// AsDatabricksNotebookActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsDatabricksNotebookActivity() (*DatabricksNotebookActivity, bool) {
	return nil, false
}

// AsDataLakeAnalyticsUSQLActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsDataLakeAnalyticsUSQLActivity() (*DataLakeAnalyticsUSQLActivity, bool) {
	return nil, false
}

// AsAzureMLUpdateResourceActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsAzureMLUpdateResourceActivity() (*AzureMLUpdateResourceActivity, bool) {
	return &amura, true
}

// AsAzureMLBatchExecutionActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsAzureMLBatchExecutionActivity() (*AzureMLBatchExecutionActivity, bool) {
	return nil, false
}

// AsGetMetadataActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsGetMetadataActivity() (*GetMetadataActivity, bool) {
	return nil, false
}

// AsWebActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsWebActivity() (*WebActivity, bool) {
	return nil, false
}

// AsLookupActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsLookupActivity() (*LookupActivity, bool) {
	return nil, false
}

// AsDeleteActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsDeleteActivity() (*DeleteActivity, bool) {
	return nil, false
}

// AsSQLServerStoredProcedureActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsSQLServerStoredProcedureActivity() (*SQLServerStoredProcedureActivity, bool) {
	return nil, false
}

// AsCustomActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsCustomActivity() (*CustomActivity, bool) {
	return nil, false
}

// AsExecuteSSISPackageActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsExecuteSSISPackageActivity() (*ExecuteSSISPackageActivity, bool) {
	return nil, false
}

// AsHDInsightSparkActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsHDInsightSparkActivity() (*HDInsightSparkActivity, bool) {
	return nil, false
}

// AsHDInsightStreamingActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsHDInsightStreamingActivity() (*HDInsightStreamingActivity, bool) {
	return nil, false
}

// AsHDInsightMapReduceActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsHDInsightMapReduceActivity() (*HDInsightMapReduceActivity, bool) {
	return nil, false
}

// AsHDInsightPigActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsHDInsightPigActivity() (*HDInsightPigActivity, bool) {
	return nil, false
}

// AsHDInsightHiveActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsHDInsightHiveActivity() (*HDInsightHiveActivity, bool) {
	return nil, false
}

// AsCopyActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsCopyActivity() (*CopyActivity, bool) {
	return nil, false
}

// AsExecutionActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsExecutionActivity() (*ExecutionActivity, bool) {
	return nil, false
}

// AsBasicExecutionActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsBasicExecutionActivity() (BasicExecutionActivity, bool) {
	return &amura, true
}

// AsWebHookActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsWebHookActivity() (*WebHookActivity, bool) {
	return nil, false
}

// AsAppendVariableActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsAppendVariableActivity() (*AppendVariableActivity, bool) {
	return nil, false
}

// AsSetVariableActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsSetVariableActivity() (*SetVariableActivity, bool) {
	return nil, false
}

// AsFilterActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsFilterActivity() (*FilterActivity, bool) {
	return nil, false
}

// AsValidationActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsValidationActivity() (*ValidationActivity, bool) {
	return nil, false
}

// AsUntilActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsUntilActivity() (*UntilActivity, bool) {
	return nil, false
}

// AsWaitActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsWaitActivity() (*WaitActivity, bool) {
	return nil, false
}

// AsForEachActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsForEachActivity() (*ForEachActivity, bool) {
	return nil, false
}

// AsIfConditionActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsIfConditionActivity() (*IfConditionActivity, bool) {
	return nil, false
}

// AsExecutePipelineActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsExecutePipelineActivity() (*ExecutePipelineActivity, bool) {
	return nil, false
}

// AsControlActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsControlActivity() (*ControlActivity, bool) {
	return nil, false
}

// AsBasicControlActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsBasicControlActivity() (BasicControlActivity, bool) {
	return nil, false
}

// AsActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsActivity() (*Activity, bool) {
	return nil, false
}

// AsBasicActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsBasicActivity() (BasicActivity, bool) {
	return &amura, true
}

// UnmarshalJSON is the custom unmarshaler for AzureMLUpdateResourceActivity struct.
func (amura *AzureMLUpdateResourceActivity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var azureMLUpdateResourceActivityTypeProperties AzureMLUpdateResourceActivityTypeProperties
				err = json.Unmarshal(*v, &azureMLUpdateResourceActivityTypeProperties)
				if err != nil {
					return err
				}
				amura.AzureMLUpdateResourceActivityTypeProperties = &azureMLUpdateResourceActivityTypeProperties
			}
		case "linkedServiceName":
			if v != nil {
				var linkedServiceName LinkedServiceReference
				err = json.Unmarshal(*v, &linkedServiceName)
				if err != nil {
					return err
				}
				amura.LinkedServiceName = &linkedServiceName
			}
		case "policy":
			if v != nil {
				var policy ActivityPolicy
				err = json.Unmarshal(*v, &policy)
				if err != nil {
					return err
				}
				amura.Policy = &policy
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if amura.AdditionalProperties == nil {
					amura.AdditionalProperties = make(map[string]interface{})
				}
				amura.AdditionalProperties[k] = additionalProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				amura.Name = &name
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				amura.Description = &description
			}
		case "dependsOn":
			if v != nil {
				var dependsOn []ActivityDependency
				err = json.Unmarshal(*v, &dependsOn)
				if err != nil {
					return err
				}
				amura.DependsOn = &dependsOn
			}
		case "userProperties":
			if v != nil {
				var userProperties []UserProperty
				err = json.Unmarshal(*v, &userProperties)
				if err != nil {
					return err
				}
				amura.UserProperties = &userProperties
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicActivity
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				amura.Type = typeVar
			}
		}
	}

	return nil
}

// AzureMLUpdateResourceActivityTypeProperties azure ML Update Resource activity properties.
type AzureMLUpdateResourceActivityTypeProperties struct {
	// TrainedModelName - Name of the Trained Model module in the Web Service experiment to be updated. Type: string (or Expression with resultType string).
	TrainedModelName interface{} `json:"trainedModelName,omitempty"`
	// TrainedModelLinkedServiceName - Name of Azure Storage linked service holding the .ilearner file that will be uploaded by the update operation.
	TrainedModelLinkedServiceName *LinkedServiceReference `json:"trainedModelLinkedServiceName,omitempty"`
	// TrainedModelFilePath - The relative file path in trainedModelLinkedService to represent the .ilearner file that will be uploaded by the update operation.  Type: string (or Expression with resultType string).
	TrainedModelFilePath interface{} `json:"trainedModelFilePath,omitempty"`
}

// AzureMLWebServiceFile azure ML WebService Input/Output file
type AzureMLWebServiceFile struct {
	// FilePath - The relative file path, including container name, in the Azure Blob Storage specified by the LinkedService. Type: string (or Expression with resultType string).
	FilePath interface{} `json:"filePath,omitempty"`
	// LinkedServiceName - Reference to an Azure Storage LinkedService, where Azure ML WebService Input/Output file located.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
}

// AzureMySQLLinkedService azure MySQL database linked service.
type AzureMySQLLinkedService struct {
	// AzureMySQLLinkedServiceTypeProperties - Azure MySQL database linked service properties.
	*AzureMySQLLinkedServiceTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Parameters - Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the linked service.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Type - Possible values include: 'TypeLinkedService', 'TypeAzureFunction', 'TypeAzureDataExplorer', 'TypeGoogleAdWords', 'TypeOracleServiceCloud', 'TypeDynamicsAX', 'TypeResponsys', 'TypeAzureDatabricks', 'TypeAzureDataLakeAnalytics', 'TypeHDInsightOnDemand', 'TypeSalesforceMarketingCloud', 'TypeNetezza', 'TypeVertica', 'TypeZoho', 'TypeXero', 'TypeSquare', 'TypeSpark', 'TypeShopify', 'TypeServiceNow', 'TypeQuickBooks', 'TypePresto', 'TypePhoenix', 'TypePaypal', 'TypeMarketo', 'TypeMariaDB', 'TypeMagento', 'TypeJira', 'TypeImpala', 'TypeHubspot', 'TypeHive', 'TypeHBase', 'TypeGreenplum', 'TypeGoogleBigQuery', 'TypeEloqua', 'TypeDrill', 'TypeCouchbase', 'TypeConcur', 'TypeAzurePostgreSQL', 'TypeAmazonMWS', 'TypeSapHana', 'TypeSapBW', 'TypeSftp', 'TypeFtpServer', 'TypeHTTPServer', 'TypeAzureSearch', 'TypeCustomDataSource', 'TypeAmazonRedshift', 'TypeAmazonS3', 'TypeRestService', 'TypeSapOpenHub', 'TypeSapEcc', 'TypeSapCloudForCustomer', 'TypeSalesforce', 'TypeOffice365', 'TypeAzureBlobFS', 'TypeAzureDataLakeStore', 'TypeCosmosDbMongoDbAPI', 'TypeMongoDbV2', 'TypeMongoDb', 'TypeCassandra', 'TypeWeb', 'TypeOData', 'TypeHdfs', 'TypeOdbc', 'TypeAzureML', 'TypeTeradata', 'TypeDb2', 'TypeSybase', 'TypePostgreSQL', 'TypeMySQL', 'TypeAzureMySQL', 'TypeOracle', 'TypeFileServer', 'TypeHDInsight', 'TypeDynamics', 'TypeCosmosDb', 'TypeAzureKeyVault', 'TypeAzureBatch', 'TypeAzureSQLDatabase', 'TypeSQLServer', 'TypeAzureSQLDW', 'TypeAzureTableStorage', 'TypeAzureBlobStorage', 'TypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) MarshalJSON() ([]byte, error) {
	amsls.Type = TypeAzureMySQL
	objectMap := make(map[string]interface{})
	if amsls.AzureMySQLLinkedServiceTypeProperties != nil {
		objectMap["typeProperties"] = amsls.AzureMySQLLinkedServiceTypeProperties
	}
	if amsls.ConnectVia != nil {
		objectMap["connectVia"] = amsls.ConnectVia
	}
	if amsls.Description != nil {
		objectMap["description"] = amsls.Description
	}
	if amsls.Parameters != nil {
		objectMap["parameters"] = amsls.Parameters
	}
	if amsls.Annotations != nil {
		objectMap["annotations"] = amsls.Annotations
	}
	if amsls.Type != "" {
		objectMap["type"] = amsls.Type
	}
	for k, v := range amsls.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsAzureFunctionLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsAzureFunctionLinkedService() (*AzureFunctionLinkedService, bool) {
	return nil, false
}

// AsAzureDataExplorerLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsAzureDataExplorerLinkedService() (*AzureDataExplorerLinkedService, bool) {
	return nil, false
}

// AsGoogleAdWordsLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsGoogleAdWordsLinkedService() (*GoogleAdWordsLinkedService, bool) {
	return nil, false
}

// AsOracleServiceCloudLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsOracleServiceCloudLinkedService() (*OracleServiceCloudLinkedService, bool) {
	return nil, false
}

// AsDynamicsAXLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsDynamicsAXLinkedService() (*DynamicsAXLinkedService, bool) {
	return nil, false
}

// AsResponsysLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsResponsysLinkedService() (*ResponsysLinkedService, bool) {
	return nil, false
}

// AsAzureDatabricksLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsAzureDatabricksLinkedService() (*AzureDatabricksLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return nil, false
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsSalesforceMarketingCloudLinkedService() (*SalesforceMarketingCloudLinkedService, bool) {
	return nil, false
}

// AsNetezzaLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsNetezzaLinkedService() (*NetezzaLinkedService, bool) {
	return nil, false
}

// AsVerticaLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsVerticaLinkedService() (*VerticaLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return nil, false
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return nil, false
}

// AsConcurLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return nil, false
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return nil, false
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return nil, false
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return nil, false
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return nil, false
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return nil, false
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return nil, false
}

// AsRestServiceLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsRestServiceLinkedService() (*RestServiceLinkedService, bool) {
	return nil, false
}

// AsSapOpenHubLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsSapOpenHubLinkedService() (*SapOpenHubLinkedService, bool) {
	return nil, false
}

// AsSapEccLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsSapEccLinkedService() (*SapEccLinkedService, bool) {
	return nil, false
}

// AsSapCloudForCustomerLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsSapCloudForCustomerLinkedService() (*SapCloudForCustomerLinkedService, bool) {
	return nil, false
}

// AsSalesforceLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsSalesforceLinkedService() (*SalesforceLinkedService, bool) {
	return nil, false
}

// AsOffice365LinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsOffice365LinkedService() (*Office365LinkedService, bool) {
	return nil, false
}

// AsAzureBlobFSLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsAzureBlobFSLinkedService() (*AzureBlobFSLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsAzureDataLakeStoreLinkedService() (*AzureDataLakeStoreLinkedService, bool) {
	return nil, false
}

// AsCosmosDbMongoDbAPILinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsCosmosDbMongoDbAPILinkedService() (*CosmosDbMongoDbAPILinkedService, bool) {
	return nil, false
}

// AsMongoDbV2LinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsMongoDbV2LinkedService() (*MongoDbV2LinkedService, bool) {
	return nil, false
}

// AsMongoDbLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsMongoDbLinkedService() (*MongoDbLinkedService, bool) {
	return nil, false
}

// AsCassandraLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsCassandraLinkedService() (*CassandraLinkedService, bool) {
	return nil, false
}

// AsWebLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsWebLinkedService() (*WebLinkedService, bool) {
	return nil, false
}

// AsODataLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsODataLinkedService() (*ODataLinkedService, bool) {
	return nil, false
}

// AsHdfsLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsHdfsLinkedService() (*HdfsLinkedService, bool) {
	return nil, false
}

// AsOdbcLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsOdbcLinkedService() (*OdbcLinkedService, bool) {
	return nil, false
}

// AsAzureMLLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsAzureMLLinkedService() (*AzureMLLinkedService, bool) {
	return nil, false
}

// AsTeradataLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsTeradataLinkedService() (*TeradataLinkedService, bool) {
	return nil, false
}

// AsDb2LinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsDb2LinkedService() (*Db2LinkedService, bool) {
	return nil, false
}

// AsSybaseLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsSybaseLinkedService() (*SybaseLinkedService, bool) {
	return nil, false
}

// AsPostgreSQLLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsPostgreSQLLinkedService() (*PostgreSQLLinkedService, bool) {
	return nil, false
}

// AsMySQLLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsMySQLLinkedService() (*MySQLLinkedService, bool) {
	return nil, false
}

// AsAzureMySQLLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsAzureMySQLLinkedService() (*AzureMySQLLinkedService, bool) {
	return &amsls, true
}

// AsOracleLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsOracleLinkedService() (*OracleLinkedService, bool) {
	return nil, false
}

// AsFileServerLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsFileServerLinkedService() (*FileServerLinkedService, bool) {
	return nil, false
}

// AsHDInsightLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsHDInsightLinkedService() (*HDInsightLinkedService, bool) {
	return nil, false
}

// AsDynamicsLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsDynamicsLinkedService() (*DynamicsLinkedService, bool) {
	return nil, false
}

// AsCosmosDbLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsCosmosDbLinkedService() (*CosmosDbLinkedService, bool) {
	return nil, false
}

// AsAzureKeyVaultLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsAzureKeyVaultLinkedService() (*AzureKeyVaultLinkedService, bool) {
	return nil, false
}

// AsAzureBatchLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsAzureBatchLinkedService() (*AzureBatchLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDatabaseLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsAzureSQLDatabaseLinkedService() (*AzureSQLDatabaseLinkedService, bool) {
	return nil, false
}

// AsSQLServerLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsSQLServerLinkedService() (*SQLServerLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDWLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsAzureSQLDWLinkedService() (*AzureSQLDWLinkedService, bool) {
	return nil, false
}

// AsAzureTableStorageLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsAzureTableStorageLinkedService() (*AzureTableStorageLinkedService, bool) {
	return nil, false
}

// AsAzureBlobStorageLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsAzureBlobStorageLinkedService() (*AzureBlobStorageLinkedService, bool) {
	return nil, false
}

// AsAzureStorageLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsAzureStorageLinkedService() (*AzureStorageLinkedService, bool) {
	return nil, false
}

// AsLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsLinkedService() (*LinkedService, bool) {
	return nil, false
}

// AsBasicLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsBasicLinkedService() (BasicLinkedService, bool) {
	return &amsls, true
}

// UnmarshalJSON is the custom unmarshaler for AzureMySQLLinkedService struct.
func (amsls *AzureMySQLLinkedService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var azureMySQLLinkedServiceTypeProperties AzureMySQLLinkedServiceTypeProperties
				err = json.Unmarshal(*v, &azureMySQLLinkedServiceTypeProperties)
				if err != nil {
					return err
				}
				amsls.AzureMySQLLinkedServiceTypeProperties = &azureMySQLLinkedServiceTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if amsls.AdditionalProperties == nil {
					amsls.AdditionalProperties = make(map[string]interface{})
				}
				amsls.AdditionalProperties[k] = additionalProperties
			}
		case "connectVia":
			if v != nil {
				var connectVia IntegrationRuntimeReference
				err = json.Unmarshal(*v, &connectVia)
				if err != nil {
					return err
				}
				amsls.ConnectVia = &connectVia
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				amsls.Description = &description
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				amsls.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				amsls.Annotations = &annotations
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicLinkedService
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				amsls.Type = typeVar
			}
		}
	}

	return nil
}

// AzureMySQLLinkedServiceTypeProperties azure MySQL database linked service properties.
type AzureMySQLLinkedServiceTypeProperties struct {
	// ConnectionString - The connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
	ConnectionString interface{} `json:"connectionString,omitempty"`
	// Password - The Azure key vault secret reference of password in connection string.
	Password *AzureKeyVaultSecretReference `json:"password,omitempty"`
	// EncryptedCredential - The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`
}

// AzureMySQLSource a copy activity Azure MySQL source.
type AzureMySQLSource struct {
	// Query - Database query. Type: string (or Expression with resultType string).
	Query interface{} `json:"query,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// SourceRetryCount - Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`
	// SourceRetryWait - Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
	// MaxConcurrentConnections - The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`
	// Type - Possible values include: 'TypeCopySource', 'TypeAmazonRedshiftSource', 'TypeGoogleAdWordsSource', 'TypeOracleServiceCloudSource', 'TypeDynamicsAXSource', 'TypeResponsysSource', 'TypeSalesforceMarketingCloudSource', 'TypeVerticaSource', 'TypeNetezzaSource', 'TypeZohoSource', 'TypeXeroSource', 'TypeSquareSource', 'TypeSparkSource', 'TypeShopifySource', 'TypeServiceNowSource', 'TypeQuickBooksSource', 'TypePrestoSource', 'TypePhoenixSource', 'TypePaypalSource', 'TypeMarketoSource', 'TypeMariaDBSource', 'TypeMagentoSource', 'TypeJiraSource', 'TypeImpalaSource', 'TypeHubspotSource', 'TypeHiveSource', 'TypeHBaseSource', 'TypeGreenplumSource', 'TypeGoogleBigQuerySource', 'TypeEloquaSource', 'TypeDrillSource', 'TypeCouchbaseSource', 'TypeConcurSource', 'TypeAzurePostgreSQLSource', 'TypeAmazonMWSSource', 'TypeHTTPSource', 'TypeAzureBlobFSSource', 'TypeAzureDataLakeStoreSource', 'TypeOffice365Source', 'TypeCosmosDbMongoDbAPISource', 'TypeMongoDbV2Source', 'TypeMongoDbSource', 'TypeCassandraSource', 'TypeWebSource', 'TypeOracleSource', 'TypeAzureDataExplorerSource', 'TypeAzureMySQLSource', 'TypeHdfsSource', 'TypeFileSystemSource', 'TypeSQLDWSource', 'TypeSQLSource', 'TypeRestSource', 'TypeSapOpenHubSource', 'TypeSapEccSource', 'TypeSapCloudForCustomerSource', 'TypeSalesforceSource', 'TypeRelationalSource', 'TypeDynamicsSource', 'TypeDocumentDbCollectionSource', 'TypeBlobSource', 'TypeAzureTableSource'
	Type TypeBasicCopySource `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureMySQLSource.
func (amss AzureMySQLSource) MarshalJSON() ([]byte, error) {
	amss.Type = TypeAzureMySQLSource
	objectMap := make(map[string]interface{})
	if amss.Query != nil {
		objectMap["query"] = amss.Query
	}
	if amss.SourceRetryCount != nil {
		objectMap["sourceRetryCount"] = amss.SourceRetryCount
	}
	if amss.SourceRetryWait != nil {
		objectMap["sourceRetryWait"] = amss.SourceRetryWait
	}
	if amss.MaxConcurrentConnections != nil {
		objectMap["maxConcurrentConnections"] = amss.MaxConcurrentConnections
	}
	if amss.Type != "" {
		objectMap["type"] = amss.Type
	}
	for k, v := range amss.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsAmazonRedshiftSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsAmazonRedshiftSource() (*AmazonRedshiftSource, bool) {
	return nil, false
}

// AsGoogleAdWordsSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsGoogleAdWordsSource() (*GoogleAdWordsSource, bool) {
	return nil, false
}

// AsOracleServiceCloudSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsOracleServiceCloudSource() (*OracleServiceCloudSource, bool) {
	return nil, false
}

// AsDynamicsAXSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsDynamicsAXSource() (*DynamicsAXSource, bool) {
	return nil, false
}

// AsResponsysSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsResponsysSource() (*ResponsysSource, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsSalesforceMarketingCloudSource() (*SalesforceMarketingCloudSource, bool) {
	return nil, false
}

// AsVerticaSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsVerticaSource() (*VerticaSource, bool) {
	return nil, false
}

// AsNetezzaSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsNetezzaSource() (*NetezzaSource, bool) {
	return nil, false
}

// AsZohoSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsZohoSource() (*ZohoSource, bool) {
	return nil, false
}

// AsXeroSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsXeroSource() (*XeroSource, bool) {
	return nil, false
}

// AsSquareSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsSquareSource() (*SquareSource, bool) {
	return nil, false
}

// AsSparkSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsSparkSource() (*SparkSource, bool) {
	return nil, false
}

// AsShopifySource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsShopifySource() (*ShopifySource, bool) {
	return nil, false
}

// AsServiceNowSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsServiceNowSource() (*ServiceNowSource, bool) {
	return nil, false
}

// AsQuickBooksSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsQuickBooksSource() (*QuickBooksSource, bool) {
	return nil, false
}

// AsPrestoSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsPrestoSource() (*PrestoSource, bool) {
	return nil, false
}

// AsPhoenixSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsPhoenixSource() (*PhoenixSource, bool) {
	return nil, false
}

// AsPaypalSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsPaypalSource() (*PaypalSource, bool) {
	return nil, false
}

// AsMarketoSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsMarketoSource() (*MarketoSource, bool) {
	return nil, false
}

// AsMariaDBSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsMariaDBSource() (*MariaDBSource, bool) {
	return nil, false
}

// AsMagentoSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsMagentoSource() (*MagentoSource, bool) {
	return nil, false
}

// AsJiraSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsJiraSource() (*JiraSource, bool) {
	return nil, false
}

// AsImpalaSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsImpalaSource() (*ImpalaSource, bool) {
	return nil, false
}

// AsHubspotSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsHubspotSource() (*HubspotSource, bool) {
	return nil, false
}

// AsHiveSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsHiveSource() (*HiveSource, bool) {
	return nil, false
}

// AsHBaseSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsHBaseSource() (*HBaseSource, bool) {
	return nil, false
}

// AsGreenplumSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsGreenplumSource() (*GreenplumSource, bool) {
	return nil, false
}

// AsGoogleBigQuerySource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsGoogleBigQuerySource() (*GoogleBigQuerySource, bool) {
	return nil, false
}

// AsEloquaSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsEloquaSource() (*EloquaSource, bool) {
	return nil, false
}

// AsDrillSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsDrillSource() (*DrillSource, bool) {
	return nil, false
}

// AsCouchbaseSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsCouchbaseSource() (*CouchbaseSource, bool) {
	return nil, false
}

// AsConcurSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsConcurSource() (*ConcurSource, bool) {
	return nil, false
}

// AsAzurePostgreSQLSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsAzurePostgreSQLSource() (*AzurePostgreSQLSource, bool) {
	return nil, false
}

// AsAmazonMWSSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsAmazonMWSSource() (*AmazonMWSSource, bool) {
	return nil, false
}

// AsHTTPSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsHTTPSource() (*HTTPSource, bool) {
	return nil, false
}

// AsAzureBlobFSSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsAzureBlobFSSource() (*AzureBlobFSSource, bool) {
	return nil, false
}

// AsAzureDataLakeStoreSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsAzureDataLakeStoreSource() (*AzureDataLakeStoreSource, bool) {
	return nil, false
}

// AsOffice365Source is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsOffice365Source() (*Office365Source, bool) {
	return nil, false
}

// AsCosmosDbMongoDbAPISource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsCosmosDbMongoDbAPISource() (*CosmosDbMongoDbAPISource, bool) {
	return nil, false
}

// AsMongoDbV2Source is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsMongoDbV2Source() (*MongoDbV2Source, bool) {
	return nil, false
}

// AsMongoDbSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsMongoDbSource() (*MongoDbSource, bool) {
	return nil, false
}

// AsCassandraSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsCassandraSource() (*CassandraSource, bool) {
	return nil, false
}

// AsWebSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsWebSource() (*WebSource, bool) {
	return nil, false
}

// AsOracleSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsOracleSource() (*OracleSource, bool) {
	return nil, false
}

// AsAzureDataExplorerSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsAzureDataExplorerSource() (*AzureDataExplorerSource, bool) {
	return nil, false
}

// AsAzureMySQLSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsAzureMySQLSource() (*AzureMySQLSource, bool) {
	return &amss, true
}

// AsHdfsSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsHdfsSource() (*HdfsSource, bool) {
	return nil, false
}

// AsFileSystemSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsFileSystemSource() (*FileSystemSource, bool) {
	return nil, false
}

// AsSQLDWSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsSQLDWSource() (*SQLDWSource, bool) {
	return nil, false
}

// AsSQLSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsSQLSource() (*SQLSource, bool) {
	return nil, false
}

// AsRestSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsRestSource() (*RestSource, bool) {
	return nil, false
}

// AsSapOpenHubSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsSapOpenHubSource() (*SapOpenHubSource, bool) {
	return nil, false
}

// AsSapEccSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsSapEccSource() (*SapEccSource, bool) {
	return nil, false
}

// AsSapCloudForCustomerSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsSapCloudForCustomerSource() (*SapCloudForCustomerSource, bool) {
	return nil, false
}

// AsSalesforceSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsSalesforceSource() (*SalesforceSource, bool) {
	return nil, false
}

// AsRelationalSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsRelationalSource() (*RelationalSource, bool) {
	return nil, false
}

// AsDynamicsSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsDynamicsSource() (*DynamicsSource, bool) {
	return nil, false
}

// AsDocumentDbCollectionSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsDocumentDbCollectionSource() (*DocumentDbCollectionSource, bool) {
	return nil, false
}

// AsBlobSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsBlobSource() (*BlobSource, bool) {
	return nil, false
}

// AsAzureTableSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsAzureTableSource() (*AzureTableSource, bool) {
	return nil, false
}

// AsCopySource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsCopySource() (*CopySource, bool) {
	return nil, false
}

// AsBasicCopySource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsBasicCopySource() (BasicCopySource, bool) {
	return &amss, true
}

// UnmarshalJSON is the custom unmarshaler for AzureMySQLSource struct.
func (amss *AzureMySQLSource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "query":
			if v != nil {
				var query interface{}
				err = json.Unmarshal(*v, &query)
				if err != nil {
					return err
				}
				amss.Query = query
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if amss.AdditionalProperties == nil {
					amss.AdditionalProperties = make(map[string]interface{})
				}
				amss.AdditionalProperties[k] = additionalProperties
			}
		case "sourceRetryCount":
			if v != nil {
				var sourceRetryCount interface{}
				err = json.Unmarshal(*v, &sourceRetryCount)
				if err != nil {
					return err
				}
				amss.SourceRetryCount = sourceRetryCount
			}
		case "sourceRetryWait":
			if v != nil {
				var sourceRetryWait interface{}
				err = json.Unmarshal(*v, &sourceRetryWait)
				if err != nil {
					return err
				}
				amss.SourceRetryWait = sourceRetryWait
			}
		case "maxConcurrentConnections":
			if v != nil {
				var maxConcurrentConnections interface{}
				err = json.Unmarshal(*v, &maxConcurrentConnections)
				if err != nil {
					return err
				}
				amss.MaxConcurrentConnections = maxConcurrentConnections
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicCopySource
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				amss.Type = typeVar
			}
		}
	}

	return nil
}

// AzureMySQLTableDataset the Azure MySQL database dataset.
type AzureMySQLTableDataset struct {
	// AzureMySQLTableDatasetTypeProperties - Azure MySQL database dataset properties.
	*AzureMySQLTableDatasetTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Description - Dataset description.
	Description *string `json:"description,omitempty"`
	// Structure - Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`
	// Schema - Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType: DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`
	// LinkedServiceName - Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
	// Parameters - Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the Dataset.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Folder - The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`
	// Type - Possible values include: 'TypeDataset', 'TypeGoogleAdWordsObject', 'TypeAzureDataExplorerTable', 'TypeOracleServiceCloudObject', 'TypeDynamicsAXResource', 'TypeResponsysObject', 'TypeSalesforceMarketingCloudObject', 'TypeVerticaTable', 'TypeNetezzaTable', 'TypeZohoObject', 'TypeXeroObject', 'TypeSquareObject', 'TypeSparkObject', 'TypeShopifyObject', 'TypeServiceNowObject', 'TypeQuickBooksObject', 'TypePrestoObject', 'TypePhoenixObject', 'TypePaypalObject', 'TypeMarketoObject', 'TypeMariaDBTable', 'TypeMagentoObject', 'TypeJiraObject', 'TypeImpalaObject', 'TypeHubspotObject', 'TypeHiveObject', 'TypeHBaseObject', 'TypeGreenplumTable', 'TypeGoogleBigQueryObject', 'TypeEloquaObject', 'TypeDrillTable', 'TypeCouchbaseTable', 'TypeConcurObject', 'TypeAzurePostgreSQLTable', 'TypeAmazonMWSObject', 'TypeHTTPFile', 'TypeAzureSearchIndex', 'TypeWebTable', 'TypeRestResource', 'TypeSQLServerTable', 'TypeSapOpenHubTable', 'TypeSapEccResource', 'TypeSapCloudForCustomerResource', 'TypeSalesforceObject', 'TypeRelationalTable', 'TypeAzureMySQLTable', 'TypeOracleTable', 'TypeODataResource', 'TypeCosmosDbMongoDbAPICollection', 'TypeMongoDbV2Collection', 'TypeMongoDbCollection', 'TypeFileShare', 'TypeOffice365Table', 'TypeAzureBlobFSFile', 'TypeAzureDataLakeStoreFile', 'TypeDynamicsEntity', 'TypeDocumentDbCollection', 'TypeCustomDataset', 'TypeCassandraTable', 'TypeAzureSQLDWTable', 'TypeAzureSQLTable', 'TypeAzureTable', 'TypeAzureBlob', 'TypeAmazonS3Object'
	Type TypeBasicDataset `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) MarshalJSON() ([]byte, error) {
	amstd.Type = TypeAzureMySQLTable
	objectMap := make(map[string]interface{})
	if amstd.AzureMySQLTableDatasetTypeProperties != nil {
		objectMap["typeProperties"] = amstd.AzureMySQLTableDatasetTypeProperties
	}
	if amstd.Description != nil {
		objectMap["description"] = amstd.Description
	}
	if amstd.Structure != nil {
		objectMap["structure"] = amstd.Structure
	}
	if amstd.Schema != nil {
		objectMap["schema"] = amstd.Schema
	}
	if amstd.LinkedServiceName != nil {
		objectMap["linkedServiceName"] = amstd.LinkedServiceName
	}
	if amstd.Parameters != nil {
		objectMap["parameters"] = amstd.Parameters
	}
	if amstd.Annotations != nil {
		objectMap["annotations"] = amstd.Annotations
	}
	if amstd.Folder != nil {
		objectMap["folder"] = amstd.Folder
	}
	if amstd.Type != "" {
		objectMap["type"] = amstd.Type
	}
	for k, v := range amstd.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsGoogleAdWordsObjectDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsGoogleAdWordsObjectDataset() (*GoogleAdWordsObjectDataset, bool) {
	return nil, false
}

// AsAzureDataExplorerTableDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsAzureDataExplorerTableDataset() (*AzureDataExplorerTableDataset, bool) {
	return nil, false
}

// AsOracleServiceCloudObjectDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsOracleServiceCloudObjectDataset() (*OracleServiceCloudObjectDataset, bool) {
	return nil, false
}

// AsDynamicsAXResourceDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsDynamicsAXResourceDataset() (*DynamicsAXResourceDataset, bool) {
	return nil, false
}

// AsResponsysObjectDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsResponsysObjectDataset() (*ResponsysObjectDataset, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudObjectDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsSalesforceMarketingCloudObjectDataset() (*SalesforceMarketingCloudObjectDataset, bool) {
	return nil, false
}

// AsVerticaTableDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsVerticaTableDataset() (*VerticaTableDataset, bool) {
	return nil, false
}

// AsNetezzaTableDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsNetezzaTableDataset() (*NetezzaTableDataset, bool) {
	return nil, false
}

// AsZohoObjectDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsZohoObjectDataset() (*ZohoObjectDataset, bool) {
	return nil, false
}

// AsXeroObjectDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsXeroObjectDataset() (*XeroObjectDataset, bool) {
	return nil, false
}

// AsSquareObjectDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsSquareObjectDataset() (*SquareObjectDataset, bool) {
	return nil, false
}

// AsSparkObjectDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsSparkObjectDataset() (*SparkObjectDataset, bool) {
	return nil, false
}

// AsShopifyObjectDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsShopifyObjectDataset() (*ShopifyObjectDataset, bool) {
	return nil, false
}

// AsServiceNowObjectDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsServiceNowObjectDataset() (*ServiceNowObjectDataset, bool) {
	return nil, false
}

// AsQuickBooksObjectDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsQuickBooksObjectDataset() (*QuickBooksObjectDataset, bool) {
	return nil, false
}

// AsPrestoObjectDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsPrestoObjectDataset() (*PrestoObjectDataset, bool) {
	return nil, false
}

// AsPhoenixObjectDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsPhoenixObjectDataset() (*PhoenixObjectDataset, bool) {
	return nil, false
}

// AsPaypalObjectDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsPaypalObjectDataset() (*PaypalObjectDataset, bool) {
	return nil, false
}

// AsMarketoObjectDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsMarketoObjectDataset() (*MarketoObjectDataset, bool) {
	return nil, false
}

// AsMariaDBTableDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsMariaDBTableDataset() (*MariaDBTableDataset, bool) {
	return nil, false
}

// AsMagentoObjectDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsMagentoObjectDataset() (*MagentoObjectDataset, bool) {
	return nil, false
}

// AsJiraObjectDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsJiraObjectDataset() (*JiraObjectDataset, bool) {
	return nil, false
}

// AsImpalaObjectDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsImpalaObjectDataset() (*ImpalaObjectDataset, bool) {
	return nil, false
}

// AsHubspotObjectDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsHubspotObjectDataset() (*HubspotObjectDataset, bool) {
	return nil, false
}

// AsHiveObjectDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsHiveObjectDataset() (*HiveObjectDataset, bool) {
	return nil, false
}

// AsHBaseObjectDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsHBaseObjectDataset() (*HBaseObjectDataset, bool) {
	return nil, false
}

// AsGreenplumTableDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsGreenplumTableDataset() (*GreenplumTableDataset, bool) {
	return nil, false
}

// AsGoogleBigQueryObjectDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsGoogleBigQueryObjectDataset() (*GoogleBigQueryObjectDataset, bool) {
	return nil, false
}

// AsEloquaObjectDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsEloquaObjectDataset() (*EloquaObjectDataset, bool) {
	return nil, false
}

// AsDrillTableDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsDrillTableDataset() (*DrillTableDataset, bool) {
	return nil, false
}

// AsCouchbaseTableDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsCouchbaseTableDataset() (*CouchbaseTableDataset, bool) {
	return nil, false
}

// AsConcurObjectDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsConcurObjectDataset() (*ConcurObjectDataset, bool) {
	return nil, false
}

// AsAzurePostgreSQLTableDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsAzurePostgreSQLTableDataset() (*AzurePostgreSQLTableDataset, bool) {
	return nil, false
}

// AsAmazonMWSObjectDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsAmazonMWSObjectDataset() (*AmazonMWSObjectDataset, bool) {
	return nil, false
}

// AsHTTPDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsHTTPDataset() (*HTTPDataset, bool) {
	return nil, false
}

// AsAzureSearchIndexDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsAzureSearchIndexDataset() (*AzureSearchIndexDataset, bool) {
	return nil, false
}

// AsWebTableDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsWebTableDataset() (*WebTableDataset, bool) {
	return nil, false
}

// AsRestResourceDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsRestResourceDataset() (*RestResourceDataset, bool) {
	return nil, false
}

// AsSQLServerTableDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsSQLServerTableDataset() (*SQLServerTableDataset, bool) {
	return nil, false
}

// AsSapOpenHubTableDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsSapOpenHubTableDataset() (*SapOpenHubTableDataset, bool) {
	return nil, false
}

// AsSapEccResourceDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsSapEccResourceDataset() (*SapEccResourceDataset, bool) {
	return nil, false
}

// AsSapCloudForCustomerResourceDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsSapCloudForCustomerResourceDataset() (*SapCloudForCustomerResourceDataset, bool) {
	return nil, false
}

// AsSalesforceObjectDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsSalesforceObjectDataset() (*SalesforceObjectDataset, bool) {
	return nil, false
}

// AsRelationalTableDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsRelationalTableDataset() (*RelationalTableDataset, bool) {
	return nil, false
}

// AsAzureMySQLTableDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsAzureMySQLTableDataset() (*AzureMySQLTableDataset, bool) {
	return &amstd, true
}

// AsOracleTableDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsOracleTableDataset() (*OracleTableDataset, bool) {
	return nil, false
}

// AsODataResourceDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsODataResourceDataset() (*ODataResourceDataset, bool) {
	return nil, false
}

// AsCosmosDbMongoDbAPICollectionDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsCosmosDbMongoDbAPICollectionDataset() (*CosmosDbMongoDbAPICollectionDataset, bool) {
	return nil, false
}

// AsMongoDbV2CollectionDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsMongoDbV2CollectionDataset() (*MongoDbV2CollectionDataset, bool) {
	return nil, false
}

// AsMongoDbCollectionDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsMongoDbCollectionDataset() (*MongoDbCollectionDataset, bool) {
	return nil, false
}

// AsFileShareDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsFileShareDataset() (*FileShareDataset, bool) {
	return nil, false
}

// AsOffice365Dataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsOffice365Dataset() (*Office365Dataset, bool) {
	return nil, false
}

// AsAzureBlobFSDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsAzureBlobFSDataset() (*AzureBlobFSDataset, bool) {
	return nil, false
}

// AsAzureDataLakeStoreDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsAzureDataLakeStoreDataset() (*AzureDataLakeStoreDataset, bool) {
	return nil, false
}

// AsDynamicsEntityDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsDynamicsEntityDataset() (*DynamicsEntityDataset, bool) {
	return nil, false
}

// AsDocumentDbCollectionDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsDocumentDbCollectionDataset() (*DocumentDbCollectionDataset, bool) {
	return nil, false
}

// AsCustomDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsCustomDataset() (*CustomDataset, bool) {
	return nil, false
}

// AsCassandraTableDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsCassandraTableDataset() (*CassandraTableDataset, bool) {
	return nil, false
}

// AsAzureSQLDWTableDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsAzureSQLDWTableDataset() (*AzureSQLDWTableDataset, bool) {
	return nil, false
}

// AsAzureSQLTableDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsAzureSQLTableDataset() (*AzureSQLTableDataset, bool) {
	return nil, false
}

// AsAzureTableDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsAzureTableDataset() (*AzureTableDataset, bool) {
	return nil, false
}

// AsAzureBlobDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsAzureBlobDataset() (*AzureBlobDataset, bool) {
	return nil, false
}

// AsAmazonS3Dataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsAmazonS3Dataset() (*AmazonS3Dataset, bool) {
	return nil, false
}

// AsDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsDataset() (*Dataset, bool) {
	return nil, false
}

// AsBasicDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsBasicDataset() (BasicDataset, bool) {
	return &amstd, true
}

// UnmarshalJSON is the custom unmarshaler for AzureMySQLTableDataset struct.
func (amstd *AzureMySQLTableDataset) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var azureMySQLTableDatasetTypeProperties AzureMySQLTableDatasetTypeProperties
				err = json.Unmarshal(*v, &azureMySQLTableDatasetTypeProperties)
				if err != nil {
					return err
				}
				amstd.AzureMySQLTableDatasetTypeProperties = &azureMySQLTableDatasetTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if amstd.AdditionalProperties == nil {
					amstd.AdditionalProperties = make(map[string]interface{})
				}
				amstd.AdditionalProperties[k] = additionalProperties
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				amstd.Description = &description
			}
		case "structure":
			if v != nil {
				var structure interface{}
				err = json.Unmarshal(*v, &structure)
				if err != nil {
					return err
				}
				amstd.Structure = structure
			}
		case "schema":
			if v != nil {
				var schema interface{}
				err = json.Unmarshal(*v, &schema)
				if err != nil {
					return err
				}
				amstd.Schema = schema
			}
		case "linkedServiceName":
			if v != nil {
				var linkedServiceName LinkedServiceReference
				err = json.Unmarshal(*v, &linkedServiceName)
				if err != nil {
					return err
				}
				amstd.LinkedServiceName = &linkedServiceName
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				amstd.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				amstd.Annotations = &annotations
			}
		case "folder":
			if v != nil {
				var folder DatasetFolder
				err = json.Unmarshal(*v, &folder)
				if err != nil {
					return err
				}
				amstd.Folder = &folder
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicDataset
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				amstd.Type = typeVar
			}
		}
	}

	return nil
}

// AzureMySQLTableDatasetTypeProperties azure MySQL database dataset properties.
type AzureMySQLTableDatasetTypeProperties struct {
	// TableName - The Azure MySQL database table name. Type: string (or Expression with resultType string).
	TableName interface{} `json:"tableName,omitempty"`
}

// AzurePostgreSQLLinkedService azure PostgreSQL linked service.
type AzurePostgreSQLLinkedService struct {
	// AzurePostgreSQLLinkedServiceTypeProperties - Azure PostgreSQL linked service properties.
	*AzurePostgreSQLLinkedServiceTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Parameters - Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the linked service.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Type - Possible values include: 'TypeLinkedService', 'TypeAzureFunction', 'TypeAzureDataExplorer', 'TypeGoogleAdWords', 'TypeOracleServiceCloud', 'TypeDynamicsAX', 'TypeResponsys', 'TypeAzureDatabricks', 'TypeAzureDataLakeAnalytics', 'TypeHDInsightOnDemand', 'TypeSalesforceMarketingCloud', 'TypeNetezza', 'TypeVertica', 'TypeZoho', 'TypeXero', 'TypeSquare', 'TypeSpark', 'TypeShopify', 'TypeServiceNow', 'TypeQuickBooks', 'TypePresto', 'TypePhoenix', 'TypePaypal', 'TypeMarketo', 'TypeMariaDB', 'TypeMagento', 'TypeJira', 'TypeImpala', 'TypeHubspot', 'TypeHive', 'TypeHBase', 'TypeGreenplum', 'TypeGoogleBigQuery', 'TypeEloqua', 'TypeDrill', 'TypeCouchbase', 'TypeConcur', 'TypeAzurePostgreSQL', 'TypeAmazonMWS', 'TypeSapHana', 'TypeSapBW', 'TypeSftp', 'TypeFtpServer', 'TypeHTTPServer', 'TypeAzureSearch', 'TypeCustomDataSource', 'TypeAmazonRedshift', 'TypeAmazonS3', 'TypeRestService', 'TypeSapOpenHub', 'TypeSapEcc', 'TypeSapCloudForCustomer', 'TypeSalesforce', 'TypeOffice365', 'TypeAzureBlobFS', 'TypeAzureDataLakeStore', 'TypeCosmosDbMongoDbAPI', 'TypeMongoDbV2', 'TypeMongoDb', 'TypeCassandra', 'TypeWeb', 'TypeOData', 'TypeHdfs', 'TypeOdbc', 'TypeAzureML', 'TypeTeradata', 'TypeDb2', 'TypeSybase', 'TypePostgreSQL', 'TypeMySQL', 'TypeAzureMySQL', 'TypeOracle', 'TypeFileServer', 'TypeHDInsight', 'TypeDynamics', 'TypeCosmosDb', 'TypeAzureKeyVault', 'TypeAzureBatch', 'TypeAzureSQLDatabase', 'TypeSQLServer', 'TypeAzureSQLDW', 'TypeAzureTableStorage', 'TypeAzureBlobStorage', 'TypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) MarshalJSON() ([]byte, error) {
	apsls.Type = TypeAzurePostgreSQL
	objectMap := make(map[string]interface{})
	if apsls.AzurePostgreSQLLinkedServiceTypeProperties != nil {
		objectMap["typeProperties"] = apsls.AzurePostgreSQLLinkedServiceTypeProperties
	}
	if apsls.ConnectVia != nil {
		objectMap["connectVia"] = apsls.ConnectVia
	}
	if apsls.Description != nil {
		objectMap["description"] = apsls.Description
	}
	if apsls.Parameters != nil {
		objectMap["parameters"] = apsls.Parameters
	}
	if apsls.Annotations != nil {
		objectMap["annotations"] = apsls.Annotations
	}
	if apsls.Type != "" {
		objectMap["type"] = apsls.Type
	}
	for k, v := range apsls.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsAzureFunctionLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsAzureFunctionLinkedService() (*AzureFunctionLinkedService, bool) {
	return nil, false
}

// AsAzureDataExplorerLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsAzureDataExplorerLinkedService() (*AzureDataExplorerLinkedService, bool) {
	return nil, false
}

// AsGoogleAdWordsLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsGoogleAdWordsLinkedService() (*GoogleAdWordsLinkedService, bool) {
	return nil, false
}

// AsOracleServiceCloudLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsOracleServiceCloudLinkedService() (*OracleServiceCloudLinkedService, bool) {
	return nil, false
}

// AsDynamicsAXLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsDynamicsAXLinkedService() (*DynamicsAXLinkedService, bool) {
	return nil, false
}

// AsResponsysLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsResponsysLinkedService() (*ResponsysLinkedService, bool) {
	return nil, false
}

// AsAzureDatabricksLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsAzureDatabricksLinkedService() (*AzureDatabricksLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return nil, false
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsSalesforceMarketingCloudLinkedService() (*SalesforceMarketingCloudLinkedService, bool) {
	return nil, false
}

// AsNetezzaLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsNetezzaLinkedService() (*NetezzaLinkedService, bool) {
	return nil, false
}

// AsVerticaLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsVerticaLinkedService() (*VerticaLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return nil, false
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return nil, false
}

// AsConcurLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return nil, false
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return &apsls, true
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return nil, false
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return nil, false
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return nil, false
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return nil, false
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return nil, false
}

// AsRestServiceLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsRestServiceLinkedService() (*RestServiceLinkedService, bool) {
	return nil, false
}

// AsSapOpenHubLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsSapOpenHubLinkedService() (*SapOpenHubLinkedService, bool) {
	return nil, false
}

// AsSapEccLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsSapEccLinkedService() (*SapEccLinkedService, bool) {
	return nil, false
}

// AsSapCloudForCustomerLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsSapCloudForCustomerLinkedService() (*SapCloudForCustomerLinkedService, bool) {
	return nil, false
}

// AsSalesforceLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsSalesforceLinkedService() (*SalesforceLinkedService, bool) {
	return nil, false
}

// AsOffice365LinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsOffice365LinkedService() (*Office365LinkedService, bool) {
	return nil, false
}

// AsAzureBlobFSLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsAzureBlobFSLinkedService() (*AzureBlobFSLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsAzureDataLakeStoreLinkedService() (*AzureDataLakeStoreLinkedService, bool) {
	return nil, false
}

// AsCosmosDbMongoDbAPILinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsCosmosDbMongoDbAPILinkedService() (*CosmosDbMongoDbAPILinkedService, bool) {
	return nil, false
}

// AsMongoDbV2LinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsMongoDbV2LinkedService() (*MongoDbV2LinkedService, bool) {
	return nil, false
}

// AsMongoDbLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsMongoDbLinkedService() (*MongoDbLinkedService, bool) {
	return nil, false
}

// AsCassandraLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsCassandraLinkedService() (*CassandraLinkedService, bool) {
	return nil, false
}

// AsWebLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsWebLinkedService() (*WebLinkedService, bool) {
	return nil, false
}

// AsODataLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsODataLinkedService() (*ODataLinkedService, bool) {
	return nil, false
}

// AsHdfsLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsHdfsLinkedService() (*HdfsLinkedService, bool) {
	return nil, false
}

// AsOdbcLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsOdbcLinkedService() (*OdbcLinkedService, bool) {
	return nil, false
}

// AsAzureMLLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsAzureMLLinkedService() (*AzureMLLinkedService, bool) {
	return nil, false
}

// AsTeradataLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsTeradataLinkedService() (*TeradataLinkedService, bool) {
	return nil, false
}

// AsDb2LinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsDb2LinkedService() (*Db2LinkedService, bool) {
	return nil, false
}

// AsSybaseLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsSybaseLinkedService() (*SybaseLinkedService, bool) {
	return nil, false
}

// AsPostgreSQLLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsPostgreSQLLinkedService() (*PostgreSQLLinkedService, bool) {
	return nil, false
}

// AsMySQLLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsMySQLLinkedService() (*MySQLLinkedService, bool) {
	return nil, false
}

// AsAzureMySQLLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsAzureMySQLLinkedService() (*AzureMySQLLinkedService, bool) {
	return nil, false
}

// AsOracleLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsOracleLinkedService() (*OracleLinkedService, bool) {
	return nil, false
}

// AsFileServerLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsFileServerLinkedService() (*FileServerLinkedService, bool) {
	return nil, false
}

// AsHDInsightLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsHDInsightLinkedService() (*HDInsightLinkedService, bool) {
	return nil, false
}

// AsDynamicsLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsDynamicsLinkedService() (*DynamicsLinkedService, bool) {
	return nil, false
}

// AsCosmosDbLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsCosmosDbLinkedService() (*CosmosDbLinkedService, bool) {
	return nil, false
}

// AsAzureKeyVaultLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsAzureKeyVaultLinkedService() (*AzureKeyVaultLinkedService, bool) {
	return nil, false
}

// AsAzureBatchLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsAzureBatchLinkedService() (*AzureBatchLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDatabaseLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsAzureSQLDatabaseLinkedService() (*AzureSQLDatabaseLinkedService, bool) {
	return nil, false
}

// AsSQLServerLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsSQLServerLinkedService() (*SQLServerLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDWLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsAzureSQLDWLinkedService() (*AzureSQLDWLinkedService, bool) {
	return nil, false
}

// AsAzureTableStorageLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsAzureTableStorageLinkedService() (*AzureTableStorageLinkedService, bool) {
	return nil, false
}

// AsAzureBlobStorageLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsAzureBlobStorageLinkedService() (*AzureBlobStorageLinkedService, bool) {
	return nil, false
}

// AsAzureStorageLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsAzureStorageLinkedService() (*AzureStorageLinkedService, bool) {
	return nil, false
}

// AsLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsLinkedService() (*LinkedService, bool) {
	return nil, false
}

// AsBasicLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsBasicLinkedService() (BasicLinkedService, bool) {
	return &apsls, true
}

// UnmarshalJSON is the custom unmarshaler for AzurePostgreSQLLinkedService struct.
func (apsls *AzurePostgreSQLLinkedService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var azurePostgreSQLLinkedServiceTypeProperties AzurePostgreSQLLinkedServiceTypeProperties
				err = json.Unmarshal(*v, &azurePostgreSQLLinkedServiceTypeProperties)
				if err != nil {
					return err
				}
				apsls.AzurePostgreSQLLinkedServiceTypeProperties = &azurePostgreSQLLinkedServiceTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if apsls.AdditionalProperties == nil {
					apsls.AdditionalProperties = make(map[string]interface{})
				}
				apsls.AdditionalProperties[k] = additionalProperties
			}
		case "connectVia":
			if v != nil {
				var connectVia IntegrationRuntimeReference
				err = json.Unmarshal(*v, &connectVia)
				if err != nil {
					return err
				}
				apsls.ConnectVia = &connectVia
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				apsls.Description = &description
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				apsls.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				apsls.Annotations = &annotations
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicLinkedService
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				apsls.Type = typeVar
			}
		}
	}

	return nil
}

// AzurePostgreSQLLinkedServiceTypeProperties azure PostgreSQL linked service properties.
type AzurePostgreSQLLinkedServiceTypeProperties struct {
	// ConnectionString - An ODBC connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
	ConnectionString interface{} `json:"connectionString,omitempty"`
	// Password - The Azure key vault secret reference of password in connection string.
	Password *AzureKeyVaultSecretReference `json:"password,omitempty"`
	// EncryptedCredential - The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`
}

// AzurePostgreSQLSource a copy activity Azure PostgreSQL source.
type AzurePostgreSQLSource struct {
	// Query - A query to retrieve data from source. Type: string (or Expression with resultType string).
	Query interface{} `json:"query,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// SourceRetryCount - Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`
	// SourceRetryWait - Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
	// MaxConcurrentConnections - The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`
	// Type - Possible values include: 'TypeCopySource', 'TypeAmazonRedshiftSource', 'TypeGoogleAdWordsSource', 'TypeOracleServiceCloudSource', 'TypeDynamicsAXSource', 'TypeResponsysSource', 'TypeSalesforceMarketingCloudSource', 'TypeVerticaSource', 'TypeNetezzaSource', 'TypeZohoSource', 'TypeXeroSource', 'TypeSquareSource', 'TypeSparkSource', 'TypeShopifySource', 'TypeServiceNowSource', 'TypeQuickBooksSource', 'TypePrestoSource', 'TypePhoenixSource', 'TypePaypalSource', 'TypeMarketoSource', 'TypeMariaDBSource', 'TypeMagentoSource', 'TypeJiraSource', 'TypeImpalaSource', 'TypeHubspotSource', 'TypeHiveSource', 'TypeHBaseSource', 'TypeGreenplumSource', 'TypeGoogleBigQuerySource', 'TypeEloquaSource', 'TypeDrillSource', 'TypeCouchbaseSource', 'TypeConcurSource', 'TypeAzurePostgreSQLSource', 'TypeAmazonMWSSource', 'TypeHTTPSource', 'TypeAzureBlobFSSource', 'TypeAzureDataLakeStoreSource', 'TypeOffice365Source', 'TypeCosmosDbMongoDbAPISource', 'TypeMongoDbV2Source', 'TypeMongoDbSource', 'TypeCassandraSource', 'TypeWebSource', 'TypeOracleSource', 'TypeAzureDataExplorerSource', 'TypeAzureMySQLSource', 'TypeHdfsSource', 'TypeFileSystemSource', 'TypeSQLDWSource', 'TypeSQLSource', 'TypeRestSource', 'TypeSapOpenHubSource', 'TypeSapEccSource', 'TypeSapCloudForCustomerSource', 'TypeSalesforceSource', 'TypeRelationalSource', 'TypeDynamicsSource', 'TypeDocumentDbCollectionSource', 'TypeBlobSource', 'TypeAzureTableSource'
	Type TypeBasicCopySource `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) MarshalJSON() ([]byte, error) {
	apss.Type = TypeAzurePostgreSQLSource
	objectMap := make(map[string]interface{})
	if apss.Query != nil {
		objectMap["query"] = apss.Query
	}
	if apss.SourceRetryCount != nil {
		objectMap["sourceRetryCount"] = apss.SourceRetryCount
	}
	if apss.SourceRetryWait != nil {
		objectMap["sourceRetryWait"] = apss.SourceRetryWait
	}
	if apss.MaxConcurrentConnections != nil {
		objectMap["maxConcurrentConnections"] = apss.MaxConcurrentConnections
	}
	if apss.Type != "" {
		objectMap["type"] = apss.Type
	}
	for k, v := range apss.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsAmazonRedshiftSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsAmazonRedshiftSource() (*AmazonRedshiftSource, bool) {
	return nil, false
}

// AsGoogleAdWordsSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsGoogleAdWordsSource() (*GoogleAdWordsSource, bool) {
	return nil, false
}

// AsOracleServiceCloudSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsOracleServiceCloudSource() (*OracleServiceCloudSource, bool) {
	return nil, false
}

// AsDynamicsAXSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsDynamicsAXSource() (*DynamicsAXSource, bool) {
	return nil, false
}

// AsResponsysSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsResponsysSource() (*ResponsysSource, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsSalesforceMarketingCloudSource() (*SalesforceMarketingCloudSource, bool) {
	return nil, false
}

// AsVerticaSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsVerticaSource() (*VerticaSource, bool) {
	return nil, false
}

// AsNetezzaSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsNetezzaSource() (*NetezzaSource, bool) {
	return nil, false
}

// AsZohoSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsZohoSource() (*ZohoSource, bool) {
	return nil, false
}

// AsXeroSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsXeroSource() (*XeroSource, bool) {
	return nil, false
}

// AsSquareSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsSquareSource() (*SquareSource, bool) {
	return nil, false
}

// AsSparkSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsSparkSource() (*SparkSource, bool) {
	return nil, false
}

// AsShopifySource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsShopifySource() (*ShopifySource, bool) {
	return nil, false
}

// AsServiceNowSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsServiceNowSource() (*ServiceNowSource, bool) {
	return nil, false
}

// AsQuickBooksSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsQuickBooksSource() (*QuickBooksSource, bool) {
	return nil, false
}

// AsPrestoSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsPrestoSource() (*PrestoSource, bool) {
	return nil, false
}

// AsPhoenixSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsPhoenixSource() (*PhoenixSource, bool) {
	return nil, false
}

// AsPaypalSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsPaypalSource() (*PaypalSource, bool) {
	return nil, false
}

// AsMarketoSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsMarketoSource() (*MarketoSource, bool) {
	return nil, false
}

// AsMariaDBSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsMariaDBSource() (*MariaDBSource, bool) {
	return nil, false
}

// AsMagentoSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsMagentoSource() (*MagentoSource, bool) {
	return nil, false
}

// AsJiraSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsJiraSource() (*JiraSource, bool) {
	return nil, false
}

// AsImpalaSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsImpalaSource() (*ImpalaSource, bool) {
	return nil, false
}

// AsHubspotSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsHubspotSource() (*HubspotSource, bool) {
	return nil, false
}

// AsHiveSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsHiveSource() (*HiveSource, bool) {
	return nil, false
}

// AsHBaseSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsHBaseSource() (*HBaseSource, bool) {
	return nil, false
}

// AsGreenplumSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsGreenplumSource() (*GreenplumSource, bool) {
	return nil, false
}

// AsGoogleBigQuerySource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsGoogleBigQuerySource() (*GoogleBigQuerySource, bool) {
	return nil, false
}

// AsEloquaSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsEloquaSource() (*EloquaSource, bool) {
	return nil, false
}

// AsDrillSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsDrillSource() (*DrillSource, bool) {
	return nil, false
}

// AsCouchbaseSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsCouchbaseSource() (*CouchbaseSource, bool) {
	return nil, false
}

// AsConcurSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsConcurSource() (*ConcurSource, bool) {
	return nil, false
}

// AsAzurePostgreSQLSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsAzurePostgreSQLSource() (*AzurePostgreSQLSource, bool) {
	return &apss, true
}

// AsAmazonMWSSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsAmazonMWSSource() (*AmazonMWSSource, bool) {
	return nil, false
}

// AsHTTPSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsHTTPSource() (*HTTPSource, bool) {
	return nil, false
}

// AsAzureBlobFSSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsAzureBlobFSSource() (*AzureBlobFSSource, bool) {
	return nil, false
}

// AsAzureDataLakeStoreSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsAzureDataLakeStoreSource() (*AzureDataLakeStoreSource, bool) {
	return nil, false
}

// AsOffice365Source is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsOffice365Source() (*Office365Source, bool) {
	return nil, false
}

// AsCosmosDbMongoDbAPISource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsCosmosDbMongoDbAPISource() (*CosmosDbMongoDbAPISource, bool) {
	return nil, false
}

// AsMongoDbV2Source is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsMongoDbV2Source() (*MongoDbV2Source, bool) {
	return nil, false
}

// AsMongoDbSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsMongoDbSource() (*MongoDbSource, bool) {
	return nil, false
}

// AsCassandraSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsCassandraSource() (*CassandraSource, bool) {
	return nil, false
}

// AsWebSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsWebSource() (*WebSource, bool) {
	return nil, false
}

// AsOracleSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsOracleSource() (*OracleSource, bool) {
	return nil, false
}

// AsAzureDataExplorerSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsAzureDataExplorerSource() (*AzureDataExplorerSource, bool) {
	return nil, false
}

// AsAzureMySQLSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsAzureMySQLSource() (*AzureMySQLSource, bool) {
	return nil, false
}

// AsHdfsSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsHdfsSource() (*HdfsSource, bool) {
	return nil, false
}

// AsFileSystemSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsFileSystemSource() (*FileSystemSource, bool) {
	return nil, false
}

// AsSQLDWSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsSQLDWSource() (*SQLDWSource, bool) {
	return nil, false
}

// AsSQLSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsSQLSource() (*SQLSource, bool) {
	return nil, false
}

// AsRestSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsRestSource() (*RestSource, bool) {
	return nil, false
}

// AsSapOpenHubSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsSapOpenHubSource() (*SapOpenHubSource, bool) {
	return nil, false
}

// AsSapEccSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsSapEccSource() (*SapEccSource, bool) {
	return nil, false
}

// AsSapCloudForCustomerSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsSapCloudForCustomerSource() (*SapCloudForCustomerSource, bool) {
	return nil, false
}

// AsSalesforceSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsSalesforceSource() (*SalesforceSource, bool) {
	return nil, false
}

// AsRelationalSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsRelationalSource() (*RelationalSource, bool) {
	return nil, false
}

// AsDynamicsSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsDynamicsSource() (*DynamicsSource, bool) {
	return nil, false
}

// AsDocumentDbCollectionSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsDocumentDbCollectionSource() (*DocumentDbCollectionSource, bool) {
	return nil, false
}

// AsBlobSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsBlobSource() (*BlobSource, bool) {
	return nil, false
}

// AsAzureTableSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsAzureTableSource() (*AzureTableSource, bool) {
	return nil, false
}

// AsCopySource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsCopySource() (*CopySource, bool) {
	return nil, false
}

// AsBasicCopySource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsBasicCopySource() (BasicCopySource, bool) {
	return &apss, true
}

// UnmarshalJSON is the custom unmarshaler for AzurePostgreSQLSource struct.
func (apss *AzurePostgreSQLSource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "query":
			if v != nil {
				var query interface{}
				err = json.Unmarshal(*v, &query)
				if err != nil {
					return err
				}
				apss.Query = query
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if apss.AdditionalProperties == nil {
					apss.AdditionalProperties = make(map[string]interface{})
				}
				apss.AdditionalProperties[k] = additionalProperties
			}
		case "sourceRetryCount":
			if v != nil {
				var sourceRetryCount interface{}
				err = json.Unmarshal(*v, &sourceRetryCount)
				if err != nil {
					return err
				}
				apss.SourceRetryCount = sourceRetryCount
			}
		case "sourceRetryWait":
			if v != nil {
				var sourceRetryWait interface{}
				err = json.Unmarshal(*v, &sourceRetryWait)
				if err != nil {
					return err
				}
				apss.SourceRetryWait = sourceRetryWait
			}
		case "maxConcurrentConnections":
			if v != nil {
				var maxConcurrentConnections interface{}
				err = json.Unmarshal(*v, &maxConcurrentConnections)
				if err != nil {
					return err
				}
				apss.MaxConcurrentConnections = maxConcurrentConnections
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicCopySource
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				apss.Type = typeVar
			}
		}
	}

	return nil
}

// AzurePostgreSQLTableDataset azure PostgreSQL dataset.
type AzurePostgreSQLTableDataset struct {
	// GenericDatasetTypeProperties - Properties specific to this dataset type.
	*GenericDatasetTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Description - Dataset description.
	Description *string `json:"description,omitempty"`
	// Structure - Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`
	// Schema - Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType: DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`
	// LinkedServiceName - Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
	// Parameters - Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the Dataset.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Folder - The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`
	// Type - Possible values include: 'TypeDataset', 'TypeGoogleAdWordsObject', 'TypeAzureDataExplorerTable', 'TypeOracleServiceCloudObject', 'TypeDynamicsAXResource', 'TypeResponsysObject', 'TypeSalesforceMarketingCloudObject', 'TypeVerticaTable', 'TypeNetezzaTable', 'TypeZohoObject', 'TypeXeroObject', 'TypeSquareObject', 'TypeSparkObject', 'TypeShopifyObject', 'TypeServiceNowObject', 'TypeQuickBooksObject', 'TypePrestoObject', 'TypePhoenixObject', 'TypePaypalObject', 'TypeMarketoObject', 'TypeMariaDBTable', 'TypeMagentoObject', 'TypeJiraObject', 'TypeImpalaObject', 'TypeHubspotObject', 'TypeHiveObject', 'TypeHBaseObject', 'TypeGreenplumTable', 'TypeGoogleBigQueryObject', 'TypeEloquaObject', 'TypeDrillTable', 'TypeCouchbaseTable', 'TypeConcurObject', 'TypeAzurePostgreSQLTable', 'TypeAmazonMWSObject', 'TypeHTTPFile', 'TypeAzureSearchIndex', 'TypeWebTable', 'TypeRestResource', 'TypeSQLServerTable', 'TypeSapOpenHubTable', 'TypeSapEccResource', 'TypeSapCloudForCustomerResource', 'TypeSalesforceObject', 'TypeRelationalTable', 'TypeAzureMySQLTable', 'TypeOracleTable', 'TypeODataResource', 'TypeCosmosDbMongoDbAPICollection', 'TypeMongoDbV2Collection', 'TypeMongoDbCollection', 'TypeFileShare', 'TypeOffice365Table', 'TypeAzureBlobFSFile', 'TypeAzureDataLakeStoreFile', 'TypeDynamicsEntity', 'TypeDocumentDbCollection', 'TypeCustomDataset', 'TypeCassandraTable', 'TypeAzureSQLDWTable', 'TypeAzureSQLTable', 'TypeAzureTable', 'TypeAzureBlob', 'TypeAmazonS3Object'
	Type TypeBasicDataset `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) MarshalJSON() ([]byte, error) {
	apstd.Type = TypeAzurePostgreSQLTable
	objectMap := make(map[string]interface{})
	if apstd.GenericDatasetTypeProperties != nil {
		objectMap["typeProperties"] = apstd.GenericDatasetTypeProperties
	}
	if apstd.Description != nil {
		objectMap["description"] = apstd.Description
	}
	if apstd.Structure != nil {
		objectMap["structure"] = apstd.Structure
	}
	if apstd.Schema != nil {
		objectMap["schema"] = apstd.Schema
	}
	if apstd.LinkedServiceName != nil {
		objectMap["linkedServiceName"] = apstd.LinkedServiceName
	}
	if apstd.Parameters != nil {
		objectMap["parameters"] = apstd.Parameters
	}
	if apstd.Annotations != nil {
		objectMap["annotations"] = apstd.Annotations
	}
	if apstd.Folder != nil {
		objectMap["folder"] = apstd.Folder
	}
	if apstd.Type != "" {
		objectMap["type"] = apstd.Type
	}
	for k, v := range apstd.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsGoogleAdWordsObjectDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsGoogleAdWordsObjectDataset() (*GoogleAdWordsObjectDataset, bool) {
	return nil, false
}

// AsAzureDataExplorerTableDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsAzureDataExplorerTableDataset() (*AzureDataExplorerTableDataset, bool) {
	return nil, false
}

// AsOracleServiceCloudObjectDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsOracleServiceCloudObjectDataset() (*OracleServiceCloudObjectDataset, bool) {
	return nil, false
}

// AsDynamicsAXResourceDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsDynamicsAXResourceDataset() (*DynamicsAXResourceDataset, bool) {
	return nil, false
}

// AsResponsysObjectDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsResponsysObjectDataset() (*ResponsysObjectDataset, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudObjectDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsSalesforceMarketingCloudObjectDataset() (*SalesforceMarketingCloudObjectDataset, bool) {
	return nil, false
}

// AsVerticaTableDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsVerticaTableDataset() (*VerticaTableDataset, bool) {
	return nil, false
}

// AsNetezzaTableDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsNetezzaTableDataset() (*NetezzaTableDataset, bool) {
	return nil, false
}

// AsZohoObjectDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsZohoObjectDataset() (*ZohoObjectDataset, bool) {
	return nil, false
}

// AsXeroObjectDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsXeroObjectDataset() (*XeroObjectDataset, bool) {
	return nil, false
}

// AsSquareObjectDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsSquareObjectDataset() (*SquareObjectDataset, bool) {
	return nil, false
}

// AsSparkObjectDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsSparkObjectDataset() (*SparkObjectDataset, bool) {
	return nil, false
}

// AsShopifyObjectDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsShopifyObjectDataset() (*ShopifyObjectDataset, bool) {
	return nil, false
}

// AsServiceNowObjectDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsServiceNowObjectDataset() (*ServiceNowObjectDataset, bool) {
	return nil, false
}

// AsQuickBooksObjectDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsQuickBooksObjectDataset() (*QuickBooksObjectDataset, bool) {
	return nil, false
}

// AsPrestoObjectDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsPrestoObjectDataset() (*PrestoObjectDataset, bool) {
	return nil, false
}

// AsPhoenixObjectDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsPhoenixObjectDataset() (*PhoenixObjectDataset, bool) {
	return nil, false
}

// AsPaypalObjectDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsPaypalObjectDataset() (*PaypalObjectDataset, bool) {
	return nil, false
}

// AsMarketoObjectDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsMarketoObjectDataset() (*MarketoObjectDataset, bool) {
	return nil, false
}

// AsMariaDBTableDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsMariaDBTableDataset() (*MariaDBTableDataset, bool) {
	return nil, false
}

// AsMagentoObjectDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsMagentoObjectDataset() (*MagentoObjectDataset, bool) {
	return nil, false
}

// AsJiraObjectDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsJiraObjectDataset() (*JiraObjectDataset, bool) {
	return nil, false
}

// AsImpalaObjectDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsImpalaObjectDataset() (*ImpalaObjectDataset, bool) {
	return nil, false
}

// AsHubspotObjectDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsHubspotObjectDataset() (*HubspotObjectDataset, bool) {
	return nil, false
}

// AsHiveObjectDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsHiveObjectDataset() (*HiveObjectDataset, bool) {
	return nil, false
}

// AsHBaseObjectDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsHBaseObjectDataset() (*HBaseObjectDataset, bool) {
	return nil, false
}

// AsGreenplumTableDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsGreenplumTableDataset() (*GreenplumTableDataset, bool) {
	return nil, false
}

// AsGoogleBigQueryObjectDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsGoogleBigQueryObjectDataset() (*GoogleBigQueryObjectDataset, bool) {
	return nil, false
}

// AsEloquaObjectDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsEloquaObjectDataset() (*EloquaObjectDataset, bool) {
	return nil, false
}

// AsDrillTableDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsDrillTableDataset() (*DrillTableDataset, bool) {
	return nil, false
}

// AsCouchbaseTableDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsCouchbaseTableDataset() (*CouchbaseTableDataset, bool) {
	return nil, false
}

// AsConcurObjectDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsConcurObjectDataset() (*ConcurObjectDataset, bool) {
	return nil, false
}

// AsAzurePostgreSQLTableDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsAzurePostgreSQLTableDataset() (*AzurePostgreSQLTableDataset, bool) {
	return &apstd, true
}

// AsAmazonMWSObjectDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsAmazonMWSObjectDataset() (*AmazonMWSObjectDataset, bool) {
	return nil, false
}

// AsHTTPDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsHTTPDataset() (*HTTPDataset, bool) {
	return nil, false
}

// AsAzureSearchIndexDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsAzureSearchIndexDataset() (*AzureSearchIndexDataset, bool) {
	return nil, false
}

// AsWebTableDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsWebTableDataset() (*WebTableDataset, bool) {
	return nil, false
}

// AsRestResourceDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsRestResourceDataset() (*RestResourceDataset, bool) {
	return nil, false
}

// AsSQLServerTableDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsSQLServerTableDataset() (*SQLServerTableDataset, bool) {
	return nil, false
}

// AsSapOpenHubTableDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsSapOpenHubTableDataset() (*SapOpenHubTableDataset, bool) {
	return nil, false
}

// AsSapEccResourceDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsSapEccResourceDataset() (*SapEccResourceDataset, bool) {
	return nil, false
}

// AsSapCloudForCustomerResourceDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsSapCloudForCustomerResourceDataset() (*SapCloudForCustomerResourceDataset, bool) {
	return nil, false
}

// AsSalesforceObjectDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsSalesforceObjectDataset() (*SalesforceObjectDataset, bool) {
	return nil, false
}

// AsRelationalTableDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsRelationalTableDataset() (*RelationalTableDataset, bool) {
	return nil, false
}

// AsAzureMySQLTableDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsAzureMySQLTableDataset() (*AzureMySQLTableDataset, bool) {
	return nil, false
}

// AsOracleTableDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsOracleTableDataset() (*OracleTableDataset, bool) {
	return nil, false
}

// AsODataResourceDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsODataResourceDataset() (*ODataResourceDataset, bool) {
	return nil, false
}

// AsCosmosDbMongoDbAPICollectionDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsCosmosDbMongoDbAPICollectionDataset() (*CosmosDbMongoDbAPICollectionDataset, bool) {
	return nil, false
}

// AsMongoDbV2CollectionDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsMongoDbV2CollectionDataset() (*MongoDbV2CollectionDataset, bool) {
	return nil, false
}

// AsMongoDbCollectionDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsMongoDbCollectionDataset() (*MongoDbCollectionDataset, bool) {
	return nil, false
}

// AsFileShareDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsFileShareDataset() (*FileShareDataset, bool) {
	return nil, false
}

// AsOffice365Dataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsOffice365Dataset() (*Office365Dataset, bool) {
	return nil, false
}

// AsAzureBlobFSDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsAzureBlobFSDataset() (*AzureBlobFSDataset, bool) {
	return nil, false
}

// AsAzureDataLakeStoreDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsAzureDataLakeStoreDataset() (*AzureDataLakeStoreDataset, bool) {
	return nil, false
}

// AsDynamicsEntityDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsDynamicsEntityDataset() (*DynamicsEntityDataset, bool) {
	return nil, false
}

// AsDocumentDbCollectionDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsDocumentDbCollectionDataset() (*DocumentDbCollectionDataset, bool) {
	return nil, false
}

// AsCustomDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsCustomDataset() (*CustomDataset, bool) {
	return nil, false
}

// AsCassandraTableDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsCassandraTableDataset() (*CassandraTableDataset, bool) {
	return nil, false
}

// AsAzureSQLDWTableDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsAzureSQLDWTableDataset() (*AzureSQLDWTableDataset, bool) {
	return nil, false
}

// AsAzureSQLTableDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsAzureSQLTableDataset() (*AzureSQLTableDataset, bool) {
	return nil, false
}

// AsAzureTableDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsAzureTableDataset() (*AzureTableDataset, bool) {
	return nil, false
}

// AsAzureBlobDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsAzureBlobDataset() (*AzureBlobDataset, bool) {
	return nil, false
}

// AsAmazonS3Dataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsAmazonS3Dataset() (*AmazonS3Dataset, bool) {
	return nil, false
}

// AsDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsDataset() (*Dataset, bool) {
	return nil, false
}

// AsBasicDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsBasicDataset() (BasicDataset, bool) {
	return &apstd, true
}

// UnmarshalJSON is the custom unmarshaler for AzurePostgreSQLTableDataset struct.
func (apstd *AzurePostgreSQLTableDataset) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var genericDatasetTypeProperties GenericDatasetTypeProperties
				err = json.Unmarshal(*v, &genericDatasetTypeProperties)
				if err != nil {
					return err
				}
				apstd.GenericDatasetTypeProperties = &genericDatasetTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if apstd.AdditionalProperties == nil {
					apstd.AdditionalProperties = make(map[string]interface{})
				}
				apstd.AdditionalProperties[k] = additionalProperties
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				apstd.Description = &description
			}
		case "structure":
			if v != nil {
				var structure interface{}
				err = json.Unmarshal(*v, &structure)
				if err != nil {
					return err
				}
				apstd.Structure = structure
			}
		case "schema":
			if v != nil {
				var schema interface{}
				err = json.Unmarshal(*v, &schema)
				if err != nil {
					return err
				}
				apstd.Schema = schema
			}
		case "linkedServiceName":
			if v != nil {
				var linkedServiceName LinkedServiceReference
				err = json.Unmarshal(*v, &linkedServiceName)
				if err != nil {
					return err
				}
				apstd.LinkedServiceName = &linkedServiceName
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				apstd.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				apstd.Annotations = &annotations
			}
		case "folder":
			if v != nil {
				var folder DatasetFolder
				err = json.Unmarshal(*v, &folder)
				if err != nil {
					return err
				}
				apstd.Folder = &folder
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicDataset
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				apstd.Type = typeVar
			}
		}
	}

	return nil
}

// AzureQueueSink a copy activity Azure Queue sink.
type AzureQueueSink struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// WriteBatchSize - Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize interface{} `json:"writeBatchSize,omitempty"`
	// WriteBatchTimeout - Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout interface{} `json:"writeBatchTimeout,omitempty"`
	// SinkRetryCount - Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount interface{} `json:"sinkRetryCount,omitempty"`
	// SinkRetryWait - Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait interface{} `json:"sinkRetryWait,omitempty"`
	// MaxConcurrentConnections - The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`
	// Type - Possible values include: 'TypeCopySink', 'TypeCosmosDbMongoDbAPISink', 'TypeSalesforceSink', 'TypeAzureDataExplorerSink', 'TypeDynamicsSink', 'TypeOdbcSink', 'TypeAzureSearchIndexSink', 'TypeAzureBlobFSSink', 'TypeAzureDataLakeStoreSink', 'TypeOracleSink', 'TypeSQLDWSink', 'TypeSQLSink', 'TypeDocumentDbCollectionSink', 'TypeFileSystemSink', 'TypeBlobSink', 'TypeAzureTableSink', 'TypeAzureQueueSink', 'TypeSapCloudForCustomerSink'
	Type TypeBasicCopySink `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureQueueSink.
func (aqs AzureQueueSink) MarshalJSON() ([]byte, error) {
	aqs.Type = TypeAzureQueueSink
	objectMap := make(map[string]interface{})
	if aqs.WriteBatchSize != nil {
		objectMap["writeBatchSize"] = aqs.WriteBatchSize
	}
	if aqs.WriteBatchTimeout != nil {
		objectMap["writeBatchTimeout"] = aqs.WriteBatchTimeout
	}
	if aqs.SinkRetryCount != nil {
		objectMap["sinkRetryCount"] = aqs.SinkRetryCount
	}
	if aqs.SinkRetryWait != nil {
		objectMap["sinkRetryWait"] = aqs.SinkRetryWait
	}
	if aqs.MaxConcurrentConnections != nil {
		objectMap["maxConcurrentConnections"] = aqs.MaxConcurrentConnections
	}
	if aqs.Type != "" {
		objectMap["type"] = aqs.Type
	}
	for k, v := range aqs.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsCosmosDbMongoDbAPISink is the BasicCopySink implementation for AzureQueueSink.
func (aqs AzureQueueSink) AsCosmosDbMongoDbAPISink() (*CosmosDbMongoDbAPISink, bool) {
	return nil, false
}

// AsSalesforceSink is the BasicCopySink implementation for AzureQueueSink.
func (aqs AzureQueueSink) AsSalesforceSink() (*SalesforceSink, bool) {
	return nil, false
}

// AsAzureDataExplorerSink is the BasicCopySink implementation for AzureQueueSink.
func (aqs AzureQueueSink) AsAzureDataExplorerSink() (*AzureDataExplorerSink, bool) {
	return nil, false
}

// AsDynamicsSink is the BasicCopySink implementation for AzureQueueSink.
func (aqs AzureQueueSink) AsDynamicsSink() (*DynamicsSink, bool) {
	return nil, false
}

// AsOdbcSink is the BasicCopySink implementation for AzureQueueSink.
func (aqs AzureQueueSink) AsOdbcSink() (*OdbcSink, bool) {
	return nil, false
}

// AsAzureSearchIndexSink is the BasicCopySink implementation for AzureQueueSink.
func (aqs AzureQueueSink) AsAzureSearchIndexSink() (*AzureSearchIndexSink, bool) {
	return nil, false
}

// AsAzureBlobFSSink is the BasicCopySink implementation for AzureQueueSink.
func (aqs AzureQueueSink) AsAzureBlobFSSink() (*AzureBlobFSSink, bool) {
	return nil, false
}

// AsAzureDataLakeStoreSink is the BasicCopySink implementation for AzureQueueSink.
func (aqs AzureQueueSink) AsAzureDataLakeStoreSink() (*AzureDataLakeStoreSink, bool) {
	return nil, false
}

// AsOracleSink is the BasicCopySink implementation for AzureQueueSink.
func (aqs AzureQueueSink) AsOracleSink() (*OracleSink, bool) {
	return nil, false
}

// AsSQLDWSink is the BasicCopySink implementation for AzureQueueSink.
func (aqs AzureQueueSink) AsSQLDWSink() (*SQLDWSink, bool) {
	return nil, false
}

// AsSQLSink is the BasicCopySink implementation for AzureQueueSink.
func (aqs AzureQueueSink) AsSQLSink() (*SQLSink, bool) {
	return nil, false
}

// AsDocumentDbCollectionSink is the BasicCopySink implementation for AzureQueueSink.
func (aqs AzureQueueSink) AsDocumentDbCollectionSink() (*DocumentDbCollectionSink, bool) {
	return nil, false
}

// AsFileSystemSink is the BasicCopySink implementation for AzureQueueSink.
func (aqs AzureQueueSink) AsFileSystemSink() (*FileSystemSink, bool) {
	return nil, false
}

// AsBlobSink is the BasicCopySink implementation for AzureQueueSink.
func (aqs AzureQueueSink) AsBlobSink() (*BlobSink, bool) {
	return nil, false
}

// AsAzureTableSink is the BasicCopySink implementation for AzureQueueSink.
func (aqs AzureQueueSink) AsAzureTableSink() (*AzureTableSink, bool) {
	return nil, false
}

// AsAzureQueueSink is the BasicCopySink implementation for AzureQueueSink.
func (aqs AzureQueueSink) AsAzureQueueSink() (*AzureQueueSink, bool) {
	return &aqs, true
}

// AsSapCloudForCustomerSink is the BasicCopySink implementation for AzureQueueSink.
func (aqs AzureQueueSink) AsSapCloudForCustomerSink() (*SapCloudForCustomerSink, bool) {
	return nil, false
}

// AsCopySink is the BasicCopySink implementation for AzureQueueSink.
func (aqs AzureQueueSink) AsCopySink() (*CopySink, bool) {
	return nil, false
}

// AsBasicCopySink is the BasicCopySink implementation for AzureQueueSink.
func (aqs AzureQueueSink) AsBasicCopySink() (BasicCopySink, bool) {
	return &aqs, true
}

// UnmarshalJSON is the custom unmarshaler for AzureQueueSink struct.
func (aqs *AzureQueueSink) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if aqs.AdditionalProperties == nil {
					aqs.AdditionalProperties = make(map[string]interface{})
				}
				aqs.AdditionalProperties[k] = additionalProperties
			}
		case "writeBatchSize":
			if v != nil {
				var writeBatchSize interface{}
				err = json.Unmarshal(*v, &writeBatchSize)
				if err != nil {
					return err
				}
				aqs.WriteBatchSize = writeBatchSize
			}
		case "writeBatchTimeout":
			if v != nil {
				var writeBatchTimeout interface{}
				err = json.Unmarshal(*v, &writeBatchTimeout)
				if err != nil {
					return err
				}
				aqs.WriteBatchTimeout = writeBatchTimeout
			}
		case "sinkRetryCount":
			if v != nil {
				var sinkRetryCount interface{}
				err = json.Unmarshal(*v, &sinkRetryCount)
				if err != nil {
					return err
				}
				aqs.SinkRetryCount = sinkRetryCount
			}
		case "sinkRetryWait":
			if v != nil {
				var sinkRetryWait interface{}
				err = json.Unmarshal(*v, &sinkRetryWait)
				if err != nil {
					return err
				}
				aqs.SinkRetryWait = sinkRetryWait
			}
		case "maxConcurrentConnections":
			if v != nil {
				var maxConcurrentConnections interface{}
				err = json.Unmarshal(*v, &maxConcurrentConnections)
				if err != nil {
					return err
				}
				aqs.MaxConcurrentConnections = maxConcurrentConnections
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicCopySink
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				aqs.Type = typeVar
			}
		}
	}

	return nil
}

// AzureSearchIndexDataset the Azure Search Index.
type AzureSearchIndexDataset struct {
	// AzureSearchIndexDatasetTypeProperties - Properties specific to this dataset type.
	*AzureSearchIndexDatasetTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Description - Dataset description.
	Description *string `json:"description,omitempty"`
	// Structure - Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`
	// Schema - Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType: DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`
	// LinkedServiceName - Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
	// Parameters - Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the Dataset.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Folder - The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`
	// Type - Possible values include: 'TypeDataset', 'TypeGoogleAdWordsObject', 'TypeAzureDataExplorerTable', 'TypeOracleServiceCloudObject', 'TypeDynamicsAXResource', 'TypeResponsysObject', 'TypeSalesforceMarketingCloudObject', 'TypeVerticaTable', 'TypeNetezzaTable', 'TypeZohoObject', 'TypeXeroObject', 'TypeSquareObject', 'TypeSparkObject', 'TypeShopifyObject', 'TypeServiceNowObject', 'TypeQuickBooksObject', 'TypePrestoObject', 'TypePhoenixObject', 'TypePaypalObject', 'TypeMarketoObject', 'TypeMariaDBTable', 'TypeMagentoObject', 'TypeJiraObject', 'TypeImpalaObject', 'TypeHubspotObject', 'TypeHiveObject', 'TypeHBaseObject', 'TypeGreenplumTable', 'TypeGoogleBigQueryObject', 'TypeEloquaObject', 'TypeDrillTable', 'TypeCouchbaseTable', 'TypeConcurObject', 'TypeAzurePostgreSQLTable', 'TypeAmazonMWSObject', 'TypeHTTPFile', 'TypeAzureSearchIndex', 'TypeWebTable', 'TypeRestResource', 'TypeSQLServerTable', 'TypeSapOpenHubTable', 'TypeSapEccResource', 'TypeSapCloudForCustomerResource', 'TypeSalesforceObject', 'TypeRelationalTable', 'TypeAzureMySQLTable', 'TypeOracleTable', 'TypeODataResource', 'TypeCosmosDbMongoDbAPICollection', 'TypeMongoDbV2Collection', 'TypeMongoDbCollection', 'TypeFileShare', 'TypeOffice365Table', 'TypeAzureBlobFSFile', 'TypeAzureDataLakeStoreFile', 'TypeDynamicsEntity', 'TypeDocumentDbCollection', 'TypeCustomDataset', 'TypeCassandraTable', 'TypeAzureSQLDWTable', 'TypeAzureSQLTable', 'TypeAzureTable', 'TypeAzureBlob', 'TypeAmazonS3Object'
	Type TypeBasicDataset `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) MarshalJSON() ([]byte, error) {
	asid.Type = TypeAzureSearchIndex
	objectMap := make(map[string]interface{})
	if asid.AzureSearchIndexDatasetTypeProperties != nil {
		objectMap["typeProperties"] = asid.AzureSearchIndexDatasetTypeProperties
	}
	if asid.Description != nil {
		objectMap["description"] = asid.Description
	}
	if asid.Structure != nil {
		objectMap["structure"] = asid.Structure
	}
	if asid.Schema != nil {
		objectMap["schema"] = asid.Schema
	}
	if asid.LinkedServiceName != nil {
		objectMap["linkedServiceName"] = asid.LinkedServiceName
	}
	if asid.Parameters != nil {
		objectMap["parameters"] = asid.Parameters
	}
	if asid.Annotations != nil {
		objectMap["annotations"] = asid.Annotations
	}
	if asid.Folder != nil {
		objectMap["folder"] = asid.Folder
	}
	if asid.Type != "" {
		objectMap["type"] = asid.Type
	}
	for k, v := range asid.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsGoogleAdWordsObjectDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsGoogleAdWordsObjectDataset() (*GoogleAdWordsObjectDataset, bool) {
	return nil, false
}

// AsAzureDataExplorerTableDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsAzureDataExplorerTableDataset() (*AzureDataExplorerTableDataset, bool) {
	return nil, false
}

// AsOracleServiceCloudObjectDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsOracleServiceCloudObjectDataset() (*OracleServiceCloudObjectDataset, bool) {
	return nil, false
}

// AsDynamicsAXResourceDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsDynamicsAXResourceDataset() (*DynamicsAXResourceDataset, bool) {
	return nil, false
}

// AsResponsysObjectDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsResponsysObjectDataset() (*ResponsysObjectDataset, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudObjectDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsSalesforceMarketingCloudObjectDataset() (*SalesforceMarketingCloudObjectDataset, bool) {
	return nil, false
}

// AsVerticaTableDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsVerticaTableDataset() (*VerticaTableDataset, bool) {
	return nil, false
}

// AsNetezzaTableDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsNetezzaTableDataset() (*NetezzaTableDataset, bool) {
	return nil, false
}

// AsZohoObjectDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsZohoObjectDataset() (*ZohoObjectDataset, bool) {
	return nil, false
}

// AsXeroObjectDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsXeroObjectDataset() (*XeroObjectDataset, bool) {
	return nil, false
}

// AsSquareObjectDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsSquareObjectDataset() (*SquareObjectDataset, bool) {
	return nil, false
}

// AsSparkObjectDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsSparkObjectDataset() (*SparkObjectDataset, bool) {
	return nil, false
}

// AsShopifyObjectDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsShopifyObjectDataset() (*ShopifyObjectDataset, bool) {
	return nil, false
}

// AsServiceNowObjectDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsServiceNowObjectDataset() (*ServiceNowObjectDataset, bool) {
	return nil, false
}

// AsQuickBooksObjectDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsQuickBooksObjectDataset() (*QuickBooksObjectDataset, bool) {
	return nil, false
}

// AsPrestoObjectDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsPrestoObjectDataset() (*PrestoObjectDataset, bool) {
	return nil, false
}

// AsPhoenixObjectDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsPhoenixObjectDataset() (*PhoenixObjectDataset, bool) {
	return nil, false
}

// AsPaypalObjectDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsPaypalObjectDataset() (*PaypalObjectDataset, bool) {
	return nil, false
}

// AsMarketoObjectDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsMarketoObjectDataset() (*MarketoObjectDataset, bool) {
	return nil, false
}

// AsMariaDBTableDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsMariaDBTableDataset() (*MariaDBTableDataset, bool) {
	return nil, false
}

// AsMagentoObjectDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsMagentoObjectDataset() (*MagentoObjectDataset, bool) {
	return nil, false
}

// AsJiraObjectDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsJiraObjectDataset() (*JiraObjectDataset, bool) {
	return nil, false
}

// AsImpalaObjectDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsImpalaObjectDataset() (*ImpalaObjectDataset, bool) {
	return nil, false
}

// AsHubspotObjectDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsHubspotObjectDataset() (*HubspotObjectDataset, bool) {
	return nil, false
}

// AsHiveObjectDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsHiveObjectDataset() (*HiveObjectDataset, bool) {
	return nil, false
}

// AsHBaseObjectDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsHBaseObjectDataset() (*HBaseObjectDataset, bool) {
	return nil, false
}

// AsGreenplumTableDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsGreenplumTableDataset() (*GreenplumTableDataset, bool) {
	return nil, false
}

// AsGoogleBigQueryObjectDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsGoogleBigQueryObjectDataset() (*GoogleBigQueryObjectDataset, bool) {
	return nil, false
}

// AsEloquaObjectDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsEloquaObjectDataset() (*EloquaObjectDataset, bool) {
	return nil, false
}

// AsDrillTableDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsDrillTableDataset() (*DrillTableDataset, bool) {
	return nil, false
}

// AsCouchbaseTableDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsCouchbaseTableDataset() (*CouchbaseTableDataset, bool) {
	return nil, false
}

// AsConcurObjectDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsConcurObjectDataset() (*ConcurObjectDataset, bool) {
	return nil, false
}

// AsAzurePostgreSQLTableDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsAzurePostgreSQLTableDataset() (*AzurePostgreSQLTableDataset, bool) {
	return nil, false
}

// AsAmazonMWSObjectDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsAmazonMWSObjectDataset() (*AmazonMWSObjectDataset, bool) {
	return nil, false
}

// AsHTTPDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsHTTPDataset() (*HTTPDataset, bool) {
	return nil, false
}

// AsAzureSearchIndexDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsAzureSearchIndexDataset() (*AzureSearchIndexDataset, bool) {
	return &asid, true
}

// AsWebTableDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsWebTableDataset() (*WebTableDataset, bool) {
	return nil, false
}

// AsRestResourceDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsRestResourceDataset() (*RestResourceDataset, bool) {
	return nil, false
}

// AsSQLServerTableDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsSQLServerTableDataset() (*SQLServerTableDataset, bool) {
	return nil, false
}

// AsSapOpenHubTableDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsSapOpenHubTableDataset() (*SapOpenHubTableDataset, bool) {
	return nil, false
}

// AsSapEccResourceDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsSapEccResourceDataset() (*SapEccResourceDataset, bool) {
	return nil, false
}

// AsSapCloudForCustomerResourceDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsSapCloudForCustomerResourceDataset() (*SapCloudForCustomerResourceDataset, bool) {
	return nil, false
}

// AsSalesforceObjectDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsSalesforceObjectDataset() (*SalesforceObjectDataset, bool) {
	return nil, false
}

// AsRelationalTableDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsRelationalTableDataset() (*RelationalTableDataset, bool) {
	return nil, false
}

// AsAzureMySQLTableDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsAzureMySQLTableDataset() (*AzureMySQLTableDataset, bool) {
	return nil, false
}

// AsOracleTableDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsOracleTableDataset() (*OracleTableDataset, bool) {
	return nil, false
}

// AsODataResourceDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsODataResourceDataset() (*ODataResourceDataset, bool) {
	return nil, false
}

// AsCosmosDbMongoDbAPICollectionDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsCosmosDbMongoDbAPICollectionDataset() (*CosmosDbMongoDbAPICollectionDataset, bool) {
	return nil, false
}

// AsMongoDbV2CollectionDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsMongoDbV2CollectionDataset() (*MongoDbV2CollectionDataset, bool) {
	return nil, false
}

// AsMongoDbCollectionDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsMongoDbCollectionDataset() (*MongoDbCollectionDataset, bool) {
	return nil, false
}

// AsFileShareDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsFileShareDataset() (*FileShareDataset, bool) {
	return nil, false
}

// AsOffice365Dataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsOffice365Dataset() (*Office365Dataset, bool) {
	return nil, false
}

// AsAzureBlobFSDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsAzureBlobFSDataset() (*AzureBlobFSDataset, bool) {
	return nil, false
}

// AsAzureDataLakeStoreDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsAzureDataLakeStoreDataset() (*AzureDataLakeStoreDataset, bool) {
	return nil, false
}

// AsDynamicsEntityDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsDynamicsEntityDataset() (*DynamicsEntityDataset, bool) {
	return nil, false
}

// AsDocumentDbCollectionDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsDocumentDbCollectionDataset() (*DocumentDbCollectionDataset, bool) {
	return nil, false
}

// AsCustomDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsCustomDataset() (*CustomDataset, bool) {
	return nil, false
}

// AsCassandraTableDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsCassandraTableDataset() (*CassandraTableDataset, bool) {
	return nil, false
}

// AsAzureSQLDWTableDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsAzureSQLDWTableDataset() (*AzureSQLDWTableDataset, bool) {
	return nil, false
}

// AsAzureSQLTableDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsAzureSQLTableDataset() (*AzureSQLTableDataset, bool) {
	return nil, false
}

// AsAzureTableDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsAzureTableDataset() (*AzureTableDataset, bool) {
	return nil, false
}

// AsAzureBlobDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsAzureBlobDataset() (*AzureBlobDataset, bool) {
	return nil, false
}

// AsAmazonS3Dataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsAmazonS3Dataset() (*AmazonS3Dataset, bool) {
	return nil, false
}

// AsDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsDataset() (*Dataset, bool) {
	return nil, false
}

// AsBasicDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsBasicDataset() (BasicDataset, bool) {
	return &asid, true
}

// UnmarshalJSON is the custom unmarshaler for AzureSearchIndexDataset struct.
func (asid *AzureSearchIndexDataset) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var azureSearchIndexDatasetTypeProperties AzureSearchIndexDatasetTypeProperties
				err = json.Unmarshal(*v, &azureSearchIndexDatasetTypeProperties)
				if err != nil {
					return err
				}
				asid.AzureSearchIndexDatasetTypeProperties = &azureSearchIndexDatasetTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if asid.AdditionalProperties == nil {
					asid.AdditionalProperties = make(map[string]interface{})
				}
				asid.AdditionalProperties[k] = additionalProperties
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				asid.Description = &description
			}
		case "structure":
			if v != nil {
				var structure interface{}
				err = json.Unmarshal(*v, &structure)
				if err != nil {
					return err
				}
				asid.Structure = structure
			}
		case "schema":
			if v != nil {
				var schema interface{}
				err = json.Unmarshal(*v, &schema)
				if err != nil {
					return err
				}
				asid.Schema = schema
			}
		case "linkedServiceName":
			if v != nil {
				var linkedServiceName LinkedServiceReference
				err = json.Unmarshal(*v, &linkedServiceName)
				if err != nil {
					return err
				}
				asid.LinkedServiceName = &linkedServiceName
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				asid.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				asid.Annotations = &annotations
			}
		case "folder":
			if v != nil {
				var folder DatasetFolder
				err = json.Unmarshal(*v, &folder)
				if err != nil {
					return err
				}
				asid.Folder = &folder
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicDataset
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				asid.Type = typeVar
			}
		}
	}

	return nil
}

// AzureSearchIndexDatasetTypeProperties properties specific to this dataset type.
type AzureSearchIndexDatasetTypeProperties struct {
	// IndexName - The name of the Azure Search Index. Type: string (or Expression with resultType string).
	IndexName interface{} `json:"indexName,omitempty"`
}

// AzureSearchIndexSink a copy activity Azure Search Index sink.
type AzureSearchIndexSink struct {
	// WriteBehavior - Specify the write behavior when upserting documents into Azure Search Index. Possible values include: 'Merge', 'Upload'
	WriteBehavior AzureSearchIndexWriteBehaviorType `json:"writeBehavior,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// WriteBatchSize - Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize interface{} `json:"writeBatchSize,omitempty"`
	// WriteBatchTimeout - Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout interface{} `json:"writeBatchTimeout,omitempty"`
	// SinkRetryCount - Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount interface{} `json:"sinkRetryCount,omitempty"`
	// SinkRetryWait - Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait interface{} `json:"sinkRetryWait,omitempty"`
	// MaxConcurrentConnections - The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`
	// Type - Possible values include: 'TypeCopySink', 'TypeCosmosDbMongoDbAPISink', 'TypeSalesforceSink', 'TypeAzureDataExplorerSink', 'TypeDynamicsSink', 'TypeOdbcSink', 'TypeAzureSearchIndexSink', 'TypeAzureBlobFSSink', 'TypeAzureDataLakeStoreSink', 'TypeOracleSink', 'TypeSQLDWSink', 'TypeSQLSink', 'TypeDocumentDbCollectionSink', 'TypeFileSystemSink', 'TypeBlobSink', 'TypeAzureTableSink', 'TypeAzureQueueSink', 'TypeSapCloudForCustomerSink'
	Type TypeBasicCopySink `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureSearchIndexSink.
func (asis AzureSearchIndexSink) MarshalJSON() ([]byte, error) {
	asis.Type = TypeAzureSearchIndexSink
	objectMap := make(map[string]interface{})
	if asis.WriteBehavior != "" {
		objectMap["writeBehavior"] = asis.WriteBehavior
	}
	if asis.WriteBatchSize != nil {
		objectMap["writeBatchSize"] = asis.WriteBatchSize
	}
	if asis.WriteBatchTimeout != nil {
		objectMap["writeBatchTimeout"] = asis.WriteBatchTimeout
	}
	if asis.SinkRetryCount != nil {
		objectMap["sinkRetryCount"] = asis.SinkRetryCount
	}
	if asis.SinkRetryWait != nil {
		objectMap["sinkRetryWait"] = asis.SinkRetryWait
	}
	if asis.MaxConcurrentConnections != nil {
		objectMap["maxConcurrentConnections"] = asis.MaxConcurrentConnections
	}
	if asis.Type != "" {
		objectMap["type"] = asis.Type
	}
	for k, v := range asis.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsCosmosDbMongoDbAPISink is the BasicCopySink implementation for AzureSearchIndexSink.
func (asis AzureSearchIndexSink) AsCosmosDbMongoDbAPISink() (*CosmosDbMongoDbAPISink, bool) {
	return nil, false
}

// AsSalesforceSink is the BasicCopySink implementation for AzureSearchIndexSink.
func (asis AzureSearchIndexSink) AsSalesforceSink() (*SalesforceSink, bool) {
	return nil, false
}

// AsAzureDataExplorerSink is the BasicCopySink implementation for AzureSearchIndexSink.
func (asis AzureSearchIndexSink) AsAzureDataExplorerSink() (*AzureDataExplorerSink, bool) {
	return nil, false
}

// AsDynamicsSink is the BasicCopySink implementation for AzureSearchIndexSink.
func (asis AzureSearchIndexSink) AsDynamicsSink() (*DynamicsSink, bool) {
	return nil, false
}

// AsOdbcSink is the BasicCopySink implementation for AzureSearchIndexSink.
func (asis AzureSearchIndexSink) AsOdbcSink() (*OdbcSink, bool) {
	return nil, false
}

// AsAzureSearchIndexSink is the BasicCopySink implementation for AzureSearchIndexSink.
func (asis AzureSearchIndexSink) AsAzureSearchIndexSink() (*AzureSearchIndexSink, bool) {
	return &asis, true
}

// AsAzureBlobFSSink is the BasicCopySink implementation for AzureSearchIndexSink.
func (asis AzureSearchIndexSink) AsAzureBlobFSSink() (*AzureBlobFSSink, bool) {
	return nil, false
}

// AsAzureDataLakeStoreSink is the BasicCopySink implementation for AzureSearchIndexSink.
func (asis AzureSearchIndexSink) AsAzureDataLakeStoreSink() (*AzureDataLakeStoreSink, bool) {
	return nil, false
}

// AsOracleSink is the BasicCopySink implementation for AzureSearchIndexSink.
func (asis AzureSearchIndexSink) AsOracleSink() (*OracleSink, bool) {
	return nil, false
}

// AsSQLDWSink is the BasicCopySink implementation for AzureSearchIndexSink.
func (asis AzureSearchIndexSink) AsSQLDWSink() (*SQLDWSink, bool) {
	return nil, false
}

// AsSQLSink is the BasicCopySink implementation for AzureSearchIndexSink.
func (asis AzureSearchIndexSink) AsSQLSink() (*SQLSink, bool) {
	return nil, false
}

// AsDocumentDbCollectionSink is the BasicCopySink implementation for AzureSearchIndexSink.
func (asis AzureSearchIndexSink) AsDocumentDbCollectionSink() (*DocumentDbCollectionSink, bool) {
	return nil, false
}

// AsFileSystemSink is the BasicCopySink implementation for AzureSearchIndexSink.
func (asis AzureSearchIndexSink) AsFileSystemSink() (*FileSystemSink, bool) {
	return nil, false
}

// AsBlobSink is the BasicCopySink implementation for AzureSearchIndexSink.
func (asis AzureSearchIndexSink) AsBlobSink() (*BlobSink, bool) {
	return nil, false
}

// AsAzureTableSink is the BasicCopySink implementation for AzureSearchIndexSink.
func (asis AzureSearchIndexSink) AsAzureTableSink() (*AzureTableSink, bool) {
	return nil, false
}

// AsAzureQueueSink is the BasicCopySink implementation for AzureSearchIndexSink.
func (asis AzureSearchIndexSink) AsAzureQueueSink() (*AzureQueueSink, bool) {
	return nil, false
}

// AsSapCloudForCustomerSink is the BasicCopySink implementation for AzureSearchIndexSink.
func (asis AzureSearchIndexSink) AsSapCloudForCustomerSink() (*SapCloudForCustomerSink, bool) {
	return nil, false
}

// AsCopySink is the BasicCopySink implementation for AzureSearchIndexSink.
func (asis AzureSearchIndexSink) AsCopySink() (*CopySink, bool) {
	return nil, false
}

// AsBasicCopySink is the BasicCopySink implementation for AzureSearchIndexSink.
func (asis AzureSearchIndexSink) AsBasicCopySink() (BasicCopySink, bool) {
	return &asis, true
}

// UnmarshalJSON is the custom unmarshaler for AzureSearchIndexSink struct.
func (asis *AzureSearchIndexSink) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "writeBehavior":
			if v != nil {
				var writeBehavior AzureSearchIndexWriteBehaviorType
				err = json.Unmarshal(*v, &writeBehavior)
				if err != nil {
					return err
				}
				asis.WriteBehavior = writeBehavior
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if asis.AdditionalProperties == nil {
					asis.AdditionalProperties = make(map[string]interface{})
				}
				asis.AdditionalProperties[k] = additionalProperties
			}
		case "writeBatchSize":
			if v != nil {
				var writeBatchSize interface{}
				err = json.Unmarshal(*v, &writeBatchSize)
				if err != nil {
					return err
				}
				asis.WriteBatchSize = writeBatchSize
			}
		case "writeBatchTimeout":
			if v != nil {
				var writeBatchTimeout interface{}
				err = json.Unmarshal(*v, &writeBatchTimeout)
				if err != nil {
					return err
				}
				asis.WriteBatchTimeout = writeBatchTimeout
			}
		case "sinkRetryCount":
			if v != nil {
				var sinkRetryCount interface{}
				err = json.Unmarshal(*v, &sinkRetryCount)
				if err != nil {
					return err
				}
				asis.SinkRetryCount = sinkRetryCount
			}
		case "sinkRetryWait":
			if v != nil {
				var sinkRetryWait interface{}
				err = json.Unmarshal(*v, &sinkRetryWait)
				if err != nil {
					return err
				}
				asis.SinkRetryWait = sinkRetryWait
			}
		case "maxConcurrentConnections":
			if v != nil {
				var maxConcurrentConnections interface{}
				err = json.Unmarshal(*v, &maxConcurrentConnections)
				if err != nil {
					return err
				}
				asis.MaxConcurrentConnections = maxConcurrentConnections
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicCopySink
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				asis.Type = typeVar
			}
		}
	}

	return nil
}

// AzureSearchLinkedService linked service for Windows Azure Search Service.
type AzureSearchLinkedService struct {
	// AzureSearchLinkedServiceTypeProperties - Windows Azure Search Service linked service properties.
	*AzureSearchLinkedServiceTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Parameters - Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the linked service.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Type - Possible values include: 'TypeLinkedService', 'TypeAzureFunction', 'TypeAzureDataExplorer', 'TypeGoogleAdWords', 'TypeOracleServiceCloud', 'TypeDynamicsAX', 'TypeResponsys', 'TypeAzureDatabricks', 'TypeAzureDataLakeAnalytics', 'TypeHDInsightOnDemand', 'TypeSalesforceMarketingCloud', 'TypeNetezza', 'TypeVertica', 'TypeZoho', 'TypeXero', 'TypeSquare', 'TypeSpark', 'TypeShopify', 'TypeServiceNow', 'TypeQuickBooks', 'TypePresto', 'TypePhoenix', 'TypePaypal', 'TypeMarketo', 'TypeMariaDB', 'TypeMagento', 'TypeJira', 'TypeImpala', 'TypeHubspot', 'TypeHive', 'TypeHBase', 'TypeGreenplum', 'TypeGoogleBigQuery', 'TypeEloqua', 'TypeDrill', 'TypeCouchbase', 'TypeConcur', 'TypeAzurePostgreSQL', 'TypeAmazonMWS', 'TypeSapHana', 'TypeSapBW', 'TypeSftp', 'TypeFtpServer', 'TypeHTTPServer', 'TypeAzureSearch', 'TypeCustomDataSource', 'TypeAmazonRedshift', 'TypeAmazonS3', 'TypeRestService', 'TypeSapOpenHub', 'TypeSapEcc', 'TypeSapCloudForCustomer', 'TypeSalesforce', 'TypeOffice365', 'TypeAzureBlobFS', 'TypeAzureDataLakeStore', 'TypeCosmosDbMongoDbAPI', 'TypeMongoDbV2', 'TypeMongoDb', 'TypeCassandra', 'TypeWeb', 'TypeOData', 'TypeHdfs', 'TypeOdbc', 'TypeAzureML', 'TypeTeradata', 'TypeDb2', 'TypeSybase', 'TypePostgreSQL', 'TypeMySQL', 'TypeAzureMySQL', 'TypeOracle', 'TypeFileServer', 'TypeHDInsight', 'TypeDynamics', 'TypeCosmosDb', 'TypeAzureKeyVault', 'TypeAzureBatch', 'TypeAzureSQLDatabase', 'TypeSQLServer', 'TypeAzureSQLDW', 'TypeAzureTableStorage', 'TypeAzureBlobStorage', 'TypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) MarshalJSON() ([]byte, error) {
	asls.Type = TypeAzureSearch
	objectMap := make(map[string]interface{})
	if asls.AzureSearchLinkedServiceTypeProperties != nil {
		objectMap["typeProperties"] = asls.AzureSearchLinkedServiceTypeProperties
	}
	if asls.ConnectVia != nil {
		objectMap["connectVia"] = asls.ConnectVia
	}
	if asls.Description != nil {
		objectMap["description"] = asls.Description
	}
	if asls.Parameters != nil {
		objectMap["parameters"] = asls.Parameters
	}
	if asls.Annotations != nil {
		objectMap["annotations"] = asls.Annotations
	}
	if asls.Type != "" {
		objectMap["type"] = asls.Type
	}
	for k, v := range asls.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsAzureFunctionLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsAzureFunctionLinkedService() (*AzureFunctionLinkedService, bool) {
	return nil, false
}

// AsAzureDataExplorerLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsAzureDataExplorerLinkedService() (*AzureDataExplorerLinkedService, bool) {
	return nil, false
}

// AsGoogleAdWordsLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsGoogleAdWordsLinkedService() (*GoogleAdWordsLinkedService, bool) {
	return nil, false
}

// AsOracleServiceCloudLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsOracleServiceCloudLinkedService() (*OracleServiceCloudLinkedService, bool) {
	return nil, false
}

// AsDynamicsAXLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsDynamicsAXLinkedService() (*DynamicsAXLinkedService, bool) {
	return nil, false
}

// AsResponsysLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsResponsysLinkedService() (*ResponsysLinkedService, bool) {
	return nil, false
}

// AsAzureDatabricksLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsAzureDatabricksLinkedService() (*AzureDatabricksLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return nil, false
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsSalesforceMarketingCloudLinkedService() (*SalesforceMarketingCloudLinkedService, bool) {
	return nil, false
}

// AsNetezzaLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsNetezzaLinkedService() (*NetezzaLinkedService, bool) {
	return nil, false
}

// AsVerticaLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsVerticaLinkedService() (*VerticaLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return nil, false
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return nil, false
}

// AsConcurLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return nil, false
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return nil, false
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return nil, false
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return &asls, true
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return nil, false
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return nil, false
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return nil, false
}

// AsRestServiceLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsRestServiceLinkedService() (*RestServiceLinkedService, bool) {
	return nil, false
}

// AsSapOpenHubLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsSapOpenHubLinkedService() (*SapOpenHubLinkedService, bool) {
	return nil, false
}

// AsSapEccLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsSapEccLinkedService() (*SapEccLinkedService, bool) {
	return nil, false
}

// AsSapCloudForCustomerLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsSapCloudForCustomerLinkedService() (*SapCloudForCustomerLinkedService, bool) {
	return nil, false
}

// AsSalesforceLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsSalesforceLinkedService() (*SalesforceLinkedService, bool) {
	return nil, false
}

// AsOffice365LinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsOffice365LinkedService() (*Office365LinkedService, bool) {
	return nil, false
}

// AsAzureBlobFSLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsAzureBlobFSLinkedService() (*AzureBlobFSLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsAzureDataLakeStoreLinkedService() (*AzureDataLakeStoreLinkedService, bool) {
	return nil, false
}

// AsCosmosDbMongoDbAPILinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsCosmosDbMongoDbAPILinkedService() (*CosmosDbMongoDbAPILinkedService, bool) {
	return nil, false
}

// AsMongoDbV2LinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsMongoDbV2LinkedService() (*MongoDbV2LinkedService, bool) {
	return nil, false
}

// AsMongoDbLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsMongoDbLinkedService() (*MongoDbLinkedService, bool) {
	return nil, false
}

// AsCassandraLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsCassandraLinkedService() (*CassandraLinkedService, bool) {
	return nil, false
}

// AsWebLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsWebLinkedService() (*WebLinkedService, bool) {
	return nil, false
}

// AsODataLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsODataLinkedService() (*ODataLinkedService, bool) {
	return nil, false
}

// AsHdfsLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsHdfsLinkedService() (*HdfsLinkedService, bool) {
	return nil, false
}

// AsOdbcLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsOdbcLinkedService() (*OdbcLinkedService, bool) {
	return nil, false
}

// AsAzureMLLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsAzureMLLinkedService() (*AzureMLLinkedService, bool) {
	return nil, false
}

// AsTeradataLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsTeradataLinkedService() (*TeradataLinkedService, bool) {
	return nil, false
}

// AsDb2LinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsDb2LinkedService() (*Db2LinkedService, bool) {
	return nil, false
}

// AsSybaseLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsSybaseLinkedService() (*SybaseLinkedService, bool) {
	return nil, false
}

// AsPostgreSQLLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsPostgreSQLLinkedService() (*PostgreSQLLinkedService, bool) {
	return nil, false
}

// AsMySQLLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsMySQLLinkedService() (*MySQLLinkedService, bool) {
	return nil, false
}

// AsAzureMySQLLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsAzureMySQLLinkedService() (*AzureMySQLLinkedService, bool) {
	return nil, false
}

// AsOracleLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsOracleLinkedService() (*OracleLinkedService, bool) {
	return nil, false
}

// AsFileServerLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsFileServerLinkedService() (*FileServerLinkedService, bool) {
	return nil, false
}

// AsHDInsightLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsHDInsightLinkedService() (*HDInsightLinkedService, bool) {
	return nil, false
}

// AsDynamicsLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsDynamicsLinkedService() (*DynamicsLinkedService, bool) {
	return nil, false
}

// AsCosmosDbLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsCosmosDbLinkedService() (*CosmosDbLinkedService, bool) {
	return nil, false
}

// AsAzureKeyVaultLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsAzureKeyVaultLinkedService() (*AzureKeyVaultLinkedService, bool) {
	return nil, false
}

// AsAzureBatchLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsAzureBatchLinkedService() (*AzureBatchLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDatabaseLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsAzureSQLDatabaseLinkedService() (*AzureSQLDatabaseLinkedService, bool) {
	return nil, false
}

// AsSQLServerLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsSQLServerLinkedService() (*SQLServerLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDWLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsAzureSQLDWLinkedService() (*AzureSQLDWLinkedService, bool) {
	return nil, false
}

// AsAzureTableStorageLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsAzureTableStorageLinkedService() (*AzureTableStorageLinkedService, bool) {
	return nil, false
}

// AsAzureBlobStorageLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsAzureBlobStorageLinkedService() (*AzureBlobStorageLinkedService, bool) {
	return nil, false
}

// AsAzureStorageLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsAzureStorageLinkedService() (*AzureStorageLinkedService, bool) {
	return nil, false
}

// AsLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsLinkedService() (*LinkedService, bool) {
	return nil, false
}

// AsBasicLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsBasicLinkedService() (BasicLinkedService, bool) {
	return &asls, true
}

// UnmarshalJSON is the custom unmarshaler for AzureSearchLinkedService struct.
func (asls *AzureSearchLinkedService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var azureSearchLinkedServiceTypeProperties AzureSearchLinkedServiceTypeProperties
				err = json.Unmarshal(*v, &azureSearchLinkedServiceTypeProperties)
				if err != nil {
					return err
				}
				asls.AzureSearchLinkedServiceTypeProperties = &azureSearchLinkedServiceTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if asls.AdditionalProperties == nil {
					asls.AdditionalProperties = make(map[string]interface{})
				}
				asls.AdditionalProperties[k] = additionalProperties
			}
		case "connectVia":
			if v != nil {
				var connectVia IntegrationRuntimeReference
				err = json.Unmarshal(*v, &connectVia)
				if err != nil {
					return err
				}
				asls.ConnectVia = &connectVia
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				asls.Description = &description
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				asls.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				asls.Annotations = &annotations
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicLinkedService
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				asls.Type = typeVar
			}
		}
	}

	return nil
}

// AzureSearchLinkedServiceTypeProperties windows Azure Search Service linked service properties.
type AzureSearchLinkedServiceTypeProperties struct {
	// URL - URL for Azure Search service. Type: string (or Expression with resultType string).
	URL interface{} `json:"url,omitempty"`
	// Key - Admin Key for Azure Search service
	Key BasicSecretBase `json:"key,omitempty"`
	// EncryptedCredential - The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AzureSearchLinkedServiceTypeProperties struct.
func (aslstp *AzureSearchLinkedServiceTypeProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "url":
			if v != nil {
				var URL interface{}
				err = json.Unmarshal(*v, &URL)
				if err != nil {
					return err
				}
				aslstp.URL = URL
			}
		case "key":
			if v != nil {
				key, err := unmarshalBasicSecretBase(*v)
				if err != nil {
					return err
				}
				aslstp.Key = key
			}
		case "encryptedCredential":
			if v != nil {
				var encryptedCredential interface{}
				err = json.Unmarshal(*v, &encryptedCredential)
				if err != nil {
					return err
				}
				aslstp.EncryptedCredential = encryptedCredential
			}
		}
	}

	return nil
}

// AzureSQLDatabaseLinkedService microsoft Azure SQL Database linked service.
type AzureSQLDatabaseLinkedService struct {
	// AzureSQLDatabaseLinkedServiceTypeProperties - Azure SQL Database linked service properties.
	*AzureSQLDatabaseLinkedServiceTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Parameters - Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the linked service.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Type - Possible values include: 'TypeLinkedService', 'TypeAzureFunction', 'TypeAzureDataExplorer', 'TypeGoogleAdWords', 'TypeOracleServiceCloud', 'TypeDynamicsAX', 'TypeResponsys', 'TypeAzureDatabricks', 'TypeAzureDataLakeAnalytics', 'TypeHDInsightOnDemand', 'TypeSalesforceMarketingCloud', 'TypeNetezza', 'TypeVertica', 'TypeZoho', 'TypeXero', 'TypeSquare', 'TypeSpark', 'TypeShopify', 'TypeServiceNow', 'TypeQuickBooks', 'TypePresto', 'TypePhoenix', 'TypePaypal', 'TypeMarketo', 'TypeMariaDB', 'TypeMagento', 'TypeJira', 'TypeImpala', 'TypeHubspot', 'TypeHive', 'TypeHBase', 'TypeGreenplum', 'TypeGoogleBigQuery', 'TypeEloqua', 'TypeDrill', 'TypeCouchbase', 'TypeConcur', 'TypeAzurePostgreSQL', 'TypeAmazonMWS', 'TypeSapHana', 'TypeSapBW', 'TypeSftp', 'TypeFtpServer', 'TypeHTTPServer', 'TypeAzureSearch', 'TypeCustomDataSource', 'TypeAmazonRedshift', 'TypeAmazonS3', 'TypeRestService', 'TypeSapOpenHub', 'TypeSapEcc', 'TypeSapCloudForCustomer', 'TypeSalesforce', 'TypeOffice365', 'TypeAzureBlobFS', 'TypeAzureDataLakeStore', 'TypeCosmosDbMongoDbAPI', 'TypeMongoDbV2', 'TypeMongoDb', 'TypeCassandra', 'TypeWeb', 'TypeOData', 'TypeHdfs', 'TypeOdbc', 'TypeAzureML', 'TypeTeradata', 'TypeDb2', 'TypeSybase', 'TypePostgreSQL', 'TypeMySQL', 'TypeAzureMySQL', 'TypeOracle', 'TypeFileServer', 'TypeHDInsight', 'TypeDynamics', 'TypeCosmosDb', 'TypeAzureKeyVault', 'TypeAzureBatch', 'TypeAzureSQLDatabase', 'TypeSQLServer', 'TypeAzureSQLDW', 'TypeAzureTableStorage', 'TypeAzureBlobStorage', 'TypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) MarshalJSON() ([]byte, error) {
	asdls.Type = TypeAzureSQLDatabase
	objectMap := make(map[string]interface{})
	if asdls.AzureSQLDatabaseLinkedServiceTypeProperties != nil {
		objectMap["typeProperties"] = asdls.AzureSQLDatabaseLinkedServiceTypeProperties
	}
	if asdls.ConnectVia != nil {
		objectMap["connectVia"] = asdls.ConnectVia
	}
	if asdls.Description != nil {
		objectMap["description"] = asdls.Description
	}
	if asdls.Parameters != nil {
		objectMap["parameters"] = asdls.Parameters
	}
	if asdls.Annotations != nil {
		objectMap["annotations"] = asdls.Annotations
	}
	if asdls.Type != "" {
		objectMap["type"] = asdls.Type
	}
	for k, v := range asdls.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsAzureFunctionLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsAzureFunctionLinkedService() (*AzureFunctionLinkedService, bool) {
	return nil, false
}

// AsAzureDataExplorerLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsAzureDataExplorerLinkedService() (*AzureDataExplorerLinkedService, bool) {
	return nil, false
}

// AsGoogleAdWordsLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsGoogleAdWordsLinkedService() (*GoogleAdWordsLinkedService, bool) {
	return nil, false
}

// AsOracleServiceCloudLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsOracleServiceCloudLinkedService() (*OracleServiceCloudLinkedService, bool) {
	return nil, false
}

// AsDynamicsAXLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsDynamicsAXLinkedService() (*DynamicsAXLinkedService, bool) {
	return nil, false
}

// AsResponsysLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsResponsysLinkedService() (*ResponsysLinkedService, bool) {
	return nil, false
}

// AsAzureDatabricksLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsAzureDatabricksLinkedService() (*AzureDatabricksLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return nil, false
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsSalesforceMarketingCloudLinkedService() (*SalesforceMarketingCloudLinkedService, bool) {
	return nil, false
}

// AsNetezzaLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsNetezzaLinkedService() (*NetezzaLinkedService, bool) {
	return nil, false
}

// AsVerticaLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsVerticaLinkedService() (*VerticaLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return nil, false
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return nil, false
}

// AsConcurLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return nil, false
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return nil, false
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return nil, false
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return nil, false
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return nil, false
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return nil, false
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return nil, false
}

// AsRestServiceLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsRestServiceLinkedService() (*RestServiceLinkedService, bool) {
	return nil, false
}

// AsSapOpenHubLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsSapOpenHubLinkedService() (*SapOpenHubLinkedService, bool) {
	return nil, false
}

// AsSapEccLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsSapEccLinkedService() (*SapEccLinkedService, bool) {
	return nil, false
}

// AsSapCloudForCustomerLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsSapCloudForCustomerLinkedService() (*SapCloudForCustomerLinkedService, bool) {
	return nil, false
}

// AsSalesforceLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsSalesforceLinkedService() (*SalesforceLinkedService, bool) {
	return nil, false
}

// AsOffice365LinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsOffice365LinkedService() (*Office365LinkedService, bool) {
	return nil, false
}

// AsAzureBlobFSLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsAzureBlobFSLinkedService() (*AzureBlobFSLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsAzureDataLakeStoreLinkedService() (*AzureDataLakeStoreLinkedService, bool) {
	return nil, false
}

// AsCosmosDbMongoDbAPILinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsCosmosDbMongoDbAPILinkedService() (*CosmosDbMongoDbAPILinkedService, bool) {
	return nil, false
}

// AsMongoDbV2LinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsMongoDbV2LinkedService() (*MongoDbV2LinkedService, bool) {
	return nil, false
}

// AsMongoDbLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsMongoDbLinkedService() (*MongoDbLinkedService, bool) {
	return nil, false
}

// AsCassandraLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsCassandraLinkedService() (*CassandraLinkedService, bool) {
	return nil, false
}

// AsWebLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsWebLinkedService() (*WebLinkedService, bool) {
	return nil, false
}

// AsODataLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsODataLinkedService() (*ODataLinkedService, bool) {
	return nil, false
}

// AsHdfsLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsHdfsLinkedService() (*HdfsLinkedService, bool) {
	return nil, false
}

// AsOdbcLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsOdbcLinkedService() (*OdbcLinkedService, bool) {
	return nil, false
}

// AsAzureMLLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsAzureMLLinkedService() (*AzureMLLinkedService, bool) {
	return nil, false
}

// AsTeradataLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsTeradataLinkedService() (*TeradataLinkedService, bool) {
	return nil, false
}

// AsDb2LinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsDb2LinkedService() (*Db2LinkedService, bool) {
	return nil, false
}

// AsSybaseLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsSybaseLinkedService() (*SybaseLinkedService, bool) {
	return nil, false
}

// AsPostgreSQLLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsPostgreSQLLinkedService() (*PostgreSQLLinkedService, bool) {
	return nil, false
}

// AsMySQLLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsMySQLLinkedService() (*MySQLLinkedService, bool) {
	return nil, false
}

// AsAzureMySQLLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsAzureMySQLLinkedService() (*AzureMySQLLinkedService, bool) {
	return nil, false
}

// AsOracleLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsOracleLinkedService() (*OracleLinkedService, bool) {
	return nil, false
}

// AsFileServerLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsFileServerLinkedService() (*FileServerLinkedService, bool) {
	return nil, false
}

// AsHDInsightLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsHDInsightLinkedService() (*HDInsightLinkedService, bool) {
	return nil, false
}

// AsDynamicsLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsDynamicsLinkedService() (*DynamicsLinkedService, bool) {
	return nil, false
}

// AsCosmosDbLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsCosmosDbLinkedService() (*CosmosDbLinkedService, bool) {
	return nil, false
}

// AsAzureKeyVaultLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsAzureKeyVaultLinkedService() (*AzureKeyVaultLinkedService, bool) {
	return nil, false
}

// AsAzureBatchLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsAzureBatchLinkedService() (*AzureBatchLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDatabaseLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsAzureSQLDatabaseLinkedService() (*AzureSQLDatabaseLinkedService, bool) {
	return &asdls, true
}

// AsSQLServerLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsSQLServerLinkedService() (*SQLServerLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDWLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsAzureSQLDWLinkedService() (*AzureSQLDWLinkedService, bool) {
	return nil, false
}

// AsAzureTableStorageLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsAzureTableStorageLinkedService() (*AzureTableStorageLinkedService, bool) {
	return nil, false
}

// AsAzureBlobStorageLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsAzureBlobStorageLinkedService() (*AzureBlobStorageLinkedService, bool) {
	return nil, false
}

// AsAzureStorageLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsAzureStorageLinkedService() (*AzureStorageLinkedService, bool) {
	return nil, false
}

// AsLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsLinkedService() (*LinkedService, bool) {
	return nil, false
}

// AsBasicLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsBasicLinkedService() (BasicLinkedService, bool) {
	return &asdls, true
}

// UnmarshalJSON is the custom unmarshaler for AzureSQLDatabaseLinkedService struct.
func (asdls *AzureSQLDatabaseLinkedService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var azureSQLDatabaseLinkedServiceTypeProperties AzureSQLDatabaseLinkedServiceTypeProperties
				err = json.Unmarshal(*v, &azureSQLDatabaseLinkedServiceTypeProperties)
				if err != nil {
					return err
				}
				asdls.AzureSQLDatabaseLinkedServiceTypeProperties = &azureSQLDatabaseLinkedServiceTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if asdls.AdditionalProperties == nil {
					asdls.AdditionalProperties = make(map[string]interface{})
				}
				asdls.AdditionalProperties[k] = additionalProperties
			}
		case "connectVia":
			if v != nil {
				var connectVia IntegrationRuntimeReference
				err = json.Unmarshal(*v, &connectVia)
				if err != nil {
					return err
				}
				asdls.ConnectVia = &connectVia
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				asdls.Description = &description
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				asdls.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				asdls.Annotations = &annotations
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicLinkedService
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				asdls.Type = typeVar
			}
		}
	}

	return nil
}

// AzureSQLDatabaseLinkedServiceTypeProperties azure SQL Database linked service properties.
type AzureSQLDatabaseLinkedServiceTypeProperties struct {
	// ConnectionString - The connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
	ConnectionString interface{} `json:"connectionString,omitempty"`
	// Password - The Azure key vault secret reference of password in connection string.
	Password *AzureKeyVaultSecretReference `json:"password,omitempty"`
	// ServicePrincipalID - The ID of the service principal used to authenticate against Azure SQL Database. Type: string (or Expression with resultType string).
	ServicePrincipalID interface{} `json:"servicePrincipalId,omitempty"`
	// ServicePrincipalKey - The key of the service principal used to authenticate against Azure SQL Database.
	ServicePrincipalKey BasicSecretBase `json:"servicePrincipalKey,omitempty"`
	// Tenant - The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
	Tenant interface{} `json:"tenant,omitempty"`
	// EncryptedCredential - The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AzureSQLDatabaseLinkedServiceTypeProperties struct.
func (asdlstp *AzureSQLDatabaseLinkedServiceTypeProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "connectionString":
			if v != nil {
				var connectionString interface{}
				err = json.Unmarshal(*v, &connectionString)
				if err != nil {
					return err
				}
				asdlstp.ConnectionString = connectionString
			}
		case "password":
			if v != nil {
				var password AzureKeyVaultSecretReference
				err = json.Unmarshal(*v, &password)
				if err != nil {
					return err
				}
				asdlstp.Password = &password
			}
		case "servicePrincipalId":
			if v != nil {
				var servicePrincipalID interface{}
				err = json.Unmarshal(*v, &servicePrincipalID)
				if err != nil {
					return err
				}
				asdlstp.ServicePrincipalID = servicePrincipalID
			}
		case "servicePrincipalKey":
			if v != nil {
				servicePrincipalKey, err := unmarshalBasicSecretBase(*v)
				if err != nil {
					return err
				}
				asdlstp.ServicePrincipalKey = servicePrincipalKey
			}
		case "tenant":
			if v != nil {
				var tenant interface{}
				err = json.Unmarshal(*v, &tenant)
				if err != nil {
					return err
				}
				asdlstp.Tenant = tenant
			}
		case "encryptedCredential":
			if v != nil {
				var encryptedCredential interface{}
				err = json.Unmarshal(*v, &encryptedCredential)
				if err != nil {
					return err
				}
				asdlstp.EncryptedCredential = encryptedCredential
			}
		}
	}

	return nil
}

// AzureSQLDWLinkedService azure SQL Data Warehouse linked service.
type AzureSQLDWLinkedService struct {
	// AzureSQLDWLinkedServiceTypeProperties - Azure SQL Data Warehouse linked service properties.
	*AzureSQLDWLinkedServiceTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Parameters - Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the linked service.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Type - Possible values include: 'TypeLinkedService', 'TypeAzureFunction', 'TypeAzureDataExplorer', 'TypeGoogleAdWords', 'TypeOracleServiceCloud', 'TypeDynamicsAX', 'TypeResponsys', 'TypeAzureDatabricks', 'TypeAzureDataLakeAnalytics', 'TypeHDInsightOnDemand', 'TypeSalesforceMarketingCloud', 'TypeNetezza', 'TypeVertica', 'TypeZoho', 'TypeXero', 'TypeSquare', 'TypeSpark', 'TypeShopify', 'TypeServiceNow', 'TypeQuickBooks', 'TypePresto', 'TypePhoenix', 'TypePaypal', 'TypeMarketo', 'TypeMariaDB', 'TypeMagento', 'TypeJira', 'TypeImpala', 'TypeHubspot', 'TypeHive', 'TypeHBase', 'TypeGreenplum', 'TypeGoogleBigQuery', 'TypeEloqua', 'TypeDrill', 'TypeCouchbase', 'TypeConcur', 'TypeAzurePostgreSQL', 'TypeAmazonMWS', 'TypeSapHana', 'TypeSapBW', 'TypeSftp', 'TypeFtpServer', 'TypeHTTPServer', 'TypeAzureSearch', 'TypeCustomDataSource', 'TypeAmazonRedshift', 'TypeAmazonS3', 'TypeRestService', 'TypeSapOpenHub', 'TypeSapEcc', 'TypeSapCloudForCustomer', 'TypeSalesforce', 'TypeOffice365', 'TypeAzureBlobFS', 'TypeAzureDataLakeStore', 'TypeCosmosDbMongoDbAPI', 'TypeMongoDbV2', 'TypeMongoDb', 'TypeCassandra', 'TypeWeb', 'TypeOData', 'TypeHdfs', 'TypeOdbc', 'TypeAzureML', 'TypeTeradata', 'TypeDb2', 'TypeSybase', 'TypePostgreSQL', 'TypeMySQL', 'TypeAzureMySQL', 'TypeOracle', 'TypeFileServer', 'TypeHDInsight', 'TypeDynamics', 'TypeCosmosDb', 'TypeAzureKeyVault', 'TypeAzureBatch', 'TypeAzureSQLDatabase', 'TypeSQLServer', 'TypeAzureSQLDW', 'TypeAzureTableStorage', 'TypeAzureBlobStorage', 'TypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) MarshalJSON() ([]byte, error) {
	asdls.Type = TypeAzureSQLDW
	objectMap := make(map[string]interface{})
	if asdls.AzureSQLDWLinkedServiceTypeProperties != nil {
		objectMap["typeProperties"] = asdls.AzureSQLDWLinkedServiceTypeProperties
	}
	if asdls.ConnectVia != nil {
		objectMap["connectVia"] = asdls.ConnectVia
	}
	if asdls.Description != nil {
		objectMap["description"] = asdls.Description
	}
	if asdls.Parameters != nil {
		objectMap["parameters"] = asdls.Parameters
	}
	if asdls.Annotations != nil {
		objectMap["annotations"] = asdls.Annotations
	}
	if asdls.Type != "" {
		objectMap["type"] = asdls.Type
	}
	for k, v := range asdls.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsAzureFunctionLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsAzureFunctionLinkedService() (*AzureFunctionLinkedService, bool) {
	return nil, false
}

// AsAzureDataExplorerLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsAzureDataExplorerLinkedService() (*AzureDataExplorerLinkedService, bool) {
	return nil, false
}

// AsGoogleAdWordsLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsGoogleAdWordsLinkedService() (*GoogleAdWordsLinkedService, bool) {
	return nil, false
}

// AsOracleServiceCloudLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsOracleServiceCloudLinkedService() (*OracleServiceCloudLinkedService, bool) {
	return nil, false
}

// AsDynamicsAXLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsDynamicsAXLinkedService() (*DynamicsAXLinkedService, bool) {
	return nil, false
}

// AsResponsysLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsResponsysLinkedService() (*ResponsysLinkedService, bool) {
	return nil, false
}

// AsAzureDatabricksLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsAzureDatabricksLinkedService() (*AzureDatabricksLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return nil, false
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsSalesforceMarketingCloudLinkedService() (*SalesforceMarketingCloudLinkedService, bool) {
	return nil, false
}

// AsNetezzaLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsNetezzaLinkedService() (*NetezzaLinkedService, bool) {
	return nil, false
}

// AsVerticaLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsVerticaLinkedService() (*VerticaLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspot