// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package alexaforbusiness

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type UpdateRoomInput struct {
	_ struct{} `type:"structure"`

	// The updated description for the room.
	Description *string `min:"1" type:"string"`

	// The updated profile ARN for the room.
	ProfileArn *string `type:"string"`

	// The updated provider calendar ARN for the room.
	ProviderCalendarId *string `type:"string"`

	// The ARN of the room to update.
	RoomArn *string `type:"string"`

	// The updated name for the room.
	RoomName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateRoomInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRoomInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateRoomInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Description", 1))
	}
	if s.RoomName != nil && len(*s.RoomName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RoomName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdateRoomOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateRoomOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateRoom = "UpdateRoom"

// UpdateRoomRequest returns a request value for making API operation for
// Alexa For Business.
//
// Updates room details by room ARN.
//
//    // Example sending a request using UpdateRoomRequest.
//    req := client.UpdateRoomRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateRoom
func (c *Client) UpdateRoomRequest(input *UpdateRoomInput) UpdateRoomRequest {
	op := &aws.Operation{
		Name:       opUpdateRoom,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateRoomInput{}
	}

	req := c.newRequest(op, input, &UpdateRoomOutput{})
	return UpdateRoomRequest{Request: req, Input: input, Copy: c.UpdateRoomRequest}
}

// UpdateRoomRequest is the request type for the
// UpdateRoom API operation.
type UpdateRoomRequest struct {
	*aws.Request
	Input *UpdateRoomInput
	Copy  func(*UpdateRoomInput) UpdateRoomRequest
}

// Send marshals and sends the UpdateRoom API request.
func (r UpdateRoomRequest) Send(ctx context.Context) (*UpdateRoomResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateRoomResponse{
		UpdateRoomOutput: r.Request.Data.(*UpdateRoomOutput),
		response:         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateRoomResponse is the response type for the
// UpdateRoom API operation.
type UpdateRoomResponse struct {
	*UpdateRoomOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateRoom request.
func (r *UpdateRoomResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
