// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package apigatewayv2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restjson"
)

type DeleteAuthorizerInput struct {
	_ struct{} `type:"structure"`

	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// AuthorizerId is a required field
	AuthorizerId *string `location:"uri" locationName:"authorizerId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteAuthorizerInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAuthorizerInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteAuthorizerInput"}

	if s.ApiId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApiId"))
	}

	if s.AuthorizerId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AuthorizerId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteAuthorizerInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ApiId != nil {
		v := *s.ApiId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "apiId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AuthorizerId != nil {
		v := *s.AuthorizerId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "authorizerId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeleteAuthorizerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteAuthorizerOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteAuthorizerOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteAuthorizer = "DeleteAuthorizer"

// DeleteAuthorizerRequest returns a request value for making API operation for
// AmazonApiGatewayV2.
//
// Deletes an Authorizer.
//
//    // Example sending a request using DeleteAuthorizerRequest.
//    req := client.DeleteAuthorizerRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/DeleteAuthorizer
func (c *Client) DeleteAuthorizerRequest(input *DeleteAuthorizerInput) DeleteAuthorizerRequest {
	op := &aws.Operation{
		Name:       opDeleteAuthorizer,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v2/apis/{apiId}/authorizers/{authorizerId}",
	}

	if input == nil {
		input = &DeleteAuthorizerInput{}
	}

	req := c.newRequest(op, input, &DeleteAuthorizerOutput{})
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DeleteAuthorizerRequest{Request: req, Input: input, Copy: c.DeleteAuthorizerRequest}
}

// DeleteAuthorizerRequest is the request type for the
// DeleteAuthorizer API operation.
type DeleteAuthorizerRequest struct {
	*aws.Request
	Input *DeleteAuthorizerInput
	Copy  func(*DeleteAuthorizerInput) DeleteAuthorizerRequest
}

// Send marshals and sends the DeleteAuthorizer API request.
func (r DeleteAuthorizerRequest) Send(ctx context.Context) (*DeleteAuthorizerResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteAuthorizerResponse{
		DeleteAuthorizerOutput: r.Request.Data.(*DeleteAuthorizerOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteAuthorizerResponse is the response type for the
// DeleteAuthorizer API operation.
type DeleteAuthorizerResponse struct {
	*DeleteAuthorizerOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteAuthorizer request.
func (r *DeleteAuthorizerResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
