// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package applicationinsights

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListLogPatternSetsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in a single call. To retrieve the
	// remaining results, make another call with the returned NextToken value.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token to request the next page of results.
	NextToken *string `type:"string"`

	// The name of the resource group.
	//
	// ResourceGroupName is a required field
	ResourceGroupName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListLogPatternSetsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListLogPatternSetsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListLogPatternSetsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if s.ResourceGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceGroupName"))
	}
	if s.ResourceGroupName != nil && len(*s.ResourceGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListLogPatternSetsOutput struct {
	_ struct{} `type:"structure"`

	// The list of log pattern sets.
	LogPatternSets []string `type:"list"`

	// The token used to retrieve the next page of results. This value is null when
	// there are no more results to return.
	NextToken *string `type:"string"`

	// The name of the resource group.
	ResourceGroupName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListLogPatternSetsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListLogPatternSets = "ListLogPatternSets"

// ListLogPatternSetsRequest returns a request value for making API operation for
// Amazon CloudWatch Application Insights.
//
// Lists the log pattern sets in the specific application.
//
//    // Example sending a request using ListLogPatternSetsRequest.
//    req := client.ListLogPatternSetsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/ListLogPatternSets
func (c *Client) ListLogPatternSetsRequest(input *ListLogPatternSetsInput) ListLogPatternSetsRequest {
	op := &aws.Operation{
		Name:       opListLogPatternSets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListLogPatternSetsInput{}
	}

	req := c.newRequest(op, input, &ListLogPatternSetsOutput{})
	return ListLogPatternSetsRequest{Request: req, Input: input, Copy: c.ListLogPatternSetsRequest}
}

// ListLogPatternSetsRequest is the request type for the
// ListLogPatternSets API operation.
type ListLogPatternSetsRequest struct {
	*aws.Request
	Input *ListLogPatternSetsInput
	Copy  func(*ListLogPatternSetsInput) ListLogPatternSetsRequest
}

// Send marshals and sends the ListLogPatternSets API request.
func (r ListLogPatternSetsRequest) Send(ctx context.Context) (*ListLogPatternSetsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListLogPatternSetsResponse{
		ListLogPatternSetsOutput: r.Request.Data.(*ListLogPatternSetsOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListLogPatternSetsRequestPaginator returns a paginator for ListLogPatternSets.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListLogPatternSetsRequest(input)
//   p := applicationinsights.NewListLogPatternSetsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListLogPatternSetsPaginator(req ListLogPatternSetsRequest) ListLogPatternSetsPaginator {
	return ListLogPatternSetsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListLogPatternSetsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListLogPatternSetsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListLogPatternSetsPaginator struct {
	aws.Pager
}

func (p *ListLogPatternSetsPaginator) CurrentPage() *ListLogPatternSetsOutput {
	return p.Pager.CurrentPage().(*ListLogPatternSetsOutput)
}

// ListLogPatternSetsResponse is the response type for the
// ListLogPatternSets API operation.
type ListLogPatternSetsResponse struct {
	*ListLogPatternSetsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListLogPatternSets request.
func (r *ListLogPatternSetsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
