// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cognitoidentityprovider

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents the request to get the device, as an administrator.
type AdminGetDeviceInput struct {
	_ struct{} `type:"structure"`

	// The device key.
	//
	// DeviceKey is a required field
	DeviceKey *string `min:"1" type:"string" required:"true"`

	// The user pool ID.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`

	// The user name.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation
func (s AdminGetDeviceInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminGetDeviceInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AdminGetDeviceInput"}

	if s.DeviceKey == nil {
		invalidParams.Add(aws.NewErrParamRequired("DeviceKey"))
	}
	if s.DeviceKey != nil && len(*s.DeviceKey) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DeviceKey", 1))
	}

	if s.UserPoolId == nil {
		invalidParams.Add(aws.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("UserPoolId", 1))
	}

	if s.Username == nil {
		invalidParams.Add(aws.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Gets the device response, as an administrator.
type AdminGetDeviceOutput struct {
	_ struct{} `type:"structure"`

	// The device.
	//
	// Device is a required field
	Device *DeviceType `type:"structure" required:"true"`
}

// String returns the string representation
func (s AdminGetDeviceOutput) String() string {
	return awsutil.Prettify(s)
}

const opAdminGetDevice = "AdminGetDevice"

// AdminGetDeviceRequest returns a request value for making API operation for
// Amazon Cognito Identity Provider.
//
// Gets the device, as an administrator.
//
// Calling this action requires developer credentials.
//
//    // Example sending a request using AdminGetDeviceRequest.
//    req := client.AdminGetDeviceRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminGetDevice
func (c *Client) AdminGetDeviceRequest(input *AdminGetDeviceInput) AdminGetDeviceRequest {
	op := &aws.Operation{
		Name:       opAdminGetDevice,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AdminGetDeviceInput{}
	}

	req := c.newRequest(op, input, &AdminGetDeviceOutput{})
	return AdminGetDeviceRequest{Request: req, Input: input, Copy: c.AdminGetDeviceRequest}
}

// AdminGetDeviceRequest is the request type for the
// AdminGetDevice API operation.
type AdminGetDeviceRequest struct {
	*aws.Request
	Input *AdminGetDeviceInput
	Copy  func(*AdminGetDeviceInput) AdminGetDeviceRequest
}

// Send marshals and sends the AdminGetDevice API request.
func (r AdminGetDeviceRequest) Send(ctx context.Context) (*AdminGetDeviceResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &AdminGetDeviceResponse{
		AdminGetDeviceOutput: r.Request.Data.(*AdminGetDeviceOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// AdminGetDeviceResponse is the response type for the
// AdminGetDevice API operation.
type AdminGetDeviceResponse struct {
	*AdminGetDeviceOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// AdminGetDevice request.
func (r *AdminGetDeviceResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
