// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package mturk

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListBonusPaymentsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the assignment associated with the bonus payments to retrieve.
	// If specified, only bonus payments for the given assignment are returned.
	// Either the HITId parameter or the AssignmentId parameter must be specified
	AssignmentId *string `min:"1" type:"string"`

	// The ID of the HIT associated with the bonus payments to retrieve. If not
	// specified, all bonus payments for all assignments for the given HIT are returned.
	// Either the HITId parameter or the AssignmentId parameter must be specified
	HITId *string `min:"1" type:"string"`

	MaxResults *int64 `min:"1" type:"integer"`

	// Pagination token
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListBonusPaymentsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListBonusPaymentsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListBonusPaymentsInput"}
	if s.AssignmentId != nil && len(*s.AssignmentId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AssignmentId", 1))
	}
	if s.HITId != nil && len(*s.HITId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("HITId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListBonusPaymentsOutput struct {
	_ struct{} `type:"structure"`

	// A successful request to the ListBonusPayments operation returns a list of
	// BonusPayment objects.
	BonusPayments []BonusPayment `type:"list"`

	// If the previous response was incomplete (because there is more data to retrieve),
	// Amazon Mechanical Turk returns a pagination token in the response. You can
	// use this pagination token to retrieve the next set of results.
	NextToken *string `min:"1" type:"string"`

	// The number of bonus payments on this page in the filtered results list, equivalent
	// to the number of bonus payments being returned by this call.
	NumResults *int64 `type:"integer"`
}

// String returns the string representation
func (s ListBonusPaymentsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListBonusPayments = "ListBonusPayments"

// ListBonusPaymentsRequest returns a request value for making API operation for
// Amazon Mechanical Turk.
//
// The ListBonusPayments operation retrieves the amounts of bonuses you have
// paid to Workers for a given HIT or assignment.
//
//    // Example sending a request using ListBonusPaymentsRequest.
//    req := client.ListBonusPaymentsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ListBonusPayments
func (c *Client) ListBonusPaymentsRequest(input *ListBonusPaymentsInput) ListBonusPaymentsRequest {
	op := &aws.Operation{
		Name:       opListBonusPayments,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListBonusPaymentsInput{}
	}

	req := c.newRequest(op, input, &ListBonusPaymentsOutput{})
	return ListBonusPaymentsRequest{Request: req, Input: input, Copy: c.ListBonusPaymentsRequest}
}

// ListBonusPaymentsRequest is the request type for the
// ListBonusPayments API operation.
type ListBonusPaymentsRequest struct {
	*aws.Request
	Input *ListBonusPaymentsInput
	Copy  func(*ListBonusPaymentsInput) ListBonusPaymentsRequest
}

// Send marshals and sends the ListBonusPayments API request.
func (r ListBonusPaymentsRequest) Send(ctx context.Context) (*ListBonusPaymentsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListBonusPaymentsResponse{
		ListBonusPaymentsOutput: r.Request.Data.(*ListBonusPaymentsOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListBonusPaymentsRequestPaginator returns a paginator for ListBonusPayments.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListBonusPaymentsRequest(input)
//   p := mturk.NewListBonusPaymentsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListBonusPaymentsPaginator(req ListBonusPaymentsRequest) ListBonusPaymentsPaginator {
	return ListBonusPaymentsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListBonusPaymentsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListBonusPaymentsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListBonusPaymentsPaginator struct {
	aws.Pager
}

func (p *ListBonusPaymentsPaginator) CurrentPage() *ListBonusPaymentsOutput {
	return p.Pager.CurrentPage().(*ListBonusPaymentsOutput)
}

// ListBonusPaymentsResponse is the response type for the
// ListBonusPayments API operation.
type ListBonusPaymentsResponse struct {
	*ListBonusPaymentsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListBonusPayments request.
func (r *ListBonusPaymentsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
