// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package opsworks

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

type AttachElasticLoadBalancerInput struct {
	_ struct{} `type:"structure"`

	// The Elastic Load Balancing instance's name.
	//
	// ElasticLoadBalancerName is a required field
	ElasticLoadBalancerName *string `type:"string" required:"true"`

	// The ID of the layer to which the Elastic Load Balancing instance is to be
	// attached.
	//
	// LayerId is a required field
	LayerId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AttachElasticLoadBalancerInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttachElasticLoadBalancerInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AttachElasticLoadBalancerInput"}

	if s.ElasticLoadBalancerName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ElasticLoadBalancerName"))
	}

	if s.LayerId == nil {
		invalidParams.Add(aws.NewErrParamRequired("LayerId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type AttachElasticLoadBalancerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AttachElasticLoadBalancerOutput) String() string {
	return awsutil.Prettify(s)
}

const opAttachElasticLoadBalancer = "AttachElasticLoadBalancer"

// AttachElasticLoadBalancerRequest returns a request value for making API operation for
// AWS OpsWorks.
//
// Attaches an Elastic Load Balancing load balancer to a specified layer. AWS
// OpsWorks Stacks does not support Application Load Balancer. You can only
// use Classic Load Balancer with AWS OpsWorks Stacks. For more information,
// see Elastic Load Balancing (https://docs.aws.amazon.com/opsworks/latest/userguide/layers-elb.html).
//
// You must create the Elastic Load Balancing instance separately, by using
// the Elastic Load Balancing console, API, or CLI. For more information, see
// Elastic Load Balancing Developer Guide (https://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/Welcome.html).
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
//    // Example sending a request using AttachElasticLoadBalancerRequest.
//    req := client.AttachElasticLoadBalancerRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/AttachElasticLoadBalancer
func (c *Client) AttachElasticLoadBalancerRequest(input *AttachElasticLoadBalancerInput) AttachElasticLoadBalancerRequest {
	op := &aws.Operation{
		Name:       opAttachElasticLoadBalancer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AttachElasticLoadBalancerInput{}
	}

	req := c.newRequest(op, input, &AttachElasticLoadBalancerOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return AttachElasticLoadBalancerRequest{Request: req, Input: input, Copy: c.AttachElasticLoadBalancerRequest}
}

// AttachElasticLoadBalancerRequest is the request type for the
// AttachElasticLoadBalancer API operation.
type AttachElasticLoadBalancerRequest struct {
	*aws.Request
	Input *AttachElasticLoadBalancerInput
	Copy  func(*AttachElasticLoadBalancerInput) AttachElasticLoadBalancerRequest
}

// Send marshals and sends the AttachElasticLoadBalancer API request.
func (r AttachElasticLoadBalancerRequest) Send(ctx context.Context) (*AttachElasticLoadBalancerResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &AttachElasticLoadBalancerResponse{
		AttachElasticLoadBalancerOutput: r.Request.Data.(*AttachElasticLoadBalancerOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// AttachElasticLoadBalancerResponse is the response type for the
// AttachElasticLoadBalancer API operation.
type AttachElasticLoadBalancerResponse struct {
	*AttachElasticLoadBalancerOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// AttachElasticLoadBalancer request.
func (r *AttachElasticLoadBalancerResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
