// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.13.0
// source: google/ads/googleads/v6/common/metrics.proto

package common

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	enums "google.golang.org/genproto/googleapis/ads/googleads/v6/enums"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Metrics data.
type Metrics struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The percent of your ad impressions that are shown as the very first ad
	// above the organic search results.
	AbsoluteTopImpressionPercentage *float64 `protobuf:"fixed64,183,opt,name=absolute_top_impression_percentage,json=absoluteTopImpressionPercentage,proto3,oneof" json:"absolute_top_impression_percentage,omitempty"`
	// Average cost of viewable impressions (`active_view_impressions`).
	ActiveViewCpm *float64 `protobuf:"fixed64,184,opt,name=active_view_cpm,json=activeViewCpm,proto3,oneof" json:"active_view_cpm,omitempty"`
	// Active view measurable clicks divided by active view viewable impressions.
	// This metric is reported only for display network.
	ActiveViewCtr *float64 `protobuf:"fixed64,185,opt,name=active_view_ctr,json=activeViewCtr,proto3,oneof" json:"active_view_ctr,omitempty"`
	// A measurement of how often your ad has become viewable on a Display
	// Network site.
	ActiveViewImpressions *int64 `protobuf:"varint,186,opt,name=active_view_impressions,json=activeViewImpressions,proto3,oneof" json:"active_view_impressions,omitempty"`
	// The ratio of impressions that could be measured by Active View over the
	// number of served impressions.
	ActiveViewMeasurability *float64 `protobuf:"fixed64,187,opt,name=active_view_measurability,json=activeViewMeasurability,proto3,oneof" json:"active_view_measurability,omitempty"`
	// The cost of the impressions you received that were measurable by Active
	// View.
	ActiveViewMeasurableCostMicros *int64 `protobuf:"varint,188,opt,name=active_view_measurable_cost_micros,json=activeViewMeasurableCostMicros,proto3,oneof" json:"active_view_measurable_cost_micros,omitempty"`
	// The number of times your ads are appearing on placements in positions
	// where they can be seen.
	ActiveViewMeasurableImpressions *int64 `protobuf:"varint,189,opt,name=active_view_measurable_impressions,json=activeViewMeasurableImpressions,proto3,oneof" json:"active_view_measurable_impressions,omitempty"`
	// The percentage of time when your ad appeared on an Active View enabled site
	// (measurable impressions) and was viewable (viewable impressions).
	ActiveViewViewability *float64 `protobuf:"fixed64,190,opt,name=active_view_viewability,json=activeViewViewability,proto3,oneof" json:"active_view_viewability,omitempty"`
	// All conversions from interactions (as oppose to view through conversions)
	// divided by the number of ad interactions.
	AllConversionsFromInteractionsRate *float64 `protobuf:"fixed64,191,opt,name=all_conversions_from_interactions_rate,json=allConversionsFromInteractionsRate,proto3,oneof" json:"all_conversions_from_interactions_rate,omitempty"`
	// The value of all conversions.
	AllConversionsValue *float64 `protobuf:"fixed64,192,opt,name=all_conversions_value,json=allConversionsValue,proto3,oneof" json:"all_conversions_value,omitempty"`
	// The total number of conversions. This includes all conversions regardless
	// of the value of include_in_conversions_metric.
	AllConversions *float64 `protobuf:"fixed64,193,opt,name=all_conversions,json=allConversions,proto3,oneof" json:"all_conversions,omitempty"`
	// The value of all conversions divided by the total cost of ad interactions
	// (such as clicks for text ads or views for video ads).
	AllConversionsValuePerCost *float64 `protobuf:"fixed64,194,opt,name=all_conversions_value_per_cost,json=allConversionsValuePerCost,proto3,oneof" json:"all_conversions_value_per_cost,omitempty"`
	// The number of times people clicked the "Call" button to call a store during
	// or after clicking an ad. This number doesn't include whether or not calls
	// were connected, or the duration of any calls.
	// This metric applies to feed items only.
	AllConversionsFromClickToCall *float64 `protobuf:"fixed64,195,opt,name=all_conversions_from_click_to_call,json=allConversionsFromClickToCall,proto3,oneof" json:"all_conversions_from_click_to_call,omitempty"`
	// The number of times people clicked a "Get directions" button to navigate to
	// a store after clicking an ad.
	// This metric applies to feed items only.
	AllConversionsFromDirections *float64 `protobuf:"fixed64,196,opt,name=all_conversions_from_directions,json=allConversionsFromDirections,proto3,oneof" json:"all_conversions_from_directions,omitempty"`
	// The value of all conversions from interactions divided by the total number
	// of interactions.
	AllConversionsFromInteractionsValuePerInteraction *float64 `protobuf:"fixed64,197,opt,name=all_conversions_from_interactions_value_per_interaction,json=allConversionsFromInteractionsValuePerInteraction,proto3,oneof" json:"all_conversions_from_interactions_value_per_interaction,omitempty"`
	// The number of times people clicked a link to view a store's menu after
	// clicking an ad.
	// This metric applies to feed items only.
	AllConversionsFromMenu *float64 `protobuf:"fixed64,198,opt,name=all_conversions_from_menu,json=allConversionsFromMenu,proto3,oneof" json:"all_conversions_from_menu,omitempty"`
	// The number of times people placed an order at a store after clicking an ad.
	// This metric applies to feed items only.
	AllConversionsFromOrder *float64 `protobuf:"fixed64,199,opt,name=all_conversions_from_order,json=allConversionsFromOrder,proto3,oneof" json:"all_conversions_from_order,omitempty"`
	// The number of other conversions (for example, posting a review or saving a
	// location for a store) that occurred after people clicked an ad.
	// This metric applies to feed items only.
	AllConversionsFromOtherEngagement *float64 `protobuf:"fixed64,200,opt,name=all_conversions_from_other_engagement,json=allConversionsFromOtherEngagement,proto3,oneof" json:"all_conversions_from_other_engagement,omitempty"`
	// Estimated number of times people visited a store after clicking an ad.
	// This metric applies to feed items only.
	AllConversionsFromStoreVisit *float64 `protobuf:"fixed64,201,opt,name=all_conversions_from_store_visit,json=allConversionsFromStoreVisit,proto3,oneof" json:"all_conversions_from_store_visit,omitempty"`
	// The number of times that people were taken to a store's URL after clicking
	// an ad.
	// This metric applies to feed items only.
	AllConversionsFromStoreWebsite *float64 `protobuf:"fixed64,202,opt,name=all_conversions_from_store_website,json=allConversionsFromStoreWebsite,proto3,oneof" json:"all_conversions_from_store_website,omitempty"`
	// The average amount you pay per interaction. This amount is the total cost
	// of your ads divided by the total number of interactions.
	AverageCost *float64 `protobuf:"fixed64,203,opt,name=average_cost,json=averageCost,proto3,oneof" json:"average_cost,omitempty"`
	// The total cost of all clicks divided by the total number of clicks
	// received.
	AverageCpc *float64 `protobuf:"fixed64,204,opt,name=average_cpc,json=averageCpc,proto3,oneof" json:"average_cpc,omitempty"`
	// The average amount that you've been charged for an ad engagement. This
	// amount is the total cost of all ad engagements divided by the total number
	// of ad engagements.
	AverageCpe *float64 `protobuf:"fixed64,205,opt,name=average_cpe,json=averageCpe,proto3,oneof" json:"average_cpe,omitempty"`
	// Average cost-per-thousand impressions (CPM).
	AverageCpm *float64 `protobuf:"fixed64,206,opt,name=average_cpm,json=averageCpm,proto3,oneof" json:"average_cpm,omitempty"`
	// The average amount you pay each time someone views your ad.
	// The average CPV is defined by the total cost of all ad views divided by
	// the number of views.
	AverageCpv *float64 `protobuf:"fixed64,207,opt,name=average_cpv,json=averageCpv,proto3,oneof" json:"average_cpv,omitempty"`
	// Average number of pages viewed per session.
	AveragePageViews *float64 `protobuf:"fixed64,208,opt,name=average_page_views,json=averagePageViews,proto3,oneof" json:"average_page_views,omitempty"`
	// Total duration of all sessions (in seconds) / number of sessions. Imported
	// from Google Analytics.
	AverageTimeOnSite *float64 `protobuf:"fixed64,209,opt,name=average_time_on_site,json=averageTimeOnSite,proto3,oneof" json:"average_time_on_site,omitempty"`
	// An indication of how other advertisers are bidding on similar products.
	BenchmarkAverageMaxCpc *float64 `protobuf:"fixed64,210,opt,name=benchmark_average_max_cpc,json=benchmarkAverageMaxCpc,proto3,oneof" json:"benchmark_average_max_cpc,omitempty"`
	// An indication on how other advertisers' Shopping ads for similar products
	// are performing based on how often people who see their ad click on it.
	BenchmarkCtr *float64 `protobuf:"fixed64,211,opt,name=benchmark_ctr,json=benchmarkCtr,proto3,oneof" json:"benchmark_ctr,omitempty"`
	// Percentage of clicks where the user only visited a single page on your
	// site. Imported from Google Analytics.
	BounceRate *float64 `protobuf:"fixed64,212,opt,name=bounce_rate,json=bounceRate,proto3,oneof" json:"bounce_rate,omitempty"`
	// The number of clicks.
	Clicks *int64 `protobuf:"varint,131,opt,name=clicks,proto3,oneof" json:"clicks,omitempty"`
	// The number of times your ad or your site's listing in the unpaid
	// results was clicked. See the help page at
	// https://support.google.com/google-ads/answer/3097241 for details.
	CombinedClicks *int64 `protobuf:"varint,156,opt,name=combined_clicks,json=combinedClicks,proto3,oneof" json:"combined_clicks,omitempty"`
	// The number of times your ad or your site's listing in the unpaid
	// results was clicked (combined_clicks) divided by combined_queries. See the
	// help page at https://support.google.com/google-ads/answer/3097241 for
	// details.
	CombinedClicksPerQuery *float64 `protobuf:"fixed64,157,opt,name=combined_clicks_per_query,json=combinedClicksPerQuery,proto3,oneof" json:"combined_clicks_per_query,omitempty"`
	// The number of searches that returned pages from your site in the unpaid
	// results or showed one of your text ads. See the help page at
	// https://support.google.com/google-ads/answer/3097241 for details.
	CombinedQueries *int64 `protobuf:"varint,158,opt,name=combined_queries,json=combinedQueries,proto3,oneof" json:"combined_queries,omitempty"`
	// The estimated percent of times that your ad was eligible to show
	// on the Display Network but didn't because your budget was too low.
	// Note: Content budget lost impression share is reported in the range of 0
	// to 0.9. Any value above 0.9 is reported as 0.9001.
	ContentBudgetLostImpressionShare *float64 `protobuf:"fixed64,159,opt,name=content_budget_lost_impression_share,json=contentBudgetLostImpressionShare,proto3,oneof" json:"content_budget_lost_impression_share,omitempty"`
	// The impressions you've received on the Display Network divided
	// by the estimated number of impressions you were eligible to receive.
	// Note: Content impression share is reported in the range of 0.1 to 1. Any
	// value below 0.1 is reported as 0.0999.
	ContentImpressionShare *float64 `protobuf:"fixed64,160,opt,name=content_impression_share,json=contentImpressionShare,proto3,oneof" json:"content_impression_share,omitempty"`
	// The last date/time a conversion tag for this conversion action successfully
	// fired and was seen by Google Ads. This firing event may not have been the
	// result of an attributable conversion (e.g. because the tag was fired from a
	// browser that did not previously click an ad from an appropriate
	// advertiser). The date/time is in the customer's time zone.
	ConversionLastReceivedRequestDateTime *string `protobuf:"bytes,161,opt,name=conversion_last_received_request_date_time,json=conversionLastReceivedRequestDateTime,proto3,oneof" json:"conversion_last_received_request_date_time,omitempty"`
	// The date of the most recent conversion for this conversion action. The date
	// is in the customer's time zone.
	ConversionLastConversionDate *string `protobuf:"bytes,162,opt,name=conversion_last_conversion_date,json=conversionLastConversionDate,proto3,oneof" json:"conversion_last_conversion_date,omitempty"`
	// The estimated percentage of impressions on the Display Network
	// that your ads didn't receive due to poor Ad Rank.
	// Note: Content rank lost impression share is reported in the range of 0
	// to 0.9. Any value above 0.9 is reported as 0.9001.
	ContentRankLostImpressionShare *float64 `protobuf:"fixed64,163,opt,name=content_rank_lost_impression_share,json=contentRankLostImpressionShare,proto3,oneof" json:"content_rank_lost_impression_share,omitempty"`
	// Conversions from interactions divided by the number of ad interactions
	// (such as clicks for text ads or views for video ads). This only includes
	// conversion actions which include_in_conversions_metric attribute is set to
	// true. If you use conversion-based bidding, your bid strategies will
	// optimize for these conversions.
	ConversionsFromInteractionsRate *float64 `protobuf:"fixed64,164,opt,name=conversions_from_interactions_rate,json=conversionsFromInteractionsRate,proto3,oneof" json:"conversions_from_interactions_rate,omitempty"`
	// The value of conversions. This only includes conversion actions which
	// include_in_conversions_metric attribute is set to true. If you use
	// conversion-based bidding, your bid strategies will optimize for these
	// conversions.
	ConversionsValue *float64 `protobuf:"fixed64,165,opt,name=conversions_value,json=conversionsValue,proto3,oneof" json:"conversions_value,omitempty"`
	// The value of conversions divided by the cost of ad interactions. This only
	// includes conversion actions which include_in_conversions_metric attribute
	// is set to true. If you use conversion-based bidding, your bid strategies
	// will optimize for these conversions.
	ConversionsValuePerCost *float64 `protobuf:"fixed64,166,opt,name=conversions_value_per_cost,json=conversionsValuePerCost,proto3,oneof" json:"conversions_value_per_cost,omitempty"`
	// The value of conversions from interactions divided by the number of ad
	// interactions. This only includes conversion actions which
	// include_in_conversions_metric attribute is set to true. If you use
	// conversion-based bidding, your bid strategies will optimize for these
	// conversions.
	ConversionsFromInteractionsValuePerInteraction *float64 `protobuf:"fixed64,167,opt,name=conversions_from_interactions_value_per_interaction,json=conversionsFromInteractionsValuePerInteraction,proto3,oneof" json:"conversions_from_interactions_value_per_interaction,omitempty"`
	// The number of conversions. This only includes conversion actions which
	// include_in_conversions_metric attribute is set to true. If you use
	// conversion-based bidding, your bid strategies will optimize for these
	// conversions.
	Conversions *float64 `protobuf:"fixed64,168,opt,name=conversions,proto3,oneof" json:"conversions,omitempty"`
	// The sum of your cost-per-click (CPC) and cost-per-thousand impressions
	// (CPM) costs during this period.
	CostMicros *int64 `protobuf:"varint,169,opt,name=cost_micros,json=costMicros,proto3,oneof" json:"cost_micros,omitempty"`
	// The cost of ad interactions divided by all conversions.
	CostPerAllConversions *float64 `protobuf:"fixed64,170,opt,name=cost_per_all_conversions,json=costPerAllConversions,proto3,oneof" json:"cost_per_all_conversions,omitempty"`
	// The cost of ad interactions divided by conversions. This only includes
	// conversion actions which include_in_conversions_metric attribute is set to
	// true. If you use conversion-based bidding, your bid strategies will
	// optimize for these conversions.
	CostPerConversion *float64 `protobuf:"fixed64,171,opt,name=cost_per_conversion,json=costPerConversion,proto3,oneof" json:"cost_per_conversion,omitempty"`
	// The cost of ad interactions divided by current model attributed
	// conversions. This only includes conversion actions which
	// include_in_conversions_metric attribute is set to true. If you use
	// conversion-based bidding, your bid strategies will optimize for these
	// conversions.
	CostPerCurrentModelAttributedConversion *float64 `protobuf:"fixed64,172,opt,name=cost_per_current_model_attributed_conversion,json=costPerCurrentModelAttributedConversion,proto3,oneof" json:"cost_per_current_model_attributed_conversion,omitempty"`
	// Conversions from when a customer clicks on a Google Ads ad on one device,
	// then converts on a different device or browser.
	// Cross-device conversions are already included in all_conversions.
	CrossDeviceConversions *float64 `protobuf:"fixed64,173,opt,name=cross_device_conversions,json=crossDeviceConversions,proto3,oneof" json:"cross_device_conversions,omitempty"`
	// The number of clicks your ad receives (Clicks) divided by the number
	// of times your ad is shown (Impressions).
	Ctr *float64 `protobuf:"fixed64,174,opt,name=ctr,proto3,oneof" json:"ctr,omitempty"`
	// Shows how your historic conversions data would look under the attribution
	// model you've currently selected. This only includes conversion actions
	// which include_in_conversions_metric attribute is set to true. If you use
	// conversion-based bidding, your bid strategies will optimize for these
	// conversions.
	CurrentModelAttributedConversions *float64 `protobuf:"fixed64,175,opt,name=current_model_attributed_conversions,json=currentModelAttributedConversions,proto3,oneof" json:"current_model_attributed_conversions,omitempty"`
	// Current model attributed conversions from interactions divided by the
	// number of ad interactions (such as clicks for text ads or views for video
	// ads). This only includes conversion actions which
	// include_in_conversions_metric attribute is set to true. If you use
	// conversion-based bidding, your bid strategies will optimize for these
	// conversions.
	CurrentModelAttributedConversionsFromInteractionsRate *float64 `protobuf:"fixed64,176,opt,name=current_model_attributed_conversions_from_interactions_rate,json=currentModelAttributedConversionsFromInteractionsRate,proto3,oneof" json:"current_model_attributed_conversions_from_interactions_rate,omitempty"`
	// The value of current model attributed conversions from interactions divided
	// by the number of ad interactions. This only includes conversion actions
	// which include_in_conversions_metric attribute is set to true. If you use
	// conversion-based bidding, your bid strategies will optimize for these
	// conversions.
	CurrentModelAttributedConversionsFromInteractionsValuePerInteraction *float64 `protobuf:"fixed64,177,opt,name=current_model_attributed_conversions_from_interactions_value_per_interaction,json=currentModelAttributedConversionsFromInteractionsValuePerInteraction,proto3,oneof" json:"current_model_attributed_conversions_from_interactions_value_per_interaction,omitempty"`
	// The value of current model attributed conversions. This only includes
	// conversion actions which include_in_conversions_metric attribute is set to
	// true. If you use conversion-based bidding, your bid strategies will
	// optimize for these conversions.
	CurrentModelAttributedConversionsValue *float64 `protobuf:"fixed64,178,opt,name=current_model_attributed_conversions_value,json=currentModelAttributedConversionsValue,proto3,oneof" json:"current_model_attributed_conversions_value,omitempty"`
	// The value of current model attributed conversions divided by the cost of ad
	// interactions. This only includes conversion actions which
	// include_in_conversions_metric attribute is set to true. If you use
	// conversion-based bidding, your bid strategies will optimize for these
	// conversions.
	CurrentModelAttributedConversionsValuePerCost *float64 `protobuf:"fixed64,179,opt,name=current_model_attributed_conversions_value_per_cost,json=currentModelAttributedConversionsValuePerCost,proto3,oneof" json:"current_model_attributed_conversions_value_per_cost,omitempty"`
	// How often people engage with your ad after it's shown to them. This is the
	// number of ad expansions divided by the number of times your ad is shown.
	EngagementRate *float64 `protobuf:"fixed64,180,opt,name=engagement_rate,json=engagementRate,proto3,oneof" json:"engagement_rate,omitempty"`
	// The number of engagements.
	// An engagement occurs when a viewer expands your Lightbox ad. Also, in the
	// future, other ad types may support engagement metrics.
	Engagements *int64 `protobuf:"varint,181,opt,name=engagements,proto3,oneof" json:"engagements,omitempty"`
	// Average lead value based on clicks.
	HotelAverageLeadValueMicros *float64 `protobuf:"fixed64,213,opt,name=hotel_average_lead_value_micros,json=hotelAverageLeadValueMicros,proto3,oneof" json:"hotel_average_lead_value_micros,omitempty"`
	// The average price difference between the price offered by reporting hotel
	// advertiser and the cheapest price offered by the competing advertiser.
	HotelPriceDifferencePercentage *float64 `protobuf:"fixed64,214,opt,name=hotel_price_difference_percentage,json=hotelPriceDifferencePercentage,proto3,oneof" json:"hotel_price_difference_percentage,omitempty"`
	// The number of impressions that hotel partners could have had given their
	// feed performance.
	HotelEligibleImpressions *int64 `protobuf:"varint,215,opt,name=hotel_eligible_impressions,json=hotelEligibleImpressions,proto3,oneof" json:"hotel_eligible_impressions,omitempty"`
	// The creative historical quality score.
	HistoricalCreativeQualityScore enums.QualityScoreBucketEnum_QualityScoreBucket `protobuf:"varint,80,opt,name=historical_creative_quality_score,json=historicalCreativeQualityScore,proto3,enum=google.ads.googleads.v6.enums.QualityScoreBucketEnum_QualityScoreBucket" json:"historical_creative_quality_score,omitempty"`
	// The quality of historical landing page experience.
	HistoricalLandingPageQualityScore enums.QualityScoreBucketEnum_QualityScoreBucket `protobuf:"varint,81,opt,name=historical_landing_page_quality_score,json=historicalLandingPageQualityScore,proto3,enum=google.ads.googleads.v6.enums.QualityScoreBucketEnum_QualityScoreBucket" json:"historical_landing_page_quality_score,omitempty"`
	// The historical quality score.
	HistoricalQualityScore *int64 `protobuf:"varint,216,opt,name=historical_quality_score,json=historicalQualityScore,proto3,oneof" json:"historical_quality_score,omitempty"`
	// The historical search predicted click through rate (CTR).
	HistoricalSearchPredictedCtr enums.QualityScoreBucketEnum_QualityScoreBucket `protobuf:"varint,83,opt,name=historical_search_predicted_ctr,json=historicalSearchPredictedCtr,proto3,enum=google.ads.googleads.v6.enums.QualityScoreBucketEnum_QualityScoreBucket" json:"historical_search_predicted_ctr,omitempty"`
	// The number of times the ad was forwarded to someone else as a message.
	GmailForwards *int64 `protobuf:"varint,217,opt,name=gmail_forwards,json=gmailForwards,proto3,oneof" json:"gmail_forwards,omitempty"`
	// The number of times someone has saved your Gmail ad to their inbox as a
	// message.
	GmailSaves *int64 `protobuf:"varint,218,opt,name=gmail_saves,json=gmailSaves,proto3,oneof" json:"gmail_saves,omitempty"`
	// The number of clicks to the landing page on the expanded state of Gmail
	// ads.
	GmailSecondaryClicks *int64 `protobuf:"varint,219,opt,name=gmail_secondary_clicks,json=gmailSecondaryClicks,proto3,oneof" json:"gmail_secondary_clicks,omitempty"`
	// The number of times a store's location-based ad was shown.
	// This metric applies to feed items only.
	ImpressionsFromStoreReach *int64 `protobuf:"varint,220,opt,name=impressions_from_store_reach,json=impressionsFromStoreReach,proto3,oneof" json:"impressions_from_store_reach,omitempty"`
	// Count of how often your ad has appeared on a search results page or
	// website on the Google Network.
	Impressions *int64 `protobuf:"varint,221,opt,name=impressions,proto3,oneof" json:"impressions,omitempty"`
	// How often people interact with your ad after it is shown to them.
	// This is the number of interactions divided by the number of times your ad
	// is shown.
	InteractionRate *float64 `protobuf:"fixed64,222,opt,name=interaction_rate,json=interactionRate,proto3,oneof" json:"interaction_rate,omitempty"`
	// The number of interactions.
	// An interaction is the main user action associated with an ad format-clicks
	// for text and shopping ads, views for video ads, and so on.
	Interactions *int64 `protobuf:"varint,223,opt,name=interactions,proto3,oneof" json:"interactions,omitempty"`
	// The types of payable and free interactions.
	InteractionEventTypes []enums.InteractionEventTypeEnum_InteractionEventType `protobuf:"varint,100,rep,packed,name=interaction_event_types,json=interactionEventTypes,proto3,enum=google.ads.googleads.v6.enums.InteractionEventTypeEnum_InteractionEventType" json:"interaction_event_types,omitempty"`
	// The percentage of clicks filtered out of your total number of clicks
	// (filtered + non-filtered clicks) during the reporting period.
	InvalidClickRate *float64 `protobuf:"fixed64,224,opt,name=invalid_click_rate,json=invalidClickRate,proto3,oneof" json:"invalid_click_rate,omitempty"`
	// Number of clicks Google considers illegitimate and doesn't charge you for.
	InvalidClicks *int64 `protobuf:"varint,225,opt,name=invalid_clicks,json=invalidClicks,proto3,oneof" json:"invalid_clicks,omitempty"`
	// Number of message chats initiated for Click To Message impressions that
	// were message tracking eligible.
	MessageChats *int64 `protobuf:"varint,226,opt,name=message_chats,json=messageChats,proto3,oneof" json:"message_chats,omitempty"`
	// Number of Click To Message impressions that were message tracking eligible.
	MessageImpressions *int64 `protobuf:"varint,227,opt,name=message_impressions,json=messageImpressions,proto3,oneof" json:"message_impressions,omitempty"`
	// Number of message chats initiated (message_chats) divided by the number
	// of message impressions (message_impressions).
	// Rate at which a user initiates a message chat from an ad impression with
	// a messaging option and message tracking enabled.
	// Note that this rate can be more than 1.0 for a given message impression.
	MessageChatRate *float64 `protobuf:"fixed64,228,opt,name=message_chat_rate,json=messageChatRate,proto3,oneof" json:"message_chat_rate,omitempty"`
	// The percentage of mobile clicks that go to a mobile-friendly page.
	MobileFriendlyClicksPercentage *float64 `protobuf:"fixed64,229,opt,name=mobile_friendly_clicks_percentage,json=mobileFriendlyClicksPercentage,proto3,oneof" json:"mobile_friendly_clicks_percentage,omitempty"`
	// The number of times someone clicked your site's listing in the unpaid
	// results for a particular query. See the help page at
	// https://support.google.com/google-ads/answer/3097241 for details.
	OrganicClicks *int64 `protobuf:"varint,230,opt,name=organic_clicks,json=organicClicks,proto3,oneof" json:"organic_clicks,omitempty"`
	// The number of times someone clicked your site's listing in the unpaid
	// results (organic_clicks) divided by the total number of searches that
	// returned pages from your site (organic_queries). See the help page at
	// https://support.google.com/google-ads/answer/3097241 for details.
	OrganicClicksPerQuery *float64 `protobuf:"fixed64,231,opt,name=organic_clicks_per_query,json=organicClicksPerQuery,proto3,oneof" json:"organic_clicks_per_query,omitempty"`
	// The number of listings for your site in the unpaid search results. See the
	// help page at https://support.google.com/google-ads/answer/3097241 for
	// details.
	OrganicImpressions *int64 `protobuf:"varint,232,opt,name=organic_impressions,json=organicImpressions,proto3,oneof" json:"organic_impressions,omitempty"`
	// The number of times a page from your site was listed in the unpaid search
	// results (organic_impressions) divided by the number of searches returning
	// your site's listing in the unpaid results (organic_queries). See the help
	// page at https://support.google.com/google-ads/answer/3097241 for details.
	OrganicImpressionsPerQuery *float64 `protobuf:"fixed64,233,opt,name=organic_impressions_per_query,json=organicImpressionsPerQuery,proto3,oneof" json:"organic_impressions_per_query,omitempty"`
	// The total number of searches that returned your site's listing in the
	// unpaid results. See the help page at
	// https://support.google.com/google-ads/answer/3097241 for details.
	OrganicQueries *int64 `protobuf:"varint,234,opt,name=organic_queries,json=organicQueries,proto3,oneof" json:"organic_queries,omitempty"`
	// Percentage of first-time sessions (from people who had never visited your
	// site before). Imported from Google Analytics.
	PercentNewVisitors *float64 `protobuf:"fixed64,235,opt,name=percent_new_visitors,json=percentNewVisitors,proto3,oneof" json:"percent_new_visitors,omitempty"`
	// Number of offline phone calls.
	PhoneCalls *int64 `protobuf:"varint,236,opt,name=phone_calls,json=phoneCalls,proto3,oneof" json:"phone_calls,omitempty"`
	// Number of offline phone impressions.
	PhoneImpressions *int64 `protobuf:"varint,237,opt,name=phone_impressions,json=phoneImpressions,proto3,oneof" json:"phone_impressions,omitempty"`
	// Number of phone calls received (phone_calls) divided by the number of
	// times your phone number is shown (phone_impressions).
	PhoneThroughRate *float64 `protobuf:"fixed64,238,opt,name=phone_through_rate,json=phoneThroughRate,proto3,oneof" json:"phone_through_rate,omitempty"`
	// Your clickthrough rate (Ctr) divided by the average clickthrough rate of
	// all advertisers on the websites that show your ads. Measures how your ads
	// perform on Display Network sites compared to other ads on the same sites.
	RelativeCtr *float64 `protobuf:"fixed64,239,opt,name=relative_ctr,json=relativeCtr,proto3,oneof" json:"relative_ctr,omitempty"`
	// The percentage of the customer's Shopping or Search ad impressions that are
	// shown in the most prominent Shopping position. See
	// https://support.google.com/google-ads/answer/7501826
	// for details. Any value below 0.1 is reported as 0.0999.
	SearchAbsoluteTopImpressionShare *float64 `protobuf:"fixed64,136,opt,name=search_absolute_top_impression_share,json=searchAbsoluteTopImpressionShare,proto3,oneof" json:"search_absolute_top_impression_share,omitempty"`
	// The number estimating how often your ad wasn't the very first ad above the
	// organic search results due to a low budget. Note: Search
	// budget lost absolute top impression share is reported in the range of 0 to
	// 0.9. Any value above 0.9 is reported as 0.9001.
	SearchBudgetLostAbsoluteTopImpressionShare *float64 `protobuf:"fixed64,137,opt,name=search_budget_lost_absolute_top_impression_share,json=searchBudgetLostAbsoluteTopImpressionShare,proto3,oneof" json:"search_budget_lost_absolute_top_impression_share,omitempty"`
	// The estimated percent of times that your ad was eligible to show on the
	// Search Network but didn't because your budget was too low. Note: Search
	// budget lost impression share is reported in the range of 0 to 0.9. Any
	// value above 0.9 is reported as 0.9001.
	SearchBudgetLostImpressionShare *float64 `protobuf:"fixed64,138,opt,name=search_budget_lost_impression_share,json=searchBudgetLostImpressionShare,proto3,oneof" json:"search_budget_lost_impression_share,omitempty"`
	// The number estimating how often your ad didn't show anywhere above the
	// organic search results due to a low budget. Note: Search
	// budget lost top impression share is reported in the range of 0 to 0.9. Any
	// value above 0.9 is reported as 0.9001.
	SearchBudgetLostTopImpressionShare *float64 `protobuf:"fixed64,139,opt,name=search_budget_lost_top_impression_share,json=searchBudgetLostTopImpressionShare,proto3,oneof" json:"search_budget_lost_top_impression_share,omitempty"`
	// The number of clicks you've received on the Search Network
	// divided by the estimated number of clicks you were eligible to receive.
	// Note: Search click share is reported in the range of 0.1 to 1. Any value
	// below 0.1 is reported as 0.0999.
	SearchClickShare *float64 `protobuf:"fixed64,140,opt,name=search_click_share,json=searchClickShare,proto3,oneof" json:"search_click_share,omitempty"`
	// The impressions you've received divided by the estimated number of
	// impressions you were eligible to receive on the Search Network for search
	// terms that matched your keywords exactly (or were close variants of your
	// keyword), regardless of your keyword match types. Note: Search exact match
	// impression share is reported in the range of 0.1 to 1. Any value below 0.1
	// is reported as 0.0999.
	SearchExactMatchImpressionShare *float64 `protobuf:"fixed64,141,opt,name=search_exact_match_impression_share,json=searchExactMatchImpressionShare,proto3,oneof" json:"search_exact_match_impression_share,omitempty"`
	// The impressions you've received on the Search Network divided
	// by the estimated number of impressions you were eligible to receive.
	// Note: Search impression share is reported in the range of 0.1 to 1. Any
	// value below 0.1 is reported as 0.0999.
	SearchImpressionShare *float64 `protobuf:"fixed64,142,opt,name=search_impression_share,json=searchImpressionShare,proto3,oneof" json:"search_impression_share,omitempty"`
	// The number estimating how often your ad wasn't the very first ad above the
	// organic search results due to poor Ad Rank.
	// Note: Search rank lost absolute top impression share is reported in the
	// range of 0 to 0.9. Any value above 0.9 is reported as 0.9001.
	SearchRankLostAbsoluteTopImpressionShare *float64 `protobuf:"fixed64,143,opt,name=search_rank_lost_absolute_top_impression_share,json=searchRankLostAbsoluteTopImpressionShare,proto3,oneof" json:"search_rank_lost_absolute_top_impression_share,omitempty"`
	// The estimated percentage of impressions on the Search Network
	// that your ads didn't receive due to poor Ad Rank.
	// Note: Search rank lost impression share is reported in the range of 0 to
	// 0.9. Any value above 0.9 is reported as 0.9001.
	SearchRankLostImpressionShare *float64 `protobuf:"fixed64,144,opt,name=search_rank_lost_impression_share,json=searchRankLostImpressionShare,proto3,oneof" json:"search_rank_lost_impression_share,omitempty"`
	// The number estimating how often your ad didn't show anywhere above the
	// organic search results due to poor Ad Rank.
	// Note: Search rank lost top impression share is reported in the range of 0
	// to 0.9. Any value above 0.9 is reported as 0.9001.
	SearchRankLostTopImpressionShare *float64 `protobuf:"fixed64,145,opt,name=search_rank_lost_top_impression_share,json=searchRankLostTopImpressionShare,proto3,oneof" json:"search_rank_lost_top_impression_share,omitempty"`
	// The impressions you've received in the top location (anywhere above the
	// organic search results) compared to the estimated number of impressions you
	// were eligible to receive in the top location.
	// Note: Search top impression share is reported in the range of 0.1 to 1. Any
	// value below 0.1 is reported as 0.0999.
	SearchTopImpressionShare *float64 `protobuf:"fixed64,146,opt,name=search_top_impression_share,json=searchTopImpressionShare,proto3,oneof" json:"search_top_impression_share,omitempty"`
	// A measure of how quickly your page loads after clicks on your mobile ads.
	// The score is a range from 1 to 10, 10 being the fastest.
	SpeedScore *int64 `protobuf:"varint,147,opt,name=speed_score,json=speedScore,proto3,oneof" json:"speed_score,omitempty"`
	// The percent of your ad impressions that are shown anywhere above the
	// organic search results.
	TopImpressionPercentage *float64 `protobuf:"fixed64,148,opt,name=top_impression_percentage,json=topImpressionPercentage,proto3,oneof" json:"top_impression_percentage,omitempty"`
	// The percentage of ad clicks to Accelerated Mobile Pages (AMP) landing pages
	// that reach a valid AMP page.
	ValidAcceleratedMobilePagesClicksPercentage *float64 `protobuf:"fixed64,149,opt,name=valid_accelerated_mobile_pages_clicks_percentage,json=validAcceleratedMobilePagesClicksPercentage,proto3,oneof" json:"valid_accelerated_mobile_pages_clicks_percentage,omitempty"`
	// The value of all conversions divided by the number of all conversions.
	ValuePerAllConversions *float64 `protobuf:"fixed64,150,opt,name=value_per_all_conversions,json=valuePerAllConversions,proto3,oneof" json:"value_per_all_conversions,omitempty"`
	// The value of conversions divided by the number of conversions. This only
	// includes conversion actions which include_in_conversions_metric attribute
	// is set to true. If you use conversion-based bidding, your bid strategies
	// will optimize for these conversions.
	ValuePerConversion *float64 `protobuf:"fixed64,151,opt,name=value_per_conversion,json=valuePerConversion,proto3,oneof" json:"value_per_conversion,omitempty"`
	// The value of current model attributed conversions divided by the number of
	// the conversions. This only includes conversion actions which
	// include_in_conversions_metric attribute is set to true. If you use
	// conversion-based bidding, your bid strategies will optimize for these
	// conversions.
	ValuePerCurrentModelAttributedConversion *float64 `protobuf:"fixed64,152,opt,name=value_per_current_model_attributed_conversion,json=valuePerCurrentModelAttributedConversion,proto3,oneof" json:"value_per_current_model_attributed_conversion,omitempty"`
	// Percentage of impressions where the viewer watched all of your video.
	VideoQuartileP100Rate *float64 `protobuf:"fixed64,132,opt,name=video_quartile_p100_rate,json=videoQuartileP100Rate,proto3,oneof" json:"video_quartile_p100_rate,omitempty"`
	// Percentage of impressions where the viewer watched 25% of your video.
	VideoQuartileP25Rate *float64 `protobuf:"fixed64,133,opt,name=video_quartile_p25_rate,json=videoQuartileP25Rate,proto3,oneof" json:"video_quartile_p25_rate,omitempty"`
	// Percentage of impressions where the viewer watched 50% of your video.
	VideoQuartileP50Rate *float64 `protobuf:"fixed64,134,opt,name=video_quartile_p50_rate,json=videoQuartileP50Rate,proto3,oneof" json:"video_quartile_p50_rate,omitempty"`
	// Percentage of impressions where the viewer watched 75% of your video.
	VideoQuartileP75Rate *float64 `protobuf:"fixed64,135,opt,name=video_quartile_p75_rate,json=videoQuartileP75Rate,proto3,oneof" json:"video_quartile_p75_rate,omitempty"`
	// The number of views your TrueView video ad receives divided by its number
	// of impressions, including thumbnail impressions for TrueView in-display
	// ads.
	VideoViewRate *float64 `protobuf:"fixed64,153,opt,name=video_view_rate,json=videoViewRate,proto3,oneof" json:"video_view_rate,omitempty"`
	// The number of times your video ads were viewed.
	VideoViews *int64 `protobuf:"varint,154,opt,name=video_views,json=videoViews,proto3,oneof" json:"video_views,omitempty"`
	// The total number of view-through conversions.
	// These happen when a customer sees an image or rich media ad, then later
	// completes a conversion on your site without interacting with (e.g.,
	// clicking on) another ad.
	ViewThroughConversions *int64 `protobuf:"varint,155,opt,name=view_through_conversions,json=viewThroughConversions,proto3,oneof" json:"view_through_conversions,omitempty"`
}

func (x *Metrics) Reset() {
	*x = Metrics{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v6_common_metrics_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Metrics) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Metrics) ProtoMessage() {}

func (x *Metrics) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v6_common_metrics_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Metrics.ProtoReflect.Descriptor instead.
func (*Metrics) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v6_common_metrics_proto_rawDescGZIP(), []int{0}
}

func (x *Metrics) GetAbsoluteTopImpressionPercentage() float64 {
	if x != nil && x.AbsoluteTopImpressionPercentage != nil {
		return *x.AbsoluteTopImpressionPercentage
	}
	return 0
}

func (x *Metrics) GetActiveViewCpm() float64 {
	if x != nil && x.ActiveViewCpm != nil {
		return *x.ActiveViewCpm
	}
	return 0
}

func (x *Metrics) GetActiveViewCtr() float64 {
	if x != nil && x.ActiveViewCtr != nil {
		return *x.ActiveViewCtr
	}
	return 0
}

func (x *Metrics) GetActiveViewImpressions() int64 {
	if x != nil && x.ActiveViewImpressions != nil {
		return *x.ActiveViewImpressions
	}
	return 0
}

func (x *Metrics) GetActiveViewMeasurability() float64 {
	if x != nil && x.ActiveViewMeasurability != nil {
		return *x.ActiveViewMeasurability
	}
	return 0
}

func (x *Metrics) GetActiveViewMeasurableCostMicros() int64 {
	if x != nil && x.ActiveViewMeasurableCostMicros != nil {
		return *x.ActiveViewMeasurableCostMicros
	}
	return 0
}

func (x *Metrics) GetActiveViewMeasurableImpressions() int64 {
	if x != nil && x.ActiveViewMeasurableImpressions != nil {
		return *x.ActiveViewMeasurableImpressions
	}
	return 0
}

func (x *Metrics) GetActiveViewViewability() float64 {
	if x != nil && x.ActiveViewViewability != nil {
		return *x.ActiveViewViewability
	}
	return 0
}

func (x *Metrics) GetAllConversionsFromInteractionsRate() float64 {
	if x != nil && x.AllConversionsFromInteractionsRate != nil {
		return *x.AllConversionsFromInteractionsRate
	}
	return 0
}

func (x *Metrics) GetAllConversionsValue() float64 {
	if x != nil && x.AllConversionsValue != nil {
		return *x.AllConversionsValue
	}
	return 0
}

func (x *Metrics) GetAllConversions() float64 {
	if x != nil && x.AllConversions != nil {
		return *x.AllConversions
	}
	return 0
}

func (x *Metrics) GetAllConversionsValuePerCost() float64 {
	if x != nil && x.AllConversionsValuePerCost != nil {
		return *x.AllConversionsValuePerCost
	}
	return 0
}

func (x *Metrics) GetAllConversionsFromClickToCall() float64 {
	if x != nil && x.AllConversionsFromClickToCall != nil {
		return *x.AllConversionsFromClickToCall
	}
	return 0
}

func (x *Metrics) GetAllConversionsFromDirections() float64 {
	if x != nil && x.AllConversionsFromDirections != nil {
		return *x.AllConversionsFromDirections
	}
	return 0
}

func (x *Metrics) GetAllConversionsFromInteractionsValuePerInteraction() float64 {
	if x != nil && x.AllConversionsFromInteractionsValuePerInteraction != nil {
		return *x.AllConversionsFromInteractionsValuePerInteraction
	}
	return 0
}

func (x *Metrics) GetAllConversionsFromMenu() float64 {
	if x != nil && x.AllConversionsFromMenu != nil {
		return *x.AllConversionsFromMenu
	}
	return 0
}

func (x *Metrics) GetAllConversionsFromOrder() float64 {
	if x != nil && x.AllConversionsFromOrder != nil {
		return *x.AllConversionsFromOrder
	}
	return 0
}

func (x *Metrics) GetAllConversionsFromOtherEngagement() float64 {
	if x != nil && x.AllConversionsFromOtherEngagement != nil {
		return *x.AllConversionsFromOtherEngagement
	}
	return 0
}

func (x *Metrics) GetAllConversionsFromStoreVisit() float64 {
	if x != nil && x.AllConversionsFromStoreVisit != nil {
		return *x.AllConversionsFromStoreVisit
	}
	return 0
}

func (x *Metrics) GetAllConversionsFromStoreWebsite() float64 {
	if x != nil && x.AllConversionsFromStoreWebsite != nil {
		return *x.AllConversionsFromStoreWebsite
	}
	return 0
}

func (x *Metrics) GetAverageCost() float64 {
	if x != nil && x.AverageCost != nil {
		return *x.AverageCost
	}
	return 0
}

func (x *Metrics) GetAverageCpc() float64 {
	if x != nil && x.AverageCpc != nil {
		return *x.AverageCpc
	}
	return 0
}

func (x *Metrics) GetAverageCpe() float64 {
	if x != nil && x.AverageCpe != nil {
		return *x.AverageCpe
	}
	return 0
}

func (x *Metrics) GetAverageCpm() float64 {
	if x != nil && x.AverageCpm != nil {
		return *x.AverageCpm
	}
	return 0
}

func (x *Metrics) GetAverageCpv() float64 {
	if x != nil && x.AverageCpv != nil {
		return *x.AverageCpv
	}
	return 0
}

func (x *Metrics) GetAveragePageViews() float64 {
	if x != nil && x.AveragePageViews != nil {
		return *x.AveragePageViews
	}
	return 0
}

func (x *Metrics) GetAverageTimeOnSite() float64 {
	if x != nil && x.AverageTimeOnSite != nil {
		return *x.AverageTimeOnSite
	}
	return 0
}

func (x *Metrics) GetBenchmarkAverageMaxCpc() float64 {
	if x != nil && x.BenchmarkAverageMaxCpc != nil {
		return *x.BenchmarkAverageMaxCpc
	}
	return 0
}

func (x *Metrics) GetBenchmarkCtr() float64 {
	if x != nil && x.BenchmarkCtr != nil {
		return *x.BenchmarkCtr
	}
	return 0
}

func (x *Metrics) GetBounceRate() float64 {
	if x != nil && x.BounceRate != nil {
		return *x.BounceRate
	}
	return 0
}

func (x *Metrics) GetClicks() int64 {
	if x != nil && x.Clicks != nil {
		return *x.Clicks
	}
	return 0
}

func (x *Metrics) GetCombinedClicks() int64 {
	if x != nil && x.CombinedClicks != nil {
		return *x.CombinedClicks
	}
	return 0
}

func (x *Metrics) GetCombinedClicksPerQuery() float64 {
	if x != nil && x.CombinedClicksPerQuery != nil {
		return *x.CombinedClicksPerQuery
	}
	return 0
}

func (x *Metrics) GetCombinedQueries() int64 {
	if x != nil && x.CombinedQueries != nil {
		return *x.CombinedQueries
	}
	return 0
}

func (x *Metrics) GetContentBudgetLostImpressionShare() float64 {
	if x != nil && x.ContentBudgetLostImpressionShare != nil {
		return *x.ContentBudgetLostImpressionShare
	}
	return 0
}

func (x *Metrics) GetContentImpressionShare() float64 {
	if x != nil && x.ContentImpressionShare != nil {
		return *x.ContentImpressionShare
	}
	return 0
}

func (x *Metrics) GetConversionLastReceivedRequestDateTime() string {
	if x != nil && x.ConversionLastReceivedRequestDateTime != nil {
		return *x.ConversionLastReceivedRequestDateTime
	}
	return ""
}

func (x *Metrics) GetConversionLastConversionDate() string {
	if x != nil && x.ConversionLastConversionDate != nil {
		return *x.ConversionLastConversionDate
	}
	return ""
}

func (x *Metrics) GetContentRankLostImpressionShare() float64 {
	if x != nil && x.ContentRankLostImpressionShare != nil {
		return *x.ContentRankLostImpressionShare
	}
	return 0
}

func (x *Metrics) GetConversionsFromInteractionsRate() float64 {
	if x != nil && x.ConversionsFromInteractionsRate != nil {
		return *x.ConversionsFromInteractionsRate
	}
	return 0
}

func (x *Metrics) GetConversionsValue() float64 {
	if x != nil && x.ConversionsValue != nil {
		return *x.ConversionsValue
	}
	return 0
}

func (x *Metrics) GetConversionsValuePerCost() float64 {
	if x != nil && x.ConversionsValuePerCost != nil {
		return *x.ConversionsValuePerCost
	}
	return 0
}

func (x *Metrics) GetConversionsFromInteractionsValuePerInteraction() float64 {
	if x != nil && x.ConversionsFromInteractionsValuePerInteraction != nil {
		return *x.ConversionsFromInteractionsValuePerInteraction
	}
	return 0
}

func (x *Metrics) GetConversions() float64 {
	if x != nil && x.Conversions != nil {
		return *x.Conversions
	}
	return 0
}

func (x *Metrics) GetCostMicros() int64 {
	if x != nil && x.CostMicros != nil {
		return *x.CostMicros
	}
	return 0
}

func (x *Metrics) GetCostPerAllConversions() float64 {
	if x != nil && x.CostPerAllConversions != nil {
		return *x.CostPerAllConversions
	}
	return 0
}

func (x *Metrics) GetCostPerConversion() float64 {
	if x != nil && x.CostPerConversion != nil {
		return *x.CostPerConversion
	}
	return 0
}

func (x *Metrics) GetCostPerCurrentModelAttributedConversion() float64 {
	if x != nil && x.CostPerCurrentModelAttributedConversion != nil {
		return *x.CostPerCurrentModelAttributedConversion
	}
	return 0
}

func (x *Metrics) GetCrossDeviceConversions() float64 {
	if x != nil && x.CrossDeviceConversions != nil {
		return *x.CrossDeviceConversions
	}
	return 0
}

func (x *Metrics) GetCtr() float64 {
	if x != nil && x.Ctr != nil {
		return *x.Ctr
	}
	return 0
}

func (x *Metrics) GetCurrentModelAttributedConversions() float64 {
	if x != nil && x.CurrentModelAttributedConversions != nil {
		return *x.CurrentModelAttributedConversions
	}
	return 0
}

func (x *Metrics) GetCurrentModelAttributedConversionsFromInteractionsRate() float64 {
	if x != nil && x.CurrentModelAttributedConversionsFromInteractionsRate != nil {
		return *x.CurrentModelAttributedConversionsFromInteractionsRate
	}
	return 0
}

func (x *Metrics) GetCurrentModelAttributedConversionsFromInteractionsValuePerInteraction() float64 {
	if x != nil && x.CurrentModelAttributedConversionsFromInteractionsValuePerInteraction != nil {
		return *x.CurrentModelAttributedConversionsFromInteractionsValuePerInteraction
	}
	return 0
}

func (x *Metrics) GetCurrentModelAttributedConversionsValue() float64 {
	if x != nil && x.CurrentModelAttributedConversionsValue != nil {
		return *x.CurrentModelAttributedConversionsValue
	}
	return 0
}

func (x *Metrics) GetCurrentModelAttributedConversionsValuePerCost() float64 {
	if x != nil && x.CurrentModelAttributedConversionsValuePerCost != nil {
		return *x.CurrentModelAttributedConversionsValuePerCost
	}
	return 0
}

func (x *Metrics) GetEngagementRate() float64 {
	if x != nil && x.EngagementRate != nil {
		return *x.EngagementRate
	}
	return 0
}

func (x *Metrics) GetEngagements() int64 {
	if x != nil && x.Engagements != nil {
		return *x.Engagements
	}
	return 0
}

func (x *Metrics) GetHotelAverageLeadValueMicros() float64 {
	if x != nil && x.HotelAverageLeadValueMicros != nil {
		return *x.HotelAverageLeadValueMicros
	}
	return 0
}

func (x *Metrics) GetHotelPriceDifferencePercentage() float64 {
	if x != nil && x.HotelPriceDifferencePercentage != nil {
		return *x.HotelPriceDifferencePercentage
	}
	return 0
}

func (x *Metrics) GetHotelEligibleImpressions() int64 {
	if x != nil && x.HotelEligibleImpressions != nil {
		return *x.HotelEligibleImpressions
	}
	return 0
}

func (x *Metrics) GetHistoricalCreativeQualityScore() enums.QualityScoreBucketEnum_QualityScoreBucket {
	if x != nil {
		return x.HistoricalCreativeQualityScore
	}
	return enums.QualityScoreBucketEnum_UNSPECIFIED
}

func (x *Metrics) GetHistoricalLandingPageQualityScore() enums.QualityScoreBucketEnum_QualityScoreBucket {
	if x != nil {
		return x.HistoricalLandingPageQualityScore
	}
	return enums.QualityScoreBucketEnum_UNSPECIFIED
}

func (x *Metrics) GetHistoricalQualityScore() int64 {
	if x != nil && x.HistoricalQualityScore != nil {
		return *x.HistoricalQualityScore
	}
	return 0
}

func (x *Metrics) GetHistoricalSearchPredictedCtr() enums.QualityScoreBucketEnum_QualityScoreBucket {
	if x != nil {
		return x.HistoricalSearchPredictedCtr
	}
	return enums.QualityScoreBucketEnum_UNSPECIFIED
}

func (x *Metrics) GetGmailForwards() int64 {
	if x != nil && x.GmailForwards != nil {
		return *x.GmailForwards
	}
	return 0
}

func (x *Metrics) GetGmailSaves() int64 {
	if x != nil && x.GmailSaves != nil {
		return *x.GmailSaves
	}
	return 0
}

func (x *Metrics) GetGmailSecondaryClicks() int64 {
	if x != nil && x.GmailSecondaryClicks != nil {
		return *x.GmailSecondaryClicks
	}
	return 0
}

func (x *Metrics) GetImpressionsFromStoreReach() int64 {
	if x != nil && x.ImpressionsFromStoreReach != nil {
		return *x.ImpressionsFromStoreReach
	}
	return 0
}

func (x *Metrics) GetImpressions() int64 {
	if x != nil && x.Impressions != nil {
		return *x.Impressions
	}
	return 0
}

func (x *Metrics) GetInteractionRate() float64 {
	if x != nil && x.InteractionRate != nil {
		return *x.InteractionRate
	}
	return 0
}

func (x *Metrics) GetInteractions() int64 {
	if x != nil && x.Interactions != nil {
		return *x.Interactions
	}
	return 0
}

func (x *Metrics) GetInteractionEventTypes() []enums.InteractionEventTypeEnum_InteractionEventType {
	if x != nil {
		return x.InteractionEventTypes
	}
	return nil
}

func (x *Metrics) GetInvalidClickRate() float64 {
	if x != nil && x.InvalidClickRate != nil {
		return *x.InvalidClickRate
	}
	return 0
}

func (x *Metrics) GetInvalidClicks() int64 {
	if x != nil && x.InvalidClicks != nil {
		return *x.InvalidClicks
	}
	return 0
}

func (x *Metrics) GetMessageChats() int64 {
	if x != nil && x.MessageChats != nil {
		return *x.MessageChats
	}
	return 0
}

func (x *Metrics) GetMessageImpressions() int64 {
	if x != nil && x.MessageImpressions != nil {
		return *x.MessageImpressions
	}
	return 0
}

func (x *Metrics) GetMessageChatRate() float64 {
	if x != nil && x.MessageChatRate != nil {
		return *x.MessageChatRate
	}
	return 0
}

func (x *Metrics) GetMobileFriendlyClicksPercentage() float64 {
	if x != nil && x.MobileFriendlyClicksPercentage != nil {
		return *x.MobileFriendlyClicksPercentage
	}
	return 0
}

func (x *Metrics) GetOrganicClicks() int64 {
	if x != nil && x.OrganicClicks != nil {
		return *x.OrganicClicks
	}
	return 0
}

func (x *Metrics) GetOrganicClicksPerQuery() float64 {
	if x != nil && x.OrganicClicksPerQuery != nil {
		return *x.OrganicClicksPerQuery
	}
	return 0
}

func (x *Metrics) GetOrganicImpressions() int64 {
	if x != nil && x.OrganicImpressions != nil {
		return *x.OrganicImpressions
	}
	return 0
}

func (x *Metrics) GetOrganicImpressionsPerQuery() float64 {
	if x != nil && x.OrganicImpressionsPerQuery != nil {
		return *x.OrganicImpressionsPerQuery
	}
	return 0
}

func (x *Metrics) GetOrganicQueries() int64 {
	if x != nil && x.OrganicQueries != nil {
		return *x.OrganicQueries
	}
	return 0
}

func (x *Metrics) GetPercentNewVisitors() float64 {
	if x != nil && x.PercentNewVisitors != nil {
		return *x.PercentNewVisitors
	}
	return 0
}

func (x *Metrics) GetPhoneCalls() int64 {
	if x != nil && x.PhoneCalls != nil {
		return *x.PhoneCalls
	}
	return 0
}

func (x *Metrics) GetPhoneImpressions() int64 {
	if x != nil && x.PhoneImpressions != nil {
		return *x.PhoneImpressions
	}
	return 0
}

func (x *Metrics) GetPhoneThroughRate() float64 {
	if x != nil && x.PhoneThroughRate != nil {
		return *x.PhoneThroughRate
	}
	return 0
}

func (x *Metrics) GetRelativeCtr() float64 {
	if x != nil && x.RelativeCtr != nil {
		return *x.RelativeCtr
	}
	return 0
}

func (x *Metrics) GetSearchAbsoluteTopImpressionShare() float64 {
	if x != nil && x.SearchAbsoluteTopImpressionShare != nil {
		return *x.SearchAbsoluteTopImpressionShare
	}
	return 0
}

func (x *Metrics) GetSearchBudgetLostAbsoluteTopImpressionShare() float64 {
	if x != nil && x.SearchBudgetLostAbsoluteTopImpressionShare != nil {
		return *x.SearchBudgetLostAbsoluteTopImpressionShare
	}
	return 0
}

func (x *Metrics) GetSearchBudgetLostImpressionShare() float64 {
	if x != nil && x.SearchBudgetLostImpressionShare != nil {
		return *x.SearchBudgetLostImpressionShare
	}
	return 0
}

func (x *Metrics) GetSearchBudgetLostTopImpressionShare() float64 {
	if x != nil && x.SearchBudgetLostTopImpressionShare != nil {
		return *x.SearchBudgetLostTopImpressionShare
	}
	return 0
}

func (x *Metrics) GetSearchClickShare() float64 {
	if x != nil && x.SearchClickShare != nil {
		return *x.SearchClickShare
	}
	return 0
}

func (x *Metrics) GetSearchExactMatchImpressionShare() float64 {
	if x != nil && x.SearchExactMatchImpressionShare != nil {
		return *x.SearchExactMatchImpressionShare
	}
	return 0
}

func (x *Metrics) GetSearchImpressionShare() float64 {
	if x != nil && x.SearchImpressionShare != nil {
		return *x.SearchImpressionShare
	}
	return 0
}

func (x *Metrics) GetSearchRankLostAbsoluteTopImpressionShare() float64 {
	if x != nil && x.SearchRankLostAbsoluteTopImpressionShare != nil {
		return *x.SearchRankLostAbsoluteTopImpressionShare
	}
	return 0
}

func (x *Metrics) GetSearchRankLostImpressionShare() float64 {
	if x != nil && x.SearchRankLostImpressionShare != nil {
		return *x.SearchRankLostImpressionShare
	}
	return 0
}

func (x *Metrics) GetSearchRankLostTopImpressionShare() float64 {
	if x != nil && x.SearchRankLostTopImpressionShare != nil {
		return *x.SearchRankLostTopImpressionShare
	}
	return 0
}

func (x *Metrics) GetSearchTopImpressionShare() float64 {
	if x != nil && x.SearchTopImpressionShare != nil {
		return *x.SearchTopImpressionShare
	}
	return 0
}

func (x *Metrics) GetSpeedScore() int64 {
	if x != nil && x.SpeedScore != nil {
		return *x.SpeedScore
	}
	return 0
}

func (x *Metrics) GetTopImpressionPercentage() float64 {
	if x != nil && x.TopImpressionPercentage != nil {
		return *x.TopImpressionPercentage
	}
	return 0
}

func (x *Metrics) GetValidAcceleratedMobilePagesClicksPercentage() float64 {
	if x != nil && x.ValidAcceleratedMobilePagesClicksPercentage != nil {
		return *x.ValidAcceleratedMobilePagesClicksPercentage
	}
	return 0
}

func (x *Metrics) GetValuePerAllConversions() float64 {
	if x != nil && x.ValuePerAllConversions != nil {
		return *x.ValuePerAllConversions
	}
	return 0
}

func (x *Metrics) GetValuePerConversion() float64 {
	if x != nil && x.ValuePerConversion != nil {
		return *x.ValuePerConversion
	}
	return 0
}

func (x *Metrics) GetValuePerCurrentModelAttributedConversion() float64 {
	if x != nil && x.ValuePerCurrentModelAttributedConversion != nil {
		return *x.ValuePerCurrentModelAttributedConversion
	}
	return 0
}

func (x *Metrics) GetVideoQuartileP100Rate() float64 {
	if x != nil && x.VideoQuartileP100Rate != nil {
		return *x.VideoQuartileP100Rate
	}
	return 0
}

func (x *Metrics) GetVideoQuartileP25Rate() float64 {
	if x != nil && x.VideoQuartileP25Rate != nil {
		return *x.VideoQuartileP25Rate
	}
	return 0
}

func (x *Metrics) GetVideoQuartileP50Rate() float64 {
	if x != nil && x.VideoQuartileP50Rate != nil {
		return *x.VideoQuartileP50Rate
	}
	return 0
}

func (x *Metrics) GetVideoQuartileP75Rate() float64 {
	if x != nil && x.VideoQuartileP75Rate != nil {
		return *x.VideoQuartileP75Rate
	}
	return 0
}

func (x *Metrics) GetVideoViewRate() float64 {
	if x != nil && x.VideoViewRate != nil {
		return *x.VideoViewRate
	}
	return 0
}

func (x *Metrics) GetVideoViews() int64 {
	if x != nil && x.VideoViews != nil {
		return *x.VideoViews
	}
	return 0
}

func (x *Metrics) GetViewThroughConversions() int64 {
	if x != nil && x.ViewThroughConversions != nil {
		return *x.ViewThroughConversions
	}
	return 0
}

var File_google_ads_googleads_v6_common_metrics_proto protoreflect.FileDescriptor

var file_google_ads_googleads_v6_common_metrics_proto_rawDesc = []byte{
	0x0a, 0x2c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x36, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e,
	0x2f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x1a, 0x3a,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x36, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x69, 0x6e,
	0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x38, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2f, 0x76, 0x36, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x71, 0x75, 0x61, 0x6c, 0x69, 0x74,
	0x79, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x5f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0xda, 0x55, 0x0a, 0x07, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x51,
	0x0a, 0x22, 0x61, 0x62, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x65, 0x5f, 0x74, 0x6f, 0x70, 0x5f, 0x69,
	0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e,
	0x74, 0x61, 0x67, 0x65, 0x18, 0xb7, 0x01, 0x20, 0x01, 0x28, 0x01, 0x48, 0x00, 0x52, 0x1f, 0x61,
	0x62, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x65, 0x54, 0x6f, 0x70, 0x49, 0x6d, 0x70, 0x72, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x50, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x88, 0x01,
	0x01, 0x12, 0x2c, 0x0a, 0x0f, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x76, 0x69, 0x65, 0x77,
	0x5f, 0x63, 0x70, 0x6d, 0x18, 0xb8, 0x01, 0x20, 0x01, 0x28, 0x01, 0x48, 0x01, 0x52, 0x0d, 0x61,
	0x63, 0x74, 0x69, 0x76, 0x65, 0x56, 0x69, 0x65, 0x77, 0x43, 0x70, 0x6d, 0x88, 0x01, 0x01, 0x12,
	0x2c, 0x0a, 0x0f, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x5f, 0x63,
	0x74, 0x72, 0x18, 0xb9, 0x01, 0x20, 0x01, 0x28, 0x01, 0x48, 0x02, 0x52, 0x0d, 0x61, 0x63, 0x74,
	0x69, 0x76, 0x65, 0x56, 0x69, 0x65, 0x77, 0x43, 0x74, 0x72, 0x88, 0x01, 0x01, 0x12, 0x3c, 0x0a,
	0x17, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x5f, 0x69, 0x6d, 0x70,
	0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0xba, 0x01, 0x20, 0x01, 0x28, 0x03, 0x48,
	0x03, 0x52, 0x15, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x56, 0x69, 0x65, 0x77, 0x49, 0x6d, 0x70,
	0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x88, 0x01, 0x01, 0x12, 0x40, 0x0a, 0x19, 0x61,
	0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x5f, 0x6d, 0x65, 0x61, 0x73, 0x75,
	0x72, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x18, 0xbb, 0x01, 0x20, 0x01, 0x28, 0x01, 0x48,
	0x04, 0x52, 0x17, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x56, 0x69, 0x65, 0x77, 0x4d, 0x65, 0x61,
	0x73, 0x75, 0x72, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x88, 0x01, 0x01, 0x12, 0x50, 0x0a,
	0x22, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x5f, 0x6d, 0x65, 0x61,
	0x73, 0x75, 0x72, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x73, 0x74, 0x5f, 0x6d, 0x69, 0x63,
	0x72, 0x6f, 0x73, 0x18, 0xbc, 0x01, 0x20, 0x01, 0x28, 0x03, 0x48, 0x05, 0x52, 0x1e, 0x61, 0x63,
	0x74, 0x69, 0x76, 0x65, 0x56, 0x69, 0x65, 0x77, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x61, 0x62,
	0x6c, 0x65, 0x43, 0x6f, 0x73, 0x74, 0x4d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x88, 0x01, 0x01, 0x12,
	0x51, 0x0a, 0x22, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x5f, 0x6d,
	0x65, 0x61, 0x73, 0x75, 0x72, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0xbd, 0x01, 0x20, 0x01, 0x28, 0x03, 0x48, 0x06, 0x52, 0x1f,
	0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x56, 0x69, 0x65, 0x77, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72,
	0x61, 0x62, 0x6c, 0x65, 0x49, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x88,
	0x01, 0x01, 0x12, 0x3c, 0x0a, 0x17, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x76, 0x69, 0x65,
	0x77, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x18, 0xbe, 0x01,
	0x20, 0x01, 0x28, 0x01, 0x48, 0x07, 0x52, 0x15, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x56, 0x69,
	0x65, 0x77, 0x56, 0x69, 0x65, 0x77, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x88, 0x01, 0x01,
	0x12, 0x58, 0x0a, 0x26, 0x61, 0x6c, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x18, 0xbf, 0x01, 0x20, 0x01, 0x28,
	0x01, 0x48, 0x08, 0x52, 0x22, 0x61, 0x6c, 0x6c, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x46, 0x72, 0x6f, 0x6d, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x52, 0x61, 0x74, 0x65, 0x88, 0x01, 0x01, 0x12, 0x38, 0x0a, 0x15, 0x61, 0x6c,
	0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0xc0, 0x01, 0x20, 0x01, 0x28, 0x01, 0x48, 0x09, 0x52, 0x13, 0x61, 0x6c,
	0x6c, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x88, 0x01, 0x01, 0x12, 0x2d, 0x0a, 0x0f, 0x61, 0x6c, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0xc1, 0x01, 0x20, 0x01, 0x28, 0x01, 0x48, 0x0a,
	0x52, 0x0e, 0x61, 0x6c, 0x6c, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x88, 0x01, 0x01, 0x12, 0x48, 0x0a, 0x1e, 0x61, 0x6c, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x70, 0x65, 0x72,
	0x5f, 0x63, 0x6f, 0x73, 0x74, 0x18, 0xc2, 0x01, 0x20, 0x01, 0x28, 0x01, 0x48, 0x0b, 0x52, 0x1a,
	0x61, 0x6c, 0x6c, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x50, 0x65, 0x72, 0x43, 0x6f, 0x73, 0x74, 0x88, 0x01, 0x01, 0x12, 0x4f, 0x0a,
	0x22, 0x61, 0x6c, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x63, 0x6c, 0x69, 0x63, 0x6b, 0x5f, 0x74, 0x6f, 0x5f, 0x63,
	0x61, 0x6c, 0x6c, 0x18, 0xc3, 0x01, 0x20, 0x01, 0x28, 0x01, 0x48, 0x0c, 0x52, 0x1d, 0x61, 0x6c,
	0x6c, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x46, 0x72, 0x6f, 0x6d,
	0x43, 0x6c, 0x69, 0x63, 0x6b, 0x54, 0x6f, 0x43, 0x61, 0x6c, 0x6c, 0x88, 0x01, 0x01, 0x12, 0x4b,
	0x0a, 0x1f, 0x61, 0x6c, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0xc4, 0x01, 0x20, 0x01, 0x28, 0x01, 0x48, 0x0d, 0x52, 0x1c, 0x61, 0x6c, 0x6c, 0x43,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x46, 0x72, 0x6f, 0x6d, 0x44, 0x69,
	0x72, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x88, 0x01, 0x01, 0x12, 0x78, 0x0a, 0x37, 0x61,
	0x6c, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x66,
	0x72, 0x6f, 0x6d, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0xc5, 0x01, 0x20, 0x01, 0x28, 0x01, 0x48, 0x0e, 0x52,
	0x31, 0x61, 0x6c, 0x6c, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x46,
	0x72, 0x6f, 0x6d, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x50, 0x65, 0x72, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x3f, 0x0a, 0x19, 0x61, 0x6c, 0x6c, 0x5f, 0x63, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x6d, 0x65,
	0x6e, 0x75, 0x18, 0xc6, 0x01, 0x20, 0x01, 0x28, 0x01, 0x48, 0x0f, 0x52, 0x16, 0x61, 0x6c, 0x6c,
	0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x46, 0x72, 0x6f, 0x6d, 0x4d,
	0x65, 0x6e, 0x75, 0x88, 0x01, 0x01, 0x12, 0x41, 0x0a, 0x1a, 0x61, 0x6c, 0x6c, 0x5f, 0x63, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x6f,
	0x72, 0x64, 0x65, 0x72, 0x18, 0xc7, 0x01, 0x20, 0x01, 0x28, 0x01, 0x48, 0x10, 0x52, 0x17, 0x61,
	0x6c, 0x6c, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x46, 0x72, 0x6f,
	0x6d, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x88, 0x01, 0x01, 0x12, 0x56, 0x0a, 0x25, 0x61, 0x6c, 0x6c,
	0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x66, 0x72, 0x6f,
	0x6d, 0x5f, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x5f, 0x65, 0x6e, 0x67, 0x61, 0x67, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x18, 0xc8, 0x01, 0x20, 0x01, 0x28, 0x01, 0x48, 0x11, 0x52, 0x21, 0x61, 0x6c, 0x6c,
	0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x46, 0x72, 0x6f, 0x6d, 0x4f,
	0x74, 0x68, 0x65, 0x72, 0x45, 0x6e, 0x67, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x88, 0x01,
	0x01, 0x12, 0x4c, 0x0a, 0x20, 0x61, 0x6c, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f,
	0x76, 0x69, 0x73, 0x69, 0x74, 0x18, 0xc9, 0x01, 0x20, 0x01, 0x28, 0x01, 0x48, 0x12, 0x52, 0x1c,
	0x61, 0x6c, 0x6c, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x46, 0x72,
	0x6f, 0x6d, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x56, 0x69, 0x73, 0x69, 0x74, 0x88, 0x01, 0x01, 0x12,
	0x50, 0x0a, 0x22, 0x61, 0x6c, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x77, 0x65,
	0x62, 0x73, 0x69, 0x74, 0x65, 0x18, 0xca, 0x01, 0x20, 0x01, 0x28, 0x01, 0x48, 0x13, 0x52, 0x1e,
	0x61, 0x6c, 0x6c, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x46, 0x72,
	0x6f, 0x6d, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x57, 0x65, 0x62, 0x73, 0x69, 0x74, 0x65, 0x88, 0x01,
	0x01, 0x12, 0x27, 0x0a, 0x0c, 0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x73,
	0x74, 0x18, 0xcb, 0x01, 0x20, 0x01, 0x28, 0x01, 0x48, 0x14, 0x52, 0x0b, 0x61, 0x76, 0x65, 0x72,
	0x61, 0x67, 0x65, 0x43, 0x6f, 0x73, 0x74, 0x88, 0x01, 0x01, 0x12, 0x25, 0x0a, 0x0b, 0x61, 0x76,
	0x65, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x70, 0x63, 0x18, 0xcc, 0x01, 0x20, 0x01, 0x28, 0x01,
	0x48, 0x15, 0x52, 0x0a, 0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x43, 0x70, 0x63, 0x88, 0x01,
	0x01, 0x12, 0x25, 0x0a, 0x0b, 0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x70, 0x65,
	0x18, 0xcd, 0x01, 0x20, 0x01, 0x28, 0x01, 0x48, 0x16, 0x52, 0x0a, 0x61, 0x76, 0x65, 0x72, 0x61,
	0x67, 0x65, 0x43, 0x70, 0x65, 0x88, 0x01, 0x01, 0x12, 0x25, 0x0a, 0x0b, 0x61, 0x76, 0x65, 0x72,
	0x61, 0x67, 0x65, 0x5f, 0x63, 0x70, 0x6d, 0x18, 0xce, 0x01, 0x20, 0x01, 0x28, 0x01, 0x48, 0x17,
	0x52, 0x0a, 0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x43, 0x70, 0x6d, 0x88, 0x01, 0x01, 0x12,
	0x25, 0x0a, 0x0b, 0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x70, 0x76, 0x18, 0xcf,
	0x01, 0x20, 0x01, 0x28, 0x01, 0x48, 0x18, 0x52, 0x0a, 0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65,
	0x43, 0x70, 0x76, 0x88, 0x01, 0x01, 0x12, 0x32, 0x0a, 0x12, 0x61, 0x76, 0x65, 0x72, 0x61, 0x67,
	0x65, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x73, 0x18, 0xd0, 0x01, 0x20,
	0x01, 0x28, 0x01, 0x48, 0x19, 0x52, 0x10, 0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x50, 0x61,
	0x67, 0x65, 0x56, 0x69, 0x65, 0x77, 0x73, 0x88, 0x01, 0x01, 0x12, 0x35, 0x0a, 0x14, 0x61, 0x76,
	0x65, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x6f, 0x6e, 0x5f, 0x73, 0x69,
	0x74, 0x65, 0x18, 0xd1, 0x01, 0x20, 0x01, 0x28, 0x01, 0x48, 0x1a, 0x52, 0x11, 0x61, 0x76, 0x65,
	0x72, 0x61, 0x67, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x4f, 0x6e, 0x53, 0x69, 0x74, 0x65, 0x88, 0x01,
	0x01, 0x12, 0x3f, 0x0a, 0x19, 0x62, 0x65, 0x6e, 0x63, 0x68, 0x6d, 0x61, 0x72, 0x6b, 0x5f, 0x61,
	0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x6d, 0x61, 0x78, 0x5f, 0x63, 0x70, 0x63, 0x18, 0xd2,
	0x01, 0x20, 0x01, 0x28, 0x01, 0x48, 0x1b, 0x52, 0x16, 0x62, 0x65, 0x6e, 0x63, 0x68, 0x6d, 0x61,
	0x72, 0x6b, 0x41, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x4d, 0x61, 0x78, 0x43, 0x70, 0x63, 0x88,
	0x01, 0x01, 0x12, 0x29, 0x0a, 0x0d, 0x62, 0x65, 0x6e, 0x63, 0x68, 0x6d, 0x61, 0x72, 0x6b, 0x5f,
	0x63, 0x74, 0x72, 0x18, 0xd3, 0x01, 0x20, 0x01, 0x28, 0x01, 0x48, 0x1c, 0x52, 0x0c, 0x62, 0x65,
	0x6e, 0x63, 0x68, 0x6d, 0x61, 0x72, 0x6b, 0x43, 0x74, 0x72, 0x88, 0x01, 0x01, 0x12, 0x25, 0x0a,
	0x0b, 0x62, 0x6f, 0x75, 0x6e, 0x63, 0x65, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x18, 0xd4, 0x01, 0x20,
	0x01, 0x28, 0x01, 0x48, 0x1d, 0x52, 0x0a, 0x62, 0x6f, 0x75, 0x6e, 0x63, 0x65, 0x52, 0x61, 0x74,
	0x65, 0x88, 0x01, 0x01, 0x12, 0x1c, 0x0a, 0x06, 0x63, 0x6c, 0x69, 0x63, 0x6b, 0x73, 0x18, 0x83,
	0x01, 0x20, 0x01, 0x28, 0x03, 0x48, 0x1e, 0x52, 0x06, 0x63, 0x6c, 0x69, 0x63, 0x6b, 0x73, 0x88,
	0x01, 0x01, 0x12, 0x2d, 0x0a, 0x0f, 0x63, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65, 0x64, 0x5f, 0x63,
	0x6c, 0x69, 0x63, 0x6b, 0x73, 0x18, 0x9c, 0x01, 0x20, 0x01, 0x28, 0x03, 0x48, 0x1f, 0x52, 0x0e,
	0x63, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65, 0x64, 0x43, 0x6c, 0x69, 0x63, 0x6b, 0x73, 0x88, 0x01,
	0x01, 0x12, 0x3f, 0x0a, 0x19, 0x63, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65, 0x64, 0x5f, 0x63, 0x6c,
	0x69, 0x63, 0x6b, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x9d,
	0x01, 0x20, 0x01, 0x28, 0x01, 0x48, 0x20, 0x52, 0x16, 0x63, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65,
	0x64, 0x43, 0x6c, 0x69, 0x63, 0x6b, 0x73, 0x50, 0x65, 0x72, 0x51, 0x75, 0x65, 0x72, 0x79, 0x88,
	0x01, 0x01, 0x12, 0x2f, 0x0a, 0x10, 0x63, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65, 0x64, 0x5f, 0x71,
	0x75, 0x65, 0x72, 0x69, 0x65, 0x73, 0x18, 0x9e, 0x01, 0x20, 0x01, 0x28, 0x03, 0x48, 0x21, 0x52,
	0x0f, 0x63, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x69, 0x65, 0x73,
	0x88, 0x01, 0x01, 0x12, 0x54, 0x0a, 0x24, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x62,
	0x75, 0x64, 0x67, 0x65, 0x74, 0x5f, 0x6c, 0x6f, 0x73, 0x74, 0x5f, 0x69, 0x6d, 0x70, 0x72, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x65, 0x18, 0x9f, 0x01, 0x20, 0x01,
	0x28, 0x01, 0x48, 0x22, 0x52, 0x20, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x42, 0x75, 0x64,
	0x67, 0x65, 0x74, 0x4c, 0x6f, 0x73, 0x74, 0x49, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x53, 0x68, 0x61, 0x72, 0x65, 0x88, 0x01, 0x01, 0x12, 0x3e, 0x0a, 0x18, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f,
	0x73, 0x68, 0x61, 0x72, 0x65, 0x18, 0xa0, 0x01, 0x20, 0x01, 0x28, 0x01, 0x48, 0x23, 0x52, 0x16,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x49, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x53, 0x68, 0x61, 0x72, 0x65, 0x88, 0x01, 0x01, 0x12, 0x5f, 0x0a, 0x2a, 0x63, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x72, 0x65, 0x63,
	0x65, 0x69, 0x76, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0xa1, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x24,
	0x52, 0x25, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x4c, 0x61, 0x73, 0x74,
	0x52, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x44,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x88, 0x01, 0x01, 0x12, 0x4b, 0x0a, 0x1f, 0x63, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x63, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x18, 0xa2, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x48, 0x25, 0x52, 0x1c, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x4c, 0x61, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x44, 0x61, 0x74, 0x65, 0x88, 0x01, 0x01, 0x12, 0x50, 0x0a, 0x22, 0x63, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x5f, 0x72, 0x61, 0x6e, 0x6b, 0x5f, 0x6c, 0x6f, 0x73, 0x74, 0x5f, 0x69, 0x6d, 0x70,
	0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x65, 0x18, 0xa3, 0x01,
	0x20, 0x01, 0x28, 0x01, 0x48, 0x26, 0x52, 0x1e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52,
	0x61, 0x6e, 0x6b, 0x4c, 0x6f, 0x73, 0x74, 0x49, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x53, 0x68, 0x61, 0x72, 0x65, 0x88, 0x01, 0x01, 0x12, 0x51, 0x0a, 0x22, 0x63, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x69, 0x6e,
	0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x18,
	0xa4, 0x01, 0x20, 0x01, 0x28, 0x01, 0x48, 0x27, 0x52, 0x1f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x46, 0x72, 0x6f, 0x6d, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x61, 0x74, 0x65, 0x88, 0x01, 0x01, 0x12, 0x31, 0x0a, 0x11,
	0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0xa5, 0x01, 0x20, 0x01, 0x28, 0x01, 0x48, 0x28, 0x52, 0x10, 0x63, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x88, 0x01, 0x01, 0x12,
	0x41, 0x0a, 0x1a, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x73, 0x74, 0x18, 0xa6, 0x01,
	0x20, 0x01, 0x28, 0x01, 0x48, 0x29, 0x52, 0x17, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x50, 0x65, 0x72, 0x43, 0x6f, 0x73, 0x74, 0x88,
	0x01, 0x01, 0x12, 0x71, 0x0a, 0x33, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x69, 0x6e,
	0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0xa7, 0x01, 0x20, 0x01, 0x28, 0x01,
	0x48, 0x2a, 0x52, 0x2e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x46,
	0x72, 0x6f, 0x6d, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x50, 0x65, 0x72, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x26, 0x0a, 0x0b, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0xa8, 0x01, 0x20, 0x01, 0x28, 0x01, 0x48, 0x2b, 0x52, 0x0b, 0x63,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x88, 0x01, 0x01, 0x12, 0x25, 0x0a,
	0x0b, 0x63, 0x6f, 0x73, 0x74, 0x5f, 0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x18, 0xa9, 0x01, 0x20,
	0x01, 0x28, 0x03, 0x48, 0x2c, 0x52, 0x0a, 0x63, 0x6f, 0x73, 0x74, 0x4d, 0x69, 0x63, 0x72, 0x6f,
	0x73, 0x88, 0x01, 0x01, 0x12, 0x3d, 0x0a, 0x18, 0x63, 0x6f, 0x73, 0x74, 0x5f, 0x70, 0x65, 0x72,
	0x5f, 0x61, 0x6c, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0xaa, 0x01, 0x20, 0x01, 0x28, 0x01, 0x48, 0x2d, 0x52, 0x15, 0x63, 0x6f, 0x73, 0x74, 0x50,
	0x65, 0x72, 0x41, 0x6c, 0x6c, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x88, 0x01, 0x01, 0x12, 0x34, 0x0a, 0x13, 0x63, 0x6f, 0x73, 0x74, 0x5f, 0x70, 0x65, 0x72, 0x5f,
	0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0xab, 0x01, 0x20, 0x01, 0x28,
	0x01, 0x48, 0x2e, 0x52, 0x11, 0x63, 0x6f, 0x73, 0x74, 0x50, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x63, 0x0a, 0x2c, 0x63, 0x6f, 0x73,
	0x74, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x6d, 0x6f,
	0x64, 0x65, 0x6c, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x64, 0x5f, 0x63,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0xac, 0x01, 0x20, 0x01, 0x28, 0x01,
	0x48, 0x2f, 0x52, 0x27, 0x63, 0x6f, 0x73, 0x74, 0x50, 0x65, 0x72, 0x43, 0x75, 0x72, 0x72, 0x65,
	0x6e, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65,
	0x64, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x3e,
	0x0a, 0x18, 0x63, 0x72, 0x6f, 0x73, 0x73, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x63,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0xad, 0x01, 0x20, 0x01, 0x28,
	0x01, 0x48, 0x30, 0x52, 0x16, 0x63, 0x72, 0x6f, 0x73, 0x73, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x88, 0x01, 0x01, 0x12, 0x16,
	0x0a, 0x03, 0x63, 0x74, 0x72, 0x18, 0xae, 0x01, 0x20, 0x01, 0x28, 0x01, 0x48, 0x31, 0x52, 0x03,
	0x63, 0x74, 0x72, 0x88, 0x01, 0x01, 0x12, 0x55, 0x0a, 0x24, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e,
	0x74, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0xaf,
	0x01, 0x20, 0x01, 0x28, 0x01, 0x48, 0x32, 0x52, 0x21, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74,
	0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x64, 0x43,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x88, 0x01, 0x01, 0x12, 0x80, 0x01,
	0x0a, 0x3b, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f,
	0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x69, 0x6e, 0x74, 0x65,
	0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x18, 0xb0, 0x01,
	0x20, 0x01, 0x28, 0x01, 0x48, 0x33, 0x52, 0x35, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x4d,
	0x6f, 0x64, 0x65, 0x6c, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x64, 0x43, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x46, 0x72, 0x6f, 0x6d, 0x49, 0x6e, 0x74,
	0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x61, 0x74, 0x65, 0x88, 0x01, 0x01,
	0x12, 0xa0, 0x01, 0x0a, 0x4c, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x69,
	0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0xb1, 0x01, 0x20, 0x01, 0x28, 0x01, 0x48, 0x34, 0x52, 0x44, 0x63, 0x75, 0x72, 0x72,
	0x65, 0x6e, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x65, 0x64, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x46, 0x72, 0x6f,
	0x6d, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x50, 0x65, 0x72, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x88, 0x01, 0x01, 0x12, 0x60, 0x0a, 0x2a, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x6d,
	0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x64, 0x5f,
	0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0xb2, 0x01, 0x20, 0x01, 0x28, 0x01, 0x48, 0x35, 0x52, 0x26, 0x63, 0x75, 0x72, 0x72,
	0x65, 0x6e, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x65, 0x64, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x88, 0x01, 0x01, 0x12, 0x70, 0x0a, 0x33, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74,
	0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65,
	0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x73, 0x74, 0x18, 0xb3, 0x01, 0x20,
	0x01, 0x28, 0x01, 0x48, 0x36, 0x52, 0x2d, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x4d, 0x6f,
	0x64, 0x65, 0x6c, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x64, 0x43, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x50, 0x65, 0x72,
	0x43, 0x6f, 0x73, 0x74, 0x88, 0x01, 0x01, 0x12, 0x2d, 0x0a, 0x0f, 0x65, 0x6e, 0x67, 0x61, 0x67,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x18, 0xb4, 0x01, 0x20, 0x01, 0x28,
	0x01, 0x48, 0x37, 0x52, 0x0e, 0x65, 0x6e, 0x67, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x52,
	0x61, 0x74, 0x65, 0x88, 0x01, 0x01, 0x12, 0x26, 0x0a, 0x0b, 0x65, 0x6e, 0x67, 0x61, 0x67, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0xb5, 0x01, 0x20, 0x01, 0x28, 0x03, 0x48, 0x38, 0x52, 0x0b,
	0x65, 0x6e, 0x67, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x88, 0x01, 0x01, 0x12, 0x4a,
	0x0a, 0x1f, 0x68, 0x6f, 0x74, 0x65, 0x6c, 0x5f, 0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x5f,
	0x6c, 0x65, 0x61, 0x64, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x6d, 0x69, 0x63, 0x72, 0x6f,
	0x73, 0x18, 0xd5, 0x01, 0x20, 0x01, 0x28, 0x01, 0x48, 0x39, 0x52, 0x1b, 0x68, 0x6f, 0x74, 0x65,
	0x6c, 0x41, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x4c, 0x65, 0x61, 0x64, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x4d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x88, 0x01, 0x01, 0x12, 0x4f, 0x0a, 0x21, 0x68, 0x6f,
	0x74, 0x65, 0x6c, 0x5f, 0x70, 0x72, 0x69, 0x63, 0x65, 0x5f, 0x64, 0x69, 0x66, 0x66, 0x65, 0x72,
	0x65, 0x6e, 0x63, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x18,
	0xd6, 0x01, 0x20, 0x01, 0x28, 0x01, 0x48, 0x3a, 0x52, 0x1e, 0x68, 0x6f, 0x74, 0x65, 0x6c, 0x50,
	0x72, 0x69, 0x63, 0x65, 0x44, 0x69, 0x66, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x50, 0x65,
	0x72, 0x63, 0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x88, 0x01, 0x01, 0x12, 0x42, 0x0a, 0x1a, 0x68,
	0x6f, 0x74, 0x65, 0x6c, 0x5f, 0x65, 0x6c, 0x69, 0x67, 0x69, 0x62, 0x6c, 0x65, 0x5f, 0x69, 0x6d,
	0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0xd7, 0x01, 0x20, 0x01, 0x28, 0x03,
	0x48, 0x3b, 0x52, 0x18, 0x68, 0x6f, 0x74, 0x65, 0x6c, 0x45, 0x6c, 0x69, 0x67, 0x69, 0x62, 0x6c,
	0x65, 0x49, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x88, 0x01, 0x01, 0x12,
	0x93, 0x01, 0x0a, 0x21, 0x68, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x5f, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x71, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x5f,
	0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x50, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x48, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x51, 0x75, 0x61, 0x6c,
	0x69, 0x74, 0x79, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x45, 0x6e,
	0x75, 0x6d, 0x2e, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x42,
	0x75, 0x63, 0x6b, 0x65, 0x74, 0x52, 0x1e, 0x68, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x69, 0x63, 0x61,
	0x6c, 0x43, 0x72, 0x65, 0x61, 0x74, 0x69, 0x76, 0x65, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79,
	0x53, 0x63, 0x6f, 0x72, 0x65, 0x12, 0x9a, 0x01, 0x0a, 0x25, 0x68, 0x69, 0x73, 0x74, 0x6f, 0x72,
	0x69, 0x63, 0x61, 0x6c, 0x5f, 0x6c, 0x61, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x71, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18,
	0x51, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e,
	0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x53, 0x63, 0x6f,
	0x72, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x51, 0x75, 0x61,
	0x6c, 0x69, 0x74, 0x79, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x52,
	0x21, 0x68, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x4c, 0x61, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x50, 0x61, 0x67, 0x65, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x53, 0x63, 0x6f,
	0x72, 0x65, 0x12, 0x3e, 0x0a, 0x18, 0x68, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x69, 0x63, 0x61, 0x6c,
	0x5f, 0x71, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0xd8,
	0x01, 0x20, 0x01, 0x28, 0x03, 0x48, 0x3c, 0x52, 0x16, 0x68, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x69,
	0x63, 0x61, 0x6c, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x88,
	0x01, 0x01, 0x12, 0x8f, 0x01, 0x0a, 0x1f, 0x68, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x69, 0x63, 0x61,
	0x6c, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74,
	0x65, 0x64, 0x5f, 0x63, 0x74, 0x72, 0x18, 0x53, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x48, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x51, 0x75, 0x61,
	0x6c, 0x69, 0x74, 0x79, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x45,
	0x6e, 0x75, 0x6d, 0x2e, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x53, 0x63, 0x6f, 0x72, 0x65,
	0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x52, 0x1c, 0x68, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x69, 0x63,
	0x61, 0x6c, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x65,
	0x64, 0x43, 0x74, 0x72, 0x12, 0x2b, 0x0a, 0x0e, 0x67, 0x6d, 0x61, 0x69, 0x6c, 0x5f, 0x66, 0x6f,
	0x72, 0x77, 0x61, 0x72, 0x64, 0x73, 0x18, 0xd9, 0x01, 0x20, 0x01, 0x28, 0x03, 0x48, 0x3d, 0x52,
	0x0d, 0x67, 0x6d, 0x61, 0x69, 0x6c, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x73, 0x88, 0x01,
	0x01, 0x12, 0x25, 0x0a, 0x0b, 0x67, 0x6d, 0x61, 0x69, 0x6c, 0x5f, 0x73, 0x61, 0x76, 0x65, 0x73,
	0x18, 0xda, 0x01, 0x20, 0x01, 0x28, 0x03, 0x48, 0x3e, 0x52, 0x0a, 0x67, 0x6d, 0x61, 0x69, 0x6c,
	0x53, 0x61, 0x76, 0x65, 0x73, 0x88, 0x01, 0x01, 0x12, 0x3a, 0x0a, 0x16, 0x67, 0x6d, 0x61, 0x69,
	0x6c, 0x5f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x5f, 0x63, 0x6c, 0x69, 0x63,
	0x6b, 0x73, 0x18, 0xdb, 0x01, 0x20, 0x01, 0x28, 0x03, 0x48, 0x3f, 0x52, 0x14, 0x67, 0x6d, 0x61,
	0x69, 0x6c, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x43, 0x6c, 0x69, 0x63, 0x6b,
	0x73, 0x88, 0x01, 0x01, 0x12, 0x45, 0x0a, 0x1c, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x72,
	0x65, 0x61, 0x63, 0x68, 0x18, 0xdc, 0x01, 0x20, 0x01, 0x28, 0x03, 0x48, 0x40, 0x52, 0x19, 0x69,
	0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x46, 0x72, 0x6f, 0x6d, 0x53, 0x74,
	0x6f, 0x72, 0x65, 0x52, 0x65, 0x61, 0x63, 0x68, 0x88, 0x01, 0x01, 0x12, 0x26, 0x0a, 0x0b, 0x69,
	0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0xdd, 0x01, 0x20, 0x01, 0x28,
	0x03, 0x48, 0x41, 0x52, 0x0b, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x88, 0x01, 0x01, 0x12, 0x2f, 0x0a, 0x10, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x18, 0xde, 0x01, 0x20, 0x01, 0x28, 0x01, 0x48, 0x42,
	0x52, 0x0f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x61, 0x74,
	0x65, 0x88, 0x01, 0x01, 0x12, 0x28, 0x0a, 0x0c, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0xdf, 0x01, 0x20, 0x01, 0x28, 0x03, 0x48, 0x43, 0x52, 0x0c, 0x69,
	0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x88, 0x01, 0x01, 0x12, 0x84,
	0x01, 0x0a, 0x17, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x65,
	0x76, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x64, 0x20, 0x03, 0x28, 0x0e,
	0x32, 0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73,
	0x2e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x54, 0x79, 0x70, 0x65, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x15,
	0x69, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x32, 0x0a, 0x12, 0x69, 0x6e, 0x76, 0x61, 0x6c, 0x69, 0x64,
	0x5f, 0x63, 0x6c, 0x69, 0x63, 0x6b, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x18, 0xe0, 0x01, 0x20, 0x01,
	0x28, 0x01, 0x48, 0x44, 0x52, 0x10, 0x69, 0x6e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x43, 0x6c, 0x69,
	0x63, 0x6b, 0x52, 0x61, 0x74, 0x65, 0x88, 0x01, 0x01, 0x12, 0x2b, 0x0a, 0x0e, 0x69, 0x6e, 0x76,
	0x61, 0x6c, 0x69, 0x64, 0x5f, 0x63, 0x6c, 0x69, 0x63, 0x6b, 0x73, 0x18, 0xe1, 0x01, 0x20, 0x01,
	0x28, 0x03, 0x48, 0x45, 0x52, 0x0d, 0x69, 0x6e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x43, 0x6c, 0x69,
	0x63, 0x6b, 0x73, 0x88, 0x01, 0x01, 0x12, 0x29, 0x0a, 0x0d, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x5f, 0x63, 0x68, 0x61, 0x74, 0x73, 0x18, 0xe2, 0x01, 0x20, 0x01, 0x28, 0x03, 0x48, 0x46,
	0x52, 0x0c, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x43, 0x68, 0x61, 0x74, 0x73, 0x88, 0x01,
	0x01, 0x12, 0x35, 0x0a, 0x13, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x69, 0x6d, 0x70,
	0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0xe3, 0x01, 0x20, 0x01, 0x28, 0x03, 0x48,
	0x47, 0x52, 0x12, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x49, 0x6d, 0x70, 0x72, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x88, 0x01, 0x01, 0x12, 0x30, 0x0a, 0x11, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x5f, 0x63, 0x68, 0x61, 0x74, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x18, 0xe4, 0x01,
	0x20, 0x01, 0x28, 0x01, 0x48, 0x48, 0x52, 0x0f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x43,
	0x68, 0x61, 0x74, 0x52, 0x61, 0x74, 0x65, 0x88, 0x01, 0x01, 0x12, 0x4f, 0x0a, 0x21, 0x6d, 0x6f,
	0x62, 0x69, 0x6c, 0x65, 0x5f, 0x66, 0x72, 0x69, 0x65, 0x6e, 0x64, 0x6c, 0x79, 0x5f, 0x63, 0x6c,
	0x69, 0x63, 0x6b, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x18,
	0xe5, 0x01, 0x20, 0x01, 0x28, 0x01, 0x48, 0x49, 0x52, 0x1e, 0x6d, 0x6f, 0x62, 0x69, 0x6c, 0x65,
	0x46, 0x72, 0x69, 0x65, 0x6e, 0x64, 0x6c, 0x79, 0x43, 0x6c, 0x69, 0x63, 0x6b, 0x73, 0x50, 0x65,
	0x72, 0x63, 0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x88, 0x01, 0x01, 0x12, 0x2b, 0x0a, 0x0e, 0x6f,
	0x72, 0x67, 0x61, 0x6e, 0x69, 0x63, 0x5f, 0x63, 0x6c, 0x69, 0x63, 0x6b, 0x73, 0x18, 0xe6, 0x01,
	0x20, 0x01, 0x28, 0x03, 0x48, 0x4a, 0x52, 0x0d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x63, 0x43,
	0x6c, 0x69, 0x63, 0x6b, 0x73, 0x88, 0x01, 0x01, 0x12, 0x3d, 0x0a, 0x18, 0x6f, 0x72, 0x67, 0x61,
	0x6e, 0x69, 0x63, 0x5f, 0x63, 0x6c, 0x69, 0x63, 0x6b, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x18, 0xe7, 0x01, 0x20, 0x01, 0x28, 0x01, 0x48, 0x4b, 0x52, 0x15, 0x6f,
	0x72, 0x67, 0x61, 0x6e, 0x69, 0x63, 0x43, 0x6c, 0x69, 0x63, 0x6b, 0x73, 0x50, 0x65, 0x72, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x88, 0x01, 0x01, 0x12, 0x35, 0x0a, 0x13, 0x6f, 0x72, 0x67, 0x61, 0x6e,
	0x69, 0x63, 0x5f, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0xe8,
	0x01, 0x20, 0x01, 0x28, 0x03, 0x48, 0x4c, 0x52, 0x12, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x63,
	0x49, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x88, 0x01, 0x01, 0x12, 0x47,
	0x0a, 0x1d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x63, 0x5f, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18,
	0xe9, 0x01, 0x20, 0x01, 0x28, 0x01, 0x48, 0x4d, 0x52, 0x1a, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69,
	0x63, 0x49, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x50, 0x65, 0x72, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x88, 0x01, 0x01, 0x12, 0x2d, 0x0a, 0x0f, 0x6f, 0x72, 0x67, 0x61, 0x6e,
	0x69, 0x63, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x69, 0x65, 0x73, 0x18, 0xea, 0x01, 0x20, 0x01, 0x28,
	0x03, 0x48, 0x4e, 0x52, 0x0e, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x63, 0x51, 0x75, 0x65, 0x72,
	0x69, 0x65, 0x73, 0x88, 0x01, 0x01, 0x12, 0x36, 0x0a, 0x14, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e,
	0x74, 0x5f, 0x6e, 0x65, 0x77, 0x5f, 0x76, 0x69, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x73, 0x18, 0xeb,
	0x01, 0x20, 0x01, 0x28, 0x01, 0x48, 0x4f, 0x52, 0x12, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74,
	0x4e, 0x65, 0x77, 0x56, 0x69, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x73, 0x88, 0x01, 0x01, 0x12, 0x25,
	0x0a, 0x0b, 0x70, 0x68, 0x6f, 0x6e, 0x65, 0x5f, 0x63, 0x61, 0x6c, 0x6c, 0x73, 0x18, 0xec, 0x01,
	0x20, 0x01, 0x28, 0x03, 0x48, 0x50, 0x52, 0x0a, 0x70, 0x68, 0x6f, 0x6e, 0x65, 0x43, 0x61, 0x6c,
	0x6c, 0x73, 0x88, 0x01, 0x01, 0x12, 0x31, 0x0a, 0x11, 0x70, 0x68, 0x6f, 0x6e, 0x65, 0x5f, 0x69,
	0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0xed, 0x01, 0x20, 0x01, 0x28,
	0x03, 0x48, 0x51, 0x52, 0x10, 0x70, 0x68, 0x6f, 0x6e, 0x65, 0x49, 0x6d, 0x70, 0x72, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x88, 0x01, 0x01, 0x12, 0x32, 0x0a, 0x12, 0x70, 0x68, 0x6f, 0x6e,
	0x65, 0x5f, 0x74, 0x68, 0x72, 0x6f, 0x75, 0x67, 0x68, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x18, 0xee,
	0x01, 0x20, 0x01, 0x28, 0x01, 0x48, 0x52, 0x52, 0x10, 0x70, 0x68, 0x6f, 0x6e, 0x65, 0x54, 0x68,
	0x72, 0x6f, 0x75, 0x67, 0x68, 0x52, 0x61, 0x74, 0x65, 0x88, 0x01, 0x01, 0x12, 0x27, 0x0a, 0x0c,
	0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x63, 0x74, 0x72, 0x18, 0xef, 0x01, 0x20,
	0x01, 0x28, 0x01, 0x48, 0x53, 0x52, 0x0b, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x76, 0x65, 0x43,
	0x74, 0x72, 0x88, 0x01, 0x01, 0x12, 0x54, 0x0a, 0x24, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f,
	0x61, 0x62, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x65, 0x5f, 0x74, 0x6f, 0x70, 0x5f, 0x69, 0x6d, 0x70,
	0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x65, 0x18, 0x88, 0x01,
	0x20, 0x01, 0x28, 0x01, 0x48, 0x54, 0x52, 0x20, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x62,
	0x73, 0x6f, 0x6c, 0x75, 0x74, 0x65, 0x54, 0x6f, 0x70, 0x49, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x53, 0x68, 0x61, 0x72, 0x65, 0x88, 0x01, 0x01, 0x12, 0x6a, 0x0a, 0x30, 0x73,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74, 0x5f, 0x6c, 0x6f, 0x73,
	0x74, 0x5f, 0x61, 0x62, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x65, 0x5f, 0x74, 0x6f, 0x70, 0x5f, 0x69,
	0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x65, 0x18,
	0x89, 0x01, 0x20, 0x01, 0x28, 0x01, 0x48, 0x55, 0x52, 0x2a, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x42, 0x75, 0x64, 0x67, 0x65, 0x74, 0x4c, 0x6f, 0x73, 0x74, 0x41, 0x62, 0x73, 0x6f, 0x6c, 0x75,
	0x74, 0x65, 0x54, 0x6f, 0x70, 0x49, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x53,
	0x68, 0x61, 0x72, 0x65, 0x88, 0x01, 0x01, 0x12, 0x52, 0x0a, 0x23, 0x73, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x5f, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74, 0x5f, 0x6c, 0x6f, 0x73, 0x74, 0x5f, 0x69, 0x6d,
	0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x65, 0x18, 0x8a,
	0x01, 0x20, 0x01, 0x28, 0x01, 0x48, 0x56, 0x52, 0x1f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x42,
	0x75, 0x64, 0x67, 0x65, 0x74, 0x4c, 0x6f, 0x73, 0x74, 0x49, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x53, 0x68, 0x61, 0x72, 0x65, 0x88, 0x01, 0x01, 0x12, 0x59, 0x0a, 0x27, 0x73,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74, 0x5f, 0x6c, 0x6f, 0x73,
	0x74, 0x5f, 0x74, 0x6f, 0x70, 0x5f, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x5f, 0x73, 0x68, 0x61, 0x72, 0x65, 0x18, 0x8b, 0x01, 0x20, 0x01, 0x28, 0x01, 0x48, 0x57, 0x52,
	0x22, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x42, 0x75, 0x64, 0x67, 0x65, 0x74, 0x4c, 0x6f, 0x73,
	0x74, 0x54, 0x6f, 0x70, 0x49, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x68,
	0x61, 0x72, 0x65, 0x88, 0x01, 0x01, 0x12, 0x32, 0x0a, 0x12, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x5f, 0x63, 0x6c, 0x69, 0x63, 0x6b, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x65, 0x18, 0x8c, 0x01, 0x20,
	0x01, 0x28, 0x01, 0x48, 0x58, 0x52, 0x10, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x6c, 0x69,
	0x63, 0x6b, 0x53, 0x68, 0x61, 0x72, 0x65, 0x88, 0x01, 0x01, 0x12, 0x52, 0x0a, 0x23, 0x73, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x5f, 0x65, 0x78, 0x61, 0x63, 0x74, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68,
	0x5f, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x68, 0x61, 0x72,
	0x65, 0x18, 0x8d, 0x01, 0x20, 0x01, 0x28, 0x01, 0x48, 0x59, 0x52, 0x1f, 0x73, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x45, 0x78, 0x61, 0x63, 0x74, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x49, 0x6d, 0x70, 0x72,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x68, 0x61, 0x72, 0x65, 0x88, 0x01, 0x01, 0x12, 0x3c,
	0x0a, 0x17, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x65, 0x18, 0x8e, 0x01, 0x20, 0x01, 0x28, 0x01,
	0x48, 0x5a, 0x52, 0x15, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x49, 0x6d, 0x70, 0x72, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x53, 0x68, 0x61, 0x72, 0x65, 0x88, 0x01, 0x01, 0x12, 0x66, 0x0a, 0x2e,
	0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x72, 0x61, 0x6e, 0x6b, 0x5f, 0x6c, 0x6f, 0x73, 0x74,
	0x5f, 0x61, 0x62, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x65, 0x5f, 0x74, 0x6f, 0x70, 0x5f, 0x69, 0x6d,
	0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x65, 0x18, 0x8f,
	0x01, 0x20, 0x01, 0x28, 0x01, 0x48, 0x5b, 0x52, 0x28, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52,
	0x61, 0x6e, 0x6b, 0x4c, 0x6f, 0x73, 0x74, 0x41, 0x62, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x65, 0x54,
	0x6f, 0x70, 0x49, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x68, 0x61, 0x72,
	0x65, 0x88, 0x01, 0x01, 0x12, 0x4e, 0x0a, 0x21, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x72,
	0x61, 0x6e, 0x6b, 0x5f, 0x6c, 0x6f, 0x73, 0x74, 0x5f, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x65, 0x18, 0x90, 0x01, 0x20, 0x01, 0x28, 0x01,
	0x48, 0x5c, 0x52, 0x1d, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x61, 0x6e, 0x6b, 0x4c, 0x6f,
	0x73, 0x74, 0x49, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x68, 0x61, 0x72,
	0x65, 0x88, 0x01, 0x01, 0x12, 0x55, 0x0a, 0x25, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x72,
	0x61, 0x6e, 0x6b, 0x5f, 0x6c, 0x6f, 0x73, 0x74, 0x5f, 0x74, 0x6f, 0x70, 0x5f, 0x69, 0x6d, 0x70,
	0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x65, 0x18, 0x91, 0x01,
	0x20, 0x01, 0x28, 0x01, 0x48, 0x5d, 0x52, 0x20, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x61,
	0x6e, 0x6b, 0x4c, 0x6f, 0x73, 0x74, 0x54, 0x6f, 0x70, 0x49, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x53, 0x68, 0x61, 0x72, 0x65, 0x88, 0x01, 0x01, 0x12, 0x43, 0x0a, 0x1b, 0x73,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x74, 0x6f, 0x70, 0x5f, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x65, 0x18, 0x92, 0x01, 0x20, 0x01, 0x28,
	0x01, 0x48, 0x5e, 0x52, 0x18, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x54, 0x6f, 0x70, 0x49, 0x6d,
	0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x68, 0x61, 0x72, 0x65, 0x88, 0x01, 0x01,
	0x12, 0x25, 0x0a, 0x0b, 0x73, 0x70, 0x65, 0x65, 0x64, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18,
	0x93, 0x01, 0x20, 0x01, 0x28, 0x03, 0x48, 0x5f, 0x52, 0x0a, 0x73, 0x70, 0x65, 0x65, 0x64, 0x53,
	0x63, 0x6f, 0x72, 0x65, 0x88, 0x01, 0x01, 0x12, 0x40, 0x0a, 0x19, 0x74, 0x6f, 0x70, 0x5f, 0x69,
	0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e,
	0x74, 0x61, 0x67, 0x65, 0x18, 0x94, 0x01, 0x20, 0x01, 0x28, 0x01, 0x48, 0x60, 0x52, 0x17, 0x74,
	0x6f, 0x70, 0x49, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x65, 0x72, 0x63,
	0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x88, 0x01, 0x01, 0x12, 0x6b, 0x0a, 0x30, 0x76, 0x61, 0x6c,
	0x69, 0x64, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x6d,
	0x6f, 0x62, 0x69, 0x6c, 0x65, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x73, 0x5f, 0x63, 0x6c, 0x69, 0x63,
	0x6b, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x18, 0x95, 0x01,
	0x20, 0x01, 0x28, 0x01, 0x48, 0x61, 0x52, 0x2b, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x41, 0x63, 0x63,
	0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x65, 0x64, 0x4d, 0x6f, 0x62, 0x69, 0x6c, 0x65, 0x50, 0x61,
	0x67, 0x65, 0x73, 0x43, 0x6c, 0x69, 0x63, 0x6b, 0x73, 0x50, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74,
	0x61, 0x67, 0x65, 0x88, 0x01, 0x01, 0x12, 0x3f, 0x0a, 0x19, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f,
	0x70, 0x65, 0x72, 0x5f, 0x61, 0x6c, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x96, 0x01, 0x20, 0x01, 0x28, 0x01, 0x48, 0x62, 0x52, 0x16, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x50, 0x65, 0x72, 0x41, 0x6c, 0x6c, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x88, 0x01, 0x01, 0x12, 0x36, 0x0a, 0x14, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x5f, 0x70, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18,
	0x97, 0x01, 0x20, 0x01, 0x28, 0x01, 0x48, 0x63, 0x52, 0x12, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x50,
	0x65, 0x72, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12,
	0x65, 0x0a, 0x2d, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x63, 0x75, 0x72,
	0x72, 0x65, 0x6e, 0x74, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0x98, 0x01, 0x20, 0x01, 0x28, 0x01, 0x48, 0x64, 0x52, 0x28, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x50, 0x65, 0x72, 0x43, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x41,
	0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x3d, 0x0a, 0x18, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f,
	0x71, 0x75, 0x61, 0x72, 0x74, 0x69, 0x6c, 0x65, 0x5f, 0x70, 0x31, 0x30, 0x30, 0x5f, 0x72, 0x61,
	0x74, 0x65, 0x18, 0x84, 0x01, 0x20, 0x01, 0x28, 0x01, 0x48, 0x65, 0x52, 0x15, 0x76, 0x69, 0x64,
	0x65, 0x6f, 0x51, 0x75, 0x61, 0x72, 0x74, 0x69, 0x6c, 0x65, 0x50, 0x31, 0x30, 0x30, 0x52, 0x61,
	0x74, 0x65, 0x88, 0x01, 0x01, 0x12, 0x3b, 0x0a, 0x17, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x71,
	0x75, 0x61, 0x72, 0x74, 0x69, 0x6c, 0x65, 0x5f, 0x70, 0x32, 0x35, 0x5f, 0x72, 0x61, 0x74, 0x65,
	0x18, 0x85, 0x01, 0x20, 0x01, 0x28, 0x01, 0x48, 0x66, 0x52, 0x14, 0x76, 0x69, 0x64, 0x65, 0x6f,
	0x51, 0x75, 0x61, 0x72, 0x74, 0x69, 0x6c, 0x65, 0x50, 0x32, 0x35, 0x52, 0x61, 0x74, 0x65, 0x88,
	0x01, 0x01, 0x12, 0x3b, 0x0a, 0x17, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x71, 0x75, 0x61, 0x72,
	0x74, 0x69, 0x6c, 0x65, 0x5f, 0x70, 0x35, 0x30, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x18, 0x86, 0x01,
	0x20, 0x01, 0x28, 0x01, 0x48, 0x67, 0x52, 0x14, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x51, 0x75, 0x61,
	0x72, 0x74, 0x69, 0x6c, 0x65, 0x50, 0x35, 0x30, 0x52, 0x61, 0x74, 0x65, 0x88, 0x01, 0x01, 0x12,
	0x3b, 0x0a, 0x17, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x71, 0x75, 0x61, 0x72, 0x74, 0x69, 0x6c,
	0x65, 0x5f, 0x70, 0x37, 0x35, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x18, 0x87, 0x01, 0x20, 0x01, 0x28,
	0x01, 0x48, 0x68, 0x52, 0x14, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x51, 0x75, 0x61, 0x72, 0x74, 0x69,
	0x6c, 0x65, 0x50, 0x37, 0x35, 0x52, 0x61, 0x74, 0x65, 0x88, 0x01, 0x01, 0x12, 0x2c, 0x0a, 0x0f,
	0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x18,
	0x99, 0x01, 0x20, 0x01, 0x28, 0x01, 0x48, 0x69, 0x52, 0x0d, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x56,
	0x69, 0x65, 0x77, 0x52, 0x61, 0x74, 0x65, 0x88, 0x01, 0x01, 0x12, 0x25, 0x0a, 0x0b, 0x76, 0x69,
	0x64, 0x65, 0x6f, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x73, 0x18, 0x9a, 0x01, 0x20, 0x01, 0x28, 0x03,
	0x48, 0x6a, 0x52, 0x0a, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x56, 0x69, 0x65, 0x77, 0x73, 0x88, 0x01,
	0x01, 0x12, 0x3e, 0x0a, 0x18, 0x76, 0x69, 0x65, 0x77, 0x5f, 0x74, 0x68, 0x72, 0x6f, 0x75, 0x67,
	0x68, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x9b, 0x01,
	0x20, 0x01, 0x28, 0x03, 0x48, 0x6b, 0x52, 0x16, 0x76, 0x69, 0x65, 0x77, 0x54, 0x68, 0x72, 0x6f,
	0x75, 0x67, 0x68, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x88, 0x01,
	0x01, 0x42, 0x25, 0x0a, 0x23, 0x5f, 0x61, 0x62, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x65, 0x5f, 0x74,
	0x6f, 0x70, 0x5f, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x65,
	0x72, 0x63, 0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x42, 0x12, 0x0a, 0x10, 0x5f, 0x61, 0x63, 0x74,
	0x69, 0x76, 0x65, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x5f, 0x63, 0x70, 0x6d, 0x42, 0x12, 0x0a, 0x10,
	0x5f, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x5f, 0x63, 0x74, 0x72,
	0x42, 0x1a, 0x0a, 0x18, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x76, 0x69, 0x65, 0x77,
	0x5f, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x1c, 0x0a, 0x1a,
	0x5f, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x5f, 0x6d, 0x65, 0x61,
	0x73, 0x75, 0x72, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x42, 0x25, 0x0a, 0x23, 0x5f, 0x61,
	0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x5f, 0x6d, 0x65, 0x61, 0x73, 0x75,
	0x72, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x73, 0x74, 0x5f, 0x6d, 0x69, 0x63, 0x72, 0x6f,
	0x73, 0x42, 0x25, 0x0a, 0x23, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x76, 0x69, 0x65,
	0x77, 0x5f, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x69, 0x6d, 0x70,
	0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x1a, 0x0a, 0x18, 0x5f, 0x61, 0x63, 0x74,
	0x69, 0x76, 0x65, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x61, 0x62, 0x69,
	0x6c, 0x69, 0x74, 0x79, 0x42, 0x29, 0x0a, 0x27, 0x5f, 0x61, 0x6c, 0x6c, 0x5f, 0x63, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x69, 0x6e,
	0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x42,
	0x18, 0x0a, 0x16, 0x5f, 0x61, 0x6c, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x12, 0x0a, 0x10, 0x5f, 0x61, 0x6c,
	0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x21, 0x0a,
	0x1f, 0x5f, 0x61, 0x6c, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x73, 0x74,
	0x42, 0x25, 0x0a, 0x23, 0x5f, 0x61, 0x6c, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x63, 0x6c, 0x69, 0x63, 0x6b, 0x5f,
	0x74, 0x6f, 0x5f, 0x63, 0x61, 0x6c, 0x6c, 0x42, 0x22, 0x0a, 0x20, 0x5f, 0x61, 0x6c, 0x6c, 0x5f,
	0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x66, 0x72, 0x6f, 0x6d,
	0x5f, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x3a, 0x0a, 0x38, 0x5f,
	0x61, 0x6c, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x5f,
	0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x69, 0x6e, 0x74, 0x65,
	0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x1c, 0x0a, 0x1a, 0x5f, 0x61, 0x6c, 0x6c, 0x5f,
	0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x66, 0x72, 0x6f, 0x6d,
	0x5f, 0x6d, 0x65, 0x6e, 0x75, 0x42, 0x1d, 0x0a, 0x1b, 0x5f, 0x61, 0x6c, 0x6c, 0x5f, 0x63, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x6f,
	0x72, 0x64, 0x65, 0x72, 0x42, 0x28, 0x0a, 0x26, 0x5f, 0x61, 0x6c, 0x6c, 0x5f, 0x63, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x6f, 0x74,
	0x68, 0x65, 0x72, 0x5f, 0x65, 0x6e, 0x67, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x23,
	0x0a, 0x21, 0x5f, 0x61, 0x6c, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x76, 0x69,
	0x73, 0x69, 0x74, 0x42, 0x25, 0x0a, 0x23, 0x5f, 0x61, 0x6c, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x5f, 0x77, 0x65, 0x62, 0x73, 0x69, 0x74, 0x65, 0x42, 0x0f, 0x0a, 0x0d, 0x5f, 0x61,
	0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x73, 0x74, 0x42, 0x0e, 0x0a, 0x0c, 0x5f,
	0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x70, 0x63, 0x42, 0x0e, 0x0a, 0x0c, 0x5f,
	0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x70, 0x65, 0x42, 0x0e, 0x0a, 0x0c, 0x5f,
	0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x70, 0x6d, 0x42, 0x0e, 0x0a, 0x0c, 0x5f,
	0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x70, 0x76, 0x42, 0x15, 0x0a, 0x13, 0x5f,
	0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x76, 0x69, 0x65,
	0x77, 0x73, 0x42, 0x17, 0x0a, 0x15, 0x5f, 0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x5f, 0x6f, 0x6e, 0x5f, 0x73, 0x69, 0x74, 0x65, 0x42, 0x1c, 0x0a, 0x1a, 0x5f,
	0x62, 0x65, 0x6e, 0x63, 0x68, 0x6d, 0x61, 0x72, 0x6b, 0x5f, 0x61, 0x76, 0x65, 0x72, 0x61, 0x67,
	0x65, 0x5f, 0x6d, 0x61, 0x78, 0x5f, 0x63, 0x70, 0x63, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x62, 0x65,
	0x6e, 0x63, 0x68, 0x6d, 0x61, 0x72, 0x6b, 0x5f, 0x63, 0x74, 0x72, 0x42, 0x0e, 0x0a, 0x0c, 0x5f,
	0x62, 0x6f, 0x75, 0x6e, 0x63, 0x65, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x42, 0x09, 0x0a, 0x07, 0x5f,
	0x63, 0x6c, 0x69, 0x63, 0x6b, 0x73, 0x42, 0x12, 0x0a, 0x10, 0x5f, 0x63, 0x6f, 0x6d, 0x62, 0x69,
	0x6e, 0x65, 0x64, 0x5f, 0x63, 0x6c, 0x69, 0x63, 0x6b, 0x73, 0x42, 0x1c, 0x0a, 0x1a, 0x5f, 0x63,
	0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65, 0x64, 0x5f, 0x63, 0x6c, 0x69, 0x63, 0x6b, 0x73, 0x5f, 0x70,
	0x65, 0x72, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x42, 0x13, 0x0a, 0x11, 0x5f, 0x63, 0x6f, 0x6d,
	0x62, 0x69, 0x6e, 0x65, 0x64, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x69, 0x65, 0x73, 0x42, 0x27, 0x0a,
	0x25, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74,
	0x5f, 0x6c, 0x6f, 0x73, 0x74, 0x5f, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x5f, 0x73, 0x68, 0x61, 0x72, 0x65, 0x42, 0x1b, 0x0a, 0x19, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x5f, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x68,
	0x61, 0x72, 0x65, 0x42, 0x2d, 0x0a, 0x2b, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x5f, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x72, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x64,
	0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x42, 0x22, 0x0a, 0x20, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x5f, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x42, 0x25, 0x0a, 0x23, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x5f, 0x72, 0x61, 0x6e, 0x6b, 0x5f, 0x6c, 0x6f, 0x73, 0x74, 0x5f, 0x69, 0x6d, 0x70,
	0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x65, 0x42, 0x25, 0x0a,
	0x23, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x66, 0x72,
	0x6f, 0x6d, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x5f,
	0x72, 0x61, 0x74, 0x65, 0x42, 0x14, 0x0a, 0x12, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x1d, 0x0a, 0x1b, 0x5f, 0x63,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x5f, 0x70, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x73, 0x74, 0x42, 0x36, 0x0a, 0x34, 0x5f, 0x63, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x69,
	0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x63, 0x6f, 0x73, 0x74, 0x5f, 0x6d, 0x69, 0x63, 0x72, 0x6f,
	0x73, 0x42, 0x1b, 0x0a, 0x19, 0x5f, 0x63, 0x6f, 0x73, 0x74, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x61,
	0x6c, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x16,
	0x0a, 0x14, 0x5f, 0x63, 0x6f, 0x73, 0x74, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x42, 0x2f, 0x0a, 0x2d, 0x5f, 0x63, 0x6f, 0x73, 0x74, 0x5f,
	0x70, 0x65, 0x72, 0x5f, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x42, 0x1b, 0x0a, 0x19, 0x5f, 0x63, 0x72, 0x6f, 0x73,
	0x73, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x42, 0x06, 0x0a, 0x04, 0x5f, 0x63, 0x74, 0x72, 0x42, 0x27, 0x0a, 0x25,
	0x5f, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x61,
	0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x3e, 0x0a, 0x3c, 0x5f, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e,
	0x74, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x66,
	0x72, 0x6f, 0x6d, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x5f, 0x72, 0x61, 0x74, 0x65, 0x42, 0x4f, 0x0a, 0x4d, 0x5f, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e,
	0x74, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x66,
	0x72, 0x6f, 0x6d, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x2d, 0x0a, 0x2b, 0x5f, 0x63, 0x75, 0x72, 0x72, 0x65,
	0x6e, 0x74, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75,
	0x74, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x5f,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x36, 0x0a, 0x34, 0x5f, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e,
	0x74, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x73, 0x74, 0x42, 0x12, 0x0a,
	0x10, 0x5f, 0x65, 0x6e, 0x67, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x72, 0x61, 0x74,
	0x65, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x65, 0x6e, 0x67, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x42, 0x22, 0x0a, 0x20, 0x5f, 0x68, 0x6f, 0x74, 0x65, 0x6c, 0x5f, 0x61, 0x76, 0x65, 0x72,
	0x61, 0x67, 0x65, 0x5f, 0x6c, 0x65, 0x61, 0x64, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x6d,
	0x69, 0x63, 0x72, 0x6f, 0x73, 0x42, 0x24, 0x0a, 0x22, 0x5f, 0x68, 0x6f, 0x74, 0x65, 0x6c, 0x5f,
	0x70, 0x72, 0x69, 0x63, 0x65, 0x5f, 0x64, 0x69, 0x66, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x5f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x42, 0x1d, 0x0a, 0x1b, 0x5f,
	0x68, 0x6f, 0x74, 0x65, 0x6c, 0x5f, 0x65, 0x6c, 0x69, 0x67, 0x69, 0x62, 0x6c, 0x65, 0x5f, 0x69,
	0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x1b, 0x0a, 0x19, 0x5f, 0x68,
	0x69, 0x73, 0x74, 0x6f, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x5f, 0x71, 0x75, 0x61, 0x6c, 0x69, 0x74,
	0x79, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x42, 0x11, 0x0a, 0x0f, 0x5f, 0x67, 0x6d, 0x61, 0x69,
	0x6c, 0x5f, 0x66, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x73, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x67,
	0x6d, 0x61, 0x69, 0x6c, 0x5f, 0x73, 0x61, 0x76, 0x65, 0x73, 0x42, 0x19, 0x0a, 0x17, 0x5f, 0x67,
	0x6d, 0x61, 0x69, 0x6c, 0x5f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x5f, 0x63,
	0x6c, 0x69, 0x63, 0x6b, 0x73, 0x42, 0x1f, 0x0a, 0x1d, 0x5f, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x5f, 0x72, 0x65, 0x61, 0x63, 0x68, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x69, 0x6d, 0x70, 0x72, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x13, 0x0a, 0x11, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x42, 0x0f, 0x0a, 0x0d, 0x5f,
	0x69, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x15, 0x0a, 0x13,
	0x5f, 0x69, 0x6e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x5f, 0x63, 0x6c, 0x69, 0x63, 0x6b, 0x5f, 0x72,
	0x61, 0x74, 0x65, 0x42, 0x11, 0x0a, 0x0f, 0x5f, 0x69, 0x6e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x5f,
	0x63, 0x6c, 0x69, 0x63, 0x6b, 0x73, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x5f, 0x63, 0x68, 0x61, 0x74, 0x73, 0x42, 0x16, 0x0a, 0x14, 0x5f, 0x6d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x5f, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x42, 0x14, 0x0a, 0x12, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x68, 0x61,
	0x74, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x42, 0x24, 0x0a, 0x22, 0x5f, 0x6d, 0x6f, 0x62, 0x69, 0x6c,
	0x65, 0x5f, 0x66, 0x72, 0x69, 0x65, 0x6e, 0x64, 0x6c, 0x79, 0x5f, 0x63, 0x6c, 0x69, 0x63, 0x6b,
	0x73, 0x5f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x42, 0x11, 0x0a, 0x0f,
	0x5f, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x63, 0x5f, 0x63, 0x6c, 0x69, 0x63, 0x6b, 0x73, 0x42,
	0x1b, 0x0a, 0x19, 0x5f, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x63, 0x5f, 0x63, 0x6c, 0x69, 0x63,
	0x6b, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x42, 0x16, 0x0a, 0x14,
	0x5f, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x63, 0x5f, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x42, 0x20, 0x0a, 0x1e, 0x5f, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x63,
	0x5f, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x70, 0x65, 0x72,
	0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x42, 0x12, 0x0a, 0x10, 0x5f, 0x6f, 0x72, 0x67, 0x61, 0x6e,
	0x69, 0x63, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x69, 0x65, 0x73, 0x42, 0x17, 0x0a, 0x15, 0x5f, 0x70,
	0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x5f, 0x6e, 0x65, 0x77, 0x5f, 0x76, 0x69, 0x73, 0x69, 0x74,
	0x6f, 0x72, 0x73, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x70, 0x68, 0x6f, 0x6e, 0x65, 0x5f, 0x63, 0x61,
	0x6c, 0x6c, 0x73, 0x42, 0x14, 0x0a, 0x12, 0x5f, 0x70, 0x68, 0x6f, 0x6e, 0x65, 0x5f, 0x69, 0x6d,
	0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x15, 0x0a, 0x13, 0x5f, 0x70, 0x68,
	0x6f, 0x6e, 0x65, 0x5f, 0x74, 0x68, 0x72, 0x6f, 0x75, 0x67, 0x68, 0x5f, 0x72, 0x61, 0x74, 0x65,
	0x42, 0x0f, 0x0a, 0x0d, 0x5f, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x63, 0x74,
	0x72, 0x42, 0x27, 0x0a, 0x25, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x61, 0x62, 0x73,
	0x6f, 0x6c, 0x75, 0x74, 0x65, 0x5f, 0x74, 0x6f, 0x70, 0x5f, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x65, 0x42, 0x33, 0x0a, 0x31, 0x5f, 0x73,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74, 0x5f, 0x6c, 0x6f, 0x73,
	0x74, 0x5f, 0x61, 0x62, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x65, 0x5f, 0x74, 0x6f, 0x70, 0x5f, 0x69,
	0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x65, 0x42,
	0x26, 0x0a, 0x24, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x62, 0x75, 0x64, 0x67, 0x65,
	0x74, 0x5f, 0x6c, 0x6f, 0x73, 0x74, 0x5f, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x65, 0x42, 0x2a, 0x0a, 0x28, 0x5f, 0x73, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x5f, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74, 0x5f, 0x6c, 0x6f, 0x73, 0x74, 0x5f, 0x74,
	0x6f, 0x70, 0x5f, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x68,
	0x61, 0x72, 0x65, 0x42, 0x15, 0x0a, 0x13, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x63,
	0x6c, 0x69, 0x63, 0x6b, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x65, 0x42, 0x26, 0x0a, 0x24, 0x5f, 0x73,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x65, 0x78, 0x61, 0x63, 0x74, 0x5f, 0x6d, 0x61, 0x74, 0x63,
	0x68, 0x5f, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x68, 0x61,
	0x72, 0x65, 0x42, 0x1a, 0x0a, 0x18, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x69, 0x6d,
	0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x65, 0x42, 0x31,
	0x0a, 0x2f, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x72, 0x61, 0x6e, 0x6b, 0x5f, 0x6c,
	0x6f, 0x73, 0x74, 0x5f, 0x61, 0x62, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x65, 0x5f, 0x74, 0x6f, 0x70,
	0x5f, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x68, 0x61, 0x72,
	0x65, 0x42, 0x24, 0x0a, 0x22, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x72, 0x61, 0x6e,
	0x6b, 0x5f, 0x6c, 0x6f, 0x73, 0x74, 0x5f, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x65, 0x42, 0x28, 0x0a, 0x26, 0x5f, 0x73, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x5f, 0x72, 0x61, 0x6e, 0x6b, 0x5f, 0x6c, 0x6f, 0x73, 0x74, 0x5f, 0x74, 0x6f, 0x70,
	0x5f, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x68, 0x61, 0x72,
	0x65, 0x42, 0x1e, 0x0a, 0x1c, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x74, 0x6f, 0x70,
	0x5f, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x68, 0x61, 0x72,
	0x65, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x73, 0x70, 0x65, 0x65, 0x64, 0x5f, 0x73, 0x63, 0x6f, 0x72,
	0x65, 0x42, 0x1c, 0x0a, 0x1a, 0x5f, 0x74, 0x6f, 0x70, 0x5f, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x42,
	0x33, 0x0a, 0x31, 0x5f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x6c, 0x65,
	0x72, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x6d, 0x6f, 0x62, 0x69, 0x6c, 0x65, 0x5f, 0x70, 0x61, 0x67,
	0x65, 0x73, 0x5f, 0x63, 0x6c, 0x69, 0x63, 0x6b, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e,
	0x74, 0x61, 0x67, 0x65, 0x42, 0x1c, 0x0a, 0x1a, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x70,
	0x65, 0x72, 0x5f, 0x61, 0x6c, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x42, 0x17, 0x0a, 0x15, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x70, 0x65, 0x72,
	0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x42, 0x30, 0x0a, 0x2e, 0x5f,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e,
	0x74, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x42, 0x1b, 0x0a,
	0x19, 0x5f, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x71, 0x75, 0x61, 0x72, 0x74, 0x69, 0x6c, 0x65,
	0x5f, 0x70, 0x31, 0x30, 0x30, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x42, 0x1a, 0x0a, 0x18, 0x5f, 0x76,
	0x69, 0x64, 0x65, 0x6f, 0x5f, 0x71, 0x75, 0x61, 0x72, 0x74, 0x69, 0x6c, 0x65, 0x5f, 0x70, 0x32,
	0x35, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x42, 0x1a, 0x0a, 0x18, 0x5f, 0x76, 0x69, 0x64, 0x65, 0x6f,
	0x5f, 0x71, 0x75, 0x61, 0x72, 0x74, 0x69, 0x6c, 0x65, 0x5f, 0x70, 0x35, 0x30, 0x5f, 0x72, 0x61,
	0x74, 0x65, 0x42, 0x1a, 0x0a, 0x18, 0x5f, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x71, 0x75, 0x61,
	0x72, 0x74, 0x69, 0x6c, 0x65, 0x5f, 0x70, 0x37, 0x35, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x42, 0x12,
	0x0a, 0x10, 0x5f, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x5f, 0x72, 0x61,
	0x74, 0x65, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x76, 0x69, 0x65,
	0x77, 0x73, 0x42, 0x1b, 0x0a, 0x19, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x5f, 0x74, 0x68, 0x72, 0x6f,
	0x75, 0x67, 0x68, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x42,
	0xe7, 0x01, 0x0a, 0x22, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e,
	0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x42, 0x0c, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x44, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67,
	0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x61, 0x64,
	0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x36, 0x2f, 0x63,
	0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x3b, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0xa2, 0x02, 0x03, 0x47,
	0x41, 0x41, 0xaa, 0x02, 0x1e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x41, 0x64, 0x73, 0x2e,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x2e, 0x56, 0x36, 0x2e, 0x43, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0xca, 0x02, 0x1e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x41, 0x64, 0x73,
	0x5c, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x5c, 0x56, 0x36, 0x5c, 0x43, 0x6f,
	0x6d, 0x6d, 0x6f, 0x6e, 0xea, 0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x41,
	0x64, 0x73, 0x3a, 0x3a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x3a, 0x3a, 0x56,
	0x36, 0x3a, 0x3a, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x33,
}

var (
	file_google_ads_googleads_v6_common_metrics_proto_rawDescOnce sync.Once
	file_google_ads_googleads_v6_common_metrics_proto_rawDescData = file_google_ads_googleads_v6_common_metrics_proto_rawDesc
)

func file_google_ads_googleads_v6_common_metrics_proto_rawDescGZIP() []byte {
	file_google_ads_googleads_v6_common_metrics_proto_rawDescOnce.Do(func() {
		file_google_ads_googleads_v6_common_metrics_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_ads_googleads_v6_common_metrics_proto_rawDescData)
	})
	return file_google_ads_googleads_v6_common_metrics_proto_rawDescData
}

var file_google_ads_googleads_v6_common_metrics_proto_msgTypes = make([]protoimpl.MessageInfo, 1)
var file_google_ads_googleads_v6_common_metrics_proto_goTypes = []interface{}{
	(*Metrics)(nil), // 0: google.ads.googleads.v6.common.Metrics
	(enums.QualityScoreBucketEnum_QualityScoreBucket)(0),     // 1: google.ads.googleads.v6.enums.QualityScoreBucketEnum.QualityScoreBucket
	(enums.InteractionEventTypeEnum_InteractionEventType)(0), // 2: google.ads.googleads.v6.enums.InteractionEventTypeEnum.InteractionEventType
}
var file_google_ads_googleads_v6_common_metrics_proto_depIdxs = []int32{
	1, // 0: google.ads.googleads.v6.common.Metrics.historical_creative_quality_score:type_name -> google.ads.googleads.v6.enums.QualityScoreBucketEnum.QualityScoreBucket
	1, // 1: google.ads.googleads.v6.common.Metrics.historical_landing_page_quality_score:type_name -> google.ads.googleads.v6.enums.QualityScoreBucketEnum.QualityScoreBucket
	1, // 2: google.ads.googleads.v6.common.Metrics.historical_search_predicted_ctr:type_name -> google.ads.googleads.v6.enums.QualityScoreBucketEnum.QualityScoreBucket
	2, // 3: google.ads.googleads.v6.common.Metrics.interaction_event_types:type_name -> google.ads.googleads.v6.enums.InteractionEventTypeEnum.InteractionEventType
	4, // [4:4] is the sub-list for method output_type
	4, // [4:4] is the sub-list for method input_type
	4, // [4:4] is the sub-list for extension type_name
	4, // [4:4] is the sub-list for extension extendee
	0, // [0:4] is the sub-list for field type_name
}

func init() { file_google_ads_googleads_v6_common_metrics_proto_init() }
func file_google_ads_googleads_v6_common_metrics_proto_init() {
	if File_google_ads_googleads_v6_common_metrics_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_ads_googleads_v6_common_metrics_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Metrics); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_ads_googleads_v6_common_metrics_proto_msgTypes[0].OneofWrappers = []interface{}{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_ads_googleads_v6_common_metrics_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   1,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_ads_googleads_v6_common_metrics_proto_goTypes,
		DependencyIndexes: file_google_ads_googleads_v6_common_metrics_proto_depIdxs,
		MessageInfos:      file_google_ads_googleads_v6_common_metrics_proto_msgTypes,
	}.Build()
	File_google_ads_googleads_v6_common_metrics_proto = out.File
	file_google_ads_googleads_v6_common_metrics_proto_rawDesc = nil
	file_google_ads_googleads_v6_common_metrics_proto_goTypes = nil
	file_google_ads_googleads_v6_common_metrics_proto_depIdxs = nil
}
