// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.13.0
// source: google/ads/googleads/v5/services/batch_job_service.proto

package services

import (
	context "context"
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	resources "google.golang.org/genproto/googleapis/ads/googleads/v5/resources"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	status "google.golang.org/genproto/googleapis/rpc/status"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Request message for [BatchJobService.MutateBatchJob][google.ads.googleads.v5.services.BatchJobService.MutateBatchJob].
type MutateBatchJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The ID of the customer for which to create a batch job.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// Required. The operation to perform on an individual batch job.
	Operation *BatchJobOperation `protobuf:"bytes,2,opt,name=operation,proto3" json:"operation,omitempty"`
}

func (x *MutateBatchJobRequest) Reset() {
	*x = MutateBatchJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v5_services_batch_job_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MutateBatchJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MutateBatchJobRequest) ProtoMessage() {}

func (x *MutateBatchJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v5_services_batch_job_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MutateBatchJobRequest.ProtoReflect.Descriptor instead.
func (*MutateBatchJobRequest) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v5_services_batch_job_service_proto_rawDescGZIP(), []int{0}
}

func (x *MutateBatchJobRequest) GetCustomerId() string {
	if x != nil {
		return x.CustomerId
	}
	return ""
}

func (x *MutateBatchJobRequest) GetOperation() *BatchJobOperation {
	if x != nil {
		return x.Operation
	}
	return nil
}

// A single operation on a batch job.
type BatchJobOperation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The mutate operation.
	//
	// Types that are assignable to Operation:
	//	*BatchJobOperation_Create
	Operation isBatchJobOperation_Operation `protobuf_oneof:"operation"`
}

func (x *BatchJobOperation) Reset() {
	*x = BatchJobOperation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v5_services_batch_job_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchJobOperation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchJobOperation) ProtoMessage() {}

func (x *BatchJobOperation) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v5_services_batch_job_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchJobOperation.ProtoReflect.Descriptor instead.
func (*BatchJobOperation) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v5_services_batch_job_service_proto_rawDescGZIP(), []int{1}
}

func (m *BatchJobOperation) GetOperation() isBatchJobOperation_Operation {
	if m != nil {
		return m.Operation
	}
	return nil
}

func (x *BatchJobOperation) GetCreate() *resources.BatchJob {
	if x, ok := x.GetOperation().(*BatchJobOperation_Create); ok {
		return x.Create
	}
	return nil
}

type isBatchJobOperation_Operation interface {
	isBatchJobOperation_Operation()
}

type BatchJobOperation_Create struct {
	// Create operation: No resource name is expected for the new batch job.
	Create *resources.BatchJob `protobuf:"bytes,1,opt,name=create,proto3,oneof"`
}

func (*BatchJobOperation_Create) isBatchJobOperation_Operation() {}

// Response message for [BatchJobService.MutateBatchJob][google.ads.googleads.v5.services.BatchJobService.MutateBatchJob].
type MutateBatchJobResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The result for the mutate.
	Result *MutateBatchJobResult `protobuf:"bytes,1,opt,name=result,proto3" json:"result,omitempty"`
}

func (x *MutateBatchJobResponse) Reset() {
	*x = MutateBatchJobResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v5_services_batch_job_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MutateBatchJobResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MutateBatchJobResponse) ProtoMessage() {}

func (x *MutateBatchJobResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v5_services_batch_job_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MutateBatchJobResponse.ProtoReflect.Descriptor instead.
func (*MutateBatchJobResponse) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v5_services_batch_job_service_proto_rawDescGZIP(), []int{2}
}

func (x *MutateBatchJobResponse) GetResult() *MutateBatchJobResult {
	if x != nil {
		return x.Result
	}
	return nil
}

// The result for the batch job mutate.
type MutateBatchJobResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the batch job.
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
}

func (x *MutateBatchJobResult) Reset() {
	*x = MutateBatchJobResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v5_services_batch_job_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MutateBatchJobResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MutateBatchJobResult) ProtoMessage() {}

func (x *MutateBatchJobResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v5_services_batch_job_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MutateBatchJobResult.ProtoReflect.Descriptor instead.
func (*MutateBatchJobResult) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v5_services_batch_job_service_proto_rawDescGZIP(), []int{3}
}

func (x *MutateBatchJobResult) GetResourceName() string {
	if x != nil {
		return x.ResourceName
	}
	return ""
}

// Request message for [BatchJobService.GetBatchJob][google.ads.googleads.v5.services.BatchJobService.GetBatchJob].
type GetBatchJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the batch job to get.
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
}

func (x *GetBatchJobRequest) Reset() {
	*x = GetBatchJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v5_services_batch_job_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetBatchJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetBatchJobRequest) ProtoMessage() {}

func (x *GetBatchJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v5_services_batch_job_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetBatchJobRequest.ProtoReflect.Descriptor instead.
func (*GetBatchJobRequest) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v5_services_batch_job_service_proto_rawDescGZIP(), []int{4}
}

func (x *GetBatchJobRequest) GetResourceName() string {
	if x != nil {
		return x.ResourceName
	}
	return ""
}

// Request message for [BatchJobService.RunBatchJob][google.ads.googleads.v5.services.BatchJobService.RunBatchJob].
type RunBatchJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the BatchJob to run.
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
}

func (x *RunBatchJobRequest) Reset() {
	*x = RunBatchJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v5_services_batch_job_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RunBatchJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RunBatchJobRequest) ProtoMessage() {}

func (x *RunBatchJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v5_services_batch_job_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RunBatchJobRequest.ProtoReflect.Descriptor instead.
func (*RunBatchJobRequest) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v5_services_batch_job_service_proto_rawDescGZIP(), []int{5}
}

func (x *RunBatchJobRequest) GetResourceName() string {
	if x != nil {
		return x.ResourceName
	}
	return ""
}

// Request message for [BatchJobService.AddBatchJobOperations][google.ads.googleads.v5.services.BatchJobService.AddBatchJobOperations].
type AddBatchJobOperationsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the batch job.
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// A token used to enforce sequencing.
	//
	// The first AddBatchJobOperations request for a batch job should not set
	// sequence_token. Subsequent requests must set sequence_token to the value of
	// next_sequence_token received in the previous AddBatchJobOperations
	// response.
	SequenceToken string `protobuf:"bytes,2,opt,name=sequence_token,json=sequenceToken,proto3" json:"sequence_token,omitempty"`
	// Required. The list of mutates being added.
	//
	// Operations can use negative integers as temp ids to signify dependencies
	// between entities created in this batch job. For example, a customer with
	// id = 1234 can create a campaign and an ad group in that same campaign by
	// creating a campaign in the first operation with the resource name
	// explicitly set to "customers/1234/campaigns/-1", and creating an ad group
	// in the second operation with the campaign field also set to
	// "customers/1234/campaigns/-1".
	MutateOperations []*MutateOperation `protobuf:"bytes,3,rep,name=mutate_operations,json=mutateOperations,proto3" json:"mutate_operations,omitempty"`
}

func (x *AddBatchJobOperationsRequest) Reset() {
	*x = AddBatchJobOperationsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v5_services_batch_job_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddBatchJobOperationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddBatchJobOperationsRequest) ProtoMessage() {}

func (x *AddBatchJobOperationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v5_services_batch_job_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddBatchJobOperationsRequest.ProtoReflect.Descriptor instead.
func (*AddBatchJobOperationsRequest) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v5_services_batch_job_service_proto_rawDescGZIP(), []int{6}
}

func (x *AddBatchJobOperationsRequest) GetResourceName() string {
	if x != nil {
		return x.ResourceName
	}
	return ""
}

func (x *AddBatchJobOperationsRequest) GetSequenceToken() string {
	if x != nil {
		return x.SequenceToken
	}
	return ""
}

func (x *AddBatchJobOperationsRequest) GetMutateOperations() []*MutateOperation {
	if x != nil {
		return x.MutateOperations
	}
	return nil
}

// Response message for [BatchJobService.AddBatchJobOperations][google.ads.googleads.v5.services.BatchJobService.AddBatchJobOperations].
type AddBatchJobOperationsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The total number of operations added so far for this batch job.
	TotalOperations int64 `protobuf:"varint,1,opt,name=total_operations,json=totalOperations,proto3" json:"total_operations,omitempty"`
	// The sequence token to be used when calling AddBatchJobOperations again if
	// more operations need to be added. The next AddBatchJobOperations request
	// must set the sequence_token field to the value of this field.
	NextSequenceToken string `protobuf:"bytes,2,opt,name=next_sequence_token,json=nextSequenceToken,proto3" json:"next_sequence_token,omitempty"`
}

func (x *AddBatchJobOperationsResponse) Reset() {
	*x = AddBatchJobOperationsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v5_services_batch_job_service_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddBatchJobOperationsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddBatchJobOperationsResponse) ProtoMessage() {}

func (x *AddBatchJobOperationsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v5_services_batch_job_service_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddBatchJobOperationsResponse.ProtoReflect.Descriptor instead.
func (*AddBatchJobOperationsResponse) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v5_services_batch_job_service_proto_rawDescGZIP(), []int{7}
}

func (x *AddBatchJobOperationsResponse) GetTotalOperations() int64 {
	if x != nil {
		return x.TotalOperations
	}
	return 0
}

func (x *AddBatchJobOperationsResponse) GetNextSequenceToken() string {
	if x != nil {
		return x.NextSequenceToken
	}
	return ""
}

// Request message for [BatchJobService.ListBatchJobResults][google.ads.googleads.v5.services.BatchJobService.ListBatchJobResults].
type ListBatchJobResultsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the batch job whose results are being listed.
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// Token of the page to retrieve. If not specified, the first
	// page of results will be returned. Use the value obtained from
	// `next_page_token` in the previous response in order to request
	// the next page of results.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Number of elements to retrieve in a single page.
	// When a page request is too large, the server may decide to
	// further limit the number of returned resources.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
}

func (x *ListBatchJobResultsRequest) Reset() {
	*x = ListBatchJobResultsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v5_services_batch_job_service_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListBatchJobResultsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBatchJobResultsRequest) ProtoMessage() {}

func (x *ListBatchJobResultsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v5_services_batch_job_service_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBatchJobResultsRequest.ProtoReflect.Descriptor instead.
func (*ListBatchJobResultsRequest) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v5_services_batch_job_service_proto_rawDescGZIP(), []int{8}
}

func (x *ListBatchJobResultsRequest) GetResourceName() string {
	if x != nil {
		return x.ResourceName
	}
	return ""
}

func (x *ListBatchJobResultsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListBatchJobResultsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

// Response message for [BatchJobService.ListBatchJobResults][google.ads.googleads.v5.services.BatchJobService.ListBatchJobResults].
type ListBatchJobResultsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of rows that matched the query.
	Results []*BatchJobResult `protobuf:"bytes,1,rep,name=results,proto3" json:"results,omitempty"`
	// Pagination token used to retrieve the next page of results.
	// Pass the content of this string as the `page_token` attribute of
	// the next request. `next_page_token` is not returned for the last
	// page.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListBatchJobResultsResponse) Reset() {
	*x = ListBatchJobResultsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v5_services_batch_job_service_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListBatchJobResultsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBatchJobResultsResponse) ProtoMessage() {}

func (x *ListBatchJobResultsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v5_services_batch_job_service_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBatchJobResultsResponse.ProtoReflect.Descriptor instead.
func (*ListBatchJobResultsResponse) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v5_services_batch_job_service_proto_rawDescGZIP(), []int{9}
}

func (x *ListBatchJobResultsResponse) GetResults() []*BatchJobResult {
	if x != nil {
		return x.Results
	}
	return nil
}

func (x *ListBatchJobResultsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// An individual batch job result.
type BatchJobResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Index of the mutate operation.
	OperationIndex int64 `protobuf:"varint,1,opt,name=operation_index,json=operationIndex,proto3" json:"operation_index,omitempty"`
	// Response for the mutate.
	// May be empty if errors occurred.
	MutateOperationResponse *MutateOperationResponse `protobuf:"bytes,2,opt,name=mutate_operation_response,json=mutateOperationResponse,proto3" json:"mutate_operation_response,omitempty"`
	// Details of the errors when processing the operation.
	Status *status.Status `protobuf:"bytes,3,opt,name=status,proto3" json:"status,omitempty"`
}

func (x *BatchJobResult) Reset() {
	*x = BatchJobResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v5_services_batch_job_service_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchJobResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchJobResult) ProtoMessage() {}

func (x *BatchJobResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v5_services_batch_job_service_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchJobResult.ProtoReflect.Descriptor instead.
func (*BatchJobResult) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v5_services_batch_job_service_proto_rawDescGZIP(), []int{10}
}

func (x *BatchJobResult) GetOperationIndex() int64 {
	if x != nil {
		return x.OperationIndex
	}
	return 0
}

func (x *BatchJobResult) GetMutateOperationResponse() *MutateOperationResponse {
	if x != nil {
		return x.MutateOperationResponse
	}
	return nil
}

func (x *BatchJobResult) GetStatus() *status.Status {
	if x != nil {
		return x.Status
	}
	return nil
}

var File_google_ads_googleads_v5_services_batch_job_service_proto protoreflect.FileDescriptor

var file_google_ads_googleads_v5_services_batch_job_service_proto_rawDesc = []byte{
	0x0a, 0x38, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x35, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x73, 0x2f, 0x62, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x6a, 0x6f, 0x62, 0x5f, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x20, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2e, 0x76, 0x35, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x1a, 0x31, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x64, 0x73, 0x2f, 0x76, 0x35, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f,
	0x62, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x6a, 0x6f, 0x62, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x39, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x35, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x61, 0x64, 0x73, 0x5f, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x95, 0x01, 0x0a, 0x15,
	0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x42, 0x61, 0x74, 0x63, 0x68, 0x4a, 0x6f, 0x62, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x24, 0x0a, 0x0b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65,
	0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0a, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x49, 0x64, 0x12, 0x56, 0x0a, 0x09, 0x6f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x35, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x73, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x4a, 0x6f, 0x62, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0x67, 0x0a, 0x11, 0x42, 0x61, 0x74, 0x63, 0x68, 0x4a, 0x6f, 0x62, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x45, 0x0a, 0x06, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e,
	0x76, 0x35, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x42, 0x61, 0x74,
	0x63, 0x68, 0x4a, 0x6f, 0x62, 0x48, 0x00, 0x52, 0x06, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x42,
	0x0b, 0x0a, 0x09, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x68, 0x0a, 0x16,
	0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x42, 0x61, 0x74, 0x63, 0x68, 0x4a, 0x6f, 0x62, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4e, 0x0a, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x35,
	0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65,
	0x42, 0x61, 0x74, 0x63, 0x68, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x06,
	0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x22, 0x3b, 0x0a, 0x14, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65,
	0x42, 0x61, 0x74, 0x63, 0x68, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x23,
	0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4e,
	0x61, 0x6d, 0x65, 0x22, 0x64, 0x0a, 0x12, 0x47, 0x65, 0x74, 0x42, 0x61, 0x74, 0x63, 0x68, 0x4a,
	0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4e, 0x0a, 0x0d, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x42, 0x61, 0x74, 0x63, 0x68, 0x4a, 0x6f, 0x62, 0x52, 0x0c, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x64, 0x0a, 0x12, 0x52, 0x75, 0x6e,
	0x42, 0x61, 0x74, 0x63, 0x68, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x4e, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x61, 0x74, 0x63, 0x68, 0x4a, 0x6f,
	0x62, 0x52, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x22,
	0xfa, 0x01, 0x0a, 0x1c, 0x41, 0x64, 0x64, 0x42, 0x61, 0x74, 0x63, 0x68, 0x4a, 0x6f, 0x62, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x4e, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a,
	0x21, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x61, 0x74, 0x63, 0x68, 0x4a,
	0x6f, 0x62, 0x52, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x25, 0x0a, 0x0e, 0x73, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x73, 0x65, 0x71, 0x75, 0x65, 0x6e,
	0x63, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x63, 0x0a, 0x11, 0x6d, 0x75, 0x74, 0x61, 0x74,
	0x65, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x35, 0x2e, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10, 0x6d, 0x75, 0x74, 0x61,
	0x74, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x7a, 0x0a, 0x1d,
	0x41, 0x64, 0x64, 0x42, 0x61, 0x74, 0x63, 0x68, 0x4a, 0x6f, 0x62, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x29, 0x0a,
	0x10, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0f, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x2e, 0x0a, 0x13, 0x6e, 0x65, 0x78, 0x74,
	0x5f, 0x73, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x6e, 0x65, 0x78, 0x74, 0x53, 0x65, 0x71, 0x75, 0x65,
	0x6e, 0x63, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xa8, 0x01, 0x0a, 0x1a, 0x4c, 0x69, 0x73,
	0x74, 0x42, 0x61, 0x74, 0x63, 0x68, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4e, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x42, 0x61, 0x74, 0x63, 0x68, 0x4a, 0x6f, 0x62, 0x52, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53,
	0x69, 0x7a, 0x65, 0x22, 0x91, 0x01, 0x0a, 0x1b, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x61, 0x74, 0x63,
	0x68, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x4a, 0x0a, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x35, 0x2e, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x4a, 0x6f, 0x62,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12,
	0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xdc, 0x01, 0x0a, 0x0e, 0x42, 0x61, 0x74, 0x63,
	0x68, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x27, 0x0a, 0x0f, 0x6f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x0e, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e,
	0x64, 0x65, 0x78, 0x12, 0x75, 0x0a, 0x19, 0x6d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x35,
	0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x52, 0x17, 0x6d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2a, 0x0a, 0x06, 0x73, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06,
	0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x32, 0xe3, 0x09, 0x0a, 0x0f, 0x42, 0x61, 0x74, 0x63, 0x68,
	0x4a, 0x6f, 0x62, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xd6, 0x01, 0x0a, 0x0e, 0x4d,
	0x75, 0x74, 0x61, 0x74, 0x65, 0x42, 0x61, 0x74, 0x63, 0x68, 0x4a, 0x6f, 0x62, 0x12, 0x37, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x35, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73,
	0x2e, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x42, 0x61, 0x74, 0x63, 0x68, 0x4a, 0x6f, 0x62, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x35,
	0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65,
	0x42, 0x61, 0x74, 0x63, 0x68, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x51, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33, 0x22, 0x2e, 0x2f, 0x76, 0x35, 0x2f, 0x63, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65,
	0x72, 0x5f, 0x69, 0x64, 0x3d, 0x2a, 0x7d, 0x2f, 0x62, 0x61, 0x74, 0x63, 0x68, 0x4a, 0x6f, 0x62,
	0x73, 0x3a, 0x6d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x15, 0x63, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x2c, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0xb5, 0x01, 0x0a, 0x0b, 0x47, 0x65, 0x74, 0x42, 0x61, 0x74, 0x63, 0x68,
	0x4a, 0x6f, 0x62, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x35, 0x2e, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x47, 0x65, 0x74, 0x42, 0x61, 0x74, 0x63, 0x68, 0x4a,
	0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2e, 0x76, 0x35, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x42, 0x61,
	0x74, 0x63, 0x68, 0x4a, 0x6f, 0x62, 0x22, 0x43, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2d, 0x12, 0x2b,
	0x2f, 0x76, 0x35, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x62,
	0x61, 0x74, 0x63, 0x68, 0x4a, 0x6f, 0x62, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x0d, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xe3, 0x01, 0x0a, 0x13,
	0x4c, 0x69, 0x73, 0x74, 0x42, 0x61, 0x74, 0x63, 0x68, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x73, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x35, 0x2e, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x61, 0x74, 0x63, 0x68,
	0x4a, 0x6f, 0x62, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x35, 0x2e, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x73, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x61, 0x74, 0x63, 0x68, 0x4a, 0x6f,
	0x62, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x4f, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x39, 0x12, 0x37, 0x2f, 0x76, 0x35, 0x2f, 0x7b, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x61, 0x74, 0x63, 0x68, 0x4a, 0x6f,
	0x62, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x6c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x73, 0xda, 0x41, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x86, 0x02, 0x0a, 0x0b, 0x52, 0x75, 0x6e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x4a, 0x6f,
	0x62, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x35, 0x2e, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x73, 0x2e, 0x52, 0x75, 0x6e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x4a, 0x6f, 0x62,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xa1, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x34, 0x22,
	0x2f, 0x2f, 0x76, 0x35, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f,
	0x62, 0x61, 0x74, 0x63, 0x68, 0x4a, 0x6f, 0x62, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x75, 0x6e,
	0x3a, 0x01, 0x2a, 0xda, 0x41, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0xca, 0x41, 0x54, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x3b, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x64, 0x73, 0x2e, 0x76, 0x35, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x4a, 0x6f, 0x62, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x4a,
	0x6f, 0x62, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xb2, 0x02, 0x0a, 0x15, 0x41,
	0x64, 0x64, 0x42, 0x61, 0x74, 0x63, 0x68, 0x4a, 0x6f, 0x62, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x35, 0x2e, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x41, 0x64, 0x64, 0x42, 0x61, 0x74, 0x63, 0x68,
	0x4a, 0x6f, 0x62, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x35, 0x2e, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x41, 0x64, 0x64, 0x42, 0x61, 0x74, 0x63, 0x68,
	0x4a, 0x6f, 0x62, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x97, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3e, 0x22, 0x39,
	0x2f, 0x76, 0x35, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x62,
	0x61, 0x74, 0x63, 0x68, 0x4a, 0x6f, 0x62, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x61, 0x64, 0x64, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x2e, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x73, 0x65, 0x71,
	0x75, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x2c, 0x6d, 0x75, 0x74, 0x61,
	0x74, 0x65, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0xda, 0x41, 0x1f,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x6d, 0x75,
	0x74, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a,
	0x1b, 0xca, 0x41, 0x18, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x42, 0xfb, 0x01, 0x0a,
	0x24, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x35, 0x2e, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x73, 0x42, 0x14, 0x42, 0x61, 0x74, 0x63, 0x68, 0x4a, 0x6f, 0x62, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x48, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67,
	0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x64, 0x73, 0x2f, 0x76, 0x35, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x3b, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0xa2, 0x02, 0x03, 0x47, 0x41, 0x41, 0xaa, 0x02, 0x20,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x41, 0x64, 0x73, 0x2e, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x41, 0x64, 0x73, 0x2e, 0x56, 0x35, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73,
	0xca, 0x02, 0x20, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x41, 0x64, 0x73, 0x5c, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x5c, 0x56, 0x35, 0x5c, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x73, 0xea, 0x02, 0x24, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x41, 0x64,
	0x73, 0x3a, 0x3a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x3a, 0x3a, 0x56, 0x35,
	0x3a, 0x3a, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x33,
}

var (
	file_google_ads_googleads_v5_services_batch_job_service_proto_rawDescOnce sync.Once
	file_google_ads_googleads_v5_services_batch_job_service_proto_rawDescData = file_google_ads_googleads_v5_services_batch_job_service_proto_rawDesc
)

func file_google_ads_googleads_v5_services_batch_job_service_proto_rawDescGZIP() []byte {
	file_google_ads_googleads_v5_services_batch_job_service_proto_rawDescOnce.Do(func() {
		file_google_ads_googleads_v5_services_batch_job_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_ads_googleads_v5_services_batch_job_service_proto_rawDescData)
	})
	return file_google_ads_googleads_v5_services_batch_job_service_proto_rawDescData
}

var file_google_ads_googleads_v5_services_batch_job_service_proto_msgTypes = make([]protoimpl.MessageInfo, 11)
var file_google_ads_googleads_v5_services_batch_job_service_proto_goTypes = []interface{}{
	(*MutateBatchJobRequest)(nil),         // 0: google.ads.googleads.v5.services.MutateBatchJobRequest
	(*BatchJobOperation)(nil),             // 1: google.ads.googleads.v5.services.BatchJobOperation
	(*MutateBatchJobResponse)(nil),        // 2: google.ads.googleads.v5.services.MutateBatchJobResponse
	(*MutateBatchJobResult)(nil),          // 3: google.ads.googleads.v5.services.MutateBatchJobResult
	(*GetBatchJobRequest)(nil),            // 4: google.ads.googleads.v5.services.GetBatchJobRequest
	(*RunBatchJobRequest)(nil),            // 5: google.ads.googleads.v5.services.RunBatchJobRequest
	(*AddBatchJobOperationsRequest)(nil),  // 6: google.ads.googleads.v5.services.AddBatchJobOperationsRequest
	(*AddBatchJobOperationsResponse)(nil), // 7: google.ads.googleads.v5.services.AddBatchJobOperationsResponse
	(*ListBatchJobResultsRequest)(nil),    // 8: google.ads.googleads.v5.services.ListBatchJobResultsRequest
	(*ListBatchJobResultsResponse)(nil),   // 9: google.ads.googleads.v5.services.ListBatchJobResultsResponse
	(*BatchJobResult)(nil),                // 10: google.ads.googleads.v5.services.BatchJobResult
	(*resources.BatchJob)(nil),            // 11: google.ads.googleads.v5.resources.BatchJob
	(*MutateOperation)(nil),               // 12: google.ads.googleads.v5.services.MutateOperation
	(*MutateOperationResponse)(nil),       // 13: google.ads.googleads.v5.services.MutateOperationResponse
	(*status.Status)(nil),                 // 14: google.rpc.Status
	(*longrunning.Operation)(nil),         // 15: google.longrunning.Operation
}
var file_google_ads_googleads_v5_services_batch_job_service_proto_depIdxs = []int32{
	1,  // 0: google.ads.googleads.v5.services.MutateBatchJobRequest.operation:type_name -> google.ads.googleads.v5.services.BatchJobOperation
	11, // 1: google.ads.googleads.v5.services.BatchJobOperation.create:type_name -> google.ads.googleads.v5.resources.BatchJob
	3,  // 2: google.ads.googleads.v5.services.MutateBatchJobResponse.result:type_name -> google.ads.googleads.v5.services.MutateBatchJobResult
	12, // 3: google.ads.googleads.v5.services.AddBatchJobOperationsRequest.mutate_operations:type_name -> google.ads.googleads.v5.services.MutateOperation
	10, // 4: google.ads.googleads.v5.services.ListBatchJobResultsResponse.results:type_name -> google.ads.googleads.v5.services.BatchJobResult
	13, // 5: google.ads.googleads.v5.services.BatchJobResult.mutate_operation_response:type_name -> google.ads.googleads.v5.services.MutateOperationResponse
	14, // 6: google.ads.googleads.v5.services.BatchJobResult.status:type_name -> google.rpc.Status
	0,  // 7: google.ads.googleads.v5.services.BatchJobService.MutateBatchJob:input_type -> google.ads.googleads.v5.services.MutateBatchJobRequest
	4,  // 8: google.ads.googleads.v5.services.BatchJobService.GetBatchJob:input_type -> google.ads.googleads.v5.services.GetBatchJobRequest
	8,  // 9: google.ads.googleads.v5.services.BatchJobService.ListBatchJobResults:input_type -> google.ads.googleads.v5.services.ListBatchJobResultsRequest
	5,  // 10: google.ads.googleads.v5.services.BatchJobService.RunBatchJob:input_type -> google.ads.googleads.v5.services.RunBatchJobRequest
	6,  // 11: google.ads.googleads.v5.services.BatchJobService.AddBatchJobOperations:input_type -> google.ads.googleads.v5.services.AddBatchJobOperationsRequest
	2,  // 12: google.ads.googleads.v5.services.BatchJobService.MutateBatchJob:output_type -> google.ads.googleads.v5.services.MutateBatchJobResponse
	11, // 13: google.ads.googleads.v5.services.BatchJobService.GetBatchJob:output_type -> google.ads.googleads.v5.resources.BatchJob
	9,  // 14: google.ads.googleads.v5.services.BatchJobService.ListBatchJobResults:output_type -> google.ads.googleads.v5.services.ListBatchJobResultsResponse
	15, // 15: google.ads.googleads.v5.services.BatchJobService.RunBatchJob:output_type -> google.longrunning.Operation
	7,  // 16: google.ads.googleads.v5.services.BatchJobService.AddBatchJobOperations:output_type -> google.ads.googleads.v5.services.AddBatchJobOperationsResponse
	12, // [12:17] is the sub-list for method output_type
	7,  // [7:12] is the sub-list for method input_type
	7,  // [7:7] is the sub-list for extension type_name
	7,  // [7:7] is the sub-list for extension extendee
	0,  // [0:7] is the sub-list for field type_name
}

func init() { file_google_ads_googleads_v5_services_batch_job_service_proto_init() }
func file_google_ads_googleads_v5_services_batch_job_service_proto_init() {
	if File_google_ads_googleads_v5_services_batch_job_service_proto != nil {
		return
	}
	file_google_ads_googleads_v5_services_google_ads_service_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_ads_googleads_v5_services_batch_job_service_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MutateBatchJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v5_services_batch_job_service_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchJobOperation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v5_services_batch_job_service_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MutateBatchJobResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v5_services_batch_job_service_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MutateBatchJobResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v5_services_batch_job_service_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetBatchJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v5_services_batch_job_service_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RunBatchJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v5_services_batch_job_service_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AddBatchJobOperationsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v5_services_batch_job_service_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AddBatchJobOperationsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v5_services_batch_job_service_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListBatchJobResultsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v5_services_batch_job_service_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListBatchJobResultsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v5_services_batch_job_service_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchJobResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_ads_googleads_v5_services_batch_job_service_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*BatchJobOperation_Create)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_ads_googleads_v5_services_batch_job_service_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   11,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_ads_googleads_v5_services_batch_job_service_proto_goTypes,
		DependencyIndexes: file_google_ads_googleads_v5_services_batch_job_service_proto_depIdxs,
		MessageInfos:      file_google_ads_googleads_v5_services_batch_job_service_proto_msgTypes,
	}.Build()
	File_google_ads_googleads_v5_services_batch_job_service_proto = out.File
	file_google_ads_googleads_v5_services_batch_job_service_proto_rawDesc = nil
	file_google_ads_googleads_v5_services_batch_job_service_proto_goTypes = nil
	file_google_ads_googleads_v5_services_batch_job_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// BatchJobServiceClient is the client API for BatchJobService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type BatchJobServiceClient interface {
	// Mutates a batch job.
	MutateBatchJob(ctx context.Context, in *MutateBatchJobRequest, opts ...grpc.CallOption) (*MutateBatchJobResponse, error)
	// Returns the batch job.
	GetBatchJob(ctx context.Context, in *GetBatchJobRequest, opts ...grpc.CallOption) (*resources.BatchJob, error)
	// Returns the results of the batch job. The job must be done.
	// Supports standard list paging.
	ListBatchJobResults(ctx context.Context, in *ListBatchJobResultsRequest, opts ...grpc.CallOption) (*ListBatchJobResultsResponse, error)
	// Runs the batch job.
	//
	// The Operation.metadata field type is BatchJobMetadata. When finished, the
	// long running operation will not contain errors or a response. Instead, use
	// ListBatchJobResults to get the results of the job.
	RunBatchJob(ctx context.Context, in *RunBatchJobRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Add operations to the batch job.
	AddBatchJobOperations(ctx context.Context, in *AddBatchJobOperationsRequest, opts ...grpc.CallOption) (*AddBatchJobOperationsResponse, error)
}

type batchJobServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewBatchJobServiceClient(cc grpc.ClientConnInterface) BatchJobServiceClient {
	return &batchJobServiceClient{cc}
}

func (c *batchJobServiceClient) MutateBatchJob(ctx context.Context, in *MutateBatchJobRequest, opts ...grpc.CallOption) (*MutateBatchJobResponse, error) {
	out := new(MutateBatchJobResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v5.services.BatchJobService/MutateBatchJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *batchJobServiceClient) GetBatchJob(ctx context.Context, in *GetBatchJobRequest, opts ...grpc.CallOption) (*resources.BatchJob, error) {
	out := new(resources.BatchJob)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v5.services.BatchJobService/GetBatchJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *batchJobServiceClient) ListBatchJobResults(ctx context.Context, in *ListBatchJobResultsRequest, opts ...grpc.CallOption) (*ListBatchJobResultsResponse, error) {
	out := new(ListBatchJobResultsResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v5.services.BatchJobService/ListBatchJobResults", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *batchJobServiceClient) RunBatchJob(ctx context.Context, in *RunBatchJobRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v5.services.BatchJobService/RunBatchJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *batchJobServiceClient) AddBatchJobOperations(ctx context.Context, in *AddBatchJobOperationsRequest, opts ...grpc.CallOption) (*AddBatchJobOperationsResponse, error) {
	out := new(AddBatchJobOperationsResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v5.services.BatchJobService/AddBatchJobOperations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// BatchJobServiceServer is the server API for BatchJobService service.
type BatchJobServiceServer interface {
	// Mutates a batch job.
	MutateBatchJob(context.Context, *MutateBatchJobRequest) (*MutateBatchJobResponse, error)
	// Returns the batch job.
	GetBatchJob(context.Context, *GetBatchJobRequest) (*resources.BatchJob, error)
	// Returns the results of the batch job. The job must be done.
	// Supports standard list paging.
	ListBatchJobResults(context.Context, *ListBatchJobResultsRequest) (*ListBatchJobResultsResponse, error)
	// Runs the batch job.
	//
	// The Operation.metadata field type is BatchJobMetadata. When finished, the
	// long running operation will not contain errors or a response. Instead, use
	// ListBatchJobResults to get the results of the job.
	RunBatchJob(context.Context, *RunBatchJobRequest) (*longrunning.Operation, error)
	// Add operations to the batch job.
	AddBatchJobOperations(context.Context, *AddBatchJobOperationsRequest) (*AddBatchJobOperationsResponse, error)
}

// UnimplementedBatchJobServiceServer can be embedded to have forward compatible implementations.
type UnimplementedBatchJobServiceServer struct {
}

func (*UnimplementedBatchJobServiceServer) MutateBatchJob(context.Context, *MutateBatchJobRequest) (*MutateBatchJobResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method MutateBatchJob not implemented")
}
func (*UnimplementedBatchJobServiceServer) GetBatchJob(context.Context, *GetBatchJobRequest) (*resources.BatchJob, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetBatchJob not implemented")
}
func (*UnimplementedBatchJobServiceServer) ListBatchJobResults(context.Context, *ListBatchJobResultsRequest) (*ListBatchJobResultsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListBatchJobResults not implemented")
}
func (*UnimplementedBatchJobServiceServer) RunBatchJob(context.Context, *RunBatchJobRequest) (*longrunning.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method RunBatchJob not implemented")
}
func (*UnimplementedBatchJobServiceServer) AddBatchJobOperations(context.Context, *AddBatchJobOperationsRequest) (*AddBatchJobOperationsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method AddBatchJobOperations not implemented")
}

func RegisterBatchJobServiceServer(s *grpc.Server, srv BatchJobServiceServer) {
	s.RegisterService(&_BatchJobService_serviceDesc, srv)
}

func _BatchJobService_MutateBatchJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MutateBatchJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BatchJobServiceServer).MutateBatchJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v5.services.BatchJobService/MutateBatchJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BatchJobServiceServer).MutateBatchJob(ctx, req.(*MutateBatchJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BatchJobService_GetBatchJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBatchJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BatchJobServiceServer).GetBatchJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v5.services.BatchJobService/GetBatchJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BatchJobServiceServer).GetBatchJob(ctx, req.(*GetBatchJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BatchJobService_ListBatchJobResults_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListBatchJobResultsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BatchJobServiceServer).ListBatchJobResults(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v5.services.BatchJobService/ListBatchJobResults",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BatchJobServiceServer).ListBatchJobResults(ctx, req.(*ListBatchJobResultsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BatchJobService_RunBatchJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RunBatchJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BatchJobServiceServer).RunBatchJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v5.services.BatchJobService/RunBatchJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BatchJobServiceServer).RunBatchJob(ctx, req.(*RunBatchJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BatchJobService_AddBatchJobOperations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddBatchJobOperationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BatchJobServiceServer).AddBatchJobOperations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v5.services.BatchJobService/AddBatchJobOperations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BatchJobServiceServer).AddBatchJobOperations(ctx, req.(*AddBatchJobOperationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _BatchJobService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.ads.googleads.v5.services.BatchJobService",
	HandlerType: (*BatchJobServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "MutateBatchJob",
			Handler:    _BatchJobService_MutateBatchJob_Handler,
		},
		{
			MethodName: "GetBatchJob",
			Handler:    _BatchJobService_GetBatchJob_Handler,
		},
		{
			MethodName: "ListBatchJobResults",
			Handler:    _BatchJobService_ListBatchJobResults_Handler,
		},
		{
			MethodName: "RunBatchJob",
			Handler:    _BatchJobService_RunBatchJob_Handler,
		},
		{
			MethodName: "AddBatchJobOperations",
			Handler:    _BatchJobService_AddBatchJobOperations_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/ads/googleads/v5/services/batch_job_service.proto",
}
