// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/openshift/cluster-kube-descheduler-operator/pkg/apis/descheduler/v1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// KubeDeschedulerLister helps list KubeDeschedulers.
// All objects returned here must be treated as read-only.
type KubeDeschedulerLister interface {
	// List lists all KubeDeschedulers in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.KubeDescheduler, err error)
	// KubeDeschedulers returns an object that can list and get KubeDeschedulers.
	KubeDeschedulers(namespace string) KubeDeschedulerNamespaceLister
	KubeDeschedulerListerExpansion
}

// kubeDeschedulerLister implements the KubeDeschedulerLister interface.
type kubeDeschedulerLister struct {
	indexer cache.Indexer
}

// NewKubeDeschedulerLister returns a new KubeDeschedulerLister.
func NewKubeDeschedulerLister(indexer cache.Indexer) KubeDeschedulerLister {
	return &kubeDeschedulerLister{indexer: indexer}
}

// List lists all KubeDeschedulers in the indexer.
func (s *kubeDeschedulerLister) List(selector labels.Selector) (ret []*v1.KubeDescheduler, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.KubeDescheduler))
	})
	return ret, err
}

// KubeDeschedulers returns an object that can list and get KubeDeschedulers.
func (s *kubeDeschedulerLister) KubeDeschedulers(namespace string) KubeDeschedulerNamespaceLister {
	return kubeDeschedulerNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// KubeDeschedulerNamespaceLister helps list and get KubeDeschedulers.
// All objects returned here must be treated as read-only.
type KubeDeschedulerNamespaceLister interface {
	// List lists all KubeDeschedulers in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.KubeDescheduler, err error)
	// Get retrieves the KubeDescheduler from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v1.KubeDescheduler, error)
	KubeDeschedulerNamespaceListerExpansion
}

// kubeDeschedulerNamespaceLister implements the KubeDeschedulerNamespaceLister
// interface.
type kubeDeschedulerNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all KubeDeschedulers in the indexer for a given namespace.
func (s kubeDeschedulerNamespaceLister) List(selector labels.Selector) (ret []*v1.KubeDescheduler, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.KubeDescheduler))
	})
	return ret, err
}

// Get retrieves the KubeDescheduler from the indexer for a given namespace and name.
func (s kubeDeschedulerNamespaceLister) Get(name string) (*v1.KubeDescheduler, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1.Resource("kubedescheduler"), name)
	}
	return obj.(*v1.KubeDescheduler), nil
}
