package customerlockbox

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// Decision enumerates the values for decision.
type Decision string

const (
	// Approve ...
	Approve Decision = "Approve"
	// Deny ...
	Deny Decision = "Deny"
)

// PossibleDecisionValues returns an array of possible values for the Decision const type.
func PossibleDecisionValues() []Decision {
	return []Decision{Approve, Deny}
}

// Status enumerates the values for status.
type Status string

const (
	// Approved ...
	Approved Status = "Approved"
	// Approving ...
	Approving Status = "Approving"
	// Completed ...
	Completed Status = "Completed"
	// Completing ...
	Completing Status = "Completing"
	// Denied ...
	Denied Status = "Denied"
	// Denying ...
	Denying Status = "Denying"
	// Error ...
	Error Status = "Error"
	// Expired ...
	Expired Status = "Expired"
	// Initializing ...
	Initializing Status = "Initializing"
	// Pending ...
	Pending Status = "Pending"
	// Revoked ...
	Revoked Status = "Revoked"
	// Revoking ...
	Revoking Status = "Revoking"
	// Unknown ...
	Unknown Status = "Unknown"
)

// PossibleStatusValues returns an array of possible values for the Status const type.
func PossibleStatusValues() []Status {
	return []Status{Approved, Approving, Completed, Completing, Denied, Denying, Error, Expired, Initializing, Pending, Revoked, Revoking, Unknown}
}
