// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package networkmanager

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DeleteDeviceInput struct {
	_ struct{} `type:"structure"`

	// The ID of the device.
	//
	// DeviceId is a required field
	DeviceId *string `location:"uri" locationName:"deviceId" type:"string" required:"true"`

	// The ID of the global network.
	//
	// GlobalNetworkId is a required field
	GlobalNetworkId *string `location:"uri" locationName:"globalNetworkId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDeviceInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDeviceInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteDeviceInput"}

	if s.DeviceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DeviceId"))
	}

	if s.GlobalNetworkId == nil {
		invalidParams.Add(aws.NewErrParamRequired("GlobalNetworkId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteDeviceInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.DeviceId != nil {
		v := *s.DeviceId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "deviceId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.GlobalNetworkId != nil {
		v := *s.GlobalNetworkId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "globalNetworkId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeleteDeviceOutput struct {
	_ struct{} `type:"structure"`

	// Information about the device.
	Device *Device `type:"structure"`
}

// String returns the string representation
func (s DeleteDeviceOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteDeviceOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Device != nil {
		v := s.Device

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Device", v, metadata)
	}
	return nil
}

const opDeleteDevice = "DeleteDevice"

// DeleteDeviceRequest returns a request value for making API operation for
// AWS Network Manager.
//
// Deletes an existing device. You must first disassociate the device from any
// links and customer gateways.
//
//    // Example sending a request using DeleteDeviceRequest.
//    req := client.DeleteDeviceRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/DeleteDevice
func (c *Client) DeleteDeviceRequest(input *DeleteDeviceInput) DeleteDeviceRequest {
	op := &aws.Operation{
		Name:       opDeleteDevice,
		HTTPMethod: "DELETE",
		HTTPPath:   "/global-networks/{globalNetworkId}/devices/{deviceId}",
	}

	if input == nil {
		input = &DeleteDeviceInput{}
	}

	req := c.newRequest(op, input, &DeleteDeviceOutput{})
	return DeleteDeviceRequest{Request: req, Input: input, Copy: c.DeleteDeviceRequest}
}

// DeleteDeviceRequest is the request type for the
// DeleteDevice API operation.
type DeleteDeviceRequest struct {
	*aws.Request
	Input *DeleteDeviceInput
	Copy  func(*DeleteDeviceInput) DeleteDeviceRequest
}

// Send marshals and sends the DeleteDevice API request.
func (r DeleteDeviceRequest) Send(ctx context.Context) (*DeleteDeviceResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteDeviceResponse{
		DeleteDeviceOutput: r.Request.Data.(*DeleteDeviceOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteDeviceResponse is the response type for the
// DeleteDevice API operation.
type DeleteDeviceResponse struct {
	*DeleteDeviceOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteDevice request.
func (r *DeleteDeviceResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
