// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/gkehub/v1alpha/configmanagement/configmanagement.proto

package configmanagement

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Enum representing the state of an ACM's deployment on a cluster
type DeploymentState int32

const (
	// Deployment's state cannot be determined
	DeploymentState_DEPLOYMENT_STATE_UNSPECIFIED DeploymentState = 0
	// Deployment is not installed
	DeploymentState_NOT_INSTALLED DeploymentState = 1
	// Deployment is installed
	DeploymentState_INSTALLED DeploymentState = 2
	// Deployment was attempted to be installed, but has errors
	DeploymentState_ERROR DeploymentState = 3
)

// Enum value maps for DeploymentState.
var (
	DeploymentState_name = map[int32]string{
		0: "DEPLOYMENT_STATE_UNSPECIFIED",
		1: "NOT_INSTALLED",
		2: "INSTALLED",
		3: "ERROR",
	}
	DeploymentState_value = map[string]int32{
		"DEPLOYMENT_STATE_UNSPECIFIED": 0,
		"NOT_INSTALLED":                1,
		"INSTALLED":                    2,
		"ERROR":                        3,
	}
)

func (x DeploymentState) Enum() *DeploymentState {
	p := new(DeploymentState)
	*p = x
	return p
}

func (x DeploymentState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DeploymentState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_enumTypes[0].Descriptor()
}

func (DeploymentState) Type() protoreflect.EnumType {
	return &file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_enumTypes[0]
}

func (x DeploymentState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DeploymentState.Descriptor instead.
func (DeploymentState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_rawDescGZIP(), []int{0}
}

// An enum representing an ACM's status syncing configs to a cluster
type SyncState_SyncCode int32

const (
	// ACM cannot determine a sync code
	SyncState_SYNC_CODE_UNSPECIFIED SyncState_SyncCode = 0
	// ACM successfully synced the git Repo with the cluster
	SyncState_SYNCED SyncState_SyncCode = 1
	// ACM is in the progress of syncing a new change
	SyncState_PENDING SyncState_SyncCode = 2
	// Indicates an error configuring ACM, and user action is required
	SyncState_ERROR SyncState_SyncCode = 3
	// ACM has been installed (operator manifest deployed),
	// but not configured.
	SyncState_NOT_CONFIGURED SyncState_SyncCode = 4
	// ACM has not been installed (no operator pod found)
	SyncState_NOT_INSTALLED SyncState_SyncCode = 5
	// Error authorizing with the cluster
	SyncState_UNAUTHORIZED SyncState_SyncCode = 6
	// Cluster could not be reached
	SyncState_UNREACHABLE SyncState_SyncCode = 7
)

// Enum value maps for SyncState_SyncCode.
var (
	SyncState_SyncCode_name = map[int32]string{
		0: "SYNC_CODE_UNSPECIFIED",
		1: "SYNCED",
		2: "PENDING",
		3: "ERROR",
		4: "NOT_CONFIGURED",
		5: "NOT_INSTALLED",
		6: "UNAUTHORIZED",
		7: "UNREACHABLE",
	}
	SyncState_SyncCode_value = map[string]int32{
		"SYNC_CODE_UNSPECIFIED": 0,
		"SYNCED":                1,
		"PENDING":               2,
		"ERROR":                 3,
		"NOT_CONFIGURED":        4,
		"NOT_INSTALLED":         5,
		"UNAUTHORIZED":          6,
		"UNREACHABLE":           7,
	}
)

func (x SyncState_SyncCode) Enum() *SyncState_SyncCode {
	p := new(SyncState_SyncCode)
	*p = x
	return p
}

func (x SyncState_SyncCode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SyncState_SyncCode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_enumTypes[1].Descriptor()
}

func (SyncState_SyncCode) Type() protoreflect.EnumType {
	return &file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_enumTypes[1]
}

func (x SyncState_SyncCode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SyncState_SyncCode.Descriptor instead.
func (SyncState_SyncCode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_rawDescGZIP(), []int{15, 0}
}

// **Anthos Config Management**: State for a single cluster.
type MembershipState struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The user-defined name for the cluster used by ClusterSelectors to group
	// clusters together. This should match Membership's membership_name,
	// unless the user installed ACM on the cluster manually prior to enabling
	// the ACM hub feature.
	// Unique within a Anthos Config Management installation.
	ClusterName string `protobuf:"bytes,1,opt,name=cluster_name,json=clusterName,proto3" json:"cluster_name,omitempty"`
	// Membership configuration in the cluster. This represents the actual state
	// in the cluster, while the MembershipSpec in the FeatureSpec represents
	// the intended state
	MembershipSpec *MembershipSpec `protobuf:"bytes,2,opt,name=membership_spec,json=membershipSpec,proto3" json:"membership_spec,omitempty"`
	// Current install status of ACM's Operator
	OperatorState *OperatorState `protobuf:"bytes,3,opt,name=operator_state,json=operatorState,proto3" json:"operator_state,omitempty"`
	// Current sync status
	ConfigSyncState *ConfigSyncState `protobuf:"bytes,4,opt,name=config_sync_state,json=configSyncState,proto3" json:"config_sync_state,omitempty"`
	// PolicyController status
	PolicyControllerState *PolicyControllerState `protobuf:"bytes,5,opt,name=policy_controller_state,json=policyControllerState,proto3" json:"policy_controller_state,omitempty"`
	// Binauthz status
	BinauthzState *BinauthzState `protobuf:"bytes,6,opt,name=binauthz_state,json=binauthzState,proto3" json:"binauthz_state,omitempty"`
	// Hierarchy Controller status
	HierarchyControllerState *HierarchyControllerState `protobuf:"bytes,7,opt,name=hierarchy_controller_state,json=hierarchyControllerState,proto3" json:"hierarchy_controller_state,omitempty"`
}

func (x *MembershipState) Reset() {
	*x = MembershipState{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MembershipState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MembershipState) ProtoMessage() {}

func (x *MembershipState) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MembershipState.ProtoReflect.Descriptor instead.
func (*MembershipState) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_rawDescGZIP(), []int{0}
}

func (x *MembershipState) GetClusterName() string {
	if x != nil {
		return x.ClusterName
	}
	return ""
}

func (x *MembershipState) GetMembershipSpec() *MembershipSpec {
	if x != nil {
		return x.MembershipSpec
	}
	return nil
}

func (x *MembershipState) GetOperatorState() *OperatorState {
	if x != nil {
		return x.OperatorState
	}
	return nil
}

func (x *MembershipState) GetConfigSyncState() *ConfigSyncState {
	if x != nil {
		return x.ConfigSyncState
	}
	return nil
}

func (x *MembershipState) GetPolicyControllerState() *PolicyControllerState {
	if x != nil {
		return x.PolicyControllerState
	}
	return nil
}

func (x *MembershipState) GetBinauthzState() *BinauthzState {
	if x != nil {
		return x.BinauthzState
	}
	return nil
}

func (x *MembershipState) GetHierarchyControllerState() *HierarchyControllerState {
	if x != nil {
		return x.HierarchyControllerState
	}
	return nil
}

// **Anthos Config Management**: Configuration for a single cluster.
// Intended to parallel the ConfigManagement CR.
type MembershipSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Config Sync configuration for the cluster.
	ConfigSync *ConfigSync `protobuf:"bytes,1,opt,name=config_sync,json=configSync,proto3" json:"config_sync,omitempty"`
	// Policy Controller configuration for the cluster.
	PolicyController *PolicyController `protobuf:"bytes,2,opt,name=policy_controller,json=policyController,proto3" json:"policy_controller,omitempty"`
	// Binauthz conifguration for the cluster.
	Binauthz *BinauthzConfig `protobuf:"bytes,3,opt,name=binauthz,proto3" json:"binauthz,omitempty"`
	// Hierarchy Controller configuration for the cluster.
	HierarchyController *HierarchyControllerConfig `protobuf:"bytes,4,opt,name=hierarchy_controller,json=hierarchyController,proto3" json:"hierarchy_controller,omitempty"`
	// Version of ACM installed.
	Version string `protobuf:"bytes,10,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *MembershipSpec) Reset() {
	*x = MembershipSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MembershipSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MembershipSpec) ProtoMessage() {}

func (x *MembershipSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MembershipSpec.ProtoReflect.Descriptor instead.
func (*MembershipSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_rawDescGZIP(), []int{1}
}

func (x *MembershipSpec) GetConfigSync() *ConfigSync {
	if x != nil {
		return x.ConfigSync
	}
	return nil
}

func (x *MembershipSpec) GetPolicyController() *PolicyController {
	if x != nil {
		return x.PolicyController
	}
	return nil
}

func (x *MembershipSpec) GetBinauthz() *BinauthzConfig {
	if x != nil {
		return x.Binauthz
	}
	return nil
}

func (x *MembershipSpec) GetHierarchyController() *HierarchyControllerConfig {
	if x != nil {
		return x.HierarchyController
	}
	return nil
}

func (x *MembershipSpec) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

// Configuration for Config Sync
type ConfigSync struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Git repo configuration for the cluster.
	Git *GitConfig `protobuf:"bytes,7,opt,name=git,proto3" json:"git,omitempty"`
	// Specifies whether the Config Sync Repo is
	// in “hierarchical” or “unstructured” mode.
	SourceFormat string `protobuf:"bytes,8,opt,name=source_format,json=sourceFormat,proto3" json:"source_format,omitempty"`
}

func (x *ConfigSync) Reset() {
	*x = ConfigSync{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConfigSync) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConfigSync) ProtoMessage() {}

func (x *ConfigSync) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConfigSync.ProtoReflect.Descriptor instead.
func (*ConfigSync) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_rawDescGZIP(), []int{2}
}

func (x *ConfigSync) GetGit() *GitConfig {
	if x != nil {
		return x.Git
	}
	return nil
}

func (x *ConfigSync) GetSourceFormat() string {
	if x != nil {
		return x.SourceFormat
	}
	return ""
}

// Git repo configuration for a single cluster.
type GitConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The URL of the Git repository to use as the source of truth.
	SyncRepo string `protobuf:"bytes,1,opt,name=sync_repo,json=syncRepo,proto3" json:"sync_repo,omitempty"`
	// The branch of the repository to sync from. Default: master.
	SyncBranch string `protobuf:"bytes,2,opt,name=sync_branch,json=syncBranch,proto3" json:"sync_branch,omitempty"`
	// The path within the Git repository that represents the top level of the
	// repo to sync. Default: the root directory of the repository.
	PolicyDir string `protobuf:"bytes,3,opt,name=policy_dir,json=policyDir,proto3" json:"policy_dir,omitempty"`
	// Period in seconds between consecutive syncs. Default: 15.
	SyncWaitSecs int64 `protobuf:"varint,4,opt,name=sync_wait_secs,json=syncWaitSecs,proto3" json:"sync_wait_secs,omitempty"`
	// Git revision (tag or hash) to check out. Default HEAD.
	SyncRev string `protobuf:"bytes,5,opt,name=sync_rev,json=syncRev,proto3" json:"sync_rev,omitempty"`
	// Type of secret configured for access to the Git repo.
	SecretType string `protobuf:"bytes,6,opt,name=secret_type,json=secretType,proto3" json:"secret_type,omitempty"`
	// URL for the HTTPS proxy to be used when communicating with the Git repo.
	HttpsProxy string `protobuf:"bytes,7,opt,name=https_proxy,json=httpsProxy,proto3" json:"https_proxy,omitempty"`
	// The GCP Service Account Email used for auth when secret_type is
	// gcpServiceAccount.
	GcpServiceAccountEmail string `protobuf:"bytes,8,opt,name=gcp_service_account_email,json=gcpServiceAccountEmail,proto3" json:"gcp_service_account_email,omitempty"`
}

func (x *GitConfig) Reset() {
	*x = GitConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GitConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GitConfig) ProtoMessage() {}

func (x *GitConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GitConfig.ProtoReflect.Descriptor instead.
func (*GitConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_rawDescGZIP(), []int{3}
}

func (x *GitConfig) GetSyncRepo() string {
	if x != nil {
		return x.SyncRepo
	}
	return ""
}

func (x *GitConfig) GetSyncBranch() string {
	if x != nil {
		return x.SyncBranch
	}
	return ""
}

func (x *GitConfig) GetPolicyDir() string {
	if x != nil {
		return x.PolicyDir
	}
	return ""
}

func (x *GitConfig) GetSyncWaitSecs() int64 {
	if x != nil {
		return x.SyncWaitSecs
	}
	return 0
}

func (x *GitConfig) GetSyncRev() string {
	if x != nil {
		return x.SyncRev
	}
	return ""
}

func (x *GitConfig) GetSecretType() string {
	if x != nil {
		return x.SecretType
	}
	return ""
}

func (x *GitConfig) GetHttpsProxy() string {
	if x != nil {
		return x.HttpsProxy
	}
	return ""
}

func (x *GitConfig) GetGcpServiceAccountEmail() string {
	if x != nil {
		return x.GcpServiceAccountEmail
	}
	return ""
}

// Configuration for Policy Controller
type PolicyController struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Enables the installation of Policy Controller.
	// If false, the rest of PolicyController fields take no
	// effect.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Installs the default template library along with Policy Controller.
	TemplateLibraryInstalled *bool `protobuf:"varint,2,opt,name=template_library_installed,json=templateLibraryInstalled,proto3,oneof" json:"template_library_installed,omitempty"`
	// Sets the interval for Policy Controller Audit Scans (in seconds).
	// When set to 0, this disables audit functionality altogether.
	AuditIntervalSeconds *int64 `protobuf:"varint,3,opt,name=audit_interval_seconds,json=auditIntervalSeconds,proto3,oneof" json:"audit_interval_seconds,omitempty"`
	// The set of namespaces that are excluded from Policy Controller checks.
	// Namespaces do not need to currently exist on the cluster.
	ExemptableNamespaces []string `protobuf:"bytes,4,rep,name=exemptable_namespaces,json=exemptableNamespaces,proto3" json:"exemptable_namespaces,omitempty"`
	// Enables the ability to use Constraint Templates that reference to objects
	// other than the object currently being evaluated.
	ReferentialRulesEnabled bool `protobuf:"varint,5,opt,name=referential_rules_enabled,json=referentialRulesEnabled,proto3" json:"referential_rules_enabled,omitempty"`
	// Logs all denies and dry run failures.
	LogDeniesEnabled bool `protobuf:"varint,6,opt,name=log_denies_enabled,json=logDeniesEnabled,proto3" json:"log_denies_enabled,omitempty"`
	// Enable users to try out mutation for PolicyController.
	MutationEnabled bool `protobuf:"varint,7,opt,name=mutation_enabled,json=mutationEnabled,proto3" json:"mutation_enabled,omitempty"`
}

func (x *PolicyController) Reset() {
	*x = PolicyController{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PolicyController) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PolicyController) ProtoMessage() {}

func (x *PolicyController) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PolicyController.ProtoReflect.Descriptor instead.
func (*PolicyController) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_rawDescGZIP(), []int{4}
}

func (x *PolicyController) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *PolicyController) GetTemplateLibraryInstalled() bool {
	if x != nil && x.TemplateLibraryInstalled != nil {
		return *x.TemplateLibraryInstalled
	}
	return false
}

func (x *PolicyController) GetAuditIntervalSeconds() int64 {
	if x != nil && x.AuditIntervalSeconds != nil {
		return *x.AuditIntervalSeconds
	}
	return 0
}

func (x *PolicyController) GetExemptableNamespaces() []string {
	if x != nil {
		return x.ExemptableNamespaces
	}
	return nil
}

func (x *PolicyController) GetReferentialRulesEnabled() bool {
	if x != nil {
		return x.ReferentialRulesEnabled
	}
	return false
}

func (x *PolicyController) GetLogDeniesEnabled() bool {
	if x != nil {
		return x.LogDeniesEnabled
	}
	return false
}

func (x *PolicyController) GetMutationEnabled() bool {
	if x != nil {
		return x.MutationEnabled
	}
	return false
}

// Configuration for Binauthz
type BinauthzConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether binauthz is enabled in this cluster.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
}

func (x *BinauthzConfig) Reset() {
	*x = BinauthzConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BinauthzConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BinauthzConfig) ProtoMessage() {}

func (x *BinauthzConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BinauthzConfig.ProtoReflect.Descriptor instead.
func (*BinauthzConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_rawDescGZIP(), []int{5}
}

func (x *BinauthzConfig) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

// Configuration for Hierarchy Controller
type HierarchyControllerConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether Hierarchy Controller is enabled in this cluster.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Whether pod tree labels are enabled in this cluster.
	EnablePodTreeLabels bool `protobuf:"varint,2,opt,name=enable_pod_tree_labels,json=enablePodTreeLabels,proto3" json:"enable_pod_tree_labels,omitempty"`
	// Whether hierarchical resource quota is enabled in this cluster.
	EnableHierarchicalResourceQuota bool `protobuf:"varint,3,opt,name=enable_hierarchical_resource_quota,json=enableHierarchicalResourceQuota,proto3" json:"enable_hierarchical_resource_quota,omitempty"`
}

func (x *HierarchyControllerConfig) Reset() {
	*x = HierarchyControllerConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HierarchyControllerConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HierarchyControllerConfig) ProtoMessage() {}

func (x *HierarchyControllerConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HierarchyControllerConfig.ProtoReflect.Descriptor instead.
func (*HierarchyControllerConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_rawDescGZIP(), []int{6}
}

func (x *HierarchyControllerConfig) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *HierarchyControllerConfig) GetEnablePodTreeLabels() bool {
	if x != nil {
		return x.EnablePodTreeLabels
	}
	return false
}

func (x *HierarchyControllerConfig) GetEnableHierarchicalResourceQuota() bool {
	if x != nil {
		return x.EnableHierarchicalResourceQuota
	}
	return false
}

// Deployment state for Hierarchy Controller
type HierarchyControllerDeploymentState struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The deployment state for open source HNC (e.g. v0.7.0-hc.0)
	Hnc DeploymentState `protobuf:"varint,1,opt,name=hnc,proto3,enum=google.cloud.gkehub.configmanagement.v1alpha.DeploymentState" json:"hnc,omitempty"`
	// The deployment state for Hierarchy Controller extension (e.g. v0.7.0-hc.1)
	Extension DeploymentState `protobuf:"varint,2,opt,name=extension,proto3,enum=google.cloud.gkehub.configmanagement.v1alpha.DeploymentState" json:"extension,omitempty"`
}

func (x *HierarchyControllerDeploymentState) Reset() {
	*x = HierarchyControllerDeploymentState{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HierarchyControllerDeploymentState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HierarchyControllerDeploymentState) ProtoMessage() {}

func (x *HierarchyControllerDeploymentState) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HierarchyControllerDeploymentState.ProtoReflect.Descriptor instead.
func (*HierarchyControllerDeploymentState) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_rawDescGZIP(), []int{7}
}

func (x *HierarchyControllerDeploymentState) GetHnc() DeploymentState {
	if x != nil {
		return x.Hnc
	}
	return DeploymentState_DEPLOYMENT_STATE_UNSPECIFIED
}

func (x *HierarchyControllerDeploymentState) GetExtension() DeploymentState {
	if x != nil {
		return x.Extension
	}
	return DeploymentState_DEPLOYMENT_STATE_UNSPECIFIED
}

// Version for Hierarchy Controller
type HierarchyControllerVersion struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Version for open source HNC
	Hnc string `protobuf:"bytes,1,opt,name=hnc,proto3" json:"hnc,omitempty"`
	// Version for Hierarchy Controller extension
	Extension string `protobuf:"bytes,2,opt,name=extension,proto3" json:"extension,omitempty"`
}

func (x *HierarchyControllerVersion) Reset() {
	*x = HierarchyControllerVersion{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HierarchyControllerVersion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HierarchyControllerVersion) ProtoMessage() {}

func (x *HierarchyControllerVersion) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HierarchyControllerVersion.ProtoReflect.Descriptor instead.
func (*HierarchyControllerVersion) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_rawDescGZIP(), []int{8}
}

func (x *HierarchyControllerVersion) GetHnc() string {
	if x != nil {
		return x.Hnc
	}
	return ""
}

func (x *HierarchyControllerVersion) GetExtension() string {
	if x != nil {
		return x.Extension
	}
	return ""
}

// State for Hierarchy Controller
type HierarchyControllerState struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The version for Hierarchy Controller
	Version *HierarchyControllerVersion `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	// The deployment state for Hierarchy Controller
	State *HierarchyControllerDeploymentState `protobuf:"bytes,2,opt,name=state,proto3" json:"state,omitempty"`
}

func (x *HierarchyControllerState) Reset() {
	*x = HierarchyControllerState{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HierarchyControllerState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HierarchyControllerState) ProtoMessage() {}

func (x *HierarchyControllerState) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HierarchyControllerState.ProtoReflect.Descriptor instead.
func (*HierarchyControllerState) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_rawDescGZIP(), []int{9}
}

func (x *HierarchyControllerState) GetVersion() *HierarchyControllerVersion {
	if x != nil {
		return x.Version
	}
	return nil
}

func (x *HierarchyControllerState) GetState() *HierarchyControllerDeploymentState {
	if x != nil {
		return x.State
	}
	return nil
}

// State information for an ACM's Operator
type OperatorState struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The semenatic version number of the operator
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	// The state of the Operator's deployment
	DeploymentState DeploymentState `protobuf:"varint,2,opt,name=deployment_state,json=deploymentState,proto3,enum=google.cloud.gkehub.configmanagement.v1alpha.DeploymentState" json:"deployment_state,omitempty"`
	// Install errors.
	Errors []*InstallError `protobuf:"bytes,3,rep,name=errors,proto3" json:"errors,omitempty"`
}

func (x *OperatorState) Reset() {
	*x = OperatorState{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OperatorState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OperatorState) ProtoMessage() {}

func (x *OperatorState) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OperatorState.ProtoReflect.Descriptor instead.
func (*OperatorState) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_rawDescGZIP(), []int{10}
}

func (x *OperatorState) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *OperatorState) GetDeploymentState() DeploymentState {
	if x != nil {
		return x.DeploymentState
	}
	return DeploymentState_DEPLOYMENT_STATE_UNSPECIFIED
}

func (x *OperatorState) GetErrors() []*InstallError {
	if x != nil {
		return x.Errors
	}
	return nil
}

// Errors pertaining to the installation of ACM
type InstallError struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A string representing the user facing error message
	ErrorMessage string `protobuf:"bytes,1,opt,name=error_message,json=errorMessage,proto3" json:"error_message,omitempty"`
}

func (x *InstallError) Reset() {
	*x = InstallError{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InstallError) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InstallError) ProtoMessage() {}

func (x *InstallError) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InstallError.ProtoReflect.Descriptor instead.
func (*InstallError) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_rawDescGZIP(), []int{11}
}

func (x *InstallError) GetErrorMessage() string {
	if x != nil {
		return x.ErrorMessage
	}
	return ""
}

// State information for ConfigSync
type ConfigSyncState struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The version of ConfigSync deployed
	Version *ConfigSyncVersion `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	// Information about the deployment of ConfigSync, including the version
	// of the various Pods deployed
	DeploymentState *ConfigSyncDeploymentState `protobuf:"bytes,2,opt,name=deployment_state,json=deploymentState,proto3" json:"deployment_state,omitempty"`
	// The state of ConfigSync's process to sync configs to a cluster
	SyncState *SyncState `protobuf:"bytes,3,opt,name=sync_state,json=syncState,proto3" json:"sync_state,omitempty"`
}

func (x *ConfigSyncState) Reset() {
	*x = ConfigSyncState{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConfigSyncState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConfigSyncState) ProtoMessage() {}

func (x *ConfigSyncState) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConfigSyncState.ProtoReflect.Descriptor instead.
func (*ConfigSyncState) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_rawDescGZIP(), []int{12}
}

func (x *ConfigSyncState) GetVersion() *ConfigSyncVersion {
	if x != nil {
		return x.Version
	}
	return nil
}

func (x *ConfigSyncState) GetDeploymentState() *ConfigSyncDeploymentState {
	if x != nil {
		return x.DeploymentState
	}
	return nil
}

func (x *ConfigSyncState) GetSyncState() *SyncState {
	if x != nil {
		return x.SyncState
	}
	return nil
}

// Specific versioning information pertaining to ConfigSync's Pods
type ConfigSyncVersion struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Version of the deployed importer pod
	Importer string `protobuf:"bytes,1,opt,name=importer,proto3" json:"importer,omitempty"`
	// Version of the deployed syncer pod
	Syncer string `protobuf:"bytes,2,opt,name=syncer,proto3" json:"syncer,omitempty"`
	// Version of the deployed git-sync pod
	GitSync string `protobuf:"bytes,3,opt,name=git_sync,json=gitSync,proto3" json:"git_sync,omitempty"`
	// Version of the deployed monitor pod
	Monitor string `protobuf:"bytes,4,opt,name=monitor,proto3" json:"monitor,omitempty"`
	// Version of the deployed reconciler-manager pod
	ReconcilerManager string `protobuf:"bytes,5,opt,name=reconciler_manager,json=reconcilerManager,proto3" json:"reconciler_manager,omitempty"`
	// Version of the deployed reconciler container in root-reconciler pod
	RootReconciler string `protobuf:"bytes,6,opt,name=root_reconciler,json=rootReconciler,proto3" json:"root_reconciler,omitempty"`
}

func (x *ConfigSyncVersion) Reset() {
	*x = ConfigSyncVersion{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConfigSyncVersion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConfigSyncVersion) ProtoMessage() {}

func (x *ConfigSyncVersion) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConfigSyncVersion.ProtoReflect.Descriptor instead.
func (*ConfigSyncVersion) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_rawDescGZIP(), []int{13}
}

func (x *ConfigSyncVersion) GetImporter() string {
	if x != nil {
		return x.Importer
	}
	return ""
}

func (x *ConfigSyncVersion) GetSyncer() string {
	if x != nil {
		return x.Syncer
	}
	return ""
}

func (x *ConfigSyncVersion) GetGitSync() string {
	if x != nil {
		return x.GitSync
	}
	return ""
}

func (x *ConfigSyncVersion) GetMonitor() string {
	if x != nil {
		return x.Monitor
	}
	return ""
}

func (x *ConfigSyncVersion) GetReconcilerManager() string {
	if x != nil {
		return x.ReconcilerManager
	}
	return ""
}

func (x *ConfigSyncVersion) GetRootReconciler() string {
	if x != nil {
		return x.RootReconciler
	}
	return ""
}

// The state of ConfigSync's deployment on a cluster
type ConfigSyncDeploymentState struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Deployment state of the importer pod
	Importer DeploymentState `protobuf:"varint,1,opt,name=importer,proto3,enum=google.cloud.gkehub.configmanagement.v1alpha.DeploymentState" json:"importer,omitempty"`
	// Deployment state of the syncer pod
	Syncer DeploymentState `protobuf:"varint,2,opt,name=syncer,proto3,enum=google.cloud.gkehub.configmanagement.v1alpha.DeploymentState" json:"syncer,omitempty"`
	// Deployment state of the git-sync pod
	GitSync DeploymentState `protobuf:"varint,3,opt,name=git_sync,json=gitSync,proto3,enum=google.cloud.gkehub.configmanagement.v1alpha.DeploymentState" json:"git_sync,omitempty"`
	// Deployment state of the monitor pod
	Monitor DeploymentState `protobuf:"varint,4,opt,name=monitor,proto3,enum=google.cloud.gkehub.configmanagement.v1alpha.DeploymentState" json:"monitor,omitempty"`
	// Deployment state of reconciler-manager pod
	ReconcilerManager DeploymentState `protobuf:"varint,5,opt,name=reconciler_manager,json=reconcilerManager,proto3,enum=google.cloud.gkehub.configmanagement.v1alpha.DeploymentState" json:"reconciler_manager,omitempty"`
	// Deployment state of root-reconciler
	RootReconciler DeploymentState `protobuf:"varint,6,opt,name=root_reconciler,json=rootReconciler,proto3,enum=google.cloud.gkehub.configmanagement.v1alpha.DeploymentState" json:"root_reconciler,omitempty"`
}

func (x *ConfigSyncDeploymentState) Reset() {
	*x = ConfigSyncDeploymentState{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConfigSyncDeploymentState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConfigSyncDeploymentState) ProtoMessage() {}

func (x *ConfigSyncDeploymentState) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConfigSyncDeploymentState.ProtoReflect.Descriptor instead.
func (*ConfigSyncDeploymentState) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_rawDescGZIP(), []int{14}
}

func (x *ConfigSyncDeploymentState) GetImporter() DeploymentState {
	if x != nil {
		return x.Importer
	}
	return DeploymentState_DEPLOYMENT_STATE_UNSPECIFIED
}

func (x *ConfigSyncDeploymentState) GetSyncer() DeploymentState {
	if x != nil {
		return x.Syncer
	}
	return DeploymentState_DEPLOYMENT_STATE_UNSPECIFIED
}

func (x *ConfigSyncDeploymentState) GetGitSync() DeploymentState {
	if x != nil {
		return x.GitSync
	}
	return DeploymentState_DEPLOYMENT_STATE_UNSPECIFIED
}

func (x *ConfigSyncDeploymentState) GetMonitor() DeploymentState {
	if x != nil {
		return x.Monitor
	}
	return DeploymentState_DEPLOYMENT_STATE_UNSPECIFIED
}

func (x *ConfigSyncDeploymentState) GetReconcilerManager() DeploymentState {
	if x != nil {
		return x.ReconcilerManager
	}
	return DeploymentState_DEPLOYMENT_STATE_UNSPECIFIED
}

func (x *ConfigSyncDeploymentState) GetRootReconciler() DeploymentState {
	if x != nil {
		return x.RootReconciler
	}
	return DeploymentState_DEPLOYMENT_STATE_UNSPECIFIED
}

// State indicating an ACM's progress syncing configurations to a cluster
type SyncState struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Token indicating the state of the repo.
	SourceToken string `protobuf:"bytes,1,opt,name=source_token,json=sourceToken,proto3" json:"source_token,omitempty"`
	// Token indicating the state of the importer.
	ImportToken string `protobuf:"bytes,2,opt,name=import_token,json=importToken,proto3" json:"import_token,omitempty"`
	// Token indicating the state of the syncer.
	SyncToken string `protobuf:"bytes,3,opt,name=sync_token,json=syncToken,proto3" json:"sync_token,omitempty"`
	// Deprecated: use last_sync_time instead.
	// Timestamp of when ACM last successfully synced the repo
	// The time format is specified in https://golang.org/pkg/time/#Time.String
	//
	// Deprecated: Do not use.
	LastSync string `protobuf:"bytes,4,opt,name=last_sync,json=lastSync,proto3" json:"last_sync,omitempty"`
	// Timestamp type of when ACM last successfully synced the repo
	LastSyncTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=last_sync_time,json=lastSyncTime,proto3" json:"last_sync_time,omitempty"`
	// Sync status code
	Code SyncState_SyncCode `protobuf:"varint,5,opt,name=code,proto3,enum=google.cloud.gkehub.configmanagement.v1alpha.SyncState_SyncCode" json:"code,omitempty"`
	// A list of errors resulting from problematic configs.
	// This list will be truncated after 100 errors, although it is
	// unlikely for that many errors to simultaneously exist.
	Errors []*SyncError `protobuf:"bytes,6,rep,name=errors,proto3" json:"errors,omitempty"`
}

func (x *SyncState) Reset() {
	*x = SyncState{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SyncState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SyncState) ProtoMessage() {}

func (x *SyncState) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SyncState.ProtoReflect.Descriptor instead.
func (*SyncState) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_rawDescGZIP(), []int{15}
}

func (x *SyncState) GetSourceToken() string {
	if x != nil {
		return x.SourceToken
	}
	return ""
}

func (x *SyncState) GetImportToken() string {
	if x != nil {
		return x.ImportToken
	}
	return ""
}

func (x *SyncState) GetSyncToken() string {
	if x != nil {
		return x.SyncToken
	}
	return ""
}

// Deprecated: Do not use.
func (x *SyncState) GetLastSync() string {
	if x != nil {
		return x.LastSync
	}
	return ""
}

func (x *SyncState) GetLastSyncTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LastSyncTime
	}
	return nil
}

func (x *SyncState) GetCode() SyncState_SyncCode {
	if x != nil {
		return x.Code
	}
	return SyncState_SYNC_CODE_UNSPECIFIED
}

func (x *SyncState) GetErrors() []*SyncError {
	if x != nil {
		return x.Errors
	}
	return nil
}

// An ACM created error representing a problem syncing configurations
type SyncError struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// An ACM defined error code
	Code string `protobuf:"bytes,1,opt,name=code,proto3" json:"code,omitempty"`
	// A description of the error
	ErrorMessage string `protobuf:"bytes,2,opt,name=error_message,json=errorMessage,proto3" json:"error_message,omitempty"`
	// A list of config(s) associated with the error, if any
	ErrorResources []*ErrorResource `protobuf:"bytes,3,rep,name=error_resources,json=errorResources,proto3" json:"error_resources,omitempty"`
}

func (x *SyncError) Reset() {
	*x = SyncError{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SyncError) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SyncError) ProtoMessage() {}

func (x *SyncError) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SyncError.ProtoReflect.Descriptor instead.
func (*SyncError) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_rawDescGZIP(), []int{16}
}

func (x *SyncError) GetCode() string {
	if x != nil {
		return x.Code
	}
	return ""
}

func (x *SyncError) GetErrorMessage() string {
	if x != nil {
		return x.ErrorMessage
	}
	return ""
}

func (x *SyncError) GetErrorResources() []*ErrorResource {
	if x != nil {
		return x.ErrorResources
	}
	return nil
}

// Model for a config file in the git repo with an associated Sync error
type ErrorResource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Path in the git repo of the erroneous config
	SourcePath string `protobuf:"bytes,1,opt,name=source_path,json=sourcePath,proto3" json:"source_path,omitempty"`
	// Metadata name of the resource that is causing an error
	ResourceName string `protobuf:"bytes,2,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// Namespace of the resource that is causing an error
	ResourceNamespace string `protobuf:"bytes,3,opt,name=resource_namespace,json=resourceNamespace,proto3" json:"resource_namespace,omitempty"`
	// Group/version/kind of the resource that is causing an error
	ResourceGvk *GroupVersionKind `protobuf:"bytes,4,opt,name=resource_gvk,json=resourceGvk,proto3" json:"resource_gvk,omitempty"`
}

func (x *ErrorResource) Reset() {
	*x = ErrorResource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ErrorResource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ErrorResource) ProtoMessage() {}

func (x *ErrorResource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ErrorResource.ProtoReflect.Descriptor instead.
func (*ErrorResource) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_rawDescGZIP(), []int{17}
}

func (x *ErrorResource) GetSourcePath() string {
	if x != nil {
		return x.SourcePath
	}
	return ""
}

func (x *ErrorResource) GetResourceName() string {
	if x != nil {
		return x.ResourceName
	}
	return ""
}

func (x *ErrorResource) GetResourceNamespace() string {
	if x != nil {
		return x.ResourceNamespace
	}
	return ""
}

func (x *ErrorResource) GetResourceGvk() *GroupVersionKind {
	if x != nil {
		return x.ResourceGvk
	}
	return nil
}

// A Kubernetes object's GVK
type GroupVersionKind struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Kubernetes Group
	Group string `protobuf:"bytes,1,opt,name=group,proto3" json:"group,omitempty"`
	// Kubernetes Version
	Version string `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
	// Kubernetes Kind
	Kind string `protobuf:"bytes,3,opt,name=kind,proto3" json:"kind,omitempty"`
}

func (x *GroupVersionKind) Reset() {
	*x = GroupVersionKind{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GroupVersionKind) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GroupVersionKind) ProtoMessage() {}

func (x *GroupVersionKind) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GroupVersionKind.ProtoReflect.Descriptor instead.
func (*GroupVersionKind) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_rawDescGZIP(), []int{18}
}

func (x *GroupVersionKind) GetGroup() string {
	if x != nil {
		return x.Group
	}
	return ""
}

func (x *GroupVersionKind) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *GroupVersionKind) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

// State for PolicyControllerState.
type PolicyControllerState struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The version of Gatekeeper Policy Controller deployed.
	Version *PolicyControllerVersion `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	// The state about the policy controller installation.
	DeploymentState *GatekeeperDeploymentState `protobuf:"bytes,2,opt,name=deployment_state,json=deploymentState,proto3" json:"deployment_state,omitempty"`
}

func (x *PolicyControllerState) Reset() {
	*x = PolicyControllerState{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PolicyControllerState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PolicyControllerState) ProtoMessage() {}

func (x *PolicyControllerState) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PolicyControllerState.ProtoReflect.Descriptor instead.
func (*PolicyControllerState) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_rawDescGZIP(), []int{19}
}

func (x *PolicyControllerState) GetVersion() *PolicyControllerVersion {
	if x != nil {
		return x.Version
	}
	return nil
}

func (x *PolicyControllerState) GetDeploymentState() *GatekeeperDeploymentState {
	if x != nil {
		return x.DeploymentState
	}
	return nil
}

// The build version of Gatekeeper Policy Controller is using.
type PolicyControllerVersion struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The gatekeeper image tag that is composed of ACM version, git tag, build
	// number.
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *PolicyControllerVersion) Reset() {
	*x = PolicyControllerVersion{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PolicyControllerVersion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PolicyControllerVersion) ProtoMessage() {}

func (x *PolicyControllerVersion) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PolicyControllerVersion.ProtoReflect.Descriptor instead.
func (*PolicyControllerVersion) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_rawDescGZIP(), []int{20}
}

func (x *PolicyControllerVersion) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

// State for Binauthz
type BinauthzState struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The state of the binauthz webhook.
	Webhook DeploymentState `protobuf:"varint,1,opt,name=webhook,proto3,enum=google.cloud.gkehub.configmanagement.v1alpha.DeploymentState" json:"webhook,omitempty"`
	// The version of binauthz that is installed.
	Version *BinauthzVersion `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *BinauthzState) Reset() {
	*x = BinauthzState{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BinauthzState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BinauthzState) ProtoMessage() {}

func (x *BinauthzState) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BinauthzState.ProtoReflect.Descriptor instead.
func (*BinauthzState) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_rawDescGZIP(), []int{21}
}

func (x *BinauthzState) GetWebhook() DeploymentState {
	if x != nil {
		return x.Webhook
	}
	return DeploymentState_DEPLOYMENT_STATE_UNSPECIFIED
}

func (x *BinauthzState) GetVersion() *BinauthzVersion {
	if x != nil {
		return x.Version
	}
	return nil
}

// The version of binauthz.
type BinauthzVersion struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The version of the binauthz webhook.
	WebhookVersion string `protobuf:"bytes,1,opt,name=webhook_version,json=webhookVersion,proto3" json:"webhook_version,omitempty"`
}

func (x *BinauthzVersion) Reset() {
	*x = BinauthzVersion{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BinauthzVersion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BinauthzVersion) ProtoMessage() {}

func (x *BinauthzVersion) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BinauthzVersion.ProtoReflect.Descriptor instead.
func (*BinauthzVersion) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_rawDescGZIP(), []int{22}
}

func (x *BinauthzVersion) GetWebhookVersion() string {
	if x != nil {
		return x.WebhookVersion
	}
	return ""
}

// State of Policy Controller installation.
type GatekeeperDeploymentState struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Status of gatekeeper-controller-manager pod.
	GatekeeperControllerManagerState DeploymentState `protobuf:"varint,1,opt,name=gatekeeper_controller_manager_state,json=gatekeeperControllerManagerState,proto3,enum=google.cloud.gkehub.configmanagement.v1alpha.DeploymentState" json:"gatekeeper_controller_manager_state,omitempty"`
	// Status of gatekeeper-audit deployment.
	GatekeeperAudit DeploymentState `protobuf:"varint,2,opt,name=gatekeeper_audit,json=gatekeeperAudit,proto3,enum=google.cloud.gkehub.configmanagement.v1alpha.DeploymentState" json:"gatekeeper_audit,omitempty"`
	// Status of the pod serving the mutation webhook.
	GatekeeperMutation DeploymentState `protobuf:"varint,3,opt,name=gatekeeper_mutation,json=gatekeeperMutation,proto3,enum=google.cloud.gkehub.configmanagement.v1alpha.DeploymentState" json:"gatekeeper_mutation,omitempty"`
}

func (x *GatekeeperDeploymentState) Reset() {
	*x = GatekeeperDeploymentState{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GatekeeperDeploymentState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GatekeeperDeploymentState) ProtoMessage() {}

func (x *GatekeeperDeploymentState) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GatekeeperDeploymentState.ProtoReflect.Descriptor instead.
func (*GatekeeperDeploymentState) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_rawDescGZIP(), []int{23}
}

func (x *GatekeeperDeploymentState) GetGatekeeperControllerManagerState() DeploymentState {
	if x != nil {
		return x.GatekeeperControllerManagerState
	}
	return DeploymentState_DEPLOYMENT_STATE_UNSPECIFIED
}

func (x *GatekeeperDeploymentState) GetGatekeeperAudit() DeploymentState {
	if x != nil {
		return x.GatekeeperAudit
	}
	return DeploymentState_DEPLOYMENT_STATE_UNSPECIFIED
}

func (x *GatekeeperDeploymentState) GetGatekeeperMutation() DeploymentState {
	if x != nil {
		return x.GatekeeperMutation
	}
	return DeploymentState_DEPLOYMENT_STATE_UNSPECIFIED
}

var File_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto protoreflect.FileDescriptor

var file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_rawDesc = []byte{
	0x0a, 0x43, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x67,
	0x6b, 0x65, 0x68, 0x75, 0x62, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x2c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0xd2, 0x05, 0x0a, 0x0f, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69,
	0x70, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x63, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x65, 0x0a, 0x0f, 0x6d, 0x65, 0x6d,
	0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x53, 0x70, 0x65, 0x63,
	0x52, 0x0e, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x53, 0x70, 0x65, 0x63,
	0x12, 0x62, 0x0a, 0x0e, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x5f, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x0d, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x12, 0x69, 0x0a, 0x11, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x73,
	0x79, 0x6e, 0x63, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x79, 0x6e, 0x63, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x0f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x79, 0x6e, 0x63, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x7b, 0x0a, 0x17, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f,
	0x6c, 0x6c, 0x65, 0x72, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x15, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e,
	0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x62, 0x0a, 0x0e,
	0x62, 0x69, 0x6e, 0x61, 0x75, 0x74, 0x68, 0x7a, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x42, 0x69, 0x6e, 0x61, 0x75, 0x74, 0x68, 0x7a, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x52, 0x0d, 0x62, 0x69, 0x6e, 0x61, 0x75, 0x74, 0x68, 0x7a, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x12, 0x84, 0x01, 0x0a, 0x1a, 0x68, 0x69, 0x65, 0x72, 0x61, 0x72, 0x63, 0x68, 0x79, 0x5f, 0x63,
	0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x48, 0x69, 0x65, 0x72, 0x61, 0x72, 0x63, 0x68, 0x79, 0x43, 0x6f,
	0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x18, 0x68,
	0x69, 0x65, 0x72, 0x61, 0x72, 0x63, 0x68, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c,
	0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x65, 0x22, 0xc8, 0x03, 0x0a, 0x0e, 0x4d, 0x65, 0x6d, 0x62,
	0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x53, 0x70, 0x65, 0x63, 0x12, 0x59, 0x0a, 0x0b, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x5f, 0x73, 0x79, 0x6e, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x79, 0x6e, 0x63, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x53, 0x79, 0x6e, 0x63, 0x12, 0x6b, 0x0a, 0x11, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f,
	0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72,
	0x52, 0x10, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c,
	0x65, 0x72, 0x12, 0x58, 0x0a, 0x08, 0x62, 0x69, 0x6e, 0x61, 0x75, 0x74, 0x68, 0x7a, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x42, 0x69, 0x6e, 0x61, 0x75, 0x74, 0x68, 0x7a, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x08, 0x62, 0x69, 0x6e, 0x61, 0x75, 0x74, 0x68, 0x7a, 0x12, 0x7a, 0x0a, 0x14,
	0x68, 0x69, 0x65, 0x72, 0x61, 0x72, 0x63, 0x68, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f,
	0x6c, 0x6c, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62,
	0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x48, 0x69, 0x65, 0x72, 0x61, 0x72,
	0x63, 0x68, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x13, 0x68, 0x69, 0x65, 0x72, 0x61, 0x72, 0x63, 0x68, 0x79, 0x43, 0x6f,
	0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x22, 0x7c, 0x0a, 0x0a, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x79, 0x6e, 0x63,
	0x12, 0x49, 0x0a, 0x03, 0x67, 0x69, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65,
	0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47, 0x69, 0x74,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x03, 0x67, 0x69, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0c, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74,
	0x22, 0xa6, 0x02, 0x0a, 0x09, 0x47, 0x69, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1b,
	0x0a, 0x09, 0x73, 0x79, 0x6e, 0x63, 0x5f, 0x72, 0x65, 0x70, 0x6f, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x73, 0x79, 0x6e, 0x63, 0x52, 0x65, 0x70, 0x6f, 0x12, 0x1f, 0x0a, 0x0b, 0x73,
	0x79, 0x6e, 0x63, 0x5f, 0x62, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0a, 0x73, 0x79, 0x6e, 0x63, 0x42, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x12, 0x1d, 0x0a, 0x0a,
	0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x64, 0x69, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x44, 0x69, 0x72, 0x12, 0x24, 0x0a, 0x0e, 0x73,
	0x79, 0x6e, 0x63, 0x5f, 0x77, 0x61, 0x69, 0x74, 0x5f, 0x73, 0x65, 0x63, 0x73, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x0c, 0x73, 0x79, 0x6e, 0x63, 0x57, 0x61, 0x69, 0x74, 0x53, 0x65, 0x63,
	0x73, 0x12, 0x19, 0x0a, 0x08, 0x73, 0x79, 0x6e, 0x63, 0x5f, 0x72, 0x65, 0x76, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x07, 0x73, 0x79, 0x6e, 0x63, 0x52, 0x65, 0x76, 0x12, 0x1f, 0x0a, 0x0b,
	0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0a, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1f, 0x0a,
	0x0b, 0x68, 0x74, 0x74, 0x70, 0x73, 0x5f, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0a, 0x68, 0x74, 0x74, 0x70, 0x73, 0x50, 0x72, 0x6f, 0x78, 0x79, 0x12, 0x39,
	0x0a, 0x19, 0x67, 0x63, 0x70, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x16, 0x67, 0x63, 0x70, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x45, 0x6d, 0x61, 0x69, 0x6c, 0x22, 0xae, 0x03, 0x0a, 0x10, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x12, 0x18,
	0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x41, 0x0a, 0x1a, 0x74, 0x65, 0x6d, 0x70,
	0x6c, 0x61, 0x74, 0x65, 0x5f, 0x6c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x5f, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6c, 0x6c, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x18,
	0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x65, 0x64, 0x88, 0x01, 0x01, 0x12, 0x39, 0x0a, 0x16, 0x61,
	0x75, 0x64, 0x69, 0x74, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x5f, 0x73, 0x65,
	0x63, 0x6f, 0x6e, 0x64, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x48, 0x01, 0x52, 0x14, 0x61,
	0x75, 0x64, 0x69, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x53, 0x65, 0x63, 0x6f,
	0x6e, 0x64, 0x73, 0x88, 0x01, 0x01, 0x12, 0x33, 0x0a, 0x15, 0x65, 0x78, 0x65, 0x6d, 0x70, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x18,
	0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x14, 0x65, 0x78, 0x65, 0x6d, 0x70, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x12, 0x3a, 0x0a, 0x19, 0x72,
	0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x17,
	0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x52, 0x75, 0x6c, 0x65, 0x73,
	0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x2c, 0x0a, 0x12, 0x6c, 0x6f, 0x67, 0x5f, 0x64,
	0x65, 0x6e, 0x69, 0x65, 0x73, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x10, 0x6c, 0x6f, 0x67, 0x44, 0x65, 0x6e, 0x69, 0x65, 0x73, 0x45, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x29, 0x0a, 0x10, 0x6d, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x0f, 0x6d, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64,
	0x42, 0x1d, 0x0a, 0x1b, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x5f, 0x6c, 0x69,
	0x62, 0x72, 0x61, 0x72, 0x79, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x65, 0x64, 0x42,
	0x19, 0x0a, 0x17, 0x5f, 0x61, 0x75, 0x64, 0x69, 0x74, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76,
	0x61, 0x6c, 0x5f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x22, 0x2a, 0x0a, 0x0e, 0x42, 0x69,
	0x6e, 0x61, 0x75, 0x74, 0x68, 0x7a, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x18, 0x0a, 0x07,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x22, 0xb7, 0x01, 0x0a, 0x19, 0x48, 0x69, 0x65, 0x72, 0x61,
	0x72, 0x63, 0x68, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x18, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x33,
	0x0a, 0x16, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x70, 0x6f, 0x64, 0x5f, 0x74, 0x72, 0x65,
	0x65, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x13,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x6f, 0x64, 0x54, 0x72, 0x65, 0x65, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x12, 0x4b, 0x0a, 0x22, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x68, 0x69,
	0x65, 0x72, 0x61, 0x72, 0x63, 0x68, 0x69, 0x63, 0x61, 0x6c, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x5f, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x1f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x48, 0x69, 0x65, 0x72, 0x61, 0x72, 0x63, 0x68, 0x69,
	0x63, 0x61, 0x6c, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x51, 0x75, 0x6f, 0x74, 0x61,
	0x22, 0xd2, 0x01, 0x0a, 0x22, 0x48, 0x69, 0x65, 0x72, 0x61, 0x72, 0x63, 0x68, 0x79, 0x43, 0x6f,
	0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65,
	0x6e, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x4f, 0x0a, 0x03, 0x68, 0x6e, 0x63, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x52, 0x03, 0x68, 0x6e, 0x63, 0x12, 0x5b, 0x0a, 0x09, 0x65, 0x78, 0x74, 0x65,
	0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x68, 0x75,
	0x62, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x09, 0x65, 0x78, 0x74, 0x65,
	0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x4c, 0x0a, 0x1a, 0x48, 0x69, 0x65, 0x72, 0x61, 0x72, 0x63,
	0x68, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x12, 0x10, 0x0a, 0x03, 0x68, 0x6e, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x68, 0x6e, 0x63, 0x12, 0x1c, 0x0a, 0x09, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69,
	0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x22, 0xe6, 0x01, 0x0a, 0x18, 0x48, 0x69, 0x65, 0x72, 0x61, 0x72, 0x63, 0x68,
	0x79, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x12, 0x62, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x48, 0x69, 0x65, 0x72, 0x61, 0x72, 0x63, 0x68, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f,
	0x6c, 0x6c, 0x65, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x12, 0x66, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x50, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x48, 0x69, 0x65, 0x72, 0x61, 0x72, 0x63, 0x68, 0x79, 0x43, 0x6f, 0x6e, 0x74,
	0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x22, 0xe7, 0x01, 0x0a,
	0x0d, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x18,
	0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x68, 0x0a, 0x10, 0x64, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x52, 0x0f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x12, 0x52, 0x0a, 0x06, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x52, 0x06,
	0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x22, 0x33, 0x0a, 0x0c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c,
	0x6c, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x23, 0x0a, 0x0d, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f,
	0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x65,
	0x72, 0x72, 0x6f, 0x72, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22, 0xb8, 0x02, 0x0a, 0x0f,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x79, 0x6e, 0x63, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x59, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x79, 0x6e, 0x63, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x72, 0x0a, 0x10, 0x64, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x79, 0x6e, 0x63, 0x44, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x0f, 0x64,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x56,
	0x0a, 0x0a, 0x73, 0x79, 0x6e, 0x63, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x53, 0x79, 0x6e, 0x63, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x09, 0x73, 0x79, 0x6e,
	0x63, 0x53, 0x74, 0x61, 0x74, 0x65, 0x22, 0xd4, 0x01, 0x0a, 0x11, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x53, 0x79, 0x6e, 0x63, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1a, 0x0a, 0x08,
	0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08,
	0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x72, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x79, 0x6e, 0x63,
	0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x73, 0x79, 0x6e, 0x63, 0x65, 0x72,
	0x12, 0x19, 0x0a, 0x08, 0x67, 0x69, 0x74, 0x5f, 0x73, 0x79, 0x6e, 0x63, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x67, 0x69, 0x74, 0x53, 0x79, 0x6e, 0x63, 0x12, 0x18, 0x0a, 0x07, 0x6d,
	0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6d, 0x6f,
	0x6e, 0x69, 0x74, 0x6f, 0x72, 0x12, 0x2d, 0x0a, 0x12, 0x72, 0x65, 0x63, 0x6f, 0x6e, 0x63, 0x69,
	0x6c, 0x65, 0x72, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x11, 0x72, 0x65, 0x63, 0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x65, 0x72, 0x4d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x72, 0x12, 0x27, 0x0a, 0x0f, 0x72, 0x6f, 0x6f, 0x74, 0x5f, 0x72, 0x65, 0x63,
	0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x65, 0x72, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x72,
	0x6f, 0x6f, 0x74, 0x52, 0x65, 0x63, 0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x65, 0x72, 0x22, 0xd6, 0x04,
	0x0a, 0x19, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x79, 0x6e, 0x63, 0x44, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x59, 0x0a, 0x08, 0x69,
	0x6d, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65,
	0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x08, 0x69, 0x6d,
	0x70, 0x6f, 0x72, 0x74, 0x65, 0x72, 0x12, 0x55, 0x0a, 0x06, 0x73, 0x79, 0x6e, 0x63, 0x65, 0x72,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x06, 0x73, 0x79, 0x6e, 0x63, 0x65, 0x72, 0x12, 0x58, 0x0a,
	0x08, 0x67, 0x69, 0x74, 0x5f, 0x73, 0x79, 0x6e, 0x63, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x07,
	0x67, 0x69, 0x74, 0x53, 0x79, 0x6e, 0x63, 0x12, 0x57, 0x0a, 0x07, 0x6d, 0x6f, 0x6e, 0x69, 0x74,
	0x6f, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65,
	0x6e, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x07, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72,
	0x12, 0x6c, 0x0a, 0x12, 0x72, 0x65, 0x63, 0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x65, 0x72, 0x5f, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x68,
	0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x11, 0x72, 0x65, 0x63,
	0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x65, 0x72, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x12, 0x66,
	0x0a, 0x0f, 0x72, 0x6f, 0x6f, 0x74, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x65,
	0x72, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e,
	0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x0e, 0x72, 0x6f, 0x6f, 0x74, 0x52, 0x65, 0x63, 0x6f,
	0x6e, 0x63, 0x69, 0x6c, 0x65, 0x72, 0x22, 0x90, 0x04, 0x0a, 0x09, 0x53, 0x79, 0x6e, 0x63, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x21, 0x0a, 0x0c, 0x69, 0x6d, 0x70, 0x6f, 0x72,
	0x74, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x69,
	0x6d, 0x70, 0x6f, 0x72, 0x74, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x79,
	0x6e, 0x63, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x73, 0x79, 0x6e, 0x63, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1f, 0x0a, 0x09, 0x6c, 0x61, 0x73,
	0x74, 0x5f, 0x73, 0x79, 0x6e, 0x63, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01,
	0x52, 0x08, 0x6c, 0x61, 0x73, 0x74, 0x53, 0x79, 0x6e, 0x63, 0x12, 0x40, 0x0a, 0x0e, 0x6c, 0x61,
	0x73, 0x74, 0x5f, 0x73, 0x79, 0x6e, 0x63, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0c,
	0x6c, 0x61, 0x73, 0x74, 0x53, 0x79, 0x6e, 0x63, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x54, 0x0a, 0x04,
	0x63, 0x6f, 0x64, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62,
	0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x79, 0x6e, 0x63, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x2e, 0x53, 0x79, 0x6e, 0x63, 0x43, 0x6f, 0x64, 0x65, 0x52, 0x04, 0x63, 0x6f,
	0x64, 0x65, 0x12, 0x4f, 0x0a, 0x06, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x18, 0x06, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x53, 0x79, 0x6e, 0x63, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x52, 0x06, 0x65, 0x72, 0x72,
	0x6f, 0x72, 0x73, 0x22, 0x93, 0x01, 0x0a, 0x08, 0x53, 0x79, 0x6e, 0x63, 0x43, 0x6f, 0x64, 0x65,
	0x12, 0x19, 0x0a, 0x15, 0x53, 0x59, 0x4e, 0x43, 0x5f, 0x43, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x53,
	0x59, 0x4e, 0x43, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x45, 0x4e, 0x44, 0x49,
	0x4e, 0x47, 0x10, 0x02, 0x12, 0x09, 0x0a, 0x05, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x03, 0x12,
	0x12, 0x0a, 0x0e, 0x4e, 0x4f, 0x54, 0x5f, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x47, 0x55, 0x52, 0x45,
	0x44, 0x10, 0x04, 0x12, 0x11, 0x0a, 0x0d, 0x4e, 0x4f, 0x54, 0x5f, 0x49, 0x4e, 0x53, 0x54, 0x41,
	0x4c, 0x4c, 0x45, 0x44, 0x10, 0x05, 0x12, 0x10, 0x0a, 0x0c, 0x55, 0x4e, 0x41, 0x55, 0x54, 0x48,
	0x4f, 0x52, 0x49, 0x5a, 0x45, 0x44, 0x10, 0x06, 0x12, 0x0f, 0x0a, 0x0b, 0x55, 0x4e, 0x52, 0x45,
	0x41, 0x43, 0x48, 0x41, 0x42, 0x4c, 0x45, 0x10, 0x07, 0x22, 0xaa, 0x01, 0x0a, 0x09, 0x53, 0x79,
	0x6e, 0x63, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x12, 0x0a, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x65,
	0x72, 0x72, 0x6f, 0x72, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x12, 0x64, 0x0a, 0x0f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x0e, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x22, 0xe7, 0x01, 0x0a, 0x0d, 0x45, 0x72, 0x72, 0x6f, 0x72,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x50, 0x61, 0x74, 0x68, 0x12, 0x23, 0x0a, 0x0d, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x2d,
	0x0a, 0x12, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73,
	0x70, 0x61, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x61, 0x0a,
	0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x67, 0x76, 0x6b, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x4b,
	0x69, 0x6e, 0x64, 0x52, 0x0b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x47, 0x76, 0x6b,
	0x22, 0x56, 0x0a, 0x10, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x4b, 0x69, 0x6e, 0x64, 0x12, 0x14, 0x0a, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x22, 0xec, 0x01, 0x0a, 0x15, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x12, 0x5f, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c,
	0x6c, 0x65, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x12, 0x72, 0x0a, 0x10, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e,
	0x74, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x47, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65,
	0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47, 0x61, 0x74,
	0x65, 0x6b, 0x65, 0x65, 0x70, 0x65, 0x72, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e,
	0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x0f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65,
	0x6e, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x22, 0x33, 0x0a, 0x17, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xc1, 0x01, 0x0a,
	0x0d, 0x42, 0x69, 0x6e, 0x61, 0x75, 0x74, 0x68, 0x7a, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x57,
	0x0a, 0x07, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x07,
	0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x12, 0x57, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x42, 0x69, 0x6e, 0x61, 0x75, 0x74, 0x68, 0x7a,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x22, 0x3a, 0x0a, 0x0f, 0x42, 0x69, 0x6e, 0x61, 0x75, 0x74, 0x68, 0x7a, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x12, 0x27, 0x0a, 0x0f, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x5f, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x77, 0x65,
	0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x84, 0x03, 0x0a,
	0x19, 0x47, 0x61, 0x74, 0x65, 0x6b, 0x65, 0x65, 0x70, 0x65, 0x72, 0x44, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x8c, 0x01, 0x0a, 0x23, 0x67,
	0x61, 0x74, 0x65, 0x6b, 0x65, 0x65, 0x70, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f,
	0x6c, 0x6c, 0x65, 0x72, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x5f, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65,
	0x6e, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x20, 0x67, 0x61, 0x74, 0x65, 0x6b, 0x65, 0x65,
	0x70, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x4d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x68, 0x0a, 0x10, 0x67, 0x61, 0x74,
	0x65, 0x6b, 0x65, 0x65, 0x70, 0x65, 0x72, 0x5f, 0x61, 0x75, 0x64, 0x69, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x52, 0x0f, 0x67, 0x61, 0x74, 0x65, 0x6b, 0x65, 0x65, 0x70, 0x65, 0x72, 0x41, 0x75,
	0x64, 0x69, 0x74, 0x12, 0x6e, 0x0a, 0x13, 0x67, 0x61, 0x74, 0x65, 0x6b, 0x65, 0x65, 0x70, 0x65,
	0x72, 0x5f, 0x6d, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52,
	0x12, 0x67, 0x61, 0x74, 0x65, 0x6b, 0x65, 0x65, 0x70, 0x65, 0x72, 0x4d, 0x75, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2a, 0x60, 0x0a, 0x0f, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e,
	0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x20, 0x0a, 0x1c, 0x44, 0x45, 0x50, 0x4c, 0x4f, 0x59,
	0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x11, 0x0a, 0x0d, 0x4e, 0x4f, 0x54, 0x5f,
	0x49, 0x4e, 0x53, 0x54, 0x41, 0x4c, 0x4c, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x49,
	0x4e, 0x53, 0x54, 0x41, 0x4c, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x12, 0x09, 0x0a, 0x05, 0x45, 0x52,
	0x52, 0x4f, 0x52, 0x10, 0x03, 0x42, 0xba, 0x02, 0x0a, 0x30, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x68, 0x75,
	0x62, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x42, 0x15, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x50, 0x01, 0x5a, 0x5c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61,
	0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2f, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x3b, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0xaa, 0x02, 0x2c, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x47, 0x6b, 0x65, 0x48, 0x75, 0x62, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x56, 0x31, 0x41, 0x6c, 0x70, 0x68, 0x61,
	0xca, 0x02, 0x2c, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c,
	0x47, 0x6b, 0x65, 0x48, 0x75, 0x62, 0x5c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5c, 0x56, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0xea,
	0x02, 0x30, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a,
	0x3a, 0x47, 0x6b, 0x65, 0x48, 0x75, 0x62, 0x3a, 0x3a, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x3a, 0x3a, 0x56, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_rawDescOnce sync.Once
	file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_rawDescData = file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_rawDesc
)

func file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_rawDescGZIP() []byte {
	file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_rawDescOnce.Do(func() {
		file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_rawDescData)
	})
	return file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_rawDescData
}

var file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_msgTypes = make([]protoimpl.MessageInfo, 24)
var file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_goTypes = []interface{}{
	(DeploymentState)(0),                       // 0: google.cloud.gkehub.configmanagement.v1alpha.DeploymentState
	(SyncState_SyncCode)(0),                    // 1: google.cloud.gkehub.configmanagement.v1alpha.SyncState.SyncCode
	(*MembershipState)(nil),                    // 2: google.cloud.gkehub.configmanagement.v1alpha.MembershipState
	(*MembershipSpec)(nil),                     // 3: google.cloud.gkehub.configmanagement.v1alpha.MembershipSpec
	(*ConfigSync)(nil),                         // 4: google.cloud.gkehub.configmanagement.v1alpha.ConfigSync
	(*GitConfig)(nil),                          // 5: google.cloud.gkehub.configmanagement.v1alpha.GitConfig
	(*PolicyController)(nil),                   // 6: google.cloud.gkehub.configmanagement.v1alpha.PolicyController
	(*BinauthzConfig)(nil),                     // 7: google.cloud.gkehub.configmanagement.v1alpha.BinauthzConfig
	(*HierarchyControllerConfig)(nil),          // 8: google.cloud.gkehub.configmanagement.v1alpha.HierarchyControllerConfig
	(*HierarchyControllerDeploymentState)(nil), // 9: google.cloud.gkehub.configmanagement.v1alpha.HierarchyControllerDeploymentState
	(*HierarchyControllerVersion)(nil),         // 10: google.cloud.gkehub.configmanagement.v1alpha.HierarchyControllerVersion
	(*HierarchyControllerState)(nil),           // 11: google.cloud.gkehub.configmanagement.v1alpha.HierarchyControllerState
	(*OperatorState)(nil),                      // 12: google.cloud.gkehub.configmanagement.v1alpha.OperatorState
	(*InstallError)(nil),                       // 13: google.cloud.gkehub.configmanagement.v1alpha.InstallError
	(*ConfigSyncState)(nil),                    // 14: google.cloud.gkehub.configmanagement.v1alpha.ConfigSyncState
	(*ConfigSyncVersion)(nil),                  // 15: google.cloud.gkehub.configmanagement.v1alpha.ConfigSyncVersion
	(*ConfigSyncDeploymentState)(nil),          // 16: google.cloud.gkehub.configmanagement.v1alpha.ConfigSyncDeploymentState
	(*SyncState)(nil),                          // 17: google.cloud.gkehub.configmanagement.v1alpha.SyncState
	(*SyncError)(nil),                          // 18: google.cloud.gkehub.configmanagement.v1alpha.SyncError
	(*ErrorResource)(nil),                      // 19: google.cloud.gkehub.configmanagement.v1alpha.ErrorResource
	(*GroupVersionKind)(nil),                   // 20: google.cloud.gkehub.configmanagement.v1alpha.GroupVersionKind
	(*PolicyControllerState)(nil),              // 21: google.cloud.gkehub.configmanagement.v1alpha.PolicyControllerState
	(*PolicyControllerVersion)(nil),            // 22: google.cloud.gkehub.configmanagement.v1alpha.PolicyControllerVersion
	(*BinauthzState)(nil),                      // 23: google.cloud.gkehub.configmanagement.v1alpha.BinauthzState
	(*BinauthzVersion)(nil),                    // 24: google.cloud.gkehub.configmanagement.v1alpha.BinauthzVersion
	(*GatekeeperDeploymentState)(nil),          // 25: google.cloud.gkehub.configmanagement.v1alpha.GatekeeperDeploymentState
	(*timestamppb.Timestamp)(nil),              // 26: google.protobuf.Timestamp
}
var file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_depIdxs = []int32{
	3,  // 0: google.cloud.gkehub.configmanagement.v1alpha.MembershipState.membership_spec:type_name -> google.cloud.gkehub.configmanagement.v1alpha.MembershipSpec
	12, // 1: google.cloud.gkehub.configmanagement.v1alpha.MembershipState.operator_state:type_name -> google.cloud.gkehub.configmanagement.v1alpha.OperatorState
	14, // 2: google.cloud.gkehub.configmanagement.v1alpha.MembershipState.config_sync_state:type_name -> google.cloud.gkehub.configmanagement.v1alpha.ConfigSyncState
	21, // 3: google.cloud.gkehub.configmanagement.v1alpha.MembershipState.policy_controller_state:type_name -> google.cloud.gkehub.configmanagement.v1alpha.PolicyControllerState
	23, // 4: google.cloud.gkehub.configmanagement.v1alpha.MembershipState.binauthz_state:type_name -> google.cloud.gkehub.configmanagement.v1alpha.BinauthzState
	11, // 5: google.cloud.gkehub.configmanagement.v1alpha.MembershipState.hierarchy_controller_state:type_name -> google.cloud.gkehub.configmanagement.v1alpha.HierarchyControllerState
	4,  // 6: google.cloud.gkehub.configmanagement.v1alpha.MembershipSpec.config_sync:type_name -> google.cloud.gkehub.configmanagement.v1alpha.ConfigSync
	6,  // 7: google.cloud.gkehub.configmanagement.v1alpha.MembershipSpec.policy_controller:type_name -> google.cloud.gkehub.configmanagement.v1alpha.PolicyController
	7,  // 8: google.cloud.gkehub.configmanagement.v1alpha.MembershipSpec.binauthz:type_name -> google.cloud.gkehub.configmanagement.v1alpha.BinauthzConfig
	8,  // 9: google.cloud.gkehub.configmanagement.v1alpha.MembershipSpec.hierarchy_controller:type_name -> google.cloud.gkehub.configmanagement.v1alpha.HierarchyControllerConfig
	5,  // 10: google.cloud.gkehub.configmanagement.v1alpha.ConfigSync.git:type_name -> google.cloud.gkehub.configmanagement.v1alpha.GitConfig
	0,  // 11: google.cloud.gkehub.configmanagement.v1alpha.HierarchyControllerDeploymentState.hnc:type_name -> google.cloud.gkehub.configmanagement.v1alpha.DeploymentState
	0,  // 12: google.cloud.gkehub.configmanagement.v1alpha.HierarchyControllerDeploymentState.extension:type_name -> google.cloud.gkehub.configmanagement.v1alpha.DeploymentState
	10, // 13: google.cloud.gkehub.configmanagement.v1alpha.HierarchyControllerState.version:type_name -> google.cloud.gkehub.configmanagement.v1alpha.HierarchyControllerVersion
	9,  // 14: google.cloud.gkehub.configmanagement.v1alpha.HierarchyControllerState.state:type_name -> google.cloud.gkehub.configmanagement.v1alpha.HierarchyControllerDeploymentState
	0,  // 15: google.cloud.gkehub.configmanagement.v1alpha.OperatorState.deployment_state:type_name -> google.cloud.gkehub.configmanagement.v1alpha.DeploymentState
	13, // 16: google.cloud.gkehub.configmanagement.v1alpha.OperatorState.errors:type_name -> google.cloud.gkehub.configmanagement.v1alpha.InstallError
	15, // 17: google.cloud.gkehub.configmanagement.v1alpha.ConfigSyncState.version:type_name -> google.cloud.gkehub.configmanagement.v1alpha.ConfigSyncVersion
	16, // 18: google.cloud.gkehub.configmanagement.v1alpha.ConfigSyncState.deployment_state:type_name -> google.cloud.gkehub.configmanagement.v1alpha.ConfigSyncDeploymentState
	17, // 19: google.cloud.gkehub.configmanagement.v1alpha.ConfigSyncState.sync_state:type_name -> google.cloud.gkehub.configmanagement.v1alpha.SyncState
	0,  // 20: google.cloud.gkehub.configmanagement.v1alpha.ConfigSyncDeploymentState.importer:type_name -> google.cloud.gkehub.configmanagement.v1alpha.DeploymentState
	0,  // 21: google.cloud.gkehub.configmanagement.v1alpha.ConfigSyncDeploymentState.syncer:type_name -> google.cloud.gkehub.configmanagement.v1alpha.DeploymentState
	0,  // 22: google.cloud.gkehub.configmanagement.v1alpha.ConfigSyncDeploymentState.git_sync:type_name -> google.cloud.gkehub.configmanagement.v1alpha.DeploymentState
	0,  // 23: google.cloud.gkehub.configmanagement.v1alpha.ConfigSyncDeploymentState.monitor:type_name -> google.cloud.gkehub.configmanagement.v1alpha.DeploymentState
	0,  // 24: google.cloud.gkehub.configmanagement.v1alpha.ConfigSyncDeploymentState.reconciler_manager:type_name -> google.cloud.gkehub.configmanagement.v1alpha.DeploymentState
	0,  // 25: google.cloud.gkehub.configmanagement.v1alpha.ConfigSyncDeploymentState.root_reconciler:type_name -> google.cloud.gkehub.configmanagement.v1alpha.DeploymentState
	26, // 26: google.cloud.gkehub.configmanagement.v1alpha.SyncState.last_sync_time:type_name -> google.protobuf.Timestamp
	1,  // 27: google.cloud.gkehub.configmanagement.v1alpha.SyncState.code:type_name -> google.cloud.gkehub.configmanagement.v1alpha.SyncState.SyncCode
	18, // 28: google.cloud.gkehub.configmanagement.v1alpha.SyncState.errors:type_name -> google.cloud.gkehub.configmanagement.v1alpha.SyncError
	19, // 29: google.cloud.gkehub.configmanagement.v1alpha.SyncError.error_resources:type_name -> google.cloud.gkehub.configmanagement.v1alpha.ErrorResource
	20, // 30: google.cloud.gkehub.configmanagement.v1alpha.ErrorResource.resource_gvk:type_name -> google.cloud.gkehub.configmanagement.v1alpha.GroupVersionKind
	22, // 31: google.cloud.gkehub.configmanagement.v1alpha.PolicyControllerState.version:type_name -> google.cloud.gkehub.configmanagement.v1alpha.PolicyControllerVersion
	25, // 32: google.cloud.gkehub.configmanagement.v1alpha.PolicyControllerState.deployment_state:type_name -> google.cloud.gkehub.configmanagement.v1alpha.GatekeeperDeploymentState
	0,  // 33: google.cloud.gkehub.configmanagement.v1alpha.BinauthzState.webhook:type_name -> google.cloud.gkehub.configmanagement.v1alpha.DeploymentState
	24, // 34: google.cloud.gkehub.configmanagement.v1alpha.BinauthzState.version:type_name -> google.cloud.gkehub.configmanagement.v1alpha.BinauthzVersion
	0,  // 35: google.cloud.gkehub.configmanagement.v1alpha.GatekeeperDeploymentState.gatekeeper_controller_manager_state:type_name -> google.cloud.gkehub.configmanagement.v1alpha.DeploymentState
	0,  // 36: google.cloud.gkehub.configmanagement.v1alpha.GatekeeperDeploymentState.gatekeeper_audit:type_name -> google.cloud.gkehub.configmanagement.v1alpha.DeploymentState
	0,  // 37: google.cloud.gkehub.configmanagement.v1alpha.GatekeeperDeploymentState.gatekeeper_mutation:type_name -> google.cloud.gkehub.configmanagement.v1alpha.DeploymentState
	38, // [38:38] is the sub-list for method output_type
	38, // [38:38] is the sub-list for method input_type
	38, // [38:38] is the sub-list for extension type_name
	38, // [38:38] is the sub-list for extension extendee
	0,  // [0:38] is the sub-list for field type_name
}

func init() { file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_init() }
func file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_init() {
	if File_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MembershipState); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MembershipSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConfigSync); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GitConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PolicyController); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BinauthzConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HierarchyControllerConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HierarchyControllerDeploymentState); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HierarchyControllerVersion); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HierarchyControllerState); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OperatorState); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InstallError); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConfigSyncState); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConfigSyncVersion); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConfigSyncDeploymentState); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SyncState); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SyncError); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ErrorResource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GroupVersionKind); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PolicyControllerState); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PolicyControllerVersion); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BinauthzState); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BinauthzVersion); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GatekeeperDeploymentState); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_msgTypes[4].OneofWrappers = []interface{}{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   24,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_goTypes,
		DependencyIndexes: file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_depIdxs,
		EnumInfos:         file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_enumTypes,
		MessageInfos:      file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_msgTypes,
	}.Build()
	File_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto = out.File
	file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_rawDesc = nil
	file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_goTypes = nil
	file_google_cloud_gkehub_v1alpha_configmanagement_configmanagement_proto_depIdxs = nil
}
