package translatortextapi

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/preview/cognitiveservices/v1.0_preview.1/translatortext"
	"github.com/Azure/go-autorest/autorest"
	"github.com/gofrs/uuid"
)

// TranslationClientAPI contains the set of methods on the TranslationClient type.
type TranslationClientAPI interface {
	CancelOperation(ctx context.Context, endpoint string, ID uuid.UUID) (result translatortext.BatchStatusDetail, err error)
	GetDocumentFormats(ctx context.Context, endpoint string) (result translatortext.FileFormatListResult, err error)
	GetDocumentStatus(ctx context.Context, endpoint string, ID uuid.UUID, documentID uuid.UUID) (result translatortext.DocumentStatusDetail, err error)
	GetDocumentStorageSource(ctx context.Context, endpoint string) (result translatortext.StorageSourceListResult, err error)
	GetGlossaryFormats(ctx context.Context, endpoint string) (result translatortext.FileFormatListResult, err error)
	GetOperationDocumentsStatus(ctx context.Context, endpoint string, ID uuid.UUID, top *int32, skip *int32) (result translatortext.DocumentStatusResponse, err error)
	GetOperations(ctx context.Context, endpoint string, top *int32, skip *int32) (result translatortext.BatchStatusResponse, err error)
	GetOperationStatus(ctx context.Context, endpoint string, ID uuid.UUID) (result translatortext.BatchStatusDetail, err error)
	SubmitBatchRequest(ctx context.Context, endpoint string, body *translatortext.BatchSubmissionRequest) (result autorest.Response, err error)
}

var _ TranslationClientAPI = (*translatortext.TranslationClient)(nil)
