# Contributing Guidelines

The **kubernetes/cloud-provider-gcp** project accepts contribution via github [pull request](https://help.github.com/articles/about-pull-requests/). This document outlines the process to help get your contribution accepted. Please also read the [Kubernetes contributor guide](https://github.com/kubernetes/community/blob/master/contributors/guide/README.md).

### Sign the Contributor License Agreement
We'd love to accept your patches! Before we can accept them you need to sign Cloud Native Computing Foundation (CNCF) [CLA](https://github.com/kubernetes/community/blob/master/CLA.md).

### Reporting an issue
If you find a bug or a feature request related to cloud-provider-gcp you can create a new github issue in this repo.

### Contributing a Patch
1. Submit an issue describing your proposed change to the repo.
2. Fork the cloud-provider-gcp repo, develop and test your code changes.
3. Submit a pull request.
4. The bot will automatically assigns someone to review your PR. Check the full list of bot commands [here](https://prow.k8s.io/command-help).

### Contact
* [Slack](https://kubernetes.slack.com/messages/sig-gcp)
* [Mailing list](https://groups.google.com/forum/#!forum/kubernetes-sig-gcp)
* Please check the [sig-gcp community page](https://github.com/kubernetes/community/blob/master/sig-gcp/README.md) for meeting times and more details.
