---
title: Contribute documentation
---

# Contributing documentation

HyperShift's documentation is based on [MkDocs](https://www.mkdocs.org) with the
[Material theme](https://squidfunk.github.io) and roughly follows the
[Diátaxis Framework](https://diataxis.fr) for content organization and stylistic
approach.

The documentation site is built and published automatically to [https://hypershift-docs.netlify.app](https://hypershift-docs.netlify.app).

## Overview

All documentation lives in the [`docs` directory](https://github.com/openshift/hypershift/tree/main/docs) of the Git repository.

All content should be Markdown files placed in the [`docs/content` directory](https://github.com/openshift/hypershift/tree/main/docs/content).
The [MkDocs configuration file](https://github.com/openshift/hypershift/blob/main/docs/mkdocs.yml)
contains all the MkDocs and Material theme configuration, including the navigation
structure for the site.

The `quay.io/hypershift/mkdocs-material:latest` image ([Dockerfile](https://github.com/openshift/hypershift/blob/main/docs/Dockerfile))
is published to provide an easy and portable way to run `mkdocs` fully configured
to preview the site equivalent to the published site.

!!! note

    The [`README.md`](https://github.com/openshift/hypershift/blob/main/README.md)
    file in the repository root is a minimal overview which quickly links users to
    the latest published documentation. Most content should go in the docs.

!!! important

    The [API reference](../reference/api.md) is generated automatically. Do not
    edit it manually. See the [API generation section](#generate-the-api-reference)
    section for details.

## Preview the site locally

To start a live preview of the site which automatically rebuilds and refreshes in
response to local content and configuration changes, run the following from the
`docs` directory:

```shell
make serve-containerized
```

Visit the site at [http://0.0.0.0:8000](http://0.0.0.0:8000).

!!! note

    The `serve-containerized` Make target runs the `quay.io/hypershift/mkdocs-material:latest`
    image with the local container runtime. Running `mkdocs` natively is possible
    but not supported.

    If you need more control over the local preview server, consult [the Makefile](https://github.com/openshift/hypershift/blob/main/docs/Makefile)
    as a guide to constructing your own local server command.

## Generate the API reference

The [API reference](../reference/api.md) is automatically generated by the
[`gen-crd-api-reference-docs` tool](https://github.com/ahmetb/gen-crd-api-reference-docs).

The `gen-crd-api-reference-docs` tool processes the [HyperShift API Go type
definitions](https://github.com/openshift/hypershift/tree/main/api) and reads the
[Kubernetes Custom Resource Definition](https://kubernetes.io/docs/concepts/extend-kubernetes/api-extension/custom-resources/)
metadata associated with the API types. Then `gen-crd-api-reference-docs` executes
a [Go template](https://github.com/openshift/hypershift/blob/main/docs/api-doc-gen/templates/pkg.tpl)
which is provided with context about the processed Go packages. The output of
template execution is the `docs/content/reference/api.md` file, which contains the
API reference documentation content.

- To change documentation of specific API types, edit the [API Go type definitions](https://github.com/openshift/hypershift/tree/main/api).
- To change the structure of the API reference page itself, edit the `gen-crd-api-reference-docs`
  [Go templates](https://github.com/openshift/hypershift/blob/main/docs/api-doc-gen/templates).

To run the API reference docs generator, run the following from the HyperShift
Git repository root:

```shell
make api-docs
```
