# Load Balancer Service Annotations

| Annotation | Description |
| --- | --- |
| `service.kubernetes.io/ibm-load-balancer-cloud-provider-ip-type` | Request a `private` or `public` load balancer service IP address. If the annotation is not specified, the default is `public` when there is at least one node on the public network, otherwise the default is `private`. |
| `service.kubernetes.io/ibm-load-balancer-cloud-provider-zone` | Request a load balancer service IP address from the specified availability zone. If the annotation is not specified, then an IP address will be chosen from any availability zone. |
| `service.kubernetes.io/ibm-load-balancer-cloud-provider-vlan` | Request a load balancer service IP address from the specified VLAN. If the annotation is not specified, then an IP address will be chosen from any VLAN. |
| `service.kubernetes.io/ibm-ingress-controller-public` | Request a public load balancer service IP address reserved for the cluster's ingress controllers. If the annotation is not specified, then an unreserved IP address is selected. |
| `service.kubernetes.io/ibm-ingress-controller-private` | Request a private load balancer service IP address reserved for the cluster's ingress controllers. If the annotation is not specified, then an unreserved IP address is selected. |
| `service.kubernetes.io/ibm-load-balancer-cloud-provider-enable-features` | Request a version 2.0 load balancer service by specifying `ipvs` for the annotation value. Version 2.0 load balancer services require `spec.externalTrafficPolicy` to be set to `Local`. A version 1.0 load balancer service is the default. Request support for source IP preservation by using `proxy-protocol` for the annotation value. |
| `service.kubernetes.io/ibm-load-balancer-cloud-provider-ipvs-scheduler` | Specify the scheduling algorithm for a version 2.0 load balancer service. Accepted values are `rr` (default) for round robin or `sh` for source hashing. The round robin scheduling algorithm cycles through the list of app pods when routing connections to nodes, treating each app pod equally. For the source hashing scheduling algorithm, a hash key is generated based on the source IP address of the client request packet. The hash key is used to route the request to an app pod. This algorithm ensures that requests from a particular client are always directed to the same app pod. *Note:* Kubernetes uses iptables rules, which cause requests to be sent to a random pod on the worker. To use the source hashing scheduling algorithm, you must ensure that no more than one pod of your app is deployed per node by using pod anti-affinity. |
