/**
 * Copyright 2020 IBM Corp.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Package client_test ...
package client_test

import (
	"testing"

	"github.com/IBM/ibmcloud-volume-vpc/common/vpcclient/client"
	"github.com/stretchr/testify/assert"
)

func TestParams(t *testing.T) {
	params := client.Params{
		"key":         "value",
		"another-key": "another-value",
	}
	clone := params.Copy()

	assert.Equal(t, params, clone)
}
