// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package organizations

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opAcceptHandshake = "AcceptHandshake"

// AcceptHandshakeRequest generates a "aws/request.Request" representing the
// client's request for the AcceptHandshake operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AcceptHandshake for more information on using the AcceptHandshake
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AcceptHandshakeRequest method.
//    req, resp := client.AcceptHandshakeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/AcceptHandshake
func (c *Organizations) AcceptHandshakeRequest(input *AcceptHandshakeInput) (req *request.Request, output *AcceptHandshakeOutput) {
	op := &request.Operation{
		Name:       opAcceptHandshake,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AcceptHandshakeInput{}
	}

	output = &AcceptHandshakeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AcceptHandshake API operation for AWS Organizations.
//
// Sends a response to the originator of a handshake agreeing to the action
// proposed by the handshake request.
//
// This operation can be called only by the following principals when they also
// have the relevant IAM permissions:
//
//    * Invitation to join or Approve all features request handshakes: only
//    a principal from the member account. The user who calls the API for an
//    invitation to join must have the organizations:AcceptHandshake permission.
//    If you enabled all features in the organization, the user must also have
//    the iam:CreateServiceLinkedRole permission so that AWS Organizations can
//    create the required service-linked role named AWSServiceRoleForOrganizations.
//    For more information, see AWS Organizations and Service-Linked Roles (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_integration_services.html#orgs_integration_service-linked-roles)
//    in the AWS Organizations User Guide.
//
//    * Enable all features final confirmation handshake: only a principal from
//    the master account. For more information about invitations, see Inviting
//    an AWS Account to Join Your Organization (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_invites.html)
//    in the AWS Organizations User Guide. For more information about requests
//    to enable all features in the organization, see Enabling All Features
//    in Your Organization (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html)
//    in the AWS Organizations User Guide.
//
// After you accept a handshake, it continues to appear in the results of relevant
// APIs for only 30 days. After that, it's deleted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation AcceptHandshake for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * AWSOrganizationsNotInUseException
//   Your account isn't a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * HandshakeConstraintViolationException
//   The requested operation would violate the constraint identified in the reason
//   code.
//
//   Some of the reasons in the following list might not be applicable to this
//   specific API or operation:
//
//      * ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on
//      the number of accounts in an organization. Note that deleted and closed
//      accounts still count toward your limit. If you get this exception immediately
//      after creating the organization, wait one hour and try again. If after
//      an hour it continues to fail with this error, contact AWS Support (https://console.aws.amazon.com/support/home#/).
//
//      * ALREADY_IN_AN_ORGANIZATION: The handshake request is invalid because
//      the invited account is already a member of an organization.
//
//      * HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of
//      handshakes that you can send in one day.
//
//      * INVITE_DISABLED_DURING_ENABLE_ALL_FEATURES: You can't issue new invitations
//      to join an organization while it's in the process of enabling all features.
//      You can resume inviting accounts after you finalize the process when all
//      accounts have agreed to the change.
//
//      * ORGANIZATION_ALREADY_HAS_ALL_FEATURES: The handshake request is invalid
//      because the organization has already enabled all features.
//
//      * ORGANIZATION_FROM_DIFFERENT_SELLER_OF_RECORD: The request failed because
//      the account is from a different marketplace than the accounts in the organization.
//      For example, accounts with India addresses must be associated with the
//      AISPL marketplace. All accounts in an organization must be from the same
//      marketplace.
//
//      * ORGANIZATION_MEMBERSHIP_CHANGE_RATE_LIMIT_EXCEEDED: You attempted to
//      change the membership of an account too quickly after its previous change.
//
//      * PAYMENT_INSTRUMENT_REQUIRED: You can't complete the operation with an
//      account that doesn't have a payment instrument, such as a credit card,
//      associated with it.
//
//   * HandshakeNotFoundException
//   We can't find a handshake with the HandshakeId that you specified.
//
//   * InvalidHandshakeTransitionException
//   You can't perform the operation on the handshake in its current state. For
//   example, you can't cancel a handshake that was already accepted or accept
//   a handshake that was already declined.
//
//   * HandshakeAlreadyInStateException
//   The specified handshake is already in the requested state. For example, you
//   can't accept a handshake that was already accepted.
//
//   * InvalidInputException
//   The requested operation failed because you provided invalid values for one
//   or more of the request parameters. This exception includes a reason that
//   contains additional information about the violated limit:
//
//   Some of the reasons in the following list might not be applicable to this
//   specific API or operation.
//
//      * DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to
//      the same entity.
//
//      * IMMUTABLE_POLICY: You specified a policy that is managed by AWS and
//      can't be modified.
//
//      * INPUT_REQUIRED: You must include a value for all required parameters.
//
//      * INVALID_ENUM: You specified an invalid value.
//
//      * INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
//
//      * INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid
//      characters.
//
//      * INVALID_LIST_MEMBER: You provided a list to a parameter that contains
//      at least one invalid value.
//
//      * INVALID_PAGINATION_TOKEN: Get the value for the NextToken parameter
//      from the response to a previous call of the operation.
//
//      * INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account,
//      organization, or email) as a party.
//
//      * INVALID_PATTERN: You provided a value that doesn't match the required
//      pattern.
//
//      * INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't
//      match the required pattern.
//
//      * INVALID_ROLE_NAME: You provided a role name that isn't valid. A role
//      name can't begin with the reserved prefix AWSServiceRoleFor.
//
//      * INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource
//      Name (ARN) for the organization.
//
//      * INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
//
//      * INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system
//      tag. You can’t add, edit, or delete system tag keys because they're
//      reserved for AWS use. System tags don’t count against your tags per
//      resource limit.
//
//      * MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter
//      for the operation.
//
//      * MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer
//      than allowed.
//
//      * MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger
//      value than allowed.
//
//      * MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter
//      than allowed.
//
//      * MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller
//      value than allowed.
//
//      * MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only
//      between entities in the same root.
//
//      * TARGET_NOT_SUPPORTED: You can't perform the specified operation on that
//      target entity.
//
//      * UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that
//      isn't recognized.
//
//   * ConcurrentModificationException
//   The target of the operation is currently being modified by a different request.
//   Try again later.
//
//   * ServiceException
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * TooManyRequestsException
//   You have sent too many requests in too short a period of time. The quota
//   helps protect against denial-of-service attacks. Try again later.
//
//   For information about quotas that affect AWS Organizations, see Quotas for
//   AWS Organizations (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html)in
//   the AWS Organizations User Guide.
//
//   * AccessDeniedForDependencyException
//   The operation that you attempted requires you to have the iam:CreateServiceLinkedRole
//   for organizations.amazonaws.com permission so that AWS Organizations can
//   create the required service-linked role. You don't have that permission.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/AcceptHandshake
func (c *Organizations) AcceptHandshake(input *AcceptHandshakeInput) (*AcceptHandshakeOutput, error) {
	req, out := c.AcceptHandshakeRequest(input)
	return out, req.Send()
}

// AcceptHandshakeWithContext is the same as AcceptHandshake with the addition of
// the ability to pass a context and additional request options.
//
// See AcceptHandshake for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) AcceptHandshakeWithContext(ctx aws.Context, input *AcceptHandshakeInput, opts ...request.Option) (*AcceptHandshakeOutput, error) {
	req, out := c.AcceptHandshakeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAttachPolicy = "AttachPolicy"

// AttachPolicyRequest generates a "aws/request.Request" representing the
// client's request for the AttachPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AttachPolicy for more information on using the AttachPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AttachPolicyRequest method.
//    req, resp := client.AttachPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/AttachPolicy
func (c *Organizations) AttachPolicyRequest(input *AttachPolicyInput) (req *request.Request, output *AttachPolicyOutput) {
	op := &request.Operation{
		Name:       opAttachPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AttachPolicyInput{}
	}

	output = &AttachPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AttachPolicy API operation for AWS Organizations.
//
// Attaches a policy to a root, an organizational unit (OU), or an individual
// account. How the policy affects accounts depends on the type of policy. Refer
// to the AWS Organizations User Guide for information about each policy type:
//
//    * AISERVICES_OPT_OUT_POLICY (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html)
//
//    * BACKUP_POLICY (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html)
//
//    * SERVICE_CONTROL_POLICY (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html)
//
//    * TAG_POLICY (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html)
//
// This operation can be called only from the organization's master account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation AttachPolicy for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * AWSOrganizationsNotInUseException
//   Your account isn't a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * ConcurrentModificationException
//   The target of the operation is currently being modified by a different request.
//   Try again later.
//
//   * ConstraintViolationException
//   Performing this operation violates a minimum or maximum value limit. For
//   example, attempting to remove the last service control policy (SCP) from
//   an OU or root, inviting or creating too many accounts to the organization,
//   or attaching too many policies to an account, OU, or root. This exception
//   includes a reason that contains additional information about the violated
//   limit:
//
//   Some of the reasons in the following list might not be applicable to this
//   specific API or operation.
//
//      * ACCOUNT_CANNOT_LEAVE_ORGANIZAION: You attempted to remove the master
//      account from the organization. You can't remove the master account. Instead,
//      after you remove all member accounts, delete the organization itself.
//
//      * ACCOUNT_CANNOT_LEAVE_WITHOUT_EULA: You attempted to remove an account
//      from the organization that doesn't yet have enough information to exist
//      as a standalone account. This account requires you to first agree to the
//      AWS Customer Agreement. Follow the steps at Removing a member account
//      from your organization (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master)in
//      the AWS Organizations User Guide.
//
//      * ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove
//      an account from the organization that doesn't yet have enough information
//      to exist as a standalone account. This account requires you to first complete
//      phone verification. Follow the steps at Removing a member account from
//      your organization (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master)
//      in the AWS Organizations User Guide.
//
//      * ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number
//      of accounts that you can create in one day.
//
//      * ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on
//      the number of accounts in an organization. If you need more accounts,
//      contact AWS Support (https://console.aws.amazon.com/support/home#/) to
//      request an increase in your limit. Or the number of invitations that you
//      tried to send would cause you to exceed the limit of accounts in your
//      organization. Send fewer invitations or contact AWS Support to request
//      an increase in the number of accounts. Deleted and closed accounts still
//      count toward your limit. If you get this exception when running a command
//      immediately after creating the organization, wait one hour and try again.
//      After an hour, if the command continues to fail with this error, contact
//      AWS Support (https://console.aws.amazon.com/support/home#/).
//
//      * CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to
//      register the master account of the organization as a delegated administrator
//      for an AWS service integrated with Organizations. You can designate only
//      a member account as a delegated administrator.
//
//      * CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove
//      an account that is registered as a delegated administrator for a service
//      integrated with your organization. To complete this operation, you must
//      first deregister this account as a delegated administrator.
//
//      * CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an
//      organization in the specified region, you must enable all features mode.
//
//      * DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register
//      an AWS account as a delegated administrator for an AWS service that already
//      has a delegated administrator. To complete this operation, you must first
//      deregister any existing delegated administrators for this service.
//
//      * EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only
//      valid for a limited period of time. You must resubmit the request and
//      generate a new verfication code.
//
//      * HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of
//      handshakes that you can send in one day.
//
//      * MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account
//      in this organization, you first must migrate the organization's master
//      account to the marketplace that corresponds to the master account's address.
//      For example, accounts with India addresses must be associated with the
//      AISPL marketplace. All accounts in an organization must be associated
//      with the same marketplace.
//
//      * MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the AWS Regions
//      in China. To create an organization, the master must have an valid business
//      license. For more information, contact customer support.
//
//      * MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you
//      must first provide a valid contact address and phone number for the master
//      account. Then try the operation again.
//
//      * MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the
//      master account must have an associated account in the AWS GovCloud (US-West)
//      Region. For more information, see AWS Organizations (http://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html)
//      in the AWS GovCloud User Guide.
//
//      * MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization
//      with this master account, you first must associate a valid payment instrument,
//      such as a credit card, with the account. Follow the steps at To leave
//      an organization when all required account information has not yet been
//      provided (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info)
//      in the AWS Organizations User Guide.
//
//      * MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted
//      to register more delegated administrators than allowed for the service
//      principal.
//
//      * MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the
//      number of policies of a certain type that can be attached to an entity
//      at one time.
//
//      * MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed
//      on this resource.
//
//      * MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation
//      with this member account, you first must associate a valid payment instrument,
//      such as a credit card, with the account. Follow the steps at To leave
//      an organization when all required account information has not yet been
//      provided (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info)
//      in the AWS Organizations User Guide.
//
//      * MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a
//      policy from an entity that would cause the entity to have fewer than the
//      minimum number of policies of a certain type required.
//
//      * ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation
//      that requires the organization to be configured to support all features.
//      An organization that supports only consolidated billing features can't
//      perform this operation.
//
//      * OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is
//      too many levels deep.
//
//      * OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs
//      that you can have in an organization.
//
//      * POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that
//      is larger than the maximum size.
//
//      * POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of
//      policies that you can have in an organization.
//
//      * TAG_POLICY_VIOLATION: You attempted to create or update a resource with
//      tags that are not compliant with the tag policy requirements for this
//      account.
//
//   * DuplicatePolicyAttachmentException
//   The selected policy is already attached to the specified target.
//
//   * InvalidInputException
//   The requested operation failed because you provided invalid values for one
//   or more of the request parameters. This exception includes a reason that
//   contains additional information about the violated limit:
//
//   Some of the reasons in the following list might not be applicable to this
//   specific API or operation.
//
//      * DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to
//      the same entity.
//
//      * IMMUTABLE_POLICY: You specified a policy that is managed by AWS and
//      can't be modified.
//
//      * INPUT_REQUIRED: You must include a value for all required parameters.
//
//      * INVALID_ENUM: You specified an invalid value.
//
//      * INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
//
//      * INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid
//      characters.
//
//      * INVALID_LIST_MEMBER: You provided a list to a parameter that contains
//      at least one invalid value.
//
//      * INVALID_PAGINATION_TOKEN: Get the value for the NextToken parameter
//      from the response to a previous call of the operation.
//
//      * INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account,
//      organization, or email) as a party.
//
//      * INVALID_PATTERN: You provided a value that doesn't match the required
//      pattern.
//
//      * INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't
//      match the required pattern.
//
//      * INVALID_ROLE_NAME: You provided a role name that isn't valid. A role
//      name can't begin with the reserved prefix AWSServiceRoleFor.
//
//      * INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource
//      Name (ARN) for the organization.
//
//      * INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
//
//      * INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system
//      tag. You can’t add, edit, or delete system tag keys because they're
//      reserved for AWS use. System tags don’t count against your tags per
//      resource limit.
//
//      * MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter
//      for the operation.
//
//      * MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer
//      than allowed.
//
//      * MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger
//      value than allowed.
//
//      * MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter
//      than allowed.
//
//      * MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller
//      value than allowed.
//
//      * MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only
//      between entities in the same root.
//
//      * TARGET_NOT_SUPPORTED: You can't perform the specified operation on that
//      target entity.
//
//      * UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that
//      isn't recognized.
//
//   * PolicyNotFoundException
//   We can't find a policy with the PolicyId that you specified.
//
//   * PolicyTypeNotEnabledException
//   The specified policy type isn't currently enabled in this root. You can't
//   attach policies of the specified type to entities in a root until you enable
//   that type in the root. For more information, see Enabling All Features in
//   Your Organization (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html)
//   in the AWS Organizations User Guide.
//
//   * ServiceException
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * TargetNotFoundException
//   We can't find a root, OU, account, or policy with the TargetId that you specified.
//
//   * TooManyRequestsException
//   You have sent too many requests in too short a period of time. The quota
//   helps protect against denial-of-service attacks. Try again later.
//
//   For information about quotas that affect AWS Organizations, see Quotas for
//   AWS Organizations (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html)in
//   the AWS Organizations User Guide.
//
//   * UnsupportedAPIEndpointException
//   This action isn't available in the current AWS Region.
//
//   * PolicyChangesInProgressException
//   Changes to the effective policy are in progress, and its contents can't be
//   returned. Try the operation again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/AttachPolicy
func (c *Organizations) AttachPolicy(input *AttachPolicyInput) (*AttachPolicyOutput, error) {
	req, out := c.AttachPolicyRequest(input)
	return out, req.Send()
}

// AttachPolicyWithContext is the same as AttachPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See AttachPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) AttachPolicyWithContext(ctx aws.Context, input *AttachPolicyInput, opts ...request.Option) (*AttachPolicyOutput, error) {
	req, out := c.AttachPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelHandshake = "CancelHandshake"

// CancelHandshakeRequest generates a "aws/request.Request" representing the
// client's request for the CancelHandshake operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelHandshake for more information on using the CancelHandshake
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CancelHandshakeRequest method.
//    req, resp := client.CancelHandshakeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/CancelHandshake
func (c *Organizations) CancelHandshakeRequest(input *CancelHandshakeInput) (req *request.Request, output *CancelHandshakeOutput) {
	op := &request.Operation{
		Name:       opCancelHandshake,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelHandshakeInput{}
	}

	output = &CancelHandshakeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CancelHandshake API operation for AWS Organizations.
//
// Cancels a handshake. Canceling a handshake sets the handshake state to CANCELED.
//
// This operation can be called only from the account that originated the handshake.
// The recipient of the handshake can't cancel it, but can use DeclineHandshake
// instead. After a handshake is canceled, the recipient can no longer respond
// to that handshake.
//
// After you cancel a handshake, it continues to appear in the results of relevant
// APIs for only 30 days. After that, it's deleted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation CancelHandshake for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * ConcurrentModificationException
//   The target of the operation is currently being modified by a different request.
//   Try again later.
//
//   * HandshakeNotFoundException
//   We can't find a handshake with the HandshakeId that you specified.
//
//   * InvalidHandshakeTransitionException
//   You can't perform the operation on the handshake in its current state. For
//   example, you can't cancel a handshake that was already accepted or accept
//   a handshake that was already declined.
//
//   * HandshakeAlreadyInStateException
//   The specified handshake is already in the requested state. For example, you
//   can't accept a handshake that was already accepted.
//
//   * InvalidInputException
//   The requested operation failed because you provided invalid values for one
//   or more of the request parameters. This exception includes a reason that
//   contains additional information about the violated limit:
//
//   Some of the reasons in the following list might not be applicable to this
//   specific API or operation.
//
//      * DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to
//      the same entity.
//
//      * IMMUTABLE_POLICY: You specified a policy that is managed by AWS and
//      can't be modified.
//
//      * INPUT_REQUIRED: You must include a value for all required parameters.
//
//      * INVALID_ENUM: You specified an invalid value.
//
//      * INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
//
//      * INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid
//      characters.
//
//      * INVALID_LIST_MEMBER: You provided a list to a parameter that contains
//      at least one invalid value.
//
//      * INVALID_PAGINATION_TOKEN: Get the value for the NextToken parameter
//      from the response to a previous call of the operation.
//
//      * INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account,
//      organization, or email) as a party.
//
//      * INVALID_PATTERN: You provided a value that doesn't match the required
//      pattern.
//
//      * INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't
//      match the required pattern.
//
//      * INVALID_ROLE_NAME: You provided a role name that isn't valid. A role
//      name can't begin with the reserved prefix AWSServiceRoleFor.
//
//      * INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource
//      Name (ARN) for the organization.
//
//      * INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
//
//      * INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system
//      tag. You can’t add, edit, or delete system tag keys because they're
//      reserved for AWS use. System tags don’t count against your tags per
//      resource limit.
//
//      * MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter
//      for the operation.
//
//      * MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer
//      than allowed.
//
//      * MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger
//      value than allowed.
//
//      * MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter
//      than allowed.
//
//      * MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller
//      value than allowed.
//
//      * MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only
//      between entities in the same root.
//
//      * TARGET_NOT_SUPPORTED: You can't perform the specified operation on that
//      target entity.
//
//      * UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that
//      isn't recognized.
//
//   * ServiceException
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * TooManyRequestsException
//   You have sent too many requests in too short a period of time. The quota
//   helps protect against denial-of-service attacks. Try again later.
//
//   For information about quotas that affect AWS Organizations, see Quotas for
//   AWS Organizations (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html)in
//   the AWS Organizations User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/CancelHandshake
func (c *Organizations) CancelHandshake(input *CancelHandshakeInput) (*CancelHandshakeOutput, error) {
	req, out := c.CancelHandshakeRequest(input)
	return out, req.Send()
}

// CancelHandshakeWithContext is the same as CancelHandshake with the addition of
// the ability to pass a context and additional request options.
//
// See CancelHandshake for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) CancelHandshakeWithContext(ctx aws.Context, input *CancelHandshakeInput, opts ...request.Option) (*CancelHandshakeOutput, error) {
	req, out := c.CancelHandshakeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAccount = "CreateAccount"

// CreateAccountRequest generates a "aws/request.Request" representing the
// client's request for the CreateAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAccount for more information on using the CreateAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateAccountRequest method.
//    req, resp := client.CreateAccountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/CreateAccount
func (c *Organizations) CreateAccountRequest(input *CreateAccountInput) (req *request.Request, output *CreateAccountOutput) {
	op := &request.Operation{
		Name:       opCreateAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAccountInput{}
	}

	output = &CreateAccountOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAccount API operation for AWS Organizations.
//
// Creates an AWS account that is automatically a member of the organization
// whose credentials made the request. This is an asynchronous request that
// AWS performs in the background. Because CreateAccount operates asynchronously,
// it can return a successful completion message even though account initialization
// might still be in progress. You might need to wait a few minutes before you
// can successfully access the account. To check the status of the request,
// do one of the following:
//
//    * Use the OperationId response element from this operation to provide
//    as a parameter to the DescribeCreateAccountStatus operation.
//
//    * Check the AWS CloudTrail log for the CreateAccountResult event. For
//    information on using AWS CloudTrail with AWS Organizations, see Monitoring
//    the Activity in Your Organization (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_monitoring.html)
//    in the AWS Organizations User Guide.
//
// The user who calls the API to create an account must have the organizations:CreateAccount
// permission. If you enabled all features in the organization, AWS Organizations
// creates the required service-linked role named AWSServiceRoleForOrganizations.
// For more information, see AWS Organizations and Service-Linked Roles (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html#orgs_integrate_services-using_slrs)
// in the AWS Organizations User Guide.
//
// If the request includes tags, then the requester must have the organizations:TagResource
// permission.
//
// AWS Organizations preconfigures the new member account with a role (named
// OrganizationAccountAccessRole by default) that grants users in the master
// account administrator permissions in the new member account. Principals in
// the master account can assume the role. AWS Organizations clones the company
// name and address information for the new account from the organization's
// master account.
//
// This operation can be called only from the organization's master account.
//
// For more information about creating accounts, see Creating an AWS Account
// in Your Organization (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_create.html)
// in the AWS Organizations User Guide.
//
//    * When you create an account in an organization using the AWS Organizations
//    console, API, or CLI commands, the information required for the account
//    to operate as a standalone account, such as a payment method and signing
//    the end user license agreement (EULA) is not automatically collected.
//    If you must remove an account from your organization later, you can do
//    so only after you provide the missing information. Follow the steps at
//    To leave an organization as a member account (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info)
//    in the AWS Organizations User Guide.
//
//    * If you get an exception that indicates that you exceeded your account
//    limits for the organization, contact AWS Support (https://console.aws.amazon.com/support/home#/).
//
//    * If you get an exception that indicates that the operation failed because
//    your organization is still initializing, wait one hour and then try again.
//    If the error persists, contact AWS Support (https://console.aws.amazon.com/support/home#/).
//
//    * Using CreateAccount to create multiple temporary accounts isn't recommended.
//    You can only close an account from the Billing and Cost Management Console,
//    and you must be signed in as the root user. For information on the requirements
//    and process for closing an account, see Closing an AWS Account (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_close.html)
//    in the AWS Organizations User Guide.
//
// When you create a member account with this operation, you can choose whether
// to create the account with the IAM User and Role Access to Billing Information
// switch enabled. If you enable it, IAM users and roles that have appropriate
// permissions can view billing information for the account. If you disable
// it, only the account root user can access billing information. For information
// about how to disable this switch for an account, see Granting Access to Your
// Billing Information and Tools (https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/grantaccess.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation CreateAccount for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * AWSOrganizationsNotInUseException
//   Your account isn't a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * ConcurrentModificationException
//   The target of the operation is currently being modified by a different request.
//   Try again later.
//
//   * ConstraintViolationException
//   Performing this operation violates a minimum or maximum value limit. For
//   example, attempting to remove the last service control policy (SCP) from
//   an OU or root, inviting or creating too many accounts to the organization,
//   or attaching too many policies to an account, OU, or root. This exception
//   includes a reason that contains additional information about the violated
//   limit:
//
//   Some of the reasons in the following list might not be applicable to this
//   specific API or operation.
//
//      * ACCOUNT_CANNOT_LEAVE_ORGANIZAION: You attempted to remove the master
//      account from the organization. You can't remove the master account. Instead,
//      after you remove all member accounts, delete the organization itself.
//
//      * ACCOUNT_CANNOT_LEAVE_WITHOUT_EULA: You attempted to remove an account
//      from the organization that doesn't yet have enough information to exist
//      as a standalone account. This account requires you to first agree to the
//      AWS Customer Agreement. Follow the steps at Removing a member account
//      from your organization (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master)in
//      the AWS Organizations User Guide.
//
//      * ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove
//      an account from the organization that doesn't yet have enough information
//      to exist as a standalone account. This account requires you to first complete
//      phone verification. Follow the steps at Removing a member account from
//      your organization (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master)
//      in the AWS Organizations User Guide.
//
//      * ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number
//      of accounts that you can create in one day.
//
//      * ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on
//      the number of accounts in an organization. If you need more accounts,
//      contact AWS Support (https://console.aws.amazon.com/support/home#/) to
//      request an increase in your limit. Or the number of invitations that you
//      tried to send would cause you to exceed the limit of accounts in your
//      organization. Send fewer invitations or contact AWS Support to request
//      an increase in the number of accounts. Deleted and closed accounts still
//      count toward your limit. If you get this exception when running a command
//      immediately after creating the organization, wait one hour and try again.
//      After an hour, if the command continues to fail with this error, contact
//      AWS Support (https://console.aws.amazon.com/support/home#/).
//
//      * CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to
//      register the master account of the organization as a delegated administrator
//      for an AWS service integrated with Organizations. You can designate only
//      a member account as a delegated administrator.
//
//      * CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove
//      an account that is registered as a delegated administrator for a service
//      integrated with your organization. To complete this operation, you must
//      first deregister this account as a delegated administrator.
//
//      * CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an
//      organization in the specified region, you must enable all features mode.
//
//      * DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register
//      an AWS account as a delegated administrator for an AWS service that already
//      has a delegated administrator. To complete this operation, you must first
//      deregister any existing delegated administrators for this service.
//
//      * EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only
//      valid for a limited period of time. You must resubmit the request and
//      generate a new verfication code.
//
//      * HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of
//      handshakes that you can send in one day.
//
//      * MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account
//      in this organization, you first must migrate the organization's master
//      account to the marketplace that corresponds to the master account's address.
//      For example, accounts with India addresses must be associated with the
//      AISPL marketplace. All accounts in an organization must be associated
//      with the same marketplace.
//
//      * MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the AWS Regions
//      in China. To create an organization, the master must have an valid business
//      license. For more information, contact customer support.
//
//      * MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you
//      must first provide a valid contact address and phone number for the master
//      account. Then try the operation again.
//
//      * MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the
//      master account must have an associated account in the AWS GovCloud (US-West)
//      Region. For more information, see AWS Organizations (http://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html)
//      in the AWS GovCloud User Guide.
//
//      * MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization
//      with this master account, you first must associate a valid payment instrument,
//      such as a credit card, with the account. Follow the steps at To leave
//      an organization when all required account information has not yet been
//      provided (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info)
//      in the AWS Organizations User Guide.
//
//      * MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted
//      to register more delegated administrators than allowed for the service
//      principal.
//
//      * MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the
//      number of policies of a certain type that can be attached to an entity
//      at one time.
//
//      * MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed
//      on this resource.
//
//      * MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation
//      with this member account, you first must associate a valid payment instrument,
//      such as a credit card, with the account. Follow the steps at To leave
//      an organization when all required account information has not yet been
//      provided (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info)
//      in the AWS Organizations User Guide.
//
//      * MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a
//      policy from an entity that would cause the entity to have fewer than the
//      minimum number of policies of a certain type required.
//
//      * ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation
//      that requires the organization to be configured to support all features.
//      An organization that supports only consolidated billing features can't
//      perform this operation.
//
//      * OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is
//      too many levels deep.
//
//      * OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs
//      that you can have in an organization.
//
//      * POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that
//      is larger than the maximum size.
//
//      * POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of
//      policies that you can have in an organization.
//
//      * TAG_POLICY_VIOLATION: You attempted to create or update a resource with
//      tags that are not compliant with the tag policy requirements for this
//      account.
//
//   * InvalidInputException
//   The requested operation failed because you provided invalid values for one
//   or more of the request parameters. This exception includes a reason that
//   contains additional information about the violated limit:
//
//   Some of the reasons in the following list might not be applicable to this
//   specific API or operation.
//
//      * DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to
//      the same entity.
//
//      * IMMUTABLE_POLICY: You specified a policy that is managed by AWS and
//      can't be modified.
//
//      * INPUT_REQUIRED: You must include a value for all required parameters.
//
//      * INVALID_ENUM: You specified an invalid value.
//
//      * INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
//
//      * INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid
//      characters.
//
//      * INVALID_LIST_MEMBER: You provided a list to a parameter that contains
//      at least one invalid value.
//
//      * INVALID_PAGINATION_TOKEN: Get the value for the NextToken parameter
//      from the response to a previous call of the operation.
//
//      * INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account,
//      organization, or email) as a party.
//
//      * INVALID_PATTERN: You provided a value that doesn't match the required
//      pattern.
//
//      * INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't
//      match the required pattern.
//
//      * INVALID_ROLE_NAME: You provided a role name that isn't valid. A role
//      name can't begin with the reserved prefix AWSServiceRoleFor.
//
//      * INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource
//      Name (ARN) for the organization.
//
//      * INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
//
//      * INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system
//      tag. You can’t add, edit, or delete system tag keys because they're
//      reserved for AWS use. System tags don’t count against your tags per
//      resource limit.
//
//      * MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter
//      for the operation.
//
//      * MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer
//      than allowed.
//
//      * MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger
//      value than allowed.
//
//      * MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter
//      than allowed.
//
//      * MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller
//      value than allowed.
//
//      * MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only
//      between entities in the same root.
//
//      * TARGET_NOT_SUPPORTED: You can't perform the specified operation on that
//      target entity.
//
//      * UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that
//      isn't recognized.
//
//   * FinalizingOrganizationException
//   AWS Organizations couldn't perform the operation because your organization
//   hasn't finished initializing. This can take up to an hour. Try again later.
//   If after one hour you continue to receive this error, contact AWS Support
//   (https://console.aws.amazon.com/support/home#/).
//
//   * ServiceException
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * TooManyRequestsException
//   You have sent too many requests in too short a period of time. The quota
//   helps protect against denial-of-service attacks. Try again later.
//
//   For information about quotas that affect AWS Organizations, see Quotas for
//   AWS Organizations (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html)in
//   the AWS Organizations User Guide.
//
//   * UnsupportedAPIEndpointException
//   This action isn't available in the current AWS Region.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/CreateAccount
func (c *Organizations) CreateAccount(input *CreateAccountInput) (*CreateAccountOutput, error) {
	req, out := c.CreateAccountRequest(input)
	return out, req.Send()
}

// CreateAccountWithContext is the same as CreateAccount with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) CreateAccountWithContext(ctx aws.Context, input *CreateAccountInput, opts ...request.Option) (*CreateAccountOutput, error) {
	req, out := c.CreateAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateGovCloudAccount = "CreateGovCloudAccount"

// CreateGovCloudAccountRequest generates a "aws/request.Request" representing the
// client's request for the CreateGovCloudAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateGovCloudAccount for more information on using the CreateGovCloudAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateGovCloudAccountRequest method.
//    req, resp := client.CreateGovCloudAccountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/CreateGovCloudAccount
func (c *Organizations) CreateGovCloudAccountRequest(input *CreateGovCloudAccountInput) (req *request.Request, output *CreateGovCloudAccountOutput) {
	op := &request.Operation{
		Name:       opCreateGovCloudAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateGovCloudAccountInput{}
	}

	output = &CreateGovCloudAccountOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateGovCloudAccount API operation for AWS Organizations.
//
// This action is available if all of the following are true:
//
//    * You're authorized to create accounts in the AWS GovCloud (US) Region.
//    For more information on the AWS GovCloud (US) Region, see the AWS GovCloud
//    User Guide. (http://docs.aws.amazon.com/govcloud-us/latest/UserGuide/welcome.html)
//
//    * You already have an account in the AWS GovCloud (US) Region that is
//    associated with your master account in the commercial Region.
//
//    * You call this action from the master account of your organization in
//    the commercial Region.
//
//    * You have the organizations:CreateGovCloudAccount permission.
//
// AWS Organizations automatically creates the required service-linked role
// named AWSServiceRoleForOrganizations. For more information, see AWS Organizations
// and Service-Linked Roles (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html#orgs_integrate_services-using_slrs)
// in the AWS Organizations User Guide.
//
// AWS automatically enables AWS CloudTrail for AWS GovCloud (US) accounts,
// but you should also do the following:
//
//    * Verify that AWS CloudTrail is enabled to store logs.
//
//    * Create an S3 bucket for AWS CloudTrail log storage. For more information,
//    see Verifying AWS CloudTrail Is Enabled (http://docs.aws.amazon.com/govcloud-us/latest/UserGuide/verifying-cloudtrail.html)
//    in the AWS GovCloud User Guide.
//
// If the request includes tags, then the requester must have the organizations:TagResource
// permission. The tags are attached to the commercial account associated with
// the GovCloud account, rather than the GovCloud account itself. To add tags
// to the GovCloud account, call the TagResource operation in the GovCloud Region
// after the new GovCloud account exists.
//
// You call this action from the master account of your organization in the
// commercial Region to create a standalone AWS account in the AWS GovCloud
// (US) Region. After the account is created, the master account of an organization
// in the AWS GovCloud (US) Region can invite it to that organization. For more
// information on inviting standalone accounts in the AWS GovCloud (US) to join
// an organization, see AWS Organizations (http://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html)
// in the AWS GovCloud User Guide.
//
// Calling CreateGovCloudAccount is an asynchronous request that AWS performs
// in the background. Because CreateGovCloudAccount operates asynchronously,
// it can return a successful completion message even though account initialization
// might still be in progress. You might need to wait a few minutes before you
// can successfully access the account. To check the status of the request,
// do one of the following:
//
//    * Use the OperationId response element from this operation to provide
//    as a parameter to the DescribeCreateAccountStatus operation.
//
//    * Check the AWS CloudTrail log for the CreateAccountResult event. For
//    information on using AWS CloudTrail with Organizations, see Monitoring
//    the Activity in Your Organization (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_monitoring.html)
//    in the AWS Organizations User Guide.
//
// When you call the CreateGovCloudAccount action, you create two accounts:
// a standalone account in the AWS GovCloud (US) Region and an associated account
// in the commercial Region for billing and support purposes. The account in
// the commercial Region is automatically a member of the organization whose
// credentials made the request. Both accounts are associated with the same
// email address.
//
// A role is created in the new account in the commercial Region that allows
// the master account in the organization in the commercial Region to assume
// it. An AWS GovCloud (US) account is then created and associated with the
// commercial account that you just created. A role is also created in the new
// AWS GovCloud (US) account that can be assumed by the AWS GovCloud (US) account
// that is associated with the master account of the commercial organization.
// For more information and to view a diagram that explains how account access
// works, see AWS Organizations (http://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html)
// in the AWS GovCloud User Guide.
//
// For more information about creating accounts, see Creating an AWS Account
// in Your Organization (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_create.html)
// in the AWS Organizations User Guide.
//
//    * When you create an account in an organization using the AWS Organizations
//    console, API, or CLI commands, the information required for the account
//    to operate as a standalone account is not automatically collected. This
//    includes a payment method and signing the end user license agreement (EULA).
//    If you must remove an account from your organization later, you can do
//    so only after you provide the missing information. Follow the steps at
//    To leave an organization as a member account (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info)
//    in the AWS Organizations User Guide.
//
//    * If you get an exception that indicates that you exceeded your account
//    limits for the organization, contact AWS Support (https://console.aws.amazon.com/support/home#/).
//
//    * If you get an exception that indicates that the operation failed because
//    your organization is still initializing, wait one hour and then try again.
//    If the error persists, contact AWS Support (https://console.aws.amazon.com/support/home#/).
//
//    * Using CreateGovCloudAccount to create multiple temporary accounts isn't
//    recommended. You can only close an account from the AWS Billing and Cost
//    Management console, and you must be signed in as the root user. For information
//    on the requirements and process for closing an account, see Closing an
//    AWS Account (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_close.html)
//    in the AWS Organizations User Guide.
//
// When you create a member account with this operation, you can choose whether
// to create the account with the IAM User and Role Access to Billing Information
// switch enabled. If you enable it, IAM users and roles that have appropriate
// permissions can view billing information for the account. If you disable
// it, only the account root user can access billing information. For information
// about how to disable this switch for an account, see Granting Access to Your
// Billing Information and Tools (https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/grantaccess.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation CreateGovCloudAccount for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * AWSOrganizationsNotInUseException
//   Your account isn't a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * ConcurrentModificationException
//   The target of the operation is currently being modified by a different request.
//   Try again later.
//
//   * ConstraintViolationException
//   Performing this operation violates a minimum or maximum value limit. For
//   example, attempting to remove the last service control policy (SCP) from
//   an OU or root, inviting or creating too many accounts to the organization,
//   or attaching too many policies to an account, OU, or root. This exception
//   includes a reason that contains additional information about the violated
//   limit:
//
//   Some of the reasons in the following list might not be applicable to this
//   specific API or operation.
//
//      * ACCOUNT_CANNOT_LEAVE_ORGANIZAION: You attempted to remove the master
//      account from the organization. You can't remove the master account. Instead,
//      after you remove all member accounts, delete the organization itself.
//
//      * ACCOUNT_CANNOT_LEAVE_WITHOUT_EULA: You attempted to remove an account
//      from the organization that doesn't yet have enough information to exist
//      as a standalone account. This account requires you to first agree to the
//      AWS Customer Agreement. Follow the steps at Removing a member account
//      from your organization (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master)in
//      the AWS Organizations User Guide.
//
//      * ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove
//      an account from the organization that doesn't yet have enough information
//      to exist as a standalone account. This account requires you to first complete
//      phone verification. Follow the steps at Removing a member account from
//      your organization (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master)
//      in the AWS Organizations User Guide.
//
//      * ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number
//      of accounts that you can create in one day.
//
//      * ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on
//      the number of accounts in an organization. If you need more accounts,
//      contact AWS Support (https://console.aws.amazon.com/support/home#/) to
//      request an increase in your limit. Or the number of invitations that you
//      tried to send would cause you to exceed the limit of accounts in your
//      organization. Send fewer invitations or contact AWS Support to request
//      an increase in the number of accounts. Deleted and closed accounts still
//      count toward your limit. If you get this exception when running a command
//      immediately after creating the organization, wait one hour and try again.
//      After an hour, if the command continues to fail with this error, contact
//      AWS Support (https://console.aws.amazon.com/support/home#/).
//
//      * CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to
//      register the master account of the organization as a delegated administrator
//      for an AWS service integrated with Organizations. You can designate only
//      a member account as a delegated administrator.
//
//      * CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove
//      an account that is registered as a delegated administrator for a service
//      integrated with your organization. To complete this operation, you must
//      first deregister this account as a delegated administrator.
//
//      * CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an
//      organization in the specified region, you must enable all features mode.
//
//      * DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register
//      an AWS account as a delegated administrator for an AWS service that already
//      has a delegated administrator. To complete this operation, you must first
//      deregister any existing delegated administrators for this service.
//
//      * EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only
//      valid for a limited period of time. You must resubmit the request and
//      generate a new verfication code.
//
//      * HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of
//      handshakes that you can send in one day.
//
//      * MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account
//      in this organization, you first must migrate the organization's master
//      account to the marketplace that corresponds to the master account's address.
//      For example, accounts with India addresses must be associated with the
//      AISPL marketplace. All accounts in an organization must be associated
//      with the same marketplace.
//
//      * MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the AWS Regions
//      in China. To create an organization, the master must have an valid business
//      license. For more information, contact customer support.
//
//      * MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you
//      must first provide a valid contact address and phone number for the master
//      account. Then try the operation again.
//
//      * MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the
//      master account must have an associated account in the AWS GovCloud (US-West)
//      Region. For more information, see AWS Organizations (http://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html)
//      in the AWS GovCloud User Guide.
//
//      * MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization
//      with this master account, you first must associate a valid payment instrument,
//      such as a credit card, with the account. Follow the steps at To leave
//      an organization when all required account information has not yet been
//      provided (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info)
//      in the AWS Organizations User Guide.
//
//      * MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted
//      to register more delegated administrators than allowed for the service
//      principal.
//
//      * MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the
//      number of policies of a certain type that can be attached to an entity
//      at one time.
//
//      * MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed
//      on this resource.
//
//      * MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation
//      with this member account, you first must associate a valid payment instrument,
//      such as a credit card, with the account. Follow the steps at To leave
//      an organization when all required account information has not yet been
//      provided (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info)
//      in the AWS Organizations User Guide.
//
//      * MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a
//      policy from an entity that would cause the entity to have fewer than the
//      minimum number of policies of a certain type required.
//
//      * ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation
//      that requires the organization to be configured to support all features.
//      An organization that supports only consolidated billing features can't
//      perform this operation.
//
//      * OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is
//      too many levels deep.
//
//      * OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs
//      that you can have in an organization.
//
//      * POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that
//      is larger than the maximum size.
//
//      * POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of
//      policies that you can have in an organization.
//
//      * TAG_POLICY_VIOLATION: You attempted to create or update a resource with
//      tags that are not compliant with the tag policy requirements for this
//      account.
//
//   * InvalidInputException
//   The requested operation failed because you provided invalid values for one
//   or more of the request parameters. This exception includes a reason that
//   contains additional information about the violated limit:
//
//   Some of the reasons in the following list might not be applicable to this
//   specific API or operation.
//
//      * DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to
//      the same entity.
//
//      * IMMUTABLE_POLICY: You specified a policy that is managed by AWS and
//      can't be modified.
//
//      * INPUT_REQUIRED: You must include a value for all required parameters.
//
//      * INVALID_ENUM: You specified an invalid value.
//
//      * INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
//
//      * INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid
//      characters.
//
//      * INVALID_LIST_MEMBER: You provided a list to a parameter that contains
//      at least one invalid value.
//
//      * INVALID_PAGINATION_TOKEN: Get the value for the NextToken parameter
//      from the response to a previous call of the operation.
//
//      * INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account,
//      organization, or email) as a party.
//
//      * INVALID_PATTERN: You provided a value that doesn't match the required
//      pattern.
//
//      * INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't
//      match the required pattern.
//
//      * INVALID_ROLE_NAME: You provided a role name that isn't valid. A role
//      name can't begin with the reserved prefix AWSServiceRoleFor.
//
//      * INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource
//      Name (ARN) for the organization.
//
//      * INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
//
//      * INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system
//      tag. You can’t add, edit, or delete system tag keys because they're
//      reserved for AWS use. System tags don’t count against your tags per
//      resource limit.
//
//      * MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter
//      for the operation.
//
//      * MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer
//      than allowed.
//
//      * MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger
//      value than allowed.
//
//      * MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter
//      than allowed.
//
//      * MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller
//      value than allowed.
//
//      * MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only
//      between entities in the same root.
//
//      * TARGET_NOT_SUPPORTED: You can't perform the specified operation on that
//      target entity.
//
//      * UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that
//      isn't recognized.
//
//   * FinalizingOrganizationException
//   AWS Organizations couldn't perform the operation because your organization
//   hasn't finished initializing. This can take up to an hour. Try again later.
//   If after one hour you continue to receive this error, contact AWS Support
//   (https://console.aws.amazon.com/support/home#/).
//
//   * ServiceException
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * TooManyRequestsException
//   You have sent too many requests in too short a period of time. The quota
//   helps protect against denial-of-service attacks. Try again later.
//
//   For information about quotas that affect AWS Organizations, see Quotas for
//   AWS Organizations (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html)in
//   the AWS Organizations User Guide.
//
//   * UnsupportedAPIEndpointException
//   This action isn't available in the current AWS Region.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/CreateGovCloudAccount
func (c *Organizations) CreateGovCloudAccount(input *CreateGovCloudAccountInput) (*CreateGovCloudAccountOutput, error) {
	req, out := c.CreateGovCloudAccountRequest(input)
	return out, req.Send()
}

// CreateGovCloudAccountWithContext is the same as CreateGovCloudAccount with the addition of
// the ability to pass a context and additional request options.
//
// See CreateGovCloudAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) CreateGovCloudAccountWithContext(ctx aws.Context, input *CreateGovCloudAccountInput, opts ...request.Option) (*CreateGovCloudAccountOutput, error) {
	req, out := c.CreateGovCloudAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateOrganization = "CreateOrganization"

// CreateOrganizationRequest generates a "aws/request.Request" representing the
// client's request for the CreateOrganization operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateOrganization for more information on using the CreateOrganization
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateOrganizationRequest method.
//    req, resp := client.CreateOrganizationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/CreateOrganization
func (c *Organizations) CreateOrganizationRequest(input *CreateOrganizationInput) (req *request.Request, output *CreateOrganizationOutput) {
	op := &request.Operation{
		Name:       opCreateOrganization,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateOrganizationInput{}
	}

	output = &CreateOrganizationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateOrganization API operation for AWS Organizations.
//
// Creates an AWS organization. The account whose user is calling the CreateOrganization
// operation automatically becomes the master account (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account)
// of the new organization.
//
// This operation must be called using credentials from the account that is
// to become the new organization's master account. The principal must also
// have the relevant IAM permissions.
//
// By default (or if you set the FeatureSet parameter to ALL), the new organization
// is created with all features enabled and service control policies automatically
// enabled in the root. If you instead choose to create the organization supporting
// only the consolidated billing features by setting the FeatureSet parameter
// to CONSOLIDATED_BILLING", no policy types are enabled by default, and you
// can't use organization policies
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation CreateOrganization for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * AlreadyInOrganizationException
//   This account is already a member of an organization. An account can belong
//   to only one organization at a time.
//
//   * ConcurrentModificationException
//   The target of the operation is currently being modified by a different request.
//   Try again later.
//
//   * ConstraintViolationException
//   Performing this operation violates a minimum or maximum value limit. For
//   example, attempting to remove the last service control policy (SCP) from
//   an OU or root, inviting or creating too many accounts to the organization,
//   or attaching too many policies to an account, OU, or root. This exception
//   includes a reason that contains additional information about the violated
//   limit:
//
//   Some of the reasons in the following list might not be applicable to this
//   specific API or operation.
//
//      * ACCOUNT_CANNOT_LEAVE_ORGANIZAION: You attempted to remove the master
//      account from the organization. You can't remove the master account. Instead,
//      after you remove all member accounts, delete the organization itself.
//
//      * ACCOUNT_CANNOT_LEAVE_WITHOUT_EULA: You attempted to remove an account
//      from the organization that doesn't yet have enough information to exist
//      as a standalone account. This account requires you to first agree to the
//      AWS Customer Agreement. Follow the steps at Removing a member account
//      from your organization (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master)in
//      the AWS Organizations User Guide.
//
//      * ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove
//      an account from the organization that doesn't yet have enough information
//      to exist as a standalone account. This account requires you to first complete
//      phone verification. Follow the steps at Removing a member account from
//      your organization (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master)
//      in the AWS Organizations User Guide.
//
//      * ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number
//      of accounts that you can create in one day.
//
//      * ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on
//      the number of accounts in an organization. If you need more accounts,
//      contact AWS Support (https://console.aws.amazon.com/support/home#/) to
//      request an increase in your limit. Or the number of invitations that you
//      tried to send would cause you to exceed the limit of accounts in your
//      organization. Send fewer invitations or contact AWS Support to request
//      an increase in the number of accounts. Deleted and closed accounts still
//      count toward your limit. If you get this exception when running a command
//      immediately after creating the organization, wait one hour and try again.
//      After an hour, if the command continues to fail with this error, contact
//      AWS Support (https://console.aws.amazon.com/support/home#/).
//
//      * CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to
//      register the master account of the organization as a delegated administrator
//      for an AWS service integrated with Organizations. You can designate only
//      a member account as a delegated administrator.
//
//      * CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove
//      an account that is registered as a delegated administrator for a service
//      integrated with your organization. To complete this operation, you must
//      first deregister this account as a delegated administrator.
//
//      * CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an
//      organization in the specified region, you must enable all features mode.
//
//      * DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register
//      an AWS account as a delegated administrator for an AWS service that already
//      has a delegated administrator. To complete this operation, you must first
//      deregister any existing delegated administrators for this service.
//
//      * EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only
//      valid for a limited period of time. You must resubmit the request and
//      generate a new verfication code.
//
//      * HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of
//      handshakes that you can send in one day.
//
//      * MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account
//      in this organization, you first must migrate the organization's master
//      account to the marketplace that corresponds to the master account's address.
//      For example, accounts with India addresses must be associated with the
//      AISPL marketplace. All accounts in an organization must be associated
//      with the same marketplace.
//
//      * MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the AWS Regions
//      in China. To create an organization, the master must have an valid business
//      license. For more information, contact customer support.
//
//      * MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you
//      must first provide a valid contact address and phone number for the master
//      account. Then try the operation again.
//
//      * MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the
//      master account must have an associated account in the AWS GovCloud (US-West)
//      Region. For more information, see AWS Organizations (http://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html)
//      in the AWS GovCloud User Guide.
//
//      * MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization
//      with this master account, you first must associate a valid payment instrument,
//      such as a credit card, with the account. Follow the steps at To leave
//      an organization when all required account information has not yet been
//      provided (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info)
//      in the AWS Organizations User Guide.
//
//      * MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted
//      to register more delegated administrators than allowed for the service
//      principal.
//
//      * MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the
//      number of policies of a certain type that can be attached to an entity
//      at one time.
//
//      * MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed
//      on this resource.
//
//      * MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation
//      with this member account, you first must associate a valid payment instrument,
//      such as a credit card, with the account. Follow the steps at To leave
//      an organization when all required account information has not yet been
//      provided (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info)
//      in the AWS Organizations User Guide.
//
//      * MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a
//      policy from an entity that would cause the entity to have fewer than the
//      minimum number of policies of a certain type required.
//
//      * ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation
//      that requires the organization to be configured to support all features.
//      An organization that supports only consolidated billing features can't
//      perform this operation.
//
//      * OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is
//      too many levels deep.
//
//      * OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs
//      that you can have in an organization.
//
//      * POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that
//      is larger than the maximum size.
//
//      * POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of
//      policies that you can have in an organization.
//
//      * TAG_POLICY_VIOLATION: You attempted to create or update a resource with
//      tags that are not compliant with the tag policy requirements for this
//      account.
//
//   * InvalidInputException
//   The requested operation failed because you provided invalid values for one
//   or more of the request parameters. This exception includes a reason that
//   contains additional information about the violated limit:
//
//   Some of the reasons in the following list might not be applicable to this
//   specific API or operation.
//
//      * DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to
//      the same entity.
//
//      * IMMUTABLE_POLICY: You specified a policy that is managed by AWS and
//      can't be modified.
//
//      * INPUT_REQUIRED: You must include a value for all required parameters.
//
//      * INVALID_ENUM: You specified an invalid value.
//
//      * INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
//
//      * INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid
//      characters.
//
//      * INVALID_LIST_MEMBER: You provided a list to a parameter that contains
//      at least one invalid value.
//
//      * INVALID_PAGINATION_TOKEN: Get the value for the NextToken parameter
//      from the response to a previous call of the operation.
//
//      * INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account,
//      organization, or email) as a party.
//
//      * INVALID_PATTERN: You provided a value that doesn't match the required
//      pattern.
//
//      * INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't
//      match the required pattern.
//
//      * INVALID_ROLE_NAME: You provided a role name that isn't valid. A role
//      name can't begin with the reserved prefix AWSServiceRoleFor.
//
//      * INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource
//      Name (ARN) for the organization.
//
//      * INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
//
//      * INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system
//      tag. You can’t add, edit, or delete system tag keys because they're
//      reserved for AWS use. System tags don’t count against your tags per
//      resource limit.
//
//      * MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter
//      for the operation.
//
//      * MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer
//      than allowed.
//
//      * MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger
//      value than allowed.
//
//      * MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter
//      than allowed.
//
//      * MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller
//      value than allowed.
//
//      * MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only
//      between entities in the same root.
//
//      * TARGET_NOT_SUPPORTED: You can't perform the specified operation on that
//      target entity.
//
//      * UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that
//      isn't recognized.
//
//   * ServiceException
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * TooManyRequestsException
//   You have sent too many requests in too short a period of time. The quota
//   helps protect against denial-of-service attacks. Try again later.
//
//   For information about quotas that affect AWS Organizations, see Quotas for
//   AWS Organizations (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html)in
//   the AWS Organizations User Guide.
//
//   * AccessDeniedForDependencyException
//   The operation that you attempted requires you to have the iam:CreateServiceLinkedRole
//   for organizations.amazonaws.com permission so that AWS Organizations can
//   create the required service-linked role. You don't have that permission.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/CreateOrganization
func (c *Organizations) CreateOrganization(input *CreateOrganizationInput) (*CreateOrganizationOutput, error) {
	req, out := c.CreateOrganizationRequest(input)
	return out, req.Send()
}

// CreateOrganizationWithContext is the same as CreateOrganization with the addition of
// the ability to pass a context and additional request options.
//
// See CreateOrganization for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) CreateOrganizationWithContext(ctx aws.Context, input *CreateOrganizationInput, opts ...request.Option) (*CreateOrganizationOutput, error) {
	req, out := c.CreateOrganizationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateOrganizationalUnit = "CreateOrganizationalUnit"

// CreateOrganizationalUnitRequest generates a "aws/request.Request" representing the
// client's request for the CreateOrganizationalUnit operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateOrganizationalUnit for more information on using the CreateOrganizationalUnit
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateOrganizationalUnitRequest method.
//    req, resp := client.CreateOrganizationalUnitRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/CreateOrganizationalUnit
func (c *Organizations) CreateOrganizationalUnitRequest(input *CreateOrganizationalUnitInput) (req *request.Request, output *CreateOrganizationalUnitOutput) {
	op := &request.Operation{
		Name:       opCreateOrganizationalUnit,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateOrganizationalUnitInput{}
	}

	output = &CreateOrganizationalUnitOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateOrganizationalUnit API operation for AWS Organizations.
//
// Creates an organizational unit (OU) within a root or parent OU. An OU is
// a container for accounts that enables you to organize your accounts to apply
// policies according to your business requirements. The number of levels deep
// that you can nest OUs is dependent upon the policy types enabled for that
// root. For service control policies, the limit is five.
//
// For more information about OUs, see Managing Organizational Units (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_ous.html)
// in the AWS Organizations User Guide.
//
// If the request includes tags, then the requester must have the organizations:TagResource
// permission.
//
// This operation can be called only from the organization's master account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation CreateOrganizationalUnit for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * AWSOrganizationsNotInUseException
//   Your account isn't a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * ConcurrentModificationException
//   The target of the operation is currently being modified by a different request.
//   Try again later.
//
//   * ConstraintViolationException
//   Performing this operation violates a minimum or maximum value limit. For
//   example, attempting to remove the last service control policy (SCP) from
//   an OU or root, inviting or creating too many accounts to the organization,
//   or attaching too many policies to an account, OU, or root. This exception
//   includes a reason that contains additional information about the violated
//   limit:
//
//   Some of the reasons in the following list might not be applicable to this
//   specific API or operation.
//
//      * ACCOUNT_CANNOT_LEAVE_ORGANIZAION: You attempted to remove the master
//      account from the organization. You can't remove the master account. Instead,
//      after you remove all member accounts, delete the organization itself.
//
//      * ACCOUNT_CANNOT_LEAVE_WITHOUT_EULA: You attempted to remove an account
//      from the organization that doesn't yet have enough information to exist
//      as a standalone account. This account requires you to first agree to the
//      AWS Customer Agreement. Follow the steps at Removing a member account
//      from your organization (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master)in
//      the AWS Organizations User Guide.
//
//      * ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove
//      an account from the organization that doesn't yet have enough information
//      to exist as a standalone account. This account requires you to first complete
//      phone verification. Follow the steps at Removing a member account from
//      your organization (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master)
//      in the AWS Organizations User Guide.
//
//      * ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number
//      of accounts that you can create in one day.
//
//      * ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on
//      the number of accounts in an organization. If you need more accounts,
//      contact AWS Support (https://console.aws.amazon.com/support/home#/) to
//      request an increase in your limit. Or the number of invitations that you
//      tried to send would cause you to exceed the limit of accounts in your
//      organization. Send fewer invitations or contact AWS Support to request
//      an increase in the number of accounts. Deleted and closed accounts still
//      count toward your limit. If you get this exception when running a command
//      immediately after creating the organization, wait one hour and try again.
//      After an hour, if the command continues to fail with this error, contact
//      AWS Support (https://console.aws.amazon.com/support/home#/).
//
//      * CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to
//      register the master account of the organization as a delegated administrator
//      for an AWS service integrated with Organizations. You can designate only
//      a member account as a delegated administrator.
//
//      * CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove
//      an account that is registered as a delegated administrator for a service
//      integrated with your organization. To complete this operation, you must
//      first deregister this account as a delegated administrator.
//
//      * CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an
//      organization in the specified region, you must enable all features mode.
//
//      * DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register
//      an AWS account as a delegated administrator for an AWS service that already
//      has a delegated administrator. To complete this operation, you must first
//      deregister any existing delegated administrators for this service.
//
//      * EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only
//      valid for a limited period of time. You must resubmit the request and
//      generate a new verfication code.
//
//      * HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of
//      handshakes that you can send in one day.
//
//      * MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account
//      in this organization, you first must migrate the organization's master
//      account to the marketplace that corresponds to the master account's address.
//      For example, accounts with India addresses must be associated with the
//      AISPL marketplace. All accounts in an organization must be associated
//      with the same marketplace.
//
//      * MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the AWS Regions
//      in China. To create an organization, the master must have an valid business
//      license. For more information, contact customer support.
//
//      * MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you
//      must first provide a valid contact address and phone number for the master
//      account. Then try the operation again.
//
//      * MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the
//      master account must have an associated account in the AWS GovCloud (US-West)
//      Region. For more information, see AWS Organizations (http://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html)
//      in the AWS GovCloud User Guide.
//
//      * MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization
//      with this master account, you first must associate a valid payment instrument,
//      such as a credit card, with the account. Follow the steps at To leave
//      an organization when all required account information has not yet been
//      provided (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info)
//      in the AWS Organizations User Guide.
//
//      * MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted
//      to register more delegated administrators than allowed for the service
//      principal.
//
//      * MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the
//      number of policies of a certain type that can be attached to an entity
//      at one time.
//
//      * MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed
//      on this resource.
//
//      * MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation
//      with this member account, you first must associate a valid payment instrument,
//      such as a credit card, with the account. Follow the steps at To leave
//      an organization when all required account information has not yet been
//      provided (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info)
//      in the AWS Organizations User Guide.
//
//      * MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a
//      policy from an entity that would cause the entity to have fewer than the
//      minimum number of policies of a certain type required.
//
//      * ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation
//      that requires the organization to be configured to support all features.
//      An organization that supports only consolidated billing features can't
//      perform this operation.
//
//      * OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is
//      too many levels deep.
//
//      * OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs
//      that you can have in an organization.
//
//      * POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that
//      is larger than the maximum size.
//
//      * POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of
//      policies that you can have in an organization.
//
//      * TAG_POLICY_VIOLATION: You attempted to create or update a resource with
//      tags that are not compliant with the tag policy requirements for this
//      account.
//
//   * DuplicateOrganizationalUnitException
//   An OU with the same name already exists.
//
//   * InvalidInputException
//   The requested operation failed because you provided invalid values for one
//   or more of the request parameters. This exception includes a reason that
//   contains additional information about the violated limit:
//
//   Some of the reasons in the following list might not be applicable to this
//   specific API or operation.
//
//      * DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to
//      the same entity.
//
//      * IMMUTABLE_POLICY: You specified a policy that is managed by AWS and
//      can't be modified.
//
//      * INPUT_REQUIRED: You must include a value for all required parameters.
//
//      * INVALID_ENUM: You specified an invalid value.
//
//      * INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
//
//      * INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid
//      characters.
//
//      * INVALID_LIST_MEMBER: You provided a list to a parameter that contains
//      at least one invalid value.
//
//      * INVALID_PAGINATION_TOKEN: Get the value for the NextToken parameter
//      from the response to a previous call of the operation.
//
//      * INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account,
//      organization, or email) as a party.
//
//      * INVALID_PATTERN: You provided a value that doesn't match the required
//      pattern.
//
//      * INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't
//      match the required pattern.
//
//      * INVALID_ROLE_NAME: You provided a role name that isn't valid. A role
//      name can't begin with the reserved prefix AWSServiceRoleFor.
//
//      * INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource
//      Name (ARN) for the organization.
//
//      * INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
//
//      * INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system
//      tag. You can’t add, edit, or delete system tag keys because they're
//      reserved for AWS use. System tags don’t count against your tags per
//      resource limit.
//
//      * MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter
//      for the operation.
//
//      * MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer
//      than allowed.
//
//      * MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger
//      value than allowed.
//
//      * MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter
//      than allowed.
//
//      * MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller
//      value than allowed.
//
//      * MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only
//      between entities in the same root.
//
//      * TARGET_NOT_SUPPORTED: You can't perform the specified operation on that
//      target entity.
//
//      * UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that
//      isn't recognized.
//
//   * ParentNotFoundException
//   We can't find a root or OU with the ParentId that you specified.
//
//   * ServiceException
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * TooManyRequestsException
//   You have sent too many requests in too short a period of time. The quota
//   helps protect against denial-of-service attacks. Try again later.
//
//   For information about quotas that affect AWS Organizations, see Quotas for
//   AWS Organizations (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html)in
//   the AWS Organizations User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/CreateOrganizationalUnit
func (c *Organizations) CreateOrganizationalUnit(input *CreateOrganizationalUnitInput) (*CreateOrganizationalUnitOutput, error) {
	req, out := c.CreateOrganizationalUnitRequest(input)
	return out, req.Send()
}

// CreateOrganizationalUnitWithContext is the same as CreateOrganizationalUnit with the addition of
// the ability to pass a context and additional request options.
//
// See CreateOrganizationalUnit for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) CreateOrganizationalUnitWithContext(ctx aws.Context, input *CreateOrganizationalUnitInput, opts ...request.Option) (*CreateOrganizationalUnitOutput, error) {
	req, out := c.CreateOrganizationalUnitRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePolicy = "CreatePolicy"

// CreatePolicyRequest generates a "aws/request.Request" representing the
// client's request for the CreatePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePolicy for more information on using the CreatePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreatePolicyRequest method.
//    req, resp := client.CreatePolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/CreatePolicy
func (c *Organizations) CreatePolicyRequest(input *CreatePolicyInput) (req *request.Request, output *CreatePolicyOutput) {
	op := &request.Operation{
		Name:       opCreatePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreatePolicyInput{}
	}

	output = &CreatePolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePolicy API operation for AWS Organizations.
//
// Creates a policy of a specified type that you can attach to a root, an organizational
// unit (OU), or an individual AWS account.
//
// For more information about policies and their use, see Managing Organization
// Policies (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies.html).
//
// If the request includes tags, then the requester must have the organizations:TagResource
// permission.
//
// This operation can be called only from the organization's master account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation CreatePolicy for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * AWSOrganizationsNotInUseException
//   Your account isn't a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * ConcurrentModificationException
//   The target of the operation is currently being modified by a different request.
//   Try again later.
//
//   * ConstraintViolationException
//   Performing this operation violates a minimum or maximum value limit. For
//   example, attempting to remove the last service control policy (SCP) from
//   an OU or root, inviting or creating too many accounts to the organization,
//   or attaching too many policies to an account, OU, or root. This exception
//   includes a reason that contains additional information about the violated
//   limit:
//
//   Some of the reasons in the following list might not be applicable to this
//   specific API or operation.
//
//      * ACCOUNT_CANNOT_LEAVE_ORGANIZAION: You attempted to remove the master
//      account from the organization. You can't remove the master account. Instead,
//      after you remove all member accounts, delete the organization itself.
//
//      * ACCOUNT_CANNOT_LEAVE_WITHOUT_EULA: You attempted to remove an account
//      from the organization that doesn't yet have enough information to exist
//      as a standalone account. This account requires you to first agree to the
//      AWS Customer Agreement. Follow the steps at Removing a member account
//      from your organization (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master)in
//      the AWS Organizations User Guide.
//
//      * ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove
//      an account from the organization that doesn't yet have enough information
//      to exist as a standalone account. This account requires you to first complete
//      phone verification. Follow the steps at Removing a member account from
//      your organization (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master)
//      in the AWS Organizations User Guide.
//
//      * ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number
//      of accounts that you can create in one day.
//
//      * ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on
//      the number of accounts in an organization. If you need more accounts,
//      contact AWS Support (https://console.aws.amazon.com/support/home#/) to
//      request an increase in your limit. Or the number of invitations that you
//      tried to send would cause you to exceed the limit of accounts in your
//      organization. Send fewer invitations or contact AWS Support to request
//      an increase in the number of accounts. Deleted and closed accounts still
//      count toward your limit. If you get this exception when running a command
//      immediately after creating the organization, wait one hour and try again.
//      After an hour, if the command continues to fail with this error, contact
//      AWS Support (https://console.aws.amazon.com/support/home#/).
//
//      * CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to
//      register the master account of the organization as a delegated administrator
//      for an AWS service integrated with Organizations. You can designate only
//      a member account as a delegated administrator.
//
//      * CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove
//      an account that is registered as a delegated administrator for a service
//      integrated with your organization. To complete this operation, you must
//      first deregister this account as a delegated administrator.
//
//      * CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an
//      organization in the specified region, you must enable all features mode.
//
//      * DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register
//      an AWS account as a delegated administrator for an AWS service that already
//      has a delegated administrator. To complete this operation, you must first
//      deregister any existing delegated administrators for this service.
//
//      * EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only
//      valid for a limited period of time. You must resubmit the request and
//      generate a new verfication code.
//
//      * HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of
//      handshakes that you can send in one day.
//
//      * MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account
//      in this organization, you first must migrate the organization's master
//      account to the marketplace that corresponds to the master account's address.
//      For example, accounts with India addresses must be associated with the
//      AISPL marketplace. All accounts in an organization must be associated
//      with the same marketplace.
//
//      * MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the AWS Regions
//      in China. To create an organization, the master must have an valid business
//      license. For more information, contact customer support.
//
//      * MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you
//      must first provide a valid contact address and phone number for the master
//      account. Then try the operation again.
//
//      * MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the
//      master account must have an associated account in the AWS GovCloud (US-West)
//      Region. For more information, see AWS Organizations (http://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html)
//      in the AWS GovCloud User Guide.
//
//      * MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization
//      with this master account, you first must associate a valid payment instrument,
//      such as a credit card, with the account. Follow the steps at To leave
//      an organization when all required account information has not yet been
//      provided (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info)
//      in the AWS Organizations User Guide.
//
//      * MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted
//      to register more delegated administrators than allowed for the service
//      principal.
//
//      * MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the
//      number of policies of a certain type that can be attached to an entity
//      at one time.
//
//      * MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed
//      on this resource.
//
//      * MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation
//      with this member account, you first must associate a valid payment instrument,
//      such as a credit card, with the account. Follow the steps at To leave
//      an organization when all required account information has not yet been
//      provided (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info)
//      in the AWS Organizations User Guide.
//
//      * MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a
//      policy from an entity that would cause the entity to have fewer than the
//      minimum number of policies of a certain type required.
//
//      * ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation
//      that requires the organization to be configured to support all features.
//      An organization that supports only consolidated billing features can't
//      perform this operation.
//
//      * OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is
//      too many levels deep.
//
//      * OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs
//      that you can have in an organization.
//
//      * POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that
//      is larger than the maximum size.
//
//      * POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of
//      policies that you can have in an organization.
//
//      * TAG_POLICY_VIOLATION: You attempted to create or update a resource with
//      tags that are not compliant with the tag policy requirements for this
//      account.
//
//   * DuplicatePolicyException
//   A policy with the same name already exists.
//
//   * InvalidInputException
//   The requested operation failed because you provided invalid values for one
//   or more of the request parameters. This exception includes a reason that
//   contains additional information about the violated limit:
//
//   Some of the reasons in the following list might not be applicable to this
//   specific API or operation.
//
//      * DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to
//      the same entity.
//
//      * IMMUTABLE_POLICY: You specified a policy that is managed by AWS and
//      can't be modified.
//
//      * INPUT_REQUIRED: You must include a value for all required parameters.
//
//      * INVALID_ENUM: You specified an invalid value.
//
//      * INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
//
//      * INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid
//      characters.
//
//      * INVALID_LIST_MEMBER: You provided a list to a parameter that contains
//      at least one invalid value.
//
//      * INVALID_PAGINATION_TOKEN: Get the value for the NextToken parameter
//      from the response to a previous call of the operation.
//
//      * INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account,
//      organization, or email) as a party.
//
//      * INVALID_PATTERN: You provided a value that doesn't match the required
//      pattern.
//
//      * INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't
//      match the required pattern.
//
//      * INVALID_ROLE_NAME: You provided a role name that isn't valid. A role
//      name can't begin with the reserved prefix AWSServiceRoleFor.
//
//      * INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource
//      Name (ARN) for the organization.
//
//      * INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
//
//      * INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system
//      tag. You can’t add, edit, or delete system tag keys because they're
//      reserved for AWS use. System tags don’t count against your tags per
//      resource limit.
//
//      * MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter
//      for the operation.
//
//      * MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer
//      than allowed.
//
//      * MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger
//      value than allowed.
//
//      * MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter
//      than allowed.
//
//      * MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller
//      value than allowed.
//
//      * MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only
//      between entities in the same root.
//
//      * TARGET_NOT_SUPPORTED: You can't perform the specified operation on that
//      target entity.
//
//      * UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that
//      isn't recognized.
//
//   * MalformedPolicyDocumentException
//   The provided policy document doesn't meet the requirements of the specified
//   policy type. For example, the syntax might be incorrect. For details about
//   service control policy syntax, see Service Control Policy Syntax (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_scp-syntax.html)
//   in the AWS Organizations User Guide.
//
//   * PolicyTypeNotAvailableForOrganizationException
//   You can't use the specified policy type with the feature set currently enabled
//   for this organization. For example, you can enable SCPs only after you enable
//   all features in the organization. For more information, see Managing AWS
//   Organizations Policies (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies.html#enable_policies_on_root)in
//   the AWS Organizations User Guide.
//
//   * ServiceException
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * TooManyRequestsException
//   You have sent too many requests in too short a period of time. The quota
//   helps protect against denial-of-service attacks. Try again later.
//
//   For information about quotas that affect AWS Organizations, see Quotas for
//   AWS Organizations (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html)in
//   the AWS Organizations User Guide.
//
//   * UnsupportedAPIEndpointException
//   This action isn't available in the current AWS Region.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/CreatePolicy
func (c *Organizations) CreatePolicy(input *CreatePolicyInput) (*CreatePolicyOutput, error) {
	req, out := c.CreatePolicyRequest(input)
	return out, req.Send()
}

// CreatePolicyWithContext is the same as CreatePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) CreatePolicyWithContext(ctx aws.Context, input *CreatePolicyInput, opts ...request.Option) (*CreatePolicyOutput, error) {
	req, out := c.CreatePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeclineHandshake = "DeclineHandshake"

// DeclineHandshakeRequest generates a "aws/request.Request" representing the
// client's request for the DeclineHandshake operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeclineHandshake for more information on using the DeclineHandshake
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeclineHandshakeRequest method.
//    req, resp := client.DeclineHandshakeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DeclineHandshake
func (c *Organizations) DeclineHandshakeRequest(input *DeclineHandshakeInput) (req *request.Request, output *DeclineHandshakeOutput) {
	op := &request.Operation{
		Name:       opDeclineHandshake,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeclineHandshakeInput{}
	}

	output = &DeclineHandshakeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeclineHandshake API operation for AWS Organizations.
//
// Declines a handshake request. This sets the handshake state to DECLINED and
// effectively deactivates the request.
//
// This operation can be called only from the account that received the handshake.
// The originator of the handshake can use CancelHandshake instead. The originator
// can't reactivate a declined request, but can reinitiate the process with
// a new handshake request.
//
// After you decline a handshake, it continues to appear in the results of relevant
// APIs for only 30 days. After that, it's deleted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation DeclineHandshake for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * ConcurrentModificationException
//   The target of the operation is currently being modified by a different request.
//   Try again later.
//
//   * HandshakeNotFoundException
//   We can't find a handshake with the HandshakeId that you specified.
//
//   * InvalidHandshakeTransitionException
//   You can't perform the operation on the handshake in its current state. For
//   example, you can't cancel a handshake that was already accepted or accept
//   a handshake that was already declined.
//
//   * HandshakeAlreadyInStateException
//   The specified handshake is already in the requested state. For example, you
//   can't accept a handshake that was already accepted.
//
//   * InvalidInputException
//   The requested operation failed because you provided invalid values for one
//   or more of the request parameters. This exception includes a reason that
//   contains additional information about the violated limit:
//
//   Some of the reasons in the following list might not be applicable to this
//   specific API or operation.
//
//      * DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to
//      the same entity.
//
//      * IMMUTABLE_POLICY: You specified a policy that is managed by AWS and
//      can't be modified.
//
//      * INPUT_REQUIRED: You must include a value for all required parameters.
//
//      * INVALID_ENUM: You specified an invalid value.
//
//      * INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
//
//      * INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid
//      characters.
//
//      * INVALID_LIST_MEMBER: You provided a list to a parameter that contains
//      at least one invalid value.
//
//      * INVALID_PAGINATION_TOKEN: Get the value for the NextToken parameter
//      from the response to a previous call of the operation.
//
//      * INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account,
//      organization, or email) as a party.
//
//      * INVALID_PATTERN: You provided a value that doesn't match the required
//      pattern.
//
//      * INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't
//      match the required pattern.
//
//      * INVALID_ROLE_NAME: You provided a role name that isn't valid. A role
//      name can't begin with the reserved prefix AWSServiceRoleFor.
//
//      * INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource
//      Name (ARN) for the organization.
//
//      * INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
//
//      * INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system
//      tag. You can’t add, edit, or delete system tag keys because they're
//      reserved for AWS use. System tags don’t count against your tags per
//      resource limit.
//
//      * MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter
//      for the operation.
//
//      * MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer
//      than allowed.
//
//      * MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger
//      value than allowed.
//
//      * MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter
//      than allowed.
//
//      * MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller
//      value than allowed.
//
//      * MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only
//      between entities in the same root.
//
//      * TARGET_NOT_SUPPORTED: You can't perform the specified operation on that
//      target entity.
//
//      * UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that
//      isn't recognized.
//
//   * ServiceException
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * TooManyRequestsException
//   You have sent too many requests in too short a period of time. The quota
//   helps protect against denial-of-service attacks. Try again later.
//
//   For information about quotas that affect AWS Organizations, see Quotas for
//   AWS Organizations (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html)in
//   the AWS Organizations User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DeclineHandshake
func (c *Organizations) DeclineHandshake(input *DeclineHandshakeInput) (*DeclineHandshakeOutput, error) {
	req, out := c.DeclineHandshakeRequest(input)
	return out, req.Send()
}

// DeclineHandshakeWithContext is the same as DeclineHandshake with the addition of
// the ability to pass a context and additional request options.
//
// See DeclineHandshake for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) DeclineHandshakeWithContext(ctx aws.Context, input *DeclineHandshakeInput, opts ...request.Option) (*DeclineHandshakeOutput, error) {
	req, out := c.DeclineHandshakeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteOrganization = "DeleteOrganization"

// DeleteOrganizationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteOrganization operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteOrganization for more information on using the DeleteOrganization
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteOrganizationRequest method.
//    req, resp := client.DeleteOrganizationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DeleteOrganization
func (c *Organizations) DeleteOrganizationRequest(input *DeleteOrganizationInput) (req *request.Request, output *DeleteOrganizationOutput) {
	op := &request.Operation{
		Name:       opDeleteOrganization,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteOrganizationInput{}
	}

	output = &DeleteOrganizationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteOrganization API operation for AWS Organizations.
//
// Deletes the organization. You can delete an organization only by using credentials
// from the master account. The organization must be empty of member accounts.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation DeleteOrganization for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * AWSOrganizationsNotInUseException
//   Your account isn't a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * ConcurrentModificationException
//   The target of the operation is currently being modified by a different request.
//   Try again later.
//
//   * InvalidInputException
//   The requested operation failed because you provided invalid values for one
//   or more of the request parameters. This exception includes a reason that
//   contains additional information about the violated limit:
//
//   Some of the reasons in the following list might not be applicable to this
//   specific API or operation.
//
//      * DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to
//      the same entity.
//
//      * IMMUTABLE_POLICY: You specified a policy that is managed by AWS and
//      can't be modified.
//
//      * INPUT_REQUIRED: You must include a value for all required parameters.
//
//      * INVALID_ENUM: You specified an invalid value.
//
//      * INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
//
//      * INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid
//      characters.
//
//      * INVALID_LIST_MEMBER: You provided a list to a parameter that contains
//      at least one invalid value.
//
//      * INVALID_PAGINATION_TOKEN: Get the value for the NextToken parameter
//      from the response to a previous call of the operation.
//
//      * INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account,
//      organization, or email) as a party.
//
//      * INVALID_PATTERN: You provided a value that doesn't match the required
//      pattern.
//
//      * INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't
//      match the required pattern.
//
//      * INVALID_ROLE_NAME: You provided a role name that isn't valid. A role
//      name can't begin with the reserved prefix AWSServiceRoleFor.
//
//      * INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource
//      Name (ARN) for the organization.
//
//      * INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
//
//      * INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system
//      tag. You can’t add, edit, or delete system tag keys because they're
//      reserved for AWS use. System tags don’t count against your tags per
//      resource limit.
//
//      * MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter
//      for the operation.
//
//      * MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer
//      than allowed.
//
//      * MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger
//      value than allowed.
//
//      * MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter
//      than allowed.
//
//      * MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller
//      value than allowed.
//
//      * MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only
//      between entities in the same root.
//
//      * TARGET_NOT_SUPPORTED: You can't perform the specified operation on that
//      target entity.
//
//      * UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that
//      isn't recognized.
//
//   * OrganizationNotEmptyException
//   The organization isn't empty. To delete an organization, you must first remove
//   all accounts except the master account, delete all OUs, and delete all policies.
//
//   * ServiceException
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * TooManyRequestsException
//   You have sent too many requests in too short a period of time. The quota
//   helps protect against denial-of-service attacks. Try again later.
//
//   For information about quotas that affect AWS Organizations, see Quotas for
//   AWS Organizations (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html)in
//   the AWS Organizations User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DeleteOrganization
func (c *Organizations) DeleteOrganization(input *DeleteOrganizationInput) (*DeleteOrganizationOutput, error) {
	req, out := c.DeleteOrganizationRequest(input)
	return out, req.Send()
}

// DeleteOrganizationWithContext is the same as DeleteOrganization with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteOrganization for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) DeleteOrganizationWithContext(ctx aws.Context, input *DeleteOrganizationInput, opts ...request.Option) (*DeleteOrganizationOutput, error) {
	req, out := c.DeleteOrganizationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteOrganizationalUnit = "DeleteOrganizationalUnit"

// DeleteOrganizationalUnitRequest generates a "aws/request.Request" representing the
// client's request for the DeleteOrganizationalUnit operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteOrganizationalUnit for more information on using the DeleteOrganizationalUnit
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteOrganizationalUnitRequest method.
//    req, resp := client.DeleteOrganizationalUnitRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DeleteOrganizationalUnit
func (c *Organizations) DeleteOrganizationalUnitRequest(input *DeleteOrganizationalUnitInput) (req *request.Request, output *DeleteOrganizationalUnitOutput) {
	op := &request.Operation{
		Name:       opDeleteOrganizationalUnit,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteOrganizationalUnitInput{}
	}

	output = &DeleteOrganizationalUnitOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteOrganizationalUnit API operation for AWS Organizations.
//
// Deletes an organizational unit (OU) from a root or another OU. You must first
// remove all accounts and child OUs from the OU that you want to delete.
//
// This operation can be called only from the organization's master account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation DeleteOrganizationalUnit for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * AWSOrganizationsNotInUseException
//   Your account isn't a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * ConcurrentModificationException
//   The target of the operation is currently being modified by a different request.
//   Try again later.
//
//   * InvalidInputException
//   The requested operation failed because you provided invalid values for one
//   or more of the request parameters. This exception includes a reason that
//   contains additional information about the violated limit:
//
//   Some of the reasons in the following list might not be applicable to this
//   specific API or operation.
//
//      * DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to
//      the same entity.
//
//      * IMMUTABLE_POLICY: You specified a policy that is managed by AWS and
//      can't be modified.
//
//      * INPUT_REQUIRED: You must include a value for all required parameters.
//
//      * INVALID_ENUM: You specified an invalid value.
//
//      * INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
//
//      * INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid
//      characters.
//
//      * INVALID_LIST_MEMBER: You provided a list to a parameter that contains
//      at least one invalid value.
//
//      * INVALID_PAGINATION_TOKEN: Get the value for the NextToken parameter
//      from the response to a previous call of the operation.
//
//      * INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account,
//      organization, or email) as a party.
//
//      * INVALID_PATTERN: You provided a value that doesn't match the required
//      pattern.
//
//      * INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't
//      match the required pattern.
//
//      * INVALID_ROLE_NAME: You provided a role name that isn't valid. A role
//      name can't begin with the reserved prefix AWSServiceRoleFor.
//
//      * INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource
//      Name (ARN) for the organization.
//
//      * INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
//
//      * INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system
//      tag. You can’t add, edit, or delete system tag keys because they're
//      reserved for AWS use. System tags don’t count against your tags per
//      resource limit.
//
//      * MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter
//      for the operation.
//
//      * MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer
//      than allowed.
//
//      * MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger
//      value than allowed.
//
//      * MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter
//      than allowed.
//
//      * MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller
//      value than allowed.
//
//      * MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only
//      between entities in the same root.
//
//      * TARGET_NOT_SUPPORTED: You can't perform the specified operation on that
//      target entity.
//
//      * UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that
//      isn't recognized.
//
//   * OrganizationalUnitNotEmptyException
//   The specified OU is not empty. Move all accounts to another root or to other
//   OUs, remove all child OUs, and try the operation again.
//
//   * OrganizationalUnitNotFoundException
//   We can't find an OU with the OrganizationalUnitId that you specified.
//
//   * ServiceException
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * TooManyRequestsException
//   You have sent too many requests in too short a period of time. The quota
//   helps protect against denial-of-service attacks. Try again later.
//
//   For information about quotas that affect AWS Organizations, see Quotas for
//   AWS Organizations (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html)in
//   the AWS Organizations User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DeleteOrganizationalUnit
func (c *Organizations) DeleteOrganizationalUnit(input *DeleteOrganizationalUnitInput) (*DeleteOrganizationalUnitOutput, error) {
	req, out := c.DeleteOrganizationalUnitRequest(input)
	return out, req.Send()
}

// DeleteOrganizationalUnitWithContext is the same as DeleteOrganizationalUnit with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteOrganizationalUnit for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) DeleteOrganizationalUnitWithContext(ctx aws.Context, input *DeleteOrganizationalUnitInput, opts ...request.Option) (*DeleteOrganizationalUnitOutput, error) {
	req, out := c.DeleteOrganizationalUnitRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePolicy = "DeletePolicy"

// DeletePolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeletePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePolicy for more information on using the DeletePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeletePolicyRequest method.
//    req, resp := client.DeletePolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DeletePolicy
func (c *Organizations) DeletePolicyRequest(input *DeletePolicyInput) (req *request.Request, output *DeletePolicyOutput) {
	op := &request.Operation{
		Name:       opDeletePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeletePolicyInput{}
	}

	output = &DeletePolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeletePolicy API operation for AWS Organizations.
//
// Deletes the specified policy from your organization. Before you perform this
// operation, you must first detach the policy from all organizational units
// (OUs), roots, and accounts.
//
// This operation can be called only from the organization's master account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation DeletePolicy for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * AWSOrganizationsNotInUseException
//   Your account isn't a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * ConcurrentModificationException
//   The target of the operation is currently being modified by a different request.
//   Try again later.
//
//   * InvalidInputException
//   The requested operation failed because you provided invalid values for one
//   or more of the request parameters. This exception includes a reason that
//   contains additional information about the violated limit:
//
//   Some of the reasons in the following list might not be applicable to this
//   specific API or operation.
//
//      * DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to
//      the same entity.
//
//      * IMMUTABLE_POLICY: You specified a policy that is managed by AWS and
//      can't be modified.
//
//      * INPUT_REQUIRED: You must include a value for all required parameters.
//
//      * INVALID_ENUM: You specified an invalid value.
//
//      * INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
//
//      * INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid
//      characters.
//
//      * INVALID_LIST_MEMBER: You provided a list to a parameter that contains
//      at least one invalid value.
//
//      * INVALID_PAGINATION_TOKEN: Get the value for the NextToken parameter
//      from the response to a previous call of the operation.
//
//      * INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account,
//      organization, or email) as a party.
//
//      * INVALID_PATTERN: You provided a value that doesn't match the required
//      pattern.
//
//      * INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't
//      match the required pattern.
//
//      * INVALID_ROLE_NAME: You provided a role name that isn't valid. A role
//      name can't begin with the reserved prefix AWSServiceRoleFor.
//
//      * INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource
//      Name (ARN) for the organization.
//
//      * INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
//
//      * INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system
//      tag. You can’t add, edit, or delete system tag keys because they're
//      reserved for AWS use. System tags don’t count against your tags per
//      resource limit.
//
//      * MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter
//      for the operation.
//
//      * MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer
//      than allowed.
//
//      * MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger
//      value than allowed.
//
//      * MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter
//      than allowed.
//
//      * MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller
//      value than allowed.
//
//      * MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only
//      between entities in the same root.
//
//      * TARGET_NOT_SUPPORTED: You can't perform the specified operation on that
//      target entity.
//
//      * UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that
//      isn't recognized.
//
//   * PolicyInUseException
//   The policy is attached to one or more entities. You must detach it from all
//   roots, OUs, and accounts before performing this operation.
//
//   * PolicyNotFoundException
//   We can't find a policy with the PolicyId that you specified.
//
//   * ServiceException
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * TooManyRequestsException
//   You have sent too many requests in too short a period of time. The quota
//   helps protect against denial-of-service attacks. Try again later.
//
//   For information about quotas that affect AWS Organizations, see Quotas for
//   AWS Organizations (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html)in
//   the AWS Organizations User Guide.
//
//   * UnsupportedAPIEndpointException
//   This action isn't available in the current AWS Region.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DeletePolicy
func (c *Organizations) DeletePolicy(input *DeletePolicyInput) (*DeletePolicyOutput, error) {
	req, out := c.DeletePolicyRequest(input)
	return out, req.Send()
}

// DeletePolicyWithContext is the same as DeletePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) DeletePolicyWithContext(ctx aws.Context, input *DeletePolicyInput, opts ...request.Option) (*DeletePolicyOutput, error) {
	req, out := c.DeletePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeregisterDelegatedAdministrator = "DeregisterDelegatedAdministrator"

// DeregisterDelegatedAdministratorRequest generates a "aws/request.Request" representing the
// client's request for the DeregisterDelegatedAdministrator operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeregisterDelegatedAdministrator for more information on using the DeregisterDelegatedAdministrator
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeregisterDelegatedAdministratorRequest method.
//    req, resp := client.DeregisterDelegatedAdministratorRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DeregisterDelegatedAdministrator
func (c *Organizations) DeregisterDelegatedAdministratorRequest(input *DeregisterDelegatedAdministratorInput) (req *request.Request, output *DeregisterDelegatedAdministratorOutput) {
	op := &request.Operation{
		Name:       opDeregisterDelegatedAdministrator,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeregisterDelegatedAdministratorInput{}
	}

	output = &DeregisterDelegatedAdministratorOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeregisterDelegatedAdministrator API operation for AWS Organizations.
//
// Removes the specified member AWS account as a delegated administrator for
// the specified AWS service.
//
// Deregistering a delegated administrator can have unintended impacts on the
// functionality of the enabled AWS service. See the documentation for the enabled
// service before you deregister a delegated administrator so that you understand
// any potential impacts.
//
// You can run this action only for AWS services that support this feature.
// For a current list of services that support it, see the column Supports Delegated
// Administrator in the table at AWS Services that you can use with AWS Organizations
// (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrated-services-list.html)
// in the AWS Organizations User Guide.
//
// This operation can be called only from the organization's master account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation DeregisterDelegatedAdministrator for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * AccountNotFoundException
//   We can't find an AWS account with the AccountId that you specified, or the
//   account whose credentials you used to make this request isn't a member of
//   an organization.
//
//   * AccountNotRegisteredException
//   The specified account is not a delegated administrator for this AWS service.
//
//   * AWSOrganizationsNotInUseException
//   Your account isn't a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * ConcurrentModificationException
//   The target of the operation is currently being modified by a different request.
//   Try again later.
//
//   * ConstraintViolationException
//   Performing this operation violates a minimum or maximum value limit. For
//   example, attempting to remove the last service control policy (SCP) from
//   an OU or root, inviting or creating too many accounts to the organization,
//   or attaching too many policies to an account, OU, or root. This exception
//   includes a reason that contains additional information about the violated
//   limit:
//
//   Some of the reasons in the following list might not be applicable to this
//   specific API or operation.
//
//      * ACCOUNT_CANNOT_LEAVE_ORGANIZAION: You attempted to remove the master
//      account from the organization. You can't remove the master account. Instead,
//      after you remove all member accounts, delete the organization itself.
//
//      * ACCOUNT_CANNOT_LEAVE_WITHOUT_EULA: You attempted to remove an account
//      from the organization that doesn't yet have enough information to exist
//      as a standalone account. This account requires you to first agree to the
//      AWS Customer Agreement. Follow the steps at Removing a member account
//      from your organization (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master)in
//      the AWS Organizations User Guide.
//
//      * ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove
//      an account from the organization that doesn't yet have enough information
//      to exist as a standalone account. This account requires you to first complete
//      phone verification. Follow the steps at Removing a member account from
//      your organization (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master)
//      in the AWS Organizations User Guide.
//
//      * ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number
//      of accounts that you can create in one day.
//
//      * ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on
//      the number of accounts in an organization. If you need more accounts,
//      contact AWS Support (https://console.aws.amazon.com/support/home#/) to
//      request an increase in your limit. Or the number of invitations that you
//      tried to send would cause you to exceed the limit of accounts in your
//      organization. Send fewer invitations or contact AWS Support to request
//      an increase in the number of accounts. Deleted and closed accounts still
//      count toward your limit. If you get this exception when running a command
//      immediately after creating the organization, wait one hour and try again.
//      After an hour, if the command continues to fail with this error, contact
//      AWS Support (https://console.aws.amazon.com/support/home#/).
//
//      * CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to
//      register the master account of the organization as a delegated administrator
//      for an AWS service integrated with Organizations. You can designate only
//      a member account as a delegated administrator.
//
//      * CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove
//      an account that is registered as a delegated administrator for a service
//      integrated with your organization. To complete this operation, you must
//      first deregister this account as a delegated administrator.
//
//      * CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an
//      organization in the specified region, you must enable all features mode.
//
//      * DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register
//      an AWS account as a delegated administrator for an AWS service that already
//      has a delegated administrator. To complete this operation, you must first
//      deregister any existing delegated administrators for this service.
//
//      * EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only
//      valid for a limited period of time. You must resubmit the request and
//      generate a new verfication code.
//
//      * HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of
//      handshakes that you can send in one day.
//
//      * MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account
//      in this organization, you first must migrate the organization's master
//      account to the marketplace that corresponds to the master account's address.
//      For example, accounts with India addresses must be associated with the
//      AISPL marketplace. All accounts in an organization must be associated
//      with the same marketplace.
//
//      * MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the AWS Regions
//      in China. To create an organization, the master must have an valid business
//      license. For more information, contact customer support.
//
//      * MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you
//      must first provide a valid contact address and phone number for the master
//      account. Then try the operation again.
//
//      * MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the
//      master account must have an associated account in the AWS GovCloud (US-West)
//      Region. For more information, see AWS Organizations (http://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html)
//      in the AWS GovCloud User Guide.
//
//      * MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization
//      with this master account, you first must associate a valid payment instrument,
//      such as a credit card, with the account. Follow the steps at To leave
//      an organization when all required account information has not yet been
//      provided (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info)
//      in the AWS Organizations User Guide.
//
//      * MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted
//      to register more delegated administrators than allowed for the service
//      principal.
//
//      * MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the
//      number of policies of a certain type that can be attached to an entity
//      at one time.
//
//      * MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed
//      on this resource.
//
//      * MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation
//      with this member account, you first must associate a valid payment instrument,
//      such as a credit card, with the account. Follow the steps at To leave
//      an organization when all required account information has not yet been
//      provided (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info)
//      in the AWS Organizations User Guide.
//
//      * MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a
//      policy from an entity that would cause the entity to have fewer than the
//      minimum number of policies of a certain type required.
//
//      * ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation
//      that requires the organization to be configured to support all features.
//      An organization that supports only consolidated billing features can't
//      perform this operation.
//
//      * OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is
//      too many levels deep.
//
//      * OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs
//      that you can have in an organization.
//
//      * POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that
//      is larger than the maximum size.
//
//      * POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of
//      policies that you can have in an organization.
//
//      * TAG_POLICY_VIOLATION: You attempted to create or update a resource with
//      tags that are not compliant with the tag policy requirements for this
//      account.
//
//   * InvalidInputException
//   The requested operation failed because you provided invalid values for one
//   or more of the request parameters. This exception includes a reason that
//   contains additional information about the violated limit:
//
//   Some of the reasons in the following list might not be applicable to this
//   specific API or operation.
//
//      * DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to
//      the same entity.
//
//      * IMMUTABLE_POLICY: You specified a policy that is managed by AWS and
//      can't be modified.
//
//      * INPUT_REQUIRED: You must include a value for all required parameters.
//
//      * INVALID_ENUM: You specified an invalid value.
//
//      * INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
//
//      * INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid
//      characters.
//
//      * INVALID_LIST_MEMBER: You provided a list to a parameter that contains
//      at least one invalid value.
//
//      * INVALID_PAGINATION_TOKEN: Get the value for the NextToken parameter
//      from the response to a previous call of the operation.
//
//      * INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account,
//      organization, or email) as a party.
//
//      * INVALID_PATTERN: You provided a value that doesn't match the required
//      pattern.
//
//      * INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't
//      match the required pattern.
//
//      * INVALID_ROLE_NAME: You provided a role name that isn't valid. A role
//      name can't begin with the reserved prefix AWSServiceRoleFor.
//
//      * INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource
//      Name (ARN) for the organization.
//
//      * INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
//
//      * INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system
//      tag. You can’t add, edit, or delete system tag keys because they're
//      reserved for AWS use. System tags don’t count against your tags per
//      resource limit.
//
//      * MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter
//      for the operation.
//
//      * MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer
//      than allowed.
//
//      * MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger
//      value than allowed.
//
//      * MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter
//      than allowed.
//
//      * MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller
//      value than allowed.
//
//      * MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only
//      between entities in the same root.
//
//      * TARGET_NOT_SUPPORTED: You can't perform the specified operation on that
//      target entity.
//
//      * UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that
//      isn't recognized.
//
//   * TooManyRequestsException
//   You have sent too many requests in too short a period of time. The quota
//   helps protect against denial-of-service attacks. Try again later.
//
//   For information about quotas that affect AWS Organizations, see Quotas for
//   AWS Organizations (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html)in
//   the AWS Organizations User Guide.
//
//   * ServiceException
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * UnsupportedAPIEndpointException
//   This action isn't available in the current AWS Region.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DeregisterDelegatedAdministrator
func (c *Organizations) DeregisterDelegatedAdministrator(input *DeregisterDelegatedAdministratorInput) (*DeregisterDelegatedAdministratorOutput, error) {
	req, out := c.DeregisterDelegatedAdministratorRequest(input)
	return out, req.Send()
}

// DeregisterDelegatedAdministratorWithContext is the same as DeregisterDelegatedAdministrator with the addition of
// the ability to pass a context and additional request options.
//
// See DeregisterDelegatedAdministrator for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) DeregisterDelegatedAdministratorWithContext(ctx aws.Context, input *DeregisterDelegatedAdministratorInput, opts ...request.Option) (*DeregisterDelegatedAdministratorOutput, error) {
	req, out := c.DeregisterDelegatedAdministratorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAccount = "DescribeAccount"

// DescribeAccountRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAccount for more information on using the DescribeAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAccountRequest method.
//    req, resp := client.DescribeAccountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DescribeAccount
func (c *Organizations) DescribeAccountRequest(input *DescribeAccountInput) (req *request.Request, output *DescribeAccountOutput) {
	op := &request.Operation{
		Name:       opDescribeAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAccountInput{}
	}

	output = &DescribeAccountOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAccount API operation for AWS Organizations.
//
// Retrieves AWS Organizations-related information about the specified account.
//
// This operation can be called only from the organization's master account
// or by a member account that is a delegated administrator for an AWS service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation DescribeAccount for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * AccountNotFoundException
//   We can't find an AWS account with the AccountId that you specified, or the
//   account whose credentials you used to make this request isn't a member of
//   an organization.
//
//   * AWSOrganizationsNotInUseException
//   Your account isn't a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * InvalidInputException
//   The requested operation failed because you provided invalid values for one
//   or more of the request parameters. This exception includes a reason that
//   contains additional information about the violated limit:
//
//   Some of the reasons in the following list might not be applicable to this
//   specific API or operation.
//
//      * DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to
//      the same entity.
//
//      * IMMUTABLE_POLICY: You specified a policy that is managed by AWS and
//      can't be modified.
//
//      * INPUT_REQUIRED: You must include a value for all required parameters.
//
//      * INVALID_ENUM: You specified an invalid value.
//
//      * INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
//
//      * INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid
//      characters.
//
//      * INVALID_LIST_MEMBER: You provided a list to a parameter that contains
//      at least one invalid value.
//
//      * INVALID_PAGINATION_TOKEN: Get the value for the NextToken parameter
//      from the response to a previous call of the operation.
//
//      * INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account,
//      organization, or email) as a party.
//
//      * INVALID_PATTERN: You provided a value that doesn't match the required
//      pattern.
//
//      * INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't
//      match the required pattern.
//
//      * INVALID_ROLE_NAME: You provided a role name that isn't valid. A role
//      name can't begin with the reserved prefix AWSServiceRoleFor.
//
//      * INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource
//      Name (ARN) for the organization.
//
//      * INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
//
//      * INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system
//      tag. You can’t add, edit, or delete system tag keys because they're
//      reserved for AWS use. System tags don’t count against your tags per
//      resource limit.
//
//      * MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter
//      for the operation.
//
//      * MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer
//      than allowed.
//
//      * MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger
//      value than allowed.
//
//      * MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter
//      than allowed.
//
//      * MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller
//      value than allowed.
//
//      * MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only
//      between entities in the same root.
//
//      * TARGET_NOT_SUPPORTED: You can't perform the specified operation on that
//      target entity.
//
//      * UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that
//      isn't recognized.
//
//   * ServiceException
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * TooManyRequestsException
//   You have sent too many requests in too short a period of time. The quota
//   helps protect against denial-of-service attacks. Try again later.
//
//   For information about quotas that affect AWS Organizations, see Quotas for
//   AWS Organizations (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html)in
//   the AWS Organizations User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DescribeAccount
func (c *Organizations) DescribeAccount(input *DescribeAccountInput) (*DescribeAccountOutput, error) {
	req, out := c.DescribeAccountRequest(input)
	return out, req.Send()
}

// DescribeAccountWithContext is the same as DescribeAccount with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) DescribeAccountWithContext(ctx aws.Context, input *DescribeAccountInput, opts ...request.Option) (*DescribeAccountOutput, error) {
	req, out := c.DescribeAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeCreateAccountStatus = "DescribeCreateAccountStatus"

// DescribeCreateAccountStatusRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCreateAccountStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeCreateAccountStatus for more information on using the DescribeCreateAccountStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeCreateAccountStatusRequest method.
//    req, resp := client.DescribeCreateAccountStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DescribeCreateAccountStatus
func (c *Organizations) DescribeCreateAccountStatusRequest(input *DescribeCreateAccountStatusInput) (req *request.Request, output *DescribeCreateAccountStatusOutput) {
	op := &request.Operation{
		Name:       opDescribeCreateAccountStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeCreateAccountStatusInput{}
	}

	output = &DescribeCreateAccountStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCreateAccountStatus API operation for AWS Organizations.
//
// Retrieves the current status of an asynchronous request to create an account.
//
// This operation can be called only from the organization's master account
// or by a member account that is a delegated administrator for an AWS service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation DescribeCreateAccountStatus for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * AWSOrganizationsNotInUseException
//   Your account isn't a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * CreateAccountStatusNotFoundException
//   We can't find an create account request with the CreateAccountRequestId that
//   you specified.
//
//   * InvalidInputException
//   The requested operation failed because you provided invalid values for one
//   or more of the request parameters. This exception includes a reason that
//   contains additional information about the violated limit:
//
//   Some of the reasons in the following list might not be applicable to this
//   specific API or operation.
//
//      * DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to
//      the same entity.
//
//      * IMMUTABLE_POLICY: You specified a policy that is managed by AWS and
//      can't be modified.
//
//      * INPUT_REQUIRED: You must include a value for all required parameters.
//
//      * INVALID_ENUM: You specified an invalid value.
//
//      * INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
//
//      * INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid
//      characters.
//
//      * INVALID_LIST_MEMBER: You provided a list to a parameter that contains
//      at least one invalid value.
//
//      * INVALID_PAGINATION_TOKEN: Get the value for the NextToken parameter
//      from the response to a previous call of the operation.
//
//      * INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account,
//      organization, or email) as a party.
//
//      * INVALID_PATTERN: You provided a value that doesn't match the required
//      pattern.
//
//      * INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't
//      match the required pattern.
//
//      * INVALID_ROLE_NAME: You provided a role name that isn't valid. A role
//      name can't begin with the reserved prefix AWSServiceRoleFor.
//
//      * INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource
//      Name (ARN) for the organization.
//
//      * INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
//
//      * INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system
//      tag. You can’t add, edit, or delete system tag keys because they're
//      reserved for AWS use. System tags don’t count against your tags per
//      resource limit.
//
//      * MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter
//      for the operation.
//
//      * MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer
//      than allowed.
//
//      * MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger
//      value than allowed.
//
//      * MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter
//      than allowed.
//
//      * MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller
//      value than allowed.
//
//      * MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only
//      between entities in the same root.
//
//      * TARGET_NOT_SUPPORTED: You can't perform the specified operation on that
//      target entity.
//
//      * UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that
//      isn't recognized.
//
//   * ServiceException
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * TooManyRequestsException
//   You have sent too many requests in too short a period of time. The quota
//   helps protect against denial-of-service attacks. Try again later.
//
//   For information about quotas that affect AWS Organizations, see Quotas for
//   AWS Organizations (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html)in
//   the AWS Organizations User Guide.
//
//   * UnsupportedAPIEndpointException
//   This action isn't available in the current AWS Region.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DescribeCreateAccountStatus
func (c *Organizations) DescribeCreateAccountStatus(input *DescribeCreateAccountStatusInput) (*DescribeCreateAccountStatusOutput, error) {
	req, out := c.DescribeCreateAccountStatusRequest(input)
	return out, req.Send()
}

// DescribeCreateAccountStatusWithContext is the same as DescribeCreateAccountStatus with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCreateAccountStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) DescribeCreateAccountStatusWithContext(ctx aws.Context, input *DescribeCreateAccountStatusInput, opts ...request.Option) (*DescribeCreateAccountStatusOutput, error) {
	req, out := c.DescribeCreateAccountStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeEffectivePolicy = "DescribeEffectivePolicy"

// DescribeEffectivePolicyRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEffectivePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEffectivePolicy for more information on using the DescribeEffectivePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEffectivePolicyRequest method.
//    req, resp := client.DescribeEffectivePolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DescribeEffectivePolicy
func (c *Organizations) DescribeEffectivePolicyRequest(input *DescribeEffectivePolicyInput) (req *request.Request, output *DescribeEffectivePolicyOutput) {
	op := &request.Operation{
		Name:       opDescribeEffectivePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEffectivePolicyInput{}
	}

	output = &DescribeEffectivePolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEffectivePolicy API operation for AWS Organizations.
//
// Returns the contents of the effective policy for specified policy type and
// account. The effective policy is the aggregation of any policies of the specified
// type that the account inherits, plus any policy of that type that is directly
// attached to the account.
//
// This operation applies only to policy types other than service control policies
// (SCPs).
//
// For more information about policy inheritance, see How Policy Inheritance
// Works (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies-inheritance.html)
// in the AWS Organizations User Guide.
//
// This operation can be called only from the organization's master account
// or by a member account that is a delegated administrator for an AWS service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation DescribeEffectivePolicy for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * AWSOrganizationsNotInUseException
//   Your account isn't a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * ConstraintViolationException
//   Performing this operation violates a minimum or maximum value limit. For
//   example, attempting to remove the last service control policy (SCP) from
//   an OU or root, inviting or creating too many accounts to the organization,
//   or attaching too many policies to an account, OU, or root. This exception
//   includes a reason that contains additional information about the violated
//   limit:
//
//   Some of the reasons in the following list might not be applicable to this
//   specific API or operation.
//
//      * ACCOUNT_CANNOT_LEAVE_ORGANIZAION: You attempted to remove the master
//      account from the organization. You can't remove the master account. Instead,
//      after you remove all member accounts, delete the organization itself.
//
//      * ACCOUNT_CANNOT_LEAVE_WITHOUT_EULA: You attempted to remove an account
//      from the organization that doesn't yet have enough information to exist
//      as a standalone account. This account requires you to first agree to the
//      AWS Customer Agreement. Follow the steps at Removing a member account
//      from your organization (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master)in
//      the AWS Organizations User Guide.
//
//      * ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove
//      an account from the organization that doesn't yet have enough information
//      to exist as a standalone account. This account requires you to first complete
//      phone verification. Follow the steps at Removing a member account from
//      your organization (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master)
//      in the AWS Organizations User Guide.
//
//      * ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number
//      of accounts that you can create in one day.
//
//      * ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on
//      the number of accounts in an organization. If you need more accounts,
//      contact AWS Support (https://console.aws.amazon.com/support/home#/) to
//      request an increase in your limit. Or the number of invitations that you
//      tried to send would cause you to exceed the limit of accounts in your
//      organization. Send fewer invitations or contact AWS Support to request
//      an increase in the number of accounts. Deleted and closed accounts still
//      count toward your limit. If you get this exception when running a command
//      immediately after creating the organization, wait one hour and try again.
//      After an hour, if the command continues to fail with this error, contact
//      AWS Support (https://console.aws.amazon.com/support/home#/).
//
//      * CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to
//      register the master account of the organization as a delegated administrator
//      for an AWS service integrated with Organizations. You can designate only
//      a member account as a delegated administrator.
//
//      * CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove
//      an account that is registered as a delegated administrator for a service
//      integrated with your organization. To complete this operation, you must
//      first deregister this account as a delegated administrator.
//
//      * CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an
//      organization in the specified region, you must enable all features mode.
//
//      * DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register
//      an AWS account as a delegated administrator for an AWS service that already
//      has a delegated administrator. To complete this operation, you must first
//      deregister any existing delegated administrators for this service.
//
//      * EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only
//      valid for a limited period of time. You must resubmit the request and
//      generate a new verfication code.
//
//      * HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of
//      handshakes that you can send in one day.
//
//      * MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account
//      in this organization, you first must migrate the organization's master
//      account to the marketplace that corresponds to the master account's address.
//      For example, accounts with India addresses must be associated with the
//      AISPL marketplace. All accounts in an organization must be associated
//      with the same marketplace.
//
//      * MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the AWS Regions
//      in China. To create an organization, the master must have an valid business
//      license. For more information, contact customer support.
//
//      * MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you
//      must first provide a valid contact address and phone number for the master
//      account. Then try the operation again.
//
//      * MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the
//      master account must have an associated account in the AWS GovCloud (US-West)
//      Region. For more information, see AWS Organizations (http://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html)
//      in the AWS GovCloud User Guide.
//
//      * MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization
//      with this master account, you first must associate a valid payment instrument,
//      such as a credit card, with the account. Follow the steps at To leave
//      an organization when all required account information has not yet been
//      provided (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info)
//      in the AWS Organizations User Guide.
//
//      * MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted
//      to register more delegated administrators than allowed for the service
//      principal.
//
//      * MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the
//      number of policies of a certain type that can be attached to an entity
//      at one time.
//
//      * MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed
//      on this resource.
//
//      * MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation
//      with this member account, you first must associate a valid payment instrument,
//      such as a credit card, with the account. Follow the steps at To leave
//      an organization when all required account information has not yet been
//      provided (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info)
//      in the AWS Organizations User Guide.
//
//      * MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a
//      policy from an entity that would cause the entity to have fewer than the
//      minimum number of policies of a certain type required.
//
//      * ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation
//      that requires the organization to be configured to support all features.
//      An organization that supports only consolidated billing features can't
//      perform this operation.
//
//      * OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is
//      too many levels deep.
//
//      * OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs
//      that you can have in an organization.
//
//      * POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that
//      is larger than the maximum size.
//
//      * POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of
//      policies that you can have in an organization.
//
//      * TAG_POLICY_VIOLATION: You attempted to create or update a resource with
//      tags that are not compliant with the tag policy requirements for this
//      account.
//
//   * ServiceException
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * TooManyRequestsException
//   You have sent too many requests in too short a period of time. The quota
//   helps protect against denial-of-service attacks. Try again later.
//
//   For information about quotas that affect AWS Organizations, see Quotas for
//   AWS Organizations (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html)in
//   the AWS Organizations User Guide.
//
//   * TargetNotFoundException
//   We can't find a root, OU, account, or policy with the TargetId that you specified.
//
//   * EffectivePolicyNotFoundException
//   If you ran this action on the master account, this policy type is not enabled.
//   If you ran the action on a member account, the account doesn't have an effective
//   policy of this type. Contact the administrator of your organization about
//   attaching a policy of this type to the account.
//
//   * InvalidInputException
//   The requested operation failed because you provided invalid values for one
//   or more of the request parameters. This exception includes a reason that
//   contains additional information about the violated limit:
//
//   Some of the reasons in the following list might not be applicable to this
//   specific API or operation.
//
//      * DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to
//      the same entity.
//
//      * IMMUTABLE_POLICY: You specified a policy that is managed by AWS and
//      can't be modified.
//
//      * INPUT_REQUIRED: You must include a value for all required parameters.
//
//      * INVALID_ENUM: You specified an invalid value.
//
//      * INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
//
//      * INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid
//      characters.
//
//      * INVALID_LIST_MEMBER: You provided a list to a parameter that contains
//      at least one invalid value.
//
//      * INVALID_PAGINATION_TOKEN: Get the value for the NextToken parameter
//      from the response to a previous call of the operation.
//
//      * INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account,
//      organization, or email) as a party.
//
//      * INVALID_PATTERN: You provided a value that doesn't match the required
//      pattern.
//
//      * INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't
//      match the required pattern.
//
//      * INVALID_ROLE_NAME: You provided a role name that isn't valid. A role
//      name can't begin with the reserved prefix AWSServiceRoleFor.
//
//      * INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource
//      Name (ARN) for the organization.
//
//      * INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
//
//      * INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system
//      tag. You can’t add, edit, or delete system tag keys because they're
//      reserved for AWS use. System tags don’t count against your tags per
//      resource limit.
//
//      * MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter
//      for the operation.
//
//      * MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer
//      than allowed.
//
//      * MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger
//      value than allowed.
//
//      * MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter
//      than allowed.
//
//      * MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller
//      value than allowed.
//
//      * MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only
//      between entities in the same root.
//
//      * TARGET_NOT_SUPPORTED: You can't perform the specified operation on that
//      target entity.
//
//      * UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that
//      isn't recognized.
//
//   * UnsupportedAPIEndpointException
//   This action isn't available in the current AWS Region.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DescribeEffectivePolicy
func (c *Organizations) DescribeEffectivePolicy(input *DescribeEffectivePolicyInput) (*DescribeEffectivePolicyOutput, error) {
	req, out := c.DescribeEffectivePolicyRequest(input)
	return out, req.Send()
}

// DescribeEffectivePolicyWithContext is the same as DescribeEffectivePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEffectivePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) DescribeEffectivePolicyWithContext(ctx aws.Context, input *DescribeEffectivePolicyInput, opts ...request.Option) (*DescribeEffectivePolicyOutput, error) {
	req, out := c.DescribeEffectivePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeHandshake = "DescribeHandshake"

// DescribeHandshakeRequest generates a "aws/request.Request" representing the
// client's request for the DescribeHandshake operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeHandshake for more information on using the DescribeHandshake
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeHandshakeRequest method.
//    req, resp := client.DescribeHandshakeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DescribeHandshake
func (c *Organizations) DescribeHandshakeRequest(input *DescribeHandshakeInput) (req *request.Request, output *DescribeHandshakeOutput) {
	op := &request.Operation{
		Name:       opDescribeHandshake,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeHandshakeInput{}
	}

	output = &DescribeHandshakeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeHandshake API operation for AWS Organizations.
//
// Retrieves information about a previously requested handshake. The handshake
// ID comes from the response to the original InviteAccountToOrganization operation
// that generated the handshake.
//
// You can access handshakes that are ACCEPTED, DECLINED, or CANCELED for only
// 30 days after they change to that state. They're then deleted and no longer
// accessible.
//
// This operation can be called from any account in the organization.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation DescribeHandshake for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * ConcurrentModificationException
//   The target of the operation is currently being modified by a different request.
//   Try again later.
//
//   * HandshakeNotFoundException
//   We can't find a handshake with the HandshakeId that you specified.
//
//   * InvalidInputException
//   The requested operation failed because you provided invalid values for one
//   or more of the request parameters. This exception includes a reason that
//   contains additional information about the violated limit:
//
//   Some of the reasons in the following list might not be applicable to this
//   specific API or operation.
//
//      * DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to
//      the same entity.
//
//      * IMMUTABLE_POLICY: You specified a policy that is managed by AWS and
//      can't be modified.
//
//      * INPUT_REQUIRED: You must include a value for all required parameters.
//
//      * INVALID_ENUM: You specified an invalid value.
//
//      * INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
//
//      * INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid
//      characters.
//
//      * INVALID_LIST_MEMBER: You provided a list to a parameter that contains
//      at least one invalid value.
//
//      * INVALID_PAGINATION_TOKEN: Get the value for the NextToken parameter
//      from the response to a previous call of the operation.
//
//      * INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account,
//      organization, or email) as a party.
//
//      * INVALID_PATTERN: You provided a value that doesn't match the required
//      pattern.
//
//      * INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't
//      match the required pattern.
//
//      * INVALID_ROLE_NAME: You provided a role name that isn't valid. A role
//      name can't begin with the reserved prefix AWSServiceRoleFor.
//
//      * INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource
//      Name (ARN) for the organization.
//
//      * INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
//
//      * INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system
//      tag. You can’t add, edit, or delete system tag keys because they're
//      reserved for AWS use. System tags don’t count against your tags per
//      resource limit.
//
//      * MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter
//      for the operation.
//
//      * MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer
//      than allowed.
//
//      * MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger
//      value than allowed.
//
//      * MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter
//      than allowed.
//
//      * MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller
//      value than allowed.
//
//      * MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only
//      between entities in the same root.
//
//      * TARGET_NOT_SUPPORTED: You can't perform the specified operation on that
//      target entity.
//
//      * UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that
//      isn't recognized.
//
//   * ServiceException
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * TooManyRequestsException
//   You have sent too many requests in too short a period of time. The quota
//   helps protect against denial-of-service attacks. Try again later.
//
//   For information about quotas that affect AWS Organizations, see Quotas for
//   AWS Organizations (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html)in
//   the AWS Organizations User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DescribeHandshake
func (c *Organizations) DescribeHandshake(input *DescribeHandshakeInput) (*DescribeHandshakeOutput, error) {
	req, out := c.DescribeHandshakeRequest(input)
	return out, req.Send()
}

// DescribeHandshakeWithContext is the same as DescribeHandshake with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeHandshake for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) DescribeHandshakeWithContext(ctx aws.Context, input *DescribeHandshakeInput, opts ...request.Option) (*DescribeHandshakeOutput, error) {
	req, out := c.DescribeHandshakeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeOrganization = "DescribeOrganization"

// DescribeOrganizationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeOrganization operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeOrganization for more information on using the DescribeOrganization
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeOrganizationRequest method.
//    req, resp := client.DescribeOrganizationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DescribeOrganization
func (c *Organizations) DescribeOrganizationRequest(input *DescribeOrganizationInput) (req *request.Request, output *DescribeOrganizationOutput) {
	op := &request.Operation{
		Name:       opDescribeOrganization,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeOrganizationInput{}
	}

	output = &DescribeOrganizationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeOrganization API operation for AWS Organizations.
//
// Retrieves information about the organization that the user's account belongs
// to.
//
// This operation can be called from any account in the organization.
//
// Even if a policy type is shown as available in the organization, you can
// disable it separately at the root level with DisablePolicyType. Use ListRoots
// to see the status of policy types for a specified root.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation DescribeOrganization for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * AWSOrganizationsNotInUseException
//   Your account isn't a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * ConcurrentModificationException
//   The target of the operation is currently being modified by a different request.
//   Try again later.
//
//   * ServiceException
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * TooManyRequestsException
//   You have sent too many requests in too short a period of time. The quota
//   helps protect against denial-of-service attacks. Try again later.
//
//   For information about quotas that affect AWS Organizations, see Quotas for
//   AWS Organizations (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html)in
//   the AWS Organizations User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DescribeOrganization
func (c *Organizations) DescribeOrganization(input *DescribeOrganizationInput) (*DescribeOrganizationOutput, error) {
	req, out := c.DescribeOrganizationRequest(input)
	return out, req.Send()
}

// DescribeOrganizationWithContext is the same as DescribeOrganization with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeOrganization for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) DescribeOrganizationWithContext(ctx aws.Context, input *DescribeOrganizationInput, opts ...request.Option) (*DescribeOrganizationOutput, error) {
	req, out := c.DescribeOrganizationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeOrganizationalUnit = "DescribeOrganizationalUnit"

// DescribeOrganizationalUnitRequest generates a "aws/request.Request" representing the
// client's request for the DescribeOrganizationalUnit operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeOrganizationalUnit for more information on using the DescribeOrganizationalUnit
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeOrganizationalUnitRequest method.
//    req, resp := client.DescribeOrganizationalUnitRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DescribeOrganizationalUnit
func (c *Organizations) DescribeOrganizationalUnitRequest(input *DescribeOrganizationalUnitInput) (req *request.Request, output *DescribeOrganizationalUnitOutput) {
	op := &request.Operation{
		Name:       opDescribeOrganizationalUnit,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeOrganizationalUnitInput{}
	}

	output = &DescribeOrganizationalUnitOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeOrganizationalUnit API operation for AWS Organizations.
//
// Retrieves information about an organizational unit (OU).
//
// This operation can be called only from the organization's master account
// or by a member account that is a delegated administrator for an AWS service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation DescribeOrganizationalUnit for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * AWSOrganizationsNotInUseException
//   Your account isn't a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * InvalidInputException
//   The requested operation failed because you provided invalid values for one
//   or more of the request parameters. This exception includes a reason that
//   contains additional information about the violated limit:
//
//   Some of the reasons in the following list might not be applicable to this
//   specific API or operation.
//
//      * DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to
//      the same entity.
//
//      * IMMUTABLE_POLICY: You specified a policy that is managed by AWS and
//      can't be modified.
//
//      * INPUT_REQUIRED: You must include a value for all required parameters.
//
//      * INVALID_ENUM: You specified an invalid value.
//
//      * INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
//
//      * INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid
//      characters.
//
//      * INVALID_LIST_MEMBER: You provided a list to a parameter that contains
//      at least one invalid value.
//
//      * INVALID_PAGINATION_TOKEN: Get the value for the NextToken parameter
//      from the response to a previous call of the operation.
//
//      * INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account,
//      organization, or email) as a party.
//
//      * INVALID_PATTERN: You provided a value that doesn't match the required
//      pattern.
//
//      * INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't
//      match the required pattern.
//
//      * INVALID_ROLE_NAME: You provided a role name that isn't valid. A role
//      name can't begin with the reserved prefix AWSServiceRoleFor.
//
//      * INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource
//      Name (ARN) for the organization.
//
//      * INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
//
//      * INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system
//      tag. You can’t add, edit, or delete system tag keys because they're
//      reserved for AWS use. System tags don’t count against your tags per
//      resource limit.
//
//      * MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter
//      for the operation.
//
//      * MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer
//      than allowed.
//
//      * MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger
//      value than allowed.
//
//      * MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter
//      than allowed.
//
//      * MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller
//      value than allowed.
//
//      * MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only
//      between entities in the same root.
//
//      * TARGET_NOT_SUPPORTED: You can't perform the specified operation on that
//      target entity.
//
//      * UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that
//      isn't recognized.
//
//   * OrganizationalUnitNotFoundException
//   We can't find an OU with the OrganizationalUnitId that you specified.
//
//   * ServiceException
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * TooManyRequestsException
//   You have sent too many requests in too short a period of time. The quota
//   helps protect against denial-of-service attacks. Try again later.
//
//   For information about quotas that affect AWS Organizations, see Quotas for
//   AWS Organizations (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html)in
//   the AWS Organizations User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DescribeOrganizationalUnit
func (c *Organizations) DescribeOrganizationalUnit(input *DescribeOrganizationalUnitInput) (*DescribeOrganizationalUnitOutput, error) {
	req, out := c.DescribeOrganizationalUnitRequest(input)
	return out, req.Send()
}

// DescribeOrganizationalUnitWithContext is the same as DescribeOrganizationalUnit with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeOrganizationalUnit for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) DescribeOrganizationalUnitWithContext(ctx aws.Context, input *DescribeOrganizationalUnitInput, opts ...request.Option) (*DescribeOrganizationalUnitOutput, error) {
	req, out := c.DescribeOrganizationalUnitRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribePolicy = "DescribePolicy"

// DescribePolicyRequest generates a "aws/request.Request" representing the
// client's request for the DescribePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribePolicy for more information on using the DescribePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribePolicyRequest method.
//    req, resp := client.DescribePolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DescribePolicy
func (c *Organizations) DescribePolicyRequest(input *DescribePolicyInput) (req *request.Request, output *DescribePolicyOutput) {
	op := &request.Operation{
		Name:       opDescribePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribePolicyInput{}
	}

	output = &DescribePolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribePolicy API operation for AWS Organizations.
//
// Retrieves information about a policy.
//
// This operation can be called only from the organization's master account
// or by a member account that is a delegated administrator for an AWS service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation DescribePolicy for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * AWSOrganizationsNotInUseException
//   Your account isn't a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * InvalidInputException
//   The requested operation failed because you provided invalid values for one
//   or more of the request parameters. This exception includes a reason that
//   contains additional information about the violated limit:
//
//   Some of the reasons in the following list might not be applicable to this
//   specific API or operation.
//
//      * DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to
//      the same entity.
//
//      * IMMUTABLE_POLICY: You specified a policy that is managed by AWS and
//      can't be modified.
//
//      * INPUT_REQUIRED: You must include a value for all required parameters.
//
//      * INVALID_ENUM: You specified an invalid value.
//
//      * INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
//
//      * INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid
//      characters.
//
//      * INVALID_LIST_MEMBER: You provided a list to a parameter that contains
//      at least one invalid value.
//
//      * INVALID_PAGINATION_TOKEN: Get the value for the NextToken parameter
//      from the response to a previous call of the operation.
//
//      * INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account,
//      organization, or email) as a party.
//
//      * INVALID_PATTERN: You provided a value that doesn't match the required
//      pattern.
//
//      * INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't
//      match the required pattern.
//
//      * INVALID_ROLE_NAME: You provided a role name that isn't valid. A role
//      name can't begin with the reserved prefix AWSServiceRoleFor.
//
//      * INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource
//      Name (ARN) for the organization.
//
//      * INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
//
//      * INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system
//      tag. You can’t add, edit, or delete system tag keys because they're
//      reserved for AWS use. System tags don’t count against your tags per
//      resource limit.
//
//      * MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter
//      for the operation.
//
//      * MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer
//      than allowed.
//
//      * MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger
//      value than allowed.
//
//      * MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter
//      than allowed.
//
//      * MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller
//      value than allowed.
//
//      * MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only
//      between entities in the same root.
//
//      * TARGET_NOT_SUPPORTED: You can't perform the specified operation on that
//      target entity.
//
//      * UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that
//      isn't recognized.
//
//   * PolicyNotFoundException
//   We can't find a policy with the PolicyId that you specified.
//
//   * ServiceException
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * TooManyRequestsException
//   You have sent too many requests in too short a period of time. The quota
//   helps protect against denial-of-service attacks. Try again later.
//
//   For information about quotas that affect AWS Organizations, see Quotas for
//   AWS Organizations (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html)in
//   the AWS Organizations User Guide.
//
//   * UnsupportedAPIEndpointException
//   This action isn't available in the current AWS Region.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DescribePolicy
func (c *Organizations) DescribePolicy(input *DescribePolicyInput) (*DescribePolicyOutput, error) {
	req, out := c.DescribePolicyRequest(input)
	return out, req.Send()
}

// DescribePolicyWithContext is the same as DescribePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DescribePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) DescribePolicyWithContext(ctx aws.Context, input *DescribePolicyInput, opts ...request.Option) (*DescribePolicyOutput, error) {
	req, out := c.DescribePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDetachPolicy = "DetachPolicy"

// DetachPolicyRequest generates a "aws/request.Request" representing the
// client's request for the DetachPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DetachPolicy for more information on using the DetachPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DetachPolicyRequest method.
//    req, resp := client.DetachPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DetachPolicy
func (c *Organizations) DetachPolicyRequest(input *DetachPolicyInput) (req *request.Request, output *DetachPolicyOutput) {
	op := &request.Operation{
		Name:       opDetachPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetachPolicyInput{}
	}

	output = &DetachPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DetachPolicy API operation for AWS Organizations.
//
// Detaches a policy from a target root, organizational unit (OU), or account.
//
// If the policy being detached is a service control policy (SCP), the changes
// to permissions for AWS Identity and Access Management (IAM) users and roles
// in affected accounts are immediate.
//
// Every root, OU, and account must have at least one SCP attached. If you want
// to replace the default FullAWSAccess policy with an SCP that limits the permissions
// that can be delegated, you must attach the replacement SCP before you can
// remove the default SCP. This is the authorization strategy of an "allow list
// (https://docs.aws.amazon.com/organizations/latest/userguide/SCP_strategies.html#orgs_policies_allowlist)".
// If you instead attach a second SCP and leave the FullAWSAccess SCP still
// attached, and specify "Effect": "Deny" in the second SCP to override the
// "Effect": "Allow" in the FullAWSAccess policy (or any other attached SCP),
// you're using the authorization strategy of a "deny list (https://docs.aws.amazon.com/organizations/latest/userguide/SCP_strategies.html#orgs_policies_denylist)".
//
// This operation can be called only from the organization's master account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation DetachPolicy for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * AWSOrganizationsNotInUseException
//   Your account isn't a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * ConcurrentModificationException
//   The target of the operation is currently being modified by a different request.
//   Try again later.
//
//   * ConstraintViolationException
//   Performing this operation violates a minimum or maximum value limit. For
//   example, attempting to remove the last service control policy (SCP) from
//   an OU or root, inviting or creating too many accounts to the organization,
//   or attaching too many policies to an account, OU, or root. This exception
//   includes a reason that contains additional information about the violated
//   limit:
//
//   Some of the reasons in the following list might not be applicable to this
//   specific API or operation.
//
//      * ACCOUNT_CANNOT_LEAVE_ORGANIZAION: You attempted to remove the master
//      account from the organization. You can't remove the master account. Instead,
//      after you remove all member accounts, delete the organization itself.
//
//      * ACCOUNT_CANNOT_LEAVE_WITHOUT_EULA: You attempted to remove an account
//      from the organization that doesn't yet have enough information to exist
//      as a standalone account. This account requires you to first agree to the
//      AWS Customer Agreement. Follow the steps at Removing a member account
//      from your organization (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master)in
//      the AWS Organizations User Guide.
//
//      * ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove
//      an account from the organization that doesn't yet have enough information
//      to exist as a standalone account. This account requires you to first complete
//      phone verification. Follow the steps at Removing a member account from
//      your organization (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master)
//      in the AWS Organizations User Guide.
//
//      * ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number
//      of accounts that you can create in one day.
//
//      * ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on
//      the number of accounts in an organization. If you need more accounts,
//      contact AWS Support (https://console.aws.amazon.com/support/home#/) to
//      request an increase in your limit. Or the number of invitations that you
//      tried to send would cause you to exceed the limit of accounts in your
//      organization. Send fewer invitations or contact AWS Support to request
//      an increase in the number of accounts. Deleted and closed accounts still
//      count toward your limit. If you get this exception when running a command
//      immediately after creating the organization, wait one hour and try again.
//      After an hour, if the command continues to fail with this error, contact
//      AWS Support (https://console.aws.amazon.com/support/home#/).
//
//      * CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to
//      register the master account of the organization as a delegated administrator
//      for an AWS service integrated with Organizations. You can designate only
//      a member account as a delegated administrator.
//
//      * CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove
//      an account that is registered as a delegated administrator for a service
//      integrated with your organization. To complete this operation, you must
//      first deregister this account as a delegated administrator.
//
//      * CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an
//      organization in the specified region, you must enable all features mode.
//
//      * DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register
//      an AWS account as a delegated administrator for an AWS service that already
//      has a delegated administrator. To complete this operation, you must first
//      deregister any existing delegated administrators for this service.
//
//      * EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only
//      valid for a limited period of time. You must resubmit the request and
//      generate a new verfication code.
//
//      * HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of
//      handshakes that you can send in one day.
//
//      * MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account
//      in this organization, you first must migrate the organization's master
//      account to the marketplace that corresponds to the master account's address.
//      For example, accounts with India addresses must be associated with the
//      AISPL marketplace. All accounts in an organization must be associated
//      with the same marketplace.
//
//      * MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the AWS Regions
//      in China. To create an organization, the master must have an valid business
//      license. For more information, contact customer support.
//
//      * MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you
//      must first provide a valid contact address and phone number for the master
//      account. Then try the operation again.
//
//      * MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the
//      master account must have an associated account in the AWS GovCloud (US-West)
//      Region. For more information, see AWS Organizations (http://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html)
//      in the AWS GovCloud User Guide.
//
//      * MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization
//      with this master account, you first must associate a valid payment instrument,
//      such as a credit card, with the account. Follow the steps at To leave
//      an organization when all required account information has not yet been
//      provided (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info)
//      in the AWS Organizations User Guide.
//
//      * MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted
//      to register more delegated administrators than allowed for the service
//      principal.
//
//      * MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the
//      number of policies of a certain type that can be attached to an entity
//      at one time.
//
//      * MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed
//      on this resource.
//
//      * MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation
//      with this member account, you first must associate a valid payment instrument,
//      such as a credit card, with the account. Follow the steps at To leave
//      an organization when all required account information has not yet been
//      provided (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info)
//      in the AWS Organizations User Guide.
//
//      * MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a
//      policy from an entity that would cause the entity to have fewer than the
//      minimum number of policies of a certain type required.
//
//      * ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation
//      that requires the organization to be configured to support all features.
//      An organization that supports only consolidated billing features can't
//      perform this operation.
//
//      * OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is
//      too many levels deep.
//
//      * OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs
//      that you can have in an organization.
//
//      * POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that
//      is larger than the maximum size.
//
//      * POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of
//      policies that you can have in an organization.
//
//      * TAG_POLICY_VIOLATION: You attempted to create or update a resource with
//      tags that are not compliant with the tag policy requirements for this
//      account.
//
//   * InvalidInputException
//   The requested operation failed because you provided invalid values for one
//   or more of the request parameters. This exception includes a reason that
//   contains additional information about the violated limit:
//
//   Some of the reasons in the following list might not be applicable to this
//   specific API or operation.
//
//      * DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to
//      the same entity.
//
//      * IMMUTABLE_POLICY: You specified a policy that is managed by AWS and
//      can't be modified.
//
//      * INPUT_REQUIRED: You must include a value for all required parameters.
//
//      * INVALID_ENUM: You specified an invalid value.
//
//      * INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
//
//      * INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid
//      characters.
//
//      * INVALID_LIST_MEMBER: You provided a list to a parameter that contains
//      at least one invalid value.
//
//      * INVALID_PAGINATION_TOKEN: Get the value for the NextToken parameter
//      from the response to a previous call of the operation.
//
//      * INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account,
//      organization, or email) as a party.
//
//      * INVALID_PATTERN: You provided a value that doesn't match the required
//      pattern.
//
//      * INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't
//      match the required pattern.
//
//      * INVALID_ROLE_NAME: You provided a role name that isn't valid. A role
//      name can't begin with the reserved prefix AWSServiceRoleFor.
//
//      * INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource
//      Name (ARN) for the organization.
//
//      * INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
//
//      * INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system
//      tag. You can’t add, edit, or delete system tag keys because they're
//      reserved for AWS use. System tags don’t count against your tags per
//      resource limit.
//
//      * MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter
//      for the operation.
//
//      * MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer
//      than allowed.
//
//      * MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger
//      value than allowed.
//
//      * MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter
//      than allowed.
//
//      * MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller
//      value than allowed.
//
//      * MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only
//      between entities in the same root.
//
//      * TARGET_NOT_SUPPORTED: You can't perform the specified operation on that
//      target entity.
//
//      * UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that
//      isn't recognized.
//
//   * PolicyNotAttachedException
//   The policy isn't attached to the specified target in the specified root.
//
//   * PolicyNotFoundException
//   We can't find a policy with the PolicyId that you specified.
//
//   * ServiceException
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * TargetNotFoundException
//   We can't find a root, OU, account, or policy with the TargetId that you specified.
//
//   * TooManyRequestsException
//   You have sent too many requests in too short a period of time. The quota
//   helps protect against denial-of-service attacks. Try again later.
//
//   For information about quotas that affect AWS Organizations, see Quotas for
//   AWS Organizations (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html)in
//   the AWS Organizations User Guide.
//
//   * UnsupportedAPIEndpointException
//   This action isn't available in the current AWS Region.
//
//   * PolicyChangesInProgressException
//   Changes to the effective policy are in progress, and its contents can't be
//   returned. Try the operation again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DetachPolicy
func (c *Organizations) DetachPolicy(input *DetachPolicyInput) (*DetachPolicyOutput, error) {
	req, out := c.DetachPolicyRequest(input)
	return out, req.Send()
}

// DetachPolicyWithContext is the same as DetachPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DetachPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) DetachPolicyWithContext(ctx aws.Context, input *DetachPolicyInput, opts ...request.Option) (*DetachPolicyOutput, error) {
	req, out := c.DetachPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisableAWSServiceAccess = "DisableAWSServiceAccess"

// DisableAWSServiceAccessRequest generates a "aws/request.Request" representing the
// client's request for the DisableAWSServiceAccess operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisableAWSServiceAccess for more information on using the DisableAWSServiceAccess
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisableAWSServiceAccessRequest method.
//    req, resp := client.DisableAWSServiceAccessRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DisableAWSServiceAccess
func (c *Organizations) DisableAWSServiceAccessRequest(input *DisableAWSServiceAccessInput) (req *request.Request, output *DisableAWSServiceAccessOutput) {
	op := &request.Operation{
		Name:       opDisableAWSServiceAccess,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisableAWSServiceAccessInput{}
	}

	output = &DisableAWSServiceAccessOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisableAWSServiceAccess API operation for AWS Organizations.
//
// Disables the integration of an AWS service (the service that is specified
// by ServicePrincipal) with AWS Organizations. When you disable integration,
// the specified service no longer can create a service-linked role (http://docs.aws.amazon.com/IAM/latest/UserGuide/using-service-linked-roles.html)
// in new accounts in your organization. This means the service can't perform
// operations on your behalf on any new accounts in your organization. The service
// can still perform operations in older accounts until the service completes
// its clean-up from AWS Organizations.
//
// We recommend that you disable integration between AWS Organizations and the
// specified AWS service by using the console or commands that are provided
// by the specified service. Doing so ensures that the other service is aware
// that it can clean up any resources that are required only for the integration.
// How the service cleans up its resources in the organization's accounts depends
// on that service. For more information, see the documentation for the other
// AWS service.
//
// After you perform the DisableAWSServiceAccess operation, the specified service
// can no longer perform operations in your organization's accounts unless the
// operations are explicitly permitted by the IAM policies that are attached
// to your roles.
//
// For more information about integrating other services with AWS Organizations,
// including the list of services that work with Organizations, see Integrating
// AWS Organizations with Other AWS Services (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html)
// in the AWS Organizations User Guide.
//
// This operation can be called only from the organization's master account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation DisableAWSServiceAccess for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * AWSOrganizationsNotInUseException
//   Your account isn't a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * ConcurrentModificationException
//   The target of the operation is currently being modified by a different request.
//   Try again later.
//
//   * ConstraintViolationException
//   Performing this operation violates a minimum or maximum value limit. For
//   example, attempting to remove the last service control policy (SCP) from
//   an OU or root, inviting or creating too many accounts to the organization,
//   or attaching too many policies to an account, OU, or root. This exception
//   includes a reason that contains additional information about the violated
//   limit:
//
//   Some of the reasons in the following list might not be applicable to this
//   specific API or operation.
//
//      * ACCOUNT_CANNOT_LEAVE_ORGANIZAION: You attempted to remove the master
//      account from the organization. You can't remove the master account. Instead,
//      after you remove all member accounts, delete the organization itself.
//
//      * ACCOUNT_CANNOT_LEAVE_WITHOUT_EULA: You attempted to remove an account
//      from the organization that doesn't yet have enough information to exist
//      as a standalone account. This account requires you to first agree to the
//      AWS Customer Agreement. Follow the steps at Removing a member account
//      from your organization (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master)in
//      the AWS Organizations User Guide.
//
//      * ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove
//      an account from the organization that doesn't yet have enough information
//      to exist as a standalone account. This account requires you to first complete
//      phone verification. Follow the steps at Removing a member account from
//      your organization (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master)
//      in the AWS Organizations User Guide.
//
//      * ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number
//      of accounts that you can create in one day.
//
//      * ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on
//      the number of accounts in an organization. If you need more accounts,
//      contact AWS Support (https://console.aws.amazon.com/support/home#/) to
//      request an increase in your limit. Or the number of invitations that you
//      tried to send would cause you to exceed the limit of accounts in your
//      organization. Send fewer invitations or contact AWS Support to request
//      an increase in the number of accounts. Deleted and closed accounts still
//      count toward your limit. If you get this exception when running a command
//      immediately after creating the organization, wait one hour and try again.
//      After an hour, if the command continues to fail with this error, contact
//      AWS Support (https://console.aws.amazon.com/support/home#/).
//
//      * CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to
//      register the master account of the organization as a delegated administrator
//      for an AWS service integrated with Organizations. You can designate only
//      a member account as a delegated administrator.
//
//      * CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove
//      an account that is registered as a delegated administrator for a service
//      integrated with your organization. To complete this operation, you must
//      first deregister this account as a delegated administrator.
//
//      * CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an
//      organization in the specified region, you must enable all features mode.
//
//      * DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register
//      an AWS account as a delegated administrator for an AWS service that already
//      has a delegated administrator. To complete this operation, you must first
//      deregister any existing delegated administrators for this service.
//
//      * EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only
//      valid for a limited period of time. You must resubmit the request and
//      generate a new verfication code.
//
//      * HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of
//      handshakes that you can send in one day.
//
//      * MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account
//      in this organization, you first must migrate the organization's master
//      account to the marketplace that corresponds to the master account's address.
//      For example, accounts with India addresses must be associated with the
//      AISPL marketplace. All accounts in an organization must be associated
//      with the same marketplace.
//
//      * MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the AWS Regions
//      in China. To create an organization, the master must have an valid business
//      license. For more information, contact customer support.
//
//      * MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you
//      must first provide a valid contact address and phone number for the master
//      account. Then try the operation again.
//
//      * MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the
//      master account must have an associated account in the AWS GovCloud (US-West)
//      Region. For more information, see AWS Organizations (http://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html)
//      in the AWS GovCloud User Guide.
//
//      * MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization
//      with this master account, you first must associate a valid payment instrument,
//      such as a credit card, with the account. Follow the steps at To leave
//      an organization when all required account information has not yet been
//      provided (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info)
//      in the AWS Organizations User Guide.
//
//      * MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted
//      to register more delegated administrators than allowed for the service
//      principal.
//
//      * MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the
//      number of policies of a certain type that can be attached to an entity
//      at one time.
//
//      * MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed
//      on this resource.
//
//      * MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation
//      with this member account, you first must associate a valid payment instrument,
//      such as a credit card, with the account. Follow the steps at To leave
//      an organization when all required account information has not yet been
//      provided (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info)
//      in the AWS Organizations User Guide.
//
//      * MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a
//      policy from an entity that would cause the entity to have fewer than the
//      minimum number of policies of a certain type required.
//
//      * ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation
//      that requires the organization to be configured to support all features.
//      An organization that supports only consolidated billing features can't
//      perform this operation.
//
//      * OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is
//      too many levels deep.
//
//      * OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs
//      that you can have in an organization.
//
//      * POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that
//      is larger than the maximum size.
//
//      * POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of
//      policies that you can have in an organization.
//
//      * TAG_POLICY_VIOLATION: You attempted to create or update a resource with
//      tags that are not compliant with the tag policy requirements for this
//      account.
//
//   * InvalidInputException
//   The requested operation failed because you provided invalid values for one
//   or more of the request parameters. This exception includes a reason that
//   contains additional information about the violated limit:
//
//   Some of the reasons in the following list might not be applicable to this
//   specific API or operation.
//
//      * DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to
//      the same entity.
//
//      * IMMUTABLE_POLICY: You specified a policy that is managed by AWS and
//      can't be modified.
//
//      * INPUT_REQUIRED: You must include a value for all required parameters.
//
//      * INVALID_ENUM: You specified an invalid value.
//
//      * INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
//
//      * INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid
//      characters.
//
//      * INVALID_LIST_MEMBER: You provided a list to a parameter that contains
//      at least one invalid value.
//
//      * INVALID_PAGINATION_TOKEN: Get the value for the NextToken parameter
//      from the response to a previous call of the operation.
//
//      * INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account,
//      organization, or email) as a party.
//
//      * INVALID_PATTERN: You provided a value that doesn't match the required
//      pattern.
//
//      * INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't
//      match the required pattern.
//
//      * INVALID_ROLE_NAME: You provided a role name that isn't valid. A role
//      name can't begin with the reserved prefix AWSServiceRoleFor.
//
//      * INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource
//      Name (ARN) for the organization.
//
//      * INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
//
//      * INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system
//      tag. You can’t add, edit, or delete system tag keys because they're
//      reserved for AWS use. System tags don’t count against your tags per
//      resource limit.
//
//      * MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter
//      for the operation.
//
//      * MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer
//      than allowed.
//
//      * MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger
//      value than allowed.
//
//      * MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter
//      than allowed.
//
//      * MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller
//      value than allowed.
//
//      * MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only
//      between entities in the same root.
//
//      * TARGET_NOT_SUPPORTED: You can't perform the specified operation on that
//      target entity.
//
//      * UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that
//      isn't recognized.
//
//   * ServiceException
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * TooManyRequestsException
//   You have sent too many requests in too short a period of time. The quota
//   helps protect against denial-of-service attacks. Try again later.
//
//   For information about quotas that affect AWS Organizations, see Quotas for
//   AWS Organizations (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html)in
//   the AWS Organizations User Guide.
//
//   * UnsupportedAPIEndpointException
//   This action isn't available in the current AWS Region.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DisableAWSServiceAccess
func (c *Organizations) DisableAWSServiceAccess(input *DisableAWSServiceAccessInput) (*DisableAWSServiceAccessOutput, error) {
	req, out := c.DisableAWSServiceAccessRequest(input)
	return out, req.Send()
}

// DisableAWSServiceAccessWithContext is the same as DisableAWSServiceAccess with the addition of
// the ability to pass a context and additional request options.
//
// See DisableAWSServiceAccess for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) DisableAWSServiceAccessWithContext(ctx aws.Context, input *DisableAWSServiceAccessInput, opts ...request.Option) (*DisableAWSServiceAccessOutput, error) {
	req, out := c.DisableAWSServiceAccessRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisablePolicyType = "DisablePolicyType"

// DisablePolicyTypeRequest generates a "aws/request.Request" representing the
// client's request for the DisablePolicyType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisablePolicyType for more information on using the DisablePolicyType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisablePolicyTypeRequest method.
//    req, resp := client.DisablePolicyTypeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DisablePolicyType
func (c *Organizations) DisablePolicyTypeRequest(input *DisablePolicyTypeInput) (req *request.Request, output *DisablePolicyTypeOutput) {
	op := &request.Operation{
		Name:       opDisablePolicyType,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisablePolicyTypeInput{}
	}

	output = &DisablePolicyTypeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisablePolicyType API operation for AWS Organizations.
//
// Disables an organizational policy type in a root. A policy of a certain type
// can be attached to entities in a root only if that type is enabled in the
// root. After you perform this operation, you no longer can attach policies
// of the specified type to that root or to any organizational unit (OU) or
// account in that root. You can undo this by using the EnablePolicyType operation.
//
// This is an asynchronous request that AWS performs in the background. If you
// disable a policy type for a root, it still appears enabled for the organization
// if all features (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html)
// are enabled for the organization. AWS recommends that you first use ListRoots
// to see the status of policy types for a specified root, and then use this
// operation.
//
// This operation can be called only from the organization's master account.
//
// To view the status of available policy types in the organization, use DescribeOrganization.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation DisablePolicyType for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * AWSOrganizationsNotInUseException
//   Your account isn't a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * ConcurrentModificationException
//   The target of the operation is currently being modified by a different request.
//   Try again later.
//
//   * ConstraintViolationException
//   Performing this operation violates a minimum or maximum value limit. For
//   example, attempting to remove the last service control policy (SCP) from
//   an OU or root, inviting or creating too many accounts to the organization,
//   or attaching too many policies to an account, OU, or root. This exception
//   includes a reason that contains additional information about the violated
//   limit:
//
//   Some of the reasons in the following list might not be applicable to this
//   specific API or operation.
//
//      * ACCOUNT_CANNOT_LEAVE_ORGANIZAION: You attempted to remove the master
//      account from the organization. You can't remove the master account. Instead,
//      after you remove all member accounts, delete the organization itself.
//
//      * ACCOUNT_CANNOT_LEAVE_WITHOUT_EULA: You attempted to remove an account
//      from the organization that doesn't yet have enough information to exist
//      as a standalone account. This account requires you to first agree to the
//      AWS Customer Agreement. Follow the steps at Removing a member account
//      from your organization (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master)in
//      the AWS Organizations User Guide.
//
//      * ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove
//      an account from the organization that doesn't yet have enough information
//      to exist as a standalone account. This account requires you to first complete
//      phone verification. Follow the steps at Removing a member account from
//      your organization (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master)
//      in the AWS Organizations User Guide.
//
//      * ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number
//      of accounts that you can create in one day.
//
//      * ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on
//      the number of accounts in an organization. If you need more accounts,
//      contact AWS Support (https://console.aws.amazon.com/support/home#/) to
//      request an increase in your limit. Or the number of invitations that you
//      tried to send would cause you to exceed the limit of accounts in your
//      organization. Send fewer invitations or contact AWS Support to request
//      an increase in the number of accounts. Deleted and closed accounts still
//      count toward your limit. If you get this exception when running a command
//      immediately after creating the organization, wait one hour and try again.
//      After an hour, if the command continues to fail with this error, contact
//      AWS Support (https://console.aws.amazon.com/support/home#/).
//
//      * CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to
//      register the master account of the organization as a delegated administrator
//      for an AWS service integrated with Organizations. You can designate only
//      a member account as a delegated administrator.
//
//      * CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove
//      an account that is registered as a delegated administrator for a service
//      integrated with your organization. To complete this operation, you must
//      first deregister this account as a delegated administrator.
//
//      * CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an
//      organization in the specified region, you must enable all features mode.
//
//      * DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register
//      an AWS account as a delegated administrator for an AWS service that already
//      has a delegated administrator. To complete this operation, you must first
//      deregister any existing delegated administrators for this service.
//
//      * EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only
//      valid for a limited period of time. You must resubmit the request and
//      generate a new verfication code.
//
//      * HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of
//      handshakes that you can send in one day.
//
//      * MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account
//      in this organization, you first must migrate the organization's master
//      account to the marketplace that corresponds to the master account's address.
//      For example, accounts with India addresses must be associated with the
//      AISPL marketplace. All accounts in an organization must be associated
//      with the same marketplace.
//
//      * MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the AWS Regions
//      in China. To create an organization, the master must have an valid business
//      license. For more information, contact customer support.
//
//      * MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you
//      must first provide a valid contact address and phone number for the master
//      account. Then try the operation again.
//
//      * MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the
//      master account must have an associated account in the AWS GovCloud (US-West)
//      Region. For more information, see AWS Organizations (http://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html)
//      in the AWS GovCloud User Guide.
//
//      * MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization
//      with this master account, you first must associate a valid payment instrument,
//      such as a credit card, with the account. Follow the steps at To leave
//      an organization when all required account information has not yet been
//      provided (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info)
//      in the AWS Organizations User Guide.
//
//      * MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted
//      to register more delegated administrators than allowed for the service
//      principal.
//
//      * MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the
//      number of policies of a certain type that can be attached to an entity
//      at one time.
//
//      * MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed
//      on this resource.
//
//      * MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation
//      with this member account, you first must associate a valid payment instrument,
//      such as a credit card, with the account. Follow the steps at To leave
//      an organization when all required account information has not yet been
//      provided (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info)
//      in the AWS Organizations User Guide.
//
//      * MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a
//      policy from an entity that would cause the entity to have fewer than the
//      minimum number of policies of a certain type required.
//
//      * ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation
//      that requires the organization to be configured to support all features.
//      An organization that supports only consolidated billing features can't
//      perform this operation.
//
//      * OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is
//      too many levels deep.
//
//      * OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs
//      that you can have in an organization.
//
//      * POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that
//      is larger than the maximum size.
//
//      * POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of
//      policies that you can have in an organization.
//
//      * TAG_POLICY_VIOLATION: You attempted to create or update a resource with
//      tags that are not compliant with the tag policy requirements for this
//      account.
//
//   * InvalidInputException
//   The requested operation failed because you provided invalid values for one
//   or more of the request parameters. This exception includes a reason that
//   contains additional information about the violated limit:
//
//   Some of the reasons in the following list might not be applicable to this
//   specific API or operation.
//
//      * DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to
//      the same entity.
//
//      * IMMUTABLE_POLICY: You specified a policy that is managed by AWS and
//      can't be modified.
//
//      * INPUT_REQUIRED: You must include a value for all required parameters.
//
//      * INVALID_ENUM: You specified an invalid value.
//
//      * INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
//
//      * INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid
//      characters.
//
//      * INVALID_LIST_MEMBER: You provided a list to a parameter that contains
//      at least one invalid value.
//
//      * INVALID_PAGINATION_TOKEN: Get the value for the NextToken parameter
//      from the response to a previous call of the operation.
//
//      * INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account,
//      organization, or email) as a party.
//
//      * INVALID_PATTERN: You provided a value that doesn't match the required
//      pattern.
//
//      * INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't
//      match the required pattern.
//
//      * INVALID_ROLE_NAME: You provided a role name that isn't valid. A role
//      name can't begin with the reserved prefix AWSServiceRoleFor.
//
//      * INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource
//      Name (ARN) for the organization.
//
//      * INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
//
//      * INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system
//      tag. You can’t add, edit, or delete system tag keys because they're
//      reserved for AWS use. System tags don’t count against your tags per
//      resource limit.
//
//      * MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter
//      for the operation.
//
//      * MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer
//      than allowed.
//
//      * MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger
//      value than allowed.
//
//      * MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter
//      than allowed.
//
//      * MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller
//      value than allowed.
//
//      * MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only
//      between entities in the same root.
//
//      * TARGET_NOT_SUPPORTED: You can't perform the specified operation on that
//      target entity.
//
//      * UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that
//      isn't recognized.
//
//   * PolicyTypeNotEnabledException
//   The specified policy type isn't currently enabled in this root. You can't
//   attach policies of the specified type to entities in a root until you enable
//   that type in the root. For more information, see Enabling All Features in
//   Your Organization (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html)
//   in the AWS Organizations User Guide.
//
//   * RootNotFoundException
//   We can't find a root with the RootId that you specified.
//
//   * ServiceException
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * TooManyRequestsException
//   You have sent too many requests in too short a period of time. The quota
//   helps protect against denial-of-service attacks. Try again later.
//
//   For information about quotas that affect AWS Organizations, see Quotas for
//   AWS Organizations (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html)in
//   the AWS Organizations User Guide.
//
//   * UnsupportedAPIEndpointException
//   This action isn't available in the current AWS Region.
//
//   * PolicyChangesInProgressException
//   Changes to the effective policy are in progress, and its contents can't be
//   returned. Try the operation again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DisablePolicyType
func (c *Organizations) DisablePolicyType(input *DisablePolicyTypeInput) (*DisablePolicyTypeOutput, error) {
	req, out := c.DisablePolicyTypeRequest(input)
	return out, req.Send()
}

// DisablePolicyTypeWithContext is the same as DisablePolicyType with the addition of
// the ability to pass a context and additional request options.
//
// See DisablePolicyType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) DisablePolicyTypeWithContext(ctx aws.Context, input *DisablePolicyTypeInput, opts ...request.Option) (*DisablePolicyTypeOutput, error) {
	req, out := c.DisablePolicyTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opEnableAWSServiceAccess = "EnableAWSServiceAccess"

// EnableAWSServiceAccessRequest generates a "aws/request.Request" representing the
// client's request for the EnableAWSServiceAccess operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See EnableAWSServiceAccess for more information on using the EnableAWSServiceAccess
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the EnableAWSServiceAccessRequest method.
//    req, resp := client.EnableAWSServiceAccessRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/EnableAWSServiceAccess
func (c *Organizations) EnableAWSServiceAccessRequest(input *EnableAWSServiceAccessInput) (req *request.Request, output *EnableAWSServiceAccessOutput) {
	op := &request.Operation{
		Name:       opEnableAWSServiceAccess,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EnableAWSServiceAccessInput{}
	}

	output = &EnableAWSServiceAccessOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// EnableAWSServiceAccess API operation for AWS Organizations.
//
// Enables the integration of an AWS service (the service that is specified
// by ServicePrincipal) with AWS Organizations. When you enable integration,
// you allow the specified service to create a service-linked role (http://docs.aws.amazon.com/IAM/latest/UserGuide/using-service-linked-roles.html)
// in all the accounts in your organization. This allows the service to perform
// operations on your behalf in your organization and its accounts.
//
// We recommend that you enable integration between AWS Organizations and the
// specified AWS service by using the console or commands that are provided
// by the specified service. Doing so ensures that the service is aware that
// it can create the resources that are required for the integration. How the
// service creates those resources in the organization's accounts depends on
// that service. For more information, see the documentation for the other AWS
// service.
//
// For more information about enabling services to integrate with AWS Organizations,
// see Integrating AWS Organizations with Other AWS Services (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html)
// in the AWS Organizations User Guide.
//
// This operation can be called only from the organization's master account
// and only if the organization has enabled all features (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation EnableAWSServiceAccess for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * AWSOrganizationsNotInUseException
//   Your account isn't a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * ConcurrentModificationException
//   The target of the operation is currently being modified by a different request.
//   Try again later.
//
//   * ConstraintViolationException
//   Performing this operation violates a minimum or maximum value limit. For
//   example, attempting to remove the last service control policy (SCP) from
//   an OU or root, inviting or creating too many accounts to the organization,
//   or attaching too many policies to an account, OU, or root. This exception
//   includes a reason that contains additional information about the violated
//   limit:
//
//   Some of the reasons in the following list might not be applicable to this
//   specific API or operation.
//
//      * ACCOUNT_CANNOT_LEAVE_ORGANIZAION: You attempted to remove the master
//      account from the organization. You can't remove the master account. Instead,
//      after you remove all member accounts, delete the organization itself.
//
//      * ACCOUNT_CANNOT_LEAVE_WITHOUT_EULA: You attempted to remove an account
//      from the organization that doesn't yet have enough information to exist
//      as a standalone account. This account requires you to first agree to the
//      AWS Customer Agreement. Follow the steps at Removing a member account
//      from your organization (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master)in
//      the AWS Organizations User Guide.
//
//      * ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove
//      an account from the organization that doesn't yet have enough information
//      to exist as a standalone account. This account requires you to first complete
//      phone verification. Follow the steps at Removing a member account from
//      your organization (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master)
//      in the AWS Organizations User Guide.
//
//      * ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number
//      of accounts that you can create in one day.
//
//      * ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on
//      the number of accounts in an organization. If you need more accounts,
//      contact AWS Support (https://console.aws.amazon.com/support/home#/) to
//      request an increase in your limit. Or the number of invitations that you
//      tried to send would cause you to exceed the limit of accounts in your
//      organization. Send fewer invitations or contact AWS Support to request
//      an increase in the number of accounts. Deleted and closed accounts still
//      count toward your limit. If you get this exception when running a command
//      immediately after creating the organization, wait one hour and try again.
//      After an hour, if the command continues to fail with this error, contact
//      AWS Support (https://console.aws.amazon.com/support/home#/).
//
//      * CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to
//      register the master account of the organization as a delegated administrator
//      for an AWS service integrated with Organizations. You can designate only
//      a member account as a delegated administrator.
//
//      * CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove
//      an account that is registered as a delegated administrator for a service
//      integrated with your organization. To complete this operation, you must
//      first deregister this account as a delegated administrator.
//
//      * CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an
//      organization in the specified region, you must enable all features mode.
//
//      * DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register
//      an AWS account as a delegated administrator for an AWS service that already
//      has a delegated administrator. To complete this operation, you must first
//      deregister any existing delegated administrators for this service.
//
//      * EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only
//      valid for a limited period of time. You must resubmit the request and
//      generate a new verfication code.
//
//      * HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of
//      handshakes that you can send in one day.
//
//      * MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account
//      in this organization, you first must migrate the organization's master
//      account to the marketplace that corresponds to the master account's address.
//      For example, accounts with India addresses must be associated with the
//      AISPL marketplace. All accounts in an organization must be associated
//      with the same marketplace.
//
//      * MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the AWS Regions
//      in China. To create an organization, the master must have an valid business
//      license. For more information, contact customer support.
//
//      * MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you
//      must first provide a valid contact address and phone number for the master
//      account. Then try the operation again.
//
//      * MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the
//      master account must have an associated account in the AWS GovCloud (US-West)
//      Region. For more information, see AWS Organizations (http://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html)
//      in the AWS GovCloud User Guide.
//
//      * MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization
//      with this master account, you first must associate a valid payment instrument,
//      such as a credit card, with the account. Follow the steps at To leave
//      an organization when all required account information has not yet been
//      provided (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info)
//      in the AWS Organizations User Guide.
//
//      * MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted
//      to register more delegated administrators than allowed for the service
//      principal.
//
//      * MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the
//      number of policies of a certain type that can be attached to an entity
//      at one time.
//
//      * MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed
//      on this resource.
//
//      * MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation
//      with this member account, you first must associate a valid payment instrument,
//      such as a credit card, with the account. Follow the steps at To leave
//      an organization when all required account information has not yet been
//      provided (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info)
//      in the AWS Organizations User Guide.
//
//      * MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a
//      policy from an entity that would cause the entity to have fewer than the
//      minimum number of policies of a certain type required.
//
//      * ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation
//      that requires the organization to be configured to support all features.
//      An organization that supports only consolidated billing features can't
//      perform this operation.
//
//      * OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is
//      too many levels deep.
//
//      * OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs
//      that you can have in an organization.
//
//      * POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that
//      is larger than the maximum size.
//
//      * POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of
//      policies that you can have in an organization.
//
//      * TAG_POLICY_VIOLATION: You attempted to create or update a resource with
//      tags that are not compliant with the tag policy requirements for this
//      account.
//
//   * InvalidInputException
//   The requested operation failed because you provided invalid values for one
//   or more of the request parameters. This exception includes a reason that
//   contains additional information about the violated limit:
//
//   Some of the reasons in the following list might not be applicable to this
//   specific API or operation.
//
//      * DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to
//      the same entity.
//
//      * IMMUTABLE_POLICY: You specified a policy that is managed by AWS and
//      can't be modified.
//
//      * INPUT_REQUIRED: You must include a value for all required parameters.
//
//      * INVALID_ENUM: You specified an invalid value.
//
//      * INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
//
//      * INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid
//      characters.
//
//      * INVALID_LIST_MEMBER: You provided a list to a parameter that contains
//      at least one invalid value.
//
//      * INVALID_PAGINATION_TOKEN: Get the value for the NextToken parameter
//      from the response to a previous call of the operation.
//
//      * INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account,
//      organization, or email) as a party.
//
//      * INVALID_PATTERN: You provided a value that doesn't match the required
//      pattern.
//
//      * INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't
//      match the required pattern.
//
//      * INVALID_ROLE_NAME: You provided a role name that isn't valid. A role
//      name can't begin with the reserved prefix AWSServiceRoleFor.
//
//      * INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource
//      Name (ARN) for the organization.
//
//      * INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
//
//      * INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system
//      tag. You can’t add, edit, or delete system tag keys because they're
//      reserved for AWS use. System tags don’t count against your tags per
//      resource limit.
//
//      * MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter
//      for the operation.
//
//      * MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer
//      than allowed.
//
//      * MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger
//      value than allowed.
//
//      * MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter
//      than allowed.
//
//      * MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller
//      value than allowed.
//
//      * MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only
//      between entities in the same root.
//
//      * TARGET_NOT_SUPPORTED: You can't perform the specified operation on that
//      target entity.
//
//      * UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that
//      isn't recognized.
//
//   * ServiceException
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * TooManyRequestsException
//   You have sent too many requests in too short a period of time. The quota
//   helps protect against denial-of-service attacks. Try again later.
//
//   For information about quotas that affect AWS Organizations, see Quotas for
//   AWS Organizations (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html)in
//   the AWS Organizations User Guide.
//
//   * UnsupportedAPIEndpointException
//   This action isn't available in the current AWS Region.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/EnableAWSServiceAccess
func (c *Organizations) EnableAWSServiceAccess(input *EnableAWSServiceAccessInput) (*EnableAWSServiceAccessOutput, error) {
	req, out := c.EnableAWSServiceAccessRequest(input)
	return out, req.Send()
}

// EnableAWSServiceAccessWithContext is the same as EnableAWSServiceAccess with the addition of
// the ability to pass a context and additional request options.
//
// See EnableAWSServiceAccess for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) EnableAWSServiceAccessWithContext(ctx aws.Context, input *EnableAWSServiceAccessInput, opts ...request.Option) (*EnableAWSServiceAccessOutput, error) {
	req, out := c.EnableAWSServiceAccessRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opEnableAllFeatures = "EnableAllFeatures"

// EnableAllFeaturesRequest generates a "aws/request.Request" representing the
// client's request for the EnableAllFeatures operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See EnableAllFeatures for more information on using the EnableAllFeatures
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the EnableAllFeaturesRequest method.
//    req, resp := client.EnableAllFeaturesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/EnableAllFeatures
func (c *Organizations) EnableAllFeaturesRequest(input *EnableAllFeaturesInput) (req *request.Request, output *EnableAllFeaturesOutput) {
	op := &request.Operation{
		Name:       opEnableAllFeatures,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EnableAllFeaturesInput{}
	}

	output = &EnableAllFeaturesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// EnableAllFeatures API operation for AWS Organizations.
//
// Enables all features in an organization. This enables the use of organization
// policies that can restrict the services and actions that can be called in
// each account. Until you enable all features, you have access only to consolidated
// billing, and you can't use any of the advanced account administration features
// that AWS Organizations supports. For more information, see Enabling All Features
// in Your Organization (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html)
// in the AWS Organizations User Guide.
//
// This operation is required only for organizations that were created explicitly
// with only the consolidated billing features enabled. Calling this operation
// sends a handshake to every invited account in the organization. The feature
// set change can be finalized and the additional features enabled only after
// all administrators in the invited accounts approve the change by accepting
// the handshake.
//
// After you enable all features, you can separately enable or disable individual
// policy types in a root using EnablePolicyType and DisablePolicyType. To see
// the status of policy types in a root, use ListRoots.
//
// After all invited member accounts accept the handshake, you finalize the
// feature set change by accepting the handshake that contains "Action": "ENABLE_ALL_FEATURES".
// This completes the change.
//
// After you enable all features in your organization, the master account in
// the organization can apply policies on all member accounts. These policies
// can restrict what users and even administrators in those accounts can do.
// The master account can apply policies that prevent accounts from leaving
// the organization. Ensure that your account administrators are aware of this.
//
// This operation can be called only from the organization's master account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation EnableAllFeatures for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * AWSOrganizationsNotInUseException
//   Your account isn't a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * ConcurrentModificationException
//   The target of the operation is currently being modified by a different request.
//   Try again later.
//
//   * HandshakeConstraintViolationException
//   The requested operation would violate the constraint identified in the reason
//   code.
//
//   Some of the reasons in the following list might not be applicable to this
//   specific API or operation:
//
//      * ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on
//      the number of accounts in an organization. Note that deleted and closed
//      accounts still count toward your limit. If you get this exception immediately
//      after creating the organization, wait one hour and try again. If after
//      an hour it continues to fail with this error, contact AWS Support (https://console.aws.amazon.com/support/home#/).
//
//      * ALREADY_IN_AN_ORGANIZATION: The handshake request is invalid because
//      the invited account is already a member of an organization.
//
//      * HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of
//      handshakes that you can send in one day.
//
//      * INVITE_DISABLED_DURING_ENABLE_ALL_FEATURES: You can't issue new invitations
//      to join an organization while it's in the process of enabling all features.
//      You can resume inviting accounts after you finalize the process when all
//      accounts have agreed to the change.
//
//      * ORGANIZATION_ALREADY_HAS_ALL_FEATURES: The handshake request is invalid
//      because the organization has already enabled all features.
//
//      * ORGANIZATION_FROM_DIFFERENT_SELLER_OF_RECORD: The request failed because
//      the account is from a different marketplace than the accounts in the organization.
//      For example, accounts with India addresses must be associated with the
//      AISPL marketplace. All accounts in an organization must be from the same
//      marketplace.
//
//      * ORGANIZATION_MEMBERSHIP_CHANGE_RATE_LIMIT_EXCEEDED: You attempted to
//      change the membership of an account too quickly after its previous change.
//
//      * PAYMENT_INSTRUMENT_REQUIRED: You can't complete the operation with an
//      account that doesn't have a payment instrument, such as a credit card,
//      associated with it.
//
//   * InvalidInputException
//   The requested operation failed because you provided invalid values for one
//   or more of the request parameters. This exception includes a reason that
//   contains additional information about the violated limit:
//
//   Some of the reasons in the following list might not be applicable to this
//   specific API or operation.
//
//      * DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to
//      the same entity.
//
//      * IMMUTABLE_POLICY: You specified a policy that is managed by AWS and
//      can't be modified.
//
//      * INPUT_REQUIRED: You must include a value for all required parameters.
//
//      * INVALID_ENUM: You specified an invalid value.
//
//      * INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
//
//      * INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid
//      characters.
//
//      * INVALID_LIST_MEMBER: You provided a list to a parameter that contains
//      at least one invalid value.
//
//      * INVALID_PAGINATION_TOKEN: Get the value for the NextToken parameter
//      from the response to a previous call of the operation.
//
//      * INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account,
//      organization, or email) as a party.
//
//      * INVALID_PATTERN: You provided a value that doesn't match the required
//      pattern.
//
//      * INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't
//      match the required pattern.
//
//      * INVALID_ROLE_NAME: You provided a role name that isn't valid. A role
//      name can't begin with the reserved prefix AWSServiceRoleFor.
//
//      * INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource
//      Name (ARN) for the organization.
//
//      * INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
//
//      * INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system
//      tag. You can’t add, edit, or delete system tag keys because they're
//      reserved for AWS use. System tags don’t count against your tags per
//      resource limit.
//
//      * MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter
//      for the operation.
//
//      * MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer
//      than allowed.
//
//      * MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger
//      value than allowed.
//
//      * MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter
//      than allowed.
//
//      * MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller
//      value than allowed.
//
//      * MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only
//      between entities in the same root.
//
//      * TARGET_NOT_SUPPORTED: You can't perform the specified operation on that
//      target entity.
//
//      * UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that
//      isn't recognized.
//
//   * ServiceException
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * TooManyRequestsException
//   You have sent too many requests in too short a period of time. The quota
//   helps protect against denial-of-service attacks. Try again later.
//
//   For information about quotas that affect AWS Organizations, see Quotas for
//   AWS Organizations (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html)in
//   the AWS Organizations User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/EnableAllFeatures
func (c *Organizations) EnableAllFeatures(input *EnableAllFeaturesInput) (*EnableAllFeaturesOutput, error) {
	req, out := c.EnableAllFeaturesRequest(input)
	return out, req.Send()
}

// EnableAllFeaturesWithContext is the same as EnableAllFeatures with the addition of
// the ability to pass a context and additional request options.
//
// See EnableAllFeatures for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) EnableAllFeaturesWithContext(ctx aws.Context, input *EnableAllFeaturesInput, opts ...request.Option) (*EnableAllFeaturesOutput, error) {
	req, out := c.EnableAllFeaturesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opEnablePolicyType = "EnablePolicyType"

// EnablePolicyTypeRequest generates a "aws/request.Request" representing the
// client's request for the EnablePolicyType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See EnablePolicyType for more information on using the EnablePolicyType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the EnablePolicyTypeRequest method.
//    req, resp := client.EnablePolicyTypeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/EnablePolicyType
func (c *Organizations) EnablePolicyTypeRequest(input *EnablePolicyTypeInput) (req *request.Request, output *EnablePolicyTypeOutput) {
	op := &request.Operation{
		Name:       opEnablePolicyType,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EnablePolicyTypeInput{}
	}

	output = &EnablePolicyTypeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// EnablePolicyType API operation for AWS Organizations.
//
// Enables a policy type in a root. After you enable a policy type in a root,
// you can attach policies of that type to the root, any organizational unit
// (OU), or account in that root. You can undo this by using the DisablePolicyType
// operation.
//
// This is an asynchronous request that AWS performs in the background. AWS
// recommends that you first use ListRoots to see the status of policy types
// for a specified root, and then use this operation.
//
// This operation can be called only from the organization's master account.
//
// You can enable a policy type in a root only if that policy type is available
// in the organization. To view the status of available policy types in the
// organization, use DescribeOrganization.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation EnablePolicyType for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * AWSOrganizationsNotInUseException
//   Your account isn't a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * ConcurrentModificationException
//   The target of the operation is currently being modified by a different request.
//   Try again later.
//
//   * ConstraintViolationException
//   Performing this operation violates a minimum or maximum value limit. For
//   example, attempting to remove the last service control policy (SCP) from
//   an OU or root, inviting or creating too many accounts to the organization,
//   or attaching too many policies to an account, OU, or root. This exception
//   includes a reason that contains additional information about the violated
//   limit:
//
//   Some of the reasons in the following list might not be applicable to this
//   specific API or operation.
//
//      * ACCOUNT_CANNOT_LEAVE_ORGANIZAION: You attempted to remove the master
//      account from the organization. You can't remove the master account. Instead,
//      after you remove all member accounts, delete the organization itself.
//
//      * ACCOUNT_CANNOT_LEAVE_WITHOUT_EULA: You attempted to remove an account
//      from the organization that doesn't yet have enough information to exist
//      as a standalone account. This account requires you to first agree to the
//      AWS Customer Agreement. Follow the steps at Removing a member account
//      from your organization (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master)in
//      the AWS Organizations User Guide.
//
//      * ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove
//      an account from the organization that doesn't yet have enough information
//      to exist as a standalone account. This account requires you to first complete
//      phone verification. Follow the steps at Removing a member account from
//      your organization (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master)
//      in the AWS Organizations User Guide.
//
//      * ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number
//      of accounts that you can create in one day.
//
//      * ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on
//      the number of accounts in an organization. If you need more accounts,
//      contact AWS Support (https://console.aws.amazon.com/support/home#/) to
//      request an increase in your limit. Or the number of invitations that you
//      tried to send would cause you to exceed the limit of accounts in your
//      organization. Send fewer invitations or contact AWS Support to request
//      an increase in the number of accounts. Deleted and closed accounts still
//      count toward your limit. If you get this exception when running a command
//      immediately after creating the organization, wait one hour and try again.
//      After an hour, if the command continues to fail with this error, contact
//      AWS Support (https://console.aws.amazon.com/support/home#/).
//
//      * CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to
//      register the master account of the organization as a delegated administrator
//      for an AWS service integrated with Organizations. You can designate only
//      a member account as a delegated administrator.
//
//      * CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove
//      an account that is registered as a delegated administrator for a service
//      integrated with your organization. To complete this operation, you must
//      first deregister this account as a delegated administrator.
//
//      * CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an
//      organization in the specified region, you must enable all features mode.
//
//      * DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register
//      an AWS account as a delegated administrator for an AWS service that already
//      has a delegated administrator. To complete this operation, you must first
//      deregister any existing delegated administrators for this service.
//
//      * EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only
//      valid for a limited period of time. You must resubmit the request and
//      generate a new verfication code.
//
//      * HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of
//      handshakes that you can send in one day.
//
//      * MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account
//      in this organization, you first must migrate the organization's master
//      account to the marketplace that corresponds to the master account's address.
//      For example, accounts with India addresses must be associated with the
//      AISPL marketplace. All accounts in an organization must be associated
//      with the same marketplace.
//
//      * MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the AWS Regions
//      in China. To create an organization, the master must have an valid business
//      license. For more information, contact customer support.
//
//      * MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you
//      must first provide a valid contact address and phone number for the master
//      account. Then try the operation again.
//
//      * MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the
//      master account must have an associated account in the AWS GovCloud (US-West)
//      Region. For more information, see AWS Organizations (http://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html)
//      in the AWS GovCloud User Guide.
//
//      * MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization
//      with this master account, you first must associate a valid payment instrument,
//      such as a credit card, with the account. Follow the steps at To leave
//      an organization when all required account information has not yet been
//      provided (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info)
//      in the AWS Organizations User Guide.
//
//      * MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted
//      to register more delegated administrators than allowed for the service
//      principal.
//
//      * MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the
//      number of policies of a certain type that can be attached to an entity
//      at one time.
//
//      * MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed
//      on this resource.
//
//      * MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation
//      with this member account, you first must associate a valid payment instrument,
//      such as a credit card, with the account. Follow the steps at To leave
//      an organization when all required account information has not yet been
//      provided (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info)
//      in the AWS Organizations User Guide.
//
//      * MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a
//      policy from an entity that would cause the entity to have fewer than the
//      minimum number of policies of a certain type required.
//
//      * ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation
//      that requires the organization to be configured to support all features.
//      An organization that supports only consolidated billing features can't
//      perform this operation.
//
//      * OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is
//      too many levels deep.
//
//      * OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs
//      that you can have in an organization.
//
//      * POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that
//      is larger than the maximum size.
//
//      * POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of
//      policies that you can have in an organization.
//
//      * TAG_POLICY_VIOLATION: You attempted to create or update a resource with
//      tags that are not compliant with the tag policy requirements for this
//      account.
//
//   * InvalidInputException
//   The requested operation failed because you provided invalid values for one
//   or more of the request parameters. This exception includes a reason that
//   contains additional information about the violated limit:
//
//   Some of the reasons in the following list might not be applicable to this
//   specific API or operation.
//
//      * DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to
//      the same entity.
//
//      * IMMUTABLE_POLICY: You specified a policy that is managed by AWS and
//      can't be modified.
//
//      * INPUT_REQUIRED: You must include a value for all required parameters.
//
//      * INVALID_ENUM: You specified an invalid value.
//
//      * INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
//
//      * INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid
//      characters.
//
//      * INVALID_LIST_MEMBER: You provided a list to a parameter that contains
//      at least one invalid value.
//
//      * INVALID_PAGINATION_TOKEN: Get the value for the NextToken parameter
//      from the response to a previous call of the operation.
//
//      * INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account,
//      organization, or email) as a party.
//
//      * INVALID_PATTERN: You provided a value that doesn't match the required
//      pattern.
//
//      * INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't
//      match the required pattern.
//
//      * INVALID_ROLE_NAME: You provided a role name that isn't valid. A role
//      name can't begin with the reserved prefix AWSServiceRoleFor.
//
//      * INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource
//      Name (ARN) for the organization.
//
//      * INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
//
//      * INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system
//      tag. You can’t add, edit, or delete system tag keys because they're
//      reserved for AWS use. System tags don’t count against your tags per
//      resource limit.
//
//      * MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter
//      for the operation.
//
//      * MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer
//      than allowed.
//
//      * MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger
//      value than allowed.
//
//      * MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter
//      than allowed.
//
//      * MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller
//      value than allowed.
//
//      * MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only
//      between entities in the same root.
//
//      * TARGET_NOT_SUPPORTED: You can't perform the specified operation on that
//      target entity.
//
//      * UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that
//      isn't recognized.
//
//   * PolicyTypeAlreadyEnabledException
//   The specified policy type is already enabled in the specified root.
//
//   * RootNotFoundException
//   We can't find a root with the RootId that you specified.
//
//   * ServiceException
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * TooManyRequestsException
//   You have sent too many requests in too short a period of time. The quota
//   helps protect against denial-of-service attacks. Try again later.
//
//   For information about quotas that affect AWS Organizations, see Quotas for
//   AWS Organizations (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html)in
//   the AWS Organizations User Guide.
//
//   * PolicyTypeNotAvailableForOrganizationException
//   You can't use the specified policy type with the feature set currently enabled
//   for this organization. For example, you can enable SCPs only after you enable
//   all features in the organization. For more information, see Managing AWS
//   Organizations Policies (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies.html#enable_policies_on_root)in
//   the AWS Organizations User Guide.
//
//   * UnsupportedAPIEndpointException
//   This action isn't available in the current AWS Region.
//
//   * PolicyChangesInProgressException
//   Changes to the effective policy are in progress, and its contents can't be
//   returned. Try the operation again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/EnablePolicyType
func (c *Organizations) EnablePolicyType(input *EnablePolicyTypeInput) (*EnablePolicyTypeOutput, error) {
	req, out := c.EnablePolicyTypeRequest(input)
	return out, req.Send()
}

// EnablePolicyTypeWithContext is the same as EnablePolicyType with the addition of
// the ability to pass a context and additional request options.
//
// See EnablePolicyType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) EnablePolicyTypeWithContext(ctx aws.Context, input *EnablePolicyTypeInput, opts ...request.Option) (*EnablePolicyTypeOutput, error) {
	req, out := c.EnablePolicyTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opInviteAccountToOrganization = "InviteAccountToOrganization"

// InviteAccountToOrganizationRequest generates a "aws/request.Request" representing the
// client's request for the InviteAccountToOrganization operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See InviteAccountToOrganization for more information on using the InviteAccountToOrganization
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the InviteAccountToOrganizationRequest method.
//    req, resp := client.InviteAccountToOrganizationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/InviteAccountToOrganization
func (c *Organizations) InviteAccountToOrganizationRequest(input *InviteAccountToOrganizationInput) (req *request.Request, output *InviteAccountToOrganizationOutput) {
	op := &request.Operation{
		Name:       opInviteAccountToOrganization,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &InviteAccountToOrganizationInput{}
	}

	output = &InviteAccountToOrganizationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// InviteAccountToOrganization API operation for AWS Organizations.
//
// Sends an invitation to another account to join your organization as a member
// account. AWS Organizations sends email on your behalf to the email address
// that is associated with the other account's owner. The invitation is implemented
// as a Handshake whose details are in the response.
//
//    * You can invite AWS accounts only from the same seller as the master
//    account. For example, if your organization's master account was created
//    by Amazon Internet Services Pvt. Ltd (AISPL), an AWS seller in India,
//    you can invite only other AISPL accounts to your organization. You can't
//    combine accounts from AISPL and AWS or from any other AWS seller. For
//    more information, see Consolidated Billing in India (http://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/useconsolidatedbilliing-India.html).
//
//    * If you receive an exception that indicates that you exceeded your account
//    limits for the organization or that the operation failed because your
//    organization is still initializing, wait one hour and then try again.
//    If the error persists after an hour, contact AWS Support (https://console.aws.amazon.com/support/home#/).
//
// If the request includes tags, then the requester must have the organizations:TagResource
// permission.
//
// This operation can be called only from the organization's master account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation InviteAccountToOrganization for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * AWSOrganizationsNotInUseException
//   Your account isn't a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * AccountOwnerNotVerifiedException
//   You can't invite an existing account to your organization until you verify
//   that you own the email address associated with the master account. For more
//   information, see Email Address Verification (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_create.html#about-email-verification)
//   in the AWS Organizations User Guide.
//
//   * ConcurrentModificationException
//   The target of the operation is currently being modified by a different request.
//   Try again later.
//
//   * HandshakeConstraintViolationException
//   The requested operation would violate the constraint identified in the reason
//   code.
//
//   Some of the reasons in the following list might not be applicable to this
//   specific API or operation:
//
//      * ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on
//      the number of accounts in an organization. Note that deleted and closed
//      accounts still count toward your limit. If you get this exception immediately
//      after creating the organization, wait one hour and try again. If after
//      an hour it continues to fail with this error, contact AWS Support (https://console.aws.amazon.com/support/home#/).
//
//      * ALREADY_IN_AN_ORGANIZATION: The handshake request is invalid because
//      the invited account is already a member of an organization.
//
//      * HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of
//      handshakes that you can send in one day.
//
//      * INVITE_DISABLED_DURING_ENABLE_ALL_FEATURES: You can't issue new invitations
//      to join an organization while it's in the process of enabling all features.
//      You can resume inviting accounts after you finalize the process when all
//      accounts have agreed to the change.
//
//      * ORGANIZATION_ALREADY_HAS_ALL_FEATURES: The handshake request is invalid
//      because the organization has already enabled all features.
//
//      * ORGANIZATION_FROM_DIFFERENT_SELLER_OF_RECORD: The request failed because
//      the account is from a different marketplace than the accounts in the organization.
//      For example, accounts with India addresses must be associated with the
//      AISPL marketplace. All accounts in an organization must be from the same
//      marketplace.
//
//      * ORGANIZATION_MEMBERSHIP_CHANGE_RATE_LIMIT_EXCEEDED: You attempted to
//      change the membership of an account too quickly after its previous change.
//
//      * PAYMENT_INSTRUMENT_REQUIRED: You can't complete the operation with an
//      account that doesn't have a payment instrument, such as a credit card,
//      associated with it.
//
//   * DuplicateHandshakeException
//   A handshake with the same action and target already exists. For example,
//   if you invited an account to join your organization, the invited account
//   might already have a pending invitation from this organization. If you intend
//   to resend an invitation to an account, ensure that existing handshakes that
//   might be considered duplicates are canceled or declined.
//
//   * ConstraintViolationException
//   Performing this operation violates a minimum or maximum value limit. For
//   example, attempting to remove the last service control policy (SCP) from
//   an OU or root, inviting or creating too many accounts to the organization,
//   or attaching too many policies to an account, OU, or root. This exception
//   includes a reason that contains additional information about the violated
//   limit:
//
//   Some of the reasons in the following list might not be applicable to this
//   specific API or operation.
//
//      * ACCOUNT_CANNOT_LEAVE_ORGANIZAION: You attempted to remove the master
//      account from the organization. You can't remove the master account. Instead,
//      after you remove all member accounts, delete the organization itself.
//
//      * ACCOUNT_CANNOT_LEAVE_WITHOUT_EULA: You attempted to remove an account
//      from the organization that doesn't yet have enough information to exist
//      as a standalone account. This account requires you to first agree to the
//      AWS Customer Agreement. Follow the steps at Removing a member account
//      from your organization (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master)in
//      the AWS Organizations User Guide.
//
//      * ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove
//      an account from the organization that doesn't yet have enough information
//      to exist as a standalone account. This account requires you to first complete
//      phone verification. Follow the steps at Removing a member account from
//      your organization (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master)
//      in the AWS Organizations User Guide.
//
//      * ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number
//      of accounts that you can create in one day.
//
//      * ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on
//      the number of accounts in an organization. If you need more accounts,
//      contact AWS Support (https://console.aws.amazon.com/support/home#/) to
//      request an increase in your limit. Or the number of invitations that you
//      tried to send would cause you to exceed the limit of accounts in your
//      organization. Send fewer invitations or contact AWS Support to request
//      an increase in the number of accounts. Deleted and closed accounts still
//      count toward your limit. If you get this exception when running a command
//      immediately after creating the organization, wait one hour and try again.
//      After an hour, if the command continues to fail with this error, contact
//      AWS Support (https://console.aws.amazon.com/support/home#/).
//
//      * CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to
//      register the master account of the organization as a delegated administrator
//      for an AWS service integrated with Organizations. You can designate only
//      a member account as a delegated administrator.
//
//      * CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove
//      an account that is registered as a delegated administrator for a service
//      integrated with your organization. To complete this operation, you must
//      first deregister this account as a delegated administrator.
//
//      * CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an
//      organization in the specified region, you must enable all features mode.
//
//      * DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register
//      an AWS account as a delegated administrator for an AWS service that already
//      has a delegated administrator. To complete this operation, you must first
//      deregister any existing delegated administrators for this service.
//
//      * EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only
//      valid for a limited period of time. You must resubmit the request and
//      generate a new verfication code.
//
//      * HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of
//      handshakes that you can send in one day.
//
//      * MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account
//      in this organization, you first must migrate the organization's master
//      account to the marketplace that corresponds to the master account's address.
//      For example, accounts with India addresses must be associated with the
//      AISPL marketplace. All accounts in an organization must be associated
//      with the same marketplace.
//
//      * MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the AWS Regions
//      in China. To create an organization, the master must have an valid business
//      license. For more information, contact customer support.
//
//      * MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you
//      must first provide a valid contact address and phone number for the master
//      account. Then try the operation again.
//
//      * MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the
//      master account must have an associated account in the AWS GovCloud (US-West)
//      Region. For more information, see AWS Organizations (http://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html)
//      in the AWS GovCloud User Guide.
//
//      * MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization
//      with this master account, you first must associate a valid payment instrument,
//      such as a credit card, with the account. Follow the steps at To leave
//      an organization when all required account information has not yet been
//      provided (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info)
//      in the AWS Organizations User Guide.
//
//      * MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted
//      to register more delegated administrators than allowed for the service
//      principal.
//
//      * MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the
//      number of policies of a certain type that can be attached to an entity
//      at one time.
//
//      * MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed
//      on this resource.
//
//      * MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation
//      with this member account, you first must associate a valid payment instrument,
//      such as a credit card, with the account. Follow the steps at To leave
//      an organization when all required account information has not yet been
//      provided (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info)
//      in the AWS Organizations User Guide.
//
//      * MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a
//      policy from an entity that would cause the entity to have fewer than the
//      minimum number of policies of a certain type required.
//
//      * ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation
//      that requires the organization to be configured to support all features.
//      An organization that supports only consolidated billing features can't
//      perform this operation.
//
//      * OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is
//      too many levels deep.
//
//      * OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs
//      that you can have in an organization.
//
//      * POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that
//      is larger than the maximum size.
//
//      * POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of
//      policies that you can have in an organization.
//
//      * TAG_POLICY_VIOLATION: You attempted to create or update a resource with
//      tags that are not compliant with the tag policy requirements for this
//      account.
//
//   * InvalidInputException
//   The requested operation failed because you provided invalid values for one
//   or more of the request parameters. This exception includes a reason that
//   contains additional information about the violated limit:
//
//   Some of the reasons in the following list might not be applicable to this
//   specific API or operation.
//
//      * DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to
//      the same entity.
//
//      * IMMUTABLE_POLICY: You specified a policy that is managed by AWS and
//      can't be modified.
//
//      * INPUT_REQUIRED: You must include a value for all required parameters.
//
//      * INVALID_ENUM: You specified an invalid value.
//
//      * INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
//
//      * INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid
//      characters.
//
//      * INVALID_LIST_MEMBER: You provided a list to a parameter that contains
//      at least one invalid value.
//
//      * INVALID_PAGINATION_TOKEN: Get the value for the NextToken parameter
//      from the response to a previous call of the operation.
//
//      * INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account,
//      organization, or email) as a party.
//
//      * INVALID_PATTERN: You provided a value that doesn't match the required
//      pattern.
//
//      * INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't
//      match the required pattern.
//
//      * INVALID_ROLE_NAME: You provided a role name that isn't valid. A role
//      name can't begin with the reserved prefix AWSServiceRoleFor.
//
//      * INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource
//      Name (ARN) for the organization.
//
//      * INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
//
//      * INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system
//      tag. You can’t add, edit, or delete system tag keys because they're
//      reserved for AWS use. System tags don’t count against your tags per
//      resource limit.
//
//      * MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter
//      for the operation.
//
//      * MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer
//      than allowed.
//
//      * MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger
//      value than allowed.
//
//      * MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter
//      than allowed.
//
//      * MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller
//      value than allowed.
//
//      * MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only
//      between entities in the same root.
//
//      * TARGET_NOT_SUPPORTED: You can't perform the specified operation on that
//      target entity.
//
//      * UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that
//      isn't recognized.
//
//   * FinalizingOrganizationException
//   AWS Organizations couldn't perform the operation because your organization
//   hasn't finished initializing. This can take up to an hour. Try again later.
//   If after one hour you continue to receive this error, contact AWS Support
//   (https://console.aws.amazon.com/support/home#/).
//
//   * ServiceException
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * TooManyRequestsException
//   You have sent too many requests in too short a period of time. The quota
//   helps protect against denial-of-service attacks. Try again later.
//
//   For information about quotas that affect AWS Organizations, see Quotas for
//   AWS Organizations (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html)in
//   the AWS Organizations User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/InviteAccountToOrganization
func (c *Organizations) InviteAccountToOrganization(input *InviteAccountToOrganizationInput) (*InviteAccountToOrganizationOutput, error) {
	req, out := c.InviteAccountToOrganizationRequest(input)
	return out, req.Send()
}

// InviteAccountToOrganizationWithContext is the same as InviteAccountToOrganization with the addition of
// the ability to pass a context and additional request options.
//
// See InviteAccountToOrganization for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) InviteAccountToOrganizationWithContext(ctx aws.Context, input *InviteAccountToOrganizationInput, opts ...request.Option) (*InviteAccountToOrganizationOutput, error) {
	req, out := c.InviteAccountToOrganizationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opLeaveOrganization = "LeaveOrganization"

// LeaveOrganizationRequest generates a "aws/request.Request" representing the
// client's request for the LeaveOrganization operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See LeaveOrganization for more information on using the LeaveOrganization
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the LeaveOrganizationRequest method.
//    req, resp := client.LeaveOrganizationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/LeaveOrganization
func (c *Organizations) LeaveOrganizationRequest(input *LeaveOrganizationInput) (req *request.Request, output *LeaveOrganizationOutput) {
	op := &request.Operation{
		Name:       opLeaveOrganization,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &LeaveOrganizationInput{}
	}

	output = &LeaveOrganizationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// LeaveOrganization API operation for AWS Organizations.
//
// Removes a member account from its parent organization. This version of the
// operation is performed by the account that wants to leave. To remove a member
// account as a user in the master account, use RemoveAccountFromOrganization
// instead.
//
// This operation can be called only from a member account in the organization.
//
//    * The master account in an organization with all features enabled can
//    set service control policies (SCPs) that can restrict what administrators
//    of member accounts can do. This includes preventing them from successfully
//    calling LeaveOrganization and leaving the organization.
//
//    * You can leave an organization as a member account only if the account
//    is configured with the information required to operate as a standalone
//    account. When you create an account in an organization using the AWS Organizations
//    console, API, or CLI commands, the information required of standalone
//    accounts is not automatically collected. For each account that you want
//    to make standalone, you must perform the following steps. If any of the
//    steps are already completed for this account, that step doesn't appear.
//    Choose a support plan Provide and verify the required contact information
//    Provide a current payment method AWS uses the payment method to charge
//    for any billable (not free tier) AWS activity that occurs while the account
//    isn't attached to an organization. Follow the steps at To leave an organization
//    when all required account information has not yet been provided (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info)
//    in the AWS Organizations User Guide.
//
//    * You can leave an organization only after you enable IAM user access
//    to billing in your account. For more information, see Activating Access
//    to the Billing and Cost Management Console (http://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/grantaccess.html#ControllingAccessWebsite-Activate)
//    in the AWS Billing and Cost Management User Guide.
//
//    * After the account leaves the organization, all tags that were attached
//    to the account object in the organization are deleted. AWS accounts outside
//    of an organization do not support tags.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation LeaveOrganization for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * AccountNotFoundException
//   We can't find an AWS account with the AccountId that you specified, or the
//   account whose credentials you used to make this request isn't a member of
//   an organization.
//
//   * AWSOrganizationsNotInUseException
//   Your account isn't a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * ConcurrentModificationException
//   The target of the operation is currently being modified by a different request.
//   Try again later.
//
//   * ConstraintViolationException
//   Performing this operation violates a minimum or maximum value limit. For
//   example, attempting to remove the last service control policy (SCP) from
//   an OU or root, inviting or creating too many accounts to the organization,
//   or attaching too many policies to an account, OU, or root. This exception
//   includes a reason that contains additional information about the violated
//   limit:
//
//   Some of the reasons in the following list might not be applicable to this
//   specific API or operation.
//
//      * ACCOUNT_CANNOT_LEAVE_ORGANIZAION: You attempted to remove the master
//      account from the organization. You can't remove the master account. Instead,
//      after you remove all member accounts, delete the organization itself.
//
//      * ACCOUNT_CANNOT_LEAVE_WITHOUT_EULA: You attempted to remove an account
//      from the organization that doesn't yet have enough information to exist
//      as a standalone account. This account requires you to first agree to the
//      AWS Customer Agreement. Follow the steps at Removing a member account
//      from your organization (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master)in
//      the AWS Organizations User Guide.
//
//      * ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove
//      an account from the organization that doesn't yet have enough information
//      to exist as a standalone account. This account requires you to first complete
//      phone verification. Follow the steps at Removing a member account from
//      your organization (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master)
//      in the AWS Organizations User Guide.
//
//      * ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number
//      of accounts that you can create in one day.
//
//      * ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on
//      the number of accounts in an organization. If you need more accounts,
//      contact AWS Support (https://console.aws.amazon.com/support/home#/) to
//      request an increase in your limit. Or the number of invitations that you
//      tried to send would cause you to exceed the limit of accounts in your
//      organization. Send fewer invitations or contact AWS Support to request
//      an increase in the number of accounts. Deleted and closed accounts still
//      count toward your limit. If you get this exception when running a command
//      immediately after creating the organization, wait one hour and try again.
//      After an hour, if the command continues to fail with this error, contact
//      AWS Support (https://console.aws.amazon.com/support/home#/).
//
//      * CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to
//      register the master account of the organization as a delegated administrator
//      for an AWS service integrated with Organizations. You can designate only
//      a member account as a delegated administrator.
//
//      * CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove
//      an account that is registered as a delegated administrator for a service
//      integrated with your organization. To complete this operation, you must
//      first deregister this account as a delegated administrator.
//
//      * CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an
//      organization in the specified region, you must enable all features mode.
//
//      * DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register
//      an AWS account as a delegated administrator for an AWS service that already
//      has a delegated administrator. To complete this operation, you must first
//      deregister any existing delegated administrators for this service.
//
//      * EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only
//      valid for a limited period of time. You must resubmit the request and
//      generate a new verfication code.
//
//      * HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of
//      handshakes that you can send in one day.
//
//      * MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account
//      in this organization, you first must migrate the organization's master
//      account to the marketplace that corresponds to the master account's address.
//      For example, accounts with India addresses must be associated with the
//      AISPL marketplace. All accounts in an organization must be associated
//      with the same marketplace.
//
//      * MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the AWS Regions
//      in China. To create an organization, the master must have an valid business
//      license. For more information, contact customer support.
//
//      * MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you
//      must first provide a valid contact address and phone number for the master
//      account. Then try the operation again.
//
//      * MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the
//      master account must have an associated account in the AWS GovCloud (US-West)
//      Region. For more information, see AWS Organizations (http://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html)
//      in the AWS GovCloud User Guide.
//
//      * MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization
//      with this master account, you first must associate a valid payment instrument,
//      such as a credit card, with the account. Follow the steps at To leave
//      an organization when all required account information has not yet been
//      provided (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info)
//      in the AWS Organizations User Guide.
//
//      * MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted
//      to register more delegated administrators than allowed for the service
//      principal.
//
//      * MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the
//      number of policies of a certain type that can be attached to an entity
//      at one time.
//
//      * MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed
//      on this resource.
//
//      * MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation
//      with this member account, you first must associate a valid payment instrument,
//      such as a credit card, with the account. Follow the steps at To leave
//      an organization when all required account information has not yet been
//      provided (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info)
//      in the AWS Organizations User Guide.
//
//      * MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a
//      policy from an entity that would cause the entity to have fewer than the
//      minimum number of policies of a certain type required.
//
//      * ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation
//      that requires the organization to be configured to support all features.
//      An organization that supports only consolidated billing features can't
//      perform this operation.
//
//      * OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is
//      too many levels deep.
//
//      * OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs
//      that you can have in an organization.
//
//      * POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that
//      is larger than the maximum size.
//
//      * POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of
//      policies that you can have in an organization.
//
//      * TAG_POLICY_VIOLATION: You attempted to create or update a resource with
//      tags that are not compliant with the tag policy requirements for this
//      account.
//
//   * InvalidInputException
//   The requested operation failed because you provided invalid values for one
//   or more of the request parameters. This exception includes a reason that
//   contains additional information about the violated limit:
//
//   Some of the reasons in the following list might not be applicable to this
//   specific API or operation.
//
//      * DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to
//      the same entity.
//
//      * IMMUTABLE_POLICY: You specified a policy that is managed by AWS and
//      can't be modified.
//
//      * INPUT_REQUIRED: You must include a value for all required parameters.
//
//      * INVALID_ENUM: You specified an invalid value.
//
//      * INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
//
//      * INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid
//      characters.
//
//      * INVALID_LIST_MEMBER: You provided a list to a parameter that contains
//      at least one invalid value.
//
//      * INVALID_PAGINATION_TOKEN: Get the value for the NextToken parameter
//      from the response to a previous call of the operation.
//
//      * INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account,
//      organization, or email) as a party.
//
//      * INVALID_PATTERN: You provided a value that doesn't match the required
//      pattern.
//
//      * INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't
//      match the required pattern.
//
//      * INVALID_ROLE_NAME: You provided a role name that isn't valid. A role
//      name can't begin with the reserved prefix AWSServiceRoleFor.
//
//      * INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource
//      Name (ARN) for the organization.
//
//      * INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
//
//      * INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system
//      tag. You can’t add, edit, or delete system tag keys because they're
//      reserved for AWS use. System tags don’t count against your tags per
//      resource limit.
//
//      * MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter
//      for the operation.
//
//      * MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer
//      than allowed.
//
//      * MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger
//      value than allowed.
//
//      * MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter
//      than allowed.
//
//      * MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller
//      value than allowed.
//
//      * MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only
//      between entities in the same root.
//
//      * TARGET_NOT_SUPPORTED: You can't perform the specified operation on that
//      target entity.
//
//      * UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that
//      isn't recognized.
//
//   * MasterCannotLeaveOrganizationException
//   You can't remove a master account from an organization. If you want the master
//   account to become a member account in another organization, you must first
//   delete the current organization of the master account.
//
//   * ServiceException
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * TooManyRequestsException
//   You have sent too many requests in too short a period of time. The quota
//   helps protect against denial-of-service attacks. Try again later.
//
//   For information about quotas that affect AWS Organizations, see Quotas for
//   AWS Organizations (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html)in
//   the AWS Organizations User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/LeaveOrganization
func (c *Organizations) LeaveOrganization(input *LeaveOrganizationInput) (*LeaveOrganizationOutput, error) {
	req, out := c.LeaveOrganizationRequest(input)
	return out, req.Send()
}

// LeaveOrganizationWithContext is the same as LeaveOrganization with the addition of
// the ability to pass a context and additional request options.
//
// See LeaveOrganization for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) LeaveOrganizationWithContext(ctx aws.Context, input *LeaveOrganizationInput, opts ...request.Option) (*LeaveOrganizationOutput, error) {
	req, out := c.LeaveOrganizationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAWSServiceAccessForOrganization = "ListAWSServiceAccessForOrganization"

// ListAWSServiceAccessForOrganizationRequest generates a "aws/request.Request" representing the
// client's request for the ListAWSServiceAccessForOrganization operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAWSServiceAccessForOrganization for more information on using the ListAWSServiceAccessForOrganization
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAWSServiceAccessForOrganizationRequest method.
//    req, resp := client.ListAWSServiceAccessForOrganizationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListAWSServiceAccessForOrganization
func (c *Organizations) ListAWSServiceAccessForOrganizationRequest(input *ListAWSServiceAccessForOrganizationInput) (req *request.Request, output *ListAWSServiceAccessForOrganizationOutput) {
	op := &request.Operation{
		Name:       opListAWSServiceAccessForOrganization,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAWSServiceAccessForOrganizationInput{}
	}

	output = &ListAWSServiceAccessForOrganizationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAWSServiceAccessForOrganization API operation for AWS Organizations.
//
// Returns a list of the AWS services that you enabled to integrate with your
// organization. After a service on this list creates the resources that it
// requires for the integration, it can perform operations on your organization
// and its accounts.
//
// For more information about integrating other services with AWS Organizations,
// including the list of services that currently work with Organizations, see
// Integrating AWS Organizations with Other AWS Services (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html)
// in the AWS Organizations User Guide.
//
// This operation can be called only from the organization's master account
// or by a member account that is a delegated administrator for an AWS service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation ListAWSServiceAccessForOrganization for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * AWSOrganizationsNotInUseException
//   Your account isn't a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * ConstraintViolationException
//   Performing this operation violates a minimum or maximum value limit. For
//   example, attempting to remove the last service control policy (SCP) from
//   an OU or root, inviting or creating too many accounts to the organization,
//   or attaching too many policies to an account, OU, or root. This exception
//   includes a reason that contains additional information about the violated
//   limit:
//
//   Some of the reasons in the following list might not be applicable to this
//   specific API or operation.
//
//      * ACCOUNT_CANNOT_LEAVE_ORGANIZAION: You attempted to remove the master
//      account from the organization. You can't remove the master account. Instead,
//      after you remove all member accounts, delete the organization itself.
//
//      * ACCOUNT_CANNOT_LEAVE_WITHOUT_EULA: You attempted to remove an account
//      from the organization that doesn't yet have enough information to exist
//      as a standalone account. This account requires you to first agree to the
//      AWS Customer Agreement. Follow the steps at Removing a member account
//      from your organization (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master)in
//      the AWS Organizations User Guide.
//
//      * ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove
//      an account from the organization that doesn't yet have enough information
//      to exist as a standalone account. This account requires you to first complete
//      phone verification. Follow the steps at Removing a member account from
//      your organization (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master)
//      in the AWS Organizations User Guide.
//
//      * ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number
//      of accounts that you can create in one day.
//
//      * ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on
//      the number of accounts in an organization. If you need more accounts,
//      contact AWS Support (https://console.aws.amazon.com/support/home#/) to
//      request an increase in your limit. Or the number of invitations that you
//      tried to send would cause you to exceed the limit of accounts in your
//      organization. Send fewer invitations or contact AWS Support to request
//      an increase in the number of accounts. Deleted and closed accounts still
//      count toward your limit. If you get this exception when running a command
//      immediately after creating the organization, wait one hour and try again.
//      After an hour, if the command continues to fail with this error, contact
//      AWS Support (https://console.aws.amazon.com/support/home#/).
//
//      * CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to
//      register the master account of the organization as a delegated administrator
//      for an AWS service integrated with Organizations. You can designate only
//      a member account as a delegated administrator.
//
//      * CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove
//      an account that is registered as a delegated administrator for a service
//      integrated with your organization. To complete this operation, you must
//      first deregister this account as a delegated administrator.
//
//      * CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an
//      organization in the specified region, you must enable all features mode.
//
//      * DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register
//      an AWS account as a delegated administrator for an AWS service that already
//      has a delegated administrator. To complete this operation, you must first
//      deregister any existing delegated administrators for this service.
//
//      * EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only
//      valid for a limited period of time. You must resubmit the request and
//      generate a new verfication code.
//
//      * HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of
//      handshakes that you can send in one day.
//
//      * MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account
//      in this organization, you first must migrate the organization's master
//      account to the marketplace that corresponds to the master account's address.
//      For example, accounts with India addresses must be associated with the
//      AISPL marketplace. All accounts in an organization must be associated
//      with the same marketplace.
//
//      * MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the AWS Regions
//      in China. To create an organization, the master must have an valid business
//      license. For more information, contact customer support.
//
//      * MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you
//      must first provide a valid contact address and phone number for the master
//      account. Then try the operation again.
//
//      * MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the
//      master account must have an associated account in the AWS GovCloud (US-West)
//      Region. For more information, see AWS Organizations (http://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html)
//      in the AWS GovCloud User Guide.
//
//      * MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization
//      with this master account, you first must associate a valid payment instrument,
//      such as a credit card, with the account. Follow the steps at To leave
//      an organization when all required account information has not yet been
//      provided (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info)
//      in the AWS Organizations User Guide.
//
//      * MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted
//      to register more delegated administrators than allowed for the service
//      principal.
//
//      * MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the
//      number of policies of a certain type that can be attached to an entity
//      at one time.
//
//      * MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed
//      on this resource.
//
//      * MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation
//      with this member account, you first must associate a valid payment instrument,
//      such as a credit card, with the account. Follow the steps at To leave
//      an organization when all required account information has not yet been
//      provided (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info)
//      in the AWS Organizations User Guide.
//
//      * MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a
//      policy from an entity that would cause the entity to have fewer than the
//      minimum number of policies of a certain type required.
//
//      * ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation
//      that requires the organization to be configured to support all features.
//      An organization that supports only consolidated billing features can't
//      perform this operation.
//
//      * OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is
//      too many levels deep.
//
//      * OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs
//      that you can have in an organization.
//
//      * POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that
//      is larger than the maximum size.
//
//      * POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of
//      policies that you can have in an organization.
//
//      * TAG_POLICY_VIOLATION: You attempted to create or update a resource with
//      tags that are not compliant with the tag policy requirements for this
//      account.
//
//   * InvalidInputException
//   The requested operation failed because you provided invalid values for one
//   or more of the request parameters. This exception includes a reason that
//   contains additional information about the violated limit:
//
//   Some of the reasons in the following list might not be applicable to this
//   specific API or operation.
//
//      * DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to
//      the same entity.
//
//      * IMMUTABLE_POLICY: You specified a policy that is managed by AWS and
//      can't be modified.
//
//      * INPUT_REQUIRED: You must include a value for all required parameters.
//
//      * INVALID_ENUM: You specified an invalid value.
//
//      * INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
//
//      * INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid
//      characters.
//
//      * INVALID_LIST_MEMBER: You provided a list to a parameter that contains
//      at least one invalid value.
//
//      * INVALID_PAGINATION_TOKEN: Get the value for the NextToken parameter
//      from the response to a previous call of the operation.
//
//      * INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account,
//      organization, or email) as a party.
//
//      * INVALID_PATTERN: You provided a value that doesn't match the required
//      pattern.
//
//      * INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't
//      match the required pattern.
//
//      * INVALID_ROLE_NAME: You provided a role name that isn't valid. A role
//      name can't begin with the reserved prefix AWSServiceRoleFor.
//
//      * INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource
//      Name (ARN) for the organization.
//
//      * INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
//
//      * INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system
//      tag. You can’t add, edit, or delete system tag keys because they're
//      reserved for AWS use. System tags don’t count against your tags per
//      resource limit.
//
//      * MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter
//      for the operation.
//
//      * MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer
//      than allowed.
//
//      * MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger
//      value than allowed.
//
//      * MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter
//      than allowed.
//
//      * MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller
//      value than allowed.
//
//      * MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only
//      between entities in the same root.
//
//      * TARGET_NOT_SUPPORTED: You can't perform the specified operation on that
//      target entity.
//
//      * UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that
//      isn't recognized.
//
//   * ServiceException
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * TooManyRequestsException
//   You have sent too many requests in too short a period of time. The quota
//   helps protect against denial-of-service attacks. Try again later.
//
//   For information about quotas that affect AWS Organizations, see Quotas for
//   AWS Organizations (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html)in
//   the AWS Organizations User Guide.
//
//   * UnsupportedAPIEndpointException
//   This action isn't available in the current AWS Region.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListAWSServiceAccessForOrganization
func (c *Organizations) ListAWSServiceAccessForOrganization(input *ListAWSServiceAccessForOrganizationInput) (*ListAWSServiceAccessForOrganizationOutput, error) {
	req, out := c.ListAWSServiceAccessForOrganizationRequest(input)
	return out, req.Send()
}

// ListAWSServiceAccessForOrganizationWithContext is the same as ListAWSServiceAccessForOrganization with the addition of
// the ability to pass a context and additional request options.
//
// See ListAWSServiceAccessForOrganization for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) ListAWSServiceAccessForOrganizationWithContext(ctx aws.Context, input *ListAWSServiceAccessForOrganizationInput, opts ...request.Option) (*ListAWSServiceAccessForOrganizationOutput, error) {
	req, out := c.ListAWSServiceAccessForOrganizationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAWSServiceAccessForOrganizationPages iterates over the pages of a ListAWSServiceAccessForOrganization operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAWSServiceAccessForOrganization method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAWSServiceAccessForOrganization operation.
//    pageNum := 0
//    err := client.ListAWSServiceAccessForOrganizationPages(params,
//        func(page *organizations.ListAWSServiceAccessForOrganizationOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Organizations) ListAWSServiceAccessForOrganizationPages(input *ListAWSServiceAccessForOrganizationInput, fn func(*ListAWSServiceAccessForOrganizationOutput, bool) bool) error {
	return c.ListAWSServiceAccessForOrganizationPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAWSServiceAccessForOrganizationPagesWithContext same as ListAWSServiceAccessForOrganizationPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) ListAWSServiceAccessForOrganizationPagesWithContext(ctx aws.Context, input *ListAWSServiceAccessForOrganizationInput, fn func(*ListAWSServiceAccessForOrganizationOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAWSServiceAccessForOrganizationInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAWSServiceAccessForOrganizationRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAWSServiceAccessForOrganizationOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAccounts = "ListAccounts"

// ListAccountsRequest generates a "aws/request.Request" representing the
// client's request for the ListAccounts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAccounts for more information on using the ListAccounts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAccountsRequest method.
//    req, resp := client.ListAccountsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListAccounts
func (c *Organizations) ListAccountsRequest(input *ListAccountsInput) (req *request.Request, output *ListAccountsOutput) {
	op := &request.Operation{
		Name:       opListAccounts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAccountsInput{}
	}

	output = &ListAccountsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAccounts API operation for AWS Organizations.
//
// Lists all the accounts in the organization. To request only the accounts
// in a specified root or organizational unit (OU), use the ListAccountsForParent
// operation instead.
//
// Always check the NextToken response parameter for a null value when calling
// a List* operation. These operations can occasionally return an empty set
// of results even when there are more results available. The NextToken response
// parameter value is null only when there are no more results to display.
//
// This operation can be called only from the organization's master account
// or by a member account that is a delegated administrator for an AWS service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation ListAccounts for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * AWSOrganizationsNotInUseException
//   Your account isn't a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * InvalidInputException
//   The requested operation failed because you provided invalid values for one
//   or more of the request parameters. This exception includes a reason that
//   contains additional information about the violated limit:
//
//   Some of the reasons in the following list might not be applicable to this
//   specific API or operation.
//
//      * DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to
//      the same entity.
//
//      * IMMUTABLE_POLICY: You specified a policy that is managed by AWS and
//      can't be modified.
//
//      * INPUT_REQUIRED: You must include a value for all required parameters.
//
//      * INVALID_ENUM: You specified an invalid value.
//
//      * INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
//
//      * INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid
//      characters.
//
//      * INVALID_LIST_MEMBER: You provided a list to a parameter that contains
//      at least one invalid value.
//
//      * INVALID_PAGINATION_TOKEN: Get the value for the NextToken parameter
//      from the response to a previous call of the operation.
//
//      * INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account,
//      organization, or email) as a party.
//
//      * INVALID_PATTERN: You provided a value that doesn't match the required
//      pattern.
//
//      * INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't
//      match the required pattern.
//
//      * INVALID_ROLE_NAME: You provided a role name that isn't valid. A role
//      name can't begin with the reserved prefix AWSServiceRoleFor.
//
//      * INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource
//      Name (ARN) for the organization.
//
//      * INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
//
//      * INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system
//      tag. You can’t add, edit, or delete system tag keys because they're
//      reserved for AWS use. System tags don’t count against your tags per
//      resource limit.
//
//      * MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter
//      for the operation.
//
//      * MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer
//      than allowed.
//
//      * MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger
//      value than allowed.
//
//      * MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter
//      than allowed.
//
//      * MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller
//      value than allowed.
//
//      * MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only
//      between entities in the same root.
//
//      * TARGET_NOT_SUPPORTED: You can't perform the specified operation on that
//      target entity.
//
//      * UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that
//      isn't recognized.
//
//   * ServiceException
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * TooManyRequestsException
//   You have sent too many requests in too short a period of time. The quota
//   helps protect against denial-of-service attacks. Try again later.
//
//   For information about quotas that affect AWS Organizations, see Quotas for
//   AWS Organizations (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html)in
//   the AWS Organizations User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListAccounts
func (c *Organizations) ListAccounts(input *ListAccountsInput) (*ListAccountsOutput, error) {
	req, out := c.ListAccountsRequest(input)
	return out, req.Send()
}

// ListAccountsWithContext is the same as ListAccounts with the addition of
// the ability to pass a context and additional request options.
//
// See ListAccounts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) ListAccountsWithContext(ctx aws.Context, input *ListAccountsInput, opts ...request.Option) (*ListAccountsOutput, error) {
	req, out := c.ListAccountsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAccountsPages iterates over the pages of a ListAccounts operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAccounts method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAccounts operation.
//    pageNum := 0
//    err := client.ListAccountsPages(params,
//        func(page *organizations.ListAccountsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Organizations) ListAccountsPages(input *ListAccountsInput, fn func(*ListAccountsOutput, bool) bool) error {
	return c.ListAccountsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAccountsPagesWithContext same as ListAccountsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) ListAccountsPagesWithContext(ctx aws.Context, input *ListAccountsInput, fn func(*ListAccountsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAccountsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAccountsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAccountsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAccountsForParent = "ListAccountsForParent"

// ListAccountsForParentRequest generates a "aws/request.Request" representing the
// client's request for the ListAccountsForParent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAccountsForParent for more information on using the ListAccountsForParent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAccountsForParentRequest method.
//    req, resp := client.ListAccountsForParentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListAccountsForParent
func (c *Organizations) ListAccountsForParentRequest(input *ListAccountsForParentInput) (req *request.Request, output *ListAccountsForParentOutput) {
	op := &request.Operation{
		Name:       opListAccountsForParent,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAccountsForParentInput{}
	}

	output = &ListAccountsForParentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAccountsForParent API operation for AWS Organizations.
//
// Lists the accounts in an organization that are contained by the specified
// target root or organizational unit (OU). If you specify the root, you get
// a list of all the accounts that aren't in any OU. If you specify an OU, you
// get a list of all the accounts in only that OU and not in any child OUs.
// To get a list of all accounts in the organization, use the ListAccounts operation.
//
// Always check the NextToken response parameter for a null value when calling
// a List* operation. These operations can occasionally return an empty set
// of results even when there are more results available. The NextToken response
// parameter value is null only when there are no more results to display.
//
// This operation can be called only from the organization's master account
// or by a member account that is a delegated administrator for an AWS service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation ListAccountsForParent for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * AWSOrganizationsNotInUseException
//   Your account isn't a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * InvalidInputException
//   The requested operation failed because you provided invalid values for one
//   or more of the request parameters. This exception includes a reason that
//   contains additional information about the violated limit:
//
//   Some of the reasons in the following list might not be applicable to this
//   specific API or operation.
//
//      * DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to
//      the same entity.
//
//      * IMMUTABLE_POLICY: You specified a policy that is managed by AWS and
//      can't be modified.
//
//      * INPUT_REQUIRED: You must include a value for all required parameters.
//
//      * INVALID_ENUM: You specified an invalid value.
//
//      * INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
//
//      * INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid
//      characters.
//
//      * INVALID_LIST_MEMBER: You provided a list to a parameter that contains
//      at least one invalid value.
//
//      * INVALID_PAGINATION_TOKEN: Get the value for the NextToken parameter
//      from the response to a previous call of the operation.
//
//      * INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account,
//      organization, or email) as a party.
//
//      * INVALID_PATTERN: You provided a value that doesn't match the required
//      pattern.
//
//      * INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't
//      match the required pattern.
//
//      * INVALID_ROLE_NAME: You provided a role name that isn't valid. A role
//      name can't begin with the reserved prefix AWSServiceRoleFor.
//
//      * INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource
//      Name (ARN) for the organization.
//
//      * INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
//
//      * INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system
//      tag. You can’t add, edit, or delete system tag keys because they're
//      reserved for AWS use. System tags don’t count against your tags per
//      resource limit.
//
//      * MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter
//      for the operation.
//
//      * MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer
//      than allowed.
//
//      * MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger
//      value than allowed.
//
//      * MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter
//      than allowed.
//
//      * MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller
//      value than allowed.
//
//      * MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only
//      between entities in the same root.
//
//      * TARGET_NOT_SUPPORTED: You can't perform the specified operation on that
//      target entity.
//
//      * UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that
//      isn't recognized.
//
//   * ParentNotFoundException
//   We can't find a root or OU with the ParentId that you specified.
//
//   * ServiceException
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * TooManyRequestsException
//   You have sent too many requests in too short a period of time. The quota
//   helps protect against denial-of-service attacks. Try again later.
//
//   For information about quotas that affect AWS Organizations, see Quotas for
//   AWS Organizations (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html)in
//   the AWS Organizations User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListAccountsForParent
func (c *Organizations) ListAccountsForParent(input *ListAccountsForParentInput) (*ListAccountsForParentOutput, error) {
	req, out := c.ListAccountsForParentRequest(input)
	return out, req.Send()
}

// ListAccountsForParentWithContext is the same as ListAccountsForParent with the addition of
// the ability to pass a context and additional request options.
//
// See ListAccountsForParent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) ListAccountsForParentWithContext(ctx aws.Context, input *ListAccountsForParentInput, opts ...request.Option) (*ListAccountsForParentOutput, error) {
	req, out := c.ListAccountsForParentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAccountsForParentPages iterates over the pages of a ListAccountsForParent operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAccountsForParent method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAccountsForParent operation.
//    pageNum := 0
//    err := client.ListAccountsForParentPages(params,
//        func(page *organizations.ListAccountsForParentOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Organizations) ListAccountsForParentPages(input *ListAccountsForParentInput, fn func(*ListAccountsForParentOutput, bool) bool) error {
	return c.ListAccountsForParentPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAccountsForParentPagesWithContext same as ListAccountsForParentPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) ListAccountsForParentPagesWithContext(ctx aws.Context, input *ListAccountsForParentInput, fn func(*ListAccountsForParentOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAccountsForParentInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAccountsForParentRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAccountsForParentOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListChildren = "ListChildren"

// ListChildrenRequest generates a "aws/request.Request" representing the
// client's request for the ListChildren operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListChildren for more information on using the ListChildren
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListChildrenRequest method.
//    req, resp := client.ListChildrenRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListChildren
func (c *Organizations) ListChildrenRequest(input *ListChildrenInput) (req *request.Request, output *ListChildrenOutput) {
	op := &request.Operation{
		Name:       opListChildren,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListChildrenInput{}
	}

	output = &ListChildrenOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListChildren API operation for AWS Organizations.
//
// Lists all of the organizational units (OUs) or accounts that are contained
// in the specified parent OU or root. This operation, along with ListParents
// enables you to traverse the tree structure that makes up this root.
//
// Always check the NextToken response parameter for a null value when calling
// a List* operation. These operations can occasionally return an empty set
// of results even when there are more results available. The NextToken response
// parameter value is null only when there are no more results to display.
//
// This operation can be called only from the organization's master account
// or by a member account that is a delegated administrator for an AWS service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation ListChildren for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * AWSOrganizationsNotInUseException
//   Your account isn't a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * InvalidInputException
//   The requested operation failed because you provided invalid values for one
//   or more of the request parameters. This exception includes a reason that
//   contains additional information about the violated limit:
//
//   Some of the reasons in the following list might not be applicable to this
//   specific API or operation.
//
//      * DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to
//      the same entity.
//
//      * IMMUTABLE_POLICY: You specified a policy that is managed by AWS and
//      can't be modified.
//
//      * INPUT_REQUIRED: You must include a value for all required parameters.
//
//      * INVALID_ENUM: You specified an invalid value.
//
//      * INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
//
//      * INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid
//      characters.
//
//      * INVALID_LIST_MEMBER: You provided a list to a parameter that contains
//      at least one invalid value.
//
//      * INVALID_PAGINATION_TOKEN: Get the value for the NextToken parameter
//      from the response to a previous call of the operation.
//
//      * INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account,
//      organization, or email) as a party.
//
//      * INVALID_PATTERN: You provided a value that doesn't match the required
//      pattern.
//
//      * INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't
//      match the required pattern.
//
//      * INVALID_ROLE_NAME: You provided a role name that isn't valid. A role
//      name can't begin with the reserved prefix AWSServiceRoleFor.
//
//      * INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource
//      Name (ARN) for the organization.
//
//      * INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
//
//      * INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system
//      tag. You can’t add, edit, or delete system tag keys because they're
//      reserved for AWS use. System tags don’t count against your tags per
//      resource limit.
//
//      * MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter
//      for the operation.
//
//      * MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer
//      than allowed.
//
//      * MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger
//      value than allowed.
//
//      * MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter
//      than allowed.
//
//      * MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller
//      value than allowed.
//
//      * MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only
//      between entities in the same root.
//
//      * TARGET_NOT_SUPPORTED: You can't perform the specified operation on that
//      target entity.
//
//      * UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that
//      isn't recognized.
//
//   * ParentNotFoundException
//   We can't find a root or OU with the ParentId that you specified.
//
//   * ServiceException
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * TooManyRequestsException
//   You have sent too many requests in too short a period of time. The quota
//   helps protect against denial-of-service attacks. Try again later.
//
//   For information about quotas that affect AWS Organizations, see Quotas for
//   AWS Organizations (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html)in
//   the AWS Organizations User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListChildren
func (c *Organizations) ListChildren(input *ListChildrenInput) (*ListChildrenOutput, error) {
	req, out := c.ListChildrenRequest(input)
	return out, req.Send()
}

// ListChildrenWithContext is the same as ListChildren with the addition of
// the ability to pass a context and additional request options.
//
// See ListChildren for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) ListChildrenWithContext(ctx aws.Context, input *ListChildrenInput, opts ...request.Option) (*ListChildrenOutput, error) {
	req, out := c.ListChildrenRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListChildrenPages iterates over the pages of a ListChildren operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListChildren method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListChildren operation.
//    pageNum := 0
//    err := client.ListChildrenPages(params,
//        func(page *organizations.ListChildrenOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Organizations) ListChildrenPages(input *ListChildrenInput, fn func(*ListChildrenOutput, bool) bool) error {
	return c.ListChildrenPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListChildrenPagesWithContext same as ListChildrenPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) ListChildrenPagesWithContext(ctx aws.Context, input *ListChildrenInput, fn func(*ListChildrenOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListChildrenInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListChildrenRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListChildrenOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListCreateAccountStatus = "ListCreateAccountStatus"

// ListCreateAccountStatusRequest generates a "aws/request.Request" representing the
// client's request for the ListCreateAccountStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCreateAccountStatus for more information on using the ListCreateAccountStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListCreateAccountStatusRequest method.
//    req, resp := client.ListCreateAccountStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListCreateAccountStatus
func (c *Organizations) ListCreateAccountStatusRequest(input *ListCreateAccountStatusInput) (req *request.Request, output *ListCreateAccountStatusOutput) {
	op := &request.Operation{
		Name:       opListCreateAccountStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCreateAccountStatusInput{}
	}

	output = &ListCreateAccountStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCreateAccountStatus API operation for AWS Organizations.
//
// Lists the account creation requests that match the specified status that
// is currently being tracked for the organization.
//
// Always check the NextToken response parameter for a null value when calling
// a List* operation. These operations can occasionally return an empty set
// of results even when there are more results available. The NextToken response
// parameter value is null only when there are no more results to display.
//
// This operation can be called only from the organization's master account
// or by a member account that is a delegated administrator for an AWS service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation ListCreateAccountStatus for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * AWSOrganizationsNotInUseException
//   Your account isn't a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * InvalidInputException
//   The requested operation failed because you provided invalid values for one
//   or more of the request parameters. This exception includes a reason that
//   contains additional information about the violated limit:
//
//   Some of the reasons in the following list might not be applicable to this
//   specific API or operation.
//
//      * DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to
//      the same entity.
//
//      * IMMUTABLE_POLICY: You specified a policy that is managed by AWS and
//      can't be modified.
//
//      * INPUT_REQUIRED: You must include a value for all required parameters.
//
//      * INVALID_ENUM: You specified an invalid value.
//
//      * INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
//
//      * INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid
//      characters.
//
//      * INVALID_LIST_MEMBER: You provided a list to a parameter that contains
//      at least one invalid value.
//
//      * INVALID_PAGINATION_TOKEN: Get the value for the NextToken parameter
//      from the response to a previous call of the operation.
//
//      * INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account,
//      organization, or email) as a party.
//
//      * INVALID_PATTERN: You provided a value that doesn't match the required
//      pattern.
//
//      * INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't
//      match the required pattern.
//
//      * INVALID_ROLE_NAME: You provided a role name that isn't valid. A role
//      name can't begin with the reserved prefix AWSServiceRoleFor.
//
//      * INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource
//      Name (ARN) for the organization.
//
//      * INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
//
//      * INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system
//      tag. You can’t add, edit, or delete system tag keys because they're
//      reserved for AWS use. System tags don’t count against your tags per
//      resource limit.
//
//      * MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter
//      for the operation.
//
//      * MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer
//      than allowed.
//
//      * MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger
//      value than allowed.
//
//      * MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter
//      than allowed.
//
//      * MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller
//      value than allowed.
//
//      * MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only
//      between entities in the same root.
//
//      * TARGET_NOT_SUPPORTED: You can't perform the specified operation on that
//      target entity.
//
//      * UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that
//      isn't recognized.
//
//   * ServiceException
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * TooManyRequestsException
//   You have sent too many requests in too short a period of time. The quota
//   helps protect against denial-of-service attacks. Try again later.
//
//   For information about quotas that affect AWS Organizations, see Quotas for
//   AWS Organizations (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html)in
//   the AWS Organizations User Guide.
//
//   * UnsupportedAPIEndpointException
//   This action isn't available in the current AWS Region.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListCreateAccountStatus
func (c *Organizations) ListCreateAccountStatus(input *ListCreateAccountStatusInput) (*ListCreateAccountStatusOutput, error) {
	req, out := c.ListCreateAccountStatusRequest(input)
	return out, req.Send()
}

// ListCreateAccountStatusWithContext is the same as ListCreateAccountStatus with the addition of
// the ability to pass a context and additional request options.
//
// See ListCreateAccountStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) ListCreateAccountStatusWithContext(ctx aws.Context, input *ListCreateAccountStatusInput, opts ...request.Option) (*ListCreateAccountStatusOutput, error) {
	req, out := c.ListCreateAccountStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListCreateAccountStatusPages iterates over the pages of a ListCreateAccountStatus operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCreateAccountStatus method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListCreateAccountStatus operation.
//    pageNum := 0
//    err := client.ListCreateAccountStatusPages(params,
//        func(page *organizations.ListCreateAccountStatusOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Organizations) ListCreateAccountStatusPages(input *ListCreateAccountStatusInput, fn func(*ListCreateAccountStatusOutput, bool) bool) error {
	return c.ListCreateAccountStatusPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListCreateAccountStatusPagesWithContext same as ListCreateAccountStatusPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) ListCreateAccountStatusPagesWithContext(ctx aws.Context, input *ListCreateAccountStatusInput, fn func(*ListCreateAccountStatusOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListCreateAccountStatusInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListCreateAccountStatusRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListCreateAccountStatusOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDelegatedAdministrators = "ListDelegatedAdministrators"

// ListDelegatedAdministratorsRequest generates a "aws/request.Request" representing the
// client's request for the ListDelegatedAdministrators operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDelegatedAdministrators for more information on using the ListDelegatedAdministrators
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDelegatedAdministratorsRequest method.
//    req, resp := client.ListDelegatedAdministratorsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListDelegatedAdministrators
func (c *Organizations) ListDelegatedAdministratorsRequest(input *ListDelegatedAdministratorsInput) (req *request.Request, output *ListDelegatedAdministratorsOutput) {
	op := &request.Operation{
		Name:       opListDelegatedAdministrators,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDelegatedAdministratorsInput{}
	}

	output = &ListDelegatedAdministratorsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDelegatedAdministrators API operation for AWS Organizations.
//
// Lists the AWS accounts that are designated as delegated administrators in
// this organization.
//
// This operation can be called only from the organization's master account
// or by a member account that is a delegated administrator for an AWS service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation ListDelegatedAdministrators for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * AWSOrganizationsNotInUseException
//   Your account isn't a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * ConstraintViolationException
//   Performing this operation violates a minimum or maximum value limit. For
//   example, attempting to remove the last service control policy (SCP) from
//   an OU or root, inviting or creating too many accounts to the organization,
//   or attaching too many policies to an account, OU, or root. This exception
//   includes a reason that contains additional information about the violated
//   limit:
//
//   Some of the reasons in the following list might not be applicable to this
//   specific API or operation.
//
//      * ACCOUNT_CANNOT_LEAVE_ORGANIZAION: You attempted to remove the master
//      account from the organization. You can't remove the master account. Instead,
//      after you remove all member accounts, delete the organization itself.
//
//      * ACCOUNT_CANNOT_LEAVE_WITHOUT_EULA: You attempted to remove an account
//      from the organization that doesn't yet have enough information to exist
//      as a standalone account. This account requires you to first agree to the
//      AWS Customer Agreement. Follow the steps at Removing a member account
//      from your organization (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master)in
//      the AWS Organizations User Guide.
//
//      * ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove
//      an account from the organization that doesn't yet have enough information
//      to exist as a standalone account. This account requires you to first complete
//      phone verification. Follow the steps at Removing a member account from
//      your organization (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master)
//      in the AWS Organizations User Guide.
//
//      * ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number
//      of accounts that you can create in one day.
//
//      * ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on
//      the number of accounts in an organization. If you need more accounts,
//      contact AWS Support (https://console.aws.amazon.com/support/home#/) to
//      request an increase in your limit. Or the number of invitations that you
//      tried to send would cause you to exceed the limit of accounts in your
//      organization. Send fewer invitations or contact AWS Support to request
//      an increase in the number of accounts. Deleted and closed accounts still
//      count toward your limit. If you get this exception when running a command
//      immediately after creating the organization, wait one hour and try again.
//      After an hour, if the command continues to fail with this error, contact
//      AWS Support (https://console.aws.amazon.com/support/home#/).
//
//      * CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to
//      register the master account of the organization as a delegated administrator
//      for an AWS service integrated with Organizations. You can designate only
//      a member account as a delegated administrator.
//
//      * CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove
//      an account that is registered as a delegated administrator for a service
//      integrated with your organization. To complete this operation, you must
//      first deregister this account as a delegated administrator.
//
//      * CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an
//      organization in the specified region, you must enable all features mode.
//
//      * DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register
//      an AWS account as a delegated administrator for an AWS service that already
//      has a delegated administrator. To complete this operation, you must first
//      deregister any existing delegated administrators for this service.
//
//      * EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only
//      valid for a limited period of time. You must resubmit the request and
//      generate a new verfication code.
//
//      * HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of
//      handshakes that you can send in one day.
//
//      * MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account
//      in this organization, you first must migrate the organization's master
//      account to the marketplace that corresponds to the master account's address.
//      For example, accounts with India addresses must be associated with the
//      AISPL marketplace. All accounts in an organization must be associated
//      with the same marketplace.
//
//      * MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the AWS Regions
//      in China. To create an organization, the master must have an valid business
//      license. For more information, contact customer support.
//
//      * MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you
//      must first provide a valid contact address and phone number for the master
//      account. Then try the operation again.
//
//      * MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the
//      master account must have an associated account in the AWS GovCloud (US-West)
//      Region. For more information, see AWS Organizations (http://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html)
//      in the AWS GovCloud User Guide.
//
//      * MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization
//      with this master account, you first must associate a valid payment instrument,
//      such as a credit card, with the account. Follow the steps at To leave
//      an organization when all required account information has not yet been
//      provided (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info)
//      in the AWS Organizations User Guide.
//
//      * MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted
//      to register more delegated administrators than allowed for the service
//      principal.
//
//      * MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the
//      number of policies of a certain type that can be attached to an entity
//      at one time.
//
//      * MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed
//      on this resource.
//
//      * MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation
//      with this member account, you first must associate a valid payment instrument,
//      such as a credit card, with the account. Follow the steps at To leave
//      an organization when all required account information has not yet been
//      provided (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info)
//      in the AWS Organizations User Guide.
//
//      * MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a
//      policy from an entity that would cause the entity to have fewer than the
//      minimum number of policies of a certain type required.
//
//      * ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation
//      that requires the organization to be configured to support all features.
//      An organization that supports only consolidated billing features can't
//      perform this operation.
//
//      * OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is
//      too many levels deep.
//
//      * OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs
//      that you can have in an organization.
//
//      * POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that
//      is larger than the maximum size.
//
//      * POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of
//      policies that you can have in an organization.
//
//      * TAG_POLICY_VIOLATION: You attempted to create or update a resource with
//      tags that are not compliant with the tag policy requirements for this
//      account.
//
//   * InvalidInputException
//   The requested operation failed because you provided invalid values for one
//   or more of the request parameters. This exception includes a reason that
//   contains additional information about the violated limit:
//
//   Some of the reasons in the following list might not be applicable to this
//   specific API or operation.
//
//      * DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to
//      the same entity.
//
//      * IMMUTABLE_POLICY: You specified a policy that is managed by AWS and
//      can't be modified.
//
//      * INPUT_REQUIRED: You must include a value for all required parameters.
//
//      * INVALID_ENUM: You specified an invalid value.
//
//      * INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
//
//      * INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid
//      characters.
//
//      * INVALID_LIST_MEMBER: You provided a list to a parameter that contains
//      at least one invalid value.
//
//      * INVALID_PAGINATION_TOKEN: Get the value for the NextToken parameter
//      from the response to a previous call of the operation.
//
//      * INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account,
//      organization, or email) as a party.
//
//      * INVALID_PATTERN: You provided a value that doesn't match the required
//      pattern.
//
//      * INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't
//      match the required pattern.
//
//      * INVALID_ROLE_NAME: You provided a role name that isn't valid. A role
//      name can't begin with the reserved prefix AWSServiceRoleFor.
//
//      * INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource
//      Name (ARN) for the organization.
//
//      * INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
//
//      * INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system
//      tag. You can’t add, edit, or delete system tag keys because they're
//      reserved for AWS use. System tags don’t count against your tags per
//      resource limit.
//
//      * MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter
//      for the operation.
//
//      * MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer
//      than allowed.
//
//      * MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger
//      value than allowed.
//
//      * MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter
//      than allowed.
//
//      * MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller
//      value than allowed.
//
//      * MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only
//      between entities in the same root.
//
//      * TARGET_NOT_SUPPORTED: You can't perform the specified operation on that
//      target entity.
//
//      * UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that
//      isn't recognized.
//
//   * TooManyRequestsException
//   You have sent too many requests in too short a period of time. The quota
//   helps protect against denial-of-service attacks. Try again later.
//
//   For information about quotas that affect AWS Organizations, see Quotas for
//   AWS Organizations (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html)in
//   the AWS Organizations User Guide.
//
//   * ServiceException
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * UnsupportedAPIEndpointException
//   This action isn't available in the current AWS Region.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListDelegatedAdministrators
func (c *Organizations) ListDelegatedAdministrators(input *ListDelegatedAdministratorsInput) (*ListDelegatedAdministratorsOutput, error) {
	req, out := c.ListDelegatedAdministratorsRequest(input)
	return out, req.Send()
}

// ListDelegatedAdministratorsWithContext is the same as ListDelegatedAdministrators with the addition of
// the ability to pass a context and additional request options.
//
// See ListDelegatedAdministrators for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) ListDelegatedAdministratorsWithContext(ctx aws.Context, input *ListDelegatedAdministratorsInput, opts ...request.Option) (*ListDelegatedAdministratorsOutput, error) {
	req, out := c.ListDelegatedAdministratorsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDelegatedAdministratorsPages iterates over the pages of a ListDelegatedAdministrators operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDelegatedAdministrators method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDelegatedAdministrators operation.
//    pageNum := 0
//    err := client.ListDelegatedAdministratorsPages(params,
//        func(page *organizations.ListDelegatedAdministratorsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Organizations) ListDelegatedAdministratorsPages(input *ListDelegatedAdministratorsInput, fn func(*ListDelegatedAdministratorsOutput, bool) bool) error {
	return c.ListDelegatedAdministratorsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDelegatedAdministratorsPagesWithContext same as ListDelegatedAdministratorsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) ListDelegatedAdministratorsPagesWithContext(ctx aws.Context, input *ListDelegatedAdministratorsInput, fn func(*ListDelegatedAdministratorsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDelegatedAdministratorsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDelegatedAdministratorsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDelegatedAdministratorsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDelegatedServicesForAccount = "ListDelegatedServicesForAccount"

// ListDelegatedServicesForAccountRequest generates a "aws/request.Request" representing the
// client's request for the ListDelegatedServicesForAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDelegatedServicesForAccount for more information on using the ListDelegatedServicesForAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDelegatedServicesForAccountRequest method.
//    req, resp := client.ListDelegatedServicesForAccountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListDelegatedServicesForAccount
func (c *Organizations) ListDelegatedServicesForAccountRequest(input *ListDelegatedServicesForAccountInput) (req *request.Request, output *ListDelegatedServicesForAccountOutput) {
	op := &request.Operation{
		Name:       opListDelegatedServicesForAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDelegatedServicesForAccountInput{}
	}

	output = &ListDelegatedServicesForAccountOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDelegatedServicesForAccount API operation for AWS Organizations.
//
// List the AWS services for which the specified account is a delegated administrator.
//
// This operation can be called only from the organization's master account
// or by a member account that is a delegated administrator for an AWS service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation ListDelegatedServicesForAccount for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * AccountNotFoundException
//   We can't find an AWS account with the AccountId that you specified, or the
//   account whose credentials you used to make this request isn't a member of
//   an organization.
//
//   * AccountNotRegisteredException
//   The specified account is not a delegated administrator for this AWS service.
//
//   * AWSOrganizationsNotInUseException
//   Your account isn't a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * ConstraintViolationException
//   Performing this operation violates a minimum or maximum value limit. For
//   example, attempting to remove the last service control policy (SCP) from
//   an OU or root, inviting or creating too many accounts to the organization,
//   or attaching too many policies to an account, OU, or root. This exception
//   includes a reason that contains additional information about the violated
//   limit:
//
//   Some of the reasons in the following list might not be applicable to this
//   specific API or operation.
//
//      * ACCOUNT_CANNOT_LEAVE_ORGANIZAION: You attempted to remove the master
//      account from the organization. You can't remove the master account. Instead,
//      after you remove all member accounts, delete the organization itself.
//
//      * ACCOUNT_CANNOT_LEAVE_WITHOUT_EULA: You attempted to remove an account
//      from the organization that doesn't yet have enough information to exist
//      as a standalone account. This account requires you to first agree to the
//      AWS Customer Agreement. Follow the steps at Removing a member account
//      from your organization (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master)in
//      the AWS Organizations User Guide.
//
//      * ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove
//      an account from the organization that doesn't yet have enough information
//      to exist as a standalone account. This account requires you to first complete
//      phone verification. Follow the steps at Removing a member account from
//      your organization (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master)
//      in the AWS Organizations User Guide.
//
//      * ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number
//      of accounts that you can create in one day.
//
//      * ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on
//      the number of accounts in an organization. If you need more accounts,
//      contact AWS Support (https://console.aws.amazon.com/support/home#/) to
//      request an increase in your limit. Or the number of invitations that you
//      tried to send would cause you to exceed the limit of accounts in your
//      organization. Send fewer invitations or contact AWS Support to request
//      an increase in the number of accounts. Deleted and closed accounts still
//      count toward your limit. If you get this exception when running a command
//      immediately after creating the organization, wait one hour and try again.
//      After an hour, if the command continues to fail with this error, contact
//      AWS Support (https://console.aws.amazon.com/support/home#/).
//
//      * CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to
//      register the master account of the organization as a delegated administrator
//      for an AWS service integrated with Organizations. You can designate only
//      a member account as a delegated administrator.
//
//      * CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove
//      an account that is registered as a delegated administrator for a service
//      integrated with your organization. To complete this operation, you must
//      first deregister this account as a delegated administrator.
//
//      * CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an
//      organization in the specified region, you must enable all features mode.
//
//      * DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register
//      an AWS account as a delegated administrator for an AWS service that already
//      has a delegated administrator. To complete this operation, you must first
//      deregister any existing delegated administrators for this service.
//
//      * EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only
//      valid for a limited period of time. You must resubmit the request and
//      generate a new verfication code.
//
//      * HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of
//      handshakes that you can send in one day.
//
//      * MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account
//      in this organization, you first must migrate the organization's master
//      account to the marketplace that corresponds to the master account's address.
//      For example, accounts with India addresses must be associated with the
//      AISPL marketplace. All accounts in an organization must be associated
//      with the same marketplace.
//
//      * MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the AWS Regions
//      in China. To create an organization, the master must have an valid business
//      license. For more information, contact customer support.
//
//      * MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you
//      must first provide a valid contact address and phone number for the master
//      account. Then try the operation again.
//
//      * MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the
//      master account must have an associated account in the AWS GovCloud (US-West)
//      Region. For more information, see AWS Organizations (http://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html)
//      in the AWS GovCloud User Guide.
//
//      * MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization
//      with this master account, you first must associate a valid payment instrument,
//      such as a credit card, with the account. Follow the steps at To leave
//      an organization when all required account information has not yet been
//      provided (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info)
//      in the AWS Organizations User Guide.
//
//      * MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted
//      to register more delegated administrators than allowed for the service
//      principal.
//
//      * MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the
//      number of policies of a certain type that can be attached to an entity
//      at one time.
//
//      * MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed
//      on this resource.
//
//      * MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation
//      with this member account, you first must associate a valid payment instrument,
//      such as a credit card, with the account. Follow the steps at To leave
//      an organization when all required account information has not yet been
//      provided (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info)
//      in the AWS Organizations User Guide.
//
//      * MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a
//      policy from an entity that would cause the entity to have fewer than the
//      minimum number of policies of a certain type required.
//
//      * ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation
//      that requires the organization to be configured to support all features.
//      An organization that supports only consolidated billing features can't
//      perform this operation.
//
//      * OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is
//      too many levels deep.
//
//      * OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs
//      that you can have in an organization.
//
//      * POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that
//      is larger than the maximum size.
//
//      * POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of
//      policies that you can have in an organization.
//
//      * TAG_POLICY_VIOLATION: You attempted to create or update a resource with
//      tags that are not compliant with the tag policy requirements for this
//      account.
//
//   * InvalidInputException
//   The requested operation failed because you provided invalid values for one
//   or more of the request parameters. This exception includes a reason that
//   contains additional information about the violated limit:
//
//   Some of the reasons in the following list might not be applicable to this
//   specific API or operation.
//
//      * DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to
//      the same entity.
//
//      * IMMUTABLE_POLICY: You specified a policy that is managed by AWS and
//      can't be modified.
//
//      * INPUT_REQUIRED: You must include a value for all required parameters.
//
//      * INVALID_ENUM: You specified an invalid value.
//
//      * INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
//
//      * INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid
//      characters.
//
//      * INVALID_LIST_MEMBER: You provided a list to a parameter that contains
//      at least one invalid value.
//
//      * INVALID_PAGINATION_TOKEN: Get the value for the NextToken parameter
//      from the response to a previous call of the operation.
//
//      * INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account,
//      organization, or email) as a party.
//
//      * INVALID_PATTERN: You provided a value that doesn't match the required
//      pattern.
//
//      * INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't
//      match the required pattern.
//
//      * INVALID_ROLE_NAME: You provided a role name that isn't valid. A role
//      name can't begin with the reserved prefix AWSServiceRoleFor.
//
//      * INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource
//      Name (ARN) for the organization.
//
//      * INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
//
//      * INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system
//      tag. You can’t add, edit, or delete system tag keys because they're
//      reserved for AWS use. System tags don’t count against your tags per
//      resource limit.
//
//      * MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter
//      for the operation.
//
//      * MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer
//      than allowed.
//
//      * MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger
//      value than allowed.
//
//      * MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter
//      than allowed.
//
//      * MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller
//      value than allowed.
//
//      * MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only
//      between entities in the same root.
//
//      * TARGET_NOT_SUPPORTED: You can't perform the specified operation on that
//      target entity.
//
//      * UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that
//      isn't recognized.
//
//   * TooManyRequestsException
//   You have sent too many requests in too short a period of time. The quota
//   helps protect against denial-of-service attacks. Try again later.
//
//   For information about quotas that affect AWS Organizations, see Quotas for
//   AWS Organizations (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html)in
//   the AWS Organizations User Guide.
//
//   * ServiceException
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * UnsupportedAPIEndpointException
//   This action isn't available in the current AWS Region.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListDelegatedServicesForAccount
func (c *Organizations) ListDelegatedServicesForAccount(input *ListDelegatedServicesForAccountInput) (*ListDelegatedServicesForAccountOutput, error) {
	req, out := c.ListDelegatedServicesForAccountRequest(input)
	return out, req.Send()
}

// ListDelegatedServicesForAccountWithContext is the same as ListDelegatedServicesForAccount with the addition of
// the ability to pass a context and additional request options.
//
// See ListDelegatedServicesForAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) ListDelegatedServicesForAccountWithContext(ctx aws.Context, input *ListDelegatedServicesForAccountInput, opts ...request.Option) (*ListDelegatedServicesForAccountOutput, error) {
	req, out := c.ListDelegatedServicesForAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDelegatedServicesForAccountPages iterates over the pages of a ListDelegatedServicesForAccount operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDelegatedServicesForAccount method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDelegatedServicesForAccount operation.
//    pageNum := 0
//    err := client.ListDelegatedServicesForAccountPages(params,
//        func(page *organizations.ListDelegatedServicesForAccountOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Organizations) ListDelegatedServicesForAccountPages(input *ListDelegatedServicesForAccountInput, fn func(*ListDelegatedServicesForAccountOutput, bool) bool) error {
	return c.ListDelegatedServicesForAccountPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDelegatedServicesForAccountPagesWithContext same as ListDelegatedServicesForAccountPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) ListDelegatedServicesForAccountPagesWithContext(ctx aws.Context, input *ListDelegatedServicesForAccountInput, fn func(*ListDelegatedServicesForAccountOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDelegatedServicesForAccountInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDelegatedServicesForAccountRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDelegatedServicesForAccountOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListHandshakesForAccount = "ListHandshakesForAccount"

// ListHandshakesForAccountRequest generates a "aws/request.Request" representing the
// client's request for the ListHandshakesForAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListHandshakesForAccount for more information on using the ListHandshakesForAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListHandshakesForAccountRequest method.
//    req, resp := client.ListHandshakesForAccountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListHandshakesForAccount
func (c *Organizations) ListHandshakesForAccountRequest(input *ListHandshakesForAccountInput) (req *request.Request, output *ListHandshakesForAccountOutput) {
	op := &request.Operation{
		Name:       opListHandshakesForAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListHandshakesForAccountInput{}
	}

	output = &ListHandshakesForAccountOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListHandshakesForAccount API operation for AWS Organizations.
//
// Lists the current handshakes that are associated with the account of the
// requesting user.
//
// Handshakes that are ACCEPTED, DECLINED, or CANCELED appear in the results
// of this API for only 30 days after changing to that state. After that, they're
// deleted and no longer accessible.
//
// Always check the NextToken response parameter for a null value when calling
// a List* operation. These operations can occasionally return an empty set
// of results even when there are more results available. The NextToken response
// parameter value is null only when there are no more results to display.
//
// This operation can be called from any account in the organization.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation ListHandshakesForAccount for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * ConcurrentModificationException
//   The target of the operation is currently being modified by a different request.
//   Try again later.
//
//   * InvalidInputException
//   The requested operation failed because you provided invalid values for one
//   or more of the request parameters. This exception includes a reason that
//   contains additional information about the violated limit:
//
//   Some of the reasons in the following list might not be applicable to this
//   specific API or operation.
//
//      * DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to
//      the same entity.
//
//      * IMMUTABLE_POLICY: You specified a policy that is managed by AWS and
//      can't be modified.
//
//      * INPUT_REQUIRED: You must include a value for all required parameters.
//
//      * INVALID_ENUM: You specified an invalid value.
//
//      * INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
//
//      * INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid
//      characters.
//
//      * INVALID_LIST_MEMBER: You provided a list to a parameter that contains
//      at least one invalid value.
//
//      * INVALID_PAGINATION_TOKEN: Get the value for the NextToken parameter
//      from the response to a previous call of the operation.
//
//      * INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account,
//      organization, or email) as a party.
//
//      * INVALID_PATTERN: You provided a value that doesn't match the required
//      pattern.
//
//      * INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't
//      match the required pattern.
//
//      * INVALID_ROLE_NAME: You provided a role name that isn't valid. A role
//      name can't begin with the reserved prefix AWSServiceRoleFor.
//
//      * INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource
//      Name (ARN) for the organization.
//
//      * INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
//
//      * INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system
//      tag. You can’t add, edit, or delete system tag keys because they're
//      reserved for AWS use. System tags don’t count against your tags per
//      resource limit.
//
//      * MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter
//      for the operation.
//
//      * MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer
//      than allowed.
//
//      * MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger
//      value than allowed.
//
//      * MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter
//      than allowed.
//
//      * MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller
//      value than allowed.
//
//      * MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only
//      between entities in the same root.
//
//      * TARGET_NOT_SUPPORTED: You can't perform the specified operation on that
//      target entity.
//
//      * UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that
//      isn't recognized.
//
//   * ServiceException
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * TooManyRequestsException
//   You have sent too many requests in too short a period of time. The quota
//   helps protect against denial-of-service attacks. Try again later.
//
//   For information about quotas that affect AWS Organizations, see Quotas for
//   AWS Organizations (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html)in
//   the AWS Organizations User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListHandshakesForAccount
func (c *Organizations) ListHandshakesForAccount(input *ListHandshakesForAccountInput) (*ListHandshakesForAccountOutput, error) {
	req, out := c.ListHandshakesForAccountRequest(input)
	return out, req.Send()
}

// ListHandshakesForAccountWithContext is the same as ListHandshakesForAccount with the addition of
// the ability to pass a context and additional request options.
//
// See ListHandshakesForAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) ListHandshakesForAccountWithContext(ctx aws.Context, input *ListHandshakesForAccountInput, opts ...request.Option) (*ListHandshakesForAccountOutput, error) {
	req, out := c.ListHandshakesForAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListHandshakesForAccountPages iterates over the pages of a ListHandshakesForAccount operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListHandshakesForAccount method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListHandshakesForAccount operation.
//    pageNum := 0
//    err := client.ListHandshakesForAccountPages(params,
//        func(page *organizations.ListHandshakesForAccountOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Organizations) ListHandshakesForAccountPages(input *ListHandshakesForAccountInput, fn func(*ListHandshakesForAccountOutput, bool) bool) error {
	return c.ListHandshakesForAccountPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListHandshakesForAccountPagesWithContext same as ListHandshakesForAccountPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) ListHandshakesForAccountPagesWithContext(ctx aws.Context, input *ListHandshakesForAccountInput, fn func(*ListHandshakesForAccountOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListHandshakesForAccountInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListHandshakesForAccountRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListHandshakesForAccountOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListHandshakesForOrganization = "ListHandshakesForOrganization"

// ListHandshakesForOrganizationRequest generates a "aws/request.Request" representing the
// client's request for the ListHandshakesForOrganization operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListHandshakesForOrganization for more information on using the ListHandshakesForOrganization
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListHandshakesForOrganizationRequest method.
//    req, resp := client.ListHandshakesForOrganizationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListHandshakesForOrganization
func (c *Organizations) ListHandshakesForOrganizationRequest(input *ListHandshakesForOrganizationInput) (req *request.Request, output *ListHandshakesForOrganizationOutput) {
	op := &request.Operation{
		Name:       opListHandshakesForOrganization,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListHandshakesForOrganizationInput{}
	}

	output = &ListHandshakesForOrganizationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListHandshakesForOrganization API operation for AWS Organizations.
//
// Lists the handshakes that are associated with the organization that the requesting
// user is part of. The ListHandshakesForOrganization operation returns a list
// of handshake structures. Each structure contains details and status about
// a handshake.
//
// Handshakes that are ACCEPTED, DECLINED, or CANCELED appear in the results
// of this API for only 30 days after changing to that state. After that, they're
// deleted and no longer accessible.
//
// Always check the NextToken response parameter for a null value when calling
// a List* operation. These operations can occasionally return an empty set
// of results even when there are more results available. The NextToken response
// parameter value is null only when there are no more results to display.
//
// This operation can be called only from the organization's master account
// or by a member account that is a delegated administrator for an AWS service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation ListHandshakesForOrganization for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * AWSOrganizationsNotInUseException
//   Your account isn't a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * ConcurrentModificationException
//   The target of the operation is currently being modified by a different request.
//   Try again later.
//
//   * InvalidInputException
//   The requested operation failed because you provided invalid values for one
//   or more of the request parameters. This exception includes a reason that
//   contains additional information about the violated limit:
//
//   Some of the reasons in the following list might not be applicable to this
//   specific API or operation.
//
//      * DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to
//      the same entity.
//
//      * IMMUTABLE_POLICY: You specified a policy that is managed by AWS and
//      can't be modified.
//
//      * INPUT_REQUIRED: You must include a value for all required parameters.
//
//      * INVALID_ENUM: You specified an invalid value.
//
//      * INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
//
//      * INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid
//      characters.
//
//      * INVALID_LIST_MEMBER: You provided a list to a parameter that contains
//      at least one invalid value.
//
//      * INVALID_PAGINATION_TOKEN: Get the value for the NextToken parameter
//      from the response to a previous call of the operation.
//
//      * INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account,
//      organization, or email) as a party.
//
//      * INVALID_PATTERN: You provided a value that doesn't match the required
//      pattern.
//
//      * INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't
//      match the required pattern.
//
//      * INVALID_ROLE_NAME: You provided a role name that isn't valid. A role
//      name can't begin with the reserved prefix AWSServiceRoleFor.
//
//      * INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource
//      Name (ARN) for the organization.
//
//      * INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
//
//      * INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system
//      tag. You can’t add, edit, or delete system tag keys because they're
//      reserved for AWS use. System tags don’t count against your tags per
//      resource limit.
//
//      * MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter
//      for the operation.
//
//      * MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer
//      than allowed.
//
//      * MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger
//      value than allowed.
//
//      * MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter
//      than allowed.
//
//      * MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller
//      value than allowed.
//
//      * MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only
//      between entities in the same root.
//
//      * TARGET_NOT_SUPPORTED: You can't perform the specified operation on that
//      target entity.
//
//      * UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that
//      isn't recognized.
//
//   * ServiceException
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * TooManyRequestsException
//   You have sent too many requests in too short a period of time. The quota
//   helps protect against denial-of-service attacks. Try again later.
//
//   For information about quotas that affect AWS Organizations, see Quotas for
//   AWS Organizations (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html)in
//   the AWS Organizations User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListHandshakesForOrganization
func (c *Organizations) ListHandshakesForOrganization(input *ListHandshakesForOrganizationInput) (*ListHandshakesForOrganizationOutput, error) {
	req, out := c.ListHandshakesForOrganizationRequest(input)
	return out, req.Send()
}

// ListHandshakesForOrganizationWithContext is the same as ListHandshakesForOrganization with the addition of
// the ability to pass a context and additional request options.
//
// See ListHandshakesForOrganization for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) ListHandshakesForOrganizationWithContext(ctx aws.Context, input *ListHandshakesForOrganizationInput, opts ...request.Option) (*ListHandshakesForOrganizationOutput, error) {
	req, out := c.ListHandshakesForOrganizationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListHandshakesForOrganizationPages iterates over the pages of a ListHandshakesForOrganization operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListHandshakesForOrganization method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListHandshakesForOrganization operation.
//    pageNum := 0
//    err := client.ListHandshakesForOrganizationPages(params,
//        func(page *organizations.ListHandshakesForOrganizationOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Organizations) ListHandshakesForOrganizationPages(input *ListHandshakesForOrganizationInput, fn func(*ListHandshakesForOrganizationOutput, bool) bool) error {
	return c.ListHandshakesForOrganizationPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListHandshakesForOrganizationPagesWithContext same as ListHandshakesForOrganizationPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) ListHandshakesForOrganizationPagesWithContext(ctx aws.Context, input *ListHandshakesForOrganizationInput, fn func(*ListHandshakesForOrganizationOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListHandshakesForOrganizationInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListHandshakesForOrganizationRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListHandshakesForOrganizationOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListOrganizationalUnitsForParent = "ListOrganizationalUnitsForParent"

// ListOrganizationalUnitsForParentRequest generates a "aws/request.Request" representing the
// client's request for the ListOrganizationalUnitsForParent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListOrganizationalUnitsForParent for more information on using the ListOrganizationalUnitsForParent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListOrganizationalUnitsForParentRequest method.
//    req, resp := client.ListOrganizationalUnitsForParentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListOrganizationalUnitsForParent
func (c *Organizations) ListOrganizationalUnitsForParentRequest(input *ListOrganizationalUnitsForParentInput) (req *request.Request, output *ListOrganizationalUnitsForParentOutput) {
	op := &request.Operation{
		Name:       opListOrganizationalUnitsForParent,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListOrganizationalUnitsForParentInput{}
	}

	output = &ListOrganizationalUnitsForParentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListOrganizationalUnitsForParent API operation for AWS Organizations.
//
// Lists the organizational units (OUs) in a parent organizational unit or root.
//
// Always check the NextToken response parameter for a null value when calling
// a List* operation. These operations can occasionally return an empty set
// of results even when there are more results available. The NextToken response
// parameter value is null only when there are no more results to display.
//
// This operation can be called only from the organization's master account
// or by a member account that is a delegated administrator for an AWS service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation ListOrganizationalUnitsForParent for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * AWSOrganizationsNotInUseException
//   Your account isn't a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * InvalidInputException
//   The requested operation failed because you provided invalid values for one
//   or more of the request parameters. This exception includes a reason that
//   contains additional information about the violated limit:
//
//   Some of the reasons in the following list might not be applicable to this
//   specific API or operation.
//
//      * DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to
//      the same entity.
//
//      * IMMUTABLE_POLICY: You specified a policy that is managed by AWS and
//      can't be modified.
//
//      * INPUT_REQUIRED: You must include a value for all required parameters.
//
//      * INVALID_ENUM: You specified an invalid value.
//
//      * INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
//
//      * INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid
//      characters.
//
//      * INVALID_LIST_MEMBER: You provided a list to a parameter that contains
//      at least one invalid value.
//
//      * INVALID_PAGINATION_TOKEN: Get the value for the NextToken parameter
//      from the response to a previous call of the operation.
//
//      * INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account,
//      organization, or email) as a party.
//
//      * INVALID_PATTERN: You provided a value that doesn't match the required
//      pattern.
//
//      * INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't
//      match the required pattern.
//
//      * INVALID_ROLE_NAME: You provided a role name that isn't valid. A role
//      name can't begin with the reserved prefix AWSServiceRoleFor.
//
//      * INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource
//      Name (ARN) for the organization.
//
//      * INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
//
//      * INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system
//      tag. You can’t add, edit, or delete system tag keys because they're
//      reserved for AWS use. System tags don’t count against your tags per
//      resource limit.
//
//      * MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter
//      for the operation.
//
//      * MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer
//      than allowed.
//
//      * MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger
//      value than allowed.
//
//      * MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter
//      than allowed.
//
//      * MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller
//      value than allowed.
//
//      * MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only
//      between entities in the same root.
//
//      * TARGET_NOT_SUPPORTED: You can't perform the specified operation on that
//      target entity.
//
//      * UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that
//      isn't recognized.
//
//   * ParentNotFoundException
//   We can't find a root or OU with the ParentId that you specified.
//
//   * ServiceException
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * TooManyRequestsException
//   You have sent too many requests in too short a period of time. The quota
//   helps protect against denial-of-service attacks. Try again later.
//
//   For information about quotas that affect AWS Organizations, see Quotas for
//   AWS Organizations (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html)in
//   the AWS Organizations User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListOrganizationalUnitsForParent
func (c *Organizations) ListOrganizationalUnitsForParent(input *ListOrganizationalUnitsForParentInput) (*ListOrganizationalUnitsForParentOutput, error) {
	req, out := c.ListOrganizationalUnitsForParentRequest(input)
	return out, req.Send()
}

// ListOrganizationalUnitsForParentWithContext is the same as ListOrganizationalUnitsForParent with the addition of
// the ability to pass a context and additional request options.
//
// See ListOrganizationalUnitsForParent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) ListOrganizationalUnitsForParentWithContext(ctx aws.Context, input *ListOrganizationalUnitsForParentInput, opts ...request.Option) (*ListOrganizationalUnitsForParentOutput, error) {
	req, out := c.ListOrganizationalUnitsForParentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListOrganizationalUnitsForParentPages iterates over the pages of a ListOrganizationalUnitsForParent operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListOrganizationalUnitsForParent method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListOrganizationalUnitsForParent operation.
//    pageNum := 0
//    err := client.ListOrganizationalUnitsForParentPages(params,
//        func(page *organizations.ListOrganizationalUnitsForParentOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Organizations) ListOrganizationalUnitsForParentPages(input *ListOrganizationalUnitsForParentInput, fn func(*ListOrganizationalUnitsForParentOutput, bool) bool) error {
	return c.ListOrganizationalUnitsForParentPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListOrganizationalUnitsForParentPagesWithContext same as ListOrganizationalUnitsForParentPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) ListOrganizationalUnitsForParentPagesWithContext(ctx aws.Context, input *ListOrganizationalUnitsForParentInput, fn func(*ListOrganizationalUnitsForParentOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListOrganizationalUnitsForParentInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListOrganizationalUnitsForParentRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListOrganizationalUnitsForParentOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListParents = "ListParents"

// ListParentsRequest generates a "aws/request.Request" representing the
// client's request for the ListParents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListParents for more information on using the ListParents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListParentsRequest method.
//    req, resp := client.ListParentsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListParents
func (c *Organizations) ListParentsRequest(input *ListParentsInput) (req *request.Request, output *ListParentsOutput) {
	op := &request.Operation{
		Name:       opListParents,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListParentsInput{}
	}

	output = &ListParentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListParents API operation for AWS Organizations.
//
// Lists the root or organizational units (OUs) that serve as the immediate
// parent of the specified child OU or account. This operation, along with ListChildren
// enables you to traverse the tree structure that makes up this root.
//
// Always check the NextToken response parameter for a null value when calling
// a List* operation. These operations can occasionally return an empty set
// of results even when there are more results available. The NextToken response
// parameter value is null only when there are no more results to display.
//
// This operation can be called only from the organization's master account
// or by a member account that is a delegated administrator for an AWS service.
//
// In the current release, a child can have only a single parent.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation ListParents for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * AWSOrganizationsNotInUseException
//   Your account isn't a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * ChildNotFoundException
//   We can't find an organizational unit (OU) or AWS account with the ChildId
//   that you specified.
//
//   * InvalidInputException
//   The requested operation failed because you provided invalid values for one
//   or more of the request parameters. This exception includes a reason that
//   contains additional information about the violated limit:
//
//   Some of the reasons in the following list might not be applicable to this
//   specific API or operation.
//
//      * DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to
//      the same entity.
//
//      * IMMUTABLE_POLICY: You specified a policy that is managed by AWS and
//      can't be modified.
//
//      * INPUT_REQUIRED: You must include a value for all required parameters.
//
//      * INVALID_ENUM: You specified an invalid value.
//
//      * INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
//
//      * INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid
//      characters.
//
//      * INVALID_LIST_MEMBER: You provided a list to a parameter that contains
//      at least one invalid value.
//
//      * INVALID_PAGINATION_TOKEN: Get the value for the NextToken parameter
//      from the response to a previous call of the operation.
//
//      * INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account,
//      organization, or email) as a party.
//
//      * INVALID_PATTERN: You provided a value that doesn't match the required
//      pattern.
//
//      * INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't
//      match the required pattern.
//
//      * INVALID_ROLE_NAME: You provided a role name that isn't valid. A role
//      name can't begin with the reserved prefix AWSServiceRoleFor.
//
//      * INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource
//      Name (ARN) for the organization.
//
//      * INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
//
//      * INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system
//      tag. You can’t add, edit, or delete system tag keys because they're
//      reserved for AWS use. System tags don’t count against your tags per
//      resource limit.
//
//      * MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter
//      for the operation.
//
//      * MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer
//      than allowed.
//
//      * MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger
//      value than allowed.
//
//      * MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter
//      than allowed.
//
//      * MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller
//      value than allowed.
//
//      * MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only
//      between entities in the same root.
//
//      * TARGET_NOT_SUPPORTED: You can't perform the specified operation on that
//      target entity.
//
//      * UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that
//      isn't recognized.
//
//   * ServiceException
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * TooManyRequestsException
//   You have sent too many requests in too short a period of time. The quota
//   helps protect against denial-of-service attacks. Try again later.
//
//   For information about quotas that affect AWS Organizations, see Quotas for
//   AWS Organizations (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html)in
//   the AWS Organizations User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListParents
func (c *Organizations) ListParents(input *ListParentsInput) (*ListParentsOutput, error) {
	req, out := c.ListParentsRequest(input)
	return out, req.Send()
}

// ListParentsWithContext is the same as ListParents with the addition of
// the ability to pass a context and additional request options.
//
// See ListParents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) ListParentsWithContext(ctx aws.Context, input *ListParentsInput, opts ...request.Option) (*ListParentsOutput, error) {
	req, out := c.ListParentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListParentsPages iterates over the pages of a ListParents operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListParents method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListParents operation.
//    pageNum := 0
//    err := client.ListParentsPages(params,
//        func(page *organizations.ListParentsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Organizations) ListParentsPages(input *ListParentsInput, fn func(*ListParentsOutput, bool) bool) error {
	return c.ListParentsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListParentsPagesWithContext same as ListParentsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) ListParentsPagesWithContext(ctx aws.Context, input *ListParentsInput, fn func(*ListParentsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListParentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListParentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListParentsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPolicies = "ListPolicies"

// ListPoliciesRequest generates a "aws/request.Request" representing the
// client's request for the ListPolicies operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPolicies for more information on using the ListPolicies
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListPoliciesRequest method.
//    req, resp := client.ListPoliciesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListPolicies
func (c *Organizations) ListPoliciesRequest(input *ListPoliciesInput) (req *request.Request, output *ListPoliciesOutput) {
	op := &request.Operation{
		Name:       opListPolicies,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPoliciesInput{}
	}

	output = &ListPoliciesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPolicies API operation for AWS Organizations.
//
// Retrieves the list of all policies in an organization of a specified type.
//
// Always check the NextToken response parameter for a null value when calling
// a List* operation. These operations can occasionally return an empty set
// of results even when there are more results available. The NextToken response
// parameter value is null only when there are no more results to display.
//
// This operation can be called only from the organization's master account
// or by a member account that is a delegated administrator for an AWS service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation ListPolicies for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * AWSOrganizationsNotInUseException
//   Your account isn't a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * InvalidInputException
//   The requested operation failed because you provided invalid values for one
//   or more of the request parameters. This exception includes a reason that
//   contains additional information about the violated limit:
//
//   Some of the reasons in the following list might not be applicable to this
//   specific API or operation.
//
//      * DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to
//      the same entity.
//
//      * IMMUTABLE_POLICY: You specified a policy that is managed by AWS and
//      can't be modified.
//
//      * INPUT_REQUIRED: You must include a value for all required parameters.
//
//      * INVALID_ENUM: You specified an invalid value.
//
//      * INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
//
//      * INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid
//      characters.
//
//      * INVALID_LIST_MEMBER: You provided a list to a parameter that contains
//      at least one invalid value.
//
//      * INVALID_PAGINATION_TOKEN: Get the value for the NextToken parameter
//      from the response to a previous call of the operation.
//
//      * INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account,
//      organization, or email) as a party.
//
//      * INVALID_PATTERN: You provided a value that doesn't match the required
//      pattern.
//
//      * INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't
//      match the required pattern.
//
//      * INVALID_ROLE_NAME: You provided a role name that isn't valid. A role
//      name can't begin with the reserved prefix AWSServiceRoleFor.
//
//      * INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource
//      Name (ARN) for the organization.
//
//      * INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
//
//      * INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system
//      tag. You can’t add, edit, or delete system tag keys because they're
//      reserved for AWS use. System tags don’t count against your tags per
//      resource limit.
//
//      * MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter
//      for the operation.
//
//      * MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer
//      than allowed.
//
//      * MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger
//      value than allowed.
//
//      * MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter
//      than allowed.
//
//      * MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller
//      value than allowed.
//
//      * MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only
//      between entities in the same root.
//
//      * TARGET_NOT_SUPPORTED: You can't perform the specified operation on that
//      target entity.
//
//      * UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that
//      isn't recognized.
//
//   * ServiceException
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * TooManyRequestsException
//   You have sent too many requests in too short a period of time. The quota
//   helps protect against denial-of-service attacks. Try again later.
//
//   For information about quotas that affect AWS Organizations, see Quotas for
//   AWS Organizations (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html)in
//   the AWS Organizations User Guide.
//
//   * UnsupportedAPIEndpointException
//   This action isn't available in the current AWS Region.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListPolicies
func (c *Organizations) ListPolicies(input *ListPoliciesInput) (*ListPoliciesOutput, error) {
	req, out := c.ListPoliciesRequest(input)
	return out, req.Send()
}

// ListPoliciesWithContext is the same as ListPolicies with the addition of
// the ability to pass a context and additional request options.
//
// See ListPolicies for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) ListPoliciesWithContext(ctx aws.Context, input *ListPoliciesInput, opts ...request.Option) (*ListPoliciesOutput, error) {
	req, out := c.ListPoliciesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPoliciesPages iterates over the pages of a ListPolicies operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPolicies method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListPolicies operation.
//    pageNum := 0
//    err := client.ListPoliciesPages(params,
//        func(page *organizations.ListPoliciesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Organizations) ListPoliciesPages(input *ListPoliciesInput, fn func(*ListPoliciesOutput, bool) bool) error {
	return c.ListPoliciesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPoliciesPagesWithContext same as ListPoliciesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) ListPoliciesPagesWithContext(ctx aws.Context, input *ListPoliciesInput, fn func(*ListPoliciesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPoliciesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPoliciesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPoliciesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPoliciesForTarget = "ListPoliciesForTarget"

// ListPoliciesForTargetRequest generates a "aws/request.Request" representing the
// client's request for the ListPoliciesForTarget operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPoliciesForTarget for more information on using the ListPoliciesForTarget
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListPoliciesForTargetRequest method.
//    req, resp := client.ListPoliciesForTargetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListPoliciesForTarget
func (c *Organizations) ListPoliciesForTargetRequest(input *ListPoliciesForTargetInput) (req *request.Request, output *ListPoliciesForTargetOutput) {
	op := &request.Operation{
		Name:       opListPoliciesForTarget,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPoliciesForTargetInput{}
	}

	output = &ListPoliciesForTargetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPoliciesForTarget API operation for AWS Organizations.
//
// Lists the policies that are directly attached to the specified target root,
// organizational unit (OU), or account. You must specify the policy type that
// you want included in the returned list.
//
// Always check the NextToken response parameter for a null value when calling
// a List* operation. These operations can occasionally return an empty set
// of results even when there are more results available. The NextToken response
// parameter value is null only when there are no more results to display.
//
// This operation can be called only from the organization's master account
// or by a member account that is a delegated administrator for an AWS service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation ListPoliciesForTarget for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * AWSOrganizationsNotInUseException
//   Your account isn't a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * InvalidInputException
//   The requested operation failed because you provided invalid values for one
//   or more of the request parameters. This exception includes a reason that
//   contains additional information about the violated limit:
//
//   Some of the reasons in the following list might not be applicable to this
//   specific API or operation.
//
//      * DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to
//      the same entity.
//
//      * IMMUTABLE_POLICY: You specified a policy that is managed by AWS and
//      can't be modified.
//
//      * INPUT_REQUIRED: You must include a value for all required parameters.
//
//      * INVALID_ENUM: You specified an invalid value.
//
//      * INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
//
//      * INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid
//      characters.
//
//      * INVALID_LIST_MEMBER: You provided a list to a parameter that contains
//      at least one invalid value.
//
//      * INVALID_PAGINATION_TOKEN: Get the value for the NextToken parameter
//      from the response to a previous call of the operation.
//
//      * INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account,
//      organization, or email) as a party.
//
//      * INVALID_PATTERN: You provided a value that doesn't match the required
//      pattern.
//
//      * INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't
//      match the required pattern.
//
//      * INVALID_ROLE_NAME: You provided a role name that isn't valid. A role
//      name can't begin with the reserved prefix AWSServiceRoleFor.
//
//      * INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource
//      Name (ARN) for the organization.
//
//      * INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
//
//      * INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system
//      tag. You can’t add, edit, or delete system tag keys because they're
//      reserved for AWS use. System tags don’t count against your tags per
//      resource limit.
//
//      * MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter
//      for the operation.
//
//      * MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer
//      than allowed.
//
//      * MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger
//      value than allowed.
//
//      * MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter
//      than allowed.
//
//      * MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller
//      value than allowed.
//
//      * MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only
//      between entities in the same root.
//
//      * TARGET_NOT_SUPPORTED: You can't perform the specified operation on that
//      target entity.
//
//      * UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that
//      isn't recognized.
//
//   * ServiceException
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * TargetNotFoundException
//   We can't find a root, OU, account, or policy with the TargetId that you specified.
//
//   * TooManyRequestsException
//   You have sent too many requests in too short a period of time. The quota
//   helps protect against denial-of-service attacks. Try again later.
//
//   For information about quotas that affect AWS Organizations, see Quotas for
//   AWS Organizations (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html)in
//   the AWS Organizations User Guide.
//
//   * UnsupportedAPIEndpointException
//   This action isn't available in the current AWS Region.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListPoliciesForTarget
func (c *Organizations) ListPoliciesForTarget(input *ListPoliciesForTargetInput) (*ListPoliciesForTargetOutput, error) {
	req, out := c.ListPoliciesForTargetRequest(input)
	return out, req.Send()
}

// ListPoliciesForTargetWithContext is the same as ListPoliciesForTarget with the addition of
// the ability to pass a context and additional request options.
//
// See ListPoliciesForTarget for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) ListPoliciesForTargetWithContext(ctx aws.Context, input *ListPoliciesForTargetInput, opts ...request.Option) (*ListPoliciesForTargetOutput, error) {
	req, out := c.ListPoliciesForTargetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPoliciesForTargetPages iterates over the pages of a ListPoliciesForTarget operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPoliciesForTarget method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListPoliciesForTarget operation.
//    pageNum := 0
//    err := client.ListPoliciesForTargetPages(params,
//        func(page *organizations.ListPoliciesForTargetOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Organizations) ListPoliciesForTargetPages(input *ListPoliciesForTargetInput, fn func(*ListPoliciesForTargetOutput, bool) bool) error {
	return c.ListPoliciesForTargetPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPoliciesForTargetPagesWithContext same as ListPoliciesForTargetPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) ListPoliciesForTargetPagesWithContext(ctx aws.Context, input *ListPoliciesForTargetInput, fn func(*ListPoliciesForTargetOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPoliciesForTargetInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPoliciesForTargetRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPoliciesForTargetOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListRoots = "ListRoots"

// ListRootsRequest generates a "aws/request.Request" representing the
// client's request for the ListRoots operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRoots for more information on using the ListRoots
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListRootsRequest method.
//    req, resp := client.ListRootsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListRoots
func (c *Organizations) ListRootsRequest(input *ListRootsInput) (req *request.Request, output *ListRootsOutput) {
	op := &request.Operation{
		Name:       opListRoots,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRootsInput{}
	}

	output = &ListRootsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRoots API operation for AWS Organizations.
//
// Lists the roots that are defined in the current organization.
//
// Always check the NextToken response parameter for a null value when calling
// a List* operation. These operations can occasionally return an empty set
// of results even when there are more results available. The NextToken response
// parameter value is null only when there are no more results to display.
//
// This operation can be called only from the organization's master account
// or by a member account that is a delegated administrator for an AWS service.
//
// Policy types can be enabled and disabled in roots. This is distinct from
// whether they're available in the organization. When you enable all features,
// you make policy types available for use in that organization. Individual
// policy types can then be enabled and disabled in a root. To see the availability
// of a policy type in an organization, use DescribeOrganization.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation ListRoots for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * AWSOrganizationsNotInUseException
//   Your account isn't a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * InvalidInputException
//   The requested operation failed because you provided invalid values for one
//   or more of the request parameters. This exception includes a reason that
//   contains additional information about the violated limit:
//
//   Some of the reasons in the following list might not be applicable to this
//   specific API or operation.
//
//      * DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to
//      the same entity.
//
//      * IMMUTABLE_POLICY: You specified a policy that is managed by AWS and
//      can't be modified.
//
//      * INPUT_REQUIRED: You must include a value for all required parameters.
//
//      * INVALID_ENUM: You specified an invalid value.
//
//      * INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
//
//      * INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid
//      characters.
//
//      * INVALID_LIST_MEMBER: You provided a list to a parameter that contains
//      at least one invalid value.
//
//      * INVALID_PAGINATION_TOKEN: Get the value for the NextToken parameter
//      from the response to a previous call of the operation.
//
//      * INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account,
//      organization, or email) as a party.
//
//      * INVALID_PATTERN: You provided a value that doesn't match the required
//      pattern.
//
//      * INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't
//      match the required pattern.
//
//      * INVALID_ROLE_NAME: You provided a role name that isn't valid. A role
//      name can't begin with the reserved prefix AWSServiceRoleFor.
//
//      * INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource
//      Name (ARN) for the organization.
//
//      * INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
//
//      * INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system
//      tag. You can’t add, edit, or delete system tag keys because they're
//      reserved for AWS use. System tags don’t count against your tags per
//      resource limit.
//
//      * MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter
//      for the operation.
//
//      * MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer
//      than allowed.
//
//      * MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger
//      value than allowed.
//
//      * MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter
//      than allowed.
//
//      * MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller
//      value than allowed.
//
//      * MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only
//      between entities in the same root.
//
//      * TARGET_NOT_SUPPORTED: You can't perform the specified operation on that
//      target entity.
//
//      * UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that
//      isn't recognized.
//
//   * ServiceException
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * TooManyRequestsException
//   You have sent too many requests in too short a period of time. The quota
//   helps protect against denial-of-service attacks. Try again later.
//
//   For information about quotas that affect AWS Organizations, see Quotas for
//   AWS Organizations (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html)in
//   the AWS Organizations User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListRoots
func (c *Organizations) ListRoots(input *ListRootsInput) (*ListRootsOutput, error) {
	req, out := c.ListRootsRequest(input)
	return out, req.Send()
}

// ListRootsWithContext is the same as ListRoots with the addition of
// the ability to pass a context and additional request options.
//
// See ListRoots for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) ListRootsWithContext(ctx aws.Context, input *ListRootsInput, opts ...request.Option) (*ListRootsOutput, error) {
	req, out := c.ListRootsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRootsPages iterates over the pages of a ListRoots operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRoots method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListRoots operation.
//    pageNum := 0
//    err := client.ListRootsPages(params,
//        func(page *organizations.ListRootsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Organizations) ListRootsPages(input *ListRootsInput, fn func(*ListRootsOutput, bool) bool) error {
	return c.ListRootsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRootsPagesWithContext same as ListRootsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) ListRootsPagesWithContext(ctx aws.Context, input *ListRootsInput, fn func(*ListRootsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRootsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRootsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListRootsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListTagsForResource
func (c *Organizations) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS Organizations.
//
// Lists tags that are attached to the specified resource.
//
// You can attach tags to the following resources in AWS Organizations.
//
//    * AWS account
//
//    * Organization root
//
//    * Organizational unit (OU)
//
//    * Policy (any type)
//
// This operation can be called only from the organization's master account
// or by a member account that is a delegated administrator for an AWS service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * AWSOrganizationsNotInUseException
//   Your account isn't a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * TargetNotFoundException
//   We can't find a root, OU, account, or policy with the TargetId that you specified.
//
//   * InvalidInputException
//   The requested operation failed because you provided invalid values for one
//   or more of the request parameters. This exception includes a reason that
//   contains additional information about the violated limit:
//
//   Some of the reasons in the following list might not be applicable to this
//   specific API or operation.
//
//      * DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to
//      the same entity.
//
//      * IMMUTABLE_POLICY: You specified a policy that is managed by AWS and
//      can't be modified.
//
//      * INPUT_REQUIRED: You must include a value for all required parameters.
//
//      * INVALID_ENUM: You specified an invalid value.
//
//      * INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
//
//      * INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid
//      characters.
//
//      * INVALID_LIST_MEMBER: You provided a list to a parameter that contains
//      at least one invalid value.
//
//      * INVALID_PAGINATION_TOKEN: Get the value for the NextToken parameter
//      from the response to a previous call of the operation.
//
//      * INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account,
//      organization, or email) as a party.
//
//      * INVALID_PATTERN: You provided a value that doesn't match the required
//      pattern.
//
//      * INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't
//      match the required pattern.
//
//      * INVALID_ROLE_NAME: You provided a role name that isn't valid. A role
//      name can't begin with the reserved prefix AWSServiceRoleFor.
//
//      * INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource
//      Name (ARN) for the organization.
//
//      * INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
//
//      * INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system
//      tag. You can’t add, edit, or delete system tag keys because they're
//      reserved for AWS use. System tags don’t count against your tags per
//      resource limit.
//
//      * MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter
//      for the operation.
//
//      * MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer
//      than allowed.
//
//      * MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger
//      value than allowed.
//
//      * MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter
//      than allowed.
//
//      * MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller
//      value than allowed.
//
//      * MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only
//      between entities in the same root.
//
//      * TARGET_NOT_SUPPORTED: You can't perform the specified operation on that
//      target entity.
//
//      * UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that
//      isn't recognized.
//
//   * ServiceException
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * TooManyRequestsException
//   You have sent too many requests in too short a period of time. The quota
//   helps protect against denial-of-service attacks. Try again later.
//
//   For information about quotas that affect AWS Organizations, see Quotas for
//   AWS Organizations (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html)in
//   the AWS Organizations User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListTagsForResource
func (c *Organizations) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTagsForResourcePages iterates over the pages of a ListTagsForResource operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTagsForResource method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListTagsForResource operation.
//    pageNum := 0
//    err := client.ListTagsForResourcePages(params,
//        func(page *organizations.ListTagsForResourceOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Organizations) ListTagsForResourcePages(input *ListTagsForResourceInput, fn func(*ListTagsForResourceOutput, bool) bool) error {
	return c.ListTagsForResourcePagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTagsForResourcePagesWithContext same as ListTagsForResourcePages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) ListTagsForResourcePagesWithContext(ctx aws.Context, input *ListTagsForResourceInput, fn func(*ListTagsForResourceOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTagsForResourceInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTagsForResourceRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTagsForResourceOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTargetsForPolicy = "ListTargetsForPolicy"

// ListTargetsForPolicyRequest generates a "aws/request.Request" representing the
// client's request for the ListTargetsForPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTargetsForPolicy for more information on using the ListTargetsForPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTargetsForPolicyRequest method.
//    req, resp := client.ListTargetsForPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListTargetsForPolicy
func (c *Organizations) ListTargetsForPolicyRequest(input *ListTargetsForPolicyInput) (req *request.Request, output *ListTargetsForPolicyOutput) {
	op := &request.Operation{
		Name:       opListTargetsForPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTargetsForPolicyInput{}
	}

	output = &ListTargetsForPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTargetsForPolicy API operation for AWS Organizations.
//
// Lists all the roots, organizational units (OUs), and accounts that the specified
// policy is attached to.
//
// Always check the NextToken response parameter for a null value when calling
// a List* operation. These operations can occasionally return an empty set
// of results even when there are more results available. The NextToken response
// parameter value is null only when there are no more results to display.
//
// This operation can be called only from the organization's master account
// or by a member account that is a delegated administrator for an AWS service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation ListTargetsForPolicy for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * AWSOrganizationsNotInUseException
//   Your account isn't a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * InvalidInputException
//   The requested operation failed because you provided invalid values for one
//   or more of the request parameters. This exception includes a reason that
//   contains additional information about the violated limit:
//
//   Some of the reasons in the following list might not be applicable to this
//   specific API or operation.
//
//      * DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to
//      the same entity.
//
//      * IMMUTABLE_POLICY: You specified a policy that is managed by AWS and
//      can't be modified.
//
//      * INPUT_REQUIRED: You must include a value for all required parameters.
//
//      * INVALID_ENUM: You specified an invalid value.
//
//      * INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
//
//      * INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid
//      characters.
//
//      * INVALID_LIST_MEMBER: You provided a list to a parameter that contains
//      at least one invalid value.
//
//      * INVALID_PAGINATION_TOKEN: Get the value for the NextToken parameter
//      from the response to a previous call of the operation.
//
//      * INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account,
//      organization, or email) as a party.
//
//      * INVALID_PATTERN: You provided a value that doesn't match the required
//      pattern.
//
//      * INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't
//      match the required pattern.
//
//      * INVALID_ROLE_NAME: You provided a role name that isn't valid. A role
//      name can't begin with the reserved prefix AWSServiceRoleFor.
//
//      * INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource
//      Name (ARN) for the organization.
//
//      * INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
//
//      * INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system
//      tag. You can’t add, edit, or delete system tag keys because they're
//      reserved for AWS use. System tags don’t count against your tags per
//      resource limit.
//
//      * MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter
//      for the operation.
//
//      * MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer
//      than allowed.
//
//      * MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger
//      value than allowed.
//
//      * MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter
//      than allowed.
//
//      * MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller
//      value than allowed.
//
//      * MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only
//      between entities in the same root.
//
//      * TARGET_NOT_SUPPORTED: You can't perform the specified operation on that
//      target entity.
//
//      * UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that
//      isn't recognized.
//
//   * PolicyNotFoundException
//   We can't find a policy with the PolicyId that you specified.
//
//   * ServiceException
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * TooManyRequestsException
//   You have sent too many requests in too short a period of time. The quota
//   helps protect against denial-of-service attacks. Try again later.
//
//   For information about quotas that affect AWS Organizations, see Quotas for
//   AWS Organizations (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html)in
//   the AWS Organizations User Guide.
//
//   * UnsupportedAPIEndpointException
//   This action isn't available in the current AWS Region.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListTargetsForPolicy
func (c *Organizations) ListTargetsForPolicy(input *ListTargetsForPolicyInput) (*ListTargetsForPolicyOutput, error) {
	req, out := c.ListTargetsForPolicyRequest(input)
	return out, req.Send()
}

// ListTargetsForPolicyWithContext is the same as ListTargetsForPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See ListTargetsForPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) ListTargetsForPolicyWithContext(ctx aws.Context, input *ListTargetsForPolicyInput, opts ...request.Option) (*ListTargetsForPolicyOutput, error) {
	req, out := c.ListTargetsForPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTargetsForPolicyPages iterates over the pages of a ListTargetsForPolicy operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTargetsForPolicy method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListTargetsForPolicy operation.
//    pageNum := 0
//    err := client.ListTargetsForPolicyPages(params,
//        func(page *organizations.ListTargetsForPolicyOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Organizations) ListTargetsForPolicyPages(input *ListTargetsForPolicyInput, fn func(*ListTargetsForPolicyOutput, bool) bool) error {
	return c.ListTargetsForPolicyPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTargetsForPolicyPagesWithContext same as ListTargetsForPolicyPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) ListTargetsForPolicyPagesWithContext(ctx aws.Context, input *ListTargetsForPolicyInput, fn func(*ListTargetsForPolicyOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTargetsForPolicyInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTargetsForPolicyRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTargetsForPolicyOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opMoveAccount = "MoveAccount"

// MoveAccountRequest generates a "aws/request.Request" representing the
// client's request for the MoveAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See MoveAccount for more information on using the MoveAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the MoveAccountRequest method.
//    req, resp := client.MoveAccountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/MoveAccount
func (c *Organizations) MoveAccountRequest(input *MoveAccountInput) (req *request.Request, output *MoveAccountOutput) {
	op := &request.Operation{
		Name:       opMoveAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &MoveAccountInput{}
	}

	output = &MoveAccountOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// MoveAccount API operation for AWS Organizations.
//
// Moves an account from its current source parent root or organizational unit
// (OU) to the specified destination parent root or OU.
//
// This operation can be called only from the organization's master account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation MoveAccount for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * InvalidInputException
//   The requested operation failed because you provided invalid values for one
//   or more of the request parameters. This exception includes a reason that
//   contains additional information about the violated limit:
//
//   Some of the reasons in the following list might not be applicable to this
//   specific API or operation.
//
//      * DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to
//      the same entity.
//
//      * IMMUTABLE_POLICY: You specified a policy that is managed by AWS and
//      can't be modified.
//
//      * INPUT_REQUIRED: You must include a value for all required parameters.
//
//      * INVALID_ENUM: You specified an invalid value.
//
//      * INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
//
//      * INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid
//      characters.
//
//      * INVALID_LIST_MEMBER: You provided a list to a parameter that contains
//      at least one invalid value.
//
//      * INVALID_PAGINATION_TOKEN: Get the value for the NextToken parameter
//      from the response to a previous call of the operation.
//
//      * INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account,
//      organization, or email) as a party.
//
//      * INVALID_PATTERN: You provided a value that doesn't match the required
//      pattern.
//
//      * INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't
//      match the required pattern.
//
//      * INVALID_ROLE_NAME: You provided a role name that isn't valid. A role
//      name can't begin with the reserved prefix AWSServiceRoleFor.
//
//      * INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource
//      Name (ARN) for the organization.
//
//      * INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
//
//      * INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system
//      tag. You can’t add, edit, or delete system tag keys because they're
//      reserved for AWS use. System tags don’t count against your tags per
//      resource limit.
//
//      * MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter
//      for the operation.
//
//      * MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer
//      than allowed.
//
//      * MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger
//      value than allowed.
//
//      * MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter
//      than allowed.
//
//      * MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller
//      value than allowed.
//
//      * MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only
//      between entities in the same root.
//
//      * TARGET_NOT_SUPPORTED: You can't perform the specified operation on that
//      target entity.
//
//      * UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that
//      isn't recognized.
//
//   * SourceParentNotFoundException
//   We can't find a source root or OU with the ParentId that you specified.
//
//   * DestinationParentNotFoundException
//   We can't find the destination container (a root or OU) with the ParentId
//   that you specified.
//
//   * DuplicateAccountException
//   That account is already present in the specified destination.
//
//   * AccountNotFoundException
//   We can't find an AWS account with the AccountId that you specified, or the
//   account whose credentials you used to make this request isn't a member of
//   an organization.
//
//   * TooManyRequestsException
//   You have sent too many requests in too short a period of time. The quota
//   helps protect against denial-of-service attacks. Try again later.
//
//   For information about quotas that affect AWS Organizations, see Quotas for
//   AWS Organizations (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html)in
//   the AWS Organizations User Guide.
//
//   * ConcurrentModificationException
//   The target of the operation is currently being modified by a different request.
//   Try again later.
//
//   * AWSOrganizationsNotInUseException
//   Your account isn't a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * ServiceException
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/MoveAccount
func (c *Organizations) MoveAccount(input *MoveAccountInput) (*MoveAccountOutput, error) {
	req, out := c.MoveAccountRequest(input)
	return out, req.Send()
}

// MoveAccountWithContext is the same as MoveAccount with the addition of
// the ability to pass a context and additional request options.
//
// See MoveAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) MoveAccountWithContext(ctx aws.Context, input *MoveAccountInput, opts ...request.Option) (*MoveAccountOutput, error) {
	req, out := c.MoveAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRegisterDelegatedAdministrator = "RegisterDelegatedAdministrator"

// RegisterDelegatedAdministratorRequest generates a "aws/request.Request" representing the
// client's request for the RegisterDelegatedAdministrator operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RegisterDelegatedAdministrator for more information on using the RegisterDelegatedAdministrator
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RegisterDelegatedAdministratorRequest method.
//    req, resp := client.RegisterDelegatedAdministratorRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/RegisterDelegatedAdministrator
func (c *Organizations) RegisterDelegatedAdministratorRequest(input *RegisterDelegatedAdministratorInput) (req *request.Request, output *RegisterDelegatedAdministratorOutput) {
	op := &request.Operation{
		Name:       opRegisterDelegatedAdministrator,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterDelegatedAdministratorInput{}
	}

	output = &RegisterDelegatedAdministratorOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RegisterDelegatedAdministrator API operation for AWS Organizations.
//
// Enables the specified member account to administer the Organizations features
// of the specified AWS service. It grants read-only access to AWS Organizations
// service data. The account still requires IAM permissions to access and administer
// the AWS service.
//
// You can run this action only for AWS services that support this feature.
// For a current list of services that support it, see the column Supports Delegated
// Administrator in the table at AWS Services that you can use with AWS Organizations
// (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrated-services-list.html)
// in the AWS Organizations User Guide.
//
// This operation can be called only from the organization's master account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation RegisterDelegatedAdministrator for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * AccountAlreadyRegisteredException
//   The specified account is already a delegated administrator for this AWS service.
//
//   * AccountNotFoundException
//   We can't find an AWS account with the AccountId that you specified, or the
//   account whose credentials you used to make this request isn't a member of
//   an organization.
//
//   * AWSOrganizationsNotInUseException
//   Your account isn't a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * ConcurrentModificationException
//   The target of the operation is currently being modified by a different request.
//   Try again later.
//
//   * ConstraintViolationException
//   Performing this operation violates a minimum or maximum value limit. For
//   example, attempting to remove the last service control policy (SCP) from
//   an OU or root, inviting or creating too many accounts to the organization,
//   or attaching too many policies to an account, OU, or root. This exception
//   includes a reason that contains additional information about the violated
//   limit:
//
//   Some of the reasons in the following list might not be applicable to this
//   specific API or operation.
//
//      * ACCOUNT_CANNOT_LEAVE_ORGANIZAION: You attempted to remove the master
//      account from the organization. You can't remove the master account. Instead,
//      after you remove all member accounts, delete the organization itself.
//
//      * ACCOUNT_CANNOT_LEAVE_WITHOUT_EULA: You attempted to remove an account
//      from the organization that doesn't yet have enough information to exist
//      as a standalone account. This account requires you to first agree to the
//      AWS Customer Agreement. Follow the steps at Removing a member account
//      from your organization (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master)in
//      the AWS Organizations User Guide.
//
//      * ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove
//      an account from the organization that doesn't yet have enough information
//      to exist as a standalone account. This account requires you to first complete
//      phone verification. Follow the steps at Removing a member account from
//      your organization (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master)
//      in the AWS Organizations User Guide.
//
//      * ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number
//      of accounts that you can create in one day.
//
//      * ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on
//      the number of accounts in an organization. If you need more accounts,
//      contact AWS Support (https://console.aws.amazon.com/support/home#/) to
//      request an increase in your limit. Or the number of invitations that you
//      tried to send would cause you to exceed the limit of accounts in your
//      organization. Send fewer invitations or contact AWS Support to request
//      an increase in the number of accounts. Deleted and closed accounts still
//      count toward your limit. If you get this exception when running a command
//      immediately after creating the organization, wait one hour and try again.
//      After an hour, if the command continues to fail with this error, contact
//      AWS Support (https://console.aws.amazon.com/support/home#/).
//
//      * CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to
//      register the master account of the organization as a delegated administrator
//      for an AWS service integrated with Organizations. You can designate only
//      a member account as a delegated administrator.
//
//      * CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove
//      an account that is registered as a delegated administrator for a service
//      integrated with your organization. To complete this operation, you must
//      first deregister this account as a delegated administrator.
//
//      * CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an
//      organization in the specified region, you must enable all features mode.
//
//      * DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register
//      an AWS account as a delegated administrator for an AWS service that already
//      has a delegated administrator. To complete this operation, you must first
//      deregister any existing delegated administrators for this service.
//
//      * EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only
//      valid for a limited period of time. You must resubmit the request and
//      generate a new verfication code.
//
//      * HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of
//      handshakes that you can send in one day.
//
//      * MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account
//      in this organization, you first must migrate the organization's master
//      account to the marketplace that corresponds to the master account's address.
//      For example, accounts with India addresses must be associated with the
//      AISPL marketplace. All accounts in an organization must be associated
//      with the same marketplace.
//
//      * MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the AWS Regions
//      in China. To create an organization, the master must have an valid business
//      license. For more information, contact customer support.
//
//      * MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you
//      must first provide a valid contact address and phone number for the master
//      account. Then try the operation again.
//
//      * MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the
//      master account must have an associated account in the AWS GovCloud (US-West)
//      Region. For more information, see AWS Organizations (http://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html)
//      in the AWS GovCloud User Guide.
//
//      * MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization
//      with this master account, you first must associate a valid payment instrument,
//      such as a credit card, with the account. Follow the steps at To leave
//      an organization when all required account information has not yet been
//      provided (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info)
//      in the AWS Organizations User Guide.
//
//      * MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted
//      to register more delegated administrators than allowed for the service
//      principal.
//
//      * MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the
//      number of policies of a certain type that can be attached to an entity
//      at one time.
//
//      * MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed
//      on this resource.
//
//      * MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation
//      with this member account, you first must associate a valid payment instrument,
//      such as a credit card, with the account. Follow the steps at To leave
//      an organization when all required account information has not yet been
//      provided (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info)
//      in the AWS Organizations User Guide.
//
//      * MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a
//      policy from an entity that would cause the entity to have fewer than the
//      minimum number of policies of a certain type required.
//
//      * ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation
//      that requires the organization to be configured to support all features.
//      An organization that supports only consolidated billing features can't
//      perform this operation.
//
//      * OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is
//      too many levels deep.
//
//      * OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs
//      that you can have in an organization.
//
//      * POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that
//      is larger than the maximum size.
//
//      * POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of
//      policies that you can have in an organization.
//
//      * TAG_POLICY_VIOLATION: You attempted to create or update a resource with
//      tags that are not compliant with the tag policy requirements for this
//      account.
//
//   * InvalidInputException
//   The requested operation failed because you provided invalid values for one
//   or more of the request parameters. This exception includes a reason that
//   contains additional information about the violated limit:
//
//   Some of the reasons in the following list might not be applicable to this
//   specific API or operation.
//
//      * DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to
//      the same entity.
//
//      * IMMUTABLE_POLICY: You specified a policy that is managed by AWS and
//      can't be modified.
//
//      * INPUT_REQUIRED: You must include a value for all required parameters.
//
//      * INVALID_ENUM: You specified an invalid value.
//
//      * INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
//
//      * INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid
//      characters.
//
//      * INVALID_LIST_MEMBER: You provided a list to a parameter that contains
//      at least one invalid value.
//
//      * INVALID_PAGINATION_TOKEN: Get the value for the NextToken parameter
//      from the response to a previous call of the operation.
//
//      * INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account,
//      organization, or email) as a party.
//
//      * INVALID_PATTERN: You provided a value that doesn't match the required
//      pattern.
//
//      * INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't
//      match the required pattern.
//
//      * INVALID_ROLE_NAME: You provided a role name that isn't valid. A role
//      name can't begin with the reserved prefix AWSServiceRoleFor.
//
//      * INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource
//      Name (ARN) for the organization.
//
//      * INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
//
//      * INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system
//      tag. You can’t add, edit, or delete system tag keys because they're
//      reserved for AWS use. System tags don’t count against your tags per
//      resource limit.
//
//      * MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter
//      for the operation.
//
//      * MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer
//      than allowed.
//
//      * MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger
//      value than allowed.
//
//      * MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter
//      than allowed.
//
//      * MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller
//      value than allowed.
//
//      * MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only
//      between entities in the same root.
//
//      * TARGET_NOT_SUPPORTED: You can't perform the specified operation on that
//      target entity.
//
//      * UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that
//      isn't recognized.
//
//   * TooManyRequestsException
//   You have sent too many requests in too short a period of time. The quota
//   helps protect against denial-of-service attacks. Try again later.
//
//   For information about quotas that affect AWS Organizations, see Quotas for
//   AWS Organizations (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html)in
//   the AWS Organizations User Guide.
//
//   * ServiceException
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * UnsupportedAPIEndpointException
//   This action isn't available in the current AWS Region.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/RegisterDelegatedAdministrator
func (c *Organizations) RegisterDelegatedAdministrator(input *RegisterDelegatedAdministratorInput) (*RegisterDelegatedAdministratorOutput, error) {
	req, out := c.RegisterDelegatedAdministratorRequest(input)
	return out, req.Send()
}

// RegisterDelegatedAdministratorWithContext is the same as RegisterDelegatedAdministrator with the addition of
// the ability to pass a context and additional request options.
//
// See RegisterDelegatedAdministrator for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) RegisterDelegatedAdministratorWithContext(ctx aws.Context, input *RegisterDelegatedAdministratorInput, opts ...request.Option) (*RegisterDelegatedAdministratorOutput, error) {
	req, out := c.RegisterDelegatedAdministratorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveAccountFromOrganization = "RemoveAccountFromOrganization"

// RemoveAccountFromOrganizationRequest generates a "aws/request.Request" representing the
// client's request for the RemoveAccountFromOrganization operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemoveAccountFromOrganization for more information on using the RemoveAccountFromOrganization
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RemoveAccountFromOrganizationRequest method.
//    req, resp := client.RemoveAccountFromOrganizationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/RemoveAccountFromOrganization
func (c *Organizations) RemoveAccountFromOrganizationRequest(input *RemoveAccountFromOrganizationInput) (req *request.Request, output *RemoveAccountFromOrganizationOutput) {
	op := &request.Operation{
		Name:       opRemoveAccountFromOrganization,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveAccountFromOrganizationInput{}
	}

	output = &RemoveAccountFromOrganizationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RemoveAccountFromOrganization API operation for AWS Organizations.
//
// Removes the specified account from the organization.
//
// The removed account becomes a standalone account that isn't a member of any
// organization. It's no longer subject to any policies and is responsible for
// its own bill payments. The organization's master account is no longer charged
// for any expenses accrued by the member account after it's removed from the
// organization.
//
// This operation can be called only from the organization's master account.
// Member accounts can remove themselves with LeaveOrganization instead.
//
//    * You can remove an account from your organization only if the account
//    is configured with the information required to operate as a standalone
//    account. When you create an account in an organization using the AWS Organizations
//    console, API, or CLI commands, the information required of standalone
//    accounts is not automatically collected. For an account that you want
//    to make standalone, you must choose a support plan, provide and verify
//    the required contact information, and provide a current payment method.
//    AWS uses the payment method to charge for any billable (not free tier)
//    AWS activity that occurs while the account isn't attached to an organization.
//    To remove an account that doesn't yet have this information, you must
//    sign in as the member account and follow the steps at To leave an organization
//    when all required account information has not yet been provided (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info)
//    in the AWS Organizations User Guide.
//
//    * After the account leaves the organization, all tags that were attached
//    to the account object in the organization are deleted. AWS accounts outside
//    of an organization do not support tags.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation RemoveAccountFromOrganization for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * AccountNotFoundException
//   We can't find an AWS account with the AccountId that you specified, or the
//   account whose credentials you used to make this request isn't a member of
//   an organization.
//
//   * AWSOrganizationsNotInUseException
//   Your account isn't a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * ConcurrentModificationException
//   The target of the operation is currently being modified by a different request.
//   Try again later.
//
//   * ConstraintViolationException
//   Performing this operation violates a minimum or maximum value limit. For
//   example, attempting to remove the last service control policy (SCP) from
//   an OU or root, inviting or creating too many accounts to the organization,
//   or attaching too many policies to an account, OU, or root. This exception
//   includes a reason that contains additional information about the violated
//   limit:
//
//   Some of the reasons in the following list might not be applicable to this
//   specific API or operation.
//
//      * ACCOUNT_CANNOT_LEAVE_ORGANIZAION: You attempted to remove the master
//      account from the organization. You can't remove the master account. Instead,
//      after you remove all member accounts, delete the organization itself.
//
//      * ACCOUNT_CANNOT_LEAVE_WITHOUT_EULA: You attempted to remove an account
//      from the organization that doesn't yet have enough information to exist
//      as a standalone account. This account requires you to first agree to the
//      AWS Customer Agreement. Follow the steps at Removing a member account
//      from your organization (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master)in
//      the AWS Organizations User Guide.
//
//      * ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove
//      an account from the organization that doesn't yet have enough information
//      to exist as a standalone account. This account requires you to first complete
//      phone verification. Follow the steps at Removing a member account from
//      your organization (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master)
//      in the AWS Organizations User Guide.
//
//      * ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number
//      of accounts that you can create in one day.
//
//      * ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on
//      the number of accounts in an organization. If you need more accounts,
//      contact AWS Support (https://console.aws.amazon.com/support/home#/) to
//      request an increase in your limit. Or the number of invitations that you
//      tried to send would cause you to exceed the limit of accounts in your
//      organization. Send fewer invitations or contact AWS Support to request
//      an increase in the number of accounts. Deleted and closed accounts still
//      count toward your limit. If you get this exception when running a command
//      immediately after creating the organization, wait one hour and try again.
//      After an hour, if the command continues to fail with this error, contact
//      AWS Support (https://console.aws.amazon.com/support/home#/).
//
//      * CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to
//      register the master account of the organization as a delegated administrator
//      for an AWS service integrated with Organizations. You can designate only
//      a member account as a delegated administrator.
//
//      * CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove
//      an account that is registered as a delegated administrator for a service
//      integrated with your organization. To complete this operation, you must
//      first deregister this account as a delegated administrator.
//
//      * CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an
//      organization in the specified region, you must enable all features mode.
//
//      * DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register
//      an AWS account as a delegated administrator for an AWS service that already
//      has a delegated administrator. To complete this operation, you must first
//      deregister any existing delegated administrators for this service.
//
//      * EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only
//      valid for a limited period of time. You must resubmit the request and
//      generate a new verfication code.
//
//      * HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of
//      handshakes that you can send in one day.
//
//      * MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account
//      in this organization, you first must migrate the organization's master
//      account to the marketplace that corresponds to the master account's address.
//      For example, accounts with India addresses must be associated with the
//      AISPL marketplace. All accounts in an organization must be associated
//      with the same marketplace.
//
//      * MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the AWS Regions
//      in China. To create an organization, the master must have an valid business
//      license. For more information, contact customer support.
//
//      * MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you
//      must first provide a valid contact address and phone number for the master
//      account. Then try the operation again.
//
//      * MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the
//      master account must have an associated account in the AWS GovCloud (US-West)
//      Region. For more information, see AWS Organizations (http://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html)
//      in the AWS GovCloud User Guide.
//
//      * MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization
//      with this master account, you first must associate a valid payment instrument,
//      such as a credit card, with the account. Follow the steps at To leave
//      an organization when all required account information has not yet been
//      provided (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info)
//      in the AWS Organizations User Guide.
//
//      * MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted
//      to register more delegated administrators than allowed for the service
//      principal.
//
//      * MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the
//      number of policies of a certain type that can be attached to an entity
//      at one time.
//
//      * MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed
//      on this resource.
//
//      * MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation
//      with this member account, you first must associate a valid payment instrument,
//      such as a credit card, with the account. Follow the steps at To leave
//      an organization when all required account information has not yet been
//      provided (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info)
//      in the AWS Organizations User Guide.
//
//      * MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a
//      policy from an entity that would cause the entity to have fewer than the
//      minimum number of policies of a certain type required.
//
//      * ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation
//      that requires the organization to be configured to support all features.
//      An organization that supports only consolidated billing features can't
//      perform this operation.
//
//      * OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is
//      too many levels deep.
//
//      * OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs
//      that you can have in an organization.
//
//      * POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that
//      is larger than the maximum size.
//
//      * POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of
//      policies that you can have in an organization.
//
//      * TAG_POLICY_VIOLATION: You attempted to create or update a resource with
//      tags that are not compliant with the tag policy requirements for this
//      account.
//
//   * InvalidInputException
//   The requested operation failed because you provided invalid values for one
//   or more of the request parameters. This exception includes a reason that
//   contains additional information about the violated limit:
//
//   Some of the reasons in the following list might not be applicable to this
//   specific API or operation.
//
//      * DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to
//      the same entity.
//
//      * IMMUTABLE_POLICY: You specified a policy that is managed by AWS and
//      can't be modified.
//
//      * INPUT_REQUIRED: You must include a value for all required parameters.
//
//      * INVALID_ENUM: You specified an invalid value.
//
//      * INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
//
//      * INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid
//      characters.
//
//      * INVALID_LIST_MEMBER: You provided a list to a parameter that contains
//      at least one invalid value.
//
//      * INVALID_PAGINATION_TOKEN: Get the value for the NextToken parameter
//      from the response to a previous call of the operation.
//
//      * INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account,
//      organization, or email) as a party.
//
//      * INVALID_PATTERN: You provided a value that doesn't match the required
//      pattern.
//
//      * INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't
//      match the required pattern.
//
//      * INVALID_ROLE_NAME: You provided a role name that isn't valid. A role
//      name can't begin with the reserved prefix AWSServiceRoleFor.
//
//      * INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource
//      Name (ARN) for the organization.
//
//      * INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
//
//      * INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system
//      tag. You can’t add, edit, or delete system tag keys because they're
//      reserved for AWS use. System tags don’t count against your tags per
//      resource limit.
//
//      * MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter
//      for the operation.
//
//      * MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer
//      than allowed.
//
//      * MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger
//      value than allowed.
//
//      * MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter
//      than allowed.
//
//      * MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller
//      value than allowed.
//
//      * MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only
//      between entities in the same root.
//
//      * TARGET_NOT_SUPPORTED: You can't perform the specified operation on that
//      target entity.
//
//      * UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that
//      isn't recognized.
//
//   * MasterCannotLeaveOrganizationException
//   You can't remove a master account from an organization. If you want the master
//   account to become a member account in another organization, you must first
//   delete the current organization of the master account.
//
//   * ServiceException
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * TooManyRequestsException
//   You have sent too many requests in too short a period of time. The quota
//   helps protect against denial-of-service attacks. Try again later.
//
//   For information about quotas that affect AWS Organizations, see Quotas for
//   AWS Organizations (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html)in
//   the AWS Organizations User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/RemoveAccountFromOrganization
func (c *Organizations) RemoveAccountFromOrganization(input *RemoveAccountFromOrganizationInput) (*RemoveAccountFromOrganizationOutput, error) {
	req, out := c.RemoveAccountFromOrganizationRequest(input)
	return out, req.Send()
}

// RemoveAccountFromOrganizationWithContext is the same as RemoveAccountFromOrganization with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveAccountFromOrganization for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) RemoveAccountFromOrganizationWithContext(ctx aws.Context, input *RemoveAccountFromOrganizationInput, opts ...request.Option) (*RemoveAccountFromOrganizationOutput, error) {
	req, out := c.RemoveAccountFromOrganizationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/TagResource
func (c *Organizations) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS Organizations.
//
// Adds one or more tags to the specified resource.
//
// Currently, you can attach tags to the following resources in AWS Organizations.
//
//    * AWS account
//
//    * Organization root
//
//    * Organizational unit (OU)
//
//    * Policy (any type)
//
// This operation can be called only from the organization's master account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * ConcurrentModificationException
//   The target of the operation is currently being modified by a different request.
//   Try again later.
//
//   * AWSOrganizationsNotInUseException
//   Your account isn't a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * TargetNotFoundException
//   We can't find a root, OU, account, or policy with the TargetId that you specified.
//
//   * ConstraintViolationException
//   Performing this operation violates a minimum or maximum value limit. For
//   example, attempting to remove the last service control policy (SCP) from
//   an OU or root, inviting or creating too many accounts to the organization,
//   or attaching too many policies to an account, OU, or root. This exception
//   includes a reason that contains additional information about the violated
//   limit:
//
//   Some of the reasons in the following list might not be applicable to this
//   specific API or operation.
//
//      * ACCOUNT_CANNOT_LEAVE_ORGANIZAION: You attempted to remove the master
//      account from the organization. You can't remove the master account. Instead,
//      after you remove all member accounts, delete the organization itself.
//
//      * ACCOUNT_CANNOT_LEAVE_WITHOUT_EULA: You attempted to remove an account
//      from the organization that doesn't yet have enough information to exist
//      as a standalone account. This account requires you to first agree to the
//      AWS Customer Agreement. Follow the steps at Removing a member account
//      from your organization (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master)in
//      the AWS Organizations User Guide.
//
//      * ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove
//      an account from the organization that doesn't yet have enough information
//      to exist as a standalone account. This account requires you to first complete
//      phone verification. Follow the steps at Removing a member account from
//      your organization (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master)
//      in the AWS Organizations User Guide.
//
//      * ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number
//      of accounts that you can create in one day.
//
//      * ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on
//      the number of accounts in an organization. If you need more accounts,
//      contact AWS Support (https://console.aws.amazon.com/support/home#/) to
//      request an increase in your limit. Or the number of invitations that you
//      tried to send would cause you to exceed the limit of accounts in your
//      organization. Send fewer invitations or contact AWS Support to request
//      an increase in the number of accounts. Deleted and closed accounts still
//      count toward your limit. If you get this exception when running a command
//      immediately after creating the organization, wait one hour and try again.
//      After an hour, if the command continues to fail with this error, contact
//      AWS Support (https://console.aws.amazon.com/support/home#/).
//
//      * CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to
//      register the master account of the organization as a delegated administrator
//      for an AWS service integrated with Organizations. You can designate only
//      a member account as a delegated administrator.
//
//      * CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove
//      an account that is registered as a delegated administrator for a service
//      integrated with your organization. To complete this operation, you must
//      first deregister this account as a delegated administrator.
//
//      * CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an
//      organization in the specified region, you must enable all features mode.
//
//      * DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register
//      an AWS account as a delegated administrator for an AWS service that already
//      has a delegated administrator. To complete this operation, you must first
//      deregister any existing delegated administrators for this service.
//
//      * EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only
//      valid for a limited period of time. You must resubmit the request and
//      generate a new verfication code.
//
//      * HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of
//      handshakes that you can send in one day.
//
//      * MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account
//      in this organization, you first must migrate the organization's master
//      account to the marketplace that corresponds to the master account's address.
//      For example, accounts with India addresses must be associated with the
//      AISPL marketplace. All accounts in an organization must be associated
//      with the same marketplace.
//
//      * MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the AWS Regions
//      in China. To create an organization, the master must have an valid business
//      license. For more information, contact customer support.
//
//      * MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you
//      must first provide a valid contact address and phone number for the master
//      account. Then try the operation again.
//
//      * MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the
//      master account must have an associated account in the AWS GovCloud (US-West)
//      Region. For more information, see AWS Organizations (http://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html)
//      in the AWS GovCloud User Guide.
//
//      * MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization
//      with this master account, you first must associate a valid payment instrument,
//      such as a credit card, with the account. Follow the steps at To leave
//      an organization when all required account information has not yet been
//      provided (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info)
//      in the AWS Organizations User Guide.
//
//      * MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted
//      to register more delegated administrators than allowed for the service
//      principal.
//
//      * MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the
//      number of policies of a certain type that can be attached to an entity
//      at one time.
//
//      * MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed
//      on this resource.
//
//      * MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation
//      with this member account, you first must associate a valid payment instrument,
//      such as a credit card, with the account. Follow the steps at To leave
//      an organization when all required account information has not yet been
//      provided (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info)
//      in the AWS Organizations User Guide.
//
//      * MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a
//      policy from an entity that would cause the entity to have fewer than the
//      minimum number of policies of a certain type required.
//
//      * ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation
//      that requires the organization to be configured to support all features.
//      An organization that supports only consolidated billing features can't
//      perform this operation.
//
//      * OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is
//      too many levels deep.
//
//      * OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs
//      that you can have in an organization.
//
//      * POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that
//      is larger than the maximum size.
//
//      * POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of
//      policies that you can have in an organization.
//
//      * TAG_POLICY_VIOLATION: You attempted to create or update a resource with
//      tags that are not compliant with the tag policy requirements for this
//      account.
//
//   * InvalidInputException
//   The requested operation failed because you provided invalid values for one
//   or more of the request parameters. This exception includes a reason that
//   contains additional information about the violated limit:
//
//   Some of the reasons in the following list might not be applicable to this
//   specific API or operation.
//
//      * DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to
//      the same entity.
//
//      * IMMUTABLE_POLICY: You specified a policy that is managed by AWS and
//      can't be modified.
//
//      * INPUT_REQUIRED: You must include a value for all required parameters.
//
//      * INVALID_ENUM: You specified an invalid value.
//
//      * INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
//
//      * INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid
//      characters.
//
//      * INVALID_LIST_MEMBER: You provided a list to a parameter that contains
//      at least one invalid value.
//
//      * INVALID_PAGINATION_TOKEN: Get the value for the NextToken parameter
//      from the response to a previous call of the operation.
//
//      * INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account,
//      organization, or email) as a party.
//
//      * INVALID_PATTERN: You provided a value that doesn't match the required
//      pattern.
//
//      * INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't
//      match the required pattern.
//
//      * INVALID_ROLE_NAME: You provided a role name that isn't valid. A role
//      name can't begin with the reserved prefix AWSServiceRoleFor.
//
//      * INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource
//      Name (ARN) for the organization.
//
//      * INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
//
//      * INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system
//      tag. You can’t add, edit, or delete system tag keys because they're
//      reserved for AWS use. System tags don’t count against your tags per
//      resource limit.
//
//      * MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter
//      for the operation.
//
//      * MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer
//      than allowed.
//
//      * MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger
//      value than allowed.
//
//      * MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter
//      than allowed.
//
//      * MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller
//      value than allowed.
//
//      * MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only
//      between entities in the same root.
//
//      * TARGET_NOT_SUPPORTED: You can't perform the specified operation on that
//      target entity.
//
//      * UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that
//      isn't recognized.
//
//   * ServiceException
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * TooManyRequestsException
//   You have sent too many requests in too short a period of time. The quota
//   helps protect against denial-of-service attacks. Try again later.
//
//   For information about quotas that affect AWS Organizations, see Quotas for
//   AWS Organizations (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html)in
//   the AWS Organizations User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/TagResource
func (c *Organizations) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/UntagResource
func (c *Organizations) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS Organizations.
//
// Removes any tags with the specified keys from the specified resource.
//
// You can attach tags to the following resources in AWS Organizations.
//
//    * AWS account
//
//    * Organization root
//
//    * Organizational unit (OU)
//
//    * Policy (any type)
//
// This operation can be called only from the organization's master account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * ConcurrentModificationException
//   The target of the operation is currently being modified by a different request.
//   Try again later.
//
//   * AWSOrganizationsNotInUseException
//   Your account isn't a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * TargetNotFoundException
//   We can't find a root, OU, account, or policy with the TargetId that you specified.
//
//   * ConstraintViolationException
//   Performing this operation violates a minimum or maximum value limit. For
//   example, attempting to remove the last service control policy (SCP) from
//   an OU or root, inviting or creating too many accounts to the organization,
//   or attaching too many policies to an account, OU, or root. This exception
//   includes a reason that contains additional information about the violated
//   limit:
//
//   Some of the reasons in the following list might not be applicable to this
//   specific API or operation.
//
//      * ACCOUNT_CANNOT_LEAVE_ORGANIZAION: You attempted to remove the master
//      account from the organization. You can't remove the master account. Instead,
//      after you remove all member accounts, delete the organization itself.
//
//      * ACCOUNT_CANNOT_LEAVE_WITHOUT_EULA: You attempted to remove an account
//      from the organization that doesn't yet have enough information to exist
//      as a standalone account. This account requires you to first agree to the
//      AWS Customer Agreement. Follow the steps at Removing a member account
//      from your organization (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master)in
//      the AWS Organizations User Guide.
//
//      * ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove
//      an account from the organization that doesn't yet have enough information
//      to exist as a standalone account. This account requires you to first complete
//      phone verification. Follow the steps at Removing a member account from
//      your organization (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master)
//      in the AWS Organizations User Guide.
//
//      * ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number
//      of accounts that you can create in one day.
//
//      * ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on
//      the number of accounts in an organization. If you need more accounts,
//      contact AWS Support (https://console.aws.amazon.com/support/home#/) to
//      request an increase in your limit. Or the number of invitations that you
//      tried to send would cause you to exceed the limit of accounts in your
//      organization. Send fewer invitations or contact AWS Support to request
//      an increase in the number of accounts. Deleted and closed accounts still
//      count toward your limit. If you get this exception when running a command
//      immediately after creating the organization, wait one hour and try again.
//      After an hour, if the command continues to fail with this error, contact
//      AWS Support (https://console.aws.amazon.com/support/home#/).
//
//      * CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to
//      register the master account of the organization as a delegated administrator
//      for an AWS service integrated with Organizations. You can designate only
//      a member account as a delegated administrator.
//
//      * CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove
//      an account that is registered as a delegated administrator for a service
//      integrated with your organization. To complete this operation, you must
//      first deregister this account as a delegated administrator.
//
//      * CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an
//      organization in the specified region, you must enable all features mode.
//
//      * DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register
//      an AWS account as a delegated administrator for an AWS service that already
//      has a delegated administrator. To complete this operation, you must first
//      deregister any existing delegated administrators for this service.
//
//      * EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only
//      valid for a limited period of time. You must resubmit the request and
//      generate a new verfication code.
//
//      * HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of
//      handshakes that you can send in one day.
//
//      * MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account
//      in this organization, you first must migrate the organization's master
//      account to the marketplace that corresponds to the master account's address.
//      For example, accounts with India addresses must be associated with the
//      AISPL marketplace. All accounts in an organization must be associated
//      with the same marketplace.
//
//      * MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the AWS Regions
//      in China. To create an organization, the master must have an valid business
//      license. For more information, contact customer support.
//
//      * MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you
//      must first provide a valid contact address and phone number for the master
//      account. Then try the operation again.
//
//      * MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the
//      master account must have an associated account in the AWS GovCloud (US-West)
//      Region. For more information, see AWS Organizations (http://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html)
//      in the AWS GovCloud User Guide.
//
//      * MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization
//      with this master account, you first must associate a valid payment instrument,
//      such as a credit card, with the account. Follow the steps at To leave
//      an organization when all required account information has not yet been
//      provided (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info)
//      in the AWS Organizations User Guide.
//
//      * MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted
//      to register more delegated administrators than allowed for the service
//      principal.
//
//      * MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the
//      number of policies of a certain type that can be attached to an entity
//      at one time.
//
//      * MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed
//      on this resource.
//
//      * MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation
//      with this member account, you first must associate a valid payment instrument,
//      such as a credit card, with the account. Follow the steps at To leave
//      an organization when all required account information has not yet been
//      provided (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info)
//      in the AWS Organizations User Guide.
//
//      * MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a
//      policy from an entity that would cause the entity to have fewer than the
//      minimum number of policies of a certain type required.
//
//      * ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation
//      that requires the organization to be configured to support all features.
//      An organization that supports only consolidated billing features can't
//      perform this operation.
//
//      * OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is
//      too many levels deep.
//
//      * OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs
//      that you can have in an organization.
//
//      * POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that
//      is larger than the maximum size.
//
//      * POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of
//      policies that you can have in an organization.
//
//      * TAG_POLICY_VIOLATION: You attempted to create or update a resource with
//      tags that are not compliant with the tag policy requirements for this
//      account.
//
//   * InvalidInputException
//   The requested operation failed because you provided invalid values for one
//   or more of the request parameters. This exception includes a reason that
//   contains additional information about the violated limit:
//
//   Some of the reasons in the following list might not be applicable to this
//   specific API or operation.
//
//      * DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to
//      the same entity.
//
//      * IMMUTABLE_POLICY: You specified a policy that is managed by AWS and
//      can't be modified.
//
//      * INPUT_REQUIRED: You must include a value for all required parameters.
//
//      * INVALID_ENUM: You specified an invalid value.
//
//      * INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
//
//      * INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid
//      characters.
//
//      * INVALID_LIST_MEMBER: You provided a list to a parameter that contains
//      at least one invalid value.
//
//      * INVALID_PAGINATION_TOKEN: Get the value for the NextToken parameter
//      from the response to a previous call of the operation.
//
//      * INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account,
//      organization, or email) as a party.
//
//      * INVALID_PATTERN: You provided a value that doesn't match the required
//      pattern.
//
//      * INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't
//      match the required pattern.
//
//      * INVALID_ROLE_NAME: You provided a role name that isn't valid. A role
//      name can't begin with the reserved prefix AWSServiceRoleFor.
//
//      * INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource
//      Name (ARN) for the organization.
//
//      * INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
//
//      * INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system
//      tag. You can’t add, edit, or delete system tag keys because they're
//      reserved for AWS use. System tags don’t count against your tags per
//      resource limit.
//
//      * MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter
//      for the operation.
//
//      * MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer
//      than allowed.
//
//      * MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger
//      value than allowed.
//
//      * MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter
//      than allowed.
//
//      * MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller
//      value than allowed.
//
//      * MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only
//      between entities in the same root.
//
//      * TARGET_NOT_SUPPORTED: You can't perform the specified operation on that
//      target entity.
//
//      * UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that
//      isn't recognized.
//
//   * ServiceException
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * TooManyRequestsException
//   You have sent too many requests in too short a period of time. The quota
//   helps protect against denial-of-service attacks. Try again later.
//
//   For information about quotas that affect AWS Organizations, see Quotas for
//   AWS Organizations (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html)in
//   the AWS Organizations User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/UntagResource
func (c *Organizations) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateOrganizationalUnit = "UpdateOrganizationalUnit"

// UpdateOrganizationalUnitRequest generates a "aws/request.Request" representing the
// client's request for the UpdateOrganizationalUnit operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateOrganizationalUnit for more information on using the UpdateOrganizationalUnit
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateOrganizationalUnitRequest method.
//    req, resp := client.UpdateOrganizationalUnitRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/UpdateOrganizationalUnit
func (c *Organizations) UpdateOrganizationalUnitRequest(input *UpdateOrganizationalUnitInput) (req *request.Request, output *UpdateOrganizationalUnitOutput) {
	op := &request.Operation{
		Name:       opUpdateOrganizationalUnit,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateOrganizationalUnitInput{}
	}

	output = &UpdateOrganizationalUnitOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateOrganizationalUnit API operation for AWS Organizations.
//
// Renames the specified organizational unit (OU). The ID and ARN don't change.
// The child OUs and accounts remain in place, and any attached policies of
// the OU remain attached.
//
// This operation can be called only from the organization's master account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation UpdateOrganizationalUnit for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * AWSOrganizationsNotInUseException
//   Your account isn't a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * ConcurrentModificationException
//   The target of the operation is currently being modified by a different request.
//   Try again later.
//
//   * DuplicateOrganizationalUnitException
//   An OU with the same name already exists.
//
//   * InvalidInputException
//   The requested operation failed because you provided invalid values for one
//   or more of the request parameters. This exception includes a reason that
//   contains additional information about the violated limit:
//
//   Some of the reasons in the following list might not be applicable to this
//   specific API or operation.
//
//      * DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to
//      the same entity.
//
//      * IMMUTABLE_POLICY: You specified a policy that is managed by AWS and
//      can't be modified.
//
//      * INPUT_REQUIRED: You must include a value for all required parameters.
//
//      * INVALID_ENUM: You specified an invalid value.
//
//      * INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
//
//      * INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid
//      characters.
//
//      * INVALID_LIST_MEMBER: You provided a list to a parameter that contains
//      at least one invalid value.
//
//      * INVALID_PAGINATION_TOKEN: Get the value for the NextToken parameter
//      from the response to a previous call of the operation.
//
//      * INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account,
//      organization, or email) as a party.
//
//      * INVALID_PATTERN: You provided a value that doesn't match the required
//      pattern.
//
//      * INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't
//      match the required pattern.
//
//      * INVALID_ROLE_NAME: You provided a role name that isn't valid. A role
//      name can't begin with the reserved prefix AWSServiceRoleFor.
//
//      * INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource
//      Name (ARN) for the organization.
//
//      * INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
//
//      * INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system
//      tag. You can’t add, edit, or delete system tag keys because they're
//      reserved for AWS use. System tags don’t count against your tags per
//      resource limit.
//
//      * MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter
//      for the operation.
//
//      * MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer
//      than allowed.
//
//      * MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger
//      value than allowed.
//
//      * MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter
//      than allowed.
//
//      * MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller
//      value than allowed.
//
//      * MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only
//      between entities in the same root.
//
//      * TARGET_NOT_SUPPORTED: You can't perform the specified operation on that
//      target entity.
//
//      * UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that
//      isn't recognized.
//
//   * OrganizationalUnitNotFoundException
//   We can't find an OU with the OrganizationalUnitId that you specified.
//
//   * ServiceException
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * TooManyRequestsException
//   You have sent too many requests in too short a period of time. The quota
//   helps protect against denial-of-service attacks. Try again later.
//
//   For information about quotas that affect AWS Organizations, see Quotas for
//   AWS Organizations (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html)in
//   the AWS Organizations User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/UpdateOrganizationalUnit
func (c *Organizations) UpdateOrganizationalUnit(input *UpdateOrganizationalUnitInput) (*UpdateOrganizationalUnitOutput, error) {
	req, out := c.UpdateOrganizationalUnitRequest(input)
	return out, req.Send()
}

// UpdateOrganizationalUnitWithContext is the same as UpdateOrganizationalUnit with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateOrganizationalUnit for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) UpdateOrganizationalUnitWithContext(ctx aws.Context, input *UpdateOrganizationalUnitInput, opts ...request.Option) (*UpdateOrganizationalUnitOutput, error) {
	req, out := c.UpdateOrganizationalUnitRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdatePolicy = "UpdatePolicy"

// UpdatePolicyRequest generates a "aws/request.Request" representing the
// client's request for the UpdatePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdatePolicy for more information on using the UpdatePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdatePolicyRequest method.
//    req, resp := client.UpdatePolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/UpdatePolicy
func (c *Organizations) UpdatePolicyRequest(input *UpdatePolicyInput) (req *request.Request, output *UpdatePolicyOutput) {
	op := &request.Operation{
		Name:       opUpdatePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdatePolicyInput{}
	}

	output = &UpdatePolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdatePolicy API operation for AWS Organizations.
//
// Updates an existing policy with a new name, description, or content. If you
// don't supply any parameter, that value remains unchanged. You can't change
// a policy's type.
//
// This operation can be called only from the organization's master account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation UpdatePolicy for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * AWSOrganizationsNotInUseException
//   Your account isn't a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * ConcurrentModificationException
//   The target of the operation is currently being modified by a different request.
//   Try again later.
//
//   * ConstraintViolationException
//   Performing this operation violates a minimum or maximum value limit. For
//   example, attempting to remove the last service control policy (SCP) from
//   an OU or root, inviting or creating too many accounts to the organization,
//   or attaching too many policies to an account, OU, or root. This exception
//   includes a reason that contains additional information about the violated
//   limit:
//
//   Some of the reasons in the following list might not be applicable to this
//   specific API or operation.
//
//      * ACCOUNT_CANNOT_LEAVE_ORGANIZAION: You attempted to remove the master
//      account from the organization. You can't remove the master account. Instead,
//      after you remove all member accounts, delete the organization itself.
//
//      * ACCOUNT_CANNOT_LEAVE_WITHOUT_EULA: You attempted to remove an account
//      from the organization that doesn't yet have enough information to exist
//      as a standalone account. This account requires you to first agree to the
//      AWS Customer Agreement. Follow the steps at Removing a member account
//      from your organization (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master)in
//      the AWS Organizations User Guide.
//
//      * ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove
//      an account from the organization that doesn't yet have enough information
//      to exist as a standalone account. This account requires you to first complete
//      phone verification. Follow the steps at Removing a member account from
//      your organization (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master)
//      in the AWS Organizations User Guide.
//
//      * ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number
//      of accounts that you can create in one day.
//
//      * ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on
//      the number of accounts in an organization. If you need more accounts,
//      contact AWS Support (https://console.aws.amazon.com/support/home#/) to
//      request an increase in your limit. Or the number of invitations that you
//      tried to send would cause you to exceed the limit of accounts in your
//      organization. Send fewer invitations or contact AWS Support to request
//      an increase in the number of accounts. Deleted and closed accounts still
//      count toward your limit. If you get this exception when running a command
//      immediately after creating the organization, wait one hour and try again.
//      After an hour, if the command continues to fail with this error, contact
//      AWS Support (https://console.aws.amazon.com/support/home#/).
//
//      * CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to
//      register the master account of the organization as a delegated administrator
//      for an AWS service integrated with Organizations. You can designate only
//      a member account as a delegated administrator.
//
//      * CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove
//      an account that is registered as a delegated administrator for a service
//      integrated with your organization. To complete this operation, you must
//      first deregister this account as a delegated administrator.
//
//      * CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an
//      organization in the specified region, you must enable all features mode.
//
//      * DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register
//      an AWS account as a delegated administrator for an AWS service that already
//      has a delegated administrator. To complete this operation, you must first
//      deregister any existing delegated administrators for this service.
//
//      * EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only
//      valid for a limited period of time. You must resubmit the request and
//      generate a new verfication code.
//
//      * HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of
//      handshakes that you can send in one day.
//
//      * MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account
//      in this organization, you first must migrate the organization's master
//      account to the marketplace that corresponds to the master account's address.
//      For example, accounts with India addresses must be associated with the
//      AISPL marketplace. All accounts in an organization must be associated
//      with the same marketplace.
//
//      * MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the AWS Regions
//      in China. To create an organization, the master must have an valid business
//      license. For more information, contact customer support.
//
//      * MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you
//      must first provide a valid contact address and phone number for the master
//      account. Then try the operation again.
//
//      * MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the
//      master account must have an associated account in the AWS GovCloud (US-West)
//      Region. For more information, see AWS Organizations (http://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html)
//      in the AWS GovCloud User Guide.
//
//      * MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization
//      with this master account, you first must associate a valid payment instrument,
//      such as a credit card, with the account. Follow the steps at To leave
//      an organization when all required account information has not yet been
//      provided (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info)
//      in the AWS Organizations User Guide.
//
//      * MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted
//      to register more delegated administrators than allowed for the service
//      principal.
//
//      * MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the
//      number of policies of a certain type that can be attached to an entity
//      at one time.
//
//      * MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed
//      on this resource.
//
//      * MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation
//      with this member account, you first must associate a valid payment instrument,
//      such as a credit card, with the account. Follow the steps at To leave
//      an organization when all required account information has not yet been
//      provided (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info)
//      in the AWS Organizations User Guide.
//
//      * MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a
//      policy from an entity that would cause the entity to have fewer than the
//      minimum number of policies of a certain type required.
//
//      * ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation
//      that requires the organization to be configured to support all features.
//      An organization that supports only consolidated billing features can't
//      perform this operation.
//
//      * OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is
//      too many levels deep.
//
//      * OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs
//      that you can have in an organization.
//
//      * POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that
//      is larger than the maximum size.
//
//      * POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of
//      policies that you can have in an organization.
//
//      * TAG_POLICY_VIOLATION: You attempted to create or update a resource with
//      tags that are not compliant with the tag policy requirements for this
//      account.
//
//   * DuplicatePolicyException
//   A policy with the same name already exists.
//
//   * InvalidInputException
//   The requested operation failed because you provided invalid values for one
//   or more of the request parameters. This exception includes a reason that
//   contains additional information about the violated limit:
//
//   Some of the reasons in the following list might not be applicable to this
//   specific API or operation.
//
//      * DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to
//      the same entity.
//
//      * IMMUTABLE_POLICY: You specified a policy that is managed by AWS and
//      can't be modified.
//
//      * INPUT_REQUIRED: You must include a value for all required parameters.
//
//      * INVALID_ENUM: You specified an invalid value.
//
//      * INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
//
//      * INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid
//      characters.
//
//      * INVALID_LIST_MEMBER: You provided a list to a parameter that contains
//      at least one invalid value.
//
//      * INVALID_PAGINATION_TOKEN: Get the value for the NextToken parameter
//      from the response to a previous call of the operation.
//
//      * INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account,
//      organization, or email) as a party.
//
//      * INVALID_PATTERN: You provided a value that doesn't match the required
//      pattern.
//
//      * INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't
//      match the required pattern.
//
//      * INVALID_ROLE_NAME: You provided a role name that isn't valid. A role
//      name can't begin with the reserved prefix AWSServiceRoleFor.
//
//      * INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource
//      Name (ARN) for the organization.
//
//      * INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
//
//      * INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system
//      tag. You can’t add, edit, or delete system tag keys because they're
//      reserved for AWS use. System tags don’t count against your tags per
//      resource limit.
//
//      * MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter
//      for the operation.
//
//      * MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer
//      than allowed.
//
//      * MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger
//      value than allowed.
//
//      * MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter
//      than allowed.
//
//      * MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller
//      value than allowed.
//
//      * MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only
//      between entities in the same root.
//
//      * TARGET_NOT_SUPPORTED: You can't perform the specified operation on that
//      target entity.
//
//      * UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that
//      isn't recognized.
//
//   * MalformedPolicyDocumentException
//   The provided policy document doesn't meet the requirements of the specified
//   policy type. For example, the syntax might be incorrect. For details about
//   service control policy syntax, see Service Control Policy Syntax (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_scp-syntax.html)
//   in the AWS Organizations User Guide.
//
//   * PolicyNotFoundException
//   We can't find a policy with the PolicyId that you specified.
//
//   * ServiceException
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * TooManyRequestsException
//   You have sent too many requests in too short a period of time. The quota
//   helps protect against denial-of-service attacks. Try again later.
//
//   For information about quotas that affect AWS Organizations, see Quotas for
//   AWS Organizations (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html)in
//   the AWS Organizations User Guide.
//
//   * UnsupportedAPIEndpointException
//   This action isn't available in the current AWS Region.
//
//   * PolicyChangesInProgressException
//   Changes to the effective policy are in progress, and its contents can't be
//   returned. Try the operation again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/UpdatePolicy
func (c *Organizations) UpdatePolicy(input *UpdatePolicyInput) (*UpdatePolicyOutput, error) {
	req, out := c.UpdatePolicyRequest(input)
	return out, req.Send()
}

// UpdatePolicyWithContext is the same as UpdatePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See UpdatePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) UpdatePolicyWithContext(ctx aws.Context, input *UpdatePolicyInput, opts ...request.Option) (*UpdatePolicyOutput, error) {
	req, out := c.UpdatePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Your account isn't a member of an organization. To make this request, you
// must use the credentials of an account that belongs to an organization.
type AWSOrganizationsNotInUseException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s AWSOrganizationsNotInUseException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AWSOrganizationsNotInUseException) GoString() string {
	return s.String()
}

func newErrorAWSOrganizationsNotInUseException(v protocol.ResponseMetadata) error {
	return &AWSOrganizationsNotInUseException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AWSOrganizationsNotInUseException) Code() string {
	return "AWSOrganizationsNotInUseException"
}

// Message returns the exception's message.
func (s *AWSOrganizationsNotInUseException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AWSOrganizationsNotInUseException) OrigErr() error {
	return nil
}

func (s *AWSOrganizationsNotInUseException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AWSOrganizationsNotInUseException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AWSOrganizationsNotInUseException) RequestID() string {
	return s.RespMetadata.RequestID
}

type AcceptHandshakeInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier (ID) of the handshake that you want to accept.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for handshake ID string
	// requires "h-" followed by from 8 to 32 lowercase letters or digits.
	//
	// HandshakeId is a required field
	HandshakeId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AcceptHandshakeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AcceptHandshakeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AcceptHandshakeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AcceptHandshakeInput"}
	if s.HandshakeId == nil {
		invalidParams.Add(request.NewErrParamRequired("HandshakeId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHandshakeId sets the HandshakeId field's value.
func (s *AcceptHandshakeInput) SetHandshakeId(v string) *AcceptHandshakeInput {
	s.HandshakeId = &v
	return s
}

type AcceptHandshakeOutput struct {
	_ struct{} `type:"structure"`

	// A structure that contains details about the accepted handshake.
	Handshake *Handshake `type:"structure"`
}

// String returns the string representation
func (s AcceptHandshakeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AcceptHandshakeOutput) GoString() string {
	return s.String()
}

// SetHandshake sets the Handshake field's value.
func (s *AcceptHandshakeOutput) SetHandshake(v *Handshake) *AcceptHandshakeOutput {
	s.Handshake = v
	return s
}

// You don't have permissions to perform the requested operation. The user or
// role that is making the request must have at least one IAM permissions policy
// attached that grants the required permissions. For more information, see
// Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
// in the IAM User Guide.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The operation that you attempted requires you to have the iam:CreateServiceLinkedRole
// for organizations.amazonaws.com permission so that AWS Organizations can
// create the required service-linked role. You don't have that permission.
type AccessDeniedForDependencyException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	Reason *string `type:"string" enum:"AccessDeniedForDependencyExceptionReason"`
}

// String returns the string representation
func (s AccessDeniedForDependencyException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessDeniedForDependencyException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedForDependencyException(v protocol.ResponseMetadata) error {
	return &AccessDeniedForDependencyException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedForDependencyException) Code() string {
	return "AccessDeniedForDependencyException"
}

// Message returns the exception's message.
func (s *AccessDeniedForDependencyException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedForDependencyException) OrigErr() error {
	return nil
}

func (s *AccessDeniedForDependencyException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedForDependencyException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedForDependencyException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains information about an AWS account that is a member of an organization.
type Account struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the account.
	//
	// For more information about ARNs in Organizations, see ARN Formats Supported
	// by Organizations (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_permissions.html#orgs-permissions-arns)
	// in the AWS Organizations User Guide.
	Arn *string `type:"string"`

	// The email address associated with the AWS account.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for this parameter is
	// a string of characters that represents a standard internet email address.
	Email *string `min:"6" type:"string" sensitive:"true"`

	// The unique identifier (ID) of the account.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for an account ID string
	// requires exactly 12 digits.
	Id *string `type:"string"`

	// The method by which the account joined the organization.
	JoinedMethod *string `type:"string" enum:"AccountJoinedMethod"`

	// The date the account became a part of the organization.
	JoinedTimestamp *time.Time `type:"timestamp"`

	// The friendly name of the account.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) that is used to validate
	// this parameter is a string of any of the characters in the ASCII character
	// range.
	Name *string `min:"1" type:"string" sensitive:"true"`

	// The status of the account in the organization.
	Status *string `type:"string" enum:"AccountStatus"`
}

// String returns the string representation
func (s Account) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Account) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Account) SetArn(v string) *Account {
	s.Arn = &v
	return s
}

// SetEmail sets the Email field's value.
func (s *Account) SetEmail(v string) *Account {
	s.Email = &v
	return s
}

// SetId sets the Id field's value.
func (s *Account) SetId(v string) *Account {
	s.Id = &v
	return s
}

// SetJoinedMethod sets the JoinedMethod field's value.
func (s *Account) SetJoinedMethod(v string) *Account {
	s.JoinedMethod = &v
	return s
}

// SetJoinedTimestamp sets the JoinedTimestamp field's value.
func (s *Account) SetJoinedTimestamp(v time.Time) *Account {
	s.JoinedTimestamp = &v
	return s
}

// SetName sets the Name field's value.
func (s *Account) SetName(v string) *Account {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Account) SetStatus(v string) *Account {
	s.Status = &v
	return s
}

// The specified account is already a delegated administrator for this AWS service.
type AccountAlreadyRegisteredException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s AccountAlreadyRegisteredException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccountAlreadyRegisteredException) GoString() string {
	return s.String()
}

func newErrorAccountAlreadyRegisteredException(v protocol.ResponseMetadata) error {
	return &AccountAlreadyRegisteredException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccountAlreadyRegisteredException) Code() string {
	return "AccountAlreadyRegisteredException"
}

// Message returns the exception's message.
func (s *AccountAlreadyRegisteredException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccountAlreadyRegisteredException) OrigErr() error {
	return nil
}

func (s *AccountAlreadyRegisteredException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccountAlreadyRegisteredException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccountAlreadyRegisteredException) RequestID() string {
	return s.RespMetadata.RequestID
}

// We can't find an AWS account with the AccountId that you specified, or the
// account whose credentials you used to make this request isn't a member of
// an organization.
type AccountNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s AccountNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccountNotFoundException) GoString() string {
	return s.String()
}

func newErrorAccountNotFoundException(v protocol.ResponseMetadata) error {
	return &AccountNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccountNotFoundException) Code() string {
	return "AccountNotFoundException"
}

// Message returns the exception's message.
func (s *AccountNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccountNotFoundException) OrigErr() error {
	return nil
}

func (s *AccountNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccountNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccountNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified account is not a delegated administrator for this AWS service.
type AccountNotRegisteredException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s AccountNotRegisteredException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccountNotRegisteredException) GoString() string {
	return s.String()
}

func newErrorAccountNotRegisteredException(v protocol.ResponseMetadata) error {
	return &AccountNotRegisteredException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccountNotRegisteredException) Code() string {
	return "AccountNotRegisteredException"
}

// Message returns the exception's message.
func (s *AccountNotRegisteredException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccountNotRegisteredException) OrigErr() error {
	return nil
}

func (s *AccountNotRegisteredException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccountNotRegisteredException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccountNotRegisteredException) RequestID() string {
	return s.RespMetadata.RequestID
}

// You can't invite an existing account to your organization until you verify
// that you own the email address associated with the master account. For more
// information, see Email Address Verification (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_create.html#about-email-verification)
// in the AWS Organizations User Guide.
type AccountOwnerNotVerifiedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s AccountOwnerNotVerifiedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccountOwnerNotVerifiedException) GoString() string {
	return s.String()
}

func newErrorAccountOwnerNotVerifiedException(v protocol.ResponseMetadata) error {
	return &AccountOwnerNotVerifiedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccountOwnerNotVerifiedException) Code() string {
	return "AccountOwnerNotVerifiedException"
}

// Message returns the exception's message.
func (s *AccountOwnerNotVerifiedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccountOwnerNotVerifiedException) OrigErr() error {
	return nil
}

func (s *AccountOwnerNotVerifiedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccountOwnerNotVerifiedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccountOwnerNotVerifiedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// This account is already a member of an organization. An account can belong
// to only one organization at a time.
type AlreadyInOrganizationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s AlreadyInOrganizationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AlreadyInOrganizationException) GoString() string {
	return s.String()
}

func newErrorAlreadyInOrganizationException(v protocol.ResponseMetadata) error {
	return &AlreadyInOrganizationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AlreadyInOrganizationException) Code() string {
	return "AlreadyInOrganizationException"
}

// Message returns the exception's message.
func (s *AlreadyInOrganizationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AlreadyInOrganizationException) OrigErr() error {
	return nil
}

func (s *AlreadyInOrganizationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AlreadyInOrganizationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AlreadyInOrganizationException) RequestID() string {
	return s.RespMetadata.RequestID
}

type AttachPolicyInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier (ID) of the policy that you want to attach to the target.
	// You can get the ID for the policy by calling the ListPolicies operation.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for a policy ID string
	// requires "p-" followed by from 8 to 128 lowercase or uppercase letters, digits,
	// or the underscore character (_).
	//
	// PolicyId is a required field
	PolicyId *string `type:"string" required:"true"`

	// The unique identifier (ID) of the root, OU, or account that you want to attach
	// the policy to. You can get the ID by calling the ListRoots, ListOrganizationalUnitsForParent,
	// or ListAccounts operations.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for a target ID string
	// requires one of the following:
	//
	//    * Root - A string that begins with "r-" followed by from 4 to 32 lowercase
	//    letters or digits.
	//
	//    * Account - A string that consists of exactly 12 digits.
	//
	//    * Organizational unit (OU) - A string that begins with "ou-" followed
	//    by from 4 to 32 lowercase letters or digits (the ID of the root that the
	//    OU is in). This string is followed by a second "-" dash and from 8 to
	//    32 additional lowercase letters or digits.
	//
	// TargetId is a required field
	TargetId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AttachPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttachPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AttachPolicyInput"}
	if s.PolicyId == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyId"))
	}
	if s.TargetId == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyId sets the PolicyId field's value.
func (s *AttachPolicyInput) SetPolicyId(v string) *AttachPolicyInput {
	s.PolicyId = &v
	return s
}

// SetTargetId sets the TargetId field's value.
func (s *AttachPolicyInput) SetTargetId(v string) *AttachPolicyInput {
	s.TargetId = &v
	return s
}

type AttachPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AttachPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachPolicyOutput) GoString() string {
	return s.String()
}

type CancelHandshakeInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier (ID) of the handshake that you want to cancel. You
	// can get the ID from the ListHandshakesForOrganization operation.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for handshake ID string
	// requires "h-" followed by from 8 to 32 lowercase letters or digits.
	//
	// HandshakeId is a required field
	HandshakeId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CancelHandshakeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelHandshakeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelHandshakeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelHandshakeInput"}
	if s.HandshakeId == nil {
		invalidParams.Add(request.NewErrParamRequired("HandshakeId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHandshakeId sets the HandshakeId field's value.
func (s *CancelHandshakeInput) SetHandshakeId(v string) *CancelHandshakeInput {
	s.HandshakeId = &v
	return s
}

type CancelHandshakeOutput struct {
	_ struct{} `type:"structure"`

	// A structure that contains details about the handshake that you canceled.
	Handshake *Handshake `type:"structure"`
}

// String returns the string representation
func (s CancelHandshakeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelHandshakeOutput) GoString() string {
	return s.String()
}

// SetHandshake sets the Handshake field's value.
func (s *CancelHandshakeOutput) SetHandshake(v *Handshake) *CancelHandshakeOutput {
	s.Handshake = v
	return s
}

// Contains a list of child entities, either OUs or accounts.
type Child struct {
	_ struct{} `type:"structure"`

	// The unique identifier (ID) of this child entity.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for a child ID string
	// requires one of the following:
	//
	//    * Account: A string that consists of exactly 12 digits.
	//
	//    * Organizational unit (OU): A string that begins with "ou-" followed by
	//    from 4 to 32 lower-case letters or digits (the ID of the root that contains
	//    the OU). This string is followed by a second "-" dash and from 8 to 32
	//    additional lower-case letters or digits.
	Id *string `type:"string"`

	// The type of this child entity.
	Type *string `type:"string" enum:"ChildType"`
}

// String returns the string representation
func (s Child) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Child) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *Child) SetId(v string) *Child {
	s.Id = &v
	return s
}

// SetType sets the Type field's value.
func (s *Child) SetType(v string) *Child {
	s.Type = &v
	return s
}

// We can't find an organizational unit (OU) or AWS account with the ChildId
// that you specified.
type ChildNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ChildNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChildNotFoundException) GoString() string {
	return s.String()
}

func newErrorChildNotFoundException(v protocol.ResponseMetadata) error {
	return &ChildNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ChildNotFoundException) Code() string {
	return "ChildNotFoundException"
}

// Message returns the exception's message.
func (s *ChildNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ChildNotFoundException) OrigErr() error {
	return nil
}

func (s *ChildNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ChildNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ChildNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The target of the operation is currently being modified by a different request.
// Try again later.
type ConcurrentModificationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ConcurrentModificationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConcurrentModificationException) GoString() string {
	return s.String()
}

func newErrorConcurrentModificationException(v protocol.ResponseMetadata) error {
	return &ConcurrentModificationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConcurrentModificationException) Code() string {
	return "ConcurrentModificationException"
}

// Message returns the exception's message.
func (s *ConcurrentModificationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConcurrentModificationException) OrigErr() error {
	return nil
}

func (s *ConcurrentModificationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConcurrentModificationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConcurrentModificationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Performing this operation violates a minimum or maximum value limit. For
// example, attempting to remove the last service control policy (SCP) from
// an OU or root, inviting or creating too many accounts to the organization,
// or attaching too many policies to an account, OU, or root. This exception
// includes a reason that contains additional information about the violated
// limit:
//
// Some of the reasons in the following list might not be applicable to this
// specific API or operation.
//
//    * ACCOUNT_CANNOT_LEAVE_ORGANIZAION: You attempted to remove the master
//    account from the organization. You can't remove the master account. Instead,
//    after you remove all member accounts, delete the organization itself.
//
//    * ACCOUNT_CANNOT_LEAVE_WITHOUT_EULA: You attempted to remove an account
//    from the organization that doesn't yet have enough information to exist
//    as a standalone account. This account requires you to first agree to the
//    AWS Customer Agreement. Follow the steps at Removing a member account
//    from your organization (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master)in
//    the AWS Organizations User Guide.
//
//    * ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove
//    an account from the organization that doesn't yet have enough information
//    to exist as a standalone account. This account requires you to first complete
//    phone verification. Follow the steps at Removing a member account from
//    your organization (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master)
//    in the AWS Organizations User Guide.
//
//    * ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number
//    of accounts that you can create in one day.
//
//    * ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on
//    the number of accounts in an organization. If you need more accounts,
//    contact AWS Support (https://console.aws.amazon.com/support/home#/) to
//    request an increase in your limit. Or the number of invitations that you
//    tried to send would cause you to exceed the limit of accounts in your
//    organization. Send fewer invitations or contact AWS Support to request
//    an increase in the number of accounts. Deleted and closed accounts still
//    count toward your limit. If you get this exception when running a command
//    immediately after creating the organization, wait one hour and try again.
//    After an hour, if the command continues to fail with this error, contact
//    AWS Support (https://console.aws.amazon.com/support/home#/).
//
//    * CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to
//    register the master account of the organization as a delegated administrator
//    for an AWS service integrated with Organizations. You can designate only
//    a member account as a delegated administrator.
//
//    * CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove
//    an account that is registered as a delegated administrator for a service
//    integrated with your organization. To complete this operation, you must
//    first deregister this account as a delegated administrator.
//
//    * CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an
//    organization in the specified region, you must enable all features mode.
//
//    * DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register
//    an AWS account as a delegated administrator for an AWS service that already
//    has a delegated administrator. To complete this operation, you must first
//    deregister any existing delegated administrators for this service.
//
//    * EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only
//    valid for a limited period of time. You must resubmit the request and
//    generate a new verfication code.
//
//    * HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of
//    handshakes that you can send in one day.
//
//    * MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account
//    in this organization, you first must migrate the organization's master
//    account to the marketplace that corresponds to the master account's address.
//    For example, accounts with India addresses must be associated with the
//    AISPL marketplace. All accounts in an organization must be associated
//    with the same marketplace.
//
//    * MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the AWS Regions
//    in China. To create an organization, the master must have an valid business
//    license. For more information, contact customer support.
//
//    * MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you
//    must first provide a valid contact address and phone number for the master
//    account. Then try the operation again.
//
//    * MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the
//    master account must have an associated account in the AWS GovCloud (US-West)
//    Region. For more information, see AWS Organizations (http://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html)
//    in the AWS GovCloud User Guide.
//
//    * MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization
//    with this master account, you first must associate a valid payment instrument,
//    such as a credit card, with the account. Follow the steps at To leave
//    an organization when all required account information has not yet been
//    provided (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info)
//    in the AWS Organizations User Guide.
//
//    * MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted
//    to register more delegated administrators than allowed for the service
//    principal.
//
//    * MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the
//    number of policies of a certain type that can be attached to an entity
//    at one time.
//
//    * MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed
//    on this resource.
//
//    * MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation
//    with this member account, you first must associate a valid payment instrument,
//    such as a credit card, with the account. Follow the steps at To leave
//    an organization when all required account information has not yet been
//    provided (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info)
//    in the AWS Organizations User Guide.
//
//    * MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a
//    policy from an entity that would cause the entity to have fewer than the
//    minimum number of policies of a certain type required.
//
//    * ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation
//    that requires the organization to be configured to support all features.
//    An organization that supports only consolidated billing features can't
//    perform this operation.
//
//    * OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is
//    too many levels deep.
//
//    * OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs
//    that you can have in an organization.
//
//    * POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that
//    is larger than the maximum size.
//
//    * POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of
//    policies that you can have in an organization.
//
//    * TAG_POLICY_VIOLATION: You attempted to create or update a resource with
//    tags that are not compliant with the tag policy requirements for this
//    account.
type ConstraintViolationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	Reason *string `type:"string" enum:"ConstraintViolationExceptionReason"`
}

// String returns the string representation
func (s ConstraintViolationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConstraintViolationException) GoString() string {
	return s.String()
}

func newErrorConstraintViolationException(v protocol.ResponseMetadata) error {
	return &ConstraintViolationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConstraintViolationException) Code() string {
	return "ConstraintViolationException"
}

// Message returns the exception's message.
func (s *ConstraintViolationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConstraintViolationException) OrigErr() error {
	return nil
}

func (s *ConstraintViolationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConstraintViolationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConstraintViolationException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateAccountInput struct {
	_ struct{} `type:"structure"`

	// The friendly name of the member account.
	//
	// AccountName is a required field
	AccountName *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// The email address of the owner to assign to the new member account. This
	// email address must not already be associated with another AWS account. You
	// must use a valid email address to complete account creation. You can't access
	// the root user of the account or remove an account that was created with an
	// invalid email address.
	//
	// Email is a required field
	Email *string `min:"6" type:"string" required:"true" sensitive:"true"`

	// If set to ALLOW, the new account enables IAM users to access account billing
	// information if they have the required permissions. If set to DENY, only the
	// root user of the new account can access account billing information. For
	// more information, see Activating Access to the Billing and Cost Management
	// Console (https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/grantaccess.html#ControllingAccessWebsite-Activate)
	// in the AWS Billing and Cost Management User Guide.
	//
	// If you don't specify this parameter, the value defaults to ALLOW, and IAM
	// users and roles with the required permissions can access billing information
	// for the new account.
	IamUserAccessToBilling *string `type:"string" enum:"IAMUserAccessToBilling"`

	// (Optional)
	//
	// The name of an IAM role that AWS Organizations automatically preconfigures
	// in the new member account. This role trusts the master account, allowing
	// users in the master account to assume the role, as permitted by the master
	// account administrator. The role has administrator permissions in the new
	// member account.
	//
	// If you don't specify this parameter, the role name defaults to OrganizationAccountAccessRole.
	//
	// For more information about how to use this role to access the member account,
	// see the following links:
	//
	//    * Accessing and Administering the Member Accounts in Your Organization
	//    (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_access.html#orgs_manage_accounts_create-cross-account-role)
	//    in the AWS Organizations User Guide
	//
	//    * Steps 2 and 3 in Tutorial: Delegate Access Across AWS Accounts Using
	//    IAM Roles (https://docs.aws.amazon.com/IAM/latest/UserGuide/tutorial_cross-account-with-roles.html)
	//    in the IAM User Guide
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) that is used to validate
	// this parameter. The pattern can include uppercase letters, lowercase letters,
	// digits with no spaces, and any of the following characters: =,.@-
	RoleName *string `type:"string"`

	// A list of tags that you want to attach to the newly created account. For
	// each tag in the list, you must specify both a tag key and a value. You can
	// set the value to an empty string, but you can't set it to null. For more
	// information about tagging, see Tagging AWS Organizations resources (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html)
	// in the AWS Organizations User Guide.
	//
	// If any one of the tags is invalid or if you exceed the allowed number of
	// tags for an account, then the entire request fails and the account is not
	// created.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s CreateAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAccountInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAccountInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAccountInput"}
	if s.AccountName == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountName"))
	}
	if s.AccountName != nil && len(*s.AccountName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountName", 1))
	}
	if s.Email == nil {
		invalidParams.Add(request.NewErrParamRequired("Email"))
	}
	if s.Email != nil && len(*s.Email) < 6 {
		invalidParams.Add(request.NewErrParamMinLen("Email", 6))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountName sets the AccountName field's value.
func (s *CreateAccountInput) SetAccountName(v string) *CreateAccountInput {
	s.AccountName = &v
	return s
}

// SetEmail sets the Email field's value.
func (s *CreateAccountInput) SetEmail(v string) *CreateAccountInput {
	s.Email = &v
	return s
}

// SetIamUserAccessToBilling sets the IamUserAccessToBilling field's value.
func (s *CreateAccountInput) SetIamUserAccessToBilling(v string) *CreateAccountInput {
	s.IamUserAccessToBilling = &v
	return s
}

// SetRoleName sets the RoleName field's value.
func (s *CreateAccountInput) SetRoleName(v string) *CreateAccountInput {
	s.RoleName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateAccountInput) SetTags(v []*Tag) *CreateAccountInput {
	s.Tags = v
	return s
}

type CreateAccountOutput struct {
	_ struct{} `type:"structure"`

	// A structure that contains details about the request to create an account.
	// This response structure might not be fully populated when you first receive
	// it because account creation is an asynchronous process. You can pass the
	// returned CreateAccountStatus ID as a parameter to DescribeCreateAccountStatus
	// to get status about the progress of the request at later times. You can also
	// check the AWS CloudTrail log for the CreateAccountResult event. For more
	// information, see Monitoring the Activity in Your Organization (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_monitoring.html)
	// in the AWS Organizations User Guide.
	CreateAccountStatus *CreateAccountStatus `type:"structure"`
}

// String returns the string representation
func (s CreateAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAccountOutput) GoString() string {
	return s.String()
}

// SetCreateAccountStatus sets the CreateAccountStatus field's value.
func (s *CreateAccountOutput) SetCreateAccountStatus(v *CreateAccountStatus) *CreateAccountOutput {
	s.CreateAccountStatus = v
	return s
}

// Contains the status about a CreateAccount or CreateGovCloudAccount request
// to create an AWS account or an AWS GovCloud (US) account in an organization.
type CreateAccountStatus struct {
	_ struct{} `type:"structure"`

	// If the account was created successfully, the unique identifier (ID) of the
	// new account.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for an account ID string
	// requires exactly 12 digits.
	AccountId *string `type:"string"`

	// The account name given to the account when it was created.
	AccountName *string `min:"1" type:"string" sensitive:"true"`

	// The date and time that the account was created and the request completed.
	CompletedTimestamp *time.Time `type:"timestamp"`

	// If the request failed, a description of the reason for the failure.
	//
	//    * ACCOUNT_LIMIT_EXCEEDED: The account could not be created because you
	//    have reached the limit on the number of accounts in your organization.
	//
	//    * CONCURRENT_ACCOUNT_MODIFICATION: You already submitted a request with
	//    the same information.
	//
	//    * EMAIL_ALREADY_EXISTS: The account could not be created because another
	//    AWS account with that email address already exists.
	//
	//    * GOVCLOUD_ACCOUNT_ALREADY_EXISTS: The account in the AWS GovCloud (US)
	//    Region could not be created because this Region already includes an account
	//    with that email address.
	//
	//    * INVALID_ADDRESS: The account could not be created because the address
	//    you provided is not valid.
	//
	//    * INVALID_EMAIL: The account could not be created because the email address
	//    you provided is not valid.
	//
	//    * INTERNAL_FAILURE: The account could not be created because of an internal
	//    failure. Try again later. If the problem persists, contact Customer Support.
	//
	//    * MISSING_BUSINESS_VALIDATION: The AWS account that owns your organization
	//    has not received Business Validation.
	//
	//    * MISSING_PAYMENT_INSTRUMENT: You must configure the master account with
	//    a valid payment method, such as a credit card.
	FailureReason *string `type:"string" enum:"CreateAccountFailureReason"`

	// If the account was created successfully, the unique identifier (ID) of the
	// new account in the AWS GovCloud (US) Region.
	GovCloudAccountId *string `type:"string"`

	// The unique identifier (ID) that references this request. You get this value
	// from the response of the initial CreateAccount request to create the account.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for a create account
	// request ID string requires "car-" followed by from 8 to 32 lower-case letters
	// or digits.
	Id *string `type:"string"`

	// The date and time that the request was made for the account creation.
	RequestedTimestamp *time.Time `type:"timestamp"`

	// The status of the request.
	State *string `type:"string" enum:"CreateAccountState"`
}

// String returns the string representation
func (s CreateAccountStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAccountStatus) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *CreateAccountStatus) SetAccountId(v string) *CreateAccountStatus {
	s.AccountId = &v
	return s
}

// SetAccountName sets the AccountName field's value.
func (s *CreateAccountStatus) SetAccountName(v string) *CreateAccountStatus {
	s.AccountName = &v
	return s
}

// SetCompletedTimestamp sets the CompletedTimestamp field's value.
func (s *CreateAccountStatus) SetCompletedTimestamp(v time.Time) *CreateAccountStatus {
	s.CompletedTimestamp = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *CreateAccountStatus) SetFailureReason(v string) *CreateAccountStatus {
	s.FailureReason = &v
	return s
}

// SetGovCloudAccountId sets the GovCloudAccountId field's value.
func (s *CreateAccountStatus) SetGovCloudAccountId(v string) *CreateAccountStatus {
	s.GovCloudAccountId = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateAccountStatus) SetId(v string) *CreateAccountStatus {
	s.Id = &v
	return s
}

// SetRequestedTimestamp sets the RequestedTimestamp field's value.
func (s *CreateAccountStatus) SetRequestedTimestamp(v time.Time) *CreateAccountStatus {
	s.RequestedTimestamp = &v
	return s
}

// SetState sets the State field's value.
func (s *CreateAccountStatus) SetState(v string) *CreateAccountStatus {
	s.State = &v
	return s
}

// We can't find an create account request with the CreateAccountRequestId that
// you specified.
type CreateAccountStatusNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s CreateAccountStatusNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAccountStatusNotFoundException) GoString() string {
	return s.String()
}

func newErrorCreateAccountStatusNotFoundException(v protocol.ResponseMetadata) error {
	return &CreateAccountStatusNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *CreateAccountStatusNotFoundException) Code() string {
	return "CreateAccountStatusNotFoundException"
}

// Message returns the exception's message.
func (s *CreateAccountStatusNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *CreateAccountStatusNotFoundException) OrigErr() error {
	return nil
}

func (s *CreateAccountStatusNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *CreateAccountStatusNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *CreateAccountStatusNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateGovCloudAccountInput struct {
	_ struct{} `type:"structure"`

	// The friendly name of the member account.
	//
	// AccountName is a required field
	AccountName *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// The email address of the owner to assign to the new member account in the
	// commercial Region. This email address must not already be associated with
	// another AWS account. You must use a valid email address to complete account
	// creation. You can't access the root user of the account or remove an account
	// that was created with an invalid email address. Like all request parameters
	// for CreateGovCloudAccount, the request for the email address for the AWS
	// GovCloud (US) account originates from the commercial Region, not from the
	// AWS GovCloud (US) Region.
	//
	// Email is a required field
	Email *string `min:"6" type:"string" required:"true" sensitive:"true"`

	// If set to ALLOW, the new linked account in the commercial Region enables
	// IAM users to access account billing information if they have the required
	// permissions. If set to DENY, only the root user of the new account can access
	// account billing information. For more information, see Activating Access
	// to the Billing and Cost Management Console (https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/grantaccess.html#ControllingAccessWebsite-Activate)
	// in the AWS Billing and Cost Management User Guide.
	//
	// If you don't specify this parameter, the value defaults to ALLOW, and IAM
	// users and roles with the required permissions can access billing information
	// for the new account.
	IamUserAccessToBilling *string `type:"string" enum:"IAMUserAccessToBilling"`

	// (Optional)
	//
	// The name of an IAM role that AWS Organizations automatically preconfigures
	// in the new member accounts in both the AWS GovCloud (US) Region and in the
	// commercial Region. This role trusts the master account, allowing users in
	// the master account to assume the role, as permitted by the master account
	// administrator. The role has administrator permissions in the new member account.
	//
	// If you don't specify this parameter, the role name defaults to OrganizationAccountAccessRole.
	//
	// For more information about how to use this role to access the member account,
	// see Accessing and Administering the Member Accounts in Your Organization
	// (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_access.html#orgs_manage_accounts_create-cross-account-role)
	// in the AWS Organizations User Guide and steps 2 and 3 in Tutorial: Delegate
	// Access Across AWS Accounts Using IAM Roles (https://docs.aws.amazon.com/IAM/latest/UserGuide/tutorial_cross-account-with-roles.html)
	// in the IAM User Guide.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) that is used to validate
	// this parameter. The pattern can include uppercase letters, lowercase letters,
	// digits with no spaces, and any of the following characters: =,.@-
	RoleName *string `type:"string"`

	// A list of tags that you want to attach to the newly created account. These
	// tags are attached to the commercial account associated with the GovCloud
	// account, and not to the GovCloud account itself. To add tags to the actual
	// GovCloud account, call the TagResource operation in the GovCloud region after
	// the new GovCloud account exists.
	//
	// For each tag in the list, you must specify both a tag key and a value. You
	// can set the value to an empty string, but you can't set it to null. For more
	// information about tagging, see Tagging AWS Organizations resources (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html)
	// in the AWS Organizations User Guide.
	//
	// If any one of the tags is invalid or if you exceed the allowed number of
	// tags for an account, then the entire request fails and the account is not
	// created.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s CreateGovCloudAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateGovCloudAccountInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateGovCloudAccountInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateGovCloudAccountInput"}
	if s.AccountName == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountName"))
	}
	if s.AccountName != nil && len(*s.AccountName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountName", 1))
	}
	if s.Email == nil {
		invalidParams.Add(request.NewErrParamRequired("Email"))
	}
	if s.Email != nil && len(*s.Email) < 6 {
		invalidParams.Add(request.NewErrParamMinLen("Email", 6))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountName sets the AccountName field's value.
func (s *CreateGovCloudAccountInput) SetAccountName(v string) *CreateGovCloudAccountInput {
	s.AccountName = &v
	return s
}

// SetEmail sets the Email field's value.
func (s *CreateGovCloudAccountInput) SetEmail(v string) *CreateGovCloudAccountInput {
	s.Email = &v
	return s
}

// SetIamUserAccessToBilling sets the IamUserAccessToBilling field's value.
func (s *CreateGovCloudAccountInput) SetIamUserAccessToBilling(v string) *CreateGovCloudAccountInput {
	s.IamUserAccessToBilling = &v
	return s
}

// SetRoleName sets the RoleName field's value.
func (s *CreateGovCloudAccountInput) SetRoleName(v string) *CreateGovCloudAccountInput {
	s.RoleName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateGovCloudAccountInput) SetTags(v []*Tag) *CreateGovCloudAccountInput {
	s.Tags = v
	return s
}

type CreateGovCloudAccountOutput struct {
	_ struct{} `type:"structure"`

	// Contains the status about a CreateAccount or CreateGovCloudAccount request
	// to create an AWS account or an AWS GovCloud (US) account in an organization.
	CreateAccountStatus *CreateAccountStatus `type:"structure"`
}

// String returns the string representation
func (s CreateGovCloudAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateGovCloudAccountOutput) GoString() string {
	return s.String()
}

// SetCreateAccountStatus sets the CreateAccountStatus field's value.
func (s *CreateGovCloudAccountOutput) SetCreateAccountStatus(v *CreateAccountStatus) *CreateGovCloudAccountOutput {
	s.CreateAccountStatus = v
	return s
}

type CreateOrganizationInput struct {
	_ struct{} `type:"structure"`

	// Specifies the feature set supported by the new organization. Each feature
	// set supports different levels of functionality.
	//
	//    * CONSOLIDATED_BILLING: All member accounts have their bills consolidated
	//    to and paid by the master account. For more information, see Consolidated
	//    billing (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#feature-set-cb-only)
	//    in the AWS Organizations User Guide. The consolidated billing feature
	//    subset isn't available for organizations in the AWS GovCloud (US) Region.
	//
	//    * ALL: In addition to all the features supported by the consolidated billing
	//    feature set, the master account can also apply any policy type to any
	//    member account in the organization. For more information, see All features
	//    (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#feature-set-all)
	//    in the AWS Organizations User Guide.
	FeatureSet *string `type:"string" enum:"OrganizationFeatureSet"`
}

// String returns the string representation
func (s CreateOrganizationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateOrganizationInput) GoString() string {
	return s.String()
}

// SetFeatureSet sets the FeatureSet field's value.
func (s *CreateOrganizationInput) SetFeatureSet(v string) *CreateOrganizationInput {
	s.FeatureSet = &v
	return s
}

type CreateOrganizationOutput struct {
	_ struct{} `type:"structure"`

	// A structure that contains details about the newly created organization.
	Organization *Organization `type:"structure"`
}

// String returns the string representation
func (s CreateOrganizationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateOrganizationOutput) GoString() string {
	return s.String()
}

// SetOrganization sets the Organization field's value.
func (s *CreateOrganizationOutput) SetOrganization(v *Organization) *CreateOrganizationOutput {
	s.Organization = v
	return s
}

type CreateOrganizationalUnitInput struct {
	_ struct{} `type:"structure"`

	// The friendly name to assign to the new OU.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The unique identifier (ID) of the parent root or OU that you want to create
	// the new OU in.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for a parent ID string
	// requires one of the following:
	//
	//    * Root - A string that begins with "r-" followed by from 4 to 32 lowercase
	//    letters or digits.
	//
	//    * Organizational unit (OU) - A string that begins with "ou-" followed
	//    by from 4 to 32 lowercase letters or digits (the ID of the root that the
	//    OU is in). This string is followed by a second "-" dash and from 8 to
	//    32 additional lowercase letters or digits.
	//
	// ParentId is a required field
	ParentId *string `type:"string" required:"true"`

	// A list of tags that you want to attach to the newly created OU. For each
	// tag in the list, you must specify both a tag key and a value. You can set
	// the value to an empty string, but you can't set it to null. For more information
	// about tagging, see Tagging AWS Organizations resources (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html)
	// in the AWS Organizations User Guide.
	//
	// If any one of the tags is invalid or if you exceed the allowed number of
	// tags for an OU, then the entire request fails and the OU is not created.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s CreateOrganizationalUnitInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateOrganizationalUnitInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateOrganizationalUnitInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateOrganizationalUnitInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.ParentId == nil {
		invalidParams.Add(request.NewErrParamRequired("ParentId"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *CreateOrganizationalUnitInput) SetName(v string) *CreateOrganizationalUnitInput {
	s.Name = &v
	return s
}

// SetParentId sets the ParentId field's value.
func (s *CreateOrganizationalUnitInput) SetParentId(v string) *CreateOrganizationalUnitInput {
	s.ParentId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateOrganizationalUnitInput) SetTags(v []*Tag) *CreateOrganizationalUnitInput {
	s.Tags = v
	return s
}

type CreateOrganizationalUnitOutput struct {
	_ struct{} `type:"structure"`

	// A structure that contains details about the newly created OU.
	OrganizationalUnit *OrganizationalUnit `type:"structure"`
}

// String returns the string representation
func (s CreateOrganizationalUnitOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateOrganizationalUnitOutput) GoString() string {
	return s.String()
}

// SetOrganizationalUnit sets the OrganizationalUnit field's value.
func (s *CreateOrganizationalUnitOutput) SetOrganizationalUnit(v *OrganizationalUnit) *CreateOrganizationalUnitOutput {
	s.OrganizationalUnit = v
	return s
}

type CreatePolicyInput struct {
	_ struct{} `type:"structure"`

	// The policy text content to add to the new policy. The text that you supply
	// must adhere to the rules of the policy type you specify in the Type parameter.
	//
	// Content is a required field
	Content *string `min:"1" type:"string" required:"true"`

	// An optional description to assign to the policy.
	//
	// Description is a required field
	Description *string `type:"string" required:"true"`

	// The friendly name to assign to the policy.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) that is used to validate
	// this parameter is a string of any of the characters in the ASCII character
	// range.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// A list of tags that you want to attach to the newly created policy. For each
	// tag in the list, you must specify both a tag key and a value. You can set
	// the value to an empty string, but you can't set it to null. For more information
	// about tagging, see Tagging AWS Organizations resources (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html)
	// in the AWS Organizations User Guide.
	//
	// If any one of the tags is invalid or if you exceed the allowed number of
	// tags for a policy, then the entire request fails and the policy is not created.
	Tags []*Tag `type:"list"`

	// The type of policy to create. You can specify one of the following values:
	//
	//    * AISERVICES_OPT_OUT_POLICY (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html)
	//
	//    * BACKUP_POLICY (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html)
	//
	//    * SERVICE_CONTROL_POLICY (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html)
	//
	//    * TAG_POLICY (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html)
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"PolicyType"`
}

// String returns the string representation
func (s CreatePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePolicyInput"}
	if s.Content == nil {
		invalidParams.Add(request.NewErrParamRequired("Content"))
	}
	if s.Content != nil && len(*s.Content) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Content", 1))
	}
	if s.Description == nil {
		invalidParams.Add(request.NewErrParamRequired("Description"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContent sets the Content field's value.
func (s *CreatePolicyInput) SetContent(v string) *CreatePolicyInput {
	s.Content = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreatePolicyInput) SetDescription(v string) *CreatePolicyInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreatePolicyInput) SetName(v string) *CreatePolicyInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreatePolicyInput) SetTags(v []*Tag) *CreatePolicyInput {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *CreatePolicyInput) SetType(v string) *CreatePolicyInput {
	s.Type = &v
	return s
}

type CreatePolicyOutput struct {
	_ struct{} `type:"structure"`

	// A structure that contains details about the newly created policy.
	Policy *Policy `type:"structure"`
}

// String returns the string representation
func (s CreatePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePolicyOutput) GoString() string {
	return s.String()
}

// SetPolicy sets the Policy field's value.
func (s *CreatePolicyOutput) SetPolicy(v *Policy) *CreatePolicyOutput {
	s.Policy = v
	return s
}

type DeclineHandshakeInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier (ID) of the handshake that you want to decline. You
	// can get the ID from the ListHandshakesForAccount operation.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for handshake ID string
	// requires "h-" followed by from 8 to 32 lowercase letters or digits.
	//
	// HandshakeId is a required field
	HandshakeId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeclineHandshakeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeclineHandshakeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeclineHandshakeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeclineHandshakeInput"}
	if s.HandshakeId == nil {
		invalidParams.Add(request.NewErrParamRequired("HandshakeId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHandshakeId sets the HandshakeId field's value.
func (s *DeclineHandshakeInput) SetHandshakeId(v string) *DeclineHandshakeInput {
	s.HandshakeId = &v
	return s
}

type DeclineHandshakeOutput struct {
	_ struct{} `type:"structure"`

	// A structure that contains details about the declined handshake. The state
	// is updated to show the value DECLINED.
	Handshake *Handshake `type:"structure"`
}

// String returns the string representation
func (s DeclineHandshakeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeclineHandshakeOutput) GoString() string {
	return s.String()
}

// SetHandshake sets the Handshake field's value.
func (s *DeclineHandshakeOutput) SetHandshake(v *Handshake) *DeclineHandshakeOutput {
	s.Handshake = v
	return s
}

// Contains information about the delegated administrator.
type DelegatedAdministrator struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the delegated administrator's account.
	Arn *string `type:"string"`

	// The date when the account was made a delegated administrator.
	DelegationEnabledDate *time.Time `type:"timestamp"`

	// The email address that is associated with the delegated administrator's AWS
	// account.
	Email *string `min:"6" type:"string" sensitive:"true"`

	// The unique identifier (ID) of the delegated administrator's account.
	Id *string `type:"string"`

	// The method by which the delegated administrator's account joined the organization.
	JoinedMethod *string `type:"string" enum:"AccountJoinedMethod"`

	// The date when the delegated administrator's account became a part of the
	// organization.
	JoinedTimestamp *time.Time `type:"timestamp"`

	// The friendly name of the delegated administrator's account.
	Name *string `min:"1" type:"string" sensitive:"true"`

	// The status of the delegated administrator's account in the organization.
	Status *string `type:"string" enum:"AccountStatus"`
}

// String returns the string representation
func (s DelegatedAdministrator) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DelegatedAdministrator) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DelegatedAdministrator) SetArn(v string) *DelegatedAdministrator {
	s.Arn = &v
	return s
}

// SetDelegationEnabledDate sets the DelegationEnabledDate field's value.
func (s *DelegatedAdministrator) SetDelegationEnabledDate(v time.Time) *DelegatedAdministrator {
	s.DelegationEnabledDate = &v
	return s
}

// SetEmail sets the Email field's value.
func (s *DelegatedAdministrator) SetEmail(v string) *DelegatedAdministrator {
	s.Email = &v
	return s
}

// SetId sets the Id field's value.
func (s *DelegatedAdministrator) SetId(v string) *DelegatedAdministrator {
	s.Id = &v
	return s
}

// SetJoinedMethod sets the JoinedMethod field's value.
func (s *DelegatedAdministrator) SetJoinedMethod(v string) *DelegatedAdministrator {
	s.JoinedMethod = &v
	return s
}

// SetJoinedTimestamp sets the JoinedTimestamp field's value.
func (s *DelegatedAdministrator) SetJoinedTimestamp(v time.Time) *DelegatedAdministrator {
	s.JoinedTimestamp = &v
	return s
}

// SetName sets the Name field's value.
func (s *DelegatedAdministrator) SetName(v string) *DelegatedAdministrator {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DelegatedAdministrator) SetStatus(v string) *DelegatedAdministrator {
	s.Status = &v
	return s
}

// Contains information about the AWS service for which the account is a delegated
// administrator.
type DelegatedService struct {
	_ struct{} `type:"structure"`

	// The date that the account became a delegated administrator for this service.
	DelegationEnabledDate *time.Time `type:"timestamp"`

	// The name of a service that can request an operation for the specified service.
	// This is typically in the form of a URL, such as: servicename.amazonaws.com.
	ServicePrincipal *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DelegatedService) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DelegatedService) GoString() string {
	return s.String()
}

// SetDelegationEnabledDate sets the DelegationEnabledDate field's value.
func (s *DelegatedService) SetDelegationEnabledDate(v time.Time) *DelegatedService {
	s.DelegationEnabledDate = &v
	return s
}

// SetServicePrincipal sets the ServicePrincipal field's value.
func (s *DelegatedService) SetServicePrincipal(v string) *DelegatedService {
	s.ServicePrincipal = &v
	return s
}

type DeleteOrganizationInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteOrganizationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteOrganizationInput) GoString() string {
	return s.String()
}

type DeleteOrganizationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteOrganizationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteOrganizationOutput) GoString() string {
	return s.String()
}

type DeleteOrganizationalUnitInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier (ID) of the organizational unit that you want to delete.
	// You can get the ID from the ListOrganizationalUnitsForParent operation.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for an organizational
	// unit ID string requires "ou-" followed by from 4 to 32 lowercase letters
	// or digits (the ID of the root that contains the OU). This string is followed
	// by a second "-" dash and from 8 to 32 additional lowercase letters or digits.
	//
	// OrganizationalUnitId is a required field
	OrganizationalUnitId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteOrganizationalUnitInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteOrganizationalUnitInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteOrganizationalUnitInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteOrganizationalUnitInput"}
	if s.OrganizationalUnitId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationalUnitId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOrganizationalUnitId sets the OrganizationalUnitId field's value.
func (s *DeleteOrganizationalUnitInput) SetOrganizationalUnitId(v string) *DeleteOrganizationalUnitInput {
	s.OrganizationalUnitId = &v
	return s
}

type DeleteOrganizationalUnitOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteOrganizationalUnitOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteOrganizationalUnitOutput) GoString() string {
	return s.String()
}

type DeletePolicyInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier (ID) of the policy that you want to delete. You can
	// get the ID from the ListPolicies or ListPoliciesForTarget operations.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for a policy ID string
	// requires "p-" followed by from 8 to 128 lowercase or uppercase letters, digits,
	// or the underscore character (_).
	//
	// PolicyId is a required field
	PolicyId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeletePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePolicyInput"}
	if s.PolicyId == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyId sets the PolicyId field's value.
func (s *DeletePolicyInput) SetPolicyId(v string) *DeletePolicyInput {
	s.PolicyId = &v
	return s
}

type DeletePolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeletePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePolicyOutput) GoString() string {
	return s.String()
}

type DeregisterDelegatedAdministratorInput struct {
	_ struct{} `type:"structure"`

	// The account ID number of the member account in the organization that you
	// want to deregister as a delegated administrator.
	//
	// AccountId is a required field
	AccountId *string `type:"string" required:"true"`

	// The service principal name of an AWS service for which the account is a delegated
	// administrator.
	//
	// Delegated administrator privileges are revoked for only the specified AWS
	// service from the member account. If the specified service is the only service
	// for which the member account is a delegated administrator, the operation
	// also revokes Organizations read action permissions.
	//
	// ServicePrincipal is a required field
	ServicePrincipal *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeregisterDelegatedAdministratorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeregisterDelegatedAdministratorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeregisterDelegatedAdministratorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeregisterDelegatedAdministratorInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.ServicePrincipal == nil {
		invalidParams.Add(request.NewErrParamRequired("ServicePrincipal"))
	}
	if s.ServicePrincipal != nil && len(*s.ServicePrincipal) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServicePrincipal", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *DeregisterDelegatedAdministratorInput) SetAccountId(v string) *DeregisterDelegatedAdministratorInput {
	s.AccountId = &v
	return s
}

// SetServicePrincipal sets the ServicePrincipal field's value.
func (s *DeregisterDelegatedAdministratorInput) SetServicePrincipal(v string) *DeregisterDelegatedAdministratorInput {
	s.ServicePrincipal = &v
	return s
}

type DeregisterDelegatedAdministratorOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeregisterDelegatedAdministratorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeregisterDelegatedAdministratorOutput) GoString() string {
	return s.String()
}

type DescribeAccountInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier (ID) of the AWS account that you want information about.
	// You can get the ID from the ListAccounts or ListAccountsForParent operations.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for an account ID string
	// requires exactly 12 digits.
	//
	// AccountId is a required field
	AccountId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAccountInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAccountInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAccountInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *DescribeAccountInput) SetAccountId(v string) *DescribeAccountInput {
	s.AccountId = &v
	return s
}

type DescribeAccountOutput struct {
	_ struct{} `type:"structure"`

	// A structure that contains information about the requested account.
	Account *Account `type:"structure"`
}

// String returns the string representation
func (s DescribeAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAccountOutput) GoString() string {
	return s.String()
}

// SetAccount sets the Account field's value.
func (s *DescribeAccountOutput) SetAccount(v *Account) *DescribeAccountOutput {
	s.Account = v
	return s
}

type DescribeCreateAccountStatusInput struct {
	_ struct{} `type:"structure"`

	// Specifies the operationId that uniquely identifies the request. You can get
	// the ID from the response to an earlier CreateAccount request, or from the
	// ListCreateAccountStatus operation.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for a create account
	// request ID string requires "car-" followed by from 8 to 32 lowercase letters
	// or digits.
	//
	// CreateAccountRequestId is a required field
	CreateAccountRequestId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeCreateAccountStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCreateAccountStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeCreateAccountStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeCreateAccountStatusInput"}
	if s.CreateAccountRequestId == nil {
		invalidParams.Add(request.NewErrParamRequired("CreateAccountRequestId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreateAccountRequestId sets the CreateAccountRequestId field's value.
func (s *DescribeCreateAccountStatusInput) SetCreateAccountRequestId(v string) *DescribeCreateAccountStatusInput {
	s.CreateAccountRequestId = &v
	return s
}

type DescribeCreateAccountStatusOutput struct {
	_ struct{} `type:"structure"`

	// A structure that contains the current status of an account creation request.
	CreateAccountStatus *CreateAccountStatus `type:"structure"`
}

// String returns the string representation
func (s DescribeCreateAccountStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCreateAccountStatusOutput) GoString() string {
	return s.String()
}

// SetCreateAccountStatus sets the CreateAccountStatus field's value.
func (s *DescribeCreateAccountStatusOutput) SetCreateAccountStatus(v *CreateAccountStatus) *DescribeCreateAccountStatusOutput {
	s.CreateAccountStatus = v
	return s
}

type DescribeEffectivePolicyInput struct {
	_ struct{} `type:"structure"`

	// The type of policy that you want information about. You can specify one of
	// the following values:
	//
	//    * AISERVICES_OPT_OUT_POLICY (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html)
	//
	//    * BACKUP_POLICY (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html)
	//
	//    * TAG_POLICY (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html)
	//
	// PolicyType is a required field
	PolicyType *string `type:"string" required:"true" enum:"EffectivePolicyType"`

	// When you're signed in as the master account, specify the ID of the account
	// that you want details about. Specifying an organization root or organizational
	// unit (OU) as the target is not supported.
	TargetId *string `type:"string"`
}

// String returns the string representation
func (s DescribeEffectivePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEffectivePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEffectivePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeEffectivePolicyInput"}
	if s.PolicyType == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyType sets the PolicyType field's value.
func (s *DescribeEffectivePolicyInput) SetPolicyType(v string) *DescribeEffectivePolicyInput {
	s.PolicyType = &v
	return s
}

// SetTargetId sets the TargetId field's value.
func (s *DescribeEffectivePolicyInput) SetTargetId(v string) *DescribeEffectivePolicyInput {
	s.TargetId = &v
	return s
}

type DescribeEffectivePolicyOutput struct {
	_ struct{} `type:"structure"`

	// The contents of the effective policy.
	EffectivePolicy *EffectivePolicy `type:"structure"`
}

// String returns the string representation
func (s DescribeEffectivePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEffectivePolicyOutput) GoString() string {
	return s.String()
}

// SetEffectivePolicy sets the EffectivePolicy field's value.
func (s *DescribeEffectivePolicyOutput) SetEffectivePolicy(v *EffectivePolicy) *DescribeEffectivePolicyOutput {
	s.EffectivePolicy = v
	return s
}

type DescribeHandshakeInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier (ID) of the handshake that you want information about.
	// You can get the ID from the original call to InviteAccountToOrganization,
	// or from a call to ListHandshakesForAccount or ListHandshakesForOrganization.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for handshake ID string
	// requires "h-" followed by from 8 to 32 lowercase letters or digits.
	//
	// HandshakeId is a required field
	HandshakeId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeHandshakeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeHandshakeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeHandshakeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeHandshakeInput"}
	if s.HandshakeId == nil {
		invalidParams.Add(request.NewErrParamRequired("HandshakeId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHandshakeId sets the HandshakeId field's value.
func (s *DescribeHandshakeInput) SetHandshakeId(v string) *DescribeHandshakeInput {
	s.HandshakeId = &v
	return s
}

type DescribeHandshakeOutput struct {
	_ struct{} `type:"structure"`

	// A structure that contains information about the specified handshake.
	Handshake *Handshake `type:"structure"`
}

// String returns the string representation
func (s DescribeHandshakeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeHandshakeOutput) GoString() string {
	return s.String()
}

// SetHandshake sets the Handshake field's value.
func (s *DescribeHandshakeOutput) SetHandshake(v *Handshake) *DescribeHandshakeOutput {
	s.Handshake = v
	return s
}

type DescribeOrganizationInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DescribeOrganizationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeOrganizationInput) GoString() string {
	return s.String()
}

type DescribeOrganizationOutput struct {
	_ struct{} `type:"structure"`

	// A structure that contains information about the organization.
	//
	// The AvailablePolicyTypes part of the response is deprecated, and you shouldn't
	// use it in your apps. It doesn't include any policy type supported by Organizations
	// other than SCPs. To determine which policy types are enabled in your organization,
	// use the ListRoots operation.
	Organization *Organization `type:"structure"`
}

// String returns the string representation
func (s DescribeOrganizationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeOrganizationOutput) GoString() string {
	return s.String()
}

// SetOrganization sets the Organization field's value.
func (s *DescribeOrganizationOutput) SetOrganization(v *Organization) *DescribeOrganizationOutput {
	s.Organization = v
	return s
}

type DescribeOrganizationalUnitInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier (ID) of the organizational unit that you want details
	// about. You can get the ID from the ListOrganizationalUnitsForParent operation.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for an organizational
	// unit ID string requires "ou-" followed by from 4 to 32 lowercase letters
	// or digits (the ID of the root that contains the OU). This string is followed
	// by a second "-" dash and from 8 to 32 additional lowercase letters or digits.
	//
	// OrganizationalUnitId is a required field
	OrganizationalUnitId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeOrganizationalUnitInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeOrganizationalUnitInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeOrganizationalUnitInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeOrganizationalUnitInput"}
	if s.OrganizationalUnitId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationalUnitId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOrganizationalUnitId sets the OrganizationalUnitId field's value.
func (s *DescribeOrganizationalUnitInput) SetOrganizationalUnitId(v string) *DescribeOrganizationalUnitInput {
	s.OrganizationalUnitId = &v
	return s
}

type DescribeOrganizationalUnitOutput struct {
	_ struct{} `type:"structure"`

	// A structure that contains details about the specified OU.
	OrganizationalUnit *OrganizationalUnit `type:"structure"`
}

// String returns the string representation
func (s DescribeOrganizationalUnitOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeOrganizationalUnitOutput) GoString() string {
	return s.String()
}

// SetOrganizationalUnit sets the OrganizationalUnit field's value.
func (s *DescribeOrganizationalUnitOutput) SetOrganizationalUnit(v *OrganizationalUnit) *DescribeOrganizationalUnitOutput {
	s.OrganizationalUnit = v
	return s
}

type DescribePolicyInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier (ID) of the policy that you want details about. You
	// can get the ID from the ListPolicies or ListPoliciesForTarget operations.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for a policy ID string
	// requires "p-" followed by from 8 to 128 lowercase or uppercase letters, digits,
	// or the underscore character (_).
	//
	// PolicyId is a required field
	PolicyId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribePolicyInput"}
	if s.PolicyId == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyId sets the PolicyId field's value.
func (s *DescribePolicyInput) SetPolicyId(v string) *DescribePolicyInput {
	s.PolicyId = &v
	return s
}

type DescribePolicyOutput struct {
	_ struct{} `type:"structure"`

	// A structure that contains details about the specified policy.
	Policy *Policy `type:"structure"`
}

// String returns the string representation
func (s DescribePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribePolicyOutput) GoString() string {
	return s.String()
}

// SetPolicy sets the Policy field's value.
func (s *DescribePolicyOutput) SetPolicy(v *Policy) *DescribePolicyOutput {
	s.Policy = v
	return s
}

// We can't find the destination container (a root or OU) with the ParentId
// that you specified.
type DestinationParentNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s DestinationParentNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DestinationParentNotFoundException) GoString() string {
	return s.String()
}

func newErrorDestinationParentNotFoundException(v protocol.ResponseMetadata) error {
	return &DestinationParentNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *DestinationParentNotFoundException) Code() string {
	return "DestinationParentNotFoundException"
}

// Message returns the exception's message.
func (s *DestinationParentNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *DestinationParentNotFoundException) OrigErr() error {
	return nil
}

func (s *DestinationParentNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *DestinationParentNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *DestinationParentNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

type DetachPolicyInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier (ID) of the policy you want to detach. You can get
	// the ID from the ListPolicies or ListPoliciesForTarget operations.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for a policy ID string
	// requires "p-" followed by from 8 to 128 lowercase or uppercase letters, digits,
	// or the underscore character (_).
	//
	// PolicyId is a required field
	PolicyId *string `type:"string" required:"true"`

	// The unique identifier (ID) of the root, OU, or account that you want to detach
	// the policy from. You can get the ID from the ListRoots, ListOrganizationalUnitsForParent,
	// or ListAccounts operations.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for a target ID string
	// requires one of the following:
	//
	//    * Root - A string that begins with "r-" followed by from 4 to 32 lowercase
	//    letters or digits.
	//
	//    * Account - A string that consists of exactly 12 digits.
	//
	//    * Organizational unit (OU) - A string that begins with "ou-" followed
	//    by from 4 to 32 lowercase letters or digits (the ID of the root that the
	//    OU is in). This string is followed by a second "-" dash and from 8 to
	//    32 additional lowercase letters or digits.
	//
	// TargetId is a required field
	TargetId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DetachPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetachPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetachPolicyInput"}
	if s.PolicyId == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyId"))
	}
	if s.TargetId == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyId sets the PolicyId field's value.
func (s *DetachPolicyInput) SetPolicyId(v string) *DetachPolicyInput {
	s.PolicyId = &v
	return s
}

// SetTargetId sets the TargetId field's value.
func (s *DetachPolicyInput) SetTargetId(v string) *DetachPolicyInput {
	s.TargetId = &v
	return s
}

type DetachPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DetachPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachPolicyOutput) GoString() string {
	return s.String()
}

type DisableAWSServiceAccessInput struct {
	_ struct{} `type:"structure"`

	// The service principal name of the AWS service for which you want to disable
	// integration with your organization. This is typically in the form of a URL,
	// such as service-abbreviation.amazonaws.com.
	//
	// ServicePrincipal is a required field
	ServicePrincipal *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DisableAWSServiceAccessInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableAWSServiceAccessInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisableAWSServiceAccessInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisableAWSServiceAccessInput"}
	if s.ServicePrincipal == nil {
		invalidParams.Add(request.NewErrParamRequired("ServicePrincipal"))
	}
	if s.ServicePrincipal != nil && len(*s.ServicePrincipal) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServicePrincipal", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetServicePrincipal sets the ServicePrincipal field's value.
func (s *DisableAWSServiceAccessInput) SetServicePrincipal(v string) *DisableAWSServiceAccessInput {
	s.ServicePrincipal = &v
	return s
}

type DisableAWSServiceAccessOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisableAWSServiceAccessOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableAWSServiceAccessOutput) GoString() string {
	return s.String()
}

type DisablePolicyTypeInput struct {
	_ struct{} `type:"structure"`

	// The policy type that you want to disable in this root. You can specify one
	// of the following values:
	//
	//    * AISERVICES_OPT_OUT_POLICY (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html)
	//
	//    * BACKUP_POLICY (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html)
	//
	//    * SERVICE_CONTROL_POLICY (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html)
	//
	//    * TAG_POLICY (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html)
	//
	// PolicyType is a required field
	PolicyType *string `type:"string" required:"true" enum:"PolicyType"`

	// The unique identifier (ID) of the root in which you want to disable a policy
	// type. You can get the ID from the ListRoots operation.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for a root ID string
	// requires "r-" followed by from 4 to 32 lowercase letters or digits.
	//
	// RootId is a required field
	RootId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DisablePolicyTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisablePolicyTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisablePolicyTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisablePolicyTypeInput"}
	if s.PolicyType == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyType"))
	}
	if s.RootId == nil {
		invalidParams.Add(request.NewErrParamRequired("RootId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyType sets the PolicyType field's value.
func (s *DisablePolicyTypeInput) SetPolicyType(v string) *DisablePolicyTypeInput {
	s.PolicyType = &v
	return s
}

// SetRootId sets the RootId field's value.
func (s *DisablePolicyTypeInput) SetRootId(v string) *DisablePolicyTypeInput {
	s.RootId = &v
	return s
}

type DisablePolicyTypeOutput struct {
	_ struct{} `type:"structure"`

	// A structure that shows the root with the updated list of enabled policy types.
	Root *Root `type:"structure"`
}

// String returns the string representation
func (s DisablePolicyTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisablePolicyTypeOutput) GoString() string {
	return s.String()
}

// SetRoot sets the Root field's value.
func (s *DisablePolicyTypeOutput) SetRoot(v *Root) *DisablePolicyTypeOutput {
	s.Root = v
	return s
}

// That account is already present in the specified destination.
type DuplicateAccountException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s DuplicateAccountException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DuplicateAccountException) GoString() string {
	return s.String()
}

func newErrorDuplicateAccountException(v protocol.ResponseMetadata) error {
	return &DuplicateAccountException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *DuplicateAccountException) Code() string {
	return "DuplicateAccountException"
}

// Message returns the exception's message.
func (s *DuplicateAccountException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *DuplicateAccountException) OrigErr() error {
	return nil
}

func (s *DuplicateAccountException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *DuplicateAccountException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *DuplicateAccountException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A handshake with the same action and target already exists. For example,
// if you invited an account to join your organization, the invited account
// might already have a pending invitation from this organization. If you intend
// to resend an invitation to an account, ensure that existing handshakes that
// might be considered duplicates are canceled or declined.
type DuplicateHandshakeException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s DuplicateHandshakeException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DuplicateHandshakeException) GoString() string {
	return s.String()
}

func newErrorDuplicateHandshakeException(v protocol.ResponseMetadata) error {
	return &DuplicateHandshakeException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *DuplicateHandshakeException) Code() string {
	return "DuplicateHandshakeException"
}

// Message returns the exception's message.
func (s *DuplicateHandshakeException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *DuplicateHandshakeException) OrigErr() error {
	return nil
}

func (s *DuplicateHandshakeException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *DuplicateHandshakeException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *DuplicateHandshakeException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An OU with the same name already exists.
type DuplicateOrganizationalUnitException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s DuplicateOrganizationalUnitException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DuplicateOrganizationalUnitException) GoString() string {
	return s.String()
}

func newErrorDuplicateOrganizationalUnitException(v protocol.ResponseMetadata) error {
	return &DuplicateOrganizationalUnitException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *DuplicateOrganizationalUnitException) Code() string {
	return "DuplicateOrganizationalUnitException"
}

// Message returns the exception's message.
func (s *DuplicateOrganizationalUnitException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *DuplicateOrganizationalUnitException) OrigErr() error {
	return nil
}

func (s *DuplicateOrganizationalUnitException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *DuplicateOrganizationalUnitException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *DuplicateOrganizationalUnitException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The selected policy is already attached to the specified target.
type DuplicatePolicyAttachmentException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s DuplicatePolicyAttachmentException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DuplicatePolicyAttachmentException) GoString() string {
	return s.String()
}

func newErrorDuplicatePolicyAttachmentException(v protocol.ResponseMetadata) error {
	return &DuplicatePolicyAttachmentException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *DuplicatePolicyAttachmentException) Code() string {
	return "DuplicatePolicyAttachmentException"
}

// Message returns the exception's message.
func (s *DuplicatePolicyAttachmentException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *DuplicatePolicyAttachmentException) OrigErr() error {
	return nil
}

func (s *DuplicatePolicyAttachmentException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *DuplicatePolicyAttachmentException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *DuplicatePolicyAttachmentException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A policy with the same name already exists.
type DuplicatePolicyException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s DuplicatePolicyException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DuplicatePolicyException) GoString() string {
	return s.String()
}

func newErrorDuplicatePolicyException(v protocol.ResponseMetadata) error {
	return &DuplicatePolicyException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *DuplicatePolicyException) Code() string {
	return "DuplicatePolicyException"
}

// Message returns the exception's message.
func (s *DuplicatePolicyException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *DuplicatePolicyException) OrigErr() error {
	return nil
}

func (s *DuplicatePolicyException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *DuplicatePolicyException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *DuplicatePolicyException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains rules to be applied to the affected accounts. The effective policy
// is the aggregation of any policies the account inherits, plus any policy
// directly attached to the account.
type EffectivePolicy struct {
	_ struct{} `type:"structure"`

	// The time of the last update to this policy.
	LastUpdatedTimestamp *time.Time `type:"timestamp"`

	// The text content of the policy.
	PolicyContent *string `min:"1" type:"string"`

	// The policy type.
	PolicyType *string `type:"string" enum:"EffectivePolicyType"`

	// The account ID of the policy target.
	TargetId *string `type:"string"`
}

// String returns the string representation
func (s EffectivePolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EffectivePolicy) GoString() string {
	return s.String()
}

// SetLastUpdatedTimestamp sets the LastUpdatedTimestamp field's value.
func (s *EffectivePolicy) SetLastUpdatedTimestamp(v time.Time) *EffectivePolicy {
	s.LastUpdatedTimestamp = &v
	return s
}

// SetPolicyContent sets the PolicyContent field's value.
func (s *EffectivePolicy) SetPolicyContent(v string) *EffectivePolicy {
	s.PolicyContent = &v
	return s
}

// SetPolicyType sets the PolicyType field's value.
func (s *EffectivePolicy) SetPolicyType(v string) *EffectivePolicy {
	s.PolicyType = &v
	return s
}

// SetTargetId sets the TargetId field's value.
func (s *EffectivePolicy) SetTargetId(v string) *EffectivePolicy {
	s.TargetId = &v
	return s
}

// If you ran this action on the master account, this policy type is not enabled.
// If you ran the action on a member account, the account doesn't have an effective
// policy of this type. Contact the administrator of your organization about
// attaching a policy of this type to the account.
type EffectivePolicyNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s EffectivePolicyNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EffectivePolicyNotFoundException) GoString() string {
	return s.String()
}

func newErrorEffectivePolicyNotFoundException(v protocol.ResponseMetadata) error {
	return &EffectivePolicyNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *EffectivePolicyNotFoundException) Code() string {
	return "EffectivePolicyNotFoundException"
}

// Message returns the exception's message.
func (s *EffectivePolicyNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *EffectivePolicyNotFoundException) OrigErr() error {
	return nil
}

func (s *EffectivePolicyNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *EffectivePolicyNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *EffectivePolicyNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

type EnableAWSServiceAccessInput struct {
	_ struct{} `type:"structure"`

	// The service principal name of the AWS service for which you want to enable
	// integration with your organization. This is typically in the form of a URL,
	// such as service-abbreviation.amazonaws.com.
	//
	// ServicePrincipal is a required field
	ServicePrincipal *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s EnableAWSServiceAccessInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableAWSServiceAccessInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnableAWSServiceAccessInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EnableAWSServiceAccessInput"}
	if s.ServicePrincipal == nil {
		invalidParams.Add(request.NewErrParamRequired("ServicePrincipal"))
	}
	if s.ServicePrincipal != nil && len(*s.ServicePrincipal) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServicePrincipal", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetServicePrincipal sets the ServicePrincipal field's value.
func (s *EnableAWSServiceAccessInput) SetServicePrincipal(v string) *EnableAWSServiceAccessInput {
	s.ServicePrincipal = &v
	return s
}

type EnableAWSServiceAccessOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s EnableAWSServiceAccessOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableAWSServiceAccessOutput) GoString() string {
	return s.String()
}

type EnableAllFeaturesInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s EnableAllFeaturesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableAllFeaturesInput) GoString() string {
	return s.String()
}

type EnableAllFeaturesOutput struct {
	_ struct{} `type:"structure"`

	// A structure that contains details about the handshake created to support
	// this request to enable all features in the organization.
	Handshake *Handshake `type:"structure"`
}

// String returns the string representation
func (s EnableAllFeaturesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableAllFeaturesOutput) GoString() string {
	return s.String()
}

// SetHandshake sets the Handshake field's value.
func (s *EnableAllFeaturesOutput) SetHandshake(v *Handshake) *EnableAllFeaturesOutput {
	s.Handshake = v
	return s
}

type EnablePolicyTypeInput struct {
	_ struct{} `type:"structure"`

	// The policy type that you want to enable. You can specify one of the following
	// values:
	//
	//    * AISERVICES_OPT_OUT_POLICY (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html)
	//
	//    * BACKUP_POLICY (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html)
	//
	//    * SERVICE_CONTROL_POLICY (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html)
	//
	//    * TAG_POLICY (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html)
	//
	// PolicyType is a required field
	PolicyType *string `type:"string" required:"true" enum:"PolicyType"`

	// The unique identifier (ID) of the root in which you want to enable a policy
	// type. You can get the ID from the ListRoots operation.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for a root ID string
	// requires "r-" followed by from 4 to 32 lowercase letters or digits.
	//
	// RootId is a required field
	RootId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s EnablePolicyTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnablePolicyTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnablePolicyTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EnablePolicyTypeInput"}
	if s.PolicyType == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyType"))
	}
	if s.RootId == nil {
		invalidParams.Add(request.NewErrParamRequired("RootId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyType sets the PolicyType field's value.
func (s *EnablePolicyTypeInput) SetPolicyType(v string) *EnablePolicyTypeInput {
	s.PolicyType = &v
	return s
}

// SetRootId sets the RootId field's value.
func (s *EnablePolicyTypeInput) SetRootId(v string) *EnablePolicyTypeInput {
	s.RootId = &v
	return s
}

type EnablePolicyTypeOutput struct {
	_ struct{} `type:"structure"`

	// A structure that shows the root with the updated list of enabled policy types.
	Root *Root `type:"structure"`
}

// String returns the string representation
func (s EnablePolicyTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnablePolicyTypeOutput) GoString() string {
	return s.String()
}

// SetRoot sets the Root field's value.
func (s *EnablePolicyTypeOutput) SetRoot(v *Root) *EnablePolicyTypeOutput {
	s.Root = v
	return s
}

// A structure that contains details of a service principal that represents
// an AWS service that is enabled to integrate with AWS Organizations.
type EnabledServicePrincipal struct {
	_ struct{} `type:"structure"`

	// The date that the service principal was enabled for integration with AWS
	// Organizations.
	DateEnabled *time.Time `type:"timestamp"`

	// The name of the service principal. This is typically in the form of a URL,
	// such as: servicename.amazonaws.com.
	ServicePrincipal *string `min:"1" type:"string"`
}

// String returns the string representation
func (s EnabledServicePrincipal) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnabledServicePrincipal) GoString() string {
	return s.String()
}

// SetDateEnabled sets the DateEnabled field's value.
func (s *EnabledServicePrincipal) SetDateEnabled(v time.Time) *EnabledServicePrincipal {
	s.DateEnabled = &v
	return s
}

// SetServicePrincipal sets the ServicePrincipal field's value.
func (s *EnabledServicePrincipal) SetServicePrincipal(v string) *EnabledServicePrincipal {
	s.ServicePrincipal = &v
	return s
}

// AWS Organizations couldn't perform the operation because your organization
// hasn't finished initializing. This can take up to an hour. Try again later.
// If after one hour you continue to receive this error, contact AWS Support
// (https://console.aws.amazon.com/support/home#/).
type FinalizingOrganizationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s FinalizingOrganizationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FinalizingOrganizationException) GoString() string {
	return s.String()
}

func newErrorFinalizingOrganizationException(v protocol.ResponseMetadata) error {
	return &FinalizingOrganizationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *FinalizingOrganizationException) Code() string {
	return "FinalizingOrganizationException"
}

// Message returns the exception's message.
func (s *FinalizingOrganizationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *FinalizingOrganizationException) OrigErr() error {
	return nil
}

func (s *FinalizingOrganizationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *FinalizingOrganizationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *FinalizingOrganizationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains information that must be exchanged to securely establish a relationship
// between two accounts (an originator and a recipient). For example, when a
// master account (the originator) invites another account (the recipient) to
// join its organization, the two accounts exchange information as a series
// of handshake requests and responses.
//
// Note: Handshakes that are CANCELED, ACCEPTED, or DECLINED show up in lists
// for only 30 days after entering that state After that they are deleted.
type Handshake struct {
	_ struct{} `type:"structure"`

	// The type of handshake, indicating what action occurs when the recipient accepts
	// the handshake. The following handshake types are supported:
	//
	//    * INVITE: This type of handshake represents a request to join an organization.
	//    It is always sent from the master account to only non-member accounts.
	//
	//    * ENABLE_ALL_FEATURES: This type of handshake represents a request to
	//    enable all features in an organization. It is always sent from the master
	//    account to only invited member accounts. Created accounts do not receive
	//    this because those accounts were created by the organization's master
	//    account and approval is inferred.
	//
	//    * APPROVE_ALL_FEATURES: This type of handshake is sent from the Organizations
	//    service when all member accounts have approved the ENABLE_ALL_FEATURES
	//    invitation. It is sent only to the master account and signals the master
	//    that it can finalize the process to enable all features.
	Action *string `type:"string" enum:"ActionType"`

	// The Amazon Resource Name (ARN) of a handshake.
	//
	// For more information about ARNs in Organizations, see ARN Formats Supported
	// by Organizations (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_permissions.html#orgs-permissions-arns)
	// in the AWS Organizations User Guide.
	Arn *string `type:"string"`

	// The date and time that the handshake expires. If the recipient of the handshake
	// request fails to respond before the specified date and time, the handshake
	// becomes inactive and is no longer valid.
	ExpirationTimestamp *time.Time `type:"timestamp"`

	// The unique identifier (ID) of a handshake. The originating account creates
	// the ID when it initiates the handshake.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for handshake ID string
	// requires "h-" followed by from 8 to 32 lower-case letters or digits.
	Id *string `type:"string"`

	// Information about the two accounts that are participating in the handshake.
	Parties []*HandshakeParty `type:"list"`

	// The date and time that the handshake request was made.
	RequestedTimestamp *time.Time `type:"timestamp"`

	// Additional information that is needed to process the handshake.
	Resources []*HandshakeResource `type:"list"`

	// The current state of the handshake. Use the state to trace the flow of the
	// handshake through the process from its creation to its acceptance. The meaning
	// of each of the valid values is as follows:
	//
	//    * REQUESTED: This handshake was sent to multiple recipients (applicable
	//    to only some handshake types) and not all recipients have responded yet.
	//    The request stays in this state until all recipients respond.
	//
	//    * OPEN: This handshake was sent to multiple recipients (applicable to
	//    only some policy types) and all recipients have responded, allowing the
	//    originator to complete the handshake action.
	//
	//    * CANCELED: This handshake is no longer active because it was canceled
	//    by the originating account.
	//
	//    * ACCEPTED: This handshake is complete because it has been accepted by
	//    the recipient.
	//
	//    * DECLINED: This handshake is no longer active because it was declined
	//    by the recipient account.
	//
	//    * EXPIRED: This handshake is no longer active because the originator did
	//    not receive a response of any kind from the recipient before the expiration
	//    time (15 days).
	State *string `type:"string" enum:"HandshakeState"`
}

// String returns the string representation
func (s Handshake) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Handshake) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *Handshake) SetAction(v string) *Handshake {
	s.Action = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *Handshake) SetArn(v string) *Handshake {
	s.Arn = &v
	return s
}

// SetExpirationTimestamp sets the ExpirationTimestamp field's value.
func (s *Handshake) SetExpirationTimestamp(v time.Time) *Handshake {
	s.ExpirationTimestamp = &v
	return s
}

// SetId sets the Id field's value.
func (s *Handshake) SetId(v string) *Handshake {
	s.Id = &v
	return s
}

// SetParties sets the Parties field's value.
func (s *Handshake) SetParties(v []*HandshakeParty) *Handshake {
	s.Parties = v
	return s
}

// SetRequestedTimestamp sets the RequestedTimestamp field's value.
func (s *Handshake) SetRequestedTimestamp(v time.Time) *Handshake {
	s.RequestedTimestamp = &v
	return s
}

// SetResources sets the Resources field's value.
func (s *Handshake) SetResources(v []*HandshakeResource) *Handshake {
	s.Resources = v
	return s
}

// SetState sets the State field's value.
func (s *Handshake) SetState(v string) *Handshake {
	s.State = &v
	return s
}

// The specified handshake is already in the requested state. For example, you
// can't accept a handshake that was already accepted.
type HandshakeAlreadyInStateException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s HandshakeAlreadyInStateException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HandshakeAlreadyInStateException) GoString() string {
	return s.String()
}

func newErrorHandshakeAlreadyInStateException(v protocol.ResponseMetadata) error {
	return &HandshakeAlreadyInStateException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *HandshakeAlreadyInStateException) Code() string {
	return "HandshakeAlreadyInStateException"
}

// Message returns the exception's message.
func (s *HandshakeAlreadyInStateException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *HandshakeAlreadyInStateException) OrigErr() error {
	return nil
}

func (s *HandshakeAlreadyInStateException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *HandshakeAlreadyInStateException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *HandshakeAlreadyInStateException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The requested operation would violate the constraint identified in the reason
// code.
//
// Some of the reasons in the following list might not be applicable to this
// specific API or operation:
//
//    * ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on
//    the number of accounts in an organization. Note that deleted and closed
//    accounts still count toward your limit. If you get this exception immediately
//    after creating the organization, wait one hour and try again. If after
//    an hour it continues to fail with this error, contact AWS Support (https://console.aws.amazon.com/support/home#/).
//
//    * ALREADY_IN_AN_ORGANIZATION: The handshake request is invalid because
//    the invited account is already a member of an organization.
//
//    * HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of
//    handshakes that you can send in one day.
//
//    * INVITE_DISABLED_DURING_ENABLE_ALL_FEATURES: You can't issue new invitations
//    to join an organization while it's in the process of enabling all features.
//    You can resume inviting accounts after you finalize the process when all
//    accounts have agreed to the change.
//
//    * ORGANIZATION_ALREADY_HAS_ALL_FEATURES: The handshake request is invalid
//    because the organization has already enabled all features.
//
//    * ORGANIZATION_FROM_DIFFERENT_SELLER_OF_RECORD: The request failed because
//    the account is from a different marketplace than the accounts in the organization.
//    For example, accounts with India addresses must be associated with the
//    AISPL marketplace. All accounts in an organization must be from the same
//    marketplace.
//
//    * ORGANIZATION_MEMBERSHIP_CHANGE_RATE_LIMIT_EXCEEDED: You attempted to
//    change the membership of an account too quickly after its previous change.
//
//    * PAYMENT_INSTRUMENT_REQUIRED: You can't complete the operation with an
//    account that doesn't have a payment instrument, such as a credit card,
//    associated with it.
type HandshakeConstraintViolationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	Reason *string `type:"string" enum:"HandshakeConstraintViolationExceptionReason"`
}

// String returns the string representation
func (s HandshakeConstraintViolationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HandshakeConstraintViolationException) GoString() string {
	return s.String()
}

func newErrorHandshakeConstraintViolationException(v protocol.ResponseMetadata) error {
	return &HandshakeConstraintViolationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *HandshakeConstraintViolationException) Code() string {
	return "HandshakeConstraintViolationException"
}

// Message returns the exception's message.
func (s *HandshakeConstraintViolationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *HandshakeConstraintViolationException) OrigErr() error {
	return nil
}

func (s *HandshakeConstraintViolationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *HandshakeConstraintViolationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *HandshakeConstraintViolationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Specifies the criteria that are used to select the handshakes for the operation.
type HandshakeFilter struct {
	_ struct{} `type:"structure"`

	// Specifies the type of handshake action.
	//
	// If you specify ActionType, you cannot also specify ParentHandshakeId.
	ActionType *string `type:"string" enum:"ActionType"`

	// Specifies the parent handshake. Only used for handshake types that are a
	// child of another type.
	//
	// If you specify ParentHandshakeId, you cannot also specify ActionType.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for handshake ID string
	// requires "h-" followed by from 8 to 32 lower-case letters or digits.
	ParentHandshakeId *string `type:"string"`
}

// String returns the string representation
func (s HandshakeFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HandshakeFilter) GoString() string {
	return s.String()
}

// SetActionType sets the ActionType field's value.
func (s *HandshakeFilter) SetActionType(v string) *HandshakeFilter {
	s.ActionType = &v
	return s
}

// SetParentHandshakeId sets the ParentHandshakeId field's value.
func (s *HandshakeFilter) SetParentHandshakeId(v string) *HandshakeFilter {
	s.ParentHandshakeId = &v
	return s
}

// We can't find a handshake with the HandshakeId that you specified.
type HandshakeNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s HandshakeNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HandshakeNotFoundException) GoString() string {
	return s.String()
}

func newErrorHandshakeNotFoundException(v protocol.ResponseMetadata) error {
	return &HandshakeNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *HandshakeNotFoundException) Code() string {
	return "HandshakeNotFoundException"
}

// Message returns the exception's message.
func (s *HandshakeNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *HandshakeNotFoundException) OrigErr() error {
	return nil
}

func (s *HandshakeNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *HandshakeNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *HandshakeNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Identifies a participant in a handshake.
type HandshakeParty struct {
	_ struct{} `type:"structure"`

	// The unique identifier (ID) for the party.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for handshake ID string
	// requires "h-" followed by from 8 to 32 lower-case letters or digits.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// The type of party.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"HandshakePartyType"`
}

// String returns the string representation
func (s HandshakeParty) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HandshakeParty) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HandshakeParty) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HandshakeParty"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *HandshakeParty) SetId(v string) *HandshakeParty {
	s.Id = &v
	return s
}

// SetType sets the Type field's value.
func (s *HandshakeParty) SetType(v string) *HandshakeParty {
	s.Type = &v
	return s
}

// Contains additional data that is needed to process a handshake.
type HandshakeResource struct {
	_ struct{} `type:"structure"`

	// When needed, contains an additional array of HandshakeResource objects.
	Resources []*HandshakeResource `type:"list"`

	// The type of information being passed, specifying how the value is to be interpreted
	// by the other party:
	//
	//    * ACCOUNT - Specifies an AWS account ID number.
	//
	//    * ORGANIZATION - Specifies an organization ID number.
	//
	//    * EMAIL - Specifies the email address that is associated with the account
	//    that receives the handshake.
	//
	//    * OWNER_EMAIL - Specifies the email address associated with the master
	//    account. Included as information about an organization.
	//
	//    * OWNER_NAME - Specifies the name associated with the master account.
	//    Included as information about an organization.
	//
	//    * NOTES - Additional text provided by the handshake initiator and intended
	//    for the recipient to read.
	Type *string `type:"string" enum:"HandshakeResourceType"`

	// The information that is passed to the other party in the handshake. The format
	// of the value string must match the requirements of the specified type.
	Value *string `type:"string" sensitive:"true"`
}

// String returns the string representation
func (s HandshakeResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HandshakeResource) GoString() string {
	return s.String()
}

// SetResources sets the Resources field's value.
func (s *HandshakeResource) SetResources(v []*HandshakeResource) *HandshakeResource {
	s.Resources = v
	return s
}

// SetType sets the Type field's value.
func (s *HandshakeResource) SetType(v string) *HandshakeResource {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *HandshakeResource) SetValue(v string) *HandshakeResource {
	s.Value = &v
	return s
}

// You can't perform the operation on the handshake in its current state. For
// example, you can't cancel a handshake that was already accepted or accept
// a handshake that was already declined.
type InvalidHandshakeTransitionException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InvalidHandshakeTransitionException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidHandshakeTransitionException) GoString() string {
	return s.String()
}

func newErrorInvalidHandshakeTransitionException(v protocol.ResponseMetadata) error {
	return &InvalidHandshakeTransitionException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidHandshakeTransitionException) Code() string {
	return "InvalidHandshakeTransitionException"
}

// Message returns the exception's message.
func (s *InvalidHandshakeTransitionException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidHandshakeTransitionException) OrigErr() error {
	return nil
}

func (s *InvalidHandshakeTransitionException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidHandshakeTransitionException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidHandshakeTransitionException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The requested operation failed because you provided invalid values for one
// or more of the request parameters. This exception includes a reason that
// contains additional information about the violated limit:
//
// Some of the reasons in the following list might not be applicable to this
// specific API or operation.
//
//    * DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to
//    the same entity.
//
//    * IMMUTABLE_POLICY: You specified a policy that is managed by AWS and
//    can't be modified.
//
//    * INPUT_REQUIRED: You must include a value for all required parameters.
//
//    * INVALID_ENUM: You specified an invalid value.
//
//    * INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
//
//    * INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid
//    characters.
//
//    * INVALID_LIST_MEMBER: You provided a list to a parameter that contains
//    at least one invalid value.
//
//    * INVALID_PAGINATION_TOKEN: Get the value for the NextToken parameter
//    from the response to a previous call of the operation.
//
//    * INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account,
//    organization, or email) as a party.
//
//    * INVALID_PATTERN: You provided a value that doesn't match the required
//    pattern.
//
//    * INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't
//    match the required pattern.
//
//    * INVALID_ROLE_NAME: You provided a role name that isn't valid. A role
//    name can't begin with the reserved prefix AWSServiceRoleFor.
//
//    * INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource
//    Name (ARN) for the organization.
//
//    * INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
//
//    * INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system
//    tag. You can’t add, edit, or delete system tag keys because they're
//    reserved for AWS use. System tags don’t count against your tags per
//    resource limit.
//
//    * MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter
//    for the operation.
//
//    * MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer
//    than allowed.
//
//    * MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger
//    value than allowed.
//
//    * MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter
//    than allowed.
//
//    * MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller
//    value than allowed.
//
//    * MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only
//    between entities in the same root.
//
//    * TARGET_NOT_SUPPORTED: You can't perform the specified operation on that
//    target entity.
//
//    * UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that
//    isn't recognized.
type InvalidInputException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	Reason *string `type:"string" enum:"InvalidInputExceptionReason"`
}

// String returns the string representation
func (s InvalidInputException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidInputException) GoString() string {
	return s.String()
}

func newErrorInvalidInputException(v protocol.ResponseMetadata) error {
	return &InvalidInputException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidInputException) Code() string {
	return "InvalidInputException"
}

// Message returns the exception's message.
func (s *InvalidInputException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidInputException) OrigErr() error {
	return nil
}

func (s *InvalidInputException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidInputException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidInputException) RequestID() string {
	return s.RespMetadata.RequestID
}

type InviteAccountToOrganizationInput struct {
	_ struct{} `type:"structure"`

	// Additional information that you want to include in the generated email to
	// the recipient account owner.
	Notes *string `type:"string" sensitive:"true"`

	// A list of tags that you want to attach to the account when it becomes a member
	// of the organization. For each tag in the list, you must specify both a tag
	// key and a value. You can set the value to an empty string, but you can't
	// set it to null. For more information about tagging, see Tagging AWS Organizations
	// resources (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html)
	// in the AWS Organizations User Guide.
	//
	// Any tags in the request are checked for compliance with any applicable tag
	// policies when the request is made. The request is rejected if the tags in
	// the request don't match the requirements of the policy at that time. Tag
	// policy compliance is not checked again when the invitation is accepted and
	// the tags are actually attached to the account. That means that if the tag
	// policy changes between the invitation and the acceptance, then that tags
	// could potentially be non-compliant.
	//
	// If any one of the tags is invalid or if you exceed the allowed number of
	// tags for an account, then the entire request fails and invitations are not
	// sent.
	Tags []*Tag `type:"list"`

	// The identifier (ID) of the AWS account that you want to invite to join your
	// organization. This is a JSON object that contains the following elements:
	//
	// { "Type": "ACCOUNT", "Id": "< account id number >" }
	//
	// If you use the AWS CLI, you can submit this as a single string, similar to
	// the following example:
	//
	// --target Id=123456789012,Type=ACCOUNT
	//
	// If you specify "Type": "ACCOUNT", you must provide the AWS account ID number
	// as the Id. If you specify "Type": "EMAIL", you must specify the email address
	// that is associated with the account.
	//
	// --target Id=diego@example.com,Type=EMAIL
	//
	// Target is a required field
	Target *HandshakeParty `type:"structure" required:"true"`
}

// String returns the string representation
func (s InviteAccountToOrganizationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InviteAccountToOrganizationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InviteAccountToOrganizationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InviteAccountToOrganizationInput"}
	if s.Target == nil {
		invalidParams.Add(request.NewErrParamRequired("Target"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Target != nil {
		if err := s.Target.Validate(); err != nil {
			invalidParams.AddNested("Target", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNotes sets the Notes field's value.
func (s *InviteAccountToOrganizationInput) SetNotes(v string) *InviteAccountToOrganizationInput {
	s.Notes = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *InviteAccountToOrganizationInput) SetTags(v []*Tag) *InviteAccountToOrganizationInput {
	s.Tags = v
	return s
}

// SetTarget sets the Target field's value.
func (s *InviteAccountToOrganizationInput) SetTarget(v *HandshakeParty) *InviteAccountToOrganizationInput {
	s.Target = v
	return s
}

type InviteAccountToOrganizationOutput struct {
	_ struct{} `type:"structure"`

	// A structure that contains details about the handshake that is created to
	// support this invitation request.
	Handshake *Handshake `type:"structure"`
}

// String returns the string representation
func (s InviteAccountToOrganizationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InviteAccountToOrganizationOutput) GoString() string {
	return s.String()
}

// SetHandshake sets the Handshake field's value.
func (s *InviteAccountToOrganizationOutput) SetHandshake(v *Handshake) *InviteAccountToOrganizationOutput {
	s.Handshake = v
	return s
}

type LeaveOrganizationInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s LeaveOrganizationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LeaveOrganizationInput) GoString() string {
	return s.String()
}

type LeaveOrganizationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s LeaveOrganizationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LeaveOrganizationOutput) GoString() string {
	return s.String()
}

type ListAWSServiceAccessForOrganizationInput struct {
	_ struct{} `type:"structure"`

	// The total number of results that you want included on each page of the response.
	// If you do not include this parameter, it defaults to a value that is specific
	// to the operation. If additional items exist beyond the maximum you specify,
	// the NextToken response element is present and has a value (is not null).
	// Include that value as the NextToken request parameter in the next call to
	// the operation to get the next part of the results. Note that Organizations
	// might return fewer results than the maximum even when there are more results
	// available. You should check NextToken after every operation to ensure that
	// you receive all of the results.
	MaxResults *int64 `min:"1" type:"integer"`

	// The parameter for receiving additional results if you receive a NextToken
	// response in a previous request. A NextToken response indicates that more
	// output is available. Set this parameter to the value of the previous call's
	// NextToken response to indicate where the output should continue from.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListAWSServiceAccessForOrganizationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAWSServiceAccessForOrganizationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAWSServiceAccessForOrganizationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAWSServiceAccessForOrganizationInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAWSServiceAccessForOrganizationInput) SetMaxResults(v int64) *ListAWSServiceAccessForOrganizationInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAWSServiceAccessForOrganizationInput) SetNextToken(v string) *ListAWSServiceAccessForOrganizationInput {
	s.NextToken = &v
	return s
}

type ListAWSServiceAccessForOrganizationOutput struct {
	_ struct{} `type:"structure"`

	// A list of the service principals for the services that are enabled to integrate
	// with your organization. Each principal is a structure that includes the name
	// and the date that it was enabled for integration with AWS Organizations.
	EnabledServicePrincipals []*EnabledServicePrincipal `type:"list"`

	// If present, indicates that more output is available than is included in the
	// current response. Use this value in the NextToken request parameter in a
	// subsequent call to the operation to get the next part of the output. You
	// should repeat this until the NextToken response element comes back as null.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListAWSServiceAccessForOrganizationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAWSServiceAccessForOrganizationOutput) GoString() string {
	return s.String()
}

// SetEnabledServicePrincipals sets the EnabledServicePrincipals field's value.
func (s *ListAWSServiceAccessForOrganizationOutput) SetEnabledServicePrincipals(v []*EnabledServicePrincipal) *ListAWSServiceAccessForOrganizationOutput {
	s.EnabledServicePrincipals = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAWSServiceAccessForOrganizationOutput) SetNextToken(v string) *ListAWSServiceAccessForOrganizationOutput {
	s.NextToken = &v
	return s
}

type ListAccountsForParentInput struct {
	_ struct{} `type:"structure"`

	// The total number of results that you want included on each page of the response.
	// If you do not include this parameter, it defaults to a value that is specific
	// to the operation. If additional items exist beyond the maximum you specify,
	// the NextToken response element is present and has a value (is not null).
	// Include that value as the NextToken request parameter in the next call to
	// the operation to get the next part of the results. Note that Organizations
	// might return fewer results than the maximum even when there are more results
	// available. You should check NextToken after every operation to ensure that
	// you receive all of the results.
	MaxResults *int64 `min:"1" type:"integer"`

	// The parameter for receiving additional results if you receive a NextToken
	// response in a previous request. A NextToken response indicates that more
	// output is available. Set this parameter to the value of the previous call's
	// NextToken response to indicate where the output should continue from.
	NextToken *string `type:"string"`

	// The unique identifier (ID) for the parent root or organization unit (OU)
	// whose accounts you want to list.
	//
	// ParentId is a required field
	ParentId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ListAccountsForParentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAccountsForParentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAccountsForParentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAccountsForParentInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ParentId == nil {
		invalidParams.Add(request.NewErrParamRequired("ParentId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAccountsForParentInput) SetMaxResults(v int64) *ListAccountsForParentInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAccountsForParentInput) SetNextToken(v string) *ListAccountsForParentInput {
	s.NextToken = &v
	return s
}

// SetParentId sets the ParentId field's value.
func (s *ListAccountsForParentInput) SetParentId(v string) *ListAccountsForParentInput {
	s.ParentId = &v
	return s
}

type ListAccountsForParentOutput struct {
	_ struct{} `type:"structure"`

	// A list of the accounts in the specified root or OU.
	Accounts []*Account `type:"list"`

	// If present, indicates that more output is available than is included in the
	// current response. Use this value in the NextToken request parameter in a
	// subsequent call to the operation to get the next part of the output. You
	// should repeat this until the NextToken response element comes back as null.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListAccountsForParentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAccountsForParentOutput) GoString() string {
	return s.String()
}

// SetAccounts sets the Accounts field's value.
func (s *ListAccountsForParentOutput) SetAccounts(v []*Account) *ListAccountsForParentOutput {
	s.Accounts = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAccountsForParentOutput) SetNextToken(v string) *ListAccountsForParentOutput {
	s.NextToken = &v
	return s
}

type ListAccountsInput struct {
	_ struct{} `type:"structure"`

	// The total number of results that you want included on each page of the response.
	// If you do not include this parameter, it defaults to a value that is specific
	// to the operation. If additional items exist beyond the maximum you specify,
	// the NextToken response element is present and has a value (is not null).
	// Include that value as the NextToken request parameter in the next call to
	// the operation to get the next part of the results. Note that Organizations
	// might return fewer results than the maximum even when there are more results
	// available. You should check NextToken after every operation to ensure that
	// you receive all of the results.
	MaxResults *int64 `min:"1" type:"integer"`

	// The parameter for receiving additional results if you receive a NextToken
	// response in a previous request. A NextToken response indicates that more
	// output is available. Set this parameter to the value of the previous call's
	// NextToken response to indicate where the output should continue from.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListAccountsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAccountsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAccountsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAccountsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAccountsInput) SetMaxResults(v int64) *ListAccountsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAccountsInput) SetNextToken(v string) *ListAccountsInput {
	s.NextToken = &v
	return s
}

type ListAccountsOutput struct {
	_ struct{} `type:"structure"`

	// A list of objects in the organization.
	Accounts []*Account `type:"list"`

	// If present, indicates that more output is available than is included in the
	// current response. Use this value in the NextToken request parameter in a
	// subsequent call to the operation to get the next part of the output. You
	// should repeat this until the NextToken response element comes back as null.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListAccountsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAccountsOutput) GoString() string {
	return s.String()
}

// SetAccounts sets the Accounts field's value.
func (s *ListAccountsOutput) SetAccounts(v []*Account) *ListAccountsOutput {
	s.Accounts = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAccountsOutput) SetNextToken(v string) *ListAccountsOutput {
	s.NextToken = &v
	return s
}

type ListChildrenInput struct {
	_ struct{} `type:"structure"`

	// Filters the output to include only the specified child type.
	//
	// ChildType is a required field
	ChildType *string `type:"string" required:"true" enum:"ChildType"`

	// The total number of results that you want included on each page of the response.
	// If you do not include this parameter, it defaults to a value that is specific
	// to the operation. If additional items exist beyond the maximum you specify,
	// the NextToken response element is present and has a value (is not null).
	// Include that value as the NextToken request parameter in the next call to
	// the operation to get the next part of the results. Note that Organizations
	// might return fewer results than the maximum even when there are more results
	// available. You should check NextToken after every operation to ensure that
	// you receive all of the results.
	MaxResults *int64 `min:"1" type:"integer"`

	// The parameter for receiving additional results if you receive a NextToken
	// response in a previous request. A NextToken response indicates that more
	// output is available. Set this parameter to the value of the previous call's
	// NextToken response to indicate where the output should continue from.
	NextToken *string `type:"string"`

	// The unique identifier (ID) for the parent root or OU whose children you want
	// to list.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for a parent ID string
	// requires one of the following:
	//
	//    * Root - A string that begins with "r-" followed by from 4 to 32 lowercase
	//    letters or digits.
	//
	//    * Organizational unit (OU) - A string that begins with "ou-" followed
	//    by from 4 to 32 lowercase letters or digits (the ID of the root that the
	//    OU is in). This string is followed by a second "-" dash and from 8 to
	//    32 additional lowercase letters or digits.
	//
	// ParentId is a required field
	ParentId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ListChildrenInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListChildrenInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListChildrenInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListChildrenInput"}
	if s.ChildType == nil {
		invalidParams.Add(request.NewErrParamRequired("ChildType"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ParentId == nil {
		invalidParams.Add(request.NewErrParamRequired("ParentId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChildType sets the ChildType field's value.
func (s *ListChildrenInput) SetChildType(v string) *ListChildrenInput {
	s.ChildType = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListChildrenInput) SetMaxResults(v int64) *ListChildrenInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListChildrenInput) SetNextToken(v string) *ListChildrenInput {
	s.NextToken = &v
	return s
}

// SetParentId sets the ParentId field's value.
func (s *ListChildrenInput) SetParentId(v string) *ListChildrenInput {
	s.ParentId = &v
	return s
}

type ListChildrenOutput struct {
	_ struct{} `type:"structure"`

	// The list of children of the specified parent container.
	Children []*Child `type:"list"`

	// If present, indicates that more output is available than is included in the
	// current response. Use this value in the NextToken request parameter in a
	// subsequent call to the operation to get the next part of the output. You
	// should repeat this until the NextToken response element comes back as null.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListChildrenOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListChildrenOutput) GoString() string {
	return s.String()
}

// SetChildren sets the Children field's value.
func (s *ListChildrenOutput) SetChildren(v []*Child) *ListChildrenOutput {
	s.Children = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListChildrenOutput) SetNextToken(v string) *ListChildrenOutput {
	s.NextToken = &v
	return s
}

type ListCreateAccountStatusInput struct {
	_ struct{} `type:"structure"`

	// The total number of results that you want included on each page of the response.
	// If you do not include this parameter, it defaults to a value that is specific
	// to the operation. If additional items exist beyond the maximum you specify,
	// the NextToken response element is present and has a value (is not null).
	// Include that value as the NextToken request parameter in the next call to
	// the operation to get the next part of the results. Note that Organizations
	// might return fewer results than the maximum even when there are more results
	// available. You should check NextToken after every operation to ensure that
	// you receive all of the results.
	MaxResults *int64 `min:"1" type:"integer"`

	// The parameter for receiving additional results if you receive a NextToken
	// response in a previous request. A NextToken response indicates that more
	// output is available. Set this parameter to the value of the previous call's
	// NextToken response to indicate where the output should continue from.
	NextToken *string `type:"string"`

	// A list of one or more states that you want included in the response. If this
	// parameter isn't present, all requests are included in the response.
	States []*string `type:"list"`
}

// String returns the string representation
func (s ListCreateAccountStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListCreateAccountStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCreateAccountStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCreateAccountStatusInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListCreateAccountStatusInput) SetMaxResults(v int64) *ListCreateAccountStatusInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCreateAccountStatusInput) SetNextToken(v string) *ListCreateAccountStatusInput {
	s.NextToken = &v
	return s
}

// SetStates sets the States field's value.
func (s *ListCreateAccountStatusInput) SetStates(v []*string) *ListCreateAccountStatusInput {
	s.States = v
	return s
}

type ListCreateAccountStatusOutput struct {
	_ struct{} `type:"structure"`

	// A list of objects with details about the requests. Certain elements, such
	// as the accountId number, are present in the output only after the account
	// has been successfully created.
	CreateAccountStatuses []*CreateAccountStatus `type:"list"`

	// If present, indicates that more output is available than is included in the
	// current response. Use this value in the NextToken request parameter in a
	// subsequent call to the operation to get the next part of the output. You
	// should repeat this until the NextToken response element comes back as null.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListCreateAccountStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListCreateAccountStatusOutput) GoString() string {
	return s.String()
}

// SetCreateAccountStatuses sets the CreateAccountStatuses field's value.
func (s *ListCreateAccountStatusOutput) SetCreateAccountStatuses(v []*CreateAccountStatus) *ListCreateAccountStatusOutput {
	s.CreateAccountStatuses = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCreateAccountStatusOutput) SetNextToken(v string) *ListCreateAccountStatusOutput {
	s.NextToken = &v
	return s
}

type ListDelegatedAdministratorsInput struct {
	_ struct{} `type:"structure"`

	// The total number of results that you want included on each page of the response.
	// If you do not include this parameter, it defaults to a value that is specific
	// to the operation. If additional items exist beyond the maximum you specify,
	// the NextToken response element is present and has a value (is not null).
	// Include that value as the NextToken request parameter in the next call to
	// the operation to get the next part of the results. Note that Organizations
	// might return fewer results than the maximum even when there are more results
	// available. You should check NextToken after every operation to ensure that
	// you receive all of the results.
	MaxResults *int64 `min:"1" type:"integer"`

	// The parameter for receiving additional results if you receive a NextToken
	// response in a previous request. A NextToken response indicates that more
	// output is available. Set this parameter to the value of the previous call's
	// NextToken response to indicate where the output should continue from.
	NextToken *string `type:"string"`

	// Specifies a service principal name. If specified, then the operation lists
	// the delegated administrators only for the specified service.
	//
	// If you don't specify a service principal, the operation lists all delegated
	// administrators for all services in your organization.
	ServicePrincipal *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListDelegatedAdministratorsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDelegatedAdministratorsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDelegatedAdministratorsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDelegatedAdministratorsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ServicePrincipal != nil && len(*s.ServicePrincipal) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServicePrincipal", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDelegatedAdministratorsInput) SetMaxResults(v int64) *ListDelegatedAdministratorsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDelegatedAdministratorsInput) SetNextToken(v string) *ListDelegatedAdministratorsInput {
	s.NextToken = &v
	return s
}

// SetServicePrincipal sets the ServicePrincipal field's value.
func (s *ListDelegatedAdministratorsInput) SetServicePrincipal(v string) *ListDelegatedAdministratorsInput {
	s.ServicePrincipal = &v
	return s
}

type ListDelegatedAdministratorsOutput struct {
	_ struct{} `type:"structure"`

	// The list of delegated administrators in your organization.
	DelegatedAdministrators []*DelegatedAdministrator `type:"list"`

	// If present, indicates that more output is available than is included in the
	// current response. Use this value in the NextToken request parameter in a
	// subsequent call to the operation to get the next part of the output. You
	// should repeat this until the NextToken response element comes back as null.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListDelegatedAdministratorsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDelegatedAdministratorsOutput) GoString() string {
	return s.String()
}

// SetDelegatedAdministrators sets the DelegatedAdministrators field's value.
func (s *ListDelegatedAdministratorsOutput) SetDelegatedAdministrators(v []*DelegatedAdministrator) *ListDelegatedAdministratorsOutput {
	s.DelegatedAdministrators = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDelegatedAdministratorsOutput) SetNextToken(v string) *ListDelegatedAdministratorsOutput {
	s.NextToken = &v
	return s
}

type ListDelegatedServicesForAccountInput struct {
	_ struct{} `type:"structure"`

	// The account ID number of a delegated administrator account in the organization.
	//
	// AccountId is a required field
	AccountId *string `type:"string" required:"true"`

	// The total number of results that you want included on each page of the response.
	// If you do not include this parameter, it defaults to a value that is specific
	// to the operation. If additional items exist beyond the maximum you specify,
	// the NextToken response element is present and has a value (is not null).
	// Include that value as the NextToken request parameter in the next call to
	// the operation to get the next part of the results. Note that Organizations
	// might return fewer results than the maximum even when there are more results
	// available. You should check NextToken after every operation to ensure that
	// you receive all of the results.
	MaxResults *int64 `min:"1" type:"integer"`

	// The parameter for receiving additional results if you receive a NextToken
	// response in a previous request. A NextToken response indicates that more
	// output is available. Set this parameter to the value of the previous call's
	// NextToken response to indicate where the output should continue from.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListDelegatedServicesForAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDelegatedServicesForAccountInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDelegatedServicesForAccountInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDelegatedServicesForAccountInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *ListDelegatedServicesForAccountInput) SetAccountId(v string) *ListDelegatedServicesForAccountInput {
	s.AccountId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDelegatedServicesForAccountInput) SetMaxResults(v int64) *ListDelegatedServicesForAccountInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDelegatedServicesForAccountInput) SetNextToken(v string) *ListDelegatedServicesForAccountInput {
	s.NextToken = &v
	return s
}

type ListDelegatedServicesForAccountOutput struct {
	_ struct{} `type:"structure"`

	// The services for which the account is a delegated administrator.
	DelegatedServices []*DelegatedService `type:"list"`

	// If present, indicates that more output is available than is included in the
	// current response. Use this value in the NextToken request parameter in a
	// subsequent call to the operation to get the next part of the output. You
	// should repeat this until the NextToken response element comes back as null.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListDelegatedServicesForAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDelegatedServicesForAccountOutput) GoString() string {
	return s.String()
}

// SetDelegatedServices sets the DelegatedServices field's value.
func (s *ListDelegatedServicesForAccountOutput) SetDelegatedServices(v []*DelegatedService) *ListDelegatedServicesForAccountOutput {
	s.DelegatedServices = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDelegatedServicesForAccountOutput) SetNextToken(v string) *ListDelegatedServicesForAccountOutput {
	s.NextToken = &v
	return s
}

type ListHandshakesForAccountInput struct {
	_ struct{} `type:"structure"`

	// Filters the handshakes that you want included in the response. The default
	// is all types. Use the ActionType element to limit the output to only a specified
	// type, such as INVITE, ENABLE_ALL_FEATURES, or APPROVE_ALL_FEATURES. Alternatively,
	// for the ENABLE_ALL_FEATURES handshake that generates a separate child handshake
	// for each member account, you can specify ParentHandshakeId to see only the
	// handshakes that were generated by that parent request.
	Filter *HandshakeFilter `type:"structure"`

	// The total number of results that you want included on each page of the response.
	// If you do not include this parameter, it defaults to a value that is specific
	// to the operation. If additional items exist beyond the maximum you specify,
	// the NextToken response element is present and has a value (is not null).
	// Include that value as the NextToken request parameter in the next call to
	// the operation to get the next part of the results. Note that Organizations
	// might return fewer results than the maximum even when there are more results
	// available. You should check NextToken after every operation to ensure that
	// you receive all of the results.
	MaxResults *int64 `min:"1" type:"integer"`

	// The parameter for receiving additional results if you receive a NextToken
	// response in a previous request. A NextToken response indicates that more
	// output is available. Set this parameter to the value of the previous call's
	// NextToken response to indicate where the output should continue from.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListHandshakesForAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListHandshakesForAccountInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListHandshakesForAccountInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListHandshakesForAccountInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListHandshakesForAccountInput) SetFilter(v *HandshakeFilter) *ListHandshakesForAccountInput {
	s.Filter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListHandshakesForAccountInput) SetMaxResults(v int64) *ListHandshakesForAccountInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListHandshakesForAccountInput) SetNextToken(v string) *ListHandshakesForAccountInput {
	s.NextToken = &v
	return s
}

type ListHandshakesForAccountOutput struct {
	_ struct{} `type:"structure"`

	// A list of Handshake objects with details about each of the handshakes that
	// is associated with the specified account.
	Handshakes []*Handshake `type:"list"`

	// If present, indicates that more output is available than is included in the
	// current response. Use this value in the NextToken request parameter in a
	// subsequent call to the operation to get the next part of the output. You
	// should repeat this until the NextToken response element comes back as null.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListHandshakesForAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListHandshakesForAccountOutput) GoString() string {
	return s.String()
}

// SetHandshakes sets the Handshakes field's value.
func (s *ListHandshakesForAccountOutput) SetHandshakes(v []*Handshake) *ListHandshakesForAccountOutput {
	s.Handshakes = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListHandshakesForAccountOutput) SetNextToken(v string) *ListHandshakesForAccountOutput {
	s.NextToken = &v
	return s
}

type ListHandshakesForOrganizationInput struct {
	_ struct{} `type:"structure"`

	// A filter of the handshakes that you want included in the response. The default
	// is all types. Use the ActionType element to limit the output to only a specified
	// type, such as INVITE, ENABLE-ALL-FEATURES, or APPROVE-ALL-FEATURES. Alternatively,
	// for the ENABLE-ALL-FEATURES handshake that generates a separate child handshake
	// for each member account, you can specify the ParentHandshakeId to see only
	// the handshakes that were generated by that parent request.
	Filter *HandshakeFilter `type:"structure"`

	// The total number of results that you want included on each page of the response.
	// If you do not include this parameter, it defaults to a value that is specific
	// to the operation. If additional items exist beyond the maximum you specify,
	// the NextToken response element is present and has a value (is not null).
	// Include that value as the NextToken request parameter in the next call to
	// the operation to get the next part of the results. Note that Organizations
	// might return fewer results than the maximum even when there are more results
	// available. You should check NextToken after every operation to ensure that
	// you receive all of the results.
	MaxResults *int64 `min:"1" type:"integer"`

	// The parameter for receiving additional results if you receive a NextToken
	// response in a previous request. A NextToken response indicates that more
	// output is available. Set this parameter to the value of the previous call's
	// NextToken response to indicate where the output should continue from.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListHandshakesForOrganizationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListHandshakesForOrganizationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListHandshakesForOrganizationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListHandshakesForOrganizationInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListHandshakesForOrganizationInput) SetFilter(v *HandshakeFilter) *ListHandshakesForOrganizationInput {
	s.Filter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListHandshakesForOrganizationInput) SetMaxResults(v int64) *ListHandshakesForOrganizationInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListHandshakesForOrganizationInput) SetNextToken(v string) *ListHandshakesForOrganizationInput {
	s.NextToken = &v
	return s
}

type ListHandshakesForOrganizationOutput struct {
	_ struct{} `type:"structure"`

	// A list of Handshake objects with details about each of the handshakes that
	// are associated with an organization.
	Handshakes []*Handshake `type:"list"`

	// If present, indicates that more output is available than is included in the
	// current response. Use this value in the NextToken request parameter in a
	// subsequent call to the operation to get the next part of the output. You
	// should repeat this until the NextToken response element comes back as null.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListHandshakesForOrganizationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListHandshakesForOrganizationOutput) GoString() string {
	return s.String()
}

// SetHandshakes sets the Handshakes field's value.
func (s *ListHandshakesForOrganizationOutput) SetHandshakes(v []*Handshake) *ListHandshakesForOrganizationOutput {
	s.Handshakes = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListHandshakesForOrganizationOutput) SetNextToken(v string) *ListHandshakesForOrganizationOutput {
	s.NextToken = &v
	return s
}

type ListOrganizationalUnitsForParentInput struct {
	_ struct{} `type:"structure"`

	// The total number of results that you want included on each page of the response.
	// If you do not include this parameter, it defaults to a value that is specific
	// to the operation. If additional items exist beyond the maximum you specify,
	// the NextToken response element is present and has a value (is not null).
	// Include that value as the NextToken request parameter in the next call to
	// the operation to get the next part of the results. Note that Organizations
	// might return fewer results than the maximum even when there are more results
	// available. You should check NextToken after every operation to ensure that
	// you receive all of the results.
	MaxResults *int64 `min:"1" type:"integer"`

	// The parameter for receiving additional results if you receive a NextToken
	// response in a previous request. A NextToken response indicates that more
	// output is available. Set this parameter to the value of the previous call's
	// NextToken response to indicate where the output should continue from.
	NextToken *string `type:"string"`

	// The unique identifier (ID) of the root or OU whose child OUs you want to
	// list.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for a parent ID string
	// requires one of the following:
	//
	//    * Root - A string that begins with "r-" followed by from 4 to 32 lowercase
	//    letters or digits.
	//
	//    * Organizational unit (OU) - A string that begins with "ou-" followed
	//    by from 4 to 32 lowercase letters or digits (the ID of the root that the
	//    OU is in). This string is followed by a second "-" dash and from 8 to
	//    32 additional lowercase letters or digits.
	//
	// ParentId is a required field
	ParentId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ListOrganizationalUnitsForParentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListOrganizationalUnitsForParentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListOrganizationalUnitsForParentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListOrganizationalUnitsForParentInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ParentId == nil {
		invalidParams.Add(request.NewErrParamRequired("ParentId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListOrganizationalUnitsForParentInput) SetMaxResults(v int64) *ListOrganizationalUnitsForParentInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListOrganizationalUnitsForParentInput) SetNextToken(v string) *ListOrganizationalUnitsForParentInput {
	s.NextToken = &v
	return s
}

// SetParentId sets the ParentId field's value.
func (s *ListOrganizationalUnitsForParentInput) SetParentId(v string) *ListOrganizationalUnitsForParentInput {
	s.ParentId = &v
	return s
}

type ListOrganizationalUnitsForParentOutput struct {
	_ struct{} `type:"structure"`

	// If present, indicates that more output is available than is included in the
	// current response. Use this value in the NextToken request parameter in a
	// subsequent call to the operation to get the next part of the output. You
	// should repeat this until the NextToken response element comes back as null.
	NextToken *string `type:"string"`

	// A list of the OUs in the specified root or parent OU.
	OrganizationalUnits []*OrganizationalUnit `type:"list"`
}

// String returns the string representation
func (s ListOrganizationalUnitsForParentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListOrganizationalUnitsForParentOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListOrganizationalUnitsForParentOutput) SetNextToken(v string) *ListOrganizationalUnitsForParentOutput {
	s.NextToken = &v
	return s
}

// SetOrganizationalUnits sets the OrganizationalUnits field's value.
func (s *ListOrganizationalUnitsForParentOutput) SetOrganizationalUnits(v []*OrganizationalUnit) *ListOrganizationalUnitsForParentOutput {
	s.OrganizationalUnits = v
	return s
}

type ListParentsInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier (ID) of the OU or account whose parent containers you
	// want to list. Don't specify a root.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for a child ID string
	// requires one of the following:
	//
	//    * Account - A string that consists of exactly 12 digits.
	//
	//    * Organizational unit (OU) - A string that begins with "ou-" followed
	//    by from 4 to 32 lowercase letters or digits (the ID of the root that contains
	//    the OU). This string is followed by a second "-" dash and from 8 to 32
	//    additional lowercase letters or digits.
	//
	// ChildId is a required field
	ChildId *string `type:"string" required:"true"`

	// The total number of results that you want included on each page of the response.
	// If you do not include this parameter, it defaults to a value that is specific
	// to the operation. If additional items exist beyond the maximum you specify,
	// the NextToken response element is present and has a value (is not null).
	// Include that value as the NextToken request parameter in the next call to
	// the operation to get the next part of the results. Note that Organizations
	// might return fewer results than the maximum even when there are more results
	// available. You should check NextToken after every operation to ensure that
	// you receive all of the results.
	MaxResults *int64 `min:"1" type:"integer"`

	// The parameter for receiving additional results if you receive a NextToken
	// response in a previous request. A NextToken response indicates that more
	// output is available. Set this parameter to the value of the previous call's
	// NextToken response to indicate where the output should continue from.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListParentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListParentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListParentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListParentsInput"}
	if s.ChildId == nil {
		invalidParams.Add(request.NewErrParamRequired("ChildId"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChildId sets the ChildId field's value.
func (s *ListParentsInput) SetChildId(v string) *ListParentsInput {
	s.ChildId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListParentsInput) SetMaxResults(v int64) *ListParentsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListParentsInput) SetNextToken(v string) *ListParentsInput {
	s.NextToken = &v
	return s
}

type ListParentsOutput struct {
	_ struct{} `type:"structure"`

	// If present, indicates that more output is available than is included in the
	// current response. Use this value in the NextToken request parameter in a
	// subsequent call to the operation to get the next part of the output. You
	// should repeat this until the NextToken response element comes back as null.
	NextToken *string `type:"string"`

	// A list of parents for the specified child account or OU.
	Parents []*Parent `type:"list"`
}

// String returns the string representation
func (s ListParentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListParentsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListParentsOutput) SetNextToken(v string) *ListParentsOutput {
	s.NextToken = &v
	return s
}

// SetParents sets the Parents field's value.
func (s *ListParentsOutput) SetParents(v []*Parent) *ListParentsOutput {
	s.Parents = v
	return s
}

type ListPoliciesForTargetInput struct {
	_ struct{} `type:"structure"`

	// The type of policy that you want to include in the returned list. You must
	// specify one of the following values:
	//
	//    * AISERVICES_OPT_OUT_POLICY (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html)
	//
	//    * BACKUP_POLICY (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html)
	//
	//    * SERVICE_CONTROL_POLICY (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html)
	//
	//    * TAG_POLICY (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html)
	//
	// Filter is a required field
	Filter *string `type:"string" required:"true" enum:"PolicyType"`

	// The total number of results that you want included on each page of the response.
	// If you do not include this parameter, it defaults to a value that is specific
	// to the operation. If additional items exist beyond the maximum you specify,
	// the NextToken response element is present and has a value (is not null).
	// Include that value as the NextToken request parameter in the next call to
	// the operation to get the next part of the results. Note that Organizations
	// might return fewer results than the maximum even when there are more results
	// available. You should check NextToken after every operation to ensure that
	// you receive all of the results.
	MaxResults *int64 `min:"1" type:"integer"`

	// The parameter for receiving additional results if you receive a NextToken
	// response in a previous request. A NextToken response indicates that more
	// output is available. Set this parameter to the value of the previous call's
	// NextToken response to indicate where the output should continue from.
	NextToken *string `type:"string"`

	// The unique identifier (ID) of the root, organizational unit, or account whose
	// policies you want to list.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for a target ID string
	// requires one of the following:
	//
	//    * Root - A string that begins with "r-" followed by from 4 to 32 lowercase
	//    letters or digits.
	//
	//    * Account - A string that consists of exactly 12 digits.
	//
	//    * Organizational unit (OU) - A string that begins with "ou-" followed
	//    by from 4 to 32 lowercase letters or digits (the ID of the root that the
	//    OU is in). This string is followed by a second "-" dash and from 8 to
	//    32 additional lowercase letters or digits.
	//
	// TargetId is a required field
	TargetId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ListPoliciesForTargetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPoliciesForTargetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPoliciesForTargetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPoliciesForTargetInput"}
	if s.Filter == nil {
		invalidParams.Add(request.NewErrParamRequired("Filter"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.TargetId == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListPoliciesForTargetInput) SetFilter(v string) *ListPoliciesForTargetInput {
	s.Filter = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPoliciesForTargetInput) SetMaxResults(v int64) *ListPoliciesForTargetInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPoliciesForTargetInput) SetNextToken(v string) *ListPoliciesForTargetInput {
	s.NextToken = &v
	return s
}

// SetTargetId sets the TargetId field's value.
func (s *ListPoliciesForTargetInput) SetTargetId(v string) *ListPoliciesForTargetInput {
	s.TargetId = &v
	return s
}

type ListPoliciesForTargetOutput struct {
	_ struct{} `type:"structure"`

	// If present, indicates that more output is available than is included in the
	// current response. Use this value in the NextToken request parameter in a
	// subsequent call to the operation to get the next part of the output. You
	// should repeat this until the NextToken response element comes back as null.
	NextToken *string `type:"string"`

	// The list of policies that match the criteria in the request.
	Policies []*PolicySummary `type:"list"`
}

// String returns the string representation
func (s ListPoliciesForTargetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPoliciesForTargetOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPoliciesForTargetOutput) SetNextToken(v string) *ListPoliciesForTargetOutput {
	s.NextToken = &v
	return s
}

// SetPolicies sets the Policies field's value.
func (s *ListPoliciesForTargetOutput) SetPolicies(v []*PolicySummary) *ListPoliciesForTargetOutput {
	s.Policies = v
	return s
}

type ListPoliciesInput struct {
	_ struct{} `type:"structure"`

	// Specifies the type of policy that you want to include in the response. You
	// must specify one of the following values:
	//
	//    * AISERVICES_OPT_OUT_POLICY (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html)
	//
	//    * BACKUP_POLICY (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html)
	//
	//    * SERVICE_CONTROL_POLICY (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html)
	//
	//    * TAG_POLICY (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html)
	//
	// Filter is a required field
	Filter *string `type:"string" required:"true" enum:"PolicyType"`

	// The total number of results that you want included on each page of the response.
	// If you do not include this parameter, it defaults to a value that is specific
	// to the operation. If additional items exist beyond the maximum you specify,
	// the NextToken response element is present and has a value (is not null).
	// Include that value as the NextToken request parameter in the next call to
	// the operation to get the next part of the results. Note that Organizations
	// might return fewer results than the maximum even when there are more results
	// available. You should check NextToken after every operation to ensure that
	// you receive all of the results.
	MaxResults *int64 `min:"1" type:"integer"`

	// The parameter for receiving additional results if you receive a NextToken
	// response in a previous request. A NextToken response indicates that more
	// output is available. Set this parameter to the value of the previous call's
	// NextToken response to indicate where the output should continue from.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListPoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPoliciesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPoliciesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPoliciesInput"}
	if s.Filter == nil {
		invalidParams.Add(request.NewErrParamRequired("Filter"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListPoliciesInput) SetFilter(v string) *ListPoliciesInput {
	s.Filter = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPoliciesInput) SetMaxResults(v int64) *ListPoliciesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPoliciesInput) SetNextToken(v string) *ListPoliciesInput {
	s.NextToken = &v
	return s
}

type ListPoliciesOutput struct {
	_ struct{} `type:"structure"`

	// If present, indicates that more output is available than is included in the
	// current response. Use this value in the NextToken request parameter in a
	// subsequent call to the operation to get the next part of the output. You
	// should repeat this until the NextToken response element comes back as null.
	NextToken *string `type:"string"`

	// A list of policies that match the filter criteria in the request. The output
	// list doesn't include the policy contents. To see the content for a policy,
	// see DescribePolicy.
	Policies []*PolicySummary `type:"list"`
}

// String returns the string representation
func (s ListPoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPoliciesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPoliciesOutput) SetNextToken(v string) *ListPoliciesOutput {
	s.NextToken = &v
	return s
}

// SetPolicies sets the Policies field's value.
func (s *ListPoliciesOutput) SetPolicies(v []*PolicySummary) *ListPoliciesOutput {
	s.Policies = v
	return s
}

type ListRootsInput struct {
	_ struct{} `type:"structure"`

	// The total number of results that you want included on each page of the response.
	// If you do not include this parameter, it defaults to a value that is specific
	// to the operation. If additional items exist beyond the maximum you specify,
	// the NextToken response element is present and has a value (is not null).
	// Include that value as the NextToken request parameter in the next call to
	// the operation to get the next part of the results. Note that Organizations
	// might return fewer results than the maximum even when there are more results
	// available. You should check NextToken after every operation to ensure that
	// you receive all of the results.
	MaxResults *int64 `min:"1" type:"integer"`

	// The parameter for receiving additional results if you receive a NextToken
	// response in a previous request. A NextToken response indicates that more
	// output is available. Set this parameter to the value of the previous call's
	// NextToken response to indicate where the output should continue from.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListRootsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRootsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRootsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRootsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListRootsInput) SetMaxResults(v int64) *ListRootsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRootsInput) SetNextToken(v string) *ListRootsInput {
	s.NextToken = &v
	return s
}

type ListRootsOutput struct {
	_ struct{} `type:"structure"`

	// If present, indicates that more output is available than is included in the
	// current response. Use this value in the NextToken request parameter in a
	// subsequent call to the operation to get the next part of the output. You
	// should repeat this until the NextToken response element comes back as null.
	NextToken *string `type:"string"`

	// A list of roots that are defined in an organization.
	Roots []*Root `type:"list"`
}

// String returns the string representation
func (s ListRootsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRootsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRootsOutput) SetNextToken(v string) *ListRootsOutput {
	s.NextToken = &v
	return s
}

// SetRoots sets the Roots field's value.
func (s *ListRootsOutput) SetRoots(v []*Root) *ListRootsOutput {
	s.Roots = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The parameter for receiving additional results if you receive a NextToken
	// response in a previous request. A NextToken response indicates that more
	// output is available. Set this parameter to the value of the previous call's
	// NextToken response to indicate where the output should continue from.
	NextToken *string `type:"string"`

	// The ID of the resource with the tags to list.
	//
	// You can specify any of the following taggable resources.
	//
	//    * AWS account – specify the account ID number.
	//
	//    * Organizational unit – specify the OU ID that begins with ou- and looks
	//    similar to: ou-1a2b-34uvwxyz
	//
	//    * Root – specify the root ID that begins with r- and looks similar to:
	//    r-1a2b
	//
	//    * Policy – specify the policy ID that begins with p- andlooks similar
	//    to: p-12abcdefg3
	//
	// ResourceId is a required field
	ResourceId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsForResourceInput) SetNextToken(v string) *ListTagsForResourceInput {
	s.NextToken = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *ListTagsForResourceInput) SetResourceId(v string) *ListTagsForResourceInput {
	s.ResourceId = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// If present, indicates that more output is available than is included in the
	// current response. Use this value in the NextToken request parameter in a
	// subsequent call to the operation to get the next part of the output. You
	// should repeat this until the NextToken response element comes back as null.
	NextToken *string `type:"string"`

	// The tags that are assigned to the resource.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsForResourceOutput) SetNextToken(v string) *ListTagsForResourceOutput {
	s.NextToken = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type ListTargetsForPolicyInput struct {
	_ struct{} `type:"structure"`

	// The total number of results that you want included on each page of the response.
	// If you do not include this parameter, it defaults to a value that is specific
	// to the operation. If additional items exist beyond the maximum you specify,
	// the NextToken response element is present and has a value (is not null).
	// Include that value as the NextToken request parameter in the next call to
	// the operation to get the next part of the results. Note that Organizations
	// might return fewer results than the maximum even when there are more results
	// available. You should check NextToken after every operation to ensure that
	// you receive all of the results.
	MaxResults *int64 `min:"1" type:"integer"`

	// The parameter for receiving additional results if you receive a NextToken
	// response in a previous request. A NextToken response indicates that more
	// output is available. Set this parameter to the value of the previous call's
	// NextToken response to indicate where the output should continue from.
	NextToken *string `type:"string"`

	// The unique identifier (ID) of the policy whose attachments you want to know.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for a policy ID string
	// requires "p-" followed by from 8 to 128 lowercase or uppercase letters, digits,
	// or the underscore character (_).
	//
	// PolicyId is a required field
	PolicyId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ListTargetsForPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTargetsForPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTargetsForPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTargetsForPolicyInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.PolicyId == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTargetsForPolicyInput) SetMaxResults(v int64) *ListTargetsForPolicyInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTargetsForPolicyInput) SetNextToken(v string) *ListTargetsForPolicyInput {
	s.NextToken = &v
	return s
}

// SetPolicyId sets the PolicyId field's value.
func (s *ListTargetsForPolicyInput) SetPolicyId(v string) *ListTargetsForPolicyInput {
	s.PolicyId = &v
	return s
}

type ListTargetsForPolicyOutput struct {
	_ struct{} `type:"structure"`

	// If present, indicates that more output is available than is included in the
	// current response. Use this value in the NextToken request parameter in a
	// subsequent call to the operation to get the next part of the output. You
	// should repeat this until the NextToken response element comes back as null.
	NextToken *string `type:"string"`

	// A list of structures, each of which contains details about one of the entities
	// to which the specified policy is attached.
	Targets []*PolicyTargetSummary `type:"list"`
}

// String returns the string representation
func (s ListTargetsForPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTargetsForPolicyOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTargetsForPolicyOutput) SetNextToken(v string) *ListTargetsForPolicyOutput {
	s.NextToken = &v
	return s
}

// SetTargets sets the Targets field's value.
func (s *ListTargetsForPolicyOutput) SetTargets(v []*PolicyTargetSummary) *ListTargetsForPolicyOutput {
	s.Targets = v
	return s
}

// The provided policy document doesn't meet the requirements of the specified
// policy type. For example, the syntax might be incorrect. For details about
// service control policy syntax, see Service Control Policy Syntax (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_scp-syntax.html)
// in the AWS Organizations User Guide.
type MalformedPolicyDocumentException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s MalformedPolicyDocumentException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MalformedPolicyDocumentException) GoString() string {
	return s.String()
}

func newErrorMalformedPolicyDocumentException(v protocol.ResponseMetadata) error {
	return &MalformedPolicyDocumentException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *MalformedPolicyDocumentException) Code() string {
	return "MalformedPolicyDocumentException"
}

// Message returns the exception's message.
func (s *MalformedPolicyDocumentException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *MalformedPolicyDocumentException) OrigErr() error {
	return nil
}

func (s *MalformedPolicyDocumentException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *MalformedPolicyDocumentException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *MalformedPolicyDocumentException) RequestID() string {
	return s.RespMetadata.RequestID
}

// You can't remove a master account from an organization. If you want the master
// account to become a member account in another organization, you must first
// delete the current organization of the master account.
type MasterCannotLeaveOrganizationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s MasterCannotLeaveOrganizationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MasterCannotLeaveOrganizationException) GoString() string {
	return s.String()
}

func newErrorMasterCannotLeaveOrganizationException(v protocol.ResponseMetadata) error {
	return &MasterCannotLeaveOrganizationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *MasterCannotLeaveOrganizationException) Code() string {
	return "MasterCannotLeaveOrganizationException"
}

// Message returns the exception's message.
func (s *MasterCannotLeaveOrganizationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *MasterCannotLeaveOrganizationException) OrigErr() error {
	return nil
}

func (s *MasterCannotLeaveOrganizationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *MasterCannotLeaveOrganizationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *MasterCannotLeaveOrganizationException) RequestID() string {
	return s.RespMetadata.RequestID
}

type MoveAccountInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier (ID) of the account that you want to move.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for an account ID string
	// requires exactly 12 digits.
	//
	// AccountId is a required field
	AccountId *string `type:"string" required:"true"`

	// The unique identifier (ID) of the root or organizational unit that you want
	// to move the account to.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for a parent ID string
	// requires one of the following:
	//
	//    * Root - A string that begins with "r-" followed by from 4 to 32 lowercase
	//    letters or digits.
	//
	//    * Organizational unit (OU) - A string that begins with "ou-" followed
	//    by from 4 to 32 lowercase letters or digits (the ID of the root that the
	//    OU is in). This string is followed by a second "-" dash and from 8 to
	//    32 additional lowercase letters or digits.
	//
	// DestinationParentId is a required field
	DestinationParentId *string `type:"string" required:"true"`

	// The unique identifier (ID) of the root or organizational unit that you want
	// to move the account from.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for a parent ID string
	// requires one of the following:
	//
	//    * Root - A string that begins with "r-" followed by from 4 to 32 lowercase
	//    letters or digits.
	//
	//    * Organizational unit (OU) - A string that begins with "ou-" followed
	//    by from 4 to 32 lowercase letters or digits (the ID of the root that the
	//    OU is in). This string is followed by a second "-" dash and from 8 to
	//    32 additional lowercase letters or digits.
	//
	// SourceParentId is a required field
	SourceParentId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s MoveAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MoveAccountInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MoveAccountInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MoveAccountInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.DestinationParentId == nil {
		invalidParams.Add(request.NewErrParamRequired("DestinationParentId"))
	}
	if s.SourceParentId == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceParentId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *MoveAccountInput) SetAccountId(v string) *MoveAccountInput {
	s.AccountId = &v
	return s
}

// SetDestinationParentId sets the DestinationParentId field's value.
func (s *MoveAccountInput) SetDestinationParentId(v string) *MoveAccountInput {
	s.DestinationParentId = &v
	return s
}

// SetSourceParentId sets the SourceParentId field's value.
func (s *MoveAccountInput) SetSourceParentId(v string) *MoveAccountInput {
	s.SourceParentId = &v
	return s
}

type MoveAccountOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s MoveAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MoveAccountOutput) GoString() string {
	return s.String()
}

// Contains details about an organization. An organization is a collection of
// accounts that are centrally managed together using consolidated billing,
// organized hierarchically with organizational units (OUs), and controlled
// with policies .
type Organization struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of an organization.
	//
	// For more information about ARNs in Organizations, see ARN Formats Supported
	// by Organizations (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_permissions.html#orgs-permissions-arns)
	// in the AWS Organizations User Guide.
	Arn *string `type:"string"`

	//
	// Do not use. This field is deprecated and doesn't provide complete information
	// about the policies in your organization.
	//
	// To determine the policies that are enabled and available for use in your
	// organization, use the ListRoots operation instead.
	AvailablePolicyTypes []*PolicyTypeSummary `type:"list"`

	// Specifies the functionality that currently is available to the organization.
	// If set to "ALL", then all features are enabled and policies can be applied
	// to accounts in the organization. If set to "CONSOLIDATED_BILLING", then only
	// consolidated billing functionality is available. For more information, see
	// Enabling All Features in Your Organization (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html)
	// in the AWS Organizations User Guide.
	FeatureSet *string `type:"string" enum:"OrganizationFeatureSet"`

	// The unique identifier (ID) of an organization.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for an organization ID
	// string requires "o-" followed by from 10 to 32 lower-case letters or digits.
	Id *string `type:"string"`

	// The Amazon Resource Name (ARN) of the account that is designated as the master
	// account for the organization.
	//
	// For more information about ARNs in Organizations, see ARN Formats Supported
	// by Organizations (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_permissions.html#orgs-permissions-arns)
	// in the AWS Organizations User Guide.
	MasterAccountArn *string `type:"string"`

	// The email address that is associated with the AWS account that is designated
	// as the master account for the organization.
	MasterAccountEmail *string `min:"6" type:"string" sensitive:"true"`

	// The unique identifier (ID) of the master account of an organization.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for an account ID string
	// requires exactly 12 digits.
	MasterAccountId *string `type:"string"`
}

// String returns the string representation
func (s Organization) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Organization) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Organization) SetArn(v string) *Organization {
	s.Arn = &v
	return s
}

// SetAvailablePolicyTypes sets the AvailablePolicyTypes field's value.
func (s *Organization) SetAvailablePolicyTypes(v []*PolicyTypeSummary) *Organization {
	s.AvailablePolicyTypes = v
	return s
}

// SetFeatureSet sets the FeatureSet field's value.
func (s *Organization) SetFeatureSet(v string) *Organization {
	s.FeatureSet = &v
	return s
}

// SetId sets the Id field's value.
func (s *Organization) SetId(v string) *Organization {
	s.Id = &v
	return s
}

// SetMasterAccountArn sets the MasterAccountArn field's value.
func (s *Organization) SetMasterAccountArn(v string) *Organization {
	s.MasterAccountArn = &v
	return s
}

// SetMasterAccountEmail sets the MasterAccountEmail field's value.
func (s *Organization) SetMasterAccountEmail(v string) *Organization {
	s.MasterAccountEmail = &v
	return s
}

// SetMasterAccountId sets the MasterAccountId field's value.
func (s *Organization) SetMasterAccountId(v string) *Organization {
	s.MasterAccountId = &v
	return s
}

// The organization isn't empty. To delete an organization, you must first remove
// all accounts except the master account, delete all OUs, and delete all policies.
type OrganizationNotEmptyException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s OrganizationNotEmptyException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OrganizationNotEmptyException) GoString() string {
	return s.String()
}

func newErrorOrganizationNotEmptyException(v protocol.ResponseMetadata) error {
	return &OrganizationNotEmptyException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *OrganizationNotEmptyException) Code() string {
	return "OrganizationNotEmptyException"
}

// Message returns the exception's message.
func (s *OrganizationNotEmptyException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *OrganizationNotEmptyException) OrigErr() error {
	return nil
}

func (s *OrganizationNotEmptyException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *OrganizationNotEmptyException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *OrganizationNotEmptyException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains details about an organizational unit (OU). An OU is a container
// of AWS accounts within a root of an organization. Policies that are attached
// to an OU apply to all accounts contained in that OU and in any child OUs.
type OrganizationalUnit struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of this OU.
	//
	// For more information about ARNs in Organizations, see ARN Formats Supported
	// by Organizations (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_permissions.html#orgs-permissions-arns)
	// in the AWS Organizations User Guide.
	Arn *string `type:"string"`

	// The unique identifier (ID) associated with this OU.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for an organizational
	// unit ID string requires "ou-" followed by from 4 to 32 lower-case letters
	// or digits (the ID of the root that contains the OU). This string is followed
	// by a second "-" dash and from 8 to 32 additional lower-case letters or digits.
	Id *string `type:"string"`

	// The friendly name of this OU.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) that is used to validate
	// this parameter is a string of any of the characters in the ASCII character
	// range.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s OrganizationalUnit) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OrganizationalUnit) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *OrganizationalUnit) SetArn(v string) *OrganizationalUnit {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *OrganizationalUnit) SetId(v string) *OrganizationalUnit {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *OrganizationalUnit) SetName(v string) *OrganizationalUnit {
	s.Name = &v
	return s
}

// The specified OU is not empty. Move all accounts to another root or to other
// OUs, remove all child OUs, and try the operation again.
type OrganizationalUnitNotEmptyException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s OrganizationalUnitNotEmptyException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OrganizationalUnitNotEmptyException) GoString() string {
	return s.String()
}

func newErrorOrganizationalUnitNotEmptyException(v protocol.ResponseMetadata) error {
	return &OrganizationalUnitNotEmptyException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *OrganizationalUnitNotEmptyException) Code() string {
	return "OrganizationalUnitNotEmptyException"
}

// Message returns the exception's message.
func (s *OrganizationalUnitNotEmptyException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *OrganizationalUnitNotEmptyException) OrigErr() error {
	return nil
}

func (s *OrganizationalUnitNotEmptyException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *OrganizationalUnitNotEmptyException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *OrganizationalUnitNotEmptyException) RequestID() string {
	return s.RespMetadata.RequestID
}

// We can't find an OU with the OrganizationalUnitId that you specified.
type OrganizationalUnitNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s OrganizationalUnitNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OrganizationalUnitNotFoundException) GoString() string {
	return s.String()
}

func newErrorOrganizationalUnitNotFoundException(v protocol.ResponseMetadata) error {
	return &OrganizationalUnitNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *OrganizationalUnitNotFoundException) Code() string {
	return "OrganizationalUnitNotFoundException"
}

// Message returns the exception's message.
func (s *OrganizationalUnitNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *OrganizationalUnitNotFoundException) OrigErr() error {
	return nil
}

func (s *OrganizationalUnitNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *OrganizationalUnitNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *OrganizationalUnitNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains information about either a root or an organizational unit (OU) that
// can contain OUs or accounts in an organization.
type Parent struct {
	_ struct{} `type:"structure"`

	// The unique identifier (ID) of the parent entity.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for a parent ID string
	// requires one of the following:
	//
	//    * Root: A string that begins with "r-" followed by from 4 to 32 lower-case
	//    letters or digits.
	//
	//    * Organizational unit (OU): A string that begins with "ou-" followed by
	//    from 4 to 32 lower-case letters or digits (the ID of the root that the
	//    OU is in). This string is followed by a second "-" dash and from 8 to
	//    32 additional lower-case letters or digits.
	Id *string `type:"string"`

	// The type of the parent entity.
	Type *string `type:"string" enum:"ParentType"`
}

// String returns the string representation
func (s Parent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Parent) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *Parent) SetId(v string) *Parent {
	s.Id = &v
	return s
}

// SetType sets the Type field's value.
func (s *Parent) SetType(v string) *Parent {
	s.Type = &v
	return s
}

// We can't find a root or OU with the ParentId that you specified.
type ParentNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ParentNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ParentNotFoundException) GoString() string {
	return s.String()
}

func newErrorParentNotFoundException(v protocol.ResponseMetadata) error {
	return &ParentNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ParentNotFoundException) Code() string {
	return "ParentNotFoundException"
}

// Message returns the exception's message.
func (s *ParentNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ParentNotFoundException) OrigErr() error {
	return nil
}

func (s *ParentNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ParentNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ParentNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains rules to be applied to the affected accounts. Policies can be attached
// directly to accounts, or to roots and OUs to affect all accounts in those
// hierarchies.
type Policy struct {
	_ struct{} `type:"structure"`

	// The text content of the policy.
	Content *string `min:"1" type:"string"`

	// A structure that contains additional details about the policy.
	PolicySummary *PolicySummary `type:"structure"`
}

// String returns the string representation
func (s Policy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Policy) GoString() string {
	return s.String()
}

// SetContent sets the Content field's value.
func (s *Policy) SetContent(v string) *Policy {
	s.Content = &v
	return s
}

// SetPolicySummary sets the PolicySummary field's value.
func (s *Policy) SetPolicySummary(v *PolicySummary) *Policy {
	s.PolicySummary = v
	return s
}

// Changes to the effective policy are in progress, and its contents can't be
// returned. Try the operation again later.
type PolicyChangesInProgressException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s PolicyChangesInProgressException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PolicyChangesInProgressException) GoString() string {
	return s.String()
}

func newErrorPolicyChangesInProgressException(v protocol.ResponseMetadata) error {
	return &PolicyChangesInProgressException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *PolicyChangesInProgressException) Code() string {
	return "PolicyChangesInProgressException"
}

// Message returns the exception's message.
func (s *PolicyChangesInProgressException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *PolicyChangesInProgressException) OrigErr() error {
	return nil
}

func (s *PolicyChangesInProgressException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *PolicyChangesInProgressException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *PolicyChangesInProgressException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The policy is attached to one or more entities. You must detach it from all
// roots, OUs, and accounts before performing this operation.
type PolicyInUseException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s PolicyInUseException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PolicyInUseException) GoString() string {
	return s.String()
}

func newErrorPolicyInUseException(v protocol.ResponseMetadata) error {
	return &PolicyInUseException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *PolicyInUseException) Code() string {
	return "PolicyInUseException"
}

// Message returns the exception's message.
func (s *PolicyInUseException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *PolicyInUseException) OrigErr() error {
	return nil
}

func (s *PolicyInUseException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *PolicyInUseException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *PolicyInUseException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The policy isn't attached to the specified target in the specified root.
type PolicyNotAttachedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s PolicyNotAttachedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PolicyNotAttachedException) GoString() string {
	return s.String()
}

func newErrorPolicyNotAttachedException(v protocol.ResponseMetadata) error {
	return &PolicyNotAttachedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *PolicyNotAttachedException) Code() string {
	return "PolicyNotAttachedException"
}

// Message returns the exception's message.
func (s *PolicyNotAttachedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *PolicyNotAttachedException) OrigErr() error {
	return nil
}

func (s *PolicyNotAttachedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *PolicyNotAttachedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *PolicyNotAttachedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// We can't find a policy with the PolicyId that you specified.
type PolicyNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s PolicyNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PolicyNotFoundException) GoString() string {
	return s.String()
}

func newErrorPolicyNotFoundException(v protocol.ResponseMetadata) error {
	return &PolicyNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *PolicyNotFoundException) Code() string {
	return "PolicyNotFoundException"
}

// Message returns the exception's message.
func (s *PolicyNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *PolicyNotFoundException) OrigErr() error {
	return nil
}

func (s *PolicyNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *PolicyNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *PolicyNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains information about a policy, but does not include the content. To
// see the content of a policy, see DescribePolicy.
type PolicySummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the policy.
	//
	// For more information about ARNs in Organizations, see ARN Formats Supported
	// by Organizations (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_permissions.html#orgs-permissions-arns)
	// in the AWS Organizations User Guide.
	Arn *string `type:"string"`

	// A boolean value that indicates whether the specified policy is an AWS managed
	// policy. If true, then you can attach the policy to roots, OUs, or accounts,
	// but you cannot edit it.
	AwsManaged *bool `type:"boolean"`

	// The description of the policy.
	Description *string `type:"string"`

	// The unique identifier (ID) of the policy.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for a policy ID string
	// requires "p-" followed by from 8 to 128 lower-case letters or digits.
	Id *string `type:"string"`

	// The friendly name of the policy.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) that is used to validate
	// this parameter is a string of any of the characters in the ASCII character
	// range.
	Name *string `min:"1" type:"string"`

	// The type of policy.
	Type *string `type:"string" enum:"PolicyType"`
}

// String returns the string representation
func (s PolicySummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PolicySummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *PolicySummary) SetArn(v string) *PolicySummary {
	s.Arn = &v
	return s
}

// SetAwsManaged sets the AwsManaged field's value.
func (s *PolicySummary) SetAwsManaged(v bool) *PolicySummary {
	s.AwsManaged = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *PolicySummary) SetDescription(v string) *PolicySummary {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *PolicySummary) SetId(v string) *PolicySummary {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *PolicySummary) SetName(v string) *PolicySummary {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *PolicySummary) SetType(v string) *PolicySummary {
	s.Type = &v
	return s
}

// Contains information about a root, OU, or account that a policy is attached
// to.
type PolicyTargetSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the policy target.
	//
	// For more information about ARNs in Organizations, see ARN Formats Supported
	// by Organizations (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_permissions.html#orgs-permissions-arns)
	// in the AWS Organizations User Guide.
	Arn *string `type:"string"`

	// The friendly name of the policy target.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) that is used to validate
	// this parameter is a string of any of the characters in the ASCII character
	// range.
	Name *string `min:"1" type:"string"`

	// The unique identifier (ID) of the policy target.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for a target ID string
	// requires one of the following:
	//
	//    * Root: A string that begins with "r-" followed by from 4 to 32 lower-case
	//    letters or digits.
	//
	//    * Account: A string that consists of exactly 12 digits.
	//
	//    * Organizational unit (OU): A string that begins with "ou-" followed by
	//    from 4 to 32 lower-case letters or digits (the ID of the root that the
	//    OU is in). This string is followed by a second "-" dash and from 8 to
	//    32 additional lower-case letters or digits.
	TargetId *string `type:"string"`

	// The type of the policy target.
	Type *string `type:"string" enum:"TargetType"`
}

// String returns the string representation
func (s PolicyTargetSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PolicyTargetSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *PolicyTargetSummary) SetArn(v string) *PolicyTargetSummary {
	s.Arn = &v
	return s
}

// SetName sets the Name field's value.
func (s *PolicyTargetSummary) SetName(v string) *PolicyTargetSummary {
	s.Name = &v
	return s
}

// SetTargetId sets the TargetId field's value.
func (s *PolicyTargetSummary) SetTargetId(v string) *PolicyTargetSummary {
	s.TargetId = &v
	return s
}

// SetType sets the Type field's value.
func (s *PolicyTargetSummary) SetType(v string) *PolicyTargetSummary {
	s.Type = &v
	return s
}

// The specified policy type is already enabled in the specified root.
type PolicyTypeAlreadyEnabledException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s PolicyTypeAlreadyEnabledException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PolicyTypeAlreadyEnabledException) GoString() string {
	return s.String()
}

func newErrorPolicyTypeAlreadyEnabledException(v protocol.ResponseMetadata) error {
	return &PolicyTypeAlreadyEnabledException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *PolicyTypeAlreadyEnabledException) Code() string {
	return "PolicyTypeAlreadyEnabledException"
}

// Message returns the exception's message.
func (s *PolicyTypeAlreadyEnabledException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *PolicyTypeAlreadyEnabledException) OrigErr() error {
	return nil
}

func (s *PolicyTypeAlreadyEnabledException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *PolicyTypeAlreadyEnabledException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *PolicyTypeAlreadyEnabledException) RequestID() string {
	return s.RespMetadata.RequestID
}

// You can't use the specified policy type with the feature set currently enabled
// for this organization. For example, you can enable SCPs only after you enable
// all features in the organization. For more information, see Managing AWS
// Organizations Policies (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies.html#enable_policies_on_root)in
// the AWS Organizations User Guide.
type PolicyTypeNotAvailableForOrganizationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s PolicyTypeNotAvailableForOrganizationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PolicyTypeNotAvailableForOrganizationException) GoString() string {
	return s.String()
}

func newErrorPolicyTypeNotAvailableForOrganizationException(v protocol.ResponseMetadata) error {
	return &PolicyTypeNotAvailableForOrganizationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *PolicyTypeNotAvailableForOrganizationException) Code() string {
	return "PolicyTypeNotAvailableForOrganizationException"
}

// Message returns the exception's message.
func (s *PolicyTypeNotAvailableForOrganizationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *PolicyTypeNotAvailableForOrganizationException) OrigErr() error {
	return nil
}

func (s *PolicyTypeNotAvailableForOrganizationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *PolicyTypeNotAvailableForOrganizationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *PolicyTypeNotAvailableForOrganizationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified policy type isn't currently enabled in this root. You can't
// attach policies of the specified type to entities in a root until you enable
// that type in the root. For more information, see Enabling All Features in
// Your Organization (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html)
// in the AWS Organizations User Guide.
type PolicyTypeNotEnabledException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s PolicyTypeNotEnabledException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PolicyTypeNotEnabledException) GoString() string {
	return s.String()
}

func newErrorPolicyTypeNotEnabledException(v protocol.ResponseMetadata) error {
	return &PolicyTypeNotEnabledException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *PolicyTypeNotEnabledException) Code() string {
	return "PolicyTypeNotEnabledException"
}

// Message returns the exception's message.
func (s *PolicyTypeNotEnabledException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *PolicyTypeNotEnabledException) OrigErr() error {
	return nil
}

func (s *PolicyTypeNotEnabledException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *PolicyTypeNotEnabledException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *PolicyTypeNotEnabledException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains information about a policy type and its status in the associated
// root.
type PolicyTypeSummary struct {
	_ struct{} `type:"structure"`

	// The status of the policy type as it relates to the associated root. To attach
	// a policy of the specified type to a root or to an OU or account in that root,
	// it must be available in the organization and enabled for that root.
	Status *string `type:"string" enum:"PolicyTypeStatus"`

	// The name of the policy type.
	Type *string `type:"string" enum:"PolicyType"`
}

// String returns the string representation
func (s PolicyTypeSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PolicyTypeSummary) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *PolicyTypeSummary) SetStatus(v string) *PolicyTypeSummary {
	s.Status = &v
	return s
}

// SetType sets the Type field's value.
func (s *PolicyTypeSummary) SetType(v string) *PolicyTypeSummary {
	s.Type = &v
	return s
}

type RegisterDelegatedAdministratorInput struct {
	_ struct{} `type:"structure"`

	// The account ID number of the member account in the organization to register
	// as a delegated administrator.
	//
	// AccountId is a required field
	AccountId *string `type:"string" required:"true"`

	// The service principal of the AWS service for which you want to make the member
	// account a delegated administrator.
	//
	// ServicePrincipal is a required field
	ServicePrincipal *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RegisterDelegatedAdministratorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterDelegatedAdministratorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegisterDelegatedAdministratorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RegisterDelegatedAdministratorInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.ServicePrincipal == nil {
		invalidParams.Add(request.NewErrParamRequired("ServicePrincipal"))
	}
	if s.ServicePrincipal != nil && len(*s.ServicePrincipal) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServicePrincipal", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *RegisterDelegatedAdministratorInput) SetAccountId(v string) *RegisterDelegatedAdministratorInput {
	s.AccountId = &v
	return s
}

// SetServicePrincipal sets the ServicePrincipal field's value.
func (s *RegisterDelegatedAdministratorInput) SetServicePrincipal(v string) *RegisterDelegatedAdministratorInput {
	s.ServicePrincipal = &v
	return s
}

type RegisterDelegatedAdministratorOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RegisterDelegatedAdministratorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterDelegatedAdministratorOutput) GoString() string {
	return s.String()
}

type RemoveAccountFromOrganizationInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier (ID) of the member account that you want to remove
	// from the organization.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for an account ID string
	// requires exactly 12 digits.
	//
	// AccountId is a required field
	AccountId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RemoveAccountFromOrganizationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveAccountFromOrganizationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveAccountFromOrganizationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveAccountFromOrganizationInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *RemoveAccountFromOrganizationInput) SetAccountId(v string) *RemoveAccountFromOrganizationInput {
	s.AccountId = &v
	return s
}

type RemoveAccountFromOrganizationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RemoveAccountFromOrganizationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveAccountFromOrganizationOutput) GoString() string {
	return s.String()
}

// Contains details about a root. A root is a top-level parent node in the hierarchy
// of an organization that can contain organizational units (OUs) and accounts.
// Every root contains every AWS account in the organization. Each root enables
// the accounts to be organized in a different way and to have different policy
// types enabled for use in that root.
type Root struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the root.
	//
	// For more information about ARNs in Organizations, see ARN Formats Supported
	// by Organizations (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_permissions.html#orgs-permissions-arns)
	// in the AWS Organizations User Guide.
	Arn *string `type:"string"`

	// The unique identifier (ID) for the root.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for a root ID string
	// requires "r-" followed by from 4 to 32 lower-case letters or digits.
	Id *string `type:"string"`

	// The friendly name of the root.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) that is used to validate
	// this parameter is a string of any of the characters in the ASCII character
	// range.
	Name *string `min:"1" type:"string"`

	// The types of policies that are currently enabled for the root and therefore
	// can be attached to the root or to its OUs or accounts.
	//
	// Even if a policy type is shown as available in the organization, you can
	// separately enable and disable them at the root level by using EnablePolicyType
	// and DisablePolicyType. Use DescribeOrganization to see the availability of
	// the policy types in that organization.
	PolicyTypes []*PolicyTypeSummary `type:"list"`
}

// String returns the string representation
func (s Root) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Root) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Root) SetArn(v string) *Root {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *Root) SetId(v string) *Root {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *Root) SetName(v string) *Root {
	s.Name = &v
	return s
}

// SetPolicyTypes sets the PolicyTypes field's value.
func (s *Root) SetPolicyTypes(v []*PolicyTypeSummary) *Root {
	s.PolicyTypes = v
	return s
}

// We can't find a root with the RootId that you specified.
type RootNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s RootNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RootNotFoundException) GoString() string {
	return s.String()
}

func newErrorRootNotFoundException(v protocol.ResponseMetadata) error {
	return &RootNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *RootNotFoundException) Code() string {
	return "RootNotFoundException"
}

// Message returns the exception's message.
func (s *RootNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *RootNotFoundException) OrigErr() error {
	return nil
}

func (s *RootNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *RootNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *RootNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// AWS Organizations can't complete your request because of an internal service
// error. Try again later.
type ServiceException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ServiceException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceException) GoString() string {
	return s.String()
}

func newErrorServiceException(v protocol.ResponseMetadata) error {
	return &ServiceException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceException) Code() string {
	return "ServiceException"
}

// Message returns the exception's message.
func (s *ServiceException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceException) OrigErr() error {
	return nil
}

func (s *ServiceException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceException) RequestID() string {
	return s.RespMetadata.RequestID
}

// We can't find a source root or OU with the ParentId that you specified.
type SourceParentNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s SourceParentNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SourceParentNotFoundException) GoString() string {
	return s.String()
}

func newErrorSourceParentNotFoundException(v protocol.ResponseMetadata) error {
	return &SourceParentNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *SourceParentNotFoundException) Code() string {
	return "SourceParentNotFoundException"
}

// Message returns the exception's message.
func (s *SourceParentNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *SourceParentNotFoundException) OrigErr() error {
	return nil
}

func (s *SourceParentNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *SourceParentNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *SourceParentNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A custom key-value pair associated with a resource within your organization.
//
// You can attach tags to any of the following organization resources.
//
//    * AWS account
//
//    * Organizational unit (OU)
//
//    * Organization root
//
//    * Policy
type Tag struct {
	_ struct{} `type:"structure"`

	// The key identifier, or name, of the tag.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The string value that's associated with the key of the tag. You can set the
	// value of a tag to an empty string, but you can't set the value of a tag to
	// null.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ID of the resource to add a tag to.
	//
	// ResourceId is a required field
	ResourceId *string `type:"string" required:"true"`

	// A list of tags to add to the specified resource.
	//
	// You can specify any of the following taggable resources.
	//
	//    * AWS account – specify the account ID number.
	//
	//    * Organizational unit – specify the OU ID that begins with ou- and looks
	//    similar to: ou-1a2b-34uvwxyz
	//
	//    * Root – specify the root ID that begins with r- and looks similar to:
	//    r-1a2b
	//
	//    * Policy – specify the policy ID that begins with p- andlooks similar
	//    to: p-12abcdefg3
	//
	// For each tag in the list, you must specify both a tag key and a value. You
	// can set the value to an empty string, but you can't set it to null.
	//
	// If any one of the tags is invalid or if you exceed the allowed number of
	// tags for an account user, then the entire request fails and the account is
	// not created.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceId sets the ResourceId field's value.
func (s *TagResourceInput) SetResourceId(v string) *TagResourceInput {
	s.ResourceId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// We can't find a root, OU, account, or policy with the TargetId that you specified.
type TargetNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s TargetNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TargetNotFoundException) GoString() string {
	return s.String()
}

func newErrorTargetNotFoundException(v protocol.ResponseMetadata) error {
	return &TargetNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TargetNotFoundException) Code() string {
	return "TargetNotFoundException"
}

// Message returns the exception's message.
func (s *TargetNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TargetNotFoundException) OrigErr() error {
	return nil
}

func (s *TargetNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TargetNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TargetNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// You have sent too many requests in too short a period of time. The quota
// helps protect against denial-of-service attacks. Try again later.
//
// For information about quotas that affect AWS Organizations, see Quotas for
// AWS Organizations (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html)in
// the AWS Organizations User Guide.
type TooManyRequestsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	Type *string `type:"string"`
}

// String returns the string representation
func (s TooManyRequestsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TooManyRequestsException) GoString() string {
	return s.String()
}

func newErrorTooManyRequestsException(v protocol.ResponseMetadata) error {
	return &TooManyRequestsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TooManyRequestsException) Code() string {
	return "TooManyRequestsException"
}

// Message returns the exception's message.
func (s *TooManyRequestsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TooManyRequestsException) OrigErr() error {
	return nil
}

func (s *TooManyRequestsException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TooManyRequestsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TooManyRequestsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// This action isn't available in the current AWS Region.
type UnsupportedAPIEndpointException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s UnsupportedAPIEndpointException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnsupportedAPIEndpointException) GoString() string {
	return s.String()
}

func newErrorUnsupportedAPIEndpointException(v protocol.ResponseMetadata) error {
	return &UnsupportedAPIEndpointException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UnsupportedAPIEndpointException) Code() string {
	return "UnsupportedAPIEndpointException"
}

// Message returns the exception's message.
func (s *UnsupportedAPIEndpointException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UnsupportedAPIEndpointException) OrigErr() error {
	return nil
}

func (s *UnsupportedAPIEndpointException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UnsupportedAPIEndpointException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UnsupportedAPIEndpointException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ID of the resource to remove a tag from.
	//
	// You can specify any of the following taggable resources.
	//
	//    * AWS account – specify the account ID number.
	//
	//    * Organizational unit – specify the OU ID that begins with ou- and looks
	//    similar to: ou-1a2b-34uvwxyz
	//
	//    * Root – specify the root ID that begins with r- and looks similar to:
	//    r-1a2b
	//
	//    * Policy – specify the policy ID that begins with p- andlooks similar
	//    to: p-12abcdefg3
	//
	// ResourceId is a required field
	ResourceId *string `type:"string" required:"true"`

	// The list of keys for tags to remove from the specified resource.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceId sets the ResourceId field's value.
func (s *UntagResourceInput) SetResourceId(v string) *UntagResourceInput {
	s.ResourceId = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateOrganizationalUnitInput struct {
	_ struct{} `type:"structure"`

	// The new name that you want to assign to the OU.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) that is used to validate
	// this parameter is a string of any of the characters in the ASCII character
	// range.
	Name *string `min:"1" type:"string"`

	// The unique identifier (ID) of the OU that you want to rename. You can get
	// the ID from the ListOrganizationalUnitsForParent operation.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for an organizational
	// unit ID string requires "ou-" followed by from 4 to 32 lowercase letters
	// or digits (the ID of the root that contains the OU). This string is followed
	// by a second "-" dash and from 8 to 32 additional lowercase letters or digits.
	//
	// OrganizationalUnitId is a required field
	OrganizationalUnitId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateOrganizationalUnitInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateOrganizationalUnitInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateOrganizationalUnitInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateOrganizationalUnitInput"}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.OrganizationalUnitId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationalUnitId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *UpdateOrganizationalUnitInput) SetName(v string) *UpdateOrganizationalUnitInput {
	s.Name = &v
	return s
}

// SetOrganizationalUnitId sets the OrganizationalUnitId field's value.
func (s *UpdateOrganizationalUnitInput) SetOrganizationalUnitId(v string) *UpdateOrganizationalUnitInput {
	s.OrganizationalUnitId = &v
	return s
}

type UpdateOrganizationalUnitOutput struct {
	_ struct{} `type:"structure"`

	// A structure that contains the details about the specified OU, including its
	// new name.
	OrganizationalUnit *OrganizationalUnit `type:"structure"`
}

// String returns the string representation
func (s UpdateOrganizationalUnitOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateOrganizationalUnitOutput) GoString() string {
	return s.String()
}

// SetOrganizationalUnit sets the OrganizationalUnit field's value.
func (s *UpdateOrganizationalUnitOutput) SetOrganizationalUnit(v *OrganizationalUnit) *UpdateOrganizationalUnitOutput {
	s.OrganizationalUnit = v
	return s
}

type UpdatePolicyInput struct {
	_ struct{} `type:"structure"`

	// If provided, the new content for the policy. The text must be correctly formatted
	// JSON that complies with the syntax for the policy's type. For more information,
	// see Service Control Policy Syntax (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_scp-syntax.html)
	// in the AWS Organizations User Guide.
	Content *string `min:"1" type:"string"`

	// If provided, the new description for the policy.
	Description *string `type:"string"`

	// If provided, the new name for the policy.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) that is used to validate
	// this parameter is a string of any of the characters in the ASCII character
	// range.
	Name *string `min:"1" type:"string"`

	// The unique identifier (ID) of the policy that you want to update.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for a policy ID string
	// requires "p-" followed by from 8 to 128 lowercase or uppercase letters, digits,
	// or the underscore character (_).
	//
	// PolicyId is a required field
	PolicyId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UpdatePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdatePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdatePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdatePolicyInput"}
	if s.Content != nil && len(*s.Content) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Content", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.PolicyId == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContent sets the Content field's value.
func (s *UpdatePolicyInput) SetContent(v string) *UpdatePolicyInput {
	s.Content = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdatePolicyInput) SetDescription(v string) *UpdatePolicyInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdatePolicyInput) SetName(v string) *UpdatePolicyInput {
	s.Name = &v
	return s
}

// SetPolicyId sets the PolicyId field's value.
func (s *UpdatePolicyInput) SetPolicyId(v string) *UpdatePolicyInput {
	s.PolicyId = &v
	return s
}

type UpdatePolicyOutput struct {
	_ struct{} `type:"structure"`

	// A structure that contains details about the updated policy, showing the requested
	// changes.
	Policy *Policy `type:"structure"`
}

// String returns the string representation
func (s UpdatePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdatePolicyOutput) GoString() string {
	return s.String()
}

// SetPolicy sets the Policy field's value.
func (s *UpdatePolicyOutput) SetPolicy(v *Policy) *UpdatePolicyOutput {
	s.Policy = v
	return s
}

const (
	// AccessDeniedForDependencyExceptionReasonAccessDeniedDuringCreateServiceLinkedRole is a AccessDeniedForDependencyExceptionReason enum value
	AccessDeniedForDependencyExceptionReasonAccessDeniedDuringCreateServiceLinkedRole = "ACCESS_DENIED_DURING_CREATE_SERVICE_LINKED_ROLE"
)

// AccessDeniedForDependencyExceptionReason_Values returns all elements of the AccessDeniedForDependencyExceptionReason enum
func AccessDeniedForDependencyExceptionReason_Values() []string {
	return []string{
		AccessDeniedForDependencyExceptionReasonAccessDeniedDuringCreateServiceLinkedRole,
	}
}

const (
	// AccountJoinedMethodInvited is a AccountJoinedMethod enum value
	AccountJoinedMethodInvited = "INVITED"

	// AccountJoinedMethodCreated is a AccountJoinedMethod enum value
	AccountJoinedMethodCreated = "CREATED"
)

// AccountJoinedMethod_Values returns all elements of the AccountJoinedMethod enum
func AccountJoinedMethod_Values() []string {
	return []string{
		AccountJoinedMethodInvited,
		AccountJoinedMethodCreated,
	}
}

const (
	// AccountStatusActive is a AccountStatus enum value
	AccountStatusActive = "ACTIVE"

	// AccountStatusSuspended is a AccountStatus enum value
	AccountStatusSuspended = "SUSPENDED"
)

// AccountStatus_Values returns all elements of the AccountStatus enum
func AccountStatus_Values() []string {
	return []string{
		AccountStatusActive,
		AccountStatusSuspended,
	}
}

const (
	// ActionTypeInvite is a ActionType enum value
	ActionTypeInvite = "INVITE"

	// ActionTypeEnableAllFeatures is a ActionType enum value
	ActionTypeEnableAllFeatures = "ENABLE_ALL_FEATURES"

	// ActionTypeApproveAllFeatures is a ActionType enum value
	ActionTypeApproveAllFeatures = "APPROVE_ALL_FEATURES"

	// ActionTypeAddOrganizationsServiceLinkedRole is a ActionType enum value
	ActionTypeAddOrganizationsServiceLinkedRole = "ADD_ORGANIZATIONS_SERVICE_LINKED_ROLE"
)

// ActionType_Values returns all elements of the ActionType enum
func ActionType_Values() []string {
	return []string{
		ActionTypeInvite,
		ActionTypeEnableAllFeatures,
		ActionTypeApproveAllFeatures,
		ActionTypeAddOrganizationsServiceLinkedRole,
	}
}

const (
	// ChildTypeAccount is a ChildType enum value
	ChildTypeAccount = "ACCOUNT"

	// ChildTypeOrganizationalUnit is a ChildType enum value
	ChildTypeOrganizationalUnit = "ORGANIZATIONAL_UNIT"
)

// ChildType_Values returns all elements of the ChildType enum
func ChildType_Values() []string {
	return []string{
		ChildTypeAccount,
		ChildTypeOrganizationalUnit,
	}
}

const (
	// ConstraintViolationExceptionReasonAccountNumberLimitExceeded is a ConstraintViolationExceptionReason enum value
	ConstraintViolationExceptionReasonAccountNumberLimitExceeded = "ACCOUNT_NUMBER_LIMIT_EXCEEDED"

	// ConstraintViolationExceptionReasonHandshakeRateLimitExceeded is a ConstraintViolationExceptionReason enum value
	ConstraintViolationExceptionReasonHandshakeRateLimitExceeded = "HANDSHAKE_RATE_LIMIT_EXCEEDED"

	// ConstraintViolationExceptionReasonOuNumberLimitExceeded is a ConstraintViolationExceptionReason enum value
	ConstraintViolationExceptionReasonOuNumberLimitExceeded = "OU_NUMBER_LIMIT_EXCEEDED"

	// ConstraintViolationExceptionReasonOuDepthLimitExceeded is a ConstraintViolationExceptionReason enum value
	ConstraintViolationExceptionReasonOuDepthLimitExceeded = "OU_DEPTH_LIMIT_EXCEEDED"

	// ConstraintViolationExceptionReasonPolicyNumberLimitExceeded is a ConstraintViolationExceptionReason enum value
	ConstraintViolationExceptionReasonPolicyNumberLimitExceeded = "POLICY_NUMBER_LIMIT_EXCEEDED"

	// ConstraintViolationExceptionReasonPolicyContentLimitExceeded is a ConstraintViolationExceptionReason enum value
	ConstraintViolationExceptionReasonPolicyContentLimitExceeded = "POLICY_CONTENT_LIMIT_EXCEEDED"

	// ConstraintViolationExceptionReasonMaxPolicyTypeAttachmentLimitExceeded is a ConstraintViolationExceptionReason enum value
	ConstraintViolationExceptionReasonMaxPolicyTypeAttachmentLimitExceeded = "MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED"

	// ConstraintViolationExceptionReasonMinPolicyTypeAttachmentLimitExceeded is a ConstraintViolationExceptionReason enum value
	ConstraintViolationExceptionReasonMinPolicyTypeAttachmentLimitExceeded = "MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED"

	// ConstraintViolationExceptionReasonAccountCannotLeaveOrganization is a ConstraintViolationExceptionReason enum value
	ConstraintViolationExceptionReasonAccountCannotLeaveOrganization = "ACCOUNT_CANNOT_LEAVE_ORGANIZATION"

	// ConstraintViolationExceptionReasonAccountCannotLeaveWithoutEula is a ConstraintViolationExceptionReason enum value
	ConstraintViolationExceptionReasonAccountCannotLeaveWithoutEula = "ACCOUNT_CANNOT_LEAVE_WITHOUT_EULA"

	// ConstraintViolationExceptionReasonAccountCannotLeaveWithoutPhoneVerification is a ConstraintViolationExceptionReason enum value
	ConstraintViolationExceptionReasonAccountCannotLeaveWithoutPhoneVerification = "ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION"

	// ConstraintViolationExceptionReasonMasterAccountPaymentInstrumentRequired is a ConstraintViolationExceptionReason enum value
	ConstraintViolationExceptionReasonMasterAccountPaymentInstrumentRequired = "MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED"

	// ConstraintViolationExceptionReasonMemberAccountPaymentInstrumentRequired is a ConstraintViolationExceptionReason enum value
	ConstraintViolationExceptionReasonMemberAccountPaymentInstrumentRequired = "MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED"

	// ConstraintViolationExceptionReasonAccountCreationRateLimitExceeded is a ConstraintViolationExceptionReason enum value
	ConstraintViolationExceptionReasonAccountCreationRateLimitExceeded = "ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED"

	// ConstraintViolationExceptionReasonMasterAccountAddressDoesNotMatchMarketplace is a ConstraintViolationExceptionReason enum value
	ConstraintViolationExceptionReasonMasterAccountAddressDoesNotMatchMarketplace = "MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE"

	// ConstraintViolationExceptionReasonMasterAccountMissingContactInfo is a ConstraintViolationExceptionReason enum value
	ConstraintViolationExceptionReasonMasterAccountMissingContactInfo = "MASTER_ACCOUNT_MISSING_CONTACT_INFO"

	// ConstraintViolationExceptionReasonMasterAccountNotGovcloudEnabled is a ConstraintViolationExceptionReason enum value
	ConstraintViolationExceptionReasonMasterAccountNotGovcloudEnabled = "MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED"

	// ConstraintViolationExceptionReasonOrganizationNotInAllFeaturesMode is a ConstraintViolationExceptionReason enum value
	ConstraintViolationExceptionReasonOrganizationNotInAllFeaturesMode = "ORGANIZATION_NOT_IN_ALL_FEATURES_MODE"

	// ConstraintViolationExceptionReasonCreateOrganizationInBillingModeUnsupportedRegion is a ConstraintViolationExceptionReason enum value
	ConstraintViolationExceptionReasonCreateOrganizationInBillingModeUnsupportedRegion = "CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION"

	// ConstraintViolationExceptionReasonEmailVerificationCodeExpired is a ConstraintViolationExceptionReason enum value
	ConstraintViolationExceptionReasonEmailVerificationCodeExpired = "EMAIL_VERIFICATION_CODE_EXPIRED"

	// ConstraintViolationExceptionReasonWaitPeriodActive is a ConstraintViolationExceptionReason enum value
	ConstraintViolationExceptionReasonWaitPeriodActive = "WAIT_PERIOD_ACTIVE"

	// ConstraintViolationExceptionReasonMaxTagLimitExceeded is a ConstraintViolationExceptionReason enum value
	ConstraintViolationExceptionReasonMaxTagLimitExceeded = "MAX_TAG_LIMIT_EXCEEDED"

	// ConstraintViolationExceptionReasonTagPolicyViolation is a ConstraintViolationExceptionReason enum value
	ConstraintViolationExceptionReasonTagPolicyViolation = "TAG_POLICY_VIOLATION"

	// ConstraintViolationExceptionReasonMaxDelegatedAdministratorsForServiceLimitExceeded is a ConstraintViolationExceptionReason enum value
	ConstraintViolationExceptionReasonMaxDelegatedAdministratorsForServiceLimitExceeded = "MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED"

	// ConstraintViolationExceptionReasonCannotRegisterMasterAsDelegatedAdministrator is a ConstraintViolationExceptionReason enum value
	ConstraintViolationExceptionReasonCannotRegisterMasterAsDelegatedAdministrator = "CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR"

	// ConstraintViolationExceptionReasonCannotRemoveDelegatedAdministratorFromOrg is a ConstraintViolationExceptionReason enum value
	ConstraintViolationExceptionReasonCannotRemoveDelegatedAdministratorFromOrg = "CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG"

	// ConstraintViolationExceptionReasonDelegatedAdministratorExistsForThisService is a ConstraintViolationExceptionReason enum value
	ConstraintViolationExceptionReasonDelegatedAdministratorExistsForThisService = "DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE"

	// ConstraintViolationExceptionReasonMasterAccountMissingBusinessLicense is a ConstraintViolationExceptionReason enum value
	ConstraintViolationExceptionReasonMasterAccountMissingBusinessLicense = "MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE"
)

// ConstraintViolationExceptionReason_Values returns all elements of the ConstraintViolationExceptionReason enum
func ConstraintViolationExceptionReason_Values() []string {
	return []string{
		ConstraintViolationExceptionReasonAccountNumberLimitExceeded,
		ConstraintViolationExceptionReasonHandshakeRateLimitExceeded,
		ConstraintViolationExceptionReasonOuNumberLimitExceeded,
		ConstraintViolationExceptionReasonOuDepthLimitExceeded,
		ConstraintViolationExceptionReasonPolicyNumberLimitExceeded,
		ConstraintViolationExceptionReasonPolicyContentLimitExceeded,
		ConstraintViolationExceptionReasonMaxPolicyTypeAttachmentLimitExceeded,
		ConstraintViolationExceptionReasonMinPolicyTypeAttachmentLimitExceeded,
		ConstraintViolationExceptionReasonAccountCannotLeaveOrganization,
		ConstraintViolationExceptionReasonAccountCannotLeaveWithoutEula,
		ConstraintViolationExceptionReasonAccountCannotLeaveWithoutPhoneVerification,
		ConstraintViolationExceptionReasonMasterAccountPaymentInstrumentRequired,
		ConstraintViolationExceptionReasonMemberAccountPaymentInstrumentRequired,
		ConstraintViolationExceptionReasonAccountCreationRateLimitExceeded,
		ConstraintViolationExceptionReasonMasterAccountAddressDoesNotMatchMarketplace,
		ConstraintViolationExceptionReasonMasterAccountMissingContactInfo,
		ConstraintViolationExceptionReasonMasterAccountNotGovcloudEnabled,
		ConstraintViolationExceptionReasonOrganizationNotInAllFeaturesMode,
		ConstraintViolationExceptionReasonCreateOrganizationInBillingModeUnsupportedRegion,
		ConstraintViolationExceptionReasonEmailVerificationCodeExpired,
		ConstraintViolationExceptionReasonWaitPeriodActive,
		ConstraintViolationExceptionReasonMaxTagLimitExceeded,
		ConstraintViolationExceptionReasonTagPolicyViolation,
		ConstraintViolationExceptionReasonMaxDelegatedAdministratorsForServiceLimitExceeded,
		ConstraintViolationExceptionReasonCannotRegisterMasterAsDelegatedAdministrator,
		ConstraintViolationExceptionReasonCannotRemoveDelegatedAdministratorFromOrg,
		ConstraintViolationExceptionReasonDelegatedAdministratorExistsForThisService,
		ConstraintViolationExceptionReasonMasterAccountMissingBusinessLicense,
	}
}

const (
	// CreateAccountFailureReasonAccountLimitExceeded is a CreateAccountFailureReason enum value
	CreateAccountFailureReasonAccountLimitExceeded = "ACCOUNT_LIMIT_EXCEEDED"

	// CreateAccountFailureReasonEmailAlreadyExists is a CreateAccountFailureReason enum value
	CreateAccountFailureReasonEmailAlreadyExists = "EMAIL_ALREADY_EXISTS"

	// CreateAccountFailureReasonInvalidAddress is a CreateAccountFailureReason enum value
	CreateAccountFailureReasonInvalidAddress = "INVALID_ADDRESS"

	// CreateAccountFailureReasonInvalidEmail is a CreateAccountFailureReason enum value
	CreateAccountFailureReasonInvalidEmail = "INVALID_EMAIL"

	// CreateAccountFailureReasonConcurrentAccountModification is a CreateAccountFailureReason enum value
	CreateAccountFailureReasonConcurrentAccountModification = "CONCURRENT_ACCOUNT_MODIFICATION"

	// CreateAccountFailureReasonInternalFailure is a CreateAccountFailureReason enum value
	CreateAccountFailureReasonInternalFailure = "INTERNAL_FAILURE"

	// CreateAccountFailureReasonGovcloudAccountAlreadyExists is a CreateAccountFailureReason enum value
	CreateAccountFailureReasonGovcloudAccountAlreadyExists = "GOVCLOUD_ACCOUNT_ALREADY_EXISTS"

	// CreateAccountFailureReasonMissingBusinessValidation is a CreateAccountFailureReason enum value
	CreateAccountFailureReasonMissingBusinessValidation = "MISSING_BUSINESS_VALIDATION"

	// CreateAccountFailureReasonMissingPaymentInstrument is a CreateAccountFailureReason enum value
	CreateAccountFailureReasonMissingPaymentInstrument = "MISSING_PAYMENT_INSTRUMENT"
)

// CreateAccountFailureReason_Values returns all elements of the CreateAccountFailureReason enum
func CreateAccountFailureReason_Values() []string {
	return []string{
		CreateAccountFailureReasonAccountLimitExceeded,
		CreateAccountFailureReasonEmailAlreadyExists,
		CreateAccountFailureReasonInvalidAddress,
		CreateAccountFailureReasonInvalidEmail,
		CreateAccountFailureReasonConcurrentAccountModification,
		CreateAccountFailureReasonInternalFailure,
		CreateAccountFailureReasonGovcloudAccountAlreadyExists,
		CreateAccountFailureReasonMissingBusinessValidation,
		CreateAccountFailureReasonMissingPaymentInstrument,
	}
}

const (
	// CreateAccountStateInProgress is a CreateAccountState enum value
	CreateAccountStateInProgress = "IN_PROGRESS"

	// CreateAccountStateSucceeded is a CreateAccountState enum value
	CreateAccountStateSucceeded = "SUCCEEDED"

	// CreateAccountStateFailed is a CreateAccountState enum value
	CreateAccountStateFailed = "FAILED"
)

// CreateAccountState_Values returns all elements of the CreateAccountState enum
func CreateAccountState_Values() []string {
	return []string{
		CreateAccountStateInProgress,
		CreateAccountStateSucceeded,
		CreateAccountStateFailed,
	}
}

const (
	// EffectivePolicyTypeTagPolicy is a EffectivePolicyType enum value
	EffectivePolicyTypeTagPolicy = "TAG_POLICY"

	// EffectivePolicyTypeBackupPolicy is a EffectivePolicyType enum value
	EffectivePolicyTypeBackupPolicy = "BACKUP_POLICY"

	// EffectivePolicyTypeAiservicesOptOutPolicy is a EffectivePolicyType enum value
	EffectivePolicyTypeAiservicesOptOutPolicy = "AISERVICES_OPT_OUT_POLICY"
)

// EffectivePolicyType_Values returns all elements of the EffectivePolicyType enum
func EffectivePolicyType_Values() []string {
	return []string{
		EffectivePolicyTypeTagPolicy,
		EffectivePolicyTypeBackupPolicy,
		EffectivePolicyTypeAiservicesOptOutPolicy,
	}
}

const (
	// HandshakeConstraintViolationExceptionReasonAccountNumberLimitExceeded is a HandshakeConstraintViolationExceptionReason enum value
	HandshakeConstraintViolationExceptionReasonAccountNumberLimitExceeded = "ACCOUNT_NUMBER_LIMIT_EXCEEDED"

	// HandshakeConstraintViolationExceptionReasonHandshakeRateLimitExceeded is a HandshakeConstraintViolationExceptionReason enum value
	HandshakeConstraintViolationExceptionReasonHandshakeRateLimitExceeded = "HANDSHAKE_RATE_LIMIT_EXCEEDED"

	// HandshakeConstraintViolationExceptionReasonAlreadyInAnOrganization is a HandshakeConstraintViolationExceptionReason enum value
	HandshakeConstraintViolationExceptionReasonAlreadyInAnOrganization = "ALREADY_IN_AN_ORGANIZATION"

	// HandshakeConstraintViolationExceptionReasonOrganizationAlreadyHasAllFeatures is a HandshakeConstraintViolationExceptionReason enum value
	HandshakeConstraintViolationExceptionReasonOrganizationAlreadyHasAllFeatures = "ORGANIZATION_ALREADY_HAS_ALL_FEATURES"

	// HandshakeConstraintViolationExceptionReasonInviteDisabledDuringEnableAllFeatures is a HandshakeConstraintViolationExceptionReason enum value
	HandshakeConstraintViolationExceptionReasonInviteDisabledDuringEnableAllFeatures = "INVITE_DISABLED_DURING_ENABLE_ALL_FEATURES"

	// HandshakeConstraintViolationExceptionReasonPaymentInstrumentRequired is a HandshakeConstraintViolationExceptionReason enum value
	HandshakeConstraintViolationExceptionReasonPaymentInstrumentRequired = "PAYMENT_INSTRUMENT_REQUIRED"

	// HandshakeConstraintViolationExceptionReasonOrganizationFromDifferentSellerOfRecord is a HandshakeConstraintViolationExceptionReason enum value
	HandshakeConstraintViolationExceptionReasonOrganizationFromDifferentSellerOfRecord = "ORGANIZATION_FROM_DIFFERENT_SELLER_OF_RECORD"

	// HandshakeConstraintViolationExceptionReasonOrganizationMembershipChangeRateLimitExceeded is a HandshakeConstraintViolationExceptionReason enum value
	HandshakeConstraintViolationExceptionReasonOrganizationMembershipChangeRateLimitExceeded = "ORGANIZATION_MEMBERSHIP_CHANGE_RATE_LIMIT_EXCEEDED"
)

// HandshakeConstraintViolationExceptionReason_Values returns all elements of the HandshakeConstraintViolationExceptionReason enum
func HandshakeConstraintViolationExceptionReason_Values() []string {
	return []string{
		HandshakeConstraintViolationExceptionReasonAccountNumberLimitExceeded,
		HandshakeConstraintViolationExceptionReasonHandshakeRateLimitExceeded,
		HandshakeConstraintViolationExceptionReasonAlreadyInAnOrganization,
		HandshakeConstraintViolationExceptionReasonOrganizationAlreadyHasAllFeatures,
		HandshakeConstraintViolationExceptionReasonInviteDisabledDuringEnableAllFeatures,
		HandshakeConstraintViolationExceptionReasonPaymentInstrumentRequired,
		HandshakeConstraintViolationExceptionReasonOrganizationFromDifferentSellerOfRecord,
		HandshakeConstraintViolationExceptionReasonOrganizationMembershipChangeRateLimitExceeded,
	}
}

const (
	// HandshakePartyTypeAccount is a HandshakePartyType enum value
	HandshakePartyTypeAccount = "ACCOUNT"

	// HandshakePartyTypeOrganization is a HandshakePartyType enum value
	HandshakePartyTypeOrganization = "ORGANIZATION"

	// HandshakePartyTypeEmail is a HandshakePartyType enum value
	HandshakePartyTypeEmail = "EMAIL"
)

// HandshakePartyType_Values returns all elements of the HandshakePartyType enum
func HandshakePartyType_Values() []string {
	return []string{
		HandshakePartyTypeAccount,
		HandshakePartyTypeOrganization,
		HandshakePartyTypeEmail,
	}
}

const (
	// HandshakeResourceTypeAccount is a HandshakeResourceType enum value
	HandshakeResourceTypeAccount = "ACCOUNT"

	// HandshakeResourceTypeOrganization is a HandshakeResourceType enum value
	HandshakeResourceTypeOrganization = "ORGANIZATION"

	// HandshakeResourceTypeOrganizationFeatureSet is a HandshakeResourceType enum value
	HandshakeResourceTypeOrganizationFeatureSet = "ORGANIZATION_FEATURE_SET"

	// HandshakeResourceTypeEmail is a HandshakeResourceType enum value
	HandshakeResourceTypeEmail = "EMAIL"

	// HandshakeResourceTypeMasterEmail is a HandshakeResourceType enum value
	HandshakeResourceTypeMasterEmail = "MASTER_EMAIL"

	// HandshakeResourceTypeMasterName is a HandshakeResourceType enum value
	HandshakeResourceTypeMasterName = "MASTER_NAME"

	// HandshakeResourceTypeNotes is a HandshakeResourceType enum value
	HandshakeResourceTypeNotes = "NOTES"

	// HandshakeResourceTypeParentHandshake is a HandshakeResourceType enum value
	HandshakeResourceTypeParentHandshake = "PARENT_HANDSHAKE"
)

// HandshakeResourceType_Values returns all elements of the HandshakeResourceType enum
func HandshakeResourceType_Values() []string {
	return []string{
		HandshakeResourceTypeAccount,
		HandshakeResourceTypeOrganization,
		HandshakeResourceTypeOrganizationFeatureSet,
		HandshakeResourceTypeEmail,
		HandshakeResourceTypeMasterEmail,
		HandshakeResourceTypeMasterName,
		HandshakeResourceTypeNotes,
		HandshakeResourceTypeParentHandshake,
	}
}

const (
	// HandshakeStateRequested is a HandshakeState enum value
	HandshakeStateRequested = "REQUESTED"

	// HandshakeStateOpen is a HandshakeState enum value
	HandshakeStateOpen = "OPEN"

	// HandshakeStateCanceled is a HandshakeState enum value
	HandshakeStateCanceled = "CANCELED"

	// HandshakeStateAccepted is a HandshakeState enum value
	HandshakeStateAccepted = "ACCEPTED"

	// HandshakeStateDeclined is a HandshakeState enum value
	HandshakeStateDeclined = "DECLINED"

	// HandshakeStateExpired is a HandshakeState enum value
	HandshakeStateExpired = "EXPIRED"
)

// HandshakeState_Values returns all elements of the HandshakeState enum
func HandshakeState_Values() []string {
	return []string{
		HandshakeStateRequested,
		HandshakeStateOpen,
		HandshakeStateCanceled,
		HandshakeStateAccepted,
		HandshakeStateDeclined,
		HandshakeStateExpired,
	}
}

const (
	// IAMUserAccessToBillingAllow is a IAMUserAccessToBilling enum value
	IAMUserAccessToBillingAllow = "ALLOW"

	// IAMUserAccessToBillingDeny is a IAMUserAccessToBilling enum value
	IAMUserAccessToBillingDeny = "DENY"
)

// IAMUserAccessToBilling_Values returns all elements of the IAMUserAccessToBilling enum
func IAMUserAccessToBilling_Values() []string {
	return []string{
		IAMUserAccessToBillingAllow,
		IAMUserAccessToBillingDeny,
	}
}

const (
	// InvalidInputExceptionReasonInvalidPartyTypeTarget is a InvalidInputExceptionReason enum value
	InvalidInputExceptionReasonInvalidPartyTypeTarget = "INVALID_PARTY_TYPE_TARGET"

	// InvalidInputExceptionReasonInvalidSyntaxOrganizationArn is a InvalidInputExceptionReason enum value
	InvalidInputExceptionReasonInvalidSyntaxOrganizationArn = "INVALID_SYNTAX_ORGANIZATION_ARN"

	// InvalidInputExceptionReasonInvalidSyntaxPolicyId is a InvalidInputExceptionReason enum value
	InvalidInputExceptionReasonInvalidSyntaxPolicyId = "INVALID_SYNTAX_POLICY_ID"

	// InvalidInputExceptionReasonInvalidEnum is a InvalidInputExceptionReason enum value
	InvalidInputExceptionReasonInvalidEnum = "INVALID_ENUM"

	// InvalidInputExceptionReasonInvalidEnumPolicyType is a InvalidInputExceptionReason enum value
	InvalidInputExceptionReasonInvalidEnumPolicyType = "INVALID_ENUM_POLICY_TYPE"

	// InvalidInputExceptionReasonInvalidListMember is a InvalidInputExceptionReason enum value
	InvalidInputExceptionReasonInvalidListMember = "INVALID_LIST_MEMBER"

	// InvalidInputExceptionReasonMaxLengthExceeded is a InvalidInputExceptionReason enum value
	InvalidInputExceptionReasonMaxLengthExceeded = "MAX_LENGTH_EXCEEDED"

	// InvalidInputExceptionReasonMaxValueExceeded is a InvalidInputExceptionReason enum value
	InvalidInputExceptionReasonMaxValueExceeded = "MAX_VALUE_EXCEEDED"

	// InvalidInputExceptionReasonMinLengthExceeded is a InvalidInputExceptionReason enum value
	InvalidInputExceptionReasonMinLengthExceeded = "MIN_LENGTH_EXCEEDED"

	// InvalidInputExceptionReasonMinValueExceeded is a InvalidInputExceptionReason enum value
	InvalidInputExceptionReasonMinValueExceeded = "MIN_VALUE_EXCEEDED"

	// InvalidInputExceptionReasonImmutablePolicy is a InvalidInputExceptionReason enum value
	InvalidInputExceptionReasonImmutablePolicy = "IMMUTABLE_POLICY"

	// InvalidInputExceptionReasonInvalidPattern is a InvalidInputExceptionReason enum value
	InvalidInputExceptionReasonInvalidPattern = "INVALID_PATTERN"

	// InvalidInputExceptionReasonInvalidPatternTargetId is a InvalidInputExceptionReason enum value
	InvalidInputExceptionReasonInvalidPatternTargetId = "INVALID_PATTERN_TARGET_ID"

	// InvalidInputExceptionReasonInputRequired is a InvalidInputExceptionReason enum value
	InvalidInputExceptionReasonInputRequired = "INPUT_REQUIRED"

	// InvalidInputExceptionReasonInvalidNextToken is a InvalidInputExceptionReason enum value
	InvalidInputExceptionReasonInvalidNextToken = "INVALID_NEXT_TOKEN"

	// InvalidInputExceptionReasonMaxLimitExceededFilter is a InvalidInputExceptionReason enum value
	InvalidInputExceptionReasonMaxLimitExceededFilter = "MAX_LIMIT_EXCEEDED_FILTER"

	// InvalidInputExceptionReasonMovingAccountBetweenDifferentRoots is a InvalidInputExceptionReason enum value
	InvalidInputExceptionReasonMovingAccountBetweenDifferentRoots = "MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS"

	// InvalidInputExceptionReasonInvalidFullNameTarget is a InvalidInputExceptionReason enum value
	InvalidInputExceptionReasonInvalidFullNameTarget = "INVALID_FULL_NAME_TARGET"

	// InvalidInputExceptionReasonUnrecognizedServicePrincipal is a InvalidInputExceptionReason enum value
	InvalidInputExceptionReasonUnrecognizedServicePrincipal = "UNRECOGNIZED_SERVICE_PRINCIPAL"

	// InvalidInputExceptionReasonInvalidRoleName is a InvalidInputExceptionReason enum value
	InvalidInputExceptionReasonInvalidRoleName = "INVALID_ROLE_NAME"

	// InvalidInputExceptionReasonInvalidSystemTagsParameter is a InvalidInputExceptionReason enum value
	InvalidInputExceptionReasonInvalidSystemTagsParameter = "INVALID_SYSTEM_TAGS_PARAMETER"

	// InvalidInputExceptionReasonDuplicateTagKey is a InvalidInputExceptionReason enum value
	InvalidInputExceptionReasonDuplicateTagKey = "DUPLICATE_TAG_KEY"

	// InvalidInputExceptionReasonTargetNotSupported is a InvalidInputExceptionReason enum value
	InvalidInputExceptionReasonTargetNotSupported = "TARGET_NOT_SUPPORTED"
)

// InvalidInputExceptionReason_Values returns all elements of the InvalidInputExceptionReason enum
func InvalidInputExceptionReason_Values() []string {
	return []string{
		InvalidInputExceptionReasonInvalidPartyTypeTarget,
		InvalidInputExceptionReasonInvalidSyntaxOrganizationArn,
		InvalidInputExceptionReasonInvalidSyntaxPolicyId,
		InvalidInputExceptionReasonInvalidEnum,
		InvalidInputExceptionReasonInvalidEnumPolicyType,
		InvalidInputExceptionReasonInvalidListMember,
		InvalidInputExceptionReasonMaxLengthExceeded,
		InvalidInputExceptionReasonMaxValueExceeded,
		InvalidInputExceptionReasonMinLengthExceeded,
		InvalidInputExceptionReasonMinValueExceeded,
		InvalidInputExceptionReasonImmutablePolicy,
		InvalidInputExceptionReasonInvalidPattern,
		InvalidInputExceptionReasonInvalidPatternTargetId,
		InvalidInputExceptionReasonInputRequired,
		InvalidInputExceptionReasonInvalidNextToken,
		InvalidInputExceptionReasonMaxLimitExceededFilter,
		InvalidInputExceptionReasonMovingAccountBetweenDifferentRoots,
		InvalidInputExceptionReasonInvalidFullNameTarget,
		InvalidInputExceptionReasonUnrecognizedServicePrincipal,
		InvalidInputExceptionReasonInvalidRoleName,
		InvalidInputExceptionReasonInvalidSystemTagsParameter,
		InvalidInputExceptionReasonDuplicateTagKey,
		InvalidInputExceptionReasonTargetNotSupported,
	}
}

const (
	// OrganizationFeatureSetAll is a OrganizationFeatureSet enum value
	OrganizationFeatureSetAll = "ALL"

	// OrganizationFeatureSetConsolidatedBilling is a OrganizationFeatureSet enum value
	OrganizationFeatureSetConsolidatedBilling = "CONSOLIDATED_BILLING"
)

// OrganizationFeatureSet_Values returns all elements of the OrganizationFeatureSet enum
func OrganizationFeatureSet_Values() []string {
	return []string{
		OrganizationFeatureSetAll,
		OrganizationFeatureSetConsolidatedBilling,
	}
}

const (
	// ParentTypeRoot is a ParentType enum value
	ParentTypeRoot = "ROOT"

	// ParentTypeOrganizationalUnit is a ParentType enum value
	ParentTypeOrganizationalUnit = "ORGANIZATIONAL_UNIT"
)

// ParentType_Values returns all elements of the ParentType enum
func ParentType_Values() []string {
	return []string{
		ParentTypeRoot,
		ParentTypeOrganizationalUnit,
	}
}

const (
	// PolicyTypeServiceControlPolicy is a PolicyType enum value
	PolicyTypeServiceControlPolicy = "SERVICE_CONTROL_POLICY"

	// PolicyTypeTagPolicy is a PolicyType enum value
	PolicyTypeTagPolicy = "TAG_POLICY"

	// PolicyTypeBackupPolicy is a PolicyType enum value
	PolicyTypeBackupPolicy = "BACKUP_POLICY"

	// PolicyTypeAiservicesOptOutPolicy is a PolicyType enum value
	PolicyTypeAiservicesOptOutPolicy = "AISERVICES_OPT_OUT_POLICY"
)

// PolicyType_Values returns all elements of the PolicyType enum
func PolicyType_Values() []string {
	return []string{
		PolicyTypeServiceControlPolicy,
		PolicyTypeTagPolicy,
		PolicyTypeBackupPolicy,
		PolicyTypeAiservicesOptOutPolicy,
	}
}

const (
	// PolicyTypeStatusEnabled is a PolicyTypeStatus enum value
	PolicyTypeStatusEnabled = "ENABLED"

	// PolicyTypeStatusPendingEnable is a PolicyTypeStatus enum value
	PolicyTypeStatusPendingEnable = "PENDING_ENABLE"

	// PolicyTypeStatusPendingDisable is a PolicyTypeStatus enum value
	PolicyTypeStatusPendingDisable = "PENDING_DISABLE"
)

// PolicyTypeStatus_Values returns all elements of the PolicyTypeStatus enum
func PolicyTypeStatus_Values() []string {
	return []string{
		PolicyTypeStatusEnabled,
		PolicyTypeStatusPendingEnable,
		PolicyTypeStatusPendingDisable,
	}
}

const (
	// TargetTypeAccount is a TargetType enum value
	TargetTypeAccount = "ACCOUNT"

	// TargetTypeOrganizationalUnit is a TargetType enum value
	TargetTypeOrganizationalUnit = "ORGANIZATIONAL_UNIT"

	// TargetTypeRoot is a TargetType enum value
	TargetTypeRoot = "ROOT"
)

// TargetType_Values returns all elements of the TargetType enum
func TargetType_Values() []string {
	return []string{
		TargetTypeAccount,
		TargetTypeOrganizationalUnit,
		TargetTypeRoot,
	}
}
