// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package budgets

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opCreateBudget = "CreateBudget"

// CreateBudgetRequest generates a "aws/request.Request" representing the
// client's request for the CreateBudget operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateBudget for more information on using the CreateBudget
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateBudgetRequest method.
//    req, resp := client.CreateBudgetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Budgets) CreateBudgetRequest(input *CreateBudgetInput) (req *request.Request, output *CreateBudgetOutput) {
	op := &request.Operation{
		Name:       opCreateBudget,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateBudgetInput{}
	}

	output = &CreateBudgetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateBudget API operation for AWS Budgets.
//
// Creates a budget and, if included, notifications and subscribers.
//
// Only one of BudgetLimit or PlannedBudgetLimits can be present in the syntax
// at one time. Use the syntax that matches your case. The Request Syntax section
// shows the BudgetLimit syntax. For PlannedBudgetLimits, see the Examples (https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_budgets_CreateBudget.html#API_CreateBudget_Examples)
// section.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Budgets's
// API operation CreateBudget for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   An error on the client occurred. Typically, the cause is an invalid input
//   value.
//
//   * InternalErrorException
//   An error on the server occurred during the processing of your request. Try
//   again later.
//
//   * CreationLimitExceededException
//   You've exceeded the notification or subscriber limit.
//
//   * DuplicateRecordException
//   The budget name already exists. Budget names must be unique within an account.
//
//   * AccessDeniedException
//   You are not authorized to use this operation with the given parameters.
//
func (c *Budgets) CreateBudget(input *CreateBudgetInput) (*CreateBudgetOutput, error) {
	req, out := c.CreateBudgetRequest(input)
	return out, req.Send()
}

// CreateBudgetWithContext is the same as CreateBudget with the addition of
// the ability to pass a context and additional request options.
//
// See CreateBudget for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Budgets) CreateBudgetWithContext(ctx aws.Context, input *CreateBudgetInput, opts ...request.Option) (*CreateBudgetOutput, error) {
	req, out := c.CreateBudgetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateNotification = "CreateNotification"

// CreateNotificationRequest generates a "aws/request.Request" representing the
// client's request for the CreateNotification operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateNotification for more information on using the CreateNotification
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateNotificationRequest method.
//    req, resp := client.CreateNotificationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Budgets) CreateNotificationRequest(input *CreateNotificationInput) (req *request.Request, output *CreateNotificationOutput) {
	op := &request.Operation{
		Name:       opCreateNotification,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateNotificationInput{}
	}

	output = &CreateNotificationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateNotification API operation for AWS Budgets.
//
// Creates a notification. You must create the budget before you create the
// associated notification.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Budgets's
// API operation CreateNotification for usage and error information.
//
// Returned Error Types:
//   * InternalErrorException
//   An error on the server occurred during the processing of your request. Try
//   again later.
//
//   * InvalidParameterException
//   An error on the client occurred. Typically, the cause is an invalid input
//   value.
//
//   * NotFoundException
//   We can’t locate the resource that you specified.
//
//   * CreationLimitExceededException
//   You've exceeded the notification or subscriber limit.
//
//   * DuplicateRecordException
//   The budget name already exists. Budget names must be unique within an account.
//
//   * AccessDeniedException
//   You are not authorized to use this operation with the given parameters.
//
func (c *Budgets) CreateNotification(input *CreateNotificationInput) (*CreateNotificationOutput, error) {
	req, out := c.CreateNotificationRequest(input)
	return out, req.Send()
}

// CreateNotificationWithContext is the same as CreateNotification with the addition of
// the ability to pass a context and additional request options.
//
// See CreateNotification for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Budgets) CreateNotificationWithContext(ctx aws.Context, input *CreateNotificationInput, opts ...request.Option) (*CreateNotificationOutput, error) {
	req, out := c.CreateNotificationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSubscriber = "CreateSubscriber"

// CreateSubscriberRequest generates a "aws/request.Request" representing the
// client's request for the CreateSubscriber operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSubscriber for more information on using the CreateSubscriber
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateSubscriberRequest method.
//    req, resp := client.CreateSubscriberRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Budgets) CreateSubscriberRequest(input *CreateSubscriberInput) (req *request.Request, output *CreateSubscriberOutput) {
	op := &request.Operation{
		Name:       opCreateSubscriber,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSubscriberInput{}
	}

	output = &CreateSubscriberOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateSubscriber API operation for AWS Budgets.
//
// Creates a subscriber. You must create the associated budget and notification
// before you create the subscriber.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Budgets's
// API operation CreateSubscriber for usage and error information.
//
// Returned Error Types:
//   * InternalErrorException
//   An error on the server occurred during the processing of your request. Try
//   again later.
//
//   * InvalidParameterException
//   An error on the client occurred. Typically, the cause is an invalid input
//   value.
//
//   * CreationLimitExceededException
//   You've exceeded the notification or subscriber limit.
//
//   * DuplicateRecordException
//   The budget name already exists. Budget names must be unique within an account.
//
//   * NotFoundException
//   We can’t locate the resource that you specified.
//
//   * AccessDeniedException
//   You are not authorized to use this operation with the given parameters.
//
func (c *Budgets) CreateSubscriber(input *CreateSubscriberInput) (*CreateSubscriberOutput, error) {
	req, out := c.CreateSubscriberRequest(input)
	return out, req.Send()
}

// CreateSubscriberWithContext is the same as CreateSubscriber with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSubscriber for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Budgets) CreateSubscriberWithContext(ctx aws.Context, input *CreateSubscriberInput, opts ...request.Option) (*CreateSubscriberOutput, error) {
	req, out := c.CreateSubscriberRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBudget = "DeleteBudget"

// DeleteBudgetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBudget operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBudget for more information on using the DeleteBudget
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteBudgetRequest method.
//    req, resp := client.DeleteBudgetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Budgets) DeleteBudgetRequest(input *DeleteBudgetInput) (req *request.Request, output *DeleteBudgetOutput) {
	op := &request.Operation{
		Name:       opDeleteBudget,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteBudgetInput{}
	}

	output = &DeleteBudgetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteBudget API operation for AWS Budgets.
//
// Deletes a budget. You can delete your budget at any time.
//
// Deleting a budget also deletes the notifications and subscribers that are
// associated with that budget.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Budgets's
// API operation DeleteBudget for usage and error information.
//
// Returned Error Types:
//   * InternalErrorException
//   An error on the server occurred during the processing of your request. Try
//   again later.
//
//   * InvalidParameterException
//   An error on the client occurred. Typically, the cause is an invalid input
//   value.
//
//   * NotFoundException
//   We can’t locate the resource that you specified.
//
//   * AccessDeniedException
//   You are not authorized to use this operation with the given parameters.
//
func (c *Budgets) DeleteBudget(input *DeleteBudgetInput) (*DeleteBudgetOutput, error) {
	req, out := c.DeleteBudgetRequest(input)
	return out, req.Send()
}

// DeleteBudgetWithContext is the same as DeleteBudget with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBudget for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Budgets) DeleteBudgetWithContext(ctx aws.Context, input *DeleteBudgetInput, opts ...request.Option) (*DeleteBudgetOutput, error) {
	req, out := c.DeleteBudgetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteNotification = "DeleteNotification"

// DeleteNotificationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteNotification operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteNotification for more information on using the DeleteNotification
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteNotificationRequest method.
//    req, resp := client.DeleteNotificationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Budgets) DeleteNotificationRequest(input *DeleteNotificationInput) (req *request.Request, output *DeleteNotificationOutput) {
	op := &request.Operation{
		Name:       opDeleteNotification,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteNotificationInput{}
	}

	output = &DeleteNotificationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteNotification API operation for AWS Budgets.
//
// Deletes a notification.
//
// Deleting a notification also deletes the subscribers that are associated
// with the notification.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Budgets's
// API operation DeleteNotification for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   An error on the client occurred. Typically, the cause is an invalid input
//   value.
//
//   * InternalErrorException
//   An error on the server occurred during the processing of your request. Try
//   again later.
//
//   * NotFoundException
//   We can’t locate the resource that you specified.
//
//   * AccessDeniedException
//   You are not authorized to use this operation with the given parameters.
//
func (c *Budgets) DeleteNotification(input *DeleteNotificationInput) (*DeleteNotificationOutput, error) {
	req, out := c.DeleteNotificationRequest(input)
	return out, req.Send()
}

// DeleteNotificationWithContext is the same as DeleteNotification with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteNotification for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Budgets) DeleteNotificationWithContext(ctx aws.Context, input *DeleteNotificationInput, opts ...request.Option) (*DeleteNotificationOutput, error) {
	req, out := c.DeleteNotificationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSubscriber = "DeleteSubscriber"

// DeleteSubscriberRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSubscriber operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSubscriber for more information on using the DeleteSubscriber
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteSubscriberRequest method.
//    req, resp := client.DeleteSubscriberRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Budgets) DeleteSubscriberRequest(input *DeleteSubscriberInput) (req *request.Request, output *DeleteSubscriberOutput) {
	op := &request.Operation{
		Name:       opDeleteSubscriber,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSubscriberInput{}
	}

	output = &DeleteSubscriberOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSubscriber API operation for AWS Budgets.
//
// Deletes a subscriber.
//
// Deleting the last subscriber to a notification also deletes the notification.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Budgets's
// API operation DeleteSubscriber for usage and error information.
//
// Returned Error Types:
//   * InternalErrorException
//   An error on the server occurred during the processing of your request. Try
//   again later.
//
//   * InvalidParameterException
//   An error on the client occurred. Typically, the cause is an invalid input
//   value.
//
//   * NotFoundException
//   We can’t locate the resource that you specified.
//
//   * AccessDeniedException
//   You are not authorized to use this operation with the given parameters.
//
func (c *Budgets) DeleteSubscriber(input *DeleteSubscriberInput) (*DeleteSubscriberOutput, error) {
	req, out := c.DeleteSubscriberRequest(input)
	return out, req.Send()
}

// DeleteSubscriberWithContext is the same as DeleteSubscriber with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSubscriber for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Budgets) DeleteSubscriberWithContext(ctx aws.Context, input *DeleteSubscriberInput, opts ...request.Option) (*DeleteSubscriberOutput, error) {
	req, out := c.DeleteSubscriberRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeBudget = "DescribeBudget"

// DescribeBudgetRequest generates a "aws/request.Request" representing the
// client's request for the DescribeBudget operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeBudget for more information on using the DescribeBudget
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeBudgetRequest method.
//    req, resp := client.DescribeBudgetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Budgets) DescribeBudgetRequest(input *DescribeBudgetInput) (req *request.Request, output *DescribeBudgetOutput) {
	op := &request.Operation{
		Name:       opDescribeBudget,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeBudgetInput{}
	}

	output = &DescribeBudgetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeBudget API operation for AWS Budgets.
//
// Describes a budget.
//
// The Request Syntax section shows the BudgetLimit syntax. For PlannedBudgetLimits,
// see the Examples (https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_budgets_DescribeBudget.html#API_DescribeBudget_Examples)
// section.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Budgets's
// API operation DescribeBudget for usage and error information.
//
// Returned Error Types:
//   * InternalErrorException
//   An error on the server occurred during the processing of your request. Try
//   again later.
//
//   * InvalidParameterException
//   An error on the client occurred. Typically, the cause is an invalid input
//   value.
//
//   * NotFoundException
//   We can’t locate the resource that you specified.
//
//   * AccessDeniedException
//   You are not authorized to use this operation with the given parameters.
//
func (c *Budgets) DescribeBudget(input *DescribeBudgetInput) (*DescribeBudgetOutput, error) {
	req, out := c.DescribeBudgetRequest(input)
	return out, req.Send()
}

// DescribeBudgetWithContext is the same as DescribeBudget with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeBudget for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Budgets) DescribeBudgetWithContext(ctx aws.Context, input *DescribeBudgetInput, opts ...request.Option) (*DescribeBudgetOutput, error) {
	req, out := c.DescribeBudgetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeBudgetPerformanceHistory = "DescribeBudgetPerformanceHistory"

// DescribeBudgetPerformanceHistoryRequest generates a "aws/request.Request" representing the
// client's request for the DescribeBudgetPerformanceHistory operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeBudgetPerformanceHistory for more information on using the DescribeBudgetPerformanceHistory
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeBudgetPerformanceHistoryRequest method.
//    req, resp := client.DescribeBudgetPerformanceHistoryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Budgets) DescribeBudgetPerformanceHistoryRequest(input *DescribeBudgetPerformanceHistoryInput) (req *request.Request, output *DescribeBudgetPerformanceHistoryOutput) {
	op := &request.Operation{
		Name:       opDescribeBudgetPerformanceHistory,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeBudgetPerformanceHistoryInput{}
	}

	output = &DescribeBudgetPerformanceHistoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeBudgetPerformanceHistory API operation for AWS Budgets.
//
// Describes the history for DAILY, MONTHLY, and QUARTERLY budgets. Budget history
// isn't available for ANNUAL budgets.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Budgets's
// API operation DescribeBudgetPerformanceHistory for usage and error information.
//
// Returned Error Types:
//   * InternalErrorException
//   An error on the server occurred during the processing of your request. Try
//   again later.
//
//   * InvalidParameterException
//   An error on the client occurred. Typically, the cause is an invalid input
//   value.
//
//   * NotFoundException
//   We can’t locate the resource that you specified.
//
//   * InvalidNextTokenException
//   The pagination token is invalid.
//
//   * ExpiredNextTokenException
//   The pagination token expired.
//
//   * AccessDeniedException
//   You are not authorized to use this operation with the given parameters.
//
func (c *Budgets) DescribeBudgetPerformanceHistory(input *DescribeBudgetPerformanceHistoryInput) (*DescribeBudgetPerformanceHistoryOutput, error) {
	req, out := c.DescribeBudgetPerformanceHistoryRequest(input)
	return out, req.Send()
}

// DescribeBudgetPerformanceHistoryWithContext is the same as DescribeBudgetPerformanceHistory with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeBudgetPerformanceHistory for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Budgets) DescribeBudgetPerformanceHistoryWithContext(ctx aws.Context, input *DescribeBudgetPerformanceHistoryInput, opts ...request.Option) (*DescribeBudgetPerformanceHistoryOutput, error) {
	req, out := c.DescribeBudgetPerformanceHistoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeBudgetPerformanceHistoryPages iterates over the pages of a DescribeBudgetPerformanceHistory operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeBudgetPerformanceHistory method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeBudgetPerformanceHistory operation.
//    pageNum := 0
//    err := client.DescribeBudgetPerformanceHistoryPages(params,
//        func(page *budgets.DescribeBudgetPerformanceHistoryOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Budgets) DescribeBudgetPerformanceHistoryPages(input *DescribeBudgetPerformanceHistoryInput, fn func(*DescribeBudgetPerformanceHistoryOutput, bool) bool) error {
	return c.DescribeBudgetPerformanceHistoryPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeBudgetPerformanceHistoryPagesWithContext same as DescribeBudgetPerformanceHistoryPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Budgets) DescribeBudgetPerformanceHistoryPagesWithContext(ctx aws.Context, input *DescribeBudgetPerformanceHistoryInput, fn func(*DescribeBudgetPerformanceHistoryOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeBudgetPerformanceHistoryInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeBudgetPerformanceHistoryRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeBudgetPerformanceHistoryOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeBudgets = "DescribeBudgets"

// DescribeBudgetsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeBudgets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeBudgets for more information on using the DescribeBudgets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeBudgetsRequest method.
//    req, resp := client.DescribeBudgetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Budgets) DescribeBudgetsRequest(input *DescribeBudgetsInput) (req *request.Request, output *DescribeBudgetsOutput) {
	op := &request.Operation{
		Name:       opDescribeBudgets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeBudgetsInput{}
	}

	output = &DescribeBudgetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeBudgets API operation for AWS Budgets.
//
// Lists the budgets that are associated with an account.
//
// The Request Syntax section shows the BudgetLimit syntax. For PlannedBudgetLimits,
// see the Examples (https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_budgets_DescribeBudgets.html#API_DescribeBudgets_Examples)
// section.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Budgets's
// API operation DescribeBudgets for usage and error information.
//
// Returned Error Types:
//   * InternalErrorException
//   An error on the server occurred during the processing of your request. Try
//   again later.
//
//   * InvalidParameterException
//   An error on the client occurred. Typically, the cause is an invalid input
//   value.
//
//   * NotFoundException
//   We can’t locate the resource that you specified.
//
//   * InvalidNextTokenException
//   The pagination token is invalid.
//
//   * ExpiredNextTokenException
//   The pagination token expired.
//
//   * AccessDeniedException
//   You are not authorized to use this operation with the given parameters.
//
func (c *Budgets) DescribeBudgets(input *DescribeBudgetsInput) (*DescribeBudgetsOutput, error) {
	req, out := c.DescribeBudgetsRequest(input)
	return out, req.Send()
}

// DescribeBudgetsWithContext is the same as DescribeBudgets with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeBudgets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Budgets) DescribeBudgetsWithContext(ctx aws.Context, input *DescribeBudgetsInput, opts ...request.Option) (*DescribeBudgetsOutput, error) {
	req, out := c.DescribeBudgetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeBudgetsPages iterates over the pages of a DescribeBudgets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeBudgets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeBudgets operation.
//    pageNum := 0
//    err := client.DescribeBudgetsPages(params,
//        func(page *budgets.DescribeBudgetsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Budgets) DescribeBudgetsPages(input *DescribeBudgetsInput, fn func(*DescribeBudgetsOutput, bool) bool) error {
	return c.DescribeBudgetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeBudgetsPagesWithContext same as DescribeBudgetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Budgets) DescribeBudgetsPagesWithContext(ctx aws.Context, input *DescribeBudgetsInput, fn func(*DescribeBudgetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeBudgetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeBudgetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeBudgetsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeNotificationsForBudget = "DescribeNotificationsForBudget"

// DescribeNotificationsForBudgetRequest generates a "aws/request.Request" representing the
// client's request for the DescribeNotificationsForBudget operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeNotificationsForBudget for more information on using the DescribeNotificationsForBudget
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeNotificationsForBudgetRequest method.
//    req, resp := client.DescribeNotificationsForBudgetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Budgets) DescribeNotificationsForBudgetRequest(input *DescribeNotificationsForBudgetInput) (req *request.Request, output *DescribeNotificationsForBudgetOutput) {
	op := &request.Operation{
		Name:       opDescribeNotificationsForBudget,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeNotificationsForBudgetInput{}
	}

	output = &DescribeNotificationsForBudgetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeNotificationsForBudget API operation for AWS Budgets.
//
// Lists the notifications that are associated with a budget.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Budgets's
// API operation DescribeNotificationsForBudget for usage and error information.
//
// Returned Error Types:
//   * InternalErrorException
//   An error on the server occurred during the processing of your request. Try
//   again later.
//
//   * InvalidParameterException
//   An error on the client occurred. Typically, the cause is an invalid input
//   value.
//
//   * NotFoundException
//   We can’t locate the resource that you specified.
//
//   * InvalidNextTokenException
//   The pagination token is invalid.
//
//   * ExpiredNextTokenException
//   The pagination token expired.
//
//   * AccessDeniedException
//   You are not authorized to use this operation with the given parameters.
//
func (c *Budgets) DescribeNotificationsForBudget(input *DescribeNotificationsForBudgetInput) (*DescribeNotificationsForBudgetOutput, error) {
	req, out := c.DescribeNotificationsForBudgetRequest(input)
	return out, req.Send()
}

// DescribeNotificationsForBudgetWithContext is the same as DescribeNotificationsForBudget with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeNotificationsForBudget for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Budgets) DescribeNotificationsForBudgetWithContext(ctx aws.Context, input *DescribeNotificationsForBudgetInput, opts ...request.Option) (*DescribeNotificationsForBudgetOutput, error) {
	req, out := c.DescribeNotificationsForBudgetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeNotificationsForBudgetPages iterates over the pages of a DescribeNotificationsForBudget operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeNotificationsForBudget method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeNotificationsForBudget operation.
//    pageNum := 0
//    err := client.DescribeNotificationsForBudgetPages(params,
//        func(page *budgets.DescribeNotificationsForBudgetOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Budgets) DescribeNotificationsForBudgetPages(input *DescribeNotificationsForBudgetInput, fn func(*DescribeNotificationsForBudgetOutput, bool) bool) error {
	return c.DescribeNotificationsForBudgetPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeNotificationsForBudgetPagesWithContext same as DescribeNotificationsForBudgetPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Budgets) DescribeNotificationsForBudgetPagesWithContext(ctx aws.Context, input *DescribeNotificationsForBudgetInput, fn func(*DescribeNotificationsForBudgetOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeNotificationsForBudgetInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeNotificationsForBudgetRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeNotificationsForBudgetOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeSubscribersForNotification = "DescribeSubscribersForNotification"

// DescribeSubscribersForNotificationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSubscribersForNotification operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeSubscribersForNotification for more information on using the DescribeSubscribersForNotification
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeSubscribersForNotificationRequest method.
//    req, resp := client.DescribeSubscribersForNotificationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Budgets) DescribeSubscribersForNotificationRequest(input *DescribeSubscribersForNotificationInput) (req *request.Request, output *DescribeSubscribersForNotificationOutput) {
	op := &request.Operation{
		Name:       opDescribeSubscribersForNotification,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeSubscribersForNotificationInput{}
	}

	output = &DescribeSubscribersForNotificationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSubscribersForNotification API operation for AWS Budgets.
//
// Lists the subscribers that are associated with a notification.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Budgets's
// API operation DescribeSubscribersForNotification for usage and error information.
//
// Returned Error Types:
//   * InternalErrorException
//   An error on the server occurred during the processing of your request. Try
//   again later.
//
//   * NotFoundException
//   We can’t locate the resource that you specified.
//
//   * InvalidParameterException
//   An error on the client occurred. Typically, the cause is an invalid input
//   value.
//
//   * InvalidNextTokenException
//   The pagination token is invalid.
//
//   * ExpiredNextTokenException
//   The pagination token expired.
//
//   * AccessDeniedException
//   You are not authorized to use this operation with the given parameters.
//
func (c *Budgets) DescribeSubscribersForNotification(input *DescribeSubscribersForNotificationInput) (*DescribeSubscribersForNotificationOutput, error) {
	req, out := c.DescribeSubscribersForNotificationRequest(input)
	return out, req.Send()
}

// DescribeSubscribersForNotificationWithContext is the same as DescribeSubscribersForNotification with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSubscribersForNotification for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Budgets) DescribeSubscribersForNotificationWithContext(ctx aws.Context, input *DescribeSubscribersForNotificationInput, opts ...request.Option) (*DescribeSubscribersForNotificationOutput, error) {
	req, out := c.DescribeSubscribersForNotificationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeSubscribersForNotificationPages iterates over the pages of a DescribeSubscribersForNotification operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeSubscribersForNotification method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeSubscribersForNotification operation.
//    pageNum := 0
//    err := client.DescribeSubscribersForNotificationPages(params,
//        func(page *budgets.DescribeSubscribersForNotificationOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Budgets) DescribeSubscribersForNotificationPages(input *DescribeSubscribersForNotificationInput, fn func(*DescribeSubscribersForNotificationOutput, bool) bool) error {
	return c.DescribeSubscribersForNotificationPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeSubscribersForNotificationPagesWithContext same as DescribeSubscribersForNotificationPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Budgets) DescribeSubscribersForNotificationPagesWithContext(ctx aws.Context, input *DescribeSubscribersForNotificationInput, fn func(*DescribeSubscribersForNotificationOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeSubscribersForNotificationInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeSubscribersForNotificationRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeSubscribersForNotificationOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opUpdateBudget = "UpdateBudget"

// UpdateBudgetRequest generates a "aws/request.Request" representing the
// client's request for the UpdateBudget operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateBudget for more information on using the UpdateBudget
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateBudgetRequest method.
//    req, resp := client.UpdateBudgetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Budgets) UpdateBudgetRequest(input *UpdateBudgetInput) (req *request.Request, output *UpdateBudgetOutput) {
	op := &request.Operation{
		Name:       opUpdateBudget,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateBudgetInput{}
	}

	output = &UpdateBudgetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateBudget API operation for AWS Budgets.
//
// Updates a budget. You can change every part of a budget except for the budgetName
// and the calculatedSpend. When you modify a budget, the calculatedSpend drops
// to zero until AWS has new usage data to use for forecasting.
//
// Only one of BudgetLimit or PlannedBudgetLimits can be present in the syntax
// at one time. Use the syntax that matches your case. The Request Syntax section
// shows the BudgetLimit syntax. For PlannedBudgetLimits, see the Examples (https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_budgets_UpdateBudget.html#API_UpdateBudget_Examples)
// section.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Budgets's
// API operation UpdateBudget for usage and error information.
//
// Returned Error Types:
//   * InternalErrorException
//   An error on the server occurred during the processing of your request. Try
//   again later.
//
//   * InvalidParameterException
//   An error on the client occurred. Typically, the cause is an invalid input
//   value.
//
//   * NotFoundException
//   We can’t locate the resource that you specified.
//
//   * AccessDeniedException
//   You are not authorized to use this operation with the given parameters.
//
func (c *Budgets) UpdateBudget(input *UpdateBudgetInput) (*UpdateBudgetOutput, error) {
	req, out := c.UpdateBudgetRequest(input)
	return out, req.Send()
}

// UpdateBudgetWithContext is the same as UpdateBudget with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateBudget for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Budgets) UpdateBudgetWithContext(ctx aws.Context, input *UpdateBudgetInput, opts ...request.Option) (*UpdateBudgetOutput, error) {
	req, out := c.UpdateBudgetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateNotification = "UpdateNotification"

// UpdateNotificationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateNotification operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateNotification for more information on using the UpdateNotification
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateNotificationRequest method.
//    req, resp := client.UpdateNotificationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Budgets) UpdateNotificationRequest(input *UpdateNotificationInput) (req *request.Request, output *UpdateNotificationOutput) {
	op := &request.Operation{
		Name:       opUpdateNotification,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateNotificationInput{}
	}

	output = &UpdateNotificationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateNotification API operation for AWS Budgets.
//
// Updates a notification.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Budgets's
// API operation UpdateNotification for usage and error information.
//
// Returned Error Types:
//   * InternalErrorException
//   An error on the server occurred during the processing of your request. Try
//   again later.
//
//   * InvalidParameterException
//   An error on the client occurred. Typically, the cause is an invalid input
//   value.
//
//   * NotFoundException
//   We can’t locate the resource that you specified.
//
//   * DuplicateRecordException
//   The budget name already exists. Budget names must be unique within an account.
//
//   * AccessDeniedException
//   You are not authorized to use this operation with the given parameters.
//
func (c *Budgets) UpdateNotification(input *UpdateNotificationInput) (*UpdateNotificationOutput, error) {
	req, out := c.UpdateNotificationRequest(input)
	return out, req.Send()
}

// UpdateNotificationWithContext is the same as UpdateNotification with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateNotification for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Budgets) UpdateNotificationWithContext(ctx aws.Context, input *UpdateNotificationInput, opts ...request.Option) (*UpdateNotificationOutput, error) {
	req, out := c.UpdateNotificationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSubscriber = "UpdateSubscriber"

// UpdateSubscriberRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSubscriber operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSubscriber for more information on using the UpdateSubscriber
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateSubscriberRequest method.
//    req, resp := client.UpdateSubscriberRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Budgets) UpdateSubscriberRequest(input *UpdateSubscriberInput) (req *request.Request, output *UpdateSubscriberOutput) {
	op := &request.Operation{
		Name:       opUpdateSubscriber,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateSubscriberInput{}
	}

	output = &UpdateSubscriberOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateSubscriber API operation for AWS Budgets.
//
// Updates a subscriber.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Budgets's
// API operation UpdateSubscriber for usage and error information.
//
// Returned Error Types:
//   * InternalErrorException
//   An error on the server occurred during the processing of your request. Try
//   again later.
//
//   * InvalidParameterException
//   An error on the client occurred. Typically, the cause is an invalid input
//   value.
//
//   * NotFoundException
//   We can’t locate the resource that you specified.
//
//   * DuplicateRecordException
//   The budget name already exists. Budget names must be unique within an account.
//
//   * AccessDeniedException
//   You are not authorized to use this operation with the given parameters.
//
func (c *Budgets) UpdateSubscriber(input *UpdateSubscriberInput) (*UpdateSubscriberOutput, error) {
	req, out := c.UpdateSubscriberRequest(input)
	return out, req.Send()
}

// UpdateSubscriberWithContext is the same as UpdateSubscriber with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSubscriber for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Budgets) UpdateSubscriberWithContext(ctx aws.Context, input *UpdateSubscriberInput, opts ...request.Option) (*UpdateSubscriberOutput, error) {
	req, out := c.UpdateSubscriberRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You are not authorized to use this operation with the given parameters.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The error message the exception carries.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Represents the output of the CreateBudget operation. The content consists
// of the detailed metadata and data file information, and the current status
// of the budget object.
//
// This is the ARN pattern for a budget:
//
// arn:aws:budgets::AccountId:budget/budgetName
type Budget struct {
	_ struct{} `type:"structure"`

	// The total amount of cost, usage, RI utilization, RI coverage, Savings Plans
	// utilization, or Savings Plans coverage that you want to track with your budget.
	//
	// BudgetLimit is required for cost or usage budgets, but optional for RI or
	// Savings Plans utilization or coverage budgets. RI and Savings Plans utilization
	// or coverage budgets default to 100, which is the only valid value for RI
	// or Savings Plans utilization or coverage budgets. You can't use BudgetLimit
	// with PlannedBudgetLimits for CreateBudget and UpdateBudget actions.
	BudgetLimit *Spend `type:"structure"`

	// The name of a budget. The name must be unique within an account. The : and
	// \ characters aren't allowed in BudgetName.
	//
	// BudgetName is a required field
	BudgetName *string `min:"1" type:"string" required:"true"`

	// Whether this budget tracks costs, usage, RI utilization, RI coverage, Savings
	// Plans utilization, or Savings Plans coverage.
	//
	// BudgetType is a required field
	BudgetType *string `type:"string" required:"true" enum:"BudgetType"`

	// The actual and forecasted cost or usage that the budget tracks.
	CalculatedSpend *CalculatedSpend `type:"structure"`

	// The cost filters, such as service or tag, that are applied to a budget.
	//
	// AWS Budgets supports the following services as a filter for RI budgets:
	//
	//    * Amazon Elastic Compute Cloud - Compute
	//
	//    * Amazon Redshift
	//
	//    * Amazon Relational Database Service
	//
	//    * Amazon ElastiCache
	//
	//    * Amazon Elasticsearch Service
	CostFilters map[string][]*string `type:"map"`

	// The types of costs that are included in this COST budget.
	//
	// USAGE, RI_UTILIZATION, RI_COVERAGE, SAVINGS_PLANS_UTILIZATION, and SAVINGS_PLANS_COVERAGE
	// budgets do not have CostTypes.
	CostTypes *CostTypes `type:"structure"`

	// The last time that you updated this budget.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// A map containing multiple BudgetLimit, including current or future limits.
	//
	// PlannedBudgetLimits is available for cost or usage budget and supports monthly
	// and quarterly TimeUnit.
	//
	// For monthly budgets, provide 12 months of PlannedBudgetLimits values. This
	// must start from the current month and include the next 11 months. The key
	// is the start of the month, UTC in epoch seconds.
	//
	// For quarterly budgets, provide 4 quarters of PlannedBudgetLimits value entries
	// in standard calendar quarter increments. This must start from the current
	// quarter and include the next 3 quarters. The key is the start of the quarter,
	// UTC in epoch seconds.
	//
	// If the planned budget expires before 12 months for monthly or 4 quarters
	// for quarterly, provide the PlannedBudgetLimits values only for the remaining
	// periods.
	//
	// If the budget begins at a date in the future, provide PlannedBudgetLimits
	// values from the start date of the budget.
	//
	// After all of the BudgetLimit values in PlannedBudgetLimits are used, the
	// budget continues to use the last limit as the BudgetLimit. At that point,
	// the planned budget provides the same experience as a fixed budget.
	//
	// DescribeBudget and DescribeBudgets response along with PlannedBudgetLimits
	// will also contain BudgetLimit representing the current month or quarter limit
	// present in PlannedBudgetLimits. This only applies to budgets created with
	// PlannedBudgetLimits. Budgets created without PlannedBudgetLimits will only
	// contain BudgetLimit, and no PlannedBudgetLimits.
	PlannedBudgetLimits map[string]*Spend `type:"map"`

	// The period of time that is covered by a budget. The period has a start date
	// and an end date. The start date must come before the end date. The end date
	// must come before 06/15/87 00:00 UTC.
	//
	// If you create your budget and don't specify a start date, AWS defaults to
	// the start of your chosen time period (DAILY, MONTHLY, QUARTERLY, or ANNUALLY).
	// For example, if you created your budget on January 24, 2018, chose DAILY,
	// and didn't set a start date, AWS set your start date to 01/24/18 00:00 UTC.
	// If you chose MONTHLY, AWS set your start date to 01/01/18 00:00 UTC. If you
	// didn't specify an end date, AWS set your end date to 06/15/87 00:00 UTC.
	// The defaults are the same for the AWS Billing and Cost Management console
	// and the API.
	//
	// You can change either date with the UpdateBudget operation.
	//
	// After the end date, AWS deletes the budget and all associated notifications
	// and subscribers.
	TimePeriod *TimePeriod `type:"structure"`

	// The length of time until a budget resets the actual and forecasted spend.
	//
	// TimeUnit is a required field
	TimeUnit *string `type:"string" required:"true" enum:"TimeUnit"`
}

// String returns the string representation
func (s Budget) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Budget) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Budget) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Budget"}
	if s.BudgetName == nil {
		invalidParams.Add(request.NewErrParamRequired("BudgetName"))
	}
	if s.BudgetName != nil && len(*s.BudgetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BudgetName", 1))
	}
	if s.BudgetType == nil {
		invalidParams.Add(request.NewErrParamRequired("BudgetType"))
	}
	if s.TimeUnit == nil {
		invalidParams.Add(request.NewErrParamRequired("TimeUnit"))
	}
	if s.BudgetLimit != nil {
		if err := s.BudgetLimit.Validate(); err != nil {
			invalidParams.AddNested("BudgetLimit", err.(request.ErrInvalidParams))
		}
	}
	if s.CalculatedSpend != nil {
		if err := s.CalculatedSpend.Validate(); err != nil {
			invalidParams.AddNested("CalculatedSpend", err.(request.ErrInvalidParams))
		}
	}
	if s.PlannedBudgetLimits != nil {
		for i, v := range s.PlannedBudgetLimits {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PlannedBudgetLimits", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBudgetLimit sets the BudgetLimit field's value.
func (s *Budget) SetBudgetLimit(v *Spend) *Budget {
	s.BudgetLimit = v
	return s
}

// SetBudgetName sets the BudgetName field's value.
func (s *Budget) SetBudgetName(v string) *Budget {
	s.BudgetName = &v
	return s
}

// SetBudgetType sets the BudgetType field's value.
func (s *Budget) SetBudgetType(v string) *Budget {
	s.BudgetType = &v
	return s
}

// SetCalculatedSpend sets the CalculatedSpend field's value.
func (s *Budget) SetCalculatedSpend(v *CalculatedSpend) *Budget {
	s.CalculatedSpend = v
	return s
}

// SetCostFilters sets the CostFilters field's value.
func (s *Budget) SetCostFilters(v map[string][]*string) *Budget {
	s.CostFilters = v
	return s
}

// SetCostTypes sets the CostTypes field's value.
func (s *Budget) SetCostTypes(v *CostTypes) *Budget {
	s.CostTypes = v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *Budget) SetLastUpdatedTime(v time.Time) *Budget {
	s.LastUpdatedTime = &v
	return s
}

// SetPlannedBudgetLimits sets the PlannedBudgetLimits field's value.
func (s *Budget) SetPlannedBudgetLimits(v map[string]*Spend) *Budget {
	s.PlannedBudgetLimits = v
	return s
}

// SetTimePeriod sets the TimePeriod field's value.
func (s *Budget) SetTimePeriod(v *TimePeriod) *Budget {
	s.TimePeriod = v
	return s
}

// SetTimeUnit sets the TimeUnit field's value.
func (s *Budget) SetTimeUnit(v string) *Budget {
	s.TimeUnit = &v
	return s
}

// A history of the state of a budget at the end of the budget's specified time
// period.
type BudgetPerformanceHistory struct {
	_ struct{} `type:"structure"`

	// A string that represents the budget name. The ":" and "\" characters aren't
	// allowed.
	BudgetName *string `min:"1" type:"string"`

	// The type of a budget. It must be one of the following types:
	//
	// COST, USAGE, RI_UTILIZATION, RI_COVERAGE, SAVINGS_PLANS_UTILIZATION, or SAVINGS_PLANS_COVERAGE.
	BudgetType *string `type:"string" enum:"BudgetType"`

	// A list of amounts of cost or usage that you created budgets for, compared
	// to your actual costs or usage.
	BudgetedAndActualAmountsList []*BudgetedAndActualAmounts `type:"list"`

	// The history of the cost filters for a budget during the specified time period.
	CostFilters map[string][]*string `type:"map"`

	// The history of the cost types for a budget during the specified time period.
	CostTypes *CostTypes `type:"structure"`

	// The time unit of the budget, such as MONTHLY or QUARTERLY.
	TimeUnit *string `type:"string" enum:"TimeUnit"`
}

// String returns the string representation
func (s BudgetPerformanceHistory) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BudgetPerformanceHistory) GoString() string {
	return s.String()
}

// SetBudgetName sets the BudgetName field's value.
func (s *BudgetPerformanceHistory) SetBudgetName(v string) *BudgetPerformanceHistory {
	s.BudgetName = &v
	return s
}

// SetBudgetType sets the BudgetType field's value.
func (s *BudgetPerformanceHistory) SetBudgetType(v string) *BudgetPerformanceHistory {
	s.BudgetType = &v
	return s
}

// SetBudgetedAndActualAmountsList sets the BudgetedAndActualAmountsList field's value.
func (s *BudgetPerformanceHistory) SetBudgetedAndActualAmountsList(v []*BudgetedAndActualAmounts) *BudgetPerformanceHistory {
	s.BudgetedAndActualAmountsList = v
	return s
}

// SetCostFilters sets the CostFilters field's value.
func (s *BudgetPerformanceHistory) SetCostFilters(v map[string][]*string) *BudgetPerformanceHistory {
	s.CostFilters = v
	return s
}

// SetCostTypes sets the CostTypes field's value.
func (s *BudgetPerformanceHistory) SetCostTypes(v *CostTypes) *BudgetPerformanceHistory {
	s.CostTypes = v
	return s
}

// SetTimeUnit sets the TimeUnit field's value.
func (s *BudgetPerformanceHistory) SetTimeUnit(v string) *BudgetPerformanceHistory {
	s.TimeUnit = &v
	return s
}

// The amount of cost or usage that you created the budget for, compared to
// your actual costs or usage.
type BudgetedAndActualAmounts struct {
	_ struct{} `type:"structure"`

	// Your actual costs or usage for a budget period.
	ActualAmount *Spend `type:"structure"`

	// The amount of cost or usage that you created the budget for.
	BudgetedAmount *Spend `type:"structure"`

	// The time period covered by this budget comparison.
	TimePeriod *TimePeriod `type:"structure"`
}

// String returns the string representation
func (s BudgetedAndActualAmounts) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BudgetedAndActualAmounts) GoString() string {
	return s.String()
}

// SetActualAmount sets the ActualAmount field's value.
func (s *BudgetedAndActualAmounts) SetActualAmount(v *Spend) *BudgetedAndActualAmounts {
	s.ActualAmount = v
	return s
}

// SetBudgetedAmount sets the BudgetedAmount field's value.
func (s *BudgetedAndActualAmounts) SetBudgetedAmount(v *Spend) *BudgetedAndActualAmounts {
	s.BudgetedAmount = v
	return s
}

// SetTimePeriod sets the TimePeriod field's value.
func (s *BudgetedAndActualAmounts) SetTimePeriod(v *TimePeriod) *BudgetedAndActualAmounts {
	s.TimePeriod = v
	return s
}

// The spend objects that are associated with this budget. The actualSpend tracks
// how much you've used, cost, usage, RI units, or Savings Plans units and the
// forecastedSpend tracks how much you are predicted to spend based on your
// historical usage profile.
//
// For example, if it is the 20th of the month and you have spent 50 dollars
// on Amazon EC2, your actualSpend is 50 USD, and your forecastedSpend is 75
// USD.
type CalculatedSpend struct {
	_ struct{} `type:"structure"`

	// The amount of cost, usage, RI units, or Savings Plans units that you have
	// used.
	//
	// ActualSpend is a required field
	ActualSpend *Spend `type:"structure" required:"true"`

	// The amount of cost, usage, RI units, or Savings Plans units that you are
	// forecasted to use.
	ForecastedSpend *Spend `type:"structure"`
}

// String returns the string representation
func (s CalculatedSpend) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CalculatedSpend) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CalculatedSpend) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CalculatedSpend"}
	if s.ActualSpend == nil {
		invalidParams.Add(request.NewErrParamRequired("ActualSpend"))
	}
	if s.ActualSpend != nil {
		if err := s.ActualSpend.Validate(); err != nil {
			invalidParams.AddNested("ActualSpend", err.(request.ErrInvalidParams))
		}
	}
	if s.ForecastedSpend != nil {
		if err := s.ForecastedSpend.Validate(); err != nil {
			invalidParams.AddNested("ForecastedSpend", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActualSpend sets the ActualSpend field's value.
func (s *CalculatedSpend) SetActualSpend(v *Spend) *CalculatedSpend {
	s.ActualSpend = v
	return s
}

// SetForecastedSpend sets the ForecastedSpend field's value.
func (s *CalculatedSpend) SetForecastedSpend(v *Spend) *CalculatedSpend {
	s.ForecastedSpend = v
	return s
}

// The types of cost that are included in a COST budget, such as tax and subscriptions.
//
// USAGE, RI_UTILIZATION, RI_COVERAGE, SAVINGS_PLANS_UTILIZATION, and SAVINGS_PLANS_COVERAGE
// budgets do not have CostTypes.
type CostTypes struct {
	_ struct{} `type:"structure"`

	// Specifies whether a budget includes credits.
	//
	// The default value is true.
	IncludeCredit *bool `type:"boolean"`

	// Specifies whether a budget includes discounts.
	//
	// The default value is true.
	IncludeDiscount *bool `type:"boolean"`

	// Specifies whether a budget includes non-RI subscription costs.
	//
	// The default value is true.
	IncludeOtherSubscription *bool `type:"boolean"`

	// Specifies whether a budget includes recurring fees such as monthly RI fees.
	//
	// The default value is true.
	IncludeRecurring *bool `type:"boolean"`

	// Specifies whether a budget includes refunds.
	//
	// The default value is true.
	IncludeRefund *bool `type:"boolean"`

	// Specifies whether a budget includes subscriptions.
	//
	// The default value is true.
	IncludeSubscription *bool `type:"boolean"`

	// Specifies whether a budget includes support subscription fees.
	//
	// The default value is true.
	IncludeSupport *bool `type:"boolean"`

	// Specifies whether a budget includes taxes.
	//
	// The default value is true.
	IncludeTax *bool `type:"boolean"`

	// Specifies whether a budget includes upfront RI costs.
	//
	// The default value is true.
	IncludeUpfront *bool `type:"boolean"`

	// Specifies whether a budget uses the amortized rate.
	//
	// The default value is false.
	UseAmortized *bool `type:"boolean"`

	// Specifies whether a budget uses a blended rate.
	//
	// The default value is false.
	UseBlended *bool `type:"boolean"`
}

// String returns the string representation
func (s CostTypes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CostTypes) GoString() string {
	return s.String()
}

// SetIncludeCredit sets the IncludeCredit field's value.
func (s *CostTypes) SetIncludeCredit(v bool) *CostTypes {
	s.IncludeCredit = &v
	return s
}

// SetIncludeDiscount sets the IncludeDiscount field's value.
func (s *CostTypes) SetIncludeDiscount(v bool) *CostTypes {
	s.IncludeDiscount = &v
	return s
}

// SetIncludeOtherSubscription sets the IncludeOtherSubscription field's value.
func (s *CostTypes) SetIncludeOtherSubscription(v bool) *CostTypes {
	s.IncludeOtherSubscription = &v
	return s
}

// SetIncludeRecurring sets the IncludeRecurring field's value.
func (s *CostTypes) SetIncludeRecurring(v bool) *CostTypes {
	s.IncludeRecurring = &v
	return s
}

// SetIncludeRefund sets the IncludeRefund field's value.
func (s *CostTypes) SetIncludeRefund(v bool) *CostTypes {
	s.IncludeRefund = &v
	return s
}

// SetIncludeSubscription sets the IncludeSubscription field's value.
func (s *CostTypes) SetIncludeSubscription(v bool) *CostTypes {
	s.IncludeSubscription = &v
	return s
}

// SetIncludeSupport sets the IncludeSupport field's value.
func (s *CostTypes) SetIncludeSupport(v bool) *CostTypes {
	s.IncludeSupport = &v
	return s
}

// SetIncludeTax sets the IncludeTax field's value.
func (s *CostTypes) SetIncludeTax(v bool) *CostTypes {
	s.IncludeTax = &v
	return s
}

// SetIncludeUpfront sets the IncludeUpfront field's value.
func (s *CostTypes) SetIncludeUpfront(v bool) *CostTypes {
	s.IncludeUpfront = &v
	return s
}

// SetUseAmortized sets the UseAmortized field's value.
func (s *CostTypes) SetUseAmortized(v bool) *CostTypes {
	s.UseAmortized = &v
	return s
}

// SetUseBlended sets the UseBlended field's value.
func (s *CostTypes) SetUseBlended(v bool) *CostTypes {
	s.UseBlended = &v
	return s
}

// Request of CreateBudget
type CreateBudgetInput struct {
	_ struct{} `type:"structure"`

	// The accountId that is associated with the budget.
	//
	// AccountId is a required field
	AccountId *string `min:"12" type:"string" required:"true"`

	// The budget object that you want to create.
	//
	// Budget is a required field
	Budget *Budget `type:"structure" required:"true"`

	// A notification that you want to associate with a budget. A budget can have
	// up to five notifications, and each notification can have one SNS subscriber
	// and up to 10 email subscribers. If you include notifications and subscribers
	// in your CreateBudget call, AWS creates the notifications and subscribers
	// for you.
	NotificationsWithSubscribers []*NotificationWithSubscribers `type:"list"`
}

// String returns the string representation
func (s CreateBudgetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateBudgetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateBudgetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateBudgetInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 12))
	}
	if s.Budget == nil {
		invalidParams.Add(request.NewErrParamRequired("Budget"))
	}
	if s.Budget != nil {
		if err := s.Budget.Validate(); err != nil {
			invalidParams.AddNested("Budget", err.(request.ErrInvalidParams))
		}
	}
	if s.NotificationsWithSubscribers != nil {
		for i, v := range s.NotificationsWithSubscribers {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "NotificationsWithSubscribers", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *CreateBudgetInput) SetAccountId(v string) *CreateBudgetInput {
	s.AccountId = &v
	return s
}

// SetBudget sets the Budget field's value.
func (s *CreateBudgetInput) SetBudget(v *Budget) *CreateBudgetInput {
	s.Budget = v
	return s
}

// SetNotificationsWithSubscribers sets the NotificationsWithSubscribers field's value.
func (s *CreateBudgetInput) SetNotificationsWithSubscribers(v []*NotificationWithSubscribers) *CreateBudgetInput {
	s.NotificationsWithSubscribers = v
	return s
}

// Response of CreateBudget
type CreateBudgetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateBudgetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateBudgetOutput) GoString() string {
	return s.String()
}

// Request of CreateNotification
type CreateNotificationInput struct {
	_ struct{} `type:"structure"`

	// The accountId that is associated with the budget that you want to create
	// a notification for.
	//
	// AccountId is a required field
	AccountId *string `min:"12" type:"string" required:"true"`

	// The name of the budget that you want AWS to notify you about. Budget names
	// must be unique within an account.
	//
	// BudgetName is a required field
	BudgetName *string `min:"1" type:"string" required:"true"`

	// The notification that you want to create.
	//
	// Notification is a required field
	Notification *Notification `type:"structure" required:"true"`

	// A list of subscribers that you want to associate with the notification. Each
	// notification can have one SNS subscriber and up to 10 email subscribers.
	//
	// Subscribers is a required field
	Subscribers []*Subscriber `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s CreateNotificationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateNotificationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateNotificationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateNotificationInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 12))
	}
	if s.BudgetName == nil {
		invalidParams.Add(request.NewErrParamRequired("BudgetName"))
	}
	if s.BudgetName != nil && len(*s.BudgetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BudgetName", 1))
	}
	if s.Notification == nil {
		invalidParams.Add(request.NewErrParamRequired("Notification"))
	}
	if s.Subscribers == nil {
		invalidParams.Add(request.NewErrParamRequired("Subscribers"))
	}
	if s.Subscribers != nil && len(s.Subscribers) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Subscribers", 1))
	}
	if s.Notification != nil {
		if err := s.Notification.Validate(); err != nil {
			invalidParams.AddNested("Notification", err.(request.ErrInvalidParams))
		}
	}
	if s.Subscribers != nil {
		for i, v := range s.Subscribers {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Subscribers", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *CreateNotificationInput) SetAccountId(v string) *CreateNotificationInput {
	s.AccountId = &v
	return s
}

// SetBudgetName sets the BudgetName field's value.
func (s *CreateNotificationInput) SetBudgetName(v string) *CreateNotificationInput {
	s.BudgetName = &v
	return s
}

// SetNotification sets the Notification field's value.
func (s *CreateNotificationInput) SetNotification(v *Notification) *CreateNotificationInput {
	s.Notification = v
	return s
}

// SetSubscribers sets the Subscribers field's value.
func (s *CreateNotificationInput) SetSubscribers(v []*Subscriber) *CreateNotificationInput {
	s.Subscribers = v
	return s
}

// Response of CreateNotification
type CreateNotificationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateNotificationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateNotificationOutput) GoString() string {
	return s.String()
}

// Request of CreateSubscriber
type CreateSubscriberInput struct {
	_ struct{} `type:"structure"`

	// The accountId that is associated with the budget that you want to create
	// a subscriber for.
	//
	// AccountId is a required field
	AccountId *string `min:"12" type:"string" required:"true"`

	// The name of the budget that you want to subscribe to. Budget names must be
	// unique within an account.
	//
	// BudgetName is a required field
	BudgetName *string `min:"1" type:"string" required:"true"`

	// The notification that you want to create a subscriber for.
	//
	// Notification is a required field
	Notification *Notification `type:"structure" required:"true"`

	// The subscriber that you want to associate with a budget notification.
	//
	// Subscriber is a required field
	Subscriber *Subscriber `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateSubscriberInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSubscriberInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSubscriberInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSubscriberInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 12))
	}
	if s.BudgetName == nil {
		invalidParams.Add(request.NewErrParamRequired("BudgetName"))
	}
	if s.BudgetName != nil && len(*s.BudgetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BudgetName", 1))
	}
	if s.Notification == nil {
		invalidParams.Add(request.NewErrParamRequired("Notification"))
	}
	if s.Subscriber == nil {
		invalidParams.Add(request.NewErrParamRequired("Subscriber"))
	}
	if s.Notification != nil {
		if err := s.Notification.Validate(); err != nil {
			invalidParams.AddNested("Notification", err.(request.ErrInvalidParams))
		}
	}
	if s.Subscriber != nil {
		if err := s.Subscriber.Validate(); err != nil {
			invalidParams.AddNested("Subscriber", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *CreateSubscriberInput) SetAccountId(v string) *CreateSubscriberInput {
	s.AccountId = &v
	return s
}

// SetBudgetName sets the BudgetName field's value.
func (s *CreateSubscriberInput) SetBudgetName(v string) *CreateSubscriberInput {
	s.BudgetName = &v
	return s
}

// SetNotification sets the Notification field's value.
func (s *CreateSubscriberInput) SetNotification(v *Notification) *CreateSubscriberInput {
	s.Notification = v
	return s
}

// SetSubscriber sets the Subscriber field's value.
func (s *CreateSubscriberInput) SetSubscriber(v *Subscriber) *CreateSubscriberInput {
	s.Subscriber = v
	return s
}

// Response of CreateSubscriber
type CreateSubscriberOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateSubscriberOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSubscriberOutput) GoString() string {
	return s.String()
}

// You've exceeded the notification or subscriber limit.
type CreationLimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The error message the exception carries.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s CreationLimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreationLimitExceededException) GoString() string {
	return s.String()
}

func newErrorCreationLimitExceededException(v protocol.ResponseMetadata) error {
	return &CreationLimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *CreationLimitExceededException) Code() string {
	return "CreationLimitExceededException"
}

// Message returns the exception's message.
func (s *CreationLimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *CreationLimitExceededException) OrigErr() error {
	return nil
}

func (s *CreationLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *CreationLimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *CreationLimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Request of DeleteBudget
type DeleteBudgetInput struct {
	_ struct{} `type:"structure"`

	// The accountId that is associated with the budget that you want to delete.
	//
	// AccountId is a required field
	AccountId *string `min:"12" type:"string" required:"true"`

	// The name of the budget that you want to delete.
	//
	// BudgetName is a required field
	BudgetName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteBudgetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBudgetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBudgetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBudgetInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 12))
	}
	if s.BudgetName == nil {
		invalidParams.Add(request.NewErrParamRequired("BudgetName"))
	}
	if s.BudgetName != nil && len(*s.BudgetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BudgetName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *DeleteBudgetInput) SetAccountId(v string) *DeleteBudgetInput {
	s.AccountId = &v
	return s
}

// SetBudgetName sets the BudgetName field's value.
func (s *DeleteBudgetInput) SetBudgetName(v string) *DeleteBudgetInput {
	s.BudgetName = &v
	return s
}

// Response of DeleteBudget
type DeleteBudgetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteBudgetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBudgetOutput) GoString() string {
	return s.String()
}

// Request of DeleteNotification
type DeleteNotificationInput struct {
	_ struct{} `type:"structure"`

	// The accountId that is associated with the budget whose notification you want
	// to delete.
	//
	// AccountId is a required field
	AccountId *string `min:"12" type:"string" required:"true"`

	// The name of the budget whose notification you want to delete.
	//
	// BudgetName is a required field
	BudgetName *string `min:"1" type:"string" required:"true"`

	// The notification that you want to delete.
	//
	// Notification is a required field
	Notification *Notification `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteNotificationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteNotificationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteNotificationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteNotificationInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 12))
	}
	if s.BudgetName == nil {
		invalidParams.Add(request.NewErrParamRequired("BudgetName"))
	}
	if s.BudgetName != nil && len(*s.BudgetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BudgetName", 1))
	}
	if s.Notification == nil {
		invalidParams.Add(request.NewErrParamRequired("Notification"))
	}
	if s.Notification != nil {
		if err := s.Notification.Validate(); err != nil {
			invalidParams.AddNested("Notification", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *DeleteNotificationInput) SetAccountId(v string) *DeleteNotificationInput {
	s.AccountId = &v
	return s
}

// SetBudgetName sets the BudgetName field's value.
func (s *DeleteNotificationInput) SetBudgetName(v string) *DeleteNotificationInput {
	s.BudgetName = &v
	return s
}

// SetNotification sets the Notification field's value.
func (s *DeleteNotificationInput) SetNotification(v *Notification) *DeleteNotificationInput {
	s.Notification = v
	return s
}

// Response of DeleteNotification
type DeleteNotificationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteNotificationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteNotificationOutput) GoString() string {
	return s.String()
}

// Request of DeleteSubscriber
type DeleteSubscriberInput struct {
	_ struct{} `type:"structure"`

	// The accountId that is associated with the budget whose subscriber you want
	// to delete.
	//
	// AccountId is a required field
	AccountId *string `min:"12" type:"string" required:"true"`

	// The name of the budget whose subscriber you want to delete.
	//
	// BudgetName is a required field
	BudgetName *string `min:"1" type:"string" required:"true"`

	// The notification whose subscriber you want to delete.
	//
	// Notification is a required field
	Notification *Notification `type:"structure" required:"true"`

	// The subscriber that you want to delete.
	//
	// Subscriber is a required field
	Subscriber *Subscriber `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteSubscriberInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSubscriberInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSubscriberInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSubscriberInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 12))
	}
	if s.BudgetName == nil {
		invalidParams.Add(request.NewErrParamRequired("BudgetName"))
	}
	if s.BudgetName != nil && len(*s.BudgetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BudgetName", 1))
	}
	if s.Notification == nil {
		invalidParams.Add(request.NewErrParamRequired("Notification"))
	}
	if s.Subscriber == nil {
		invalidParams.Add(request.NewErrParamRequired("Subscriber"))
	}
	if s.Notification != nil {
		if err := s.Notification.Validate(); err != nil {
			invalidParams.AddNested("Notification", err.(request.ErrInvalidParams))
		}
	}
	if s.Subscriber != nil {
		if err := s.Subscriber.Validate(); err != nil {
			invalidParams.AddNested("Subscriber", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *DeleteSubscriberInput) SetAccountId(v string) *DeleteSubscriberInput {
	s.AccountId = &v
	return s
}

// SetBudgetName sets the BudgetName field's value.
func (s *DeleteSubscriberInput) SetBudgetName(v string) *DeleteSubscriberInput {
	s.BudgetName = &v
	return s
}

// SetNotification sets the Notification field's value.
func (s *DeleteSubscriberInput) SetNotification(v *Notification) *DeleteSubscriberInput {
	s.Notification = v
	return s
}

// SetSubscriber sets the Subscriber field's value.
func (s *DeleteSubscriberInput) SetSubscriber(v *Subscriber) *DeleteSubscriberInput {
	s.Subscriber = v
	return s
}

// Response of DeleteSubscriber
type DeleteSubscriberOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteSubscriberOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSubscriberOutput) GoString() string {
	return s.String()
}

// Request of DescribeBudget
type DescribeBudgetInput struct {
	_ struct{} `type:"structure"`

	// The accountId that is associated with the budget that you want a description
	// of.
	//
	// AccountId is a required field
	AccountId *string `min:"12" type:"string" required:"true"`

	// The name of the budget that you want a description of.
	//
	// BudgetName is a required field
	BudgetName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeBudgetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeBudgetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeBudgetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeBudgetInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 12))
	}
	if s.BudgetName == nil {
		invalidParams.Add(request.NewErrParamRequired("BudgetName"))
	}
	if s.BudgetName != nil && len(*s.BudgetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BudgetName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *DescribeBudgetInput) SetAccountId(v string) *DescribeBudgetInput {
	s.AccountId = &v
	return s
}

// SetBudgetName sets the BudgetName field's value.
func (s *DescribeBudgetInput) SetBudgetName(v string) *DescribeBudgetInput {
	s.BudgetName = &v
	return s
}

// Response of DescribeBudget
type DescribeBudgetOutput struct {
	_ struct{} `type:"structure"`

	// The description of the budget.
	Budget *Budget `type:"structure"`
}

// String returns the string representation
func (s DescribeBudgetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeBudgetOutput) GoString() string {
	return s.String()
}

// SetBudget sets the Budget field's value.
func (s *DescribeBudgetOutput) SetBudget(v *Budget) *DescribeBudgetOutput {
	s.Budget = v
	return s
}

type DescribeBudgetPerformanceHistoryInput struct {
	_ struct{} `type:"structure"`

	// The account ID of the user. It should be a 12-digit number.
	//
	// AccountId is a required field
	AccountId *string `min:"12" type:"string" required:"true"`

	// A string that represents the budget name. The ":" and "\" characters aren't
	// allowed.
	//
	// BudgetName is a required field
	BudgetName *string `min:"1" type:"string" required:"true"`

	// An integer that represents how many entries a paginated response contains.
	// The maximum is 100.
	MaxResults *int64 `min:"1" type:"integer"`

	// A generic string.
	NextToken *string `type:"string"`

	// Retrieves how often the budget went into an ALARM state for the specified
	// time period.
	TimePeriod *TimePeriod `type:"structure"`
}

// String returns the string representation
func (s DescribeBudgetPerformanceHistoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeBudgetPerformanceHistoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeBudgetPerformanceHistoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeBudgetPerformanceHistoryInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 12))
	}
	if s.BudgetName == nil {
		invalidParams.Add(request.NewErrParamRequired("BudgetName"))
	}
	if s.BudgetName != nil && len(*s.BudgetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BudgetName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *DescribeBudgetPerformanceHistoryInput) SetAccountId(v string) *DescribeBudgetPerformanceHistoryInput {
	s.AccountId = &v
	return s
}

// SetBudgetName sets the BudgetName field's value.
func (s *DescribeBudgetPerformanceHistoryInput) SetBudgetName(v string) *DescribeBudgetPerformanceHistoryInput {
	s.BudgetName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeBudgetPerformanceHistoryInput) SetMaxResults(v int64) *DescribeBudgetPerformanceHistoryInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeBudgetPerformanceHistoryInput) SetNextToken(v string) *DescribeBudgetPerformanceHistoryInput {
	s.NextToken = &v
	return s
}

// SetTimePeriod sets the TimePeriod field's value.
func (s *DescribeBudgetPerformanceHistoryInput) SetTimePeriod(v *TimePeriod) *DescribeBudgetPerformanceHistoryInput {
	s.TimePeriod = v
	return s
}

type DescribeBudgetPerformanceHistoryOutput struct {
	_ struct{} `type:"structure"`

	// The history of how often the budget has gone into an ALARM state.
	//
	// For DAILY budgets, the history saves the state of the budget for the last
	// 60 days. For MONTHLY budgets, the history saves the state of the budget for
	// the current month plus the last 12 months. For QUARTERLY budgets, the history
	// saves the state of the budget for the last four quarters.
	BudgetPerformanceHistory *BudgetPerformanceHistory `type:"structure"`

	// A generic string.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeBudgetPerformanceHistoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeBudgetPerformanceHistoryOutput) GoString() string {
	return s.String()
}

// SetBudgetPerformanceHistory sets the BudgetPerformanceHistory field's value.
func (s *DescribeBudgetPerformanceHistoryOutput) SetBudgetPerformanceHistory(v *BudgetPerformanceHistory) *DescribeBudgetPerformanceHistoryOutput {
	s.BudgetPerformanceHistory = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeBudgetPerformanceHistoryOutput) SetNextToken(v string) *DescribeBudgetPerformanceHistoryOutput {
	s.NextToken = &v
	return s
}

// Request of DescribeBudgets
type DescribeBudgetsInput struct {
	_ struct{} `type:"structure"`

	// The accountId that is associated with the budgets that you want descriptions
	// of.
	//
	// AccountId is a required field
	AccountId *string `min:"12" type:"string" required:"true"`

	// An optional integer that represents how many entries a paginated response
	// contains. The maximum is 100.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token that you include in your request to indicate the next
	// set of results that you want to retrieve.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeBudgetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeBudgetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeBudgetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeBudgetsInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 12))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *DescribeBudgetsInput) SetAccountId(v string) *DescribeBudgetsInput {
	s.AccountId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeBudgetsInput) SetMaxResults(v int64) *DescribeBudgetsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeBudgetsInput) SetNextToken(v string) *DescribeBudgetsInput {
	s.NextToken = &v
	return s
}

// Response of DescribeBudgets
type DescribeBudgetsOutput struct {
	_ struct{} `type:"structure"`

	// A list of budgets.
	Budgets []*Budget `type:"list"`

	// The pagination token in the service response that indicates the next set
	// of results that you can retrieve.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeBudgetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeBudgetsOutput) GoString() string {
	return s.String()
}

// SetBudgets sets the Budgets field's value.
func (s *DescribeBudgetsOutput) SetBudgets(v []*Budget) *DescribeBudgetsOutput {
	s.Budgets = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeBudgetsOutput) SetNextToken(v string) *DescribeBudgetsOutput {
	s.NextToken = &v
	return s
}

// Request of DescribeNotificationsForBudget
type DescribeNotificationsForBudgetInput struct {
	_ struct{} `type:"structure"`

	// The accountId that is associated with the budget whose notifications you
	// want descriptions of.
	//
	// AccountId is a required field
	AccountId *string `min:"12" type:"string" required:"true"`

	// The name of the budget whose notifications you want descriptions of.
	//
	// BudgetName is a required field
	BudgetName *string `min:"1" type:"string" required:"true"`

	// An optional integer that represents how many entries a paginated response
	// contains. The maximum is 100.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token that you include in your request to indicate the next
	// set of results that you want to retrieve.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeNotificationsForBudgetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeNotificationsForBudgetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeNotificationsForBudgetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeNotificationsForBudgetInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 12))
	}
	if s.BudgetName == nil {
		invalidParams.Add(request.NewErrParamRequired("BudgetName"))
	}
	if s.BudgetName != nil && len(*s.BudgetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BudgetName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *DescribeNotificationsForBudgetInput) SetAccountId(v string) *DescribeNotificationsForBudgetInput {
	s.AccountId = &v
	return s
}

// SetBudgetName sets the BudgetName field's value.
func (s *DescribeNotificationsForBudgetInput) SetBudgetName(v string) *DescribeNotificationsForBudgetInput {
	s.BudgetName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeNotificationsForBudgetInput) SetMaxResults(v int64) *DescribeNotificationsForBudgetInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeNotificationsForBudgetInput) SetNextToken(v string) *DescribeNotificationsForBudgetInput {
	s.NextToken = &v
	return s
}

// Response of GetNotificationsForBudget
type DescribeNotificationsForBudgetOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token in the service response that indicates the next set
	// of results that you can retrieve.
	NextToken *string `type:"string"`

	// A list of notifications that are associated with a budget.
	Notifications []*Notification `type:"list"`
}

// String returns the string representation
func (s DescribeNotificationsForBudgetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeNotificationsForBudgetOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeNotificationsForBudgetOutput) SetNextToken(v string) *DescribeNotificationsForBudgetOutput {
	s.NextToken = &v
	return s
}

// SetNotifications sets the Notifications field's value.
func (s *DescribeNotificationsForBudgetOutput) SetNotifications(v []*Notification) *DescribeNotificationsForBudgetOutput {
	s.Notifications = v
	return s
}

// Request of DescribeSubscribersForNotification
type DescribeSubscribersForNotificationInput struct {
	_ struct{} `type:"structure"`

	// The accountId that is associated with the budget whose subscribers you want
	// descriptions of.
	//
	// AccountId is a required field
	AccountId *string `min:"12" type:"string" required:"true"`

	// The name of the budget whose subscribers you want descriptions of.
	//
	// BudgetName is a required field
	BudgetName *string `min:"1" type:"string" required:"true"`

	// An optional integer that represents how many entries a paginated response
	// contains. The maximum is 100.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token that you include in your request to indicate the next
	// set of results that you want to retrieve.
	NextToken *string `type:"string"`

	// The notification whose subscribers you want to list.
	//
	// Notification is a required field
	Notification *Notification `type:"structure" required:"true"`
}

// String returns the string representation
func (s DescribeSubscribersForNotificationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSubscribersForNotificationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeSubscribersForNotificationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeSubscribersForNotificationInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 12))
	}
	if s.BudgetName == nil {
		invalidParams.Add(request.NewErrParamRequired("BudgetName"))
	}
	if s.BudgetName != nil && len(*s.BudgetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BudgetName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Notification == nil {
		invalidParams.Add(request.NewErrParamRequired("Notification"))
	}
	if s.Notification != nil {
		if err := s.Notification.Validate(); err != nil {
			invalidParams.AddNested("Notification", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *DescribeSubscribersForNotificationInput) SetAccountId(v string) *DescribeSubscribersForNotificationInput {
	s.AccountId = &v
	return s
}

// SetBudgetName sets the BudgetName field's value.
func (s *DescribeSubscribersForNotificationInput) SetBudgetName(v string) *DescribeSubscribersForNotificationInput {
	s.BudgetName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeSubscribersForNotificationInput) SetMaxResults(v int64) *DescribeSubscribersForNotificationInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeSubscribersForNotificationInput) SetNextToken(v string) *DescribeSubscribersForNotificationInput {
	s.NextToken = &v
	return s
}

// SetNotification sets the Notification field's value.
func (s *DescribeSubscribersForNotificationInput) SetNotification(v *Notification) *DescribeSubscribersForNotificationInput {
	s.Notification = v
	return s
}

// Response of DescribeSubscribersForNotification
type DescribeSubscribersForNotificationOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token in the service response that indicates the next set
	// of results that you can retrieve.
	NextToken *string `type:"string"`

	// A list of subscribers that are associated with a notification.
	Subscribers []*Subscriber `min:"1" type:"list"`
}

// String returns the string representation
func (s DescribeSubscribersForNotificationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSubscribersForNotificationOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeSubscribersForNotificationOutput) SetNextToken(v string) *DescribeSubscribersForNotificationOutput {
	s.NextToken = &v
	return s
}

// SetSubscribers sets the Subscribers field's value.
func (s *DescribeSubscribersForNotificationOutput) SetSubscribers(v []*Subscriber) *DescribeSubscribersForNotificationOutput {
	s.Subscribers = v
	return s
}

// The budget name already exists. Budget names must be unique within an account.
type DuplicateRecordException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The error message the exception carries.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s DuplicateRecordException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DuplicateRecordException) GoString() string {
	return s.String()
}

func newErrorDuplicateRecordException(v protocol.ResponseMetadata) error {
	return &DuplicateRecordException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *DuplicateRecordException) Code() string {
	return "DuplicateRecordException"
}

// Message returns the exception's message.
func (s *DuplicateRecordException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *DuplicateRecordException) OrigErr() error {
	return nil
}

func (s *DuplicateRecordException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *DuplicateRecordException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *DuplicateRecordException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The pagination token expired.
type ExpiredNextTokenException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The error message the exception carries.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ExpiredNextTokenException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExpiredNextTokenException) GoString() string {
	return s.String()
}

func newErrorExpiredNextTokenException(v protocol.ResponseMetadata) error {
	return &ExpiredNextTokenException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ExpiredNextTokenException) Code() string {
	return "ExpiredNextTokenException"
}

// Message returns the exception's message.
func (s *ExpiredNextTokenException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ExpiredNextTokenException) OrigErr() error {
	return nil
}

func (s *ExpiredNextTokenException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ExpiredNextTokenException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ExpiredNextTokenException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An error on the server occurred during the processing of your request. Try
// again later.
type InternalErrorException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The error message the exception carries.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InternalErrorException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InternalErrorException) GoString() string {
	return s.String()
}

func newErrorInternalErrorException(v protocol.ResponseMetadata) error {
	return &InternalErrorException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalErrorException) Code() string {
	return "InternalErrorException"
}

// Message returns the exception's message.
func (s *InternalErrorException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalErrorException) OrigErr() error {
	return nil
}

func (s *InternalErrorException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalErrorException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalErrorException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The pagination token is invalid.
type InvalidNextTokenException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The error message the exception carries.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InvalidNextTokenException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidNextTokenException) GoString() string {
	return s.String()
}

func newErrorInvalidNextTokenException(v protocol.ResponseMetadata) error {
	return &InvalidNextTokenException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidNextTokenException) Code() string {
	return "InvalidNextTokenException"
}

// Message returns the exception's message.
func (s *InvalidNextTokenException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidNextTokenException) OrigErr() error {
	return nil
}

func (s *InvalidNextTokenException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidNextTokenException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidNextTokenException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An error on the client occurred. Typically, the cause is an invalid input
// value.
type InvalidParameterException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The error message the exception carries.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InvalidParameterException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidParameterException) GoString() string {
	return s.String()
}

func newErrorInvalidParameterException(v protocol.ResponseMetadata) error {
	return &InvalidParameterException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidParameterException) Code() string {
	return "InvalidParameterException"
}

// Message returns the exception's message.
func (s *InvalidParameterException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidParameterException) OrigErr() error {
	return nil
}

func (s *InvalidParameterException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidParameterException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidParameterException) RequestID() string {
	return s.RespMetadata.RequestID
}

// We can’t locate the resource that you specified.
type NotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The error message the exception carries.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s NotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NotFoundException) GoString() string {
	return s.String()
}

func newErrorNotFoundException(v protocol.ResponseMetadata) error {
	return &NotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NotFoundException) Code() string {
	return "NotFoundException"
}

// Message returns the exception's message.
func (s *NotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NotFoundException) OrigErr() error {
	return nil
}

func (s *NotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A notification that is associated with a budget. A budget can have up to
// ten notifications.
//
// Each notification must have at least one subscriber. A notification can have
// one SNS subscriber and up to 10 email subscribers, for a total of 11 subscribers.
//
// For example, if you have a budget for 200 dollars and you want to be notified
// when you go over 160 dollars, create a notification with the following parameters:
//
//    * A notificationType of ACTUAL
//
//    * A thresholdType of PERCENTAGE
//
//    * A comparisonOperator of GREATER_THAN
//
//    * A notification threshold of 80
type Notification struct {
	_ struct{} `type:"structure"`

	// The comparison that is used for this notification.
	//
	// ComparisonOperator is a required field
	ComparisonOperator *string `type:"string" required:"true" enum:"ComparisonOperator"`

	// Whether this notification is in alarm. If a budget notification is in the
	// ALARM state, you have passed the set threshold for the budget.
	NotificationState *string `type:"string" enum:"NotificationState"`

	// Whether the notification is for how much you have spent (ACTUAL) or for how
	// much you're forecasted to spend (FORECASTED).
	//
	// NotificationType is a required field
	NotificationType *string `type:"string" required:"true" enum:"NotificationType"`

	// The threshold that is associated with a notification. Thresholds are always
	// a percentage, and many customers find value being alerted between 50% - 200%
	// of the budgeted amount. The maximum limit for your threshold is 1,000,000%
	// above the budgeted amount.
	//
	// Threshold is a required field
	Threshold *float64 `type:"double" required:"true"`

	// The type of threshold for a notification. For ABSOLUTE_VALUE thresholds,
	// AWS notifies you when you go over or are forecasted to go over your total
	// cost threshold. For PERCENTAGE thresholds, AWS notifies you when you go over
	// or are forecasted to go over a certain percentage of your forecasted spend.
	// For example, if you have a budget for 200 dollars and you have a PERCENTAGE
	// threshold of 80%, AWS notifies you when you go over 160 dollars.
	ThresholdType *string `type:"string" enum:"ThresholdType"`
}

// String returns the string representation
func (s Notification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Notification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Notification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Notification"}
	if s.ComparisonOperator == nil {
		invalidParams.Add(request.NewErrParamRequired("ComparisonOperator"))
	}
	if s.NotificationType == nil {
		invalidParams.Add(request.NewErrParamRequired("NotificationType"))
	}
	if s.Threshold == nil {
		invalidParams.Add(request.NewErrParamRequired("Threshold"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComparisonOperator sets the ComparisonOperator field's value.
func (s *Notification) SetComparisonOperator(v string) *Notification {
	s.ComparisonOperator = &v
	return s
}

// SetNotificationState sets the NotificationState field's value.
func (s *Notification) SetNotificationState(v string) *Notification {
	s.NotificationState = &v
	return s
}

// SetNotificationType sets the NotificationType field's value.
func (s *Notification) SetNotificationType(v string) *Notification {
	s.NotificationType = &v
	return s
}

// SetThreshold sets the Threshold field's value.
func (s *Notification) SetThreshold(v float64) *Notification {
	s.Threshold = &v
	return s
}

// SetThresholdType sets the ThresholdType field's value.
func (s *Notification) SetThresholdType(v string) *Notification {
	s.ThresholdType = &v
	return s
}

// A notification with subscribers. A notification can have one SNS subscriber
// and up to 10 email subscribers, for a total of 11 subscribers.
type NotificationWithSubscribers struct {
	_ struct{} `type:"structure"`

	// The notification that is associated with a budget.
	//
	// Notification is a required field
	Notification *Notification `type:"structure" required:"true"`

	// A list of subscribers who are subscribed to this notification.
	//
	// Subscribers is a required field
	Subscribers []*Subscriber `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s NotificationWithSubscribers) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NotificationWithSubscribers) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NotificationWithSubscribers) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NotificationWithSubscribers"}
	if s.Notification == nil {
		invalidParams.Add(request.NewErrParamRequired("Notification"))
	}
	if s.Subscribers == nil {
		invalidParams.Add(request.NewErrParamRequired("Subscribers"))
	}
	if s.Subscribers != nil && len(s.Subscribers) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Subscribers", 1))
	}
	if s.Notification != nil {
		if err := s.Notification.Validate(); err != nil {
			invalidParams.AddNested("Notification", err.(request.ErrInvalidParams))
		}
	}
	if s.Subscribers != nil {
		for i, v := range s.Subscribers {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Subscribers", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNotification sets the Notification field's value.
func (s *NotificationWithSubscribers) SetNotification(v *Notification) *NotificationWithSubscribers {
	s.Notification = v
	return s
}

// SetSubscribers sets the Subscribers field's value.
func (s *NotificationWithSubscribers) SetSubscribers(v []*Subscriber) *NotificationWithSubscribers {
	s.Subscribers = v
	return s
}

// The amount of cost or usage that is measured for a budget.
//
// For example, a Spend for 3 GB of S3 usage would have the following parameters:
//
//    * An Amount of 3
//
//    * A unit of GB
type Spend struct {
	_ struct{} `type:"structure"`

	// The cost or usage amount that is associated with a budget forecast, actual
	// spend, or budget threshold.
	//
	// Amount is a required field
	Amount *string `min:"1" type:"string" required:"true"`

	// The unit of measurement that is used for the budget forecast, actual spend,
	// or budget threshold, such as dollars or GB.
	//
	// Unit is a required field
	Unit *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s Spend) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Spend) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Spend) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Spend"}
	if s.Amount == nil {
		invalidParams.Add(request.NewErrParamRequired("Amount"))
	}
	if s.Amount != nil && len(*s.Amount) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Amount", 1))
	}
	if s.Unit == nil {
		invalidParams.Add(request.NewErrParamRequired("Unit"))
	}
	if s.Unit != nil && len(*s.Unit) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Unit", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAmount sets the Amount field's value.
func (s *Spend) SetAmount(v string) *Spend {
	s.Amount = &v
	return s
}

// SetUnit sets the Unit field's value.
func (s *Spend) SetUnit(v string) *Spend {
	s.Unit = &v
	return s
}

// The subscriber to a budget notification. The subscriber consists of a subscription
// type and either an Amazon SNS topic or an email address.
//
// For example, an email subscriber would have the following parameters:
//
//    * A subscriptionType of EMAIL
//
//    * An address of example@example.com
type Subscriber struct {
	_ struct{} `type:"structure"`

	// The address that AWS sends budget notifications to, either an SNS topic or
	// an email.
	//
	// When you create a subscriber, the value of Address can't contain line breaks.
	//
	// Address is a required field
	Address *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// The type of notification that AWS sends to a subscriber.
	//
	// SubscriptionType is a required field
	SubscriptionType *string `type:"string" required:"true" enum:"SubscriptionType"`
}

// String returns the string representation
func (s Subscriber) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Subscriber) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Subscriber) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Subscriber"}
	if s.Address == nil {
		invalidParams.Add(request.NewErrParamRequired("Address"))
	}
	if s.Address != nil && len(*s.Address) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Address", 1))
	}
	if s.SubscriptionType == nil {
		invalidParams.Add(request.NewErrParamRequired("SubscriptionType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddress sets the Address field's value.
func (s *Subscriber) SetAddress(v string) *Subscriber {
	s.Address = &v
	return s
}

// SetSubscriptionType sets the SubscriptionType field's value.
func (s *Subscriber) SetSubscriptionType(v string) *Subscriber {
	s.SubscriptionType = &v
	return s
}

// The period of time that is covered by a budget. The period has a start date
// and an end date. The start date must come before the end date. There are
// no restrictions on the end date.
type TimePeriod struct {
	_ struct{} `type:"structure"`

	// The end date for a budget. If you didn't specify an end date, AWS set your
	// end date to 06/15/87 00:00 UTC. The defaults are the same for the AWS Billing
	// and Cost Management console and the API.
	//
	// After the end date, AWS deletes the budget and all associated notifications
	// and subscribers. You can change your end date with the UpdateBudget operation.
	End *time.Time `type:"timestamp"`

	// The start date for a budget. If you created your budget and didn't specify
	// a start date, AWS defaults to the start of your chosen time period (DAILY,
	// MONTHLY, QUARTERLY, or ANNUALLY). For example, if you created your budget
	// on January 24, 2018, chose DAILY, and didn't set a start date, AWS set your
	// start date to 01/24/18 00:00 UTC. If you chose MONTHLY, AWS set your start
	// date to 01/01/18 00:00 UTC. The defaults are the same for the AWS Billing
	// and Cost Management console and the API.
	//
	// You can change your start date with the UpdateBudget operation.
	Start *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s TimePeriod) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TimePeriod) GoString() string {
	return s.String()
}

// SetEnd sets the End field's value.
func (s *TimePeriod) SetEnd(v time.Time) *TimePeriod {
	s.End = &v
	return s
}

// SetStart sets the Start field's value.
func (s *TimePeriod) SetStart(v time.Time) *TimePeriod {
	s.Start = &v
	return s
}

// Request of UpdateBudget
type UpdateBudgetInput struct {
	_ struct{} `type:"structure"`

	// The accountId that is associated with the budget that you want to update.
	//
	// AccountId is a required field
	AccountId *string `min:"12" type:"string" required:"true"`

	// The budget that you want to update your budget to.
	//
	// NewBudget is a required field
	NewBudget *Budget `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateBudgetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateBudgetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateBudgetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateBudgetInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 12))
	}
	if s.NewBudget == nil {
		invalidParams.Add(request.NewErrParamRequired("NewBudget"))
	}
	if s.NewBudget != nil {
		if err := s.NewBudget.Validate(); err != nil {
			invalidParams.AddNested("NewBudget", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *UpdateBudgetInput) SetAccountId(v string) *UpdateBudgetInput {
	s.AccountId = &v
	return s
}

// SetNewBudget sets the NewBudget field's value.
func (s *UpdateBudgetInput) SetNewBudget(v *Budget) *UpdateBudgetInput {
	s.NewBudget = v
	return s
}

// Response of UpdateBudget
type UpdateBudgetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateBudgetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateBudgetOutput) GoString() string {
	return s.String()
}

// Request of UpdateNotification
type UpdateNotificationInput struct {
	_ struct{} `type:"structure"`

	// The accountId that is associated with the budget whose notification you want
	// to update.
	//
	// AccountId is a required field
	AccountId *string `min:"12" type:"string" required:"true"`

	// The name of the budget whose notification you want to update.
	//
	// BudgetName is a required field
	BudgetName *string `min:"1" type:"string" required:"true"`

	// The updated notification to be associated with a budget.
	//
	// NewNotification is a required field
	NewNotification *Notification `type:"structure" required:"true"`

	// The previous notification that is associated with a budget.
	//
	// OldNotification is a required field
	OldNotification *Notification `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateNotificationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateNotificationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateNotificationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateNotificationInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 12))
	}
	if s.BudgetName == nil {
		invalidParams.Add(request.NewErrParamRequired("BudgetName"))
	}
	if s.BudgetName != nil && len(*s.BudgetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BudgetName", 1))
	}
	if s.NewNotification == nil {
		invalidParams.Add(request.NewErrParamRequired("NewNotification"))
	}
	if s.OldNotification == nil {
		invalidParams.Add(request.NewErrParamRequired("OldNotification"))
	}
	if s.NewNotification != nil {
		if err := s.NewNotification.Validate(); err != nil {
			invalidParams.AddNested("NewNotification", err.(request.ErrInvalidParams))
		}
	}
	if s.OldNotification != nil {
		if err := s.OldNotification.Validate(); err != nil {
			invalidParams.AddNested("OldNotification", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *UpdateNotificationInput) SetAccountId(v string) *UpdateNotificationInput {
	s.AccountId = &v
	return s
}

// SetBudgetName sets the BudgetName field's value.
func (s *UpdateNotificationInput) SetBudgetName(v string) *UpdateNotificationInput {
	s.BudgetName = &v
	return s
}

// SetNewNotification sets the NewNotification field's value.
func (s *UpdateNotificationInput) SetNewNotification(v *Notification) *UpdateNotificationInput {
	s.NewNotification = v
	return s
}

// SetOldNotification sets the OldNotification field's value.
func (s *UpdateNotificationInput) SetOldNotification(v *Notification) *UpdateNotificationInput {
	s.OldNotification = v
	return s
}

// Response of UpdateNotification
type UpdateNotificationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateNotificationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateNotificationOutput) GoString() string {
	return s.String()
}

// Request of UpdateSubscriber
type UpdateSubscriberInput struct {
	_ struct{} `type:"structure"`

	// The accountId that is associated with the budget whose subscriber you want
	// to update.
	//
	// AccountId is a required field
	AccountId *string `min:"12" type:"string" required:"true"`

	// The name of the budget whose subscriber you want to update.
	//
	// BudgetName is a required field
	BudgetName *string `min:"1" type:"string" required:"true"`

	// The updated subscriber that is associated with a budget notification.
	//
	// NewSubscriber is a required field
	NewSubscriber *Subscriber `type:"structure" required:"true"`

	// The notification whose subscriber you want to update.
	//
	// Notification is a required field
	Notification *Notification `type:"structure" required:"true"`

	// The previous subscriber that is associated with a budget notification.
	//
	// OldSubscriber is a required field
	OldSubscriber *Subscriber `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateSubscriberInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateSubscriberInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateSubscriberInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateSubscriberInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 12))
	}
	if s.BudgetName == nil {
		invalidParams.Add(request.NewErrParamRequired("BudgetName"))
	}
	if s.BudgetName != nil && len(*s.BudgetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BudgetName", 1))
	}
	if s.NewSubscriber == nil {
		invalidParams.Add(request.NewErrParamRequired("NewSubscriber"))
	}
	if s.Notification == nil {
		invalidParams.Add(request.NewErrParamRequired("Notification"))
	}
	if s.OldSubscriber == nil {
		invalidParams.Add(request.NewErrParamRequired("OldSubscriber"))
	}
	if s.NewSubscriber != nil {
		if err := s.NewSubscriber.Validate(); err != nil {
			invalidParams.AddNested("NewSubscriber", err.(request.ErrInvalidParams))
		}
	}
	if s.Notification != nil {
		if err := s.Notification.Validate(); err != nil {
			invalidParams.AddNested("Notification", err.(request.ErrInvalidParams))
		}
	}
	if s.OldSubscriber != nil {
		if err := s.OldSubscriber.Validate(); err != nil {
			invalidParams.AddNested("OldSubscriber", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *UpdateSubscriberInput) SetAccountId(v string) *UpdateSubscriberInput {
	s.AccountId = &v
	return s
}

// SetBudgetName sets the BudgetName field's value.
func (s *UpdateSubscriberInput) SetBudgetName(v string) *UpdateSubscriberInput {
	s.BudgetName = &v
	return s
}

// SetNewSubscriber sets the NewSubscriber field's value.
func (s *UpdateSubscriberInput) SetNewSubscriber(v *Subscriber) *UpdateSubscriberInput {
	s.NewSubscriber = v
	return s
}

// SetNotification sets the Notification field's value.
func (s *UpdateSubscriberInput) SetNotification(v *Notification) *UpdateSubscriberInput {
	s.Notification = v
	return s
}

// SetOldSubscriber sets the OldSubscriber field's value.
func (s *UpdateSubscriberInput) SetOldSubscriber(v *Subscriber) *UpdateSubscriberInput {
	s.OldSubscriber = v
	return s
}

// Response of UpdateSubscriber
type UpdateSubscriberOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateSubscriberOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateSubscriberOutput) GoString() string {
	return s.String()
}

// The type of a budget. It must be one of the following types:
//
// COST, USAGE, RI_UTILIZATION, RI_COVERAGE, SAVINGS_PLANS_UTILIZATION, or SAVINGS_PLANS_COVERAGE.
const (
	// BudgetTypeUsage is a BudgetType enum value
	BudgetTypeUsage = "USAGE"

	// BudgetTypeCost is a BudgetType enum value
	BudgetTypeCost = "COST"

	// BudgetTypeRiUtilization is a BudgetType enum value
	BudgetTypeRiUtilization = "RI_UTILIZATION"

	// BudgetTypeRiCoverage is a BudgetType enum value
	BudgetTypeRiCoverage = "RI_COVERAGE"

	// BudgetTypeSavingsPlansUtilization is a BudgetType enum value
	BudgetTypeSavingsPlansUtilization = "SAVINGS_PLANS_UTILIZATION"

	// BudgetTypeSavingsPlansCoverage is a BudgetType enum value
	BudgetTypeSavingsPlansCoverage = "SAVINGS_PLANS_COVERAGE"
)

// BudgetType_Values returns all elements of the BudgetType enum
func BudgetType_Values() []string {
	return []string{
		BudgetTypeUsage,
		BudgetTypeCost,
		BudgetTypeRiUtilization,
		BudgetTypeRiCoverage,
		BudgetTypeSavingsPlansUtilization,
		BudgetTypeSavingsPlansCoverage,
	}
}

// The comparison operator of a notification. Currently the service supports
// the following operators:
//
// GREATER_THAN, LESS_THAN, EQUAL_TO
const (
	// ComparisonOperatorGreaterThan is a ComparisonOperator enum value
	ComparisonOperatorGreaterThan = "GREATER_THAN"

	// ComparisonOperatorLessThan is a ComparisonOperator enum value
	ComparisonOperatorLessThan = "LESS_THAN"

	// ComparisonOperatorEqualTo is a ComparisonOperator enum value
	ComparisonOperatorEqualTo = "EQUAL_TO"
)

// ComparisonOperator_Values returns all elements of the ComparisonOperator enum
func ComparisonOperator_Values() []string {
	return []string{
		ComparisonOperatorGreaterThan,
		ComparisonOperatorLessThan,
		ComparisonOperatorEqualTo,
	}
}

const (
	// NotificationStateOk is a NotificationState enum value
	NotificationStateOk = "OK"

	// NotificationStateAlarm is a NotificationState enum value
	NotificationStateAlarm = "ALARM"
)

// NotificationState_Values returns all elements of the NotificationState enum
func NotificationState_Values() []string {
	return []string{
		NotificationStateOk,
		NotificationStateAlarm,
	}
}

// The type of a notification. It must be ACTUAL or FORECASTED.
const (
	// NotificationTypeActual is a NotificationType enum value
	NotificationTypeActual = "ACTUAL"

	// NotificationTypeForecasted is a NotificationType enum value
	NotificationTypeForecasted = "FORECASTED"
)

// NotificationType_Values returns all elements of the NotificationType enum
func NotificationType_Values() []string {
	return []string{
		NotificationTypeActual,
		NotificationTypeForecasted,
	}
}

// The subscription type of the subscriber. It can be SMS or EMAIL.
const (
	// SubscriptionTypeSns is a SubscriptionType enum value
	SubscriptionTypeSns = "SNS"

	// SubscriptionTypeEmail is a SubscriptionType enum value
	SubscriptionTypeEmail = "EMAIL"
)

// SubscriptionType_Values returns all elements of the SubscriptionType enum
func SubscriptionType_Values() []string {
	return []string{
		SubscriptionTypeSns,
		SubscriptionTypeEmail,
	}
}

// The type of threshold for a notification. It can be PERCENTAGE or ABSOLUTE_VALUE.
const (
	// ThresholdTypePercentage is a ThresholdType enum value
	ThresholdTypePercentage = "PERCENTAGE"

	// ThresholdTypeAbsoluteValue is a ThresholdType enum value
	ThresholdTypeAbsoluteValue = "ABSOLUTE_VALUE"
)

// ThresholdType_Values returns all elements of the ThresholdType enum
func ThresholdType_Values() []string {
	return []string{
		ThresholdTypePercentage,
		ThresholdTypeAbsoluteValue,
	}
}

// The time unit of the budget, such as MONTHLY or QUARTERLY.
const (
	// TimeUnitDaily is a TimeUnit enum value
	TimeUnitDaily = "DAILY"

	// TimeUnitMonthly is a TimeUnit enum value
	TimeUnitMonthly = "MONTHLY"

	// TimeUnitQuarterly is a TimeUnit enum value
	TimeUnitQuarterly = "QUARTERLY"

	// TimeUnitAnnually is a TimeUnit enum value
	TimeUnitAnnually = "ANNUALLY"
)

// TimeUnit_Values returns all elements of the TimeUnit enum
func TimeUnit_Values() []string {
	return []string{
		TimeUnitDaily,
		TimeUnitMonthly,
		TimeUnitQuarterly,
		TimeUnitAnnually,
	}
}
