// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"context"
	"time"

	v1 "github.com/openshift/api/cloudnetwork/v1"
	scheme "github.com/openshift/client-go/cloudnetwork/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// CloudPrivateIPConfigsGetter has a method to return a CloudPrivateIPConfigInterface.
// A group's client should implement this interface.
type CloudPrivateIPConfigsGetter interface {
	CloudPrivateIPConfigs() CloudPrivateIPConfigInterface
}

// CloudPrivateIPConfigInterface has methods to work with CloudPrivateIPConfig resources.
type CloudPrivateIPConfigInterface interface {
	Create(ctx context.Context, cloudPrivateIPConfig *v1.CloudPrivateIPConfig, opts metav1.CreateOptions) (*v1.CloudPrivateIPConfig, error)
	Update(ctx context.Context, cloudPrivateIPConfig *v1.CloudPrivateIPConfig, opts metav1.UpdateOptions) (*v1.CloudPrivateIPConfig, error)
	UpdateStatus(ctx context.Context, cloudPrivateIPConfig *v1.CloudPrivateIPConfig, opts metav1.UpdateOptions) (*v1.CloudPrivateIPConfig, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*v1.CloudPrivateIPConfig, error)
	List(ctx context.Context, opts metav1.ListOptions) (*v1.CloudPrivateIPConfigList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.CloudPrivateIPConfig, err error)
	CloudPrivateIPConfigExpansion
}

// cloudPrivateIPConfigs implements CloudPrivateIPConfigInterface
type cloudPrivateIPConfigs struct {
	client rest.Interface
}

// newCloudPrivateIPConfigs returns a CloudPrivateIPConfigs
func newCloudPrivateIPConfigs(c *CloudV1Client) *cloudPrivateIPConfigs {
	return &cloudPrivateIPConfigs{
		client: c.RESTClient(),
	}
}

// Get takes name of the cloudPrivateIPConfig, and returns the corresponding cloudPrivateIPConfig object, and an error if there is any.
func (c *cloudPrivateIPConfigs) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.CloudPrivateIPConfig, err error) {
	result = &v1.CloudPrivateIPConfig{}
	err = c.client.Get().
		Resource("cloudprivateipconfigs").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of CloudPrivateIPConfigs that match those selectors.
func (c *cloudPrivateIPConfigs) List(ctx context.Context, opts metav1.ListOptions) (result *v1.CloudPrivateIPConfigList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.CloudPrivateIPConfigList{}
	err = c.client.Get().
		Resource("cloudprivateipconfigs").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested cloudPrivateIPConfigs.
func (c *cloudPrivateIPConfigs) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("cloudprivateipconfigs").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a cloudPrivateIPConfig and creates it.  Returns the server's representation of the cloudPrivateIPConfig, and an error, if there is any.
func (c *cloudPrivateIPConfigs) Create(ctx context.Context, cloudPrivateIPConfig *v1.CloudPrivateIPConfig, opts metav1.CreateOptions) (result *v1.CloudPrivateIPConfig, err error) {
	result = &v1.CloudPrivateIPConfig{}
	err = c.client.Post().
		Resource("cloudprivateipconfigs").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(cloudPrivateIPConfig).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a cloudPrivateIPConfig and updates it. Returns the server's representation of the cloudPrivateIPConfig, and an error, if there is any.
func (c *cloudPrivateIPConfigs) Update(ctx context.Context, cloudPrivateIPConfig *v1.CloudPrivateIPConfig, opts metav1.UpdateOptions) (result *v1.CloudPrivateIPConfig, err error) {
	result = &v1.CloudPrivateIPConfig{}
	err = c.client.Put().
		Resource("cloudprivateipconfigs").
		Name(cloudPrivateIPConfig.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(cloudPrivateIPConfig).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *cloudPrivateIPConfigs) UpdateStatus(ctx context.Context, cloudPrivateIPConfig *v1.CloudPrivateIPConfig, opts metav1.UpdateOptions) (result *v1.CloudPrivateIPConfig, err error) {
	result = &v1.CloudPrivateIPConfig{}
	err = c.client.Put().
		Resource("cloudprivateipconfigs").
		Name(cloudPrivateIPConfig.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(cloudPrivateIPConfig).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the cloudPrivateIPConfig and deletes it. Returns an error if one occurs.
func (c *cloudPrivateIPConfigs) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return c.client.Delete().
		Resource("cloudprivateipconfigs").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *cloudPrivateIPConfigs) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("cloudprivateipconfigs").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched cloudPrivateIPConfig.
func (c *cloudPrivateIPConfigs) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.CloudPrivateIPConfig, err error) {
	result = &v1.CloudPrivateIPConfig{}
	err = c.client.Patch(pt).
		Resource("cloudprivateipconfigs").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
