package cbn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyCenRouteMap invokes the cbn.ModifyCenRouteMap API synchronously
func (client *Client) ModifyCenRouteMap(request *ModifyCenRouteMapRequest) (response *ModifyCenRouteMapResponse, err error) {
	response = CreateModifyCenRouteMapResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyCenRouteMapWithChan invokes the cbn.ModifyCenRouteMap API asynchronously
func (client *Client) ModifyCenRouteMapWithChan(request *ModifyCenRouteMapRequest) (<-chan *ModifyCenRouteMapResponse, <-chan error) {
	responseChan := make(chan *ModifyCenRouteMapResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyCenRouteMap(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyCenRouteMapWithCallback invokes the cbn.ModifyCenRouteMap API asynchronously
func (client *Client) ModifyCenRouteMapWithCallback(request *ModifyCenRouteMapRequest, callback func(response *ModifyCenRouteMapResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyCenRouteMapResponse
		var err error
		defer close(result)
		response, err = client.ModifyCenRouteMap(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyCenRouteMapRequest is the request struct for api ModifyCenRouteMap
type ModifyCenRouteMapRequest struct {
	*requests.RpcRequest
	ResourceOwnerId                    requests.Integer `position:"Query" name:"ResourceOwnerId"`
	CommunityMatchMode                 string           `position:"Query" name:"CommunityMatchMode"`
	MapResult                          string           `position:"Query" name:"MapResult"`
	DestinationRegionIds               *[]string        `position:"Query" name:"DestinationRegionIds"  type:"Repeated"`
	NextPriority                       requests.Integer `position:"Query" name:"NextPriority"`
	DestinationCidrBlocks              *[]string        `position:"Query" name:"DestinationCidrBlocks"  type:"Repeated"`
	OriginalRouteTableIds              *[]string        `position:"Query" name:"OriginalRouteTableIds"  type:"Repeated"`
	SourceInstanceIds                  *[]string        `position:"Query" name:"SourceInstanceIds"  type:"Repeated"`
	SourceRegionIds                    *[]string        `position:"Query" name:"SourceRegionIds"  type:"Repeated"`
	GatewayZoneId                      string           `position:"Query" name:"GatewayZoneId"`
	MatchAsns                          *[]string        `position:"Query" name:"MatchAsns"  type:"Repeated"`
	Preference                         requests.Integer `position:"Query" name:"Preference"`
	OwnerId                            requests.Integer `position:"Query" name:"OwnerId"`
	Priority                           requests.Integer `position:"Query" name:"Priority"`
	DestinationChildInstanceTypes      *[]string        `position:"Query" name:"DestinationChildInstanceTypes"  type:"Repeated"`
	SourceRouteTableIds                *[]string        `position:"Query" name:"SourceRouteTableIds"  type:"Repeated"`
	SourceChildInstanceTypes           *[]string        `position:"Query" name:"SourceChildInstanceTypes"  type:"Repeated"`
	CommunityOperateMode               string           `position:"Query" name:"CommunityOperateMode"`
	OperateCommunitySet                *[]string        `position:"Query" name:"OperateCommunitySet"  type:"Repeated"`
	RouteTypes                         *[]string        `position:"Query" name:"RouteTypes"  type:"Repeated"`
	MatchAddressType                   string           `position:"Query" name:"MatchAddressType"`
	CidrMatchMode                      string           `position:"Query" name:"CidrMatchMode"`
	CenId                              string           `position:"Query" name:"CenId"`
	Description                        string           `position:"Query" name:"Description"`
	SourceInstanceIdsReverseMatch      requests.Boolean `position:"Query" name:"SourceInstanceIdsReverseMatch"`
	DestinationRouteTableIds           *[]string        `position:"Query" name:"DestinationRouteTableIds"  type:"Repeated"`
	SourceZoneIds                      *[]string        `position:"Query" name:"SourceZoneIds"  type:"Repeated"`
	DestinationInstanceIds             *[]string        `position:"Query" name:"DestinationInstanceIds"  type:"Repeated"`
	ResourceOwnerAccount               string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount                       string           `position:"Query" name:"OwnerAccount"`
	DestinationInstanceIdsReverseMatch requests.Boolean `position:"Query" name:"DestinationInstanceIdsReverseMatch"`
	RouteMapId                         string           `position:"Query" name:"RouteMapId"`
	PrependAsPath                      *[]string        `position:"Query" name:"PrependAsPath"  type:"Repeated"`
	AsPathMatchMode                    string           `position:"Query" name:"AsPathMatchMode"`
	MatchCommunitySet                  *[]string        `position:"Query" name:"MatchCommunitySet"  type:"Repeated"`
	CenRegionId                        string           `position:"Query" name:"CenRegionId"`
}

// ModifyCenRouteMapResponse is the response struct for api ModifyCenRouteMap
type ModifyCenRouteMapResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyCenRouteMapRequest creates a request to invoke ModifyCenRouteMap API
func CreateModifyCenRouteMapRequest() (request *ModifyCenRouteMapRequest) {
	request = &ModifyCenRouteMapRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cbn", "2017-09-12", "ModifyCenRouteMap", "cbn", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyCenRouteMapResponse creates a response to parse from ModifyCenRouteMap response
func CreateModifyCenRouteMapResponse() (response *ModifyCenRouteMapResponse) {
	response = &ModifyCenRouteMapResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
