package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeElasticBandwidthSpec invokes the ddoscoo.DescribeElasticBandwidthSpec API synchronously
func (client *Client) DescribeElasticBandwidthSpec(request *DescribeElasticBandwidthSpecRequest) (response *DescribeElasticBandwidthSpecResponse, err error) {
	response = CreateDescribeElasticBandwidthSpecResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeElasticBandwidthSpecWithChan invokes the ddoscoo.DescribeElasticBandwidthSpec API asynchronously
func (client *Client) DescribeElasticBandwidthSpecWithChan(request *DescribeElasticBandwidthSpecRequest) (<-chan *DescribeElasticBandwidthSpecResponse, <-chan error) {
	responseChan := make(chan *DescribeElasticBandwidthSpecResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeElasticBandwidthSpec(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeElasticBandwidthSpecWithCallback invokes the ddoscoo.DescribeElasticBandwidthSpec API asynchronously
func (client *Client) DescribeElasticBandwidthSpecWithCallback(request *DescribeElasticBandwidthSpecRequest, callback func(response *DescribeElasticBandwidthSpecResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeElasticBandwidthSpecResponse
		var err error
		defer close(result)
		response, err = client.DescribeElasticBandwidthSpec(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeElasticBandwidthSpecRequest is the request struct for api DescribeElasticBandwidthSpec
type DescribeElasticBandwidthSpecRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
	SourceIp   string `position:"Query" name:"SourceIp"`
}

// DescribeElasticBandwidthSpecResponse is the response struct for api DescribeElasticBandwidthSpec
type DescribeElasticBandwidthSpecResponse struct {
	*responses.BaseResponse
	RequestId            string   `json:"RequestId" xml:"RequestId"`
	ElasticBandwidthSpec []string `json:"ElasticBandwidthSpec" xml:"ElasticBandwidthSpec"`
}

// CreateDescribeElasticBandwidthSpecRequest creates a request to invoke DescribeElasticBandwidthSpec API
func CreateDescribeElasticBandwidthSpecRequest() (request *DescribeElasticBandwidthSpecRequest) {
	request = &DescribeElasticBandwidthSpecRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "DescribeElasticBandwidthSpec", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeElasticBandwidthSpecResponse creates a response to parse from DescribeElasticBandwidthSpec response
func CreateDescribeElasticBandwidthSpecResponse() (response *DescribeElasticBandwidthSpecResponse) {
	response = &DescribeElasticBandwidthSpecResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
