package aliyuncvc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListConferenceDevices invokes the aliyuncvc.ListConferenceDevices API synchronously
func (client *Client) ListConferenceDevices(request *ListConferenceDevicesRequest) (response *ListConferenceDevicesResponse, err error) {
	response = CreateListConferenceDevicesResponse()
	err = client.DoAction(request, response)
	return
}

// ListConferenceDevicesWithChan invokes the aliyuncvc.ListConferenceDevices API asynchronously
func (client *Client) ListConferenceDevicesWithChan(request *ListConferenceDevicesRequest) (<-chan *ListConferenceDevicesResponse, <-chan error) {
	responseChan := make(chan *ListConferenceDevicesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListConferenceDevices(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListConferenceDevicesWithCallback invokes the aliyuncvc.ListConferenceDevices API asynchronously
func (client *Client) ListConferenceDevicesWithCallback(request *ListConferenceDevicesRequest, callback func(response *ListConferenceDevicesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListConferenceDevicesResponse
		var err error
		defer close(result)
		response, err = client.ListConferenceDevices(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListConferenceDevicesRequest is the request struct for api ListConferenceDevices
type ListConferenceDevicesRequest struct {
	*requests.RpcRequest
	SerialNumber string           `position:"Query" name:"SerialNumber"`
	PageNumber   requests.Integer `position:"Query" name:"PageNumber"`
	PageSize     requests.Integer `position:"Query" name:"PageSize"`
}

// ListConferenceDevicesResponse is the response struct for api ListConferenceDevices
type ListConferenceDevicesResponse struct {
	*responses.BaseResponse
	ErrorCode        int              `json:"ErrorCode" xml:"ErrorCode"`
	Message          string           `json:"Message" xml:"Message"`
	Success          bool             `json:"Success" xml:"Success"`
	RequestId        string           `json:"RequestId" xml:"RequestId"`
	ConferencesDatas ConferencesDatas `json:"ConferencesDatas" xml:"ConferencesDatas"`
}

// CreateListConferenceDevicesRequest creates a request to invoke ListConferenceDevices API
func CreateListConferenceDevicesRequest() (request *ListConferenceDevicesRequest) {
	request = &ListConferenceDevicesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aliyuncvc", "2019-10-30", "ListConferenceDevices", "aliyuncvc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListConferenceDevicesResponse creates a response to parse from ListConferenceDevices response
func CreateListConferenceDevicesResponse() (response *ListConferenceDevicesResponse) {
	response = &ListConferenceDevicesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
