package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAntChainConsortiums invokes the baas.DescribeAntChainConsortiums API synchronously
// api document: https://help.aliyun.com/api/baas/describeantchainconsortiums.html
func (client *Client) DescribeAntChainConsortiums(request *DescribeAntChainConsortiumsRequest) (response *DescribeAntChainConsortiumsResponse, err error) {
	response = CreateDescribeAntChainConsortiumsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAntChainConsortiumsWithChan invokes the baas.DescribeAntChainConsortiums API asynchronously
// api document: https://help.aliyun.com/api/baas/describeantchainconsortiums.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeAntChainConsortiumsWithChan(request *DescribeAntChainConsortiumsRequest) (<-chan *DescribeAntChainConsortiumsResponse, <-chan error) {
	responseChan := make(chan *DescribeAntChainConsortiumsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAntChainConsortiums(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAntChainConsortiumsWithCallback invokes the baas.DescribeAntChainConsortiums API asynchronously
// api document: https://help.aliyun.com/api/baas/describeantchainconsortiums.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeAntChainConsortiumsWithCallback(request *DescribeAntChainConsortiumsRequest, callback func(response *DescribeAntChainConsortiumsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAntChainConsortiumsResponse
		var err error
		defer close(result)
		response, err = client.DescribeAntChainConsortiums(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAntChainConsortiumsRequest is the request struct for api DescribeAntChainConsortiums
type DescribeAntChainConsortiumsRequest struct {
	*requests.RpcRequest
	PageNumber requests.Integer `position:"Body" name:"PageNumber"`
	PageSize   requests.Integer `position:"Body" name:"PageSize"`
}

// DescribeAntChainConsortiumsResponse is the response struct for api DescribeAntChainConsortiums
type DescribeAntChainConsortiumsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateDescribeAntChainConsortiumsRequest creates a request to invoke DescribeAntChainConsortiums API
func CreateDescribeAntChainConsortiumsRequest() (request *DescribeAntChainConsortiumsRequest) {
	request = &DescribeAntChainConsortiumsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-12-21", "DescribeAntChainConsortiums", "baas", "openAPI")
	return
}

// CreateDescribeAntChainConsortiumsResponse creates a response to parse from DescribeAntChainConsortiums response
func CreateDescribeAntChainConsortiumsResponse() (response *DescribeAntChainConsortiumsResponse) {
	response = &DescribeAntChainConsortiumsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
